;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: map						*
;*	file name	: ys_map					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_color.h
		include		../union/ys_mapobj.h
		include		ys_presno.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MAPINIT,MAPPLAY
		GLB	MPROGOCLR,MPHLDRCLR
		GLB	M_KUMO,M_SMOK,M_KAMO,M_PLAY
;
		GLB	sagi20
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VRAMCL2,OAMCLR,BLNKOFF,URAMCLR,DMA_M_M,DMA_D_M
		EXT	VMADSPL,RANDAM
		EXT	SOUND_TR_MAP,SOUND_3_ON
		EXT	DMIN,HMPIN,MPIN
		EXT	MTCL,HLCL,D_01
;
		EXT	INT_GM
;
;-------------< ys_save >------------------------------------------------
		EXT	SVRMCK_INT,SVDTLD,SVDTSV,DATA_COPY
		EXT	AICONBF_dat0,AICONBF_dat1,AICONBF_dat2
		EXT	AICONBF_dat3,AICONBF_dat4,AICONBF_dat5
;
		EXT	SV_CRS
;
;-------------< ys_rpro >------------------------------------------------
		EXT	NEWVMADL,CHIPON,MPCHIPON,BLNKON
		EXT	VRAMDX_ST
		EXT	VRT01
		EXT	FADINTM
;
;-------------< ys_init >------------------------------------------------
		EXT	GMMDST,DIVDTST
		EXT	MPCHRST,MPCOLST
		EXT	MP00,GM00
		EXT	MPCHR
		EXT	UNCOMPRES
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ys_data >------------------------------------------------
		EXT	COS,SIN
;
;-------------< ys_mpobj >-----------------------------------------------
		EXT	MPOBJTBL,MPMVOBJTBL
		EXT	TOWER,TOWER5
;
;-------------< ys_mpmv >------------------------------------------------
		EXT	MAPMVTBL,MPPLMVDT
;
;-------------< ys_enmy2 >-----------------------------------------------
		EXT	ANGCKD
;
;-------------< ys_hlder >-----------------------------------------------
		EXT	AICON_BFAD,HOLDER_NO1M,HOLDER_NO1D
;
;-------------< ys_chr >-------------------------------------------------
		EXT	ADDSTART
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_17	GROUP	Map_pro
Map_pro		SECT	REL
;
;************************************************************************
;*		map test 1st initial					*
;************************************************************************
;
;-------------- z_[XN[NA[f[^ --------------------
MPHLDRCLR	EQU	$
		WORD	3000H,4000H+(0800H-1)
		WORD	01BFH
		WORD	0FFFFH
;
;-------------- title map "rogo" clear data -----------------------------
MPROGOCLR	EQU	$
		WORD	3800H,4000H+(0800H-1)
		WORD		0000H
		WORD	7E82H,4000H+((30+(32*8)+30)*2-1)
		WORD		05FFH
		WORD	0FFFFH
;
;-------------- H-DMA set data ------------------------------------------
;
;-------------- H-DMA parameter data ( [hVl`s`Ca ) ---
MPHDMAP0	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	1BH		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
HDMAPD0		EQU	$
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF0
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF0
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( [hVl`sbCc ) ---
MPHDMAP1	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	1DH		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
HDMAPD1		EQU	$
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF2
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF2
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( ^CgSJ[ ) -----
MPHDMAP2	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	21H		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
HDMAPD2		EQU	$
		BYTE	20H+00H		;line no.
		WORD	HDMAPR2+(HDMAPD2D-HDMAPD2)
;;;;		    BYTE    38H+80H	    ;line no.
		BYTE	30H+80H		;line no.
		WORD	MPHDMABF4
		BYTE	01H+00H
		WORD	HDMAPR2+(HDMAPD2D-HDMAPD2)
		HEX	00		;end code
;
HDMAPD2D	EQU	$
		WORD	2626H,7FFFH	;[ dummy data ]
;
;-------------- H-DMA parameter datai afRwiXN[ j---
MPHDMAP2_S	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	0DH		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
HDMAPD2_S	EQU	$
		BYTE	76H+00H		;line no.
		WORD	SCCH4		;
		BYTE	01H+00H		;line no.
		WORD	SCCH1		;
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( ^CgSgł ) -----
MPHDMAP3	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR3	;    A	    "     (L)
		BYTE	HIGH HDMAPR3	;	    "     (H)
		BYTE	BANK HDMAPR3	;	    "     (B)
;
HDMAPD3		EQU	$
		BYTE	20H+00H		;line no.
		WORD	MPHDMABF5
;;;;		    BYTE    38H+80H	    ;line no.
		BYTE	30H+80H		;line no.
		WORD	MPHDMABF5+4
		BYTE	01H+00H
		WORD	MPHDMABF5
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( EBhE ) -------------
MPHDMAP3_S	EQU	$
		BYTE	01000001B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMAPR3	;    A	    "     (L)
		BYTE	HIGH HDMAPR3	;	    "     (H)
		BYTE	BANK HDMAPR3	;	    "     (B)
;
HDMAPD3_S	EQU	$
		BYTE	0FH+00H		;line no.
		WORD	MPHDMABF5
		BYTE	64H+80H		;line no.
		WORD	MPHDMABF5+2
		BYTE	01H+80H		;line no.
		WORD	MPHDMABF5+0E0H
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( af[h؂ւ ) -----
MPHDMAP4	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	05H		;    B bus address
		BYTE	LOW  HDMADB0	;    A	    "     (L)
		BYTE	HIGH HDMADB0	;	    "     (H)
		BYTE	BANK HDMADB0	;	    "     (B)
;
HDMAPD4		EQU	$
		BYTE	76H+00H		;line no.
		BYTE	00010000B	;	( BG mode 0 )
		BYTE	6AH+00H		;line no.
		BYTE	00000111B	;	( BG mode 7 )
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( CʃZbg ) -------
MPHDMAP5	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMADB1	;    A	    "     (L)
		BYTE	HIGH HDMADB1	;	    "     (H)
		BYTE	BANK HDMADB1	;	    "     (B)
;
HDMAPD5		EQU	$
		BYTE	70H+00H		;line no.
		BYTE	00010011B	;	( BG mode 0 )
		BYTE	70H+00H		;line no.
		BYTE	00010001B	;	( BG mode 7 )
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( afPwiXN[ ) ---
MPHDMAP6	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	0DH		;    B bus address
		BYTE	LOW  HDMAPR4	;    A	    "     (L)
		BYTE	HIGH HDMAPR4	;	    "     (H)
		BYTE	BANK HDMAPR4	;	    "     (B)
;
HDMAPD6		EQU	$
		BYTE	5FH+00H		;line no.
		WORD	SCCH3		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH40		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH41		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH42		;
		BYTE	02H+00H		;line no.
		WORD	MPSCH43		;
		BYTE	03H+00H		;line no.
		WORD	MPSCH44		;
		BYTE	04H+00H		;line no.
		WORD	MPSCH45		;
		BYTE	05H+00H		;line no.
		WORD	MPSCH46		;
		BYTE	06H+00H		;line no.
		WORD	MPSCH47		;
		BYTE	01H+00H		;line no.
		WORD	SCCH1		;
		HEX	00		;end code
HDMAPD6E	EQU	$
;
BG3_SCR_ADR	EQU	$
		LWORD	MPB3SCR_ADR
		LWORD	MPB36W_ADR
;
MV_START_POS	EQU	$-2		; v[[ړX^[g|WV
		HEX	0DAH,058H
		HEX	0A1H,021H
		HEX	0C8H,0BBH
		HEX	020H,0B9H
		HEX	034H,040H
		HEX	0B9H,0D4H
;
MV_START_MAP	EQU	$-2
		WORD	00070H
		WORD	0004DH
		WORD	0001CH
		WORD	000EFH
		WORD	0009CH
		WORD	0002AH
;
CLR_WLD_CHK	EQU	$
		LWORD	SAVERAM0+2
		LWORD	SAVERAM1+2
		LWORD	SAVERAM2+2
;
;
STAR_ADDRESS	EQU	$
		WORD	SAVERAM0+(SAVERAM0-SAVERAM0)+SV_CRS+8+012*5
		WORD	SAVERAM0+(SAVERAM1-SAVERAM0)+SV_CRS+8+012*5
		WORD	SAVERAM0+(SAVERAM2-SAVERAM0)+SV_CRS+8+012*5
;
W6_CLS_CHK	EQU	$
		WORD	SAVERAM0+SV_CRS+012*(6-1)+(8-1)
		WORD	SAVERAM1+SV_CRS+012*(6-1)+(8-1)
		WORD	SAVERAM2+SV_CRS+012*(6-1)+(8-1)
;
;
MAPINIT		EQU	$
		LDA	#HLCL		;(A) <-- VRFLG set no.
		JSL	>VRAMCL2	;VRAM clear
		JSL	>URAMCLR	;use RAM clear
;
;------------------------------------------------------------------------
;-		map RAM initial set					-
;------------------------------------------------------------------------
		JSL	>DIVDTST	;div data set
;
		M16
;
		LDA	#0080H		;center X pos set
		STA	CENTX
		LDA	#0100H		;center Y pos set
		STA	CENTY
;
		STZ	<SCCH1		;[hVXN[JE^[
		LDA	#0060H
		STA	<SCCV1
		STZ	<SCCH2		;^CgSXN[JE^[
		LDA	#08FH
		STA	<SCCV2
		STZ	<SCCH3		;afRwiXN[JE^[
		STZ	<SCCV3
		STZ	MPSCH40+2	;XN[JE^[
		STZ	MPSCH41+2
		STZ	MPSCH42+2
		STZ	MPSCH43+2
		STZ	MPSCH44+2
		STZ	MPSCH45+2
		STZ	MPSCH46+2
		STZ	MPSCH47+2
		STZ	!MP_WINDOWS_FG
;
		M8
;
		LDA	!TITLEFG		; ^Cgf ?
		BNE	MPIN000			;	NO -> MPIN000
		LDA	>SLCT_FILE_NO
		ASL	A
		ADC	>SLCT_FILE_NO
		TAX
		M16				; memory 16bit mode
		LDA	CLR_WLD_CHK,X
		STA	<WORK0
		LDA	CLR_WLD_CHK+1,X
		STA	<WORK1
		STZ	!WLD6_FLG
		M8				; memory 8bit mode
		LDX	#000
		LDA	[<WORK0]
		AND	#07FH
		BEQ	CLR_WLD_CHK_PAS
CLR_WLD_CHK_LOP EQU	$
		INX
		SEC
		SBC	#012
		BPL	CLR_WLD_CHK_LOP
		DEX
		CPX	#006-1			; U[h܂ł ?
		BNE	CLR_WLD_CHK_PAS		;	NO -> CLR_WLD_CHK_PAS
		INC	!WLD6_FLG
CLR_WLD_CHK_PAS EQU	$
		TXA
		ASL	A
		STA	!MPTYPE
;
;------------------------------------------------------------------------
;-		map H-DMA initial set					-
;------------------------------------------------------------------------
MPIN000		EQU	$
		LDX	#04
MPIN010		EQU	$
		LDA	!MPHDMAP0,X
		STA	4370H,X
		LDA	!MPHDMAP1,X
		STA	4360H,X
		LDA	!MPHDMAP2,X
		STA	4350H,X
		LDA	!MPHDMAP3,X
		STA	4340H,X
		LDA	!MPHDMAP4,X
		STA	4330H,X
		LDA	!MPHDMAP5,X
		STA	4320H,X
		LDA	!MPHDMAP6,X
		STA	4310H,X
		DEX
		BPL	MPIN010
		LDA	#BANK HDMABUF
		STA	4377H
		STA	4367H
		STA	4357H
		STA	4347H
		STA	4337H
		STA	4327H
		STZ	4317H
;
		LDX	#HDMAPD6E-HDMAPD6-1
MPIN020		EQU	$
		LDA	!HDMAPD0,X
		STA	>HDMAPR0,X
		LDA	!HDMAPD1,X
		STA	>HDMAPR1,X
		LDA	!HDMAPD2,X
		STA	>HDMAPR2,X
		LDA	!HDMAPD3,X
		STA	>HDMAPR3,X
		LDA	!HDMAPD4,X
		STA	>HDMADB0,X
		LDA	!HDMAPD5,X
		STA	>HDMADB1,X
		LDA	!HDMAPD6,X
		STA	>HDMAPR4,X
		DEX
		BPL	MPIN020
;
		LDA	#0DH		;wiXN[JE^[Zbgg|cl`Zbg
		STA	MP_BG3_BBUS
;
;------------------------------------------------------------------------
;-		map character set					-
;------------------------------------------------------------------------
		JSL	>MPCHRST	;character set
;
;------------------------------------------------------------------------
;-		PPU Reg. set						-
;------------------------------------------------------------------------
		LDX	#MP00		;(X) <-- map mode type no.
		JSL	>GMMDST		;game mode set
		LDA	#3CH
		STA	210AH		;BG4 screen base set
		STZ	211AH		;mode 7 initial set flag set
;
;------------------------------------------------------------------------
;-		title rogo & moji character save			-
;------------------------------------------------------------------------
;
;	WORKBF+(0000H-03FFH) : title rogo character (low)
;	   "   (0400H-07FFH) : moji character (low)
;	   "   (0800H-0BFFH) : title rogo character (high)
;	   "   (0C00H-0FFFH) : moji character (high)
;
		M16
;
		LDY	#00000000B
		STY	2115H		;inc mode set (low)
		LDA	#3800H
		STA	2116H		;VRAM address set
		LDA	#10000000B+(39H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#WORKBF
		STA	4302H		;A bus address(L,H) set
		LDY	#BANK WORKBF
		STY	4304H		;	"     (B) set
		LDA	#0800H
		STA	4305H		;number of byte set
		LDY	2139H		;dummy read !!
		LDX	#00000001B
		STX	420BH		;DMA "ON"
		LDY	#10000000B
		STY	2115H		;inc mode set (high)
		LDA	#3800H
		STA	2116H		;VRAM address set
		LDY	#3AH
		STY	4301H		;B bus address set
		LDA	#0800H
		STA	4305H		;number of byte set
		LDY	213AH		;dummy read !!
		STX	420BH		;DMA "ON"
;
;------------------------------------------------------------------------
;-		mode 7 screen set					-
;------------------------------------------------------------------------
		LDY	#7FH		;(WK0) <-- clear chara no.
		STY	<WORK
;
		STZ	2115H		;inc mode set
;
		STZ	2116H		;VRAM address set
		LDA	#00001000B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#WORK
		STA	4302H		;A bus address(L,H) set
;;;;		LDY	#BANK WORK
		STZ	4304H		;	"     (B) set
		LDA	#2000H
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;------------------------------------------------------------------------
;-		mode 0 screen write					-
;------------------------------------------------------------------------
		LDY	#10000000B
		STY	2115H		;inc mode set
;;;;K;;;;		LDA	#3C00H
;;;;K;;;;		STA	2116H		;VRAM address set
;;;;K;;;;		LDA	#00000001B+(18H*100H)
;;;;K;;;;		STA	4300H		;DMA parameter & B bus address set
;;;;K;;;;		LDA	#MPB3SCR_ADR
;;;;K;;;;		STA	4302H		;A bus address(L,H) set
;;;;K;;;;		LDY	#BANK MPB3SCR_ADR
;;;;K;;;;		STY	4304H		;	"     (B) set
;;;;K;;;;		LDA	#0800H
;;;;K;;;;		STA	4305H		;number of byte set
;;;;K;;;;;;;;		LDX	#00000001B
;;;;K;;;;		STX	420BH		;DMA "ON"
		LDY	#003
		LDA	!TITLEFG
		AND	#000FFH
		CMP	#00080H
		BEQ	BG3_SCR_050
		LDA	!WLD6_FLG
		BNE	BG3_SCR_050
		DEY
		DEY
		DEY
BG3_SCR_050	EQU	$
		LDA	#3C00H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	BG3_SCR_ADR+1,Y
		STA	4303H		;A bus address(B) set
		LDA	BG3_SCR_ADR,Y
		STA	4302H		;A bus address(L,H) set
		LDA	#00480H
		STA	4305H		;number of byte set
;;;;		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		LDA	#3E40H
		STA	2116H		;VRAM address set
		LDA	#MPB3RG_ADR
		STA	4302H		;A bus address(L,H) set
		LDY	#BANK MPB3RG_ADR
		STY	4304H		;	"     (B) set
		LDA	#00380H
		STA	4305H		;number of byte set
;;;;		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;--------------------------------------------------------
;-		Zbg				-
;--------------------------------------------------------
		LDX	#BANK SAVERAM0
		STX	<WORK2
		LDA	>SLCT_FILE_NO
		ASL	A
		TAX
		LDA	STAR_ADDRESS,X
		STA	<WORK0
		LDY	#006-1
		LDA	#03E00H+08FH+(006-1)*2
		STA	<WORKA
		LDA	#03E00H+0AFH+(006-1)*2
		STA	<WORKC
;
STAR_1000	EQU	$
		LDA	#02B7FH
		STA	<WORK10
		STA	<WORK12
		STA	<WORK20
		STA	<WORK22
		LDA	[<WORK0]
		AND	#0007FH
		CMP	#00100		; XyVR[XPOO_ɂȂĂ邩 ?
		BCC	STAR_2000	;	NO -> STAR_2000
		LDA	#02B12H
		STA	<WORK10
		INC	A
		STA	<WORK12
		LDA	#02B22H
		STA	<WORK20
		INC	A
		STA	<WORK22
STAR_2000	EQU	$
		LDA	<WORKA		; XN[ɐ
		STA	2116H		;
		LDA	<WORK10		;
		STA	2118H		;
		LDA	<WORK12		;
		STA	2118H		;
		LDA	<WORKC		;
		STA	2116H		;
		LDA	<WORK20		;
		STA	2118H		;
		LDA	<WORK22		;
		STA	2118H		;
;
		LDA	<WORK0
		SEC
		SBC	#00012
		STA	<WORK0
		DEC	<WORKA
		DEC	<WORKA
		DEC	<WORKC
		DEC	<WORKC
		DEY			; Zbg I ?
		BPL	STAR_1000	;	NO -> STAR_1000
;
;------------------------------------------------------------------------
;-		title map initial set					-
;------------------------------------------------------------------------
;
		LDY	TITLEFG
		BNE	MPIN060		;title map ? ( no:MPIN060 )
;
;----------------------------------------------------------------
;-	I[vjO f [v ^C}[ Zbg		-
;----------------------------------------------------------------
		LDA	#00400H
		STA	!OPDMLPTM
;
		LDA	#0DA00H		;}bvvC[ʒuZbg
		STA	MPPLXPOS
		LDA	#05800H
		STA	MPPLZPOS
		LDA	#000H
		STA	MPPLYPOS
		LDA	#00070H
		STA	!MPANGLE
;
;----------------------------------------------------------------
;-		title color animation H-DMA data set		-
;----------------------------------------------------------------
		PHB			;(DBR) save
		LDX	#BANK MPHDMABF4 ;(DBR) <-- BANK MPHDMABF4
		PHX
		PLB
;
		I16
;
		LDY	#((040H*2)-1)*4 ;[ 010H line over !! ]
MPIN030		EQU	$
		LDA	#2626H
		STA	MPHDMABF4,Y
		DEY
		DEY
		DEY
		DEY
		BPL	MPIN030
;
		LDX	#(040H-1)*2
		LDY	#(040H-1)*4	;[ 010H line over !! ]
MPIN040		EQU	$
		LDA	>COL_ADDRESS+TITLE_ANIM_COL,X
		STA	MPHDMABF4+2,Y
		STA	MPHDMABF4+(040H*4)+2,Y
		DEY
		DEY
		DEY
		DEY
		DEX
		DEX
		BPL	MPIN040
;
;----------------------------------------------------------------
;-		title scroll counter H-DMA data set		-
;----------------------------------------------------------------
		LDX	#(38H+1-1)*4	;[ +1:top data -> normal ]
MPIN050		EQU	$
		LDA	<SCCH2
		STA	MPHDMABF5,X
		LDA	<SCCV2
		STA	MPHDMABF5+2,X
		DEX
		DEX
		DEX
		DEX
		BPL	MPIN050
;
		MI8
;
		PLB
;
		LDA	#11111110B	;(A) <-- H-DMA "ON" flag
		BRA	MPIN070
;
;------------------------------------------------------------------------
;-		game map initial set					-
;------------------------------------------------------------------------
;
		MEM16
		IDX8
;
MPIN060		EQU	$
;
;----------------------------------------------------------------
;-		moji character change initial set		-
;----------------------------------------------------------------
		LDY	#00		;(Y) <-- clear data
		LDA	#WORKBF
		STA	<WORK20
		LDX	#BANK WORKBF
		STX	<WORK22
		LDA	#0400H
		JSL	>DMA_D_M
		LDA	#WORKBF+800H
		STA	<WORK20
		LDA	#0400H
		JSL	>DMA_D_M
;
		LDA	#00010001B	;main select set
		STA	MANSEL
;
;----------------------------------------------------------------
;-		title map "rogo" clear				-
;----------------------------------------------------------------
;
		M8
;
		LDA	#MTCL
		STA	VRFLG
		JSL	>VMADSPL
;
		LDA	#11001110B	;(A) <-- H-DMA "ON" flag
MPIN070		EQU	$
		STA	HD420C		;H-DMA "ON" !!
;
;
;------------------------------------------------------------------------
;-		map RAM clear						-
;------------------------------------------------------------------------
;
		I16
;
;-------------- SFC ---------------------------------------------
		LDX	#MPCLRSE-1
MPIN2001	EQU	$
		STZ	MPCLRRM_S,X
		DEX
		BPL	MPIN2001
;
;-------------- M-chip ------------------------------------------
		LDX	#MMPCLRSE-1
MPIN2002	EQU	$
		STZ	MMPCLRRM_S,X
		DEX
		BPL	MPIN2002
;
		I8
;
;------------------------------------------------------------------------
;-		color set						-
;------------------------------------------------------------------------
		LDX	#002
		LDA	!TITLEFG
		CMP	#080H
		BEQ	WLD6_ST_200
		LDA	!WLD6_FLG	; n}bv ?
		BNE	WLD6_ST_200	;	YES -> WLD6_ST_200
		DEX
		DEX
WLD6_ST_200	EQU	$
		JSL	>MPCOLST
;
;------------------------------------------------------------------------
;-		mode 7 screen set					-
;------------------------------------------------------------------------
		PHB			;(DBR) save
		LDA	#BANK VRAMDX	;(DBR) <-- VRAMDX(B)
		PHA
		PLB
;
		MI16
		LDA	#00400H
		STA	<WORK4
		LDA	!TITLEFG
		AND	#000FFH
		CMP	#00080H
		BEQ	WLD6_ST_400
		LDA	!WLD6_FLG	; n}bv ?
		BNE	WLD6_ST_400	;	YES -> WLD6_ST_400
		STZ	<WORK4
;
WLD6_ST_400	EQU	$
		LDY	VRAMDX		;(Y) <-- VRAMDX set pointer
		LDA	<WORK4
		CLC
		ADC	#MAPSCR_ADR
		STA	<WORK4		;(WK4,5) <-- mode 7 screen data address(L,H)
		LDA	#32
		STA	<WORK2		;(WK2,3) <-- V loop no.
		LDA	#(080H/8)*(20H*4)
MPIN2020	EQU	$
		STA	<WORK		;(WK0,1) <-- VRAM address set
		STA	0,Y		;VRAM address set
		LDA	#00000000B
		STA	2,Y		;inc mode set
		LDA	#00000000B+(18H*100H)
		STA	3,Y		;DMA parameter & B bus address set
		LDA	<WORK4
		STA	5,Y		;A bus address(L,H) set
		CLC
		ADC	#32
		STA	<WORK4
		LDA	#BANK MAPSCR_ADR
		STA	7,Y		;	"     (B) set
		LDA	#32
		STA	8,Y		;number of byte set
		TYA
		CLC
		ADC	#12
		STA	10,Y		;next data address set
		TAY
		LDA	<WORK
		CLC
		ADC	#20H*4
		DEC	<WORK2
		BNE	MPIN2020
		STY	VRAMDX		;end address set
;
		PLB
;
;------------------------------------------------------------------------
;-		map OBJ data set					-
;------------------------------------------------------------------------
		LDX	#00002
		LDA	!TITLEFG
		AND	#000FFH
		CMP	#00080H
		BEQ	WLD6_ST_800
		LDA	!WLD6_FLG	; n}bv ?
		BNE	WLD6_ST_800	;	YES -> WLD6_ST_800
		DEX
		DEX
WLD6_ST_800	EQU	$
		LDA	>MPOBJTBL,X	;(WK0,1) <-- map OBJ data address
		STA	<WORK
		LDA	>MPMVOBJTBL,X	;(WK2,3) <-- map move OBJ data address
		STA	<WORK+2
;
		M8
;
;-------------- map OBJ data RAM set ----------------------------
		PHB
		LDA	#BANK MPOBJTBL
		PHA
		PLB
		LDY	#00		;(Y)	 <-- map OBJ RAM pointer
MPIN2030	EQU	$
		LDA	(<WORK),Y
		CMP	#0FFH
		BEQ	MPIN2050	;end ? ( yes:MPIN2050 )
;
		INC	MPOBJSTN	;map OBJ set no count up !!
;
		LDX	#4
MPIN2040	EQU	$
		LDA	(<WORK),Y
		STA	MPOBJTYP,Y
		INY
		DEX
		BNE	MPIN2040
		BRA	MPIN2030
;
;-------------- map player RAM initial set ----------------------
MPIN2050	EQU	$
		PLB
		LDA	MPPLXPOS+1	;player X pos set
		STA	MPPLXPS
		LDA	MPPLZPOS+1	;   "   Z    "
		STA	MPPLZPS
		LDA	MPPLYPOS+1	;   "   Y    "
		STA	MPPLYPS
		LDA	#0C0H		;   "   angle set
		SEC
		SBC	MPANGLE
		STA	MPPLANG
;
;-------------- map OBJ zoom size initial set -------------------
;
		MI16
;
		LDX	#(MPOBJN-1)*4
		LDA	#0100H		;(A) <-- 1.0
MPIN2060	EQU	$
		STA	MPWOBJSIZ,X
		DEX
		DEX
		DEX
		DEX
		BPL	MPIN2060
;
		MI8		; memory , index 8bit mode
;
;-------------- map move OBJ data RAM set -----------------------
		PHB
		LDA	#BANK MPMVOBJTBL
		PHA
		PLB
		LDY	#00		;(Y)	 <-- map move OBJ RAM pointer
MPIN2070	EQU	$
		LDA	(<WORK+2),Y
		BMI	MPIN2090	;end ? ( yes:MPIN2090 )
;
		LDX	#4
MPIN2080	EQU	$
		LDA	(<WORK+2),Y
		STA	MPMVOBJNO,Y
		INY
		DEX
		BNE	MPIN2080
		BRA	MPIN2070
;
MPIN2090	EQU	$
		PLB
;
;------------------------------------------------------------------------
;-		map course select BG write flag "ON"			-
;------------------------------------------------------------------------
WLD_CHK_300	EQU	$
		JSR	CRSCK010
;
		LDX	!MPTYPE
		BNE	WLD_CHK_310
		JMP	HATA_SET_END
WLD_CHK_310	EQU	$
		LDA	!TITLEFG
		AND	#07FH
		BNE	HATA_SET_SET
;;;;K;;;;		CPX	#(006-1)*2
;;;;K;;;;		BEQ	HATA_SET_SET
		INX
		INX
HATA_SET_SET	EQU	$
		LDA	MV_START_POS+0,X
		STA	!MPPLXPOS+1
		STA	MPPLXPS
		LDA	MV_START_POS+1,X
		STA	!MPPLZPOS+1
		STA	MPPLZPS
		LDA	MV_START_MAP,X
		STA	!MPANGLE
		LDA	#0C0H
		SEC
		SBC	MPANGLE
		STA	MPPLANG
;
		LDA	!TITLEFG
		AND	#07FH
		BNE	WLD_CHK_400
		LDA	!MPTYPE
		CMP	#(006-1)*2	;Uvnqkc`FbN ?
		BNE	WLD_CHK_400	;	NO -> WLD_CHK_400
		LDA	>SLCT_FILE_NO
		ASL	A
		TAY
		LDA	#BANK SAVERAM0
		STA	<WORK2
		M16			; memory 16bit mode
		LDA	W6_CLS_CHK,Y
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	[<WORK]
		AND	#080H
		BEQ	WLD_CHK_380
		M16			; memory 16bit mode
		LDA	>MAPMVTBL,X
		STA	!MPCLRPT
		LDA	>TOWER,X
		STA	!MPFGONPT
		I16			; index 16bit mode
		TAY
		LDA	#00000
		STA	!MPOBJTYP,Y
		I8			; index 8bit mode
		TXA
		ASL	A
		TAY
		LDA	#M_PTPT
		STA	!MPMVOBJNO,Y
		M8			; memory 8bit mode
WLD_CHK_380	EQU	$
		BRA	HATA_SET_END
;
WLD_CHK_400	EQU	$
		M16			; memory 16bit mode
		LDA	>MAPMVTBL,X
		STA	!MPCLRPT
		LDA	>TOWER,X
		STA	!MPFGONPT
		M8			; memory 8bit mode
		CPX	#006*2
		BCS	HATA_SET_END
		TXA
		ASL	A
		TAY
HATA_SET_LOOP	EQU	$
		DEY
		DEY
		DEY
		DEY
		BEQ	HATA_SET_END
		LDA	#M_PTPT
		STA	!MPMVOBJNO,Y
		TYA
		LSR	A
		TAX
		M16			; memory 16bit mode
		LDA	>TOWER,X
		I16			; index 16bit mode
		TAX
		M8			; memory 8bit mode
		STZ	!MPOBJTYP,X
		I8			; index 8bit mode
		BRA	HATA_SET_LOOP
HATA_SET_END	EQU	$
;
		LDA	!TITLEFG	; ^Cgf
		BEQ	WLD_CHK_990	;	YES -> WLD_CHK_990
;
;------------------------------------------------------------------------
;-		[h NA f CjV `FbN  Zbg	-
;------------------------------------------------------------------------
WLD_CHK_500	EQU	$
		LDA	!TITLEFG	; ^Cgf
		BEQ	WLD_CHK_990	;	YES -> WLD_CHK_990
		CMP	#080H		; n}bv ?
		BNE	WLD_CHK_550	;	NO -> WLD_CHK_550
		LDA	#W6_DM
		BRA	WLD_CHK_560
WLD_CHK_550	EQU	$
		LDA	#PFGON
WLD_CHK_560	EQU	$
		STA	!MPLMODE
;
;------------------------------------------------------------------------
;-		lo|vhmcnvrXN[Zbg			-
;------------------------------------------------------------------------
WLD_CHK_990	EQU	$
;
		LDA	!TITLEFG	; ^Cgf ?
		BMI	MPIN2500	;	NO -> MPIN2500
;;;;K;;;;		BNE	MPIN2500	;	NO -> MPIN2500
;
		LDA	>SLCT_FILE_NO
		STA	!FLSLCSLPT
;
		JSR	FLINTSET
;
		MI16
;
		LDX	#HOLDERBF0	;(X)   <-- ]AhXikCgj
		LDA	#BANK HOLDERBF0
		STA	<WORK1		;(WK1) <-- ]AhXiaj
		LDY	#3020H		;(Y)   <-- uq`lAhX
		LDA	#00300H		;(A)   <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDX	#MPBITMAP	;(X) <-- ]AhXikCgj
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <-- ]AhXiaj
		LDY	#2000H		;(Y) <-- uq`lAhX
		LDA	#1000H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		MI8
;
		JSL	>NEWVMADL
;
;------------------------------------------------------------------------
;-		TEhvO]i}bvj			-
;------------------------------------------------------------------------
MPIN2500	EQU	$
		LDA	!TITLEFG
		BPL	MPIN2520
		LDA	#0F0H		;BGM off !!
		BRA	MPIN2540
;;;;K;;;;		 JSL	 >SOUND_TR_MAP
MPIN2520	EQU	$
		LDA	!TITL_SND
		BPL	MPIN2550
		LDA	#01H		;[]
		STA	!TITL_SND
		LDX	!WLD6_FLG
		BEQ	MPIN2540
		INC	A
		INC	A
MPIN2540	EQU	$
		STA	<SOUND_0
;
;------------------------------------------------------------------------
;-		1st map set						-
;------------------------------------------------------------------------
MPIN2550	EQU	$
		LDA	MPFADFG
		BNE	MPIN2092	;1st fade in/out ? ( no:MPIN2092 )
;
		LDA	#1FH
		STA	MPFADR
		STA	MPFADG
		STA	MPFADB
;
MPIN2092	EQU	$
		STZ	MPFADFG		;fade in/out cancel !!
;
		JSL	>BLNKOFF	;NMI enable
;
		JSL	>MAPPLAY0	;1st map set
;
		LDA	MPWDMAFG
		STA	MPDMAFG		;bitmap chara DMA "ON" !!
;
MPIN2100	EQU	$
		LDA	MPDMAFG
		BNE	MPIN2100	;bitmap chara DMA end ? ( no:MPIN2100 )
;
		LDA	MPBANK		;OBJ chara bank change
		EOR	#01H
		STA	MPBANK
;
		LDA	#0FH
		STA	FADNO
;
;-------------- go to next mode !! ------------------------------
		JSR	MPFADIN		;fade initial set
;
		JMP	>MODINC		;go to next mode !!
;
;------------------------------------------------------------------------
;-		fade initial set					-
;------------------------------------------------------------------------
MPFADIN		EQU	$
		LDA	!FADMK
		ASL	A
		ASL	A
		TAX
		LDY	#(3-1)*2
MPFI010		EQU	$
		LDA	>FADINTM,X
		STA	MPFADRTM,Y	;constant color add fade initial wait timer set ( red )
		INX
		DEY
		DEY
		BPL	MPFI010
		INC	MPFADFG
		RTS
;
;------------------------------------------------------------------------
;-		map course select BG write flag "ON"			-
;------------------------------------------------------------------------
CRSCK010	EQU	$
		STZ	MPLMODE		;map player mode set
		LDA	TITLEFG
		BEQ	CRSCK020	;title ? ( yes:CRSCK020 )
;
CORSELON	EQU	$
		LDA	#3
		STA	MPSPFLAG	;map spacial flag set
		LDA	#06H
		STA	MPSPWK0		;counter initial set
CRSCK020	EQU	$
		RTS
;
;************************************************************************
;*		map test initial					*
;************************************************************************
;
;-------------- map test OAM data -------------------------------
MPOBX		EQU	10H
MPOBY		EQU	28H
;
MAPOAM		EQU	$
		BYTE	040H+MPOBX,000H+MPOBY,000H,2EH	;[01]
		BYTE	060H+MPOBX,000H+MPOBY,004H,2EH	;[02]
		BYTE	080H+MPOBX,000H+MPOBY,008H,2EH	;[03]
;
		BYTE	020H+MPOBX,020H+MPOBY,040H,2EH	;[04]
		BYTE	040H+MPOBX,020H+MPOBY,044H,2EH	;[05]
		BYTE	060H+MPOBX,020H+MPOBY,048H,2EH	;[06]
		BYTE	080H+MPOBX,020H+MPOBY,04CH,2EH	;[07]
		BYTE	0A0H+MPOBX,020H+MPOBY,00CH,2EH	;[08]
;
		BYTE	010H+MPOBX,040H+MPOBY,080H,2EH	;[09]
		BYTE	030H+MPOBX,040H+MPOBY,084H,2EH	;[10]
		BYTE	050H+MPOBX,040H+MPOBY,088H,2EH	;[11]
		BYTE	070H+MPOBX,040H+MPOBY,08CH,2EH	;[12]
		BYTE	090H+MPOBX,040H+MPOBY,040H,2FH	;[13]
		BYTE	0B0H+MPOBX,040H+MPOBY,044H,2FH	;[14]
;
		BYTE	010H+MPOBX,060H+MPOBY,0C0H,2EH	;[15]
		BYTE	030H+MPOBX,060H+MPOBY,0C4H,2EH	;[16]
		BYTE	050H+MPOBX,060H+MPOBY,0C8H,2EH	;[17]
		BYTE	070H+MPOBX,060H+MPOBY,0CCH,2EH	;[18]
;
		BYTE	010H+MPOBX,080H+MPOBY,000H,2FH	;[19]
		BYTE	030H+MPOBX,080H+MPOBY,004H,2FH	;[20]
		BYTE	050H+MPOBX,080H+MPOBY,008H,2FH	;[21]
		BYTE	070H+MPOBX,080H+MPOBY,00CH,2FH	;[22]
		BYTE	090H+MPOBX,070H+MPOBY,048H,2FH	;[23]
		BYTE	0B0H+MPOBX,070H+MPOBY,04CH,2FH	;[24]
;
		BYTE	090H+MPOBX,060H+MPOBY,080H,2FH	;[25]
		BYTE	0A0H+MPOBX,060H+MPOBY,082H,2FH	;[26]
		BYTE	0B0H+MPOBX,060H+MPOBY,084H,2FH	;[27]
		BYTE	0C0H+MPOBX,060H+MPOBY,086H,2FH	;[28]
;
		BYTE	090H+MPOBX,090H+MPOBY,088H,2FH	;[29]
		BYTE	0A0H+MPOBX,090H+MPOBY,08AH,2FH	;[30]
		BYTE	0B0H+MPOBX,090H+MPOBY,08CH,2FH	;[31]
		BYTE	0C0H+MPOBX,090H+MPOBY,08EH,2FH	;[32]
;
		BYTE	000H+MPOBX,050H+MPOBY,0A0H,2FH	;[33]
		BYTE	000H+MPOBX,060H+MPOBY,0A2H,2FH	;[34]
		BYTE	000H+MPOBX,070H+MPOBY,0A4H,2FH	;[35]
		BYTE	000H+MPOBX,080H+MPOBY,0A6H,2FH	;[36]
		BYTE	0D0H+MPOBX,050H+MPOBY,0A8H,2FH	;[37]
		BYTE	0D0H+MPOBX,060H+MPOBY,0AAH,2FH	;[38]
		BYTE	0D0H+MPOBX,070H+MPOBY,0ACH,2FH	;[39]
		BYTE	0D0H+MPOBX,080H+MPOBY,0AEH,2FH	;[40]
MAPOAME		EQU	$
;
MAPOAMSB	EQU	$
		WORD	1010101010101010B		;[01-08]
		WORD	1010101010101010B		;[09-16]
		WORD	1010101010101010B		;[17-24]
		WORD	0000000000000000B		;[25-32]
		WORD	0000000000000000B		;[33-40]
MAPOAMSBE	EQU	$
;
;-------------- map test bitmap data convert status data --------
MPCNVST		EQU	$
		WORD	MPCNVST0
		WORD	MPCNVST1
		WORD	MPCNVST2
		WORD	MPCNVST3
MPCNVBP		EQU	$
		WORD	MPDMABF
		WORD	MPDMABF+0E00H
		WORD	MPDMABF+0E00H*2
		WORD	MPDMABF+0E00H*3
;
;				  X	Y	number of chara
MPCNVST0	WORD	MPBITMAP+(08*20+00)*20H
		BYTE	06*2				;(1)
		WORD	MPBITMAP+(20*20+04)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+01)*20H
		BYTE	06*2				;(1)
		WORD	MPBITMAP+(20*20+05)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+02)*20H
		BYTE	06*2				;(2)
		WORD	MPBITMAP+(20*20+06)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+03)*20H
		BYTE	06*2				;(2)
		WORD	MPBITMAP+(20*20+07)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(04*20+04)*20H
		BYTE	08*2				;(3)
		WORD	MPBITMAP+(04*20+05)*20H
		BYTE	08*2				;(3)
		WORD	MPBITMAP+(04*20+06)*20H
		BYTE	08*2				;(4)
		HEX	FF
;
MPCNVST1	WORD	MPBITMAP+(04*20+07)*20H
		BYTE	08*2				;(4)
		WORD	MPBITMAP+(02*20+08)*20H
		BYTE	08*2				;(5)
		WORD	MPBITMAP+(02*20+09)*20H
		BYTE	08*2				;(5)
		WORD	MPBITMAP+(02*20+10)*20H
		BYTE	08*2				;(6)
		WORD	MPBITMAP+(02*20+11)*20H
		BYTE	08*2				;(6)
		WORD	MPBITMAP+(02*20+12)*20H
		BYTE	08*2				;(7)
		WORD	MPBITMAP+(02*20+13)*20H
		BYTE	08*2				;(7)
		HEX	FF
;
MPCNVST2	WORD	MPBITMAP+(02*20+14)*20H
		BYTE	08*2				;(8)
		WORD	MPBITMAP+(02*20+15)*20H
		BYTE	08*2				;(8)
		WORD	MPBITMAP+(02*20+16)*20H
		BYTE	08*2				;(9)
		WORD	MPBITMAP+(02*20+17)*20H
		BYTE	08*2				;(9)
		WORD	MPBITMAP+(02*20+18)*20H
		BYTE	08*2				;(10)
		WORD	MPBITMAP+(02*20+19)*20H
		BYTE	08*2				;(10)
		WORD	MPBITMAP+(18*20+08)*20H
		BYTE	04*2				;(12)
		WORD	MPBITMAP+(18*20+14)*20H
		BYTE	04*2				;(15)
		HEX	FF
;
MPCNVST3	WORD	MPBITMAP+(18*20+09)*20H
		BYTE	04*2				;(12)
		WORD	MPBITMAP+(18*20+15)*20H
		BYTE	04*2				;(15)
		WORD	MPBITMAP+(18*20+10)*20H
		BYTE	04*2				;(13)
		WORD	MPBITMAP+(18*20+16)*20H
		BYTE	04*2				;(16)
		WORD	MPBITMAP+(18*20+11)*20H
		BYTE	04*2				;(13)
		WORD	MPBITMAP+(18*20+17)*20H
		BYTE	04*2				;(16)
		WORD	MPBITMAP+(18*20+12)*20H
		BYTE	04*2				;(14)
		WORD	MPBITMAP+(18*20+18)*20H
		BYTE	04*2				;(17)
		WORD	MPBITMAP+(18*20+13)*20H
		BYTE	04*2				;(14)
		WORD	MPBITMAP+(18*20+19)*20H
		BYTE	04*2				;(17)
		WORD	MPBITMAP+(00*20+10)*20H
		BYTE	01*2				;(18)
		WORD	MPBITMAP+(00*20+12)*20H
		BYTE	01*2				;(19)
		WORD	MPBITMAP+(00*20+14)*20H
		BYTE	01*2				;(20)
		WORD	MPBITMAP+(00*20+16)*20H
		BYTE	01*2				;(21)
		WORD	MPBITMAP+(26*20+10)*20H
		BYTE	01*2				;(22)
		WORD	MPBITMAP+(26*20+12)*20H
		BYTE	01*2				;(23)
		WORD	MPBITMAP+(26*20+14)*20H
		BYTE	01*2				;(24)
		WORD	MPBITMAP+(26*20+16)*20H
		BYTE	01*2				;(25)
		WORD	MPBITMAP+(00*20+11)*20H
		BYTE	01*2				;(18)
		WORD	MPBITMAP+(00*20+13)*20H
		BYTE	01*2				;(19)
		WORD	MPBITMAP+(00*20+15)*20H
		BYTE	01*2				;(20)
		WORD	MPBITMAP+(00*20+17)*20H
		BYTE	01*2				;(21)
		WORD	MPBITMAP+(26*20+11)*20H
		BYTE	01*2				;(22)
		WORD	MPBITMAP+(26*20+13)*20H
		BYTE	01*2				;(23)
		WORD	MPBITMAP+(26*20+15)*20H
		BYTE	01*2				;(24)
		WORD	MPBITMAP+(26*20+17)*20H
		BYTE	01*2				;(25)
		HEX	FF
;
;-------------- map fade in/out end check data ------------------
FADCP		EQU	$		;[FADMK]
		WORD	00000H		;[0]
		WORD	07FFFH		;[1]
;
MAPPLAY0	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
MAPPLAY		EQU	$
;
;------------------------------------------------------------------------
;-		OAM set							-
;------------------------------------------------------------------------
		JSL	>OAMCLR		;OAM clear !!
;
		MI16
;
		LDX	#MAPOAME-MAPOAM-2
MPPL010		EQU	$
		LDA	!MAPOAM,X
		STA	>OAM+(32*4),X
		DEX
		DEX
		BPL	MPPL010
;
		LDX	#MAPOAMSBE-MAPOAMSB-2
MPPL020		EQU	$
		LDA	!MAPOAMSB,X
		STA	>OAMSUB+(32/4),X
		DEX
		DEX
		BPL	MPPL020
;
		MI8
;
		LDA	!TITLEFG	; [h NA f ?
		BMI	MPPL022		;	YES -> MPPL022
;
		LDA	MP_WINDOWS_FG
		BEQ	MPPL022		;lo|vhmcnvrH ( no:MPPL022 )
;
		JSR	MP_WINDOWS
		JMP	MPPL047
;
;------------------------------------------------------------------------
;-		map pars data set					-
;------------------------------------------------------------------------
MPPL022		EQU	$
;
		M16
;
		LDX	#BANK MPPARSST
		LDA	#MPPARSST
		JSL	>CHIPON
;
;------------------------------------------------------------------------
;-		map bitmap OBJ move					-
;------------------------------------------------------------------------
;
		M8
;
		JSR	MPMVOBJ
;
;------------------------------------------------------------------------
;-		map point color change					-
;------------------------------------------------------------------------
		LDA	<FRCNT
		AND	#07H
		ASL	A
		TAX
;
		M16
;
		LDA	>COL_ADDRESS+MAP_POINT_COL,X
		STA	>DATACOL+(80H+77H)*2
;
;------------------------------------------------------------------------
;-		map bitmap buffer clear					-
;------------------------------------------------------------------------
		LDX	#BANK MPBFCLR
		LDA	#MPBFCLR
		JSL	>CHIPON
;
;------------------------------------------------------------------------
;-		map bitmap buffer set					-
;------------------------------------------------------------------------
		LDX	#BANK MPWRITE
		LDA	#MPWRITE
		JSL	>CHIPON
;
		M8
;
;------------------------------------------------------------------------
;-		bitmap buffer trasfer					-
;------------------------------------------------------------------------
MPPL030		EQU	$
		LDA	MPDMAFG
		BNE	MPPL030		;bitmap chara DMA end ? ( no:MPPL030 )
;
;----------------------------------------------------------------
;-		bitmap data convert				-
;----------------------------------------------------------------
MPPL032		EQU	$
		LDA	4212H
		BPL	MPPL032
MPPL034		EQU	$
		LDA	4212H
		BMI	MPPL034
;
		M16
;
;----------------------------------------------------------------
;-		title rogo wave set data set			-
;----------------------------------------------------------------
		LDA	MPTITLCT
		CLC
		ADC	#020H
		AND	#07FEH
		STA	MPTITLCT
		STA	<WORK4		;(WK4,5) <-- cos,sin data pointer
		STZ	<WORK6		;(WK6,7) <-- H-DMA buffer    "
;
		LDA	#MPCNVBF	;(WK23,24,25) <-- from address
		STA	<WORK23
		LDA	#BANK MPCNVBF
		STA	<WORK25
;
		LDX	#(4-1)*2
MPPL040		EQU	$
		STX	<WORK		;(WK0,1) <-- loop no
;
		LDA	>MPCNVST,X
		STA	R14		;convert status data address(L,H)
		LDA	#BANK MPCNVST0
		STA	R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>MPCHIPON
;
		LDX	<WORK
		LDA	#MPDMABF/100H	;(WK20,21,22) <-- to address
		STA	<WORK21
		LDA	!MPCNVBP,X
		STA	<WORK20
;
		M8
;
MPPL042		EQU	$
		BIT	4212H
		BVC	MPPL042
MPPL044		EQU	$
		BIT	4212H
		BVS	MPPL044
		LDY	#04H
MPPL046		EQU	$
		DEY
		BNE	MPPL046
;
		M16
;
		LDA	#0E00H		;(A) <-- number of byte
		JSL	>DMA_M_M
;
		DEX
		DEX
		BPL	MPPL040
;
		LDA	MPBANK		;chara bank change
		EOR	#01H
		STA	MPBANK
		LDA	#03H		;DMA start "ON" !!
		STA	MPWDMAFG
;
		M8
;
;------------------------------------------------------------------------
;-		fade in/out end check					-
;------------------------------------------------------------------------
MPPL047		EQU	$
		LDA	MPFADFG		; tF[hI ?
		BNE	MPPL048		;	NO -> MPPL048
;
;------------------------------------------------------------------------
;-		map spacial process check				-
;------------------------------------------------------------------------
		LDA	MPSPFLAG
		BEQ	MPPL080		;map spacial process ? ( no:MPPL080 )
;
;----------------------------------------------------------------
;-		map spacial process				-
;----------------------------------------------------------------
		JSR	MPSPACIAL
		BRA	MPPL080
;
;----------------------------------------------------------------
;-		fade in/out					-
;----------------------------------------------------------------
MPPL048		EQU	$
		LDA	!FADMK
		ASL	A
		TAX
;
		M16
;
		LDA	MPFADB
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	MPFADG
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	MPFADR
		CMP	!FADCP,X
;
		M8
;
		BNE	MPPL080		;fade end ? ( no:MPPL080 )
;
;----------------------------------------------------------------
;-		fade end check					-
;----------------------------------------------------------------
		STZ	MPFADFG		;map fade in/out flag "OFF" !!
		LDA	FADMK
		TAX
		LDA	MPFAD_DAT,X
		STA	!FADNO
		TXA
		EOR	#01H
		STA	FADMK
		BNE	MPPL080
		LDA	!MP_MODE_BF
		STA	!MODENO
;
MPPL080		EQU	$
		PLB
		RTL
;
MPFAD_DAT	EQU	$
		HEX	00F,000
;
;****************************************************************
;		map bitmap OBJ move				*
;****************************************************************
MPMVOBSB	EQU	$-2
MV_KUMO		WORD	KUMOMOV		;kumo
MV_SMOK		WORD	SMOKMOV		;kazan smoke
MV_KAMO		WORD	KAMOMOV		;kamome
MV_PLAY		WORD	PLAYMOV		;player
MV_PTPT		WORD	PATA_PATA	;
MV_TORI		WORD	KOUNO_TORI	;REmg㏸
;
M_KUMO		EQU	MV_KUMO-MPMVOBSB
M_SMOK		EQU	MV_SMOK-MPMVOBSB
M_KAMO		EQU	MV_KAMO-MPMVOBSB
M_PLAY		EQU	MV_PLAY-MPMVOBSB
M_PTPT		EQU	MV_PTPT-MPMVOBSB
M_TORI		EQU	MV_TORI-MPMVOBSB
;
;
MPMVOBJ		EQU	$
		LDY	#(MPMVOBN-1)*4
MPMO010		EQU	$
		LDX	MPMVOBJNO,Y
		BEQ	MPMO030		;move ? ( no:MPMO030 )
;
		LDA	MPMVOBTM0,Y	;timer set
		BEQ	MPMO020
		DEC	A
		STA	MPMVOBTM0,Y
MPMO020		EQU	$
		JSR	(!MPMVOBSB,X)	;type select
;
MPMO030		EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	MPMO010
		RTS
;
;----------------------------------------------------------------
;		kumo move					-
;----------------------------------------------------------------
KUMOMOV		EQU	$
		STZ	<WORK		;(WK0) <-- center X pos
		STZ	<WORK+1		;(WK1) <--    "   Y  "
		LDA	MPMVOBWK0,Y	;(A) <-- angle
		INC	A
		STA	MPMVOBWK0,Y
		LDX	#40H		;(X) <-- R
		JMP	ROTCALC		;rotation caluclate
;
;----------------------------------------------------------------
;		kazan smoke move				-
;----------------------------------------------------------------
MPSMKXP		EQU	$
		HEX	00,00,00,FF,00,01
		HEX	01,00,FF,FF,00,01
		HEX	00
;;;;K;;;;		HEX	12,12,12,11,11,12
;;;;K;;;;		HEX	13,13,12,11,11,12
;;;;K;;;;		HEX	12
MPSMKZP		EQU	$
		HEX	00,00,00,FF,00,01
		HEX	01,00,FF,FF,00,01
		HEX	00
;;;;K;;;;		HEX	52,52,52,51,51,52
;;;;K;;;;		HEX	53,53,52,51,51,52
;;;;K;;;;		HEX	53
MPSMKPT		EQU	$
		BYTE	SMOKE_1,SMOKE_2,SMOKE_3,SMOKE_3,SMOKE_3,SMOKE_3
		BYTE	SMOKE_3,SMOKE_3,SMOKE_3,SMOKE_4,SMOKE_5,SMOKE_6
		BYTE	SMOKE_7
SMKMX		EQU	MPSMKZP-MPSMKXP
;
SMOKMOV		EQU	$
		LDA	MPPLYPS,Y	;smoke Y pos set
		INC	A
		INC	A
		STA	MPPLYPS,Y
		LDX	MPMVOBWK0,Y
		INX
		CPX	#SMKMX
		BCC	SMKM010
		LDX	#00
		LDA	#1AH
		STA	MPPLYPS,Y	;smoke Y pos reset
SMKM010		EQU	$
		TXA
		STA	MPMVOBWK0,Y
		LDA	!MPPLXPS,Y
		CLC
		ADC	MPSMKXP,X
		STA	!MPPLXPS,Y	;smoke X pos set
		LDA	!MPPLZPS,Y
		CLC
		ADC	MPSMKZP,X
		STA	!MPPLZPS,Y	;  "   Z    "
		LDA	MPSMKPT,X
		STA	!MPPLTYP,Y	;pattern no. set
		RTS
;
;----------------------------------------------------------------
;		kamome move					-
;----------------------------------------------------------------
KAMOPT		EQU	$
		BYTE	KAMO_1,KAMO_2,KAMO_3,KAMO_4,KAMO_5,KAMO_6,KAMO_7,KAMO_8
KAMOPTE		EQU	$
KAMMX		EQU	KAMOPTE-KAMOPT
;
KAMOMOV		EQU	$
		LDX	MPMVOBWK1,Y
		INX
		CPX	#KAMMX
		BCC	KAMM010
		LDX	#00
KAMM010		EQU	$
		TXA
		STA	MPMVOBWK1,Y
		LDA	!KAMOPT,X
		STA	MPPLTYP,Y
		LDA	#0B6H
		STA	<WORK		;(WK0) <-- center X pos
		LDA	#0F0H
		STA	<WORK+1		;(WK1) <--    "   Y  "
		LDA	MPMVOBWK0,Y	;(A) <-- angle
		CLC
		ADC	#4
		STA	MPMVOBWK0,Y
		LDX	#010H		;(X) <-- R
		JMP	ROTCALC		;rotation caluclate
;
;--------------------------------------------------------
;-		rotation caluclate			-
;-			in  : (WK0) <-- center X pos	-
;-			      (WK1) <--	   "   Z  "	-
;-			      (A)   <-- angle		-
;-			      (X)   <-- R		-
;--------------------------------------------------------
ROTCALC		EQU	$
		STX	<WORK+2
;
		MI16
;
		AND	#00FFH
		ASL	A
		TAX
		LDA	>COS,X
		STA	<WORK+3
		BPL	ROTCL010
		EOR	#0FFFFH
		INC	A
ROTCL010	EQU	$
		CMP	#0100H
;
		M8
;
		BCS	ROTCL020	;1.0 ? ( yes:ROTCL020 )
;
		STA	4202H
		LDA	<WORK+2
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A		;(C) <-- 0.5
		LDA	4217H
		ADC	#0
		BRA	ROTCL030
;
ROTCL020	EQU	$
		LDA	<WORK+2
ROTCL030	EQU	$
		BIT	<WORK+4
		BPL	ROTCL040
		EOR	#0FFH
		INC	A
ROTCL040	EQU	$
		CLC
		ADC	<WORK
		STA	MPPLXPS,Y
;
		M16
;
		LDA	>SIN,X
		STA	<WORK+3
		BPL	ROTCL050
		EOR	#0FFFFH
		INC	A
ROTCL050	EQU	$
		CMP	#0100H
;
		M8
;
		BCS	ROTCL060	;1.0 ? ( yes:ROTC060 )
;
		STA	4202H
		LDA	<WORK+2
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A		;(C) <-- 0.5
		LDA	4217H
		ADC	#0
		BRA	ROTCL070
;
ROTCL060	EQU	$
		LDA	<WORK+2
ROTCL070	EQU	$
		BIT	<WORK+4
		BPL	ROTCL080
		EOR	#0FFH
		INC	A
ROTCL080	EQU	$
		CLC
		ADC	<WORK+1
		STA	MPPLZPS,Y
;
		I8
;
		RTS
;
;----------------------------------------------------------------
;		player move					-
;----------------------------------------------------------------
;-------------- player move angle add data ----------------------
MPPLANAD	EQU	$
		BYTE	0FFH,001H	;[00][01]
		BYTE	0FCH,004H	;[02][03]
;
MPLCHPT		EQU	$
		BYTE	PLAYER_01,PLAYER_06,PLAYER_11,PLAYER_16,PLAYER_21,PLAYER_26,PLAYER_31,PLAYER_36	 ;[ stop ]
		BYTE	PLAYER_02,PLAYER_07,PLAYER_12,PLAYER_17,PLAYER_22,PLAYER_27,PLAYER_32,PLAYER_37	 ;[walk.1]
		BYTE	PLAYER_03,PLAYER_08,PLAYER_13,PLAYER_18,PLAYER_23,PLAYER_28,PLAYER_33,PLAYER_38	 ;[  " .2]
		BYTE	PLAYER_04,PLAYER_09,PLAYER_14,PLAYER_19,PLAYER_24,PLAYER_29,PLAYER_34,PLAYER_39	 ;[  " .3]
		BYTE	PLAYER_05,PLAYER_10,PLAYER_15,PLAYER_20,PLAYER_25,PLAYER_30,PLAYER_35,PLAYER_40	 ;[  " .4]
		BYTE	PLAYER_02,PLAYER_07,PLAYER_41,PLAYER_17,PLAYER_22,PLAYER_27,PLAYER_45,PLAYER_37	 ;[  " .5]
		BYTE	PLAYER_03,PLAYER_08,PLAYER_42,PLAYER_18,PLAYER_23,PLAYER_28,PLAYER_46,PLAYER_38	 ;[  " .6]
		BYTE	PLAYER_04,PLAYER_09,PLAYER_43,PLAYER_19,PLAYER_24,PLAYER_29,PLAYER_47,PLAYER_39	 ;[  " .7]
		BYTE	PLAYER_05,PLAYER_10,PLAYER_44,PLAYER_20,PLAYER_25,PLAYER_30,PLAYER_48,PLAYER_40	 ;[  " .8]
;
PLAYMOV		EQU	$
;
		M16
;
		STZ	MPBG3SP
;
		M8
;
		LDX	MPLMODE
		JSR	(!PLMVSB,X)
;
;-------------- player pos convert set --------------------------
		LDA	MPPLXPOS+1
		STA	MPPLXPS,Y	;map X pos set
		LDA	MPPLZPOS+1
		STA	MPPLZPS,Y	; "  Z    "
		LDA	MPPLYPOS+1
		STA	MPPLYPS,Y	; "  Y    "
;
;-------------- map rotation angle set --------------------------
		PHY			;(Y) save
;
		LDA	MPPLXPS,Y
		STA	<WORK0		;(WK0) <-- X size
		LDA	MPPLZPS,Y
		STA	<WORK1		;(WK1) <-- Z size
		JSR	ANGLCALC
		LDA	#0C0H
		SEC
		SBC	<WORK2
;
		LDX	TITLEFG
		BNE	PLMV002		;title map player hosei rotation ? ( no:PLMV002 )
;
;-------------- title map rotation set ------------------
		LDX	MPSPFLAG	;iwjOŁiPLMV010j
		BEQ	PLMV010		;demo rotation ? ( yes:PLMV010 )
;
;-------------- title map player hosei rotation -
		LDX	#03H
		SEC
		SBC	MPANGLE
		BNE	PLMV000		;hosei rotation end ? ( no:PLMV000 )
;
		INC	TITLEFG		;title flag "OFF" !!
		BRA	PLMV020
;
PLMV000		EQU	$
		BPL	PLMV001
		DEX
PLMV001		EQU	$
		PHA
		CLC
		ADC	#04H
		CMP	#04H*2+1
		PLA
		BCC	PLMV012
		BRA	PLMV010

;;;;		    CMP	    #0FCH
;;;;		    BCS	    PLMV012	    ;max speed over ? ( no:PLMV012 )
;;;;		    LDA	    #0FCH
;;;;		    BRA	    PLMV012
;
;-------------- game map roatation set ------------------
PLMV002		EQU	$
		LDX	#01H		;(X) <-- watch roatation
		CMP	MPANGLE
		BEQ	PLMV020		;angle change ? ( no:PLMV020 )
;
PLMV004		EQU	$
		BPL	PLMV010
		DEX			;(X) <-- not watch roatation
PLMV010		EQU	$
		LDA	!MPPLANAD,X
PLMV012		EQU	$
		PHA			;rotation speed save
		CLC
		ADC	MPANGLE
		STA	MPANGLE		;map rotation angle set
;
		PLA
		XBA
;
		M16
;
		AND	#0FF00H
		BPL	PLMV014
		ORA	#00FFH
PLMV014		EQU	$
		XBA
		STA	MPBG3SP		;BG3 scroll speed set
;
		M8
;
;-------------- player pattern no. set --------------------------
PLMV020		EQU	$
		PLY			;(Y) load
;
		LDA	!MPLMODE
		CMP	#PLFY
		BCS	PLMV900
;
		LDA	MPPLWLK
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK
		LDA	MPPLANG
		CLC
		ADC	MPANGLE
		CLC
		ADC	#020H/2
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK
		TAX
		LDA	!MPLCHPT,X
		STA	MPPLTYP,Y	;pattern no. set
PLMV900		EQU	$
		RTS
;
;
;
PLMVSB		EQU	$
		WORD	PLSTART		;course in [start] wait
PFLGON		WORD	MPMODINC	;	 "        walk ( initial )
		WORD	PLWALK0		;	   "           ( walk )
		WORD	SIRO_ZOOM_INT
		WORD	SIRO_ZOOM
		WORD	MAP_WAIT_TIMER
		WORD	SIRO_BOOM_INT
		WORD	SIRO_BOOM
		WORD	MAP_WAIT_TIMER
		WORD	SIRO_HATA_INT
		WORD	SIRO_HATA
		WORD	HATA_HATA
PL_FY		WORD	PL_FLY_UP
		WORD	PL_FLSH
W6_DEMO		WORD	PL_FLY_DWN
		WORD	WLD6_DEMO_INT
		WORD	WLD6_DEMO
;
;
PFGON		EQU	PFLGON-PLMVSB
PLFY		EQU	PL_FY-PLMVSB
W6_DM		EQU	W6_DEMO-PLMVSB
;
MPMODINC	EQU	$
		INC	MPLMODE
		INC	MPLMODE
		RTS
;
;----------------------------------------------------------------
;-		EFCg^C}[				-
;----------------------------------------------------------------
MAP_WAIT_TIMER	EQU	$
		M16			; memory 16bit mode
		DEC	!MAPWAIT
		BNE	MP_WT_TM_500
		INC	!MPLMODE
		INC	!MPLMODE
MP_WT_TM_500	EQU	$
		M8			; memory 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		course in [start] wait				-
;----------------------------------------------------------------
PLSTART		EQU	$
		STZ	MPPLWLK		;player walk pattern reset
;
		LDA	MPFADFG
		ORA	MPSPFLAG
		BNE	PST0020		;now fade in/out ? ( yes:PST0020 )
;
		LDA	TITLEFG		; title map ?
		BNE	PST0020		;	NO -> PST0020
;
;-------------- I[vjO f [v ^C}[ `FbN ------
		M16			; memory 16bit mode
		DEC	!OPDMLPTM
		M8			; memory 8bit mode
		LDA	!OPDMLPTM
		ORA	!OPDMLPTM+1
		BNE	PLSTART_000
		LDA	#D_01		; ~[WJ f X^[g !!
;;;;K;;;;		STA	!MODENO
		STA	!MP_MODE_BF
		INC	!MPFADFG
		RTS
;
;-------------- title start key check -------------------
PLSTART_000	EQU	$
		LDA	<KEYC1L
		AND	#11000000B
		ORA	<KEYC1
		AND	#11010000B	; t@Cj[  ?
		BEQ	PST0020		;	NO -> PST0020
;
;-------------- go to game map !! ---------------
		INC	MPSPFLAG
PST0020		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		 Y[					-
;----------------------------------------------------------------
SIRO_ZOOM_INT	EQU	$
		LDA	#00087H
		JSR	MAP_SOUND3	; sound set !!
		INC	!MPLMODE
		INC	!MPLMODE
SIRO_ZOOM	EQU	$
		MI16			; memory , index 16bit mode
		LDX	!MPFGONPT
		LDA	!MPWOBJSIZ,X
		CLC
		ADC	#00010H
		STA	!MPWOBJSIZ,X
		CMP	#001F0H
		BCC	SR_ZOM_800
		INC	!MPLMODE
		INC	!MPLMODE
		STZ	!MPFGONCT
		LDA	#010H
		STA	!MAPWAIT
		CPX	#TOWER5
		BNE	SR_ZOM_800
		LDA	#08AH		; j󂵂̓Vm.
		STA	!MPOBJTYP+6*4
SR_ZOM_800	EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		 						-
;----------------------------------------------------------------
SIRO_BOOM_INT	EQU	$
		LDA	#00099H
		JSR	MAP_SOUND3	; sound set !!
		INC	!MPLMODE
		INC	!MPLMODE
SIRO_BOOM	EQU	$
		LDA	<FRCNT
		AND	#001
		BNE	SR_BOM_990
		I16			; index 16bit mode
		LDX	!MPFGONPT
		LDA	!MPFGONCT
		PHA
		CLC
		ADC	#074H
		STA	!MPOBJTYP,X
		PLA
		LSR	A
		CLC
		ADC	!MPOBJYPS,X
		STA	!MPOBJYPS,X
		LDA	#000
		STA	!MPWOBJSIZ,X
;
		INC	!MPFGONCT
		LDA	!MPFGONCT
		CMP	#011
		BCC	SR_BOM_900
		LDA	#000
		STA	!MPOBJTYP,X
		LDA	#010H
		STA	!MAPWAIT
		INC	!MPLMODE
		INC	!MPLMODE
		STZ	!MPFGONCT
SR_BOM_900	EQU	$
		I8			; index 8bit mode
;
SR_BOM_990	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		 o						-
;----------------------------------------------------------------
SIRO_HATA_INT	EQU	$
		LDA	#00097H
		JSR	MAP_SOUND3	; sound set !!
		INC	!MPLMODE
		INC	!MPLMODE
SIRO_HATA	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MPTYPE
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!MPFGONCT
		CLC
		ADC	#07EH
		STA	!MPOBJTYP,X
		I8			; index 8bit mode
		INC	!MPFGONCT
		LDA	!MPFGONCT
		CMP	#010
		BCC	SR_HT_990
		INC	!MPLMODE
		INC	!MPLMODE
		STZ	!MPFGONCT
SR_HT_990	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		 ͂߂					-
;----------------------------------------------------------------
HATA_HATA	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MPTYPE
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!MPFGONCT
		AND	#003
		CLC
		ADC	#086H
		STA	!MPOBJTYP,X
		I8			; index 8bit mode
		INC	!MPFGONCT
		LDA	!MPFGONCT
		CMP	#030H
		BCC	HT_HT_990
		STZ	!MPFGONCT
		CPX	#014H
		BNE	HT_HT_800
		INC	!MPLMODE
		INC	!MPLMODE
		LDA	#08BH
		STA	!MPPLTYP
		LDA	!MPPLYPOS+1
		SEC
		SBC	#00CH
		STA	!MPPLYPOS+1
		BRA	HT_HT_990
;
HT_HT_800	EQU	$
		LDA	#M_PTPT
		STA	!MPMVOBJNO,X
		STZ	!MPLMODE
		CPX	#006*2*2
		BCC	HT_HT_850
		LDA	#M_TORI
		STA	!MPMVOBJNO+00FH*4
		STZ	!MPMVOBJNO
		BRA	HT_HT_990
HT_HT_850	EQU	$
		LDA	#HMPIN+1	;XN[}bv...
HT_HT_880	EQU	$
		STA	!MP_MODE_BF
		INC	!MPFADFG
HT_HT_990	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		v[[ tbV e to		-
;----------------------------------------------------------------
PL_FLY_UP	EQU	$
		M16			; memory 16bit mode
		LDA	!MPPLYPOS
		CLC
		ADC	#00080H
		STA	!MPPLYPOS
		M8			; memory 8bit mode
		LDA	!MPFGONCT
		CMP	#020H
		BCC	PL_FLSH
		INC	!MPLMODE
		INC	!MPLMODE
;
;----------------------------------------------------------------
;-		v[[ tbV				-
;----------------------------------------------------------------
PL_FLSH		EQU	$
		LDA	!MPFGONCT
		AND	#003H
		CLC
		ADC	#08CH
		STA	!MPPLTYP
		INC	!MPFGONCT
		LDA	!MPFGONCT
		CMP	#040H
		BCC	PL_FY_900
		LDA	#080H
		STA	!TITLEFG
		LDA	#MPIN+1		;]}bv...
;;;;K;;;;		STA	!MODENO
		STA	!MP_MODE_BF
		INC	!MPFADFG
PL_FY_900	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MPTYPE
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!MPFGONCT
		AND	#003
		CLC
		ADC	#086H
		STA	!MPOBJTYP,X
		I8			; index 8bit mode
		LDA	#0C0H
		STA	!PL_FRASH_FG
		RTS
;
;----------------------------------------------------------------
;-		v[[ tbV e cnvm		-
;----------------------------------------------------------------
PL_FLY_DWN	EQU	$
		LDA	#0C0H
		STA	!PL_FRASH_FG
		LDA	!MPFGONCT
		AND	#003H
		CLC
		ADC	#08CH
		STA	!MPPLTYP
		INC	!MPFGONCT
		M16			; memory 16bit mode
		LDA	!MPPLYPOS
		SEC
		SBC	#00100H
		STA	!MPPLYPOS
		XBA
		M8			; memory 8bit mode
		CMP	#010H
		BCS	PL_FY_DN_50
		STZ	!PL_FRASH_FG
		INC	!MPLMODE
		INC	!MPLMODE
		LDA	#08BH
		STA	!MPPLTYP
PL_FY_DN_50	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		n}bv f					-
;----------------------------------------------------------------
WLD6_DEMO_INT	EQU	$
		LDA	!MPPLYPOS+1
		CLC
		ADC	#00CH
		STA	!MPPLYPOS+1
		INC	!MPLMODE
		INC	!MPLMODE
;
;
WLD6_DEMO	EQU	$
		LDA	#PLAYER_21
		STA	!MPPLTYP
		M16			; memory 16bit mode
		LDA	!MPPLYPOS
		SEC
		SBC	#00080H
		STA	!MPPLYPOS
		BPL	WLD6_DM_900
		STZ	!MPPLYPOS
		STZ	!MPLMODE
		LDA	#HMPIN		;XN[}bv...
;;;;K;;;;		STA	!MODENO
		STA	!MP_MODE_BF
		INC	!MPFADFG
WLD6_DM_900	EQU	$
		M8			; memory 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		REmg					-
;----------------------------------------------------------------
TORI_ADR	EQU	$
		WORD	TORI_UP
		WORD	TORI_MAWAL
;
;
KOUNO_TORI	EQU	$
		LDX	!MPLMODE
		JSR	(TORI_ADR,X)
;
		LDX	!MPMVOBWK0,Y
		INX
		CPX	#KAMMX
		BCC	TORI_UP_010
		LDX	#00
TORI_UP_010	EQU	$
		TXA
		STA	!MPMVOBWK0,Y
		BNE	TORI_UP_020
		LDA	#09FH
		JSR	MAP_SOUND3
TORI_UP_020	EQU	$
		LDA	KAMOPT,X
		STA	!MPOBJTYP,Y
		LDA	#009H
		STA	<WORK0		;(WK0) <-- center X pos
		LDA	#016H
		STA	<WORK+1		;(WK1) <--    "   Y  "
		LDA	!MPMVOBWK1,Y	;(A) <-- angle
		CLC
		ADC	#4
		STA	!MPMVOBWK1,Y
;;;;K;;;;		LDX	#010H		;(X) <-- R
		LDX	<WORK10		;(X) <-- R
		JMP	ROTCALC		;rotation caluclate
;
;--------------------------------------------------------
;-		REmg㏸				-
;--------------------------------------------------------
TORI_UP		EQU	$
		LDA	!MPOBJYPS,Y
		INC	A
		STA	!MPOBJYPS,Y
		CMP	#040H
		BCC	TR_UP_500
		INC	!MPLMODE
		INC	!MPLMODE
TR_UP_500	EQU	$
		LSR	A
		CMP	#010H
		BCC	TR_UP_900
		LDA	#010H
TR_UP_900	EQU	$
		STA	<WORK10
		RTS
;
;--------------------------------------------------------
;-		REmg㏸				-
;--------------------------------------------------------
TORI_MAWAL	EQU	$
		LDA	#010H
		STA	<WORK10
		INC	!MPFGONCT
		LDA	!MPFGONCT
		CMP	#030H
		BCC	TR_MWL_900
		LDA	!MODENO
		INC	A
		STA	!MP_MODE_BF		; GfBO...
		INC	!MPFADFG
TR_MWL_900	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		go to next point walk				-
;----------------------------------------------------------------
PLWALK0		EQU	$
		LDA	MPFADFG
		BNE	PWK0070		;now fade in/out ? ( yes:PLYM0070 )
;
		LDA	MPMVOBWK0,Y
		BNE	PWK0050		;next walk point check ? ( no:PWK0050 )
;
;-------------- next walk set -----------------------------------
;
		I16			; index 16bit mode
;
		LDX	MPCLRPT
;
;-------------- walk point read -----------------
		LDA	>MPPLMVDT+1,X
		STA	MPGOTOXP	;go to next point X pos set
		LDA	>MPPLMVDT+2,X
		STA	MPGOTOZP	;	"         Z    "
		LDA	>MPPLMVDT+3,X
;
;-------------- next walk speed calculate ---------------
PWK0030		EQU	$
		STA	MPGOTOYP	;go to next point Y pos set
;
		I8			; index 8bit mode
;
		JSR	PWKCAL		;player walk speed calculate
;
;-------------- player pos move ---------------------------------
PWK0050		EQU	$
		JSR	PSCALC		;player pos calculate
;
;-------------- player walk pattern no. set ---------------------
		LDA	!MPPLWLK
		INC	A
		PHA
		AND	#003
		BNE	PWK0055
		LDA	#09BH
		STA	<SOUND_3	; sound set!!
PWK0055		EQU	$
		PLA
		CMP	#08H+1
		BCC	PWK0060
		LDA	#01H
PWK0060		EQU	$
		STA	!MPPLWLK
;
PWK0070		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		player walk speed calculate			-
;-			in  : (MPGOTOXP) <-- go to X pos	-
;-			      (MPGOTOZP) <--   "   Z  "		-
;-			      (MPGOTOYP) <--   "   Y  "		-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
PWKCAL		EQU	$
		PHY			;(Y) save
;
;-------------- player walk speed set -------------------
		LDA	MPGOTOXP
		SEC
		SBC	MPPLXPS,Y
		STA	<WORK3		;(WK3) <-- X move muki
		ABS8
		STA	<WORK4		;(WK4) <-- ABS( X move size )
		LDA	MPGOTOZP
		SEC
		SBC	MPPLZPS,Y
		STA	<WORK5		;(WK5) <-- Z move muki
		ABS8
		STA	<WORK6		;(WK6) <-- ABS( Z move size )
		LDA	MPGOTOYP
		SEC
		SBC	MPPLYPS,Y
		STA	<WORK7		;(WK7) <-- Z move muki
		ABS8
		STA	<WORK8		;(WK8) <-- ABS( Y move size )
;
		LDY	#04		;(Y) <-- big size index
		CMP	<WORK6
		BCS	PWCL010
		LDY	#02
		LDA	<WORK6
PWCL010		EQU	$
		CMP	<WORK4
		BCS	PWCL020
		LDY	#00
		LDA	<WORK4
PWCL020		EQU	$
		STA	MPGOTOCT	;walk counter set
		STY	<WORK9		;(WK9) <-- big size index
;
		LDX	#04
PWCL030		EQU	$
		CPX	<WORK9
		BNE	PWCL040		;big size index ? ( no:PWCL040 )
;
		M16
;
		LDA	#0200H
		BRA	PWCL050
;
		MEM8
;
PWCL040		EQU	$
		STZ	4204H		;div calculate
		LDA	<WORK4,X
		STA	4205H
		LDA	WORK4,Y
		STA	4206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
;
		M16
;
		LDA	4214H
		ASL	A		;[ 2dot/f ]
PWCL050		EQU	$
		BIT	<WORK3-1,X	;(N) set
		ABS16
		STA	MPPLXSPD,X	;speed set
;
		M8
;
		DEX
		DEX
		BPL	PWCL030
;
		STZ	MPPLXPOS	;speed(L) reset
		STZ	MPPLZPOS
		STZ	MPPLYPOS
;
;-------------- map rotation angle set ------------------
		LDA	<WORK3
		STA	<WORK0		;(WK0) <-- X size
		LDA	<WORK5
		STA	<WORK1		;(WK1) <-- Z size
		JSR	ANGLCALC
;
		PLY			;(Y) load
;
		STA	MPPLANG		;map player move angle set
;
		TYX
		INC	MPMVOBWK0,X	;walk flag "ON"
		RTS
;
;----------------------------------------------------------------
;		player pos calculate				-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
PSCALC		EQU	$
;
		M16
;
		LDX	#04
PSCL010		EQU	$
		LDA	MPPLXPOS,X	;X pos
		CLC
		ADC	MPPLXSPD,X
		STA	MPPLXPOS,X
		DEX
		DEX
		BPL	PSCL010
;
		M8
;
		DEC	MPGOTOCT
		DEC	MPGOTOCT
		BMI	PSCL020		;walk end ? ( yes:PSCL020 )
		BNE	PSCL040		;    "    ? ( no:PSCL040 )
;
;-------------- walk end check --------------------------
PSCL020		EQU	$
;
		I16
;
		LDX	MPCLRPT
		LDA	>MPPLMVDT+0,X
		BPL	PSCL030		;go to course in [start] wait ? ( no:PSCL030 )
;
;-------------- go to course in [start] wait ----
		INC	!MPLMODE
		INC	!MPLMODE
;
;-------------- course select BG display set ----
		JSR	CORSELON
;
;-------------- walk end player map pos reset ---
PSCL030		EQU	$
		INX
		INX
		INX
		INX
		STX	MPCLRPT		;next point index set
;
		I8
;
		TYX
		STZ	MPMVOBWK0,X	;walk flag "OFF"
;
		LDA	MPGOTOXP
		STA	MPPLXPOS+1	;map X pos set
		LDA	MPGOTOZP
		STA	MPPLZPOS+1	; "  Z    "
		LDA	MPGOTOYP
		STA	MPPLYPOS+1	;map Y pos set
PSCL040		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		angle calculate					-
;-			in  : (WK0)	<-- X size		-
;-			      (WK1)	<-- Y size		-
;-			out : (A),(WK2) <-- angle		-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
ANGLCALC	EQU	$
		LDX	#00H		;(X) <-- angle pos check data
		LDA	<WORK0
		BPL	ANCL010		;right ? ( yes:ANCL010 )
		LDX	#04H
		NEG8
ANCL010		EQU	$
		STA	<WORK2
		LDA	<WORK1
		BPL	ANCL020		;under ? ( yes:ANCL020 )
		INX
		INX
		NEG8
ANCL020		EQU	$
		LDY	<WORK2
		CMP	<WORK2
		BEQ	ANCL030		;Y =< X ? ( yes:ANCL030 )
		BCC	ANCL030		;	    "
		INX
		TAY
		LDA	<WORK2
ANCL030		EQU	$
		STZ	4204H		;div calculate
		STA	4205H
		STY	4206H
		STY	<WORK2		;(WK2,3) <-- div data
		STZ	<WORK3
;
		TXA
		ASL	A
		TAX
		NOP
		NOP
		NOP
		NOP
;
		MI16
;
		LDA	4216H
		ASL	A
		SEC
		SBC	<WORK2		;(C) <-- 0.5
		LDA	4214H		;(X) <-- div ans
		ADC	#0
		ASL	A
		TAY
		CPY	#(0100H+1)*2
		BCC	ANCL040
		LDY	#(0100H*2)
ANCL040		EQU	$
		LDA	>ANGCKD,X
		ASL	A		;(C) <-- NEG flag
		STA	<WORK2
		TYX
		LDA	>ATAN,X
		BCC	ANCL050
		NEG16
ANCL050		EQU	$
		CLC
		ADC	<WORK2
		LSR	A
;
		MI8
;
		STA	<WORK2
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		l`oʉZbg		x
;x			in			x
;x			A : sound NO.		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		MEM16
		IDX16
MAP_SOUND3	EQU	$
		PHY
		JSL	>SOUND_3_ON
		PLY
		RTS
;
		MEM8
		IDX8
;
;----------------------------------------------------------------
;-		 ͂߂					-
;----------------------------------------------------------------
PATA_PATA	EQU	$
		LDA	!MPMVOBWK0,Y
		CLC
		ADC	#086H
		STA	!MPPLTYP,Y
		LDA	!MPMVOBWK0,Y
		INC	A
		AND	#003
		STA	!MPMVOBWK0,Y
		RTS
;
;****************************************************************
;*		map spacial process				*
;*			in  : (A) <-- MPSPFLAG			*
;****************************************************************
MPSPACIAL	EQU	$
		ASL	A
		TAX
		JMP	(!MPSPSUB,X)
;
MPSPSUB		EQU	$-2		;[MPSPFLAG]
		WORD	MPSPSB00	;[1] title chara clear initial
		WORD	MPSPSB01	;[2]	     "         move
		WORD	MPSPSB01	;[3] z_[ chara set move
		WORD	MPSPSB03	;[4] return to game map wait
;
;----------------------------------------------------------------
;-		title chara clear initial			-
;----------------------------------------------------------------
CHCLRPNT	EQU	$		;[MPSPWK0]
		WORD	WORKBF+0000H	;[0]
		WORD	WORKBF+0800H	;[2]
		WORD	WORKBF+0001H	;[4]
		WORD	WORKBF+0801H	;[6]
		WORD	WORKBF+0000H	;[8]
		WORD	WORKBF+0800H	;[A]
		WORD	WORKBF+0001H	;[C]
		WORD	WORKBF+0801H	;[E]
;
MPSPSB00	EQU	$
		LDA	#0EH
MPSP00_010	EQU	$
		STA	MPSPWK0		;counter initial set
;
		INC	MPSPFLAG	;go to title chara clear move !!
;
;----------------------------------------------------------------
;-		title chara clear move				-
;----------------------------------------------------------------
MPSPSB01	EQU	$
		PHB			;(DBR) save
;
		LDY	MPSPWK0
;
		I16
;
		LDX	!CHCLRPNT,Y	;(X) <-- clear chara data start address
		STX	<WORK
;
		LDA	#BANK WORKBF	;(DBR) <-- WORKBF(B)
		PHA
		PLB
;
		CPY	#08H		;(C) <-- title chara clear or moji chara set ?
;
		LDY	#0400H/2
		BCC	MPSP01_020	;title chara clear ? ( no:MPSP01_020 )
;
;-------------- title chara clear -------------------------------
MPSP01_010	EQU	$
		STZ	0,X
		INX
		INX
		DEY
		BNE	MPSP01_010
		BRA	MPSP01_030
;
;-------------- moji chara set ----------------------------------
MPSP01_020	EQU	$
		LDA	400H,X
		STA	0,X
		INX
		INX
		DEY
		BNE	MPSP01_020
;
;-------------- chara write set ---------------------------------
MPSP01_030	EQU	$
		LDA	#BANK VRAMDX	;(DBR) <-- VRAMDX(B)
		PHA
		PLB
;
		M16
;
		LDX	VRAMDX
		LDA	#3800H
		STA	0,X		;VRAM address set
		LDA	<WORK
		STA	5,X		;A bus address(L,H) set
		LSR	A
		BCC	MPSP01_032
		INC	0,X		;VRAM address set [ 3C01H ]
MPSP01_032	EQU	$
		LDY	#00000000B+(18H*100H)
		AND	#0800H>>1
		BNE	MPSP01_040	;low chara set ? ( yes:MPSP01_040 )
		LDA	#10000000B
		LDY	#00000000B+(19H*100H)
MPSP01_040	EQU	$
		STA	2,X		;inc mode set
		TYA
		STA	3,X		;DMA parameter & B bus address set
		LDA	#BANK WORKBF
		STA	7,X		;A bus address(B) set
		LDA	#0400H-1
		STA	8,X		;number of byte set
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		STA	VRAMDX		;end address set
;
		MI8
;
		PLB
;
		DEC	MPSPWK0
		DEC	MPSPWK0
		BMI	MPSPINC		;return game map wait ? ( yes:MPSPINC )
;
		LDA	MPSPWK0
		CMP	#06H
		BNE	MPSP01_060	;title flag "OFF" timming ? ( no:MPSP01_060 )
;
		LDA	#11001110B
		STA	HD420C		;title H-DMA cancel !!
		LDA	#00010001B	;main select set
		STA	MANSEL
;
;-------------- go to course select screen write --------
MPSPINC		EQU	$
		INC	MPSPFLAG
;
MPSP01_060	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		return game map wait				-
;----------------------------------------------------------------
MPSPSB03	EQU	$
		LDA	TITLEFG
		BEQ	MPSP03_030	;return game map ? ( no:MPSP03_030 )
		BMI	MPSP03_030
		LDA	MPBANK
		EOR	#01H
		BNE	MPSP03_030	;OBJ chara area ok ? ( no:MPSP03_030 )
;
;-------------- return game map ---------------------------------
		STA	MPBANK		;chara bank change cancel !!
		STZ	MPWDMAFG	;DMA start "OFF" !!
		STZ	MPBG3SP		;BG3 scroll speed clear !!
		STZ	MPBG3SP+1	;BG3 scroll speed clear !!
;
;
;-------------- H-DMA change ----------------------------
		LDX	#04
MPSP03_010	EQU	$
		LDA	!MPHDMAP2_S,X
		STA	4350H,X
		LDA	!MPHDMAP3_S,X
		STA	4340H,X
		DEX
		BPL	MPSP03_010
;
		LDX	#HDMAPD6E-HDMAPD6-1
MPSP03_020	EQU	$
		LDA	!HDMAPD2_S,X
		STA	>HDMAPR2,X
		LDA	!HDMAPD3_S,X
		STA	>HDMAPR3,X
		DEX
		BPL	MPSP03_020
;
;------- t@C ZNg [h(LN^[cl`]) --
		JSR	FLSELECT_MOJ
;
;-------------- BG mode change --------------------------
		INC	MP_WINDOWS_FG	;lo|vhmcnvrX^[g
;
		LDA	#01000001B	;BG mode.1 set
		STA	BGMODE
		LDA	#00010111B	;main select set
		STA	MANSEL
		LDA	#030H		;BG1,BG2 screen base set
		STA	BG1SCF
		STA	BG2SCF
		LDA	#11H		;wiXN[JE^[Zbgg|cl`ύX
		STA	MP_BG3_BBUS
;
		M16
;
		STZ	<SCCH4		;BG mode.1 BG1 scroll counter set
		STZ	<SCCV4
		STZ	<SCCH2		;BG mode.1 BG2 scroll counter set
		LDA	#080H
		STA	<SCCV2
;
		M8
;
		LDA	#11111110B	;H-DMA "ON"
		STA	HD420C
;
		STZ	MPSPFLAG
;
MPSP03_030	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg CjV [`		*
;*								*
;****************************************************************
FLINTSET	EQU	$
		JSR	FILE_CHECK	;Z[ut@C `FbN !!
;
		JSR	FLINTSET_SUB
		LDA	>SLCT_FILE_NO
		TAX
		LDA	GOTOPTST_CMP,X
		STA	!ICONMV_X
		LDA	#03AH
		STA	!ICONMV_Y	; wJ[\ |Cg Zbg
;
		M16			; memory 16bit mode
		LDA	#0000EH		; LN^[
		STA	R9		; uq`l Zbg
		LDA	#BANK CMODE_DAT8
		STA	!CCWORK0
		LDA	#CMODE_DAT8
		STA	!CCWORK1
		M_CHIP	MPCHRVRMST
		M8			; memory 8bit mode
;
		LDA	#001H
		STA	!FLSLMD
		LDA	#006H
		STA	!KMRCLSCT
		STZ	!KMRCLSIDX
		RTS
;
;
CMODE_DAT8	EQU	$
		HEX	015H,015H,015H,015H,015H,015H
		HEX	015H,015H,015H,015H,015H,015H
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	t@C ZNg z_[ XN[ Zbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
FLINTSET_SUB	EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
		LDA	!HOLDERFG
		AND	#00001
		BEQ	FLINTSET_030
		LDX	#HOLDERBF1-HOLDERBF0
FLINTSET_030	EQU	$
		STX	<WORK10
;
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	FSATL_DAT,X
		STA	<WORK12		; Agr[g
;
		LDX	<WORK10
		LDY	#0007FH
		LDA	#021BFH
FLINTSET_010	EQU	$		; z_[ obt@ NA !!
		STA	!HOLDERBF0+000H,X
		STA	!HOLDERBF0+100H,X
		STA	!HOLDERBF0+200H,X
		INX
		INX
		DEY
		BPL	FLINTSET_010
;
		LDX	<WORK10
		LDY	#00000
FLINTSET_100	EQU	$		; {z_[ Zbg !!
		LDA	FLSET_DAT_UP0,Y
		ORA	<WORK12
		STA	!FLSLBUF00,X
		LDA	FLSET_DAT_UP1,Y
		ORA	<WORK12
		STA	!FLSLBUF01,X
		LDA	FLSET_DAT_MID,Y
		ORA	<WORK12
		STA	!FLSLBUF02,X
		STA	!FLSLBUF03,X
		STA	!FLSLBUF04,X
		STA	!FLSLBUF05,X
		STA	!FLSLBUF06,X
		STA	!FLSLBUF07,X
		STA	!FLSLBUF08,X
		STA	!FLSLBUF09,X
		STA	!FLSLBUF0A,X
		LDA	FLSET_DAT_DWN,Y
		ORA	<WORK12
		STA	!FLSLBUF0B,X
		INX
		INX
		INY
		INY
		CPY	#FLSET_DAT_UP1-FLSET_DAT_UP0
		BCC	FLINTSET_100
;
		LDX	<WORK10
		LDY	#00000
FLINTSET_120	EQU	$		; [h ACR x^
		LDA	FSMD_DAT_UP,Y
		STA	!FSMDBUF00,X
		LDA	FSMD_DAT_MID,Y
		STA	!FSMDBUF01,X
		STA	!FSMDBUF02,X
		STA	!FSMDBUF03,X
		STA	!FSMDBUF04,X
		STA	!FSMDBUF05,X
		STA	!FSMDBUF06,X
		STA	!FSMDBUF07,X
		LDA	FSMD_DAT_DWN,Y
		STA	!FSMDBUF08,X
		INX
		INX
		INY
		INY
		CPY	#FSMD_DAT_MID-FSMD_DAT_UP
		BCC	FLINTSET_120
;
		LDX	<WORK10
		LDY	#00000
FLINTSET_140	EQU	$		; t@C Zbg !!
		LDA	FS_FLNM_DT0,Y
		ORA	<WORK12
		STA	!FSNMBF00,X
		LDA	FS_FLNM_DT1,Y
		ORA	<WORK12
		STA	!FSNMBF01,X
		LDA	FS_FLNM_DT2,Y
		ORA	<WORK12
		STA	!FSNMBF02,X
		INX
		INX
		INY
		INY
		CPY	#FS_FLNM_DT1-FS_FLNM_DT0
		BCC	FLINTSET_140
;
		LDA	!HOLDERFG
		AND	#00001
		XBA
		LSR	A
		STA	<WORK2
;
		LDX	<WORK10
		LDY	#0000DH
		LDA	#02200H
		ORA	<WORK2
		ORA	<WORK12
		STA	<WORK0
FLINTSET_220	EQU	$		; [h Zbg !!
		LDA	<WORK0
		STA	!FSMDMSGBF00,X
		ORA	#00010H
		STA	!FSMDMSGBF01,X
		INC	<WORK0
		INX
		INX
		DEY
		BNE	FLINTSET_220
;
		LDX	<WORK10
		LDY	#00010H
		LDA	#02220H
		ORA	<WORK2
		ORA	<WORK12
		STA	<WORK0
FLINTSET_240	EQU	$		; [h bZ[W Zbg !!
		LDA	<WORK0
		STA	!FSMSGBF00,X
		ORA	#00010H
		STA	!FSMSGBF01,X
		INC	<WORK0
		INX
		INX
		DEY
		BNE	FLINTSET_240
		LDA	<WORK0
		CLC
		ADC	#00010H
		STA	!FSMSGBF00,X
		ORA	#00010H
		STA	!FSMSGBF01,X
;
		I8			; index 8bit mode
;
		LDX	#000H
FLINTSET_600	EQU	$		; t@C ACR Zbg !!
		LDA	!FLSLTBL,X
		AND	#000FFH
		ASL	A
		TAY
		LDA	AICON_DTAD,Y
		ORA	AICON_DTATL,Y
		STA	<WORK0
		LDA	FLINTSET_DT,X
		CLC
		ADC	<WORK10
		STA	<WORKA
		CLC
		ADC	#00040H
		STA	<WORKC
		CLC
		ADC	#00040H
		STA	<WORKE
		JSR	AICONSET_SUB	; ACR Zbg Tu[`
		INX
		INX
		CPX	#FLS_MD_ICN-FLINTSET_DT
		BCC	FLINTSET_600
;
		LDA	!FSHDFLG
		ASL	A
		ASL	A
		TAX
FLINTSET_650	EQU	$		; [h ACR Zbg !!
		LDA	FLS_MD_ICN,X
		STA	<WORK0
		TXA
		AND	#00002
		TAY
		LDA	FLS_MD_ADR,Y
		CLC
		ADC	<WORK10
		STA	<WORKA
		CLC
		ADC	#00040H
		STA	<WORKC
		CLC
		ADC	#00040H
		STA	<WORKE
		JSR	AICONSET_SUB	; ACR Zbg Tu[`
		INX
		INX
		TXA
		AND	#00002
		BNE	FLINTSET_650
;
		LDA	!HOLDERFG
		EOR	#00001H
		AND	#00001H
		STA	!HOLDERFG
;
		MI8			; memory , index  8bit mode
		RTS
;
;
FLSET_DAT_UP0	EQU	$
		WORD	021BFH,021BFH,02186H,0218FH,0218FH,0218FH,0218FH
		WORD	0218FH,0218FH,0218FH,0218FH,0218FH,0218FH,0218FH
		WORD	0218FH,0218FH,06186H,021BFH,021BFH,021BFH,021BFH
		WORD	021BFH,021BFH,021BFH
;
FLSET_DAT_UP1	EQU	$
		WORD	0A199H,0218FH,0218EH,0218EH,0218EH,0218EH,0218EH
		WORD	0218EH,0218EH,0218EH,0218EH,0218EH,0218EH,0218EH
		WORD	0218EH,0218EH,0218EH,0218FH,0218FH,0218FH,0218FH
		WORD	0218FH,0218FH,0E199H
;
FLSET_DAT_MID	EQU	$
		WORD	02198H,0218EH,0218EH,0218EH,0218EH,0218EH,0218EH
		WORD	0218EH,0218EH,0218EH,0218EH,0218EH,0218EH,0218EH
		WORD	0218EH,0218EH,0218EH,0218EH,0218EH,0218EH,0218EH
		WORD	0218EH,0218EH,06198H
;
FLSET_DAT_DWN	EQU	$
		WORD	021A1H,021AFH,021AFH,021AFH,021AFH,021AFH,021AFH
		WORD	021AFH,021AFH,021AFH,021AFH,021AFH,021AFH,021AFH
		WORD	021AFH,021AFH,021AFH,021AFH,021AFH,021AFH,021AFH
		WORD	021AFH,021AFH,061A1H
;
FSMD_DAT_UP	EQU	$
		WORD	0399FH,0398FH,0398FH,0398FH,0799FH
;
FSMD_DAT_MID	EQU	$
		WORD	03998H,0398EH,0398EH,0398EH,07998H
;
FSMD_DAT_DWN	EQU	$
		WORD	0B99FH,0B98FH,0B98FH,0B98FH,0F99FH
;
FS_FLNM_DT0	EQU	$
		WORD	0219AH,0219BH,0219CH,0219DH,0219EH
;
FS_FLNM_DT1	EQU	$
		WORD	0219AH,0219BH,0219CH,021BBH,021BCH
;
FS_FLNM_DT2	EQU	$
		WORD	0219AH,0219BH,0219CH,021BDH,021BEH
;
FSATL_DAT	EQU	$		; z_[ Agr[g
		WORD	00C00H,01000H,01400H
		WORD	01800H
;
FLINTSET_DT	EQU	$
		WORD	FSICNBF00,FSICNBF01,FSICNBF02
;
FLS_MD_ICN	EQU	$
		WORD	02C51H,0385AH	;Rs[,
		WORD	02C48H,0385AH	;j[,
		WORD	02C48H,02C51H	;j[,Rs[
;
FLS_MD_ADR	EQU	$
		WORD	FSMDICNBF00,FSMDICNBF01
;
AICON_DTAD	EQU	$
		WORD	02000H,02009H,02012H,0201BH,02024H,0202DH
		WORD	02036H,0283FH,02C48H,03451H,0385AH,03863H
;
AICON_DTATL	EQU	$
		WORD	01800H,01800H,01800H,01800H,01800H,01800H,01800H
;
;
;--------------------------------------------------------
;-		ACR Zbg Tu[`		-
;-			in				-
;-			work0,1 <- ACR f[^	-
;-			    a,b <- ACR		-
;-			    c,d <-   f[^ Zbg	-
;-			    e,f <-	AhX	-
;--------------------------------------------------------
		MEM16
AICONSET_SUB	EQU	$
		LDY	#00000H
AICONSUB_LOP	EQU	$
		TYA
		LSR	A
		CLC
		ADC	<WORK0
		STA	(<WORKA),Y
		INC	A
		INC	A
		INC	A
		STA	(<WORKC),Y
		INC	A
		INC	A
		INC	A
		STA	(<WORKE),Y
		INY
		INY
		CPY	#006H
		BCC	AICONSUB_LOP
		RTS
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ̃[h܂ NA ?		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
FLINTSET_SVAD	EQU	$
		WORD	SAVERAM0+2,SAVERAM1+2,SAVERAM2+2
;
FLINTSET_TBLAD	EQU	$
		WORD	FLSLTBL+0,FLSLTBL+2,FLSLTBL+4
;
;
FILE_CHECK	EQU	$
		M16			; memory 16bit mode
		LDA	#BANK FLSLTBL
		STA	<WORK10
;
		PHB
		LDX	#BANK SAVERAM0
		PHX
		PLB
		LDX	#000H
;
FILE_CHECK_10	EQU	$
		LDA	>FLINTSET_TBLAD,X
		STA	<WORKE
		LDA	>FLINTSET_SVAD,X
		STA	<WORK4
;
FILE_CHECK_30	EQU	$
		M8			; memory 8bit mode
		STZ	<WORK0
		LDA	(<WORK4)	; mdv Q[ ?
		BMI	FILE_CHECK_40	;	YES -> FILE_CHECK_40
;
FILE_CHECK_35	EQU	$
		INC	<WORK0
		SEC
		SBC	#012
		BPL	FILE_CHECK_35
;
FILE_CHECK_40	EQU	$
		LDA	<WORK0
		STA	[<WORKE]
		M16			; memory 16bit mode
		INX
		INX
		CPX	#FLINTSET_TBLAD-FLINTSET_SVAD
		BCC	FILE_CHECK_10
;
		PLB
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h (CjV̂)	*
;*			bZ[WLN^[ cl`]	*
;****************************************************************
FLSELECT_MOJ	EQU	$
		LDA	#BANK FLSL_MOJI_DT0
		STA	CCWORK11
		M16			; memory 16bit mode
		LDA	#FLSL_MOJI_DT0
		STA	CCWORK10
		LDA	#0000CH
		STA	CCWORK12	; x^ rbgJ[ Zbg
		LDA	#00008H
		STA	CCWORK13	; vbg rbgJ[ Zbg
;
		LDA	#00008H
		STA	CCWORK14	; x^ J[m.
		LDA	#00007H
		STA	CCWORK15	; pJ[m.
		LDA	#00009H
		STA	CCWORK16	; vbg rbgJ[m.
;
		M_CHIP	FLSLMDMN
;;;;K;;;;		M_CHIP	FLSLMOJ
;
		I16			; index 16bit mode
		LDA	!HOLDERFG
		AND	#00001
		ASL	A
		TAY
		LDA	FLSL_MOJI_ADR,Y
		TAY			;(Y) <-- uq`lAhX
		LDX	#MPBITMAP	;(X) <-- ]AhX (k,g)
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <- ]AhX (a)
		LDA	#00C00H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
		MI8			; memory , index 8bit mode
		RTS
;
FLSL_MOJI_ADR	EQU	$
		WORD	04800H,04000H
;
FLSL_MOJI_DT0	EQU	$
		BYTE	0FFH,010H,002H		;wx vbg X^[g |Cg
		BYTE	07AH,09BH,051H,08AH	; t@C
		BYTE	083H,071H,098H,0C9H	;	j[
		BYTE	0FFH,080H
		BYTE	0FFH,018H,012H		;wx vbg X^[g |Cg
		BYTE	037H,03BH,036H		; ǂ
		BYTE	000H,014H,03EH		;   
		BYTE	030H,012H,008H,0C6H	;	܂H
		BYTE	0FFH,0FFH	; end code
;
;
;************************************************************************
;*									*
;*		lo|vhmcnvr  uRDP				*
;*									*
;************************************************************************
;
		MEM8
		IDX8
;
MP_WINDOWS	EQU	$
;
		STZ	!OAMSUB
		STZ	!OAMSUB+1
		STZ	!CRSL_ON
		STZ	!CRSL_ON+1
		LDA	#0B5H
		STA	!SUBADF
;
		LDA	!FLSLMD		;t@Cj[ [h ?
		BEQ	MP_WINDOWS_200	;	NO -> MP_WINDOWS_200
		ASL	A
		TAX
		JSR	(FILESLMODE,X)
		BRA	MP_WINDOWS_900
;
MP_WINDOWS_200	EQU	$
		LDA	!CRS_IN_MD	; Q[ X^[g [h ?
		BEQ	MP_WINDOWS_400	;	NO -> MP_WINDOWS_200
		ASL	A
		TAX
		JSR	(GAME_START,X)
		JSR	FLAICN_OBJ
		BRA	MP_WINDOWS_900
;
MP_WINDOWS_400	EQU	$
		LDA	!COPYMD		;Rs[ [h ?
		BEQ	MP_WINDOWS_600	;	NO -> MP_WINDOWS_600
		ASL	A
		TAX
		JSR	(FILECPMODE,X)
		LDA	COPYMD
		CMP	#AICN_ZOM+1
		BCC	MP_WINDOWS_480
		CMP	#CP_END
		BCS	MP_WINDOWS_480
		JSR	COPY_AICNOBJ
MP_WINDOWS_480	EQU	$
		LDA	!COPYMD
		CMP	#CP_STAT
		BCC	MP_WINDOWS_900
		BRA	MP_WINDOWS_990
;
MP_WINDOWS_600	EQU	$
		LDA	!KILLMD		; [h ?
		BEQ	MP_WINDOWS_800	;	NO -> MP_WINDOWS_800
		ASL	A
		TAX
		JSR	(FILEKLMODE,X)
		LDA	!KILLMD
		CMP	#AICN_ZOM+1
		BCC	MP_WINDOWS_680
		CMP	#KL_END
		BCS	MP_WINDOWS_680
		JSR	COPY_AICNOBJ
MP_WINDOWS_680	EQU	$
		LDA	!KILLMD
		CMP	#KIL_SLCT
		BCC	MP_WINDOWS_900
		BRA	MP_WINDOWS_990
;
MP_WINDOWS_800	EQU	$
		LDA	!HLDRCHGMD	;z_[ `FW[hnm ?
		BEQ	MP_WINDOWS_900	;	NO -> MP_WINDOWS_900
		ASL	A
		TAX
		JSR	(HOLDER_CHANGE,X)
		LDA	!HLDRCHGMD
		BEQ	MP_WINDOWS_900
		JSR	FLAICN_OBJ
;
MP_WINDOWS_900	EQU	$
;
;-------------- }bvJ[\ IuWFZbg -----------
		JSR	MPCSLSET
;
MP_WINDOWS_990	EQU	$
		RTS
;
;
FILESLMODE	EQU	$-2		;t@Cj[
FILE_SELCT	EQU	$
		WORD	FLSLCRSLMV,GOTOPTST
MODE_CHANGE	EQU	$
		WORD	GOTOMDSL
AICON_ZOM	EQU	$
;
FL_SLT		EQU	(FILE_SELCT-FILESLMODE)/2
MD_CHNG		EQU	(MODE_CHANGE-FILESLMODE)/2
AICN_ZOM	EQU	(AICON_ZOM-FILESLMODE)/2
;
GAME_START	EQU	$-2		;Q[ X^[g
		WORD	AICNPSH_000,AICNPSH_100
		WORD	AICNPSH_200,AICNPSH_300
		WORD	AICNPSH_400
;
FILECPMODE	EQU	$-2		;Rs[
		WORD	FLCPCRSLMV,GOTOPTST
		WORD	GOTOMDSL
		WORD	AICNZOM_000,AICNZOM_100
		WORD	MOJI_0000,MOJI_0100
		WORD	MOJI_0200
		WORD	COPY_0000,GOTOPTST
COPY_PASS	EQU	$
		WORD	COPY_1000,MOJI_0000
		WORD	COPY_2000,MOJI_0200
		WORD	COPY_3000
COPY_START	EQU	$
		WORD	MOJI_0000,COPY_5000
		WORD	COPY_6000,COPY_7000
		WORD	COPY_8000,COPY_9000
		WORD	COPY_A000
COPY_END	EQU	$
		WORD	MOJI_0200
		WORD	COPY_B000,MOJI_0000
		WORD	COPY_C000,MOJI_0200
		WORD	COPY_D000
;
CP_PAS		EQU	(COPY_PASS-FILECPMODE)/2
CP_STAT		EQU	(COPY_START-FILECPMODE)/2
CP_END		EQU	(COPY_END-FILECPMODE)/2
;
FILEKLMODE	EQU	$-2		;
		WORD	FLCPCRSLMV,GOTOPTST
		WORD	GOTOMDSL
		WORD	AICNZOM_000,AICNZOM_100
KILL_SELECT	EQU	$
		WORD	MOJI_0000,MOJI_0100
		WORD	MOJI_0200
		WORD	KILL_0000,KILL_1000
KILL_PASS	EQU	$
		WORD	COPY_1000,MOJI_0000
		WORD	COPY_2000,MOJI_0200
		WORD	COPY_3000
KILL_START	EQU	$
		WORD	MOJI_0000,KILL_8000
		WORD	KILL_9000,KILL_A000
		WORD	KILL_B000,COPY_A000
KILL_END	EQU	$
		WORD	KILL_C000,MOJI_0200
		WORD	COPY_B000,MOJI_0000
		WORD	KILL_D000,MOJI_0200
		WORD	COPY_D000
;
KIL_SLCT	EQU	(KILL_SELECT-FILEKLMODE)/2
KL_PAS		EQU	(KILL_PASS-FILEKLMODE)/2
KL_STAT		EQU	(KILL_START-FILEKLMODE)/2
KL_END		EQU	(KILL_END-FILEKLMODE)/2
;
HOLDER_CHANGE	EQU	$-2		;z_[ `FW[h
		WORD	HOLDER_000,HOLDER_100
		WORD	HOLDER_200,HOLDER_300
		WORD	HOLDER_400,HOLDER_500
		WORD	HOLDER_600
;
HLDR_CHNG	EQU	(HOLDER_CHANGE-FILESLMODE)/2
;
;
;****************************************************************
;*								*
;*	t@C ZNg J[\ ړ `FbN		*
;*								*
;****************************************************************
FLSLCRSLMV_DT	EQU	$-1
		BYTE	001H,0FFH
;
;
FLSLCRSLMV	EQU	$
		LDA	<KEYC2
		AND	#003H		; EL[ nm ?
		BEQ	FLSLCRSLMV_200
		TAY
		LDA	!FLSLCSLPT
		CLC
		ADC	FLSLCRSLMV_DT,Y
		BMI	FLSLCRSLMV_090
		LDX	#057H
		STX	<SOUND_3	    ;[]
		CMP	#003
		BCS	FLSLCRSLMV_100
		STA	!FLSLCSLPT	; t@C ZNg
		INC	!FLSLMD
FLSLCRSLMV_090	EQU	$
		BRA	FLSLCRSLMV_900
;
;;;;K;;;;FLSLCRSLMV_090 EQU	$
;;;;K;;;;		LDA	#001
;;;;K;;;;		STA	<SOUND0		;[]
;;;;K;;;;		BRA	FLSLCRSLMV_900
;
FLSLCRSLMV_100	EQU	$
		LDA	#0C4H
		STA	!ICONMV_X
		LDA	#032H
		STA	!ICONMV_Y
		LDA	#MD_CHNG	; [h ZNg
		STA	!FLSLMD
		BRA	FLSLCRSLMV_900
;
FLSLCRSLMV_200	EQU	$
		LDA	<KEYC1L
		AND	#11000000B
		ORA	<KEYC1
		AND	#11010000B	; Q[ X^[g ?
		BEQ	FLSLCRSLMV_300	;	NO -> FLSLCRSLMV_300
		INC	!CRSL_ON
		STZ	!FLSLMD
		INC	!CRS_IN_MD
		LDA	#009H
		STA	<SOUND_3	    ;[]
;
FLSLCRSLMV_300	EQU	$
;
FLSLCRSLMV_900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	t@C̃Rs[ or f[g J[\ړ `FbN	*
;*								*
;****************************************************************
FLCPCRSLMV	EQU	$
		LDA	<KEYC2
		AND	#003H		; EL[ nm ?
		BEQ	FLCPCRSLMV_200	;	NO -> FLCPCRSLMV_200
		TAY
		LDA	!FLSLCSLPT
		STA	<WORK0
		CLC
		ADC	FLSLCRSLMV_DT,Y
		BMI	FLCPCRSLMV_090
		CMP	#003
		BCS	FLCPCRSLMV_100
		STA	!FLSLCSLPT	; t@C ZNg
		LDA	!FSHDFLG
		ASL	A
		TAX
		JSR	(GOTOMDSL_ADR,X)
		TXA
		BNE	FLCPCRSLMV_090
		LDA	!FLSLCSLPT
		CMP	#003
		BCS	FLCPCRSLMV_100
		LDA	#057H
		STA	<SOUND_3	    ;[]
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
		BRA	FLCPCRSLMV_900
;
FLCPCRSLMV_090	EQU	$
		LDA	<WORK0
		STA	!FLSLCSLPT	; t@C ZNg
		LDA	#057H
		STA	<SOUND_3	    ;[]
		BRA	FLCPCRSLMV_900
;
FLCPCRSLMV_100	EQU	$
		LDA	#0C4H
		STA	!ICONMV_X
		LDA	#032H
		STA	!ICONMV_Y
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	#MD_CHNG	; [h ZNg
		STA	!FLSLMD,X
		LDA	#057H
		STA	<SOUND_3	    ;[]
		BRA	FLCPCRSLMV_900
;
FLCPCRSLMV_200	EQU	$
		LDA	<KEYC1
		ORA	<KEYC1L		; "rs`qs" "`" "a"
		AND	#11010000B	; "w" "x" L[nm ?
		BEQ	FLCPCRSLMV_300	;	NO -> FLCPCRSLMV_300
		LDA	!FLSLCSLPT
		STA	!ORG_CSLPT
		INC	!CRSL_ON
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	#AICN_ZOM
		STA	!FLSLMD,X
		LDA	#009H
		STA	<SOUND_3	    ;[]
		BRA	FLCPCRSLMV_900
;
FLCPCRSLMV_300	EQU	$
;
FLCPCRSLMV_900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		J[\ ړ					*
;*								*
;****************************************************************
GOTOPTST_CMP	EQU	$
		BYTE	044H,06CH,094H
;
GOTOPTST_ADD	EQU	$
		BYTE	004H,0FCH
;
;
GOTOPTST	EQU	$
		LDX	!FLSLCSLPT
		LDA	!ICONMV_X
		CMP	GOTOPTST_CMP,X
		BEQ	GOTOPTST_900
		ROL	A
		AND	#001
		TAX
		LDA	!ICONMV_X
		CLC
		ADC	GOTOPTST_ADD,X
		STA	!ICONMV_X
		BRA	GOTOPTST_990
GOTOPTST_900	EQU	$
		LDA	!FSHDFLG
		ASL	A
		TAX
		DEC	!FLSLMD,X
GOTOPTST_990	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		[h ZNg J[\ ړ `FbN		*
;*								*
;****************************************************************
GOTOMDSL_SLCT	EQU	$
		BYTE	001H,002H	;j[
		BYTE	000H,002H	;Rs[
		BYTE	000H,001H	;
;
GOTOMDSL_ADR	EQU	$
		WORD	MENU_MODE_CK
		WORD	COPY_MODE_CK
		WORD	DEL_MODE_CK
;
GOTOMDSL_BAK	EQU	$
		BYTE	FL_SLT
		BYTE	FL_SLT
		BYTE	FL_SLT
;
GOTOMDSL_YPOS	EQU	$
		HEX	032H,052H
;
;
GOTOMDSL	EQU	$
		LDA	#002H
		STA	!FLSLCSLPT
		LDA	<KEYC2
		AND	#00CH		; ㉺L[ nm ?
		BEQ	GOTOMDSL_100	;	NO -> GOTOMDSL_100
		LDA	!FSUPDNFG
		EOR	#001
		AND	#001
		STA	!FSUPDNFG
		TAX
		LDA	GOTOMDSL_YPOS,X
		STA	!ICONMV_Y
		BRA	GOTOMDSL_270
;
GOTOMDSL_100	EQU	$
		LDA	<KEYC1
		ORA	<KEYC1L		; "rs`qs" "`" "a"
		AND	#11010000B	; "w" "x" L[nm@?
		BEQ	GOTOMDSL_200	;	NO -> GOTOMDSL_200
		STZ	!FLSLMD
		STZ	!COPYMD
		STZ	!KILLMD
		LDA	!FSHDFLG
		ASL	A
		ADC	!FSUPDNFG
		TAX
		LDA	GOTOMDSL_SLCT,X
		STA	!FSHDFLG	; [h `FW !!
		INC	!HLDRCHGMD	; z_[ `FW[h nm
		LDA	#009H
		BRA	GOTOMDSL_275
;
GOTOMDSL_200	EQU	$
		LDA	<KEYC2
		AND	#003		; EL[ nm ?
		BEQ	GOTOMDSL_900
		TAY
		AND	#001
		BNE	GOTOMDSL_900
		LDA	!FSHDFLG
		ASL	A
		TAX
		JSR	(GOTOMDSL_ADR,X)
		TXA
		BNE	GOTOMDSL_900
		LDX	!FLSLCSLPT
		LDA	GOTOPTST_CMP,X
		STA	!ICONMV_X
		LDA	#03AH
		STA	!ICONMV_Y
		LDA	!FSHDFLG
		TAX
		ASL	A
		TAY
		LDA	GOTOMDSL_BAK,X
		STA	!FLSLMD,Y
		STZ	!FSUPDNFG
GOTOMDSL_270	EQU	$
		LDA	#057H
GOTOMDSL_275	EQU	$
		STA	<SOUND_3	    ;[]
;
GOTOMDSL_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		j[ z_[ `FbN		+
;+				out			+
;+				X  0 : nj		+
;+				   1 : nts		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MENU_MODE_CK	EQU	$
		LDX	#000
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		Rs[ z_[ `FbN		+
;+				in			+
;+				Y <- `FbN	+
;+					P or Q	+
;+				out			+
;+				X  0 : nj		+
;+				   1 : nts		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COPY_MODE_CK	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
COPY_MODE_CK_LP EQU	$
		LDA	!FLSLTBL,X
		BEQ	DEL_MODE_CK
		TXA
		CLC
		ADC	FLSLCRSLMV_DT,Y
		CLC
		ADC	FLSLCRSLMV_DT,Y
		TAX
		BMI	DEL_MODE_CK
		CMP	#003*2
		BCC	COPY_MODE_CK_LP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		 z_[ `FbN			+
;+				in			+
;+				Y <- `FbN	+
;+					P or Q	+
;+				out			+
;+				X  0 : nj		+
;+				   1 : nts		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DEL_MODE_CK	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
DEL_MODE_CK_LP	EQU	$
		LDA	!FLSLTBL,X
		BNE	DEL_MODE_CK_50
		TXA
		CLC
		ADC	FLSLCRSLMV_DT,Y
		CLC
		ADC	FLSLCRSLMV_DT,Y
		TAX
		BMI	DEL_MODE_CK_90
		CMP	#003*2
		BCC	DEL_MODE_CK_LP
DEL_MODE_CK_50	EQU	$
		TXA
		LSR	A
		STA	!FLSLCSLPT
		LDX	#000
DEL_MODE_CK_90	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h			*
;*			(ACR vbV CjV Zbg)	*
;*								*
;****************************************************************
AICNPSH_000	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	#00100H
		STA	!SMZOMCT
;
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	!FLSLCSLPT
		AND	#00007H
		ASL	A
		TAY
		LDA	FLINTSET_DT,Y
		JSR	FLAICNCLS
		M8			; memory 8bit mode
;
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		JSR	AICN_PUSH_DMA
		INC	!CRS_IN_MD
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h			*
;*				(ACR vbV k )	*
;****************************************************************
AICNPSH_100	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		SEC
		SBC	#00008H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		CMP	#0C0H
		BCS	AICNPSH_150
		INC	!CRS_IN_MD
AICNPSH_150	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		JSR	AICN_PUSH_DMA
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h			*
;*				(ACR vbV g )	*
;****************************************************************
AICNPSH_200	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		CLC
		ADC	#00008H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		JSR	AICN_PUSH_DMA
		LDA	!SMZOMCT+1
		BEQ	AICNPSH_290
		LDA	#020H
		STA	!SMZOMCT	;EFCg ^C}[ JEg
		INC	!CRS_IN_MD
AICNPSH_290	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h			*
;*					(҂)		*
;****************************************************************
AICNPSH_300	EQU	$
		INC	!CRSL_ON
		DEC	!SMZOMCT
		BNE	AICNPSH_350
		INC	!CRS_IN_MD
AICNPSH_350	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		t@C ZNg [h			*
;*				(Q[ X^[g Zbg !!)	*
;****************************************************************
AICNPSH_400	EQU	$
		LDA	!FLSLCSLPT
		STA	>SLCT_FILE_NO
		ASL	A
		STA	!SVFILEIDX
;
		M16			; memory 16bit mode
		LDX	#012-2
		LDA	#000
AICNPSH_410	EQU	$
		STA	!AICONBF1,X
		STA	!AICONBF2,X
		STA	!AICONBF3,X
		STA	!AICONBF4,X
		STA	!AICONBF5,X
		STA	!AICONBF6,X
		DEX
		DEX
		BPL	AICNPSH_410
		LDA	#0F0F0H
		STA	!AICONBF1+08
		STA	!AICONBF2+08
		STA	!AICONBF3+08
		STA	!AICONBF4+08
		STA	!AICONBF5+08
		STA	!AICONBF6+08
		M8			; memory 8bit mode
;
		JSL	>SVDTLD		; Z[uf[^ kn`c
;
;;;;K;;;;		LDA	!MAPOINT	; mdvt@C X^[g ?
;;;;K;;;;		BPL	AICNPSH_420	;	NO -> AICNPSH_420
;;;;K;;;;		LDA	!MAPOINT
;;;;K;;;;		AND	#07FH
;;;;K;;;;		STA	!MAPOINT
;;;;K;;;;		JSL	>SVDTSV		; Z[uf[^ CjVZ[u
;
AICNPSH_420	EQU	$
		STZ	!WLD6_FLG
		LDA	!MAPOINT
		BMI	AICNPSH_423
		CMP	#012*(6-1)	;UvnqkcɂĂ邩 ?
		BCC	AICNPSH_423	;	NO -> AICNPSH_423
		INC	!WLD6_FLG
AICNPSH_423	EQU	$
;
;------------------------------------- test
sagi20		equ	$
		JMP	AICNPSH_490
		LDA	!FLSLCSLPT
		CMP	#002		;RԖڂ̃t@CZNg ?
		beq	AICNPSH_425
		jmp	AICNPSH_490	;	NO -> AICNPSH_490
;
AICNPSH_425	equ	$
		LDA	#099
		STA	YSCOIN
		LDA	<KEYC1L
		AND	#030H
		BEQ	CORSECLER_PASS
		LDA	#099
		STA	!PLCONT
;
CORSECLER_PASS	EQU	$
		LDX	#000H
		TXA
		INC	A
CORSECLER_LOP0	EQU	$		; ACe Zbg
		STA	!ITEMBUF,X
		INC	A
		CMP	#010
		BCC	CORSECLER_LOP00
		LDA	#001
CORSECLER_LOP00 EQU	$
		INX
		CPX	#027
		BCC	CORSECLER_LOP0
;
		LDA	#000H
		TAX
		TXY
		INC	A
CORSECLER_LOP1	EQU	$
		STA	!MPCLRTBL,Y
;;;;K;;;;		PHA
;;;;K;;;;		LDA	#000
;;;;K;;;;		STA	!HISCEBF,Y
;;;;K;;;;		PLA
		INY
		CPY	#012*6
		BCC	CORSECLER_LOP1
;
		LDA	#000H
		TAX
CORSECLER_LOP2	EQU	$
		INC	A
		PHA
		M16			; memory 16bit mode
		LDA	>AICONBF_dat0,X
		STA	<WORK0
		LDA	>AICONBF_dat1,X
		STA	<WORK2
		LDA	>AICONBF_dat2,X
		STA	<WORK4
		LDA	>AICONBF_dat3,X
		STA	<WORK6
		LDA	>AICONBF_dat4,X
		STA	<WORK8
		LDA	>AICONBF_dat5,X
		STA	<WORKA
		M8			; memory 8bit mode
		PLA
		STA	(<WORK0)
		STA	(<WORK2)
		STA	(<WORK4)
		STA	(<WORK6)
		STA	(<WORK8)
		STA	(<WORKA)
		INX
		INX
		CPX	#012*2
		BCC	CORSECLER_LOP2
;
		M16			; memory 16bit mode
		LDA	#00A09H
		STA	!AICONBF1+08
		STA	!AICONBF2+08
		STA	!AICONBF3+08
		STA	!AICONBF4+08
		STA	!AICONBF5+08
		STA	!AICONBF6+08
		M8			; memory 8bit mode
		LDA	#001
		STA	!FLSLTBL+4
;
AICNPSH_490	EQU	$
;------------------------------------- test
;
		LDA	#003
		STA	!PLCONT
		LDA	#HMPIN
		STA	!MODENO
		LDA	#0F1H
		STA	<SOUND_0
		LDA	#001
		STA	!FADMK
		STZ	!NTHLDRFG
		STZ	!NTHLDRFG+1
;;;;K;;;;		LDA	!MPCLRTBL
;;;;K;;;;		BPL	AICNPSH_499
		LDX	!SVFILEIDX
		LDA	!FLSLTBL,X	;mdvACR ?
		BNE	AICNPSH_499	;	NO -> AICNPSH_499
		LDA	#INT_GM
		STA	!MODENO
		STZ	!P_COLOR
AICNPSH_499	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		t@C ACR NA		+
;+			in				+
;+			A <- ACR AhX		+
;+			X <- z_[ Agr[g	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
FLAICNCLS_DAT	EQU	$
		WORD	HOLDERBF1,HOLDERBF0
;
		MEM16
;
FLAICNCLS	EQU	$
		LDY	!HOLDERFG
		BNE	FLAICNCLS_100
		CLC
		ADC	#HOLDERBF1-HOLDERBF0
FLAICNCLS_100	EQU	$
		STA	<WORK0
		CLC
		ADC	#00040H
		STA	<WORK2
		CLC
		ADC	#00040H
		STA	<WORK4
;
		LDY	#000
		LDA	#0218EH
		ORA	FSATL_DAT,X
FLAICNCLS_200	EQU	$
		STA	(<WORK0),Y
		STA	(<WORK2),Y
		STA	(<WORK4),Y
		INY
		INY
		CPY	#003*2
		BCC	FLAICNCLS_200
;
HLDER_DMA	EQU	$
		I16			; index 16bit mode
		LDA	!HOLDERFG
		AND	#00001
		ASL	A
		TAY
		LDA	#BANK HOLDERBF0
		STA	<WORK1		;(WK1) <-- ]AhXia)
		LDA	FLAICNCLS_DAT,Y
		TAX			;(X) <-- ]AhXik,g)
		LDY	#03020H		;(Y) <-- uq`lAhX
		LDA	#00300H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		I8			; index 8bit mode
		RTS
;
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		ACR vbV Zbg		+
;+				in			+
;+				A <- ACRm.	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
AICN_PUSH_DMA	EQU	$
		M16			; memory 16bit mode
		AND	#00FFH
		STA	R3		; ACRm.
		LDA	#015H
		STA	R1		; blncd m.
		LDA	!SMZOMCT
		STA	R6		; {
;
		M_CHIP	MPAICNZM
;
		I16			; index 16bit mode
		LDY	#07C80H		;(Y) <-- uq`lAhX
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <-- ]AhXia)
		LDX	#MPBITMAP	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07D80H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+200H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07E80H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+400H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07F80H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+600H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		MI8			; memory , index 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*			(ACR vbV CjV Zbg)	*
;*				(z_[ XN[ Zbg)	*
;****************************************************************
HOLDER_0ADR	EQU	$
		WORD	FSMDICNBF00,FSMDICNBF01
;
;
HOLDER_000	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	#00100H
		STA	!SMZOMCT
;
		LDA	!FSUPDNFG
		ASL	A
		TAY
		LDA	HOLDER_0ADR,Y
		LDX	#006
		JSR	FLAICNCLS
		M8			; memory 8bit mode
		STZ	!FSUPDNFG
;
		JSR	HOLDER_250
;
		JSR	FLINTSET_SUB
		MI16			; memory , index 16bit mode
		LDA	!HOLDERFG
		AND	#00001
		ASL	A
		TAY
		LDA	#BANK HOLDERBF0
		STA	<WORK1		;(WK1) <- ]AhXia)
		LDA	FLAICNCLS_DAT,Y
		TAX			;(X)   <- ]AhXik,g)
		LDY	#03220H		;(Y)   <- uq`lAhX
		LDA	#00300H		;(A)   <- ]oCg
		JSL	>VRAMDX_ST
		MI8			; memory , index 8bit mode
		INC	!HLDRCHGMD
		RTS
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				(ACR vbV k )	*
;****************************************************************
HOLDER_100	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		SEC
		SBC	#00008H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		CMP	#0C0H
		BCS	HOLDER_150
		INC	!HLDRCHGMD
HOLDER_150	EQU	$
		JSR	HOLDER_250
		RTS
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				(ACR vbV g )	*
;****************************************************************
MODEAICN_NO	EQU	$
		BYTE	08+012*7	;j[
		BYTE	09+012*7	;Rs[
		BYTE	10+012*7	;
;
;
HOLDER_200	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		CLC
		ADC	#00008H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!SMZOMCT+1
		BEQ	HOLDER_250
		INC	!HLDRCHGMD
HOLDER_250	EQU	$
		LDX	!FSHDFLG
		LDA	MODEAICN_NO,X
		JSR	AICN_PUSH_DMA
		RTS
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				([h Zbg)		*
;****************************************************************
HOLDER_300	EQU	$
		LDA	#BANK MODE_MOJI_DT0
		STA	CCWORK11
		M16			; memory 16bit mode
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	MODE_MOJI_DAT,X
		STA	CCWORK10
		LDA	#00008H
		STA	CCWORK14	; x^ J[m.
		LDA	#00007H
		STA	CCWORK15	; pJ[m.
		LDA	#00009H
		STA	CCWORK16	; vbg rbgJ[m.
;
		M_CHIP	FLSLMDMN
;
		I16			; index 16bit mode
		LDA	!HOLDERFG
		AND	#00001
		ASL	A
		TAY
		LDA	FLSL_MOJI_ADR,Y
		TAY			;(Y) <-- uq`lAhX
		LDX	#MPBITMAP	;(X) <-- ]AhX (k,g)
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <- ]AhX (a)
		LDA	#00400H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDA	!FSHDFLG
		ASL	A
		TAX
		JSR	(MSG_DSP_CHK,X)
		MI8			; memory , index 8bit mode
		INC	!HLDRCHGMD
		RTS
;
;
MSG_DSP_CHK	EQU	$
		WORD	SELECT_CK
		WORD	COPY_CK
		WORD	KILL_CK
;
MODE_MOJI_DAT	EQU	$
		WORD	MODE_MOJI_DT0,MODE_MOJI_DT1,FLSL_MOJI_DT2
;
;
MODE_MOJI_DT0	EQU	$
		BYTE	0FFH,010H,002H		;wx vbg X^[g |Cg
		BYTE	07AH,09BH,051H,08AH	; t@C
		BYTE	083H,071H,098H,0C9H	;	j[
		BYTE	0FFH,0FFH
;
MODE_MOJI_DT1	EQU	$
		BYTE	0FFH,013H,002H
		BYTE	07AH,09BH,051H,08AH	; t@C
		BYTE	05CH,093H,0C9H		;	Rs[
		BYTE	0FFH,0FFH
;
FLSL_MOJI_DT2	EQU	$
		BYTE	0FFH,013H,002H
		BYTE	07AH,09BH,051H,08AH	; t@C
		BYTE	00EH,00BH,012H		;	
		BYTE	0FFH,0FFH
;
		MEM16
		IDX16
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		ZNg[h			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SELECT_CK	EQU	$
		LDA	#FLSL
		STA	!FLS_MSG_NO
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		Rs[[h				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COPY_CK_DAT	EQU	$
		WORD	FLCP+2	;t@CɃf[^܂
		WORD	FLCP	;ǂRs[܂H
		WORD	FLCP	;ǂRs[܂H
		WORD	FLCP+8	;̃t@C܂
;
;
COPY_CK		EQU	$
		LDX	#00000H
		LDA	!FLSLTBL
		BEQ	COPY_CK_010
		INX
		INX
COPY_CK_010	EQU	$
		LDA	!FLSLTBL+2
		BEQ	COPY_CK_020
		INX
		INX
COPY_CK_020	EQU	$
		LDA	!FLSLTBL+4
		BEQ	COPY_CK_030
		INX
		INX
COPY_CK_030	EQU	$
		LDA	COPY_CK_DAT,X
		STA	!FLS_MSG_NO
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		f[g[h			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KILL_CK		EQU	$
		LDA	#FLKL
		STA	!FLS_MSG_NO
		LDA	!FLSLTBL
		ORA	!FLSLTBL+2
		ORA	!FLSLTBL+4
		BNE	KILL_CK_PAS
		INC	!FLS_MSG_NO
		INC	!FLS_MSG_NO
KILL_CK_PAS	EQU	$
		RTS
;
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				(bZ[W Zbg)		*
;****************************************************************
HOLDER_400	EQU	$
		JSR	MOJI_SET
		INC	!HLDRCHGMD
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MOJI_SET	EQU	$
		LDA	#BANK MSG_DAT0_00
		STA	CCWORK11
		M16			; memory 16bit mode
		LDX	!FLS_MSG_NO
		LDA	MSG_DAT_ADR,X
		STA	CCWORK10
		LDA	#0000CH
		STA	CCWORK12	; x^ rbgJ[ Zbg
		LDA	#00008H
		STA	CCWORK13	; vbg rbgJ[ Zbg
;
		M_CHIP	FLSLMOJ
;
		I16			; index 16bit mode
		LDA	!HOLDERFG
		AND	#00001
		ASL	A
		TAY
		LDA	FLSL_MOJI_ADR,Y
		CLC
		ADC	#00200H
		TAY			;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+0400H ;(X) <-- ]AhX (k,g)
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <- ]AhX (a)
		LDA	#00800H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
		MI8			; memory , index 8bit mode
		RTS
;
;
MSG_DAT_ADR	EQU	$
		WORD	MSG_DAT0_00
;
MSG_DAT_ADR_CP	EQU	$
		WORD	MSG_DAT1_00,MSG_DAT1_01,MSG_DAT1_02
		WORD	MSG_DAT1_03,MSG_DAT1_04
;
MSG_DAT_ADR_KL	EQU	$
		WORD	MSG_DAT2_00,MSG_DAT2_01,MSG_DAT2_02
		WORD	MSG_DAT2_03,MSG_DAT2_04,MSG_DAT2_05
;
FLSL	EQU	(MSG_DAT_ADR-MSG_DAT_ADR)
FLCP	EQU	(MSG_DAT_ADR_CP-MSG_DAT_ADR)
FLKL	EQU	(MSG_DAT_ADR_KL-MSG_DAT_ADR)
;
;
MSG_DAT0_00	EQU	$
		BYTE	0FFH,018H,012H
		BYTE	037H,03BH,036H		; ǂ
		BYTE	000H,014H,03EH		;   
		BYTE	030H,012H,008H,0C6H	;	܂H
		BYTE	0FFH,0FFH
;
MSG_DAT1_00	EQU	$
		BYTE	0FFH,014H,012H
		BYTE	037H,03BH,00EH		 ; ǂ
		BYTE	05CH,093H,0C9H		 ;   Rs[
		BYTE	011H,030H,012H,008H,0C6H ;	܂H
		BYTE	0FFH,0FFH
;
MSG_DAT1_01	EQU	$
MSG_DAT2_01	EQU	$
		BYTE	0FFH,003H,012H
		BYTE	07AH,09BH,051H,08AH,021H ; t@C
		BYTE	086H,0C9H,068H,015H	 ;  f[^
		BYTE	000H,039H,030H,013H,00FH ;   ܂
		BYTE	0FFH,0FFH
;
MSG_DAT1_02	EQU	$
		BYTE	0FFH,019H,012H
		BYTE	05CH,093H,0C9H		; Rs[
		BYTE	011H,048H,002H		;  イ
		BYTE	039H,049H,002H,0C7H	;   傤!
		BYTE	0FFH,0FFH
;
MSG_DAT1_03	EQU	$
		BYTE	0FFH,014H,012H
		BYTE	037H,00CH,021H		; ǂ
		BYTE	05CH,093H,0C9H		;  Rs[
		BYTE	011H,030H,012H,008H,0C6H ;  ܂H
		BYTE	0FFH,0FFH
;
MSG_DAT1_04	EQU	$
		BYTE	0FFH,00AH,012H
		BYTE	008H,038H,024H		 ; 
		BYTE	07AH,09BH,051H,08AH,015H ;  t@C
		BYTE	000H,039H,030H,013H,00FH ;   ܂
		BYTE	0FFH,0FFH
;
MSG_DAT2_00	EQU	$
		BYTE	0FFH,01CH,012H
		BYTE	037H,03BH,00EH		; ǂ
		BYTE	00BH,011H		;   
		BYTE	030H,012H,008H,0C6H	;     ܂H
		BYTE	0FFH,0FFH
;
MSG_DAT2_02	EQU	$
		BYTE	0FFH,00CH,012H
		BYTE	07CH,05FH,06CH,0C6H	; zgH
		BYTE	0FFH,041H,012H
		BYTE	028H,001H		; ͂
		BYTE	0FFH,061H,012H
		BYTE	001H,001H,003H		; 
		BYTE	0FFH,0FFH
;
MSG_DAT2_03	EQU	$
		BYTE	0FFH,009H,012H
		BYTE	0C4H			 ; w
		BYTE	057H,09AH,061H,0C9H,0A1H ; bV[P
		BYTE	0C5H			 ;  x
		BYTE	00EH			 ;  
		BYTE	00BH,011H,030H,011H,018H ;  ܂
		BYTE	0FFH,0FFH
;
MSG_DAT2_04	EQU	$
		BYTE	0FFH,009H,012H
		BYTE	0C4H			 ; w
		BYTE	057H,09AH,061H,0C9H,0A2H ; bV[Q
		BYTE	0C5H			 ;  x
		BYTE	00EH			 ;  
		BYTE	00BH,011H,030H,011H,018H ;  ܂
		BYTE	0FFH,0FFH
;
MSG_DAT2_05	EQU	$
		BYTE	0FFH,009H,012H
		BYTE	0C4H			 ; w
		BYTE	057H,09AH,061H,0C9H,0A3H ; bV[R
		BYTE	0C5H			 ;  x
		BYTE	00EH			 ;  
		BYTE	00BH,011H,030H,011H,018H ;  ܂
		BYTE	0FFH,0FFH
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				(EBhD CjVZbg)	*
;****************************************************************
HOLDER_500	EQU	$
		M16			; memory 16bit mode
		PHB
		LDX	#BANK MPHDMABF5
		PHX
		PLB
		LDX	#000
		LDA	#000FFH
HOLDER_520	EQU	$		; EBhD N[Y Zbg
		STA	!MPHDMABF5,X
		DEX
		DEX
		BNE	HOLDER_520
		PLB
		M8			; memory 8bit mode
;
		LDA	#013H
		STA	!WMANSL
		LDA	#002H
		STA	!WIND25
		STZ	!HLDRWDW
;;;;		    LDA	    #01CH
;;;;		    STA	    <SOUND0
		INC	!HLDRCHGMD
		RTS
;
;
;****************************************************************
;*								*
;*		z_[ `FW [h			*
;*				(EBhD I[v)		*
;****************************************************************
HOLDER_600	EQU	$
		M16			; memory 16bit mode
		LDA	!HLDRWDW
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	#0FF00H
		STA	>MPHDMABF5+0,X
		STA	>MPHDMABF5+2,X
		STA	>MPHDMABF5+4,X
		STA	>MPHDMABF5+6,X
		M8			; memory 8bit mode
		INC	!HLDRWDW
		LDA	!HLDRWDW
		CMP	#015H		; EBhD JI ?
		BCC	HOLDER_690	;	NO -> HOLDER_490
		MI16			; memory , index 16bit mode
		LDA	!HOLDERFG
		AND	#00001H
		ASL	A
		TAY
		LDA	#BANK HOLDERBF0
		STA	<WORK1		;(WK1) <-- ]AhXia)
		LDA	FLAICNCLS_DAT,Y
		TAX			;(X) <-- ]AhXik,g)
		LDY	#03020H		;(Y) <-- uq`lAhX
		LDA	#00300H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
		MI8			; memory , index 8bit mode
		STZ	!WMANSL
		STZ	!WIND25
		STZ	!HLDRCHGMD
		STZ	!FSUPDNFG
		LDA	GOTOMDSL_YPOS
		STA	!ICONMV_Y
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	#MD_CHNG
		STA	!FLSLMD,X
HOLDER_690	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		ACR Y[ [h				*
;*					(CjVZbg)	*
;****************************************************************
AICNZOM_000	EQU	$
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
;;;;		    LDA	    #00EH
;;;;		    STA	    <SOUND3
		M16			; memory 16bit mode
		LDA	#00100H
		STA	!SMZOMCT
		M8			; memory 8bit mode
;
;
;****************************************************************
;*								*
;*		ACR Y[ [h				*
;*					(ACR Y[)	*
;****************************************************************
AICNZOM_100	EQU	$
		INC	!CRSL_ON
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		CLC
		ADC	#00004H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!SMZOMCT
		CMP	#050H
		BCC	AICNZOM_150
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
		STZ	!FLSMJCNT
;;;;		    LDA	    #00CH
;;;;		    STA	    <SOUND0	    ;[]
;
AICNZOM_150	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		M16			; memory 16bit mode
		AND	#00FFH
		STA	R3		; ACRm.
		LDA	#015H
		STA	R1		; blncd m.
		LDA	!SMZOMCT
		STA	R6		; {
;
		M_CHIP	MPAICNZM
;
AICN_DMA	EQU	$
		I16			; index 16bit mode
		LDY	#07CC0H		;(Y) <-- uq`lAhX
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <-- ]AhXia)
		LDX	#MPBITMAP	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07DC0H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+200H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EC0H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+400H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07FC0H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+600H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		MI8			; memory , index 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*		[h 				*
;*								*
;****************************************************************
MOJI_0000	EQU	$
		M16			; memory 16bit mode
		LDA	#FSMSGBF00
		LDY	!HOLDERFG
		BNE	MOJI_0020
		CLC
		ADC	#HOLDERBF1-HOLDERBF0
MOJI_0020	EQU	$
		STA	<WORK0
		CLC
		ADC	#00040H
		STA	<WORK2
;
		I16			; index 16bit mode
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	!FLSMJCNT
		AND	#000FFH
		ASL	A
		TAY
		LDA	#0218EH
		ORA	FSATL_DAT,X
		STA	(<WORK0),Y
		STA	(<WORK2),Y
;
		JSR	HLDER_DMA
		MI8			; memory , index 8bit mode
;
		INC	!FLSMJCNT
		LDA	!FLSMJCNT
		CMP	#017
		BCC	MOJI_0040
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
;
MOJI_0040	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		[h 				*
;*					Zbg		*
;****************************************************************
MOJI_NO_CHK	EQU	$-2
		WORD	COPY_NO
		WORD	KILL_NO
;
;
MOJI_0100	EQU	$
		LDA	!FSHDFLG
		ASL	A
		TAX
		JSR	(MOJI_NO_CHK,X)
		JSR	MOJI_SET
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
		STZ	!FLSMJCNT
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	    Rs[[h `FbN		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COPY_NO		EQU	$
		LDA	#FLCP+3*2
		STA	!FLS_MSG_NO
		LDA	!FLSLTBL
		BEQ	COPY_NO_900
		LDA	!FLSLTBL+2
		BEQ	COPY_NO_900
		LDA	!FLSLTBL+4
		BEQ	COPY_NO_900
		INC	!FLS_MSG_NO
		INC	!FLS_MSG_NO
COPY_NO_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KILL_NO		EQU	$
		LDA	#FLKL+2*2
		STA	!FLS_MSG_NO
		RTS
;
;
;****************************************************************
;*								*
;*		[h 				*
;*								*
;****************************************************************
MOJI_0200	EQU	$
		M16			; memory 16bit mode
		LDA	#FSMSGBF00
		LDY	!HOLDERFG
		BNE	MOJI_0220
		CLC
		ADC	#HOLDERBF1-HOLDERBF0
MOJI_0220	EQU	$
		STA	<WORK0
		CLC
		ADC	#00040H
		STA	<WORK2
;
		LDA	!HOLDERFG
		EOR	#00001
		AND	#00001
		XBA
		LSR	A
		STA	<WORKE
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	!FLSMJCNT
		AND	#000FFH
		PHA
		ASL	A
		TAY
		PLA
		ADC	#02220H
		ORA	FSATL_DAT,X
		ORA	<WORKE
		STA	(<WORK0),Y
		ORA	#00010H
		STA	(<WORK2),Y
;
		I16			; index 16bit mode
		JSR	HLDER_DMA
		MI8			; memory , index 8bit mode
;
		INC	!FLSMJCNT
		LDA	!FLSMJCNT
		CMP	#016
		BCC	MOJI_0290
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
;
MOJI_0290	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				J[\ړ			*
;****************************************************************
COPY_0000	EQU	$
		LDA	<KEYC2
		AND	#003		; EL[ nm ?
		BEQ	COPY_0100	;	NO -> COPY_0100
		TAY
		LDA	!FLSLCSLPT
		CLC
		ADC	FLSLCRSLMV_DT,Y
		BMI	COPY_0050
		CMP	#003
		BCS	COPY_0050
		ASL	A
		TAX
COPY_0005	EQU	$
		LDA	FLSLTBL,X	;̃f[^ ?
		BEQ	COPY_0010	;	YES -> COPY_0010
		TXA
		LSR	A
		CMP	!ORG_CSLPT	;Rs[ACR̈ʒu ?
		BEQ	COPY_0010	;	YES -> COPY_0010
		TXA
		CLC
		ADC	FLSLCRSLMV_DT,Y
		CLC
		ADC	FLSLCRSLMV_DT,Y
		TAX
		BMI	COPY_0050
		CMP	#003*2
		BCS	COPY_0050
		BRA	COPY_0005
;
COPY_0010	EQU	$
		TXA
		LSR	A
		STA	!FLSLCSLPT
		LDA	#057H
		STA	<SOUND_3	    ;[]
		INC	!COPYMD
		BRA	COPY_0900
;
COPY_0050	EQU	$
;;;;		    LDA	    #001	    ;J[\ړ Xgbv !!
;;;;		    STA	    <SOUND0	    ;[]
		BRA	COPY_0900
;
COPY_0100	EQU	$
		LDA	<KEYC1
		ORA	<KEYC1L		; "rs`qs" "`" "a"
		AND	#11010000B	; "w" "x" L[nm@?
		BEQ	COPY_0900	;	NO -> COPY_0900
		STZ	!FLSMJCNT
		LDA	!FLSLCSLPT
		CMP	!ORG_CSLPT	;LZ ?
		BEQ	COPY_0150	;	YES -> COPY_0150
;;;;		    LDA	    #00CH
;;;;		    STA	    <SOUND0	    ;[]
		LDA	#CP_STAT
		STA	!COPYMD
		BRA	COPY_0900
COPY_0150	EQU	$
		LDA	#CP_PAS
		STA	!COPYMD
;;;;		    LDA	    #00EH
;;;;		    STA	    <SOUND3	    ;[]
;
COPY_0900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*		f[g[h					*
;*				LZ !!			*
;****************************************************************
COPY_1000	EQU	$
		LDA	!SMZOMCT
		SEC
		SBC	#004
		STA	!SMZOMCT
		BNE	COPY_1050
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
;;;;		    LDA	    #00CH
;;;;		    STA	    <SOUND0	    ;[]
;
COPY_1050	EQU	$
		JSR	AICNZOM_150
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*		f[g[h					*
;*				Zbg			*
;****************************************************************
MOJI_ORG	EQU	$-1
		BYTE	FLCP
		BYTE	FLKL
;
;
COPY_2000	EQU	$
		LDX	!FSHDFLG
		LDA	MOJI_ORG,X
		STA	!FLS_MSG_NO
		JSR	MOJI_SET
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
		STZ	!FLSMJCNT
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*		f[g[h					*
;*				LZ I (Rs[s)	*
;****************************************************************
COPY_3000	EQU	$
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	#001
		STA	!FLSLMD,X
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*			ACRNA  k CjVZbg *
;****************************************************************
COPY_5000	EQU	$
		M16			; memory 16bit mode
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	!FLSLCSLPT
		AND	#00007H
		ASL	A
		TAY
		LDA	FLINTSET_DT,Y
		JSR	FLAICNCLS
;
		LDA	#00100H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		INC	!COPYMD
;;;;		    LDA	    #01CH
;;;;		    STA	    <SOUND3	    ;[]
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				ACR k			*
;****************************************************************
COPY_6000	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		JSR	AICN_PUSH_DMA
;
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		SEC
		SBC	#00008
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!SMZOMCT
		CMP	#020H
		BCS	COPY_6050
		INC	!COPYMD
;
COPY_6050	EQU	$
		JSR	FLAICN_OBJ
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*			f[^ Rs[  g CjVZbg	*
;****************************************************************
COPY_7000	EQU	$
		JSL	>DATA_COPY
		LDA	!ORG_CSLPT
		ASL	A
		TAX
		LDA	!FLSLCSLPT
		ASL	A
		TAY
		LDA	!FLSLTBL,X
		STA	!FLSLTBL,Y
		INC	!COPYMD
;;;;		    LDA	    #00AH
;;;;		    STA	    <SOUND0
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*					ACR g		*
;****************************************************************
COPY_8000	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		JSR	AICN_PUSH_DMA
;
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		CLC
		ADC	#00008
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!SMZOMCT+1
		BEQ	COPY_8050
		INC	!COPYMD
;
COPY_8050	EQU	$
		JSR	FLAICN_OBJ
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				ACRz_[ɃZbg	*
;****************************************************************
COPY_9000	EQU	$
		JSR	AICON_SET
		JSR	FLAICN_OBJ
		M16			; memory 16bit mode
		LDA	#00150H
		STA	!SMZOMCT
		M8			; memory 8bit mode
;
		LDA	#FLCP+4
		STA	!FLS_MSG_NO
		JSR	MOJI_SET
;
;;;;		    LDA	    #00EH
;;;;		    STA	    <SOUND3	    ;[]
		INC	!COPYMD
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		ACRz_[ɃZbg		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
AICON_SET	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		ASL	A
		TAY
		M16			; memory 16bit mode
		LDA	AICON_DTAD,Y
		ORA	AICON_DTATL,Y
		STA	<WORK0
		LDA	FLINTSET_DT,X
		LDY	!HOLDERFG
		BNE	AICON_SET_10
		CLC
		ADC	#HOLDERBF1-HOLDERBF0
AICON_SET_10	EQU	$
		STA	<WORKA
		CLC
		ADC	#00040H
		STA	<WORKC
		CLC
		ADC	#00040H
		STA	<WORKE
		JSR	AICONSET_SUB	; ACR Zbg Tu[`
		JSR	HLDER_DMA
;
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*		f[g[h					*
;*				g債ĂACRɖ߂	*
;****************************************************************
COPY_A000	EQU	$
		JSR	AICNZOM_150
		M16			; memory 16bit mode
		LDA	!SMZOMCT
		SEC
		SBC	#00004
		STA	!SMZOMCT
		M8			; memory 8bit mode
		LDA	!SMZOMCT
		BNE	COPY_A050
		LDA	!FSHDFLG
		ASL	A
		TAX
		INC	!FLSLMD,X
		CPX	#002		; Rs[ [h
		BNE	COPY_A030	;	NO -> COPY_A030
		LDA	#032H
		STA	<SOUND_3
COPY_A030	EQU	$
		STZ	!FLSMJCNT
		STZ	!SMZOMCT
COPY_A050	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				I\ ҂		*
;****************************************************************
COPY_B_DAT	EQU	$-1
		BYTE	020H,040H
;
;
COPY_B000	EQU	$
		INC	!SMZOMCT
		LDA	!FSHDFLG
		TAY
		ASL	A
		TAX
		LDA	!SMZOMCT
		CMP	COPY_B_DAT,Y
		BCC	COPY_B050
		INC	!FLSLMD,X
;;;;		    LDA	    #00CH
;;;;		    STA	    <SOUND0	    ;[]
		STZ	!FLSMJCNT
		M16			; memory 16bit mode
		LDA	#032C4H
		STA	!ICONMV_X
		M8			; memory 8bit mode
COPY_B050	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				I\ 	*
;*					bZ[W Zbg	*
;****************************************************************
COPY_C000	EQU	$
		MI16			; memory , index 16bit mode
		JSR	COPY_CK
		MI8			; memory , index 8bit mode
		JSR	MOJI_SET
		STZ	!FLSMJCNT
		INC	!COPYMD
		RTS
;
;
;****************************************************************
;*								*
;*		Rs[ [h					*
;*				Rs[f[g[hI	*
;*					[hZNgɂǂ	*
;****************************************************************
COPY_D000	EQU	$
		LDA	!FSHDFLG
		ASL	A
		TAX
		LDA	#MD_CHNG
		STA	!FLSLMD,X
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*			͂  IuWF uq`lZbg *
;****************************************************************
KILL_0000	EQU	$
		LDA	#BANK YES_NO_DAT
		STA	CCWORK11
		M16			; memory 16bit mode
		LDA	#YES_NO_DAT
		STA	CCWORK10
		LDA	#0000CH
		STA	CCWORK12	; x^ rbgJ[ Zbg
		LDA	#00008H
		STA	CCWORK13	; vbg rbgJ[ Zbg
;
		M_CHIP	FLSLMOJ
;
		I16			; index 16bit mode
		LDY	#07E00H		;(Y) <-- uq`lAhX
		LDA	#BANK MPBITMAP
		STA	<WORK1		;(WK1) <-- ]AhXia)
		LDX	#MPBITMAP+400H	;(X) <-- ]AhX (k,g)
		LDA	#00100H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07F00H		;(Y) <-- uq`lAhX
		LDX	#MPBITMAP+600H	;(X) <-- ]AhX (k,g)
		LDA	#00100H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		MI8			; memory , index 8bit mode
		STZ	!YESNOFLG
		JSR	YESNO_OBJ
		INC	!KILLMD
		RTS
;
YES_NO_DAT	EQU	$
		BYTE	0FFH,000H,012H
		BYTE	028H,001H	; ͂
		BYTE	0FFH,020H,012H
		BYTE	001H,001H,003H	; 
		BYTE	0FFH,0FFH
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*				͂  ZNg		*
;****************************************************************
KILL_10_MDDT	EQU	$
		BYTE	KL_PAS	; LZ
		BYTE	KL_STAT ; f[g X^[g
;
;
KILL_1000	EQU	$
		LDA	<KEYC2
		AND	#003		; EL[ nm ?
		BEQ	KILL_1020	;	NO -> KILL_1020
		EOR	#003
		TAY
		LDA	!YESNOFLG
		CLC
		ADC	FLSLCRSLMV_DT,Y
		BMI	KILL_1090
		CMP	#002
		BCS	KILL_1090
		STA	!YESNOFLG
		LDA	#057H
		STA	<SOUND_3	    ;[]
		BRA	KILL_1090
;
KILL_1020	EQU	$
		LDA	<KEYC1
		ORA	<KEYC1L		; "rs`qs" "`" "a"
		AND	#11010000B	; "w" "x" L[nm@?
		BEQ	KILL_1090	;	NO -> KILL_1090
		LDX	!YESNOFLG
		LDA	KILL_10_MDDT,X
		STA	!KILLMD
		M16			; memory 16bit mode
		LDA	#00150H
		STA	!SMZOMCT
		M8			; memory 8bit mode
		STZ	!FLSMJCNT
		TXA
		BEQ	KILL_1025
		LDA	#009H
		STA	<SOUND_3	    ;[]
		BRA	KILL_1090
;
KILL_1025	EQU	$
;;;;		    LDA	    #00EH
;;;;		    STA	    <SOUND3	    ;[]
;
KILL_1090	EQU	$
		JSR	YESNO_OBJ
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*			f[g X^[g CjVZbg	*
;****************************************************************
KILL_8000	EQU	$
		STZ	!FSPLOT_X
		STZ	!FSPLOT_Y
		LDA	#012*7
		JSR	AICN_PUSH_DMA
		INC	!KILLMD
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*				XNb` CjVZbg	*
;****************************************************************
KILL_9000	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		CLC
		ADC	#012*7
		M16			; memory 16bit mode
		AND	#000FFH
		STA	R3		; ACRm.
		LDA	#015H
		STA	R1		; blncd m.
		LDA	!SMZOMCT
		STA	R6		; {
;
		M_CHIP	MPAICNZM
;
		M8			; memory 8bit mode
;
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		PHA
		PHX
		LDA	#000
		STA	!FLSLTBL,X
		JSR	AICON_SET	; "mdv" ACR Zbg
		PLX
		PLA
		STA	!FLSLTBL,X
		STZ	!FLSMJCNT
		STZ	!FSPLOT_X
		STZ	!FSPLOT_Y
		INC	!KILLMD
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*				XNb` X^[g (㔼)	*
;****************************************************************
KILL_A_ADD_X	EQU	$
		BYTE	0FFH,001H
;
KILL_A_ADD_Y	EQU	$
		BYTE	001H,0FFH
;
;
KILL_A000	EQU	$
		JSR	KILL_A_SUB
		JSR	KILL_A_SUB
		M16			; memory 16bit mode
		JSR	AICN_DMA
		M8			; memory 8bit mode
;
		LDA	!FLSMJCNT
		CMP	#011
		BCC	KILL_A070
		INC	!KILLMD
		STZ	!FLSMJCNT
		M16			; memory 16bit mode
		LDA	#01F1FH
		STA	!FSPLOT_X
		M8			; memory 8bit mode
		BRA	KILL_A100
KILL_A070	EQU	$
		LDA	#05AH
		STA	<SOUND_3	;[]
;
KILL_A100	EQU	$
		M16			; memory 16bit mode
		LDA	!FLSLCSLPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	COPY_AICNOBJ_DT,X
		AND	#0FFF8H
		CLC
		ADC	#00100H
		CLC
		ADC	!FSPLOT_X
		STA	!ICONMV_X
		M8			; memory 8bit mode
		JSR	MPCSLSET
		JSR	KILL_AICNOBJ
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		㔼				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KILL_A_SUB	EQU	$
		M16			; memory 16bit mode
		LDA	#00015H
		STA	R0		;blncd m.
		LDA	!FSPLOT_X
		AND	#000FFH
		STA	R3		;wW
		LDA	!FSPLOT_Y
		AND	#000FFH
		STA	R4		;xW
;
		M_CHIP	AICNCLS
;
		M8			; memory 8bit mode
;
		LDA	!FLSMJCNT
		AND	#001
		TAX
		LDA	!FSPLOT_X
		CLC
		ADC	KILL_A_ADD_X,X
		BPL	KILL_A050
		SEC
		SBC	KILL_A_ADD_X,X
		INC	!FSPLOT_Y
		INC	!FSPLOT_Y
		INC	!FLSMJCNT
KILL_A050	EQU	$
		STA	!FSPLOT_X
;
		LDA	!FSPLOT_Y
		CLC
		ADC	KILL_A_ADD_Y,X
		BPL	KILL_A060
		SEC
		SBC	KILL_A_ADD_Y,X
		INC	!FSPLOT_X
		INC	!FSPLOT_X
		INC	!FLSMJCNT
KILL_A060	EQU	$
		STA	!FSPLOT_Y
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*				XNb` X^[g (E)	*
;****************************************************************
KILL_B000	EQU	$
		JSR	KILL_B_SUB
		JSR	KILL_B_SUB
		M16			; memory 16bit mode
		JSR	AICN_DMA
		M8			; memory 16bit mode
;
		LDA	!FLSMJCNT
		CMP	#011
		BCC	KILL_B070
		INC	!KILLMD
		M16			; memory 16bit mode
		LDA	#00150H
		STA	!SMZOMCT
		M8			; memory 8bit mode
;;;;		    LDA	    #00EH
;;;;		    STA	    <SOUND3	    ;[]
		LDA	!FLSLCSLPT
		ASL	A
		TAX
		LDA	#000
		STA	!FLSLTBL,X
		BRA	KILL_B100
KILL_B070	EQU	$
		LDA	#05AH
		STA	<SOUND_3	;[]
;
KILL_B100	EQU	$
		M16			; memory 16bit mode
		LDA	!FLSLCSLPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	COPY_AICNOBJ_DT,X
		AND	#0FFF8H
		CLC
		ADC	#00100H
		CLC
		ADC	!FSPLOT_X
		STA	!ICONMV_X
		M8			; memory 8bit mode
		JSR	MPCSLSET
		JSR	KILL_AICNOBJ
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		E				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KILL_B_SUB	EQU	$
		M16			; memory 16bit mode
		LDA	#00015H
		STA	R0		;blncd m.
		LDA	!FSPLOT_X
		AND	#000FFH
		STA	R3		;wW
		LDA	!FSPLOT_Y
		AND	#000FFH
		STA	R4		;xW
;
		M_CHIP	AICNCLS
;
		M8			; memory 8bit mode
;
		LDA	!FLSMJCNT
		AND	#001
		TAX
		LDA	!FSPLOT_X
		CLC
		ADC	KILL_A_ADD_Y,X
		CMP	#020H
		BCC	KILL_B050
		SEC
		SBC	KILL_A_ADD_Y,X
		DEC	!FSPLOT_Y
		DEC	!FSPLOT_Y
		INC	!FLSMJCNT
KILL_B050	EQU	$
		STA	!FSPLOT_X
;
		LDA	!FSPLOT_Y
		CLC
		ADC	KILL_A_ADD_X,X
		CMP	#020H
		BCC	KILL_B060
		SEC
		SBC	KILL_A_ADD_X,X
		DEC	!FSPLOT_X
		DEC	!FSPLOT_X
		INC	!FLSMJCNT
KILL_B060	EQU	$
		STA	!FSPLOT_Y
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*				t@C̃bZ[WZbg*
;*				f[^ 폜 !!			*
;****************************************************************
KILL_C000	EQU	$
		LDA	!FLSLCSLPT
		ASL	A
		CLC
		ADC	#FLKL+003*2
		STA	!FLS_MSG_NO
		JSR	MOJI_SET
		STZ	!FLSMJCNT
;;;;		    LDA	    #00CH
;;;;		    STA	    <SOUND0	    ;[]
		STZ	!SMZOMCT
;
		M16			; memory 16bit mode
		LDA	!FLSLCSLPT
		AND	#0000FH
		ASL	A
		TAX
		LDA	#00000H
		STA	>RAMCHK0,X
		STA	>RAMCHK0_BAK,X
		M8			; memory 8bit mode
		JSL	>SVRMCK_INT
		INC	!KILLMD
		RTS
;
;
;****************************************************************
;*								*
;*		f[g[h					*
;*					bZ[W Zbg	*
;****************************************************************
KILL_D000	EQU	$
		MI16			; memory , index 16bit mode
		JSR	KILL_CK
		MI8			; memory , index 8bit mode
		JSR	MOJI_SET
		STZ	!FLSMJCNT
		INC	!KILLMD
		RTS
;
;
;****************************************************************
;*								*
;*		}bvJ[\ IuWFZbg			*
;*								*
;****************************************************************
MPCSLSET	EQU	$
		M16			; memory 16bit mode
		LDA	!ICONMV_X
		STA	!OAM
MPCSLSET_SET	EQU	$
		LDA	#039C0H
		STA	!OAM+2
		LDA	!CRSL_ON
		BEQ	MPCSLSET_PAS
		LDA	!OAM+2
		INC	A
		INC	A
		STA	!OAM+2
MPCSLSET_PAS	EQU	$
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*		͂@ IuWFZbg			*
;*					f[g[hp	*
;****************************************************************
YESNO_OBJ_ADR	EQU	$
		WORD	05C90H	;
		WORD	05C6BH	;͂
;
;
YESNO_OBJ	EQU	$
		M16			; memory 16bit mode
		LDA	!YESNOFLG
		AND	#00001
		ASL	A
		TAX
		LDA	YESNO_OBJ_ADR,X
		STA	!OAM
		BRA	MPCSLSET_SET
		MEM8
;
;
;****************************************************************
;*								*
;*		t@C ACR IuWFZbg		*
;*								*
;****************************************************************
FLAICN_OBJ_DAT	EQU	$
		WORD	037C8H	;ZNg
		WORD	037C8H	;Rs[
		WORD	03DC8H	;
;
;
FLAICN_OBJ	EQU	$
		LDA	!ICONMV_X
		SEC
		SBC	#010H
		STA	!OAM+8
		LDA	!ICONMV_Y
		SEC
		SBC	#017H
		STA	!OAM+9
		M16			; memory 16bit mode
		LDA	!FLSLCSLPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	!FLSLTBL,X
		ASL	A
		TAX
		LDA	AICON_DTATL,X
		LSR	A
		ORA	#031C8H
		STA	!OAM+10
		LDA	!HLDRCHGMD
		AND	#000FFH		;z_[ `FW[hnm ?
		BEQ	FLAICN_OBJ_PAS	;	NO -> FLAICN_OBJ_PAS
		LDA	!FSHDFLG
		AND	#00003
		ASL	A
		TAX
		LDA	FLAICN_OBJ_DAT,X
		STA	!OAM+10
FLAICN_OBJ_PAS	EQU	$
		M8			; memory 8bit mode
		LDA	!OAMSUB
		ORA	#00100000B
		STA	!OAMSUB
		RTS
;
;
;****************************************************************
;*								*
;*		t@CACR IuWFZbg			*
;*					ACRŒ		*
;****************************************************************
COPY_AICNOBJ_DT EQU	$
		WORD	02334H,0235CH,02384H
;
;
COPY_AICNOBJ	EQU	$
		M16			; memory 16bit mode
		LDA	!ORG_CSLPT
		ASL	A
		TAX
		LDA	COPY_AICNOBJ_DT,X
		STA	!OAM+4
		LDA	!FLSLTBL,X
		ASL	A
		TAX
		LDA	AICON_DTATL,X
		LSR	A
		ORA	#031CCH
		STA	!OAM+6
		M8			; memory 8bit mode
		LDA	!OAMSUB
		ORA	#00001000B
		STA	!OAMSUB
		RTS
;
;
;****************************************************************
;*								*
;*		t@CACR IuWFZbg			*
;*					ŒACR		*
;****************************************************************
KILL_AICNOBJ	EQU	$
		M16			; memory 16bit mode
		LDA	!FLSLCSLPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	COPY_AICNOBJ_DT,X
		STA	!OAM+8
		LDA	AICON_DTATL
		LSR	A
		ORA	#031C8H
		STA	!OAM+10
		M8			; memory 8bit mode
		LDA	!OAMSUB
		ORA	#00100000B
		STA	!OAMSUB
		RTS
;
;
;
;
		MEM8
		IDX8
;
;
;
;
;
		END
