;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: player					*
;*	file name	: ys_play					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_color.h
		include		ys_pld.h
		include		../union/ys_bgcheck.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	player_debug
;
		GLB	PLINIT,PLINIT_2,PLAYER,PLCSET,PLSCRL,PLCOLTR
		GLB	PSCRL_INIT,PLSCRL_INIT
		GLB	SCRL_CXY_SET
		GLB	BERO_CANCEL,BERO_CANCEL_2,TONNEL_INOUT_IN
		GLB	HERI_INITL,CAR_INITL
		GLB	TIMEUP_SET,TIMEUP_SET_S,TIMEUP_SET_SS
		GLB	PCOLTBL
		GLB	EGG_WARE_SET,PLTYPE_RAMCLR
		GLB	PMOV,PFAL,PCHG,PSTP,PGUS,PSHT,PGOL,PTTL,PRET,PDSC,PDKN
		GLB	PCLR,PDEM,PBSQ,PBQ7,PSDM,PBSC,PBNS,PEND,PYGN
		GLB	PFLP
;
		GLB	CHNGXPS,CHNGYPS
		GLB	PUSHPT,PUSHTM
;
		GLB	PO_NORMAL,PO_SKI,PO_DK_O_R,PO_DK_O_L,PO_DK_O_D,PO_DK_O_U
		GLB	PO_DK_I_R,PO_DK_I_L,PO_DK_I_D,PO_DK_I_U,PO_BSQ_M7
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	SOUND_3_ON
		EXT	MPIN,GMIN,TMUP,HMPIN
;
;-------------< ys_init >------------------------------------------------
		EXT	PL_COLBK
;
;-------------< ys_pldt >------------------------------------------------
		EXT	CHDTNO,CHDTIN,CHYPAD
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENINSR,ENINSR2,PLFLST,EGGKILL,ENCLEAR
		EXT	ENINSR_I,ENINSR2_I
		EXT	ENEAT_CANCEL
		EXT	PL_1UP_SET
		EXT	AUTO_SCROLL
		EXT	EINIT,EMOVE,EEATM,ENOSE,EFAIL,ECHNG
		EXT	ETBG0,MISA0,FIREX,SOPB0
		EXT	HBLK1,HBLK2,HBLK3,HBLK4,DWNBG,POLDR,BABYM
		EXT	DEATH,WATCH,WATKM,DRKEY
		EXT	EGOPAD
;
;-------------< ys_enmy3 >-----------------------------------------------
		EXT	GO_NEXTGOTO,GO_NEXTGOTO_2
		EXT	KINOMI_CANCEL
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXINSR
		EXT	WTUP0,WTUP1,BABL0,CCHG0,BRBG0,MSMK0,KIRA0,TRSMK
		EXT	SOPB1,SNOW0,SNOW1
		EXT	DOSN0,DUST0,DSMK0,DSMK1,AWABR
		EXT	SCORE,EGGWR
;
		EXT	BRSNOW,SKSNOW
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	UNITCHG
		EXT	BLK0,BGCG,DWCG
;
;-------------< ys_data >------------------------------------------------
		EXT	COSEDAT,UNDTADD
		EXT	SIN,COS
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ,CHIPON_SPECIAL
;
;-------------< ys_game >------------------------------------------------
		EXT	EGG_LOAD
;
;-------------< ys_start >-----------------------------------------------
		EXT	STT_PL_GO
;
;-------------< ys_mapdt >-----------------------------------------------
		EXT	INT_STAT
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
JPET		EQU	6
PUSHTM		EQU	10H	;side cross push wait timer
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_4		GROUP	Yossy_pro
Yossy_pro	SECT	REL
;
;
;------------------------------------------------------------------------
;-		side cross push pattern no. data			-
;------------------------------------------------------------------------
PUSHPT		EQU	$
		WORD	OS01,OS02,OS03,OS04,OS05
;
;
;************************************************************************
;*		player intial						*
;************************************************************************
PL_INIT_MODE	EQU	$
POUT_NORMAL	WORD	PMOV	;̏ŏo
POUT_SKI	WORD	PSKI	;XL[ŏo
PL_INIT_DOKN	EQU	$
POUT_DK_O_R	WORD	PDKN	;hJiOjE
POUT_DK_O_L	WORD	PDKN	;     h     
POUT_DK_O_D	WORD	PDKN	;     h     
POUT_DK_O_U	WORD	PDKN	;     h     
POUT_DK_I_R	WORD	PDKN	;hJijE
POUT_DK_I_L	WORD	PDKN	;     h     
POUT_DK_I_D	WORD	PDKN	;     h     
POUT_DK_I_U	WORD	PDKN	;     h     
POUT_BSQ_M7	WORD	PBQ7	;{Xp񃂁[hVof
;
PO_NORMAL	EQU	(POUT_NORMAL-PL_INIT_MODE)/2
PO_SKI		EQU	(POUT_SKI-PL_INIT_MODE)/2
PO_DK_O_R	EQU	(POUT_DK_O_R-PL_INIT_MODE)/2
PO_DK_O_L	EQU	(POUT_DK_O_L-PL_INIT_MODE)/2
PO_DK_O_D	EQU	(POUT_DK_O_D-PL_INIT_MODE)/2
PO_DK_O_U	EQU	(POUT_DK_O_U-PL_INIT_MODE)/2
PO_DK_I_R	EQU	(POUT_DK_I_R-PL_INIT_MODE)/2
PO_DK_I_L	EQU	(POUT_DK_I_L-PL_INIT_MODE)/2
PO_DK_I_D	EQU	(POUT_DK_I_D-PL_INIT_MODE)/2
PO_DK_I_U	EQU	(POUT_DK_I_U-PL_INIT_MODE)/2
PO_BSQ_M7	EQU	(POUT_BSQ_M7-PL_INIT_MODE)/2
;
PLINIT		EQU	$
;
		MI16
;
;-------------- vC[o[hZbg ------------------------------
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDA	PLMODE
		ASL	A
		TAY
		LDX	#020H		;(X) <-- afD揇
		LDA	!PL_INIT_MODE,Y
		STA	PLMODE		;vC[ԃZbg
		STA	ENSTFG		;Grsno
		CMP	#PSKI
		BNE	PLINIT_FFD	;XL[oH ( no:PLINIT_FFD )
;
;-------------- XL[oZbg ----------------------------
		LDA	#P_SKI		;XL[bV[Zbg
		STA	PLTYPE
		LDA	PLXPSL		;wW␳
		SEC
		SBC	#010H
		STA	PLXPSL
		STZ	PLMVSP
		STZ	PLXSPD
		STZ	PLYSPD
		STZ	PLDOSN		;hhX[htONA[
		JSL	>PLTYPE_RAMCLR
		BRA	PLINT_000
;
PLINIT_FFD	EQU	$
		CMP	#PDKN
		BNE	PLINT_000	;hJoH ( no:PLINT_000 )
;
;-------------- hJoZbg ----------------------------
		PHA			;(A) save
;
		TYA
		CLC
		ADC	#02H-(PL_INIT_DOKN-PL_INIT_MODE)
		CMP	#02H+(2*4)
		BCS	PLINIT_FFE	;OhJH ( no:PLINIT_FFE )
;
		LDX	#DO0C		;vC[p^[Zbg
		STX	PLPATN
		LDX	#010H		;(X) <-- afD揇
		BRA	PLINIT_FFF
;
PLINIT_FFE	EQU	$
;;;;		    SEC
		SBC	#(2*4)
		ORA	#8000H
		LDX	#020H		;(X) <-- afD揇
PLINIT_FFF	EQU	$
		ORA	#4000H
		STA	DOKNMK		;hJZbg
		AND	#00FFH
		CMP	#2+4
		BCC	PLINIT_FFFF	;chJH ( no:PLINIT_FFFF )
		TAY			;(A) save
		LDA	PLXPSL		;wW␳
		ORA	#08H
		STA	PLXPSL
		TYA			;(A) load
PLINIT_FFFF	EQU	$
		AND	#02H
		EOR	#02H
		STA	PLCMKI		;vC[Zbg
;
		PLA			;(A) load
PLINT_000	EQU	$
		STX	PLPRIO		;afD揇ʃZbg
;
		I8
;
		CMP	#PBQ7
		BNE	PLINT_008	;{Xp񃂁[hVofH ( no:PLINT_008 )
;
;-------------- {Xp񃂁[hVofZbg ------------------
		LDX	#(15-1)*2
PLINT_001	EQU	$
		LDA	>COL_ADDRESS+TORI_COL_1,X
		STA	>DATACOL+(80H+51H)*2,X
		STA	>MOTOCOL+(80H+51H)*2,X
		DEX
		DEX
		BPL	PLINT_001
;
		STZ	PYS_WORK0	;ZbgtOZbg
;
PLINT_008	EQU	$
		LDA	#01H
		STA	PLSTOP
;
		PLB
;
;-------------- XN[JE^[Zbg --------------------------
		LDA	PLXPSL
		SEC
		SBC	#78H
		STA	ESCCH1
		LDA	PLYPSL
		SEC
;;;;		    SBC	    #78H-(48H/2)
		SBC	#78H-(48H/2)+10H
		STA	ESCCV1
		BRA	PLINT_002
;
;-------------- Ԃ񏉊Zbg --------------------------------------
PLINIT_2	EQU	$
		LDA	#020H		;player BG pri. set
		STA	PLPRIO
;
PLINT_002	EQU	$
		LDA	#BABYM		;(A) <-- enemy no.
		LDY	#00		;(Y) <--   "   index
		JSL	>ENINSR2
		LDA	#ENOSE
		STA	ENMODE,Y
		LDA	#0DH
		STA	ENCHPT,Y
		LDA	#01H
		STA	ENWRKC,Y
		LDA	#8000H
		STA	BABYNO
		LDA	PLXPSL
		STA	ENXPSL,Y
		LDA	PLYPSL
		STA	ENYPSL,Y
		LDA	ENCLOR,Y
		AND	#11001111B
		ORA	PLPRIO
		STA	ENCLOR,Y
;
;-------------- ܂IvVZbg ------------------------------
;
;-------------- ^}Skn`c`FbN ----------------------------------
		JSL	>EGG_LOAD
;
		I16
;
		LDX	#EGOPMX-2
PLINT_010	EQU	$
		LDA	PLXPSL
		STA	EGOPTX,X
		LDA	PLYPSL
		CLC
		ADC	#010H
		STA	EGOPTY,X
		LDA	PLPRIO
		STA	EGOPT0,X
		DEX
		DEX
		BPL	PLINT_010
;
		I8
;
;-------------- vC[XN[JE^[Zbg ----------------
PSCRL_INIT	EQU	$
		LDA	PLXSDR
		STA	PLXSDR_OLD
		LDA	PLXPSL
		STA	PLXPSL_OLD
		LDA	PLYSDR
		STA	PLYSDR_OLD
		LDA	PLYPSL
		STA	PLYPSL_OLD
;
		STZ	PLSCRL_MINX
		LDA	#0F00H
		STA	PLSCRL_MAXX
		STZ	PLSCRL_MINY
;;;;		    LDA	    #071CH
		LDA	#070CH
		STA	PLSCRL_MAXY
		LDA	#(0100H/2)-08H-(018H/2)
		STA	PLSCRL_CX
;;;;		    LDA	    #((0B8H-8)/2)-010H
		LDA	#((0D8H-8)/2)-010H
		STA	PLSCRL_CY
;
		M8
;
;-------------- XN[JE^[Zbg --------------------------
PLSCRL_INIT	EQU	$
		JSL	>PLSCRL
;
		LDY	BG3TYP
		CPY	#01AH
		BNE	PLINT_020	;Az[afRH ( no:PLINT_020 )
;
;-------------- Az[afRX^[gXN[JE^[␳lvZ ----
;
		M16
;
		LDA	#0000H
		SEC
		SBC	<SCCH3
		STA	SCRL_WRK0
		LDA	#0100H
		SEC
		SBC	<SCCV3
		STA	SCRL_WRK1
;
		M8
;
PLINT_020	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDA	PLMODE
		CMP	#PSKI
		BEQ	PLINT_030	;XL[bV[oH ( yes:PLINT_030 )
		JSR	SKI_DOOR_CK
		BNE	PLINT_030	;XL[bV[ϐghAR[XH ( no:PLINT_030 )
;
		INC	SCRL_STOP	;XN[rsnoII
PLINT_030	EQU	$
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		XN[Zbg					-
;------------------------------------------------------------------------
;
		MEM16
;
SCRL_CXY_SET	EQU	$
		LDA	PLXPSL
		SEC
		SBC	SCCH1
		SEC
		SBC	#(018H/2)
		CMP	#030H
		BPL	SCRL_CXY_SET_10
		LDA	#030H
SCRL_CXY_SET_10 EQU	$
		CMP	#0A8H
		BMI	SCRL_CXY_SET_20
		LDA	#0A8H
SCRL_CXY_SET_20 EQU	$
		STA	PLSCRL_CX
		LDA	PLYPSL
		SEC
		SBC	SCCV1
;;;;		    CMP	    #020H
		CMP	#020H+20H
		BPL	SCRL_CXY_SET_30
;;;;		    LDA	    #020H
		LDA	#020H+20H
SCRL_CXY_SET_30 EQU	$
;;;;		    CMP	    #080H
		CMP	#080H+20H
		BMI	SCRL_CXY_SET_40
;;;;		    LDA	    #080H
		LDA	#080H+20H
SCRL_CXY_SET_40 EQU	$
		STA	PLSCRL_CY
		RTL
;
		MEM8
;
;************************************************************************
;*		player main						*
;************************************************************************
;
;-------------- vC[{^f[^ --------------------------
P_KEY_MNAG_DT	EQU	$
; CONFIG -->		       [0]		 [2]
		WORD	0000000010000000B,0000000010000000B
P_KEY_BERO_DT	EQU	$
		WORD	0100000000000000B,0100000000000000B
P_KEY_JUMP_DT	EQU	$
		WORD	1000000000000000B,1000000000000000B
;
;-------------- VbgZbgf[^ ----------------------------------
YHOSEID		EQU	$
;			  [normal]     [swimming & ( 0:up ) ]
		WORD	0000CH,0000CH,00004H,00004H	;[not shot]
		WORD	00010H,00010H,0000CH,0000CH	;[yoko]
		WORD	0000DH,0000DH,00008H,00008H	;[up]
		WORD	00007H,00007H,00007H,00007H	;[fire shot]
XHOSEID		EQU	$
		WORD	0000CH,0FFF4H,00008H,0FFF8H	;[not shot]
		WORD	00004H,0FFFCH,00004H,0FFFCH	;[yoko]
		WORD	0000BH,0FFF5H,00008H,0FFF8H	;[up]
BRCTXA		EQU	$
		WORD	00008H,00008H	;[not shot]
		WORD	00008H,00008H	;[yoko]
		WORD	00006H,0000AH	;[up]
BRCTYA		EQU	$
		WORD	00004H,00004H	;[not shot]
		WORD	00004H,00004H	;[yoko]
		WORD	00002H,00002H	;[up]
;
HOSEDAT		EQU	$
		WORD	00004H,0FFFCH
;
HOSEDT2		EQU	$
		WORD	00004H,0FFFCH
;
;
BNSSPA		EQU	$-1
		WORD	00008H,0FFF8H
BNSSPC		EQU	$-1
		WORD	00800H,00000H
;
PLAYER		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
		LDX	CONFIGFG
		LDA	!P_KEY_BERO_DT,X
		STA	P_KEY_BERO	;Vbg{^Zbg
		LDA	!P_KEY_MNAG_DT,X
		STA	P_KEY_MNAG	;l`w{^Zbg
		LDA	!P_KEY_JUMP_DT,X
		STA	P_KEY_JUMP	;Wv{^Zbg
;
;-------------- glhm^ntsf`FbN ------------------------
		JSR	TONNEL_INOUT
;
;-------------- vC[ ------------------------------------------
		LDA	EATSPT
;;;;		    CMP	    #03H+1
;;;;		    BCC	    PLAY20	    ;XyVVbgEFCgH ( no:PLAY20 )
		BEQ	PLAY20		;XyVVbgEFCgH ( no:PLAY20 )
;
;-------------- XyVVbgEFCg ----------------------
		LSR	A
		BNE	PLAY10		;EFCgIH ( no:PLAY10 )
;
		STZ	PLSTFG
		STZ	ENSTFG
PLAY10		EQU	$
		DEC	EATSPT
;
PLAY20		EQU	$
		LDA	PLSTFG
		BMI	PLAY22		;ԂߊlH ( yes:PLAY22 )
		ORA	BIRIBIRI
		ORA	ITEMNO
		BNE	PLAY30		;player stop ? ( yes:PLAY30 )
;
PLAY22		EQU	$
;
;-------------- timer set ---------------------------------------
		JSR	TIMER_DEC
;
;-------------- player move -------------------------------------
		JSR	PLMDSL		;player mode select
;
;-------------- player option pos set -------------------
		JSR	EGGPOS_SET
;
		STZ	ONLFFG		;tgĂtOZbg
		STZ	PUSHFG		;GtOZbg
;
;-------------- bero pos set ------------------------------------
PLAY30		EQU	$
		LDA	PLTYPE
		BNE	PLAY50		;ϐgH ( yes:PLAY50 )
;
		LDA	BERFLG
		INC	A
		AND	#06H
		TAX
;;;;		    BNE	    PLAY32	    ;bero not shot ? ( no:PLAY32 )
;;;;		    LDA	    <KEYC1
;;;;		    AND	    #00001000B
;;;;		    BEQ	    PLAY40	    ;[up] key in ? ( no:PLAY40 )
;;;;		    BRA	    PLAY34
		BEQ	PLAY40		;bero not shot ? ( no:PLAY32 )
;
;;;;PLAY32	    EQU	    $
		LDY	PLSWIM
		BEQ	PLAY40		;player swimming ? ( no:PLAY40 )
PLAY34		EQU	$
		INX
PLAY40		EQU	$
		TXA
		ASL	A
		ASL	A
		ORA	PLCMKI
		TAY
		TXA
		ASL	A
		ORA	PLCMKI
		TAX
;
		LDA	!XHOSEID,Y	;bero cross center X pos set
		CLC
		ADC	BERXPS
		STA	BRXPSL
		CLC
		ADC	PLXPSL
		CLC
		ADC	!BRCTXA,X
		STA	BRCNTX
		LDA	PLDSXL	       ;display X pos set
		CLC
		ADC	BRXPSL
		STA	BRDSXL		;bero display X pos set
;
		LDA	!YHOSEID,Y	;bero cross center Y pos set
		CLC
		ADC	BERYPS
		STA	BRYPSL
		CLC
		ADC	PLYPSL
		CLC
		ADC	!BRCTYA,X
		STA	BRCNTY
		LDA	PLDSXL	       ;display X pos set
		CLC
		ADC	BRXPSL
		STA	BRDSXL		;bero display X pos set
;
PLAY50		EQU	$
		LDY	KOOPA_FG
		BEQ	PLAY60		;{XNbpH ( no:PLAY60 )
;
		LDA	PLPATN
		CMP	#BE06
		BCS	PLAY60		;{XNbppp^[LH ( no:PLAY60 )
;;;;		    CLC
		ADC	#p000
		STA	PLPATN
PLAY60		EQU	$
;
		MI8
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		^C}[Z						-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
TIMER_DEC	EQU	$
		LDX	#TIMNO-2
TIMER_DEC_010	EQU	$
		LDA	TIMST,X
		BEQ	TIMER_DEC_020
		DEC	TIMST,X
TIMER_DEC_020	EQU	$
		DEX
		DEX
		BPL	TIMER_DEC_010
;
		LDX	#MTIMNO-2
TIMER_DEC_030	EQU	$
		LDA	MTIMST,X
		BEQ	TIMER_DEC_040
		DEC	MTIMST,X
TIMER_DEC_040	EQU	$
		DEX
		DEX
		BPL	TIMER_DEC_030
		RTS
;
;------------------------------------------------------------------------
;-		IvV^}SWZbg				-
;------------------------------------------------------------------------
EGGPOS_SET	EQU	$
		LDA	ONLFFG
		LDY	DSPMOD
		CPY	#0DH
		BNE	EGGPOS_SET_000	;QQ[ݑ܁H ( no:EGGPOS_SET_000 )
		LDA	#00
EGGPOS_SET_000	EQU	$
		STA	OLD_ONLFFG	;ÕtgĂ邩tOZbg
		ORA	PLJUMP
		STA	<PWRK02
;
		STZ	<PWRK00
		LDX	EGGPNT
		BEQ	EGGPOS_SET_040	;egg nothing ? ( yes:EGGPOS_SET_040 )
;
EGGPOS_SET_010	EQU	$
		LDY	EGGLNK-2,X
		LDA	EGOPTP
		SEC
		SBC	ENWRK2,Y
		BPL	EGGPOS_SET_020
		CLC
		ADC	#EGOPMX
EGGPOS_SET_020	EQU	$
		TAY
		LDA	EGOPT1,Y
		AND	#00FFH
		TSB	<PWRK00
		DEX
		DEX
		BNE	EGGPOS_SET_010
		LDA	<PWRK00
		ORA	<PWRK02
		ORA	CCHGMK
		ORA	GOAL_IN
		BNE	EGGPOS_SET_040	;^}SWvvC[WvϐgH ( yes:EGGPOS_SET_040 )
;
		LDA	PLMVSP
		CLC
		ADC	PL_ADD_XSP
		BPL	EGGPOS_SET_030
		EOR	#0FFFFH
		INC	A
EGGPOS_SET_030	EQU	$
		CLC
		ADC	EGOPSP
		STA	EGOPSP
		CMP	#0160H
		BCC	EGGPOS_SET_100	;pos set timming ? ( no:EGGPOS_SET_100 )
;
;;;;		SEC
		SBC	#0160H
		STA	EGOPSP
;
EGGPOS_SET_040	EQU	$
		LDY	EGOPTP
		LDA	CCHGMK
		BNE	EGGPOS_SET_048	;ϐgH ( yes:EGGPOS_SET_048 )
		LDA	GOAL_IN
		BEQ	EGGPOS_SET_060	;S[CH ( no:EGGPOS_SET_060 )
		LDA	BABYNO
		BMI	EGGPOS_SET_060	;ԂĂH ( yes:EGGPOS_SET_060 )
;
;-------------- ϐgԂWZbg ------------------------
EGGPOS_SET_048	EQU	$
		LDA	ENXPSL
		STA	EGOPTX,Y
		LDA	ENYPSL
		SEC
		SBC	#03H-010H
		STA	EGOPTY,Y
		LDA	ENYSPD
		AND	#0FF00H
		ORA	#0100H		;[ !=0 ]
		ORA	ENCLOR
		AND	#1111111100110000B
;
		LDY	EGOPTP
		BRA	EGGPOS_SET_080
;
;-------------- vC[WZbg ----------------------------
EGGPOS_SET_060	EQU	$
		LDA	PLXPSL
		STA	EGOPTX,Y
		LDA	PLYPSL
;;;;		    CLC
;;;;		    ADC	    CCHGLN
		CLC
		ADC	#010H
		STA	EGOPTY,Y
		LDA	<PWRK02
		BEQ	EGGPOS_SET_070	;player jump ? ( no:EGGPOS_SET_070 )
		LDA	PLYSPD
		AND	#0FF00H
		ORA	#0100H		;[ !=0 ]
EGGPOS_SET_070	EQU	$
		ORA	PLPRIO
EGGPOS_SET_080	EQU	$
		STA	EGOPT0,Y
		INY
		INY
		CPY	#EGOPMX
		BCC	EGGPOS_SET_090	;max pointer over ? ( no:EGGPOS_SET_090 )
		LDY	#00
EGGPOS_SET_090	EQU	$
		STY	EGOPTP
;
EGGPOS_SET_100	EQU	$
		RTS
;
;************************************************************************
;*		player mode select					*
;************************************************************************
;
		MEM16
		IDX16
;
PLMDSL		EQU	$
		LDX	PLMODE
		JMP	(!PLMVAD,X)
;
PLMVAD		EQU	$
PLMOV		WORD	PLMOVE		;player normal move
PLDEM		WORD	PLDEMO		;L[f[^f
PLSDM		WORD	PLSDEM		;X^[gf
;
PLDKN		WORD	PLDOKN		;hJof
PLDSC		WORD	PLDKSC		;hJXN[f
PLSHT		WORD	PLSHOT		;player shot !!
PLSKI		WORD	PLSKIO		;XL[of
PLFAL		WORD	PLFAIL		;vC[_E
PLCHG		WORD	PLCCHG		;[CCHG]
PLGUS		WORD	PLGUSH		;player "Gusha" !!
PLGOL		WORD	PLGOL0		;player Goal !!
PLTTL		WORD	PLTITL		;player R[XC^Cgf
PLRET		WORD	PLRETN		;player ϐgŎ̈ʒu֋A
PLSTP		WORD	PLSTMV		;player stop move
PLCLR		WORD	PLCLR0		;player not display
PLBSQ		WORD	PLBOSQ		;{XpԂуf
PLBQ7		WORD	PLBSQ7		;{Xp񃂁[hVof
PLBSC		WORD	PLBSCL		;{XNA[f
PLBNS		WORD	PLBONS		;fn`k{[iX胉bL[Wv
PLEND		WORD	PLENDG		;GfBOf
PLYGN		WORD	PLYOGN		;vC[n◎
PLDKJ		WORD	PLDKJP		;hJofWvEFCg
;
;
PMOV		EQU	(PLMOV-PLMVAD)
PDEM		EQU	(PLDEM-PLMVAD)
PSDM		EQU	(PLSDM-PLMVAD)
;
PDKN		EQU	(PLDKN-PLMVAD)
PDSC		EQU	(PLDSC-PLMVAD)
PSHT		EQU	(PLSHT-PLMVAD)
PSKI		EQU	(PLSKI-PLMVAD)
PFAL		EQU	(PLFAL-PLMVAD)
PCHG		EQU	(PLCHG-PLMVAD)
PGUS		EQU	(PLGUS-PLMVAD)
PGOL		EQU	(PLGOL-PLMVAD)
PTTL		EQU	(PLTTL-PLMVAD)
PRET		EQU	(PLRET-PLMVAD)
PSTP		EQU	(PLSTP-PLMVAD)
PCLR		EQU	(PLCLR-PLMVAD)
PBSQ		EQU	(PLBSQ-PLMVAD)
PBQ7		EQU	(PLBQ7-PLMVAD)
PBSC		EQU	(PLBSC-PLMVAD)
PBNS		EQU	(PLBNS-PLMVAD)
PEND		EQU	(PLEND-PLMVAD)
PYGN		EQU	(PLYGN-PLMVAD)
PDKJ		EQU	(PLDKJ-PLMVAD)
;
;
;
;****************************************************************
;*		vC[n◎				*
;****************************************************************
PLYOGN		EQU	$
;
		I8
;
		JSL	>BERO_CANCEL	;eat cancel !!
;
		LDA	PLWORKTM
		BEQ	PLYOGN_0000	;EFCgH ( no:PLYOGN_0000 )
;
		I16
;
		DEC	PLWORKTM
		BRA	PLYOGN_0110
;
		IDX8
;
;-------------- ނZbg ------------------------------------
PLYOGN_0000	EQU	$
		LDA	FRCNT
		AND	#01H
		BNE	PLYOGN_0010	;cZbgH ( no:PLYOGN_0010 )
;
		LDA	#DSMK0		;(A) <-- ʂmD
		JSL	>EXINSR		;ʃGAm
		LDA	PLXPSL
		STA	EXXPSL,Y	;wWZbg
		LDA	PLYPSL
		CLC
		ADC	#0CH
		STA	EXYPSL,Y	;xWZbg
		LDA	#05H
		STA	EXWRK0,Y	;JE^[Zbg
;;;;		    LDA	    #01H
		STA	EXWRK2,Y	;Grsnołl
;;;;		    LDA	    #05H
		STA	EXCHPT,Y	;p^[mDZbg
		LDA	#04H
		STA	EXTIM0,Y	;^C}[Zbg
		LDA	#06H
		STA	EXYUSN,Y	;D揇ʃZbg
;
PLYOGN_0010	EQU	$
		M_CHIP	M_PLXYCLC
;
		I16
;
		LDA	PLDSYL
		CMP	#0120H
		BMI	PLYOGN_0050	;IH ( no:PLYOGN_0050 )
;
		JSL	>TIMEUP_SET_2
		INC	PLSTFG
		RTS
;
;-------------- p^[Zbg ----------------------------------
PLYOGN_0050	EQU	$
		LDX	#YG01		;(X) <-- p^[mD
		LDA	PLYSPD
		CLC
		ADC	#028H
		CMP	#0400H
		BMI	PLYOGN_0100
		LDA	#0400H
PLYOGN_0100	EQU	$
		STA	PLYSPD
		TAY
		BMI	PLYOGN_0150	;㏸H ( yes:PLYOGN_0150 )
;
		LDA	#030H		;afD揇ʕύXiŗDj
		STA	PLPRIO
PLYOGN_0110	EQU	$
		LDX	#DM00		;(X) <-- p^[mD
PLYOGN_0150	EQU	$
		STX	PLPATN
		RTS
;
;************************************************************************
;*		GfBOf					*
;************************************************************************
L_		EQU	00000100B	;L[
R_		EQU	00000010B	;EL[
JP		EQU	00000001B	;WvL[
;
PLENDG_KEY_DT	EQU	$
		BYTE	R_,   008H
		BYTE	R_+JP,02CH
		BYTE	R_,   016H
		BYTE	R_+JP,012H
		BYTE	R_,   01CH
		BYTE	R_+JP,01CH
		BYTE	R_,   026H
		BYTE	0,    0FFH
LUIGI_FIND_P	BYTE	R_,   010H
		BYTE	0,    040H
		BYTE	JP,   006H
		BYTE	0,    014H
		BYTE	JP,   006H
;
		BYTE	0,    040H
		BYTE	JP,   006H
		BYTE	0,    014H
		BYTE	JP,   006H
;
		BYTE	0,    040H
		BYTE	JP,   006H
		BYTE	0,    014H
		BYTE	JP,   006H
;
		BYTE	0,    040H
		BYTE	JP,   006H
		BYTE	0,    014H
		BYTE	JP,   006H
;
LOOP_P		BYTE	0,    07FH
;
		BYTE	-(($-LOOP_P)/2)
;
LUIGI_FIND	EQU	(LUIGI_FIND_P-PLENDG_KEY_DT)/2
;
PLENDG		EQU	$
;
		I8
;
		LDA	PLWORKTM
		BNE	PLENDG_0100	;L[f[^ύXH ( no:PLENDG_0100 )
;
;-------------- ̃L[f[^ǂݍ ----------------------------------
PLENDG_0010	EQU	$
		LDA	PYS_WORK0
		ASL	A
		TAX
		CPX	#LUIGI_FIND
		BCC	PLENDG_0012	;}IH ( no:PLENDG_0012 )
;
		STA	HELLO_LUIGI
PLENDG_0012	EQU	$
		LDY	!PLENDG_KEY_DT,X
		BPL	PLENDG_0020	;f[^dmcH ( no:PLENDG_0020 )
;
		TYA
		ORA	#0FF00H
		CLC
		ADC	PYS_WORK0
		STA	PYS_WORK0
		BRA	PLENDG_0010
;
PLENDG_0020	EQU	$
		TYA
		LSR	A		;(C) <-- WvL[
		XBA
		BCC	PLENDG_0050	;WvL[H ( no:PLENDG_0050 )
		ORA	P_KEY_JUMP
PLENDG_0050	EQU	$
		STA	P_KEYC1L
		STA	P_KEYC2L
		LDA	!PLENDG_KEY_DT+1,X
		AND	#00FFH
		STA	PLWORKTM
;
		INC	PYS_WORK0
		BRA	PLENDG_0150
;
PLENDG_0100	EQU	$
		STZ	P_KEYC2L
;
PLENDG_0150	EQU	$
;
		I16
;
		LDA	P_KEYC1L
		STA	MKEYC1L
		LDA	P_KEYC2L
		STA	MKEYC2L
		JSR	PL_MOVE_CALL
;
		LDA	PLJUMP
		BEQ	PLENDG_0200	;WvH ( no:PLENDG_0200 )
;
		LDX	PYS_WORK0
		CPX	#LUIGI_FIND
		BCC	PLENDG_0170	;hb^[IIhH ( no:PLENDG_0170 )
;
		CMP	#BN02
		BCS	PLENDG_0160	;hb^[IIhWvp^[H ( yes:PLENDG_0160 )
		LDA	#BN02
		STA	PLJUMP
		STA	PYS_WORK2
PLENDG_0160	EQU	$
		JSR	LUCKY_JUMP_SET
;
PLENDG_0170	EQU	$
		LDA	#07A0H
		CMP	PLYPSL
		BPL	PLENDG_0200	;nxʒuH ( no:PLENDG_0200 )
;
		STA	PLYPSL
		STZ	PLJUMP
PLENDG_0200	EQU	$
		RTS
;
;************************************************************************
;*		{XNA[f					*
;************************************************************************
PLBSCL		EQU	$
		INC	ONLFFG		;IvV^}SW
;
		I8
;
		M_CHIP	M_PLCALC	;position move
;
		LDA	#00000001B*100H ;ړL[Zbg
		STA	MKEYC1L
;
		LDA	PLDSXL
;;;;		    CMP	    #090H
		CMP	#080H
		BPL	PLBSCL_0050	;vC[WvʒuH ( yes:PLBSCL_0050 )
;
;-------------- JM֑II ----------------------------------------
		STZ	MKEYC2L
		LDA	<SCCV1		;vC[zaf`FbN
		CLC
		ADC	#080H
		STA	PLYPSL
		BRA	PLBSCL_0150
;
;-------------- vC[WvII ----------------------------------
PLBSCL_0050	EQU	$
		LDA	PLJUMP
		BNE	PLBSCL_0100	;WvH ( yes:PLBSCL_0100 )
;
		LDA	P_KEY_JUMP	;l|pRg[[Zbg
		STA	MKEYC2L
PLBSCL_0100	EQU	$
		LDA	PLYSPD
		BPL	PLBSCL_0150	;㏸H ( no:PLBSCL_0150 )
;
		LDA	P_KEY_JUMP	;l|pRg[[Zbg
		TSB	MKEYC1L
;
;-------------- fZbg ------------------------------------------
PLBSCL_0150	EQU	$
		INC	PLSTOP		;Zbg
		M_CHIPS PL_DEMO_2
;
		I16
;
		RTS
;
;************************************************************************
;*		X^[gf						*
;************************************************************************
PLSDEM		EQU	$
		LDA	BABYNO
		BMI	PLSDEM_0500	;ԂH ( yes:PLSDEM_0500 )
;
		LDA	PLJUMP
		ORA	PLJPTM
		BNE	PLSDEM_0502	;WvH ( yes:PLSDEM_0502 )
;
		LDA	PYS_WORK0
		CMP	#02H
		BCS	PLSDEM_0040	;WvIH ( yes:PLSDEM_0040 )
;
;-------------- ܂͂QWv --------------------------------------
		INC	PYS_WORK0
		BRA	PLSDEM_JUMP
;
PLSDEM_0040	EQU	$
		LDA	#080H		;Ԃ̃EFCg^C}[Zbg
		STA	PLWORKTM
		LDA	PLMVSP
		CMP	#0FF00H
		BPL	PLSDEM_0050	;l`wXs[hH ( no:PLSDEM_0050 )
		LDA	#0FF00H
		STA	PLMVSP
PLSDEM_0050	EQU	$
		LDA	#00000010B*100H
		JMP	PLSDEM_1000
;
PLSDEM_0500	EQU	$
		LDA	DEMO_NO
		CMP	#STT_PL_GO
		BCS	PLSDEM_0510	;bZ[W\IH ( yes:PLSDEM_0510 )
;
		LDA	PLWORKTM
		BEQ	PLSDEM_0502	;Ԃ̃EFCgH ( no:PLSDEM_0502 )
;
		LSR	A
		BNE	PLSDEM_0502	;bZ[W\H ( no:PLSDEM_0502 )
;
;-------------- bZ[W\ ----------------------------------------
		INC	DEMO_NO
;
PLSDEM_0502	EQU	$
		LDA	#00000000B*100H
		JMP	PLSDEM_1000
;
PLSDEM_0510	EQU	$
		STZ	ATSCRL_H	;vC[XN[X^[g
;
		LDA	PLDSXL
		CMP	#0A0H
		BPL	PLSDEM_0530	;Ō̃WvʒuH ( yes:PLSDEM_0530 )
;
		LDA	PYS_WORK0
		ORA	PLJUMP
		ORA	PLJPTM
		BEQ	PLSDEM_0511	;݂ȂւIH ( yes:PLSDEM_0511 )
;
		LDA	PLXPSL
		CMP	#01D0H
		BPL	PLSDEM_GOODBY	;WvʒuH ( no:PLSDEM_GOODBY )
PLSDEM_0511	EQU	$
		JMP	PLSDEM_0548
;
PLSDEM_GOODBY	EQU	$
		LDA	PLMVSP
		BEQ	PLSDEM_0512	;vC[~܂H ( yes:PLSDEM_0512 )
;
		LDA	#040H		;Wv܂ł̃EFCg^C}[Zbg
		STA	PLWORKTM
PLSDEM_0512	EQU	$
		LDA	#02H		;vC[Zbg
		STA	PLCMKI
;
		LDA	PLWORKTM
		BNE	PLSDEM_0502	;Wv܂ł̃EFCgH ( yes:PLSDEM_0502 )
;
;-------------- ܂͂QWv --------------------------------------
		LDA	PLJUMP
		ORA	PLJPTM
		BNE	PLSDEM_0502	;WvH ( yes:PLSDEM_0502 )
;
		DEC	PYS_WORK0
PLSDEM_JUMP	EQU	$
		LDA	#0FA00H		;WvxXs[hZbg
PLSDEM_JUMP_2	EQU	$
		STA	PLYSPD
		LDA	#P006		;WvtOhnmh
		STA	PLJUMP
		BRA	PLSDEM_0502
;
PLSDEM_0530	EQU	$
		CMP	#0120H
		BMI	PLSDEM_0540	;fIH ( no:PLSDEM_0540 )
;
;-------------- Pv|O ----------------------------------------------
;;;;K;;;;		LDA	#HMPIN
;;;;K;;;;		STA	MODENO
		LDA	#GMIN
		STA	!MODENO
		LDA	#INT_STAT
		STA	!MAPOINT
		RTS
;
PLSDEM_0540	EQU	$
		LDA	PYS_WORK0
		CMP	#-02H
		BNE	PLSDEM_GOODBY	;WvIH ( no:PLSDEM_GOODBY )
;
		LDA	PLJUMP
		ORA	PLJPTM
		BEQ	PLSDEM_0544	;WvH ( no:PLSDEM_0544 )
;
		LDA	PLDSXL
		CMP	#0C0H
		BMI	PLSDEM_05400	;WvH ( no:PLSDEM_05400 )
;
;-------------- WvL[Zbg ------------------------------------
		LDA	P_KEY_JUMP
		ORA	#00000001B*100H
		BRA	PLSDEM_1000
;
PLSDEM_05400	EQU	$
		LDA	#040H		;U܂ł̃EFCg^C}[Zbg
PLSDEM_0541	EQU	$
		STA	PLWORKTM
PLSDEM_0542	EQU	$
		JMP	PLSDEM_0502
;
PLSDEM_0544	EQU	$
		LDA	PLDSXL
		CMP	#0C0H
		BMI	PLSDEM_0545	;WvH ( no:PLSDEM_0545 )
;
;-------------- WvII ------------------------------------------
		LDA	#0FB00H		;(A) <-- WvxXs[h
		BRA	PLSDEM_JUMP_2
;
PLSDEM_0545	EQU	$
		LDA	PLWORKTM
		BEQ	PLSDEM_0550	;U܂ł̃EFCgH ( no:PLSDEM_0550 )
;
		LSR	A
		BNE	PLSDEM_0542	;UZbgH ( no:PLSDEM_0542 )
;
		LDA	PLCMKI
		BEQ	PLSDEM_0542	;UH ( no:PLSDEM_0542 )
;
		STZ	PLCMKI		;vC[Zbg
		LDA	#060H		;o܂ł̃EFCg^C}[Zbg
		BRA	PLSDEM_0541
;
PLSDEM_0548	EQU	$
		LDA	PLMVSP
		CMP	#0100H
		BMI	PLSDEM_0550	;l`wXs[hH ( no:PLSDEM_0550 )
		LDA	#0100H
		STA	PLMVSP
PLSDEM_0550	EQU	$
		LDA	#00000001B*100H
PLSDEM_1000	EQU	$
		STA	MKEYC1L
		STZ	MKEYC2L
		JMP	PL_MOVE_CALL
;
;************************************************************************
;*		fn`k{[iX胉bL[Wv			*
;************************************************************************
PLBONS		EQU	$
		LDA	P_KEY_JUMP
		STA	MKEYC1L
		STZ	MKEYC2L
		STZ	PLSPJP		;W^o^WvLZ
		LDA	#01H		;
		STA	PSPJTM		;
		JSR	PL_MOVE_CALL	;vC[
;
		LDA	PYS_WORK1
		BEQ	PLBONS_0010	;EFCgH ( no:PLBONS_0010 )
		DEC	PYS_WORK1
		CMP	#040H
		BCS	PLBONS_0000	;㌩H ( no:PLBONS_0000 )
		LDA	#P106
		STA	PLPATN
PLBONS_0000	EQU	$
		RTS
;
PLBONS_0010	EQU	$
		LDA	PLJUMP
		BNE	PLBONS_0100	;WvH ( yes:PLBONS_0100 )
;
		LDA	PLJPTM
		BNE	PLBONS_0200	;nH ( yes:PLBONS_0200 )
;
		DEC	PYS_WORK0
		BPL	PLBONS_0050	;WvIH ( no:PLBONS_0050 )
;
		LDA	#PDEM
		STA	PLMODE
		RTS
;
;-------------- WvZbg ------------------------------------------
PLBONS_0050	EQU	$
		LDA	#0FD00H
		STA	PLYSPD
		LDA	#BN02
		STA	PLJUMP
		STA	PYS_WORK2
		STZ	PLSPJP
		RTS
;
;-------------- Wvp^[Zbg ----------------------------------
LUCKY_JUMP_SET	EQU	$
PLBONS_0100	EQU	$
		LDA	PLYSPD
		CMP	#0FF00H
		BMI	PLBONS_0150	;p^[؂ւH ( no:PLBONS_0150 )
;
		LDA	PLJPTM
		BNE	PLBONS_0150	;p^[؂ւnjH ( no:PLBONS_0150 )
		LDA	#04H
		STA	PLJPTM
		LDA	PYS_WORK2
		CMP	#BN05
		BCS	PLBONS_0150	;l`wp^[H ( yes:PLBONS_0150 )
		INC	PYS_WORK2
PLBONS_0150	EQU	$
		LDA	PYS_WORK2
		STA	PLPATN		;Wvp^[Zbg
PLBONS_0200	EQU	$
		RTS
;
;************************************************************************
;*		{Xp񃂁[hVof				*
;************************************************************************
PLBSQ7		EQU	$
;
;-------------- WvZ ------------------------------------------------
;
		I8
;
		M_CHIP	M_PLXYCLC
;
;-------------- {vZ ------------------------------------------------
		LDA	PYS_WORK0
		BNE	PLBSQ7_0010	;ZbgH ( no:PLBSQ7_0010 )
;
		LDA	#089H		;[]
		JSL	>SOUND_3_ON
;
		LDA	#0FA00H		;{wXs[hZbg
		STA	PYS_WORK1
		LDA	#0800H		;{Zbg
		STA	PYS_WORK0
PLBSQ7_0010	EQU	$
		SEC
		SBC	#08H
		CMP	#0100H
		BCS	PLBSQ7_0050
		LDA	#0100H
PLBSQ7_0050	EQU	$
		STA	PYS_WORK0
		STA	R6		;(R6) <-- {
		LDA	#01H
		STA	R4		;(R4) <-- 폜
		M_CHIP	DIV_DOUBLE
		LDA	R7
		STA	<WORK		;(WK0,1) <-- {
		STA	R6		;(R6)	 <--  h
;
		LDA	PYS_WORK1
		STA	R0		;(R0) <-- {wXs[h
		M_CHIP	MULT16C
		LDA	R0-1
		AND	#0FF00H
		STA	<WORK2
		LDA	R4+1
		AND	#00FFH
		ORA	<WORK2
		STA	PLXSPD		;wXs[hZbg
;
		LDA	#0FC00H
		STA	R0		;(R0) <-- {xXs[h
		M_CHIP	MULT16C
		LDA	R0-1
		AND	#0FF00H
		STA	<WORK2
		LDA	R4+1
		AND	#00FFH
		ORA	<WORK2
		STA	PLYSPD		;xXs[hZbg
;
		LDA	PYS_WORK1	;{wXs[hύX
		CLC
		ADC	#08H
		STA	PYS_WORK1
;
;-------------- LN^[Zbg --------------------------------------
		LDA	#020H
		STA	R2		;(R2) <-- rbg}bvWQx
		STZ	R3		;(R3) <--	 h	  Qw
		LDA	FRCNT2
		ASL	A
		ASL	A
		ASL	A
		AND	#00FFH
		STA	R5		;(R5) <-- ]px
		LDA	#CIPCHD+0040H
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CIPCHD
		STA	R13		;(R13) <--	   h		(aj
		M_CHIP	C_32_ROTZOM
;
		LDA	#PC00	;vC[p^[mDZbg
		STA	PLPATN
;
;-------------- J[tF[h ------------------------------------------
		LDA	P_COLOR
		ASL	A
		TAX
		LDA	>PL_COLBK,X
		CLC
		ADC	#COL_ADDRESS
		STA	R14		;(R14) <-- J[f[^AhXikCgj
		LDA	#BANK COL_ADDRESS
		STA	R0		;(R0)  <-- J[f[^AhXiaj
		LDA	<WORK
		STA	R6		;(R6)  <-- tF[h
		LDA	#080H+51H
		STA	R8		;(R8)  <-- J[|C^[iO`eej
		LDA	#15
		STA	R12		;(R12) <-- J[
		M_CHIP	COL_MORF_B
;
		LDY	#0AH		;(Y) <-- Ԃ\hneeh
		LDX	#40H		;(X) <-- naiD揇ʁiŉʁj
		LDA	PLDSYL
		CMP	#0FF80H
		BPL	PLBSQ7_0100	;fIH ( no:PLBSQ7_0100 )
;
;-------------- fI ----------------------------------------
		LDA	P_COLOR		;vC[J[Zbg
		ASL	A
		STA	PCOLTR
		JSL	>PLCOLTR
;
		LDA	#PDEM
		STA	PLMODE
		LDA	#0140H
		STA	PLXPSL
		LDA	#0000H
		STA	PLYPSL
;
		LDY	#2AH		;(Y) <-- Ԃ\hnmh
		LDX	#00H		;(X) <-- naiD揇ʁim[}j
PLBSQ7_0100	EQU	$
		STY	ENCLOR
		STX	ENEMU0
;
		I16
;
		RTS
;
;************************************************************************
;*		{XpԂуf				*
;************************************************************************
PLBOSQ		EQU	$
;
		I8
;
		M_CHIP	M_PLXYCLC
		M_CHIP	M_PLBGCK
;
		I16
;
		LDA	PLBGCR
		AND	#110000000B
		BEQ	PLBOSQ_0010	;TChafH ( no:PLBOSQ_0010 )
;
		LDA	#0800H		;(A) <-- wXs[h
		LDY	#0FC00H		;(Y) <-- xXs[h
		BRA	PLBOSQ_0020
;
PLBOSQ_0010	EQU	$
		LDA	PLBGCR
		AND	#001100000B
		BEQ	PLBOSQ_0050	;ETChafH ( no:PLBOSQ_0050 )
;
		LDA	#0FC00H		;(A) <-- wXs[h
		LDY	#0F800H		;(Y) <-- xXs[h
PLBOSQ_0020	EQU	$
		STA	PLXSPD
		STY	PLYSPD
;
PLBOSQ_0050	EQU	$
		LDA	PLDSYL
		CMP	#0FFC0H
		BPL	PLBOSQ_0100	;mdws fnsnH ( no:PLBOSQ_0100 )
;
;-------------- mdws fnsnII -----------------------------------
		JSL	>GO_NEXTGOTO
;
PLBOSQ_0100	EQU	$
		LDA	#DM00		;p^[mDZbg
		STA	PLPATN
		RTS
;
;************************************************************************
;*		XL[of						*
;************************************************************************
PLSKIO		EQU	$
		LDA	PLDSXL
		CMP	#020H
		BMI	PLSKIO_0010	;fIH ( no:PLSKIO_0010 )
;
;-------------- fI ------------------------------------------------
		STZ	PLMODE
PLSKIO_0010	EQU	$
		LDA	#300H		;wXs[hZbg
		STA	PLMVSP
		LDA	#00000001B*100H ;l|pRg[[Zbg
		STA	MKEYC1L
		STZ	MKEYC2L
		JSR	PL_MOVE_CALL
		LDA	#0FH		;[ AND	#0FFF0H ]
		TRB	PLYPSL
		RTS
;
;************************************************************************
;*		hJof					*
;************************************************************************
DOKAN_SIDE_XSP	EQU	$-2
		WORD	00080H,0FF80H
;
DOKAN_INUD_PTN	EQU	$-(2+4)
		WORD	P008,  P006
DOKAN_INUD_YSP	EQU	$-(2+4)
		WORD	00100H,0F400H
DOKAN_OTUD_YSP	EQU	$-(2+4)
		WORD	00100H,0FF00H
;
DOKAN_PATN	EQU	$
DOKAN_DW_PATN	WORD	P011,P012,P011,DD01,DD02,DD03,DD12
DOKAN_UP_PATN	WORD	DU01,DU02,DU03,DU04,DU05,DU06,DU07,DU08
		WORD	DU09,DU0A,DU0B
DOKAN_PATN_E	EQU	$
DOKAN_UPDW_PTIN EQU	$-(2+4)
		WORD	DOKAN_DW_PATN-DOKAN_PATN,DOKAN_UP_PATN-DOKAN_PATN
DOKAN_UPDW_PTNO EQU	$-(2+4)
		WORD	(DOKAN_UP_PATN-DOKAN_DW_PATN)/2,(DOKAN_PATN_E-DOKAN_UP_PATN)/2
DOKAN_UPDW_TM	EQU	$-(2+4)
		WORD	06H,	    04H
DOKAN_UPDW_XA	EQU	$
		WORD	00001H,	    0FFFFH
DOKAN_UPDW_XH	EQU	$
; PLCMKI -->		 [0]	[2]
		WORD	0FFFEH,00002H
;
DK_NEXTGOTO_HSX EQU	$-2
; DOKNMK -->		 [2]  [4]  [6]	[8]
		WORD	-1FH, 1FH, 00H, 00H
DK_NEXTGOTO_HSY EQU	$-2
		WORD	 00H, 00H,-1FH, 1FH
;
PLDOKN		EQU	$
		LDA	PLXSPD
		ORA	PLYSPD
		ORA	PLJUMP
		BNE	PLDOKN_FFC0	;TEhZbgH ( no:PLDOKN_FFC0 )
;
		LDA	#031H		;[]
		LDY	DSPMOD
		CPY	#0DH
		BNE	PLDOKN_FFB0	;QQ`̈ݑ܁H ( no:PLDOKN_FFB0 )
;
		LDY	DOKNMK
		BMI	PLDOKN_FFC0	;H ( no:PLDOKN_FFC0 )
;
		LDA	#014H		;[]
PLDOKN_FFB0	EQU	$
		JSL	>SOUND_3_ON
;
PLDOKN_FFC0	EQU	$
		INC	ONLFFG
;
		I8
;
		LDY	DOKNMK		;(Y) <-- hJ
		CPY	#2+4
		BCS	PLDOKN_FFD0	;hJH ( no:PLDOKN_FFD0 )
		JMP	PLDOKN_0100
;
;-------------- chJ ------------------------------------------------
PLDOKN_FFD0	EQU	$
		STZ	PLMVSP		;wXs[hNA[
		STZ	PLXSPD
;
		BIT	DOKNMK
		BVC	PLDOKN_FFF0	;oH ( no:PLDOKN_FFF0 )
;
;-------------- o --------------------------------------------
		LDA	PLXPSL
		AND	#0FH
		CMP	#08H
		BEQ	PLDOKN_FFD4
;
		LDX	#00
		BCC	PLDOKN_FFD2
		LDX	#02
PLDOKN_FFD2	EQU	$
		LDA	PLXPSL
		CLC
		ADC	!DOKAN_UPDW_XA,X
		STA	PLXPSL
;
PLDOKN_FFD4	EQU	$
		LDA	DOKNMK
		AND	#8000H+2000H
		CMP	#8000H
		BNE	PLDOKN_FFD6	;OhJH ( yes:PLDOKN_FFD6 )
;
		LDA	!DOKAN_INUD_PTN,Y ;op^[mDZbg
		STA	PLJUMP
		LDA	!DOKAN_INUD_YSP,Y ;xXs[hZbg
		BRA	PLDOKN_FFD8
;
PLDOKN_FFD6	EQU	$
		LDA	#DO0C		;op^[mDZbg
		STA	PLJUMP
		LDA	!DOKAN_OTUD_YSP,Y ;xXs[hZbg
PLDOKN_FFD8	EQU	$
		STA	PLYSPD
		BPL	PLDOKN_FFE0
		EOR	#0FFFFH
		INC	A
PLDOKN_FFE0	EQU	$
		JMP	PLDOKN_0120
;
;-------------- mdws|fnsn ------------------------------
PLDOKN_FFF0	EQU	$
		LDX	PLCMKI
		LDA	DOKNCX
		CLC
		ADC	!DOKAN_UPDW_XH,X
		LDX	#00
		CMP	PLXPSL
		BEQ	PLDOKN_0002
		BPL	PLDOKN_0000
;
		LDX	#02
PLDOKN_0000	EQU	$
		LDA	PLXPSL
		CLC
		ADC	!DOKAN_UPDW_XA,X
		STA	PLXPSL
;
PLDOKN_0002	EQU	$
		LDA	PLWORKTM
		BNE	PLDOKN_0010	;p^[؂ւH ( no:PLDOKN_0010 )
;
		LDA	DOKNPT
		CMP	!DOKAN_UPDW_PTNO,Y
		BEQ	PLDOKN_0010	;p^[l`wH ( yes:PLDOKN_0010 )
;
		INC	DOKNPT
		LDA	!DOKAN_UPDW_TM,Y
		STA	PLWORKTM	;p^[؂ւ^C}[Zbg
PLDOKN_0010	EQU	$
		LDA	DOKNPT
		ASL	A
;;;;		    CLC
		ADC	!DOKAN_UPDW_PTIN,Y
		TAX
		LDA	!DOKAN_PATN-2,X
		STA	PLJUMP		;p^[mDZbg
		STZ	PLSITD		;Ⴊ݃LZ
;
		LDA	FRCNT
		AND	#01H
		BNE	PLDOKN_0022
		LDA	DOKNGP
		ASL	A
		BCC	PLDOKN_0020
		LDA	#0FFFFH
PLDOKN_0020	EQU	$
		STA	DOKNGP
;
PLDOKN_0022	EQU	$
		LDA	DOKNGP
		XBA
		AND	#00FFH
		CPY	#2+4
		BEQ	PLDOKN_0030
		EOR	#0FFFFH
		INC	A
PLDOKN_0030	EQU	$
		CLC
		ADC	PLYSPD
		STA	PLYSPD		;xXs[hZbg
		BPL	PLDOKN_0120
		EOR	#0FFFFH
		INC	A
		BRA	PLDOKN_0120
;
;-------------- hJ ------------------------------------------------
PLDOKN_0100	EQU	$
		STZ	PLYSPD		;xXs[hNA[
;
		LDX	#00H		;(X) <-- vC[
		LDA	!DOKAN_SIDE_XSP,Y
		STA	PLMVSP		;ړXs[hZbg
		STA	PLXSPD		;wXs[hZbg
		BPL	PLDOKN_0110
		LDX	#02H		;(X) <-- vC[
		EOR	#0FFFFH
		INC	A
PLDOKN_0110	EQU	$
		STX	PLCMKI		;vC[Zbg
;
PLDOKN_0120	EQU	$
		CLC
		ADC	DOKNCT
		STA	DOKNCT
		CMP	#01F00H
		BCS	PLDOKN_0122	;fIH ( yes:PLDOKN_0122 )
		JMP	PLDOKN_0140
;
PLDOKN_0122	EQU	$
		BIT	DOKNMK
		BVC	PLDOKN_0130	;oH ( no:PLDOKN_0130 )
;
;-------------- o ----------------------------------------------------
		LDA	PLYSPD
		CMP	#0FF00H
		BPL	PLDOKN_0123	;WvoH ( no:PLDOKN_0123 )
;
		LDA	#PDKJ
		STA	PLMODE
		BRA	PLDOKN_0124
;
PLDOKN_0123	EQU	$
		STZ	PLMODE		;ʃ[hw
		STZ	ENSTFG		;Grsno
		LDA	PLJUMP
		BEQ	PLDOKN_0124
		LDA	#P008
		STA	PLJUMP
PLDOKN_0124	EQU	$
		BRA	PLDOKN_0150
;
PLDOKN_0130	EQU	$
		LDA	DOKNMK
		AND	#2000H
		BEQ	PLDOKN_0138	;hJXN[H ( no:PLDOKN_0138 )
;
;-------------- hJXN[ ----------------------------------------
		LDA	#PDSC		;hJXN[vC[[hZbg
		STA	PLMODE
;
		LDA	PLXPSL
		STA	R8		;(R8) <-- af`FbNwW
		LDA	PLYPSL
		CLC
		ADC	#020H+018H
		STA	R0		;(R0) <-- af`FbNxW
		M_CHIPR M_BGUNIT_READ
;
		LDA	#00
		LDY	R6+1
		CPY	#HIGH UT3D00
		BEQ	PLDOKN_0132	;փXN[H ( yes:PLDOKN_0132 )
		LDA	#02H
PLDOKN_0132	EQU	$
		STA	DOKNMK
;
		LDA	PLYPSL		;vC[xW␳
		CLC
		ADC	#08H
		AND	#0FFF0H
		DEC	A
		STA	PLYPSL
		BRA	PLDOKN_0160
;
;-------------- mdws|fnsn --------------------------------------
PLDOKN_0138	EQU	$
		LDY	DOKNMK
		LDA	PLXPSL
		CLC
		ADC	!DK_NEXTGOTO_HSX,Y
		XBA
		AND	#0FH
		ASL	A
		ASL	A
		STA	<WORK
		LDA	PLYPSL
		CLC
		ADC	!DK_NEXTGOTO_HSY,Y
		AND	#0F00H
		LSR	A
		LSR	A
		ORA	<WORK
		JSL	>GO_NEXTGOTO_2
;
;-------------- afD揇ʕύX --------------------------------
PLDOKN_0140	EQU	$
		LDA	#010H		;(A) <-- vC[afD揇
		BIT	DOKNMK
		BPL	PLDOKN_0152	;OhJH ( yes:PLDOKN_0152 )
;
PLDOKN_0150	EQU	$
		LDA	#020H		;(A) <-- vC[afD揇
PLDOKN_0152	EQU	$
		STA	PLPRIO		;vC[afD揇ʕύX
		JSR	BABY_OPT_PRI_ST
;
		M_CHIPS PL_DEMO_0	;vC[fp
;
PLDOKN_0160	EQU	$
;
		I16
;
		RTS
;
;------------------------------------------------------------------------
;-		Ԃ񁕃IvVafD揇ʃZbg			-
;------------------------------------------------------------------------
;
		IDX8
;
BABY_OPT_PRI_ST EQU	$
		LDA	ENCLOR		;ԂafD揇ʕύX
		AND	#11001111B
		ORA	PLPRIO
		STA	ENCLOR
;
		LDX	EGGPNT
		BEQ	B_O_PRI_ST_0050 ;IvVLH ( no:B_O_PRI_ST_0050 )
;
B_O_PRI_ST_0010 EQU	$
		LDY	EGGLNK-2,X
		LDA	ENCLOR,Y
		AND	#11001111B
		ORA	PLPRIO
		STA	ENCLOR,Y
		DEX
		DEX
		BNE	B_O_PRI_ST_0010
;
B_O_PRI_ST_0050 EQU	$
		RTS
;
		IDX16
;
;************************************************************************
;*		hJXN[f					*
;************************************************************************
DOKAN_SCRL_CY	EQU	$
		WORD	0007CH,0008CH
DOKAN_SCRL_YA	EQU	$
		WORD	00004H,0FFFCH
DK_SCRL_BGC_YA	EQU	$
		WORD	-000FH,00000H
DK_SCRL_BGC_UT	EQU	$
		WORD	UT3D3E,UT3D38
;
PLDKSC		EQU	$
		STZ	PLJUMP		;WvtOhneeh
		INC	ONLFFG
;
		I8
;
		LDY	DOKNMK
		LDA	PLYPSL
		CLC
		ADC	!DOKAN_SCRL_YA,Y
		STA	PLYPSL
;
		CLC
		ADC	!DK_SCRL_BGC_YA,Y
		STA	R0		;(R0) <-- af`FbNxW
		LDA	PLXPSL
		STA	R8		;(R8) <-- af`FbNwW
		M_CHIPR M_BGUNIT_READ
;
		LDY	DOKNMK
		LDA	R6
		CMP	!DK_SCRL_BGC_UT,Y
		BNE	PLDKSC_0050	;hJXN[rsnoH ( no:PLDKSC_0050 )
;
;-------------- JMhJ`FbN --------------------------------------
		LDA	PLXPSL
		STA	R8		;(R8) <-- af`FbNwW
		LDA	PLYPSL
		CLC
		ADC	#08H
		STA	R0		;(R0) <-- af`FbNxW
		M_CHIPR M_BGUNIT_READ
;
		LDA	R6
		CMP	#UT7D29
		BNE	PLDKSC_0040	;JMhJH ( no:PLDKSC_0040 )
;
		LDX	EGGPNT
		BEQ	PLDKSC_0020	;JMĂH ( no:PLDKSC_0020 )
		LDY	EGGLNK-2,X
		LDA	ENMYNO,Y
		CMP	#DRKEY
		BEQ	PLDKSC_0030	;JMĂH ( yes:PLDKSC_0030 )
;
;-------------- t߂II --------------------------------------
PLDKSC_0020	EQU	$
		LDA	DOKNMK
		EOR	#02H
		STA	DOKNMK
		BRA	PLDKSC_0050
;
PLDKSC_0030	EQU	$
		LDA	PLXPSL		;afwW
		STA	<BGXPS1
		LDA	PLYPSL		;afxW
		CLC
		ADC	#08H
		STA	<BGYPS1
		LDA	#BGCG		;af^Cv
		STA	BGCGNO
		LDA	#UT7D27		;afjbgmD
		STA	BGUTNO
		JSL	>UNITCHG
;
		INC	PLSTFG
;
PLDKSC_0040	EQU	$
		LDA	#PDKN		;hJofvC[[hZbg
		STA	PLMODE
		LDA	#((2+4)+2)+8000H+4000H+2000H
		STA	DOKNMK
		STZ	DOKNCT
		LDA	PLYPSL		;vC[xW␳
		CLC
		ADC	#08H
		AND	#0FFF0H
		DEC	A
		STA	PLYPSL
		BRA	PLDKSC_0100
;
PLDKSC_0050	EQU	$
		STZ	PLYUSN		;vC[\Zbg
;
PLDKSC_0100	EQU	$
		JSR	BABY_OPT_YSN_ST ;Ԃ񁕃IvVnaiD揇ʃZbg
;
		I16
;
		RTS
;
;------------------------------------------------------------------------
;-		Ԃ񁕃IvVnaiD揇ʃZbg		-
;------------------------------------------------------------------------
;
		IDX8
;
BABY_OPT_YSN_ST EQU	$
		LDX	PLYUSN
		DEX
		TXY
		BMI	B_O_YSN_ST_0000
		LDX	#04H
		LDY	#05H
B_O_YSN_ST_0000 EQU	$
		STX	ENYUSN		;ԂnaiD揇ʕύX
;
		TYA			;(A) <-- IvVnaiD揇
		LDX	EGGPNT
		BEQ	B_O_YSN_ST_0050 ;IvVLH ( no:B_O_YSN_ST_0050 )
;
B_O_YSN_ST_0010 EQU	$
		LDY	EGGLNK-2,X
		STA	ENYUSN,Y
		DEX
		DEX
		BNE	B_O_YSN_ST_0010
;
B_O_YSN_ST_0050 EQU	$
		RTS
;
		IDX16
;
;****************************************************************
;*		hJofWvEFCg		*
;****************************************************************
PLDKJP		EQU	$
		STZ	P_KEYC1L
		STZ	P_KEYC2L
		LDA	PLJUMP
		BNE	PLDEMO		;WvH ( yes:PLDEMO )
;
		STZ	PLMODE
		STZ	ENSTFG
		RTS
;
;************************************************************************
;*		L[f[^f						*
;************************************************************************
PLDEMO		EQU	$
		LDA	P_KEYC1L
		STA	MKEYC1L
		LDA	P_KEYC2L
		STA	MKEYC2L
		JMP	PL_MOVE_CALL
;
;************************************************************************
;*		ϐgŎ̈ʒu֋A				*
;************************************************************************
RETN_ROTCHR	EQU	$-2
		WORD	CIPCHD+60A0H		;N}
		WORD	CIPCHD+2060H		;O
		WORD	CIPCHD+00A0H		;wRv^[
		WORD	CIPCHD+2000H		;D
		WORD	CIPCHD+00C0H		;LmR
		WORD	CIPCHD+0000H		;
;
PLRETN		EQU	$
		STZ	PONLFFG		;tgtOJ

		LDA	#01H		;enemy stop !!
		STA	ENSTFG
;
		LDA	PCHNG_TM
		BEQ	PLRETN_000	;ʕ\H ( no:PLRETN_000 )
;
		LSR	A
		BNE	PLRETN_FFF	;TEhZbgH ( no:PLRETN_FFF )
;
		LDA	CCHGEN
		BEQ	PLRETN_FFF	;^C}[؂H ( no:PLRETN_FFF )
;
		LDA	#07DH		;[]
		JSL	>SOUND_3_ON
;
PLRETN_FFF	EQU	$
		JMP	PLRETN_030
;
PLRETN_000	EQU	$
		STZ	PLTYPE
;
		I8
;
		LDA	#TR00		;p^[mDZbg
		STA	PLPATN
;
		LDA	#020H
		STA	R2		;(R2) <-- rbg}bvWQx
		STZ	R3		;(R3) <--	 h	  Qw
		LDA	PLWRK0
		CLC
		ADC	#010H
		AND	#00FFH
		STA	PLWRK0
		STA	R5		;(R5) <-- px
		LDA	#0100H
		STA	R6		;(R6) <-- {
		LDY	CCHGMK
		LDA	!RETN_ROTCHR,Y
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CIPCHD
		STA	R13		;(R13) <--	   h		(aj
		M_CHIP	C_32_ROTZOM
;
		LDA	ENXPSL
		STA	R1		;(R1) <-- ڕWwW
		LDA	ENYPSL
		SEC
		SBC	#010H
		STA	R2		;(R2) <--  h x h
		LDA	PLXPSL
		STA	R3		;(R3) <-- ݂w h
		LDA	PLYPSL
		STA	R4		;(R4) <--  h x h
		LDA	#0800H
		STA	R6		;(R6) <-- T[`Xs[h
		M_CHIP	SEARCH_SPEED
;
		LDA	R1
		STA	PLXSPD	       ;vC[wXs[hZbg
		LDA	R2
		STA	PLYSPD	       ;     h	  x	  h
;
		M_CHIP	M_PLXYCLC	;wCxWvZ
;;;;		    JSR	    XYCALC	    ;WvZ
;
		I16
;
		LDA	ENXPSL
		SEC
		SBC	PLXPSL
		BEQ	PLRETN_010	;̂wʒuɋAH ( yes:PLRETN_010 )
		EOR	PLXSPD
		BPL	PLRETN_030	;	   h		( no:PLRETN_030 )
;
		LDA	ENXPSL		;vC[wW␳
		STA	PLXPSL
PLRETN_010	EQU	$
		LDA	ENYPSL
		SEC
		SBC	#010H
		STA	<WORK0
		SEC
		SBC	PLYPSL
		BEQ	PLRETN_020	;  h  x      h	( yes:PLRETN_020 )
		EOR	PLYSPD
		BPL	PLRETN_030	;	   h		( no:PLRETN_030 )
;
		LDA	<WORK0		;vC[xW␳
		STA	PLYPSL
;
;-------------- ʂ̃vC[ɖ߂ ----------------------------------
PLRETN_020	EQU	$
;;;;		    LDA	    #PMOV
		STZ	PLMODE
		JSL	>PLTYPE_RAMCLR
;
		STZ	CCHGMK
		STZ	BERFLG
		STZ	PLSWIM
;
		LDA	#03H
		STA	PLSITD
		STZ	PLMVSP
		STZ	PLXSPD
		STZ	PLYSPD
		STZ	ENSTFG
;
		STZ	PLFTLN		;̒NA
;
		LDA	#CHR64+1E0H*020H ;̃LN^[w߂
		STA	PCHTRF
;
;-------------- ϐgACeohnm^neehtOZbg ----------
;
		MI8
;
		LDX	CHG_ITEM_SW_PT
		BEQ	PLRETN_024
;
PLRETN_022	EQU	$
		STZ	CHG_ITEM_SW-1,X
		DEX
		BNE	PLRETN_022
		STZ	CHG_ITEM_SW_PT
;
PLRETN_024	EQU	$
;
		MI16
;
PLRETN_030	EQU	$
		RTS
;
;************************************************************************
;*		R[XC^Cgf					*
;************************************************************************
PLTITL		EQU	$
		LDA	P_KEY_JUMP	;l|pRg[[Zbg
		STA	MKEYC1L
		STZ	MKEYC2L
		STZ	PLSPJP		;W^o^WvLZ
		LDA	#01H		;
		STA	PSPJTM		;
;
		I8
;
		M_CHIP	M_PLCALC	;position move
;
;-------------- zaf`FbN ----------------------------------------
		LDA	PLYSPD
		BMI	PLTITL_010	;㏸H ( yes:PLTITL_010 )
		LDA	<SCCV1
		CLC
;;;;		    ADC	    #084H
		ADC	#084H+10H
		CMP	PLYPSL
		BCS	PLTITL_010	;ʒuH ( no:PLTITL_010 )
;
		STA	PLYPSL
		LDA	PLJUMP
		BEQ	PLTITL_010
		STZ	PLJUMP
		LDA	#JPET-1
		STA	PLJPTM
;
;-------------- fZbg ------------------------------------------
PLTITL_010	EQU	$
		INC	PLSTOP		;Zbg
		M_CHIPS PL_DEMO_2
;
		I16
;
		RTS
;
;************************************************************************
;*		player "Gusha" !!					*
;************************************************************************
PLZW		EQU	060H
;
HIRA_IN_XAD	EQU	$
		WORD	00003H,0FFFDH
;
HIRAADSP	EQU	$
		WORD	00010H,0FFF0H
HIRAMXSP	EQU	$
		WORD	00100H,0FF00H
;
PLGUSH		EQU	$
		LDY	POLYANG
		BEQ	PGUS0D0		;return normal mode ? ( no:PGUS0D0 )
		JMP	PGUS0FF
;
;-------------- "Hira Hira" move --------------------------------
PGUS0D0		EQU	$
;
		I8
;
		LDY	POLYHIRA
		BNE	PGUS0E0		;initial ? ( no:PGUS0E0 )
;
;-------------- "Hira Hira" initial set -----------------
		LDA	#07DH		;[]
		JSL	>SOUND_3_ON
;
		LDY	PLCMKI
		LDA	PLXPSL
		CLC
		ADC	!HIRA_IN_XAD,Y
		STA	PLXPSL
		LDA	PLYPSL
		SEC
		SBC	#08H
		STA	PLYPSL
		STZ	POLYHRSD	;"Hira Hira" move flag clear !!
		INC	POLYHIRA
		STZ	POLYHRSP
		LDA	#007FH
		STA	POLYHRZM	;Y step zoom flag initial set
		JMP	PGUS0F0		;pattern no. set
;
PGUS0E0		EQU	$
		CPY	#038H
		BCC	PGUS0E2		;down move ? ( no:PGUS0E2 )
;
;-------------- "Hira Hira" down move -------------------
		LDA	PLYSPD
		CLC
		ADC	#08H
		CMP	#080H
		BMI	PGUS0E1
		LDA	#080H
PGUS0E1		EQU	$
		STA	PLYSPD
;
		M_CHIP	M_PLYCLC	;Y pos calculate
		M_CHIPS M_PLBGCK	;BG check
;
;-------------- "Hira Hira" data pointer set ------------
PGUS0E2		EQU	$
		LDA	POLYHIRA
		CMP	#079H
		BNE	PGUS0E3		;end ? ( no:PGUS0E3 )
;
;-------------- return normal mode !! -----------
		LDA	#PMOV
		STA	PLMODE		;player normal mode set !!
		STZ	PONLFFG		;tgtOJ
		STA	PLEATFG		;	  h
		BRA	PGUS0E8
;
PGUS0E3		EQU	$
		LDA	POLYHRSP
		CMP	#0180H
		BEQ	PGUS0E6		;max speed over ? ( yes:PGUS0E6 )
		CLC
		ADC	#0010H
		STA	POLYHRSP
PGUS0E6		EQU	$
		CLC
		ADC	POLYHRSD
		STA	POLYHRSD
;
;-------------- "Hira Hira" character set ---------------
PGUS0E8		EQU	$
		LDA	POLYHIRA
		STA	R9		;(R9)  <-- "Hira Hira" data pointer
		LDA	#BANK CIPCHD
		STA	R10		;(R10) <-- chara data address(B)
		LDA	#CIPCHD+40E0H
		STA	R11		;(R11) <--	    "        (L,H) (front view)
		LDA	#CIPCHD+6060H
		STA	R12		;(R12) <--	    "        (L,H) (back   '  )
		LDA	POLYHRZM
		XBA
		STA	R8		;(R8)  <-- Y step zoom flag
		M_CHIP	HIRACHR
;
PGUS0F0		EQU	$
		LDA	#PO01		;pattern no. set
		LDY	POLYHIRA
		CPY	#068H
		BCS	PGUS0F2
		LDA	#PO02		;pattern no. set
PGUS0F2		EQU	$
		JMP	PGUS090
;
		IDX16
;
;-------------- polygon "Gusha" move ----------------------------
PGUS0FF		EQU	$
		STZ	POLYHIRA	;"Hira Hira" pointer clear !!
;
		LDA	POLYHIGH	;(A) <-- Y zoom size
		BPL	PGUS000		;zoom ok size ? ( yes:PGUS000 )
;
		LDA	#CIPCHD+080H	;(X) <-- chara data address
		BRA	PGUS060
;
PGUS000		EQU	$
		LDY	POLYMUK
		DEY
		BNE	PGUS050		;player Y small zoom ? ( no:PGUS050 )
;
;-------------- player Y small zoom -----------------------------
		CLC
		ADC	#04H
		XBA
		STA	4204H
		LDA	#01CH
		STA	4206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
;
		M16
;
		LDA	4214H
		STA	R11		;(R11) <-- x{
		LDA	#0100H
		STA	R6		;(R6)  <-- w{
		STZ	R3		;(R3)  <-- rbg}bvWQw
		LDA	#20H
		STA	R2		;(R2)  <--	  h	   Qx
		LDA	#010H
		STA	R8		;(R8)  <-- SQw
		LDA	#01FH
		STA	R9		;(R9)  <--   hQx
		LDA	#CIPCHD+40E0H	;chara data address
		STA	R12
		LDA	#BANK CIPCHD
		STA	R13
;
		I8
;
		M_CHIP	C_32_ZOOM_XY
;
		LDA	#PC00		;pattern no. set
		BRA	PGUS090
;
;-------------- player polygon chara set ------------------------
PGUS050		EQU	$
		LDA	#CIPCHD+40E0H
PGUS060		EQU	$
		STA	R11		;(R11) <--	    "        (L,H)
		LDA	#BANK CIPCHD
		STA	R10		;(R10) <-- chara data address(B)
		LDA	POLYPLXL
		LDY	PLCMKI
		BNE	PGUS070
		EOR	#0FFFFH
		INC	A
PGUS070		EQU	$
		STA	R1		;(R1)  <-- OBJ X pos
		LDA	#-PLZW
		STA	R2		;(R2)  <--  "  Y  "
		LDA	POLYZPS
		STA	R3		;(R3)  <--  "  Z  "
		LDA	POLYANG
		AND	#00FFH
		STA	R4		;(R4)  <-- angle
;
		I8
;
		M_CHIP	POLYCHR
;
		LDA	CCWORK0
		LDY	PLCMKI
		BNE	PGUS080
		EOR	#0FFFFH
		INC	A
PGUS080		EQU	$
		CLC
		ADC	POLYXPS
		STA	PLXPSL	       ;player X pos set
		LDA	POLYYPS
		CLC
		ADC	CCWORK1
		STA	PLYPSL	       ;   "   Y    "
;
		LDA	#PO00		;pattern no. set
PGUS090		EQU	$
		STA	PLPATN
;
		I16
;
;;;;		    STZ	    ONLFFG	    ;lift on flag cancel !!
		RTS
;
;************************************************************************
;*		player chara change move				*
;************************************************************************
;
CCHGDT		EQU	$
CCHGDE		EQU	$		;bV[
		WORD	CIPCHD+40E0H+1F00H
		HEX	20
		HEX	0B,0F, 0F,13, 0B,0F, 0F,14, 0B,0F, 0F,14, 0B,0F, 0F,13
		HEX	0A,0F, 0F,12, 09,12, 16,18, 08,13, 15,19, 02,04, 08,19
		HEX	01,0E, 0E,19, 00,0E, 0E,19, 00,0E, 0E,18, 00,0E, 0E,18
		HEX	00,0E, 0E,19, 00,0F, 0F,1B, 01,10, 10,1C, 01,10, 10,1E
		HEX	02,10, 10,1E, 04,11, 11,1E, 04,11, 11,1E, 04,11, 11,1E
		HEX	03,10, 10,1E, 02,10, 10,1E, 02,10, 10,1E, 02,0F, 0F,1E
		HEX	02,0F, 0F,1E, 03,13, 19,1E, 03,12, 1A,1F, 04,11, 1B,1F
		HEX	05,11, 1C,1E, 09,10, 10,11, 0A,10, 10,10, 0B,0C, 0E,0F
;
CCHGDG		EQU	$		;N}
		WORD	CIPCHD+60C0H+1700H
		HEX	15
		HEX	03,10, 10,1E, 02,10, 10,1E, 02,10, 10,1F, 01,0F, 0F,1F
		HEX	01,0F, 0F,1F, 00,0F, 0F,1E, 00,0F, 0F,1E, 00,0F, 0F,1F
		HEX	01,0F, 0F,1F, 01,0F, 0F,1F, 02,0F, 0F,1E, 03,0F, 0F,1E
		HEX	05,0F, 0F,1D, 08,0F, 0F,1C, 08,0F, 0F,1B, 08,0F, 0F,19
		HEX	09,0E, 0E,16, 09,0E, 0E,14, 0A,0E, 0E,13, 0B,0E, 0E,12
		HEX	0C,0D, 0F,11
CCHGDJ		EQU	$		;O
		WORD	CIPCHD+60E0H+1F00H
		HEX	16
		HEX	00,07, 09,1D, 00,14, 14,1E, 00,14, 14,1F, 00,14, 14,1F
		HEX	01,14, 14,1F, 01,14, 14,1F, 02,14, 14,1E, 01,13, 13,1E
		HEX	01,12, 12,1D, 01,11, 11,1D, 01,10, 10,1D, 01,0F, 0F,1C
		HEX	02,0F, 0F,1C, 03,0F, 0F,1B, 05,0F, 0F,1A, 09,0F, 0F,19
		HEX	09,0F, 0F,17, 0A,11, 13,14, 13,14, 14,16, 13,14, 14,14
		HEX	13,13, 15,16, 13,13, 13,13
CCHGDK		EQU	$		;
		WORD	CIPCHD+0020H+1700H
		HEX	18
		HEX	0A,0E, 0E,0F, 07,0F, 0F,13, 05,15, 1C,1D, 04,17, 1B,1D
		HEX	03,18, 1B,1D, 02,12, 12,1D, 02,12, 12,1E, 01,12, 12,1F
		HEX	01,12, 12,1F, 01,12, 12,1F, 02,12, 12,1F, 02,11, 11,1D
		HEX	03,19, 1B,1E, 04,17, 1B,1E, 06,15, 1B,1E, 09,17, 1C,1D
		HEX	09,0F, 0F,18, 09,0F, 0F,17, 0A,0F, 0F,15, 0B,0E, 0E,14
		HEX	11,12, 12,13, 0F,12, 12,13, 0F,11, 11,13, 0F,10, 10,12
CCHGDL		EQU	$		;wRv^[
		WORD	CIPCHD+00A0H+1B00H
		HEX	18
		HEX	04,11, 11,19, 03,11, 11,1A, 02,11, 11,19, 02,0C, 0E,15
		HEX	02,04, 06,14, 05,11, 11,14, 04,12, 12,14, 03,03, 05,15
		HEX	02,13, 13,16, 02,13, 13,16, 02,17, 1A,1D, 02,19, 1E,1E
		HEX	03,1B, 1E,1E, 04,1D, 1F,1F, 05,1D, 1F,1F, 06,1D, 1F,1F
		HEX	06,13, 18,1F, 06,13, 1B,1E, 06,13, 1E,1E, 07,13, 1A,1D
		HEX	08,0A, 0C,13, 08,15, 17,1B, 10,11, 11,13, 11,11, 11,12
CCHGDM		EQU	$		;D
		WORD	CIPCHD+2000H+1E00H
		HEX	1E
		HEX	0D,11, 15,19, 04,12, 14,1A, 04,12, 14,1A, 05,12, 14,1A
		HEX	06,12, 14,1A, 05,11, 11,1C, 05,11, 11,1C, 04,11, 11,1C
		HEX	03,11, 11,1C, 03,11, 11,1A, 03,11, 11,1A, 03,11, 11,1A
		HEX	03,11, 11,1A, 03,11, 11,1A, 02,11, 11,1A, 02,11, 11,1A
		HEX	02,11, 11,1A, 02,15, 17,1A, 02,16, 18,1A, 02,15, 17,1A
		HEX	02,10, 10,1A, 03,0F, 0F,1A, 07,0E, 0E,1B, 06,0E, 0E,1B
		HEX	06,0F, 0F,1B, 06,0F, 0F,1A, 06,0F, 0F,18, 06,0E, 0E,0F
		HEX	07,0D, 0D,0E, 08,0D, 0D,0D
CCHGDN		EQU	$		;LmR
		WORD	CIPCHD+4080H+1F00H
		HEX	16
		HEX	0D,0F, 0F,12, 0B,0F, 0F,14, 0A,0F, 0F,15, 09,0F, 0F,16
		HEX	09,0F, 0F,16, 09,0F, 0F,16, 09,0F, 0F,15, 0A,0F, 0F,14
		HEX	08,0F, 0F,16, 06,0F, 0F,19, 05,0F, 0F,1A, 04,0F, 0F,1B
		HEX	04,0F, 0F,1B, 04,0F, 0F,1B, 05,0F, 0F,1A, 05,0F, 0F,1A
		HEX	06,0F, 0F,19, 07,0F, 0F,18, 08,0F, 0F,17, 09,0F, 0F,16
		HEX	0B,0F, 0F,15, 0D,0F, 0F,12
;;;;CCHGDO	    EQU	    $		    ;eN
;;;;		    WORD    CIPCHD+6010H+0EF8H
;;;;		    HEX	    10
;;;;		    HEX	    08,0D, 12,17, 08,0D, 12,17, 09,0F, 0F,16, 0A,0F, 0F,15
;;;;		    HEX	    0B,0F, 0F,14, 0A,0F, 0F,15, 0A,0F, 0F,15, 09,0F, 0F,16
;;;;		    HEX	    09,0F, 0F,16, 09,0F, 0F,16, 09,0F, 0F,16, 0A,0F, 0F,15
;;;;		    HEX	    0A,0F, 0F,15, 0B,10, 10,14, 0C,11, 11,13, 0E,11, 14,14
;
CCHGTP		EQU	$			;[CCHGEN]
		WORD	CCHGDE			;[0] ʂ̃bV[
		WORD	CCHGDG			;[1] N}
		WORD	CCHGDJ			;[2] O
		WORD	CCHGDL			;[3] wRv^[
		WORD	CCHGDM			;[5] D
		WORD	CCHGDN			;[6] LmR
		WORD	CCHGDK			;[7] 
;;;;		    WORD    CCHGDO		    ;[8] ΂񂭂
;
CCHGPT		EQU	$
		WORD	P000			;[0] ʂ̃bV[
		WORD	CA00			;[1] N}
		WORD	MG02			;[2] O
		WORD	HR00			;[3] wRv^[
		WORD	TR00			;[5] D
		WORD	KS00			;[6] LmR
		WORD	CR03			;[7] 
;;;;		    WORD    SK00		    ;[8] ΂񂭂
;
PCGWHS		EQU	$
		WORD	00AH,004H
PCGCOL		EQU	$
		WORD	03FFH,023FH,001FH,4010H,7C00H,7E00H,47E0H,03F4H
;
CHGCOL		EQU	$
		WORD	003FFH,0031FH,0021FH,0011FH,0001FH,02018H,04010H,06008H
		WORD	07C00H,07D00H,07E00H,06300H,047E0H,023EAH,003F4H,003FAH
CHGEXA		EQU	$
		WORD	0000CH,00006H
;
PLCCHG		EQU	$
		LDA	#0FFH
		STA	ENSTFG		;enemy stop !!
		STA	SCRONF		;t[XN[Zbg
;
		LDY	CCHGFG
		BNE	PCG0E0		;ႪށH ( no:PCG0E0 )
		RTS
;
PCG0E0		EQU	$
		DEY
		DEY
		DEY
		BPL	PCG0F0		;@̃f^}Sh҂҂hH ( no:PCG0F0 )
		JMP	PCG0222
;
PCG0F0		EQU	$
		BNE	PCG020		;J[ÂH ( no:PCG020 )
;
;-------------- start C.G fade ----------------------------------
		LDA	>CLFDCNT
		CMP	#020H
		BCC	PCG002
;
		LDA	#-80H
PCG000		EQU	$
		STA	CCHGCT
		LDA	#00
		STA	>CLFDCNT
		INC	CCHGFG
		RTS
;
PCG002		EQU	$
		LDA	#MOTOCOL
		LDY	#CHNGCOL
PCG004		EQU	$
		STA	>MOTOADR
		TYA
		STA	>CHNGADR
;
		I8
;
		M_CHIP	COLFADE
;
		I16
;
		BRA	PCG0222
;
PCG020		EQU	$
;
;-------------- start chara change ------------------------------
		DEY
		BNE	PCG0212
;
;-------------- ϐgpʃZbg ------------------------
		LDA	#070H		 ;[]
		JSL	>SOUND_3_ON
;
		I8
;
		LDA	#CCHG0		;(A) <-- exstra no.
		JSL	>EXINSR
		LDX	PLCMKI
		LDA	PLXPSL
		CLC
		ADC	!CHGEXA,X
		STA	EXXPSL,Y	;X pos set
		LDA	PLYPSL
		STA	EXYPSL,Y	;Y pos set
		LDA	#0F0H
		STA	EXTIM0,Y	;timer set
;
		I16
;
		INC	CCHGFG
		RTS
;
PCG0212		EQU	$
		DEY
		BNE	PCG040
;
		LDA	CCHGCT
		CMP	#0100H
		BMI	PCG022
;
		LDX	CCHGEN		;change muki set
		STX	CCHGMK
;
		LDA	#00		;(A) <-- CCHGCT set data
		JMP	PCG000
;
PCG022		EQU	$
		LDA	CCHGCT
		CLC
		ADC	#02H
		STA	CCHGCT
		BPL	PCG0302
;
PCG0222		EQU	$
		LDA	#00
PCG0302		EQU	$
		STA	R3
		LDX	CCHGMK
		LDA	!CCHGTP,X	;(A) <-- from chara address
		STA	R1
		LDX	CCHGEN
		LDA	!CCHGTP,X	;(Y) <-- to chara address
		STA	R2
		LDA	#BANK CCHGDT
		STA	R0
		STZ	R4		;(R4) <-- vbgwW
		LDA	#020H
		STA	R5		;(R5) <-- vbgxW
;
		I8
;
		M_CHIP	CCHANGE
;
		I16
;
PCG031		EQU	$
		RTS
;
;-------------- end C.G fade ------------------------------------
PCG040		EQU	$
		LDA	>CLFDCNT
		CMP	#020H
		BCS	PCG090
		LDA	#CHNGCOL
		LDY	#MOTOCOL
		JSR	PCG004
		JMP	PCG031
;
PCG090		EQU	$
;
;-------------- return to normal move ---------------------------
PCG120		EQU	$
		LDA	#00
		STA	>CLFDCNT
		STZ	CCHGFG
		STZ	ENSTFG
		LDA	#PMOV
		STA	PLMODE
		STZ	PLMVSP
		STZ	PLXSPD
		STZ	PLYSPD
		STZ	PLDOSN		;hhX[htONA[
;
		LDX	CCHGMK
		STX	PLTYPE		;vC[^CvmDZbg
		BEQ	PCG130		;chara change player ? ( no:PCG130 )
;
		LDA	#0500H		;ϐg^C}[Zbg
		STA	PCHNG_TM
		STZ	PLSWIM		;jLZ
		BRA	PCG140
;
PCG130		EQU	$
;
PCG140		EQU	$
		LDA	!CCHGPT,X	;(Y) <-- go to chara change initial pattern
		STA	PLPATN
		JSL	>PLTYPE_RAMCLR
		JMP	(!PCHNG_INIT,X) ;vC[^CvʏZbg
;
;----------------------------------------------------------------
;-		player change pattern set			-
;----------------------------------------------------------------
PCGPST3		EQU	$
		TXY
		STA	<WORK
		ASL	A
		STA	<WORK+2
		STA	<WORK+4
		LDA	#WOB7CHR+(40H*20H)
PCGP10		EQU	$
		STA	PCHNO0,X
		CLC
		ADC	#0200H
		STA	PCHNO0+2,X
		CLC
		ADC	#0200H
		INX
		INX
		INX
		INX
		DEC	<WORK
		BNE	PCGP20
		LDA	#WOB7CHR+(40H*20H)+020H*2
PCGP20		EQU	$
		DEC	<WORK+2
		BNE	PCGP10
;
		M8
;
		LDA	#BANK WOB7CHR
		TYX
PCGP30		EQU	$
		STA	PCHNO0+2,X
		INX
		INX
		INX
		INX
		DEC	<WORK+4
		BNE	PCGP30
;
		M16
;
		RTS
;
;************************************************************************
;*		vC[^Cvʂq`lNA[			*
;************************************************************************
PLTYPE_RAMCLR	EQU	$
		PHP			;(P) save
;
		MI16
;
		PHX			;(X) save
;
		STZ	PLDOSN		;hhX[hLZ
		STZ	PLNAGE		;^}SLZ
		STZ	PLSLIP		;XbvLZ
		STZ	PLSITD		;LZ
		STZ	PLWALK		;p^[JE^[Zbg
;
		LDX	#PLTYPE_RAM_E-PLTYPE_RAM-2
PLTYPE_RMCL_010 EQU	$
		STZ	PLTYPE_RAM,X
		DEX
		DEX
		BPL	PLTYPE_RMCL_010
;
		PLX			;(X) load
		PLP			;(P) load
		RTL
;
;************************************************************************
;*		vC[^CvʏZbg				*
;************************************************************************
PCHNG_INIT	EQU	$
		WORD	YOSSY_INIT	;[0] bV[
		WORD	CAR_INIT	;[1] N}
		WORD	MOGURA_INIT	;[2] O
		WORD	HERI_INIT	;[3] wRv^[
		WORD	TRAIN_INIT	;[5] D
		WORD	YOSSY_INIT	;[6] LmR
		WORD	SBMARIN_INIT	;[7] 
;;;;		    WORD    BOMB_INIT	    ;[8] eN
;
;****************************************************************
;*		bV[Zbg				*
;****************************************************************
YOSSY_INIT	EQU	$
		RTS
;
;****************************************************************
;*		܂񏉊Zbg				*
;****************************************************************
CAR_INITL	EQU	$
		JSR	CAR_INIT
		JMP	CHANGE_TYPE_IN
;
CAR_INIT	EQU	$
		STZ	PLLFTX		;^C̎̂wWNA
		STZ	PLCFTX		;	@h
		STZ	PLRFTX		;E	@h
		STZ	PLLFTY		;^C̎̂xWNA
		STZ	PLCFTY		;	@h
		STZ	PLRFTY		;E	@h
		STZ	PLFTLN		;̒NA
		STZ	CARYSW		;Lтx	@h
		LDA	#00100H
		STA	CARZOM		;c{Zbg
		STZ	CARANG		;]pNA
		STZ	CARCT0		;L`FWJE^[NA
		STZ	PLBGCR		;
		STZ	PLBGSV		;ȎNA
		STZ	CARFTF		;L΂tONA
		STZ	PLANSV
		STZ	CARBGF		;aftO
		STZ	CARSKV		;px
		STZ	CARBDY		;{fB[LtONA
		STZ	RAMCK0
		STZ	RAMCK1
		STZ	RAMCK2
		STZ	RAMCK3
		STZ	RAMCK4
		STZ	PLTIM0
		RTS
;
;;;;;****************************************************************
;;;;;*		    eNZbg				    *
;;;;;****************************************************************
;;;;BOMB_INIT	    EQU	    $
;;;;		    LDA	    #00003	    ;J[CfbNXZbg
;;;;		    STA	    PLCNT0
;;;;		    ASL	    A
;;;;;		    LDA	    #00006	    ;J[Zbg
;;;;		    STA	    PLCLOR
;;;;		    LDA	    #00400H	    ;J[`FW^C}[Zbg
;;;;		    STA	    PLTIM0
;;;;		    STZ	    PLCCNT	    ;Lp^[`FWJE^[NA
;;;;		    STZ	    PLBANG	    ;tONA
;;;;		    STZ	    PLBMSW	    ;XCb`NA
;;;;		    STZ	    PLDMGF	    ;_[WtO
;;;;		    RTS
;
;****************************************************************
;*		wRv^[Zbg				*
;****************************************************************
HERI_INITL	EQU	$
;
CHANGE_TYPE_IN	EQU	$
		STZ	MKEYC1L
		STZ	MKEYC2L
		JSR	PL_MOVE_CALL
		RTL
;
HERI_INIT	EQU	$
		STZ	PHR_ANGL
		STZ	PHR_MKCG
		STZ	PHR_FMKF
		STZ	PHR_MCTM
		RTS
;
;****************************************************************
;*		͏Zbg				*
;****************************************************************
SBMARIN_INIT	EQU	$
		STZ	PSB_ANGL
		RTS
;
;****************************************************************
;*		OZbg				*
;****************************************************************
MOGURA_INIT	EQU	$
		STZ	PMG_ANGL
		STZ	PMG_MVMK
		STZ	PMG_TOAN
		STZ	PMG_KEYF
		STZ	PMG_CNVKEY
		RTS
;
;****************************************************************
;*		DԏZbg					*
;****************************************************************
TRAIN_INIT	EQU	$
		LDA	PLCMKI
		BEQ	TRAIN_INIT_050
		LDA	#80H*100H
TRAIN_INIT_050	EQU	$
		STA	PTR_ANGL
		STZ	PTR_MODE
		STZ	PTR_MANG
		STZ	PTR_PTNO
		STZ	PTR_WALK
		LDA	#0100H
		STA	PTR_ZOOM
		RTS
;
;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;o		chara change player move			o
;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
CCHGMV		EQU	$
		LDA	PCHNG_TM
		SEC
		SBC	#020H
		BCC	CHGMFF		;ϐgH ( yes:CHGMFF )
;
		CMP	#0C0H
		BCS	CHGM00		;xZbgH ( no:CHGM00 )
		INC	A
		AND	#03FH
		BNE	CHGM00		;xZbgH ( no:CHGM00 )
;
;-------------- xZbg ------------------------------------
		LDA	#07FH		;[]
		JSL	>SOUND_3_ON
		BRA	CHGM00
;
;-------------- ϐgII ------------------------------------
CHGMFF		EQU	$
		LDA	#PRET		;vC[XN[[h
		STA	PLMODE
		STZ	PLWRK0		;]pxZbg
;
		I8
;
		LDA	#AWABR		;(A) <-- ʂmD
		JSL	>EXINSR
		TYX			;(X) <-- ʃCfbNX
		LDA	PLXPSL
		CLC
		ADC	#08H
		STA	EXXPSL,X
		LDA	PLYPSL
		CLC
		ADC	#014H
		STA	EXYPSL,X
		LDA	#0BH
		STA	EXWRK0,X
		LDA	#0FFH
		STA	EXWRK2,X
		STZ	EXCHPT,X
		LDA	#02H
		STA	EXTIM0,X
;
		I16
;
CHGM00		EQU	$
		JMP	PLMV_SUB
;
;
;
;
;
;************************************************************************
;*		glhm^ntsf				*
;************************************************************************
TONNEL_INOUT	EQU	$
		LDA	CCHGTN
		BEQ	TONNEL_INOUT_10 ;glhm^ntsfH ( no:TONNEL_INOUT_10 )
;
		ASL	A		;
		ASL	A		;x4
		ORA	CCHGTK
		TAX
		JSR	(!TONINSB,X)	;move mode select
;
TONNEL_INOUT_10 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		"tonnel" in initial set move select data	-
;----------------------------------------------------------------
TONINSB		EQU	$-4		;[CCHGTN] [CCHGTK]
		WORD	TONINCHG	;[1]	  [0] glass chara change
		WORD	TONINCIN	;	  [1] "tonnel" in right BG C.G down initial
;
		WORD	TONINWRT	;[2]	  [0] "tonnel" in right BG write
		WORD	TONINCOL	;	  [1] "tonnel" in right BG C.G down
;
		WORD	TONINCIN	;[3]	  [0] "tonnel" in right BG C.G up initial
		WORD	TONINSAV	;	  [1] glass screen save
;
		WORD	TONINCOL	;[4]	  [0] "tonnel" in right BG C.G up
		WORD	TONINSAV	;	  [1] glass screen save
;
		WORD	TONINEND	;[5]	  [0] return to normal move set
		WORD	TONINLOD	;	  [1] glass screen load
;
		WORD	0		;[6]	  [0]
		WORD	TONINCHG	;	  [1] glass chara change
;
		WORD	0		;[7]	  [0]
		WORD	TONINEND	;	  [1] return to normal move set
;
;--------------------------------------------------------
;-		return to normal move set		-
;--------------------------------------------------------
TONINEND	EQU	$
		STZ	CCHGTN		;"tonnel" in/out initial set "OFF"
		LDA	#00
		STA	>CLFDCNT
		STZ	PLSTFG		;player stop "OFF"
		STZ	ENSTFG		;enemy stop "OFF"
		LDA	CCHGTK		;(Y) <-- "tonnel" muki
		EOR	#02H
		STA	CCHGTK
		RTS
;
;--------------------------------------------------------
;-		glass chara change			-
;--------------------------------------------------------
TONINCHG	EQU	$
		JSR	CHNGSUB		;glass chara change
;
		LDA	>CLFDCNT
		INC	A
		STA	>CLFDCNT
;;;;		    CMP	    #020H
		CMP	#010H
		BCS	TONININC	;chara change end ? ( yes:TONININC )
		RTS
;
;--------------------------------------------------------
;-		BG1 screen save				-
;--------------------------------------------------------
TONSVVRAD	EQU	$-(3*2)
		WORD	6800H,6C00H
TONSVBFAD	EQU	$-(3*2)
		WORD	SCRSVBF,SCRSVBF+800H
;
TONINSAV	EQU	$
;
;-------------- BG1 screen save -----------------
		PHB			;(DBR) save
		PEA	VRAMDX/100H	;(DBR) <-- VRAMDX(B)
		PLB
		PLB
;
		LDY	VRAMDX		;(Y) <-- VRAMDX set address
		LDA	>CCHGTN
		ASL	A
		TAX
		LDA	>TONSVVRAD,X
		STA	0,Y		;VRAM address set
		LDA	#10000000B
		STA	2,Y		;VRAM address inc mode set
		LDA	#10000001B+(39H*100H)
		STA	3,Y		;DMA parameter & B bus address set
		LDA	>TONSVBFAD,X
		STA	5,Y		;A bus address(L,H) set
		LDA	#BANK SCRSVBF
		STA	7,Y		;	"     (B) set
		LDA	#0800H-(20H*2)
		STA	8,Y		;number of byte set
		TXA
		CLC
		ADC	#12
		STA	10,Y		;next data set address set
		STA	VRAMDX		;end address set
;
		PLB
;
;-------------- "tonnel" in initial mode inc ------------
TONININC	EQU	$
		INC	CCHGTN
		RTS
;
;--------------------------------------------------------
;-		"tonnel" in right BG C.G up/down initial-
;--------------------------------------------------------
TONINCIN	EQU	$
		BRA	TONININC
;
;--------------------------------------------------------
;-		"tonnel" in right BG C.G up/down	-
;--------------------------------------------------------
TICOLAD		EQU	$
; CCHGTK -->		 [0]	[2]
		WORD	00002H,0FFFEH
;
TONINCOL	EQU	$
		LDX	CCHGTK		;(X) <-- "tonnel" in/out muki
		LDA	>CLFDCNT
		CLC
		ADC	!TICOLAD,X
		AND	#01EH
		STA	>CLFDCNT
		BEQ	TONININC	;C.G up/down end ? ( yes:TONININC )
;
		BIT	#02H
		BNE	TICOL020	;C.G change ? ( no:TICOL020 )
;
		AND	#01CH
		LSR	A
		STA	<WORK
		LSR	A
;;;;		CLC
		ADC	<WORK
		ASL	A
;;;;		CLC
		ADC	#04H
		TAX
;
		PHB			;(DBR) save
		PEA	DATACOL/100H
		PLB
		PLB
;
		LDY	#04H
TICOL010	EQU	$
		LDA	>COL_ADDRESS+MOGURA_MASK_COL,X
		STA	DATACOL+(05H*2),Y
		STA	MOTOCOL+(05H*2),Y
		DEX
		DEX
		DEY
		DEY
		BPL	TICOL010
;
		PLB
;
TICOL020	EQU	$
		RTS
;
;--------------------------------------------------------
;-		glass screen load			-
;--------------------------------------------------------
TONINLOD	EQU	$
;
;-------------- BG3 <-- BG1 sccreen change ------
		PHB			;(DBR) save
		PEA	SCRSVBF/100H
		PLB
		PLB
;
		LDX	#0800H-(20H*2)-2
		LDY	#0400H-2
TILOD000	EQU	$
		PHX
		LDA	#10H
		STA	<WORK
		STA	<WORK2
TILOD001	EQU	$
		PHY
		LDA	SCRSVBF+800H,X
		TAY
		AND	#03FFH
		CMP	#0180H
		BCC	TILOD002	;convert chara no. ? ( no:TILOD002 )
		CMP	#0180H+0080H
		BCC	TILOD004	;	   "         ( yes:TOLOD004 )
TILOD002	EQU	$
		LDA	#01CEH
		BRA	TILOD0040
;
TILOD004	EQU	$
		TYA
		AND	#0C07FH
		ORA	#02100H
TILOD0040	EQU	$
		PLY
		STA	SCRSVBF+0C00H,Y
		STA	SCRSVBF+1000H,Y
		DEY
		DEY
		DEX
		DEX
		DEX
		DEX
		DEC	<WORK
		BNE	TILOD001
;
		PLX
TILOD005	EQU	$
		PHY
		LDA	SCRSVBF,X
		TAY
		AND	#03FFH
		CMP	#0180H
		BCC	TILOD006	;convert chara no. ? ( no:TILOD006 )
		CMP	#0180H+0080H
		BCC	TILOD008	;	   "         ( yes:TOLOD008 )
TILOD006	EQU	$
		LDA	#01CEH
		BRA	TILOD0080
;
TILOD008	EQU	$
		TYA
		AND	#0C07FH
		ORA	#02100H
TILOD0080	EQU	$
		PLY
		STA	SCRSVBF+0C00H,Y
		STA	SCRSVBF+1000H,Y
		DEY
		DEY
		DEX
		DEX
		DEX
		DEX
		DEC	<WORK2
		BNE	TILOD005
;
		TXA
		AND	#0FFBFH
		TAX
		BPL	TILOD000
;
		PLB
;
;-------------- "tonnel" out PPU Reg. set -------
;;;;		    LDA	    #00010100B+(00000011B*100H)	    ;main & sub select set
;;;;		    STA	    MANSEL
;;;;		    LDA	    SUBADF	    ;sub/add flag set
;;;;		    EOR	    #11010011B
;;;;		    STA	    SUBADF
;
;-------------- BG3 screen write set ------------
		LDA	#18H+(LOW SCRSVBF)*100H ;(A) <-- B bus address & A bus address(L) set
		LDY	#(SCRSVBF+0C00H)/100H		;(Y) <-- A bus address(H,B) set
;
TILOD010	EQU	$
		PHB			;(DBR) save
		PEA	VRAMDX/100H
		PLB
		PLB
;
		LDX	VRAMDX
		STA	4,X		;B bus address & A bus address(L) set
		TYA
		STA	6,X		;A bus address(H,B) set
;
		LDA	#3400H
		STA	0,X		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#0800H
		STA	8,X		;number of byte set
		TXA
		CLC
		ADC	#12
		STA	10,X
		STA	VRAMDX
;
		PLB
;
TILOD020	EQU	$
		INC	CCHGTN
		RTS
;
;--------------------------------------------------------
;-		"tonnel" in right BG write		-
;--------------------------------------------------------
TONINWRT	EQU	$
		BRA	TILOD020
;
;;;;;-------------- "tonnel" in PPU Reg. set --------
;;;;		    LDA	    #00010011B+(00000100B*100H)	    ;main select set
;;;;		    STA	    MANSEL
;;;;		    LDA	    SUBADF	    ;sub/add flag set
;;;;		    EOR	    #11010011B
;;;;		    STA	    SUBADF
;;;;		    JSR	    MOGUSCST	    ;"mogura" right BG3 scrooll counter initial set
;;;;;
;;;;;-------------- "tonnel" in right BG write ------
;;;;		    LDA	    #18H+(LOW 18F800H)*100H ;(A) <-- B bus address & A bus address(L) set
;;;;		    LDY	    #18F800H/100H	    ;(Y) <-- A bus address(H,B) set
;;;;		    BRA	    TILOD010
;
;
;************************************************************************
;*		glhm^ntsfX^[gZbg		*
;************************************************************************
TONNEL_MSKBFP0	EQU	$
		WORD	1000H-2
TONNEL_MSKBFP1	EQU	$
		WORD	0800H-2,1000H-2
;
TONNEL_INOUT_IN EQU	$
		LDA	PLSTFG
		ORA	ENSTFG
		ORA	ITEMNO
		ORA	SP_SCRL_FG
		BEQ	TN_INOUT_IN_000 ;glhm^ntsfX^[gnjH ( yes:TN_INOUT_IN_000 )
		RTL
;
TN_INOUT_IN_000 EQU	$
		LDA	#04H		;[]
		JSL	>SOUND_3_ON
;
;-------------- glhm^ntsftOhnmh ------------------
		INC	CCHGTN
;
;-------------- afR}XNLZbg --------------------
		LDX	CCHGTK		;(X) <--muki
;
		PHB			;(DBR) save
		PEA	WOB7CHR/100H
		PLB
		PLB
;
		PHX
		LDA	>TONNEL_MSKBFP1,X
		TAX
		LDY	#0800H-2
TN_INOUT_IN_010 EQU	$
		STZ	WOB7CHR+1000H,X
		DEX
		DEX
		DEY
		DEY
		BPL	TN_INOUT_IN_010
;
		PLX			;(X) <--muki
		LDA	>TONNEL_MSKBFP0,X
		TAY
		LDX	#0800H-2
TN_INOUT_IN_020 EQU	$
		LDA	>CHRSVBF,X
		STA	WOB7CHR+1000H,Y
		DEY
		DEY
		DEX
		DEX
		BPL	TN_INOUT_IN_020
;
		PLB
;
		LDA	#01
		STA	PLSTFG		;player stop "ON" !!
		STA	ENSTFG		;enemy stop "ON" !!
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CHNGSUB ( BG_3 kusa data chenge sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CHNGXPS		EQU	$
		HEX	000,007,001,006,000,007,002,005
		HEX	001,006,000,007,003,004,002,005
		HEX	001,006,000,007,004,003,003,004
		HEX	002,005,001,006,000,007,005,002
		HEX	004,003,003,004,002,005,001,006
		HEX	000,007,006,001,005,002,004,003
		HEX	003,004,002,005,001,006,000,007
		HEX	007,000,006,001,005,002,004,003
;
		HEX	000,001,002,003,004,005,006,007
		HEX	007,007,007,007,007,007,007,006
		HEX	005,004,003,002,001,000,000,000
		HEX	000,000,000,000,001,002,003,004
		HEX	005,006,006,006,006,006,006,005
		HEX	004,003,002,001,001,001,001,001
		HEX	002,003,004,005,005,005,005,004
		HEX	003,002,002,002,003,004,004,003
;
		HEX	000,005,002,004,003,007,001,006
		HEX	002,004,001,006,000,005,004,005
		HEX	003,006,003,007,000,003,004,007
		HEX	001,005,001,005,000,006,001,007
		HEX	002,005,003,007,002,003,003,007
		HEX	001,007,002,006,002,006,000,005
		HEX	002,004,002,005,000,004,001,004
		HEX	000,007,003,006,000,004,001,006
;
		HEX	000,001,002,003,004,005,006,007
		HEX	007,007,007,007,007,007,007,006
		HEX	005,004,003,002,001,001,001,001
		HEX	001,001,002,003,004,005,005,005
		HEX	005,004,003,003,004,004,003,002
		HEX	002,002,002,003,004,005,006,006
		HEX	006,006,006,006,005,004,003,002
		HEX	001,000,000,000,000,000,000,000
;
		HEX	003,004,000,000,003,004,007,007
		HEX	002,005,000,000,002,005,007,007
		HEX	003,004,001,001,003,004,006,006
		HEX	001,006,000,000,001,006,007,007
		HEX	002,005,001,001,002,005,006,006
		HEX	003,004,002,002,003,004,005,005
		HEX	000,007,000,007,001,006,001,006
		HEX	002,005,002,005,003,004,003,004
;
		HEX	003,004,000,007,003,004,000,007
		HEX	002,005,001,006,003,004,000,007
		HEX	002,005,001,006,003,004,000,007
		HEX	001,006,002,005,002,005,001,006
		HEX	003,004,000,007,001,006,002,005
		HEX	002,005,001,006,003,004,000,007
		HEX	000,007,000,007,001,006,001,006
		HEX	002,005,002,005,003,004,003,004
;
CHNGYPS		EQU	$
		HEX	000,007,000,007,001,006,000,007
		HEX	001,006,002,005,000,007,001,006
		HEX	002,005,003,004,000,007,001,006
		HEX	002,005,003,004,004,003,000,007
		HEX	001,006,002,005,003,004,004,003
		HEX	005,002,000,007,001,006,002,005
		HEX	003,004,004,003,005,002,006,001
		HEX	000,007,001,006,002,005,003,004
;
		HEX	000,000,000,000,000,000,000,000
		HEX	001,002,003,004,005,006,007,007
		HEX	007,007,007,007,007,007,006,005
		HEX	004,003,002,001,001,001,001,001
		HEX	001,001,002,003,004,005,006,006
		HEX	006,006,006,006,005,004,003,002
		HEX	002,002,002,002,003,004,005,005
		HEX	005,005,004,003,003,003,004,004
;
		HEX	002,005,005,001,003,007,007,003
		HEX	001,006,004,001,000,002,004,000
		HEX	000,006,007,004,005,002,005,002
		HEX	002,007,006,003,003,007,001,003
		HEX	004,001,006,001,000,004,001,005
		HEX	005,000,006,000,003,005,007,004
		HEX	007,002,002,006,001,003,003,007
		HEX	004,006,005,002,006,000,000,004
;
		HEX	000,000,000,000,000,000,000,000
		HEX	001,002,003,004,005,006,007,007
		HEX	007,007,007,007,007,006,005,004
		HEX	003,002,002,002,002,002,003,004
		HEX	005,005,005,004,004,003,003,003
		HEX	004,005,006,006,006,006,006,005
		HEX	004,003,002,001,001,001,001,001
		HEX	001,001,002,003,004,005,006,007
;
		HEX	000,000,003,004,007,007,003,004
		HEX	000,000,002,005,007,007,002,005
		HEX	001,001,003,004,006,006,003,004
		HEX	000,000,001,006,007,007,001,006
		HEX	001,001,002,005,006,006,002,005
		HEX	002,002,003,004,005,005,003,004
		HEX	000,007,007,000,001,006,006,001
		HEX	002,005,005,002,003,004,004,003
;
		HEX	000,000,007,007,001,001,006,006
		HEX	000,000,007,007,002,002,005,005
		HEX	001,001,006,006,003,003,004,004
		HEX	000,000,007,007,002,002,005,005
		HEX	004,004,003,003,001,001,006,006
		HEX	003,003,004,004,005,005,002,002
		HEX	000,000,001,001,002,002,003,003
		HEX	004,004,005,005,006,006,007,007
;
CHNGSUB		EQU	$
;
		I8
;
		LDY	CIPSCB		;chip screen base save
		PHY
		LDY	#1AH		;	 "        change ( 706800H- )
		STY	CIPSCB
		LDY	CIPSCR		;chip screen size mode save
		PHY
		LDY	#00111100B
		STY	CIPSCR		;	 "        change ( 2 bit chara )
;
		LDX	#BANK BG3CHEG	; chip call address bank set !!
;
		I16
;
		LDA	>CLFDCNT
		ASL	A
		ASL	A
;;;;		ORA	#00000H
		TAY
;
CGB050		EQU	$
		LDA	CHNGXPS,Y
		AND	#000FFH
		STA	CCWORK0
;
		LDA	CHNGYPS,Y
		AND	#000FFH
		STA	CCWORK1
;
		PHY
;
		I8
;
		LDA	#BG3CHEG	; chip call address set !!
		JSL	>CHIPON
;
		I16
;
		PLY
		INY
		TYA
;;;;		    AND	    #00001H
		AND	#00003H
		BNE	CGB050
;
;-------------- LN^[]Zbg ----------------------------------
		PHB			;(DBR) save
		PEA	VRAMDX/100H
		PLB
		PLB			;(DBR) <-- VRAMDX(B)
;
		LDX	VRAMDX		;(X) <-- VRAMDX set pointer
		LDA	#2800H
		STA	0,X		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#18H+((LOW (WOB7CHR+1000H+800H))*100H)
		STA	4,X		;B bus address & A bus address(L) set
		LDA	#(WOB7CHR+1000H+800H)/100H
		STA	6,X		;A bus address(H,B) set
		LDA	#0800H
		STA	8,X		;number of byte set
		TXA
		CLC
		ADC	#12
		STA	10,X		;next set pointer set
		STA	VRAMDX		;end address set
;
		PLB
;
		I8
;
		PLY
		STY	CIPSCR
		PLY
		STY	CIPSCB
;
		I16
;
		RTS
;
;
;
;------------------------------------------------------------------------
;-		fobOp{XւfnII				-
;------------------------------------------------------------------------
		EXT	CORS_13_01,CORS_17_02,CORS_23_02,CORS_27_06
		EXT	CORS_33_04,CORS_37_02,CORS_43_02,CORS_47_02
		EXT	CORS_53_02,CORS_57_04,CORS_63_05,CORS_67_14
		EXT	EGG_SAVE
BOSS_NEXTGOTO	EQU	$
		BYTE	CORS_13_01, 005H,063H, PO_NORMAL    ;[1-4]
		BYTE	CORS_17_02, 004H,078H, PO_NORMAL    ;[1-8]
		BYTE	CORS_23_02, 0BBH,07AH, PO_NORMAL    ;[2-4]
		BYTE	CORS_27_06, 004H,04DH, PO_NORMAL    ;[2-8]
		BYTE	CORS_33_04, 012H,061H, PO_DK_O_D    ;[3-4]
		BYTE	CORS_37_02, 00DH,042H, PO_NORMAL    ;[3-8]
		BYTE	CORS_43_02, 006H,064H, PO_NORMAL    ;[4-4]
		BYTE	CORS_47_02, 00DH,078H, PO_NORMAL    ;[4-8]
		BYTE	CORS_53_02, 00AH,07AH, PO_NORMAL    ;[5-4]
		BYTE	CORS_57_04, 003H,04BH, PO_DK_O_U    ;[5-8]
		BYTE	CORS_63_05, 049H,064H, PO_DK_O_R    ;[6-4]
		BYTE	CORS_67_14, 004H,07AH, PO_NORMAL    ;[6-8]
;
GO_BOSS		EQU	$
		LDA	KEYC1L
		CMP	#00000011110000B
		BNE	GO_BOSS_0500
;
		LDA	MAPOINT
GO_BOSS_0050	EQU	$
		CMP	#12
		BCC	GO_BOSS_0100
;;;;		    SEC
		SBC	#12
		BRA	GO_BOSS_0050
;
GO_BOSS_0100	EQU	$
		CMP	#3
		BEQ	GO_BOSS_0150
		CMP	#7
		BNE	GO_BOSS_0500
;
GO_BOSS_0150	EQU	$
		AND	#4
		LSR	A
		LSR	A
		ORA	MPTYPE
		ASL	A
		ASL	A
		TAX
		LDA	!BOSS_NEXTGOTO,X
		STA	>NXGOTOBF
		LDA	!BOSS_NEXTGOTO+2,X
		STA	>NXGOTOBF+2
		STZ	NEXTGOTO_POS
		LDA	#01H
		STA	NEXTGOTO
		LDA	#GMIN
		STA	MODENO
		JSL	>EGG_SAVE
;
GO_BOSS_0500	EQU	$
		RTS
;
;
;
;
;
;****************************************************************
;*		player normal move				*
;****************************************************************
;
PLMOVE		EQU	$
;
;
;
;
;
player_debug	equ	$
		bra	PLMV_0010	;[fobN[h]
;
;
;
;
;
;-------------- {Xw̃fobN[h --------------------------
		JSR	GO_BOSS
;
;-------------- fobN[hZNg --------------------------
		LDA	<KEYC1L
		AND	#00110000B
		BEQ	FU010
		LDA	<KEYC2
		AND	#00001000B
		BEQ	FU010
		LDA	FUFUFU
		EOR	#01H
		STA	FUFUFU
FU010		EQU	$
		LDA	FUFUFU
		BEQ	PLMV_0010	;"FUFUFU" ? ( no:PLMV_0010 )
;
		STZ	PONLFFG
		JMP	FUFUFUSB
;----------------------------------------------------------------
;
;
;
;
;
;----------------------------------------------------------------
;-		player move					-
;----------------------------------------------------------------
PLMV_0010	EQU	$
;
;-------------- vC[`FbN ------------------------
		LDA	PLDSYL
		CMP	#0140H
		BMI	PLMV_0030	;H ( no:PLMV_0030 )
		LDA	SP_SCRL_FG
		BNE	PLMV_0030	;XN[ꃂ[hH ( yes:PLMV_0030 )
;
		LDA	#PSTP		;(A) <-- vC[Xgbv
		JSL	>TIMEUP_SET
		RTS
;
PLMV_0030	EQU	$
		LDA	CCHGMK
		BEQ	PLMV_SUB	;chara change player ? ( no:PLMV_SUB )
		JMP	CCHGMV
;
PLMV_SUB	EQU	$
		LDA	<KEYC1L		;l|pRg[[Zbg
		LDY	PLFLTM
		BEQ	PLMV_0202	;vC[_[WH ( no:PLMV_0202 )
;
		AND	#1111110011111111B
PLMV_0202	EQU	$
		STA	MKEYC1L
		LDA	<KEYC2L
		STA	MKEYC2L
PL_MOVE_CALL	EQU	$
		STZ	MSOUND1		;l|pTEhtOZbg
		STZ	MSOUND3
		LDA	BG1TYP		;l|pmDZbg
		STA	MBG1TYP
;
		I8
;
		M_CHIPS PL_MOVE
;
;-------------- TEhtOZbg ------------------------------------
		LDA	MSOUND1		;[]
		STA	<SOUND_1
		LDA	MSOUND3
		BEQ	PLMV_0220
		JSL	>SOUND_3_ON
PLMV_0220	EQU	$
;
		I16
;
		RTS
;
;************************************************************************
;*		^CAbvZbg					*
;*			in  : (A) <-- vC[[h			*
;************************************************************************
;
		MEM16
		IDX16
;
TIMEUP_SET	EQU	$
		JSL	>TIMEUP_SET_S
;
TIMEUP_SET_2	EQU	$
		LDA	#TMUP		;^CAbvf
		STA	MODENO
;;;;		    LDA	    #01H
		STA	ENSTFG
		STZ	GMFADE_CT	;J[eEBhEZbg
;
		M8			; memory 8bit mode
		STZ	!INCSNXT
		M16			; memory 16bit mode
;
		RTL
;
;------------------------------------------------------------------------
;-									-
;------------------------------------------------------------------------
TIMEUP_SET_S	EQU	$
		STA	PLMODE		;vC[[hZbg
		STA	ENSTFG		;G~tOhnmh
		STZ	PLFLSH		;vC[_ŉ
;
		LDA	#07H		;[]
		STA	SOUND_0
;
TIMEUP_SET_SS	EQU	$
		LDA	!MAPOINT
		CMP	#INT_STAT
		BEQ	TIMEUP_SET_000	;Pv|OH ( yes:TIMEUP_SET_000 )
;
		DEC	PLCONT		;vC[Z
		LDA	PLDNCT
		CMP	#999
		BCS	TIMEUP_SET_000
		INC	PLDNCT
;
TIMEUP_SET_000	EQU	$
		RTL
;
;FUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFU
;F		FUFUFU						U
;FUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFUFU
FUFUAD		EQU	$
		WORD	00000H,00000H
		WORD	00001H,00004H
		WORD	0FFFFH,0FFFCH
		WORD	0FFFFH,0FFFCH
;
FUFUFUSB	EQU	$
		STZ	PLJUMP
;
		LDA	<KEYC1
		AND	#00000011B
		ASL	A
		BIT	<KEYC1L-1
		BPL	FUSB010
		INC	A
FUSB010		EQU	$
		ASL	A
		TAX
		LDA	PLXPSL
		CLC
		ADC	!FUFUAD,X
		STA	PLXPSL
;
		LDA	<KEYC1
		AND	#00001100B
		LSR	A
		BIT	<KEYC1L-1
		BPL	FUSB020
		INC	A
FUSB020		EQU	$
		ASL	A
		TAX
		LDA	PLYPSL
		CLC
		ADC	!FUFUAD,X
		STA	PLYPSL
		RTS
;
;------------------------------------------------------------------------
;-		VbgLZ					-
;------------------------------------------------------------------------
BERO_CANCEL	EQU	$
		STZ	PLNAGE		;^}SLZ
;
BERO_CANCEL_2	EQU	$
		STZ	PLDOSN		;hhX`hLZ
;
		PHX			;(X) save
;
		LDX	EATFLG
		BNE	BERO_CANCEL_010 ;HׂĂH ( no:BERO_CANCEL_010 )
;
		LDX	EATSTP
		BEQ	BERO_CANCEL_020 ;HׂĂH ( no:BERO_CANCEL_020 )
		BRA	BERO_CANCEL_030
;
BERO_CANCEL_010 EQU	$
		LDA	BERXPS
		ORA	BERYPS
		BNE	BERO_CANCEL_011 ;ɓĂH ( no:BERO_CANCEL_011 )
;
		LDA	EATSTP
		BEQ	BERO_CANCEL_014 ;ݍށH ( yes:BERO_CANCEL_014 )
		LDA	EATSPF
		BEQ	BERO_CANCEL_040 ;XyVVbgH ( no:BERO_CANCEL_040 )
		STZ	EATSPC
		BRA	BERO_CANCEL_020
;
BERO_CANCEL_011 EQU	$
		DEX			;[-1]
		BNE	BERO_CANCEL_012 ;ԂH ( no:BERO_CANCEL_012 )
		LDA	GOAL_IN
		BNE	BERO_CANCEL_014 ;S[CH ( yes:BERO_CANCEL_014 )
BERO_CANCEL_012 EQU	$
		JSL	>ENEAT_CANCEL
		LDA	ENMOD1,X
		AND	#0110000000000000B
		CMP	#0110000000000000B
		BNE	BERO_CANCEL_014 ;ACeH ( no:BERO_CANCEL_014 )
;
		LDA	ENGPOW,X
		BNE	BERO_CANCEL_014 ;؂̎̕V[hH ( no:BERO_CANCEL_014 )
;
		JSL	>KINOMI_CANCEL
;
BERO_CANCEL_014 EQU	$
		STZ	EATFLG
		STZ	EATSTP
		STZ	EATSPF
;
BERO_CANCEL_020 EQU	$
		STZ	BERFLG
BERO_CANCEL_030 EQU	$
		STZ	BERXPS
		STZ	BERYPS
		STZ	BERO_GUNYA
		STZ	BERO_BIRI
;
BERO_CANCEL_040 EQU	$
		PLX			;(X) load
		RTL
;
;
;****************************************************************
;*		player fail move				*
;****************************************************************
PFALTM		EQU	$
		WORD	080H,005H,002H,002H,002H,00CH,006H,006H
		WORD	006H,006H,006H,006H,004H,004H,004H,004H
		WORD	004H,004H,003H,003H,003H,003H,003H,003H
		WORD	002H,002H,002H,002H,002H
PFALPT		EQU	$
		WORD	DM04,DM03,DM04,DM03,DM02,DM05
PFALPT_ROT	WORD	DM0A,DM09,DM08,DM07,DM06,DM05
PFALPT_ROT_E	EQU	$
PFLP		EQU	PFALPT-PFALTM
PFLP_ROT	EQU	PFALPT_ROT-PFALPT
PFLP_ROT_NO	EQU	PFALPT_ROT_E-PFALPT_ROT
;
PLFAIL		EQU	$
;
		I8
;
		JSL	>BERO_CANCEL	;eat cancel !!
;
		I16
;
		LDX	PLWALK
;;;;		    BEQ	    PFL070	    ;[?]
;;;;;
		LDA	PLWKTM
		BNE	PFL070		;pattern change ? ( no:PFL070 )
;
		DEX
		DEX
		BPL	PFL010
		JSL	>TIMEUP_SET_2
		INC	PLSTFG
		RTS
;
PFL010		EQU	$
		STX	PLWALK
		LDA	!PFALTM,X	;walk timer set
		CPX	#PFLP
		BCC	PFL064		;]H ( no:PFL064 )
;
		LDA	#01H
PFL064		EQU	$
		STA	PLWKTM
PFL070		EQU	$
		CPX	#PFLP_ROT
		BCC	PFL080		;]p^[H ( no:PFL080 )
;
		TXA
;;;;		    SEC
		SBC	#PFLP_ROT
PFL072		EQU	$		;]p^[ŊZ
;;;;		    SEC			;
		SBC	#PFLP_ROT_NO	;
		BCS	PFL072		;
;;;;		    CLC
		ADC	#PFLP_ROT_NO+PFLP_ROT
		TAX
;
PFL080		EQU	$
		LDA	!PFALPT,X	;player pattern no. set
		STA	PLPATN
		RTS
;
;****************************************************************
;*		player stop move				*
;****************************************************************
PLCLR0		EQU	$
		STZ	PLYUSN
PLSTMV		EQU	$
		RTS
;
;****************************************************************
;*		player Goal move ( EFCg )			*
;****************************************************************
PLGOL0		EQU	$
		STZ	MKEYC1L
		STZ	MKEYC2L
;
		I8
;
		M_CHIPS PL_DEMO_1
;
		I16
;
		RTS
;
;----------------------------------------------------------------
;-		^}SkZbg				-
;----------------------------------------------------------------
EGGWR_XAD	EQU	$
;			 [0]	[1]    [2]    [3]
		WORD	0FFFCH,00004H,0FFFCH,00004H
EGGWR_YAD	EQU	$
		WORD	0FFFCH,0FFFCH,00004H,00004H
EGGWR_XSP	EQU	$
		WORD	0FF00H,00100H,0FF80H,00080H
EGGWR_YSP	EQU	$
		WORD	0FD00H,0FD00H,0FE00H,0FE00H
EGGWR_ATT	EQU	$
		WORD	00000H,00040H,00080H,000C0H
EGGWR_TIM	EQU	$
		WORD	00010H,00010H,00001H,00001H
;
		IDX8
;
EGG_WARE_SET	EQU	$
;;;;		    LDA	    #0AH	    ;[]
;;;;		    STA	    SOUND3
;
		LDX	#(4-1)*2
EGG_WARE_SET_10 EQU	$
		LDA	#EGGWR		;(A) <-- ʂmD
		JSL	>EXINSR		;ʃGAm
		LDA	WORK0
		CLC
		ADC	>EGGWR_XAD,X
		STA	EXXPSL,Y	;ʂwWZbg
		LDA	WORK2
		CLC
		ADC	>EGGWR_YAD,X
		STA	EXYPSL,Y	;ʂxWZbg
		LDA	>EGGWR_XSP,X
		STA	EXXSPD,Y	;ʂwXs[hZbg
		LDA	>EGGWR_YSP,X
		STA	EXYSPD,Y	;ʂxXs[hZbg
		LDA	WORK4
		ORA	>EGGWR_ATT,X
		STA	EXCLOR,Y	;`ssZbg
		LDA	>EGGWR_TIM,X
		STA	EXTIM0,Y	;^C}[Zbg
		DEX
		DEX
		BPL	EGG_WARE_SET_10
		RTL
;
		IDX16
;
;****************************************************************
;*		player door in shot move			*
;****************************************************************
PSHOT_PT	EQU	$
		WORD	DR06,DR07
PSHOT_WK_PT	WORD	DR08,DR09,DR0A,DR0B,DR0C,DR0D,DR0E,DR0F
PSHOT_PT_E	EQU	$
DROUT_WK_PT	WORD	DO0A,DO0B,DO0C,DO0D,DO0E,DO0F
DROUT_WK_E	EQU	$
;
PLSHOT		EQU	$
		LDA	PLJUMP
		BEQ	PLSHOT_010	;player jump ? ( no:PLSHOT_010 )
		JMP	PLSHOT_500
;
;-------------- door in walk ------------------------------------
PLSHOT_010	EQU	$
		LDY	PLWALK		;(Y) <-- pattern counter
		LDA	PLWKTM
		BNE	PLSHOT_150	;pattern change ? ( no:PLSHOT_150 )
;
		INY
		INY
		LDA	DOORMK
		BEQ	PLSHOT_040	;hAhmH ( yes:PLSHOT_040 )
;
;-------------- hAnts --------------------------------------
		STZ	ENTRDRFG	;ԂhAtOhneeh
;
		CPY	#DROUT_WK_E-PSHOT_PT
		BCC	PLSHOT_050
		LDY	#DROUT_WK_PT-PSHOT_PT
		BRA	PLSHOT_050
;
;-------------- hAhm ----------------------------------------
PLSHOT_040	EQU	$
		INC	A		;[ LDA	#01H ]
		STA	ENTRDRFG	;ԂhAtOhnmh
;
		CPY	#PSHOT_PT_E-PSHOT_PT
		BCC	PLSHOT_050
		LDY	#PSHOT_WK_PT-PSHOT_PT
PLSHOT_050	EQU	$
		STY	PLWALK
		LDA	#06H		;(A) <-- pattern change timer
		CPY	#PSHOT_WK_PT-PSHOT_PT
		BCS	PLSHOT_100	;Up^[H ( no:PLSHOT_100 )
;
;-------------- hAhmtF[hJ[Zbg --------
		PHY			;(Y) save
;
		LDA	#MOTOCOL	;(R1) <-- ]|C^[
		STA	R1
		LDA	#CHNGCOL	;(R2) <-- ]|C^[
		STA	R2
		LDA	#0200H		;(R12) <-- ]oCg
		STA	R12
;
		I8
;
		M_CHIP	MRAM_MOVE
;
		I16
;
		PLY			;(Y) load
;
		LDX	#(15-1)*2
		LDA	#0
PLSHOT_060	EQU	$
		STA	>CHNGCOL+(80H+51H)*2,X
		DEX
		DEX
		BPL	PLSHOT_060
		LDA	#-1		;J[tF[hrsnoII
		STA	>CLFDCNT
;
		LDA	#04H		;(A) <-- pattern change timer
PLSHOT_100	EQU	$
		STA	PLWKTM		;pattern change timer set
;
PLSHOT_150	EQU	$
		LDA	!PSHOT_PT,Y
		STA	PLPATN		;player pattern set
;
		CPY	#PSHOT_WK_PT-PSHOT_PT
		BCC	PLSHOT_160	;Up^[H ( yes:PLSHOT_160 )
;
;-------------- J[tF[h ----------------------------------
		LDA	>CLFDCNT
		CMP	#020H
		BPL	PLSHOT_500	;J[tF[hIH ( yes:PLSHOT_500 )
;
		LDA	#MOTOCOL
		STA	>MOTOADR
		LDA	#CHNGCOL
		STA	>CHNGADR
;
		I8
;
		M_CHIP	COLFADE
;
		I16
;
PLSHOT_160	EQU	$
;;;;		    LDA	    PLDOOR
;;;;		    BEQ	    PLSHOT_200	    ;afm[}hAH ( no:PLSHOT_200 )
;;;;;
;;;;;-------------- wʒu␳ --------------------------------------
;;;;		    LDA	    PLXPSL
;;;;		    AND	    #0FH
;;;;		    CMP	    #08H
;;;;		    BEQ	    PLSHOT_200	    ;player X pos hosei ? ( no:PLSHOT_200 )
;;;;;
;;;;		    INC	    PLXPSL
;;;;		    BCC	    PLSHOT_200
;;;;		    DEC	    PLXPSL
;;;;		    DEC	    PLXPSL
;;;;;
;;;;PLSHOT_200	    EQU	    $
		RTS
;
PLSHOT_500	EQU	$
		LDA	PLDOOR
		CMP	#DR
		BEQ	PLSHOT_550	;afhAH ( yes:PLSHOT_550 )
;
;;;;;-------------- ˃Vbg ------------------------------------
;-------------- XL[bV[ϐghA --------------------------
;
		MI8
;
		JSR	SKI_DOOR_CK
;
		MI16
;
		BEQ	PLSHOT_600	;XL[bV[ϐghAR[XH ( yes:PLSHOT_600 )
;
		STZ	PLDOOR		;XL[bV[ϐghALZII
;;;;		    LDA	    PLJUMP
;;;;		    STA	    PLPATN	    ;player pattern set
;;;;;;;;		LDA	#01
;;;;;;;;		STA	SCRONF		;scroll "ON" !!
;;;;;
;;;;		    LDA	    PLDSYL
;;;;		    CMP	    #0FF80H
;;;;		    BMI	    PLSHOT_550	    ;next go to ? ( no:PLSHOT_550 )
;;;;;
;;;;		    I8
;;;;;
;;;;		    M_CHIP  M_PLYCLC	    ;Y pos calculate
;;;;;
;;;;		    I16
;;;;;
PLSHOT_502	EQU	$
		RTS
;
;;;;;-------------- next go to !! -----------------------------------
;;;;PLSHOT_510	    EQU	    $
;;;;		    LDA	    DOORMK
;;;;		    BNE	    PLSHOT_700	    ;hAntsH ( yes:PLSHOT_700 )
;;;;;
;-------------- hAhm --------------------------------
PLSHOT_550	EQU	$
		JSL	>GO_NEXTGOTO
		RTS
;
;-------------- hAnts --------------------
PLSHOT_600	EQU	$
		LDA	#BD
		STA	PLDOOR
		STZ	PLMVSP		;wXs[hLZ
;
		LDA	PLTYPE
		BNE	PLSHOT_700	;hAntsH ( yes:PLSHOT_700 )
;
		LDA	DOORMK
		BEQ	PLSHOT_620	;hAĂnodmX^[gH ( no:PLSHOT_620 )
;
		LDA	#P_SKI
		STA	PLTYPE		;XL[bV[w
		JSL	>PLTYPE_RAMCLR
;
DOOR_OUT_IN	EQU	$
		LDA	#PSHT
		STA	PLMODE
		INC	DOORMK
		LDA	#DROUT_WK_PT-PSHOT_PT-2
		STA	PLWALK
		STZ	PLWKTM
;
;-------------- hAntstF[hJ[Zbg -
		LDA	P_COLOR
		ASL	A		;x2
		STA	PCOLTR
		JSL	>PLCOLTR
;
		LDA	#MOTOCOL	;(R1) <-- ]|C^[
		STA	R1
		LDA	#CHNGCOL	;(R2) <-- ]|C^[
		STA	R2
		LDA	#0200H		;(R12) <-- ]oCg
		STA	R12
;
		I8
;
		M_CHIP	MRAM_MOVE
;
		I16
;
		LDA	#0		;J[tF[hJE^[Zbg
		STA	>CLFDCNT
		LDX	#(15-1)*2
PLSHOT_610	EQU	$
		STA	>DATACOL+(80H+51H)*2,X
		STA	>MOTOCOL+(80H+51H)*2,X
		DEX
		DEX
		BPL	PLSHOT_610
;
PLSHOT_620	EQU	$
		RTS
;
;-------------- hAnts ------------------------------
PLSHOT_700	EQU	$
		LDA	SCRL_STOP
		BNE	PLSHOT_710	;hAntsInjH ( no:PLSHOT_710 )
;
		STZ	PLMODE
		STZ	PLCMKI
		STZ	PLWALK
PLSHOT_710	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		XL[bV[ϐghAR[X`FbN			-
;-			out :						-
;-				(Z) <-- 1:XL[bV[ϐghAR[XI-
;------------------------------------------------------------------------
SP_DOOR_CORS	EQU	$
		BYTE	(5-1)*12+(3-1)	;5W-3
		BYTE	(5-1)*12+(9-1)	;5W-9
SP_DOOR_CORS_E	EQU	$
;
		MEM8
		IDX8
;
SKI_DOOR_CK	EQU	$
		LDA	BG1TYP
		CMP	#4
		BNE	SKI_DOOR_CK_020 ;R[XH ( no:SKI_DOOR_CK_020 )
		LDX	CORSNO
		CPX	#3
		BNE	SKI_DOOR_CK_020 ;R[XmDRH ( no:SKI_DOOR_CK_020 )
		LDX	#SP_DOOR_CORS_E-SP_DOOR_CORS-1
		LDA	MAPOINT
SKI_DOOR_CK_010 EQU	$
		CMP	!SP_DOOR_CORS,X
		BEQ	SKI_DOOR_CK_020 ;hAntsցH ( yes:SKI_DOOR_CK_020 )
		DEX
		BPL	SKI_DOOR_CK_010
SKI_DOOR_CK_020 EQU	$
		RTS
;
		MEM16
		IDX16
;
;************************************************************************
;*		player OAM set						*
;************************************************************************
;
		MEM8
		IDX8
;
;-------------- vC[StbV^C}[f[^ ------------------
FLSHTM		EQU	$
		WORD	00H,00H,01H,01H
		WORD	02H,02H,04H,04H,04H,04H,04H,04H
;
PLCSET		EQU	$
;
		MI16
;
		LDA	PLXSDR
		STA	PLXSDR_OLD
		LDA	PLXPSL
		STA	PLXPSL_OLD	;player work X pos set
		SEC
		SBC	ESCCH1
		STA	PLDSXL		;display X pos set
		STA	R1
		CLC
		ADC	BRXPSL
		STA	BRDSXL
;
		LDA	PLYSDR
		STA	PLYSDR_OLD
		LDA	PLYPSL
		STA	PLYPSL_OLD	;player work Y pos set
		SEC
		SBC	ESCCV1
		STA	PLDSYL		;display Y pos set
		STA	R2
		CLC
		ADC	BRYPSL
		STA	BRDSYL
;
		LDA	PLYUSN
		BEQ	PCS050		;OAM not set ? ( yes:PCS050 )
;
		LDA	PLSTFG
		ORA	BIRIBIRI
		ORA	PROTSP
		ORA	ITEMNO
		BNE	PCS010		;vC[~H ( yes:PCS010 )
;
		LDA	SUPER_FLAG
		BNE	PCS006		;}IvC[H ( yes:PCS006 )
;
		LDA	PCHNG_TM
		BEQ	PCS008		;ϐgH ( no:PCS008 )
;
PCS006		EQU	$
		CMP	#0C0H
		BCS	PCS008		;߂H ( no:PCS008 )
;
		STA	<WORK
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ASL	A
		TAX
		LDA	>FLSHTM,X
		AND	<WORK
		BEQ	PCS010		;_ł̕\^C~OH ( yes:PCS010 )
		BRA	PCS050
;
PCS008		EQU	$
		LDA	PLFLSH
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ASL	A
		TAX
		LDA	FRCNT2
		AND	>FLSHTM,X
		BNE	PCS050		;OAM not set ? ( yes:PCS050 )
;
PCS010		EQU	$
		LDA	PLCMKI
		STA	R3
		LDA	PLPATN
		TAY
		ASL	A
		TAX
		LDA	>CHDTIN,X
		CLC
		ADC	#CHYPAD
		STA	R14
		TYX
		LDA	>CHDTNO,X
		AND	#00FFH
		STA	R12
;
		I8
;
		M_CHIP	PLAYOAM
;
PCS050		EQU	$
;
		MI8
;
		LDA	#03H		;vC[naiD揇ʃZbg
		STA	PLYUSN
		LDA	#0AH		;vC[J[Zbg
		STA	PLCLOR
		RTL
;
;************************************************************************
;*		player color transfer set				*
;************************************************************************
PCOLTBL		EQU	$			;[PCOLTR]
		WORD	PLAY_0_COL+(15-1)*2	;[0]
		WORD	PLAY_1_COL+(15-1)*2	;[2]
		WORD	PLAY_2_COL+(15-1)*2	;[4]
		WORD	PLAY_3_COL+(15-1)*2	;[6]
		WORD	PLAY_4_COL+(15-1)*2	;[8]
		WORD	PLAY_5_COL+(15-1)*2	;[A]
		WORD	PLAY_6_COL+(15-1)*2	;[C]
		WORD	PLAY_7_COL+(15-1)*2	;[E]
;
		WORD	PLAY_FADE_0+(15-1)*2	;[10]
		WORD	PLAY_FADE_1+(15-1)*2	;[12]
		WORD	PLAY_FADE_2+(15-1)*2	;[14]
		WORD	PLAY_FADE_3+(15-1)*2	;[16]
		WORD	PLAY_FADE_4+(15-1)*2	;[18]
		WORD	PLAY_FADE_5+(15-1)*2	;[1A]
		WORD	PLAY_FADE_6+(15-1)*2	;[1C]
;
PLCOLTR		EQU	$
		PHP			;(P) save
;
		MI16
;
		PHA			;(A)   "
		PHX			;(X)   "
		PHY			;(Y)   "
		PHB			;(DBR) "
;
		LDX	PCOLTR
;
		PEA	DATACOL/100H	;(DBR) <-- DATACOL(B)
		PLB
		PLB
;
		LDA	>PCOLTBL,X
		TAX
		LDY	#(15-1)*2
PCOLT010	EQU	$
		LDA	>COL_ADDRESS,X
		STA	DATACOL+(80H+51H)*2,Y
		STA	MOTOCOL+(80H+51H)*2,Y
		DEX
		DEX
		DEY
		DEY
		BPL	PCOLT010
;
		PLB			;(DBR) load
		PLY			;(Y)	 "
		PLX			;(X)	 "
		PLA			;(A)	 "
;
		PLP			;(P)	 "
		RTL
;
		MEM8
		IDX8
;
;************************************************************************
;*		vC[XN[				*
;************************************************************************
;
;------------------------------------------------------------------------
;-		XN[p^[f[^				-
;------------------------------------------------------------------------
BG2_H_SCRL_SP	EQU	$
; SCRLNO -->		 [0]  [1]  [2]	[3]  [4]  [5]  [6]  [7]	 [8]  [9]  [A]	[B]  [C]  [D]  [E]  [F]
		WORD	040H,080H,100H,080H,080H,080H,080H,080H,040H,0C0H,080H,0C0H,000H,080H,000H,000H
;			[10] [11] [12] [13] [14] [15] [16] [17] [18] [19] [1A] [1B] [1C] [1D] [1E] [1F]
		WORD	080H,080H,080H,080H,040H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
BG2_V_SCRL_SP	EQU	$
		WORD	040H,-1,  -1,  040H,040H,040H,040H,040H, -1 ,060H,040H, -1 ,000H, -1 ,000H,000H
		WORD	100H,040H,040H,040H,040H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
;
BG3_H_SCRL_SP	EQU	$
		WORD	020H,040H,100H,100H,000H,040H,133H,080H,040H,040H,020H,000H,040H,000H,040H,000H
		WORD	040H,040H,080H,0C0H,000H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
BG3_V_SCRL_SP	EQU	$
		WORD	020H,-1,  -1,  -1,  000H,040H,133H,040H, -1 ,020H,020H,000H,020H,000H,040H,000H
		WORD	100H,020H,040H,060H,000H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
;
BG4_H_SCRL_SP	EQU	$
		WORD	100H,100H,100H,100H,100H,100H,166H,000H,100H,100H,100H,000H,000H,100H,000H,000H
		WORD	020H,060H,100H,100H,000H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
BG4_V_SCRL_SP	EQU	$
		WORD	100H,100H,100H,100H,100H,100H,000H,000H,100H,100H,100H,000H,000H,100H,000H,000H
		WORD	100H,020H,100H,100H,000H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H,100H
;
;------------------------------------------------------------------------
;-	XyV Of[VJ[XN[ nmtO f[^	-
;------------------------------------------------------------------------
SPL_GRDTN_CMP	EQU	$
		WORD	00023H
SPL_GRDTN_END	EQU	$
;
SPL_GDN		EQU	SPL_GRDTN_CMP-SPL_GRDTN_END
;
;
;------------------------------------------------------------------------
;-		XN[JE^[␳@f[^			-
;------------------------------------------------------------------------
PSCR_HOSFG	EQU	$
;			BG check point over flag
;			+------ V hosei
;			|+----- H   "
;			||+---- 45 angle hosei
		BYTE	000B	;[0000]
		BYTE	110B	;[0001]
		BYTE	110B	;[0010]
		BYTE	100B	;[0011]
		BYTE	110B	;[0100]
		BYTE	010B	;[0101]
		BYTE	110B	;[0110]
		BYTE	001B	;[0111]
		BYTE	110B	;[1000]
		BYTE	110B	;[1001]
		BYTE	010B	;[1010]
		BYTE	001B	;[1011]
		BYTE	100B	;[1100]
		BYTE	001B	;[1101]
		BYTE	001B	;[1110]
		BYTE	000B	;[1111]
PSCR45XMK	EQU	$
		BYTE	0	;[0000]
		BYTE	0	;[0001]
		BYTE	0	;[0010]
		BYTE	0	;[0011]
		BYTE	0	;[0100]
		BYTE	0	;[0101]
		BYTE	0	;[0110]
		BYTE	1	;[0111]
		BYTE	0	;[1000]
		BYTE	0	;[1001]
		BYTE	0	;[1010]
		BYTE	-1	;[1011]
		BYTE	0	;[1100]
		BYTE	1	;[1101]
		BYTE	-1	;[1110]
		BYTE	0	;[1111]
PSCR45YMK	EQU	$
		BYTE	0	;[0000]
		BYTE	0	;[0001]
		BYTE	0	;[0010]
		BYTE	0	;[0011]
		BYTE	0	;[0100]
		BYTE	0	;[0101]
		BYTE	0	;[0110]
		BYTE	1	;[0111]
		BYTE	0	;[1000]
		BYTE	0	;[1001]
		BYTE	0	;[1010]
		BYTE	1	;[1011]
		BYTE	0	;[1100]
		BYTE	-1	;[1101]
		BYTE	-1	;[1110]
		BYTE	0	;[1111]
;
;------------------------------------------------------------------------
;-		uXN[őlf[^				-
;------------------------------------------------------------------------
SCRMAXX		EQU	$
		WORD	-8,8
SCRMAXY		EQU	$
		WORD	-8,8
;
PLSCRL		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		M16
;
		LDA	MSGMOD
		BEQ	PSCR_0010	;bZ[W\H ( no:PSCR_0010 )
		JMP	PSCR_0800
;
PSCR_0010	EQU	$
		LDA	SP_SCRL_FG
		ORA	GOAL_IN
		BNE	PSCR_0020	;XN[ꂏS[CH ( yes:PSCR_0020 )
		LDA	PLSTFG
		ORA	SCRL_STOP
		ORA	BIRIBIRI
		ORA	ITEMNO
		BNE	PSCR_0800	;player stop or XN[hneehH ( no:PSCR_0800 )
		LDA	CCHGFG
		BEQ	PSCR_0020	;ϐgfH ( no:PSCR_0020 )
		CMP	#05H
		BCS	PSCR_0800	;ϐg̃XN[H ( no:PSCR_0800 )
;
PSCR_0020	EQU	$
;
		I16
;
;------------------------------------------------------------------------
;-		XN[͈̓`FbN					-
;------------------------------------------------------------------------
		LDA	ATSCRL_FLAG
		TAY
		BEQ	PSCR_0030	;I[gXN[H ( no:PSCR_0030 )
;
;-------------- I[gXN[ ----------------------------------------
		JSL	>AUTO_SCROLL
;
		LDA	ATSCRL_XSPD
		LDY	ATSCRL_SCCH1L
;
;-------------- vC[XN[ ------------------------------------
PSCR_0030	EQU	$
		STA	SCRL_XSPD	;XN[wXs[hZbg
		STY	SCRL_XSDR
;
		I8
;
		LDX	PLMODE
		CPX	#PTTL
		BEQ	PSCR_0800	;XN[ZbgnjH ( no:PSCR_0800 )
;
		LDX	SCRLNO
		CPX	#0DH
		BNE	PSCR_0050	;hJXN[R[XH ( no:PSCR_0050 )
;
		LDX	PLMODE
		CPX	#PDSC
		BNE	PSCR_0038	;hJXN[H ( no:PSCR_0038 )
;
		LDY	DOKNMK
		LDA	!DOKAN_SCRL_CY
		STA	PLSCRL_CY	;XN[SxŒZbg
		LDA	PLYPSL
		SEC
		SBC	ESCCV1
		SEC
		SBC	PLSCRL_CY
		EOR	!DOKAN_SCRL_YA,Y
		BMI	PSCR_0038	;hJXN[njH ( no:PSCR_0038 )
;
		LDA	#00
		BRA	PSCR_0040
;
PSCR_0038	EQU	$
		LDA	ESCCV1
		STA	ATSCRL_SCCV1
		LDA	#01H
PSCR_0040	EQU	$
		STA	ATSCRL_V
;
PSCR_0050	EQU	$
		M_CHIP	M_PLSCRL
;
		LDA	ESCCV1		;(A) <-- player scroll counter
		CLC
;;;;		    ADC	    #01CH
		ADC	#0CH
		STA	ESCCV1
;
;------------------------------------------------------------------------
;-		XN[JE^[Zbg				-
;------------------------------------------------------------------------
PSCR_0800	EQU	$
;
;-------------- XN[JE^[gZbg ----------------------------
		LDA	ESCCH1		;(A) <-- player scroll counter
		LDY	ATSCRL_H
		BEQ	PSCR_0810	;gI[gXN[H ( no:PSCR_0810 )
;
		LDA	ATSCRL_SCCH1L
		AND	#00FFH
		STA	ESCCH1L
		LDA	ATSCRL_SCCH1	;(A) <-- I[gXN[JE^[g
		STA	ESCCH1
PSCR_0810	EQU	$
		LDY	#00
		CMP	<SCCH1
		BPL	PSCR_0850
		LDY	#02
PSCR_0850	EQU	$
		STY	<SCHMK1
		STA	<SCCH1
;
;-------------- XN[JE^[uZbg ----------------------------
		LDA	ESCCV1		;(A) <-- player scroll counter
		LDY	ATSCRL_V
		BEQ	PSCR_0902	;uI[gXN[H ( no:PSCR_0902 )
;
		LDA	ATSCRL_SCCV1L
		AND	#00FFH
		STA	ESCCV1L
		LDA	ATSCRL_SCCV1	;(A) <-- I[gXN[JE^[u
		STA	ESCCV1
PSCR_0902	EQU	$
		LDY	#00
		CMP	<SCCV1
		BPL	PSCR_0910
		LDY	#02
PSCR_0910	EQU	$
		STY	<SCVMK1
		STA	<SCCV1
		STA	<SCCV1
;
;-------------- Of[VJ[XN[Zbg --------------------
		LDY	NUKINO
		CPY	#10H
		BCC	PSCR_0912	;Of[VJ[XN[H ( no:PSCR_0912 )
;
		LSR	A
		LSR	A
		LSR	A
		PHA
		CLC
		ADC	#NUKCOL_BF_B
		STA	NUKCOL_SCRL_B
		PLA
		ASL	A
;;;;		    CLC
		ADC	#NUKCOL_BF_RG
		STA	NUKCOL_SCRL_RG
;
;-------------- XyV Of[VJ[XN[ Zbg --------
PSCR_0912	EQU	$
		LDA	!GRDTN_FLG
		BEQ	PSCR_0912_90
;
		LDA	<SCCV3
		SEC
		SBC	#00029H
		BPL	PSCR_0912_40
		LDA	#00000H
PSCR_0912_40	EQU	$
		PHA
		CLC
		ADC	#NUKCOL_BF_B
		STA	!NUKCOL_SCRL_B
		PLA
		ASL	A
		ADC	#NUKCOL_BF_RG
		STA	!NUKCOL_SCRL_RG
;
;-------------- afQCRCSXN[JE^[Zbg ----------------
PSCR_0912_90	EQU	$
		LDA	SCRLNO
		ASL	A
		TAX
		LDA	!BG2_H_SCRL_SP,X
		STA	R8
		LDA	!BG2_V_SCRL_SP,X
		STA	R9
		LDA	!BG3_H_SCRL_SP,X
		LDY	BG1TYP
		CPY	#03
		BNE	PSCR_0970	;af[hQH ( no:PSCR_0970 )
;
		LDA	#0
PSCR_0970	EQU	$
		STA	R10
		LDA	!BG3_V_SCRL_SP,X
		LDY	BG3TYP
		CPY	#01CH
		BNE	PSCR_0980	;"mogura" BG3 ? ( no:PSCR_0980 )
;
		JSR	MOGUSCST
		LDA	#0
;
PSCR_0980	EQU	$
		STA	R11
		LDA	!BG4_H_SCRL_SP,X
		STA	R12
		LDA	!BG4_V_SCRL_SP,X
		STA	R13
		M_CHIP	BG234_SCRL
;
		LDA	ESCCH2
		STA	<SCCH2
		LDA	ESCCV2
		STA	<SCCV2
		LDY	BG3TYP
		CPY	#01AH
		BNE	PSCR_0990	;Az[afRH ( no:PSCR_0990 )
;
;-------------- Az[afRXN[ --------------------------------
		LDA	FRCNT2
		LSR	A
		LSR	A
		PHA
		CLC
		ADC	ESCCH3
		CLC
		ADC	SCRL_WRK0
		STA	ESCCH3
		STA	<SCCH3
		PLA
		LSR	A
		CLC
		ADC	ESCCV3
		CLC
		ADC	SCRL_WRK1
		STA	ESCCV3
		STA	<SCCV3
		BRA	PSCR_1000
;
PSCR_0990	EQU	$
		CPY	#02DH		;afR ?
		BNE	PSCR_0990_200	;	NO -> PSCR_0990_200
		LDA	!FRCNT2
		LSR	A
		LSR	A
		LSR	A
		ADC	!ESCCH1
		STA	!ESCCH3
		LDA	!ESCCV1
		STA	!ESCCV3
;
PSCR_0990_200	EQU	$
		DEY			;[ CPY #01H ]
		BNE	PSCR_0999	;afRH ( no:PSCR_0999 )
;
;-------------- afRXN[ ------------------------------------
		LDA	FRCNT2
		LSR	A
		LSR	A
		CLC
		ADC	ESCCH3
		CLC
		ADC	SCRL_WRK0
		STA	ESCCH3
		STA	<SCCH3
		BRA	PSCR_1000
;
PSCR_0999	EQU	$
		LDA	ESCCH3
		STA	<SCCH3
		LDA	ESCCV3
		STA	<SCCV3
;
PSCR_1000	EQU	$
		LDA	ESCCH4
		STA	<SCCH4
		LDA	ESCCV4
		STA	<SCCV4
;
		MI8
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		"mogura" right BG3 scrooll counter set			-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
MOGUSCST	EQU	$
		LDA	#00F8H		;"mogura" right scrool set
		SEC
		SBC	PLDSXL
		STA	ESCCH3
		LDA	#00F0H
		SEC
		SBC	PLDSYL
		STA	ESCCV3
		RTS
;
;
;
;
;
		END
