;************************************************************************
;*									*
;*	title name	:						*
;*	proccess	: macro program					*
;*	file name	: sfx_macro					*
;*									*
;************************************************************************
;
;
	EXTEND
;
;
;************************************************************************
;*		memory 8 bit mode set					*
;************************************************************************
;
M8		MACRO
;
		MEM8
		SEP	#00100000B	;memory 8 bit mode set
;
		ENDM
;
;************************************************************************
;*		memory 16 bit mode set					*
;************************************************************************
;
M16		MACRO
;
		MEM16
		REP	#00100000B	;memory 16 bit mode set
;
		ENDM
;
;************************************************************************
;*		index 8 bit mode set					*
;************************************************************************
;
I8		MACRO
;
		IDX8
		SEP	#00010000B	;index 8 bit mode set
;
		ENDM
;
;************************************************************************
;*		index 16 bit mode set					*
;************************************************************************
;
I16		MACRO
;
		IDX16
		REP	#00010000B	;index 16 bit mode set
;
		ENDM
;
;************************************************************************
;*		memory,index 8 bit mode set				*
;************************************************************************
;
MI8		MACRO
;
		MEM8
		IDX8
		SEP	#00110000B	;memory,index 8 bit mode set
;
		ENDM
;
;************************************************************************
;*		memory,index 16 bit mode set				*
;************************************************************************
;
MI16		MACRO
;
		MEM16
		IDX16
		REP	#00110000B	;memory,index 16 bit mode set
;
		ENDM
;
;************************************************************************
;*		ABS ( 8bit mode )					*
;************************************************************************
;
ABS8		MACRO
		LOCAL	ABS8_10
		BPL	ABS8_10
		EOR	#0FFH
		INC	A
ABS8_10		EQU	$
		ENDM
;
;************************************************************************
;*		ABS ( 16bit mode )					*
;************************************************************************
;
ABS16		MACRO
		LOCAL	ABS16_10
		BPL	ABS16_10
		EOR	#0FFFFH
		INC	A
ABS16_10	EQU	$
		ENDM
;
;************************************************************************
;*		NEG ( 8bit mode )					*
;************************************************************************
;
NEG8		MACRO
		EOR	#0FFH
		INC	A
		ENDM
;
;************************************************************************
;*		NEG ( 16bit mode )					*
;************************************************************************
;
NEG16		MACRO
		EOR	#0FFFFH
		INC	A
		ENDM
;
;************************************************************************
;*		ASR ( 8bit mode )					*
;************************************************************************
;
ASR8		MACRO
		CMP	#80H
		ROR	A
		ENDM
;
;************************************************************************
;*		ASR ( 16bit mode )					*
;************************************************************************
;
ASR16		MACRO
		CMP	#8000H
		ROR	A
		ENDM
;
;************************************************************************
;*		DIV2 ( 8bit mode )					*
;************************************************************************
;
DIV2_8		MACRO
		local	div2_8_010, div2_8_020
		CMP	#0FFH
		BNE	div2_8_010
		INC	A
		BRA	div2_8_020
;
div2_8_010	EQU	$
		CMP	#80H
		ROR	A
div2_8_020	EQU	$
		ENDM
;
;************************************************************************
;*		DIV2 ( 16bit mode )					*
;************************************************************************
;
DIV2_16		MACRO
		local	div2_16_010, div2_16_020
		CMP	#0FFFFH
		BNE	div2_16_010
		INC	A
		BRA	div2_16_020
;
div2_16_010	EQU	$
		CMP	#8000H
		ROR	A
div2_16_020	EQU	$
		ENDM
;
;************************************************************************
;*		M-chip call						*
;************************************************************************
;
M_CHIP		MACRO	ADDRESS
		LDX	#BANK &ADDRESS
		LDA	#&ADDRESS
		JSL	>CHIPON
		ENDM
;
;************************************************************************
;*		M-chip ( SFC-RAM read type ) call			*
;************************************************************************
;
M_CHIPR		MACRO	ADDRESS
		LDX	#BANK &ADDRESS
		LDA	#&ADDRESS
		JSL	>CHIPON_RAM_READ
		ENDM
;
;************************************************************************
;*		M-chip ( special type ) call				*
;************************************************************************
;
M_CHIPS		MACRO	ADDRESS
		LDX	#BANK &ADDRESS
		LDA	#&ADDRESS
		JSL	>CHIPON_SPECIAL
		ENDM
;
;************************************************************************
;*		]GAP^St[^C~O`FbN		*
;************************************************************************
;
TROBJ_CHK_4	MACRO
		LDA	ENTROB,X
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	FRCNT
		AND	#03H
		ENDM
;
;************************************************************************
;*		]GAP^Qt[^C~O`FbN		*
;************************************************************************
;
TROBJ_CHK_2	MACRO
		LDA	ENTROB,X
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	FRCNT
		AND	#01H
		ENDM
;
