;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: enemy sub.1					*
;*	file name	: ys_boss1					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_pld.h
		include		ys_color.h
		include		../union/ys_bgcheck.h
		include		ys_ename.h
		include		ys_presno.h
;
		XALL
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	SLIMEIN,BKSLMIN,SLEYEIN,SSLIMIN
;
		GLB	SLIMEMV,BKSLMMV,SLEYEMV,SSLIMMV
;
		GLB	BGDATA_MAKE
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< sy_main >------------------------------------------------
		EXT	SOUND_3_ON
;
;-------------< sy_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ
		EXT	B3CL
;
;-------------< sy_play >------------------------------------------------
		EXT	PLCOLTR
		EXT	EBSTAT
		EXT	PFAL,PSTP,PMOV
		EXT	PFLP,PDEM,PDKN
;
		EXT	BERO_CANCEL
;
;-------------< sy_bgsc >------------------------------------------------
		EXT	UNITCHG
;
;-------------< sy_enmy >------------------------------------------------
		EXT	ENEMY,ENINSB
		EXT	ENCLEAR,ENCLEAR_NORETN,DISPCK0,DISPCK1,DISPCK2
		EXT	ENINSR,ENINSR2,EEXCHK,EEYCHK,EEXYCK,ESTATST
		EXT	ENINSR_I,ENINSR2_I
		EXT	SCOREST,COLD_KIRA_ST,SHOT_EN_KILL
		EXT	ENMDCK,XSDOWN,EPCRCK,MUKEOR,XSPEOR,MKEOR2,PLFLST
		EXT	PLFLST_2
		EXT	FSMK0_SET4,FSMK0_SET2
		EXT	ENDEATH_SET_4
;
		EXT	EINIT,EFAIL,EMOVE,EEATM,ENOSE,EBABL,ERINT,EFALL
		EXT	EFIRE
;
		EXT	EATMXS,NOSWT
;
		EXT	ENFAIL0,EGGKILL_ALL,ENDEATH_SET
		EXT	SHOT_EN_KILL_S,SHOT_EN_KILL_2
		EXT	EXIST_CHECK
;
		EXT	TROBJ_CANCEL
		EXT	TROBJ_SR_2x2,TROBJ_SR_4x4,TROBJ_SR_8x8
		EXT	TROBJ_SR_2x2_CL,TROBJ_SR_4x4_CL,TROBJ_SR_8x8_CL
		EXT	TROBJ_OAM_2x2,TROBJ_OAM_4x4,TROBJ_OAM_8x8
		EXT	TROBJ_OAM_2x2_I,TROBJ_OAM_4x4_I,TROBJ_OAM_8x8_I
		EXT	TROBJ_CLEAR
		EXT	TROBJ_PLOT_X,TROBJ_PLOT_Y
;
;-------------< sy_enmy3 >------------------------------------------------
		EXT	IWATSIN,BG3POLYST0,BG3POLYST
		EXT	ICE_IN_CK
		EXT	BSCLW_SET_B,BSCLW_SET_M
		EXT	BOSS_CLEAR
		EXT	BOSS_EN_CHANGE
;
;-------------< sy_enmy5 >------------------------------------------------
		EXT	SLIME_START_ST,SLIME_START_ED
;
;-------------< sy_enmy6 >------------------------------------------------
		EXT	DOROB_RMODE0
		EXT	DOROB_RMODE1
		EXT	DOROB_RMODE2
		EXT	DOROB_RMODE3
		EXT	DOROB_RMODE5
		EXT	DOROB_RMODE6
		EXT	DOROB_RMODE7
		EXT	DOROB_RMODE8
		EXT	DOROB_RMODE9
;
		EXT	DOROB_R5_CHCT
;
		EXT	DOROB_R5_CHPT
;
;-------------< sy_enmy8 >------------------------------------------------
		EXT	SHOT_EN_KILL_SP
;
;-------------< sy_exst >------------------------------------------------
		EXT	EXINSR
		EXT	SKSNOW
;
;-------------< sy_unit >------------------------------------------------
		EXT	UNCOMPRES,VRAMDX_ST
		EXT	UNDTADD,UNDATA,RUTDATA
;
		EXT	M_DMA_BFST
;
;-------------< ys_data >------------------------------------------------
		EXT	SIN,COS
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
BABY_INDEX	EQU	00H
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
		EXTEND
;
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
Group_6		GROUP	Boss1_pro
Boss1_pro	SECT	REL
;
;************************************************************************
;*		initial ( block slime )					*
;************************************************************************
;			 [4]	[6]    [8]
;BSLM_XSRH	 EQU	 $
;		 WORD	 00020H,00030H,00040H
;BSLM_XSRH2	 EQU	 $
;		 WORD	 00040H,00060H,00080H
;BSLM_YSRH	 EQU	 $
;		 WORD	 00050H,00060H,00080H
;BSLM_DTADR	 EQU	 $
;		 WORD	 BG3KAG0F,BG3KAG10,BG3KAG11
;BSLM_VSUM	 EQU	 $
;		 WORD	 00003H,00004H,00006H
;BSLM_HSUM	 EQU	 $
;		 WORD	 00004H,00006H,00008H
;BSLM_VADX	 EQU	 $
;		 WORD	 0FFE8H,0FFD8H,0FFC8H
;BSLM_VADY	 EQU	 $
;		 WORD	 0FFD0H,0FFC0H,0FFA0H
;
;USED WORK
;		EWORK0		*
;		EWORK2		*
;		EWORK4
;		EWORK6
;		EWORK8
;		EWORKA
;		EWORKC
;		EWORKE		*
;
BKSLMIN		EQU	$			;-- bkslmin --
		LDA	<ENWRK0,X		;afubN݂̑`FbN ?
		BNE	BKSLMIN0090		;  no: BKSLMIN0090

		JSL	>EXIST_CHECK

		I16
		LDA	ENYPSL,X		;BG data buffer clear addr. calc.
		STA	BLKSETY			;
		SEC				;
		SBC	#00038H			;
		PHA				;
		AND	#0FF00H			;
		LSR	A			;
		LSR	A			;
		LSR	A			;
		LSR	A			;
		STA	<EWORK0			;
		LDA	ENXPSL,X		;
		STA	BLKSETX			;
		SEC				;
		SBC	#00018H			;
		PHA				;
		AND	#0FF00H			;
		XBA				;
		ORA	<EWORK0			;
		TAX				;
						;
		PLA				;
		AND	#000F0H			;
		LSR	A			;
		LSR	A			;
		LSR	A			;
		STA	<EWORK0			;
						;
		PLA				;
		AND	#000F0H			;
		ASL	A			;
		ORA	<EWORK0			;
		STA	<EWORK0			;
						;
		LDA	UNBUFAD-1,X		;
		AND	#03F00H			;
		ASL	A			;
		CLC				;
		ADC	<EWORK0			;
		STA	<EWORK0			;
		TAX				;

		LDA	>BGUNIT,X		;afubN݂ ?
		I8				;
		LDX	<ENINDX			;
		CMP	#UT0181			;
		BEQ	BKSLMIN0080		; yes: BKSLMIN0080

BKSLMIN0040	EQU	$
		JMP	>ENCLEAR

BKSLMIN0080	EQU	$
		LDA	<EWORK0			;slime BG data buffer index <work> set
		STA	<ENWRK0,X		;

BKSLMIN0090	EQU	$
		LDA	BG3USEFG		;obN ?
		BNE	BKSLMIN0040		; yes: BKSLMIN0040

		LDA	PWIDEX			;vC[߂ɂ ?
		CLC				;
		ADC	#00030H			;
		ASL	A			;
		STA	<EWORK0			;
		LSR	A			;
		CLC				;
		ADC	ENXPSL,X		;
		CLC				;
		ADC	#00008H+8		;
		SEC				;
		SBC	PCENTX			;
		CMP	<EWORK0			;
		BCS	BKSLMIN0100		;
						;
		LDA	ENYPSL,X		;
		SEC				;
		SBC	PCENTY			;
		SEC				;
		SBC	PWIDEY			;
		SEC				;
		SBC	#00040H+1		;
		BPL	BKSLMIN0100		;  no: BKSLMIN0100

		LDA	PLBGCR
		AND	#0000000000000111B
		BNE	BKSLMIN0200

BKSLMIN0100	EQU	$
		LDA	#EINIT
		STA	ENMODE,X

		RTL

BKSLMIN0200	EQU	$
		INC	BG3USEFG		;afRobNtOZbg

		LDA	#UT0181			;trans. data set ( change color attr. )
		JSL	>BGDATA_MAKE		;
						;
		LDA	<EWORK4			;
		XBA				;
		AND	#000E3H			;
;		ORA	#00014H			;
;		LDA	#00016H			;trans. data set ( change color attr. )
		STA	BLKVDT0			;
		ORA	#00080H
		STA	BLKVDT1

		LDA	<ENWRK0,X		;slime BG data buffer index set
		STA	BLKBGID			;

		LDA	ENXPSL,X		;x pos. revise
		CLC				;
		ADC	#00008H			;
		STA	ENXPSL,X		;

		STZ	SLMCOLX			;blosk slime col. data index clear

		LDA	#00008			;v_line loop counter*2 set
		STA	<EWORK2			;

		LDA	ENYPSL,X		;Vram addr. calc.
		CLC				;
		ADC	#0FFC8H			;
		AND	#000F0H			;
		ASL	A			;
		ASL	A			;
		STA	<EWORK0			;
;						;
		LDA	ENXPSL,X		;
		CLC				;
		ADC	#0FFE0H			;
		AND	#001F0H			;
		LSR	A			;
		LSR	A			;
		LSR	A			;
		BIT	#00100H>>3		;
		BEQ	BKSLMIN0280		;
;						;
		EOR	#0400H|(0100H>>3)	;
BKSLMIN0280	EQU	$			;
		TSB	<EWORK0			;
		LDA	<EWORK0			;
		CLC				;
		ADC	#06800H			;
		STA	<EWORK0			;
		STA	BLKADDR			;

		LDA	#00006H			;h_line loop counter set
		STA	<EWORKE			;

		PHB
		M8
		LDA	#BANK VRAMDX
		PHA
		PLB

		MI16
		LDX	VRAMDX

BKSLMIN0300	EQU	$
		LDA	<EWORK0			;Vram addr. set
		STA	00H,X			;

		LDA	#00880H			;inc. mode & DMA para. set
		STA	02H,X			; 2115h & 4300h

		LDA	#00019H			;DMA B_bus addr. set
		STA	04H,X			;

		LDA	#BLKVDT0		;DMA A_bus addr. set
		STA	05H,X			;

		LDA	#BANK BLKVDT0		;DMA A_bus bank set
		STA	07H,X			;

		LDA	#0000CH			;DMA trans. data sum. set
		STA	08H,X			;

		TXA				;next data addr. calc.
		CLC				;
		ADC	#0000CH			;
		STA	0AH,X			;next data addr. set
		TAX

		DEC	<EWORK2			;trans. loop end ?
		BEQ	BKSLMIN0400		; yes: BKSLMIN0400

		LDA	<EWORK0			;next Vram addr. calc.
		CLC				;
		ADC	#00020H			;
		STA	<EWORK0			;
		BRA	BKSLMIN0300

BKSLMIN0400	EQU	$
		LDA	<EWORK0			;Vram addr. set
		INC	A
		STA	00H,X			;

		LDA	#00880H			;inc. mode & DMA para. set
		STA	02H,X			; 2115h & 4300h

		LDA	#00019H			;DMA B_bus addr. set
		STA	04H,X			;

		LDA	#BLKVDT1		;DMA A_bus addr. set
		STA	05H,X			;

		LDA	#BANK BLKVDT1		;DMA A_bus bank set
		STA	07H,X			;

		LDA	#0000AH			;DMA trans. data sum. set
		STA	08H,X			;

		TXA				;next data addr. calc.
		CLC				;
		ADC	#0000CH			;
		STA	0AH,X			;next data addr. set
		STA	VRAMDX			;last data addr. set

		JSR	BLKSLM_COLCHG		;block slime col. init.
		IDX8
		PLB

;--------------< colour data change >--------------
		LDA	#00008H			;colour change timer set
		STA	ENTIM0,X		;
		LSR	A
;		LDA	#00004H			;colour change counter set
		STA	SLMZMIN			;

;--------------<
		LDA	#0E000H
		STA	SLMSIZE			;slime size counter clear
		STZ	SLMHDFG				;tONA
		LDA	#00001			;Xe[WtOZbg
		STA	SLMSTGF			;

		LDA	#BG3KAG10		;bg3 data addr. set
		STA	BLKSIZE			;

		LDY	#SLIME_RMODE90		;routine mode index set
		STY	<ENWRK2,X		;

		RTL
;
BGDATA_MAKE	EQU	$			;BGUNIT data ( UT**** ) --> BG data
		PHY
		I16

		TAY
		AND	#0FF00H
		XBA
		ASL	A
		TAX
		LDA	>UNDTADD,X
		STA	<EWORK0
		TYA
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<EWORK0
		TAX
		LDA	>UNDATA,X
		STA	<EWORK4		;EWORK4 <-- chara no.1
		LDA	>UNDATA+2,X
		STA	<EWORK6		;EWORK6 <-- chara no.2
		LDA	>UNDATA+4,X
		STA	<EWORK8		;EWORK8 <-- chara no.3
		LDA	>UNDATA+6,X
		STA	<EWORKA		;EWORKA <-- chara no.4

		I8
		PLY

		LDX	<ENINDX

		RTL
;
;************************************************************************
;*		initial ( rbOՂ )					*
;************************************************************************
SLIME_I_SUB	EQU	$
		WORD	SLIME_I_SUB10		;f
		WORD	SLIME_I_SUB11		;fdmc`FbN
		WORD	SLIME_I_SUB12		;тՂfdmc`FbN
		WORD	SLIME_I_SUB20		;afRLN^[]iXCpj
		WORD	SLIME_I_SUB21		;afRLN^[]iXCpj
		WORD	SLIME_I_SUB22		;afRXN[]iXCpj
		WORD	SLIME_I_SUB30		;ՂiAjɂ
		WORD	SLIME_I_SUB40		;afQݒ
;
SLIMEIN		EQU	$			;-- slimein --
		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SLIME_I_SUB,X)

		LDA	#EINIT		;enemy mode keep init.
		STA	ENMODE,X	;

		RTL
;
SLIME_I_SUB10	EQU	$
		TYX

		LDA	PLXPSL			;vC[AĂ ?
		CMP	#001E0H			;
		BMI	SLIME_I_S100800		;  no: SLIME_I_S100800

		STZ	PLXSPD
		STZ	PLMVSP
;;;;;;;;		STZ	PLCMKI
		JSL	>BERO_CANCEL

;
;-------------- JbNZbg ----------------------------
		LDA	#KAMC2
		JSL	>ENINSR_I
		LDA	#00010H
		STA	ENXPSL,Y
;
;-------------- TEhtF[h ----------------------------
		LDA	#000F1H			;mrn
		STA	SOUND_0
;
;-------------- fZbg ----------------------------
		LDA	#DMPLC
		JSL	>ENINSR
		LDA	#SLIME_START_ST
		STA	ENWRK0,Y
		LDA	#SLIME_START_ED
		STA	ENWRKC,Y
		STZ	BOSS0FLG

		INC	<ENWRK2,X

SLIME_I_S100800 EQU	$

		RTS
;
SLIME_I_SUB11	EQU	$
		TYX

		STZ	PLCMKI

		LDY	BOSS0FLG		;Ղf ?
		BEQ	SLIME_I_S110800		; yes: SLIME_I_S110800

		LDA	#SSLIM
		JSL	>ENINSR
		LDA	#00240H
		STA	ENXPSL,Y
		LDA	#00730H
		STA	ENYPSL,Y
		LDA	#00006
		STA	ENWRK2,Y
		LDA	ENMOD1,Y		;GȂ
		ORA	#0010000000000000B	;
		STA	ENMOD1,Y		;
		M8
		LDA	#001
		STA	ENYUSN,Y
		LDA	#02EH
		STA	ENCLOR,Y
		M16
;
		LDA	#00009			;mrn
		STA	SOUND_0
;
		LDX	#(10H*1)*2		;6 <- 1
SLIME_I_S110500 EQU	$
		LDA	>MOTOCOL+09H*10H*2-2,X
		STA	>DATACOL+0EH*10H*2-2,X
		DEX
		DEX
		BNE	SLIME_I_S110500

		LDX	<ENINDX
		STZ	BOSS0FLG
		INC	<ENWRK2,X

SLIME_I_S110800 EQU	$

		RTS
;
SLIME_I_SUB12	EQU	$
		TYX

		LDY	BOSS0FLG		;тՂ ?
		BEQ	SLIME_I_S120800		;  no: SLIME_I_S120800

		STZ	SLMSTGF
;		LDY	BG2TYP			;PUFo[W ?
;		CPY	#016H			;
;		BNE	SLIME_I_S120500		;  no: SLIME_I_S120500
;
;		INC	SLMSTGF
		LDY	#00AH-3-1
		STY	<ENWRK2,X

SLIME_I_S120500 EQU	$
		INC	<ENWRK2,X

SLIME_I_S120800 EQU	$

		RTS
;
SLIME_I_SUB30	EQU	$
		TYX
;
		JSL	>TROBJ_CANCEL	;]GAJ
;
		STZ	TROBJ_ARIA		;
;
		LDA	SCCH1			;CjVw@onrDZbg
		CLC				;
		ADC	#000A8H			;
		STA	ENXPSL,X		;
		LDA	#00728H			;CjVx@onrDZbg
		STA	ENYPSL,X		;
		STA	SLSTCPY			;
		LDA	#007B0H			;`FbNx@onrDZbg
		STA	SLMYLOW			;
;
		INC	BG3USEFG		;obNtOZbg

		LDY	#SLIME_RMODE10		;routine mode index set
		STY	<ENWRK2,X		;
;
		LDA	#SLMAP		;(A) <-- exstra no.
		JSL	>EXINSR

		LDA	ENXPSL,X	;x_pos set
		STA	EXXPSL,Y	;

		LDA	ENYPSL,X	;y_pos set
		CLC
		ADC	#00006H
		STA	ENYPSL,X
		STA	EXYPSL,Y	;

		LDA	ENYPSL,X		;Z^[onrDZbg
		SEC
		SBC	ESCCV1
		CLC
		ADC	#0000EH+8
		STA	SLMKIRE

		LDA	#0FFFFH		;timer set
		STA	EXTIM0,Y	;
		TYA			;appear data index save
		STA	ENWRK8,X	;

		TXA			;slime data index save
		STA	EXWRK0,Y	;
;
;--------------< other work set >----------------
		STZ	SLMZMAX			;^e{Xs[hl`wNA
		STZ	SLMZMIN			;^e{Xs[hlhmNA
		STZ	SLMFTFG			;ntONA
		STZ	SLMSPOI			;rhmf[^|C^[NA
		STZ	SLMSXZM			;rhmf[^Aw@Y[NA
		LDA	#00100H			;rhmf[^Ax@XebvZbg
		STA	SLMSYST			;
		STZ	SLMYURE			;Ղh񐔃NA
		STZ	SLMDMGF			;_[WtONA
		STZ	SLMNIGE			;т̂tONA
;		LDA	#0FFFFH
		LDA	#0B000H
;		LDA	#0D000H
		STA	SLMSIZE			;ՂTCYNA
		STZ	SLMDMGT			;Ղ_[W^C}[Zbg

		LDA	#000E0H			;c{lZbg
		STA	<ENWRK0,X		;

		STZ	ENWRKA,X		;␳bNtONA
		STZ	SLMHDFG			;tONA

		LDA	#00001			;X^[gXgbvtOZbg
		STA	SLMSTART		;
		STZ	SLMDEMO			;ՂtONA

		PLA			;ڂqsk
		RTL
;
;------------------------------------------------------------------------
;-		afRLN^[]					-
;------------------------------------------------------------------------
SLIME_I_SUB20	EQU	$
		LDA	#CHR23A		;(A) <-- LN^[oNiXCj
SLIME_I_SUB2010 EQU	$
;
		I16
;
		LDY	#2800H		;(Y) <-- uq`lAhX
		BRA	SLIME_I_SUB2020
SLIME_I_SUB21	EQU	$
		LDA	#CHR22B		;(A) <-- LN^[oNiXCj
SLIME_I_SUB2110 EQU	$
;
		I16
;
		LDY	#2C00H		;(Y) <-- uq`lAhX
;
SLIME_I_SUB2020 EQU	$
		PHA			;(A) save
		PHY			;(Y) save
;
		I8
;
		LDA	#00000100B+(00000100B*100H) ;afR\hneeh
		TRB	MANSEL		;[ & SUBSEL ]
;
		I16
;
		PLY			;(Y) <-- uq`lAhX
		PLA			;(A) <-- LN^[oN
		JSR	UNCOM_VRAMTR
;
		IDX8
;
		BRA	SLIMEIN_MODINC
;
;------------------------------------------------------------------------
;-		afRXCXN[]				-
;------------------------------------------------------------------------
SLIME_I_SUB22	EQU	$
		I16
;
		LDA	#B3TEKI0	;(A) <-- LN^[oN
		LDY	#3400H		;(Y) <-- uq`lAhX
		JSR	UNCOM_VRAMTR
		IDX8
;
;-------------- J[Zbg --------------------------------------------
		LDX	#006
SLIME_I_SUB2240 EQU	$
		LDA	>COL_ADDRESS+BG3_TEKI_1+0*2,X
		STA	>MOTOCOL+4*2,X
		STA	>DATACOL+4*2,X
		DEX
		DEX
		BPL	SLIME_I_SUB2240
;
SLIMEIN_MODINC	EQU	$
		LDX	<ENINDX
		INC	<ENWRK2,X
		RTS
;
;------------------------------------------------------------------------
;-		afQJ[Zbgтg|cl`p[^ύX	-
;------------------------------------------------------------------------
SLIME_I_SUB40	EQU	$
		JSR	SLIME_NORM_COL

;afQG֕ύX
		LDY	#0FH			;g|cl`p[^ύX
		STY	4331H
		INY		;[ LDY	#10H ]
		STY	4341H

		LDX	<ENINDX
		DEC	<ENWRK2,X

		RTS
;
;------------------------------------------------------------------------
;-		kf[^̉𓀁Auq`lւ̓]			-
;-			in :						-
;-				(A) <-- LN^[oN		-
;-				(Y) <-- uq`lAhX		-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
UNCOM_VRAMTR	EQU	$
		PHY			;(Y) save
;
;-------------- kf[^̉ ----------------------------------------
		LDX	#WOB7CHR+1000H	;(X) <-- kf[^i[AhXZbg
		JSL	>UNCOMPRES	;[ (A) <-- WJf[^oCg ]
;
;-------------- WJf[^] ------------------------------------------
		PLY			;(Y) <-- uq`lAhX
		LDX	#BANK WOB7CHR
		STX	WORK1		;(WK1,2) <-- ]AhXiaj
		LDX	#WOB7CHR+1000H	;(X)	 <-- ]AhXikCgj
		JSL	>VRAMDX_ST
;
		I8
;
		RTS
;
;************************************************************************
;*		move	( rbOՂ )					*
;************************************************************************
;		ENWRK0	c{
;		ENWRK2	ROUTINE MODE INDEX
;		ENWRK4	{Xs[h~bg
;		ENWRK6	{Xs[h
;		ENWRK8	APPEAR DATA INDEX SAVE / SLIME_EYE ROUTINE INDEX ( ENEMY INDEX )
;		ENWRKA	USE
;		ENWRKC	ntO	0...FOOT 2...HEAD
;
;		ENCONT	{JE^[
;
;		SLMIDX0 GCfbNX
;		SLMZMAX ^e{l`wD
;		SLMZMIN ^e{lhmD
;		SLMFTFG ntO (0BIT)
;		SLMKIRE Z^[onrD
;		SLMSPOI SIN f[^|C^[
;		SLMSXZM SIN f[^|C^[w@ynnl@ek`f
;		SLMSYST SIN f[^|C^[x@rsdo
;		SLMDMGT Ղ_[W^C}[
;		SLMYURE rbOՂh
;		SLMDMGF Ղ_[WtO
;		SLMNIGE Ղ撵т̂tO
;		SLMTRZM rbOՂό`{
;		SLMXSPD n̂wXs[h
;
;		SLMYLOW ̂x@onrD
;
;		SLMSTART X^[gbNtO
;		SLMDEMO ՂftO
;		SLMSTGF Xe[WtO	1...afR 0...afQ
;
;		SLMHDFG Ղ擪tO
;		SLMHDYP Ղ擪̂x@onrD
;
;		SLMSIZE	 TCY
;		SLMSIZE2 TCY2ȉ݂c{j
;
;		SLMDIDX Ă̃CfbNXZbg
;		SLMDMGC тՂ攭JE^[
;
;		BLKSETX ԂՂ  Zbgw
;		BLKSETY ԂՂ  Zbgx
;		BLKADDR ԂՂ  ̂u@AhX
;		BLKBGID ԂՂ  BGUNITCfbNX
;		BLKVDT0 ԂՂ  u@f[^O
;		BLKVDT1 ԂՂ  u@f[^P
;
;		ENTIM0	Xgbv^C}[
;		ENTIM1	_[W`FbNbN^C}[
;		ENTIM2
;		ENTIM3
;
SLIME_SUB	EQU	$
SLIME_00	EQU	$
		WORD	SLIME_SUB00	;			Ղ *
SLIME_01	EQU	$
		WORD	SLIME_SUB01	;[				Ղ *
SLIME_02	EQU	$
		WORD	SLIME_SUB02	;			Ղ *
SLIME_03	EQU	$
		WORD	SLIME_SUB03	;			Ղ *
SLIME_04	EQU	$
		WORD	SLIME_SUB00	;			Ղ *
SLIME_10	EQU	$
		WORD	SLIME_SUB10	;CjVfił͂߁j	Ղ
SLIME_11	EQU	$
		WORD	SLIME_SUB11	;CjVfiՁj	Ղ
SLIME_12	EQU	$
		WORD	SLIME_SUB12	;CjVfiтj	Ղ
SLIME_13	EQU	$
		WORD	SLIME_SUB13	;CjVfi܂j		Ղ
SLIME_80	EQU	$
		WORD	SLIME_SUB80	;GhfivC[`FbNj Ղ
SLIME_81	EQU	$
		WORD	SLIME_SUB81	;GhfiႭȂj	Ղ *
SLIME_82	EQU	$
		WORD	SLIME_SUB82	;Ghfi܂j		Ղ *
;
SLIME_90	EQU	$
		WORD	SLIME_SUB90	;J[`FW@ԂՂ
SLIME_91	EQU	$
		WORD	SLIME_SUB91	;ւ񂯂@@@@ԂՂ
;
;		*...KYO-TSU-
;
SLIME_RMODE00	EQU	(SLIME_00-SLIME_SUB)/2
SLIME_RMODE01	EQU	(SLIME_01-SLIME_SUB)/2
SLIME_RMODE02	EQU	(SLIME_02-SLIME_SUB)/2
SLIME_RMODE03	EQU	(SLIME_03-SLIME_SUB)/2
SLIME_RMODE04	EQU	(SLIME_04-SLIME_SUB)/2
SLIME_RMODE10	EQU	(SLIME_10-SLIME_SUB)/2
SLIME_RMODE11	EQU	(SLIME_11-SLIME_SUB)/2
SLIME_RMODE12	EQU	(SLIME_12-SLIME_SUB)/2
SLIME_RMODE13	EQU	(SLIME_13-SLIME_SUB)/2
SLIME_RMODE80	EQU	(SLIME_80-SLIME_SUB)/2
SLIME_RMODE81	EQU	(SLIME_81-SLIME_SUB)/2
SLIME_RMODE82	EQU	(SLIME_82-SLIME_SUB)/2
SLIME_RMODE90	EQU	(SLIME_90-SLIME_SUB)/2
SLIME_RMODE91	EQU	(SLIME_91-SLIME_SUB)/2
;
BKSLMMV		EQU	$			;-- bkslmmv --
SLIMEMV		EQU	$			;-- slimemv --
;		ldy	#004
;		sty	2100h
;
		LDA	<ENWRK0,X		;݂̔{
		STA	R0			;
		LDY	SLMSIZE+1		;
		TYA				;
		STA	R6			;
		M_CHIP	MULTIPLY		;
		LDA	#00180H
;		LDA	#000D0H
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	SLMSIZE2		;

		LDY	<ENWRK2,X		;J[ςĂ ?
		CPY	#SLIME_RMODE90		;
		BPL	SLIMEMV0200		; yes: SLIMEMV0200
;		CPY	#SLIME_RMODE91		;ubNm[}ɂȂĂr ?
;		BEQ	SLIMEMV0200		; yes: SLIMEMV0200

		JSR	SLIME_BODY_SET
		JSR	SLIME_BGDTMK		;BG check
;
SLIMEMV0200	EQU	$
		JSR	SLIME_BGCHK		;af`FbN

		LDY	SLMSTGF			;afRo[W ?
		BEQ	SLIMEMV0280		;  no: SLIMEMV0280

		LDY	PLMODE			;vC[yǂɂ͂낤ƂĂ ?
		CPY	#PDKN			;
		BNE	SLIMEMV0280		;  no: SLIMEMV0280

		LDA	#00215H
		STA	MANSEL

SLIMEMV0280	EQU	$
		JSL	>ENMDCK			;mode check

		LDY	<ENWRK2,X		;J[ςĂ ?
		CPY	#SLIME_RMODE90		;
		BEQ	SLIMEMV0400		; yes: SLIMEMV0400
		CPY	#SLIME_RMODE91		;ubNm[}ɂȂĂr ?
		BEQ	SLIMEMV0300		; yes: SLIMEMV0300

		JSR	SLIME_OBJCK		;vs enemy check

SLIMEMV0300	EQU	$
		JSR	SLIME_PLCHK		;vs player check

SLIMEMV0400	EQU	$
		JSR	SLIME_DEATH_CHK		;GhfJn`FbN

		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SLIME_SUB,X)

		LDA	SLMDMGT			;_[W^C}[Z
		BEQ	SLIMEMV0700		;
						;
		DEC	SLMDMGT			;

SLIMEMV0700	EQU	$
		JSR	SSLIM_CHECK		;тՂ掩R`FbNZbg

;		ldy	#00fh
;		sty	2100h

		RTL
;
SLIME_BODY_SET	EQU	$
		LDY	<ENWRK2,X		;ł͂߁î܂Ղj ?
		CPY	#SLIME_RMODE10		;
		BEQ	SLIME_CHIP		; yes: SLIME_CHIP
		CPY	#SLIME_RMODE82		;Ghf ?
		BNE	SLIME_CHIP2		;  no: SLIME_CHIP2

		LDY	SLMDEMO			;afR ?
		BEQ	SLIME_CHIP2		;  no: SLIME_CHIP2

		RTS
;
SLIME_CHIP	EQU	$
		STZ	CCWORK7			;CWRK7 <- ڂ̃ItZbgw@onrD
		STZ	CCWORK8			;CWRK8 <- ڂ̃ItZbgx@onrD

		LDY	ENWRK8,X
		LDA	EXYPSL,Y		;KIRE Y_POS
		SEC
		SBC	SCCV1
		BRA	SLIME_CHIP0200

SLIME_CHIP2	EQU	$
		LDY	ENWRK8,X		;CWRK7 <- ڂ̃ItZbgw@onrD
		LDA	ENWRK4,Y		;CWRK8 <- ڂ̃ItZbgx@onrD
		PHA				;
		AND	#000FFH			;
		TAY				;
		BPL	SLIME_CHIP0150		;
						;
		ORA	#0FF00H			;
						;
SLIME_CHIP0150	EQU	$			;
		STA	CCWORK7			;
						;
		PLA				;
		AND	#0FF00H			;
		BPL	SLIME_CHIP0180		;
						;
		ORA	#000FFH			;
						;
SLIME_CHIP0180	EQU	$			;
		XBA				;
		STA	<EWORK0			;
;;;;;;;;		LDA	#00031H			;
		LDA	#00028H			;
		STA	R0			;
		LDA	SLMSIZE2		;
		STA	R6			;
		M_CHIP	MULTIPLY		;
		LDX	<ENINDX			;
		LDA	<EWORK0			;
		SEC				;
		SBC	R0			;
;;;;;;;;		SEC				;
;;;;;;;;		SBC	#00010H			;
		SEC				;
		SBC	#00008			;
		STA	CCWORK8			;

		LDA	#00000H			;KIRE Y_POS

SLIME_CHIP0200	EQU	$
		STA	R2			;(R2) <- A_[\onrD

		LDA	SLMKIRE			;(R3) <- Z^[\onrD
		STA	R3

		LDA	ENDSXL,X		;CWRK0 <- Sw@onrD
		CLC
		ADC	#00008H
		STA	CCWORK0

		LDA	ENDSYL,X		;CWRK1 <- x@onrD
		STA	CCWORK1

		LDA	SLMSIZE2		;CWRK3 <- c{
		STA	CCWORK3			;

		TXA
		STA	CCWORK9

		LDA	#002C0H			;CWRK2 <- {
;		LDA	#00300H			;CWRK2 <- {
		SEC				;
		SBC	<ENWRK0,X		;
		STA	R0			;
		LDY	SLMSIZE+1		;
		TYA				;
		STA	R6			;
		M_CHIP	MULTIPLY		;
		LDA	R0			;
		STA	CCWORK2			;

		LDA	SLMSPOI			;sin data pointer
		STA	CCWORK4

		LDA	SLMSXZM			;sin data x zoom
		STA	CCWORK5

		LDA	SLMSYST			;sin data y step
		STA	CCWORK6

		LDA	PLDSXL			;player display x_pos. set
		STA	CCWORKA

		LDA	PLDSYL			;player display y_pos. set
		STA	CCWORKB

		LDA	PLSITD			;player sit down flag set
		STA	CCWORKC

		M_CHIPR SLIMEST

SLIME_CHIP0280	EQU	$
		I16
		JSL	>M_DMA_BFST
		LWORD	HDMABUF		;to address set
		LWORD	HDMABF		;from address set
		WORD	0D2H*2*2	;umber of byte set
		MI8

		LDA	SLSTCPY		;̐؂[͎cĂ ?
		ORA	SLSTCPY+1	;
		BEQ	SLIME_CHIP0300	;  no: SLIME_CHIP0300

		LDA	#00001000B
		TRB	BGMODE		;afR̃vCIeB[𗎂Ƃ
		LDY	#013H
		LDA	#004H
		BRA	SLIME_CHIP0400

SLIME_CHIP0300	EQU	$
		LDY	SLMSTGF			;afRo[W ?
		BEQ	SLIME_CHIP0380		;  no: SLIME_CHIP0380

		LDY	#010H
		LDA	#007H
		BRA	SLIME_CHIP0400

SLIME_CHIP0380	EQU	$
		LDY	#012H
		LDA	#005H

SLIME_CHIP0400	EQU	$
		STY	MANSEL
		STA	SUBSEL
		LDA	#002H
		STA	WIND30
		LDA	#020H
		STA	SUBADF

		LDA	#00011000B
		TSB	HD420C
		M16

		LDX	<ENINDX		;ENEMY INDEX FUKKATU
		JSR	SLIME_COL_SET
		LDX	<ENINDX

		LDA	CCWORK10		;̂x@onrD
		STA	ENWRKA,X		;

		LDY	<ENWRK2,X		;ł͂ ?
		CPY	#SLIME_RMODE10		;
		BEQ	SLIME_CHIP0500		; yes: SLIME_CHIP0500

		LDY	ENWRK8,X		;ڂ̂w@onrCZbg
		LDA	CCWORK7			;
		CLC				;
		ADC	ENXPSL,X		;
		STA	ENXPSL,Y		;

		LDA	CCWORK8			;ڂ̂x@onrCZbg
		CLC				;
		ADC	ENYPSL,X		;
		SEC				;
		SBC	#00010H			;
		STA	ENYPSL,Y		;

SLIME_CHIP0500	EQU	$

		RTS
;
SLIME_COL_SET	EQU	$
		LDY	SLMSTGF			;afQo[W ?
		BEQ	SLIME_C_SET1000		; yes: SLIME_C_SET1000

		LDY	SLMDMGT			;_[W ?
		BEQ	SLIME_C_SET0600		;  no: SLIME_C_SET0600

		LDA	ENTIM2,X		;J[ւ ?
		BNE	SLIME_C_SET0800		;  no: SLIME_C_SET0800

		LDA	#00004H
		STA	ENTIM2,X

		LDA	>DATACOL+(01H*2)
		EOR	#0FFFFH
		STA	>DATACOL+(01H*2)
		STA	>MOTOCOL+(01H*2)

		LDA	>DATACOL+(02H*2)
		EOR	#0FFFFH
		BRA	SLIME_C_SET0700

SLIME_C_SET0600 EQU	$
		LDA	#0637DH
		STA	>DATACOL+(01H*2)
		STA	>MOTOCOL+(01H*2)
		LDA	#04A75H

SLIME_C_SET0700 EQU	$
		STA	>DATACOL+(02H*2)
		STA	>MOTOCOL+(02H*2)
		LDA	#0000H
		STA	>DATACOL+(03H*2)
		STA	>MOTOCOL+(03H*2)

SLIME_C_SET0800 EQU	$

		RTS

SLIME_C_SET1000 EQU	$
		LDY	SLMDMGT			;_[W ?
		BEQ	SLIME_C_SET1600		;  no: SLIME_C_SET1600

		LDA	ENTIM2,X		;J[ւ ?
		BNE	SLIME_C_SET1600		;  no: SLIME_C_SET1600

		LDA	#00004H
		STA	ENTIM2,X

		LDX	#00EH*2
SLIME_C_SET1100 EQU	$
		LDA	>COL_ADDRESS+OBJ_SUB_B_COL+0FH*2-2,X
		STA	>DATACOL+(06*10H+1-1)*2,X
		STA	>DATACOL+(07*10H+1-1)*2,X
		DEX
		DEX
		BNE	SLIME_C_SET1100

		RTS

SLIME_NORM_COL	EQU	$
SLIME_C_SET1600 EQU	$
		LDX	#0EH*2
SLIME_C_SET1700 EQU	$
		LDA	>COL_ADDRESS+SLIMEBOSS_COL-2,X
		STA	>MOTOCOL+(06H*10H+01H)*2-2,X
		STA	>DATACOL+(06H*10H+01H)*2-2,X
		LDA	>COL_ADDRESS+SLIMEBOSS_COL+0EH*2-2,X
		STA	>MOTOCOL+(07H*10H+01H)*2-2,X
		STA	>DATACOL+(07H*10H+01H)*2-2,X
		DEX
		DEX
		BNE	SLIME_C_SET1700

		RTS
;
SLIME_BGCHK	EQU	$
		LDY	SLMSTART		;CjVf ?
		BNE	SLIME_BGCHK0100		; yes: SLIME_BGCHK0100
		LDY	<ENWRK2,X
		CPY	#SLIME_RMODE04		;Wv ?
		BEQ	SLIME_BGCHK0100		; yes: SLIME_BGCHK0100
		CPY	#SLIME_RMODE03		;񂮁AGhf ?
		BPL	SLIME_BGCHK0800		; yes: SLIME_BGCHK0800

SLIME_BGCHK0100 EQU	$
		LDA	ENCBFG,X		;ǂɂ ?
		AND	#0000CH			;
		BEQ	SLIME_BGCHK0800		;  no: SLIME_BGCHK0800

		CMP	#0000CH			;Vɒ ?
		BEQ	SLIME_BGCHK0800		; yes: SLIME_BGCHK0800

		AND	#00008H
		LSR	A
		LSR	A
		DEC	A
		CLC
		ADC	ENXPSL,X
		SEC
		SBC	ENMOVX,X
		STA	ENXPSL,X

		LDA	SLMXSPD
		EOR	#0FFFFH
		INC	A
		STA	SLMXSPD
		LDA	ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,X
		LDA	ENXMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X

SLIME_BGCHK0800 EQU	$

		RTS
;
SLIME_DEATH_CHK EQU	$
		LDY	SLMSIZE+1		;Ȃ ?
		CPY	#04BH+1			;
		BCS	SLIME_D_CHK0800		;  no: SLIME_D_CHK0800

		LDY	SLMSTGF			;afRo[W ?
		BNE	SLIME_D_CHK0100		; yes: SLIME_D_CHK0100

		LDY	GOAL_BOSS_CLEAR
		BNE	SLIME_D_CHK0100

		JSL	>BOSS_EN_CHANGE

SLIME_D_CHK0100 EQU	$
		LDA	ENCBFG,X		;nʂɒ ?
		AND	#00001			;
		BEQ	SLIME_D_CHK0800		;  no: SLIME_D_CHK0800

		LDY	<ENWRK2,X		;Ghf ?
		CPY	#SLIME_RMODE80		;
		BEQ	SLIME_D_CHK0800		;
		CPY	#SLIME_RMODE81		;
		BEQ	SLIME_D_CHK0800		;
		CPY	#SLIME_RMODE82		;
		BEQ	SLIME_D_CHK0800		; yes: SLIME_D_CHK0800

		STZ	ENXSPD,X
		STZ	ENXPOW,X
		LDA	#00040H
		STA	ENTIM0,X
		LDA	#SLIME_RMODE81
		STA	<ENWRK2,X
		LDA	#0FFFFH
		STA	ENTIM3,X
		STA	TIMER_STOP

		LDY	SLMSTGF			;afRo[W ?
		BNE	SLIME_D_CHK0800		; yes: SLIME_D_CHK0800

		DEC	<ENWRK2,X
		LDA	#PDEM
		STA	PLMODE

SLIME_D_CHK0800 EQU	$

		RTS
;
SSLIM_CHECK	EQU	$
		LDA	SLMSTGF			;XC{X ? ( no: SSLIM_CHECK0800 )
		ORA	SLMSTART		;X^[gf ?
		ORA	GOAL_BOSS_CLEAR		;|ꂽ ?
		BNE	SSLIM_CHECK0800		; yes: SSLIM_CHECK0800

		LDY	<ENWRK2,X		;Ghf ?
		CPY	#SLIME_RMODE80		;
		BPL	SSLIM_CHECK0800		; yes: SSLIM_CHECK0800

		LDA	#SSLIM			;тՂ悢 ?
		STA	R4			;
		INC	A			;
		STA	R5			;
		M_CHIP	TARGET_COUNTER		;
		LDX	<ENINDX			;
		LDY	R6			;
		BNE	SSLIM_CHECK0800		; yes: SSLIM_CHECK0800

		M_CHIP	EGGSEARCH		;^}S ?
		LDX	<ENINDX			;
		LDY	R6			;
		BNE	SSLIM_CHECK0800		; yes: SSLIM_CHECK0800

		LDA	#SSLIM
		JSL	>ENINSR
		BCC	SSLIM_CHECK0800

		LDA	<RANDM0
		AND	#000FFH
		CLC
		ADC	#00248H-80H
		STA	ENXPSL,Y
		LDA	#00730H
		STA	ENYPSL,Y
		LDA	#00001
		STA	ENYUSN,Y

SSLIM_CHECK0800 EQU	$

		RTS
;
SLM_BGDTMK_DT1	EQU	$
		WORD	0FFFDH,0FFFEH
;
SLIME_BGDTMK	EQU	$
		LDY	<ENWRK2,X		;on ?
		CPY	#SLIME_RMODE10		;
		BNE	SLIME_BGDTMK0100	;  no: SLIME_BGDTMK0100

		STZ	ENCBFG,X		;af`FbNLZ

		RTS

SLIME_BGDTMK0100 EQU	$
		LDY	ENYSPD+1,X		;㏸Ă ?
		BMI	SLIME_BGDTMK0180	; yes: SLIME_BGDTMK0180

		LDA	SLMYLOW			;nʂɒ ?
		BMI	SLIME_BGDTMK0180	;
		CMP	ENYPSL,X		;
		BPL	SLIME_BGDTMK0180	;  no: SLIME_BGDTMK0180

		STA	ENYPSL,X
		LDA	ENCBFG,X
		ORA	#00001
		STA	ENCBFG,X

SLIME_BGDTMK0180 EQU	$
		LDY	SLMHDFG			;Ă ?
		BNE	SLIME_BGDTMK0280	; yes: SLIME_BGDTMK0280

		LDY	#000
		LDA	ENYSPD,X
		BPL	SLIME_BGDTMK0200

		INY
		INY

SLIME_BGDTMK0200 EQU	$
		LDA	!SLM_BGDTMK_DT1,Y
		AND	ENCBFG,X
		STA	ENCBFG,X
		AND	#00003			; ?
		BEQ	SLIME_BGDTMK0400	;  no: SLIME_BGDTMK0400
		AND	#00002			; ?
		BEQ	SLIME_BGDTMK0300	;  no: SLIME_BGDTMK0300
;
		LDA	ENWRKA,X		;̂x@onrDZ[u
		SEC
		SBC	#00004H
		STA	SLMHDYP			;

		STZ	ENYSPD,X

		STZ	<ENWRK2,X
		STZ	ENGPOW,X		;f@onvdqNA
		INC	SLMHDFG			;Ղ擪tOZbg

SLIME_BGDTMK0280 EQU	$
		LDA	SLMHDYP
		CLC
		ADC	ENYPSL,X
		SEC
		SBC	ENWRKA,X
		BRA	SLIME_BGDTMK0380

SLIME_BGDTMK0300 EQU	$
		LDA	ENYPSL,X		;x@onrD␳
		AND	#0FFF0H			;
		ORA	#00001			;
						;
SLIME_BGDTMK0380 EQU	$			;
		STA	ENYPSL,X		;

SLIME_BGDTMK0400 EQU	$
		LDA	ENCBFG,X
		AND	#00030H
		LSR	A
		LSR	A
		ORA	ENCBFG,X
		STA	ENCBFG,X

SLIME_BGDTMK0800 EQU	$

		RTS
;
;SLIME_SUB_DAT	 EQU	 $
;		 WORD	 00300H,00500H
;
SLIME_OBJCK	EQU	$
		LDY	ECRSFG,X		;GƂ ?
		DEY				;
		BMI	SLIME_OBJCK0200		;ԂƂ ?
		BEQ	SLIME_OBJCK0200		;  no: SLIME_OBJCK0200

		LDA	ENMODE,Y		;Ă ?
		CMP	#EMOVE			;
		BNE	SLIME_OBJCK0200		;  no: SLIME_OBJCK0200
		LDA	ENSHOT,Y		;VbgĂ ?
		BEQ	SLIME_OBJCK0200		;  no: SLIME_OBJCK0200

		CPY	SLMDIDX			;Ă͏߂ďՓ˂ ?
		BEQ	SLIME_OBJCK0080		;  no: SLIME_OBJCK0080

		STY	SLMDIDX			;Ă̃CfbNXZbg
		STZ	SLMDMGC			;тՂ攭JE^[NA

SLIME_OBJCK0080 EQU	$
		LDA	SLMSIZE			;ԂႭȂ ?
		CMP	#04C00H			;
		BCC	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100

		LDA	<ENWRK2,X		;XEBO ?
		CMP	#SLIME_RMODE03		;
		BEQ	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100
		CMP	#SLIME_RMODE80		;Ghf ?
		BEQ	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100
		CMP	#SLIME_RMODE81		;
		BEQ	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100
		CMP	#SLIME_RMODE82		;
		BNE	SLIME_OBJCK0400		;  no: SLIME_OBJCK0400

SLIME_OBJCK0100 EQU	$
		TYX
		JSL	>SHOT_EN_KILL

SLIME_OBJCK0200 EQU	$
		LDY	#0FFH			;Ă̃CfbNXNA
		STY	SLMDIDX			;

		RTS

SLIME_OBJCK0400 EQU	$
		LDA	#00020H			;_[W^C}[Zbg
		STA	SLMDMGT			;

		LDA	ENTIM1,X		;`FbNbN ?
		BNE	SLIME_OBJCK0200		; yes: SLIME_OBJCK0200

		LDA	ENXPSL,Y		;Ă̂w@onrDZ[u
		STA	<EWORK0			;
		LDA	ENYPSL,Y		;	h	@ x@onrDZ[u
		STA	<EWORK2			;
		LDA	ENGPOW,Y
		STA	<EWORK4

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	SLMDMGC			;тՂ攭 ?
		AND	#00003H			;
		ORA	SLMSTGF			;XC{X ?
		BNE	SLIME_OBJCK0480		;  no: SLIME_OBJCK0480

		LDA	#SSLIM			;тՂTCȏア ?
		STA	R4			;
		INC	A			;
		STA	R5			;
		M_CHIP	TARGET_COUNTER		;
		LDX	<ENINDX			;
		LDY	R6			;
		CPY	#005+1			;
		BPL	SLIME_OBJCK0480		; yes: SLIME_OBJCK0480

		LDA	#SSLIM			;тՂ攭ł ?
		JSL	>ENINSR			;
		BCC	SLIME_OBJCK0480		;  no: SLIME_OBJCK0480

		M8
		LDA	#SSLIM_RMODE2
		STA	ENWRK2,Y
		LDA	#010H			;IuWF`FbNbN^C}[Zbg
		STA	ENTIM2,Y		;
		LDA	ENMOD0+1,Y		;Փ˃`FbNȂ
		AND	#11111001B		;
		STA	ENMOD0+1,Y		;
		LDA	#001
		STA	ENYUSN,Y
		LDA	#02EH
		STA	ENCLOR,Y
		LDA	#040H
		STA	ENGPOW,Y
		M16
		TYA
		CLC
		ADC	#EXNO*4
		TAY
		BRA	SLIME_OBJCK0490

SLIME_OBJCK0480 EQU	$
		LDA	#SLMSB		;(A) <-- enemy no.
		JSL	>EXINSR

		LDA	#0FFFFH
		STA	EXTIM0,Y

SLIME_OBJCK0490 EQU	$
		LDA	<EWORK0
		STA	EXXPSL,Y	;X pos set
		LDA	<EWORK2
		STA	EXYPSL,Y	;Y pos set
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16

		LDA	<RANDM0
		PHA
		AND	#001FFH
		SEC
		SBC	#00100H
		STA	EXXSPD,Y	;X speed set
		BMI	SLIME_OBJCK0500

		LDA	#00002
		STA	EXMUKI,Y

SLIME_OBJCK0500 EQU	$
		PLA
		XBA
		AND	#003FFH
		EOR	#0FFFFH
		INC	A
		STA	EXYSPD,Y	;Y speed set

		INC	SLMDMGC			;тՂ攭JE^[INC.

		LDY	SLMDMGF
		BNE	SLIME_OBJCK0700

		INC	SLMDMGF			;Ղ_[WtOZbg
		LDY	#002			;hhtOZbg
		STY	SLMNIGE			;

		LDY	<ENWRK2,X		;Ղ@ړ ?
		CPY	#SLIME_RMODE02		;
		BNE	SLIME_OBJCK0600		;  no: SLIME_OBJCK0600

		LDA	#00003H			;Ղh񐔃Zbg
		STA	SLMYURE			;
		STZ	ENXSPD,X		;x idou stop
		STZ	ENXPOW,X		;

SLIME_OBJCK0600 EQU	$
		LDA	ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,X
		LDA	ENXMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X

SLIME_OBJCK0700 EQU	$
;		 LDY	 #000
;		 LDA	 ENMYNO,X
;		 CMP	 #SLIME
;		 BEQ	 SLIME_OBJCK0780
;
;		 INY
;		 INY
;
;SLIME_OBJCK0780 EQU	 $
		LDA	SLMSIZE
		SEC
;		 SBC	 !SLIME_SUB_DAT,Y
		SBC	#00300H
;		SBC	#00100H
		CMP	#04C00H
		BCS	SLIME_OBJCK0800

		LDA	#04BFFH

SLIME_OBJCK0800 EQU	$
		STA	SLMSIZE
		LDY	#002H
		LDA	<EWORK4			;l`wȂ ?
		CMP	#00040H			;
		BPL	SLIME_OBJCK0900		;  no: SLIME_OBJCK0900

		LDY	#001

SLIME_OBJCK0900 EQU	$
		TYA				;`FbNbN^C}[Zbg
		STA	ENTIM1,X		;

SLIME_PLCHK0001 EQU	$

		RTS
;
SLIME_PLCHK_DT	EQU	$
		WORD	00080H,0FF80H
;
SLIME_PLCHK	EQU	$
		LDA	CCWORKD			;vC[̋߂ɂ ?
		BEQ	SLIME_PLCHK0001		;  no: SLIME_PLCHK0001

		STZ	PLDOSN
		BIT	#00001H			;vC[ɓ܂Ă ?
		BEQ	SLIME_PLCHK0050		;  no: SLIME_PLCHK0050

		BIT	#0000EH			;vC[̑`FbNꂽ ?
		BEQ	SLIME_PLCHK0280		; yes: SLIME_PLCHK0280

SLIME_PLCHK0050 EQU	$
		LDY	EPXMUK,X
		LDA	!SLIME_PLCHK_DT,Y
		SEC
		SBC	EPWIDX,X
		CMP	#08000H
		ROR	A
 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		STA	R0
		LDA	#00122H
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************
		STA	<EWORK0

		LDY	<ENWRK2,X		;Ghf ?
		CPY	#SLIME_RMODE80		;
		BEQ	SLIME_PLCHK0280		;
		CPY	#SLIME_RMODE81		;
		BEQ	SLIME_PLCHK0280		;
		CPY	#SLIME_RMODE82		;
		BEQ	SLIME_PLCHK0280		; yes: SLIME_PLCHK0280

		LDA	PLXSPD			;vC[̂wXs[ho߂Ă ?
		PHA				;
		CLC				;
		ADC	#00400H			;
		CMP	#00800H			;
		BCS	SLIME_PLCHK0250		; yes: SLIME_PLCHK0250

		PLA				;vC[̂wXs[h␳
		SEC				;
		SBC	<EWORK0			;
		STA	PLXSPD			;
		STA	PLMVSP			;
		BRA	SLIME_PLCHK0280

SLIME_PLCHK0250 EQU	$
		PLA

SLIME_PLCHK0280 EQU	$
		LDA	CCWORKD			;vC[ɓ܂Ă ?
		BIT	#00001H			;
		BEQ	SLIME_PLCHK0400		;  no: SLIME_PLCHK0400

		LDA	PLYSPD			;vC[㏸ ?
		BMI	SLIME_PLCHK0400		; yes: SLIME_PLCHK0400

		LSR	A			;vC[̂xXs[h␳
		STA	PLYSPD

SLIME_PLCHK0400 EQU	$
		LDY	EPYMUK,X
		LDA	!SLIME_PLCHK_DT,Y
		SEC
		SBC	EPWIDY,X
		STA	<EWORK0

		LDA	PLYSPD
		PHA
		CLC
		ADC	#00200H
		CMP	#00400H
		BCS	SLIME_PLCHK0500

		PLA				;㏸n߂ ?
		SEC				;
		SBC	<EWORK0			;
		SEC				;
		SBC	#00080H			;
		STA	PLYSPD			;
		BPL	SLIME_PLCHK0900		;  no: SLIME_PLCHK0900

		LDA	#P006
		STA	PLJUMP
		LDA	#001+8000H
		STA	PLSPJP

		RTS

SLIME_PLCHK0500 EQU	$
		PLA

SLIME_PLCHK0900 EQU	$

		RTS
;
SLIME_SUB00	EQU	$
SLIME_SUB11	EQU	$
		TYX

		JSR	SLIME_MOV

		LDA	SLMSXZM
		BEQ	SLIME_SUB00300
		BMI	SLIME_SUB00200

		DEC	SLMSXZM
		BRA	SLIME_SUB00300

SLIME_SUB00200	EQU	$
		INC	SLMSXZM

SLIME_SUB00300	EQU	$

		RTS
;
PUYO_YURE_XSPD	EQU	$
		WORD	00100H,0FF00H
;
SLIME_SUB01	EQU	$
		TYX

		LDY	SLMSTART		;X^[gbN ?
		BNE	SLIME_SUB01100		; yes: SLIME_SUB01100

		LDA	SLMNIGE			; ?
		BEQ	SLIME_SUB01300		;  no: SLIME_SUB01300

		LDY	SLMSIZE+1		;ՂAȂĂ ?
		CPY	#04BH+1			;
		BCC	SLIME_SUB01100		; yes: SLIME_SUB01100

		BIT	#00001H			;Ղ_[W󂯂 ?
		BNE	SLIME_SUB01200		;  no: SLIME_SUB01200

		STZ	ENXSPD,X		;w@roddcNA
		STZ	ENXPOW,X		;w@onvdqNA
		LDA	#00002H			;Ղh񐔃Zbg
		STA	SLMYURE			;

		LDY	#SLIME_RMODE03		;routine mode index set
		STY	<ENWRK2,X		;

SLIME_SUB01100	EQU	$

		RTS

SLIME_SUB01200	EQU	$
		LDA	SLMNIGE			;ՂEɐiƂĂ ?
		AND	#00002H			;   0... yes 2...no
		TAY				;iт̂Xs[hZbgj
		LDA	!PUYO_YURE_XSPD,Y
		BRA	SLIME_SUB01600

SLIME_SUB01300	EQU	$
		LDA	#000C0H
		LDY	EPXMUK,X
		BNE	SLIME_SUB01400

		EOR	#0FFFFH
		INC	A

SLIME_SUB01400	EQU	$
		STA	<EWORK0

		LDA	EPWIDX,X
		STA	<EWORK2

		LDA	ENCBFG,X		;isɕ ?
		AND	#0000CH			;
		BEQ	SLIME_SUB01500		;
		SEC				;
		SBC	#00006H			;
		EOR	<EWORK2			;
		BMI	SLIME_SUB01500		;  no: SLIME_SUB01500

		LDA	<EWORK0
		EOR	#0FFFFH
		INC	A
		STA	<EWORK0

SLIME_SUB01500	EQU	$
		LDA	<EWORK0
		LDY	SLMDMGF			;_[W󂯂 ?
		BEQ	SLIME_SUB01600		;  no: SLIME_SUB01600

		STZ	SLMDMGF			;Ղ_[WtONA
		EOR	#0FFFFH
		INC	A

SLIME_SUB01600	EQU	$
		STA	R0
		LDY	SLMSIZE+1
		TYA
		STA	<EWORK0
		LDA	#00200H
		SEC
		SBC	<EWORK0
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	ENXMAX,X

		LDY	SLMNIGE			;Ă ?
		BEQ	SLIME_SUB01700		;  no: SLIME_SUB01700

		STZ	SLMNIGE			;tobinoki flag clear

		LDY	#SLIME_RMODE04
		STY	<ENWRK2,X		;routine mode index set
		BRA	SLIME_SUB01900

SLIME_SUB01700	EQU	$
		LDA	EPWIDX,X		;vC[߂ɂ ?
		CLC				;
		ADC	#00080H			;
		CMP	#00100H			;
		BCS	SLIME_SUB01800		;  no: SLIME_SUB01800

		LDA	<RANDM0			;Wv ?
		BIT	#00003H			;
		BEQ	SLIME_SUB01800		; yes: SLIME_SUB01800

		STZ	SLMYURE			;Ղh񐔃NA

		STZ	SLMSXZM			;sin data x zoom clear

		LDA	#00010H			;w@onvdqZbg
		STA	ENXPOW,X		;

		LDA	#00100H			;{Xs[h̏ƃ~bgZbg
		STA	SLMZMAX			;
		STA	<ENWRK4,X		;

		LDY	#SLIME_RMODE02		;routine mode index set
		STY	<ENWRK2,X		;
		RTS

SLIME_SUB01800	EQU	$
		STZ	<ENWRK2,X		;routine mode index set

SLIME_SUB01900	EQU	$
		LDA	#00400H			;{Xs[h̏ƃ~bgZbg
		STA	SLMZMAX			;
		STA	<ENWRK4,X		;

		LDA	#0FCE0H			;{Xs[h̉Zbg
		STA	SLMZMIN			;

		LDA	ENXMAX,X
		STA	SLMXSPD
		STZ	ENXPOW,X

		RTS
;
SLIME_SUB02	EQU	$
		TYX

		LDA	<ENWRK4,X		;nobiteru ?
		CMP	SLMZMAX			;
		BNE	SLIME_SUB02200		;  no: SLIME_SUB02200

		LDA	ENXMAX,X
		BMI	SLIME_SUB02300

SLIME_SUB02100	EQU	$
		INC	SLMSXZM

		BRA	SLIME_SUB02400

SLIME_SUB02200	EQU	$
		LDA	ENXMAX,X
		BMI	SLIME_SUB02100

SLIME_SUB02300	EQU	$
		DEC	SLMSXZM

SLIME_SUB02400	EQU	$
		JSR	SLIME_MOV200

		LDY	SLMSIZE+1		;ՂAȂĂ ?
		CPY	#04BH+1			;
		BCC	SLIME_SUB02800		; yes: SLIME_SUB02800

		TXA
		STA	R1
		M_CHIP	SHOTENSR
		LDX	<ENINDX
		LDY	R1			;VbgĂGȂ ?
		BMI	SLIME_SUB02800		; yes: SLIME_SUB02800

		LDA	ECENTX,Y		;߂ɂ ?
		SEC				;
		SBC	ECENTX,X		;
		STA	<EWORK0			;
		CLC				;
		ADC	#00080H			;
		CMP	#00100H			;
		BCS	SLIME_SUB02700		;  no: SLIME_SUB02700

		LDA	<EWORK0			;ĂĂ ?
		EOR	ENXSPD,Y		;
		BPL	SLIME_SUB02800		;  no: SLIME_SUB02800

		LDA	#SLIME_RMODE01		;routine mode index set
		STA	<ENWRK2,X		;
;;;;;;;;		LDA	#00001
		STA	SLMNIGE			;tobinoki flag set

		LDA	<EWORK0			;痈Ă ?
		BMI	SLIME_SUB02800		; yes: SLIME_SUB02800

		LDA	#00003H
		STA	SLMNIGE
		RTS

SLIME_SUB02700	EQU	$
;;;;;;;;		PLP

SLIME_SUB02800	EQU	$
		LDA	ENCBFG,X		;͕ ?
		BIT	#0000CH			;
		BEQ	SLIME_SUB02900		;  no: SLIME_SUB02900

		LDA	#00003H			;Ղh񐔃Zbg
		STA	SLMYURE			;

SLIME_SUB02900	EQU	$

		RTS
;
;		SLMSPOI SIN DATA POINTER
;		SLMSXZM SIN DATA X ZOOM FLAG
;		SLMSYST SIN DATA Y STEP
;
SLIME_SUB03	EQU	$
		TYX

		LDA	SLMYURE			;ՂhI ?
		BNE	SLIME_SUB03050		;  no: SLIME_SUB03050

		LDA	SLMSXZM			;sin data x zoom hosei end ?
		BMI	SLIME_SUB03030		; yes: SLIME_SUB03030

		DEC	SLMSXZM			;sin data x zoom hosei

		RTS

SLIME_SUB03030	EQU	$
		LDY	#SLIME_RMODE01		;routine mode index set
		STY	<ENWRK2,X		;

		STZ	SLMSXZM			;sin data x zoom clear
		STZ	SLMNIGE			;puyo damage flag clear

		RTS

SLIME_SUB03050	EQU	$
		LDA	SLMYURE
		BIT	#00001H
		BNE	SLIME_SUB03100

		LDA	SLMSYST
		CLC
		ADC	#00040H
		STA	SLMSYST
		CMP	#00800H
		BNE	SLIME_SUB03300
		BRA	SLIME_SUB03200

SLIME_SUB03100	EQU	$
		LDA	SLMSYST
		SEC
		SBC	#00040H
		STA	SLMSYST
		CMP	#00100H
		BNE	SLIME_SUB03300

SLIME_SUB03200	EQU	$
		DEC	SLMYURE

SLIME_SUB03300	EQU	$
		LDA	SLMSXZM		;sin data x zoom flag cul. & set
		CMP	#00008H		;
		BCS	SLIME_SUB03900

		INC	SLMSXZM

SLIME_SUB03900	EQU	$

		RTS
;
SLIME_SUB10	EQU	$
		TYX

		LDY	ENWRK8,X		;
		LDA	ENYPSL,X		;xAbv ?
		SEC				;
		SBC	EXYPSL,Y		;
		CMP	#0004AH			;
		BMI	SLIME_SUB10200		;  no: SLIME_SUB10200
;		CMP	#00068H			;
		CMP	#0004EH			;oI ?
		BPL	SLIME_SUB10100		; yes: SLIME_SUB10100

 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		LDA	#0001EH
		STA	ENGPOW,X
		LDA	#000A0H
		STA	ENGMAX,X
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		LDA	#00018H
		STA	ENGPOW,X
		LDA	#00080H
		STA	ENGMAX,X
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************
		BRA	SLIME_SUB10200

SLIME_SUB10100	EQU	$
		STZ	SLSTCPY			;( bg3 < bg1 ) ==> ( bg3 > bg1 )

 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		LDA	#0000FH			;new GPOW set
		STA	ENGPOW,X		;
		LDA	#00500H			;new GMAX set
		STA	ENGMAX,X		;
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		LDA	#0000CH			;new GPOW set
		STA	ENGPOW,X		;
		LDA	#00400H			;new GMAX set
		STA	ENGMAX,X		;
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************

		INC	<ENWRK2,X		;routine mode index set

		JSR	SLMEYE_SET

SLIME_SUB10200	EQU	$
		JSR	SLIME_MOV	;

		RTS
;
SLIME_SUB12	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB12800		; yes: SLIME_SUB12800

		LDA	SLMSIZE			;傫Ȃ ?
		CLC				;
;		ADC	#00100H			;
		ADC	#00240H			;
		BMI	SLIME_SUB12700		;  no: SLIME_SUB12700

		LDA	#0FFFFH

SLIME_SUB12700	EQU	$
		STA	SLMSIZE

		JSR	SLIME_MOV

SLIME_SUB12800	EQU	$

		RTS
;
SLIME_SUB13	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB13800		; yes: SLIME_SUB13800

		STZ	SLMSTART
		STZ	PLMODE
		LDY	#SLIME_RMODE01
		STY	<ENWRK2,X

SLIME_SUB13800	EQU	$
		RTS
;
SLIME_S80_KEY	EQU	$
		WORD	00100H,00200H
SLIME_S80_XMAX	EQU	$
SLIME_S80_CHKDT EQU	$
 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		WORD	00122H,0FEDEH
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		WORD	00100H,0FF00H
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************
;
SLIME_SUB80	EQU	$
		TYX

		LDY	#000
		LDA	EPWIDX,X
		CLC
		ADC	#00050H
		CMP	#000A0H
		BCS	SLIME_SUB80300

		STZ	P_KEYC1L
		INC	<ENWRK2,X

		RTS

SLIME_SUB80300	EQU	$
		BPL	SLIME_SUB80400

		INY
		INY

SLIME_SUB80400	EQU	$
		LDA	!SLIME_S80_KEY,Y
		STA	P_KEYC1L
		LDA	PLXSPD
		SEC
		SBC	!SLIME_S80_XMAX,Y
		EOR	!SLIME_S80_CHKDT,Y
		BMI	SLIME_SUB80800

		LDA	!SLIME_S80_XMAX,Y
		STA	PLXSPD
		STA	PLMVSP

SLIME_SUB80800	EQU	$

		RTS
;
SLIME_S6_XSPD	EQU	$
		WORD	00080H,00100H,00200H,00400H
SLIME_S6_YSPD	EQU	$
		WORD	0FF80H,0FF00H,0FE00H,0FC00H
;
SLIME_SUB81	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB81300		; yes: SLIME_SUB81300

		LDA	#00002
		STA	ENTIM0,X

		LDA	<RANDM0
		AND	#0000EH
		TAY
		LDA	!SLIME_S6_XSPD,Y
		STA	<EWORK0
		LDA	<RANDM0+1
		AND	#00006H
		TAY
		LDA	!SLIME_S6_YSPD,Y
		STA	<EWORK2
		LDA	<RANDM0
		AND	#0000FH
		SEC
		SBC	#00008
		STA	<EWORK4

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	#SLMSB		;(A) <-- enemy no.
		JSL	>EXINSR

		LDA	ENXPSL,X
		CLC
		ADC	<EWORK4
		STA	EXXPSL,Y	;X pos set
		LDA	ENYPSL,X
		SEC
		SBC	#00004
		STA	EXYPSL,Y	;Y pos set
		LDA	#0FFFFH
		STA	EXTIM0,Y
		LDA	<EWORK0
		STA	EXXSPD,Y
		LDA	<EWORK2
		STA	EXYSPD,Y
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16

SLIME_SUB81300	EQU	$
		LDA	SLMSIZE			;ŃTCYɂȂ ?
		SEC				;
		SBC	#00020H			;
		STA	SLMSIZE			;
		CMP	#02000H			;
		BCS	SLIME_SUB81800		;  no: SLIME_SUB81800

		LDA	#00040H
		STA	ENTIM0,X
		INC	<ENWRK2,X

SLIME_SUB81800	EQU	$
SLIME_SUB82000	EQU	$

		RTS
;
SLIME_SUB82	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB82000		; yes: SLIME_SUB82000

		INC	SLMDEMO
		LDY	SLMDEMO
		CPY	#001
		BEQ	SLIME_SUB82500
		CPY	#002
		BEQ	SLIME_SUB82300

		STZ	TROBJ_ARIA
		PLA
		JMP	>ENCLEAR_NORETN
;;;;;;;;		JMP	>BOSS_CLEAR

SLIME_SUB82300	EQU	$
		LDA	ENXPSL,X
		STA	<EWORK0
		LDA	ENYPSL,X
		SEC
		SBC	#00010H
		STA	<EWORK2
		JSL	>BSCLW_SET_B
		LDA	#000C0H			;Xgbv^C}[Zbg
		STA	ENTIM0,X		;
;;;;;;;;		LDA	#00005			;mrn
;;;;;;;;		STA	SOUND_0

		RTS

SLIME_SUB82500	EQU	$
		LDA	ENWRK8,X
		TAX
		LDA	#SMOK0		;(A) <-- exstra no.
		JSL	>EXINSR
		LDA	ENXPSL,X	;X pos set
		STA	EXXPSL,Y
		LDA	ENYPSL,X	;Y pos set
		STA	EXYPSL,Y
		LDA	#00		;X speed set
		STA	EXXSPD,Y
		LDA	EXMOD2,Y
		AND	#0FFFCH
		STA	EXMOD2,Y
		LDA	#0FFC0H		;Y speed set
		STA	EXYSPD,Y
		LDA	#02		;counter set
		STA	EXWRK0,Y
		LDA	#06		;timer set
		STA	EXTIM0,Y

		JSL	>ENCLEAR		;Ղ̖ڂNA

		LDA	#0001CH		;mrn
		JSL	>SOUND_3_ON

		M_CHIP	HDMABF_CLR
		I16
		JSL	>M_DMA_BFST
		LWORD	HDMABUF		;to address set
		LWORD	HDMABF		;from address set
		WORD	0D2H*2*2	;number of byte set
		I8
		LDX	<ENINDX
		LDA	#00002H
		STA	ENTIM0,X
		LDY	SLMSTGF			;afRo[W ?
		BEQ	SLIME_SUB82800		;  no: SLIME_SUB82800

		LDA	#DRKEY
		JSL	>ENINSR_I

		LDA	ENWRK8,X
		TAX
		LDA	ENXPSL,X
		STA	ENXPSL,Y
		LDA	ENYPSL,X
		STA	ENYPSL,Y
		LDA	#0FB00H
		STA	ENYSPD,Y
		LDA	#00001
		STA	ENSHOT,Y
		LDA	BLKSETX			;݃rbgNA|WVZbg
		STA	ENWRKA,Y		;
		LDA	BLKSETY			;
		STA	ENWRKC,Y		;
;
		LDA	#00215H
		STA	MANSEL
;
		LDX	<ENINDX
		PLA
		JMP	>ENCLEAR_NORETN

SLIME_SUB82800	EQU	$

		RTS
;
SLIME_SUB90	EQU	$
		TYX
;
		LDA	ENTIM0,X	;Xgbv ?
		BNE	SLIME_SUB90200	;  no: SLIME_SUB90200

		DEC	SLMZMIN		;colour change counter dec.
		BEQ	SLIME_SUB90100	;colour change end ?
					; yes: SLIME_SUB90100

		LDA	#00008H		;colour change timer set
		STA	ENTIM0,X	;

		JSR	BLKSLM_COLCHG	;

		RTS

SLIME_SUB90100	EQU	$
		STZ	SLMTRZM		;counter ( bairitu ) clear

		INC	<ENWRK2,X	;routine mode index inc.

SLIME_SUB90200	EQU	$

		RTS
;
PUYO_DATA	EQU	$
		BYTE	000H,0B2H, 00AH,0B2H, 00FH,0B3H, 012H,0B4H
		BYTE	017H,0B5H, 01BH,0B7H, 021H,0BAH, 028H,0BFH
		BYTE	02FH,0C5H, 032H,0C9H, 033H,0CCH, 035H,0CFH
		BYTE	038H,0D4H, 038H,0D8H, 039H,0DBH, 03AH,0DCH
		BYTE	03AH,0E0H, 03BH,0E1H, 03BH,0E8H, 03AH,0EAH
		BYTE	039H,0ECH, 038H,0EFH, 036H,0F1H, 031H,0F5H
		BYTE	02DH,0F7H, 027H,0FAH, 025H,0FBH, 01FH,0FCH
		BYTE	019H,0FEH, 015H,0FFH, 00EH,0FFH, 00EH,000H
		BYTE	000H,000H, 0F1H,000H, 0F1H,0FFH, 0EBH,0FFH
		BYTE	0E7H,0FEH, 0E0H,0FCH, 0DBH,0FBH, 0D9H,0FAH
		BYTE	0D3H,0F7H, 0CFH,0F5H, 0CAH,0F1H, 0C8H,0EFH
		BYTE	0C7H,0ECH, 0C6H,0EAH, 0C5H,0E8H, 0C5H,0E1H
		BYTE	0C6H,0E0H, 0C6H,0DCH, 0C7H,0DBH, 0C8H,0D8H
		BYTE	0C8H,0D4H, 0CBH,0CFH, 0CDH,0CCH, 0CEH,0C9H
		BYTE	0D2H,0C5H, 0D8H,0BFH, 0DFH,0BAH, 0E5H,0B7H
		BYTE	0E9H,0B5H, 0EEH,0B4H, 0F1H,0B3H, 0F6H,0B2H
;
PUYO_END	EQU	$
;
PUYO_DATA_SUM	EQU	(PUYO_END-PUYO_DATA)/2
;
BLOCK_DATA	EQU	$
		BYTE	000H,0C1H, 006H,0C1H, 00CH,0C1H, 012H,0C1H
		BYTE	018H,0C1H, 01EH,0C1H, 024H,0C1H, 02AH,0C1H
		BYTE	02FH,0C1H, 02FH,0C5H, 02FH,0C9H, 02FH,0CDH
		BYTE	02FH,0D1H, 02FH,0D5H, 02FH,0D9H, 02FH,0DDH
		BYTE	02FH,0E1H, 02FH,0E5H, 02FH,0E9H, 02FH,0EDH
		BYTE	02FH,0F1H, 02FH,0F5H, 02FH,0F9H, 02FH,0FDH
		BYTE	02FH,000H, 02AH,000H, 024H,000H, 01EH,000H
		BYTE	018H,000H, 012H,000H, 00CH,000H, 006H,000H
		BYTE	000H,000H, 0FAH,000H, 0F4H,000H, 0EEH,000H
		BYTE	0E8H,000H, 0E2H,000H, 0DCH,000H, 0D6H,000H
		BYTE	0D0H,000H, 0D0H,0FDH, 0D0H,0F9H, 0D0H,0F5H
		BYTE	0D0H,0F1H, 0D0H,0EDH, 0D0H,0E9H, 0D0H,0E5H
		BYTE	0D0H,0E1H, 0D0H,0DDH, 0D0H,0D9H, 0D0H,0D5H
		BYTE	0D0H,0D1H, 0D0H,0CDH, 0D0H,0C9H, 0D0H,0C5H
		BYTE	0D0H,0C1H, 0D6H,0C1H, 0DCH,0C1H, 0E2H,0C1H
		BYTE	0E8H,0C1H, 0EEH,0C1H, 0F4H,0C1H, 0FAH,0C1H
;
;
;
SLIME_SUB91	EQU	$
		TYX

		LDA	SLMTRZM		;first change ?
;		BNE	SLIME_SUB9100	;  no: SLIME_SUB91100
		BEQ	SLIME_SUB91100
		JMP	SLIME_SUB91600

SLIME_SUB91100	EQU	$
		PHA

;		clear ??
;
;		LDA	#01220H			;trans. data set
;		LDA	#013EEH			;trans. data set
;		STA	BLKVRDT
;
;--------------< u@f[^NA >----------------
		LDA	#UT0000		;trans. data set
		JSL	>BGDATA_MAKE

		LDA	<EWORK4
		LDX	#000H
SLIME_SUB91200	EQU	$
		STA	BLKVRDT,X
		INX
		INX
		CPX	#020H
		BNE	SLIME_SUB91200

		LDA	BLKADDR		;vram addr. set
		STA	<EWORK0		;

		LDA	#00008		;V_line sum.*2 set
		STA	<EWORK2		;

		PHB
		M8
		LDA	#BANK VRAMDX
		PHA
		PLB

		MI16
		LDX	#VRAMDX
		INX
		INX

SLIME_SUB91300	EQU	$
		LDA	<EWORK0		;Vram addr. set
		STA	00H,X		;

		LDA	#00180H		;inc. mode & DMA para. set
		STA	02H,X		; 2115h & 43*0h

		LDA	#00018H		;DMA B_bus addr. set ( 0021**H )
		STA	04H,X		;

		LDA	#BLKVRDT	;DMA A_bus addr. set
		STA	05H,X		;

		LDA	#BANK BLKVRDT	;DMA A_bus bank set
		STA	07H,X		;

		LDA	#00006*4	;DMA trans. data sum. set
		STA	08H,X		;

		TXA			;next data addr. calc.
		CLC			;
		ADC	#0000CH		;
		STA	0AH,X		;next data addr. set
		TAX

		DEC	<EWORK2		;trans. data end ?
		BEQ	SLIME_SUB91380	; yes: SLIME_SUB91380

		LDA	<EWORK0		;next Vram addr. calc.
		CLC			;
		ADC	#00020H		;
		STA	<EWORK0		;
		BRA	SLIME_SUB91300

SLIME_SUB91380	EQU	$
		TXA			;last data addr. set
		STA	VRAMDX		;

		PLB
;
;--------------< af`FbNobt@NA >---------------
		LDX	<ENINDX
		LDA	#00004			;c[v񐔃Zbg
		STA	<EWORKA			;
		LDA	BLKADDR
		SEC
		SBC	#06800H
		STA	<EWORK0
		STA	<EWORK8
		LDA	ENDSYL,X
		SEC
		SBC	#00040H

SLIME_SUB91420	EQU	$
		STA	<EWORKE			;ʊO ?
		CMP	#00100H			;
		BCS	SLIME_SUB91490		; yes: SLIME_SUB91490

		LDY	#00006			;[v񐔃Zbg
		LDX	<ENINDX
		LDA	ENDSXL,X
		SEC
		SBC	#00028H

SLIME_SUB91430	EQU	$
		STA	<EWORKC			;ʊO ?
		CMP	#00130H			;
		BCS	SLIME_SUB91480		; yes: SLIME_SUB91480

		LDA	<EWORK0
		BIT	#00400H
		BEQ	SLIME_SUB91450

		EOR	#00400H|020H

SLIME_SUB91450	EQU	$
		TAX
		LDA	#UT0000
		STA	>BGCHECK_BUF,X

SLIME_SUB91480	EQU	$
		LDA	<EWORKC
		CLC
		ADC	#00010H
		INC	<EWORK0
		INC	<EWORK0
		DEY				;dmc ?
		BNE	SLIME_SUB91430		;  no: SLIME_SUB91430

SLIME_SUB91490	EQU	$
		LDA	<EWORK8
		CLC
		ADC	#00040H
		STA	<EWORK0
		STA	<EWORK8
		LDA	<EWORKE
		CLC
		ADC	#00010H
		DEC	<EWORKA			;cdmc ?
		BNE	SLIME_SUB91420		;  no: SLIME_SUB91420
;
;--------------< jbgobt@NA >---------------
		LDA	#00004		;tate loop counter set
		STA	<EWORK0		;

		LDX	BLKBGID

SLIME_SUB91500	EQU	$
		PHX
		LDY	#00006		;yoko loop counter set

SLIME_SUB91580	EQU	$
;		LDA	#UT00D5		;normal kabe set
		LDA	#UT0000		;nuki set
		STA	>BGUNIT,X	;
		INX			;data set index inc.
		INX			;data set index inc.
		DEY			;yoko loop end ?
		BNE	SLIME_SUB91580	;  no: SLIME_SUB91580

		PLA			;next v_line addr. calc.
		CLC			;
		ADC	#00020H		;
		TAX			;

		DEC	<EWORK0		;tate loop end ?
		BNE	SLIME_SUB91500	;  no: SLIME_SUB91500

		I8
		LDX	<ENINDX
		PLA

SLIME_SUB91600	EQU	$
		CMP	#00100H			;[ӂ񂮏I ?
		BMI	SLIME_SUB91700		;  no: SLIME_SUB91700

		LDA	#00010H			;new GPOW set
		STA	ENGPOW,X		;
		LDA	#00400H			;new GMAX set
		STA	ENGMAX,X		;
;
		INC	BG3USEFG		;obNtOZbg

		LDA	#000A0H			;c{lZbg
		STA	<ENWRK0,X		;
		STZ	ENWRK6,X		;{Xs[hNA
		STZ	ENWRK4,X		;{Xs[h~bgNA
		STZ	ENWRKC,X		;ntONA
		LDY	#SLIME_RMODE01		;routine mode index set
		STY	<ENWRK2,X		;
;
;--------------< other work set >----------------
		STZ	SLMZMAX			;^e{Xs[hl`wNA
		STZ	SLMZMIN			;^e{Xs[hlhmNA
		STZ	SLMFTFG			;ntONA
		STZ	SLMSPOI			;rhmf[^|C^[NA
		STZ	SLMSXZM			;rhmf[^Aw@Y[NA
		LDA	#00100H			;rhmf[^Ax@XebvZbg
		STA	SLMSYST			;
		STZ	SLMYURE			;Ղh񐔃NA
		STZ	SLMDMGF			;_[WtONA
		STZ	SLMNIGE			;т̂tONA
		LDA	#0E000H
		STA	SLMSIZE			;ՂTCYNA
		STZ	SLMDMGT			;Ղ_[W^C}[Zbg
		STZ	SLMKIRE			;Z^[onrDNA
		LDA	#0FFFFH			;`FbNx@onrDZbg
		STA	SLMYLOW			;
;
		STZ	ENWRKA,X		;␳bNtONA
		STZ	SLMHDFG			;tONA

		STZ	SLMSTART		;X^[gXgbvtONA
		STZ	SLMDEMO			;ՂtONA

		STZ	SLSTCPY			;( bg3 < bg1 ) ==> ( bg3 > bg1 )
		STZ	SLMTRZM		;puyo henkei bairitu clear

		STZ	SLSTCPY		;( slime start y pos. for compare ) clear

		JMP	SLMEYE_SET	;puyo eye set

SLIME_SUB91700	EQU	$
;
;-------------- afRZbg --------------------------------------------
		LDA	#BLOCK_DATA
		STA	R1		;(R1) <-- [tBOf[^AhX
		LDA	#PUYO_DATA
		STA	R2		;(R2) <-- [tBOf[^AhX
		LDA	#BANK PUYO_DATA
		STA	R0		;(R0)  <-- [tBOf[^AhXiaj
		LDA	#PUYO_DATA_SUM
		STA	R3		;(R3)  <-- |Cg
		LDA	#00021H
		STA	R4		;(R4)  <-- S|CgmD
		LDA	#BG3_POLYGON_DT
		STA	R5		;(R5)  <-- [tBOf[^i[AhX
		LDA	SLMTRZM
		STA	R6		;(R6)  <-- [tBO
		LDA	ENDSXL,X
		CLC
		ADC	#08H
		STA	CREG0		;\wWZbg
		LDA	ENDSYL,X
		STA	CREG1		;\xWZbg
		M_CHIP	BG3_MORPHING_N
;
;--------------< data trans. >-----------------
		JSL	>M_DMA_BFST
		LWORD	HDMABUF		;]AhX
		LWORD	HDMABF		;]AhX
		WORD	(0D2H*2*2)	;]oCg
;
;-------------- vC[ƂafRƂ̏Փ˃`FbN ----------------------
		LDA	<ENINDX
		STA	CCWORK9		;(CWK9) <-- GCfbNX
		LDA	PLDSXL
		STA	CCWORKA		;(CWKA) <-- player display X pos
		LDA	PLDSYL
		STA	CCWORKB		;(CWKB) <--	   "       Y  "
		LDA	PLSITD
		STA	CCWORKC		;(CWKC) <--    "   sit down flag
		M_CHIP	BG3_CROSS_CK
;
;--------------< config. set >-------------------
		MI8
		LDY	#010H
		LDA	#007H
		STY	MANSEL
		STA	SUBSEL
		LDA	#002H
		STA	WIND30
		LDA	#020H
		STA	SUBADF

		LDA	#00011000B
		TSB	HD420C
		M16

		LDX	<ENINDX
;--------------< colour set >-----------------
;		LDA	#07FFFH
		LDA	#0637DH			;gJ[
		STA	>DATACOL+(01H*2)	;
		STA	>MOTOCOL+(01H*2)	;
;		LDA	#07FF6H			;
		LDA	#04A75H			;eJ[
		STA	>DATACOL+(02H*2)	;
		STA	>MOTOCOL+(02H*2)	;
		LDA	#0000H			;֊sJ[
		STA	>DATACOL+(03H*2)	;
		STA	>MOTOCOL+(03H*2)	;

		LDA	SLMTRZM
		CLC
		ADC	#00008H
		STA	SLMTRZM

		RTS
;
SLMEYE_SET	EQU	$
		LDA	#SLEYE		;(A) <-- enemy no.
		JSL	>ENINSR
		BCC	SLMEYE_SET0100	;fail: SLMEYE_SET0100

		TXA
		STA	ENWRK0,Y	;slime (main) routine index set

		TYA			;slime_eye routine index save
		STA	ENWRK8,X	;

		LDA	#00002H
		STA	ENCHPT,Y	;char. pat. no set

		LDA	ENXPSL,X
		STA	ENXPSL,Y	;X pos set

		LDA	ENYPSL,X
		SEC
		SBC	#00038H
		STA	ENYPSL,Y	;Y pos set

SLMEYE_SET0100	EQU	$

		RTS
;
BLKSLM_COLCHG	EQU	$
		I16
		LDX	SLMCOLX

		LDA	>COL_ADDRESS+SLIM_BLK_COL+0,X
;		STA	>DATACOL+(05CH*2)
		STA	>DATACOL+(00CH*2)
		STA	>MOTOCOL+(00CH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+2,X
;		STA	>DATACOL+(05DH*2)
		STA	>DATACOL+(00DH*2)
		STA	>MOTOCOL+(00DH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+4,X
;		STA	>DATACOL+(05EH*2)
		STA	>DATACOL+(00EH*2)
		STA	>MOTOCOL+(00EH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+6,X
;		STA	>DATACOL+(05FH*2)
		STA	>DATACOL+(00FH*2)
		STA	>MOTOCOL+(00FH*2)

		TXA			;next colour index calc.
		CLC			;
		ADC	#00008H		;
		STA	SLMCOLX		;
		I8
		LDX	<ENINDX

		RTS
;
;
SLIME_MOV	EQU	$
		LDY	SLMHDFG			;VɂĂ ?
		BEQ	SLIME_MOV100		;  no: SLIME_MOV100

		LDA	#00002
		BRA	SLIME_MOV130

SLIME_MOV100	EQU	$
		LDA	ENCBFG,X		;nʁ@@VɂĂ ?
		AND	#00003H			;
		BEQ	SLIME_MOV500		;  no: SLIME_MOV500

		AND	#00002H			;ڒntOZbg

SLIME_MOV130	EQU	$
		STA	ENWRKC,X		;

		LDY	SLMFTFG			;O璅nĂ ?
		BNE	SLIME_MOV200		; yes: SLIME_MOV200

		INC	SLMFTFG			;ntOZbg

		LDA	ENXSPD,X
		STA	SLMXSPD
		STZ	ENXSPD,X		;w@roddcNA

		LDA	ENWRK6,X		; ?
		BMI	SLIME_MOV150		; yes: SLIME_MOV150

		EOR	#0FFFFH			;{Xs[h]
		INC	A			;

SLIME_MOV150	EQU	$
		STA	ENWRK6,X

		JSR	SLIME_ZOM_INIT

SLIME_MOV200	EQU	$
		JSR	SLMSPD_CHG

		LDA	ENWRK6,X
		BPL	SLIME_MOV600

		EOR	#0FFFFH
		INC	A
		BRA	SLIME_MOV600

SLIME_MOV500	EQU	$
		STZ	ENWRKC,X		;ڒntONA

		STZ	SLMFTFG			;ntONA

		LDA	ENYSPD,X		;{Xs[hZbg
		STA	ENWRK6,X		;
		BPL	SLIME_MOV600

		EOR	#0FFFFH
		INC	A

SLIME_MOV600	EQU	$
		LSR	A			;c{vZ
		LSR	A			;
		LSR	A			;
		CLC				;
		ADC	#000A0H			;
;		ADC	#000E0H			;
						;
SLIME_MOV800	EQU	$
		STA	<ENWRK0,X		;

		RTS
;
SLIME_ZOM_INIT	EQU	$
		STA	R6
		LDA	#-000B0H
		STA	R0
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	SLMZMAX			;{Xs[h̏Zbg
		STA	<ENWRK4,X		;{Xs[h~bgZbg
		EOR	#0FFFFH
		INC	A			;{Xs[h̉Zbg
		STA	SLMZMIN			;

		RTS
;
;SLM_YSPD_CMP	EQU	$
;		WORD	00140H,00120H,000A0H
SLIME_ST_XSPD	EQU	$
		WORD	000C0H,0FF40H
;
SLMSPD_CHG	EQU	$
		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE02		;
		BEQ	SLMSPD_CHG0002		; yes: SLMSPD_CHG0002
		CPY	#SLIME_RMODE04		;Wv ?
		BNE	SLMSPD_CHG0005		;  no: SLMSPD_CHG0005

		LDA	#04000H
		BRA	SLMSPD_CHG0008

SLMSPD_CHG0002	EQU	$
		LDA	#00A00H
		BRA	SLMSPD_CHG0008

SLMSPD_CHG0005	EQU	$
		LDA	#-03000H
		LDY	SLMNIGE			;Ă ?
		BEQ	SLMSPD_CHG0007		;  no: SLMSPD_CHG0007

		LDA	#-03400H

SLMSPD_CHG0007	EQU	$
		STA	R6
		LDY	SLMSIZE+1
		TYA
		SEC
		SBC	#00100H
		STA	R0
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		CLC
		ADC	#02000H			;

SLMSPD_CHG0008	EQU	$
		STA	<EWORK0

		LDA	ENWRK6,X		;Ղ{vZ
		BPL	SLMSPD_CHG0010		;
						;
		EOR	#0FFFFH			;
		INC	A			;
						;
SLMSPD_CHG0010	EQU	$			;
		CLC				;
		ADC	<EWORK0			;
		ASL	A			;
		AND	#0FF00H			;
		XBA				;
		STA	<EWORKE			;

		LDA	<ENWRK4,X		;{Xs[hE菬 ?
		CMP	ENWRK6,X		;
		BMI	SLMSPD_CHG0100		;  no: SLMSPD_CHG0100

		CMP	SLMZMAX			;{Xs[h͏z ?
		BEQ	SLMSPD_CHG0050		; yes: SLMSPD_CHG0050

		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE02		;
		BEQ	SLMSPD_CHG0040		; yes: SLMSPD_CHG0040

		LDA	SLMZMIN			;̔{Xs[h̉vZ
		BEQ	SLMSPD_CHG0030		;
						;
		SEC				;
		ROR	A			;
		CMP	#0FFE0H			;
		BCC	SLMSPD_CHG0030		;
						;
SLMSPD_CHG0020	EQU	$			;
		LDA	#00000H			;
						;
SLMSPD_CHG0030	EQU	$			;
		STA	SLMZMIN			;

		BRA	SLMSPD_CHG0048

SLMSPD_CHG0040	EQU	$
		INC	SLMYURE
		LDA	SLMYURE
		CMP	#00004H
		BNE	SLMSPD_CHG0048

		STZ	ENXPOW,X
		DEC	<ENWRK2,X		;routine mode index dec.

		RTS

SLMSPD_CHG0048	EQU	$
		LDA	SLMZMAX			;{Xs[h~bgɕύX
		STA	<ENWRK4,X		;

SLMSPD_CHG0050	EQU	$
		LDA	ENWRK6,X		;{Xs[hvZ
		CLC				;
		ADC	<EWORKE			;
		JMP	SLMSPD_CHG0200

SLMSPD_CHG0100	EQU	$
		CMP	SLMZMAX			;{Xs[h~bg͏ ?
		BEQ	SLMSPD_CHG0110
		JMP	SLMSPD_CHG0150		;  no: SLMSPD_CHG0150

SLMSPD_CHG0110	EQU	$
		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE02		;
		BEQ	SLMSPD_CHG0135		; yes: SLMSPD_CHG0135

		LDA	SLMZMAX			;̔{Xs[h̏vZ
		BEQ	SLMSPD_CHG0135		;
						;
		LSR	A			;
		CMP	#00020H			;
		BCS	SLMSPD_CHG0130		;
						;
SLMSPD_CHG0120	EQU	$			;
		LDA	#00000H			;
						;
SLMSPD_CHG0130	EQU	$			;
		STA	SLMZMAX			;

;		LDA	#00200H			;
		LDA	#001D0H			;
		BRA	SLMSPD_CHG0137		;
						;
SLMSPD_CHG0135	EQU	$
		LDA	#00600H			;
						;
SLMSPD_CHG0137	EQU	$			;
		STA	<EWORK0			;

		LDA	ENWRK6,X		;Ղ悽ĂɐLтĂ ?
		BMI	SLMSPD_CHG0140		;  no: SLMSPD_CHG0140

		LDY	ENWRKC,X		;Ă ?
		BNE	SLMSPD_CHG013B		; yes: SLMSPD_CHG013B

		LDY	<ENWRK2,X
		CPY	#SLIME_RMODE12
		BEQ	SLMSPD_CHG0140

		LDY	SLMSTART		;CjVf ?
		BEQ	SLMSPD_CHG0138		;  no: SLMSPD_CHG0138
		DEY
		BNE	SLMSPD_CHG0138

		INC	SLMSTART
		ASL	A

SLMSPD_CHG0138	EQU	$
		CMP	<EWORK0			;
		BCC	SLMSPD_CHG0140		;  no: SLMSPD_CHG0140

		EOR	#0FFFFH			;x@roddcZbg
		INC	A			;

SLMSPD_CHG013B	EQU	$
		STA	ENYSPD,X		;

		LDA	#00034H			;mrn
		JSL	>SOUND_3_ON

		LDA	SLMXSPD
		STA	ENXSPD,X

		STZ	SLMHDFG			;tONA

		LDA	#00010H			;f@onvdqZbg
		STA	ENGPOW,X		;

		LDY	SLMSTART		;CjVf ?
		BEQ	SLMSPD_CHG0300		;  no: SLMSPD_CHG0300

		LDA	#000C0H
		STA	ENXSPD,X

SLMSPD_CHG0140	EQU	$
		LDA	SLMZMIN			;{Xs[h~bgɕύX
		STA	<ENWRK4,X		;

SLMSPD_CHG0150	EQU	$
		LDA	ENWRK6,X		;{Xs[hvZ
		SEC				;
		SBC	<EWORKE			;
						;
SLMSPD_CHG0200	EQU	$			;
		STA	ENWRK6,X		;

		LDA	SLMZMAX			;ՂWvI ?
		ORA	SLMZMIN			;
		BNE	SLMSPD_CHG0300		;  no: SLMSPD_CHG0300

		LDY	<ENWRK2,X		;CjVf ?
		CPY	#SLIME_RMODE11
		BNE	SLMSPD_CHG0240		;  no: SLMSPD_CHG0240

		LDA	#0FE00H
		JSR	SLIME_ZOM_INIT

 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		LDA	#00019H			;Xgbv^C}[Zbg
		STA	ENTIM0,X		;
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		LDA	#00020H			;Xgbv^C}[Zbg
		STA	ENTIM0,X		;
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************

		INC	<ENWRK2,X
		RTS

SLMSPD_CHG0240	EQU	$
		CPY	#SLIME_RMODE12
		BNE	SLMSPD_CHG0280

 IF PAL	   ;*** PAL Ή [1995/7/20] ******************
		LDA	#00033H
		STA	ENTIM0,X
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		LDA	#00040H
		STA	ENTIM0,X
 ENDIF	   ;*** PAL Ή [1995/7/20] ******************

		INC	<ENWRK2,X
		RTS

SLMSPD_CHG0280	EQU	$
		LDY	#SLIME_RMODE01
		STY	<ENWRK2,X		;routine mode index set

SLMSPD_CHG0300	EQU	$

		RTS
;
;************************************************************************
;*		initial ( Ղ̖ڂ )				*
;************************************************************************
SLEYEIN		EQU	$			;-- sleyein --
		RTL
;
;************************************************************************
;*		move	( Ղ̖ڂ )				*
;************************************************************************
;		ENWRK0	SLIME ROUTINE INDEX ( ENEMY INDEX )
;		ENWRK2	MABATAKI KAISUU
;		ENWRK4	EYES POS.
;		ENWRK6
;		ENWRK8
;
SLEYEMV		EQU	$			;-- sleyemv --
		JSL	>ENMDCK			;mode check

		JSR	EYE_SEARCH

		LDA	ENTIM0,X		;Lp^[`FW ?
		BNE	SLEYEMV0900		;  no: SLEYEMV0800

		LDA	<ENWRK2,X		;uȂ ?
		BEQ	SLEYEMV0800		; yes: SLEYEMV0800

		BIT	#00001H			;
		BNE	SLEYEMV0100		;

		DEC	ENCHPT,X		;char. pat. no. dec.
		LDA	ENCHPT,X		;
		BNE	SLEYEMV0700		;
		BRA	SLEYEMV0200		;

SLEYEMV0100	EQU	$
		INC	ENCHPT,X		;char. pat. no. inc.
		LDA	ENCHPT,X		;
		CMP	#00002H			;
		BNE	SLEYEMV0700		;

SLEYEMV0200	EQU	$
		DEC	<ENWRK2,X		;uJE^[DEC.

SLEYEMV0700	EQU	$
		LDA	#00004H			;Lp^[`FW^C}[Zbg
		STA	ENTIM0,X		;
		BRA	SLEYEMV0900

SLEYEMV0800	EQU	$
		LDA	<RANDM0			;u ?
		BIT	#0001FH			;
		BNE	SLEYEMV0900		;  no: SLEYEMV0900

		LDA	#00004H			;uJE^[Zbg
		STA	<ENWRK2,X		;

SLEYEMV0900	EQU	$
		INC	<ENCONT,X

		RTL
;
;		EWORK0	ANGLE
;		EWORK2	X POS
;		EWORK4	Y POS
;		EWORK6	EPWIDX
;		EWORK8	EPWIDY
;		EWORKA
;		EWORKC
;		EWORKE	EYES POS.
;
EYE_SEARCH	EQU	$
		LDA	<ENWRK4,X	;eyes pos. set
		STA	<EWORKE		;

		LDA	EPWIDX,X		;]pvZ
		STA	R1			;
		LDA	EPWIDY,X		;
		STA	R2			;
						;
		M_CHIP	M_RAD_GET		;
						;
		I16
		LDA	R1
		JSR	SEYE_POS

		M8

		LDA	<EWORKE		;X HOSEI PLAS ?
		CMP	<EWORK2		;X HOSEI : X MOKUHYOU ?
		BEQ	SLIME_EYE0700	; yes: SLIME_EYE0700

		LDA	<EWORKE		;X HOSEI PLAS ?
		BMI	SLIME_EYE0650	; no:  SLIME_EYE0650

		LDA	<EWORK2		;X MOKUHYOU PLAS
		BMI	SLIME_EYE0680	; no:  SLIME_EYE0680
		CMP	<EWORKE
		BCC	SLIME_EYE0680

SLIME_EYE0600	EQU	$
		INC	<EWORKE		;x_pos inc.
		BRA	SLIME_EYE0700

SLIME_EYE0650	EQU	$
		LDA	<EWORK2
		BPL	SLIME_EYE0600
		CMP	<EWORKE
		BCS	SLIME_EYE0600

SLIME_EYE0680	EQU	$
		DEC	<EWORKE		;x_pos dec.

SLIME_EYE0700	EQU	$
		LDA	<EWORKF		;Y HOSEI PLAS ?
		CMP	<EWORK4		;Y HOSEI : Y MOKUHYOU ?
		BEQ	SLIME_EYE0800	; yes: SLIME_EYE0800

		LDA	<EWORKF		;Y HOSEI PLAS ?
		BMI	SLIME_EYE0750	; no:  SLIME_EYE0750

		LDA	<EWORK4		;Y MOKUHYOU PLAS
		BMI	SLIME_EYE0780	; no:  SLIME_EYE0780
		CMP	<EWORKF
		BCC	SLIME_EYE0780

SLIME_EYE0710	EQU	$
		INC	<EWORKF		;y_pos inc.
		BRA	SLIME_EYE0800

SLIME_EYE0750	EQU	$
		LDA	<EWORK4
		BEQ	SLIME_EYE0800	; yes: SLIME_EYE0800
		BPL	SLIME_EYE0710
		CMP	<EWORKF
		BCS	SLIME_EYE0710

SLIME_EYE0780	EQU	$
		DEC	<EWORKF		;y_pos dec.

SLIME_EYE0800	EQU	$
		M16
		LDA	<EWORKE		;eyes pos. set
		STA	<ENWRK4,X	;

		RTS
;
SEYE_POS	EQU	$
		I16
		ASL	A
		TAX
		PHX

		LDA	>COS,X
		M8			;SET_DATA GET & SET
		STA	211BH		;
		XBA			;
		STA	211BH		;
		LDA	#010H		; hankei
		STA	211CH		;

		LDA	2135H
		STA	<EWORK2
		BPL	SEYE_POS0050

		LDA	#0FFH
		BRA	SEYE_POS0080

SEYE_POS0050	EQU	$
		LDA	#000H

SEYE_POS0080	EQU	$
		STA	<EWORK3		;x pos. set

		M16

		PLX
		LDA	>SIN,X
		M8			;SET_DATA GET & SET
		STA	211BH		;
		XBA			;
		STA	211BH		;
		LDA	#010H		; hankei
		STA	211CH		;

		LDA	2135H
		STA	<EWORK4
		BPL	SEYE_POS0200

		LDA	#0FFH
		BRA	SEYE_POS0300

SEYE_POS0200	EQU	$
		LDA	#000H

SEYE_POS0300	EQU	$
		STA	<EWORK5		;y pos. set

		M16

		I8
		LDX	<ENINDX

		RTS
;
;************************************************************************
;*		initial ( тՂ )					*
;************************************************************************
SSLIMIN		EQU	$		;-- sslimin --
		LDY	#SSLIM_RMODE5
		STY	<ENWRK2,X

		RTL
;
;************************************************************************
;*		move	( тՂ )					*
;************************************************************************
;		ENWRK0	DvC[`FbNbNtO
;		ENWRK2	ROUTINE MODE INDEX
;		ENWRK4
;		ENWRK6
;		ENWRK8
;		ENWRKA	ăZbg`FbN
;		ENWRKC	ăZbg`FbN
;
;		ENTIM0	Xgbv^C}[
;		ENTIM1	Lp^[`FW^C}[
;		ENTIM2	IuWF`FbNbN^C}[
;
SSLIM_SUB	EQU	$
SSLIM_0		EQU	$
		WORD	SSLIM_SUB0		;ׂ炾炟`
SSLIM_1		EQU	$
		WORD	SSLIM_SUB1		;nPODOO
SSLIM_2		EQU	$
		WORD	SSLIM_SUB2		;EH[N
SSLIM_3		EQU	$
		WORD	SSLIM_SUB3		;Ԃ
SSLIM_4		EQU	$
		WORD	SSLIM_SUB4		;e
SSLIM_5		EQU	$
		WORD	SSLIM_SUB5		;CjV
SSLIM_60	EQU	$
		WORD	SSLIM_SUB60		;тՂ̃CjVfiׂ炾炟`j
SSLIM_61	EQU	$
		WORD	SSLIM_SUB61		;тՂ̃CjVfinPODOOj
SSLIM_62	EQU	$
		WORD	SSLIM_SUB62		;тՂ̃CjVfiJbN҂Wvj
SSLIM_63	EQU	$
		WORD	SSLIM_SUB63		;тՂ̃CjVfiV`FbNnj
SSLIM_64	EQU	$
		WORD	SSLIM_SUB64		;тՂ̃CjVfi҂j
;
;ys_chip3  PONTA_BOMB ɒӁII
;
SSLIM_RMODE0	EQU	(SSLIM_0-SSLIM_0)/2
SSLIM_RMODE1	EQU	(SSLIM_1-SSLIM_0)/2
SSLIM_RMODE2	EQU	(SSLIM_2-SSLIM_0)/2
SSLIM_RMODE3	EQU	(SSLIM_3-SSLIM_0)/2
SSLIM_RMODE4	EQU	(SSLIM_4-SSLIM_0)/2
SSLIM_RMODE5	EQU	(SSLIM_5-SSLIM_0)/2
SSLIM_RMODE60	EQU	(SSLIM_60-SSLIM_0)/2
SSLIM_RMODE61	EQU	(SSLIM_61-SSLIM_0)/2
SSLIM_RMODE62	EQU	(SSLIM_62-SSLIM_0)/2
SSLIM_RMODE63	EQU	(SSLIM_63-SSLIM_0)/2
SSLIM_RMODE64	EQU	(SSLIM_64-SSLIM_0)/2
;
SSLIMMV		EQU	$			;-- sslimmv --
		LDA	ENMODE,X
		CMP	#EMOVE
		BEQ	SSLIMMV0300

SSLIMMV0100	EQU	$
		LDA	PLMODE
		CMP	#PDEM
		BNE	SSLIMMV0500

		CMP	<ENWRK4,X
		BNE	SSLIMMV0500

		LDA	#PMOV
		STA	PLMODE
		BRA	SSLIMMV0500

SSLIMMV0300	EQU	$
		LDA	ENCOLD,X		;Ă ?
		BEQ	SSLIMMV0400		;  no: SSLIMMV0400

		STZ	ENMOD1,X		;af`FbNȂ
		BRA	SSLIMMV0100

SSLIMMV0400	EQU	$
		LDY	ENSHOT,X
		BEQ	SSLIMMV0500

		LDA	#00002
		STA	ENYUSN,X
		STZ	ENCHPT,X
		LDA	#0FFFFH
		STA	ENWRKA,X
		STA	ENWRKC,X

SSLIMMV0500	EQU	$
		JSL	>ENMDCK			;mode check

		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SSLIM_SUB,X)

		JSR	SSLIM_PLCHK

		LDA	ENTIM2,X		;IuWF`FbNbN ?
		BNE	SSLIMMV0800		; yes: SSLIMMV0800

		LDA	ENMOD0,X		;Փ˃`FbNL
		ORA	#0000011000000000B	;
		STA	ENMOD0,X		;

SSLIMMV0800	EQU	$

		JMP	>SHOT_EN_KILL_SP
;
SSLIM_PLCHK	EQU	$
		LDA	<ENWRK0,X		;IuWF`FbNbN ?
		BNE	SSLIM_PLCHK0090		; yes: SSLIM_PLCHK0090

		LDY	ECRSFG,X		;vC[ɂ ?
		BPL	SSLIM_PLCHK0300		;  no: SSLIM_PLCHK0300

		LDY	<ENWRK2,X		;ׂĂ ?
		CPY	#SSLIM_RMODE3		;
		BEQ	SSLIM_PLCHK0500		; yes: SSLIM_PLCHK0500
		CPY	#SSLIM_RMODE4		;
		BEQ	SSLIM_PLCHK0500		;

		LDA	EPWIDY,X		;vC[炠 ?
		SEC				;
		SBC	PWIDEY			;
		SEC				;
		SBC	EWIDEY,X		;
		CMP	#0FFF8H			;
		BCS	SSLIM_PLCHK0100		;  no: SSLIM_PLCHK0100

SSLIM_PLCHK0080 EQU	$
		JSL	>PLFLST

SSLIM_PLCHK0090 EQU	$
		RTS

SSLIM_PLCHK0100 EQU	$
		LDY	PLYSPD+1		;vC[㏸ ?
		BMI	SSLIM_PLCHK0500		; yes: SSLIM_PLCHK0500

		LDY	PLJUMP			;vC[Wv ?
		BEQ	SSLIM_PLCHK0080		;  no: SSLIM_PLCHK0080

		LDA	ENCBFG,X		;nʂɒĂ ?
		AND	#00001			;
		BEQ	SSLIM_PLCHK0500		;  no: SSLIM_PLCHK0500

		LDA	#00020H
		CMP	PLFLSH
		BMI	SSLIM_PLCHK0200

		STA	PLFLSH

SSLIM_PLCHK0200 EQU	$
		LDA	P_KEY_MNAG
		AND	KEYC1L
		STA	P_KEYC1L
		LDA	KEYC2L
		AND	P_KEY_MNAG
		STA	P_KEYC2L

		STZ	PLDOSN
		LDA	#PDEM
		STA	PLMODE
		STA	<ENWRK4,X

		LDA	#0111110001100000B	;HȂAGȂ
		STA	ENMOD0,X		;

		STZ	PLXSPD
		STZ	PLMVSP
		STZ	PLYSPD
		STZ	<ENCONT,X
		STZ	ENXSPD,X
		LDA	#00004
		STA	ENTIM1,X
		STA	ENCHPT,X

		LDY	#SSLIM_RMODE3
		STY	<ENWRK2,X

		RTS

SSLIM_PLCHK0300 EQU	$
		JSL	>EPCRCK

SSLIM_PLCHK0500 EQU	$

		RTS
;
SSLIM_S0_CHPT	EQU	$-1
		HEX	08,09,00,01
SSLIM_S0_TIM1	EQU	$-1
		HEX	10,06,05,04
;
SSLIM_SUB0	EQU	$
SSLIM_SUB60	EQU	$
		TYX

		LDA	ENTIM1,X
		BNE	SSLIM_SUB0800

		INC	<ENCONT,X
		LDY	<ENCONT,X
		CPY	#005
		BNE	SSLIM_SUB0500

		LDA	#00040H
		STA	ENGPOW,X
		STZ	<ENCONT,X
		STZ	ENCHPT,X
		INC	<ENWRK2,X

		RTS

SSLIM_SUB0500	EQU	$
		LDA	!SSLIM_S0_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S0_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X

SSLIM_SUB0800	EQU	$

		RTS
;
SSLIM_S1_CHPT	EQU	$-1
		HEX	01,04,05,06,01,00,02,00,01
SSLIM_S1_TIM1	EQU	$-1
		HEX	02,02,02,02,02,02,04,02,30
;
SSLIM_SUB1	EQU	$
SSLIM_SUB61	EQU	$
		TYX

		LDA	ENCBFG,X		;nʂɒ ?
		AND	#00001			;
		BEQ	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	ENTIM1,X		;Lp^[`FW ?
		BNE	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		INC	<ENCONT,X
		LDY	<ENCONT,X
		LDA	!SSLIM_S1_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S1_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X
		CPY	#002
		BNE	SSLIM_SUB1500

		LDA	#00060H			;mrn
		JSL	>SOUND_3_ON
		RTS

SSLIM_SUB1500	EQU	$
		CPY	#009			;np^[I ?
		BMI	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	ENTIM1,X
		STA	ENTIM0,X
		LDY	EPXMUK,X
		TYA
		STA	ENMUKI,X

		INC	<ENWRK2,X

		LDY	<ENWRK2,X		;тՂ̃f ?
		CPY	#SSLIM_RMODE61+1	;
		BNE	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	#00007H
		STA	<ENCONT,X
		INC	BOSS_START

SSLIM_SUB1800	EQU	$

		RTS
;
SSLIM_XSPD	EQU	$
		WORD	0FFC0H,00040H
;
SSLIM_SUB2	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SSLIM_SUB2800		; yes: SSLIM_SUB2800

		STZ	<ENWRK0,X		;DvC[`FbNbNtONA

		LDA	ENCBFG,X		;nʂɒ ?
		AND	#00001			;
		BEQ	SSLIM_SUB2800		;  no: SSLIM_SUB2800

		LDY	ENMUKI,X
		LDA	!SSLIM_XSPD,Y
		STA	ENXSPD,X

		LDA	ENTIM1,X
		BNE	SSLIM_SUB2800

		LDA	#00004H
		STA	ENTIM1,X

		LDA	ENCHPT,X
		INC	A
		AND	#00003
		STA	ENCHPT,X

SSLIM_SUB2800	EQU	$

		RTS
;
SSLIM_PLYREV	EQU	$
;ENCHPT =		 [4]	[5]    [6]
		WORD	0001AH,00018H,00014H
;
SSLIM_SUB3	EQU	$
		TYX

		LDA	ENTIM1,X		;Lp^[`FW ?
		BNE	SSLIM_SUB3800		;  no: SSLIM_SUB3800

		INC	<ENCONT,X
		INC	<ENCONT,X
		LDY	<ENCONT,X		;ԂI ?
		CPY	#006			;
		BMI	SSLIM_SUB3500		;  no: SSLIM_SUB3500

		LDA	#00003
		STA	ENTIM0,X

		LDA	#SSLMB
		JSL	>EXINSR
		LDA	ECENTX,X
		STA	EXXPSL,Y
		LDA	ECENTY,X
		STA	EXYPSL,Y
		LDA	#00005
		STA	EXCHPT,Y
		LDA	#00002
		STA	EXTIM0,Y
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16
		INC	<ENWRK2,X

		RTS

SSLIM_SUB3500	EQU	$
		LDA	#00004
		STA	ENTIM1,X
		INC	ENCHPT,X

SSLIM_SUB3800	EQU	$
		LDA	PLBGCR
		AND	#0000000000000111B
		BNE	SSLIM_SUB3900

		LDY	<ENCONT,X
		LDA	ENYPSL,X
		SEC
		SBC	!SSLIM_PLYREV,Y
		SEC
		SBC	PLFTLN
		STA	PLYPSL
		STZ	PLYSPD
		INC	ONLFFG

SSLIM_SUB3900	EQU	$

		RTS
;
SSLIM_SUB4	EQU	$
		TYX

		LDA	ENTIM0,X
		BNE	SSLIM_SUB4100

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	#PMOV
		STA	PLMODE
		STZ	P_KEYC1L
		STZ	P_KEYC2L

		PLA
		JMP	>ENCLEAR_NORETN

SSLIM_SUB4100	EQU	$
		LDA	ECENTX,X
		STA	R1
		LDA	ECENTY,X
		STA	R2
		LDA	#00040H			;a
		STA	R10			;
		LDA	#00200H			;XSPD
		STA	CCWORK0
		LDA	#0FE00H			;YSPD
		STA	CCWORK1

		M_CHIP	PONTA_BOMB

		LDX	<ENINDX

		RTS
;
SSLIM_SUB5	EQU	$
		TYX

		LDA	ENWRKA,X
		CMP	ENWRKC,X
		BNE	SSLIM_SUB5100

		INC	A
		BNE	SSLIM_SUB5100

		INC	A		;[ LDA	#00001 ]
		STA	ENCHPT,X
		INC	A		;[ LDA	#00002 ]
		STA	ENYUSN,X
		STA	<ENWRK2,X
		LDA	#00030H
		STA	ENTIM0,X
		LDY	EPXMUK,X
		TYA
		STA	ENMUKI,X
		RTS

SSLIM_SUB5100	EQU	$
		LDA	EPWIDX,X
		CLC
		ADC	#00030H
		CMP	#00060H
		BCS	SSLIM_SUB5800

;		LDA	ENYPSL,X		;oJnʒu
;		CLC				;
;		ADC	#00010H			;
;		STA	ENYPSL,X		;

		LDA	#0FFFFH
		STA	ENWRKA,X
		STA	ENWRKC,X

		LDA	#00007
		STA	ENCHPT,X
		INC	A		[ LDA	#00008 ]
		STA	ENTIM1,X

		LDA	#00002
		STA	ENYUSN,X

		STZ	<ENWRK2,X

SSLIM_SUB5800	EQU	$

		RTS
;
SSLIM_S62_CHPT	EQU	$
		HEX	04,05,06,05,04,00,02
;
SSLIM_SUB62	EQU	$
		TYX

		LDA	BOSS_START		;JbNޏꂵ ?
		BPL	SSLIM_SUB62800		;  no: SSLIM_SUB62800

		LDA	ENTIM1,X
		BNE	SSLIM_SUB62800

		DEC	<ENCONT,X		;Wv ?
		BPL	SSLIM_SUB62300		;  no: SSLIM_SUB62300

		LDA	#00002
		STA	ENCHPT,X
		STA	<ENCONT,X
		LDA	#0FA00H
		STA	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENCBFG,X
		INC	<ENWRK2,X
		LDA	#00013H			;mrn
		JSL	>SOUND_3_ON

		RTS

SSLIM_SUB62300	EQU	$
		LDY	<ENCONT,X
		LDA	!SSLIM_S62_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	#00002H
		STA	ENTIM1,X

SSLIM_SUB62800	EQU	$

		RTS
;
SSLIM_S63_CHPT	EQU	$
		HEX	07,08
SSLIM_S63_TIM1	EQU	$
		HEX	08,10
;
SSLIM_SUB63	EQU	$
		TYX

		LDA	ENYSPD,X
		BEQ	SSLIM_SUB63300

		LDA	ENCBFG,X		; ?
		AND	#00002			;
		BEQ	SSLIM_SUB63800		;  no: SSLIM_SUB63800

		LDA	ENYPSL,X
		CLC
		ADC	#00008H
		AND	#0FFF0H
		STA	ENYPSL,X
		STZ	ENYSPD,X
		RTS

SSLIM_SUB63300	EQU	$
		LDA	ENTIM1,X
		BNE	SSLIM_SUB63800

		DEC	<ENCONT,X
		BPL	SSLIM_SUB63500

		LDA	#00020H
		STA	ENTIM0,X
		LDA	#000FFH
		STA	ENYUSN,X
		INC	<ENWRK2,X
		RTS

SSLIM_SUB63500	EQU	$
		LDY	<ENCONT,X
		LDA	!SSLIM_S63_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S63_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X

SSLIM_SUB63800	EQU	$

		RTS
;
SSLIM_SUB64	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SSLIM_SUB64800		; yes: SSLIM_SUB64800

		STZ	BOSS_START
		INC	BOSS0FLG
		JSL	>ENCLEAR

SSLIM_SUB64800	EQU	$

		RTS
;
;
;
;
;
;
