;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: system main					*
;*	file name	: ys_main					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		../sound/ys_sound.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	system_pause
;
		GLB	BLNKON,BLNKOFF,DMA_M_M,DMA_D_M,RAMCLR,URAMCLR,VRAMCL
		GLB	VRAMCL2,OAMCLR,OAMDXCLR,OAMCHG,JSRSUB,JSLSUB
		GLB	RANDAM,FADEST_SUB
		GLB	SOUND_TR,SOUND_TR_2
		GLB	SOUND_3_ON
;
		GLB	VCLDAT
;
		GLB	GMIN,GMFD,GMPL,MPIN,TMUP,DMIN,D_00,D_01,SFCSTP
		GLB	HMPIN,HMPPL,HMPDM,BNSGM,BNSMV,MINPL,MINIT
		GLB	HMPHIDM,BS_SCRE,HMPWDCRDM,INT_GM,HF_STAT,KEYSTP
		GLB	GM_OVR,AGAIN,BNSIN,HMPFAD,GM_CTN
;
		GLB	TITLE_SOUND,W1_0_SOUND,MAP_SOUND,END_SOUND
;
 IF  PAL  ;**** PAL Ή [1995/7/20] *****************************
		GLB	LNGGSL

 ENDIF	  ;**** PAL Ή [1995/7/20] *****************************

;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_save >------------------------------------------------
		EXT	SVRMCK_INT
;
;-------------< ys_rpro >------------------------------------------------
		EXT	RPRO_ROM
		EXT	NMISUB,IRQSUB,CHIPON
		EXT	VMADSPL,OBJDMA
;
		EXT	VTCL
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
		EXT	TLINIT,TLPLAY,KEYINCHK
		EXT	SFC_STOP,KEYCHK_DSP
;
;-------------< ys_mini >-------------------------------------------------
		EXT	MINIPLAY,MINIINIT
;
;-------------< ys_map >-------------------------------------------------
		EXT	MAPINIT,MAPPLAY
;
;-------------< ys_game >------------------------------------------------
		EXT	GMINIT,GMPLAY,GMFADE,GMGOAL
		EXT	BOSCLR_SCORE,HALF_INIT,HALF_SLCT
		EXT	COS_AGAIN_INT,CORS_AGAIN,AGAIN_WAIT_SET
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	GMBGIN,TIMEUP
;
;-------------< ys_demo >------------------------------------------------
		EXT	DEMO_00_IN,DEMO_00_MV
		EXT	DEMO_01_IN,DEMO_01_MV
;
;-------------< ys_demo >------------------------------------------------
		EXT	BONUSIT,BONUSMV
;
;-------------< ys_start >-----------------------------------------------
		EXT	START_INIT,START_PLAY
;
 IF  PAL  ;**** PAL Ή [1995/7/20] *****************************
;
;-------------< ys_lngsl >-----------------------------------------------
		EXT	LNG_SLCT_INT,LNG_SELECT
 ENDIF	  ;**** PAL Ή [1995/7/20] *****************************
;
;
;-------------< ys_ending >----------------------------------------------
		EXT	ENDING_MAP_IN
		EXT	ENDING1_IN,ENDING1_PL,ENDING_START
		EXT	GAME_OVER_INT,GAME_OVER
;
;-------------< ys_hmap >------------------------------------------------
		EXT	HMAPINIT,HMAPPLAY,HMAPDEMO
		EXT	HMAPHIDEMO,HMPWLDCLRDEMO
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		t							*
;*									*
;************************************************************************
;
		ORG	0FFA0H
;
		include ys_date.inc
;
;
;************************************************************************
;*									*
;*		interrupt vector					*
;*									*
;************************************************************************
;
		ORG	0FFE0H
;
;------------------------------------------------------------------------
;-		NATIVE							-
;------------------------------------------------------------------------
		WORD	RTISUB
		WORD	RTISUB
		WORD	COPSUB		;COP
		WORD	RTISUB
		WORD	RTISUB
		WORD	00108H		;NMI
		WORD	RTISUB
		WORD	0010CH		;IRQ
;
;------------------------------------------------------------------------
;-		EMULATION						-
;------------------------------------------------------------------------
		WORD	RTISUB
		WORD	RTISUB
		WORD	RTISUB
		WORD	RTISUB
		WORD	RTISUB
		WORD	RTISUB
		WORD	RESET		;reset
		WORD	RTISUB
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_0		GROUP	Main_pro
Main_pro	SECT	REL
;
;************************************************************************
;*		reset							*
;************************************************************************
;
RESET		EQU	$
		SEI			;IRQ disable
		REP	#00001001B
		XCE
;
		MI8
;
		LDA	#00		;(DBR) <-- 0
		PHA
		PLB
		PHA			;(D) <-- 0
		PHA
		PLD
;
;-------------- PPU Reg initial clear -----------------------------------
		STZ	4200H		;NMI disable
		STZ	4016H
		LDA	#10001111B	;blanking "ON"
		STA	2100H
;
		LDA	#00000001B	;B-RAM enable
		STA	3033H
		STZ	2106H		;mozaiku flag reset
		STZ	2140H		;sound port reset
		STZ	2141H		;	"
		STZ	2142H		;	"
		STZ	2143H		;	"
;
		LDA	#0FFH		;I/O port reset
		STA	4201H
		STZ	4207H		;H counter reset
		STZ	4208H
		STZ	4209H		;V	"
		STZ	420AH
		STZ	420BH		;M-DMA switch reset
		STZ	420CH		;H-	  "
		STZ	420DH		;memory access cycle reset (2.68MHz)
;
		M16
;
		LDA	#8000H		;OAM rotation reset
		STA	2102H
;
;-------------- stack pointer set ---------------------------------------
		LDA	#01FFH		;(SP) set
		TCS
;
		M8
		JSL	>RAMCLR		;all RAM clear !!
;
;
;-------------- TEhvO]iCj ------------------------
;
		LDX	#TITLE_SOUND	;(X) <-- TEhvO]e[umD
		JSL	>SOUND_TR_2
;
		M16
;
;
;-------------- RAM vecter set ------------------------------------------
		LDX	#(RMVCTTBLE-RMVCTTBL)-1
RESET010	EQU	$
		LDA	!RMVCTTBL,X
		STA	RAMVCT,X
		DEX
		DEX
		BPL	RESET010
;
;-------------- RAM program set -----------------------------------------
		LDA	#RPRO_RAM	;to memory address set
		STA	<WORK20
		LDY	#BANK RPRO_RAM
		STY	<WORK22
		LDA	#RPRO_ROM	;from memory address set
		STA	<WORK23
		LDY	#BANK RPRO_ROM
		STY	<WORK25
		LDA	#4000H		;(A) <-- number of byte set
		JSL	>DMA_M_M	;DMA "ON"
;
		M8
		I16
;
;-------------- system RAM initial clear --------------------------------
		LDX	#STACK-SYSRAM-1
RESET020	EQU	$
		STZ	SYSRAM,X
		DEX
		BPL	RESET020
;
		I8
;
;-------------- }I`bvZbg ----------------------------------
		LDA	#00000001B	;M-chip 21MHz mode set
		STA	3039H
		LDA	#10100000B	;M-chip config set ( IRQ disable , mult speed up )
		STA	3037H
		LDA	#016H		;M-chip screen base initial set
		STA	CIPSCB
		LDA	#00111101B	;	"      size mode set
		STA	CIPSCR
;
 IF BUG00  ;******************************************************[1995/8/8]
		M16			; memory 16bit mode
		STZ	!TITL_SND
		STZ	!WLD6_FLG
;
		LDX	#BANK CHIPINIT
		LDA	#CHIPINIT
		JSL	>CHIPON
;
		M8			; memory 8bit mode
 ELSE	   ;******************************************************[1995/8/8]
 ENDIF	   ;******************************************************[1995/8/8]
;
		LDA	>SLCT_FILE_NO+1
		BNE	SV_CLS_000
		LDA	>SLCT_FILE_NO
		CMP	#003
		BCC	SV_CLS_900
SV_CLS_000	EQU	$
		M16			; memory 16bit mode
		LDA	#000
		STA	>SLCT_FILE_NO
		STA	>RAMCHK0
		STA	>RAMCHK1
		STA	>RAMCHK2
		STA	>RAMCHK0_BAK
		STA	>RAMCHK1_BAK
		STA	>RAMCHK2_BAK
		JSL	>SVRMCK_INT
		M8			; memory 8bit mode
SV_CLS_900	EQU	$
;
 IF BUG00  ;******************************************************[1995/8/8]
 ELSE	   ;******************************************************[1995/8/8]
		M16			; memory 16bit mode
		STZ	!TITL_SND
		STZ	!WLD6_FLG
;
		LDX	#BANK CHIPINIT
		LDA	#CHIPINIT
		JSL	>CHIPON
;
		M8			; memory 8bit mode
 ENDIF	   ;******************************************************[1995/8/8]
;
		CLI			;IRQ enable
;
;************************************************************************
;*		game main						*
;************************************************************************
;
GSTART		EQU	$
		LDA	NMIFLG
		BMI	GSTART
;
system_pause	equ	$
		bra	GST040
;
;
;
;
;
;-------------- pause check -----------------------------
		LDA	KEYB2
		AND	#00010000B
		BEQ	GST010
		LDA	PAUSE
		EOR	#01
		STA	PAUSE
GST010		EQU	$
		LDA	PAUSE
		BEQ	GST040
;
		LDY	#20H
		LDA	KEYB2L
		AND	#00010000B
		BNE	GST032
;
		LDA	KEYB1L
		AND	#00110000B
		BNE	GST020
;
		STZ	PASTM
		BRA	GST050
;
GST020		EQU	$
		LDA	PASTM
		BEQ	GST030
		DEC	PASTM
		BRA	GST050
;
GST030		EQU	$
		LDY	#04H
GST032		EQU	$
		STY	PASTM
;
;--------------------------------------------------------
;
;
;
;
;
GST040		EQU	$
;
		M16
;
		INC	<FRCNT		;frame counter set
;
		M8
;
		JSL	>MODESEL	;game mode select
;
GST050		EQU	$
		DEC	NMIFLG
		BRA	GSTART
;
;
;************************************************************************
;		RAM vecter data						*
;************************************************************************
RMVCTTBL	EQU	$
		RTI			;[100]
		NOP
		NOP
		NOP
;
		RTI			;[104] COP
		NOP
		NOP
		NOP
;
		JMP	>NMISUB		;[108] NMI
;
		JMP	>IRQSUB		;[10C] IRQ
;
RMVCTTBLE	EQU	$
;
;************************************************************************
;		cop							*
;************************************************************************
COPSUB		EQU	$
;;;;		JMP	>CHIPCALL
;
;************************************************************************
;		interrapt return					*
;************************************************************************
RTISUB		EQU	$
		RTI
;
;
;
;************************************************************************
;		game mode select					*
;************************************************************************
;
MODESEL		EQU	$
		LDA	MODENO
		ASL	A
;;;;		CLC
		ADC	MODENO
		TAX
		PHB			;(DBR) save
		LDA	!MODETBL+2,X
		PHA
		PHA
		PLB			;(DBR) <-- (PBR)
		LDA	>MODETBL+1,X
		PHA
		LDA	>MODETBL,X
		PHA
		RTL
;
 IF  PAL  ;**** PAL Ή [1995/7/20] *****************************
;
;-------------- game mode program address table -----------------
MODETBL		EQU	$
TTLIN		LWORD	TLINIT-1	;title initial
		LWORD	KEYINCHK-1	;L[`FbN
		LWORD	FADEST2-1	;fade "in/out" ( timer type ) set
		LWORD	TLPLAY-1	;title play
LNGG_SLCT	LWORD	FADEST-1	;fade "in/out" set
		LWORD	LNG_SLCT_INT-1	;ZNgZbg
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	LNG_SELECT-1	;ZNg
DM_01		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_01_IN-1	;~[WJZbg
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_01_MV-1	;~[WJf
MPINT		LWORD	FADEST2-1	;fade "in/out" set
		LWORD	MAPINIT-1	;map test initial
		LWORD	MAPPLAY-1	;    "    play
GMINT		LWORD	FADEST-1	;fade "in/out" set
		LWORD	GMINIT-1	;game initial
GMFAD		LWORD	GMFADE-1	;  "  fade "in/out" set
GM_CATEN	LWORD	GMBGIN-1	;  "  initial course BG write
GMPLY		LWORD	GMPLAY-1	;  "  play
		LWORD	GMGOAL-1	;  "  goal in
TIMUP		LWORD	TIMEUP-1	;^CAbvf
;
DM_00		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_00_IN-1	;_fZbg
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_00_MV-1	;_f
;
DEMIN		LWORD	FADEST3-1	;GfBO
		LWORD	ENDING_MAP_IN-1
		LWORD	MAPINIT-1
		LWORD	MAPPLAY-1
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	ENDING1_IN-1
		LWORD	ENDING_START-1
		LWORD	ENDING1_PL-1
;
HMAP_FADE	LWORD	HMAPFADE-1
HMPINT		LWORD	FADEST2-1
HMAP_SB		LWORD	HMAPINIT-1	;XN[ }bv
HMPPLY		LWORD	FADEST-1
		LWORD	HMAPPLAY-1
HMPDEM		LWORD	FADEST-1
		LWORD	HMAPDEMO-1
HMPHIDEM	LWORD	FADEST-1
		LWORD	HMAPHIDEMO-1
HMPWDCRDEM	LWORD	FADEST-1
		LWORD	HMPWLDCLRDEMO-1
;
BONUSGM		LWORD	FADEST2-1	;{[iX Q[
BONUSIN		LWORD	BONUSIT-1
		LWORD	FADEST-1
BONUS_MD	LWORD	BONUSMV-1
;
MININT		LWORD	FADEST-1	;~j Q[
		LWORD	MINIINIT-1
MINIPL		LWORD	FADEST-1
		LWORD	MINIPLAY-1
;
BSCR_SCRE	LWORD	BOSCLR_SCORE-1	;{XNÃXRAZ
;
HALF_STAT	LWORD	FADEST-1	; ԃQ[g ăX^[gZNg
		LWORD	HALF_INIT-1
		LWORD	FADEST-1
		LWORD	HALF_SLCT-1
		LWORD	AGAIN_WAIT_SET-1
;
INT_GAME	LWORD	FADEST2-1	; CjV R[XC f
		LWORD	START_INIT-1
		LWORD	START_PLAY-1
;
AGAIN_STAT	LWORD	FADEST-1	; ̃R[X ăX^[gZNg
		LWORD	COS_AGAIN_INT-1
		LWORD	FADEST-1
		LWORD	CORS_AGAIN-1
		LWORD	AGAIN_WAIT_SET-1
;
GM_OVER		LWORD	GAME_OVER_INT-1 ; f`ld nudq
		LWORD	GAME_OVER-1
;
KEYSTOP		LWORD	FADEST-1
		LWORD	KEYCHK_DSP-1	;L[`FbNɂQ[ Xgbv
;
SFCSTOP		LWORD	FADEST-1
		LWORD	SFC_STOP-1	;Q[ Xgbv !!
;
;
;
TLIN		EQU	(TTLIN-MODETBL)/3
LNGGSL		EQU	(LNGG_SLCT-MODETBL)/3
MPIN		EQU	(MPINT-MODETBL)/3
GMIN		EQU	(GMINT-MODETBL)/3
GMFD		EQU	(GMFAD-MODETBL)/3
GM_CTN		EQU	(GM_CATEN-MODETBL)/3
GMPL		EQU	(GMPLY-MODETBL)/3
TMUP		EQU	(TIMUP-MODETBL)/3
;
D_00		EQU	(DM_00-MODETBL)/3
D_01		EQU	(DM_01-MODETBL)/3
;
DMIN		EQU	(DEMIN-MODETBL)/3
;
HMPFAD		EQU	(HMAP_FADE-MODETBL)/3
HMPIN		EQU	(HMPINT-MODETBL)/3
HMPSB		EQU	(HMAP_SB-MODETBL)/3
HMPPL		EQU	(HMPPLY-MODETBL)/3
HMPDM		EQU	(HMPDEM-MODETBL)/3
HMPHIDM		EQU	(HMPHIDEM-MODETBL)/3
HMPWDCRDM	EQU	(HMPWDCRDEM-MODETBL)/3
;
BNSGM		EQU	(BONUSGM-MODETBL)/3
BNSIN		EQU	(BONUSIN-MODETBL)/3
BNSMV		EQU	(BONUS_MD-MODETBL)/3
;
MINIT		EQU	(MININT-MODETBL)/3
MINPL		EQU	(MINIPL-MODETBL)/3
;
BS_SCRE		EQU	(BSCR_SCRE-MODETBL)/3
;
HF_STAT		EQU	(HALF_STAT-MODETBL)/3
;
INT_GM		EQU	(INT_GAME-MODETBL)/3
GM_OVR		EQU	(GM_OVER-MODETBL)/3
AGAIN		EQU	(AGAIN_STAT-MODETBL)/3
;
KEYSTP		EQU	(KEYSTOP-MODETBL)/3
SFCSTP		EQU	(SFCSTOP-MODETBL)/3
 ENDIF	  ;**** PAL Ή [1995/7/20] *****************************

;
;
 IF  JPN | NES ;**** { or NES Ή [1995/6/30] ****************
;
;-------------- game mode program address table -----------------
MODETBL		EQU	$
TTLIN		LWORD	TLINIT-1	;title initial
		LWORD	KEYINCHK-1	;L[`FbN
		LWORD	FADEST2-1	;fade "in/out" ( timer type ) set
		LWORD	TLPLAY-1	;title play
DM_01		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_01_IN-1	;~[WJZbg
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_01_MV-1	;~[WJf
MPINT		LWORD	FADEST2-1	;fade "in/out" set
		LWORD	MAPINIT-1	;map test initial
		LWORD	MAPPLAY-1	;    "    play
GMINT		LWORD	FADEST-1	;fade "in/out" set
		LWORD	GMINIT-1	;game initial
GMFAD		LWORD	GMFADE-1	;  "  fade "in/out" set
GM_CATEN	LWORD	GMBGIN-1	;  "  initial course BG write
GMPLY		LWORD	GMPLAY-1	;  "  play
		LWORD	GMGOAL-1	;  "  goal in
TIMUP		LWORD	TIMEUP-1	;^CAbvf
;
DM_00		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_00_IN-1	;_fZbg
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	DEMO_00_MV-1	;_f
;
DEMIN		LWORD	FADEST3-1	;GfBO
		LWORD	ENDING_MAP_IN-1
		LWORD	MAPINIT-1
		LWORD	MAPPLAY-1
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	ENDING1_IN-1
		LWORD	ENDING_START-1
		LWORD	ENDING1_PL-1
;
HMAP_FADE	LWORD	HMAPFADE-1
HMPINT		LWORD	FADEST2-1
HMAP_SB		LWORD	HMAPINIT-1	;XN[ }bv
HMPPLY		LWORD	FADEST-1
		LWORD	HMAPPLAY-1
HMPDEM		LWORD	FADEST-1
		LWORD	HMAPDEMO-1
HMPHIDEM	LWORD	FADEST-1
		LWORD	HMAPHIDEMO-1
HMPWDCRDEM	LWORD	FADEST-1
		LWORD	HMPWLDCLRDEMO-1
;
BONUSGM		LWORD	FADEST2-1	;{[iX Q[
BONUSIN		LWORD	BONUSIT-1
		LWORD	FADEST-1
BONUS_MD	LWORD	BONUSMV-1
;
MININT		LWORD	FADEST-1	;~j Q[
		LWORD	MINIINIT-1
MINIPL		LWORD	FADEST-1
		LWORD	MINIPLAY-1
;
BSCR_SCRE	LWORD	BOSCLR_SCORE-1	;{XNÃXRAZ
;
HALF_STAT	LWORD	FADEST-1	; ԃQ[g ăX^[gZNg
		LWORD	HALF_INIT-1
		LWORD	FADEST-1
		LWORD	HALF_SLCT-1
		LWORD	AGAIN_WAIT_SET-1
;
INT_GAME	LWORD	FADEST2-1	; CjV R[XC f
		LWORD	START_INIT-1
		LWORD	START_PLAY-1
;
AGAIN_STAT	LWORD	FADEST-1	; ̃R[X ăX^[gZNg
		LWORD	COS_AGAIN_INT-1
		LWORD	FADEST-1
		LWORD	CORS_AGAIN-1
		LWORD	AGAIN_WAIT_SET-1
;
GM_OVER		LWORD	GAME_OVER_INT-1 ; f`ld nudq
		LWORD	GAME_OVER-1
;
KEYSTOP		LWORD	FADEST-1
		LWORD	KEYCHK_DSP-1	;L[`FbNɂQ[ Xgbv
;
SFCSTOP		LWORD	FADEST-1
		LWORD	SFC_STOP-1	;Q[ Xgbv !!
;
;
;
TLIN		EQU	(TTLIN-MODETBL)/3
MPIN		EQU	(MPINT-MODETBL)/3
GMIN		EQU	(GMINT-MODETBL)/3
GMFD		EQU	(GMFAD-MODETBL)/3
GM_CTN		EQU	(GM_CATEN-MODETBL)/3
GMPL		EQU	(GMPLY-MODETBL)/3
TMUP		EQU	(TIMUP-MODETBL)/3
;
D_00		EQU	(DM_00-MODETBL)/3
D_01		EQU	(DM_01-MODETBL)/3
;
DMIN		EQU	(DEMIN-MODETBL)/3
;
HMPFAD		EQU	(HMAP_FADE-MODETBL)/3
HMPIN		EQU	(HMPINT-MODETBL)/3
HMPSB		EQU	(HMAP_SB-MODETBL)/3
HMPPL		EQU	(HMPPLY-MODETBL)/3
HMPDM		EQU	(HMPDEM-MODETBL)/3
HMPHIDM		EQU	(HMPHIDEM-MODETBL)/3
HMPWDCRDM	EQU	(HMPWDCRDEM-MODETBL)/3
;
BNSGM		EQU	(BONUSGM-MODETBL)/3
BNSIN		EQU	(BONUSIN-MODETBL)/3
BNSMV		EQU	(BONUS_MD-MODETBL)/3
;
MINIT		EQU	(MININT-MODETBL)/3
MINPL		EQU	(MINIPL-MODETBL)/3
;
BS_SCRE		EQU	(BSCR_SCRE-MODETBL)/3
;
HF_STAT		EQU	(HALF_STAT-MODETBL)/3
;
INT_GM		EQU	(INT_GAME-MODETBL)/3
GM_OVR		EQU	(GM_OVER-MODETBL)/3
AGAIN		EQU	(AGAIN_STAT-MODETBL)/3
;
KEYSTP		EQU	(KEYSTOP-MODETBL)/3
SFCSTP		EQU	(SFCSTOP-MODETBL)/3
 ENDIF	       ;**** { or NES Ή [1995/6/30] ****************
;
;************************************************************************
;*		blanking "ON"						*
;************************************************************************
BLNKON		EQU	$
		STZ	4200H		;NMI disable
		STZ	420CH		;H-DMA "OFF"
		LDA	#10001111B	;blanking "ON"
		STA	2100H
		RTL
;
;************************************************************************
;*		blanking "OFF"						*
;************************************************************************
BLNKOFF		EQU	$
		LDA	#10000001B	;NMI enable
		STA	4200H
		RTL
;
;************************************************************************
;*		OAM clear						*
;************************************************************************
OAMCLR		EQU	$
;
		M16
;
		LDX	#BANK OAM_CLR
		LDA	#OAM_CLR
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		OAM clear ( to game mode )				*
;************************************************************************
OAMDXCLR	EQU	$
;
		M16
;
		LDX	#BANK OAM_DXCLR
		LDA	#OAM_DXCLR
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		OAM convert & change					*
;************************************************************************
OAMCHG		EQU	$
;
		M16
;
		LDX	#BANK OAMCHG2
		LDA	#OAMCHG2
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		VRAM clear						*
;*			in  : (A) <-- VRAM clear data table pointer	*
;************************************************************************
VCLDAT		EQU	$		;screen all clear data !!
		WORD	0FFFFH
;
VRAMCL		EQU	$
		LDA	#VTCL
VRAMCL2		EQU	$
		STA	VRFLG		;VRAM clear data table pointer
;
		JSL	>BLNKON
;
;-------------- OAM intial --------------------------------------
		JSL	>OAMCLR		;OAM clear
;
;-------------- VRAM clear --------------------------------------
		JMP	>VMADSPL
;
;************************************************************************
;*		memory DMA ( block transfer )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (WK23,24,25) <-- from	 "              *
;*			      (A)	   <-- number of byte		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_M_M		EQU	$
		STA	4305H		;number of byte set
;
		LDA	<WORK20		;to memory address set
		STA	2181H		;	  "
		LDY	<WORK22
		STY	2183H
;
		LDA	#00000000B+(080H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK23		;A bus address set
		STA	4302H
		LDY	<WORK25
		STY	4304H
;
		LDY	#00000001B	;DMA "ON"
		STY	420BH
		RTL
;
;************************************************************************
;*		memory DMA ( 1 byte data fill )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (A)	   <-- number of byte		*
;*			      (Y)	   <-- fill 1 byte data		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_D_M		EQU	$
		STA	4305H		;number of byte set
;
		STY	211BH
		LDX	#00
		STX	211BH
		INX			;x1
		STX	211CH
;
		LDA	#10000000B+(034H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK20		;A bus address set
		STA	4302H
		LDX	<WORK22
		STX	4304H
;
		LDX	#00000001B	;DMA "ON"
		STX	420BH
		RTL
;
		MEM8
;
;************************************************************************
;*		RAM clear						*
;************************************************************************
RAMCLR		EQU	$
		JSL	>BLNKON		;blanking "ON"
;
		M16
;
		LDY	#00			;(Y) <-- 0 clear data
;
;-------------< 000H - 0FFH >--------------------------------------------
		STZ	<WORK20			;to memory address set
		STZ	<WORK22
		LDA	#(0FFH-000H)+1		;(A) <-- number of byte
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7E0200H - 7EBFFFH >--------------------------------------
		LDA	#0200H			;to memory address set
		STA	<WORK20
		LDX	#07EH
		STX	<WORK22
		LDA	#(7EBFFFH-7E0200H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7F0000H - 7FFFFFH >--------------------------------------
		STZ	<WORK20			;to memory address set
		LDX	#07FH
		STX	<WORK22
		LDA	#(7FFFFFH-7F0000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 700000H - 707BFFH >--------------------------------------
		LDX	#070H			;to memory address set
		STX	<WORK22
		LDA	#(707BFFH-700000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< initial RAM set >----------------------------------------
		LDA	#0FFFFH		;BG write( VRAMD ) end code set
		STA	>VRAMD+2
		LDA	#VRAMDX+2	;    "   ( VRAMDX )      "
		STA	>VRAMDX
;
		M8
;
		RTL
;
;************************************************************************
;*		clear area RAM clear					*
;************************************************************************
URAMCLR		EQU	$
;
		M16
;
		LDY	#00		;(Y) <-- 0 clear data
;
;-------------- SFC ---------------------------------------------
		STZ	<WORK21		;to memory address set
		LDA	#CLRRM0_S
		STA	<WORK20
		LDA	#CLR0SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#CLRRM1_S
		STA	<WORK20
		LDA	#CLR1SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
;-------------- M-chip ------------------------------------------
		LDA	#MCLRRM0_S
		STA	<WORK20
		LDA	#MCLR0SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM1_S
		STA	<WORK20
		LDA	#MCLR1SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM2_S
		STA	<WORK20
		LDX	#BANK MCLRRM2_S
		STX	<WORK22
		LDA	#MCLR2SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		M8
;
		RTL
;
;************************************************************************
;*		call subroutine						*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSRSUB		EQU	$
		STY	<WORK+3		;(Y) save
;
		PLY
		STY	<WORK
;
		MI16
;
		AND	#00FFH
		ASL	A
		TAY
		PLA
		STA	<WORK+1
;
		INY
		LDA	[<WORK],Y
		STA	<WORK
;
		MI8
;
		LDY	<WORK+3		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		call subroutine ( long )				*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSLSUB		EQU	$
		STY	<WORK+5		;(Y) save
;
		PLY
		STY	<WORK+2
;
		MI16
;
		AND	#00FFH
		STA	<WORK+3
		ASL	A
		ADC	<WORK+3
		TAY
		PLA
		STA	<WORK+3
;
		INY
		LDA	[<WORK+2],Y
		STA	<WORK
		INY
		LDA	[<WORK+2],Y
		STA	<WORK+1
		XBA
;
		MI8
;
		PHB			;(DBR) save
;;;;		LDA	<WORK+2		;(DBR) <-- (PBR)
		PHA
		PLB
		LDY	<WORK+5		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		XN[}bvւ̍tF[h			*
;************************************************************************
HMAPFADE	EQU	$
		LDX	!FADMK
		LDA	!FADNO
		AND	#00FH
		CMP	FADCMP,X	; tF[h  ?
		BNE	FAD010		;	NO -> FAD010
		TXA			;fade muki set
		EOR	#01H
		AND	#01H
		STA	!FADMK
;
;-------------- go to next mode ---------------------------------
		LDA	#HMPSB
		STA	!MODENO
		BRA	FAD020
;
;************************************************************************
;*		fade in/out						*
;************************************************************************
FADADD		EQU	$
		HEX	01,FF
FADCMP		EQU	$
		HEX	0F,00
;
FADEST_SUB	EQU	$
		PHB
		LDA	#BANK FADEST
		PHA
		PLB
;
FADEST		EQU	$
		LDX	!FADMK
		LDA	!FADNO
		AND	#00FH
		CMP	FADCMP,X	; tF[h  ?
		BNE	FAD010		;	NO -> FAD010
		TXA			;fade muki set
		EOR	#01H
		AND	#01H
		STA	!FADMK
;
;-------------- go to next mode ---------------------------------
		INC	!MODENO
		BRA	FAD020
;
FAD010		EQU	$
		CLC
		ADC	FADADD,X
		STA	!FADNO
;
FAD020		EQU	$
		PLB
		RTL
;
;************************************************************************
;*		fade in/out ( timer type )				*
;************************************************************************
;
FADEST2		EQU	$
		DEC	FADTM
		BPL	FAD020		;wait ? ( yes:FAD010 )
;
		LDA	#02H		;wait timer set
		STA	FADTM
		BRA	FADEST
;
;************************************************************************
;*		fade in/out ( long timer type )				*
;************************************************************************
;
FADEST3		EQU	$
		DEC	FADTM
		BPL	FAD020		;wait ? ( yes:FAD010 )
;
		LDA	#08H		;wait timer set
		STA	FADTM
		BRA	FADEST
;
;************************************************************************
;*								*
;*			߂l	 i`jF				*
;************************************************************************
;
RANDAM		EQU	$
		PHP
;
		M8
;
		LDA	2137H
		LDA	213FH
;
		M16
;
		LDA	213CH
		CLC
		ADC	RANDM0
		STA	RANDM0
;
		PLP
		RTL
;
;
;
;
;
;************************************************************************
;*									*
;*		TEhvOu[g				*
;*									*
;************************************************************************
;
;-------------------------------------------------
APU_port0	EQU	02140H
APU_port1	EQU	02141H
APU_port2	EQU	02142H
APU_port3	EQU	02143H
address		EQU	00000H
address2	EQU	address+3
address3	EQU	address2+3
address4	EQU	address3+3
next_flag	EQU	address4+3
pointer		EQU	next_flag+2
;-------------------------------------------------
;
Boot_APU	EQU	$
		PHP
;
		MI16
;
		LDY	#00
		LDA	#0BBAAH
boot_initial	EQU	$
		CMP	APU_port0	;m16
		BNE	boot_initial
;
		M8
;
		LDA	#0CCH
		BRA	boot_entry1
;
boot_repeat	EQU	$
		LDA	[<address],Y
		INY
		XBA
		LDA	#00
		BRA	boot_entry2
;
boot_loop	EQU	$
		XBA
		LDA	[<address],Y
		INY
		XBA
boot_wait1	EQU	$
		CMP	APU_port0
		BNE	boot_wait1
		INC	A
boot_entry2	EQU	$
;
		M16
;
		STA	APU_port0	;m16
;
		M8
;
		DEX
		BNE	boot_loop
;
boot_wait2	EQU	$
		CMP	APU_port0
		BNE	boot_wait2
boot_zero	EQU	$
		ADC	#03
		BEQ	boot_zero
boot_entry1	EQU	$
		PHA			;>
;
		M16
;
		LDA	[<address],Y	;m16
		BNE	boot_next_ck_10
;
		DEC	next_flag
		BMI	boot_next_ck_10
;
		LDA	next_flag
		ASL	A		;
;;;;		    CLC			;x3
		ADC	next_flag	;
		TAY
		LDA	address2,Y
		STA	<address
		LDA	address2+1,Y
		STA	<address+1
		LDY	#00
		LDA	[<address],Y	;m16
boot_next_ck_10 EQU	$
		INY
		INY
		TAX
		LDA	[<address],Y	;m16
		INY
		INY
		STA	APU_port2	;m16
;
		M8
;
		CPX	#01
		LDA	#00
		ROL	A
		STA	APU_port1
		ADC	#07FH
		PLA			;<
		STA	APU_port0
boot_wait3	EQU	$
		CMP	APU_port0
		BNE	boot_wait3
		BVS	boot_repeat
;
		STZ	APU_port0	;port reset !!
		STZ	APU_port1
		STZ	APU_port2
		STZ	APU_port3
;
		PLP
		RTS
;
		MEM8
		IDX8
;
;************************************************************************
;*									*
;*		TEhvO]					*
;*									*
;************************************************************************
SOUND_TR_ADRS	EQU	$
ysat_PT		LWORD	ysat
ysathre_PT	LWORD	ysathre
ysbonus_PT	LWORD	ysbonus
ysboss_PT	LWORD	ysboss
yschika_PT	LWORD	yschika
ysgame0_PT	LWORD	ysgame0
ysgame1_PT	LWORD	ysgame1
ysgm_PT		LWORD	ysgm
yshn_PT		LWORD	yshn
ysmap_PT	LWORD	ysmap
ysoobs_PT	LWORD	ysoobs
ysor_PT		LWORD	ysor
ysse_PT		LWORD	ysse
ysshiro_PT	LWORD	ysshiro
ystitle_PT	LWORD	ystitle
yslets_PT	LWORD	yslets
yskp_PT		LWORD	yskp
yskuppa_PT	LWORD	yskuppa
ysed_PT		LWORD	ysed
ysend_PT	LWORD	ysend
;
ysat_P		EQU	ysat_PT-SOUND_TR_ADRS+1
ysathre_P	EQU	ysathre_PT-SOUND_TR_ADRS+1
ysbonus_P	EQU	ysbonus_PT-SOUND_TR_ADRS+1
ysboss_P	EQU	ysboss_PT-SOUND_TR_ADRS+1
yschika_P	EQU	yschika_PT-SOUND_TR_ADRS+1
ysgame0_P	EQU	ysgame0_PT-SOUND_TR_ADRS+1
ysgame1_P	EQU	ysgame1_PT-SOUND_TR_ADRS+1
ysgm_P		EQU	ysgm_PT-SOUND_TR_ADRS+1
yshn_P		EQU	yshn_PT-SOUND_TR_ADRS+1
ysmap_P		EQU	ysmap_PT-SOUND_TR_ADRS+1
ysoobs_P	EQU	ysoobs_PT-SOUND_TR_ADRS+1
ysor_P		EQU	ysor_PT-SOUND_TR_ADRS+1
ysse_P		EQU	ysse_PT-SOUND_TR_ADRS+1
ysshiro_P	EQU	ysshiro_PT-SOUND_TR_ADRS+1
ystitle_P	EQU	ystitle_PT-SOUND_TR_ADRS+1
yslets_P	EQU	yslets_PT-SOUND_TR_ADRS+1
yskp_P		EQU	yskp_PT-SOUND_TR_ADRS+1
yskuppa_P	EQU	yskuppa_PT-SOUND_TR_ADRS+1
ysed_P		EQU	ysed_PT-SOUND_TR_ADRS+1
ysend_P		EQU	ysend_PT-SOUND_TR_ADRS+1
;
;------------------------------------------------------------------------
;-		TEhvO]				-
;------------------------------------------------------------------------
SOUND_TR_DATA	EQU	$
; SOUND_AR_? -->	   [0]	      [1]	 [2]	    [3]
TITLE_TR_DATA	BYTE	ystitle_P, 0FFH,      0FFH,	 0FFH	    ;[^Cg]
W1_0_DM_TR_DATA BYTE	ysse_P,	   ysor_P,    yslets_P,	 0FFH	    ;[Pv|Of]
MAP_TR_DATA	BYTE	ysse_P,	   ysor_P,    ysmap_P,	 0FFH	    ;[}bv]
OHANA_TR_DATA	BYTE	ysse_P,	   yshn_P,    ysgame1_P, 0FFH	    ;[Ԕ]
CHIJYO_TR_DATA	BYTE	ysse_P,	   ysgm_P,    ysgame0_P, 0FFH	    ;[n]
CHIKA_TR_DATA	BYTE	ysse_P,	   ysgm_P,    yschika_P, 0FFH	    ;[n]
OSHIRO_TR_DATA	BYTE	ysse_P,	   ysor_P,    ysshiro_P, 0FFH	    ;[]
BOSS_TR_DATA	BYTE	ysse_P,	   ysgm_P,    ysboss_P,	 0FFH	    ;[{X]
BONUS_TR_DATA	BYTE	ysse_P,	   yshn_P,    ysbonus_P, 0FFH	    ;[{[iX]
OOBOSS_TR_DATA	BYTE	ysse_P,	   yshn_P,    ysoobs_P,	 0FFH	    ;[{X]
ATHRE_TR_DATA	BYTE	ysse_P,	   ysat_P,    ysathre_P, 0FFH	    ;[AX`bN]
KUPPA_TR_DATA	BYTE	yskp_P,	   yskuppa_P, 0FFH,	 0FFH	    ;[Nbp]
ENDING_TR_DATA	BYTE	ysed_P,	   ysend_P,   0FFH,	 0FFH	    ;[GfBO]
;
TITLE_TR	EQU	TITLE_TR_DATA-SOUND_TR_DATA
W1_0_DM_TR	EQU	W1_0_DM_TR_DATA-SOUND_TR_DATA
MAP_TR		EQU	MAP_TR_DATA-SOUND_TR_DATA
OHANA_TR	EQU	OHANA_TR_DATA-SOUND_TR_DATA
CHIJYO_TR	EQU	CHIJYO_TR_DATA-SOUND_TR_DATA
CHIKA_TR	EQU	CHIKA_TR_DATA-SOUND_TR_DATA
OSHIRO_TR	EQU	OSHIRO_TR_DATA-SOUND_TR_DATA
BOSS_TR		EQU	BOSS_TR_DATA-SOUND_TR_DATA
BONUS_TR	EQU	BONUS_TR_DATA-SOUND_TR_DATA
OOBOSS_TR	EQU	OOBOSS_TR_DATA-SOUND_TR_DATA
ATHRE_TR	EQU	ATHRE_TR_DATA-SOUND_TR_DATA
KUPPA_TR	EQU	KUPPA_TR_DATA-SOUND_TR_DATA
ENDING_TR	EQU	ENDING_TR_DATA-SOUND_TR_DATA
;
;------------------------------------------------------------------------
;-		TEhvO]e[u				-
;------------------------------------------------------------------------
ITEM_STOP_SW	EQU	$
		HEX	0		;[0] Ԕ
		HEX	0		;[1] n
		HEX	0		;[2] 
		HEX	1		;[3] {X
		HEX	0		;[4] n
		HEX	1		;[5] {XiȂ{Xaflj
		HEX	0		;[6] {[iXQ[
		HEX	1		;[7] {X
		HEX	1		;[8] {XiȂ{Xaflj
		HEX	1		;[9] {XiJ`J`pȂ{Xaflj
		HEX	0		;[A] AX`bN
		HEX	0		;[B] G}I
		HEX	1		;[C] Nbp
		HEX	0		;[D] XyVS
		HEX	0		;[E]
		HEX	0		;[F]
;
		HEX	FF		;[10] ^Cg
		HEX	0		;[11] Pv|Of
		HEX	FF		;[12] }bv
;
GAME_TR_ADRS	EQU	$-1
		BYTE	OHANA_TR	;[0] Ԕ
		BYTE	CHIJYO_TR	;[1] n
		BYTE	OSHIRO_TR	;[2] 
		BYTE	BOSS_TR		;[3] {X
		BYTE	CHIKA_TR	;[4] n
		BYTE	BOSS_TR		;[5] {XiȂ{Xaflj
		BYTE	BONUS_TR	;[6] {[iXQ[
		BYTE	OOBOSS_TR	;[7] {X
		BYTE	OOBOSS_TR	;[8] {XiȂ{Xaflj
		BYTE	OOBOSS_TR	;[9] {XiJ`J`pȂ{Xaflj
		BYTE	ATHRE_TR	;[A] AX`bN
		BYTE	ATHRE_TR	;[B] G}I
		BYTE	KUPPA_TR	;[C] Nbp
		BYTE	BOSS_TR		;[D] XyVS
		BYTE	0		;[E]
		BYTE	0		;[F]
;
TITLE_SOUND_ADR BYTE	TITLE_TR	;[10] ^Cg
W1_0_SOUND_ADR	BYTE	W1_0_DM_TR	;[11] Pv|Of
MAP_SOUND_ADR	BYTE	MAP_TR		;[12] }bv
END_SOUND_ADR	BYTE	ENDING_TR	;[13] }bv
;
TITLE_SOUND	EQU	TITLE_SOUND_ADR-GAME_TR_ADRS-1
W1_0_SOUND	EQU	W1_0_SOUND_ADR-GAME_TR_ADRS-1
MAP_SOUND	EQU	MAP_SOUND_ADR-GAME_TR_ADRS-1
END_SOUND	EQU	END_SOUND_ADR-GAME_TR_ADRS-1
;
SOUND_TR_2	EQU	$
		STX	BGM_NO
SOUND_TR	EQU	$
;
;------------------------------------------------------------------------
;-		TEhvO]`FbN				-
;------------------------------------------------------------------------
		LDX	BGM_NO
		LDA	>ITEM_STOP_SW,X ;ACegp֎~tOZbg
		BMI	SOUND_TR_0010	;ACegp֎~tOZbgnjH ( no:SOUND_TR_0010 )
;
		STA	ITEM_STOP
;
SOUND_TR_0010	EQU	$
		INX
		CPX	GM_BGM_NO
		BNE	SOUND_TR_0020	;aflύXH ( yes:SOUND_TR_0020 )
		RTL
;
SOUND_TR_0020	EQU	$
		STX	GM_BGM_NO
		STZ	GM_SOUND_0
		LDA	>GAME_TR_ADRS,X
		TAX			;(X) <-- ]^Cv
;
;------------------------------------------------------------------------
;-		TEhvO]`FbN			-
;------------------------------------------------------------------------
		STZ	<next_flag
		STZ	<next_flag+1
		STZ	<pointer
;
		LDY	#0
SOUND_TR_0050	EQU	$
		LDA	>SOUND_TR_DATA,X
		CMP	SOUND_AR_0,Y
		BEQ	SOUND_TR_0100	;]ρH ( yes:SOUND_TR_0100 )
;
		STA	SOUND_AR_0,Y
		CMP	#0FFH
		BEQ	SOUND_TR_0100	;]H ( no:SOUND_TR_0100 )
;
		INC	<next_flag
;
		PHX			;(X) save
		PHY			;(Y) save
;
		TAX
		LDY	<pointer
		LDA	>SOUND_TR_ADRS-1,X
		STA	address,Y
		LDA	>SOUND_TR_ADRS-1+1,X
		STA	address+1,Y
		LDA	>SOUND_TR_ADRS-1+2,X
		STA	address+2,Y
		INY
		INY
		INY
		STY	<pointer
;
		PLY			;(Y) load
		PLX			;(X) load
SOUND_TR_0100	EQU	$
		INX
		INY
		CPY	#4
		BCC	SOUND_TR_0050
;
		DEC	<next_flag
		BMI	SOUND_TR_0150	;]H ( yes:SOUND_TR_0150 )
;
;------------------------------------------------------------------------
;-		TEhvO]					-
;------------------------------------------------------------------------
		SEI			;IRQ disable
;
		LDA	#0FFH		;flag set !!
		STA	APU_port0
		JSR	Boot_APU	;sound transfer
;
		CLI			;IRQ enable
;
SOUND_TR_0150	EQU	$
		LDX	#04-1
SOUND_TR_0200	EQU	$
		STZ	2140H,X		;sound port clear !!
		DEX
		BPL	SOUND_TR_0200
;
		M16
;
		STZ	SOUND_0
		STZ	SOUND_0_CK
		STZ	SOUND_3
		STZ	SOUND_3_CK
		STZ	SOUND_3_P
		STZ	SOUND_3_BF
;
		M8
;
		RTL
;
;************************************************************************
;*									*
;*		TEhrdtOobt@Zbg			*
;*			in :						*
;*				(A) <-- rdtO			*
;*			break :						*
;*				(Y)					*
;*									*
;************************************************************************
SOUND_3_ON	EQU	$
		LDY	SOUND_3_P
		STA	SOUND_3_BF,Y
		INC	SOUND_3_P
		RTL
;
;
;
;
;
		END
