;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program				*
;*	file name	: ys_chip0					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	COS,SIN,LCOS,LSIN,LCOS_S,LSIN_S
		GLB	FURA_WAVE_MAP
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip1 >-----------------------------------------------
;		EXT
;
;-------------< ys_chip2 >-----------------------------------------------
		EXT	C_32_ROTZOM,C_32_ZOOM_XY_16,C_32_ROTZOM_16,C_16_ROTZOM
		EXT	C_32_RTZ_16_XY,C_64HZOOM_32,C_32_ZOOM
		EXT	C_32_ZOOM_XY_C,C_32_ROTZOM_C,C_32_ZOOM_XY
		EXT	C_32_RTZ_32_XY
;
;-------------< ys_pldt >-----------------------------------------------
		EXT	M_TAN
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
MPCIPCHR	EQU	560000H		;}bvrbg}bvLN^[AhX
MFCIPCHR	EQU	568000H		;H flip
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_8		GROUP	S_chip_0
S_chip_0	SECT	REL
;
;
;************************************************************************
;*		M-chip initial set					*
;************************************************************************
CHIPINIT	EQU	$
		SUB	R0		;[ IBT R0,#0 ]
		RAMB
;
		STOP
		NOP
;
;************************************************************************
;*	f[^k					(DT_UNCOMPRESS) *
;*     mn	  @qSFf[^oNiSOg`Tegj		*
;*		  @qXF@@@@AhX				*
;*		  qPOF𓀐@AhX				*
;*									*
;*     mn qPOF𓀌  𓀐  AhX			*
;*									*
;*     mtnR0,R1,R2,R3,R4,R5,R6,R7,R9,R10,R11,R12,R13,R14,R15	*
;************************************************************************
DT_UNCOMPRESS	EQU	$
		FROM	R4
		ROMB				; b|qoNݒ
		MOVE	R14,R9			; qPSb|qAhXݒ
;
		MOVE	R9,R10			; (qX)   𓀐AhX(l)
		IWT	R5,#003FFH		;iqTj@f[^`FbNR[h
		IBT	R6,#0001FH		;iqUj@f[^`FbNR[h
		IWT	R7,#000E0H		;iqVj@f[^s`FbNR[h
		IWT	R8,#000FFH		;iqWj@f[^I`FbNR[h
		IWT	R11,#(DT_UNC000+1)	;iqPPjiloAhX
;
		CACHE				; LbV
;
DT_UNC000
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC100+1		; moNH
;						; 
		SUB	R8
		ADD	R8
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC100
		SUB	R8
		BNE	DT_UNC200		; f[^IH
;						; 
		ADD	R8
		STOP				; frtI
		NOP
;
;-----------------------------------------------; f[^`FbN
DT_UNC200
		TO	R2			; cqQ
		AND	R7			; qQf[^s
		SUB	R7
		BPL	DT_UNC300		; Pegȏf[^H
;						; 
		ADD	R7
		AND	R6			; qOif[^FPeȓj
		BRA	DT_UNC500+1
		INC	R0
;
DT_UNC300
		MOVE	R1,R0			; qO̓eqPɃZbg
		ADD	R0
		ADD	R0
		ADD	R0			; qOqOW@
		TO	R2			; cqQ
		AND	R7			; qQf[^s
;
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC400+1		; moNH
;						; 
		WITH	R1			; rqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC400
		WITH	R1			; rqP
		SWAP				; rik|gjcig|kj
		OR	R1
		AND	R5			; qOif[^FPeȏj
;
;-----------------------------------------------; f[^s`FbN
DT_UNC500
		INC	R0
		MOVE	R12,R0			; qPQɃf[^Zbg
		MOVES	R0,R2			; f[^s`FbN
		BEQ	DT_UNC1100		;i񋤒ʃf[^jH
;						; 
		SWAP
		BMI	DT_UNC1200		;iQƃf[^jH
;						; 
		ADD	R0
		BPL	DT_UNC1300		;iPʃf[^jH
;						; 
		ADD	R0
		BPL	DT_UNC1400		;iQʃf[^jH
;						; 
;-----------------------------------------------;ivXPf[^j
DT_UNC1000
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1040		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1040
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		INC	R0
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------;i񋤒ʃf[^j
DT_UNC1100
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1140		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1140
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------;iQƃf[^j
DT_UNC1200
		WITH	R1			; cqP
		GETB				; qPqobt@
		INC	R14
		BNE	DT_UNC1220+1		; moNH
;						; 
		GETB				; qOqobt@
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1220
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1240+1		; moNH
;						; 
		WITH	R1			; rqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1240
		WITH	R1			; rqP
		SWAP				; rik|gjcig|kj
		TO	R2			; cqQ
		OR	R1			; qQQƃf[^AhX
		WITH	R2			; cqQ
		ADD	R9			; qQQƃf[^AhX
;
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		LDB	(R2)			; b|qf[^[h
		STB	(R10)			; b|qփf[^XgA
		INC	R2
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------; iPʃf[^j
DT_UNC1300
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1340		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1340
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------; iQʃf[^j
DT_UNC1400
		INC	R14
		BNE	DT_UNC1420+1		; moNH
;						; 
		WITH	R1			; cqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1420
		WITH	R1			; cqP
		GETB				; qPqobt@
		INC	R14
		BNE	DT_UNC1440		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1440
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		INC	R10
		DEC	R12
		BEQ	DT_UNC1480		; f[^IH
;						; 
		FROM	R1
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
DT_UNC1480
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;************************************************************************
;*		[hVLN^[Wrbgϊ			*
;*			in :						*
;*				(R12) <-- ϊoCg			*
;************************************************************************
M7_CHR_CNV	EQU	$
		IWT	R1,#WOB7CHR+1800H ;(R1) <-- Srbgf[^|C^[
		IWT	R2,#WOB7CHR+1000H ;(R2) <-- Wrbgϊf[^|C^[
;
		IBT	R3,#0FH		;(R3) <-- ikjf[^`mcf[^
		IWT	R4,#0F0H	;(R4) <-- igj	h
;
		CACHE
;
		MOVE	R13,R15
M7_CHR_CNV_010
		LDB	(R1)
		TO	R5
		AND	R3
;
		AND	R4
		LSR
		LSR
		LSR
		LSR
		SWAP
		OR	R5
		STW	(R2)
;
		INC	R2
		INC	R2
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		q`lubN]					*
;*			in :						*
;*				(R1)  <-- ]|C^[		*
;*				(R2)  <-- ]|C^[		*
;*				(R12) <-- ]oCg			*
;************************************************************************
MRAM_MOVE	EQU	$
		CACHE
;
		MOVE	R13,R15
MRAM_MOVE_0010
		LDB	(R1)
		STB	(R2)
		INC	R1
		LOOP
		INC	R2
;
		STOP
		NOP
;
;************************************************************************
;*		q`lf[^]					*
;*			in :						*
;*				(R0)  <-- ]AhX		*
;*				(R1)  <--	h	Zf[^	*
;*				(R2)  <-- ]f[^			*
;*				(R12) <-- ][h			*
;************************************************************************
MRAM_FILL	EQU	$
		CACHE
;
		MOVE	R13,R15
MRAM_FILL_0010
		FROM	R2
		STW	(R0)
		LOOP
		ADD	R1
;
		STOP
		NOP
;
;****************************************************************
;*		PROGRAM						*
;****************************************************************
;=============== OAM ALL KAITEN =================================
;
;		KAKUDO	  --> OBJKAKU
;		MANNAKA X --> OBJXPOS
;		MANNAKA Y --> OBJYPOS
;		ZOOM X	  --> OBJXZUM
;		ZOOM Y	  --> OBJYZUM
;
;
OBJKAI		EQU		$
		LM		R0,OBJKAKU		;KAKUDO(0 - FF)
		LINK		#4			;R9 = SIN(KAKUDO)
		IWT		R15,#SINGET
		NOP
		MOVE		R1,R0
;
		LM		R0,OBJKAKU		;KAKUDO(0 - FF)
		LINK		#4			;R10 = COS(KAKUDO)
		IWT		R15,#COSGET
		NOP
		MOVE		R2,R0
;
		LM		R3,OBJXZUM		;X ZOOM
		LM		R5,OBJYZUM		;Y ZOOM
;
		LM		R11,OBJXPOS		;R11 = MANNAKA X
		LM		R14,OBJYPOS		;R14 = MANNAKA Y
;
		MOVE		R6,R2			;COS * X ZOOM
		MOVE		R0,R3
		LMULT
		LOB
		TO		R7
		SWAP
		FROM		R4
		HIB
		TO		R7
		OR		R7
;
		MOVE		R6,R1			;SIN * X ZOOM
		MOVE		R0,R3
		LMULT
		LOB
		TO		R8
		SWAP
		FROM		R4
		HIB
		TO		R8
		OR		R8
;
		MOVE		R6,R2			;COS * Y ZOOM
		MOVE		R0,R5
		LMULT
		LOB
		TO		R9
		SWAP
		FROM		R4
		HIB
		TO		R9
		OR		R9
;
		MOVE		R6,R1			;SIN * Y ZOOM
		MOVE		R0,R5
		LMULT
		LOB
		TO		R10
		SWAP
		FROM		R4
		HIB
		TO		R10
		OR		R10
;
		IWT		R1,#COAM_DX
		IWT		R12,#00100H
		CACHE
		MOVE		R13,R15
;
		LDW		(R1)			;X POS
		IWT		R2,#08000H		;OFF CHK.
		CMP		R2
		BNE		OBJKAI20
		NOP
OBJKAI30
		WITH		R1
		ADD		#008H
		LOOP
		NOP
		STOP
		NOP
;
OBJKAI20
		TO		R2
		SUB		R11
		MOVE		R5,R1
		INC		R5
		INC		R5
		LDW		(R5)			;Y POS
		TO		R3
		SUB		R14
		WITH		R5
		ADD		#004H
		LDW		(R5)
		ADD		#000H
		BPL		OBJKAI30
		NOP
;
		MOVE		R6,R7			;COS * X ZOOM * X POS
		MOVE		R0,R2
		LMULT
		SMS		R4,CWORK0
		SMS		R0,CWORK1
		MOVE		R6,R8			;SIN * X ZOOM * Y POS
		MOVE		R0,R3
		LMULT
		SMS		R0,CWORK2
		LMS		R0,CWORK0
		TO		R5
		ADD		R4
		LMS		R0,CWORK1
		LMS		R4,CWORK2
		ADC		R4
		LOB
		TO		R4
		SWAP
		FROM		R5
		HIB
		OR		R4
		ADD		R11
		STW		(R1)
		INC		R1
		INC		R1
;
		MOVE		R6,R9			;COS * Y ZOOM * Y POS
		MOVE		R0,R3
		LMULT
		SMS		R4,CWORK0
		SMS		R0,CWORK1
		MOVE		R6,R10			;SIN * Y ZOOM * X POS
		MOVE		R0,R2
		LMULT
		SMS		R0,CWORK2
		LMS		R0,CWORK0
		TO		R5
		SUB		R4
		LMS		R0,CWORK1
		LMS		R4,CWORK2
		SBC		R4
		LOB
		TO		R4
		SWAP
		FROM		R5
		HIB
		OR		R4
		ADD		R14
		STW		(R1)
;
OBJKAI10
		WITH		R1
		ADD		#006H
		LOOP
		NOP
;
		STOP
		NOP
;
;========================================================================
;
;		? --> R0
;
;		R0 <--- SIN(?)
;
SINGET
		LOB
		ADD		R0
		IWT		R14,#SIN
		TO		R14
		ADD		R14
		GETB
		INC		R14
		GETBH
		JMP		R11
		NOP
;------------------------------------------------------------------------
;
;		? --> R0
;
;		R0 <--- COS(?)
;
COSGET
		LOB
		ADD		R0
		IWT		R14,#COS
		TO		R14
		ADD		R14
		GETB
		INC		R14
		GETBH
		JMP		R11
		NOP
;------------------------------------------------------------------------
;
;************************************************************************
;*		[hQ htthg̎}bvf[^		*
;************************************************************************
FURA_WAVE_MAP	EQU	$
		HEX	08,08,08,08,08,08,10,10
;
;************************************************************************
;*		cos data						*
;************************************************************************
M_COS		EQU	$
COS		EQU	$
		WORD	00100H,00100H,00100H,000FFH,000FFH,000FEH,000FDH,000FCH
		WORD	000FBH,000FAH,000F8H,000F7H,000F5H,000F3H,000F1H,000EFH
		WORD	000EDH,000EAH,000E7H,000E5H,000E2H,000DFH,000DCH,000D8H
		WORD	000D5H,000D1H,000CEH,000CAH,000C6H,000C2H,000BEH,000B9H
		WORD	000B5H,000B1H,000ACH,000A7H,000A2H,0009DH,00098H,00093H
		WORD	0008EH,00089H,00084H,0007EH,00079H,00073H,0006DH,00068H
		WORD	00062H,0005CH,00056H,00050H,0004AH,00044H,0003EH,00038H
		WORD	00032H,0002CH,00026H,0001FH,00019H,00013H,0000DH,00006H
;
M_SIN		EQU	$
SIN		EQU	$
		WORD	00000H,0FFFAH,0FFF3H,0FFEDH,0FFE7H,0FFE1H,0FFDAH,0FFD4H
		WORD	0FFCEH,0FFC8H,0FFC2H,0FFBCH,0FFB6H,0FFB0H,0FFAAH,0FFA4H
		WORD	0FF9EH,0FF98H,0FF93H,0FF8DH,0FF87H,0FF82H,0FF7CH,0FF77H
		WORD	0FF72H,0FF6DH,0FF68H,0FF63H,0FF5EH,0FF59H,0FF54H,0FF4FH
		WORD	0FF4BH,0FF47H,0FF42H,0FF3EH,0FF3AH,0FF36H,0FF32H,0FF2FH
		WORD	0FF2BH,0FF28H,0FF24H,0FF21H,0FF1EH,0FF1BH,0FF19H,0FF16H
		WORD	0FF13H,0FF11H,0FF0FH,0FF0DH,0FF0BH,0FF09H,0FF08H,0FF06H
		WORD	0FF05H,0FF04H,0FF03H,0FF02H,0FF01H,0FF01H,0FF00H,0FF00H
		WORD	0FF00H,0FF00H,0FF00H,0FF01H,0FF01H,0FF02H,0FF03H,0FF04H
		WORD	0FF05H,0FF06H,0FF08H,0FF09H,0FF0BH,0FF0DH,0FF0FH,0FF11H
		WORD	0FF13H,0FF16H,0FF19H,0FF1BH,0FF1EH,0FF21H,0FF24H,0FF28H
		WORD	0FF2BH,0FF2FH,0FF32H,0FF36H,0FF3AH,0FF3EH,0FF42H,0FF47H
		WORD	0FF4BH,0FF4FH,0FF54H,0FF59H,0FF5EH,0FF63H,0FF68H,0FF6DH
		WORD	0FF72H,0FF77H,0FF7CH,0FF82H,0FF87H,0FF8DH,0FF93H,0FF98H
		WORD	0FF9EH,0FFA4H,0FFAAH,0FFB0H,0FFB6H,0FFBCH,0FFC2H,0FFC8H
		WORD	0FFCEH,0FFD4H,0FFDAH,0FFE1H,0FFE7H,0FFEDH,0FFF3H,0FFFAH
		WORD	00000H,00006H,0000DH,00013H,00019H,0001FH,00026H,0002CH
		WORD	00032H,00038H,0003EH,00044H,0004AH,00050H,00056H,0005CH
		WORD	00062H,00068H,0006DH,00073H,00079H,0007EH,00084H,00089H
		WORD	0008EH,00093H,00098H,0009DH,000A2H,000A7H,000ACH,000B1H
		WORD	000B5H,000B9H,000BEH,000C2H,000C6H,000CAH,000CEH,000D1H
		WORD	000D5H,000D8H,000DCH,000DFH,000E2H,000E5H,000E7H,000EAH
		WORD	000EDH,000EFH,000F1H,000F3H,000F5H,000F7H,000F8H,000FAH
		WORD	000FBH,000FCH,000FDH,000FEH,000FFH,000FFH,00100H,00100H
		WORD	00100H,00100H,00100H,000FFH,000FFH,000FEH,000FDH,000FCH
		WORD	000FBH,000FAH,000F8H,000F7H,000F5H,000F3H,000F1H,000EFH
		WORD	000EDH,000EAH,000E7H,000E5H,000E2H,000DFH,000DCH,000D8H
		WORD	000D5H,000D1H,000CEH,000CAH,000C6H,000C2H,000BEH,000B9H
		WORD	000B5H,000B1H,000ACH,000A7H,000A2H,0009DH,00098H,00093H
		WORD	0008EH,00089H,00084H,0007EH,00079H,00073H,0006DH,00068H
		WORD	00062H,0005CH,00056H,00050H,0004AH,00044H,0003EH,00038H
		WORD	00032H,0002CH,00026H,0001FH,00019H,00013H,0000DH,00006H
;
;************************************************************************
;*		cos data ( 8 bit )					*
;************************************************************************
LCOS		EQU	$
		BYTE	040H,040H,040H,040H,040H,040H,03FH,03FH
		BYTE	03FH,03EH,03EH,03EH,03DH,03DH,03CH,03CH
		BYTE	03BH,03BH,03AH,039H,038H,038H,037H,036H
		BYTE	035H,034H,033H,032H,031H,030H,02FH,02EH
		BYTE	02DH,02CH,02BH,02AH,029H,027H,026H,025H
		BYTE	024H,022H,021H,020H,01EH,01DH,01BH,01AH
		BYTE	018H,017H,016H,014H,013H,011H,010H,00EH
		BYTE	00CH,00BH,009H,008H,006H,005H,003H,002H
;
LSIN		EQU	$
		BYTE	000H,0FEH,0FDH,0FBH,0FAH,0F8H,0F7H,0F5H
		BYTE	0F4H,0F2H,0F0H,0EFH,0EDH,0ECH,0EAH,0E9H
		BYTE	0E8H,0E6H,0E5H,0E3H,0E2H,0E0H,0DFH,0DEH
		BYTE	0DCH,0DBH,0DAH,0D9H,0D7H,0D6H,0D5H,0D4H
		BYTE	0D3H,0D2H,0D1H,0D0H,0CFH,0CEH,0CDH,0CCH
		BYTE	0CBH,0CAH,0C9H,0C8H,0C8H,0C7H,0C6H,0C5H
		BYTE	0C5H,0C4H,0C4H,0C3H,0C3H,0C2H,0C2H,0C2H
		BYTE	0C1H,0C1H,0C1H,0C0H,0C0H,0C0H,0C0H,0C0H
		BYTE	0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0C1H,0C1H
		BYTE	0C1H,0C2H,0C2H,0C2H,0C3H,0C3H,0C4H,0C4H
		BYTE	0C5H,0C5H,0C6H,0C7H,0C8H,0C8H,0C9H,0CAH
		BYTE	0CBH,0CCH,0CDH,0CEH,0CFH,0D0H,0D1H,0D2H
		BYTE	0D3H,0D4H,0D5H,0D6H,0D7H,0D9H,0DAH,0DBH
		BYTE	0DCH,0DEH,0DFH,0E0H,0E2H,0E3H,0E5H,0E6H
		BYTE	0E8H,0E9H,0EAH,0ECH,0EDH,0EFH,0F0H,0F2H
		BYTE	0F4H,0F5H,0F7H,0F8H,0FAH,0FBH,0FDH,0FEH
		BYTE	000H,002H,003H,005H,006H,008H,009H,00BH
		BYTE	00CH,00EH,010H,011H,013H,014H,016H,017H
		BYTE	018H,01AH,01BH,01DH,01EH,020H,021H,022H
		BYTE	024H,025H,026H,027H,029H,02AH,02BH,02CH
		BYTE	02DH,02EH,02FH,030H,031H,032H,033H,034H
		BYTE	035H,036H,037H,038H,038H,039H,03AH,03BH
		BYTE	03BH,03CH,03CH,03DH,03DH,03EH,03EH,03EH
		BYTE	03FH,03FH,03FH,040H,040H,040H,040H,040H
		BYTE	040H,040H,040H,040H,040H,040H,03FH,03FH
		BYTE	03FH,03EH,03EH,03EH,03DH,03DH,03CH,03CH
		BYTE	03BH,03BH,03AH,039H,038H,038H,037H,036H
		BYTE	035H,034H,033H,032H,031H,030H,02FH,02EH
		BYTE	02DH,02CH,02BH,02AH,029H,027H,026H,025H
		BYTE	024H,022H,021H,020H,01EH,01DH,01BH,01AH
		BYTE	018H,017H,016H,014H,013H,011H,010H,00EH
		BYTE	00CH,00BH,009H,008H,006H,005H,003H,002H
;
;************************************************************************
;*	  cos data							  *
;************************************************************************
LCOS_S		EQU	$
		BYTE	040H,040H,040H,040H,040H,040H,040H,040H
		BYTE	040H,040H,040H,03FH,03FH,03FH,03FH,03FH
		BYTE	03FH,03FH,03EH,03EH,03EH,03EH,03EH,03DH
		BYTE	03DH,03DH,03DH,03DH,03CH,03CH,03CH,03BH
		BYTE	03BH,03BH,03BH,03AH,03AH,03AH,039H,039H
		BYTE	038H,038H,038H,037H,037H,036H,036H,036H
		BYTE	035H,035H,034H,034H,033H,033H,032H,032H
		BYTE	031H,031H,030H,030H,02FH,02FH,02EH,02EH
		BYTE	02DH,02DH,02CH,02CH,02BH,02AH,02AH,029H
		BYTE	029H,028H,027H,027H,026H,025H,025H,024H
		BYTE	024H,023H,022H,022H,021H,020H,020H,01FH
		BYTE	01EH,01DH,01DH,01CH,01BH,01BH,01AH,019H
		BYTE	018H,018H,017H,016H,016H,015H,014H,013H
		BYTE	013H,012H,011H,010H,010H,00FH,00EH,00DH
		BYTE	00CH,00CH,00BH,00AH,009H,009H,008H,007H
		BYTE	006H,005H,005H,004H,003H,002H,002H,001H
;
LSIN_S		EQU	$
		BYTE	000H,0FFH,0FEH,0FEH,0FDH,0FCH,0FBH,0FBH
		BYTE	0FAH,0F9H,0F8H,0F7H,0F7H,0F6H,0F5H,0F4H
		BYTE	0F4H,0F3H,0F2H,0F1H,0F0H,0F0H,0EFH,0EEH
		BYTE	0EDH,0EDH,0ECH,0EBH,0EAH,0EAH,0E9H,0E8H
		BYTE	0E8H,0E7H,0E6H,0E5H,0E5H,0E4H,0E3H,0E3H
		BYTE	0E2H,0E1H,0E0H,0E0H,0DFH,0DEH,0DEH,0DDH
		BYTE	0DCH,0DCH,0DBH,0DBH,0DAH,0D9H,0D9H,0D8H
		BYTE	0D7H,0D7H,0D6H,0D6H,0D5H,0D4H,0D4H,0D3H
		BYTE	0D3H,0D2H,0D2H,0D1H,0D1H,0D0H,0D0H,0CFH
		BYTE	0CFH,0CEH,0CEH,0CDH,0CDH,0CCH,0CCH,0CBH
		BYTE	0CBH,0CAH,0CAH,0CAH,0C9H,0C9H,0C8H,0C8H
		BYTE	0C8H,0C7H,0C7H,0C6H,0C6H,0C6H,0C5H,0C5H
		BYTE	0C5H,0C5H,0C4H,0C4H,0C4H,0C3H,0C3H,0C3H
		BYTE	0C3H,0C3H,0C2H,0C2H,0C2H,0C2H,0C2H,0C1H
		BYTE	0C1H,0C1H,0C1H,0C1H,0C1H,0C1H,0C0H,0C0H
		BYTE	0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0C0H
		BYTE	0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0C0H
		BYTE	0C0H,0C0H,0C0H,0C1H,0C1H,0C1H,0C1H,0C1H
		BYTE	0C1H,0C1H,0C2H,0C2H,0C2H,0C2H,0C2H,0C3H
		BYTE	0C3H,0C3H,0C3H,0C3H,0C4H,0C4H,0C4H,0C5H
		BYTE	0C5H,0C5H,0C5H,0C6H,0C6H,0C6H,0C7H,0C7H
		BYTE	0C8H,0C8H,0C8H,0C9H,0C9H,0CAH,0CAH,0CAH
		BYTE	0CBH,0CBH,0CCH,0CCH,0CDH,0CDH,0CEH,0CEH
		BYTE	0CFH,0CFH,0D0H,0D0H,0D1H,0D1H,0D2H,0D2H
		BYTE	0D3H,0D3H,0D4H,0D4H,0D5H,0D6H,0D6H,0D7H
		BYTE	0D7H,0D8H,0D9H,0D9H,0DAH,0DBH,0DBH,0DCH
		BYTE	0DCH,0DDH,0DEH,0DEH,0DFH,0E0H,0E0H,0E1H
		BYTE	0E2H,0E3H,0E3H,0E4H,0E5H,0E5H,0E6H,0E7H
		BYTE	0E8H,0E8H,0E9H,0EAH,0EAH,0EBH,0ECH,0EDH
		BYTE	0EDH,0EEH,0EFH,0F0H,0F0H,0F1H,0F2H,0F3H
		BYTE	0F4H,0F4H,0F5H,0F6H,0F7H,0F7H,0F8H,0F9H
		BYTE	0FAH,0FBH,0FBH,0FCH,0FDH,0FEH,0FEH,0FFH
		BYTE	000H,001H,002H,002H,003H,004H,005H,005H
		BYTE	006H,007H,008H,009H,009H,00AH,00BH,00CH
		BYTE	00CH,00DH,00EH,00FH,010H,010H,011H,012H
		BYTE	013H,013H,014H,015H,016H,016H,017H,018H
		BYTE	018H,019H,01AH,01BH,01BH,01CH,01DH,01DH
		BYTE	01EH,01FH,020H,020H,021H,022H,022H,023H
		BYTE	024H,024H,025H,025H,026H,027H,027H,028H
		BYTE	029H,029H,02AH,02AH,02BH,02CH,02CH,02DH
		BYTE	02DH,02EH,02EH,02FH,02FH,030H,030H,031H
		BYTE	031H,032H,032H,033H,033H,034H,034H,035H
		BYTE	035H,036H,036H,036H,037H,037H,038H,038H
		BYTE	038H,039H,039H,03AH,03AH,03AH,03BH,03BH
		BYTE	03BH,03BH,03CH,03CH,03CH,03DH,03DH,03DH
		BYTE	03DH,03DH,03EH,03EH,03EH,03EH,03EH,03FH
		BYTE	03FH,03FH,03FH,03FH,03FH,03FH,040H,040H
		BYTE	040H,040H,040H,040H,040H,040H,040H,040H
		BYTE	040H,040H,040H,040H,040H,040H,040H,040H
		BYTE	040H,040H,040H,03FH,03FH,03FH,03FH,03FH
		BYTE	03FH,03FH,03EH,03EH,03EH,03EH,03EH,03DH
		BYTE	03DH,03DH,03DH,03DH,03CH,03CH,03CH,03BH
		BYTE	03BH,03BH,03BH,03AH,03AH,03AH,039H,039H
		BYTE	038H,038H,038H,037H,037H,036H,036H,036H
		BYTE	035H,035H,034H,034H,033H,033H,032H,032H
		BYTE	031H,031H,030H,030H,02FH,02FH,02EH,02EH
		BYTE	02DH,02DH,02CH,02CH,02BH,02AH,02AH,029H
		BYTE	029H,028H,027H,027H,026H,025H,025H,024H
		BYTE	024H,023H,022H,022H,021H,020H,020H,01FH
		BYTE	01EH,01DH,01DH,01CH,01BH,01BH,01AH,019H
		BYTE	018H,018H,017H,016H,016H,015H,014H,013H
		BYTE	013H,012H,011H,010H,010H,00FH,00EH,00DH
		BYTE	00CH,00CH,00BH,00AH,009H,009H,008H,007H
		BYTE	006H,005H,005H,004H,003H,002H,002H,001H
;
;
;================ OAM_DXCLR =============================================
OAM_DXCLR	EQU		$
		CACHE
		IWT		R0,#COAM_DX
		SMS		R0,COAMIDX
;
		IWT		R1,#08000H
		IBT		R2,#008H
;
		IWT		R12,#256
		MOVE		R13,R15
;
		FROM		R1
		STW		(R0)
;
		LOOP
		ADD		R2
;
		STOP
		NOP
;
;;;;;================ OAM_DXCLR_S ===========================================
;;;;OAM_DXCLR_S	    EQU		    $
;;;;		    CACHE
;;;;		    IWT		    R0,#COAM_DX
;;;;		    SMS		    R0,COAMIDX
;;;;;
;;;;		    IWT		    R1,#08000H
;;;;		    IBT		    R2,#008H
;;;;;
;;;;		    IBT		    R3,#6	    ;to spacial flag pointer add data
;;;;;
;;;;		    IWT		    R12,#128
;;;;		    MOVE	    R13,R15
;;;;;
;;;;		    TO		    R4
;;;;		    ADD		    R3
;;;;		    TO		    R5
;;;;		    LDW		    (R4)
;;;;		    MOVES	    R5,R5
;;;;		    BMI		    OAM_DXCLR_S_010
;;;;		    FROM	    R1
;;;;;
;;;;		    STW		    (R0)
;;;;;
;;;;OAM_DXCLR_S_010
;;;;		    LOOP
;;;;		    ADD		    R2
;;;;;
;;;;		    STOP
;;;;		    NOP
;
;========================================================================
DX_OAM		EQU		$
		IBT		R12,#16		;not OAM_DX area no
;
;;;;DX_OAM_S	    EQU		    $
;;;;		    MOVE	    R6,R12
;
;-------------- not OAM_DX area clear -----------------------------------
		IWT		R0,#COAM+1
		IBT		R1,#4
		IBT		R2,#0F0H
;
		CACHE
;
		MOVE		R13,R15
;
		FROM		R2
		STB		(R0)
		LOOP
		ADD		R1
;
;-------------- OAM_DX area set -----------------------------------------
;;;;		    MOVE	    R2,R0
;;;;		    DEC		    R2
		IWT		R2,#COAM+4*16
;;;;		    IWT		    R0,#COAMSB
;;;;		    TO		    R4
;;;;		    ADD		    R6
		IWT		R4,#COAMSB+1*16
;
		IWT		R1,#COAM_DX
		IWT		R3,#COAM+200H-4
		IWT		R5,#COAMSB+80H-1
		IBT		R7,#0F1H
;
;;;;		    IWT		    R12,#128		    ;LOOP N
		IWT		R12,#256		;LOOP N
		MOVE		R13,R15			;LOOP ADDR
;
		MOVE		R6,R1			;INDEX KEISAN USE SET
;
		LDW		(R6)			;X POS CHK.
		CMP		R7
		BLT		DX_OAM80
		NOP
		IWT		R8,#00100H
		CMP		R8
		BGE		DX_OAM80
		INC		R6
		INC		R6
		IBT		R9,#000H		;COAMSB DATA INT
		MOVES		R11,R0
		BPL		DX_OAM60
		NOP
		INC		R9			;COAMSB SET
;
DX_OAM60
		LDW		(R6)			;Y POS CHK.
		CMP		R7
		BLT		DX_OAM80
		NOP
		IWT		R8,#000F0H
		CMP		R8
		BGE		DX_OAM80
		INC		R6
		MOVE		R14,R0
		INC		R6
;
		TO		R10			;CHAR & ATR SET
		LDW		(R6)
		INC		R6
		INC		R6
;
		LDW		(R6)			;SB & DATA SET
		TO		R9
		OR		R9
		IWT		R8,#04000H		;YUSEN CHK.
		AND		R8
		BNE		DX_OAM10
		FROM		R11
;							;YUSEN
		STB		(R2)			;COAM X SET
		INC		R2
;
		DEC		R14
		FROM		R14			;COAM Y SET
		STB		(R2)
		INC		R2
;
		FROM		R10			;CHAR & ATR SET
		STW		(R2)
		INC		R2
		INC		R2
;
		FROM		R9			;SB SET
		STB		(R4)
;
		BRA		DX_OAM40
		INC		R4
;
DX_OAM10						;NOT YUSEN
		STB		(R3)			;COAM X SET
		INC		R3
;
		DEC		R14
		FROM		R14			;COAM Y SET
		STB		(R3)
		INC		R3
;
		FROM		R10			;CHAR & ATR SET
		STW		(R3)
;
		FROM		R9			;SB SET
		STB		(R5)
		DEC		R5
;
		WITH		R3
		SUB		#006H
;
DX_OAM40
		FROM		R3			;COAM OVERFLOR CHK.
		SUB		R2
		BCC		DX_OAM90
;
DX_OAM80
		WITH		R1			;NEXT COAM_DX
		ADD		#008H
;
		LOOP
		NOP
;
		IBT		R0,#0F0H		;COAM CLR
		INC		R2
		INC		R3
DX_OAM50
		STB		(R2)
		WITH		R2
		ADD		#004H
		FROM		R3
		CMP		R2
		BCS		DX_OAM50
		NOP
;
DX_OAM90
;;;;		STOP
;;;;		NOP
;
;************************************************************************
;*		OAMCHG2							*
;************************************************************************
OAMCHG2		EQU	$
		CACHE
;
		IWT	R10,#COAMSB+80H-1	;R10 <-- COAM index
		IWT	R8,#COAMSUB+20H-1	;R8 <-- COAM sub index
		IBT	R12,#20H		;COAM sub loop set
		MOVE	R13,R15
OACG10
		LDB	(R10)
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
;
		STB	(R8)
		LOOP
		DEC	R8
;
		STOP
		NOP
;
;========================================================================
;
;	R0,R4 = R0 * R6
;
;
MULT16C		EQU		$
		LMULT
;
		STOP
		NOP
;
;************************************************************************
;*		circle window ( big circle )				*
;*			in  : (R0)  <-- window data address(B)		*
;*			      (R4)  <--		 "         (L,H)        *
;*			      (R1)  <-- circle center X pos		*
;*			      (R2)  <--		"     Y  "		*
;*			      (R12) <--	   "   R                        *
;************************************************************************
;
CIRCLWD		EQU	$
		ROMB			;window data address(B) set
		FROM	R2		;circle center Y pos x4
		ADD	R2
		ADD	R0
		IWT	R5,#WINDBF
		ADD	R5
		MOVE	R6,R0		;(R6) <-- center window buffer address(down)
		TO	R5
		SUB	#4		;(R5) <--		"             (up)
		IBT	R7,#00		;(R7) <-- window data pointer
		MOVES	R8,R12		;(R8) <-- circle R
		BEQ	CRW220		;R=0 ? ( yes:CRW220 )
		FROM	R12		;circle R x2
;
;-------------- circle window set -------------------------------
		ADD	R12
		IWT	R3,#DIVBUF
		ADD	R3
		TO	R3
		LDW	(R0)		;(R3) <-- window data step
;
		IWT	R11,#WINDBF+(0D2H*4)-1 ;(R11) <-- window buffer
		IWT	R10,#00FFH	       ;(R10) <-- right max check data
;
		CACHE
;
		IWT	R13,#CRW210+1
CRW210
		FROM	R7
		HIB
		TO	R14
		ADD	R4
		GETB
		UMULT	R8
		TO	R9
		HIB
		FROM	R1
		SUB	R9
		BPL	CRW212		;left max over ? ( no:CRW212 )
		NOP
;
		SUB	R0
CRW212
		STB	(R5)		;left pos set
		STB	(R6)
		INC	R5
		INC	R6
		FROM	R9
		ADD	R1
		SUB	R10
		BMI	CRW214		;right max over ? ( no:CRW214 )
		ADD	R10
;
		MOVE	R0,R10
CRW214
		STB	(R5)		;right pos set
		STB	(R6)
		WITH	R7
		ADD	R3
		WITH	R5
		SUB	#4+1
		IWT	R0,#WINDBF-4	;(R4)  <-- max window buffer address(up)
		FROM	R5
		SUB	R0
		BCS	CRW216		;buffer size over ? ( no:CRW216 )
		NOP
;
		IWT	R5,#WINDBF-4
CRW216
		WITH	R6
		ADD	#4-1
		FROM	R6
		SUB	R11
		BCC	CRW218		;buffer size over ? ( no:CRW218 )
		NOP
;
		MOVE	R6,R11
CRW218
		LOOP
		FROM	R7
;
;-------------- up clear window set -----------------------------
CRW220
		IWT	R0,#WINDBF
		FROM	R5
		SUB	R0
		BMI	CRW232		;up buffer set ? ( no:CRW232 )
		TO	R12
;
		LSR
		INC	R12
		IWT	R9,#00FFH	;(R9)  <-- clear window data
		IBT	R10,#4		;(R10) <-- buffer add data
		MOVE	R0,R5
		MOVE	R13,R15
CRW230
		FROM	R9
		STW	(R0)
		LOOP
		SUB	R10
;
;-------------- down clear window set ---------------------------
CRW232
		IWT	R0,#WINDBF+(0D2H*4)-4
		SUB	R6
		BMI	CRW250		;down buffer set ? ( no:CRW250 )
		TO	R12
;
		LSR
		INC	R12
		IWT	R9,#00FFH	;(R9) <-- clear window data
		IBT	R10,#4		;(R10) <-- buffer add data
		MOVE	R0,R6
		MOVE	R13,R15
CRW240
		FROM	R9
		STW	(R0)
		LOOP
		ADD	R10
;
CRW250
		STOP
		NOP
;
;************************************************************************
;*		circle window ( big circle )				*
;*			in  : (R0)  <-- window data address(B)		*
;*			      (R4)  <--		 "         (L,H)        *
;*			      (R1)  <-- circle center X pos		*
;*			      (R2)  <--		"     Y  "		*
;*			      (R11) <-- 0:left 2:right			*
;*			      (R12) <--	   "   R                        *
;************************************************************************
;
BS_CIRCLWD	EQU	$
		ROMB			;window data address(B) set
		FROM	R2		;circle center Y pos x4
		ADD	R2
		ADD	R0
		IWT	R5,#WINDBF
		ADD	R5
		ADD	R11
		MOVE	R6,R0		;(R6) <-- center window buffer address(down)
		TO	R5
		SUB	#04H		;(R5) <--		"             (up)
		IBT	R7,#00		;(R7) <-- window data pointer
		MOVES	R8,R12		;(R8) <-- circle R
		BEQ	BS_CRW220	;R=0 ? ( yes:BS_CRW220 )
		FROM	R12		;circle R x2
;
;-------------- circle window set -------------------------------
		ADD	R12
		IWT	R3,#DIVBUF
		ADD	R3
		TO	R3
		LDW	(R0)		;(R3) <-- window data step
;
		IWT	R10,#000FFH	;(R10) <-- right max check data
;
		CACHE
;
		MOVE	R13,R15
BS_CRW210
		FROM	R7
		HIB
		TO	R14
		ADD	R4
		GETB
		UMULT	R8
		TO	R9
		HIB
		FROM	R1
		SUB	R9
		BPL	BS_CRW212	;left max over ? ( no:BS_CRW212 )
		NOP
;
		SUB	R0
BS_CRW212
		STB	(R5)		;left pos set
		STB	(R6)
		INC	R5
		INC	R6
		FROM	R9
		ADD	R1
		CMP	R10
		BMI	BS_CRW214	;right max over ? ( no:BS_CRW214 )
		NOP
;
		MOVE	R0,R10
BS_CRW214
		STB	(R5)		;right pos set
		STB	(R6)
;
		WITH	R7
		ADD	R3
		WITH	R5
		SUB	#5
		INC	R6
		INC	R6
;
		LOOP
		INC	R6
;
BS_CRW220
		STOP
		NOP
;
;************************************************************************
;*		circle window ( big circle )				*
;*			in  : (R5)  <-- mask data			*
;************************************************************************
;
BS_MASKST	EQU	$
		IWT	R6,#WINDBF
;
		IWT	R1,#000B8H	; R1 <-- window 1 left data set
		IWT	R0,#000D7H
		SUB	R5		; R2 <-- window 1 right data set
		CMP	R1
		BNE	BS_MSS050	; mask over ?
		NOP
;
		IWT	R1,#000FFH
		SUB	R0
;
BS_MSS050
		MOVE	R2,R0
;
		IWT	R4,#000F7H	; R4 <-- window 2 right deta set
		IWT	R0,#000D8H
		ADD	R5		; R3 <-- window 2 left deta set
		CMP	R4
		BNE	BS_MSS100
		NOP
;
		IBT	R4,#000H
		IWT	R0,#000FFH
;
BS_MSS100
		MOVE	R3,R0
;
		IWT	R12,#000D2H
;
		CACHE
;
		MOVE	R13,R15
BS_MSS150
		FROM	R1
		STB	(R6)
		INC	R6
;
		FROM	R2
		STB	(R6)
		INC	R6
;
		FROM	R3
		STB	(R6)
		INC	R6
;
		FROM	R4
		STB	(R6)
;
		LOOP
		INC	R6
;
		STOP
		NOP
;
;************************************************************************
;*		window buffer initial set sub				*
;************************************************************************
WINBFCLR	EQU	$
		IWT	R1,#WINDBF
		IWT	R2,#WINDBF+1*2
		IWT	R0,#000FFH
		IWT	R12,#000D2H
;
		CACHE
;
		MOVE	R13,R15
;
WFR050		EQU	$
		STW	(R1)		; left window data clear !!
		STW	(R2)		; right window data clear !!
;
		INC	R1
		INC	R1
		INC	R1
		INC	R1
		INC	R2
		INC	R2
		INC	R2
		LOOP
		INC	R2
;
		STOP
		NOP
;
;************************************************************************
;*		slot window ( big circle )				*
;*			in  : (R1)  <-- BG 1 scroll data		*
;************************************************************************
;
BS_SLOTWIN	EQU	$
		IWT	R0,#000FFH
		IWT	R2,#WINDBF
		IWT	R12,#000D2H
;
		CACHE
;
		MOVE	R13,R15
;
BS_STN000
		STW	(R2)
		INC	R2
		INC	R2
		STW	(R2)
		INC	R2
		LOOP
		INC	R2
;
		IWT	R4,#WINDBF
		IBT	R0,#04EH+15H
		SUB	R1
		ADD	R0
		ADD	R0
		TO	R2		; (R2) <-- up window address !!
		ADD	R4
;
		IWT	R0,#00082H
		SUB	R1
		ADD	R0
		ADD	R0
		TO	R3		; (R3) <-- down window address !!
		ADD	R4
;
		IWT	R4,#WINDBF+(000D2H*4)
		IWT	R5,#0852EH
;
		IBT	R12,#016H
;
		MOVE	R13,R15
;
BS_STN050
		FROM	R2
		CMP	R4
		BCS	BS_STN100	; up addres pointer over ?
		NOP			; Yes !!
;
		FROM	R5
		STW	(R2)
;
BS_STN100
		DEC	R2
		DEC	R2
		DEC	R2
		DEC	R2
;
		FROM	R3
		CMP	R4
		BCS	BS_STN150	; down address pointer over ?
		NOP			; Yes !!
;
		FROM	R5
		STW	(R3)
;
BS_STN150
		INC	R3
		INC	R3
		INC	R3
		LOOP
		INC	R3
;
		STOP
		NOP
;
;----------------------------------------------------------------
;-	R7 / R8 -> R9 ... R0					-
;----------------------------------------------------------------
;----------------------------------------------------------------
;-	use register						-
;-		r0,r7,r8,r9,r12,r13				-
;----------------------------------------------------------------
DIV16		EQU	$
		IBT	R12,#0016	; R12 <- 00016
		SUB	R0		; R0 <- 0000
		MOVE	R9,R0		; R9 <- 0000 ( syou clear )
		MOVE	R13,R15
DIV000
		WITH	R9
		ADD	R9		; R9 <- R9 << 1
		WITH	R7
		ADD	R7		; R7 <- R7 << 1
		ROL			; R0 <- R0 << 1
		CMP	R8
		BCC	DIV020
		NOP
;
		SUB	R8		; R0 <- R0 - R8
		INC	R9
DIV020
		LOOP
		NOP
;
		JMP	R11
		NOP
;
;************************************************************************
;*		R G B color change					*
;*			R1  <- read ram address				*
;*			R2  <- write "     "				*
;*			R5  <- Red bairitu				*
;*			R10 <- Green bairitu				*
;*			R14 <- Blue bairitu				*
;************************************************************************
;
;------------------------------------------------------------------------
;-	use register							-
;-		r0,r1,r2,r3,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14		-
;------------------------------------------------------------------------
COLHEN		EQU	$
		CACHE
;;;;		    IWT	    R1,#MOTOCOL	    ; read ram address set
;;;;		    IWT	    R2,#CHNGCOL	    ; write "     "	"
		IWT	R12,#100H	; loop suu set
		IBT	R3,#01FH	; colour and data
		MOVE	R13,R15
COL000
		LDW	(R1)		; colour read
		TO	R7
		AND	R3		; r7 <- Red
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R8
		AND	R3		; r8 <- Green
		LSR
		LSR
		LSR
		LSR
		LSR
		AND	R3		; r0 <- Blue
		ADD	R7
		ADD	R8		; R+G+B
		TO	R7
		SWAP			; low <-> high
;
		SMS	R12,REG12	; r12 push
		SMS	R13,REG13	; r13 push
;
		IBT	R8,#03
		LINK	#4
		IWT	R15,#DIV16	; warizan
		NOP
;
		LMS	R12,REG12	; r12 pull
		LMS	R13,REG13	; r13 pull
;
		IWT	R0,#00080H
		ADD	R9
		HIB
		TO	R6
		SWAP
;
		FROM	R5
		TO	R7
		FMULT		; r7 <- Red
;
		FROM	R10
		TO	R8
		FMULT		; r8 <- Green

;
		FROM	R14
		FMULT		; r0 <- Blue
;
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		OR	R8
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		OR	R7
;
		STW	(R2)
		INC	R1
		INC	R1
		INC	R2
		INC	R2
;
		LOOP
		NOP
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*									*
;*		COLOR FADE						*
;*									*
;*									*
;************************************************************************
;
;
;		R1		R
;		R2		G
;		R3		B
;
;		R4		R
;		R5		G
;		R6		B
;
;		R7		R
;		R8		G
;		R9		B
;
;		R10		00010H
;		R11		COLOR FADE CNT
;
;		R12		RAM POINTER
;		R14		ROM POINTER
;
;
COLFADE		EQU		$
		IBT		R0,#BANK COLDAT0
		ROMB
;
		IBT		R1,#01FH
		LM		R0,CLFDCNT
		MOVE		R11,R0			;CNT SET
		INC		R0
;;;;		AND		R1
		NOP
		NOP
		SBK
;
		IBT		R10,#020H		;MULT
;
		IWT		R12,#00200H
		CACHE
		MOVE		R13,R15
;
		LM		R0,MOTOADR		;MOTO COLOR SET
		SUB		#002H
;		IWT		R0,#MOTOCOL-2
		ADD		R12
		LDW		(R0)
		MOVE		R2,R0
		MOVE		R1,R0
		LSR
		LSR
		TO		R3
		SWAP
		FROM		R2
		ADD		R2
		ADD		R0
		ADD		R0
		TO		R2
		SWAP
		IBT		R0,#01FH
		TO		R1
		AND		R1
		TO		R2
		AND		R2
		TO		R3
		AND		R3
;
		LM		R0,CHNGADR		;CHANGE COLOR SET
		SUB		#002H
;		IWT		R0,#CHNGCOL-2
		ADD		R12
		LDW		(R0)
		MOVE		R5,R0
		MOVE		R4,R0
		LSR
		LSR
		TO		R6
		SWAP
		FROM		R5
		ADD		R5
		ADD		R0
		ADD		R0
		TO		R5
		SWAP
		IBT		R0,#01FH
		TO		R4
		AND		R4
		TO		R5
		AND		R5
		TO		R6
		AND		R6
;
		IWT		R0,#DATACOL-2		;DATA COLOR SET
		ADD		R12
		LDW		(R0)
		MOVE		R8,R0
		MOVE		R7,R0
		LSR
		LSR
		TO		R9
		SWAP
		FROM		R8
		ADD		R8
		ADD		R0
		ADD		R0
		TO		R8
		SWAP
		IBT		R0,#01FH
		TO		R7
		AND		R7
		TO		R8
		AND		R8
		TO		R9
		AND		R9
;
		FROM		R3
		SUB		R6
		BEQ		CLADE10
		NOP
		BPL		CLADE20
		NOP
		NOT
		INC		R0
CLADE20
		MULT		R10
		ADD		R11
		IWT		R14,#COLDAT0
		WITH		R14
		ADD		R0
		FROM		R9
		SUB		R6
		BEQ		CLADE10
		NOP
		BPL		CLADE30
		NOP
		GETB
		WITH		R9
		BRA		CLADE10
		ADD		R0
CLADE30
		GETB
		WITH		R9
		SUB		R0
CLADE10
;
		FROM		R2
		SUB		R5
		BEQ		CLADE40
		NOP
		BPL		CLADE50
		NOP
		NOT
		INC		R0
CLADE50
		MULT		R10
		ADD		R11
		IWT		R14,#COLDAT0
		WITH		R14
		ADD		R0
		FROM		R8
		SUB		R5
		BEQ		CLADE40
		NOP
		BPL		CLADE60
		NOP
		GETB
		WITH		R8
		BRA		CLADE40
		ADD		R0
CLADE60
		GETB
		WITH		R8
		SUB		R0
CLADE40
;
		FROM		R1
		SUB		R4
		BEQ		CLADE70
		NOP
		BPL		CLADE80
		NOP
		NOT
		INC		R0
CLADE80
		MULT		R10
		ADD		R11
		IWT		R14,#COLDAT0
		WITH		R14
		ADD		R0
		FROM		R7
		SUB		R4
		BEQ		CLADE70
		NOP
		BPL		CLADE90
		NOP
		GETB
		WITH		R7
		BRA		CLADE70
		ADD		R0
CLADE90
		GETB
		WITH		R7
		SUB		R0
CLADE70
;
		FROM		R8
		SWAP
		LSR
		LSR
		TO		R8
		LSR
		FROM		R9
		SWAP
		ADD		R0
		ADD		R0
		OR		R8
		OR		R7
		IWT		R1,#DATACOL-2
		WITH		R1
		ADD		R12
		STW		(R1)
;
		DEC		R12
		LOOP
		NOP
		STOP
		NOP
;
COLDAT0
		BYTE		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		BYTE		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
COLDAT1
		BYTE		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
		BYTE		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
COLDAT2
		BYTE		1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		BYTE		1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
COLDAT3
		BYTE		1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0
		BYTE		0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0
;
COLDAT4
		BYTE		1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0
		BYTE		1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0
;
COLDAT5
		BYTE		1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0
		BYTE		0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0
;
COLDAT6
		BYTE		1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0
		BYTE		1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0
;
COLDAT7
		BYTE		1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0
		BYTE		0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0
;
COLDAT8
		BYTE		1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
		BYTE		1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
;
COLDAT9
		BYTE		1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0
		BYTE		0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0
;
COLDATA
		BYTE		1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0
		BYTE		1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0
;
COLDATB
		BYTE		1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
		BYTE		0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0
;
COLDATC
		BYTE		1,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0
		BYTE		1,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0
;
COLDATD
		BYTE		1,0,1,0,1,0,0,1,0,1,0,0,1,0,0,1
		BYTE		0,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0
;
COLDATE
		BYTE		1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
		BYTE		0,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0
;
COLDATF
		BYTE		1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
		BYTE		0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0
;
COLDAT10
		BYTE		1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
		BYTE		1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
;
COLDAT11
		BYTE		1,1,0,1,0,1,0,1,1,0,1,0,1,0,1,0
		BYTE		1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
;
COLDAT12
		BYTE		1,1,0,1,0,1,0,1,1,0,1,0,1,0,1,0
		BYTE		1,1,0,1,0,1,0,1,1,0,1,0,1,0,1,0
;
COLDAT13
		BYTE		1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1
		BYTE		1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,0
;
COLDAT14
		BYTE		1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0
		BYTE		1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0
;
COLDAT15
		BYTE		1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1
		BYTE		1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0
;
COLDAT16
		BYTE		1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,0
		BYTE		1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,0
;
COLDAT17
		BYTE		1,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1
		BYTE		1,0,1,1,1,0,1,1,0,1,1,1,0,1,1,0
;
COLDAT18
		BYTE		1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0
		BYTE		1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0
;
COLDAT19
		BYTE		1,1,1,1,0,1,1,1,1,0,1,1,1,0,1,1
		BYTE		1,1,0,1,1,1,0,1,1,1,1,0,1,1,1,0
;
COLDAT1A
		BYTE		1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0
		BYTE		1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0
;
COLDAT1B
		BYTE		1,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1
		BYTE		1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0
;
COLDAT1C
		BYTE		1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0
		BYTE		1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0
;
COLDAT1D
		BYTE		1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1
		BYTE		1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0
;
COLDAT1E
		BYTE		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
		BYTE		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
;
COLDAT1F
		BYTE		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
		BYTE		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
;
;************************************************************************
;*		window change						*
;*			in :						*
;*				(R0) <-- data bank			*
;*				(R1) <-- from data address		*
;*				(R2) <-- to data address		*
;*				(R3) <-- counter			*
;*				(R8) <-- center X pos			*
;*				(R9) <--    "   Y  "			*
;************************************************************************
;
CHANGE		EQU	$
		ROMB
;
;-------------- low clear area set ------------------------------
		IWT	R4,#WINDBF+((0D2H-1)*4)
		IWT	R0,#0D2H
		SUB	R9
		TO	R12
		ADD	R0
		IWT	R0,#00FFH	;(R0) <-- clear data
;
		CACHE
;
		MOVE	R13,R15
CHG030
		STW	(R4)
		DEC	R4
		LOOP
		DEC	R4
;
;-------------- change area set ---------------------------------
		MOVE	R14,R1
		INC	R1
		IWT	R4,#DIVBUF	;(R4) <-- div data pointer
		MOVE	R6,R3		;(R6) <-- bairitsu
		TO	R5		;(R5) <-- data.1 high
		GETB
		MOVE	R14,R2
		INC	R2
		TO	R7		;(R7) <-- data.2 high
		GETB
		FROM	R7
		SUB	R5
		SWAP
		FMULT
		ADD	R5
		MOVE	R12,R0		;(R12) <-- loop no. ( data high )
		ADD	R0		;[ ASL ]
		ADD	R4
		LDW	(R0)
		TO	R6
		LSR
		FROM	R5
		SWAP
		FMULT
		TO	R5		;(R5) <-- data.1 step
		ADD	R0
		FROM	R7
		SWAP
		FMULT
		TO	R7		;(R7) <-- data.2 step
		ADD	R0
;
		MOVE	R6,R3		;(R6) <-- bairitsu
		IWT	R0,#WINDBF
		ADD	R9
		ADD	R9
		ADD	R9
		TO	R9		;(R9) <-- window data pointer
		ADD	R9
		DEC	R9		;[-1]
		IBT	R10,#00		;(R10) <-- data.1 add pointer
		MOVE	R11,R10		;(R11) <-- data.2      "
;
		MOVE	R13,R15
CHG010
		FROM	R10
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R14
		ADD	R1
		TO	R4		;(R4) <-- dada.1 right data
		GETBS
		INC	R14
		TO	R3		;(R3) <-- data.1 left data
		GETBS
		INC	R14
		GETBS
		INC	R14
		SMS	R0,CWORK1	;(WK1) <-- no.2 data
		GETBS
		SMS	R0,CWORK0	;(WK0) <-- no.2 data
;
		FROM	R11
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R14
		ADD	R2
		GETBS
		INC	R14
		SUB	R4
		SWAP
		FMULT
		ADD	R4
		ADD	R8
		STB	(R9)		;left data set
		DEC	R9
;
		GETBS
		INC	R14
		SUB	R3
		SWAP
		FMULT
		ADD	R3
		ADD	R8
		STB	(R9)		;right data set
		DEC	R9
;
		GETBS
		INC	R14
		LMS	R4,CWORK1
		SUB	R4
		SWAP
		FMULT
		ADD	R4
		ADD	R8
		STB	(R9)		;left data set
		DEC	R9
;
		GETBS
		LMS	R3,CWORK0
		SUB	R3
		SWAP
		FMULT
		ADD	R3
		ADD	R8
		STB	(R9)		;right data set
;
		WITH	R10
		ADD	R5
		WITH	R11
		ADD	R7
		LOOP
		DEC	R9
;
;-------------- up clear area set -------------------------------
		IWT	R0,#WINDBF-4
		FROM	R9
		SUB	R0
		TO	R12
		LSR
		IWT	R0,#00FFH	;(R0) <-- clear data
		MOVE	R13,R15
CHG020
		DEC	R9
		STW	(R9)
		LOOP
		DEC	R9
;
		STOP
		NOP
;
;************************************************************************
;*		chara change						*
;*			in  : (R0) <-- data bank			*
;*			      (R1) <-- from data address		*
;*			      (R2) <-- to data address			*
;*			      (R3) <-- counter				*
;*			      (R4) <-- vbgwW		*
;*			      (R5) <--	     h	   x h		*
;************************************************************************
;
CCHANGE		EQU	$
		SMS	R0,REG0		;data bank save
		ROMB
		SMS	R3,REG3		;bairitsu save
		SMS	R4,CWORK10	;(CWK10) <-- vbgwW
		SMS	R5,CWORK11	;(CWK11) <--	   h	 x h
;
		SUB	R0		;color mode set
		CMODE
;
;-------------- ram clear ---------------------------------------
		IBT	R0,#040H
		UMULT	R5
		WITH	R4
		UMULT	#4
		ADD	R4
		IWT	R4,#WOB7CHR
		TO	R4
		ADD	R4
;
;;;;		    IWT	    R4,#WOB7CHR+(40H*20H)
		IBT	R5,#(20H*4)/2
		IWT	R6,#200H-20H*4
		IWT	R13,#CCHG02
		IBT	R7,#4
		SUB	R0		;[ IBT R0,#0 ]
;
		CACHE
;
CCHG00
		MOVE	R12,R5
CCHG02
		STW	(R4)
		INC	R4
		LOOP
		INC	R4
;
		WITH	R4
		ADD	R6
		DEC	R7
		BNE	CCHG00+1
		WITH	R5
;
;-------------- change area set ---------------------------------
		MOVE	R14,R1
		GETB
		INC	R14
		GETBH
		INC	R14
		SMS	R0,CWORK0	;(CWK0) <-- from data chara address
		TO	R7		;(R7) <-- data.1 high
		GETB
		INC	R14
		SMS	R14,CWORKC	;(CWKC) <-- from data next address
;
		MOVE	R14,R2
		GETB
		INC	R14
		GETBH
		INC	R14
		SMS	R0,CWORK1	;(CWK1) <-- to data chara address
		TO	R8		;(R8) <-- data.2 high
		GETB
		INC	R14
		SMS	R14,CWORKD	;(CWKD) <-- from data next address
;
		MOVE	R6,R3		;(R6) <-- bairitsu
		FROM	R8
		SUB	R7
		LOB
		SWAP
		FMULT
		ADC	R7
		SMS	R0,REG12	;loop no. ( data high )
		ADD	R0		;[ ASL ]
		IWT	R1,#DIVBUF	;(R4) <-- div data pointer
		ADD	R1
		TO	R6
		LDW	(R0)
		FROM	R7
		LOB
		SWAP
		FMULT
		ADC	#0
		SMS	R0,CWORKA	;(CWKA) <-- data.1 step
		TO	R7
		LSR
		FROM	R8
		LOB
		SWAP
		FMULT
		ADC	#0
		SMS	R0,CWORKB	;(CWKB) <-- data.2 step
		TO	R11
		LSR
;
		LMS	R0,CWORK11
		IBT	R2,#020H-1
		TO	R2		;(R2) <-- plot Y pos
		ADD	R2
;;;;		    IBT	    R2,#40H-1	    ;(R2)  <-- plot Y pos
CCHG10
		LMS	R0,REG0		;data bank set
		ROMB
;
		FROM	R7
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		LMS	R4,CWORKC
		TO	R14
		ADD	R4
		TO	R13
		GETB
		INC	R14
		SMS	R13,CWORK2	;(CWK2) <-- no.2 data
		GETB
		INC	R14
		SMS	R0,CWORK3	;(CWK3) <-- no.2 data
		SUB	R13
		SMS	R0,CWORK4	;(CWK4) <-- no.2 wide
		GETB
		MOVE	R1,R0		;(R1) <-- data.1 left data
		LOB
		TO	R8		;(R8) <-- X pointer
		SWAP
		INC	R14
		TO	R12		;(R12) <--    "   right data
		GETB
		FROM	R12
		SUB	R1
		SMS	R0,CWORK5	;(CWK5) <-- data.1 wide
;
;-------------- no.1 data step calculate ------------------------
		FROM	R11
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		LMS	R5,CWORKD
		TO	R14
		ADD	R5
		TO	R13
		GETB
		INC	R14
		SMS	R13,CWORK6	;(WK6) <-- no.2 data
		GETB
		INC	R14
		SMS	R0,CWORK7	;(WK7) <-- no.2 data
		SUB	R13
		SMS	R0,CWORK8	;(CWK8) <-- no.2 wide
		GETB			;(R0) <--    "   right data
		MOVE	R13,R0
		LOB
		TO	R9		;(R9) <-- X pointer
		SWAP
		INC	R14
		GETB
;
		TO	R6
		SUB	R13
		SMS	R6,CWORK9	;(CWK9) <-- data.2 wide
;
		SUB	R12
		LOB
		SWAP
		LMS	R6,REG3		;(R6) <-- bairitsu
		FMULT
		TO	R12		;(R12) <-- new right X pos
		ADC	R12
		FROM	R13
		SUB	R1
		LOB
		SWAP
		FMULT
		ADC	R1
		WITH	R12		;(R12) <-- new wide
		SUB	R0
		LMS	R1,CWORK10
		TO	R1
		ADD	R1
;
;-------------- no.1 data plot ----------------------------------
		IBT	R0,#BANK CIPCHD ;chara data bank set
		ROMB
;
		IWT	R0,#DIVBUF	;(R0) <-- div data pointer
		ADD	R12
		ADD	R12
		LDW	(R0)
		MOVES	R6,R0
		LMS	R0,CWORK5
		BPL	CCHG12
		NOP
		DEC	R6
		BMI	CCHG14
		NOP
;
CCHG12
		SWAP
		FMULT
CCHG14
		MOVE	R10,R0		;(R10) <-- chara data X step
		LSR
		TO	R8
		ADD	R8
;
		MOVES	R6,R6
		LMS	R0,CWORK9
		BPL	CCHG16
		NOP
		DEC	R6
		BMI	CCHG18
		NOP
;
CCHG16
		SWAP
		FMULT
CCHG18
		MOVE	R5,R0		;(R5) <-- chara data X step
		LSR
		TO	R9
		ADD	R9
;
		LMS	R6,REG3		;(R6) <-- bairitsu
		INC	R12
		MOVE	R13,R15
CCHG20
		FROM	R7
		HIB
		SWAP
		LMS	R3,CWORK0	;(R3) <-- from data chara address
		WITH	R3
		SUB	R0
		FROM	R8
		HIB
		TO	R14
		ADD	R3
		WITH	R8
		ADD	R10
		GETB
		TO	R4		;(R4) <-- data.1 color
		AND	#0FH
;
		FROM	R11
		HIB
		SWAP
		LMS	R3,CWORK1	;(R3) <-- from data chara address
		WITH	R3
		SUB	R0
		FROM	R9
		HIB
		TO	R14
		ADD	R3
		WITH	R9
		ADD	R5
		GETB			;(R0) <-- data.2 color
		AND	#0FH
		SUB	R4
		SWAP
		FMULT
		ADD	R4
		COLOUR			;color set
;
		LOOP
		PLOT
;
;-------------- no.2 data step calculate ------------------------
		LMS	R0,CWORK7
		LMS	R12,CWORK3
		SUB	R12
		LOB
		SWAP
		LMS	R6,REG3		;(R6) <-- bairitsu
		FMULT
		TO	R12
		ADC	R12
		LMS	R0,CWORK6
		TO	R9		;(R9) <-- X pointer
		LOB
		WITH	R9
		SWAP
		LMS	R1,CWORK2
		FROM	R1
		TO	R8		;(R8) <-- X pointer
		LOB
		WITH	R8
		SWAP
		SUB	R1
		LOB
		SWAP
		FMULT
		ADC	R1
		WITH	R12		;(R12) <-- new wide
		SUB	R0
		LMS	R1,CWORK10
		TO	R1
		ADD	R1
;
;-------------- no.2 data plot ----------------------------------
		IWT	R0,#DIVBUF	;(R0) <-- div data pointer
		ADD	R12
		ADD	R12
		LDW	(R0)
		MOVES	R6,R0
		LMS	R0,CWORK4
		BPL	CCHG22
		NOP
		DEC	R6
		BMI	CCHG24
		NOP
;
CCHG22
		SWAP
		FMULT
CCHG24
		MOVE	R10,R0		;(R10) <-- chara data X step
		LSR
		TO	R8
		ADD	R8
;
		MOVES	R6,R6
		LMS	R0,CWORK8
		BPL	CCHG26
		NOP
		DEC	R6
		BMI	CCHG28
		NOP
;
CCHG26
		SWAP
		FMULT
CCHG28
		MOVE	R5,R0		;(R5) <-- chara data X step
		LSR
		TO	R9
		ADD	R9
;
		LMS	R6,REG3		;(R6) <-- bairitsu
		INC	R12
		MOVE	R13,R15
CCHG30
		FROM	R7
		HIB
		SWAP
		LMS	R3,CWORK0	;(R3) <-- from data chara address
		WITH	R3
		SUB	R0
		FROM	R8
		HIB
		TO	R14
		ADD	R3
		WITH	R8
		ADD	R10
		GETB
		TO	R4		;(R4) <-- data.1 color
		AND	#0FH
;
		FROM	R11
		HIB
		SWAP
		LMS	R3,CWORK1	;(R3) <-- from data chara address
		WITH	R3
		SUB	R0
		FROM	R9
		HIB
		TO	R14
		ADD	R3
		WITH	R9
		ADD	R5
		GETB			;(R0) <-- data.2 color
		AND	#0FH
		SUB	R4
		SWAP
		FMULT
		ADD	R4
		COLOUR			;color set
;
		LOOP
		PLOT
;
;-------------- next set ----------------------------------------
		LMS	R0,CWORKA
		TO	R7
		ADD	R7
		LMS	R0,CWORKB
		TO	R11
		ADD	R11
;
		LMS	R0,REG12
		DEC	R0
		SMS	R0,REG12
		BEQ	CCHG40
		DEC	R2
;
		IWT	R15,#CCHG10	;[ JMP CCHG10 ]
		NOP
;
CCHG40
;
;-------------- chara data change -------------------------------
		RPIX
;
		STOP
		NOP
;
;;;;;************************************************************************
;;;;;*		    root ( 32 bit )					    *
;;;;;*			    in	: (R2) <-- root data(L)			    *
;;;;;*				  (R3) <--     "    (H)                     *
;;;;;*			    out : (R4) <-- root result data(decimal)	    *
;;;;;*				  (R5) <--	  "        (integer)        *
;;;;;************************************************************************
;;;;;
;;;;ROOT32	    EQU	    $
;;;;		    CACHE
;;;;;
;;;;		    SUB	    R0		    ;(R0.R1) <-- calculate work
;;;;		    MOVE    R1,R0
;;;;		    MOVE    R4,R0	    ;(R4.R5) <-- root result
;;;;		    MOVE    R5,R0
;;;;		    IBT	    R12,#16+16	    ;(R12)   <-- loop no.
;;;;		    IWT	    R13,#ROT3210+1
;;;;ROT3210
;;;;		    WITH    R4		    ;[ ASL R4.R5 ]
;;;;		    ADD	    R4
;;;;		    WITH    R5
;;;;		    ROL
;;;;		    WITH    R2
;;;;		    ADD	    R2		    ;[ ASL R2.R3 ]
;;;;		    WITH    R3
;;;;		    ROL
;;;;		    ROL			    ;[ ROL R0,R1 ]
;;;;		    WITH    R1
;;;;		    ROL
;;;;		    WITH    R2		    ;[ ASL R2.R3 ]
;;;;		    ADD	    R2
;;;;		    WITH    R3
;;;;		    ROL
;;;;		    ROL			    ;[ ROL R0,R1 ]
;;;;		    WITH    R1
;;;;		    ROL
;;;;;
;;;;		    TO	    R6
;;;;		    SBC	    R4
;;;;		    FROM    R1
;;;;		    TO	    R7
;;;;		    SBC	    R5
;;;;		    BCC	    ROT3220
;;;;		    WITH    R4
;;;;;
;;;;		    ADD	    #2
;;;;		    WITH    R5
;;;;		    ADC	    #0
;;;;		    MOVE    R0,R6
;;;;		    MOVE    R1,R7
;;;;ROT3220
;;;;		    LOOP
;;;;		    WITH    R4
;;;;;
;;;;		    WITH    R5		    ;[ LSR R4,R5 ]
;;;;		    LSR
;;;;		    WITH    R4
;;;;		    ROR
;;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;************************************************************************
;;;;;*		    root ( 16 bit )					    *
;;;;;*			    in	: (R1) <-- root data(L)			    *
;;;;;*			    out : (R2) <-- root result data		    *
;;;;;*					       (low  byte : decimal)	    *
;;;;;*					       (high byte : integer)	    *
;;;;;************************************************************************
;;;;;
;;;;RCALC	    EQU	    $
;;;;		    FROM    R3		    ;(R1) <-- SX^2
;;;;		    TO	    R1
;;;;		    MULT    R3
;;;;		    FROM    R2
;;;;		    MULT    R2		    ;(R0) <-- SY^2
;;;;		    TO	    R1
;;;;		    ADD	    R1		    ;(R1) <-- SZ^2 = SY^2
;;;;;
;;;;ROOT16	    EQU	    $
;;;;		    CACHE
;;;;;
;;;;		    SUB	    R0		    ;(R0) <-- calculate work
;;;;		    MOVE    R2,R0	    ;(R2) <-- root result
;;;;		    IBT	    R12,#8+8	    ;(R12)   <-- loop no.
;;;;		    IWT	    R13,#ROT1610+1
;;;;ROT1610
;;;;		    WITH    R2		    ;[ ASL R2 ]
;;;;		    ADD	    R2
;;;;		    WITH    R1		    ;[ ASL R1 ]
;;;;		    ADD	    R1
;;;;		    ROL			    ;[ ROL R0 ]
;;;;		    WITH    R1		    ;[ ASL R1 ]
;;;;		    ADD	    R1
;;;;		    ROL			    ;[ ROL R0 ]
;;;;;
;;;;		    TO	    R3
;;;;		    SBC	    R2
;;;;		    BCC	    ROT1620
;;;;		    WITH    R2
;;;;;
;;;;		    ADD	    #2
;;;;		    MOVE    R0,R3
;;;;ROT1620
;;;;		    LOOP
;;;;		    WITH    R2
;;;;;
;;;;		    LSR
;;;;;
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*		"mogura" course grass BG3 screen set			*
;*			in  : (R6) <-- convert AND data			*
;*			      (R7) <--	  "    OR   "			*
;*			      (R8) <-- V scroll write start pointer	*
;************************************************************************
;
BG3SCST		EQU	$
;
;-------------- BG3 V scroll screen data set ----------------------------
		IWT	R1,#CBGVSCRBF	;(R1)  <-- BG1 screen data pointer
		IWT	R2,#BG3VSCRBF	;(R2)  <-- BG3	      "
		IWT	R3,#03FFH	;(R3)  <-- chara no. check AND data
		IWT	R4,#0180H	;(R4)  <-- convert top chara no.
		IWT	R5,#0080H	;(R5)  <-- number of convert chara no.
		IWT	R9,#01CEH	;(R9)  <-- nuki chara no.
		IBT	R14,#03EH	;(R14) <-- BG3 screen data set index AND data
;
		CACHE
;
		IBT	R12,#022H/2
		MOVE	R13,R15
BG3S10
		FROM	R2
		TO	R10		;(R10) <-- BG3 screen data set pointer
		ADD	R8
;
		LDW	(R1)		;BG1 screen data load
		MOVE	R11,R0
		AND	R3
		SUB	R4
		BCC	BG3S20		;convert chara no. ? ( no:BG3S20 )
;
		SUB	R5
		BCS	BG3S30		;convert chara no. ? ( no:BG3S30 )
		FROM	R9
;
;-------------- chara no. convert -------------------------------
		FROM	R11
		AND	R6
		BRA	BG3S30
		OR	R7
;
;-------------- nuki chara no. set ------------------------------
BG3S20
		FROM	R9
BG3S30
		STW	(R10)		;BG3 screen data set
		INC	R8
		INC	R8
		WITH	R8
		AND	R14
		INC	R1
		INC	R1
		INC	R1
		LOOP
		INC	R1
;
;-------------- BG3 H scroll screen data set ----------------------------
		IWT	R1,#CBGHSCRBF		;(R1)  <-- BG1 screen data pointer
		IWT	R2,#BG3HSCRBF		;(R2)  <-- BG3	      "
		IWT	R10,#BG3HSCRBF+20H	;(R10) <--	      "
		IBT	R14,#4			;(R14) <-- BG1 screen data pointer add data
;
		IBT	R12,#020H/2
		MOVE	R13,R15
BG3S40
		LDW	(R1)		;BG1 screen data load
		MOVE	R11,R0
		AND	R3
		SUB	R4
		BCC	BG3S50		;convert chara no. ? ( no:BG3S50 )
;
		SUB	R5
		BCS	BG3S50		;convert chara no. ? ( no:BG3S50 )
;
;-------------- chara no. convert -------------------------------
		FROM	R11
		AND	R6
		BRA	BG3S60
		OR	R7
;
;-------------- nuki chara no. set ------------------------------
BG3S50
		MOVE	R0,R9
BG3S60
		STW	(R2)		;BG3 screen data set
		STW	(R10)		;	 "
		WITH	R1
		ADD	R14
		INC	R2
		INC	R2
		INC	R10
		LOOP
		INC	R10
;
		STOP
		NOP
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x									x
;x		color gensan sub					x
;x									x
;x		R1 <--- henkan moto color address set			x
;x		R2 <--- henkan ato color address set			x
;x		R3 <--- gensan color data set				x
;x		R12 <--- henkan color data counter set			x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COLRDEC		EQU	$
		CACHE
;
		IBT	R4,#01FH	; R4 <--- and data set !!
;
		FROM	R3
		TO	R5
		AND	R4		; red color dec. data set !!
;
		FROM	R3
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R6
		AND	R4		; green color dec. data set !!
;
		FROM	R3
		SWAP
		LSR
		LSR
		TO	R7
		AND	R4		; blue color dec. data set !!
;
		MOVE	R13,R15
;
CRC050		EQU	$
		LDB	(R1)
		AND	R4
		SUB	R5		; red color gensan !!
		BPL	CRC100		; plas ?
		NOP			; No !!
;
		SUB	R0		; red color clear set !!
;
CRC100		EQU	$
		MOVE	R8,R0
;
		LDW	(R1)
		LSR
		LSR
		LSR
		LSR
		LSR
		AND	R4
		SUB	R6		; green color gensan !!
		BPL	CRC150		; plas ?
		NOP			; No !!
;
		SUB	R0		; green color clear set !!
;
CRC150		EQU	$
		IBT	R9,#020H
		MULT	R9
		TO	R8
		OR	R8
;
		LDW	(R1)
		SWAP
		LSR
		LSR
		AND	R4
		SUB	R7		; blue color gensan !!
		BPL	CRC200		; plas ?
		NOP			; No !!
;
		SUB	R0		; blue color clear set !!
;
CRC200		EQU	$
		IBT	R9,#004H
		SWAP
		MULT	R9
		OR	R8
		STW	(R2)		; gensan color data set !!
;
		INC	R1
		INC	R1		; moto color data address inc. !!
		INC	R2
		LOOP
		INC	R2		; ato color data address inc. !!
;
		STOP
		NOP
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x									x
;x		tonneal BG_3 kusa chenge sub				x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BG3CHEG		EQU	$
		CACHE
;
		IBT	R0,#1
		CMODE
;
		LM	R6,CWORK0	; R3 <--- char data X_pos set !!
		LM	R3,CWORK1	; R2 <--- moto char data Y_pos set !!
		IBT	R5,#007H	; R5 <--- big loop counter set !!
		IBT	R0,#040H
;
		TO	R4		; R4 <--- ato char data Y_pos set !!
		ADD	R3
;
BCG050		EQU	$
		MOVE	R1,R6
		IBT	R12,#010H
		MOVE	R13,R15
;
BCG100		EQU	$
		MOVE	R2,R3
;
		RPIX
;
		COLOR
;
		MOVE	R2,R4
;
		PLOT
;
		WITH	R1
		ADD	#007H
;
		LOOP
		NOP
;
		WITH	R3
		ADD	#008
;
		WITH	R4
		ADD	#008
;
		MOVE	R1,R6
;
		DEC	R5
		BPL	BCG050
		NOP
;
		RPIX
;
		STOP
		NOP
;
;;;;;************************************************************************
;;;;;*		    program start ( 32x32 ) spacial			    *
;;;;;************************************************************************
;;;;;
;;;;OBJM73X	    EQU	    $
;;;;		    CACHE
;;;;;
;;;;		    LM	    R0,OCHRADR+2    ;chara data address(B)
;;;;		    ROMB
;;;;;
;;;;;-------------- rotation pos calculate --------------------------
;;;;		    LM	    R0,OSCCH
;;;;		    LOB			    ;(R1) <-- SCCH*100H
;;;;		    TO	    R1
;;;;		    SWAP
;;;;		    LM	    R0,OCENTX
;;;;		    TO	    R6
;;;;		    NOT
;;;;		    INC	    R6
;;;;		    LM	    R3,OMATA	    ;R3 <-- MATA
;;;;		    FROM    R3
;;;;		    LMULT
;;;;		    MOVE    R9,R4	    ;R9	 <-- SX*MATA
;;;;		    LM	    R5,OMATC	    ;R5 <-- MATC
;;;;		    FROM    R5
;;;;		    LMULT
;;;;		    MOVE    R10,R4	    ;R10 <--- SX*MATC
;;;;;
;;;;		    LM	    R0,OSCCV
;;;;		    LOB			    ;(R2) <-- SCCV*100H
;;;;		    TO	    R2
;;;;		    SWAP
;;;;		    LM	    R0,OCENTY
;;;;		    TO	    R6
;;;;		    NOT
;;;;		    INC	    R6
;;;;		    LM	    R0,OMATB
;;;;		    TO	    R11
;;;;		    ASR
;;;;		    LMULT
;;;;		    FROM    R4
;;;;		    ADD	    R9
;;;;		    ADD	    R1
;;;;		    TO	    R9		    ;R9 <-- PX
;;;;		    ADD	    R11
;;;;		    LM	    R0,OMATD
;;;;		    TO	    R11
;;;;		    ASR
;;;;		    LMULT
;;;;		    FROM    R4
;;;;		    ADD	    R10
;;;;		    ADD	    R2
;;;;		    TO	    R10		    ;R10 <-- PY
;;;;		    ADD	    R11
;;;;;
;;;;;-------------- plot intial set ---------------------------------
;;;;		    LM	    R0,OCHRADR
;;;;		    LSR			    ;(C) <-- color mode
;;;;		    IBT	    R6,#01H	    ;plot mode set
;;;;		    BCC	    OM73X00	    ;high bit color ? ( no:OM73X00 )
;;;;		    ADD	    R0
;;;;;
;;;;		    IBT	    R6,#05H
;;;;OM73X00
;;;;		    FROM    R6
;;;;		    CMODE		    ;plot mode set
;;;;		    MOVE    R11,R0	    ;R11 <-- chara data address(L,H)
;;;;;
;;;;		    LM	    R6,OBUFXPS	    ;R6 <-- plot start X pos set
;;;;		    LM	    R2,OBUFYPS	    ;R2 <--	"     Y    "
;;;;		    IWT	    R13,#OM73X20
;;;;;
;;;;		    IBT	    R4,#32	    ;R4 <-- Y loop set
;;;;OM73X10
;;;;		    MOVE    R1,R6	    ;R1 <-- plot start X pos set
;;;;		    FROM    R3
;;;;		    ASR
;;;;		    TO	    R8		    ;R8 <-- PX
;;;;		    ADD	    R9
;;;;		    FROM    R5
;;;;		    ASR
;;;;		    TO	    R7		    ;R7 <-- PY
;;;;		    ADD	    R10
;;;;		    IBT	    R12,#32	    ;X loop set
;;;;OM73X20
;;;;		    MERGE
;;;;		    BCC	    OM73X30	    ;area over ? ( no:OM73X30 )
;;;;		    TO	    R14
;;;;;
;;;;		    WITH    R8
;;;;		    ADD	    R3
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    SUB	    R0		    ;[ IBT  R0,#00 ]
;;;;		    BRA	    OM73X40
;;;;		    COLOUR		    ;color set
;;;;;
;;;;OM73X30
;;;;		    ADD	    R11
;;;;;
;;;;		    WITH    R8
;;;;		    ADD	    R3
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    GETC		    ;color set
;;;;OM73X40
;;;;		    LOOP
;;;;		    PLOT		    ;pset
;;;;;
;;;;		    LM	    R0,OMATB
;;;;		    TO	    R9
;;;;		    ADD	    R9
;;;;		    LM	    R0,OMATD
;;;;		    TO	    R10
;;;;		    ADD	    R10
;;;;		    DEC	    R4
;;;;		    BNE	    OM73X10	    ;end ? ( no:OM73X10 )
;;;;		    INC	    R2		    ;Y pos +1
;;;;;
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*		normal OAM clear					*
;************************************************************************
;
OAM_CLR		EQU	$
		CACHE
;
		IWT	R0,#COAM	;(R0)  <-- normal OAM address
		IWT	R1,#0F080H	;(R1)  <--	"     clear X,Y pos data
		IBT	R2,#4		;(R2)  <--	    "         add data
		IWT	R12,#128	;(R12) <-- loop no.
		MOVE	R13,R15
OAMCL010
		FROM	R1
		STW	(R0)
		LOOP
		ADD	R2
;
		MOVE	R1,R0		;(R1)  <-- normal OAM sub address
		IWT	R0,#05555H	;(R0)  <--	  "       clear data
		IBT	R12,#128/8	;(R12) <-- loop no.
		MOVE	R13,R15
OAMCL020
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		spacial zoom window					*
;*			in  : (R0)  <-- window data address(B)		*
;*			      (R5)  <--		 "         (L,H)        *
;*			      (R1)  <--	     "      center X pos        *
;*			      (R2)  <--		"          Y  "		*
;*			      (R3)  <--	   "   display center X pos     *
;*			      (R4)  <--		  "           Y  "	*
;*			      (R6)  <-- zoom flag ( 1.0 = 100H )	*
;************************************************************************
;
SPWINDOW	EQU	$
		ROMB			;window data address(B) set
;
		FROM	R4
		ADD	R4		;[ ASL ]
		ADD	R0		;[ ASL ] x4
		IWT	R4,#WINDBF
		ADD	R4
		MOVE	R10,R0		;(R10) <-- window up   buffer pointer
		TO	R11		;(R11) <--     "  down        "
		ADD	#4
;
		CACHE
;
;-------------- div data calculate ------------------------------
		MOVES	R7,R6
		BNE	SPWD000		;n / 0 ? ( no:SPWD000 )
		SUB	R0		;[ IBT R0,#00 ]
;
;-------------- n / 0 !! --------------------------------
		BRA	SPWD000
		DEC	R7		;[ IWT R7,#0FFFFH ]
;
SPWD000
		MOVE	R7,R0		;(R7) <-- div ans.
		INC	R0		;[ IBT R0,#01 ]
		IBT	R12,#17
		MOVE	R13,R15
SPWD002
		WITH	R7
		ADD	R7		;[ ASL ]
		CMP	R6
		BCC	SPWD004
		NOP
;
		SUB	R6
		INC	R7
SPWD004
		LOOP
		ADD	R0		;[ ASL ]
;
		MOVE	R14,R5
		GETB
		TO	R8		;(R8) <-- Y size
		SWAP
		INC	R5
;
		MOVE	R0,R2		;(R2) <-- up   window data pointer
		WITH	R2
		SWAP
		ADD	#4
		TO	R9		;(R9) <-- down		"
		SWAP
;
;-------------- window up buffer set ----------------------------
SPWD010
		IWT	R0,#WINDBF
		FROM	R10
		SUB	R0
		BMI	SPWD070		;H-DMA buffer up over ? ( yes:SPWD070 )
		NOP
;
		IWT	R4,#0D2H*4
		SUB	R4
		BPL	SPWD050		;H-DMA buffer down over ? ( yes:SPWD050 )
		NOP
;
		FROM	R2
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ] x4
		TO	R14
		ADD	R5
;
		IBT	R12,#4
		MOVE	R13,R15
SPWD020
		GETB
		SUB	R1
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		ADD	R3
		BPL	SPWD030		;min over ? ( no:SPWD030 )
		INC	R14		;go to next window data
;
		SUB	R0		;[ IBT R0,#00 ]
SPWD030
		IWT	R4,#00FFH	;(R11) <-- max data
		CMP	R4
		BCC	SPWD040		;max over ? ( no:SPWD040 )
		NOP
;
		FROM	R4
SPWD040
		STB	(R10)
		LOOP
		INC	R10
;
SPWD050
		WITH	R10
		SUB	#4+4
		WITH	R2
		SUB	R7
		FROM	R2
		SUB	R8
		BCC	SPWD010+1	;window data end ? ( no:SPWD010+1 )
		IWT	R0,#WINDBF	;[ next program dummy ]
;
;-------------- up window clear set -----------------------------
		MOVE	R4,R0
		FROM	R10
		SUB	R0
		BMI	SPWD070		;H-DMA buffer up over ? ( yes:SPWD070 )
		LSR
;
		LSR			;/4
		INC	R0
		TO	R12
		ADD	R0		;[ ASL ] x2
		IWT	R0,#00FFH	;(R0) <-- clear window data
		MOVE	R13,R15
SPWD060
		STW	(R4)
		INC	R4
		LOOP
		INC	R4
;
;-------------- window down buffer set --------------------------
SPWD070
		IWT	R0,#WINDBF+((0D2H-1)*4)
		SUB	R11
		BMI	SPWD130		;H-DMA buffer up over ? ( yes:SPWD130 )
		NOP
;
		IWT	R4,#0D2H*4
		SUB	R4
		BPL	SPWD110		;H-DMA buffer down over ? ( yes:SPWD110 )
		NOP
;
		FROM	R9
		HIB
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ] x4
		TO	R14
		ADD	R5
;
		IBT	R12,#4
		MOVE	R13,R15
SPWD080
		GETB
		SUB	R1
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		ADD	R3
		BPL	SPWD090		;min over ? ( no:SPWD090 )
		INC	R14		;go to next window data
;
		SUB	R0		;[ IBT R0,#00 ]
SPWD090
		IWT	R4,#00FFH	;(R11) <-- max data
		CMP	R4
		BCC	SPWD100		;max over ? ( no:SPWD100 )
		NOP
;
		FROM	R4
SPWD100
		STB	(R11)
		LOOP
		INC	R11
;
SPWD110
		WITH	R9
		ADD	R7
		FROM	R9
		SUB	R8
		BCC	SPWD070+1	;window data end ? ( no:SPWD070+1 )
		IWT	R0,#WINDBF+((0D2H-1)*4)	 ;[ next program dummy ]
;
;-------------- up window clear set -----------------------------
		FROM	R0
		SUB	R11
		BMI	SPWD130		;H-DMA buffer up over ? ( yes:SPWD130 )
		LSR
;
		LSR			;/4
		INC	R0
		TO	R12
		ADD	R0		;[ ASL ] x2
		IWT	R0,#00FFH	;(R0) <-- clear window data
		MOVE	R13,R15
SPWD120
		STW	(R11)
		INC	R11
		LOOP
		INC	R11
;
SPWD130
		STOP
		NOP
;
;************************************************************************
;*		BG3 spacial screen data set				*
;*			in :						*
;*				(R2) <-- scroll counter_V		*
;************************************************************************
;
BG3SCSP		EQU	$
		IWT	R1,#HDMABF0	;(R1)  <-- H-DMA buffer address
		IWT	R3,#07F0H	;(R3)  <--	    "           AND data
		IWT	R4,#0080H	;(R4)  <-- H-DMA max line no
		IBT	R5,#007FH	;(R5)  <--	  "        -1
		IBT	R12,#00H	;(R12) <-- end line check flag
;;;;		    IWT	    R13,#0B2H	    ;(R13) <-- max line no
		IWT	R13,#0D2H	;(R13) <-- max line no
		IWT	R14,#CESCCH1	;(R14) <-- BG1 scroll counter_H address
;
		FROM	R2
		ADD	#8+1		;[ up blanking 8 dot hosei !! ]
		TO	R6		;(R6) <-- BG1 scroll counter_V 0-F dot data
		AND	#0FH
;
		AND	R3
		LSR			;x6
		LSR
		MOVE	R7,R0
		LSR
		ADD	R7
		IWT	R7,#BG3SCBF
		TO	R7		;(R7) <-- BG3 spacial screen data buffer address
		ADD	R7
;
		LDW	(R7)
		MOVE	R8,R0		;(R8) <-- line no
		SUB	R6
		BRA	B3SP011
		CACHE
;
B3SP010
		LDW	(R7)
		MOVE	R8,R0		;(R8) <-- line no
B3SP011
		MOVE	R9,R0		;(R9) <-- set line no
		TO	R12
		ADD	R12
		FROM	R13
		SUB	R12
		BPL	B3SP012		;max line no over ? ( no:B3SP012 )
		TO	R9
;
		ADD	R9
B3SP012
		INC	R7
		INC	R7
		LDW	(R7)
		TO	R10		;(R10) <-- H-DMA data set BG3 scroll counter_V
		ADD	R2
		INC	R7
		INC	R7
		LDW	(R7)		;(R0)  <-- scroll type no.
		ADD	R14
		TO	R11		;(R11) <-- H-DMA data set BG3 scrool counter_H
		LDW	(R0)
		INC	R7
		INC	R7
B3SP020
		FROM	R9
		SUB	R4
		BCC	B3SP030		;line no max over ? ( no:B3SP030 )
		FROM	R5
;
		STB	(R1)		;line no set
		INC	R1
		MOVE	R0,R11
		STB	(R1)		;BG3 scroll counter_H set
		INC	R1
		SWAP
		STB	(R1)		;	    "
		INC	R1
		MOVE	R0,R10
		STB	(R1)		;BG3 scroll counter_V set
		INC	R1
		SWAP
		STB	(R1)		;	    "
		WITH	R9
		SUB	R5
		BRA	B3SP020
		INC	R1
;
B3SP030
		FROM	R9
		STB	(R1)		;line no set
		INC	R1
		MOVE	R0,R11
		STB	(R1)		;BG3 scroll counter_H set
		INC	R1
		SWAP
		STB	(R1)		;	    "
		INC	R1
		MOVE	R0,R10
		STB	(R1)		;BG3 scroll counter_V set
		INC	R1
		SWAP
		STB	(R1)		;	    "
		INC	R1
		DEC	R8
		FROM	R8
		AND	R3
		LSR			;x6
		LSR
		MOVE	R8,R0
		LSR
		ADD	R8
		TO	R7
		ADD	R7
		FROM	R13
		SUB	R12
		DEC	R0
		BPL	B3SP010+1	;max line no over ? ( no:B3SP010+1 )
		LDW	(R7)		;[ next program ]
;
B3SP040
		STOP
		NOP
;
;************************************************************************
;*		BG3 polygon						*
;*			in  : (R1)  <-- scroll counter_H		*
;*			      (R2)  <-- display center Y pos		*
;*			      (R3)  <--		"      Z  "		*
;*			      (R4)  <-- (X)_rotation angle		*
;*			      (R12) <-- polygon data address(B)		*
;*			      (R13) <--		 "          (L,H)       *
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-	polygon data format						-
;-		(point no),(Z1,Y1,XW1),(Z2,Y2,XW2),...(Zn,Yn,XWn)	-
;-		(face no),(color1),(P11),(P12),...(color2)(Pn1)(Pn2)	-
;------------------------------------------------------------------------
;
BG3POLY		EQU	$
		WITH	R2		;(R2) <-- display center Y pos hosei
		SUB	#8
;
;-------------- display check -----------------------------------
		IWT	R0,#0F0H
		TO	R5		;[ IWT R5,#0F0H*2 ]
		ADD	R0
		ADD	R1
		SUB	R5
		BCC	B3POL000	;display ? ( yes:B3POL000 )
		NOP
;
;-------------- not display clear set !! ----------------
		IWT	R3,#HDMABF	;(R3)  <-- H-DMA buffer pointer
;;;;		    IWT	    R12,#0B2H	    ;(R12) <-- loop no
		IWT	R12,#0D2H	;(R12) <-- loop no
		SUB	R0		;[ IBT R0,#0 ]
		IWT	R15,#B3POL112	;[ JMP B3POL112 ]
		DEC	R0		;[ IBT R0,#0FFH ]
;
;-------------- (X)_rotation cos & sin data set -----------------
B3POL000
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		ADD	R4
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R7,R0		;(R7) <-- cos data
;
		IWT	R0,#SIN
		ADD	R4
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R8,R0		;(R8) <-- sin data
;
		SMS	R4,REG4		;(REG4) <-- rotation angle save
;
;-------------- point data rotation -----------------------------
		FROM	R12
		ROMB			;polygon data address(B) set
		MOVE	R14,R13		;	    "        (L,H) set
;
		TO	R12		;(R12) <-- point no
		GETB
		INC	R14
		SMS	R12,REG12	;(REG12) <-- point no.
;
		IWT	R1,#DIVBUF	;(R1) <-- div data pointer
		IBT	R5,#CWORK0	;(R5) <-- object point data buffer pointer
;
		CACHE
;
		MOVE	R13,R15
B3POL010
		GETBS			;(R0) <-- Z pos
		INC	R14
		MOVE	R9,R0		;(R9) <-- Z pos
		MOVE	R6,R7		;(R6) <-- cos data
		LMULT
		MOVE	R10,R4		;(R10) <-- SZ*cos
;
		GETBS			;(R0) <-- Y pos
		INC	R14
		MOVE	R11,R0		;(R11) <-- Y pos
		MOVE	R6,R8		;(R6) <-- sin data
		LMULT			;(R4) <-- SY*sin
		FROM	R10
		ADD	R4
		HIB
		SEX
		ADD	R3		;(R0) <-- object Z pos = SZ*cos+SY*sin+CZ
		ADD	R0		;x2
		ADD	R1
		TO	R10		;(R10) <-- object Z pos mult data
		LDW	(R0)
;
		FROM	R9
		LMULT
		MOVE	R9,R4		;(R9) <-- SZ*sin
		MOVE	R6,R7		;(R6) <-- cos data
		FROM	R11
		LMULT
		FROM	R4
		SUB	R9
		HIB			;(R0) <-- SY*cos-SZ*sin
		SEX
;
		MOVE	R6,R10
		SWAP
		FMULT
		ADD	R2
		STW	(R5)		;object Y pos set
		INC	R5
		INC	R5
;
		GETB			;(R0) <-- X wide
		INC	R14
		SWAP
		FMULT
		ADC	#0
		STW	(R5)		;object X wide set
		INC	R5
;
		LOOP
		INC	R5
;
;-------------- polygon set -------------------------------------
		TO	R1		;(R1) <-- face no
		GETB
		INC	R14
;
		IWT	R11,#DIVBUF	;(R11) <-- div data pointer
B3POL020
		TO	R2		;(R2) <-- face color & angle
		GETB
		INC	R14
;
		GETB
		INC	R14
		ADD	R0
		TO	R8		;(R8) <-- point.1 pointer
		ADD	R0
;
		GETB
		INC	R14
		ADD	R0
		TO	R9		;(R9) <-- point.2 pointer
		ADD	R0
;
;-------------- face display check ----------------------
		TO	R3		;(R3) <-- point.1 Y pos
		LDW	(R8)
		LDW	(R9)
		SUB	R3
		BPL	B3POL022	;face display ? ( yes:B3POL022 )
		INC	R0
;
		IWT	R15,#B3POL060+1 ;[ JMP B3POL060+1 ]
		DEC	R1		;[ dummy ]
;
;-------------- face set --------------------------------
B3POL022
		SMS	R0,REG10	;(REG10) <-- Y move loop no
;
		INC	R8
		INC	R8
		TO	R7		;(R7) <-- XW1
		LDW	(R8)
		INC	R9
		INC	R9
		TO	R8		;(R8) <-- XW2
		LDW	(R9)
;
;-------------- face color set ------------------
		IWT	R0,#0F0H
		AND	R2
		LMS	R4,REG4
		ADD	R4
		ADD	R0		;[ ASL ]
		SWAP
		BPL	B3POL024
		HIB
;
		IWT	R4,#0FFH
		FROM	R4
		SUB	R0
B3POL024
		TO	R4		;(R4) <-- color contrast
		ADD	R0		;[ ASL ]
;
		FROM	R2
		AND	#0FH
		MOVE	R2,R0		;(R2) <-- face color
		ADD	R0
		ADD	R0
		TO	R9
		ADD	R0
		IWT	R0,#MOTOCOL+2
		TO	R10		;(R10) <-- base color pointer
		ADD	R9
		IWT	R0,#DATACOL+2
		TO	R9		;(R9) <-- now color pointer
		ADD	R9
		FROM	R2
		UMULT	#9
		IWT	R6,#POLYCOL
		TO	R6		;(R6) <-- polygon color pointer
		ADD	R6
;
		IBT	R12,#3
		MOVE	R13,R15
B3POL032
		LDB	(R6)
		UMULT	R4
		SWAP
		BPL	B3POL034
		LOB
;
		INC	R0
B3POL034
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R5
		ADD	R0
		INC	R6
		LDB	(R6)
		UMULT	R4
		SWAP
		BPL	B3POL036
		LOB
;
		INC	R0
B3POL036
		OR	R5
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R5
		ADD	R0
		INC	R6
		LDB	(R6)
		UMULT	R4
		SWAP
		BPL	B3POL038
		LOB
;
		INC	R0
B3POL038
		OR	R5
		STW	(R10)		;color set
		STW	(R9)
		INC	R9
		INC	R9
		INC	R10
		INC	R10
		LOOP
		INC	R6
;
;-------------- line step set -------------------
		LMS	R12,REG10
		FROM	R12
		ADD	R12
		ADD	R11
		LDW	(R0)
		TO	R6		;(R6) <-- div data
		LSR			;1/2
		FROM	R8
		SUB	R7
		LOB
		SWAP
		FMULT
		TO	R8		;(R8) <-- XW1-XW2 step
		ROL			;x2
;
		IWT	R4,#0080H	;(R4) <-- XW1-XW2 step calculate buffer
;
		IWT	R0,#HDMABF
		ADD	R3
		TO	R10		;(R10) <-- H-DMA buffer pointer
		ADD	R3
;;;;		    IWT	    R9,#0B2H	    ;(R9) <-- max Y pos
		IWT	R9,#0D2H	;(R9) <-- max Y pos
;
		FROM	R2
		SWAP
		TO	R2		;(R2) <-- face color set data
		LSR			;[ 80H step ]
		MOVE	R13,R15
B3POL040
		MOVES	R0,R3
		BMI	B3POL050	;H-DMA data set ? ( no:B3POL050 )
		SUB	R9
;
		BPL	B3POL060	;H-DMA set end ? ( yes:B3POL060 )
		FROM	R2
;
		SUB	R3
		ADD	R7
		SUB	#8
		STW	(R10)		;H-DMA buffer set
;
B3POL050
		FROM	R4
		ADD	R8
		TO	R4
		LOB
		HIB
		SEX
		TO	R7
		ADD	R7
		INC	R10
		INC	R10
		LOOP
		INC	R3
;
B3POL060
		DEC	R1
		BEQ	B3POL062
		NOP
;
		IWT	R15,#B3POL020+1	 ;[ JMP B3POL020+1 ]
		TO	R2		  ;[ dummy ]
;
B3POL062
;-------------- H-DMA buffer clear area set ---------------------
;;;;		    IWT	    R1,#0B2H-1	    ;(R1) <-- min Y pos
		IWT	R1,#0D2H-1	;(R1) <-- min Y pos
		MOVE	R4,R1		;(R4) <--     "
		IBT	R2,#0FFH	;(R2) <-- max Y pos
		IBT	R3,#CWORK0	;(R3) <-- object point data pointer
		LMS	R12,REG12
		MOVE	R13,R15
B3POL070
		LDW	(R3)
		SUB	R1
		BPL	B3POL080	;new min ? ( no:B3POL080 )
		ADD	R1
;
		MOVE	R1,R0
B3POL080
		SUB	R2
		BMI	B3POL090	;new max ? ( no:B3POL080 )
		ADD	R2
;
		MOVE	R2,R0
B3POL090
		INC	R3
		INC	R3
		INC	R3
		LOOP
		INC	R3
;
;-------------- uper area clear -------------------------
		IWT	R5,#HDMABF	;(R5) <-- H-DMA buffer pointer
		MOVE	R12,R1
		DEC	R1
		BMI	B3POL110+1	;uper area clear ? ( no:B3POL110+1 )
		FROM	R4		;[ to B3POL110 ]
;
		MOVE	R3,R5		;(R3) <-- H-DMA buffer pointer
		IBT	R0,#-8
		MOVE	R13,R15
B3POL100
		DEC	R0
		STW	(R3)
		INC	R3
		LOOP
		INC	R3
;
;-------------- lower area clear ------------------------
B3POL110
		FROM	R4
		SUB	R2
		MOVE	R12,R0
		DEC	R0
		BMI	B3POL130	;lower area clear ? ( no:B3POL130 )
		INC	R2
;
		FROM	R5
		ADD	R2
		TO	R3		;(R3) <-- H-DMA buffer pointer
		ADD	R2
		FROM	R2
		NOT
;
B3POL112
		SUB	#8
		MOVE	R13,R15
B3POL120
		STW	(R3)
		INC	R3
		INC	R3
		LOOP
		DEC	R0
;
B3POL130
		STOP
		NOP
;
;************************************************************************
;*	BG3 polygon OBJ chara set					*
;*		in  : (R10)  <-- chara data address(B)			*
;*		      (R11)  <--	"         (L,H)                 *
;*		      (R1)   <-- OBJ X pos				*
;*		      (R2)   <--  "  Y  "				*
;*		      (R3)   <--  "  Z  "				*
;*		      (R4)   <-- angle					*
;*		out : (CWK0) <-- OBJ set X pos				*
;*		      (CWK1) <--     "   Y  "				*
;************************************************************************
;
POLYCHR		EQU	$
		CACHE
;
		SUB	R0		;color mode set
		CMODE
;
;-------------- chara data buffer clear -------------------------
		IWT	R5,#WOB7CHR+(40H*20H)
		IWT	R6,#(20H*(16-6))
		IWT	R7,#(20H*6)/2
		IWT	R13,#POLCH002
		IBT	R8,#4
		SUB	R0		;[ IBT R0,#00 ]
POLCH000
		MOVE	R12,R7
POLCH002
		STW	(R5)
		INC	R5
		LOOP
		INC	R5
;
		WITH	R5
		ADD	R6
		DEC	R8
		BNE	POLCH000+1
		MOVE	R12,R7		;[ dummy ]
;
;-------------- OBJ Y pos(up) 2D pos calculate ------------------
		IBT	R0,#BANK COS
		ROMB
;
		WITH	R4		;(R4) <-- angle * 2
		ADD	R4
;
		FROM	R2
		TO	R6		;(R6) <-- OBJ Y pos * 100H
		SWAP
;
		IWT	R0,#COS
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R7,R0		;(R7) <-- cos data
		TO	R5		;(R5) <-- rotation OBJ Y pos
		FMULT
;
		IWT	R0,#SIN
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R8,R0		;(R8) <-- sin data
		FMULT
		ADD	R3		;(R0) <-- rotation OBJ Z pos
		ADD	R0		;x2
		IWT	R13,#DIVBUF	;(R13) <-- div data pointer
		ADD	R13
		TO	R6		;(R6) <-- 2D convert size
		LDW	(R0)
;
		IWT	R14,#01800H	;(R14) <-- X wide data * 100H
;
		FROM	R1
		SWAP
		TO	R9		;(R9) <-- 2D convert OBJ X pos(up)
		FMULT
		FROM	R5
		SWAP
		TO	R12		;(R12) <-- 2D convert OBJ Y pos(up)
		FMULT
		SMS	R12,CWORK1	;(CWK1) <-- OBJ set Y pos
		FROM	R14
		FMULT
		ADD	R0		;x2
		ADD	R13
		TO	R6
		LDW	(R0)
		IWT	R0,#02000H
		TO	R5		;(R5) <-- X zoom size(up)
		FMULT
;
;-------------- OBJ Y pos(low) 2D pos calculate -----------------
		IBT	R0,#018H
		ADD	R2
		TO	R6		;(R6) <-- OBJ Y pos(low) * 100H
		SWAP
;
		FROM	R7
;;;;		TO	R4		;(R4) <-- rotation OBJ Y pos
		FMULT
		MOVE	R4,R0		;(R4) <-- rotation OBJ Y pos
;
		FROM	R8
		FMULT
		ADD	R3		;(R0) <-- rotation OBJ Z pos
		ADD	R0		;x2
		ADD	R13
		TO	R6		;(R6) <-- 2D convert size
		LDW	(R0)
;
		FROM	R1
		SWAP
		TO	R1		;(R1) <-- 2D convert OBJ X pos(low)
		FMULT
;
		FROM	R4
		SWAP
		TO	R2		;(R2) <-- 2D convert OBJ Y pos(low)
		FMULT
		FROM	R14
		FMULT
		ADD	R0		;x2
		ADD	R13
		TO	R6
		LDW	(R0)
		IWT	R0,#02000H
		FMULT
		TO	R3		;(R3) <-- X zoom size(low) - X zoom size(up)
		SUB	R5
;
		FROM	R2
		SUB	R12
		DEC	R0
		MOVE	R7,R0		;(R7) <-- chara set ok flag
		BPL	POLCH008	;chara set ok ? ( yes:POLCH008 )
		INC	R0
;
		NOT
		INC	R0
POLCH008
		ADD	R0		;x2
		ADD	R13
		LDW	(R0)
		TO	R6		;(R6) <-- Y wide div data
		LSR
;
		FROM	R3
		LMULT
		TO	R3		;(R3) <-- X zoom size step
		ADC	R0
;
		IBT	R12,#0		;(R12) <-- plot start X pos
		MOVE	R2,R9		;(R2) <-- 2D convert OBJ X pos(up)
		FROM	R1
		SUB	R9		;(R0) <--	  "            wide
		BPL	POLCH010
		TO	R12
;
		NOT
		INC	R12
		WITH	R12
		SWAP
		MOVE	R2,R1
POLCH010
		SMS	R2,CWORK0	;(CWK0) <-- OBJ set X pos
;
		MOVES	R7,R7
		BMI	POLCH050	;chara set ok ? ( no:POLCH050 )
		LOB
;
		SWAP
		FMULT
		TO	R13		;(R13) <-- plot X pos step
		ADC	R0		;x2
;
		IWT	R0,#02000H
		FMULT
		TO	R9		;(R9) <-- Y zoom size step
		ADC	R0		;x2
;
;-------------- character plot ----------------------------------
		FROM	R10
		ROMB			;chara data address(B) set
		MOVE	R6,R11		;(R6) <-- chara data address(L,H)
;
		MOVE	R10,R12		;(R10) <-- plot start X pos
		MOVE	R11,R13		;(R11) <--   "  X pos step
;
		IBT	R2,#020H	;(R2) <-- plot start Y pos
		MOVE	R7,R2		;(R7) <-- chara data Y pointer
		IWT	R13,#POLCH030

		IBT	R4,#32		;(R4) <-- Y loop no
POLCH020
		IBT	R8,#0		;(R8) <-- chara data X pointer
;
		MERGE
		BCS	POLCH050	;area over ? ( no:POLCH050 )
		FROM	R10
;
		TO	R1		;(R1) <-- plot start X pos
		HIB
;
		IBT	R12,#42		;(R12) <-- X loop no
POLCH030
		MERGE
		BCS	POLCH040	;area over ? ( yes:POLCH040 )
		TO	R14
;
		ADD	R6
		WITH	R8
		ADD	R5
		GETC			;color set
;
		LOOP
		PLOT
;
POLCH040
		WITH	R10
		ADD	R11
		WITH	R5
		ADD	R3
;
		WITH	R7
		ADD	R9
;
		DEC	R4
		BNE	POLCH020
		INC	R2
;
POLCH050
		STOP
		NOP
;
;************************************************************************
;*	BG3 polygon OBJ chara set ( "Hira Hira" )			*
;*		in  : (R10)  <-- chara data address(B)			*
;*		      (R11)  <--	 "         (L,H) (front view)   *
;*		      (R12)  <--	 "         (L,H) (back   "  )	*
;*		      (R9)   <-- "Hira Hira" data pointer		*
;*		      (R8)   <-- Y step zoom flag			*
;************************************************************************
;
HIRACHR		EQU	$
		CACHE
;
		SUB	R0		;color mode set
		CMODE
;
		SMS	R11,CWORK0	;(CWK0) <-- front view chara address
		SMS	R12,CWORK1	;(CWK1) <-- back	  "
		SMS	R8,CWORK2	;(CWK2) <-- Y step zoom flag
;
;-------------- chara data buffer clear -------------------------
		IWT	R5,#WOB7CHR+(40H*20H)
		IWT	R6,#(20H*(16-4))
		IWT	R7,#(20H*4)/2
		IWT	R13,#HIRCH002
		IBT	R8,#8
		SUB	R0		;[ IBT R0,#00 ]
HIRCH000
		MOVE	R12,R7
HIRCH002
		STW	(R5)
		INC	R5
		LOOP
		INC	R5
;
		WITH	R5
		ADD	R6
		DEC	R8
		BNE	HIRCH000+1
		MOVE	R12,R7		;[ dummy ]
;
;-------------- "Hira Hira" data address set --------------------
		FROM	R9
		ADD	R9
		ADD	R0
		IWT	R9,#HIRASTEP
		TO	R9		;(R9) <-- "Hira Hira" data address
		ADD	R9
;
		IBT	R4,#32		;(R3) <-- V loop no
		IWT	R5,#4800H	;(R5) <-- plot Y pos buffer
		IBT	R7,#01FH	;(R7) <-- chara data start Y pos
		IWT	R13,#HIRCH020
HIRCH010
;
;-------------- "Hira Hira" data read ---------------------------
		IBT	R0,#BANK HIRASTEP
		ROMB
		MOVE	R14,R9		;(R14) <-- "Hira Hira" data address
		TO	R3		;(R3)  <-- X step
		GETB
		INC	R14
;
		IBT	R12,#32		;(R12) <-- H loop no
		IWT	R6,#DIVBUF	;(R6)  <-- div data pointer
		FROM	R5
		TO	R2		;(R2) <-- plot start Y pos
		HIB
;
		WITH	R3
		GETBH
		INC	R14
;
		FROM	R3
		ADD	R3		;x2
		ADD	R6
		TO	R6		;(R6) <-- div data
		LDW	(R0)
;
		TO	R8		;(R8)  <-- Y step
		GETB
		INC	R14
;
		FROM	R12
		SWAP
		FMULT
		FROM	R12
		SBC	R0
		TO	R1		;(R1) <-- plot start X pos
		LSR
;
		WITH	R8
		GETBH
		INC	R14
		MOVE	R9,R14		;(R9) <-- next "Hira Hira" data address
;
		LMS	R6,CWORK2	;(R6) <-- Y step zoom flag
		FROM	R8
		FMULT
		ADC	R0
		WITH	R5		;plot Y pos up !!
		SUB	R0
;
;-------------- chara data plot ---------------------------------
		MOVES	R8,R8
		BPL	HIRCH012	;front view ? ( yes:HIRCH012 )
		SUB	R0
;
		INC	R0
		INC	R0
HIRCH012
		TO	R11		;(R11) <-- chara address(L,H)
		LDW	(R0)
;
		FROM	R10
		ROMB
		SUB	R0		;[ IBT R0,#0 ]
		MOVE	R8,R0		;(R8) <-- chara data X pos buffer
		WITH	R7		;(R7) <--      "     Y     "
		SWAP
HIRCH020
		MERGE
		BCS	HIRCH030	;chara area over ? ( yes:HIRCH030 )
		TO	R14		;(R14) <-- chara data address
;
		ADD	R11
		WITH	R8		;plot X pos up !!
		ADD	R3
		FROM	R8
		HIB
;
		GETC
		LOOP
		PLOT
;
HIRCH030
		WITH	R7
		SWAP
		DEC	R4
		BNE	HIRCH010
		DEC	R7
;
		RPIX
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-	"Hira Hira" data						-
;------------------------------------------------------------------------
HIRASTEP	EQU	$
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[00]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[04]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[08]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[0C]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[10]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[14]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[18]
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000C0H, 00155H,000C0H  ;[1C]
;
		WORD	00155H,000C0H, 00155H,000C0H, 00155H,000BEH, 00155H,000BCH  ;[20]
		WORD	00155H,000BAH, 00154H,000B6H, 00154H,000B2H, 00153H,000ADH  ;[24]
		WORD	00152H,000A7H, 00152H,000A0H, 00151H,00099H, 00150H,00091H  ;[28]
		WORD	0014FH,00088H, 0014EH,0007FH, 0014DH,00075H, 0014CH,0006BH  ;[2C]
		WORD	0014BH,00060H, 00149H,00054H, 00148H,00048H, 00147H,0003CH  ;[30]
		WORD	00145H,0002FH, 00144H,00022H, 00143H,00015H, 00141H,00008H  ;[34]
		WORD	00140H,0FFFBH, 0013FH,0FFEDH, 0013DH,0FFE0H, 0013CH,0FFD2H  ;[38]
		WORD	0013AH,0FFC4H, 00139H,0FFB7H, 00138H,0FFAAH, 00137H,0FF9DH  ;[3C]
		WORD	00135H,0FF90H, 00134H,0FF84H, 00133H,0FF78H, 00132H,0FF6DH  ;[40]
		WORD	00131H,0FF63H, 00130H,0FF59H, 0012FH,0FF50H, 0012FH,0FF47H  ;[44]
		WORD	0012EH,0FF40H, 0012DH,0FF39H, 0012DH,0FF34H, 0012CH,0FF2FH  ;[48]
		WORD	0012CH,0FF2BH, 0012CH,0FF29H, 0012CH,0FF27H, 0012CH,0FF26H  ;[4C]
;
		WORD	0012CH,0FF26H, 0012CH,0FF27H, 0012CH,0FF28H, 0012BH,0FF2AH  ;[50]
		WORD	0012BH,0FF2DH, 0012BH,0FF30H, 0012AH,0FF34H, 0012AH,0FF3AH  ;[54]
		WORD	00129H,0FF3FH, 00128H,0FF46H, 00128H,0FF4DH, 00127H,0FF55H  ;[58]
		WORD	00126H,0FF5EH, 00125H,0FF67H, 00124H,0FF71H, 00123H,0FF7CH  ;[5C]
		WORD	00122H,0FF87H, 00120H,0FF92H, 0011FH,0FF9FH, 0011EH,0FFABH  ;[60]
		WORD	0011DH,0FFB8H, 0011BH,0FFC6H, 0011AH,0FFD4H, 00118H,0FFE2H  ;[64]
		WORD	00117H,0FFF0H, 00116H,0FFFFH, 00114H,0000DH, 00113H,0001CH  ;[68]
		WORD	00112H,0002BH, 00110H,0003AH, 0010FH,00048H, 0010EH,00057H
		WORD	0010CH,00066H, 0010BH,00074H, 0010AH,00082H, 00109H,0008FH
		WORD	00108H,0009CH, 00107H,000A9H, 00106H,000B5H, 00105H,000C0H
		WORD	00104H,000CAH, 00103H,000D4H, 00102H,000DDH, 00102H,000E5H
		WORD	00101H,000ECH, 00100H,000F2H, 00100H,000F7H, 00100H,000FBH
		WORD	00100H,000FEH, 00100H,00100H, 00100H,00100H		    ;[*81]
;
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H
;
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H, 00100H,00100H, 00100H,00100H, 00100H,00100H
		WORD	00100H,00100H
;
;************************************************************************
;*		BG3 polygon ( Y loop )					*
;*			in  : (R1) <-- big face wide			*
;*			      (R2) <-- small   "                        *
;*			      (R3) <-- angle				*
;*			      (R5) <-- center Y pos			*
;*			      (R7) <-- Y wide				*
;*			      (R8) <-- center X pos			*
;************************************************************************
;
;-------------- initial -------------------------------------------------
BG3POLY1IN	EQU	$
;
;-------------- BG3 wide H-DMA buffer initial clear -------------
		IWT	R4,#HDMABF	;(R4) <-- BG3 wide H-DMA buffer clear !!
		IBT	R0,#-8
;
		CACHE
;
;;;;		    IWT	    R12,#0B2H
		IWT	R12,#0D2H
		MOVE	R13,R15
B3POL1I010
		DEC	R0
		STW	(R4)
		INC	R4
		LOOP
		INC	R4
;
;-------------- scroll counter_H H-DMA buffer initial clear -----
		IWT	R4,#HDMABF1	;(R4) <-- BG3 scroll counter_H H-DMA buffer claer
		SUB	R0		;[ IBT R0,#0 ] initial start code set
		STB	(R4)
;
;-------------- color H-DMA buffer initial clear ----------------
		IWT	R4,#HDMABF1+((1+2)*8)
		STB	(R4)
		IWT	R4,#HDMABF1+((1+2)*8)+(((1+2)*3)*8)
		STB	(R4)
;
;-------------- normal --------------------------------------------------
BG3POLY1	EQU	$
		WITH	R5		;(R5) <_- center Y pos hosei
		SUB	#8
;
;-------------- not display check -------------------------------
		IWT	R0,#0100H
		IWT	R4,#0200H
		ADD	R8
		SUB	R4
		BCS	B3POL1012	;not display ? ( yes:B3POL1012 )
		NOP
;
;-------------- BG3 wide calculate ------------------------------
		IBT	R0,#BANK COS
		ROMB			;cos & sin data bank set
;
		IWT	R0,#COS
		ADD	R3
		TO	R14		;(R14) <-- cos data address
		ADD	R3
		GETB
		INC	R14
		GETBH
		MOVES	R6,R0
		BPL	B3POL1000
		NOT
;
		INC	R0
		MOVE	R6,R0
B3POL1000
		FROM	R1
		LMULT
		MOVE	R1,R4		;(R1) <-- big face rotation wide
;
		IWT	R0,#SIN
		MOVE	R11,R0		;(R11) <-- sin data address
		ADD	R3
		TO	R14
		ADD	R3
		GETB
		INC	R14
		GETBH
		MOVES	R6,R0
		BPL	B3POL1002
		NOT
;
		INC	R0
		MOVE	R6,R0
B3POL1002
		FROM	R2
		LMULT
		FROM	R4
		ADD	R1
		SWAP
		BPL	B3POL1003
		LOB
;
		INC	R0
B3POL1003
		TO	R1		;(R1) <-- big + small face rotation wide
		SUB	#8
;
;-------------- BG3 face muki check -----------------------------
		IWT	R0,#040H
		AND	R3
		ADD	R0
		TO	R2		;(R2) <-- BG3 type ( 000H or 100H )
		ADD	R0
;
;-------------- BG3 wide H-DMA buffer set -----------------------
		MOVE	R12,R7		;(R12) <-- Y wide
;
;-------------- uper over check -------------------------
		MOVES	R0,R5
		BPL	B3POL1010	;from uper over set ? ( no:B3POL1010 )
		CACHE
;
		TO	R12		;(R12) <-- new Y wide
		ADD	R12
		DEC	R12
		BMI	B3POL1012	;not display ? ( yes:B3POL1012 )
		INC	R12
;
		BRA	B3POL1020
		SUB	R0
;
;-------------- lower over check ------------------------
B3POL1010
;;;;		    IWT	    R6,#0B2H	    ;(R6) <-- max Y pos
		IWT	R6,#0D2H	;(R6) <-- max Y pos
		TO	R6
		SUB	R6
		BCC	B3POL1018	;not display ? ( no:B3POL1018 )
		WITH	R6		;[ dummy ]
;
B3POL1012
		STOP
		NOP
;
B3POL1018
;;;;		WITH	R6
		ADD	R12
		DEC	R6
		BMI	B3POL1020	;lower over ? ( no:B3POL1020 )
		INC	R6
;
		WITH	R12
		SUB	R6
;
;-------------- polygon data set ------------------------
B3POL1020
		MOVE	R4,R0		;(R4) <-- set center Y pos
		ADD	R0		;x2
		IWT	R6,#HDMABF
		TO	R6		;(R6) <-- BG3 wide H-DMA buffer pointer
		ADD	R6
;
		FROM	R2
		SUB	R4
		ADD	R1		;(R0) <-- start polygon set data
;
		WITH	R4		;(R4) <-- scroll counter_H H-DMA buffer set Y pos
		ADD	R12
;
		MOVE	R13,R15
B3POL1030
		STW	(R6)
		INC	R6
		INC	R6
		LOOP
		DEC	R0
;
;-------------- scroll counter_H H-DMA buffer set ---------------
;
;-------------- H-DMA data insert pos check -------------
		IWT	R6,#HDMABF1	;(R6) <-- scroll counter_H H-DMA buffer pointer
		IBT	R1,#0		;(R1) <-- H-DMA data Y pos
B3POL1040
		LDB	(R6)
		MOVES	R9,R0
		BEQ	B3POL1050	;end code ? ( yes:B3POL1050 )
		ADD	R1
;
		SUB	R4
		BCS	B3POL1050	;data change ? ( yes:B3POL1050 )
		ADD	R4
;
		MOVE	R1,R0
		INC	R6
		INC	R6
		BRA	B3POL1040
		INC	R6
;
;-------------- insert H-DMA data max line check --------
B3POL1050
		IWT	R10,#HDMABF1+((1+2)*(7-1))-1
;
		WITH	R4		;(R4) <-- line no.1
		SUB	R1
;
		FROM	R4
		SUB	R9
		BNE	B3POL1051	;data delete ? ( no:B3POL1051 )
		FROM	R6
;
		TO	R9		;next data line no add !!
		ADD	#3
		LDB	(R9)
		ADD	R4
		STB	(R9)
		INC	R10
		INC	R10
		BRA	B3POL1052
		INC	R10
;
B3POL1051
		MOVES	R1,R1
		BEQ	B3POL1052	;up data change check ? ( no:B3POL1052 )
		FROM	R4
;
		SUB	R9
		BCS	B3POL1052	;up data change ? ( no:B3POL1052 )
		FROM	R6
;
		TO	R9
		SUB	#2
		MOVE	R0,R8
		STB	(R9)
		INC	R9
		SWAP
		STB	(R9)
;
B3POL1052
		IBT	R9,#7FH
		FROM	R9
		TO	R2
		SUB	R4
		BPL	B3POL1060
		SUB	R0
;
		MOVE	R4,R9
		FROM	R2
		NOT
		INC	R0
		DEC	R10
		DEC	R10
		DEC	R10
B3POL1060
		MOVE	R2,R0		;(R2) <-- line no.2
;
;-------------- H-DMA data move -------------------------
		IWT	R9,#HDMABF1+((1+2)*7)-1
		TO	R12
		FROM	R10
		SUB	R6
		INC	R12
		MOVE	R13,R15
B3POL1070
		LDB	(R10)
		STB	(R9)
		DEC	R10
		LOOP
		DEC	R9
;
;-------------- insert H-DMA data set -------------------
		FROM	R4
		STB	(R6)
		INC	R6
		MOVE	R0,R8
		STB	(R6)
		INC	R6
		SWAP
		STB	(R6)
;
		MOVES	R0,R2
		BEQ	B3POL1080	;line no.2 set ? ( no:B3POL1080 )
		INC	R6
;
		STB	(R6)
		MOVE	R4,R0
		INC	R6
		MOVE	R0,R8
		STB	(R6)
		INC	R6
		SWAP
		STB	(R6)
		INC	R6
;
B3POL1080
		LDB	(R6)		;next line no change !!
		SUB	#0
		BEQ	B3POL1082	;end code ? ( yes:B3POL1082 )
		SUB	R4
;
		STB	(R6)
;
;-------------- color H-DMA buffer set --------------------------
B3POL1082
;
;-------------- light shading calculate -----------------
		SMS	R5,CWORK10	;(CWK10) <-- center Y pos
		SMS	R7,CWORK11	;(CWK11) <-- Y wide
;
		IWT	R9,#POLYCOL	;(R9)  <-- polygon face color buffer pointer
		IBT	R7,#7FH		;(R7)  <-- light shading check data
		IBT	R8,#60H		;(R8)  <--	   "
		IWT	R5,#0FFH	;(R5)  <-- hi-light check data
		IBT	R10,#20H	;(R10) <-- color fade offset data
;
		FROM	R10
		ADD	R3		;(R0)  <-- light vector muki set
;
		IBT	R1,#CWORK0
		IBT	R2,#2
B3POL1090
		MOVE	R3,R0
		AND	R7
		SUB	R8
		BCS	B3POL1100
		SUB	R0
;
		FROM	R3
		LOB
		ADD	R0		;x2
		TO	R14
		ADD	R11
		GETB
		INC	R14
		IWT	R6,#0B0H
		GETBH
		DEC	R0
		BPL	B3POL1092
		INC	R0
;
		NOT
		INC	R0
B3POL1092
		SUB	R5
		BCC	B3POL1094
		ADD	R5
;
		IWT	R6,#0E0H
B3POL1094
		LMULT
		FROM	R4
		HIB
;
B3POL1100
		TO	R6
		ADD	R10
;
		IBT	R12,#3
		MOVE	R13,R15
B3POL1110
		LDB	(R9)
		SWAP
		FMULT
		ADC	#0
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R4
		ADD	R0		;[ ASL ]
;
		INC	R9
		LDB	(R9)
		SWAP
		FMULT
		ADC	R4		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R4
		ADD	R0		;[ ASL ]
;
		INC	R9
		LDB	(R9)
		SWAP
		FMULT
		ADC	R4		;[ ASL ]
		STW	(R1)
		WITH	R1
		ADD	#4
		LOOP
		INC	R9
;
		WITH	R1
		SUB	#4*3-2
		IBT	R0,#40H
		ADD	R3
;
		DEC	R2
		BNE	B3POL1090
		NOP
;
		LMS	R5,CWORK10	;(R5) <-- center Y pos
		LMS	R7,CWORK11	;(R7) <-- Y wide
;
;-------------- H-DMA data set --------------------------
		FROM	R7
		LSR
		LSR
		LSR
		TO	R8		;(R8)  <-- color line no
		LSR
;;;;		    IWT	    R3,#0B1H	    ;(R3)  <-- max line no
		IWT	R3,#0D2H-1	;(R3)  <-- max line no
		IBT	R4,#010H	;(R4)  <-- 1 line no
		IBT	R11,#CWORK0	;(R11) <-- light shading color pointer
B3POL1120
;
;-------------- set data check ------------------
		WITH	R5
		ADD	R4
		DEC	R5
		BPL	B3POL1122	;up over ? ( no:B3POL1122 )
		INC	R5
;
		INC	R11
		IWT	R15,#B3POL1210	;[ JMP B3POL1210 ]
		INC	R11
;
B3POL1122
		FROM	R3
		SUB	R5
		BPL	B3POL1130	;lower over ? ( no:B3POL1130 )
		ADD	R4
;
		BPL	B3POL1130	;set end ? ( no:B3POL1130 )
		NOP
;
		STOP
		NOP
;
;-------------- H-DMA data insert pos check -----
B3POL1130
		IWT	R6,#HDMABF1+((1+2)*8)	;(R6) <-- color H-DMA buffer pointer
		IBT	R1,#0			;(R1) <-- H-DMA data Y pos
B3POL1150
		LDB	(R6)
		MOVES	R9,R0
		BEQ	B3POL1160	;end code ? ( yes:B3POL1160 )
		ADD	R1
;
		SUB	R5
		BCS	B3POL1160	;data change ? ( yes:B3POL1160 )
		ADD	R5
;
		MOVE	R1,R0
		INC	R6
		INC	R6
		BRA	B3POL1150
		INC	R6
;
;-------------- insert H-DMA data max line check -
B3POL1160
		IWT	R12,#HDMABF1+((1+2)*8)+(((1+2)*3)*7)-(1+2)-1
;
		FROM	R5
		TO	R7		;(R7) <-- line no.1
		SUB	R1
;
		FROM	R7
		SUB	R9
		BNE	B3POL1161	;data delete ? ( no:B3POL1161 )
		FROM	R6
;
		TO	R9
		ADD	#3
		LDB	(R9)
		ADD	R7
		STB	(R9)
		INC	R12
		INC	R12
		BRA	B3POL1162
		INC	R12
;
B3POL1161
		MOVES	R1,R1
		BEQ	B3POL1162	;up data change check ? ( no:B3POL1161 )
		FROM	R7
;
		SUB	R4
		BCS	B3POL1162	;up data change ? ( no:B3POL1162 )
		FROM	R6
;
		TO	R10
		SUB	#2
		IBT	R0,#((1+2)*3)*8
		TO	R9
		ADD	R10
		LDW	(R11)
		STB	(R10)
		INC	R10
		SWAP
		STB	(R10)
		FROM	R11
		ADD	#2
		LDW	(R0)
		STB	(R9)
		INC	R9
		SWAP
		STB	(R9)
;
B3POL1162
		MOVE	R10,R12
		IBT	R9,#7FH
		FROM	R9
		TO	R2
		SUB	R7
		BPL	B3POL1170
		SUB	R0
;
		MOVE	R7,R9
		FROM	R2
		NOT
		INC	R0
		DEC	R10
		DEC	R10
		DEC	R10
B3POL1170
		MOVE	R2,R0		;(R2) <-- line no.2
;
;-------------- H-DMA data move -----------------
		SMS	R3,REG3		;(R3) save
		SMS	R5,REG5		;(R5)  "
		SMS	R8,REG8		;(R8)  "
;
		IWT	R9,#HDMABF1+((1+2)*8)+(((1+2)*3)*7)-1
		IBT	R0,#((1+2)*3)*8
		TO	R5		;(R5) <-- (R6)+((1+2)*3)*5
		ADD	R6
		TO	R3		;(R3) <-- (R9)+((1+2)*3)*5
		ADD	R9
		TO	R8		;(R8) <-- (R10)+((1+2)*3)*5
		ADD	R10
		FROM	R10
		TO	R12
		SUB	R6
		INC	R12
		MOVE	R13,R15
B3POL1180
		LDB	(R10)
		STB	(R9)
		LDB	(R8)
		STB	(R3)
		DEC	R10
		DEC	R9
		DEC	R8
		LOOP
		DEC	R3
;
;-------------- insert H-DMA data set -------------------
		MOVE	R0,R7
		STB	(R6)
		STB	(R5)
		INC	R6
		INC	R5
		LDW	(R11)
		MOVE	R9,R0
		STB	(R6)
		INC	R6
		SWAP
		STB	(R6)
		INC	R11
		INC	R11
		LDW	(R11)
		MOVE	R10,R0
		STB	(R5)
		INC	R5
		SWAP
		STB	(R5)
		INC	R6
;
		MOVES	R0,R2
		BEQ	B3POL1190	;line no.2 set ? ( no:B3POL1190 )
		INC	R5
;
		STB	(R6)
		STB	(R5)
		MOVE	R7,R0
		INC	R6
		INC	R5
		MOVE	R0,R9
		STB	(R6)
		INC	R6
		SWAP
		STB	(R6)
		MOVE	R0,R10
		STB	(R5)
		INC	R5
		SWAP
		STB	(R5)
		INC	R6
		INC	R5
;
B3POL1190
		LDB	(R6)		;next line no change !!
		SUB	#0
		BEQ	B3POL1200	;end code ? ( yes:B3POL1200 )
		SUB	R7
;
		STB	(R6)
		STB	(R5)
;
B3POL1200
		LMS	R3,REG3		;(R3) load
		LMS	R5,REG5		;(R5)  "
		LMS	R8,REG8		;(R8)  "
;
B3POL1210
		DEC	R8
		BEQ	B3POL1220
		INC	R11
;
		IWT	R15,#B3POL1120	;[ JMP B3POL1120 ]
		INC	R11
;
B3POL1220
		STOP
		NOP
;
;************************************************************************
;*		map bitmap buffer clear					*
;************************************************************************
;
MPBFCLR		EQU	$
		IWT	R1,#MPBITMAP	;(R1) <-- map bitmap buffer
		IBT	R0,#0
		IWT	R12,#4600H/2
;
		CACHE
;
		MOVE	R13,R15
MPBCL010
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		map bitmap buffer convert				*
;*			in  : (R0)  <-- convert status data address(B)	*
;*			      (R14) <--		      "            (L,H)*
;************************************************************************
;
MPBFCNV		EQU	$
		ROMB			;convert status data address(B) set
		MOVE	R14,R14		;	       "            (L,H) set
;
		IWT	R8,#280H-20H		;(R8)  <-- convert address change data
		IBT	R9,#10H			;(R9)  <-- 1 chara loop no
		IWT	R10,#MPCNVBF		;(R10)	<-- convert data set buffer
		IWT	R13,#MPBCV030
;
		CACHE
;
MPBCV010
		GETB
		INC	R14
		MOVE	R1,R0		;(R1) <-- up convert bitmap buffer pointer
		LSR
		BCS	MPBCV040	;end ? ( yes:MPBCV040 )
		WITH	R1
;
		GETBH
		INC	R14
;
		TO	R2		;(R2) <-- number of chara
		GETB
		INC	R14
;
MPBCV020
		MOVE	R12,R9
MPBCV030
		LDW	(R1)
		STW	(R10)
		INC	R1
		INC	R1
		INC	R10
		LOOP
		INC	R10
;
		WITH	R1
		ADD	R8
;
		DEC	R2
		BNE	MPBCV020+1
		MOVE	R12,R9		;[ dummy ]
;
		BRA	MPBCV010+1
		GETB			;[ dummy ]
;
MPBCV040
		STOP
		NOP
;
;************************************************************************
;*		map mode 7 pars data set				*
;************************************************************************
;
MPPARSST	EQU	$
;
;----------------------------------------------------------------
;-		cos & sin data get				-
;----------------------------------------------------------------
		IBT	R0,#BANK COS
		ROMB
;
		LM	R0,CMPANGLE
		TO	R11		;(R11) <-- angle
		ADD	R0
;
		IWT	R0,#COS
		TO	R14
		ADD	R11
		GETB
		INC	R14
		IWT	R6,#0E8H	;(R6) <-- mode 7 screen zoom flag set
		GETBH
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R1		;(R1) <-- cos data
		OR	R4
;
		IWT	R0,#SIN
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R2		;(R2) <-- sin data
		OR	R4
;
;----------------------------------------------------------------
;-		mode 7 pars data calculate set			-
;----------------------------------------------------------------
MPWT0000
		IBT	R0,#BANK PARSDT
		ROMB
		IWT	R14,#PARSDT	;(R14) <-- pars data address
;
		IWT	R7,#CMPHDMAB0-2 ;(R7)  <-- X cos,sin  data set RAM pointer
		IWT	R8,#CMPHDMAB2-4 ;(R8)  <-- Y -sin,cos	  "
		IBT	R9,#6		;(R9)  <--     "      pointer add data
		IWT	R11,#PARSY	;(R11) <-- Y zoom data
;
		IBT	R12,#70H
;
		CACHE
;
		MOVE	R13,R15
MPWT0002
		GETB
		INC	R14
		INC	R7		;X cos data set RAM pointer up !!
		INC	R7
		WITH	R8
		ADD	R9
		MOVE	R6,R1		;(R6) <-- cos data
		GETBH
		INC	R14
		MOVE	R5,R0		;(R5) <-- pars data
;
		LMULT			;data x cos
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		STW	(R7)		;X cos data set
		INC	R7
		INC	R7
;
		MOVE	R6,R11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		STW	(R8)		;Y cos data set
;
		MOVE	R0,R5		;(R0) <-- pars data
		MOVE	R6,R2		;(R6) <-- sin data
		LMULT			;data x cos
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		MOVE	R6,R0		;(R6) <-- X sin data
;
		NOT
		INC	R0
		DEC	R8
		DEC	R8
		STW	(R8)		;Y -sin data set
;
		FROM	R11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		LOOP
		STW	(R7)		;-sin data set
;
		STOP
		NOP
;
;************************************************************************
;*		map bitmap plot						*
;************************************************************************
;
;-------------- map OBJ name --------------------------------------------
YAMA_H		EQU	01H
YAMA_M		EQU	02H
YAMA_L		EQU	03H
TOWER_T		EQU	04H
TOWER_G		EQU	05H
KAZAN		EQU	06H
SML_YAMA	EQU	07H
DAI		EQU	08H
SML_TOWER	EQU	09H
WID_TOWER	EQU	0AH
MIN_YAMA	EQU	0BH
SAKU		EQU	0CH
YANE		EQU	0DH
HOLL		EQU	0EH
TREE_1		EQU	0FH
TREE_2		EQU	10H
TREE_3		EQU	11H
TREE_4		EQU	12H
TREE_5		EQU	13H
IWA		EQU	14H
KUMO		EQU	15H
LAPUTA		EQU	16H
KEBLE		EQU	17H
KUSA		EQU	18H
FLOWER		EQU	19H
ISHI		EQU	1AH
LOPE		EQU	1BH
SMOKE_1		EQU	1CH
SMOKE_2		EQU	1DH
SMOKE_3		EQU	1EH
SMOKE_4		EQU	1FH
SMOKE_5		EQU	20H
SMOKE_6		EQU	21H
SMOKE_7		EQU	22H
KAMO_1		EQU	23H
KAMO_2		EQU	24H
KAMO_3		EQU	25H
KAMO_4		EQU	26H
KAMO_5		EQU	27H
KAMO_6		EQU	28H
KAMO_7		EQU	29H
KAMO_8		EQU	2AH
PLAYER_01	EQU	2BH
PLAYER_02	EQU	2CH
PLAYER_03	EQU	2DH
PLAYER_04	EQU	2EH
PLAYER_05	EQU	2FH
PLAYER_06	EQU	30H
PLAYER_07	EQU	31H
PLAYER_08	EQU	32H
PLAYER_09	EQU	33H
PLAYER_10	EQU	34H
PLAYER_11	EQU	35H
PLAYER_12	EQU	36H
PLAYER_13	EQU	37H
PLAYER_14	EQU	38H
PLAYER_15	EQU	39H
PLAYER_16	EQU	3AH
PLAYER_17	EQU	3BH
PLAYER_18	EQU	3CH
PLAYER_19	EQU	3DH
PLAYER_20	EQU	3EH
PLAYER_21	EQU	3FH
PLAYER_22	EQU	40H
PLAYER_23	EQU	41H
PLAYER_24	EQU	42H
PLAYER_25	EQU	43H
PLAYER_26	EQU	44H
PLAYER_27	EQU	45H
PLAYER_28	EQU	46H
PLAYER_29	EQU	47H
PLAYER_30	EQU	48H
PLAYER_31	EQU	49H
PLAYER_32	EQU	4AH
PLAYER_33	EQU	4BH
PLAYER_34	EQU	4CH
PLAYER_35	EQU	4DH
PLAYER_36	EQU	4EH
PLAYER_37	EQU	4FH
PLAYER_38	EQU	50H
PLAYER_39	EQU	51H
PLAYER_40	EQU	52H
PLAYER_41	EQU	53H
PLAYER_42	EQU	54H
PLAYER_43	EQU	55H
PLAYER_44	EQU	56H
PLAYER_45	EQU	57H
PLAYER_46	EQU	58H
PLAYER_47	EQU	59H
PLAYER_48	EQU	5AH
AYASHI_H	EQU	5BH
AYASHI_L	EQU	5CH
AYASHI_2	EQU	5DH
BIG_KINOKO	EQU	5EH
SML_KINOKO	EQU	5FH
ZENMAI		EQU	60H
BIG_CRYSTL	EQU	61H
SML_CRYSTL	EQU	62H
ISHI_T_1	EQU	63H
ISHI_T_2	EQU	64H
MIN_TOWER	EQU	65H
KINOKO_2	EQU	66H
KINOKO_3	EQU	67H
KINOKO_4	EQU	68H
KINOKO_6	EQU	69H
KINOKO_7	EQU	6AH
HOLL_MASK	EQU	6BH
AYA_WOD_L	EQU	6CH
AYA_WOD_S	EQU	6DH
IWA_L		EQU	6EH
IWA_S		EQU	6FH
J_TOWR_L	EQU	70H
J_TOWR_S	EQU	71H
GY_TOWR		EQU	72H
KUPA_TOWR	EQU	73H
BOOM_1		EQU	74H
BOOM_2		EQU	75H
BOOM_3		EQU	76H
BOOM_4		EQU	77H
BOOM_5		EQU	78H
BOOM_6		EQU	79H
BOOM_7		EQU	7AH
BOOM_8		EQU	7BH
BOOM_9		EQU	7CH
BOOM_A		EQU	7DH
HATA_01		EQU	7EH
HATA_02		EQU	7FH
HATA_03		EQU	80H
HATA_04		EQU	81H
HATA_05		EQU	82H
HATA_06		EQU	83H
HATA_07		EQU	84H
HATA_08		EQU	85H
HATA_09		EQU	86H
HATA_0A		EQU	87H
HATA_0B		EQU	88H
HATA_0C		EQU	89H
BRK_LPUT	EQU	8AH
YS_FRSH0	EQU	8BH
YS_FRSH1	EQU	8CH
YS_FRSH2	EQU	8DH
YS_FRSH3	EQU	8EH
YS_FRSH4	EQU	8FH
;
;
MPWRITE		EQU	$
;
;----------------------------------------------------------------
;-		cos & sin data get				-
;----------------------------------------------------------------
		IBT	R0,#BANK COS
		ROMB
;
		LM	R0,CMPANGLE
		TO	R11		;(R11) <-- angle
		ADD	R0
;
		IWT	R0,#COS
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		MOVE	R1,R0		;(R1) <-- cos data
;
		IWT	R0,#SIN
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		MOVE	R2,R0		;(R2) <-- sin data
;
;----------------------------------------------------------------
;-		2D convert position calculate			-
;----------------------------------------------------------------
		IBT	R0,#BANK PARSDV
		ROMB
;
		IWT	R9,#CMPOBJXPS	;(R9)  <-- point data pointer
		IWT	R10,#CMPWOBJXPS ;(R10) <-- 2D convert X,Y pos data pointer
		IWT	R11,#CMPWOBJZPS ;(R11) <--	"     Z         "
;
		LM	R12,CMPOBJSTN	;(R12) <-- number of point
;
		CACHE
;
		MOVE	R13,R15		;(R13) <-- loop address
MPWT0010
;
;-------------- position rotation -----------------------
		MOVE	R6,R1		;(R6) <-- cos data
;
		LDB	(R9)
		SEX
		INC	R9
		MOVE	R5,R0		;(R5) <-- X pos
		LMULT
		MOVE	R7,R4		;(R7) <-- (X * cos)
		LDB	(R9)
		SEX
		MOVE	R3,R0		;(R3) <-- Z pos
		LMULT
		MOVE	R8,R4		;(R8) <-- (Z * cos)
;
		MOVE	R6,R2		;(R6) <-- sin data
;
		FROM	R3
		LMULT			;(R4) <-- (Z * sin)
		FROM	R4
		ADD	R7		;(R0) <-- (X * cos) + (Z * sin)
		IWT	R14,#080H
		ADD	R14
		SWAP
		TO	R3		;(R3) <-- rotation X pos
		SEX
;
		FROM	R5
		LMULT			;(R4) <-- (X * sin)
		FROM	R8
		SUB	R4		;(R0) <-- (Z * cos) - (X * sin)
		ADD	R14
		SWAP
		SEX
		IWT	R5,#CENTZ
		ADD	R5
		STB	(R11)		;rotation Z pos set
;
;-------------- 2D pos calculate ------------------------
		ADD	R0
		IWT	R14,#PARSDV
		TO	R14		;(R14) <-- pars div data address
		ADD	R14
;
		INC	R9
		LDB	(R9)
		TO	R7		;(R7) <-- Y pos
		SEX
		BPL	MPWT0011	;chika ? ( no:MPWT0011 )
		INC	R9
;
;-------------- chika Z pos change !! -----------
		FROM	R7
		STB	(R11)
		INC	R7		;[ 0000- <-- FFFF- ]
MPWT0011
		INC	R9
;
		TO	R6		;(R6) <-- pars div data
		GETB
		INC	R14
;
		LM	R0,CMPOBJSTN
		SUB	R12
		INC	R11
		STB	(R11)		;Z pos sort index set
		INC	R11
;
		WITH	R6
		GETBH
;
		FROM	R3
		LOB
		SWAP
		FMULT
		IBT	R4,#20H
		ADD	R4
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		SWAP
		SEX
		IBT	R4,#MPCENTX
		ADD	R4
		STB	(R10)		;2D convert X pos set
		INC	R10
;
		IWT	R0,#PARSYP
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		FMULT
		IWT	R4,#MPCENTY
		ADC	R4
		SUB	R7
		STB	(R10)		;2D convert Y pos set
		INC	R10
;
		INC	R10
		LOOP
		INC	R10
;
;-------------- Z pos sort --------------------------------------
		IWT	R11,#CMPWORK	;(R11) <-- stack pointer
		MOVE	R12,R11		;(R12) <-- search end check data
		IWT	R1,#CMPWOBJZPS	;(R1)  <-- check start pointer
		LM	R0,CMPOBJSTN
		DEC	R0		;[-1]
		ADD	R0		;[x2]
		TO	R2		;(R2)  <--   "   end      "
		ADD	R1
;
		LDB	(R1)		;player Z pos
		DEC	R0
		SBK
MPWT0012
		MOVE	R3,R1		;(R3) <-- (R1)
		MOVE	R4,R2		;(R4) <-- (R2)
		FROM	R1
		ADD	R2
		LSR
		LSR
		ADD	R0
		TO	R5		;(R5) <-- search data
		LDB	(R0)
;
;-------------- max search ------------------------------
MPWT0014
		TO	R7		;(R7) <-- max search data
		LDB	(R3)
		FROM	R5
		SUB	R7
		BCS	MPWT0030	;max search end ? ( yes:MPWT0030 )
		INC	R3
;
MPWT0020
		INC	R3
		TO	R7		;(R7) <-- max search data
		LDB	(R3)
		FROM	R5
		SUB	R7
		BCC	MPWT0020	;max search end ? ( no:MPWT0020 )
		INC	R3
;
MPWT0030
		DEC	R3
;
;-------------- min serach ------------------------------
		LDB	(R4)
		SUB	R5
		BCS	MPWT0050	;min search end ? ( yes:MPWT0050 )
		ADD	R5
;
MPWT0040
		DEC	R4
		DEC	R4
		LDB	(R4)
		SUB	R5
		BCC	MPWT0040	;min search end ? ( no:MPWT0040 )
		ADD	R5
;
MPWT0050
		MOVE	R6,R0		;(R6) <-- min search data
;
;-------------- data change check -----------------------
		FROM	R4
		SUB	R3
		BCC	MPWT0062	;data change ? ( no:MPWT0062 )
		FROM	R7
;
		STB	(R4)
		FROM	R6
		STB	(R3)
		INC	R3
		INC	R4
		TO	R8
		LDB	(R4)
		LDB	(R3)
		STB	(R4)
		FROM	R8
		STB	(R3)
;
		INC	R3
		DEC	R4
		DEC	R4
		DEC	R4
;
MPWT0060
		FROM	R4
		SUB	R3
		BCS	MPWT0014	;next data change check ? ( yes:MPWT0014 )
MPWT0062
		FROM	R1
;
;-------------- data serach stack set check -------------
		SUB	R4
		BCS	MPWT0070	;stack set ? ( no:MPWT0070 )
		FROM	R1
;
		STW	(R11)
		INC	R11
		INC	R11
		FROM	R4
		STW	(R11)
		INC	R11
		INC	R11
;
MPWT0070
		FROM	R3
		SUB	R2
		BCS	MPWT0080	;stack set ? ( no:MPWT0080 )
		FROM	R3
;
		STW	(R11)
		INC	R11
		INC	R11
		FROM	R2
		STW	(R11)
		INC	R11
		INC	R11
MPWT0080
		DEC	R11
		FROM	R11
		SUB	R12
		BCC	MPWT0090	;sort end ? ( yes:MPWT0090 )
		DEC	R11
;
		TO	R2		;(R1) <-- check start pointer
		LDW	(R11)
		DEC	R11
		DEC	R11
		TO	R1		;(R2) <--   "   end      "
		LDW	(R11)
		BRA	MPWT0012+1
		MOVE	R3,R1		;[ dummy ]
;
;-------------- map OBJ write -----------------------------------
MPWT0090
;
;	93/07/26 angle roation delete ( then (R10) free !! )
;
		IWT	R11,#CMPSORTIDX ;(R11) <-- Z pos sort index pointer
;
		LM	R12,CMPOBJSTN	;number of point
;
		CACHE
;
		MOVE	R13,R15
MPWT0100
		IBT	R0,#BANK MPOBJDIN
		ROMB
;
		LDB	(R11)
		ADD	R0		;x4
		ADD	R0		;
		IWT	R1,#CMPWOBJXPS
		TO	R1		;(R1) <-- map OBJ 2D pos pointer
		ADD	R1
		IWT	R2,#CMPOBJTYP
		ADD	R2		;(R0) <-- map OBJ type no. pointer
		LDB	(R0)
		DEC	R0
		BPL	MPWT0102	;set ok OBJ ? ( yes:MPWT0102 )
		ADD	R0		;x2
;
		IWT	R15,#MPWT0140+1 ;[ JMP MPWT0140+1 ]
		INC	R11		;[ dummy ]
;
;-------------- OBJ set ---------------------------------
MPWT0102
		IWT	R14,#MPOBJDIN
		TO	R14		;(R14) <-- map OBJ status data index address
		ADD	R14
		GETB
		INC	R14
;
		SMS	R11,REG11	;(R11) save
		SMS	R12,REG12	;(R12) save
;
		IWT	R7,#080H	;(R7) <-- chara Y wide buffer
;
		GETBH
;
		MOVE	R14,R0		;(R14) <-- map OBJ status data address
;
		TO	R11		;(R11) <-- 2D X pos
		LDB	(R1)
		INC	R1
		TO	R2		;(R2) <-- 2D Y pos
		LDB	(R1)
;
		GETB
		INC	R14
		SBK			;(CMPWOBJYPS) <-- player VS cross check R set
		INC	R1
;
		LDW	(R1)
		LSR
		BNE	MPWT0104	;zoom size ok ? ( yes:MPWT0104 )
		TO	R6		;(R6) <-- zoom size
;
		IWT	R15,#MPWT0134	;[ JMP MPWT0134 ]
		LMS	R11,REG11	;[ dummy ]
;
MPWT0104
		ROL
		GETB			;(R0) <-- to center Y wide
		INC	R14
		SWAP
		FMULT
		TO	R2		;(R2) <-- plot start Y pos
		ADC	R2
;
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R5		;(R5) <-- chara plot step
		LDW	(R0)
;
		GETB
		INC	R14
		TO	R3		;(R3) <-- chara X wide
		SWAP
		WITH	R3
		OR	R7
;
		INC	R0
MPWT0110
		LSR
		SWAP
		FMULT
		FROM	R11
		TO	R12		;(R12) <-- plot start X pos
		SUB	R0
;
		GETB
		INC	R14
		MOVE	R9,R14		;(R9) <-- (R14)
		SWAP
		TO	R7		;(R7) <-- chara Y wide
		ADD	R7
;
		TO	R4
		GETB
		INC	R14
;
		SUB	R0		;[ IBT R0,#0 ]
		MOVE	R8,R0		;(R8) <-- plot mode
;
		WITH	R4
		GETBH
;
		IBT	R0,#BANK MPCIPCHR	;chara data address(B) set
		ROMB
;
		FROM	R4
		LSR
		BCC	MPWT0112	;high bit color ? ( no:MPWT0112 )
		ADD	R0		;[ ASL ]
;
		IBT	R8,#04H
MPWT0112
		FROM	R8
		CMODE			;plot mode set
		MOVES	R4,R0		;(R4)  <-- chara data address
		BPL	MPWT0120+1	;H flip ? ( no:MPWT0120+1 )
;
;-------------- H flip chara data plot ----------
		MOVE	R1,R12		;[ to not H flip quit !! ]
;
		ADD	R0
		TO	R4		;(R4)  <-- chara data address
		LSR
		BEQ	MPWT0118	;<<spacial plot>> ? ( yes:MPWT118 )
		SUB	R0		;[ spacial plot quit !! ]
;
MPWT0114
		MOVE	R1,R12		;(R1) <-- plot start X pos
		IWT	R8,#080H	;(R8) <-- chara X wide
MPWT0116
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		ADD	R5		;(N) <-- end flag
		FROM	R3
		SUB	R8
;
		GETC			;color get
		BPL	MPWT0116
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	MPWT0114
		DEC	R2		;Y pos up !!
;
		BRA	MPWT0132+1
		IBT	R0,#BANK MPOBJDIN	;[ dummy ]
;
;-------------- spacial plot !! -----------------
MPWT0118
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
		COLOUR			;plot color set ( nuki )
		INC	R0		;[ IBT R0,#01H ]
		CMODE			;plot mode set
MPWT01182
		MOVE	R1,R12		;(R1) <-- plot start X pos
		MOVE	R8,R3		;(R8) <-- chara X wide
MPWT01184
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		SUB	R5
;
		GETB
		AND	#0FH
		BEQ	MPWT01186	;plot ? ( no:MPWT01186 )
		INC	R1
;
		DEC	R1
		PLOT			;plot
MPWT01186
		MOVES	R8,R8
		BPL	MPWT01184+1
		MERGE			;[ dummy ]
;
		WITH	R7
		SUB	R5
		BPL	MPWT01182
		DEC	R2		;Y pos up !!
;
		BRA	MPWT0132+1
		IBT	R0,#BANK MPOBJDIN	;[ dummy ]
;
;-------------- chara data plot -----------------
MPWT0120
		MOVE	R1,R12		;(R1) <-- plot start X pos
		MOVE	R8,R3		;(R8) <-- chara X wide
MPWT0130
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		SUB	R5		;(N) <-- end flag
;
		GETC			;color get
		BPL	MPWT0130
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	MPWT0120
		DEC	R2		;Y pos up !!
;
;-------------- next chara set check ------------
MPWT0132
		IBT	R0,#BANK MPOBJDIN
		ROMB
;
		MOVE	R14,R9		;(R14) <-- next status data address
		INC	R14
		INC	R14
		GETB
		INC	R14
		TO	R3		;(R3) <-- chara X wide
		SWAP
		BMI	MPWT0134	;next data nothing ? ( yes:MPWT0134 )
		INC	R0
;
		IWT	R15,#MPWT0110+1 ;[ JMP MPWT0110+1 ]
		LSR			;[ dummy ]
;
MPWT0134
		LMS	R11,REG11	;(R11) load
		LMS	R12,REG12	;(R12) load
;
MPWT0140
		INC	R11
		LOOP
		INC	R11
;
;-------------- last plot cancel ------------------------
		INC	R2
		RPIX
;
;
;-------------- player VS cross check ---------------------------
		IWT	R1,#CMPMVTYP	;(R1)  <-- map OBJ type no. pointer
		IWT	R2,#CMPMVXPS	;(R2)  <--    "    X pos pointer
		IWT	R5,#CMPMVYPS	;(R5)  <--    "    Y      "
		IWT	R3,#CMPWMVYPS	;(R3)  <--    "    cross check R pointer
		LM	R0,CMPPLXPOS
		HIB
		TO	R10		;(R10) <--  "  player X pos
		SEX
		LM	R0,CMPPLZPOS
		HIB
		TO	R11		;(R11) <--	"     Z  "
		SEX
;
		LM	R12,CMPOBJSTN
		DEC	R12
;
		CACHE
;
		MOVE	R13,R15
MPWT0150
		LDB	(R1)
		DEC	R0
		BMI	MPWT0160	;check ok ? ( no:MPWT0160 )
		NOP
;
;;;;		LDB	(R5)
;;;;		DEC	R0
;;;;		BPL	MPWT0160	;Y pos cross ok ? ( no:MPWT0160 )
;;;;		NOP
;
		LDB	(R3)
		MOVES	R6,R0
		BEQ	MPWT0160	;cross check ok ? ( no:MPWT0160 )
		NOP
;
		LMULT
		MOVE	R7,R4		;(R7) <-- cross check R * R
;
		LDB	(R2)
		SEX
		SUB	R10
		MOVE	R8,R0		;(R8) <-- SX
		MOVE	R6,R0
		LMULT			;(R4) <-- SX * SX
		WITH	R7
		SUB	R4
		BCC	MPWT0170	;cross ? ( no:MPWT0170 )
		INC	R2
;
		MOVE	R14,R4		;(R14) <-- SX * SX
		LDB	(R2)
		SEX
		SUB	R11
		MOVE	R9,R0		;(R9) <-- SZ
		MOVE	R6,R0
		LMULT			;(R4) <-- SZ * SZ
		FROM	R4
		SUB	R7
		BCS	MPWT0170+1	;cross ? ( no:MPWT0170+1 )
		INC	R2
;
		BRA	MPWT0180
		WITH	R14		;(R14) <-- ( SX * SX ) + ( SZ * SZ )
;
MPWT0160
		INC	R2
MPWT0170
		INC	R2
		INC	R2
		IBT	R0,#4
		TO	R1
		ADD	R1
		TO	R5
		ADD	R5
		TO	R3
		ADD	R3
		LOOP
		INC	R2
;
		STOP
		NOP
;
;-------------- cross !! --------------------------------
MPWT0180
;;;;		WITH	R14		;(R14) <-- ( SX * SX ) + ( SZ * SZ )
		ADD	R4
;
		LDB	(R1)
		SUB	#HOLL
		BNE	MPWT0182	;holl in ? ( no:MPWT0182 )
		SUB	R0		;(R0)  <-- calculate work
;
;-------------- holl in !! ----------------------
		LM	R0,CMPLMODE
		SUB	#0
		BNE	MPWT0181	;now holl in ? ( yes:MPWT0181 )
		INC	R0
;
		INC	R0
		SBK
MPWT0181
		STOP
		NOP
;
;-------------- player hosei ----------------------------
;
;-------------- sqr -----------------------------
MPWT0182
;;;;		SUB	R0		;(R0)  <-- calculate work
		MOVE	R6,R0		;(R6)  <-- root result
		IBT	R5,#2		;(R5)  <-- add data
		IBT	R12,#8+8	;(R12) <-- loop no.
		IWT	R13,#MPWT0190+1
MPWT0190
		WITH	R6		;[ ASL R6  ]
		ADD	R6
		WITH	R14		;[ ASL R14 ]
		ADD	R14
		ROL			;[ ROL R0  ]
		WITH	R14		;[ ASL R14 ]
		ADD	R14
		ROL			;[ ROL R0  ]
;
		TO	R1
		SBC	R6
		BCC	MPWT0200
		WITH	R6
;
		ADD	R5
		MOVE	R0,R1
MPWT0200
		LOOP
		WITH	R6
;
		LSR
;
		LDB	(R3)		;(R0) <-- cross check R
		ADD	R0		;x2
		IWT	R3,#DIVBUF
		ADD	R3
		LDW	(R0)
		FMULT
		ADD	R0		;x2
		ADD	R3
		TO	R6		;(R6) <-- hosei mult data
		LDW	(R0)
;
		FROM	R9
		SEX
		SWAP
		FMULT
		MOVE	R1,R0
		HIB
		SEX			;(R0) <-- integer add data
		TO	R1
		ADC	R1
		DEC	R2
		LDB	(R2)
		SEX
		SUB	R1
		SWAP
;;;;		SM	R0,CMPPLZPOS
;
		FROM	R8
		SEX
		SWAP
		FMULT
		MOVE	R1,R0
		HIB
		SEX			;(R0) <-- integer add data
		TO	R1
		ADC	R1
		DEC	R2
		LDB	(R2)
		SEX
		SUB	R1
		SWAP
;;;;		SM	R0,CMPPLXPOS
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		map OBJ data						-
;------------------------------------------------------------------------
MPOBJDIN	EQU	$		;[MPOBJTYP]
		WORD	MPOBJDT01	;[01] yama.H
		WORD	MPOBJDT02	;[02]	" .M
		WORD	MPOBJDT03	;[03]	" .L
		WORD	MPOBJDT04	;[04] tower( tea )
		WORD	MPOBJDT05	;[05]	"  ( gray )
		WORD	MPOBJDT06	;[06] kazan
		WORD	MPOBJDT07	;[07] small yama
		WORD	MPOBJDT08	;[08] dai
		WORD	MPOBJDT09	;[09] small tower
		WORD	MPOBJDT0A	;[0A] wide tower
		WORD	MPOBJDT0B	;[0B] mini yama
		WORD	MPOBJDT0C	;[0C] saku
		WORD	MPOBJDT0D	;[0D] yane
		WORD	MPOBJDT0E	;[0E] holl
		WORD	MPOBJDT0F	;[0F] tree.1
		WORD	MPOBJDT10	;[10]	" .2
		WORD	MPOBJDT11	;[11]	" .3
		WORD	MPOBJDT12	;[12]	" .4
		WORD	MPOBJDT13	;[13]	" .5
		WORD	MPOBJDT14	;[14] iwa
		WORD	MPOBJDT15	;[15] kumo
		WORD	MPOBJDT16	;[16] laputa
		WORD	MPOBJDT17	;[17] keble
		WORD	MPOBJDT18	;[18] kusa
		WORD	MPOBJDT19	;[19] flower
		WORD	MPOBJDT1A	;[1A] ishi
		WORD	MPOBJDT1B	;[1B] lope
		WORD	MPOBJDT1C	;[1C] kazan smoke.1
		WORD	MPOBJDT1D	;[1D]	   "     .2
		WORD	MPOBJDT1E	;[1E]	   "     .3
		WORD	MPOBJDT1F	;[1F]	   "     .4
		WORD	MPOBJDT20	;[20]	   "     .5
		WORD	MPOBJDT21	;[21]	   "     .6
		WORD	MPOBJDT22	;[22]	   "     .7
		WORD	MPOBJDT23	;[23] kamome.1
		WORD	MPOBJDT24	;[24]	 "  .2
		WORD	MPOBJDT25	;[25]	 "  .3
		WORD	MPOBJDT26	;[26]	 "  .4
		WORD	MPOBJDT27	;[27]	 "  .5
		WORD	MPOBJDT28	;[28]	 "  .6
		WORD	MPOBJDT29	;[29]	 "  .7
		WORD	MPOBJDT2A	;[2A]	 "  .8
		WORD	MPOBJDT2B	;[2B] player.1
		WORD	MPOBJDT2C	;[2C]	 "  .2
		WORD	MPOBJDT2D	;[2D]	 "  .3
		WORD	MPOBJDT2E	;[2E]	 "  .4
		WORD	MPOBJDT2F	;[2F]	 "  .5
		WORD	MPOBJDT30	;[30]	 "  .6
		WORD	MPOBJDT31	;[31]	 "  .7
		WORD	MPOBJDT32	;[32]	 "  .8
		WORD	MPOBJDT33	;[33]	 "  .9
		WORD	MPOBJDT34	;[34]	 "  .10
		WORD	MPOBJDT35	;[35]	 "  .11
		WORD	MPOBJDT36	;[36]	 "  .12
		WORD	MPOBJDT37	;[37]	 "  .13
		WORD	MPOBJDT38	;[38]	 "  .14
		WORD	MPOBJDT39	;[39]	 "  .15
		WORD	MPOBJDT3A	;[3A]	 "  .16
		WORD	MPOBJDT3B	;[3B]	 "  .17
		WORD	MPOBJDT3C	;[3C]	 "  .18
		WORD	MPOBJDT3D	;[3D]	 "  .19
		WORD	MPOBJDT3E	;[3E]	 "  .20
		WORD	MPOBJDT3F	;[3F]	 "  .21
		WORD	MPOBJDT40	;[40]	 "  .22
		WORD	MPOBJDT41	;[41]	 "  .23
		WORD	MPOBJDT42	;[42]	 "  .24
		WORD	MPOBJDT43	;[43]	 "  .25
		WORD	MPOBJDT44	;[44]	 "  .26
		WORD	MPOBJDT45	;[45]	 "  .27
		WORD	MPOBJDT46	;[46]	 "  .28
		WORD	MPOBJDT47	;[47]	 "  .29
		WORD	MPOBJDT48	;[48]	 "  .30
		WORD	MPOBJDT49	;[49]	 "  .31
		WORD	MPOBJDT4A	;[4A]	 "  .32
		WORD	MPOBJDT4B	;[2B]	 "  .33
		WORD	MPOBJDT4C	;[4C]	 "  .34
		WORD	MPOBJDT4D	;[4D]	 "  .35
		WORD	MPOBJDT4E	;[4E]	 "  .36
		WORD	MPOBJDT4F	;[4F]	 "  .37
		WORD	MPOBJDT50	;[50]	 "  .38
		WORD	MPOBJDT51	;[51]	 "  .39
		WORD	MPOBJDT52	;[52]	 "  .40
		WORD	MPOBJDT53	;[53]	 "  .41
		WORD	MPOBJDT54	;[54]	 "  .42
		WORD	MPOBJDT55	;[55]	 "  .43
		WORD	MPOBJDT56	;[56]	 "  .44
		WORD	MPOBJDT57	;[57]	 "  .45
		WORD	MPOBJDT58	;[58]	 "  .46
		WORD	MPOBJDT59	;[59]	 "  .47
		WORD	MPOBJDT5A	;[5A]	 "  .48
		WORD	MPOBJDT5B	;[5B] ayashii.H
		WORD	MPOBJDT5C	;[5C]	 "   .L
		WORD	MPOBJDT5D	;[5D]	 "   .2
		WORD	MPOBJDT5E	;[5E] big   kinoko
		WORD	MPOBJDT5F	;[5F] small    "
		WORD	MPOBJDT60	;[60] zenmai
		WORD	MPOBJDT61	;[61] big   crystal
		WORD	MPOBJDT62	;[62] small    "
		WORD	MPOBJDT63	;[63] ishi (tea).1
		WORD	MPOBJDT64	;[64]	   "    .2
		WORD	MPOBJDT65	;[65] mini tower
		WORD	MPOBJDT66	;[66] high kinoko.2
		WORD	MPOBJDT67	;[67]	    "    .3
		WORD	MPOBJDT68	;[68]	    "    .4
		WORD	MPOBJDT69	;[69]	    "    .6
		WORD	MPOBJDT6A	;[6A]	    "    .7
		WORD	MPOBJDT6B	;[6B] holl mask
		WORD	MPOBJDT6C	;[6C] d ()
		WORD	MPOBJDT6D	;[6D] d ()
		WORD	MPOBJDT6E	;[6E] ()
		WORD	MPOBJDT6F	;[6F] ()
		WORD	MPOBJDT70	;[70] WO̓ ()
		WORD	MPOBJDT71	;[71]	"       "    ()
		WORD	MPOBJDT72	;[72] O[̓
		WORD	MPOBJDT73	;[73] Nbp
		WORD	MPOBJDT74	;[74] Aj[Vm.P
		WORD	MPOBJDT75	;[75]	"       "	m.Q
		WORD	MPOBJDT76	;[76]	"       "	m.R
		WORD	MPOBJDT77	;[77]	"       "	m.S
		WORD	MPOBJDT78	;[78]	"       "	m.T
		WORD	MPOBJDT79	;[79]	"       "	m.U
		WORD	MPOBJDT7A	;[7A]	"       "	m.V
		WORD	MPOBJDT7B	;[7B]	"       "	m.W
		WORD	MPOBJDT7C	;[7C]	"       "	m.X
		WORD	MPOBJDT7D	;[7D]	"       "	m.`
		WORD	MPOBJDT7E	;[7E] ͂߂ Aj[V m.P
		WORD	MPOBJDT7F	;[7F]	"       "	"       m.Q
		WORD	MPOBJDT80	;[80]	"       "	"       m.R
		WORD	MPOBJDT81	;[81]	"       "	"       m.S
		WORD	MPOBJDT82	;[82]	"       "	"       m.T
		WORD	MPOBJDT83	;[83]	"       "	"       m.U
		WORD	MPOBJDT84	;[84]	"       "	"       m.V
		WORD	MPOBJDT85	;[85]	"       "	"       m.W
		WORD	MPOBJDT86	;[86]	"       "	"       m.X
		WORD	MPOBJDT87	;[87]	"       "	"       m.`
		WORD	MPOBJDT88	;[88]	"       "	"       m.a
		WORD	MPOBJDT89	;[89]	"       "	"       m.b
		WORD	MPOBJDT8A	;[8A] j󂵂̓V
		WORD	MPOBJDT8B	;[8B] bV[ tbV m.O
		WORD	MPOBJDT8C	;[8C]	"       "	  m.P
		WORD	MPOBJDT8D	;[8D]	"       "	  m.Q
		WORD	MPOBJDT8E	;[8E]	"       "	  m.R
		WORD	MPOBJDT8F	;[8F]	"       "	  m.S
;
MPOBJDT01	EQU	$	;[ yama.H ]
;			[VS player cross check R ( 0:not cross ) ]
;			[to center Y wide]
;			[X wide],[Y wide]
;			[chara address]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,01CH-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,017H-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	008H-1,009H-1
		WORD	MPCIPCHR+3641H
		BYTE	0FFH
;
MPOBJDT02	EQU	$	;[ yama.M ]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,01CH-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,008H-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	0FFH
;
MPOBJDT03	EQU	$	;[ yama.L ]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0800H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	0FFH
;
MPOBJDT04	EQU	$	;[ tower( tea ) ]
		BYTE	012H/2
		BYTE	002H
		BYTE	010H-1,020H-1
		WORD	MFCIPCHR+00B0H
		BYTE	0FFH
;
MPOBJDT05	EQU	$	;[ tower( gray ) ]
		BYTE	016H/2
		BYTE	003H
		BYTE	010H-1,020H-1
		WORD	MFCIPCHR+00D0H
		BYTE	0FFH
;
MPOBJDT06	EQU	$	;[ kazan ]
		BYTE	024H/2
		BYTE	007H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+00C1H
		BYTE	0FFH
;
MPOBJDT07	EQU	$	;[ small yama ]
		BYTE	024H/2
		BYTE	005H
		BYTE	020H-1,01BH-1
		WORD	MFCIPCHR+0081H
		BYTE	0FFH
;
MPOBJDT08	EQU	$	;[ dai ]
		BYTE	024H/2
		BYTE	006H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0021H
		BYTE	0FFH
;
MPOBJDT09	EQU	$	;[ small tower ]
		BYTE	00EH/2
		BYTE	001H
		BYTE	008H-1,010H-1
		WORD	MFCIPCHR+0051H
		BYTE	0FFH
;
MPOBJDT0A	EQU	$	;[ wide tower ]
		BYTE	016H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+2071H
		BYTE	0FFH
;
MPOBJDT0B	EQU	$	;[ mini yama ]
		BYTE	012H/2
		BYTE	003H
		BYTE	010H-1,00DH-1
		WORD	MFCIPCHR+0041H
		BYTE	0FFH
;
MPOBJDT0C	EQU	$	;[ saku ]
		BYTE	008H/2
		BYTE	000H
		BYTE	004H-1,004H-1
		WORD	MPCIPCHR+1B61H
		BYTE	0FFH
;
MPOBJDT0D	EQU	$	;[ yorozuya ]
		BYTE	010H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+2061H
		BYTE	0FFH
;
MPOBJDT0E	EQU	$	;[ holl ]
		BYTE	018H/2
		BYTE	003H
		BYTE	020H-1,008H-1
		WORD	MPCIPCHR+5801H
		BYTE	0FFH
;
MPOBJDT0F	EQU	$	;[ tree.1 ]
		BYTE	00EH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+30B1H
		BYTE	0FFH
;
MPOBJDT10	EQU	$	;[ tree.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+20F0H
		BYTE	0FFH
;
MPOBJDT11	EQU	$	;[ tree.3 ]
		BYTE	008H/2
		BYTE	000H
		BYTE	008H-1,00DH-1
		WORD	MPCIPCHR+0071H
		BYTE	0FFH
;
MPOBJDT12	EQU	$	;[ tree.4 ]
		BYTE	008H/2
		BYTE	000H
		BYTE	009H-1,00AH-1
		WORD	MPCIPCHR+0E71H
		BYTE	0FFH
;
MPOBJDT13	EQU	$	;[ tree.5 ]
		BYTE	00EH/2
		BYTE	000H
		BYTE	00FH-1,01BH-1
		WORD	MPCIPCHR+0061H
		BYTE	0FFH
;
MPOBJDT14	EQU	$	;[ iwa ]
		BYTE	012H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+20E0H
		BYTE	0FFH
;
MPOBJDT15	EQU	$	;[ kumo ]
		BYTE	000H/2
		BYTE	008H
		BYTE	018H-1,00FH-1
		WORD	MPCIPCHR+30E0H
		BYTE	0FFH
;
MPOBJDT16	EQU	$	;[ laputa ]
		BYTE	000H/2
		BYTE	00AH
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+00E0H
		BYTE	0FFH
;
MPOBJDT17	EQU	$	;[ keble ]
		BYTE	000H/2
		BYTE	008H
		BYTE	007H-1,009H-1
		WORD	MPCIPCHR+1779H
		BYTE	0FFH
;
MPOBJDT18	EQU	$	;[ kusa ]
		BYTE	000H/2
		BYTE	000H
		BYTE	007H-1,004H-1
		WORD	MPCIPCHR+1B65H
		BYTE	0FFH
;
MPOBJDT19	EQU	$	;[ flower ]
		BYTE	000H/2
		BYTE	000H
		BYTE	005H-1,006H-1
		WORD	MPCIPCHR+007BH
		BYTE	0FFH
;
MPOBJDT1A	EQU	$	;[ ishi ]
		BYTE	00CH/2
		BYTE	001H
		BYTE	006H-1,006H-1
		WORD	MPCIPCHR+067BH
		BYTE	0FFH
;
MPOBJDT1B	EQU	$	;[ lope ]
		BYTE	000H/2
		BYTE	001H
		BYTE	003H-1,003H-1
		WORD	MPCIPCHR+0C7BH
		BYTE	0FFH
;
MPOBJDT1C	EQU	$	;[ kazan smoke.1 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	004H-1,003H-1
		WORD	MPCIPCHR+1A41H
		BYTE	0FFH
;
MPOBJDT1D	EQU	$	;[ kazan smoke.2 ]
		BYTE	000H/2
		BYTE	001H
		BYTE	006H-1,005H-1
		WORD	MPCIPCHR+1A45H
		BYTE	0FFH
;
MPOBJDT1E	EQU	$	;[ kazan smoke.3 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+1A4BH
		BYTE	0FFH
;
MPOBJDT1F	EQU	$	;[ kazan smoke.4 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+1A53H
		BYTE	0FFH
;
MPOBJDT20	EQU	$	;[ kazan smoke.5 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2141H
		BYTE	0FFH
;
MPOBJDT21	EQU	$	;[ kazan smoke.6 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2149H
		BYTE	0FFH
;
MPOBJDT22	EQU	$	;[ kazan smoke.7 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2151H
		BYTE	0FFH
;
MPOBJDT23	EQU	$	;[ kamome.1 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18E0H
		BYTE	0FFH
;
MPOBJDT24	EQU	$	;[ kamome.2 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18E8H
		BYTE	0FFH
;
MPOBJDT25	EQU	$	;[ kamome.3 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18F0H
		BYTE	0FFH
;
MPOBJDT26	EQU	$	;[ kamome.4 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18F8H
		BYTE	0FFH
;
MPOBJDT27	EQU	$	;[ kamome.5 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2841H
		BYTE	0FFH
;
MPOBJDT28	EQU	$	;[ kamome.6 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2849H
		BYTE	0FFH
;
MPOBJDT29	EQU	$	;[ kamome.7 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2851H
		BYTE	0FFH
;
MPOBJDT2A	EQU	$	;[ kamome.8 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2859H
		BYTE	0FFH
;
MPOBJDT2B	EQU	$	;[ player.1 ( <right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20F1H
		BYTE	0FFH
;
MPOBJDT2C	EQU	$	;[ player.2 ( <right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+00EBH
		BYTE	0FFH
;
MPOBJDT2D	EQU	$	;[ player.3 ( <right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+08EBH
		BYTE	0FFH
;
MPOBJDT2E	EQU	$	;[ player.4 ( <right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+10EBH
		BYTE	0FFH
;
MPOBJDT2F	EQU	$	;[ player.5 ( <right> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+18EBH
		BYTE	0FFH
;
MPOBJDT30	EQU	$	;[ player.6 ( <up right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+2059H
		BYTE	0FFH
;
MPOBJDT31	EQU	$	;[ player.7 ( <up right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+00E1H
		BYTE	0FFH
;
MPOBJDT32	EQU	$	;[ player.8 ( <up right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+08E1H
		BYTE	0FFH
;
MPOBJDT33	EQU	$	;[ player.9 ( <up right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+10E1H
		BYTE	0FFH
;
MPOBJDT34	EQU	$	;[ player.10 ( <up rightt> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+18E1H
		BYTE	0FFH
;
MPOBJDT35	EQU	$	;[ player.11 ( <up> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+30F1H
		BYTE	0FFH
;
MPOBJDT36	EQU	$	;[ player.12 ( <up> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20E1H
		BYTE	0FFH
;
MPOBJDT37	EQU	$	;[ player.13 ( <up> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+28E1H
		BYTE	0FFH
;
MPOBJDT38	EQU	$	;[ player.14 ( <up> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+30E1H
		BYTE	0FFH
;
MPOBJDT39	EQU	$	;[ player.15 ( <up> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+38E1H
		BYTE	0FFH
;
MPOBJDT3A	EQU	$	;[ player.16 ( <up left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+2059H
		BYTE	0FFH
;
MPOBJDT3B	EQU	$	;[ player.17 ( <up left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+00E1H
		BYTE	0FFH
;
MPOBJDT3C	EQU	$	;[ player.18 ( <up left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+08E1H
		BYTE	0FFH
;
MPOBJDT3D	EQU	$	;[ player.19 ( <up left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+10E1H
		BYTE	0FFH
;
MPOBJDT3E	EQU	$	;[ player.20 ( <up left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+18E1H
		BYTE	0FFH
;
MPOBJDT3F	EQU	$	;[ player.21 ( <left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20F1H
		BYTE	0FFH
;
MPOBJDT40	EQU	$	;[ player.22 ( <left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+00EBH
		BYTE	0FFH
;
MPOBJDT41	EQU	$	;[ player.23 ( <left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+08EBH
		BYTE	0FFH
;
MPOBJDT42	EQU	$	;[ player.24 ( <left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+10EBH
		BYTE	0FFH
;
MPOBJDT43	EQU	$	;[ player.25 ( <left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+18EBH
		BYTE	0FFH
;
MPOBJDT44	EQU	$	;[ player.26 ( <down left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+28F1H
		BYTE	0FFH
;
MPOBJDT45	EQU	$	;[ player.27 ( <down left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+00F5H
		BYTE	0FFH
;
MPOBJDT46	EQU	$	;[ player.28 ( <down left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+08F5H
		BYTE	0FFH
;
MPOBJDT47	EQU	$	;[ player.29 ( <down left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+0FF5H
		BYTE	0FFH
;
MPOBJDT48	EQU	$	;[ player.30 ( <down left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+17F5H
		BYTE	0FFH
;
MPOBJDT49	EQU	$	;[ player.31 ( <down> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+38F1H
		BYTE	0FFH
;
MPOBJDT4A	EQU	$	;[ player.32 ( <down> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20E9H
		BYTE	0FFH
;
MPOBJDT4B	EQU	$	;[ player.33 ( <down> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+28E9H
		BYTE	0FFH
;
MPOBJDT4C	EQU	$	;[ player.34 ( <down> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+30E9H
		BYTE	0FFH
;
MPOBJDT4D	EQU	$	;[ player.35 ( <down> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+38E9H
		BYTE	0FFH
;
MPOBJDT4E	EQU	$	;[ player.36 ( <down right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28F1H
		BYTE	0FFH
;
MPOBJDT4F	EQU	$	;[ player.37 ( <down right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+00F5H
		BYTE	0FFH
;
MPOBJDT50	EQU	$	;[ player.38 ( <down right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+08F5H
		BYTE	0FFH
;
MPOBJDT51	EQU	$	;[ player.39 ( <down right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+0FF5H
		BYTE	0FFH
;
MPOBJDT52	EQU	$	;[ player.40 ( <down right> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+17F5H
		BYTE	0FFH
;
MPOBJDT53	EQU	$	;[ player.12 ( <up> : walk.5 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20E1H
		BYTE	0FFH
;
MPOBJDT54	EQU	$	;[ player.13 ( <up> : walk.6 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28E1H
		BYTE	0FFH
;
MPOBJDT55	EQU	$	;[ player.14 ( <up> : walk.7 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+30E1H
		BYTE	0FFH
;
MPOBJDT56	EQU	$	;[ player.15 ( <up> : walk.8 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+38E1H
		BYTE	0FFH
;
MPOBJDT57	EQU	$	;[ player.32 ( <down> : walk.5 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20E9H
		BYTE	0FFH
;
MPOBJDT58	EQU	$	;[ player.33 ( <down> : walk.6 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28E9H
		BYTE	0FFH
;
MPOBJDT59	EQU	$	;[ player.34 ( <down> : walk.7 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+30E9H
		BYTE	0FFH
;
MPOBJDT5A	EQU	$	;[ player.35 ( <down> : walk.8 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+38E9H
		BYTE	0FFH
;
MPOBJDT5B	EQU	$	;[ ayashii.H ]
		BYTE	008H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+20A1H
		BYTE	0FFH
;
MPOBJDT5C	EQU	$	;[ ayashii.L ]
		BYTE	006H/2
		BYTE	000H
		BYTE	007H-1,00EH-1
		WORD	MPCIPCHR+12A1H
		BYTE	0FFH
;
MPOBJDT5D	EQU	$	;[ ayashii.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	008H-1,010H-1
		WORD	MPCIPCHR+30F8H
		BYTE	0FFH
;
MPOBJDT5E	EQU	$	;[ big kinoko ]
		BYTE	016H/2
		BYTE	001H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3071H
		BYTE	0FFH
;
MPOBJDT5F	EQU	$	;[ small kinoko ]
		BYTE	00AH/2
		BYTE	000H
		BYTE	00AH-1,009H-1
		WORD	MPCIPCHR+16A7H
		BYTE	0FFH
;
MPOBJDT60	EQU	$	;[ zenmai ]
		BYTE	008H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+1871H
		BYTE	0FFH
;
MPOBJDT61	EQU	$	;[ big crystal ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	008H-1,00BH-1
		WORD	MPCIPCHR+00A9H
		BYTE	0FFH
;
MPOBJDT62	EQU	$	;[ small crystal ]
		BYTE	008H/2
		BYTE	000H
		BYTE	005H-1,005H-1
		WORD	MPCIPCHR+304FH
		BYTE	0FFH
;
MPOBJDT63	EQU	$	;[ ishi (tea).1 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	007H-1,006H-1
		WORD	MPCIPCHR+3041H
		BYTE	0FFH
;
MPOBJDT64	EQU	$	;[ ishi (tea).2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	006H-1,006H-1
		WORD	MPCIPCHR+3049H
		BYTE	0FFH
;
MPOBJDT65	EQU	$	;[ mini tower ]
		BYTE	00AH/2
		BYTE	000H
		BYTE	007H-1,008H-1
		WORD	MPCIPCHR+3641H
		BYTE	0FFH
;
MPOBJDT66	EQU	$	;[ high kinoko.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT67	EQU	$	;[ high kinoko.3 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT68	EQU	$	;[ high kinoko.4 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT69	EQU	$	;[ high kinoko.6 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT6A	EQU	$	;[ high kinoko.7 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT6B	EQU	$	;[ holl mask ]
		BYTE	000H/2
		BYTE	005H
		BYTE	028H-1,01EH-1
		WORD	MFCIPCHR+0000H
		BYTE	0FFH
;
MPOBJDT6C	EQU	$	;[d ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+4000H
		BYTE	0FFH
;
MPOBJDT6D	EQU	$	;[d ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+5010H
		BYTE	0FFH
;
MPOBJDT6E	EQU	$	;[ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40E1H
		BYTE	0FFH
;
MPOBJDT6F	EQU	$	;[()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+4010H
		BYTE	0FFH
;
MPOBJDT70	EQU	$	;[ WO̓ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+00C0H
		BYTE	0FFH
;
MPOBJDT71	EQU	$	;[ WO̓ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,016H-1
		WORD	MPCIPCHR+2AF9H
		BYTE	0FFH
;
MPOBJDT72	EQU	$	;[ O[̓ ]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+20B0H
		BYTE	0FFH
;
MPOBJDT73	EQU	$	;[ Nbp  ]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4020H
		BYTE	0FFH
;
MPOBJDT74	EQU	$	;[Aj[Vm.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0040H
		BYTE	0FFH
;
MPOBJDT75	EQU	$	;[Aj[Vm.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0001H
		BYTE	0FFH
;
MPOBJDT76	EQU	$	;[Aj[Vm.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2001H
		BYTE	0FFH
;
MPOBJDT77	EQU	$	;[Aj[Vm.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2021H
		BYTE	0FFH
;
MPOBJDT78	EQU	$	;[Aj[Vm.T]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2081H
		BYTE	0FFH
;
MPOBJDT79	EQU	$	;[Aj[Vm.U]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+20C1H
		BYTE	0FFH
;
MPOBJDT7A	EQU	$	;[Aj[Vm.V]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4001H
		BYTE	0FFH
;
MPOBJDT7B	EQU	$	;[Aj[Vm.W]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4021H
		BYTE	0FFH
;
MPOBJDT7C	EQU	$	;[Aj[Vm.X]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3080H
		BYTE	0FFH
;
MPOBJDT7D	EQU	$	;[Aj[Vm.`]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3090H
		BYTE	0FFH
;
MPOBJDT7E	EQU	$	;[͂߂ Aj[V m.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,008H-1
		WORD	MFCIPCHR+5880H
		BYTE	0FFH
;
MPOBJDT7F	EQU	$	;[͂߂ Aj[V m.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,010H-1
		WORD	MFCIPCHR+4080H
		BYTE	0FFH
;
MPOBJDT80	EQU	$	;[͂߂ Aj[V m.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MFCIPCHR+48C0H
		BYTE	0FFH
;
MPOBJDT81	EQU	$	;[͂߂ Aj[V m.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+40E0H
		BYTE	0FFH
;
MPOBJDT82	EQU	$	;[͂߂ Aj[V m.T]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+4060H
		BYTE	0FFH
;
MPOBJDT83	EQU	$	;[͂߂ Aj[V m.U]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+4040H
		BYTE	0FFH
;
MPOBJDT84	EQU	$	;[͂߂ Aj[V m.V]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+20C0H
		BYTE	0FFH
;
MPOBJDT85	EQU	$	;[͂߂ Aj[V m.W]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+0060H
		BYTE	0FFH
;
MPOBJDT86	EQU	$	;[͂߂ Aj[V m.X]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2040H
		BYTE	0FFH
;
MPOBJDT87	EQU	$	;[͂߂ Aj[V m.`]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2060H
		BYTE	0FFH
;
MPOBJDT88	EQU	$	;[͂߂ Aj[V m.a]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2000H
		BYTE	0FFH
;
MPOBJDT89	EQU	$	;[͂߂ Aj[V m.b]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2020H
		BYTE	0FFH
;
MPOBJDT8A	EQU	$	;[j󂵂̓V]
		BYTE	000H/2
		BYTE	00AH
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4081H
		BYTE	0FFH
;
MPOBJDT8B	EQU	$	;[bV[ tbV m.O]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40C1H
		BYTE	0FFH
;
MPOBJDT8C	EQU	$	;[bV[ tbV m.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40A0H
		BYTE	0FFH
;
MPOBJDT8D	EQU	$	;[bV[ tbV m.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4041H
		BYTE	0FFH
;
MPOBJDT8E	EQU	$	;[bV[ tbV m.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4061H
		BYTE	0FFH
;
MPOBJDT8F	EQU	$	;[bV[ tbV m.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40A1H
		BYTE	0FFH
;
;
;------------------------------------------------------------------------
;-		map pars data						-
;------------------------------------------------------------------------
PARSY		EQU	0300H
PARSDT		EQU	$
		WORD	00120H,0011FH,0011FH,0011EH,0011DH,0011CH,0011CH,0011BH
		WORD	0011AH,0011AH,00119H,00118H,00117H,00117H,00116H,00115H
		WORD	00115H,00114H,00113H,00113H,00112H,00111H,00111H,00110H
		WORD	0010FH,0010FH,0010EH,0010DH,0010DH,0010CH,0010CH,0010BH
		WORD	0010AH,0010AH,00109H,00108H,00108H,00107H,00107H,00106H
		WORD	00105H,00105H,00104H,00104H,00103H,00102H,00102H,00101H
		WORD	00101H,00100H,000FFH,000FFH,000FEH,000FEH,000FDH,000FDH
		WORD	000FCH,000FBH,000FBH,000FAH,000FAH,000F9H,000F9H,000F8H
		WORD	000F8H,000F7H,000F6H,000F6H,000F5H,000F5H,000F4H,000F4H
		WORD	000F3H,000F3H,000F2H,000F2H,000F1H,000F1H,000F0H,000F0H
		WORD	000EFH,000EFH,000EEH,000EEH,000EDH,000EDH,000ECH,000ECH
		WORD	000EBH,000EBH,000EAH,000EAH,000E9H,000E9H,000E8H,000E8H
		WORD	000E7H,000E7H,000E6H,000E6H,000E5H,000E5H,000E5H,000E4H
		WORD	000E4H,000E3H,000E3H,000E2H,000E2H,000E1H,000E1H,000E0H
;
PARSYP		EQU	01B9H
CENTZ		EQU	080H
PARSDV		EQU	$
		WORD	0468FH,04680H,04672H,04663H,04654H,04645H,04637H,04628H
		WORD	04619H,0460BH,045FCH,045EEH,045DFH,045D1H,045C2H,045B4H
		WORD	045A5H,04597H,04588H,0457AH,0456CH,0455DH,0454FH,04541H
		WORD	04533H,04524H,04516H,04508H,044FAH,044ECH,044DDH,044CFH
		WORD	044C1H,044B3H,044A5H,04497H,04489H,0447BH,0446DH,0445FH
		WORD	04451H,04444H,04436H,04428H,0441AH,0440CH,043FEH,043F1H
		WORD	043E3H,043D5H,043C8H,043BAH,043ACH,0439FH,04391H,04383H
		WORD	04376H,04368H,0435BH,0434DH,04340H,04332H,04325H,04318H
		WORD	0430AH,042FDH,042F0H,042E2H,042D5H,042C8H,042BAH,042ADH
		WORD	042A0H,04293H,04286H,04278H,0426BH,0425EH,04251H,04244H
		WORD	04237H,0422AH,0421DH,04210H,04203H,041F6H,041E9H,041DCH
		WORD	041CFH,041C2H,041B5H,041A9H,0419CH,0418FH,04182H,04175H
		WORD	04169H,0415CH,0414FH,04143H,04136H,04129H,0411DH,04110H
		WORD	04103H,040F7H,040EAH,040DEH,040D1H,040C5H,040B8H,040ACH
		WORD	0409FH,04093H,04087H,0407AH,0406EH,04061H,04055H,04049H
		WORD	0403DH,04030H,04024H,04018H,0400CH,03FFFH,03FF3H,03FE7H
		WORD	03FDBH,03FCFH,03FC3H,03FB7H,03FAAH,03F9EH,03F92H,03F86H
		WORD	03F7AH,03F6EH,03F62H,03F56H,03F4BH,03F3FH,03F33H,03F27H
		WORD	03F1BH,03F0FH,03F03H,03EF7H,03EECH,03EE0H,03ED4H,03EC8H
		WORD	03EBDH,03EB1H,03EA5H,03E9AH,03E8EH,03E82H,03E77H,03E6BH
		WORD	03E60H,03E54H,03E48H,03E3DH,03E31H,03E26H,03E1AH,03E0FH
		WORD	03E03H,03DF8H,03DEDH,03DE1H,03DD6H,03DCAH,03DBFH,03DB4H
		WORD	03DA8H,03D9DH,03D92H,03D87H,03D7BH,03D70H,03D65H,03D5AH
		WORD	03D4EH,03D43H,03D38H,03D2DH,03D22H,03D17H,03D0CH,03D00H
		WORD	03CF5H,03CEAH,03CDFH,03CD4H,03CC9H,03CBEH,03CB3H,03CA8H
		WORD	03C9DH,03C93H,03C88H,03C7DH,03C72H,03C67H,03C5CH,03C51H
		WORD	03C46H,03C3CH,03C31H,03C26H,03C1BH,03C11H,03C06H,03BFBH
		WORD	03BF0H,03BE6H,03BDBH,03BD0H,03BC6H,03BBBH,03BB1H,03BA6H
		WORD	03B9BH,03B91H,03B86H,03B7CH,03B71H,03B67H,03B5CH,03B52H
		WORD	03B47H,03B3DH,03B32H,03B28H,03B1EH,03B13H,03B09H,03AFEH
		WORD	03AF4H,03AEAH,03ADFH,03AD5H,03ACBH,03AC0H,03AB6H,03AACH
		WORD	03AA2H,03A98H,03A8DH,03A83H,03A79H,03A6FH,03A65H,03A5AH
;
MPCENTX		EQU	0E0H/2
MPCENTY		EQU	(070H+31H)-PARSYP-28H
;
;
;
;
;
;
;
;
;************************************************************************
;*		M-chip RAM clear					*
;*			in  : (R1)  <-- clear RAM start address		*
;*			      (R12) <--		   "     size ( word )  *
;************************************************************************
;
MRAM_CLR	EQU	$
		SUB	R0		;[ IBT R0,#0 ]
;
		CACHE
;
		MOVE	R13,R15
MRMCL010
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		moji polygon RAM convert				*
;*			in  : (R1) <-- convert RAM from start address	*
;*			      (R2) <-- convert RAM to start address	*
;*			      (R3) <-- 1 block number of word		*
;*			      (R4) <-- number of block			*
;************************************************************************
;
MJRAMCNV	EQU	$
		IWT	R0,#16*20H
		SUB	R3
		TO	R5		;(R5) <-- from address add data
		SUB	R3
;
		CACHE
;
		IWT	R13,#MRCNV020
MRCNV010
		MOVE	R12,R3
MRCNV020
		LDW	(R1)
		STW	(R2)
		INC	R1
		INC	R1
		INC	R2
		LOOP
		INC	R2
;
		WITH	R1
		ADD	R5
;
		DEC	R4
		BNE	MRCNV010+1
		MOVE	R12,R3		;[dummy]
;
		STOP
		NOP
;
;
;************************************************************************
;*									*
;*	xnrgh cnnq lnud					*
;*					Programmed by  Y. Yamamoto.	*
;*						Jul. 14(Wed), JST 1993	*
;*								Ver 0.00*
;************************************************************************
DOR_ADR		EQU		CIPCHD3 + 6000H
DOR_ADR_B	EQU		BANK DOR_ADR
DOR_YS		EQU		020H - 1
DOR_XS		EQU		010H - 1
DOR_COS		EQU		COS + 002H
DOR_COS_B	EQU		8		;BANK DOR_COS
DOR_NDT		EQU		DIVBUF		;1/n DATA
;
;
DOOR_MV		EQU		$
		ROMB
;
		CACHE
		LM		R0, CWORK1	;R1 = Y * 40H + X * 10H
		ADD		R0
		MULT		#8
		LM		R1, CWORK0
		ADD		R1
		MULT		#4
		IWT		R1, #WOB7CHR
		TO		R1
		ADD		R1
		mCHAR_CLR_4X	R1, 4, R2, R3, R4, R5
		mROMB		DOR_COS_B	;COS DATA ROM BANK SET
;
;;;;		    IWT		    R9, #DOR_ADR
		IWT		R1,#DOR_COS	;DOOR COS DATA
		IWT		R2,#DOR_NDT	;DOOR 1/n DATA
		FROM		R10		;DOOR KAKUDO
		ADD		R10		;COS DATA = DOR_RAD * 2 + DOR_COS
		TO		R14
		ADD		R1
		GETB
		INC		R14
		GETBH
		ADD		R0
		ADD		R2
		TO		R6
		LDW		(R0)		;R6 <- 1/COS(R10)
;
;;;;		    mCMODE	    004H	    ;CMODE DATA SET
		FROM		R9
		LSR
		BCC		DO_M00
		SUB		R0		;[ IBT R0,#00 ]
;
		OR		#04H
DO_M00
		CMODE
;;;;		    mCMODE	    000H	    ;CMODE DATA SET
;;;;		    mROMB	    DOR_ADR_B	    ;DOOR DATA ROM BANK SET
		FROM		R11
		ROMB
;
		IWT		R11, #00100H
		IWT		R13, #DO_M20
		LM		R2, CWORK1
		IWT		R0, #DOR_YS
		TO		R2
		ADD		R2
		IWT		R7, #DOR_YS * 100H
DO_M10
		LM		R1, CWORK0
		IBT		R8, #000H
		IBT		R12, #DOR_XS + 1
DO_M20
		MERGE
		TO		R14
		ADD		R9
		LOB
		BIC		#00FH
		BNE		DO_M30
		GETC
;
		WITH		R8
		ADD		R6
		LOOP
		PLOT
DO_M30
		DEC		R1
;		ibt		r0,#010h
;		colour
;		plot
;;;;		    IBT		    R0,#0CCH	    ;[ (L) color ]
		IBT		R0,#011H	;[ (L) color ]
;		ADD		R10
		COLOUR
		FROM		R10
		LSR
		LSR
		LSR
		LSR
		NOT
		AND		#003H
		WITH		R15
		ADD		R0
		PLOT
		PLOT
		PLOT
;
		WITH		R7
		SUB		R11
		BPL		DO_M10
		DEC		R2
;
		RPIX
;
		STOP
		NOP
;
;
;************************************************************************
;*		gate OAM set						*
;*			in  : (R1) <-- enemy index			*
;*			      (R2) <-- start angle			*
;*			      (R3) <-- OAM index			*
;*			      (R4) <-- start pattern chara no. index	*
;*			      (R6) <-- a				*
;************************************************************************
GATCHNO		EQU	$
;
;-------------- OAj[VLmDf[^ ------------------
;			 1  2  3  4  5	6
		HEX	44,54,45,55,45,54
		HEX	44,54,45,55,45,54,44,54,45,55,45,54,44
;
;-------------- OLmDf[^ ----------------------------
		HEX	55,55,55,55,55,55,55,55,55,55,55,55,55,55
		HEX	45,45,45,45,45,45,45,45,45,45,45,45,45,45
		HEX	54,54,54,54,54,54,54,54,54,54,54,54,54,54
		HEX	44,44,44,44,44,44,44,44,44,44,44,44,44,44
;
GATOAMST	EQU	$
		IWT	R0,#GATCHNO
		TO	R7		;(R7)  <-- star chara pattern data address
		ADD	R4
		IWT	R0,#CENMUKI
		ADD	R1
		LDW	(R0)
		SWAP
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11			;(R11) <-- OBJ pri. muki
		ADD	R0
		IWT	R0,#CENDSXL
		ADD	R1
		LDW	(R0)
		TO	R4			;(R4)  <-- enmy display X pos
		ADD	#8
		IWT	R0,#CENDSYL
		ADD	R1
		LDW	(R0)
		TO	R5			;(R5)  <--	 "     Y  "
		ADD	#8
;
		WITH	R6			;;(R6)	<-- circle R
		SWAP
;
		IWT	R8,#COS			;(R8)  <-- cos data address
		IWT	R9,#SIN			;(R9)  <-- sin	    "
		IWT	R10,#(256*100H)/14	;(R10) <-- angle add data
;
		WITH	R2			;(R2)  <-- start angle * 100H
		SWAP
;
		IBT	R0,#BANK COS
		ROMB

		CACHE
;
		IBT	R12,#14
		MOVE	R13,R15
GTOS010
		FROM	R2
		HIB
		ADD	R0
		MOVE	R1,R0
		TO	R14		;(R14) <-- cos data address
		ADD	R9
		GETB
		INC	R14
		GETBH
		FMULT
		DIV2
		ADD	R4
		STW	(R3)		;X pos set
		INC	R3
		INC	R3
;
		FROM	R1
		TO	R14		;(R14) <-- sin data address
		ADD	R8
		GETB
		INC	R14
		GETBH
;
		MOVE	R14,R7		;(R14) <-- star chara pattern data address
;
		FMULT
		ADD	R5
		STW	(R3)		;Y pos set
		INC	R3
		INC	R3
;
		GETB
		STB	(R3)		;chara no. set
		INC	R3
;
		IBT	R0,#036H	;(R11) <-- att data
		STB	(R3)		;att set
		INC	R3
;
		FROM	R2
		LSR
		IWT	R1,#4000H
		AND	R1			;spacial flag set [ 4000H ]
		XOR	R11
		STW	(R3)		;size & spacial flag set
		INC	R3
		INC	R3
;
		WITH	R2
		ADD	R10
;
		LOOP
		INC	R7
;
		STOP
		NOP
;
;
;;;;;************************************************************************
;;;;;*		    rotation point polygon				    *
;;;;;*			    in	: (R1) <-- data no.			    *
;;;;;*				  (R2) <-- X angle			    *
;;;;;*				  (R3) <-- Y   "                            *
;;;;;*				  (R4) <-- center X pos.		    *
;;;;;*				  (R5) <--    "   Y  "			    *
;;;;;*				  (R6) <-- zoom flag			    *
;;;;;************************************************************************
;;;;ROTPOLY	    EQU	    $
;;;;;
;;;;;-------------- bitmap buffer clear !! ----------------------------------
;;;;		    CACHE
;;;;;
;;;;		    IWT	    R7,#(WOB7CHR+20H*4)
;;;;		    IWT	    R8,#(WOB7CHR+20H*4)+200H
;;;;		    IWT	    R9,#(WOB7CHR+20H*4)+400H
;;;;		    IWT	    R10,#(WOB7CHR+20H*4)+600H
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    IWT	    R12,#(20H*4)/2
;;;;		    MOVE    R13,R15
;;;;RTPOL000
;;;;		    STW	    (R7)
;;;;		    STW	    (R8)
;;;;		    STW	    (R9)
;;;;		    STW	    (R10)
;;;;		    INC	    R7
;;;;		    INC	    R7
;;;;		    INC	    R8
;;;;		    INC	    R8
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    INC	    R10
;;;;		    LOOP
;;;;		    INC	    R10
;;;;;
;;;;;-------------- moji polygon set ----------------------------------------
;;;;;
;;;;;-------------- plot mode set -----------------------------------
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    CMODE
;;;;		    IBT	    R0,#01H
;;;;		    COLOUR		    ;color set
;;;;;
;;;;;-------------- cos & sin data read -----------------------------
;;;;		    IBT	    R0,#BANK LCOS   ;cos & sin data bank set
;;;;		    ROMB
;;;;;
;;;;		    IWT	    R13,#LCOS
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R2
;;;;		    TO	    R7		    ;(R7) <-- X cos data
;;;;		    GETB
;;;;;
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    TO	    R9		    ;(R9)   <-- Y cos data
;;;;		    GETB
;;;;;
;;;;		    IWT	    R13,#LSIN
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R2
;;;;		    TO	    R8		    ;(R8) <-- X sin data
;;;;		    GETB
;;;;;
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    TO	    R10		    ;(R10) <-- Y sin data
;;;;		    GETB
;;;;;
;;;;;-------------- moji polygon data address read ------------------
;;;;		    IWT	    R0,#ROTPOLIN
;;;;		    ADD	    R1
;;;;		    TO	    R14
;;;;		    ADD	    R1
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    GETBH
;;;;		    MOVE    R14,R0	    ;(R14) <-- moji polygon data pointer
;;;;;
;;;;;-------------- point rotation & 2D convert ---------------------
;;;;		    MOVE    R11,R6	    ;(R11) <-- zoom flag
;;;;		    TO	    R12		    ;(R12) <-- number of point
;;;;		    GETB
;;;;		    INC	    R14
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    MOVE    R13,R15
;;;;RTPOL010
;;;;		    GETB		    ;(R0) <-- Z pos.
;;;;		    INC	    R14
;;;;;
;;;;		    TO	    R1		    ;(R1) <-- SZ * (X cos)
;;;;		    MULT    R7
;;;;		    TO	    R2		    ;(R2) <-- SZ * (X sin)
;;;;		    MULT    R8
;;;;;
;;;;		    GETB		    ;(R0) <-- Y pos.
;;;;		    INC	    R14
;;;;		    MOVE    R6,R0
;;;;;
;;;;		    MULT    R7		    ;(R0) <-- SY * (X cos) - SZ * (X sin)
;;;;		    SUB	    R2
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R3		    ;(R3) <-- rotation Y pos
;;;;		    HIB
;;;;;
;;;;		    FROM    R6
;;;;		    MULT    R8		    ;(R0) <-- SY * (X sin)
;;;;		    ADD	    R1		    ;(R0) <-- SZ * (X cos) + SY * (X sin)
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    HIB			    ;(R0) <-- X rotation Z pos
;;;;;
;;;;		    TO	    R1		    ;(R1) <-- SZ * (Y cos)
;;;;		    MULT    R9
;;;;		    TO	    R2		    ;(R2) <-- SZ * (Y sin)
;;;;		    MULT    R10
;;;;;
;;;;		    GETB		    ;(R0) <-- X pos.
;;;;		    INC	    R14
;;;;		    MOVE    R6,R0
;;;;;
;;;;		    MULT    R9		    ;(R0) <-- SX * (Y cos)
;;;;		    ADD	    R2		    ;(R0) <-- SX * (Y cos) + SZ * (Y sin)
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R2		    ;(R2) <-- rotation X pos
;;;;		    HIB
;;;;;
;;;;		    FROM    R6
;;;;		    MULT    R10		    ;(R0) <-- SX * (Y sin)
;;;;		    FROM    R1		    ;(R0) <-- SZ * (Y cos) - SX * (Y sin)
;;;;		    SUB	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    HIB			    ;(R0) <-- rotation Z pos
;;;;;
;;;;		    MULT    R11
;;;;		    HIB
;;;;		    TO	    R1
;;;;		    SEX
;;;;		    IWT	    R0,#DIVBUF+(100H*2)
;;;;		    ADD	    R1
;;;;		    ADD	    R1
;;;;		    TO	    R6
;;;;		    LDW	    (R0)
;;;;		    FROM    R2
;;;;		    SWAP
;;;;		    FMULT
;;;;		    MULT    R11
;;;;		    SWAP
;;;;		    ADD	    R4		    ;center X pos. add.
;;;;		    TO	    R1		    ;(R1) <-- 2D X pos
;;;;		    LOB
;;;;;
;;;;		    FROM    R3
;;;;		    SWAP
;;;;		    FMULT
;;;;		    MULT    R11
;;;;		    SWAP
;;;;		    ADD	    R5		    ;center Y pos. add.
;;;;		    TO	    R2
;;;;		    LOB
;;;;;
;;;;		    PLOT
;;;;		    PLOT
;;;;		    DEC	    R1
;;;;		    DEC	    R1
;;;;		    INC	    R2
;;;;		    PLOT
;;;;;
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;------------------------------------------------------------------------
;;;;;-		    rotation point data					    -
;;;;;------------------------------------------------------------------------
;;;;ROTPOLIN	    EQU	    $
;;;;		    WORD    ROTPOLD0	    ;[0]
;;;;;
;;;;;
;;;;ROTPOLD0	    EQU	    $
;;;;;			    number of point
;;;;		    HEX	    20
;;;;;			     Z	Y  X
;;;;		    HEX	    00,00,40	    ;[0]
;;;;		    HEX	    2D,00,2D	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,00,D3	    ;[135]
;;;;		    HEX	    00,00,C1	    ;[180]
;;;;		    HEX	    D3,00,D3	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,00,2D	    ;[315]
;;;;;
;;;;		    HEX	    00,2D,2D	    ;[0]
;;;;		    HEX	    2D,1F,1F	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,E0,E0	    ;[135]
;;;;		    HEX	    00,D3,D3	    ;[180]
;;;;		    HEX	    D3,E1,E1	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,20,20	    ;[315]
;;;;;
;;;;		    HEX	    00,3F,00	    ;[0]
;;;;		    HEX	    2D,2D,00	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,D3,00	    ;[135]
;;;;		    HEX	    00,C1,00	    ;[180]
;;;;		    HEX	    D3,D3,00	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,2D,00	    ;[315]
;;;;;
;;;;		    HEX	    00,2D,D3	    ;[0]
;;;;		    HEX	    2D,1F,E0	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,E1,20	    ;[135]
;;;;		    HEX	    00,D3,2D	    ;[180]
;;;;		    HEX	    D3,E1,1F	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,20,E0	    ;[315]
;;;;;
;;;;;
;;;;;************************************************************************
;;;;;*		    rotation point polygon				    *
;;;;;*			    in	: (R1) <--				    *
;;;;;*				  (R2) <-- X angle			    *
;;;;;*				  (R3) <-- Y   "                            *
;;;;;*				CWORK0 <-- data no. (FROM)		    *
;;;;;*				CWORK1 <-- data no. (TO)		    *
;;;;;*				CWORK2 <-- zoom flag			    *
;;;;;*				CWORK3 <-- center X pos.		    *
;;;;;*				CWORK4 <--    "   Y  "			    *
;;;;;*				CWORK5 <-- henkei ritu			    *
;;;;;************************************************************************
;;;;DOTSET	    EQU	    $
;;;;;
;;;;;-------------- bitmap buffer clear !! ----------------------------------
;;;;		    CACHE
;;;;;
;;;;		    IWT	    R7,#(WOB7CHR+20H*4)
;;;;		    IWT	    R8,#(WOB7CHR+20H*4)+200H
;;;;		    IWT	    R9,#(WOB7CHR+20H*4)+400H
;;;;		    IWT	    R10,#(WOB7CHR+20H*4)+600H
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    IWT	    R12,#(20H*4)/2
;;;;		    MOVE    R13,R15
;;;;DOTSET000
;;;;		    STW	    (R7)
;;;;		    STW	    (R8)
;;;;		    STW	    (R9)
;;;;		    STW	    (R10)
;;;;		    INC	    R7
;;;;		    INC	    R7
;;;;		    INC	    R8
;;;;		    INC	    R8
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    INC	    R10
;;;;		    LOOP
;;;;		    INC	    R10
;;;;;
;;;;;-------------- moji polygon set ----------------------------------------
;;;;;
;;;;;-------------- plot mode set -----------------------------------
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    CMODE
;;;;		    IBT	    R0,#01H
;;;;		    COLOUR		    ;color set
;;;;;
;;;;;-------------- cos & sin data read -----------------------------
;;;;		    IBT	    R0,#BANK LCOS   ;cos & sin data bank set
;;;;		    ROMB
;;;;;
;;;;		    IWT	    R13,#LCOS
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R2
;;;;		    TO	    R7		    ;(R7) <-- X cos data
;;;;		    GETB
;;;;;
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    TO	    R9		    ;(R9)   <-- Y cos data
;;;;		    GETB
;;;;;
;;;;		    IWT	    R13,#LSIN
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R2
;;;;		    TO	    R8		    ;(R8) <-- X sin data
;;;;		    GETB
;;;;;
;;;;		    FROM    R13
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    TO	    R10		    ;(R10) <-- Y sin data
;;;;		    GETB
;;;;;
;;;;;-------------- moji polygon data address read ------------------
;;;;		    LMS	    R0,CWORK0	    ;(R4) <-- TO data start addr.
;;;;		    ADD	    R0		    ;
;;;;		    IWT	    R1,#DOTDATIN    ;
;;;;		    TO	    R14		    ;
;;;;		    ADD	    R1		    ;
;;;;		    GETB		    ;
;;;;		    INC	    R14		    ;
;;;;		    GETBH		    ;
;;;;		    MOVE    R4,R0	    ;
;;;;
;;;;		    LMS	    R0,CWORK1	    ;(R5) <-- FROM data start addr.
;;;;		    ADD	    R0		    ;
;;;;		    TO	    R14		    ;
;;;;		    ADD	    R1		    ;
;;;;		    GETB		    ;
;;;;		    INC	    R14		    ;
;;;;		    GETBH		    ;
;;;;		    MOVE    R5,R0	    ;
;;;;
;;;;;
;;;;;-------------- point rotation & 2D convert ---------------------
;;;;;		    MOVE    R11,R6	    ;(R11) <-- zoom flag
;;;;		    LMS	    R11,CWORK2	    ;(R11) <-- zoom flag
;;;;		    IBT	    R12,#020H	    ;(R12) <-- number of point
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    MOVE    R13,R15
;;;;DOTSET010
;;;;		    MOVE    R14,R4
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    TO	    R1
;;;;		    SEX			    ;
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    TO	    R2
;;;;		    SEX			    ;
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    TO	    R3
;;;;		    SEX			    ;
;;;;		    MOVE    R4,R14
;;;;
;;;;		    LMS	    R6,CWORK5	    ;(R6) <-- henkei ritu
;;;;
;;;;		    MOVE    R14,R5
;;;;		    GETBS		    ;CWORK5 <-- Z pos.
;;;;		    INC	    R14		    ;
;;;;		    SUB	    R1		    ;
;;;;		    LOB			    ;
;;;;		    SWAP		    ;
;;;;		    FMULT		    ;
;;;;		    ADD	    R1		    ;
;;;;		    LOB			    ;
;;;;		    SMS	    R0,CWORK6	    ;
;;;;
;;;;		    GETBS		    ;CWORK6 <-- Y pos.
;;;;		    INC	    R14		    ;
;;;;		    SUB	    R2		    ;
;;;;		    LOB			    ;
;;;;		    SWAP		    ;
;;;;		    FMULT		    ;
;;;;		    ADD	    R2		    ;
;;;;		    LOB			    ;
;;;;		    SMS	    R0,CWORK7	    ;
;;;;
;;;;		    GETBS		    ;CWORK7 <-- X pos.
;;;;		    INC	    R14		    ;
;;;;		    SUB	    R3		    ;
;;;;		    LOB			    ;
;;;;		    SWAP		    ;
;;;;		    FMULT		    ;
;;;;		    ADD	    R3		    ;
;;;;		    LOB			    ;
;;;;		    SMS	    R0,CWORK8	    ;
;;;;
;;;;		    MOVE    R5,R14
;;;;
;;;;		    LMS	    R0,CWORK6	    ;(R0) <-- Z pos.
;;;;;
;;;;		    TO	    R1		    ;(R1) <-- SZ * (X cos)
;;;;		    MULT    R7
;;;;		    TO	    R2		    ;(R2) <-- SZ * (X sin)
;;;;		    MULT    R8
;;;;;
;;;;		    LMS	    R0,CWORK7	    ;(R0) <-- Y pos.
;;;;		    MOVE    R6,R0
;;;;;
;;;;		    MULT    R7		    ;(R0) <-- SY * (X cos) - SZ * (X sin)
;;;;		    SUB	    R2
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R3		    ;(R3) <-- rotation Y pos
;;;;		    HIB
;;;;;
;;;;		    FROM    R6
;;;;		    MULT    R8		    ;(R0) <-- SY * (X sin)
;;;;		    ADD	    R1		    ;(R0) <-- SZ * (X cos) + SY * (X sin)
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    HIB			    ;(R0) <-- X rotation Z pos
;;;;;
;;;;		    TO	    R1		    ;(R1) <-- SZ * (Y cos)
;;;;		    MULT    R9
;;;;		    TO	    R2		    ;(R2) <-- SZ * (Y sin)
;;;;		    MULT    R10
;;;;;
;;;;		    LMS	    R0,CWORK8	    ;(R0) <-- X pos.
;;;;		    MOVE    R6,R0
;;;;;
;;;;		    MULT    R9		    ;(R0) <-- SX * (Y cos)
;;;;		    ADD	    R2		    ;(R0) <-- SX * (Y cos) + SZ * (Y sin)
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R2		    ;(R2) <-- rotation X pos
;;;;		    HIB
;;;;;
;;;;		    FROM    R6
;;;;		    MULT    R10		    ;(R0) <-- SX * (Y sin)
;;;;		    FROM    R1		    ;(R0) <-- SZ * (Y cos) - SX * (Y sin)
;;;;		    SUB	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    HIB			    ;(R0) <-- rotation Z pos
;;;;;
;;;;		    MULT    R11
;;;;		    HIB
;;;;		    TO	    R1
;;;;		    SEX
;;;;		    IWT	    R0,#DIVBUF+(100H*2)
;;;;		    ADD	    R1
;;;;		    ADD	    R1
;;;;		    TO	    R6
;;;;		    LDW	    (R0)
;;;;		    FROM    R2
;;;;		    SWAP
;;;;		    FMULT
;;;;		    MULT    R11
;;;;		    SWAP
;;;;		    LMS	    R1,CWORK3	    ;center X pos. add.
;;;;		    ADD	    R1		    ;
;;;;		    TO	    R1		    ;(R1) <-- 2D X pos
;;;;		    LOB
;;;;;
;;;;		    FROM    R3
;;;;		    SWAP
;;;;		    FMULT
;;;;		    MULT    R11
;;;;		    SWAP
;;;;		    LMS	    R2,CWORK4	    ;center Y pos. add.
;;;;		    ADD	    R2		    ;
;;;;		    TO	    R2
;;;;		    LOB
;;;;;
;;;;		    PLOT
;;;;		    PLOT
;;;;		    DEC	    R1
;;;;		    DEC	    R1
;;;;		    INC	    R2
;;;;		    PLOT
;;;;;
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;------------------------------------------------------------------------
;;;;;-		    rotation point data					    -
;;;;;------------------------------------------------------------------------
;;;;DOTDATIN	    EQU	    $
;;;;		    WORD    DOTDAT0	    ;[0]
;;;;		    WORD    DOTDAT1	    ;[1]
;;;;;
;;;;;
;;;;DOTDAT0	    EQU	    $
;;;;;			     Z	Y  X
;;;;		    HEX	    00,00,40	    ;[0]
;;;;		    HEX	    2D,00,2D	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,00,D3	    ;[135]
;;;;		    HEX	    00,00,C1	    ;[180]
;;;;		    HEX	    D3,00,D3	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,00,2D	    ;[315]
;;;;;
;;;;		    HEX	    00,2D,2D	    ;[0]
;;;;		    HEX	    2D,1F,1F	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,E0,E0	    ;[135]
;;;;		    HEX	    00,D3,D3	    ;[180]
;;;;		    HEX	    D3,E1,E1	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,20,20	    ;[315]
;;;;;
;;;;		    HEX	    00,3F,00	    ;[0]
;;;;		    HEX	    2D,2D,00	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,D3,00	    ;[135]
;;;;		    HEX	    00,C1,00	    ;[180]
;;;;		    HEX	    D3,D3,00	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,2D,00	    ;[315]
;;;;;
;;;;		    HEX	    00,2D,D3	    ;[0]
;;;;		    HEX	    2D,1F,E0	    ;[45]
;;;;		    HEX	    3F,00,00	    ;[90]
;;;;		    HEX	    2D,E1,20	    ;[135]
;;;;		    HEX	    00,D3,2D	    ;[180]
;;;;		    HEX	    D3,E1,1F	    ;[225]
;;;;		    HEX	    C1,00,00	    ;[270]
;;;;		    HEX	    D3,20,E0	    ;[315]
;;;;;
;;;;DOTDAT1	    EQU	    $
;;;;;			     Z	Y  X
;;;;		    HEX	    28,F3,28
;;;;		    HEX	    28,0E,28
;;;;		    HEX	    28,F3,D9
;;;;		    HEX	    28,0E,D9
;;;;		    HEX	    D9,0E,D9
;;;;		    HEX	    D9,F3,D9
;;;;		    HEX	    D9,0E,28
;;;;		    HEX	    D9,F3,28
;;;;;
;;;;		    HEX	    0E,28,28
;;;;		    HEX	    28,28,28
;;;;		    HEX	    0E,D9,D9
;;;;		    HEX	    28,D9,D9
;;;;		    HEX	    F3,D9,D9
;;;;		    HEX	    D9,D9,D9
;;;;		    HEX	    F3,28,28
;;;;		    HEX	    D9,28,28
;;;;;
;;;;		    HEX	    28,28,F3
;;;;		    HEX	    28,28,0E
;;;;		    HEX	    28,D9,F3
;;;;		    HEX	    28,D9,0E
;;;;		    HEX	    D9,D9,0E
;;;;		    HEX	    D9,D9,F3
;;;;		    HEX	    D9,28,0E
;;;;		    HEX	    D9,28,F3
;;;;;
;;;;		    HEX	    0E,28,D9
;;;;		    HEX	    28,28,D9
;;;;		    HEX	    0E,D9,28
;;;;		    HEX	    28,D9,28
;;;;		    HEX	    F3,D9,28
;;;;		    HEX	    D9,D9,28
;;;;		    HEX	    F3,28,D9
;;;;		    HEX	    D9,28,D9
;
;
;
;		HEX	D9,D9,D9	;
;		HEX	D9,D9,F3	;
;		HEX	D9,D9,0E	;
;		HEX	D9,D9,28	;
;		HEX	D9,F3,D9	;
;		HEX	D9,F3,28	;
;		HEX	D9,0E,D9	;
;		HEX	D9,0E,28	;
;		HEX	D9,28,D9	;
;		HEX	D9,28,F3	;
;		HEX	D9,28,0E	;
;		HEX	D9,28,28	;
;;					;
;		HEX	F3,D9,D9	;
;		HEX	F3,D9,28	;
;		HEX	F3,28,D9	;
;		HEX	F3,28,28	;
;;					;
;		HEX	0E,D9,D9	;
;		HEX	0E,D9,28	;
;		HEX	0E,28,D9	;
;		HEX	0E,28,28	;
;;					;
;		HEX	28,D9,D9	;
;		HEX	28,D9,F3	;
;		HEX	28,D9,0E	;
;		HEX	28,D9,28	;
;		HEX	28,F3,D9	;
;		HEX	28,F3,28	;
;		HEX	28,0E,D9	;
;		HEX	28,0E,28	;
;		HEX	28,28,D9	;
;		HEX	28,28,F3	;
;		HEX	28,28,0E	;
;		HEX	28,28,28	;
;
;****************************************************************
;*		NII MACRO					*
;****************************************************************
;
JSR		MACRO	SUBROUTINE
		LINK	#4
		MOVE	R15,#SUBROUTINE
		NOP
		ENDM
;
RTS		MACRO
		MOVE	R15,R11
		NOP
		ENDM
;
;************************************************
;*  other conditions...				*
;*	r12 :	lsin data table addr.		*
;*	r13 :	lcos data table addr.		*
;*						*
;************************************************
GET_LSINCOS2	MACRO	SINREG,SINRAM,COSREG,COSRAM,ANGLE

		GET_LSINCOS	SINREG,COSREG,ANGLE
		SMS	SINREG,SINRAM
		SMS	COSREG,COSRAM

		ENDM
;
;************************************************
;*  other conditions...				*
;*	r12 :	lsin data table addr.		*
;*	r13 :	lcos data table addr.		*
;*						*
;************************************************
GET_LSINCOS	MACRO	SINREG,COSREG,ANGLE

		FROM	R12
		TO	R14
		ADD	ANGLE
		TO	SINREG
		GETBS

		FROM	R13
		TO	R14
		ADD	ANGLE
		TO	COSREG
		GETBS

		ENDM
;
MULT_2VALUE	MACRO	V1,V2,RESULT		;RESULT(reg) <-- high( V1 * V2 * 4 )
		FROM	V1
		MULT	V2
		ADD	R0
		ADD	R0
		TO	RESULT
		HIB

		ENDM
;
MULT_2VALUE2	MACRO	V1,V2,RESULT		;RESULT(mem) <-- high( V1 * V2 * 4 )

		MULT_2VALUE	V1,V2,R0
		SMS	R0,RESULT

		ENDM
;
;
;
;
;
;;;;N_POL	    EQU	    $			    ;n_pol
;;;;		    CACHE
;;;;;
;;;;		    IWT	    R7,#(WOB7CHR+20H*4)
;;;;		    IWT	    R8,#(WOB7CHR+20H*4)+200H
;;;;		    IWT	    R9,#(WOB7CHR+20H*4)+400H
;;;;		    IWT	    R10,#(WOB7CHR+20H*4)+600H
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    IWT	    R12,#(20H*4)/2
;;;;		    MOVE    R13,R15
;;;;
;;;;		    STW	    (R7)
;;;;		    STW	    (R8)
;;;;		    STW	    (R9)
;;;;		    STW	    (R10)
;;;;		    INC	    R7
;;;;		    INC	    R7
;;;;		    INC	    R8
;;;;		    INC	    R8
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    INC	    R10
;;;;		    LOOP
;;;;		    INC	    R10
;;;;;-----------------< plot mode set >------------------------------
;;;;N_NP	    EQU	    $
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    CMODE
;;;;
;;;;		    SMS	    R0,REG0
;;;;		    SMS	    R0,REG1
;;;;
;;;;;------------------< sin & cos data >-----------------------------
;;;;		    IBT	    R0,#BANK LCOS
;;;;		    ROMB
;;;;
;;;;		    IWT	    R12,#LSIN
;;;;		    IWT	    R13,#LCOS
;;;;
;;;;		    GET_LSINCOS	    R4,R5,R1
;;;;		    GET_LSINCOS	    R7,R8,R2
;;;;		    SMS	    R7,CWORK16
;;;;		    GET_LSINCOS	    R9,R10,R3
;;;;;
;;;;		    MULT_2VALUE2    R4,R7,CWORK19		    ;CWORK19 <-- sin r1 * sin r2
;;;;
;;;;		    MULT_2VALUE	    R9,R4,R2			    ;r2 <-- sin r3 * sin r1
;;;;
;;;;		    MULT_2VALUE2    R5,R8,CWORK18		    ;CWORK18 <-- cos r1 * cos r2
;;;;
;;;;		    MULT_2VALUE2    R8,R10,CWORK10		    ;CWORK10 <-- cos r2 * cos r3
;;;;
;;;;		    MULT_2VALUE	    R10,R5,R3			    ;r3 <-- cos r3 * cos r1
;;;;
;;;;		    MULT_2VALUE2    R8,R9,CWORK13		    ;CWORK13 <-- cos r2 * sin r3
;;;;
;;;;		    MULT_2VALUE	    R5,R7,R11			    ;r11 <-- cos r1 * sin r2
;;;;
;;;;		    MULT_2VALUE2    R4,R8,CWORK17		    ;CWORK17 <-- sin r1 * cos r2
;;;;
;;;;		    MULT_2VALUE	    R5,R9,R5			    ;r5 <-- cos r1 * sin r3
;;;;
;;;;		    MULT_2VALUE	    R4,R10,R4			    ;r4 <-- sin r1 * cos r3
;;;;
;;;;		    LMS	    R1,CWORK19
;;;;		    MULT_2VALUE	    R1,R9,R7			    ;r7 <-- sin r1 * sin r2 * sin r3
;;;;		    FROM    R3					    ;CWORK14 <-- - ( sin r1 * sin r2 * sin r3 ) + ( cos r3 * cos r1 )
;;;;		    SUB	    R7					    ;
;;;;		    SMS	    R0,CWORK14				    ;
;;;;
;;;;		    MULT_2VALUE	    R1,R10,R0			    ;r0 <-- sin r1 * sin r2 * cos r3
;;;;		    ADD	    R5					    ;CWORK11 <-- - ( sin r1 * sin r2 * cos r3 ) - ( cos r1 * sin r3 )
;;;;		    SMS	    R0,CWORK11				    ;
;;;;
;;;;		    MULT_2VALUE	    R11,R10,R0
;;;;		    ADD	    R2
;;;;		    SMS	    R0,CWORK12
;;;;
;;;;		    MULT_2VALUE	    R11,R9,R0
;;;;		    SUB	    R4
;;;;		    SMS	    R0,CWORK15
;;;;
;;;;
;;;;
;;;;;		    GET_LSINCOS2    R3,CWORK10,R5,CWORK11,R1	    ;r3,CWORK10 <-- sin r1
;;;;;								    ;r1,CWORK11 <-- cos r1
;;;;;		    GET_LSINCOS2    R7,CWORK12,R8,CWORK13,R2	    ;r7,CWORK12 <-- sin r2
;;;;;								    ;r8,CWORK13 <-- cos r2
;;;;;
;;;;;		    MULT_2VALUE2    R3,R7,CWORK14		    ;CWORK14 <-- sin r1 * sin r2  MAX 1000H
;;;;;		    MULT_2VALUE2    R3,R8,CWORK16		    ;CWORK16 <-- sin r1 * cos r2  MAX 1000H
;;;;;		    MULT_2VALUE2    R5,R7,CWORK17		    ;CWORK17 <-- cos r1 * sin r2  MAX 1000H
;;;;;		    MULT_2VALUE2    R5,R8,CWORK15		    ;CWORK15 <-- cos r1 * cos r2  MAX 1000H
;;;;
;;;;;==================< point trans. loop >=========================
;;;;;---------< point trans loop init >--------
;;;;		    IBT	    R0,#BANK POINT_WK
;;;;		    RAMB
;;;;
;;;;		    IWT	    R4,#POINT_WK    ;r10 <-- ram p.
;;;;;		    IWT	    R4,#CWORK0	    ;r10 <-- ram p.
;;;;
;;;;		    IBT	    R0,#BANK POI
;;;;		    ROMB
;;;;
;;;;		    IWT	    R14,#POI	    ;r12 <-- point sum.
;;;;		    TO	    R12		    ;
;;;;		    GETB		    ;
;;;;		    INC	    R14		    ;
;;;;
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;;---------< point trans loop start >-------
;;;;		    TO	    R8		    ;r8 <-- z
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;		    TO	    R7		    ;r7 <-- y
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;		    TO	    R5		    ;r5 <-- x
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;;------------------< rotate >-----------------------------------
;;;;		    LMS	    R6,CWORK16	    ;rot z1 calc.
;;;;		    FROM    R5		    ; x * -sin r2
;;;;		    TO	    R1		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK17	    ; y * sin r1 * cos r2
;;;;		    FROM    R7		    ;
;;;;		    TO	    R2		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK18	    ; z * cos r1 * cos r2
;;;;		    FROM    R8		    ;
;;;;		    MULT    R6		    ;
;;;;		    ADD	    R2		    ;
;;;;		    SUB	    R1		    ;
;;;;		    ADD	    R0		    ;
;;;;		    ADD	    R0		    ;
;;;;		    SWAP		    ;
;;;;		    SEX			    ;
;;;;		    STW	    (R4)	    ;
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;
;;;;		    SEX
;;;;		    IWT	    R3,#00100H
;;;;		    WITH    R3
;;;;		    SUB	    R0
;;;;
;;;;		    LMS	    R6,CWORK13	    ;rot y1 calc.
;;;;		    FROM    R5		    ;
;;;;		    TO	    R1		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK14	    ;
;;;;		    FROM    R7		    ;
;;;;		    TO	    R2		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK15	    ;
;;;;		    FROM    R8		    ;
;;;;		    MULT    R6		    ;
;;;;		    ADD	    R2		    ;
;;;;		    ADD	    R1		    ;
;;;;		    ADD	    R0		    ;
;;;;		    ADD	    R0		    ;
;;;;		    MOVE    R6,R3	    ;
;;;;		    FMULT		    ;
;;;;		    STW	    (R4)	    ;
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;
;;;;		    LMS	    R6,CWORK10	    ;rot x1 calc.
;;;;		    FROM    R5		    ;
;;;;		    TO	    R1		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK11	    ;
;;;;		    FROM    R7		    ;
;;;;		    TO	    R2		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK12	    ;
;;;;		    FROM    R8		    ;
;;;;		    MULT    R6		    ;
;;;;		    SUB	    R2		    ;
;;;;		    ADD	    R1		    ;
;;;;		    ADD	    R0		    ;
;;;;		    ADD	    R0		    ;
;;;;		    MOVE    R6,R3	    ;
;;;;		    FMULT		    ;
;;;;		    STW	    (R4)	    ;
;;;;		    INC	    R4		    ;
;;;;
;;;;;		    LMS	    R6,CWORK12	    ;rot z1 calc.
;;;;;		    FROM    R5		    ; x * -sin r2
;;;;;		    TO	    R1		    ;
;;;;;		    MULT    R6		    ;
;;;;;					    ;
;;;;;		    LMS	    R6,CWORK16	    ; y * sin r1 * cos r2
;;;;;		    FROM    R7		    ;
;;;;;		    TO	    R2		    ;
;;;;;		    MULT    R6		    ;
;;;;;					    ;
;;;;;		    LMS	    R6,CWORK15	    ; z * cos r1 * cos r2
;;;;;		    FROM    R8		    ;
;;;;;		    MULT    R6		    ;
;;;;;		    ADD	    R2		    ;
;;;;;		    SUB	    R1		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    SWAP		    ;
;;;;;		    SEX			    ;
;;;;;		    STW	    (R4)	    ;
;;;;;		    INC	    R4		    ;
;;;;;		    INC	    R4		    ;
;;;;;
;;;;;		    SEX
;;;;;		    IWT	    R3,#00100H
;;;;;		    WITH    R3
;;;;;		    SUB	    R0
;;;;;
;;;;;		    LMS	    R6,CWORK10	    ;rot y1 calc.
;;;;;		    FROM    R8		    ; z * -sin r1
;;;;;		    TO	    R1		    ;
;;;;;		    MULT    R6		    ;
;;;;;					    ;
;;;;;		    LMS	    R6,CWORK11	    ; y * cos r1
;;;;;		    FROM    R7		    ;
;;;;;		    MULT    R6		    ;
;;;;;		    SUB	    R1		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    MOVE    R6,R3	    ;
;;;;;		    FMULT		    ;
;;;;;		    STW	    (R4)	    ;
;;;;;		    INC	    R4		    ;
;;;;;		    INC	    R4		    ;
;;;;;
;;;;;		    LMS	    R6,CWORK13	    ;rot x1 calc.
;;;;;		    FROM    R5		    ; x * cos r2
;;;;;		    TO	    R1		    ;
;;;;;		    MULT    R6		    ;
;;;;;					    ;
;;;;;		    LMS	    R6,CWORK14	    ; y * sin r1 * sin r2
;;;;;		    FROM    R7		    ;
;;;;;		    TO	    R2		    ;
;;;;;		    MULT    R6		    ;
;;;;;					    ;
;;;;;		    LMS	    R6,CWORK17	    ; z * sin r1 * cos r2
;;;;;		    FROM    R8		    ;
;;;;;		    MULT    R6		    ;
;;;;;		    ADD	    R2		    ;
;;;;;		    ADD	    R1		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    ADD	    R0		    ;
;;;;;		    MOVE    R6,R3	    ;
;;;;;		    FMULT		    ;
;;;;;		    STW	    (R4)	    ;
;;;;;		    INC	    R4		    ;
;;;;
;;;;;---------< point trans loop end >---------
;;;;		    LOOP
;;;;		    INC	    R4
;;;;
;;;;;==================< large loop >=================================
;;;;;---------< large loop init >--------------
;;;;		    IWT	    R14,#FACE
;;;;
;;;;		    TO	    R12		    ;r12 <-- face sum.
;;;;		    GETB		    ;
;;;;		    INC	    R14		    ;
;;;;
;;;;		    SMS	    R15,REG13	    ;loop pointer ( REG13 )
;;;;
;;;;;---------< large loop start >-------------
;;;;		    SMS	    R12,REG12	    ;loop ounter save
;;;;
;;;;;
;;;;;==================< sort loop >==================================
;;;;;---------< sort loop init >---------------
;;;;		    TO	    R12		    ;r12 <-- point sum.
;;;;		    GETB		    ;
;;;;		    INC	    R14		    ;
;;;;		    SMS	    R12,CWORKE
;;;;
;;;;;		    GETB		    ;face colour set
;;;;;		    INC	    R14		    ;
;;;;;		    COLOR
;;;;
;;;;		    IWT	    R3,#POIYPS1	    ;r3 <-- select point save work base addr.
;;;;
;;;;		    WITH    R9		    ;r9,r10 <-- start number
;;;;		    SUB	    R9		    ;
;;;;		    MOVE    R11,R9	    ;
;;;;
;;;;		    GETB		    ;r0 <-- point no.
;;;;		    INC	    R14		    ;
;;;;
;;;;		    IWT	    R4,#POINT_WK    ;r4 <-- point data ram p. + point no. * 003H
;;;;		    MULT    #006H	    ;
;;;;		    TO	    R4		    ;
;;;;		    ADD	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;
;;;;		    TO	    R7		    ;r7,r8 <-- start y pos.
;;;;		    LDW	    (R4)	    ;
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;		    MOVE    R8,R7	    ;
;;;;		    FROM    R7		    ;
;;;;		    STW	    (R3)	    ;
;;;;		    INC	    R3		    ;
;;;;		    INC	    R3		    ;
;;;;
;;;;		    LDW	    (R4)	    ;
;;;;		    STW	    (R3)	    ;
;;;;		    INC	    R3		    ;
;;;;		    INC	    R3		    ;
;;;;
;;;;		    DEC	    R12		    ;r12 <-- r12 - 1
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;;---------< sort loop start >-------------
;;;;		    INC	    R11
;;;;
;;;;		    GETB		    ;r0 <-- point no.
;;;;		    INC	    R14		    ;
;;;;
;;;;		    IWT	    R4,#POINT_WK    ;r4 <-- point data ram p. + point no. * 003H
;;;;		    MULT    #006H	    ;
;;;;		    TO	    R4		    ;
;;;;		    ADD	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;
;;;;		    LDW	    (R4)	    ;y pos = minor ?
;;;;		    INC	    R4		    ;
;;;;		    INC	    R4		    ;
;;;;		    STW	    (R3)	    ;
;;;;		    INC	    R3		    ;
;;;;		    CMP	    R7		    ;
;;;;		    BPL	    S_0100	    ;
;;;;		    INC	    R3		    ;  no: S_0100
;;;;
;;;;		    MOVE    R7,R0	    ;r5 <-- minor data
;;;;		    WITH    R11		    ;MOVE   R9,R11	    ;r9 <-- minor number
;;;;		    BRA	    S_0200
;;;;		    TO	    R9
;;;;
;;;;S_0100
;;;;		    CMP	    R8		    ;y pos. = major ?
;;;;		    BMI	    S_0200	    ;  no: S_0200
;;;;
;;;;		    WITH    R0		    ;r8 <-- major data
;;;;		    TO	    R8
;;;;
;;;;S_0200
;;;;		    LDW	    (R4)	    ;
;;;;		    STW	    (R3)	    ;
;;;;		    INC	    R3		    ;
;;;;
;;;;;---------< sort loop end >---------------
;;;;		    LOOP
;;;;		    INC	    R3		    ;
;;;;
;;;;		    SMS	    R9,CWORK2	    ;left to point no.
;;;;		    SMS	    R9,CWORK4	    ;right to point no.
;;;;
;;;;;
;;;;;==================< gaiseki calc. >===============================
;;;;
;;;;		    LM	    R1,POIYPS1	    ;r1 <-- y1
;;;;
;;;;		    LM	    R2,POIXPS1	    ;r2 <-- x1
;;;;
;;;;		    LM	    R3,POIYPS2	    ;r3 <-- y2
;;;;
;;;;		    LM	    R4,POIXPS2	    ;r4 <-- x2
;;;;
;;;;		    LM	    R5,POIYPS3	    ;r5 <-- y3
;;;;
;;;;		    LM	    R6,POIXPS3	    ;r6 <-- x3
;;;;
;;;;		    WITH    R6		    ;r0 <-- (y3 - y2) * (x2 - x1) - (x3 - x2) * (y2 - y1)
;;;;		    SUB	    R4		    ; r6 <-- (x3 - x2) * (y2 - y1)
;;;;		    FROM    R3		    ;
;;;;		    SUB	    R1		    ;
;;;;		    TO	    R6		    ;
;;;;		    MULT    R6		    ;
;;;;		    WITH    R5		    ; r0 <--(y3 - y2) * (x2 - x1)
;;;;		    SUB	    R3		    ;
;;;;		    FROM    R4		    ;
;;;;		    SUB	    R2		    ;
;;;;		    MULT    R5		    ;
;;;;		    SUB	    R6		    ;
;;;;
;;;;		    BMI	    COLST_0100
;;;;
;;;;		    WITH    R14		    ;CWORK8 <-- face data rom p.
;;;;		    ADD	    #003H
;;;;		    SMS	    R14,REG14
;;;;
;;;;		    LMS	    R0,REG1
;;;;		    DEC	    R0
;;;;		    SBK
;;;;
;;;;		    IWT	    R15,#D_END
;;;;		    NOP
;;;;
;;;;;
;;;;;==================< colour set >=================================
;;;;COLST_0100
;;;;;		    INC	    R8
;;;;		    SMS	    R8,CWORK0	    ;CWORK0 <-- Y end pos.
;;;;
;;;;		    GETBS		    ;r0 <-- z pos.
;;;;		    INC	    R14
;;;;
;;;;		    TO	    R1		    ;r1 <-- y pos.
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;		    TO	    R2		    ;r2 <-- x pos.
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;		    SMS	    R14,REG14	    ;REG14 <-- face data rom p.
;;;;
;;;;;------------------< rotate >-----------------------------------
;;;;		    LMS	    R6,CWORK16	    ;rot z calc.
;;;;;		    LMS	    R6,CWORK12	    ;rot z calc.
;;;;		    WITH    R2		    ; x * -sin r2
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK17	    ; y * sin r1 * cos r2
;;;;;		    LMS	    R6,CWORK16	    ; y * sin r1 * cos r2
;;;;		    WITH    R1		    ;
;;;;		    MULT    R6		    ;
;;;;					    ;
;;;;		    LMS	    R6,CWORK18	    ; z * cos r1 * cos r2
;;;;;		    LMS	    R6,CWORK15	    ; z * cos r1 * cos r2
;;;;		    MULT    R6		    ;
;;;;		    ADD	    R1		    ;
;;;;		    SUB	    R2		    ;
;;;;		    ADD	    R0		    ;
;;;;		    ADD	    R0		    ;
;;;;		    HIB			    ;
;;;;
;;;;		    IWT	    R1,#00100H
;;;;;		    IBT	    R2,#004H
;;;;		    IBT	    R3,#008H
;;;;
;;;;		    FROM    R1
;;;;		    SUB	    R0
;;;;		    LOB
;;;;;
;;;;;		    CMP	    R2
;;;;;		    BCS	    COLST_0200
;;;;;		    NOP
;;;;;
;;;;;		    IBT	    R0,#004H
;;;;;;
;;;;;COLST_0200
;;;;		    CMP	    R3
;;;;		    BCC	    COLST_0300
;;;;		    NOP
;;;;
;;;;		    IBT	    R0,#007H
;;;;
;;;;COLST_0300
;;;;		    COLOR
;;;;;
;;;;;==================< drow >=======================================
;;;;
;;;;		    MOVE    R0,R7
;;;;		    DEC	    R0
;;;;		    SMS	    R0,CWORK5	    ;line adjust
;;;;		    SMS	    R0,CWORK6	    ;	  "
;;;;		    SUB	    R0
;;;;		    SMS	    R0,CWORKA	    ;drow loop counter set
;;;;		    SMS	    R0,CWORKB	    ;drow loop counter set
;;;;
;;;;		    LMS	    R0,REG0
;;;;		    INC	    R0
;;;;		    SBK
;;;;
;;;;		    CACHE
;;;;DR_START
;;;;		    LMS	    R0,CWORKA
;;;;		    DEC	    R0
;;;;		    BPL	    DR_0100
;;;;		    SBK
;;;;
;;;;		    LINK    #004H
;;;;		    IWT	    R15,#NEXT_L_LINE
;;;;		    NOP
;;;;
;;;;DR_0100
;;;;		    LMS	    R0,CWORKB
;;;;		    DEC	    R0
;;;;		    BPL	    DR_0200
;;;;		    SBK
;;;;
;;;;		    LINK    #004H
;;;;		    IWT	    R15,#NEXT_R_LINE
;;;;		    NOP
;;;;
;;;;DR_0200
;;;;		    LM	    R3,POIXPSL	    ;r3 <-- x pos.
;;;;		    LM	    R5,POIRL	    ;r5 <-- R
;;;;		    LM	    R9,POIXADL	    ;r9 <-- x add data
;;;;
;;;;		    LM	    R0,POICNDL	    ;|DX| < |DY| ?
;;;;		    MOVES   R0,R0
;;;;		    BNE	    DR_1500	    ;
;;;;		    NOP			    ; yes: DR_1500
;;;;
;;;;		    LMS	    R4,CWORKC	    ;r4 <-- x end pos.
;;;;		    LM	    R6,POI2DYL	    ;r6 <-- 2DY
;;;;
;;;;DR_1000
;;;;		    FROM    R3		    ;x end ?
;;;;		    CMP	    R4		    ;
;;;;		    BEQ	    DR_1800	    ;
;;;;		    WITH    R3		    ; yes: DR_1800
;;;;
;;;;		    ADD	    R9		    ;x <-- x + 1 or -1
;;;;
;;;;		    WITH    R5		    ;R <-- R + 2DY
;;;;		    ADD	    R6		    ;R < 0 ?
;;;;		    BMI	    DR_1000	    ;
;;;;		    NOP			    ; yes: DR_1000
;;;;
;;;;		    LM	    R6,POI2DXL	    ;R <-- R - 2DX
;;;;		    WITH    R5		    ;
;;;;
;;;;		    BRA	    DR_1800
;;;;		    SUB	    R6		    ;
;;;;
;;;;DR_1500
;;;;		    LM	    R6,POI2DXL	    ;r6 <-- 2DX
;;;;
;;;;DR_1600
;;;;		    WITH    R5		    ;R <-- R + 2DX
;;;;		    ADD	    R6		    ;R < 0 ?
;;;;		    BMI	    DR_1800	    ;
;;;;		    WITH    R3		    ; yes: DR_1800
;;;;
;;;;		    ADD	    R9		    ;X <-- X + 1 or -1
;;;;
;;;;		    LM	    R6,POI2DYL	    ;R <-- R - 2DY
;;;;		    WITH    R5		    ;
;;;;		    SUB	    R6		    ;
;;;;
;;;;DR_1800
;;;;		    SM	    R3,POIXPSL	    ;POIXPSL <-- r3
;;;;		    SM	    R5,POIRL	    ;POIRL   <-- r5
;;;;
;;;;
;;;;		    LM	    R3,POIXPSR	    ;r3 <-- x pos.
;;;;		    LM	    R5,POIRR	    ;r5 <-- R
;;;;		    LM	    R9,POIXADR	    ;r9 <-- x add data
;;;;
;;;;		    LM	    R0,POICNDR	    ;|DX| < |DY| ?
;;;;		    MOVES   R0,R0
;;;;		    BNE	    DR_2500	    ;
;;;;		    NOP			    ; yes: DR_2500
;;;;
;;;;		    LMS	    R4,CWORKD	    ;r4 <-- x end pos.
;;;;		    LM	    R6,POI2DYR	    ;r6 <-- 2DY
;;;;
;;;;DR_2000
;;;;		    FROM    R3		    ;x end ?
;;;;		    CMP	    R4		    ;
;;;;		    BEQ	    DR_2800	    ;
;;;;		    WITH    R3		    ; yes: DR_2800
;;;;
;;;;		    ADD	    R9		    ;x <-- x + 1 or -1
;;;;
;;;;		    WITH    R5		    ;R <-- R + 2DY
;;;;		    ADD	    R6		    ;R < 0 ?
;;;;		    BMI	    DR_2000	    ;
;;;;		    NOP			    ; yes: DR_2000
;;;;
;;;;		    LM	    R6,POI2DXR	    ;R <-- R - 2DX
;;;;		    WITH    R5		    ;
;;;;
;;;;		    BRA	    DR_2800
;;;;		    SUB	    R6		    ;
;;;;
;;;;DR_2500
;;;;		    LM	    R6,POI2DXR	    ;r6 <-- 2DX
;;;;
;;;;DR_2600
;;;;		    WITH    R5		    ;R <-- R + 2DX
;;;;		    ADD	    R6		    ;R < 0 ?
;;;;		    BMI	    DR_2800	    ;
;;;;		    WITH    R3		    ; yes: DR_2800
;;;;
;;;;		    ADD	    R9		    ;X <-- X + 1 or -1
;;;;
;;;;		    LM	    R6,POI2DYR	    ;R <-- R - 2DY
;;;;		    WITH    R5		    ;
;;;;		    SUB	    R6		    ;
;;;;
;;;;DR_2800
;;;;		    SM	    R3,POIXPSR	    ;POIXPSL <-- r3
;;;;		    SM	    R5,POIRR	    ;POIRL   <-- r5
;;;;
;;;;		    LM	    R1,POIXPSL
;;;;		    IBT	    R0,#050H
;;;;		    FROM    R7
;;;;		    TO	    R2
;;;;		    ADD	    R0
;;;;
;;;;		    LM	    R3,POIXPSR	    ;r12 <-- Xr pos. - Xl pos. + 1
;;;;
;;;;		    FROM    R3		    ;left pos. >= right pos. ?
;;;;		    CMP	    R1		    ;
;;;;		    BPL	    DR_2900	    ;
;;;;		    NOP			    ; yes: DR_2900
;;;;
;;;;		    MOVE    R0,R1
;;;;		    MOVE    R1,R3
;;;;		    MOVE    R3,R0
;;;;
;;;;DR_2900
;;;;		    FROM    R3		    ;
;;;;		    TO	    R12		    ;
;;;;		    SUB	    R1		    ;
;;;;		    INC	    R12		    ;
;;;;
;;;;;		    IBT	    R0,#020H	    ;r0 <-- center revise ( obj bit map )
;;;;		    IBT	    R0,#060H	    ;r0 <-- center revise ( 256col bit map )
;;;;
;;;;		    WITH    R1
;;;;		    ADD	    R0
;;;;
;;;;		    MOVE    R13,R15
;;;;
;;;;		    LOOP
;;;;		    PLOT
;;;;
;;;;DR_3000
;;;;		    INC	    R7		    ;all line ok ?
;;;;		    LMS	    R0,CWORK0	    ;
;;;;		    CMP	    R7		    ;
;;;;		    BEQ	    D_END	    ;
;;;;		    NOP			    ; yes: D_END
;;;;
;;;;		    IWT	    R15,#DR_START
;;;;		    NOP
;;;;
;;;;D_END
;;;;;---------< large loop end >--------------
;;;;		    LMS	    R12,REG12	    ;r12 <-- large loop counter
;;;;		    LMS	    R13,REG13	    ;r13 <-- large loop pointer
;;;;		    INC	    R13		    ;
;;;;		    LMS	    R14,REG14	    ;r14 <-- face data rom p.
;;;;
;;;;		    LOOP
;;;;		    NOP
;;;;
;;;;		    RPIX		    ;
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;
;;;;;
;;;;NEXT_L_LINE	    EQU	    $
;;;;		    SMS	    R11,RTS0
;;;;
;;;;		    LMS	    R0,CWORK2	    ;new from point <-- to point
;;;;		    SMS	    R0,CWORK1	    ;
;;;;
;;;;		    MOVE    R1,R0	    ;new to point calc.
;;;;		    LMS	    R2,CWORKE	    ;
;;;;		    INC	    R1		    ;
;;;;		    FROM    R1		    ;
;;;;		    CMP	    R2		    ;
;;;;		    BMI	    N_L_L0100	    ;
;;;;		    WITH    R1		    ;
;;;;					    ;
;;;;		    SUB	    R1		    ;
;;;;					    ;
;;;;N_L_L0100				    ;
;;;;		    SMS	    R1,CWORK2	    ;
;;;;
;;;;		    IWT	    R10,#POIYPS1
;;;;
;;;;		    ADD	    R0		    ;MULT #004H
;;;;		    ADD	    R0		    ;
;;;;		    TO	    R9
;;;;		    ADD	    R10
;;;;
;;;;		    TO	    R4		    ;r4 <-- y1
;;;;		    LDW	    (R9)
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;
;;;;		    TO	    R3		    ;r3 <-- x1
;;;;		    LDW	    (R9)
;;;;		    SM	    R3,POIXPSL	    ;POIXPSL <-- x1
;;;;
;;;;		    FROM    R1		    ;FROM R1
;;;;		    ADD	    R1		    ;MULT #004H
;;;;		    ADD	    R0		    ;
;;;;		    TO	    R9
;;;;		    ADD	    R10
;;;;
;;;;		    TO	    R6		    ;r6 <-- y2
;;;;		    LDW	    (R9)
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    SMS	    R6,CWORK5	    ;CWORK5 <-- y2
;;;;
;;;;		    LDW	    (R9)	    ;r0 <-- x2
;;;;		    SMS	    R0,CWORKC	    ;CWORKC <-- x2
;;;;
;;;;		    IBT	    R10,#001H	    ;r11 <-- X add data
;;;;
;;;;		    TO	    R3		    ;r3 <-- |x2 - x1|
;;;;		    SUB	    R3		    ;
;;;;		    BPL	    N_L_L0200
;;;;		    WITH    R3
;;;;		    NOT
;;;;		    INC	    R3
;;;;
;;;;		    IBT	    R10,#0FFH	    ;r11 <-- x add data
;;;;
;;;;N_L_L0200
;;;;		    WITH    R6		    ;r6 <-- y2 - y1
;;;;		    SUB	    R4		    ;
;;;;		    SMS	    R6,CWORKA	    ;drow loop counter set
;;;;
;;;;		    SM	    R10,POIXADL	    ;POIXADL <-- r11
;;;;
;;;;		    FROM    R3		    ;POI2DXL <-- r3 * 2
;;;;		    ADD	    R3		    ;
;;;;		    SM	    R0,POI2DXL	    ;
;;;;
;;;;		    FROM    R6		    ;POI2DYL <-- r6 * 2
;;;;		    ADD	    R6		    ;
;;;;		    SM	    R0,POI2DYL	    ;
;;;;
;;;;		    WITH    R10		    ;r10 <-- 0
;;;;		    SUB	    R10		    ;
;;;;
;;;;		    FROM    R3		    ;DX >= DY ?
;;;;		    CMP	    R6		    ;
;;;;		    BPL	    N_L_L0300	    ; yes: N_L_L0300
;;;;
;;;;		    FROM    R6
;;;;		    NOT
;;;;		    BRA	    N_L_L0400
;;;;		    INC	    R10
;;;;
;;;;N_L_L0300
;;;;		    FROM    R3
;;;;		    NOT
;;;;
;;;;N_L_L0400
;;;;		    INC	    R0		    ;POIRL <-- -(x2 - x1) or -(y2 - y1)
;;;;		    SM	    R0,POIRL	    ;
;;;;
;;;;		    SM	    R10,POICNDL	    ;POICNDL <-- r10
;;;;
;;;;		    LMS	    R15,RTS0
;;;;		    NOP
;;;;
;;;;
;;;;
;;;;NEXT_R_LINE	    EQU	    $
;;;;		    SMS	    R11,RTS0
;;;;
;;;;		    LMS	    R0,CWORK4	    ;new from point <-- to point
;;;;		    SMS	    R0,CWORK3	    ;
;;;;
;;;;		    MOVE    R1,R0	    ;new to point calc.
;;;;		    DEC	    R1		    ;
;;;;		    BPL	    N_R_L0100	    ;
;;;;		    NOP			    ;
;;;;					    ;
;;;;		    LMS	    R1,CWORKE	    ;
;;;;		    DEC	    R1		    ;
;;;;					    ;
;;;;N_R_L0100				    ;
;;;;		    SMS	    R1,CWORK4	    ;
;;;;
;;;;		    IWT	    R10,#POIYPS1
;;;;
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R9
;;;;		    ADD	    R10
;;;;
;;;;		    TO	    R4		    ;r4 <-- y1
;;;;		    LDW	    (R9)
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;
;;;;		    TO	    R3		    ;r3 <-- x1
;;;;		    LDW	    (R9)
;;;;
;;;;		    SM	    R3,POIXPSR	    ;POIXPSR <-- x1
;;;;
;;;;		    FROM    R1		    ;FROM R1
;;;;		    ADD	    R1		    ;MULT #004H
;;;;		    ADD	    R0		    ;
;;;;		    TO	    R9
;;;;		    ADD	    R10
;;;;
;;;;		    TO	    R6		    ;r6 <-- y2
;;;;		    LDW	    (R9)
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    SMS	    R6,CWORK6	    ;CWORK6 <-- y2
;;;;
;;;;		    LDW	    (R9)	    ;r0 <-- x2
;;;;		    SMS	    R0,CWORKD	    ;CWORKD <-- x2
;;;;
;;;;		    IBT	    R10,#001H	    ;r10 <-- X add data
;;;;
;;;;		    TO	    R3		    ;r3 <-- |x2 - x1|
;;;;		    SUB	    R3		    ;
;;;;		    BPL	    N_R_L0200
;;;;		    WITH    R3
;;;;		    NOT
;;;;		    INC	    R3
;;;;
;;;;		    IBT	    R10,#0FFH	    ;r10 <-- X add data
;;;;
;;;;N_R_L0200
;;;;		    WITH    R6		    ;r6 <-- y2 - y1
;;;;		    SUB	    R4		    ;
;;;;		    SMS	    R6,CWORKB	    ;drow loop counter set
;;;;
;;;;		    SM	    R10,POIXADR	    ;POIXADR <-- r10
;;;;
;;;;		    FROM    R3		    ;POI2DXR <-- r3 * 2
;;;;		    ADD	    R3		    ;
;;;;		    SM	    R0,POI2DXR	    ;
;;;;
;;;;		    FROM    R6		    ;POI2DYR <-- r6 * 2
;;;;		    ADD	    R6		    ;
;;;;		    SM	    R0,POI2DYR	    ;
;;;;
;;;;		    WITH    R10		    ;r10 <-- 0
;;;;		    SUB	    R10		    ;
;;;;
;;;;		    FROM    R3		    ;DX >= DY ?
;;;;		    CMP	    R6		    ;
;;;;		    BPL	    N_R_L0300	    ; yes: N_R_L0300
;;;;
;;;;		    FROM    R6
;;;;		    NOT
;;;;		    BRA	    N_R_L0400
;;;;		    INC	    R10		    ;r10 <-- COND
;;;;
;;;;N_R_L0300
;;;;		    FROM    R3
;;;;		    NOT
;;;;
;;;;N_R_L0400
;;;;		    INC	    R0		    ;POIRR <-- -(x2 - x1) or -(y2 - y1)
;;;;		    SM	    R0,POIRR	    ;
;;;;
;;;;		    SM	    R10,POICNDR	    ;POICNDR <-- r10
;;;;
;;;;		    LMS	    R15,RTS0
;;;;		    NOP
;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;POI		    EQU	    $
;;;;		    HEX	    4
;;;;		    HEX	    000,0E0,000
;;;;		    HEX	    018,020,000
;;;;		    HEX	    0E8,020,020
;;;;		    HEX	    0E8,020,0E0
;;;;;
;;;;;		    HEX	    4
;;;;;		    HEX	    000,0F8,000
;;;;;		    HEX	    006,008,000
;;;;;		    HEX	    0FA,008,008
;;;;;		    HEX	    0FA,008,0F8
;;;;;
;;;;		    HEX	    8		    ;[ point sum. ]
;;;;		    HEX	    0D8,0D8,0D8	    ;[0][ (z),(y),(x) ]
;;;;		    HEX	    0D8,0D8,028	    ;[1][ (z),(y),(x) ]
;;;;		    HEX	    0D8,028,028	    ;[2][ (z),(y),(x) ]
;;;;		    HEX	    0D8,028,0D8	    ;[3][ (z),(y),(x) ]
;;;;		    HEX	    028,0D8,0D8	    ;[4][ (z),(y),(x) ]
;;;;		    HEX	    028,0D8,028	    ;[5][ (z),(y),(x) ]
;;;;		    HEX	    028,028,028	    ;[6][ (z),(y),(x) ]
;;;;		    HEX	    028,028,0D8	    ;[7][ (z),(y),(x) ]
;;;;;
;;;;		    HEX	    8		    ;[ point sum. ]
;;;;		    HEX	    0F8,0F8,0F8	    ;[0][ (z),(y),(x) ]
;;;;		    HEX	    0F8,0F8,008	    ;[1][ (z),(y),(x) ]
;;;;		    HEX	    0F8,008,008	    ;[2][ (z),(y),(x) ]
;;;;		    HEX	    0F8,008,0F8	    ;[3][ (z),(y),(x) ]
;;;;		    HEX	    008,0F8,0F8	    ;[4][ (z),(y),(x) ]
;;;;		    HEX	    008,0F8,008	    ;[5][ (z),(y),(x) ]
;;;;		    HEX	    008,008,008	    ;[6][ (z),(y),(x) ]
;;;;		    HEX	    008,008,0F8	    ;[7][ (z),(y),(x) ]
;;;;;
;;;;FACE	    EQU	    $
;;;;		    HEX	    4
;;;;		    HEX	    3,0,2,1
;;;;		    HEX	    009,0FD,00C
;;;;		    HEX	    3,0,3,2
;;;;		    HEX	    0F1,0FB,000
;;;;		    HEX	    3,0,1,3
;;;;		    HEX	    009,0FD,0F4
;;;;		    HEX	    3,1,2,3
;;;;		    HEX	    000,00F,000
;;;;;
;;;;
;;;;		    HEX	    6		    ;[ face sum. ]
;;;;		    HEX	    4,0,3,2,1	    ;[0][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    0F1,000,000
;;;;		    HEX	    4,0,1,5,4	    ;[1][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    000,0F1,000
;;;;		    HEX	    4,0,4,7,3	    ;[2][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    000,000,0F1
;;;;		    HEX	    4,1,2,6,5	    ;[3][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    000,000,00F
;;;;		    HEX	    4,2,3,7,6	    ;[4][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    000,00F,000
;;;;		    HEX	    4,4,5,6,7	    ;[5][ (point sum),(col),(point no),.... ]
;;;;		    HEX	    00F,000,000
;;;;;
;;;;;		    HEX	    6		    ;[ face sum. ]
;;;;;		    HEX	    4,1,0,3,2,1	    ;[0][ (point sum),(col),(point no),.... ]
;;;;;		    HEX	    4,2,0,1,5,4	    ;[1][ (point sum),(col),(point no),.... ]
;;;;;		    HEX	    4,3,0,4,7,3	    ;[2][ (point sum),(col),(point no),.... ]
;;;;;		    HEX	    4,4,1,2,6,5	    ;[3][ (point sum),(col),(point no),.... ]
;;;;;		    HEX	    4,5,2,3,7,6	    ;[4][ (point sum),(col),(point no),.... ]
;;;;;		    HEX	    4,6,4,5,6,7	    ;[5][ (point sum),(col),(point no),.... ]
;;;;;
;;;;;
;
;
;************************************************************************
;*									*
;*		HDMABF SPACE CLEAR					*
;*									*
;************************************************************************
HDMABF_CLR	EQU	$
		IBT	R0,#BANK HDMABF		;HDMABF ram bank set
		RAMB

		IWT	R1,#HDMABF
		IWT	R2,#HDMABF1

		IBT	R0,#0FFH-8		;clear data

;;;;		    IWT	    R12,#000B2H
		IWT	R12,#000D2H
		CACHE
		MOVE	R13,R15

		STW	(R1)
		STW	(R2)
		INC	R1
		INC	R1
		INC	R2
		INC	R2

		LOOP
		DEC	R0

		STOP
		NOP
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;		    r1...   x display pos.
;;;;;		    r2...   y display pos.
;;;;;		    r3...   y base pos.
;;;;;
;;;;TOFU_BLOCK	    EQU	    $
;;;;		    IBT	    R0,#078H
;;;;		    TO	    R1
;;;;		    SUB	    R1
;;;;
;;;;		    IBT	    R0,#BANK TOFU_DATA	    ;rom bank set
;;;;		    ROMB
;;;;
;;;;		    IWT	    R0,#TOFU_DATA	    ;rom pointer set
;;;;		    TO	    R14
;;;;		    ADD	    R4
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    TO	    R6
;;;;		    GETBH
;;;;
;;;;		    IBT	    R0,#BANK HDMABF	    ;ram bank set
;;;;		    RAMB
;;;;
;;;;		    IWT	    R4,#HDMABF		    ;ram addr. set
;;;;		    IWT	    R5,#HDMABF1		    ;ram addr. set
;;;;
;;;;		    FROM    R3
;;;;		    MULT    R10
;;;;		    TO	    R14
;;;;		    ADD	    R6
;;;;		    MOVE    R6,R14
;;;;
;;;;		    TO	    R7			    ;h wide get
;;;;		    GETB			    ;
;;;;		    WITH    R14			    ;
;;;;		    ADD	    R11			    ;
;;;;		    SMS	    R7,CWORK0
;;;;
;;;;		    TO	    R8			    ;v wide get
;;;;		    GETB			    ;
;;;;		    FROM    R6
;;;;		    TO	    R14
;;;;		    ADD	    R10
;;;;		    DEC	    R14
;;;;		    SMS	    R8,CWORK1
;;;;
;;;;		    TO	    R9			    ;square wide get
;;;;		    GETB			    ;
;;;;		    INC	    R14			    ;
;;;;
;;;;		    SUB	    R0
;;;;		    SMS	    R0,CWORK2
;;;;
;;;;
;;;;
;;;;		    IWT	    R13,#000B2H
;;;;
;;;;		    FROM    R2
;;;;		    CMP	    R13
;;;;		    BCC	    TOFU0200
;;;;		    NOP
;;;;
;;;;		    BPL	    TOFU0100
;;;;		    NOP
;;;;
;;;;		    WITH    R9
;;;;		    ADD	    R2
;;;;		    FROM    R9
;;;;		    HIB
;;;;		    BMI	    TOFU0800
;;;;		    NOP
;;;;
;;;;		    IBT	    R0,#0FFH	    ;5
;;;;		    TO	    R7
;;;;		    ADD	    R7
;;;;		    BRA	    TOFU0700
;;;;		    NOP
;;;;
;;;;TOFU0100
;;;;		    FROM    R2
;;;;		    SUB	    R8
;;;;		    CMP	    R13
;;;;		    BCS	    TOFU0800
;;;;		    NOP
;;;;
;;;;		    IBT	    R6,#001H	    ;3
;;;;		    SMS	    R6,CWORK2
;;;;
;;;;		    FROM    R13
;;;;		    SUB	    R0
;;;;		    SMS	    R0,CWORK1
;;;;
;;;;		    BRA	    TOFU0500
;;;;		    NOP
;;;;
;;;;TOFU0200
;;;;		    FROM    R2
;;;;		    TO	    R6
;;;;		    SUB	    R8
;;;;		    FROM    R6
;;;;		    HIB
;;;;		    BPL	    TOFU0300
;;;;		    NOP
;;;;
;;;;		    WITH    R8		    ;2
;;;;		    ADD	    R6
;;;;
;;;;		    SMS	    R8,CWORK1
;;;;		    BRA	    TOFU0500
;;;;		    NOP
;;;;
;;;;TOFU0300
;;;;		    FROM    R2
;;;;		    ADD	    R9
;;;;		    CMP	    R13
;;;;		    BCC	    TOFU0500
;;;;		    NOP
;;;;
;;;;		    FROM    R13		    ;1
;;;;		    TO	    R9
;;;;		    SUB	    R2
;;;;
;;;;TOFU0500
;;;;
;;;;		    INC	    R8			    ;v wide inc.
;;;;
;;;;		    FROM    R8
;;;;		    MULT    R10
;;;;		    WITH    R14
;;;;		    SUB	    R0
;;;;
;;;;		    DEC	    R8			    ;v wide dae.
;;;;
;;;;
;;;;		    WITH    R2
;;;;		    SUB	    R8
;;;;
;;;;		    FROM    R2
;;;;		    ADD	    R2
;;;;
;;;;		    WITH    R4			    ;set ram addr. calc.
;;;;		    ADD	    R0			    ;
;;;;
;;;;		    WITH    R5			    ;set ram addr. calc.
;;;;		    ADD	    R0			    ;
;;;;
;;;;		    IBT	    R0,#0FFH		    ;v base wide set
;;;;		    TO	    R7			    ;
;;;;		    SUB	    R2			    ;
;;;;
;;;;		    LMS	    R12,CWORK1
;;;;		    MOVES   R12,R12
;;;;		    BNE	    TOFU0600
;;;;		    NOP
;;;;
;;;;		    LMS	    R0,CWORK0
;;;;		    ADD	    R7
;;;;		    BRA	    TOFU0700
;;;;		    NOP
;;;;
;;;;TOFU0600
;;;;		    JSR	    TOFU_UPPER
;;;;
;;;;TOFU0700
;;;;		    LMS	    R6,CWORK2		    ;square drow ?
;;;;		    MOVES   R6,R6		    ;
;;;;		    BNE	    TOFU0800		    ;  no: TOFU0800
;;;;		    NOP
;;;;
;;;;		    IWT	    R7,#00100H		    ;h wide set (lock)
;;;;		    TO	    R7
;;;;		    SUB	    R7
;;;;
;;;;		    MOVES   R12,R9
;;;;		    BEQ	    TOFU0800
;;;;		    NOP
;;;;
;;;;		    JSR	    TOFU_UNDER
;;;;
;;;;TOFU0800
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;
;;;;TOFU_UPPER	    EQU	    $
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;		    GETB			    ;wide calc. & set
;;;;		    WITH    R14			    ;
;;;;		    ADD	    R10			    ;
;;;;						    ;
;;;;		    ADD	    R7			    ;
;;;;		    STW	    (R4)		    ;
;;;;		    INC	    R4			    ;
;;;;		    INC	    R4			    ;
;;;;
;;;;		    FROM    R1			    ;center set
;;;;		    STW	    (R5)		    ;
;;;;		    INC	    R5			    ;
;;;;		    INC	    R5			    ;
;;;;
;;;;		    LOOP
;;;;		    DEC	    R7
;;;;
;;;;		    RTS
;;;;;
;;;;TOFU_UNDER	    EQU	    $
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;		    FROM    R7			    ;wide set
;;;;		    STW	    (R4)		    ;
;;;;		    INC	    R4			    ;
;;;;		    INC	    R4			    ;
;;;;
;;;;		    FROM    R1			    ;center set
;;;;		    STW	    (R5)		    ;
;;;;		    INC	    R5			    ;
;;;;		    INC	    R5			    ;
;;;;
;;;;		    LOOP
;;;;		    DEC	    R7
;;;;
;;;;		    RTS
;;;;;
;;;;;
;;;;;
;;;;TOFU_DATA	    EQU	    $
;;;;		    WORD    TOFU_SHOT		    ;tofu block shot
;;;;		    WORD    TOFU_STEP		    ;tofu expand step
;;;;;
;;;;TOFU_SHOT	    EQU	    $
;;;;;	    X START WIDE =008,Y START WIDE =002
;;;;;	    X  END  WIDE =040,Y	 END  WIDE =016
;;;;;	    Z	    WIDE =050
;;;;		    HEX	    008,000,000,000,000,002
;;;;		    HEX	    008,000,000,000,000,002
;;;;		    HEX	    009,000,000,000,000,002
;;;;		    HEX	    00A,000,000,000,001,002
;;;;		    HEX	    00A,000,000,001,001,003
;;;;		    HEX	    00B,000,001,001,001,003
;;;;		    HEX	    00C,000,001,001,002,003
;;;;		    HEX	    00C,000,001,001,002,003
;;;;		    HEX	    00D,000,001,002,002,004
;;;;		    HEX	    00E,000,001,002,003,004
;;;;		    HEX	    00F,001,002,002,003,004
;;;;		    HEX	    00F,001,002,003,003,004
;;;;		    HEX	    010,001,002,003,004,005
;;;;		    HEX	    011,001,002,003,004,005
;;;;		    HEX	    011,001,002,003,004,005
;;;;		    HEX	    012,001,003,004,005,005
;;;;		    HEX	    013,001,003,004,005,006
;;;;		    HEX	    014,001,003,004,005,006
;;;;		    HEX	    014,001,003,005,006,006
;;;;		    HEX	    015,001,003,005,006,006
;;;;		    HEX	    016,002,004,005,006,007
;;;;		    HEX	    016,002,004,005,007,007
;;;;		    HEX	    017,002,004,006,007,007
;;;;		    HEX	    018,002,004,006,007,007
;;;;		    HEX	    018,002,004,006,008,008
;;;;		    HEX	    019,002,005,007,008,008
;;;;		    HEX	    01A,002,005,007,008,008
;;;;		    HEX	    01B,002,005,007,009,008
;;;;		    HEX	    01B,002,005,007,009,009
;;;;		    HEX	    01C,002,005,008,009,009
;;;;		    HEX	    01D,003,006,008,00A,009
;;;;		    HEX	    01D,003,006,008,00A,009
;;;;		    HEX	    01E,003,006,008,00A,00A
;;;;		    HEX	    01F,003,006,009,00B,00A
;;;;		    HEX	    020,003,006,009,00B,00A
;;;;		    HEX	    020,003,007,009,00B,00A
;;;;		    HEX	    021,003,007,00A,00C,00B
;;;;		    HEX	    022,003,007,00A,00C,00B
;;;;		    HEX	    022,003,007,00A,00C,00B
;;;;		    HEX	    023,003,007,00A,00D,00B
;;;;		    HEX	    024,004,008,00B,00D,00C
;;;;		    HEX	    024,004,008,00B,00D,00C
;;;;		    HEX	    025,004,008,00B,00E,00C
;;;;		    HEX	    026,004,008,00C,00E,00C
;;;;		    HEX	    027,004,008,00C,00E,00D
;;;;		    HEX	    027,004,009,00C,00F,00D
;;;;		    HEX	    028,004,009,00C,00F,00D
;;;;		    HEX	    029,004,009,00D,00F,00D
;;;;		    HEX	    029,004,009,00D,010,00E
;;;;		    HEX	    02A,004,009,00D,010,00E
;;;;		    HEX	    02B,005,00A,00E,011,00E
;;;;		    HEX	    02C,005,00A,00E,011,00E
;;;;		    HEX	    02C,005,00A,00E,011,00F
;;;;		    HEX	    02D,005,00A,00E,012,00F
;;;;		    HEX	    02E,005,00A,00F,012,00F
;;;;		    HEX	    02E,005,00B,00F,012,00F
;;;;		    HEX	    02F,005,00B,00F,013,010
;;;;		    HEX	    030,005,00B,00F,013,010
;;;;		    HEX	    031,005,00B,010,013,010
;;;;		    HEX	    031,005,00B,010,014,010
;;;;		    HEX	    032,006,00C,010,014,011
;;;;		    HEX	    033,006,00C,011,014,011
;;;;		    HEX	    033,006,00C,011,015,011
;;;;		    HEX	    034,006,00C,011,015,011
;;;;		    HEX	    035,006,00C,011,015,012
;;;;		    HEX	    035,006,00D,012,016,012
;;;;		    HEX	    036,006,00D,012,016,012
;;;;		    HEX	    037,006,00D,012,016,012
;;;;		    HEX	    038,006,00D,013,017,013
;;;;		    HEX	    038,006,00D,013,017,013
;;;;		    HEX	    039,007,00E,013,017,013
;;;;		    HEX	    03A,007,00E,013,018,013
;;;;		    HEX	    03A,007,00E,014,018,014
;;;;		    HEX	    03B,007,00E,014,018,014
;;;;		    HEX	    03C,007,00E,014,019,014
;;;;		    HEX	    03D,007,00F,015,019,014
;;;;		    HEX	    03D,007,00F,015,019,015
;;;;		    HEX	    03E,007,00F,015,01A,015
;;;;		    HEX	    03F,007,00F,015,01A,015
;;;;		    HEX	    03F,007,00F,016,01A,015
;;;;;
;;;;TOFU_STEP	    EQU	    $
;;;;;	    X START WIDE =020,Y START WIDE =00A
;;;;;	    X  END  WIDE =040,Y	 END  WIDE =010
;;;;;	    Z	    WIDE =020
;;;;		    HEX	    020,000,00A
;;;;		    HEX	    021,001,00A
;;;;		    HEX	    022,002,00A
;;;;		    HEX	    023,003,00A
;;;;		    HEX	    024,004,00A
;;;;		    HEX	    025,005,00A
;;;;		    HEX	    026,006,00B
;;;;		    HEX	    027,007,00B
;;;;		    HEX	    028,008,00B
;;;;		    HEX	    029,009,00B
;;;;		    HEX	    02A,00A,00B
;;;;		    HEX	    02B,00B,00C
;;;;		    HEX	    02C,00C,00C
;;;;		    HEX	    02D,00D,00C
;;;;		    HEX	    02E,00E,00C
;;;;		    HEX	    02F,00F,00C
;;;;		    HEX	    030,010,00D
;;;;		    HEX	    031,011,00D
;;;;		    HEX	    032,012,00D
;;;;		    HEX	    033,013,00D
;;;;		    HEX	    034,014,00D
;;;;		    HEX	    035,015,00E
;;;;		    HEX	    036,016,00E
;;;;		    HEX	    037,017,00E
;;;;		    HEX	    038,018,00E
;;;;		    HEX	    039,019,00E
;;;;		    HEX	    03A,01A,00E
;;;;		    HEX	    03B,01B,00F
;;;;		    HEX	    03C,01C,00F
;;;;		    HEX	    03D,01D,00F
;;;;		    HEX	    03E,01E,00F
;;;;		    HEX	    03F,01F,00F
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;CORNER_CHK	    MACRO   XPOS,YPOS,DMODE,CMPDT,XWIDE,YWIDE
;;;;		    LOCAL   C_CHK0100,C_CHK0200,C_CHK0300
;;;;		    LOCAL   C_CHK1000,C_CHK1100,C_CHK1200,C_CHK1300,C_CHK1400
;;;;		    LOCAL   C_CHK2000
;;;;
;;;;		    DEC	    CMPDT
;;;;		    BEQ	    C_CHK1000
;;;;		    NOP
;;;;
;;;;		    MOVES   DMODE,DMODE	    ;DMODE...
;;;;		    BEQ	    C_CHK0100	    ;	    0: C_CHK0100
;;;;		    NOP			    ;
;;;;		    FROM    DMODE	    ;
;;;;		    SUB	    #002	    ;
;;;;		    BEQ	    C_CHK0300	    ;	    2: C_CHK0300
;;;;		    NOP			    ;
;;;;		    BMI	    C_CHK0200	    ;	    1: C_CHK0200
;;;;		    NOP			    ;
;;;;
;;;;		    BRA	    C_CHK2000
;;;;		    DEC	    YPOS
;;;;
;;;;C_CHK0100
;;;;		    BRA	    C_CHK2000
;;;;		    INC	    XPOS
;;;;
;;;;C_CHK0200
;;;;		    BRA	    C_CHK2000
;;;;		    INC	    YPOS
;;;;
;;;;C_CHK0300
;;;;		    BRA	    C_CHK2000
;;;;		    DEC	    XPOS
;;;;
;;;;C_CHK1000
;;;;		    MOVES   DMODE,DMODE	    ;DMODE...
;;;;		    BEQ	    C_CHK1100	    ;	    0: C_CHK1100
;;;;		    NOP			    ;
;;;;		    FROM    DMODE	    ;
;;;;		    SUB	    #002	    ;
;;;;		    BEQ	    C_CHK1300	    ;	    2: C_CHK1300
;;;;		    NOP			    ;
;;;;		    BMI	    C_CHK1200	    ;	    1: C_CHK1200
;;;;		    NOP			    ;
;;;;
;;;;		    LMS	    CMPDT,YWIDE
;;;;		    DEC	    CMPDT
;;;;		    FROM    CMPDT
;;;;		    SBK
;;;;
;;;;		    LMS	    CMPDT,XWIDE
;;;;		    BRA	    C_CHK1400
;;;;		    INC	    XPOS
;;;;
;;;;C_CHK1100
;;;;		    LMS	    CMPDT,XWIDE
;;;;		    DEC	    CMPDT
;;;;		    FROM    CMPDT
;;;;		    SBK
;;;;
;;;;		    LMS	    CMPDT,YWIDE
;;;;
;;;;		    BRA	    C_CHK1400
;;;;		    INC	    YPOS
;;;;
;;;;C_CHK1200
;;;;		    LMS	    CMPDT,YWIDE
;;;;		    DEC	    CMPDT
;;;;		    FROM    CMPDT
;;;;		    SBK
;;;;
;;;;		    LMS	    CMPDT,XWIDE
;;;;
;;;;		    BRA	    C_CHK1400
;;;;		    DEC	    XPOS
;;;;
;;;;C_CHK1300
;;;;		    LMS	    CMPDT,XWIDE
;;;;		    DEC	    CMPDT
;;;;		    FROM    CMPDT
;;;;		    SBK
;;;;
;;;;		    LMS	    CMPDT,YWIDE
;;;;		    DEC	    YPOS
;;;;
;;;;C_CHK1400
;;;;		    INC	    DMODE
;;;;		    WITH    DMODE
;;;;		    AND	    #003H
;;;;
;;;;C_CHK2000
;;;;		    ENDM
;;;;;
;;;;;
;;;;FREEAREA_CLR    EQU	    $
;;;;;---------------< mapping area clear >----------------
;;;;
;;;;		    CACHE
;;;;
;;;;		    IWT	    R7,#(WOB7CHR+20H*4)
;;;;		    IWT	    R8,#(WOB7CHR+20H*4)+200H
;;;;		    IWT	    R9,#(WOB7CHR+20H*4)+400H
;;;;		    IWT	    R10,#(WOB7CHR+20H*4)+600H
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    IWT	    R12,#(20H*4)/2
;;;;		    MOVE    R13,R15
;;;;
;;;;		    STW	    (R7)
;;;;		    INC	    R7
;;;;		    INC	    R7
;;;;		    STW	    (R8)
;;;;		    INC	    R8
;;;;		    INC	    R8
;;;;		    STW	    (R9)
;;;;		    INC	    R9
;;;;		    INC	    R9
;;;;		    STW	    (R10)
;;;;		    INC	    R10
;;;;		    LOOP
;;;;		    INC	    R10
;;;;;
;;;;		    IBT	    R0,#BANK DATACMP
;;;;		    RAMB
;;;;
;;;;		    IWT	    R1,#DATACMP
;;;;
;;;;		    SUB	    R0
;;;;
;;;;		    IBT	    R12,#010H
;;;;		    MOVE    R13,R15
;;;;
;;;;		    STW	    (R1)
;;;;
;;;;		    INC	    R1
;;;;
;;;;		    LOOP
;;;;		    INC	    R1
;;;;
;;;;		    STOP
;;;;		    NOP
;
;
;;;;;********************************************************
;;;;;*		    bit map block			    *
;;;;;********************************************************
;;;;;
;;;;;r1		    player x pos.
;;;;;r2		       "   y  "
;;;;;r3		       "   char. muki
;;;;;r4		       "   sit down flag
;;;;;r5		    enemy x pos.
;;;;;r6		      "   y  "
;;;;;
;;;;;
;;;;;
;;;;ERASER_XPOS	    EQU	    $
;;;;;	    PLCMKI =	     0	 2
;;;;		    HEX	    008,0F8
;;;;;		    HEX	    008,000
;;;;;
;;;;ERASER_YPOS	    EQU	    $
;;;;;	    PLSITD =	     0	 1   2	 3   4	 5
;;;;		    HEX	    008,00B,00D,00F,011,014
;;;;;
;;;;ERASER_DATA	    EQU	    $
;;;;;		    HEX	    08
;;;;;		    HEX	    10
;;;;;		    HEX	    5A
;;;;;		    HEX	    BF
;;;;;		    HEX	    7D
;;;;;		    HEX	    5C
;;;;;		    HEX	    08
;;;;;		    HEX	    10
;;;;		    HEX	    00,00
;;;;		    HEX	    00,01
;;;;		    HEX	    80,01
;;;;		    HEX	    C0,03
;;;;		    HEX	    E0,07
;;;;		    HEX	    F0,0F
;;;;		    HEX	    F8,1F
;;;;		    HEX	    FE,3F
;;;;		    HEX	    FC,7F
;;;;		    HEX	    F8,1F
;;;;		    HEX	    F0,0F
;;;;		    HEX	    E0,07
;;;;		    HEX	    C0,03
;;;;		    HEX	    80,01
;;;;		    HEX	    80,00
;;;;		    HEX	    00,00
;;;;;
;;;;BTBLK_SET	    EQU	    $
;;;;		    WITH    R3
;;;;		    DIV2
;;;;
;;;;		    IBT	    R0,#BANK ERASER_XPOS
;;;;		    ROMB
;;;;
;;;;		    IWT	    R0,#ERASER_XPOS
;;;;
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    GETBS
;;;;		    ADD	    R1
;;;;		    TO	    R3
;;;;		    SUB	    R5
;;;;
;;;;		    IWT	    R0,#ERASER_YPOS
;;;;
;;;;		    TO	    R14
;;;;		    ADD	    R4
;;;;		    GETB
;;;;		    ADD	    R2
;;;;		    TO	    R2
;;;;		    SUB	    R6
;;;;
;;;;;		    IBT	    R5,#008H		    ;c( range ) + 4( player center ) - 8( enemy center )
;;;;;		    IBT	    R6,#018H		    ;range * 2
;;;;
;;;;		    IBT	    R5,#010H		    ;10( range ) + 8( player center ) - 8( enemy center )
;;;;		    IBT	    R6,#020H		    ;range * 2
;;;;
;;;;		    FROM    R3			    ;x pos. over ?
;;;;		    ADD	    R5
;;;;		    CMP	    R6
;;;;		    BCS	    BTBLK_END2		    ; yes: BTBLK_END2
;;;;		    NOP
;;;;
;;;;		    FROM    R2			    ;y pos. over ?
;;;;		    ADD	    R5
;;;;		    CMP	    R6
;;;;;		    BCS	    BTBLK_END2		    ; yes: BTBLK_END2
;;;;		    BCC	    BTBLK_SET0010	    ;  no: BTBLK_SET0010
;;;;		    NOP
;;;;
;;;;BTBLK_END2
;;;;		    SUB	    R0			    ;IBT    R0,#000
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;
;;;;BTBLK_SET0010
;;;;		    DEC	    R2
;;;;;;;
;;;;		    IWT	    R14,#ERASER_DATA
;;;;
;;;;;		    IBT	    R0,#BANK CWORK0
;;;;;		    RAMB
;;;;
;;;;		    IWT	    R5,#CWORK0
;;;;
;;;;;		    IBT	    R12,#004H
;;;;		    IBT	    R12,#010H
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    GETBH
;;;;		    INC	    R14
;;;;		    STW	    (R5)
;;;;
;;;;		    INC	    R5
;;;;
;;;;		    LOOP
;;;;		    INC	    R5
;;;;;;;
;;;;
;;;;		    SUB	    R0			    ;IBT    R0,#000
;;;;		    CMODE			    ;mode set
;;;;
;;;;		    IBT	    R0,#BANK CIPCHD+6000H
;;;;		    ROMB
;;;;
;;;;		    IWT	    R6,#CIPCHD+6000H
;;;;
;;;;		    IWT	    R5,#CWORK0
;;;;
;;;;		    IBT	    R0,#BANK DATACMP
;;;;		    RAMB
;;;;
;;;;		    IWT	    R11,#DATACMP
;;;;
;;;;		    IBT	    R10,#020H
;;;;
;;;;		    SMS	    R3,REG3		    ;REG3 <-- eraser start x pos.
;;;;
;;;;;		    IBT	    R0,#008H		    ;L loop counter
;;;;		    IBT	    R0,#010H		    ;L loop counter
;;;;		    SMS	    R0,REG0
;;;;
;;;;		    CACHE
;;;;BTBLK_LLOOP
;;;;		    TO	    R9			    ;R5 <-- eraser data
;;;;;		    LDB	    (R5)
;;;;		    LDW	    (R5)
;;;;		    INC	    R5
;;;;		    INC	    R5
;;;;
;;;;		    INC	    R2
;;;;		    LMS	    R3,REG3		    ;R3 <-- eraser start x pos.
;;;;
;;;;;		    IBT	    R12,#008H		    ;S loop counter
;;;;		    IBT	    R12,#010H		    ;S loop counter
;;;;
;;;;		    MOVE    R13,R15
;;;;
;;;;BTBLK_SLOOP
;;;;		    FROM    R2
;;;;		    TO	    R7
;;;;		    SWAP
;;;;
;;;;		    FROM    R3
;;;;		    TO	    R8
;;;;		    SWAP
;;;;
;;;;		    MERGE			    ;draw area ?
;;;;		    BEQ	    BTBLK_SLP0100	    ;  no: BTBLK_SLP0100
;;;;
;;;;		    TO	    R14
;;;;		    ADD	    R6
;;;;
;;;;		    WITH    R9			    ;draw ??
;;;;		    ROR
;;;;		    BCC	    BTBLK_SLP0100	    ;  no: BTBLK_SLP0100
;;;;
;;;;		    FROM    R3
;;;;		    TO	    R1
;;;;		    ADD	    R10
;;;;
;;;;		    GETC
;;;;		    PLOT
;;;;
;;;;
;;;;		    IBT	    R0,#001H
;;;;		    MOVES   R4,R2
;;;;		    BEQ	    BTBLK_SSLP0050
;;;;		    NOP
;;;;BTBLK_SSLOOP
;;;;		    ADD	    R0
;;;;		    DEC	    R4
;;;;		    BNE	    BTBLK_SSLOOP
;;;;		    NOP
;;;;
;;;;BTBLK_SSLP0050
;;;;		    MOVE    R4,R0
;;;;
;;;;BTBLK_SSLP0100
;;;;		    FROM    R3
;;;;		    ADD	    R3
;;;;		    TO	    R1
;;;;		    ADD	    R11
;;;;		    LDW	    (R1)
;;;;		    OR	    R4
;;;;		    STW	    (R1)
;;;;
;;;;BTBLK_SLP0100
;;;;		    LOOP
;;;;		    INC	    R3
;;;;
;;;;		    LMS	    R0,REG0
;;;;		    DEC	    R0
;;;;		    BNE	    BTBLK_LLOOP
;;;;		    SBK
;;;;
;;;;		    RPIX
;;;;
;;;;;		    IBT	    R1,#0FFH
;;;;;
;;;;;		    IBT	    R12,#010H
;;;;;		    MOVE    R13,R15
;;;;;
;;;;;		    LDW	    (R11)
;;;;;		    CMP	    R1
;;;;;		    BNE	    BTBLK_END
;;;;;		    INC	    R11
;;;;;
;;;;;		    LOOP
;;;;;		    INC	    R11
;;;;;
;;;;		    WITH    R2		    ;IBT    R2,#000
;;;;		    SUB	    R2
;;;;
;;;;		    IBT	    R4,#010H
;;;;
;;;;BTBLK_CHKLP
;;;;		    LDW	    (R11)
;;;;
;;;;		    IBT	    R12,#010H
;;;;		    MOVE    R13,R15
;;;;
;;;;		    LSR
;;;;		    BCC	    BTBLK_CHKLP0100
;;;;		    NOP
;;;;
;;;;		    INC	    R2
;;;;
;;;;BTBLK_CHKLP0100
;;;;		    LOOP
;;;;		    NOP
;;;;
;;;;		    INC	    R11
;;;;
;;;;		    DEC	    R4
;;;;		    BNE	    BTBLK_CHKLP
;;;;		    INC	    R11
;;;;
;;;;		    IWT	    R3,#000E0H
;;;;
;;;;		    FROM    R2
;;;;		    CMP	    R3
;;;;		    BMI	    BTBLK_END
;;;;		    NOP
;;;;
;;;;		    IBT	    R0,#001H
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;
;;;;BTBLK_END
;;;;		    SUB	    R0		    ;IBT    R0,#000
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;
;;;;;********************************************************
;;;;;*		    bit map block all set		    *
;;;;;********************************************************
;;;;;
;;;;BTBLK_ASET	    EQU	    $
;;;;		    IBT	    R0,#BANK CIPCHD+6000H
;;;;		    ROMB
;;;;
;;;;		    IWT	    R14,#CIPCHD+6000H
;;;;
;;;;		    WITH    R2			    ;IBT    R2,#000
;;;;		    SUB	    R2			    ;
;;;;
;;;;		    IWT	    R3,#000F0H
;;;;
;;;;		    IBT	    R5,#010H		    ;L loop counter set
;;;;
;;;;BTBLK_ALLOOP
;;;;		    IBT	    R1,#020H		    ;plot x pos. set
;;;;
;;;;		    IBT	    R12,#010H		    ;S loop counter set
;;;;		    MOVE    R13,R15
;;;;
;;;;		    GETC
;;;;		    INC	    R14
;;;;
;;;;		    PLOT
;;;;
;;;;		    LOOP
;;;;		    NOP
;;;;
;;;;		    WITH    R14			    ;next line addr. calc.
;;;;		    ADD	    R3			    ;
;;;;
;;;;		    INC	    R2			    ;plot y pos. inc.
;;;;
;;;;		    DEC	    R5			    ;draw end ?
;;;;		    BNE	    BTBLK_ALLOOP	    ;  no: BTBLK_ALLOOP
;;;;		    NOP
;;;;
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*		BG3 polygon						*
;*			in  : (R1)  <-- scroll counter_H		*
;*			      (R2)  <-- display center Y pos		*
;*			      (R3)  <--		"      Z  "		*
;*			      (R4)  <-- (X)_rotation angle		*
;*			      (R12) <-- polygon data address(B)		*
;*			      (R13) <--		 "          (L,H)       *
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-	polygon data format						-
;-		(point no),(Z1,Y1,XW1),(Z2,Y2,XW2),...(Zn,Yn,XWn)	-
;-		(face no),(color1),(P11),(P12),...(color2)(Pn1)(Pn2)	-
;------------------------------------------------------------------------
;
BG3POLY2	EQU	$
		SMS	R1,REG0
;
;-------------- display check -----------------------------------
		IWT	R0,#0F0H
		TO	R5		;[ IWT R5,#0F0H*2 ]
		ADD	R0
		ADD	R1
		SUB	R5
		BCC	B3POL2000	;display ? ( yes:B3POL2000 )
		NOP
;
;-------------- not display clear set !! ----------------
		STOP
		NOP
;
;-------------- (X)_rotation cos & sin data set -----------------
B3POL2000
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		ADD	R4
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R7,R0		;(R7) <-- cos data
;
		IWT	R0,#SIN
		ADD	R4
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R8,R0		;(R8) <-- sin data
;
		SMS	R4,REG4		;(REG4) <-- rotation angle save
;
;-------------- point data rotation -----------------------------
		FROM	R12
		ROMB			;polygon data address(B) set
		MOVE	R14,R13		;	    "        (L,H) set
;
		TO	R12		;(R12) <-- point no
		GETB
		INC	R14
		SMS	R12,REG12	;(REG12) <-- point no.
;
		IWT	R1,#DIVBUF	;(R1) <-- div data pointer
		IBT	R5,#CWORK0	;(R5) <-- object point data buffer pointer
;
		CACHE
;
		MOVE	R13,R15
B3POL2010
		GETBS			;(R0) <-- Z pos
		INC	R14
		MOVE	R9,R0		;(R9) <-- Z pos
		MOVE	R6,R7		;(R6) <-- cos data
		LMULT
		MOVE	R10,R4		;(R10) <-- SZ*cos
;
		GETBS			;(R0) <-- Y pos
		INC	R14
		MOVE	R11,R0		;(R11) <-- Y pos
		MOVE	R6,R8		;(R6) <-- sin data
		LMULT			;(R4) <-- SY*sin
		FROM	R10
		ADD	R4
		HIB
		SEX
		ADD	R3		;(R0) <-- object Z pos = SZ*cos+SY*sin+CZ
		ADD	R0		;x2
		ADD	R1
		TO	R10		;(R10) <-- object Z pos mult data
		LDW	(R0)
;
		FROM	R9
		LMULT
		MOVE	R9,R4		;(R9) <-- SZ*sin
		MOVE	R6,R7		;(R6) <-- cos data
		FROM	R11
		LMULT
		FROM	R4
		SUB	R9
		HIB			;(R0) <-- SY*cos-SZ*sin
		SEX
;
		MOVE	R6,R10
		SWAP
		FMULT
		ADD	R2
		STW	(R5)		;object Y pos set
		INC	R5
		INC	R5
;
		GETB			;(R0) <-- X wide
		INC	R14
		SWAP
		FMULT
		ADC	#0
		STW	(R5)		;object X wide set
		INC	R5
;
		LOOP
		INC	R5
;
;-------------- polygon set -------------------------------------
		TO	R1		;(R1) <-- face no
		GETB
		INC	R14
;
		IWT	R11,#DIVBUF	;(R11) <-- div data pointer
B3POL2020
		TO	R2		;(R2) <-- face color & angle
		GETB
		INC	R14
;
		GETB
		INC	R14
		ADD	R0
		TO	R8		;(R8) <-- point.1 pointer
		ADD	R0
;
		GETB
		INC	R14
		ADD	R0
		TO	R9		;(R9) <-- point.2 pointer
		ADD	R0
;
;-------------- face display check ----------------------
		TO	R3		;(R3) <-- point.1 Y pos
		LDW	(R8)
		LDW	(R9)
		SUB	R3
		BPL	B3POL2022	;face display ? ( yes:B3POL2022 )
		INC	R0
;
		IWT	R15,#B3POL2060+1	;[ JMP B3POL2060+1 ]
		DEC	R1		;[ dummy ]
;
;-------------- face set --------------------------------
B3POL2022
		SMS	R0,REG10	;(REG10) <-- Y move loop no
;
		INC	R8
		INC	R8
		TO	R7		;(R7) <-- XW1
		LDW	(R8)
		INC	R9
		INC	R9
		TO	R8		;(R8) <-- XW2
		LDW	(R9)
;
;-------------- line step set -------------------
		SMS	R11,REG11
		LMS	R12,REG10
		FROM	R12
		ADD	R12
		ADD	R11
		LDW	(R0)
		TO	R6		;(R6) <-- div data
		LSR			;1/2
		FROM	R8
		SUB	R7
		LOB
		SWAP
		FMULT
		TO	R8		;(R8) <-- XW1-XW2 step
		ROL			;x2
;
		IWT	R4,#0080H	;(R4) <-- XW1-XW2 step calculate buffer
;
		IWT	R0,#HDMABF
		ADD	R3
		TO	R10		;(R10) <-- H-DMA buffer pointer
		ADD	R3
;;;;		    IWT	    R9,#0B2H	    ;(R9) <-- max Y pos
		IWT	R9,#0D2H	;(R9) <-- max Y pos

		IWT	R0,#HDMABF1
		ADD	R3
		TO	R11		;(R11) <-- H-DMA buffer 1 pointer
		ADD	R3
;
		FROM	R2
		SWAP
		TO	R2		;(R2) <-- face color set data
		LSR			;[ 80H step ]
		MOVE	R13,R15
B3POL2040
		MOVES	R0,R3
		BMI	B3POL2050	;H-DMA data set ? ( no:B3POL2050 )
		SUB	R9
;
		BPL	B3POL2060	;H-DMA set end ? ( yes:B3POL2060 )
		FROM	R2
;
		SUB	R3
		ADD	R7
		SUB	#8
		STW	(R10)		;H-DMA buffer set
;
		LMS	R0,REG0
		STW	(R11)		;H-DMA beffer 1 set

B3POL2050
		FROM	R4
		ADD	R8
		TO	R4
		LOB
		HIB
		SEX
		TO	R7
		ADD	R7
		INC	R10
		INC	R10
		INC	R11
		INC	R11
		LOOP
		INC	R3
;
B3POL2060
		DEC	R1
		BEQ	B3POL2112
		NOP
;
		LMS	R11,REG11

		IWT	R15,#B3POL2020+1  ;[ JMP B3POL2020+1 ]
		TO	R2		  ;[ dummy ]
;
B3POL2112

		STOP
		NOP
;
;************************************************************************
;*		chara zoom ( 32x32 )					*
;*			(R4) <-- power					*
;************************************************************************
M_FUSEN_SET	EQU	$
;====================< mapping >==========================
		IBT	R0,#005
		CMODE			;plot mode set

		IBT	R0,#BANK CIPCHD3+0040H	;rom bank set
		ROMB				;

		IWT	R3,#CIPCHD3+0040H	;rom data start addr. set

		CACHE
;
;-------------- plot intial set ---------------------------------
		IBT	R5,#009		;(R5) <-- power reverse checker set

;		IBT	R2,#0		;(R2) <-- plot start Y pos set
		MOVE	R9,R2		;(R9) <-- PY

		IWT	R13,#P_P120	;(R13) <-- Y loop addr. set
;
		IBT	R10,#32		;(R10) <-- Y loop set
P_P110
;		IBT	R1,#020H	;(R1) <-- plot start X pos set
		LMS	R1,CWORK0
		WITH	R8		;(R8) <-- PX ( = 0 )
		SUB	R8
		MOVE	R6,R8		;(R6) <-- speed
		MOVE	R11,R8		;(R11) <-- revise data

		IBT	R12,#32		;X loop set

P_P120
		FROM	R9		;(R7) <-- PY
		TO	R7		;
		SUB	R11		;

		MERGE
		BCC	P_P130		;area over ? ( no:P_P030 )
		TO	R14
;
		DEC	R5
		BNE	P_P125
		WITH	R4		;power reverse
		NOT
		INC	R4

		IBT	R5,#010H	;(R5) <-- power reverse checker set

P_P125
		WITH	R6		;speed calc.
		ADD	R4

		WITH	R11		;PY add calc.
		ADD	R6

		IWT	R0,#00100H	;PX calc.
		WITH	R8
		ADD	R0

		SUB	R0		;[ IBT	R0,#00 ]
		BRA	P_P140
		COLOUR			;color set
;
P_P130
		ADD	R3
;
		DEC	R5
		BNE	P_P135
		WITH	R4		;power reverse
		NOT
		INC	R4

		IBT	R5,#010H	;(R5) <-- power reverse checker set

P_P135
		WITH	R6		;speed calc.
		ADD	R4

		WITH	R11		;PY add calc.
		ADD	R6

		IWT	R0,#00100H	;PX calc.
		WITH	R8
		ADD	R0

		GETC			;color set

P_P140
		LOOP
		PLOT			;pset
;
		WITH	R9		;PY base calc.
		ADD	R0

		IWT	R6,#000F0H	;(R4) <-- power * 90%
		FROM	R4
		LMULT

		WITH	R4
		HIB

		IBT	R0,#00FH
		FROM	R4
		CMP	R0
		BPL	P_P160
		NOP

		IBT	R4,#0

P_P160
		DEC	R10
		BNE	P_P110		;end ? ( no:P_P110 )
		INC	R2		;Y pos +1
;
		RPIX

		STOP
		NOP
;
;************************************************************************
;*		mapping area clear					*
;************************************************************************
;
;MAPAREA_CLR	EQU	$
;;---------------< mapping area clear >----------------
;
;		CACHE
;
;		IWT	R7,#(WOB7CHR+20H*4)
;		IWT	R8,#(WOB7CHR+20H*4)+200H
;		IWT	R9,#(WOB7CHR+20H*4)+400H
;		IWT	R10,#(WOB7CHR+20H*4)+600H
;		SUB	R0		;[ IBT R0,#0 ]
;		IWT	R12,#(20H*4)/2
;		MOVE	R13,R15
;
;		STW	(R7)
;		INC	R7
;		INC	R7
;		STW	(R8)
;		INC	R8
;		INC	R8
;		STW	(R9)
;		INC	R9
;		INC	R9
;		STW	(R10)
;		INC	R10
;		LOOP
;		INC	R10
;
;		RTS
;
;
;
;************************************************************************
;*		Y[pbN					*
;*								*
;*	[In]							*
;*		R0	{					*
;*		R1	|WV]pil`w@Oeegj	*
;*		R2	rbg}bvWQxZbg		*
;*		R3	rbg}bvWQwZbg		*
;*		R4	{					*
;*		R5	G̉]pil`w@Oeegj		*
;*		R6	a					*
;*		R7	L				*
;*		R12	]AhX				*
;*		R13	]oN				*
;*								*
;*	[Out]							*
;*		CWORK10 ItZbgx@onrD		*
;*		CWORK11 ItZbgw@onrD		*
;*								*
;****************************************************************
M_ZPACK_SET	EQU	$
		TO	R11		;R11 <- a
		FMULT			;

		IBT	R0,#BANK LSIN
		ROMB

		IWT	R8,#LSIN	;CWORK10 <-- x@onrD
		FROM	R1		;
		TO	R14		;
		ADD	R8		;

		IWT	R8,#LCOS	;CWORK11 <-- w@onrD
		FROM	R1		;
		TO	R10		;
		ADD	R8		;

		GETBS			;

		MOVE	R14,R10		;

		MULT	R11		;
		ADD	R0		;
		ADD	R0		;
		HIB			;
		SEX			;
		NOT			;
		INC	R0		;
		SMS	R0,CWORK10	;

		GETBS			;
		MULT	R11		;
		ADD	R0		;
		ADD	R0		;
		HIB			;
		SEX
		ADD	#004

		MOVES	R7,R7		;E ?
		BNE	ZPACK_SET0100	; yes: ZPACK_SET0100
		NOP			;

		NOT			;
		INC	R0		;

ZPACK_SET0100
		ADD	#008
		SMS	R0,CWORK11	;

		MOVE	R6,R4

		IWT	R15,#C_32_ROTZOM
		NOP
;
;************************************************************************
;*		jump block						*
;************************************************************************
M_JBLK0_SET	EQU	$
		FROM	R11		;
		FMULT			;
		SMS	R0,CWORK10

		MOVES	R7,R7		;rbg}bvGA ?
		BNE	M_JBLK0_SET0	; yes: M_JBLK0_SET0
		WITH	R4

		STOP
		NOP

M_JBLK0_SET0
		TO	R6

		MOVES	R10,R10
		BNE	M_JBLK0_SET2+1
		IWT	R15,#C_32_ZOOM_XY_16
		NOP

M_JBLK0_SET2
		IWT	R15,#C_32_ZOOM_XY
		NOP
;
;****************************************************************
;*								*
;*								*
;*	[In]							*
;*		R2	rbg}bvWQxZbg		*
;*		R3	rbg}bvWQwZbg		*
;*		R4	{					*
;*		R5	]pil`w@Oeegj		*
;*		R6	߂̒SƃL̒S̋		*
;*		R9	L				*
;*		R11	]pil`w@OPedgj		*
;*		R12	]AhX				*
;*		R13	]oN				*
;*								*
;*	[Out]							*
;*		CWORK10 nT~ItZbgw@onrD		*
;*		CWORK11 nT~ItZbgx@onrD		*
;*								*
;****************************************************************
M_KANI0_SET	EQU	$
		FROM	R4
		FMULT
		LOB
		TO	R6
		SWAP

		IBT	R0,#BANK SIN
		ROMB

		IWT	R1,#SIN
		FROM	R11
		TO	R14
		ADD	R1

		IWT	R1,#COS
		FROM	R11
		TO	R10
		ADD	R1

		GETB			;(R8) <- Y POS.
		INC	R14
		GETBH
		TO	R8
		FMULT

		MOVE	R14,R10

		GETB			;(R7) <- X POS.
		INC	R14
		GETBH
		FMULT

		MOVES	R9,R9			; ?
		BEQ	KANI0_SET0100		; yes: KANI0_SUB0100
		NOP

		NOT
		INC	R0

KANI0_SET0100
		SMS	R0,CWORK10
		SMS	R8,CWORK11

		MOVE	R6,R4

		IWT	R15,#C_32_ROTZOM
		NOP
;
;****************************************************************
;*		telesa L size set				*
;****************************************************************
M_TELEL_SET	EQU	$
		FROM	R4
		FMULT
		MOVE	R10,R0
		TO	R11
		ADD	R0

		WITH	R1
		SUB	R1

		FROM	R7				;㉺`FbNnj ?
		ADD	R10				;
		CMP	R11				;
		BCS	M_TELEL_SET0800			; yes: M_TELEL_SET0800

		FROM	R8				;E`FbNnj ?
		ADD	R10				;
		CMP	R11				;
		BCS	M_TELEL_SET0800			; yes: M_TELEL_SET0800
		NOP

		INC	R1

		MOVES	R9,R9				;vC[̓tbVOĂ ?
		BNE	M_TELEL_SET0800			; yes: M_TELEL_SET0800
		NOP

		INC	R1

M_TELEL_SET0800
		SMS	R1,CWORK10

		MOVE	R6,R4

		IWT	R15,#C_32_ROTZOM
		NOP
;
;
;****************************************************************
;*		gabon						*
;****************************************************************
;*		spark						*
;****************************************************************
M_GABNB_SET	EQU	$
		FROM	R4		;(R11) <-- Oa
		TO	R11		;
		FMULT			;
;
		MOVE	R6,R10
		FROM	R4
		FMULT
		ADD	R1
		SMS	R0,CWORK12	;vC[wW
		ADD	R0
		SMS	R0,CWORK13

		FROM	R4
		FMULT
		ADD	R8
		SMS	R0,CWORK14	;vC[xW
		ADD	R0
		SMS	R0,CWORK15
;
		IBT	R0,#BANK LSIN
		ROMB

		IWT	R1,#LSIN	;CWORK10 <-- x@onrD
		FROM	R5		;
		TO	R14		;
		ADD	R1		;

		IWT	R1,#LCOS	;CWORK11 <-- w@onrD
		FROM	R5		;
		TO	R10		;
		ADD	R1		;

		GETBS			;

		MOVE	R14,R10		;

		MULT	R11		;
		ADD	R0		;
		ADD	R0		;
		HIB			;
		SEX			;
		SMS	R0,CWORK10	;

		GETBS			;
		MULT	R11		;
		ADD	R0		;
		ADD	R0		;
		HIB			;
		SEX

		MOVES	R7,R7
		BEQ	GABNB_SET0100
		NOP

		NOT			;
		INC	R0		;

GABNB_SET0100
		SMS	R0,CWORK11	;

		MOVE	R6,R4

		IWT	R15,#C_32_ROTZOM_16
		NOP
;
;****************************************************************
;*		hodai						*
;****************************************************************
M_HODAI_SET	EQU	$
		IBT	R0,#BANK LSIN
		ROMB

		IWT	R1,#LSIN
		FROM	R5
		TO	R14
		ADD	R1

		IWT	R1,#LCOS
		FROM	R5
		TO	R11
		ADD	R1

		TO	R7		;(R7) <-- SIN
		GETBS

		FROM	R9		;(R1) <-- X SIN
		MULT	R7
		ADD	R0
		ADD	R0
		HIB
		TO	R1
		SEX

		IBT	R0,#080H	;CWORK12 <-- Y speed
		MULT	R7		;40H = 100H
		ADD	R0
		ADD	R0
		HIB
		SEX
		ADD	R0
		ADD	R0
		SMS	R0,CWORK12

		FROM	R10		;(R7) <-- Y SIN
		MULT	R7
		ADD	R0
		ADD	R0
		HIB
		TO	R7
		SEX

		MOVE	R14,R11

		TO	R8		;(R8) <-- COS
		GETBS

		FROM	R9		;(R9) <-- X COS
		MULT	R8
		ADD	R0
		ADD	R0
		HIB
		TO	R9
		SEX

		IBT	R0,#080H	;CWORK13 <-- X speed
		MULT	R8		;40H = 100H
		ADD	R0
		ADD	R0
		HIB
		SEX
		ADD	R0
		ADD	R0
		MOVES	R4,R4
		BEQ	HODAI_SET0080
		NOP

		NOT
		INC	R0

HODAI_SET0080
		SMS	R0,CWORK13

		FROM	R10		;(R8) <-- Y COS
		MULT	R8
		ADD	R0
		ADD	R0
		HIB
		TO	R8
		SEX

		FROM	R9		;CWORK11 <- X POS.
		SUB	R7		;
		MOVES	R4,R4		;
		BEQ	HODAI_SET0100	;
		NOP			;
					;
		NOT			;
		INC	R0		;
					;
HODAI_SET0100				;
		SMS	R0,CWORK11	;

		FROM	R1		;CWORK10 <- Y POS.
		ADD	R8		;
		SMS	R0,CWORK10	;

		MOVE	R11,R6

		IWT	R6,#01000H
		FROM	R11
		FMULT
		SMS	R0,CWORK14
		ADD	R0
		SMS	R0,CWORK15

		IWT	R6,#00800H
		FROM	R11
		FMULT
		SMS	R0,CWORK16

		MOVE	R6,R11

		IWT	R15,#C_32_ROTZOM_16
		NOP
;
;****************************************************************
;*		ta_kun2						*
;****************************************************************
M_ARIH0_SET	EQU	$
		FROM	R11
		FMULT
		SMS	R0,CWORK10

		MOVE	R6,R4

		IWT	R15,#C_32_ZOOM_XY_16
		NOP
;
;****************************************************************
;*		wang wang					*
;****************************************************************
M_WANG0_SET	EQU	$
		IBT	R0,#BANK CWORK0
		RAMB

		WITH	R6
		SUB	R6

		WITH	R3			;̍sa`FbN@ ?
		MULT	R3			;
		FROM	R4			;
		MULT	R4			;
		ADD	R3			;
		CMP	R5			;
		BMI	WANG0_SET0010		; yes: WANG0_SET0010
		NOP				;
						;
		INC	R6			;
						;
WANG0_SET0010					;
		SMS	R6,CWORK1E		;

		IBT	R12,#004

		IWT	R4,#CWORK10
		IWT	R5,#CWORK14

		CACHE
		MOVE	R13,R15

		TO	R6
		LDW	(R4)
;
		FROM	R6
		SUB	R1			;Ô̍ ?
		BMI	WANG0_SET0100		; yes: WANG0_SET0100
		INC	R4			;

		CMP	R10			;͔͈͓ ?
		BMI	WANG0_SET0300		; yes: WANG0_SET0300
		INC	R4			;

		FROM	R1
		ADD	R10
		BRA	WANG0_SET0200
		NOP

WANG0_SET0100
		NOT				;͔͈͓ ?
		INC	R0			;
		CMP	R10			;
		BMI	WANG0_SET0300		; yes: WANG0_SET0300
		INC	R4

		FROM	R1
		SUB	R10

WANG0_SET0200
		SBK
		MOVE	R6,R0

WANG0_SET0300
		MOVE	R1,R6
;
		TO	R6
		LDW	(R5)

		FROM	R6
		SUB	R2			;Ô̏ ?
		BMI	WANG0_SET3400		; yes: WANG0_SET3400
		INC	R5			;

		FROM	R2			;l`w
		ADD	R10			;
		CMP	R9			;
		BMI	WANG0_SET3500		;  no: WANG0_SET3500
		NOP

		WITH	R9			;MOVE R0,R9
		BRA	WANG0_SET3500
		TO	R0

WANG0_SET3400
		NOT				;Ԃl`w
		INC	R0			;
		CMP	R10			;
		BPL	WANG0_SET3480		; yes: WANG0_SET3480
		FROM	R2

		INC	R6			;d͕

		FROM	R6
		SBK
		BRA	WANG0_SET3600
		NOP

WANG0_SET3480
;		FROM	R2
		SUB	R10			;x@onrD␳
		INC	R0			;
		INC	R0			;

WANG0_SET3500
		SBK
		MOVE	R6,R0

WANG0_SET3600
		MOVE	R2,R6
		LOOP
		INC	R5

		LMS	R6,REG6			;(R11) <- x{Zbg
		LMS	R11,REG6		;(R6) <- w{Zbg

		LMS	R5,REG5			;(R5) <- ]pZbg
		LMS	R13,REG13		;(R13) <- chara data bank set
		LMS	R12,REG12		;(R12) <- chara data address set

		IBT	R8,#008			;(R8) <- Sw@onrD
		MOVE	R9,R8			;(R9) <- Sx@onrD

		LMS	R2,REG2			;(R2) <- ]GAx@onrDZbg
		LMS	R3,REG3			;(R3) <- ]GAw@onrDZbg
;

		IWT	R15,#C_32_RTZ_16_XY
		NOP
;
M_WANG0_SET2	EQU	$
		IBT	R0,#BANK CWORK10
		RAMB

		WITH	R6
		SUB	R6

		WITH	R3			;̍sa`FbN@ ?
		MULT	R3			;
		FROM	R4			;
		MULT	R4			;
		ADD	R3			;
		CMP	R5			;
		BMI	WANG0_SET2010		; yes: WANG0_SET2010
		NOP				;
						;
		INC	R6			;
						;
WANG0_SET2010					;
		SMS	R6,CWORK1E		;

		IWT	R4,#CWORK10
		IWT	R5,#CWORK14

		WITH	R1			;{S͂܂񒆂ɂĂ邽
		ADD	#004			;
		WITH	R2			;
		ADD	#004			;

		FROM	R8
		SUB	R1
		DIV2
		TO	R7
		DIV2

		WITH	R1
		ADD	R7

		FROM	R9
		SUB	R2
		DIV2
		TO	R8
		DIV2

		WITH	R2
		ADD	R8

		IBT	R12,#004

		CACHE
		MOVE	R13,R15

		TO	R6
		LDW	(R4)
		FROM	R1
		SUB	R6
		DIV2
		ADD	R6
		SBK

		INC	R4
		INC	R4

		TO	R6
		LDW	(R5)
		FROM	R2
		SUB	R6
		DIV2
		ADD	R6
		SBK

		WITH	R1
		ADD	R7

		WITH	R2
		ADD	R8

		INC	R5
		LOOP
		INC	R5

		LMS	R6,REG6			;(R11) <- x{Zbg
		LMS	R11,REG6		;(R6) <- w{Zbg

		LMS	R5,REG5			;(R5) <- ]pZbg
		LMS	R13,REG13		;(R13) <- chara data bank set
		LMS	R12,REG12		;(R12) <- chara data address set

		LMS	R2,REG2			;(R2) <- ]GAx@onrDZbg
		LMS	R3,REG3			;(R3) <- ]GAw@onrDZbg
;
		LMS	R1,REG1
		MOVES	R1,R1
		BNE	WANG0_SET2020
		NOP

		IBT	R8,#008			;(R8) <- Sw@onrD
		MOVE	R9,R8			;(R9) <- Sx@onrD

		IWT	R15,#C_32_RTZ_16_XY
		NOP

WANG0_SET2020
		IBT	R8,#010H		;(R8) <- Sw@onrD
		MOVE	R9,R8			;(R9) <- Sx@onrD

		LMS	R0,REG0
		MOVES	R0,R0
		BNE	WANG0_SET2030
		NOP

		IWT	R15,#C_32_ZOOM
		NOP

WANG0_SET2030
		IWT	R15,#C_64HZOOM_32
		NOP
;
M_WANG0_SET3	EQU	$
		IBT	R0,#BANK CWORK10
		RAMB

		WITH	R6
		SUB	R6

		WITH	R3			;̍sa`FbN@ ?
		MULT	R3			;
		FROM	R4			;
		MULT	R4			;
		ADD	R3			;
		CMP	R5			;
		BMI	WANG0_SET3010		; yes: WANG0_SET3010
		NOP				;
						;
		INC	R6			;
						;
WANG0_SET3010					;
		SMS	R6,CWORK1E		;

		IWT	R4,#CWORK10
		IWT	R5,#CWORK14

		WITH	R1			;{S͂܂񒆂ɂĂ邽
		ADD	#004			;
		WITH	R2			;
		ADD	#004			;

		FROM	R8
		SUB	R1
		DIV2
		TO	R7
		DIV2

		WITH	R1
		ADD	R7

		FROM	R9
		SUB	R2
		DIV2
		TO	R8
		DIV2

		WITH	R2
		ADD	R8

		IBT	R12,#004

		CACHE
		MOVE	R13,R15

		TO	R6
		LDW	(R4)
		FROM	R1
		SUB	R6
		DIV2
		ADD	R6
		SBK

		INC	R4
		INC	R4

		TO	R6
		LDW	(R5)
		FROM	R2
		SUB	R6
		DIV2
		ADD	R6
		SBK

		WITH	R1
		ADD	R7

		WITH	R2
		ADD	R8

		INC	R5
		LOOP
		INC	R5

		LMS	R6,REG6			;(R11) <- x{Zbg
		LMS	R11,REG6		;(R6) <- w{Zbg

		LMS	R5,REG5			;(R5) <- ]pZbg
		LMS	R13,REG13		;(R13) <- chara data bank set
		LMS	R12,REG12		;(R12) <- chara data address set

		IBT	R8,#008			;(R8) <- Sw@onrD
		MOVE	R9,R8			;(R9) <- Sx@onrD

		LMS	R2,REG2			;(R2) <- ]GAx@onrDZbg
		LMS	R3,REG3			;(R3) <- ]GAw@onrDZbg
;

		IWT	R15,#C_32_RTZ_16_XY
		NOP
;
M_WANG0_SET4	EQU	$
		IBT	R0,#BANK CWORK0
		RAMB

		WITH	R6
		SUB	R6

		WITH	R3			;̍sa`FbN@ ?
		MULT	R3			;
		FROM	R4			;
		MULT	R4			;
		ADD	R3			;
		CMP	R5			;
		BMI	WANG0_SET4010		; yes: WANG0_SET4010
		NOP				;
						;
		INC	R6			;
						;
WANG0_SET4010					;
		SMS	R6,CWORK1E		;

		WITH	R2			;
		ADD	#004			;

		FROM	R9
		SUB	R2
		DIV2
		TO	R8
		DIV2

		WITH	R2
		ADD	R8

		IBT	R12,#004

		IWT	R4,#CWORK10
		IWT	R5,#CWORK14

		CACHE
		MOVE	R13,R15

		TO	R6
		LDW	(R4)
;
		FROM	R6
		SUB	R1			;Ô̍ ?
		BMI	WANG0_SET4100		; yes: WANG0_SET4100
		INC	R4			;

		CMP	R10			;͔͈͓ ?
		BMI	WANG0_SET4300		; yes: WANG0_SET4300
		INC	R4			;

		FROM	R1
		ADD	R10
		BRA	WANG0_SET4200
		NOP

WANG0_SET4100
		NOT				;͔͈͓ ?
		INC	R0			;
		CMP	R10			;
		BMI	WANG0_SET4300		; yes: WANG0_SET4300
		INC	R4

		FROM	R1
		SUB	R10

WANG0_SET4200
		SBK
		MOVE	R6,R0

WANG0_SET4300
		MOVE	R1,R6
;
		TO	R6
		LDW	(R5)
		FROM	R2
		SUB	R6
		DIV2
		ADD	R6
		SBK

		WITH	R2
		ADD	R8

		INC	R5
		LOOP
		INC	R5

		LMS	R6,REG6			;(R11) <- x{Zbg
		LMS	R11,REG6		;(R6) <- w{Zbg

		LMS	R5,REG5			;(R5) <- ]pZbg
		LMS	R13,REG13		;(R13) <- chara data bank set
		LMS	R12,REG12		;(R12) <- chara data address set

		IBT	R8,#008			;(R8) <- Sw@onrD
		MOVE	R9,R8			;(R9) <- Sx@onrD

		LMS	R2,REG2			;(R2) <- ]GAx@onrDZbg
		LMS	R3,REG3			;(R3) <- ]GAw@onrDZbg
;

		IWT	R15,#C_32_RTZ_16_XY
		NOP
;
;****************************************************************
;*		͂܂˂					*
;****************************************************************
M_HARIO_SET	EQU	$
		TO	R7
		FMULT
		mSTW	R7,CEWIDEX,R10
		mSTW	R7,CEWIDEY,R10

		IWT	R0,#-01000H
		FMULT
		IBT	R7,#010H
		TO	R7
		ADD	R7
		mSTW	R7,CECNTYW,R10

		IWT	R15,#C_32_ZOOM
		NOP
;
;****************************************************************
;*		XCb`					*
;****************************************************************
M_SW000_SET	EQU	$
		FMULT
		SMS	R0,CWORK10

		MOVE	R6,R11
		FROM	R1
		FMULT
		SMS	R0,CWORK11

		MOVE	R6,R4

		IWT	R15,#C_32_ZOOM_XY
		NOP
;
;****************************************************************
;*								*
;*	}bv LN^[ uq`lZbg			*
;*				in				*
;*				cwork0 <- BANK CMODE_DATA	*
;*				  "  1 <- CMODE_DATA (L.H)      *
;*				R9 <- world NO.			*
;****************************************************************
MPCHRVRMST	EQU	$
		IBT	R0,#BANK MPCHRST_ADR
		ROMB
		IWT	R0,#MPCHRST_ADR
		TO	R14
		ADD	R9		;	R14 = R0 + R9
		GETB
		INC	R14
		TO	R8
		GETBH			; R8 <- bit map address data
		IBT	R3,#00		; R3 <- #00
		MOVE	R4,R3		; R4 <- #00
		MOVE	R5,R3		; R5 <- #00
		IWT	R13,#MPCHRST_LOP0
		IBT	R7,#12
;
		CACHE			; LbV X^[g !!
;
MPCHRST_LOP3
		LMS	R0,CWORK0	; CMODE NO. set
		ROMB
		LMS	R14,CWORK1
		GETB
		CMODE
		INC	R14
		SMS	R14,CWORK1
;
		IBT	R0,#BANK MPCHRST_ADR
		ROMB
		MOVE	R14,R8		; R14 <- bit map address data
		GETB
		INC	R14
		TO	R10
		GETBH
		INC	R14
		TO	R11		; LN^[ oNAhX
		GETB
		IBT	R6,#03
;
MPCHRST_LOP2
		MOVE	R9,R5		;x X^[g|Cg
;
MPCHRST_LOP1
		FROM	R11		; LN^[ oNAhX Zbg
		ROMB
		MOVE	R2,R9		;x X^[g|Cg
		MOVE	R1,R3		;w X^[g|Cg
		IBT	R12,#24
		MOVE	R14,R10
;
MPCHRST_LOP0				; LN^[ Zbg !!
		GETC
		PLOT
		IBT	R0,#127
		TO	R1
		AND	R1		; R1 <- R1 and R0
		BNE	MPCHRST_LOP05
		WITH	R2
		ADD	#08		;	R2 = R2 + #08
MPCHRST_LOP05
		LOOP
		INC	R14
;
		IWT	R0,#256		;
		TO	R10		;
		ADD	R10		;	R10 = R10 + #256
		INC	R9		; next V-line set
		INC	R4
		WITH	R4
		AND	#007		; R4 and #007 -> R4 = 0 ?
		BNE	MPCHRST_LOP1	;	NO -> MPCHRST_LOP1
		NOP
;
		IBT	R0,#24		; w |CgZbg
		TO	R3
		ADD	R3		;	R3 = R3 + #024
		FROM	R3
		ADD	R3		;	R0 = R3 + R3
		SWAP
		AND	#001		; next character line ?
		BEQ	MPCHRST_200	;	NO -> MPCHRST_200
		WITH	R5
		ADD	#08		;	R5 = R5 + #08
MPCHRST_200
		IBT	R0,#127
		TO	R3
		AND	R3		; R3 <- R3 and R0
		DEC	R6
		BNE	MPCHRST_LOP2
		NOP
;
		INC	R8		; bit map address data + #003
		INC	R8
		INC	R8
		DEC	R7
		BNE	MPCHRST_LOP3
		NOP
;
		RPIX
;
		STOP
		NOP
;
;--------------------------------------------------------
;-	rbg }bv AhXf[^			-
;--------------------------------------------------------
MPCHRST_ADR	EQU	$
		WORD	MPCHRST_ADR0,MPCHRST_ADR1,MPCHRST_ADR2
		WORD	MPCHRST_ADR3,MPCHRST_ADR4,MPCHRST_ADR5
		WORD	MPCHRST_ADR6,MPCHRST_ADR7,MPCHRST_ADR8
		WORD	MPCHRST_ADR9,MPCHRST_ADRA,MPCHRST_ADRB
 IF  PAL  ;**** PAL Ή [1995/08/01] *****************************
		WORD	MPCHRST_PAL_F,MPCHRST_PAL_D
		WORD	MPCHRST_PAL_F9,MPCHRST_ADRA
		WORD	MPCHRST_PAL_D9,MPCHRST_PAL_DA
		WORD	MPCHRST_PAL_F8,MPCHRST_PAL_D8
		WORD	MPCHRST_PAL_FB,MPCHRST_PAL_DB
 ENDIF	  ;**** PAL Ή [1995/08/01] *****************************
;
MPCHRST_ADR0	EQU	$		;Pvnqkc
		LWORD	0530404H,0530420H,053043CH,0530458H,0530474H,0530490H
		LWORD	05304ACH,05304C8H,05304E4H,05344C8H,0536420H,0536490H
;
MPCHRST_ADR1	EQU	$		;Qvnqkc
		LWORD	0532404H,0532420H,053243CH,0532458H,0532474H,0532490H
		LWORD	05324ACH,05324C8H,05324E4H,05344E4H,0536420H,0536490H
;
MPCHRST_ADR2	EQU	$		;Rvnqkc
		LWORD	0534404H,0534420H,053443CH,0534458H,0534474H,0534490H
		LWORD	05344ACH,05344C8H,05344E4H,0536404H,0536420H,0536490H
;
MPCHRST_ADR3	EQU	$		;Svnqkc
		LWORD	0536404H,0536420H,053643CH,0536458H,0536474H,0536490H
		LWORD	05364ACH,05364C8H,05364E4H,05364ACH,0536420H,0536490H
;
MPCHRST_ADR4	EQU	$		;Tvnqkc
		LWORD	0530404H,0530420H,053043CH,0530458H,0530474H,0530490H
		LWORD	05304ACH,05304C8H,05304E4H,05364C8H,0536420H,0536490H
;
MPCHRST_ADR5	EQU	$		;Uvnqkc
		LWORD	0532404H,0532420H,053243CH,0532458H,0532474H,0532490H
		LWORD	05324ACH,05324C8H,05324E4H,05364E4H,0536420H,0536490H
;
MPCHRST_ADR6	EQU	$		;RtBO ACR
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LWORD	CHR80+643CH,CHR80+6458H,CHR80+6474H
		LWORD	CHRPAL3+2490H,CHRPAL3+24ACH,CHRPAL3+2474H
		LWORD	CHR80+643CH,CHR80+6458H,CHR80+6474H
		LWORD	0536458H,053C43CH,0534404H
 ENDIF	  ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LWORD	053643CH,0536458H,0536474H,05324ACH,05324C8H,05324E4H
		LWORD	0536404H,0536420H,05364C8H,0536458H,053C43CH,0534404H
 ENDIF	       ;**** { or NES Ή [1995/08/02] *****************************
;
MPCHRST_ADR7	EQU	$		;R[XZNg ACR
		LWORD	0538404H,0538420H,053843CH,0538458H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,053A490H,053A4ACH,053A4C8H,053A4E4H
;
MPCHRST_ADR8	EQU	$		;~jQ[ ACR
		LWORD	0534404H,0534420H,053443CH,0534458H,0534474H,0534490H
		LWORD	05344ACH,053A4E4H,053A4E4H,0536420H,0536420H,0536490H
;;;;K;;;;;
;;;;K;;;;MPCHRST_ADR8	EQU	$		;{[iX ACR
;;;;K;;;;		LWORD	0534404H,0534420H,053443CH,0534458H,0534474H,0534490H
;;;;K;;;;		LWORD	05344ACH,05344C8H,0536404H,0536420H,0536420H,0536490H
;
;--------------- {[iX@Q[------------------------------
MPCHRST_ADR9	EQU	$
		LWORD	0538404H,0538420H,053843CH,0538458H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
MPCHRST_ADRA	EQU	$
		LWORD	053A458H,053A474H,053A490H,053A4ACH,053A4C8H,053A4E4H
		LWORD	053A404H,053A420H,053A43CH,053A458H,053A474H,053A490H
;
MPCHRST_ADRB	EQU	$
;[1995/05/03]		     LWORD   053A43CH,053A490H,053A4ACH,053A4C8H,053A4E4H,053A404H
;[1995/05/03]		     LWORD   053A474H,05384C8H,05384E4H,0538404H,0538404H,0538404H
		LWORD	053A43CH,0538420H,053843CH,0538458H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
;
 IF  PAL  ;**** PAL Ή [1995/08/01] *****************************
MPCHRST_PAL_F	EQU	$		;R[XZNg
		LWORD	CHRPAL3+0404H,CHRPAL3+0420H,CHRPAL3+043CH,CHRPAL3+0458H,CHRPAL3+0474H,CHRPAL3+0490H
		LWORD	CHRPAL3+04ACH,CHRPAL3+04C8H,CHRPAL3+2420H,CHRPAL3+2404H,CHRPAL3+04E4H,CHRPAL3+24E4H
;
MPCHRST_PAL_D	EQU	$		;R[XZNg
		LWORD	CHRPAL3+0404H,CHRPAL3+0420H,CHRPAL3+043CH,CHRPAL3+0458H,CHRPAL3+0474H,CHRPAL3+0490H
		LWORD	CHRPAL3+04ACH,CHRPAL3+04C8H,CHRPAL3+2420H,CHRPAL3+2404H,CHRPAL3+04E4H,CHRPAL3+04C8H
;
MPCHRST_PAL_F9	EQU	$		;{[iX@Q[
		LWORD	CHRPAL3+24C8H,0538420H,053843CH,CHRPAL3+2458H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
MPCHRST_PAL_D9	EQU	$		;{[iX@Q[
		LWORD	CHRPAL3+24C8H,0538420H,053843CH,CHRPAL3+2474H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
MPCHRST_PAL_DA	EQU	$
		LWORD	053A458H,053A474H,053A490H,053A4ACH,053A4C8H,053A4E4H
		LWORD	053A404H,053A420H,053A43CH,CHRPAL3+2474H,053A474H,053A490H
;
MPCHRST_PAL_F8	EQU	$		;~jQ[ ACR
		LWORD	0534404H,0534420H,053443CH,0534458H,0534474H,0534490H
		LWORD	05344ACH,CHRPAL3+24E4H,053A4E4H,0536420H,0536420H,0536490H
;
MPCHRST_PAL_D8	EQU	$		;~jQ[ ACR
		LWORD	0534404H,0534420H,053443CH,0534458H,0534474H,0534490H
		LWORD	05344ACH,CHRPAL3+04C8H,053A4E4H,0536420H,0536420H,0536490H
;
MPCHRST_PAL_FB	EQU	$
		LWORD	053A43CH,0538420H,053843CH,CHRPAL3+2458H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
MPCHRST_PAL_DB	EQU	$
		LWORD	053A43CH,0538420H,053843CH,CHRPAL3+2474H,0538474H,0538490H
		LWORD	05384ACH,05384C8H,05384E4H,053A404H,053A420H,053A43CH
;
 ENDIF	  ;**** PAL Ή [1995/08/01] *****************************
;
;
;****************************************************************
;*								*
;*		}bv ACR Y[Zbg			*
;*				in				*
;*				R1 <- CMODE NO.			*
;*				R3 <- R[X mn.		*
;*				R6 <- {			*
;*				out				*
;*				R2 <- rbg}bvW w	*
;*				R3 <-	"       "      x	*
;*				R6 <- {			*
;*				R8 <- S w			*
;*				R9 <-	"  x                   *
;*				R12 <- LN^[ AhX L,H*
;*				R13 <-	"       "	"    B  *
;****************************************************************
MPAICNZM	EQU	$
		IBT	R0,#BANK MPCHRST_ADR0
		ROMB
		IWT	R0,#MPCHRST_ADR0
		ADD	R3
		ADD	R3
		TO	R14
		ADD	R3
		TO	R12
		GETB
		INC	R14
		WITH	R12
		GETBH			; R12 <- bit map address data
		INC	R14
		TO	R13
		GETB			; R13 <- #053H (LN^[ oN)
;
		IWT	R0,#00404H
		WITH	R12		; R12 <- LN^[ AhX
		SUB	R0		;	R12 = R12 - R0
;
		IBT	R2,#00		; R2 <- #00 (rbg}bvW w)
		MOVE	R3,R2		; R3 <- #00 (	"       "     x)
		IBT	R8,#010H	; R8 <- #010H (S w)
		MOVE	R9,R8		; R9 <- #010H (S x)
		MOVE	R11,R6
;
		IWT	R15,#C_32_ZOOM_XY_C	; goto C_32_ZOOM_XY_C
		NOP
;
;****************************************************************
;*								*
;*		R[XC ACR]k			*
;*				in				*
;*				R1 <- CMODE NO.			*
;*				R3 <- R[X mn.		*
;*				R5 <- px (0`0`FFH)		*
;*				R6 <- { (100H = 1.0)		*
;*				out				*
;*				R1 <- CMODE NO.			*
;*				R2 <- rbg}bvW w	*
;*				R3 <-	"       "      x	*
;*				R5 <- px (0`0`FFH)		*
;*				R6 <- { (100H = 1.0)		*
;*				R12 <- LN^[ AhX L,H*
;*				R13 <-	"       "	"     B *
;****************************************************************
CSINROLSM	EQU	$
		IBT	R0,#BANK MPCHRST_ADR0
		ROMB
		IWT	R0,#MPCHRST_ADR0
		ADD	R3
		ADD	R3
		TO	R14
		ADD	R3		;	R14 = R0 + R3
		TO	R12
		GETB
		INC	R14
		WITH	R12
		GETBH			; R12 <- bit map address data
		INC	R14
		TO	R13
		GETB			; R13 <- #053H (LN^[ oN)
;
		IWT	R0,#00404H
		WITH	R12		; R12 <- LN^[ AhX
		SUB	R0		;	R12 = R12 - R0
		IBT	R2,#00		; R2 <- #00 (rbg}bvW w)
		MOVE	R3,R2		; R3 <- #00 (	"       "     x)
;
		IWT	R15,#C_32_ROTZOM_C	; goto C_32_ROTZOM_C
		NOP
;
;
;****************************************************************
;*								*
;*		ʎw̐					*
;*				in				*
;*				R0 <-- f[^ oN		*
;*				R2 <-- XN[l		*
;*				R9 <-- f[^ AhX		*
;*				R10 <- obt@AhX		*
;****************************************************************
DISP_CNTRL	EQU	$
		ROMB			; f[^ oN Zbg
;
;;;;		    IWT	    R12,#000B2H	    ; \ʂ̃C([v)
		IWT	R12,#000D2H	; \ʂ̃C([v)
		IWT	R13,#DISP_CTL_200	; AhX Zbg
;
		CACHE			; LbV X^[g !!
;
DISP_CTL_100
		MOVE	R14,R9
		GETB
		INC	R14
		TO	R3
		GETBH			; R3 <- Zbg f[^
		INC	R14
		GETB
		INC	R14
		TO	R7
		GETBH			; R7 <- GhC
		INC	R14
		MOVE	R9,R14
;
DISP_CTL_200
		FROM	R2
		CMP	R7		; k Gh ?
		BCS	DISP_CTL_100	;	YES -> DISP_CTL_100
		NOP
;
		FROM	R3
		STW	(R10)		; f[^ Zbg !!
		INC	R10
		INC	R10
		LOOP
		INC	R2
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	afQ XN[					*
;*			in					*
;*			R1  <- [hmn.			*
;*					2:XN[	*
;*					4:X^[XN[	*
;*			R2  <- afQ̏cXN[l		*
;*			R3  <- f[^ AhX			*
;*			R4  <- f[^ oNAhX		*
;*			R10 <- g|cl`obt@ AhX	*
;*			R11  <- Aj[VXgbv tO	*
;*			cwrk0 <- U				*
;****************************************************************
BG2SCSP		EQU	$
;
		CACHE			; LbV X^[g!!
;
;;;;		    IWT	    R12,#000B2H	    ; \ʂ̃C([v)
		IWT	R12,#000D2H	; \ʂ̃C([v)
		MOVE	R5,R4
		LM	R7,CBG2SCR_CNT
		MOVES	R0,R11
		BNE	BG2SCSP_000
		INC	R7
		INC	R7
		IWT	R0,#001FEH
		AND	R7
		SM	R0,CBG2SCR_CNT	; JEg
BG2SCSP_000
		IBT	R0,#BANK BG2SCSP_MD_ADR
		ROMB
		IWT	R0,#BG2SCSP_MD_ADR
		TO	R14
		ADD	R1
		GETB
		INC	R14
		TO	R15
		GETBH
		NOP
;
;
BG2SCSP_MD_ADR
		WORD	BG2SCSP_100	; XN[
		WORD	BG2SCSP_200	; X^[XN[
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		XN[				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2SCSP_100	EQU	$
		FROM	R5
		ROMB			; f[^ oN Zbg
		IWT	R13,#BG2SCSP_140	; AhX Zbg
BG2SCSP_110
		MOVE	R14,R3
		GETBS
		MOVES	R11,R0		; [h؂芷 ?
		BPL	BG2SCSP_120	;	NO -> BG2SCSP_120
		INC	R3
		TO	R1
		AND	#00FH
		IWT	R15,#BG2SCSP_000
		NOP
BG2SCSP_120
		MOVE	R14,R3
		GETB
		INC	R14
		TO	R6
		GETBH
		LMS	R0,CESCCH1
		LMULT
		TO	R7
		SWAP
		MOVE	R8,R4
		TO	R11
		MERGE
;
		INC	R14
		GETB
		INC	R14
		TO	R9
		GETBH			; C blof[^ Zbg
		WITH	R3
		ADD	#004
;
BG2SCSP_140
		FROM	R2
		CMP	R9
		BCS	BG2SCSP_110
;
		FROM	R11
		STW	(R10)
		INC	R10
		INC	R10
		LOOP
		INC	R2
;
		STOP
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		X^[XN[			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2SCSP_200	EQU	$
		LM	R7,CBG2SCR_CNT	; JEg
		IWT	R13,#BG2SCSP_240	; AhX Zbg
		FROM	R2		; X^[XN[
		ADD	R2		;	X^[g C Zbg
		TO	R7		;
		ADD	R7		;
;
BG2SCSP_210
		FROM	R5
		ROMB			; f[^ oN Zbg
		MOVE	R14,R3
		GETBS
		MOVES	R11,R0		; [h؂芷 ?
		BPL	BG2SCSP_220
		INC	R3
		TO	R1
		AND	#00FH
		IWT	R15,#BG2SCSP_000
		NOP
;
BG2SCSP_220
		MOVE	R9,R7
		INC	R14
		GETB
		INC	R14
		TO	R6
		GETBH
		LMS	R0,CESCCH1
		LMULT
		TO	R7
		SWAP
		MOVE	R8,R4
		TO	R11
		MERGE			; R11 <- XN[l
		MOVE	R7,R9
;
;;;;K;;;;		IWT	R0,#CESCCH1	; CESCCH1̂q`lAhX
;;;;K;;;;		TO	R11
;;;;K;;;;		ADD	R11
;
		INC	R14
		GETB
		INC	R14
		TO	R9
		GETBH			; C blof[^ Zbg
		INC	R14
		TO	R8
		GETB			; JEg Zbg
		WITH	R3
		ADD	#005
;
		LMS	R1,CWORK0	;  Zbg
;
		IBT	R0,#BANK SIN
		ROMB			; TCf[^ oN Zbg
;
BG2SCSP_240
		IWT	R0,#001FEH
		TO	R7
		AND	R7
;
		FROM	R2
		CMP	R9
		BCS	BG2SCSP_210
		NOP
;
		IWT	R0,#SIN
		TO	R14
		ADD	R7
		GETB
		INC	R14
		TO	R6
		GETBH			; R0 <- TCf[^
		FROM	R1
		LMULT
		FROM	R4
		HIB
		TO	R4
		SEX
;
		FROM	R11
		ADD	R4
		STW	(R10)
		INC	R10
		INC	R10
		WITH	R7
		ADD	R8		; JEg{Q
		LOOP
		INC	R2
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	afQ uXN[					*
;*			in					*
;*			R1  <- uXN[ or k tO	*
;*			R2  <- afQ̏cXN[l		*
;*			R3  <- U				*
;*			R7  <- f[^ AhX			*
;*			R8  <- f[^ oNAhX		*
;*			R10 <- g|cl`obt@ AhX	*
;*			R11  <- Aj[VXgbv tO	*
;****************************************************************
BG2VSCSP	EQU	$
;
		CACHE			; LbV X^[g!!
;
		MOVES	R0,R11
		BNE	BG2VSCSP_000
		NOP
		LM	R11,CBG2V_CNT
		DEC	R11
		DEC	R11
		IWT	R0,#001FEH
		TO	R11
		AND	R11
		SM	R11,CBG2V_CNT
;
BG2VSCSP_000
		MOVE	R0,R2		; lobt@ɃZbg
		MOVE	R11,R10
;;;;		    IWT	    R12,#000B2H
		IWT	R12,#000D2H
		MOVE	R13,R15
;
		STW	(R11)
		INC	R11
		LOOP
		INC	R11
;
		IBT	R0,#BANK BG2VSCSP_MD_ADR
		ROMB
		IWT	R0,#BG2VSCSP_MD_ADR
		TO	R14
		ADD	R1
		GETB
		INC	R14
		TO	R15
		GETBH
		NOP
;
BG2VSCSP_MD_ADR EQU	$
		WORD	BG2VSCSP_200	; uXN[
		WORD	BG2VSCSP_400	; k
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		afQ uXN[			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2VSCSP_200	EQU	$
		MOVE	R1,R2
;;;;		    IWT	    R12,#000B2H	    ; \ʂ̃C([v)
		IWT	R12,#000D2H	; \ʂ̃C([v)
		IWT	R13,#BG2VSCSP_240	; AhX Zbg
		LM	R11,CBG2V_CNT
		FROM	R2
		ADD	R2
		ADD	R0
		TO	R11
		SUB	R11
;
BG2VSCSP_210
		IWT	R4,#0FFH
		FROM	R8
		ROMB			; f[^ oN Zbg
		MOVE	R14,R7
		GETB
		CMP	R4		; f[^ Gh ?
		BEQ	BG2VSCSP_290	;	YES -> BG2VSCSP_290
		INC	R14
		MOVE	R5,R0		; R5 <- X^[ XCb`
		GETB
		INC	R14
		TO	R9
		GETBH			; C rf[^ Zbg
		INC	R14
		MOVE	R7,R14
;
		IBT	R0,#BANK SIN
		ROMB			; TCf[^ oN Zbg
;
BG2VSCSP_240
		IWT	R0,#001FEH
		TO	R11
		AND	R11
;
		FROM	R2
		CMP	R9
		BCS	BG2VSCSP_210
		NOP
		MOVES	R0,R3
		BEQ	BG2VSCSP_250
		NOP
		MOVES	R0,R5
		BEQ	BG2VSCSP_250
		NOP
;
		IWT	R0,#SIN
		TO	R14
		ADD	R11
		GETB
		INC	R14
		TO	R6
		GETBH			; R0 <- TCf[^
		FROM	R3
		LMULT
		FROM	R4
		HIB
		SEX
		WITH	R11
		ADD	#004		; JEg{S
;
BG2VSCSP_250
		ADD	R1
		STW	(R10)
		INC	R10
		INC	R10
		LOOP
		INC	R2
;
BG2VSCSP_290
		STOP
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		af ck				+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2VSCSP_400
		FROM	R8
		ROMB			; f[^ oN Zbg
;
		MOVE	R14,R7
		GETB
		SMS	R0,CWORKF	; cworkF <- Xs[h
		INC	R14
		GETB
		INC	R14
		SMS	R0,CWORKE	; cworke <- ŏl
		SMS	R14,CWORK0
;
;;;;		    IWT	    R12,#000B2H	    ; \ʂ̃C([v)
		IWT	R12,#000D2H	; \ʂ̃C([v)
		IWT	R13,#BG2VSCSP_430	; AhX Zbg
		MOVE	R9,R2
		FROM	R2
		TO	R3
		ADD	R12
		DEC	R3		; R3 <- ͈̓`FbN JE^[
		FROM	R12
		ADD	R12
		TO	R10
		ADD	R10		; R10 <- obt@ AhX
;
BG2VSCSP_410
		MOVE	R2,R9
		LMS	R14,CWORK0
		GETB
		INC	R14
		TO	R7
		GETBH			; R7 <- X^[gC
		FROM	R7
		ADD	#001		; f[^ Gh ?
		BEQ	BG2VSCSP_490	;	YES -> BG2VSCSP_490
		INC	R14
		GETB
		INC	R14
		TO	R8
		GETBH			; R8 <- GhC
		INC	R14
		SMS	R14,CWORK0
;
		IWT	R1,#07FFFH
		LM	R0,CBG2V_CNT	; R11 <- kJE^[
		TO	R11
		AND	R1
		IBT	R4,#000H
;
;;;;		    IWT	    R0,#000B2H
		IWT	R0,#000D2H
		ADD	R2
		FROM	R8
		SUB	R0
		BMI	BG2VSCSP_430
		WITH	R11
		TO	R6
		MOVE	R1,R0
		LMULT
		FROM	R4
		HIB
		FROM	R1
		SUB	R0
		WITH	R2
		SUB	R0
		WITH	R4
		LOB
;
BG2VSCSP_430
		DEC	R10
		DEC	R10
		FROM	R3
		CMP	R8		; k Gh ?
		BCS	BG2VSCSP_485	;	YES -> BG2VSCSP_485
		FROM	R3
		CMP	R7		; kX^[g ?
		BCC	BG2VSCSP_410	;	NO -> BG2VSCSP_410
;
		FROM	R4
		ADD	R11
		TO	R4
		LOB
		HIB
		BNE	BG2VSCSP_480
		WITH	R2
		TO	R0
		DEC	R2		; k !!
BG2VSCSP_480
		STW	(R10)		; XN[l Zbg !!
BG2VSCSP_485
		LOOP
		DEC	R3
;
BG2VSCSP_490
		LMS	R10,CWORKE	; R10 <- ŏl
		LMS	R1,CWORKF	; R1 <-- Xs[h
		LM	R0,CBG2V_CNT
		MOVES	R2,R0
		BMI	BG2VSCSP_490_50
		NOP
		SUB	R1
		BMI	BG2VSCSP_490_05
		NOP
		CMP	R10
		BCS	BG2VSCSP_490_90
		NOP
BG2VSCSP_490_05
		IWT	R0,#08000H
		OR	R10
BG2VSCSP_490_50
		ADD	R1
		IWT	R3,#08100H
		CMP	R3
		BCC	BG2VSCSP_490_90
		NOP
		IWT	R2,#07FFFH
		AND	R2
;
BG2VSCSP_490_90
		SM	R0,CBG2V_CNT
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	obNAbv q`l CjV f[^ Zbg		*
;*				in				*
;*				R1  <- CjVf[^AhX *
;*				R2  <-	"       "	oN	*
;*				R10 <- ]AhX		*
;****************************************************************
BAKINTST	EQU	$
		CACHE			;LbV X^[g !!
		IWT	R12,#(SAVERAM1-SAVERAM0)/2
		IWT	R13,#BAKINTST_LOP
;
		FROM	R2
		ROMB
		MOVE	R2,R10
		MOVE	R14,R1
;
BAKINTST_LOP
		GETB
		INC	R14
		GETBH
		INC	R14
		STW	(R2)
		INC	R2
		LOOP
		INC	R2
;
		BRA	SAVEPRS
		NOP
;
;
;****************************************************************
;*								*
;*	obNAbv q`l Z[u q`l [h		*
;*				in				*
;*				R1  <- ]AhX		*
;*				R10 <- ]AhX		*
;****************************************************************
LDBAKSET	EQU	$
		MOVE	R2,R10
;
		CACHE			;LbV X^[g !!
		IWT	R12,#(SAVERAM1-SAVERAM0)/2
		IWT	R13,#LDBAKSET_LOP
;
LDBAKSET_LOP
		LDW	(R1)
		STW	(R2)
		INC	R1
		INC	R1
		INC	R2
		LOOP
		INC	R2
;
;
;****************************************************************
;*								*
;*		obNAbv q`l				*
;*								*
;*		  Z[u q`l					*
;*				 f[^ ׂăvX	*
;*				in				*
;*				R10 <- q`lAhX		*
;*				out				*
;*				R0  <- vX		*
;****************************************************************
SAVEPRS		EQU	$
		CACHE			;LbV X^[g !!
		IWT	R12,#(SAVERAM1-SAVERAM0)/2
		IWT	R13,#SAVEPRS_LOP
;
		IBT	R1,#000
SAVEPRS_LOP
		LDW	(R10)
		TO	R1
		ADD	R1
		INC	R10
		LOOP
		INC	R10
;
		IWT	R0,#07777H
		SUB	R1
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*		ACR ]					*
;*			in					*
;*			R1 <-- blncd mn.			*
;*			R2 <-- TCf[^CfbNX		*
;*			R3 <- R[X mn.			*
;*			R11 <- x{( 100H=1.0 )		*
;****************************************************************
AICONHKAITEN	EQU	$
		FROM	R1
		CMODE			; J[ [h Zbg
;
		IBT	R0,#BANK MPCHRST_ADR0
		ROMB
		IWT	R0,#MPCHRST_ADR0
		ADD	R3
		ADD	R3
		TO	R14
		ADD	R3
		GETB
		INC	R14
		TO	R9
		GETBH			; R6 <- bit map address data
		INC	R14
		TO	R10
		GETB
;
		LMS	R6,CWORK0
		MOVES	R0,R6
		BEQ	AICONHKAITEN_20
		WITH	R6
		TO	R9
;
AICONHKAITEN_20
		IWT	R0,#00404H
		WITH	R9
		SUB	R0		; R9 <- LN^[ AhX
;
		SMS	R10,CCWORK0	; LN^[ oNAhX
;
;
;****************************************************************
;*								*
;*		߂ vO				*
;*			in					*
;*			R2 <-- TCf[^CfbNX		*
;*			R3 <-- R[X mn.			*
;*			R9 <-- f[^ AhX (k,g)		*
;*			cwork0 <- f[^ AhX (a)		*
;*			R11 <- x{( 100H=1.0 )		*
;****************************************************************
MEKURE		EQU	$
;
;-------------- RTCf[^ ǂݍ -------------------------
		IBT	R0,#BANK COS
		ROMB
;
		IWT	R0,#COS
		TO	R14
		ADD	R2
		GETB
		INC	R14
		TO	R6
		GETBH
;
;-------------- {ϊ ----------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6
		LDW	(R0)		; R6 <- LN^[{
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11
		LDW	(R0)		; R11 <- LN^[{
;
;-------------- X^[g|CgvZ ----------------------------
		IBT	R0,#010H	; #010H (S w)
		TO	R8
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R8
		ADD	R4		; R8 <- SX * x_zoom
		MOVE	R5,R6		; R5 <- w{
;
		MOVE	R6,R11
		IBT	R0,#010H	; #010H (S x)
		TO	R10
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R10
		ADD	R4		; R10 <- SY * y_zoom
;
;-------------- ݃[h ----------------------------------
		MOVE	R6,R9		; R6 <- LN^[ AhX
;
		IBT	R3,#000
;
;--------------  ----------------------------------------
		LMS	R0,CCWORK0
		ROMB			; oN (#053H) Zbg
;
		IWT	R13,#MEKURE_50
		IBT	R4,#032
;
		CACHE			; LbV X^[g !!
;
MEKURE_40
		IBT	R12,#032	; R12 <- x[v JEg
		MOVE	R1,R3
		IBT	R2,#000
		MOVE	R7,R10
;
MEKURE_50
		MERGE
		BCS	MEKURE_60
		TO	R14
		ADD	R6
;
		WITH	R7
		ADD	R11
		GETC
		PLOT
		DEC	R1
		LOOP
		INC	R2		; Y pos +1
;
		BRA	MEKURE_70
		NOP
;
MEKURE_60
		WITH	R7
		ADD	R11
		SUB	R0		;IBT R0,#00
		COLOUR
		PLOT
		INC	R2		; Y pos +1
		LOOP
		DEC	R1
;
MEKURE_70
		WITH	R8
		ADD	R5
		DEC	R4		; Gh ?
		BNE	MEKURE_40	;	NO -> MEKURE_40
		INC	R3
;
		RPIX
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	XN[}bv X^[ XN[ Zbg		*
;*				in				*
;*				R3 <-- őU			*
;*				R5 <-- f[^ AhX(a)	*
;*				R7 <-- TCf[^ X^[g	*
;*				R8 <-- Xebv		*
;*				R9 <-- lorbgQ		*
;*				R11 <- f[^ AhX(k,g) *
;*				R12 <- [v̉		*
;****************************************************************
HMPRSTER	EQU	$
		WITH	R7
		ADD	R7
		WITH	R8
		ADD	R8
		IWT	R10,#MPWIND0+6+10H
;
		CACHE			; LbV X^[g !!
;
		MOVE	R1,R12
		IWT	R12,#(8*2)+04
		IWT	R13,#HMPRSTER_100
		IWT	R0,#000FFH
HMPRSTER_100
		STW	(R10)		;  f[^
		INC	R10		;	Zbg |Cg
		INC	R10		;		炷
		INC	R10
		LOOP
		INC	R10
;
		IWT	R0,#00100H
		TO	R9
		SUB	R9
		MOVE	R12,R1
		IWT	R13,#HMPRSTER_200
;
HMPRSTER_200
		FROM	R5
		ROMB
;
		MOVE	R14,R11
		GETB
		INC	R14
		TO	R1
		GETBH			; R1 <-  f[^
;
		IBT	R0,#BANK SIN
		ROMB
		IWT	R0,#SIN
		TO	R14
		ADD	R7
		GETB
		INC	R14
		TO	R6
		GETBH			; R6 <- TCf[^
;
		FROM	R3
		LMULT
		FROM	R4
		HIB
		SEX			; R0 <- U̕
;
		ADD	R9
		ADD	R1
;
		STW	(R10)
		WITH	R7
		ADD	R8
		IWT	R0,#001FFH
		TO	R7
		AND	R7
		INC	R10
		INC	R10
		INC	R10
		INC	R10
		INC	R11
		LOOP
		INC	R11
;
		STOP
		NOP
;
;
;
;----------------------------------------------------------------
;-		R0 : character bank				-
;-		R3 : character address				-
;----------------------------------------------------------------
GININIT		EQU	$
		ROMB
		IBT	R0,#01
		CMODE
;
		CACHE			; LbV X^[g !!
;
		IBT	R2,#00
		IBT	R4,#018H
GINIT0020
		IBT	R1,#00
		IBT	R12,#018H
;;;		IWT	R13,#(GINIT0040&0FFFFH)
		MOVE	R13,R15
GINIT0040
		FROM	R3
		TO	R14
		ADD	R1
		GETC
		LOOP
		PLOT
;
		IWT	R0,#0100H
		WITH	R3
		ADD	R0
		DEC	R4
		BNE	GINIT0020		;
		INC	R2
;
		RPIX
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	GINGAMI							-
;-		R3 : x position					-
;-		R4 : y	  "                                     -
;----------------------------------------------------------------
GINGAMI		EQU	$
		IBT	R0,#01
		CMODE
		IBT	R0,#00
		COLOR
;
		FROM	R3
		TO	R1
		SUB	#01
		MOVE	R2,R4
;
		CACHE
;
		IBT	R12,#3
;;;;		IWT	R13,#(GING0010&0FFFFH)
		MOVE	R13,R15
GING0010
		MOVES	R0,R1
		BMI	GING0080		;
		NOP
;
		IBT	R0,#018H
		FROM	R1
		SUB	R0
		BCS	GING0080		;
		NOP
;
		PLOT
GING0080
		LOOP
		NOP
;
		MOVE	R1,R3
		FROM	R4
		TO	R2
		SUB	#01
;
		IBT	R12,#3
		IWT	R13,#(GING0090&0FFFFH)
;
GING0090
		MOVES	R0,R2
		BMI	GING0100		;
		NOP
;
		IBT	R0,#018H
		FROM	R2
		SUB	R0
		BCS	GING0100		;
		NOP
;
		PLOT
		DEC	R1
GING0100
		LOOP
		INC	R2
;
		RPIX
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	dot erase						-
;-	CWORK0 <- x position 1					-
;-	CWORK1 <- x position 2					-
;-	CWORK2 <- y position 1					-
;-	CWORK3 <- y position 2					-
;----------------------------------------------------------------
DOTERASE	EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#01
		CMODE
		IBT	R0,#00
		COLOR
;
		LMS	R6,CWORK2
		LMS	R7,CWORK3
		LMS	R8,CWORK0
		LMS	R9,CWORK1
		IBT	R3,#3
DE0040
		MOVE	R4,R8
		MOVE	R5,R9
		IBT	R12,#3
		MOVE	R13,R15
DE0060
		MOVE	R1,R4
		MOVE	R2,R6
		PLOT
		MOVE	R1,R5
		MOVE	R2,R7
		WITH	R4
		ADD	#8
		WITH	R5
		ADD	#8
		LOOP
		PLOT
;
		WITH	R6
		ADD	#8
		WITH	R7
		ADD	#8
		DEC	R3
		BNE	DE0040			;
		NOP
;
		RPIX
		STOP
		NOP
;
;
;--------------------------------------------------------
;-	SHUTTER						-
;-	R0 <- char bank					-
;-	R3 <- char address				-
;-	R4 <- v counter (0-B)				-
;-	R5 <- h counter (0-B)				-
;--------------------------------------------------------
SHUTTER		EQU	$
		ROMB
		IBT	R0,#15H
		CMODE
;
		CACHE			; LbV X^[g !!
;
		MOVE	R7,R4
;
		IBT	R2, #00
		IBT	R9, #12
SHUT0030
		FROM	R7
		TO	R6
		SWAP
		IBT	R1, #00
		MOVE	R8,R5
		IBT	R12,#12
		MOVE	R13,R15
SHUT0040
		FROM	R6
		ADD	R8
		TO	R14
		ADD	R3
;
		FROM	R7
		SUB	#12
		BCS	SHUT0080		;
		NOP
;
		FROM	R8
		SUB	#12
		BCS	SHUT0080		;
		NOP
;
		BRA	SHUT0090
		GETC
;
SHUT0080
		IBT	R0,#00
		COLOR
SHUT0090
		INC	R8
		LOOP
		PLOT
;
		DEC	R8
;
		IBT	R12,#12
		MOVE	R13,R15
SHUT0140
		FROM	R6
		ADD	R8
		TO	R14
		ADD	R3
;
		FROM	R7
		SUB	#12
		BCS	SHUT0180		;
		NOP
;
		FROM	R8
		SUB	#12
		BCS	SHUT0180		;
		NOP
;
		BRA	SHUT0190
		GETC
;
SHUT0180
		IBT	R0,#00
		COLOR
SHUT0190
		DEC	R8
		LOOP
		PLOT
;
		INC	R7
		DEC	R9
		BNE	SHUT0030		;
		INC	R2
;
		DEC	R7
;
		IBT	R9, #12
SHUT0230
		FROM	R7
		TO	R6
		SWAP
		IBT	R1, #00
		MOVE	R8,R5
		IBT	R12,#12
		MOVE	R13,R15
SHUT0240
		FROM	R6
		ADD	R8
		TO	R14
		ADD	R3
;
		FROM	R7
		SUB	#12
		BCS	SHUT0280		;
		NOP
;
		FROM	R8
		SUB	#12
		BCS	SHUT0280		;
		NOP
;
		BRA	SHUT0290
		GETC
;
SHUT0280
		IBT	R0,#00
		COLOR
SHUT0290
		INC	R8
		LOOP
		PLOT
;
		DEC	R8
;
		IBT	R12,#12
		MOVE	R13,R15
SHUT0340
		FROM	R6
		ADD	R8
		TO	R14
		ADD	R3
;
		FROM	R7
		SUB	#12
		BCS	SHUT0380		;
		NOP
;
		FROM	R8
		SUB	#12
		BCS	SHUT0380		;
		NOP
;
		BRA	SHUT0390
		GETC
;
SHUT0380
		IBT	R0,#00
		COLOR
SHUT0390
		DEC	R8
		LOOP
		PLOT
;
		DEC	R7
		DEC	R9
		BNE	SHUT0230		;
		INC	R2
;
		RPIX
;
		STOP
		NOP
;
;
;****************************************************************
;*	ACR XNb` NA[				*
;*				in				*
;*				R0 : blncd m.		*
;*				R3 : wW			*
;*				R4 : xW			*
;****************************************************************
AICNCLS		EQU	$
		CMODE
		IBT	R0,#00
		COLOR
;
		IBT	R5,#008*4
;
		FROM	R3
		TO	R1
		SUB	#01
		MOVE	R2,R4
;
		CACHE			;LbV X^[g!!
;
		IBT	R12,#3
		MOVE	R13,R15
AICNCLS_010
		MOVES	R0,R1		;wWrbg}bv GA ?
		BMI	AICNCLS_020	;	NO -> AICNCLS_020
;
		FROM	R1
		SUB	R5
		BCS	AICNCLS_020
		NOP
;
		PLOT
AICNCLS_020
		LOOP
		NOP
;
		MOVE	R1,R3
		FROM	R4
		TO	R2
		SUB	#01
;
		IBT	R12,#3
		MOVE	R13,R15
;
AICNCLS_050
		MOVES	R0,R2		;xWrbg}bv GA ?
		BMI	AICNCLS_070	;	NO -> AICNCLS_070
;
		FROM	R2
		SUB	R5
		BCS	AICNCLS_070
		NOP
;
		PLOT
		DEC	R1
AICNCLS_070
		LOOP
		INC	R2
;
		RPIX
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	RtBO ACR LN^[ uq`lZbg		*
;*				in				*
;*				R0  : blncd m.		*
;*				R10 : LN^[ AhX	*
;****************************************************************
CNFGAICN	EQU	$
		CMODE			; blncd m. Zbg
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		FROM	R1
 ENDIF	  ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		IBT	R0,#053H
 ENDIF	       ;**** { or NES Ή [1995/08/02] *****************************
;
		ROMB			; LN^[ oN Zbg
;
		IBT	R3,#000H	; R3 : w l
		IBT	R4,#038H	; R4 : x l
		IWT	R13,#CNFGAICN_LOP0
		IBT	R6,#03
;
		CACHE			; LbV X^[g !!
;
CNFGAICN_LOP2
		MOVE	R2,R4		;x X^[g|Cg
;
CNFGAICN_LOP1
		MOVE	R1,R3		;w X^[g|Cg
		IBT	R12,#24
		MOVE	R14,R10
;
CNFGAICN_LOP0				; LN^[ Zbg !!
		GETC
		PLOT
		LOOP
		INC	R14
;
		IWT	R0,#256		;
		TO	R10		;
		ADD	R10		;	R10 = R10 + #256
		INC	R2
		FROM	R2
		AND	#007		; R4 and #007 -> R4 = 0 ?
		BNE	CNFGAICN_LOP1	;	NO -> MPCHRST_LOP1
		NOP
;
		IBT	R0,#24		; w |CgZbg
		TO	R3
		ADD	R3		;	R3 = R3 + #024
		IBT	R0,#127
		TO	R3
		AND	R3		; R3 <- R3 and R0
		DEC	R6
		BNE	CNFGAICN_LOP2
		NOP
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		J[[tBO					*
;*			in : (R1) <-- J[				*
;*			     (R2) <-- J[				*
;*			     (R6) <-- {				*
;*			out :						*
;*			     (R3) <-- [tBOJ[		*
;************************************************************************
COL_MORF	EQU	$
		IBT	R0,#01FH	;(R0) <-- iqjǂݍ݂`mcf[^
		TO	R3		;(R3) <-- J[iqj
		AND	R1
		AND	R2		;(R0) <-- J[iqj
		SUB	R3
		LOB
		SWAP
		FMULT
		TO	R3		;(R3) <-- [tBOJ[iqj
		ADD	R3
;
		IWT	R0,#01FH<<5	;(R0) <-- ifjǂݍ݂`mcf[^
		MOVE	R7,R0
		TO	R5		;(R5) <-- J[ifj
		AND	R1
		AND	R2		;(R0) <-- J[ifj
		SUB	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R5
		AND	R7
		TO	R3		;(R3) <-- [tBOJ[iqjifj
		OR	R3
;
		IWT	R0,#01FH<<10	;(R0) <-- iajǂݍ݂`mcf[^
		MOVE	R7,R0
		TO	R5		;(R5) <-- J[iaj
		AND	R1
		AND	R2		;(R0) <-- J[iaj
		SUB	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R5
		AND	R7
		TO	R3		;(R3) <-- [tBOJ[
		OR	R3
;
		STOP
		NOP
;
;************************************************************************
;*		J[[tBOiubNj				*
;*			in : (R8)  <-- J[|C^[iO`eej	*
;*			     (R14) <-- J[f[^AhXikCgj *
;*			     (R0)  <--		 h	     iaj	*
;*			     (R12) <-- J[				*
;*			     (R6)  <-- {				*
;************************************************************************
COL_MORF_B	EQU	$
		ROMB
		MOVE	R14,R14
;
		IWT	R0,#MOTOCOL
		ADD	R8
		TO	R9		;(R9) <-- J[|C^[
		ADD	R8
		IWT	R0,#DATACOL
		ADD	R8
		TO	R8		;(R8) <-- i[J[|C^[
		ADD	R8
;
		IBT	R11,#01FH	;(R11) <-- iqjǂݍ݂`mcf[^
		IWT	R7,#01FH<<5	;(R7)  <-- ifjǂݍ݂`mcf[^
		IWT	R10,#01FH<<10	;(R10) <-- iajǂݍ݂`mcf[^
;
		CACHE
;
		MOVE	R13,R15
COL_MORF_B_010
		GETB
		INC	R14
;
		TO	R1		;(R1) <-- J[
		LDW	(R9)
		INC	R9
		INC	R9
;
		TO	R2		;(R2) <-- J[
		GETBH
		INC	R14
;
		MOVE	R0,R11		;(R0) <-- iqjǂݍ݂`mcf[^
		TO	R3		;(R3) <-- J[iqj
		AND	R1
		AND	R2		;(R0) <-- J[iqj
		SUB	R3
		LOB
		SWAP
		FMULT
		TO	R3		;(R3) <-- [tBOJ[iqj
		ADD	R3
;
		MOVE	R0,R7		;(R0) <-- ifjǂݍ݂`mcf[^
		TO	R5		;(R5) <-- J[ifj
		AND	R1
		AND	R2		;(R0) <-- J[ifj
		SUB	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R5
		AND	R7
		TO	R3		;(R3) <-- [tBOJ[iqjifj
		OR	R3
;
		MOVE	R0,R10		;(R0) <-- iajǂݍ݂`mcf[^
		TO	R5		;(R5) <-- J[iaj
		AND	R1
		AND	R2		;(R0) <-- J[iaj
		SUB	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R5
		AND	R10
		OR	R3		;(R0) <-- [tBOJ[
		STW	(R8)
;
		INC	R8
		LOOP
		INC	R8
;
		STOP
		NOP
;
;************************************************************************
;*		S[On`lZbg				*
;*			in :						*
;*				(R1) <-- n`lCfbNX		*
;*				(R2) <-- Sw\W			*
;*				(R3) <-- Sx\W			*
;*				(R4) <-- LmD			*
;*				(R6) <-- a~POOg			*
;*				(R7) <-- A^mD			*
;*				(R8) <-- S[O\tO		*
;*				(R9) <-- A^ʒuf[^		*
;*				(CWRK6) <-- A^O\^C}[	*
;*			out :						*
;*				(CWRK0) <-- ~܂Ƃ낪A^H	*
;*				(CWRK1) <-- S~SA^G{		*
;*				(CWRK2) <-- A^GLN^[AhX*
;*				(CWRK3) <-- Q~QA^G{		*
;*				(CWRK4) <-- A^GLN^[AhX*
;*				(CWRK5) <-- A^GS~SQ~QH	*
;*				(CWRK7-) <- ʃZbgpW		*
;************************************************************************
GOAL_RING	EQU	$
		SMS	R1,CWORK1F	;(CWK1F) <-- n`lCfbNX
;
		SUB	R0		;[ IBT R0,#0 ]
		SMS	R0,CWORK0	;(CWK0) <-- ~܂Ƃ낪A^HtOZbg
		INC	R0		;[ IBT R0,#1 ]
		SMS	R0,CWORK5	;(CWK5) <-- A^GS~SQ~QHZbg
		IBT	R0,#CWORK7
		SMS	R0,CWORK1E
;
		IBT	R0,#BANK LCOS
		ROMB
;
		IWT	R10,#4000H-10000H/10 ;(R10) <-- ~f[^|C^[
;
		IBT	R12,#10
		MOVE	R13,R15
GOAL_RING_0050
		LMS	R11,CWORK1E
;
		FROM	R10
		HIB
		IWT	R14,#LCOS
		TO	R14		;(R14) <-- bnrf[^AhX
		ADD	R14
;
		IWT	R0,#10000H/10	;(R0) <-- ~Xebv
		WITH	R10
		SUB	R0
;
		WITH	R8
		LSR
		BCC	GOAL_RING_0060	;\njH ( yes:GOAL_RING_0060 )
		NOP
;
		FROM	R11
		ADD	#4
		SBK			;[ SMS R0,CWORK1E ]
		WITH	R9
		LSR
		DEC	R1		;[-1]
		mDJMP_X GOAL_RING_0110+1
		LOOP
;
GOAL_RING_0060
		GETBS
		MULT	#3
		DIV2
;
		IBT	R5,#040H	;(R5) <-- rhmf[^ւ̉Zl
		WITH	R14
		ADD	R5
;
		FMULT
		ADD	R2
		STW	(R1)		;n`lwWZbg
		INC	R1
		INC	R1
		STW	(R11)
;
		GETBS
		ADD	R0		;x4
		ADD	R0		;
;
		FMULT
		ADD	R3
		STW	(R1)		;n`lxWZbg
		INC	R11
		INC	R11
		STW	(R11)
		INC	R11
		INC	R11
		SMS	R11,CWORK1E
;
		MOVE	R14,R4
		WITH	R9
		LSR
		BCC	GOAL_RING_0070	;A^H ( no:GOAL_RING_0070 )
		INC	R1
;
		FROM	R12
		LSR
		BCC	GOAL_RING_0070	;A^H ( no:GOAL_RING_0070 )
		NOP
;
		INC	R14
		INC	R14
GOAL_RING_0070
		FROM	R12
		SUB	R7
		BPL	GOAL_RING_0072
		INC	R1
;
		ADD	#10
GOAL_RING_0072
		LSR
		BNE	GOAL_RING_0090	;A^  A^OH ( no:GOAL_RING_0090 )
		NOP
;
		BCC	GOAL_RING_0080	;A^OH ( no:GOAL_RING_0080 )
		NOP
;
;-------------- A^OII ----------------------------------------
		LMS	R0,CWORK6
		DEC	R0
		BMI	GOAL_RING_0090	;A^O\H ( no:GOAL_RING_0090 )
		NOP
;
		IWT	R5,#0CCH	;(R5) <-- A^G{Zbg
;
		FROM	R14		;~܂Ƃ낪A^ǂHtOZbg
		SUB	R4
		BEQ	GOAL_RING_0082	;H ( no:GOAL_RING_082 )
		NOP
;
		BRA	GOAL_RING_0120
		NOP
;
;-------------- A^II ----------------------------------------------
GOAL_RING_0080
		IWT	R5,#0100H	;(R5) <-- A^G{Zbg
;
		FROM	R14		;~܂Ƃ낪A^ǂHtOZbg
		SUB	R4
		SMS	R0,CWORK0
		BNE	GOAL_RING_0120	;H ( yes:GOAL_RING_0120 )
		NOP
;
;-------------- ͂II --------------------------------------
GOAL_RING_0082
		LMS	R0,CWORK5
		DEC	R0
		SBK			;[ SMS R0,CWORK5 ] A^GS~SQ~QHZbg
		BMI	GOAL_RING_0083
		SUB	R0		;[ IBT R0,#0 ]
;
		IBT	R0,#CWORK3-CWORK1
GOAL_RING_0083
		TO	R11
		ADD	#CWORK1
		IBT	R0,#(024H*2)+CWORK1
		SUB	R11
		TO	R14
		LSR
		FROM	R12
		LSR
		IWT	R0,#CIPCHD+4010H
		BCS	GOAL_RING_0084	;ڂ݁H ( yes:GOAL_RING_0084 )
		NOP
;
		IWT	R0,#CIPCHD+3040H
GOAL_RING_0084
		FROM	R5
		STW	(R11)		;[ SMS R5,(CWORK1 or CWORK3) ] A^G{Zbg
		INC	R11
		INC	R11
		STW	(R11)		;[ SMS R0,(CWORK2 or CWORK4) ]A^GLN^[AhXZbg
;
		LDW	(R1)
		ADD	R4
		ADD	R14
		BRA	GOAL_RING_0098
		SBK			;[ STW (R1) ]
;
;-------------- nYII ----------------------------------------------
GOAL_RING_0090
		FROM	R14
		SUB	R4
		BNE	GOAL_RING_0092	;H ( yes:GOAL_RING_0092 )
		FROM	R12
;
		LSR
		BCS	GOAL_RING_0092	;ڂ݁H ( yes:GOAL_RING_0092 )
		NOP
;
		IWT	R0,#020H+(00000010B*100H) ;J[Q
		TO	R14
		ADD	R14
GOAL_RING_0092
		LDW	(R1)
		ADD	R14
		SBK			;[ STW (R1) ]
;
GOAL_RING_0098
		INC	R1
		INC	R1
GOAL_RING_0100
		FROM	R12
		SUB	#10/2
		BCS	GOAL_RING_0110	;D揇ʌցH ( no:GOAL_RING_0110 )
		INC	R1
;
		IBT	R0,#40H
		STB	(R1)
GOAL_RING_0110
		LOOP
		INC	R1
;
		LMS	R0,CWORK1F
		IBT	R5,#(13-1)*8
		ADD	R5
		SUB	R1
		BMI	GOAL_RING_0150	;n`l]H ( no:GOAL_RING_0150 )
		LSR			;1/8
;
		LSR			;
		TO	R12		;
		LSR			;
		INC	R12		;(R12) <-- n`l]萔
		MOVE	R0,R1		;(R0) <-- n`lCfbNX
		IBT	R5,#8		;(R5) <-- n`lCfbNXZl
		IWT	R1,#8000H	;(R1) <-- \wW
		IWT	R13,#GOAL_RING_0112+1
GOAL_RING_0112
		FROM	R1
		STW	(R0)
		ADD	R5
		LOOP
		FROM	R1
;
GOAL_RING_0150
		STOP
		NOP
;
;-------------- II --------------------------------------
GOAL_RING_0120
		SMS	R5,CWORK1	;A^G{Zbg
;
		IWT	R0,#CIPCHD+4020H
		SMS	R0,CWORK2
;
		LDW	(R1)
		ADD	R4
		ADD	#4
		SBK			;[ STW (R1) ] LmDZbg
;
		DEC	R1
		DEC	R1
		LDW	(R1)
		SUB	#8
		SBK			;[ STW (R1) ] xWZbg
		MOVE	R11,R0		;(R11) <-- xW
;
		DEC	R1
		DEC	R1
		LDW	(R1)
		SUB	#8
		SBK			;[ STW (R1) ] wWZbg
		MOVE	R14,R0		;(R14) <-- wW
;
		WITH	R1
		ADD	#8+4
;
		LDW	(R1)
		ADD	R4
		ADD	#6
		SBK			;[ STW (R1) ] ELmDZbg
;
		DEC	R1
		DEC	R1
		FROM	R11
		STW	(R1)		;ExWZbg
;
		DEC	R1
		DEC	R1
		IBT	R0,#010H
		ADD	R14
		STW	(R1)		;EwWZbg
;
		WITH	R1
		ADD	#8+4
;
		LDW	(R1)
		ADD	R4
		IBT	R5,#020H+4
		ADD	R5
		SBK			;[ STW (R1) ] LmDZbg
;
		DEC	R1
		DEC	R1
		IBT	R0,#010H
		ADD	R11
		MOVE	R11,R0
		STW	(R1)		;xWZbg
;
		DEC	R1
		DEC	R1
		FROM	R14
		STW	(R1)		;wWZbg
;
		WITH	R1
		ADD	#8+4
;
		LDW	(R1)
		ADD	R4
		IBT	R5,#020H+6
		ADD	R5
		SBK			;[ STW (R1) ] ELmDZbg
;
		DEC	R1
		DEC	R1
		FROM	R11
		STW	(R1)		;ExWZbg
;
		DEC	R1
		DEC	R1
		IBT	R0,#010H
		ADD	R14
		STW	(R1)		;EwWZbg
;
		WITH	R1
		ADD	#4+2
		mDJMP_X GOAL_RING_0100+1
		FROM	R12
;
;
;
;
;************************************************************************
;>>>>>>>>>>
;SIN CURBE WRITE
;entry
;R0 = DATA_BANK
;R1 = DATA_ADDRESS
;R2 = X BAIRITU
;R3 = Y BAIRITU
;----
;CWORK0 = X POSITION
;CWORK1 = Y POSITION
;CWORK2 = SHINPUKU
;CWORK3 = SYUUKI
;CWORK5 = H-DMA BUFFER (H scroll)
;CWORK6 = H-DMA BUFFER (V scroll)
;CWORK7 = SYUUKI ZURASHI DOT SUU
;return
;<<<<<<<<<<
;************************************************************************
;
BG3_SHADOW_SET	EQU	$
;
		ROMB				;R0 = DATA_BANK
;
;---- initial set
;
;;;		IWT	R12, #0B2H		;loop conter<<initial set>>
		IWT	R12, #0D2H		;loop conter<<initial set>>
		IBT	R0, #-9			;set initial
;;;		IWT	R10, #HDMABF		;BUFFER <v scroll>
		LMS	R10, CWORK6		;
;;;		IWT	R11, #HDMABF1		;BUFFER <h scroll>
		LMS	R11, CWORK5		;BUFFER <h scroll>
;
		CACHE
;
		MOVE	R13, R15		;
BG3SS_100					;
;;;		STW	(R11)			;
;;;		INC	R11			;
;;;		INC	R11			;
		STW	(R10)			;
		INC	R10			;
		INC	R10			;
		LOOP				;
		DEC	R0			;
;
		IWT	R4, #0200H		;R0 = 0200H
		IWT	R5, #0500H		;R1 = 280H + 0200H
;
		LMS	R0, CWORK0
		ADD	R4
		CMP	R5
		BCS	BG3SS_108		;> STOP
		NOP
BG3SS_105
		LMS	R0, CWORK1
		ADD	R4
		CMP	R5
		BCC	BG3SS_109
		NOP
BG3SS_108
		STOP
		NOP
BG3SS_109
;
;---- shadow set (not sin curve set)
;
		MOVE	R14, R1		;R1 = DATA_ADDRESS
		GETB			;R0 = DATA LENGTH
		INC	R14
;
		TO	R6		;
		SWAP			;
		FROM	R3		;
		FMULT			;
		MOVE	R1, R0		;R1 = Dyw * Yz (loop counter set)
		DIV2			;
		BNE	BG3SS_110	;DISPLAY NON
		NOP
		mDJMP_X BG3SS_900
		NOP
;
BG3SS_110
		LMS	R5, CWORK1
;;;		IWT	R9, #070H-0B2H/2-8	;
		IWT	R9, #070H-0D2H/2-8	;
		FROM	R5			;
		SUB	R0			;
		SUB	R9			;
		TO	R9			;
		ADD	R0			;R9 = (Yp  - (080H - 0D2H/2) - Dyw / 2 * Yz) *2
		SMS	R9, CWORK4
;
;;		IWT	R7, #HDMABF	;wide set buffer
;;		IWT	R8, #HDMABF1	;H scroll counter
		LMS	R7, CWORK6
		LMS	R8, CWORK5
		IBT	R11, #000H	;KASANTI
;
		IWT	R5, #DIVBUF	;gyakusuu get
		FROM	R3		;
		ADD	R3		;
		ADD	R5		;
		TO	R5		;
		LDW	(R0)		;gyakusuu
;
		IWT	R6, #080H
		LMS	R0, CWORK0
		SUB	R6
		NOT
		INC	R0
		SMS	R0, CWORK0
;
		GETB
;
		CACHE
;
		MOVE	R12, R1		;loop count = Dyw * Yz
		MOVE	R13, R15
BG3SS_200
;;;		IWT	R6, #0B2H*2
		IWT	R6, #0D2H*2
;
		FROM	R9		;MIN & MAX CHECK
		CMP	R6		;
		BCS	BG3SS_210	;
		NOP
;
		INC	R14
;
		FROM	R8		;R10 = H_HDMA_POINTER + W_POINTER
		TO	R10		;
		ADD	R9		;
;
		TO	R6
		SWAP
		FROM	R2
		FMULT
;;		WITH	R4
;;		HIB
;;		LOB
;;		SWAP
;;		OR	R4

		LMS	R6, CWORK0	;XPOS GET
		FROM	R6
		ADD	R0
		STW	(R10)		;H scroll set (cetnter set)
;
		TO	R6
		GETB
		DEC	R14
;
		FROM	R2
		LMULT					;Xw * Xz
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R0		;*2
;
		FROM	R7		;R10 = HDMA_POINTER + W_POINTER
		TO	R10		;
		ADD	R9		;
;
		SUB	R9
		DIV2
		SUB	#009H
		STW	(R10)		;wide set (wide set)
BG3SS_210
		WITH	R11		;minimum counter add
		ADD	R5		;
		FROM	R11		;seisuu bu get
		HIB			;
		ADD	R0		;seisuubu *2
		WITH	R14		;rom buffer plus
		ADD	R0		;
		WITH	R11		;R1 &= 0FFH (syou suu bu get)
		LOB			;
;
		INC	R9
;
		GETB
;
		LOOP
		INC	R9
;
;;;		STOP
;;;		NOP
;
;
;---- sin wave set
;
BG3SS_300
;
		IBT	R0, #BANK LSIN
		ROMB
;
		LMS	R11, CWORK3	;syuuki get
		IWT	R5, #DIVBUF	;gyakusuu get
		FROM	R11		;
		ADD	R11		;
		ADD	R5		;
		TO	R11		;
		LDW	(R0)		;gyakusuu
;
		IWT	R0, #00FFH
		LMS	R2, CWORK7
		TO	R2
		AND	R2
;
		FROM	R1		;R1 = Dyw * Yz / 2
		TO	R6		;
		DIV2			;
		WITH	R6
		ADD	R2
		FROM	R11		;R0 = (Dyw * Yz /2 ) * syuuki
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		OR	R4		;
		NOT			;
		INC	R0		;
		TO	R10		;
		LOB			;
;
;;;		IWT	R5, #HDMABF1
		LMS	R5, CWORK5
		LMS	R3, CWORK4
;
		IWT	R2, #LSIN	;rom address set
		FROM	R2		;
		TO	R14		;
		ADD	R10		;
;
		IBT	R9, #000H	;
		LMS	R0, CWORK2	;R6 = shinpuku * 4 /2
;;;		ADD	R0		;
		TO	R6		;
		ADD	R0		;
;
		GETB
;
		CACHE
;
		IWT	R8, #0100H+0100H
;;;		IWT	R10, #080H
;
		MOVE	R12, R1
		MOVE	R13, R15
BG3SS_310
		SEX
		LMULT
;
;;;		IWT	R1, #0B2H*2
		IWT	R1, #0D2H*2
		FROM	R3
		CMP	R1
		BCS	BG3SS_340
		NOP
;
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R7
		OR	R4
;
		FROM	R5		;address calc
		TO	R1		;
		ADD	R3		;
;
		IWT	R14, #0100H
;
		LDW	(R1)
		ADD	R7
		TO	R4
		ADD	R14
		FROM	R4
		CMP	R8
		BCC	BG3SS_330
		NOP
;
;;		IWT	R0, #HDMABF
		LMS	R0, CWORK6
		TO	R7
		ADD	R3
;
		FROM	R3
		DIV2
		NOT
		INC	R0
		SUB	#009H
		STW	(R7)

BG3SS_330
		SBK			;STW	(R1)
BG3SS_340
		WITH	R9		;minmum pnt += syuuki
		ADD	R11		;
		FROM	R9		;
		HIB			;
		ADD	R10
		TO	R10
		LOB
		FROM	R2
		TO	R14
		ADD	R10
		WITH	R9
		LOB
;
		INC	R3
		INC	R3
;
		LOOP
		GETB
;
BG3SS_900
		STOP
		NOP
;
;
;>>>>>>>>>>
;BG3_SEESAW_SET
;entry
;R1 = DATA ROM BANK
;R2 = DATA ADDRESS
;R3 = ANGLE (000H-0FFH)
;<<<<<<<<<<
;
BG3_SEESAW_SET	EQU	$
;
;---angle sin cos paramter get
;
		FROM	R3		;R5 = angle * 2
		TO	R5		;
		ADD	R3		;
;
		IBT	R0, #BANK SIN
		ROMB
		IWT	R0, #SIN
		TO	R14
		ADD	R5
;
		GETB			;sin paramter get
		INC	R14
		GETBH
		MOVE	R7, R0
;
		IWT	R0, #COS
		TO	R14
		ADD	R5
;
		GETB			;cos paramter get
		INC	R14
		GETBH
		MOVE	R8 , R0
;
;--- paramter turn
;
		FROM	R1
		ROMB
;
		MOVE	R14, R2
;
		TO	R1		;R1 = point kazu
		GETB
		INC	R14
;
		IWT	R5, #BG3_POLYGON_DT	;R5 = 000H (top data address)
		SMS	R5, REG4
;
		FROM	R1		;number
		ADD	R1		;*2
		ADD	R0		;*4
		ADD	R5		;
		SUB	#004H		;-data length
		SMS	R0, REG5
;
		CACHE
;
		MOVE	R12, R1		;loop counter set
		MOVE	R13, R15
BG3SES2_010
		TO	R6		;R6 = X paramter get
		GETBS			;
		INC	R14		;
		FROM	R7		;R9 = X * sin (angle)
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		TO	R9		;
		OR	R4		;
;
		FROM	R8		;R10 = X * cos (angle)
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		TO	R10		;
		OR	R4		;
;
		TO	R6		;R6 = Y paramter get
		GETBS			;
		INC	R14		;
		FROM	R7		;R0 = Y * sin(angle)
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		OR	R4		;
;
		FROM	R10		;R9 = X * cos(angle) - Y * sin(angle)
		SUB	R0		;
;
		STW	(R5)
		INC	R5
		INC	R5
;
		FROM	R8		;R0 = Y * cos(angle)
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		OR	R4		;
;
		ADD	R9		;R0 = Y * cos(angle) + X * sin(angle)
;
		STW	(R5)
		INC	R5
;
		LOOP
		INC	R5
;
		IBT	R0, #0001H
		SMS	R0, REG15
;
		mDJMP	BG_POLYGON_SET
;
;
;>>>
;function
; |Cgf[^ɂaXvCs
;name
;entry
; REG0		 : Xp(000H-0FFH)
; REG1		 : Yp(000H-0FFH)
; BSPL_B_POINT	 : B-SPLINE POINT BUFFER
;  DATA FORMAT
;    POINT OF NUMBER 1BYTE
;    X POINT NUMBER  1BYTE
;    Y POINT NUMBER  1BYTE
;return
; BG3_POLYGON_DT : POLYGON_DT POINT BUFFER
;    X POINT NUMBER  2BYTE
;    Y POINT NUMBER  2BYTE
;<<<
BG3_BSPLINE_SET EQU	$
;
;---- initial set
;
;;;		IWT	R12, #0B2H		;loop conter<<initial set>>
;;		IWT	R12, #0D2H		;loop conter<<initial set>>
;;		IBT	R0,  #-9		;set initial
;;		IWT	R10, #HDMABF		;BUFFER <v scroll>
;
;;		CACHE
;
;;		MOVE	R13, R15		;
BSPS_001					;
;;		STW	(R10)			;
;;		INC	R10			;
;;		INC	R10			;
;;		LOOP				;
;;		DEC	R0			;
;
;--- dispaly range check
;
;;		LMS	R8, REG0
;;		IWT	R0, #00080H
;;		IWT	R9, #00200H
;;		ADD	R8
;;		SUB	R9
;;		BCS	BSP_005
;;		NOP
;
;;		LMS	R8, REG1
;;		IWT	R0, #0B2H/2		;B2/2
;;		IWT	R9, #0B2H*2
;;		IWT	R0, #0D2H/2		;D2/2
;;		IWT	R9, #0D2H*2
;;		ADD	R8
;;		SUB	R9
;;		BCC	BSP_009
;;		NOP
BSP_005
;;		STOP
;;		NOP
BSP_009
		IWT	R1,  #BSPL_B_POINT
;;;		IWT	R0, #BG3_POLYGON_DT
		IWT	R11, #BG3_POLYGON_DT
;
;;;		mJSR	BSPLINE_SUB
;
;
BSPLINE_SUB	EQU	$
;
;;;		SMS	R11, REG11	;R11 BACKUP
;
;;;		MOVE	R11, R0
;
		TO	R12		;o[v񐔌
		LDB	(R1)		;
		SMS	R12, REG6	;
		SMS	R11, REG4	;
		INC	R1
		MOVE	R3, R1
		FROM	R12
		ADD	R12
		TO	R14
		ADD	R1
;
		DEC	R14
;
		TO	R4		;
		LDB	(R1)		;P1X get
		INC	R1		;
;
		TO	R5		;
		LDB	(R1)		;P1Y get
		INC	R1		;
;
		TO	R7		;
		LDB	(R1)		;P2X get
		INC	R1		;
;
		TO	R8		;
		LDB	(R1)		;P2Y get
		INC	R1		;
;
		TO	R9		;
		LDB	(R1)		;P3X get
		INC	R1		;
;
		TO	R10		;
		LDB	(R1)		;P3Y get
		INC	R1		;
;
		FROM	R1
		SUB	R14
		BCC	BSPRST_005
		CACHE
;
		MOVE	R1, R3
BSPRST_005
		MOVE	R13, R15
BSPRST_010
;;		IBT	R0, #01EH		;X[0.0] = X1 * 0.50 + X2 * 0.50 + X3 * 0.00
		IBT	R0, #020H		;X[0.0] = X1 * 0.50 + X2 * 0.50 + X3 * 0.00
		TO	R2			;
		MULT	R4			;
		IBT	R6, #020H		;
		FROM	R7			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.0] set
		INC	R11
		INC	R11
;
;;;		IBT	R6, #020H		;Y[0.0] = Y1 * 0.50 + Y2 * 0.50 + Y3 * 0.00
		FROM	R8			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #020H		;
;;;		IBT	R0, #01EH		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.0] set
		INC	R11			;
		INC	R11
;
;;;		IBT	R0, #013H		;X[0.2] = X1 * 0.32 + X2 * 0.66 + X3 * 0.02
		IBT	R0, #015H		;X[0.2] = X1 * 0.32 + X2 * 0.66 + X3 * 0.02
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02AH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
		IBT	R6, #001H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.2] set
		INC	R11
		INC	R11
;
;;;		IWT	R6, #001H		;Y[0.2] = Y1 * 0.32 + Y2 * 0.66 + Y3 * 0.02
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02AH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R0, #013H		;
		IBT	R0, #015H		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.2] set
		INC	R11			;
		INC	R11
;
;;;		IBT	R0, #00BH		;X[0.4] = X1 * 0.18 + X2 * 0.74 + X3 * 0.08
		IBT	R0, #00CH		;X[0.4] = X1 * 0.18 + X2 * 0.74 + X3 * 0.08
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02FH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #004H		;
		IBT	R6, #005H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.4] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #004H		;Y[0.4] = Y1 * 0.18 + Y2 * 0.74 + Y3 * 0.08
;;;		IWT	R6, #005H		;Y[0.4] = Y1 * 0.18 + Y2 * 0.74 + Y3 * 0.08
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #00BH		;
		IBT	R6, #00CH		;
		FROM	R5			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.4] set
		INC	R11			;
		INC	R11
;
;;;;;;		IBT	R6, #00BH		;X[0.6] = X1 * 0.08 + X2 * 0.74 + X3 * 0.18
;;;		IBT	R6, #00CH		;X[0.6] = X1 * 0.08 + X2 * 0.74 + X3 * 0.18
		FROM	R9			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #004H		;
		IBT	R6, #005H		;
		FROM	R4			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.6] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #004H		;Y[0.6] = Y1 * 0.08 + Y2 * 0.74 + Y3 * 0.18
;;;		IWT	R6, #005H		;Y[0.6] = Y1 * 0.08 + Y2 * 0.74 + Y3 * 0.18
		FROM	R5			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R0, #00BH		;
		IBT	R0, #00CH		;
		MULT	R10			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.6] set
		INC	R11			;
		INC	R11
;
		IBT	R0, #001H		;X[0.8] = X1 * 0.02 + X2 * 0.66 + X3 * 0.32
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02AH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #013H		;
		IBT	R6, #015H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.8] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #013H		;Y[0.8] = Y1 * 0.02 + Y2 * 0.66 + Y3 * 0.32
;;;		IWT	R6, #015H		;Y[0.8] = Y1 * 0.02 + Y2 * 0.66 + Y3 * 0.32
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02AH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
		IBT	R0, #001H		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.0] set
;
		MOVE	R4, R7			;X2 -> X1
		MOVE	R5, R8			;Y2 -> Y1
		MOVE	R7, R9			;X3 -> X2
		MOVE	R8, R10			;Y3 -> Y2
;
		TO	R9
		LDB	(R1)			;X3 load
		INC	R1
		TO	R10
		LDB	(R1)
		INC	R1
;
		FROM	R1
		SUB	R14
		BCC	BSPRST_040
		INC	R11
;
		MOVE	R1, R3
BSPRST_040
		LOOP
		INC	R11
;
		LMS	R2, REG4		;store data end address-4
		LMS	R1, REG6
		FROM	R1
		ADD	R1	;*2
		ADD	R0	;*4
		ADD	R1	;*5
		MOVE	R1, R0
		ADD	R0	;*10<*2>
		ADD	R0	;*20<*4>
		ADD	R2	;+base address
		SUB	#004H
		SMS	R0, REG5
;
;;;		LMS	R11, REG11
;
;;;		mRTS
;
		IBT	R0, #001H
		SMS	R0, REG15
;
		mDJMP	BG_POLYGON_SET
;
;
;>>>
;function
; |Cgf[^ɂaXvCsiQoCgŁj
;name
; PT_BSPLINE_RW
;entry
; R2		 : |CgiXvCp̌j
; REG0		 : Xp(000H-0FFH)
; REG1		 : Yp(000H-0FFH)
; BSPL_B_POINT	 : B-SPLINE POINT BUFFER
;    X POINT NUMBER  2BYTE
;    Y POINT NUMBER  2BYTE
;return
; BG3_POLYGON_DT : POLYGON_DT POINT BUFFER
;    X POINT NUMBER  2BYTE
;    Y POINT NUMBER  2BYTE
;<<<
BG_BSPLINE_AW	EQU	$
		IWT	R1, #BSPL_B_POINT
		IWT	R0, #BG3_POLYGON_DT
;
		mJSR	BSPLINE_RW_SUB
;
		IBT	R0, #001H
		SMS	R0, REG15
;
		mDJMP	BG_POLYGON_SET
		NOP
;
PT_BSPLINE_AW	EQU	$
		IWT	R1, #BSPL_B_POINT
		IWT	R0, #BG3_POLYGON_DT
;
PT_BSPLINE_AW2	EQU	$
		mJSR	BSPLINE_RW_SUB
;
		STOP
		NOP
;
BSPLINE_RW_SUB
		SMS	R11, REG11		;R11 BACKUP
;
		MOVE	R11, R0
;
;;		TO	R12		;o[v񐔌
;;		LDB	(R1)		;
		MOVE	R12, R2
		SMS	R12, REG6	;
		SMS	R11, REG4	;
;;		INC	R1
		MOVE	R3, R1
;
		FROM	R12		;|Cg
		ADD	R12
		ADD	R0
		TO	R14
		ADD	R1
		DEC	R14
		DEC	R14		;R14 = XvC|Cgf[^XgAhX
;
		TO	R4		;
		LDW	(R1)		;P1X get
		INC	R1		;
		INC	R1
;
		TO	R5		;
		LDW	(R1)		;P1Y get
		INC	R1		;
		INC	R1
;
		TO	R7		;
		LDW	(R1)		;P2X get
		INC	R1		;
		INC	R1		;
;
		TO	R8		;
		LDW	(R1)		;P2Y get
		INC	R1		;
		INC	R1		;
;
		TO	R9		;
		LDW	(R1)		;P3X get
		INC	R1		;
		INC	R1		;
;
		TO	R10		;
		LDW	(R1)		;P3Y get
		INC	R1		;
		INC	R1		;
;
		FROM	R1
		SUB	R14
		BCC	BSP_AW_005	;Xgf[^AhXI[o[?[no->BSPRST_005]
		CACHE
;
		MOVE	R1, R3		;擪f[^AhXZbg
BSP_AW_005
		MOVE	R13, R15
BSP_AW_010
;;		IBT	R0, #01EH		;X[0.0] = X1 * 0.50 + X2 * 0.50 + X3 * 0.00
		IBT	R0, #020H		;X[0.0] = X1 * 0.50 + X2 * 0.50 + X3 * 0.00
		TO	R2			;
		MULT	R4			;
		IBT	R6, #020H		;
		FROM	R7			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.0] set
		INC	R11
		INC	R11
;
;;;		IBT	R6, #020H		;Y[0.0] = Y1 * 0.50 + Y2 * 0.50 + Y3 * 0.00
		FROM	R8			;
		TO	R2			;
		MULT	R6			;
;;		IBT	R0, #01EH		;
		IBT	R0, #020H		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.0] set
		INC	R11			;
		INC	R11
;
;;;		IBT	R0, #013H		;X[0.2] = X1 * 0.32 + X2 * 0.66 + X3 * 0.02
		IBT	R0, #015H		;X[0.2] = X1 * 0.32 + X2 * 0.66 + X3 * 0.02
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02AH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
		IBT	R6, #001H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.2] set
		INC	R11
		INC	R11
;
;;;		IWT	R6, #001H		;Y[0.2] = Y1 * 0.32 + Y2 * 0.66 + Y3 * 0.02
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02AH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R0, #013H		;
		IBT	R0, #015H		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.2] set
		INC	R11			;
		INC	R11
;
;;;		IBT	R0, #00BH		;X[0.4] = X1 * 0.18 + X2 * 0.74 + X3 * 0.08
		IBT	R0, #00CH		;X[0.4] = X1 * 0.18 + X2 * 0.74 + X3 * 0.08
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02FH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #004H		;
		IBT	R6, #005H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.4] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #004H		;Y[0.4] = Y1 * 0.18 + Y2 * 0.74 + Y3 * 0.08
;;;		IWT	R6, #005H		;Y[0.4] = Y1 * 0.18 + Y2 * 0.74 + Y3 * 0.08
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #00BH		;
		IBT	R6, #00CH		;
		FROM	R5			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.4] set
		INC	R11			;
		INC	R11
;
;;;		IBT	R6, #00BH		;X[0.6] = X1 * 0.08 + X2 * 0.74 + X3 * 0.18
		FROM	R9			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #004H		;
		IBT	R6, #005H		;
		FROM	R4			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.6] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #004H		;Y[0.6] = Y1 * 0.08 + Y2 * 0.74 + Y3 * 0.18
;;;		IWT	R6, #005H		;Y[0.6] = Y1 * 0.08 + Y2 * 0.74 + Y3 * 0.18
		FROM	R5			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02FH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R0, #00BH		;
		IBT	R0, #00CH		;
		MULT	R10			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.6] set
		INC	R11			;
		INC	R11
;
		IBT	R0, #001H		;X[0.8] = X1 * 0.02 + X2 * 0.66 + X3 * 0.32
		TO	R2			;
		MULT	R4			;
		IBT	R0, #02AH		;
		MULT	R7			;
		WITH	R2			;
		ADD	R0			;
;;;		IBT	R6, #013H		;
		IBT	R6, #015H		;
		FROM	R9			;
		MULT	R6			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;X[0.8] set
		INC	R11
		INC	R11
;
;;;;;;		IWT	R6, #013H		;Y[0.8] = Y1 * 0.02 + Y2 * 0.66 + Y3 * 0.32
;;;		IWT	R6, #015H		;Y[0.8] = Y1 * 0.02 + Y2 * 0.66 + Y3 * 0.32
		FROM	R10			;
		TO	R2			;
		MULT	R6			;
		IBT	R0, #02AH		;
		MULT	R8			;
		WITH	R2			;
		ADD	R0			;
		IBT	R0, #001H		;
		MULT	R5			;
		ADD	R2			;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		DIV2				;
		ADC	#0			;
		STW	(R11)			;Y[0.0] set
;
		MOVE	R4, R7			;X2 -> X1
		MOVE	R5, R8			;Y2 -> Y1
		MOVE	R7, R9			;X3 -> X2
		MOVE	R8, R10			;Y3 -> Y2
;
		TO	R9
		LDW	(R1)			;X3 load
		INC	R1
		INC	R1
		TO	R10
		LDW	(R1)
		INC	R1
		INC	R1
;
		FROM	R1
		SUB	R14
		BCC	BSP_AW_040
		INC	R11
;
		MOVE	R1, R3
BSP_AW_040
		LOOP
		INC	R11
;
		LMS	R2, REG4		;store data end address-4
		LMS	R1, REG6
		FROM	R1
		ADD	R1			;*2
		ADD	R0			;*4
		ADD	R1			;*5
		MOVE	R1, R0
		ADD	R0			;*10<*2>
		ADD	R0			;*20<*4>
		ADD	R2			;+base address
		SUB	#004H
		SMS	R0, REG5		;REG5 = ŏIf[^AhX
;
		LMS	R11, REG11
;
		mRTS
;
;>>>>>>>>>>
;function
; _f[^̃[tBOs (\͈̓`FbN)
;entry
;R1 = BEFOR POINT ADDRES (RAM<70H> ADDRESS)
;R2 = AFTER POINT ADDRES (RAM<70H> ADDRESS)
;R3 = POINT 
;R4 = S|Cgԍ (0-xx)
;R5 = MORPH DATA SET ADDRESS (RAM<70H>ADDRESS)
;R6 = {1.00=100H
;R14 = BEFOR POINT DATA ROM ADDRESS
;R0  = BEFOR POINT DATA ROM BANK
;R7  = AFTER POINT DATA ROM ADDRESS
;R8  = AFTER POINT DATA ROM BANK
;REG0 : Xp
;REG1 : Yp
;<<<<<<<<<<
BG_MORPHING_OB	EQU	$
		IBT	R10,#000H
		SMS	R10, REG2		;wWItZbg
		IBT	R11,#000H
		SMS	R11, REG3		;xWItZbg
;
BG_MORPHING_OB2 EQU	$
		mJSR	MORPHING_OB_SUB		;ROM 1BYTE DATA -> RAM 2BYTE DATA CONVERT
		mJSR	MORPHING_AW_SUB		;RAM 2BYTE DATA MORPHING
;
		mDJMP	BG_POLYGON_SET
;
PT_MORPHING_OB	EQU	$
		IBT	R10,#000H
		SMS	R10, REG2		;wWItZbg
		IBT	R11,#000H
		SMS	R11, REG3		;xWItZbg
;
PT_MORPHING_OB2 EQU	$
		mJSR	MORPHING_OB_SUB		;ROM 1BYTE DATA -> RAM 2BYTE DATA CONVERT
		mJSR	MORPHING_AW_SUB		;RAM 2BYTE DATA MORPHING
;
		STOP
		NOP
;
;
MORPHING_OB_SUB EQU	$
		SMS	R11, REG11
;
		LMS	R10, REG2
		LMS	R11, REG3
;
;--- BEFOR DATA TRNS
;
		ROMB
;
		MOVE	R9, R1
		MOVE	R14, R14
;
;;		FROM	R3	;kosuu
;;		TO	R12	;
;;		ADD	R3	;R12 = *2
		MOVE	R12, R3
;
		GETB
;
		CACHE
;
		MOVE	R13, R15
BG3MP_B_010
		INC	R14
		ADD	R10
		STW	(R9)
		INC	R9
		INC	R9
		GETB
		INC	R14
		ADD	R11
		STW	(R9)
		INC	R9
		INC	R9
		LOOP
		GETB
;
;--- AFTER DATA TRNS
;
		FROM	R8
		ROMB
;
		MOVE	R9, R2
		MOVE	R14, R7
;
;;		FROM	R3
;;		TO	R12
;;		ADD	R3
		MOVE	R12, R3
;
		GETB
;
		CACHE
;
		MOVE	R13, R15
BG3MP_B_020
		INC	R14
		ADD	R10
		STW	(R9)
		INC	R9
		INC	R9
		GETB
		INC	R14
		ADD	R11
		STW	(R9)
		INC	R9
		INC	R9
		LOOP
		GETB
;
		LMS	R11, REG11
;
		mRTS
;
BG3_MORPHING_O	EQU	$
		IBT	R10,#000H
		SMS	R10, REG2		;wWItZbg
		IBT	R11,#000H
		SMS	R11, REG3		;xWItZbg
;
BG_MORPHING_OW2 EQU	$
		mJSR	MORPHING_OW_SUB		;ROM 2BYTE DATA -> RAM 2BYTE DATA
		mJSR	MORPHING_AW_SUB		;RAM 2BYTE DATA MORPHING
;
		mDJMP	BG_POLYGON_SET
;
MORPHING_OW_SUB
		SMS	R11, REG11
;
;--- BEFOR DATA TRNS
;
;;;		SMS	R12, R12
		LMS	R10,REG2
		LMS	R11,REG3
;
		ROMB
;
		MOVE	R9, R1
		MOVE	R14, R14
;
;;		FROM	R3	;kosuu
;;		TO	R12	;
;;		ADD	R3	;R12 = *2
		MOVE	R12, R3
;
		GETB
;
		CACHE
;
		MOVE	R13, R15
BG3MP_010
		INC	R14
		GETBH
		INC	R14
		ADD	R10
		STW	(R9)
		INC	R9
		INC	R9
		GETB
		INC	R14
		GETBH
		INC	R14
		ADD	R11
		STW	(R9)
		INC	R9
		INC	R9
		LOOP
		GETB
;
;--- AFTER DATA TRNS
;
		FROM	R8
		ROMB
;
		MOVE	R9, R2
		MOVE	R14, R7
;
;;		FROM	R3
;;		TO	R12
;;		ADD	R3
		MOVE	R12, R3
;
		GETB
;
		CACHE
;
		MOVE	R13, R15
BG3MP_020
		INC	R14
		GETBH
		INC	R14
		ADD	R10
		STW	(R9)
		INC	R9
		INC	R9
		GETB
		INC	R14
		GETBH
		INC	R14
		ADD	R11
		STW	(R9)
		INC	R9
		INC	R9
		LOOP
		GETB
;
		LMS	R11, REG11
;
		mRTS
;
;>>>>>>>>>>
;function : _f[^̃[tBOs(\͈̓`FbN)
;name
; PT_MORPHING_AW
;entry
;R1 = BEFOR POINT ADDRES (RAM<70H> ADDRESS)
;R2 = AFTER POINT ADDRES (RAM<70H> ADDRESS)
;R3 = POINT 
;R4 = S|Cgԍ (0-xx)
;R5 = MORPH DATA SET ADDRESS (RAM<70H>ADDRESS)
;R6 = {1.00=100H
;REG0 : Xp
;REG1 : Yp
;<<<<<<<<<<
BG_MORPHING_AW	EQU	$
		mJSR	MORPHING_AW_SUB
;
		mDJMP	BG_POLYGON_SET
;
PT_MORPHING_AW	EQU	$
;
		mJSR	MORPHING_AW_SUB
;
		STOP
		NOP
;
MORPHING_AW_SUB
		SMS	R11, REG11	;AAhXۑ
;
		SMS	R3, REG2
		SMS	R5, REG4
		FROM	R3
		ADD	R3
		ADD	R0
		ADD	R5
		SUB	#004H
		SMS	R0, REG5
;
		FROM	R4		;S|Cg
		ADD	R4		;*2
		ADD	R0		;*4
		TO	R8
		ADD	R1		;S|Cgiό`OAhXj
		TO	R9
		ADD	R2		;S|Cgiό`AhXj
;
		TO	R7
		LDW	(R8)		;
		INC	R8
		INC	R8
		LDW	(R9)
		INC	R9
		INC	R9
		TO	R10
		SUB	R7		;S|Cgw
;
		TO	R7
		LDW	(R8)
		LDW	(R9)
		TO	R11
		SUB	R7		;S|Cgx
;
		MOVE	R12, R3
		MOVE	R13, R15
MORP_010
		TO	R7
		LDW	(R1)		;ό`Ow|Cgo
		INC	R1
		INC	R1
		LDW	(R2)		;ό`w|Cgo
		INC	R2
		INC	R2
		SUB	R7
		SUB	R10
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R7
		STW	(R5)
		INC	R5
		INC	R5
;
		TO	R7
		LDW	(R1)		;ό`Ox|Cgo
		INC	R1
		INC	R1
		LDW	(R2)		;ό`x|Cgo
		INC	R2
		INC	R2
		SUB	R7
		SUB	R11
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R7
		STW	(R5)
		INC	R5
;
		LOOP
		INC	R5
;
		LMS	R1, REG2
;
		IBT	R0, #000H
		SMS	R0, REG15
;
		LMS	R11, REG11	;AAhXo
;
		mRTS
;
;>>>>>>>>>>
;function
; _f[^̃[tBOsix̃f[^ׂă}CiXƂĈj
;name
; BG3_MORPHING_N
;entry
;R0 = ROM BANK ADDRESS
;R1 = BEFOR POINT ADDRES (ROM ADDRESS)
;R2 = AFTER POINT ADDRES (ROM ADDRESS)
;R3 = POINT 
;R4 = S|Cgԍ (0-xx)
;R5 = MORPH DATA SET ADDRESS (RAM<70H>ADDRESS)
;R6 = {1.00=100H
;REG0 : Xp
;REG1 : Yp
;<<<<<<<<<<
BG3_MORPHING_N	EQU	$
;
;
		mJSR	BG3_MORPHING_S
;
		mDJMP	BG_POLYGON_SET
;
BG3_MORPHING_S	EQU	$
;
		SMS	R11, REG6

		ROMB
;
		SMS	R3, REG2
		SMS	R5, REG4
		FROM	R3
		ADD	R3
		ADD	R0
		ADD	R5
;;;		SUB	#002H
		SUB	#004H
		SMS	R0, REG5
;
;;		FROM	R4		;S|Cg
;;		ADD	R4		;*2
;;		ADD	R0		;*4
;;		TO	R8
		FROM	R4		;S|Cg
		ADD	R4		;*2
		TO	R8
		ADD	R1		;S|Cgiό`OAhXj
		MOVE	R14, R8
		TO	R9
		ADD	R2		;S|Cgiό`AhXj
;
		TO	R7
;;		LDW	(R8)		;
;;		INC	R8
;;		INC	R8
		GETBS
		MOVE	R14, R9
		INC	R8
;
;
;;		LDW	(R9)
;;		INC	R9
;;		INC	R9
		GETBS
		INC	R9
		TO	R10
		SUB	R7		;S|Cgw
;
		MOVE	R14, R8
		TO	R7
;;		LDW	(R8)
		GETB
		DEC	R7
		BMI	MORP_N_000
		INC	R7
;
		IWT	R0,#0FF00H
		TO	R7
		OR	R7
MORP_N_000
		MOVE	R14, R9
;;		LDW	(R9)
		GETB
		DEC	R0
		BMI	MORP_N_005
		INC	R0
;
		IWT	R11,#0FF00H
		OR	R11
MORP_N_005
		TO	R11
		SUB	R7		;S|Cgx
;
		MOVE	R12, R3
		MOVE	R13, R15
MORP_N_010
		MOVE	R14, R1
		TO	R7
;;		LDW	(R1)		;ό`Ow|Cgo
		GETBS
		MOVE	R14, R2
		INC	R1
;;		INC	R1
;;		LDW	(R2)		;ό`w|Cgo
		GETBS
		MOVE	R14, R1
		INC	R2
;;		INC	R2
		SUB	R7
		SUB	R10
		LMULT
		WITH	R4
		SWAP
		FROM	R4
		TO	R3
		ADD	R4
		WITH	R4
		LOB
		LOB
		SWAP
		OR	R4
		ADC	R7
		STW	(R5)
		INC	R5
		INC	R5
;
		TO	R7
;;		LDW	(R1)		;ό`Ox|Cgo
		GETB
		DEC	R7
		BMI	MORP_N_020
		INC	R7
;
		IWT	R0,#0FF00H
		TO	R7
		OR	R7
MORP_N_020
		MOVE	R14, R2
		INC	R1
;;		INC	R1
;;		LDW	(R2)		;ό`x|Cgo
		GETB
		DEC	R0
		BMI	MORP_N_030
		INC	R0
;
		IWT	R4,#0FF00H
		OR	R4
MORP_N_030
		INC	R2
;;		INC	R2
		SUB	R7
		SUB	R11
		LMULT
		WITH	R4
		SWAP
		FROM	R4
		TO	R3
		ADD	R4
		WITH	R4
		LOB
		LOB
		SWAP
		OR	R4
		ADC	R7
		STW	(R5)
		INC	R5
;
		LOOP
		INC	R5
;
		LMS	R1, REG2
;
		IBT	R0, #001H
		SMS	R0, REG15
;
		LMS	R11, REG6
;
		mRTS
;
;
;>>>>>>>>>>
;BG_POLYGON_SET
;entry
;R1   : |Cg
;REG0 : Xp
;REG1 : Yp
;REG4 : point data top address
;REG5 : point data end address -4 (LAST DATA POSITION)
;<<<<<<<<<<
BG_POLYGON_SET EQU	$
;
;---- initial set
;
;;;		IWT	R12, #0B2H		;loop conter<<initial set>>
		IWT	R12, #0D2H		;loop conter<<initial set>>
		IBT	R0,  #-9		;set initial
		IWT	R10, #HDMABF		;BUFFER <v scroll>
;
		CACHE
;
		MOVE	R13, R15		;
BG3POLD3_001					;
		STW	(R10)			;
		INC	R10			;
		INC	R10			;
		LOOP				;
		DEC	R0			;
;
;--- dispaly range check
;
		LMS	R0, REG15
		MOVES	R0,R0
		BEQ	BG3POLD3_009
		NOP					;LMS OK!
;
		LMS	R8, REG0
		IWT	R0, #00080H
		IWT	R9, #00200H
		ADD	R8
		SUB	R9
		BCS	BG3POLD3_008
		NOP
;
		LMS	R8, REG1
		IWT	R0, #080H*2
;;		IWT	R9, #0B2H+080H*4		;B2/2
		IWT	R9, #0D2H+080H*4		;D2/2
		ADD	R8
		SUB	R9
		BCC	BG3POLD3_009
		NOP
;
BG3POLD3_008
		STOP
		NOP
;
;--- initial prm check
;
BG3POLD3_009
		LMS	R0, REG1
		SUB	#009H
		SBK
;
;--- upper & lower point get
;
		CACHE
;
		LMS	R0, REG4	;R5 = top address ypoint
		TO	R5		;
		ADD	#002H		;
;
		IWT	R11, #007FFH	;upper level initial
		IWT	R8, #0F800H	;lowler level initial
;
		LDW	(R5)
;
		MOVE	R12, R1
		MOVE	R13, R15
BG3POLD3_110
		CMP	R11
		BEQ	BG3POLD3_115
		NOP
		BPL	BG3POLD3_120
		NOP
BG3POLD3_115
		MOVE	R11, R0
		MOVE	R1, R5
BG3POLD3_120
		CMP	R8
		BMI	BG3POLD3_130
		NOP
BG3POLD3_125
		MOVE	R8,R0
BG3POLD3_130
		WITH	R5
		ADD	#004H
		LOOP
		LDW	(R5)
;
;;;		SMS	R1, REG2
		SMS	R8, REG3	;low_point Y position
;
;>>> '94/12/11 add for debug
		FROM	R11
		SUB	R8
		BNE	BG3POLD3_200
		NOP
		STOP
		NOP
;<<< '94/12/11 add for debug
;
;--- bg3 make start
;
BG3POLD3_200
		WITH	R1			;R1 = left point address
		ADD	#004H-2
		SMS	R1, REG8
;
		FROM	R1			;R2 = right apoint address
		SUB	#008H
		SMS	R0, REG9
;
		IBT	R14, #003H		;point read flg set
;
		CACHE
;
;=== Main Loop
;
;--- left
;
BG3POLD3_210
		FROM	R14
		AND	#002H
		BEQ	BG3POLD3_310
		NOP
;;;		BNE	BG3POLD3_215
;;;		NOP
;;;		mDJMP_X BG3POLD3_310
;;;		NOP
BG3POLD3_215
		LMS	R5, REG4		;data address increment
		LMS	R1, REG8		;
		WITH	R1			;
		SUB	#004H			;
		FROM	R1			;last data ?
		SUB	R5			;
		BCS	BG3POLD3_220		;
		NOP
		LMS	R1, REG5		;LAST DATA ADDRESS
BG3POLD3_220
		FROM	R1			;R3 = R1 - 4  (next left position get)
		TO	R2			;
		SUB	#004H			;
		FROM	R2
		SUB	R5
		BCS	BG3POLD3_230		;
		NOP				;
		LMS	R2, REG5		;LAST DATA ADDRESS
BG3POLD3_230
		SMS	R1, REG8		;
;
		TO	R7			;R7 = left x prm get
		LDW	(R1)			;
;;		FROM	R1			;
;;		ADD	#002H			;
;;		TO	R1			;R1 = left y prm get
;;		LDW	(R0)			;
		MOVE	R1, R11
;
		TO	R9			;R9 = left_next x prm get
		LDW	(R2)			;
		FROM	R2			;
		ADD	#002H			;
		TO	R2			;R2 = left_next y prm get
		LDW	(R0)			;
		MOVE	R12, R2
;
		FROM	R14
		AND	#004H
		BEQ	BG3POLD3_235
		NOP
;
		MOVE	R9, R7			;x prm = next x prm
		MOVE	R2, R1			;y prm = next y prm
		IBT	R0, #000H
;
		BRA	BG3POLD3_237
		NOP
;
BG3POLD3_235
		FROM	R2			;y point equal check & R0 = Yw calc
		SUB	R1			;
		BEQ	BG3POLD3_215
		NOP
		BMI	BG3POLD3_215		;minus
		NOP				;
;
BG3POLD3_237
;;		FROM	R9			;
;;		TO	R6			;R6 = Xw calc
;;		SUB	R7			;
		FROM	R7			;
		TO	R6			;R6 = -Xw calc
		SUB	R9			;
;
		ADD	R0			;1 / Yw get
		IWT	R5, #DIVBUF		;
		ADD	R5			;
		LDW	(R0)			;
		LSR
;
		MOVE	R5, R4
;
		LMULT				;
		FROM	R4
		TO	R2
		ADD	R4
		TO	R1			;
		ADC	R0			;
;;;		MOVE	R2, R4			;
;
		MOVE	R4, R5
;
BG3POLD3_280
		LMS	R0, REG0		;
		WITH	R7			;
		ADD	R0			;
		IWT	R9, #08000H
;
		WITH	R14			;flg clear
		BIC	#002H			;
;
;--- right
;
BG3POLD3_310
		FROM	R14
		AND	#001H
		BEQ	BG3POLD3_400
		NOP
;;;		BNE	BG3POLD3_315
;;;		NOP
;;;		mDJMP	BG3POLD3_400
;;;		NOP
BG3POLD3_315
		LMS	R0, REG5		;over address check
		INC	R0			;
		INC	R0			;
		LMS	R3, REG9		;R3 += 4 right address set
		WITH	R3			;
		ADD	#004H			;
		FROM	R3
		CMP	R0
		BCC	BG3POLD3_320
		NOP
		LMS	R3, REG4		;LAST DATA ADDRESS
BG3POLD3_320
		FROM	R3			;R3 += 4  next right position set
		TO	R4			;
		ADD	#004H			;
		FROM	R4			;
		CMP	R0			;
		BCC	BG3POLD3_330		;
		NOP				;
		LMS	R4, REG4		;LAST DATA ADDRESS
BG3POLD3_330
		SMS	R3, REG9		;
;
		TO	R8			;R8 = right x prm get
		LDW	(R3)			;
;;		FROM	R3			;
;;		ADD	#002H			;
;;		TO	R3			;R3 = right y prm get
;;		LDW	(R0)			;
		MOVE	R3, R11
;
		TO	R10			;R10 = right_next x prm get
		LDW	(R4)			;
		FROM	R4			;
		ADD	#002H			;
		TO	R4			;R4 = right_next y prm get
		LDW	(R0)			;
		MOVE	R13, R4
;
		FROM	R14
		AND	#004H
		BEQ	BG3POLD3_335
		NOP
;
		MOVE	R10, R8
		MOVE	R4, R3
		IBT	R0, #000H
;
		BRA	BG3POLD3_337
		NOP
;
BG3POLD3_335
		FROM	R4			;y point equal check & R0 = Yw
		SUB	R3			;
		BEQ	BG3POLD3_315		;
		NOP				;
		BMI	BG3POLD3_315
		NOP
;
BG3POLD3_337
		FROM	R10			;R6 = Xw calc
		TO	R6			;
		SUB	R8			;
;
BG3POLD3_370
		ADD	R0			;(1 / Yw) / 2 get
		IWT	R5, #DIVBUF		;
		ADD	R5			;
		LDW	(R0)			;
		LSR
;
		LMULT				;
		WITH	R4
		ADD	R4
		TO	R3			;
		ADC	R0
BG3POLD3_380
		LMS	R0, REG0		;
		WITH	R8			;
		ADD	R0			;
		IWT	R10, #08000H
;
		WITH	R14			;flg clear
		BIC	#001H			;
;
;
;--- buffer set
;
BG3POLD3_400
		FROM	R8			;R6 = Xwide
		TO	R6			;
		SUB	R7			;
		BMI	BG3POLD3_410
		NOP
		IWT	R0, #000FFH
		SUB	R6			;xw>100H>?
		BCS	BG3POLD3_405		;
		INC	R6
		MOVE	R6, R0			;yes
BG3POLD3_405
;;		IWT	R5, #000B2H		;buffer address calc & Y set position check
		IWT	R5, #000D2H		;buffer address calc & Y set position check
		LMS	R0, REG1		;
		ADD	R11			;
		BMI	BG3POLD3_410		;
		SUB	R5			;
		BCS	BG3POLD3_410		;
		ADD	R5			;R5 = R5 * 2
		TO	R5			;
		ADD	R0			;
;
		FROM	R6			;WIDE
		SUB	R0			;- (Yp + Y0)
		TO	R6			;
		SUB	#009H			;
;
		IWT	R0, #HDMABF		;
		ADD	R5			;
		FROM	R6			;
		STW	(R0)			;
;
		FROM	R8			;R6 = <080H - (x1 + x2) /2)
		ADD	R7			;
		DIV2				;
		IWT	R6, #080H		;
		WITH	R6			;
		SUB	R0			;
;
		IWT	R0, #HDMABF1		;H scroll set
		ADD	R5			;
		FROM	R6			;
		STW	(R0)			;
;
BG3POLD3_410
;;		WITH	R9			;left mini calc
;;		ADD	R2			;
;;		WITH	R7			;
;;		ADC	R1			;
		WITH	R9			;left mini calc
		SUB	R2			;
		WITH	R7			;
		SBC	R1			;
;
		WITH	R10			;right mini  calc
		ADD	R4			;
		WITH	R8			;
		ADC	R3			;
;
		LMS	R0, REG3		;end check
		SUB	R11			;
		BEQ	BG3POLD3_900
		ADD	R11
;
		INC	R11		;write line incriment
;
;;;		LMS	R0, REG3	;end check
		SUB	R11		;
		BNE	BG3POLD3_415	;
		NOP
;
		WITH	R14
		OR	#004H
;
BG3POLD3_415
		FROM	R12
		SUB	R11
		BNE	BG3POLD3_420
		NOP
		WITH	R14
;
		OR	#002H
BG3POLD3_420
		FROM	R13
		SUB	R11
		BNE	BG3POLD3_430
		NOP
		WITH	R14
;
		OR	#001H
BG3POLD3_430
		mDJMP_X BG3POLD3_210
		NOP
BG3POLD3_900
		STOP
		NOP
;
;>>>>>>>>>>
;function
; Q_W̃[tBO
;name
; ONEPOINT_MORP
;entry
;R1 : [tBOwWl
;R2 : [tBOxWl
;R3 : [tBOwWl
;R5 : [tBOxWl
;R6 : {
;R7 : [tBOʂwW
;R8 : [tBOʂxW
;return
;<<<<<<<<<<
ONEPOINT_MORP	EQU	$
;
		FROM	R3
		SUB	R1
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		TO	R7
		ADD	R1
;
		FROM	R5
		SUB	R2
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		TO	R8
		ADD	R2
;
		STOP
		NOP
;
;;;;>>>>>>>>>>
;;;;<<<<<<<<<<
;;;GET_LEN		EQU	$
;;;		LMULT
;;;		WITH	R4
;;;		HIB
;;;		LOB
;;;		SWAP
;;;		OR	R4
;;;;
;;;		STOP
;;;		NOP
;;;;
;
;
;****************************************************************
;*								*
;*		Of[V Zbg			*
;*				in				*
;*				R0 : f[^oNAhX	*
;*				R9 : f[^AhX		*
;****************************************************************
NUKCOL_BF_NO	EQU	(724H/8)+0D2H
;
;
SPL_GRDTN	EQU	$
		ROMB
;
		IWT	R10,#WOB7CHR+NUKCOL_BF_NO	; qf
		IWT	R11,#WOB7CHR			; a
;
		CACHE			; LbVX^[g !!
;
SPL_GRDTN_200
;
;--------------------------------------- ̃J[ Zbg
		MOVE	R14,R9
		GETB
		INC	R14
		GETBH			; R0 <- J[f[^
		INC	R14
;
		IBT	R1,#0FFH
		CMP	R1		; f[^ Gh ?
		BNE	SPL_GRDTN_220	;	NO -> SPL_GRDTN_220
		NOP
		IWT	R15,#SPL_GRDTN_900
		NOP
;
SPL_GRDTN_220
		IBT	R12,#00011111B
		TO	R1
		AND	R12
		SMS	R1,CWORK0	; cwrk0 <- ̂qJ[
;
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R2
		AND	R12
		SMS	R2,CWORK1	; cwrk1 <- ̂fJ[
;
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R3
		AND	R12
		SMS	R3,CWORK2	; cwrk2 <- ̂aJ[
;
;--------------------------------------- ̃J[ Zbg
		GETB
		INC	R14
		GETBH			; R0 <- J[f[^
		INC	R14
;
		TO	R1
		AND	R12		; R1 <- ̂qJ[
;
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R2
		AND	R12		; R2 <- ̂fJ[
;
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R3
		AND	R12		; R3 <- ̂aJ[
;
;--------------------------------------- ZbgC̐
		GETB
		INC	R14
		TO	R12
		GETBH
		INC	R14		; R12 <- ZbgC̐
;
		MOVE	R9,R14		; R9 <- f[^AhX
;
;--------------------------------------- qfa 
		IWT	R14,#0FFFFH
		LMS	R0,CWORK0
		SUB	R1
		TO	R6
		XOR	R14
		INC	R6
		FROM	R12
		LSR
		LMULT
		SMS	R4,CWORK4
		SMS	R0,CWORK5
		SMS	R4,CWORKA
		SMS	R0,CWORKB	; q̂
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R1
		OR	R4		; R1 <- q̂
;
		LMS	R0,CWORK1
		SUB	R2
		TO	R6
		XOR	R14
		INC	R6
		FROM	R12
		LSR
		LMULT
		SMS	R4,CWORK6
		SMS	R0,CWORK7
		SMS	R4,CWORKC
		SMS	R0,CWORKD	; f̂
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R2
		OR	R4		; R2 <- f̂
;
		LMS	R0,CWORK2
		SUB	R3
		TO	R6
		XOR	R14
		INC	R6
		FROM	R12
		LSR
		LMULT
		SMS	R4,CWORK8
		SMS	R0,CWORK9
		SMS	R4,CWORKE
		SMS	R0,CWORKF	; â
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R3
		OR	R4		; R3 <- â
;
;--------------------------------------- f[^ Zbg !!
SPL_GRDTN_400
		IBT	R5,#008H
SPL_GRDTN_420
		DEC	R12		; ZbgI ?
		BNE	SPL_GRDTN_440	;	NO -> SPL_GRDTN_440
		NOP
		IWT	R15,#SPL_GRDTN_200
		NOP
SPL_GRDTN_440	EQU	$
		IBT	R4,#00100000B
		IBT	R6,#00011111B
;
		LMS	R0,CWORK0
		ADD	R1
		AND	R6
		OR	R4
		STB	(R10)		; qJ[ Zbg
		INC	R10
		WITH	R4
		ADD	R4
;
		LMS	R0,CWORK1
		ADD	R2
		AND	R6
		OR	R4
		STB	(R10)		; fJ[ Zbg
		INC	R10
		WITH	R4
		ADD	R4
;
		LMS	R0,CWORK2
		ADD	R3
		AND	R6
		OR	R4
		STB	(R11)		; aJ[ Zbg
;
		DEC	R5
		BNE	SPL_GRDTN_420
		INC	R11
;
		LMS	R4,CWORK4
		LMS	R0,CWORKA
		TO	R4
		ADD	R4
		SMS	R4,CWORKA
		LMS	R1,CWORK5
		LMS	R0,CWORKB	; q̂
		ADC	R1
		SMS	R0,CWORKB
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R1
		OR	R4		; R1 <- q̂
;
		LMS	R4,CWORK6
		LMS	R0,CWORKC
		TO	R4
		ADD	R4
		SMS	R4,CWORKC
		LMS	R2,CWORK7
		LMS	R0,CWORKD	; f̂
		ADC	R2
		SMS	R0,CWORKD
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R2
		OR	R4		; R2 <- f̂
;
		LMS	R4,CWORK8
		LMS	R0,CWORKE
		TO	R4
		ADD	R4
		SMS	R4,CWORKE
		LMS	R3,CWORK9
		LMS	R0,CWORKF	; â
		ADC	R3
		SMS	R0,CWORKF
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R3
		OR	R4		; R3 <- â
;
		IWT	R15,#SPL_GRDTN_400
		NOP
;
SPL_GRDTN_900
		STOP
		NOP
;
;>>>>>>>>>>
;function : JbNقLL@p}XNEBhEZbg
;KIRAKIRA_WINSET
;entry
;R1 KAMEC NOW X POSITION
;R2 KAMEC NOW Y POSITION
;R7 KAMEC OLD X POSITION
;R8 KAMEC OLD Y POSITION
;return
;HDMA_WINDOW_BUFFER
;HDMA_VSCROLL_BUFFER
;<<<<<<<<<<
;
Y_PLUS		EQU	009H		;̗]̃hbg
;;BUFFER_LINE	EQU	0B2H		;HDMA BUFFER LINE (SCROLL)
BUFFER_LINE	EQU	0D2H		;HDMA BUFFER LINE (SCROLL)
BUFFER_LINE2	EQU	0D2H		;HDMA BUFFER LINE (WINDOW)
;
KIRAKIRA_WINSET EQU	$
;
;--- paramter check & pararmeter reset
;
		IBT	R4, #000H		;initial flg reset
		IWT	R3, #0100H		;NOW X paramter check
		MOVES	R1,R1			;
		BMI	KIRAWS_005		;
		NOP				;
		FROM	R1			;
		SUB	R3			;
		BMI	KIRAWS_010		;
		NOP				;
		IWT	R1, #000FFH		;
		BRA	KIRAWS_010		;
		NOP				;
KIRAWS_005					;
		IBT	R1, #000H		;
KIRAWS_010					;OLD X paramter check
		MOVES	R7,R7			;
		BMI	KIRAWS_015		;
		NOP				;
		FROM	R7			;
		SUB	R3			;
		BMI	KIRAWS_020		;
		NOP				;
		IWT	R7, #000FFH		;
		IBT	R4, #001H		;<initial flg on>
		BRA	KIRAWS_020		;
		NOP				;
KIRAWS_015					;
		IBT	R7, #000H		;
KIRAWS_020
		IWT	R3, #BUFFER_LINE2	;NOW Y paramter check
		MOVES	R2,R2			;
		BMI	KIRAWS_025		;
		NOP				;
		FROM	R2			;
		SUB	R3			;
		BMI	KIRAWS_030		;
		NOP				;
		IWT	R2, #BUFFER_LINE2-1	;
		BRA	KIRAWS_030		;
		NOP				;
KIRAWS_025					;
		IBT	R1, #000H		;
KIRAWS_030					;OLD Y paramter check
		MOVES	R8,R8			;
		BMI	KIRAWS_035		;
		NOP				;
		FROM	R8			;
		SUB	R3			;
		BMI	KIRAWS_040		;
		NOP				;
		IWT	R8, #BUFFER_LINE2-1	;
		BRA	KIRAWS_040		;
		NOP				;
KIRAWS_035					;
		IBT	R7, #000H
KIRAWS_040
;
;--- initial
;
		MOVES	R4,R4
		BEQ	KIRAWS_200
		NOP
;
		FROM	R2
		TO	R3
		SUB	#Y_PLUS-1
;
		IWT	R9, #000FFH			;window open paramter
		IWT	R4, #WINDBF+BUFFER_LINE2*4-4
		IBT	R5, #004H			;address decrement paramter
		IWT	R6, #0FF00H			;window close paramter
;
		CACHE
;
		IWT	R12, #BUFFER_LINE2	;Zbg
		MOVE	R13, R15
KIRAWS_110
		FROM	R12
		SUB	R3
		BNE	KIRAWS_120
		FROM	R9
;
		MOVE	R9, R6
		FROM	R9
KIRAWS_120
		STW	(R4)
		WITH	R4
		SUB	R5
;
		LOOP
		NOP
;
;
;--- pramter calc
;
KIRAWS_200
		FROM	R7		;R9  = Xv = R7 - R1 +1
		TO	R9		;
		SUB	R1		;
		NOP
		FROM	R8		;R10 = Yw = R8 - R2
		TO	R10		;
		SUB	R2		;
		INC	R10
		IWT	R0, #DIVBUF	;R6 = (1/ Yw) / 2
		ADD	R10		;
		ADD	R10		;
		LDW	(R0)		;
		TO	R6		;
		LSR			;
		FROM	R9		;R11 = Xv / (Yw-1) * 0100H
		SUB	#000H		;
		SWAP			;
		FMULT			;
		TO	R11		;
		ROL			;
		WITH	R1		;R1 = XNewPos * 0100H
		SWAP			;
		FROM	R2		;R5 = HDMA BUFFER SET START ADDRESS = (R2 - Y_PLUS) * 4 + WINDBF
		SUB	#Y_PLUS		;
		ADD	R0		;*2
		ADD	R0		;*4
		IWT	R5, #WINDBF	;
		TO	R5		;
		ADD	R5		;
;
		IWT	R4, #0FF00H
		IBT	R6, #004H
;
		CACHE
;
		IWT	R9, #080H
;
		MOVE	R12, R10
		MOVE	R13, R15
KIRAWS_210
		FROM	R1
		ADD	R9
		SWAP
		OR	R4		;AND #0FFH
		STW	(R5)
		WITH	R5
		ADD	R6
		WITH	R1
		ADD	R11
;
		BCC	KIRAWS_220
		NOP
		IWT	R0, #0FFH
		STW	(R5)
KIRAWS_220
		LOOP
		NOP
;
		STOP
		NOP
;
;>>>>>>>>>
;KIRAKIRA_TSET
;entry
;R1 = START COLOR
;R2 = END COLOR
;R3 = TABLE ADDRESS
;R5 = number of SET
;return
;<<<<<<<<<<
KIRAKIRA_TSET	EQU	$
;
		IWT	R0, #DIVBUF		;R6 = (1 / R5) / 2 = (1 / C) / 2
		ADD	R5			;
		ADD	R5			;
		LDW	(R0)			;
		TO	R6
		LSR
;---blue
		FROM	R1			;minimum blue = R7 : R8 = REG0 : REG1
		HIB				;
		LSR				;
		TO	R7			;
		LSR				;
;						;
		FROM	R2			;
		HIB				;
		LSR				;
		LSR				;
		SUB	R7			;
		INC	R0
		LMULT				;
		FROM	R4			;
		TO	R12			;
		ADD	R4			;
		TO	R13			;
		ADC	R0			;
		SMS	R12, REG0		;
		SMS	R13, REG1		;
;---green
		IBT	R14, #01FH		;minimum green = R7 : R8 = REG2 : REG3
		FROM	R1			;
		LSR				;
		LSR				;
		LSR				;
		LSR				;
		LSR				;
		TO	R9			;
		AND	R14			;
;						;
		FROM	R2			;
		LSR				;
		LSR				;
		LSR				;
		LSR				;
		LSR				;
		AND	R14			;
		SUB	R9			;
		INC	R0
		LMULT				;
		FROM	R4			;
		TO	R12			;
		ADD	R4			;
		TO	R13			;
		ADC	R0			;
		SMS	R12, REG2		;
		SMS	R13, REG3		;
;---red
		FROM	R1			;minimum red = R7 : R8 = REG4 : REG5
		TO	R11			;
		AND	R14			;
;						;
		FROM	R2			;
		AND	R14			;
		SUB	R11			;
		INC	R0			;
		LMULT				;
		FROM	R4			;
		TO	R12			;
		ADD	R4			;
		TO	R13			;
		ADC	R0			;
		SMS	R12, REG4		;
		SMS	R13, REG5		;
;
		IBT	R6,  #000H		;
		IBT	R8,  #000H		;
		IBT	R10, #000H		;
;
		IBT	R4,  #01FH
;
		CACHE
;
		MOVE	R12, R5
		MOVE	R13, R15
KIRAKIRATS_110
		FROM	R7			;blue
		AND	R4			;
		SWAP				;
		ROL				;
		TO	R5			;
		ROL				;
;
		FROM	R9			;green
		AND	R4			;
		ROL				;
		ROL				;
		ROL				;
		ROL				;
		ROL				;
		OR	R5			;
;
		WITH	R11			;red
		AND	R4			;
		OR	R11			;
;
		STW	(R3)
		INC	R3
		INC	R3
;
		LMS	R1, REG0		;blue
		LMS	R2, REG1		;
;						;
		WITH	R6			;
		ADD	R1			;
		WITH	R7			;
		ADC	R2			;
;
		LMS	R1, REG2		;green
		LMS	R2, REG3		;
;						;
		WITH	R8			;
		ADD	R1			;
		WITH	R9			;
		ADC	R2			;
;
		LMS	R1, REG4		;red
		LMS	R2, REG5		;
;						;
		WITH	R10			;
		ADD	R1			;
		WITH	R11			;
		ADC	R2			;
;
		LOOP
		NOP
;
		STOP
		NOP
;
;>>>>>>>>>>
;function : JbNقLL@p}XNEBhEZbg
;KIRAKIRA_WINST2
;entry
;R1 KAMEC NOW X POSITION
;R2 KAMEC NOW Y POSITION
;R7 KAMEC OLD X POSITION
;R8 KAMEC OLD Y POSITION
;return
;HDMA_WINDOW_BUFFER
;HDMA_VSCROLL_BUFFER
;<<<<<<<<<<
;
;;Y_PLUS		EQU	009H		;̗]̃hbg
;;BUFFER_LINE	EQU	0B2H		;HDMA BUFFER LINE (SCROLL)
;;BUFFER_LINE2	EQU	0D2H		;HDMA BUFFER LINE (WINDOW)
;
KIRAKIRA_WINST2 EQU	$
;
;--- paramter check & pararmeter reset
;
		IBT	R4, #000H		;initial flg reset
		IWT	R3, #0100H		;NOW X paramter check
		MOVES	R1,R1			;
		BMI	KIRAWS2_005		;
		NOP				;
		FROM	R1			;
		SUB	R3			;
		BMI	KIRAWS2_010		;
		NOP				;
		IWT	R1, #000FFH		;
		BRA	KIRAWS2_010		;
		NOP				;
KIRAWS2_005					;
		IBT	R1, #000H		;
KIRAWS2_010					;OLD X paramter check
		MOVES	R7,R7			;
		BMI	KIRAWS2_015		;
		NOP				;
		FROM	R7			;
		SUB	R3			;
		BMI	KIRAWS2_020		;
		NOP				;
		IWT	R7, #000FFH		;
		BRA	KIRAWS2_020		;
		NOP				;
KIRAWS2_015					;
		IBT	R4, #001H		;<initial flg on>
		IBT	R7, #000H		;
KIRAWS2_020
		IWT	R3, #BUFFER_LINE2	;NOW Y paramter check
		MOVES	R2,R2			;
		BMI	KIRAWS2_025		;
		NOP				;
		FROM	R2			;
		SUB	R3			;
		BMI	KIRAWS2_030		;
		NOP				;
		IWT	R2, #BUFFER_LINE2-1	;
		BRA	KIRAWS2_030		;
		NOP				;
KIRAWS2_025					;
		IBT	R1, #000H		;
KIRAWS2_030					;OLD Y paramter check
		MOVES	R8,R8			;
		BMI	KIRAWS2_035		;
		NOP				;
		FROM	R8			;
		SUB	R3			;
		BMI	KIRAWS2_040		;
		NOP				;
		IWT	R8, #BUFFER_LINE2-1	;
		BRA	KIRAWS2_040		;
		NOP				;
KIRAWS2_035					;
		IBT	R7, #000H
KIRAWS2_040
;
;--- initial
;
		MOVES	R4,R4
		BEQ	KIRAWS2_200
		NOP
;
		FROM	R2
		TO	R3
		SUB	#Y_PLUS-1
;
		IWT	R9, #000FFH			;window open paramter
		IWT	R4, #WINDBF+BUFFER_LINE2*4-4
		IBT	R5, #004H			;address decrement paramter
		IWT	R6, #0FF00H			;window close paramter
;
		CACHE
;
		IWT	R12, #BUFFER_LINE2	;Zbg
		MOVE	R13, R15
KIRAWS2_110
		FROM	R12
		SUB	R3
		BNE	KIRAWS2_120
		FROM	R9
;
		MOVE	R9, R6
		FROM	R9
KIRAWS2_120
		STW	(R4)
		WITH	R4
		SUB	R5
;
		LOOP
		NOP
;
;
;--- pramter calc
;
KIRAWS2_200
		FROM	R1		;R9  = Xw = R1 - R7 +1
		TO	R9		;
		SUB	R7		;
		NOP
		FROM	R8		;R10 = Yw = R8 - R2
		TO	R10		;
		SUB	R2		;
		INC	R10
		IWT	R0, #DIVBUF	;R6 = (1/ Yw) / 2
		ADD	R10		;
		ADD	R10		;
		LDW	(R0)		;
		TO	R6		;
		LSR			;
		FROM	R9		;R11 = Xw / (Yw-1) * 0100H
		SUB	#000H		;
		SWAP			;
		FMULT			;
		TO	R11		;
		ROL			;
		WITH	R1		;R1 = XNewPos * 0100H
		SWAP			;
		FROM	R2		;R5 = HDMA BUFFER SET START ADDRESS = (R2 - Y_PLUS) * 4 + WINDBF
		SUB	#Y_PLUS		;
		ADD	R0		;*2
		ADD	R0		;*4
		IWT	R5, #WINDBF	;
		TO	R5		;
		ADD	R5		;
;
		IWT	R4, #0FF00H
		IBT	R6, #004H
;
		CACHE
;
		IWT	R9, #080H
;
		MOVE	R12, R10
		MOVE	R13, R15
KIRAWS2_210
		FROM	R1
		ADD	R9
		BCC	KIRAWS2_212
		NOP
		IWT	R0, #0FF00H
KIRAWS2_212
;;;		SWAP
		AND	R4		;AND #0FF00H
		STW	(R5)
		WITH	R5
		ADD	R6
		WITH	R1
		SUB	R11
;
		BCS	KIRAWS2_220
		NOP
		IWT	R0, #0FFH
		STW	(R5)
KIRAWS2_220
		LOOP
		NOP
;
		STOP
		NOP
;
;>>>>>>>>>>
;function : JbNقLL@pJ[eZbg
;KIRAKIRA_VSCRSET
;entry
; EXTRA RAM
;return
;HDMA_WINDOW_BUFFER
;HDMA_VSCROLL_BUFFER
;<<<<<<<<<<
;
;;KIRAKIRA_V_VSP	EQU	00000H		;cXN[Jnʒu					;NON RESET
;;KIRAKIRA_V_VS		EQU	00000H		;cXN[						;    RESET
;;KIRAKIRA_V_VSL	EQU	00000H		;cXN[ʏ					;    RESET
;;KIRAKIRA_V_VSS	EQU	00000H		;cXN[x					;NON RESET
;;KIRAKIRA_V_VSA	EQU	00000H		;cXN[x					;NON RESET
;;KIRAKIRA_V_ST		EQU	00000H		;cXN[L΂C				;    RESET X
;;KIRAKIRA_V_STS	EQU	00000H		;cXN[L΂Cx			;    RESET
;;KIRAKIRA_V_STA	EQU	00000H		;cXN[L΂Cx			;NON RESET
;;KIRAKIRA_V_STSS	EQU	00000H		;cXN[L΂Cxt[x	;    RESET
;;KIRAKIRA_V_STSA	EQU	00000H		;cXN[L΂Cxt[x	;NON RESET
;
;x̒Pʂׂ͂100H = 1.0iXN[j
;
KIRAKIRA_SCRSET EQU	$
;
		IWT	R10, #KIRAKIRA_V_VS	;R1 = VS
		TO	R1			;
		LDW	(R10)			;
		IWT	R0, #KIRAKIRA_V_VSL	;R11 = VSL
		TO	R11			;
		LDW	(R0)			;
		IWT	R0,  #KIRAKIRA_V_VSP	;R2 = VSP * 2 + HDMABF = VSCROLL ADDRESS
		LDW	(R0)			;
		SUB	#Y_PLUS			;
		MOVE	R8, R0			;
		ADD	R0			;
		IWT	R2, #HDMABF		;
		TO	R2			;
		ADD	R2			;
;
		IWT	R5, #0100H		;
		IWT	R9, #KIRAKIRA_V_ST	;
		TO	R3			;
		LDW	(R9)			;
		FROM	R3
		SUB	R5			;
		BMI	KIRAKIRASS_005		;
		NOP
		MOVE	R3, R5
KIRAKIRASS_005
		IWT	R0, #KIRAKIRA_V_STS	;
		TO	R5			;
		LDW	(R0)			;
;
		IWT	R0, #KIRAKIRA_V_STA	;
		TO	R6			;
		LDW	(R0)			;
;
		MOVE	R0, #BUFFER_LINE	;
		TO	R12			;
		SUB	R8			;
;
		IWT	R8, #0100H
;
		CACHE
;
		MOVE	R13, R15		;
KIRAKIRASS_010
		FROM	R1			;
		STW	(R2)			;
		INC	R2			;
		INC	R2			;
		FROM	R3
		LOB
		SWAP
		WITH	R11
		SUB	R0
		FROM	R3
		HIB
		SEX
		WITH	R1
		SBC	R0
		IWT	R4, #000E0H
		WITH	R3			;ST(XX.XX)+=STS(XX.XX)
		ADD	R5			;
		FROM	R3
		SUB	R4
		BCC	KIRAKIRASS_015		;
		ADD	R4
		MOVE	R3, R4
KIRAKIRASS_015
		FROM	R3			;
		SUB	R8			;
		BMI	KIRAKIRASS_020
		ADD	R8
		MOVE	R3, R8
KIRAKIRASS_020
		WITH	R5			;STS(XX.XX)+=STA(XX.XX)
		ADD	R6
KIRAKIRASS_030
		LOOP
		NOP
;
		IWT	R8, #KIRAKIRA_V_VSL
		TO	R6
		LDW	(R8)
		IWT	R7, #KIRAKIRA_V_VSS
		TO	R1
		LDW	(R7)
		FROM	R1
		LOB
		TO	R2
		SWAP
		FROM	R1
		HIB
		TO	R3
		SEX
		FROM	R6
		ADD	R2
		STW	(R8)
		LDW	(R10)
		ADC	R3
		STW	(R10)
;
		IWT	R0, #KIRAKIRA_V_VSA
		LDW	(R0)
		ADD	R1
		STW	(R7)
;
		IWT	R2, #KIRAKIRA_V_STSS
		TO	R1
		LDW	(R2)
		FROM	R1
		TO	R3
		HIB
		WITH	R3
		LSR
		WITH	R3
		LSR
		WITH	R3
		LSR
		WITH	R3
		LSR
		LDW	(R9)			;STS LOAD
		ADD	R3			; ST = ST + STSS
		STW	(R9)			;
;
		IWT	R0, #KIRAKIRA_V_STSA
		LDW	(R0)
		FROM	R1
		ADD	R0
		STW	(R2)
;
;;		STOP
;;		NOP
;
KIRAKIRA2
;
		IWT	R1, #HDMABF2		;initalize
		IBT	R0, #000H		;
;						;
		CACHE				;
;						;
		IWT	R12, #BUFFER_LINE	;
		MOVE	R13, R15		;
KIRAKIRA2_01					;
		STW	(R1)			;
;						;
		INC	R1			;
		INC	R1			;
;						;
		LOOP				;
		NOP				;
KIRAKIRA2_02
		IWT	R0, #BUFFER_LINE	;R12 = LOOP COUNTER = SET LINE NO.
		IWT	R2, #KIRAKIRA_C_SP	;R2  = START LINE NO.
		TO	R2			;
		LDW	(R2)			;
;;;		WITH	R2			;
;;;		SUB	#009H			;
		WITH	R2			;
		HIB				;
		TO	R12			;
		SUB	R2			;
;
		IWT	R0, #HDMABF2		;R1 = HDMA TBL ADDRESS
		ADD	R2			;
		TO	R1			;
		ADD	R2			;
;
		IWT	R0, #KIRAKIRA_C_TW	;R3,R10 LINE VOL. (R10 = MASTER)
		TO	R3			;
		LDW	(R0)			;
		MOVE	R10, R3
;
		IWT	R0, #KIRAKIRA_C_TWBS	;R4 = LINE VOL ADD PER BLOCK
		TO	R4			;
		LDW	(R0)			;
;
		IWT	R0, #KIRAKIRA_C_TWBA	;R5 = (LINE VOL ADD) VOL ADD PER BLOCK
		TO	R5			;
		LDW	(R0)			;
;
		IWT	R0, #KIRAKIRA_C_TC	;R11 = Top Color_table address = TC * 2 + KIRAKIRA_CTBL
		LDW	(R0)			;
		MOVES	R0,R0			;
		BPL	KIRAKIRA2_005		;
		NOP				;
		IBT	R0, #000H		;
KIRAKIRA2_005
		HIB				;
		ADD	R0			;
		IWT	R14, #KIRAKIRA_CTBL	;
		TO	R11			;
		ADD	R14			;
;
		IWT	R6, #KIRAKIRA_CTBL_E	;
		IWT	R7, #00000H		;
;
		TO	R9
		LDW	(R11)
;
		CACHE
;
		MOVE	R13, R15
KIRAKIRA2_110
		FROM	R9
		STW	(R1)
		INC	R1
		INC	R1
;
		WITH	R7
		ADD	R3
		BCC	KIRAKIRA2_150
		NOP
KIRAKIRA2_115
		INC	R11		;R11 = R11 + 2
		INC	R11		;
;
		FROM	R11
		SUB	R6
		BCC	KIRAKIRA2_120
		ADD	R6
;
		MOVE	R11, R6
KIRAKIRA2_120
		TO	R9
		LDW	(R11)
;
		WITH	R10
		ADD	R4
		MOVE	R3, R10
		WITH	R4
		ADD	R5
KIRAKIRA2_150
		LOOP
		NOP
;
		IWT	R2, #KIRAKIRA_C_TWS
		TO	R3
		LDW	(R2)
		IWT	R1, #KIRAKIRA_C_TW
		LDW	(R1)
		SUB	R3
		BCC	KIRAKIRA2_170
		NOP
		STW	(R1)
;
		IWT	R0, #KIRAKIRA_C_TWA
		TO	R4
		LDW	(R0)
		FROM	R3
		ADD	R4
		STW	(R2)
;--
KIRAKIRA2_170
		IWT	R4, #00000H
		IWT	R2, #KIRAKIRA_C_TCS
		TO	R3
		LDW	(R2)
		IWT	R1, #KIRAKIRA_C_TC
		LDW	(R1)
		SUB	R3
		BCS	KIRAKIRA2_210
		NOP
;
		MOVE	R0, R4
KIRAKIRA2_210
		STW	(R1)
;
		IWT	R0, #KIRAKIRA_C_TCA
		TO	R4
		LDW	(R0)
		FROM	R3
		ADD	R4
		STW	(R2)
;
		IWT	R4, #(BUFFER_LINE-1)*0100H
		IWT	R1, #KIRAKIRA_C_SPS
		TO	R2
		LDW	(R1)
		IWT	R5, #KIRAKIRA_C_SP
		LDW	(R5)
		ADD	R2
		SUB	R4
		BCS	KIRAKIRA2_310
		ADD	R4
;
		STW	(R5)
;
KIRAKIRA2_310
		IWT	R0, #KIRAKIRA_C_SPA
		TO	R2
		LDW	(R0)
		LDW	(R1)
		ADD	R2
		STW	(R1)
;
		STOP
		NOP
;
;>>>>>>>>>>
;function
; vhmcnv
;name
; WINDOW_HALL
;entry
; R0  : `f[^oN
; R1  : \Sʕ\ʒuwW
; R2  : \Sʕ\ʒuxW
; R6  : { XX.XX = 100H = 1.0
; R7  : \SʒuwW
; R8  : \SʒuxW
; R14 : `f[^AhX
;return
;work
; R11 : k XX.XX
;<<<<<<<<<<
;
WINDOW_HALL	EQU	$
;
;--- initial clear
;
		ROMB
;
		MOVE	R14, R14
;
		IWT	R9,  #000FFH	;EChEm}XNݒl
		IWT	R10, #0FF00H	;EChEt}XNݒl
		IWT	R0, #DIVBUF
		ADD	R6
		ADD	R6
		TO	R11
		LDW	(R0)		;R11 = k XX.XX
		FROM	R7
		LOB
		SWAP
		FMULT			;R0 = \SwW * {
		NOT
		INC	R0
		ADD	R1
		SMS	R0, CWORK0	;
		BPL	WINH_040	;\ʒuʍOH[no->WINH_040]
		NOP
		MOVE	R3, R9		;EChEPm}XNݒ
		MOVE	R4, R10		;EChEQt}XNݒ
		BRA	WINH_060
		NOP
WINH_040
		IWT	R5, #0100H
		SUB	R5
		BCC	WINH_050	;\ʒuʉEOH[no->WINH_050]
		ADD	R5
		MOVE	R3, R10		;EChEPt}XNݒ
		MOVE	R4, R9		;EChEQm}XNݒ
		BRA	WINH_060
		NOP
WINH_050
		TO	R3
		SWAP
		TO	R4
		OR	R10
WINH_060
		IWT	R5,  #WINDBF
		IWT	R12, #0D2H
		CACHE
		MOVE	R13, R15
WINH_070
		FROM	R3
		STW	(R5)
		INC	R5
		INC	R5
		FROM	R4
		STW	(R5)
		INC	R5
		LOOP
		INC	R5
;
;--- hall display out
;
		FROM	R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT			;
		INC	R0
		ADD	R2		;\ʒuZ
		ADD	R0		;*2
		ADD	R0		;*4
		IWT	R4, #WINDBF
		TO	R7		;R7 = EChEobt@ݒAhX
		ADD	R4
		IWT	R5, #000H
;
		IWT	R1,  #00100H	;E[ʊO`FbNp
		IBT	R12, #000H	;~j}JEg
;
		TO	R2
		GETB
		INC	R14
;
		CACHE
;
WINH_210
		TO	R5
		GETBS
;
		WITH	R12
		ADD	R11		;~j}JEg֏kZ
		FROM	R12
		HIB
		WITH	R2
		SUB	R0
		BMI	WINH_310
		NOP
		TO	R14
		ADD	R14		;~j}JEg̐f[^AhX։Z
		WITH	R12
		LOB			;~j}JEĝ݂ɂB
;
		FROM	R5
		LOB
		SWAP
		TO	R5
		FMULT				;R0 = { * З̒
;
		MOVE	R4, R9			;EChEm}XNlZbg
		LMS	R0, CWORK0
		SUB	R5
		BMI	WINH_230		;|CgʊOH[yes->WINH_230]
		NOP
;
		MOVE	R4, R10			;EChEt}XNlZbg
		SUB	R1
		BCS	WINH_230		;|CgEʊOH[yes->WINH_230]
		ADD	R1
;
		TO	R4
		SWAP
WINH_230
		FROM	R4
		STW	(R7)			;vhmcnvPZbg
		INC	R7
;;;		INC	R7
;
		MOVE	R4, R10			;EChEt}XNlZbg
		LMS	R0, CWORK0
		ADD	R5
		BMI	WINH_260		;|CgʊOH[yes->WINH_260]
		INC	R7			;EChEobt@AhXZ
;
		MOVE	R4, R9			;EChEm}XNlZbg
		SUB	R1
		BCS	WINH_260		;|CgEʊOH[yes->WINH_260]
		ADD	R1
;
		TO	R4
		OR	R10
WINH_260
		FROM	R4
		STW	(R7)			;vhmcnvQZbg
		INC	R7
;
		BRA	WINH_210
		INC	R7
;
WINH_310
		STOP
		NOP
;
;
;************************************************************************
;*		moji polygon						*
;*			in  : (R1) <-- moji no.				*
;*			      (R2) <-- X angle				*
;*			      (R3) <-- Y   "                            *
;*			      (R4) <-- center X pos			*
;*			      (R5) <--	  "   Y  "			*
;*			      (R6) <-- zoom flag			*
;************************************************************************
MOJIPOLY4	EQU	$
;
;-------------- bitmap buffer clear !! ----------------------------------
		CACHE
;
		FROM	R5
		ADD	R5
		MULT	#8
		ADD	R4
		ADD	R0		;x4
		ADD	R0		;
		IWT	R7,#WOB7CHR
		TO	R7
		ADD	R7
		mCHAR_CLR_4X	R7,4,R8,R9,R10,R11
;
		IBT	R0,#010H
		WITH	R4
		ADD	R0
		WITH	R5
		ADD	R0
		BRA	MOJIPOLY2+1
		SMS	R4,CWORK1E	;[ dummy ]
;
MOJIPOLY	EQU	$
;
;-------------- bitmap buffer clear !! ----------------------------------
		CACHE
;
		FROM	R5
		ADD	R5
		MULT	#8
		ADD	R4
		ADD	R0		;x4
		ADD	R0		;
		IWT	R7,#WOB7CHR
		TO	R7
		ADD	R7
		mCHAR_CLR_2X	R7,2,R8,R9
;
		WITH	R4
		ADD	#8
		WITH	R5
		ADD	#8
;
;-------------- moji polygon set ----------------------------------------
MOJIPOLY2	EQU	$
		SMS	R4,CWORK1E	;(CWK1E) <-- center X pos
		SMS	R5,CWORK1F	;(CWK1F) <--	"   Y  "
		SMS	R6,CWORK1D	;(CWK1D) <-- zoom flag
;
;-------------- plot mode set -----------------------------------
		SUB	R0		;[ IBT R0,#0 ]
		CMODE
;
;-------------- cos & sin data read -----------------------------
		IBT	R0,#BANK LCOS	;cos & sin data bank set
		ROMB
;
		IBT	R6,#10H		;(R6) <-- Z pos
		IWT	R13,#LCOS
		FROM	R13
		TO	R14
		ADD	R2
		GETB
		SMS	R0,CWORK0	;(CWK0) <-- X cos data
		MOVE	R9,R0		;(R9)	<--	 "
;
		FROM	R13
		TO	R14
		ADD	R3
		GETB
		SMS	R0,CWORK1	;(CWK1) <-- Y cos data
		MOVE	R7,R0		;(R7)	<--	 "
		MULT	R6
		SMS	R0,CWORK2	;(CWK2) <-- SZ * (Y cos)
;
		IWT	R13,#LSIN
		FROM	R13
		TO	R14
		ADD	R2
		GETB
		SMS	R0,CWORK3	;(CWK3) <-- X sin data
		MOVE	R10,R0		;(R10)	<--	 "
;
		FROM	R13
		TO	R14
		ADD	R3
		GETB
		SMS	R0,CWORK4	;(CWK4) <-- Y sin data
		MOVE	R8,R0		;(R8)	<--	 "
		MULT	R6
		SMS	R0,CWORK5	;(CWK5) <-- SZ * (Y sin)
;
;-------------- face color calculate ----------------------------
		IWT	R14,#FACVCT	;(R14) <-- face vector data address
		IBT	R4,#CL0		;(R4)  <-- color data set pointer
		IBT	R12,#5
;
		CACHE
;
		MOVE	R13,R15
MJPOL002
		GETBS			;(R0) <-- SX
		INC	R14
		TO	R11		;(R11) <-- SX * (Y sin)
		MULT	R8
		GETBS			;(R0) <-- SZ
		INC	R14
		MULT	R7		;(R0) <-- SZ * (Y cos)
		SUB	R11		;(R0) <-- SZ * (Y cos) - SX * (Y sin)
		ADD	R0
		ADD	R0
		HIB
		SEX
		TO	R11		;(R11) <-- SZ * (X cos)
		MULT	R9
		GETBS			;(R0) <-- SY
		MULT	R10		;(R0) <-- SY * (X sin)
		ADD	R11		;(R0) <-- SZ * (X cos) + SY * (X sin)
		BPL	MJPOL004
		INC	R14
;
		NOT
		INC	R0
MJPOL004
		HIB
		LSR
		TO	R11
		LSR
		GETB
		INC	R14
		ADD	R11
		STB	(R4)
		LOOP
		INC	R4
;
;-------------- moji polygon data address read ------------------
		IWT	R0,#MOJPOLIN
		ADD	R1
		TO	R14
		ADD	R1
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0		;(R14) <-- moji polygon data pointer
;
;-------------- point rotation & 2D convert ---------------------
		IWT	R1,#MJP2DPS	;(R1) <-- rotation & 2D convert data set pointer
;
		TO	R12		;(R12) <-- number of point
		GETB
		INC	R14
;
		MOVE	R13,R15
MJPOL010
		GETB			;(R0) <-- X pos
		INC	R14
		MOVE	R4,R0		;(R4) <--   "
		LMS	R0,CWORK1
		MULT	R4
		MOVE	R2,R0		;(R2) <-- SX * (Y cos)
		LMS	R5,CWORK5
		SUB	R5		;(R0) <-- SX * (Y cos) + SZ * (Y sin)
		ADD	R0		;[ ASL ]
		TO	R7		;(R7) <-- rotation X pos set ( front )
		ADD	R0		;[ ASL ]
		FROM	R2
		ADD	R5		;(R0) <-- SX * (Y cos) + (-SZ) * (Y sin)
		ADD	R0		;[ ASL ]
		TO	R8		;(R8) <-- rotation X pos set ( back )
		ADD	R0		;[ ASL ]
;
		LMS	R0,CWORK4
		MULT	R4
		NOT
		INC	R0
		MOVE	R3,R0		;(R3) <-- -( SX * (Y sin) )
		LMS	R5,CWORK2
		SUB	R5		;(R0) <-- -( SZ * (Y cos) ) - SX * (Y sin)
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		HIB
		TO	R2		;(R2) <-- Y rotation Z pos ( front )
		SEX
		FROM	R5
		ADD	R3		;(R0) <-- SZ * (Y cos) - SX * (Y sin)
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		HIB
		TO	R3		;(R3) <-- Y rotation Z pos ( back )
		SEX
;
		GETB			;(R0) <-- Y pos
		INC	R14
		MOVE	R6,R0		;(R6) <--   "
		LMS	R5,CWORK3
		MULT	R5		;(R0) <-- SY * (X sin)
		MOVE	R4,R0		;(R4) <--      "
		LMS	R11,CWORK0
		FROM	R2
		MULT	R11		;(R0) <-- SZ * (X cos) ( front )
		ADD	R4		;(R0)  <-- SZ * (X cos) + SY * (X sin)
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		HIB
		TO	R9		;(R9) <-- rotation Z pos set ( front )
		SEX
		FROM	R3
		MULT	R11		;(R0) <-- SZ * (X cos) ( back )
		ADD	R4		;(R0) <-- SZ * (X cos) + SY * (X sin)
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		HIB
		TO	R10		;(R10) <-- rotation Z pos set ( back )
		SEX
;
		FROM	R6
		MULT	R11		;(R0) <-- SY * (X cos)
		MOVE	R4,R0		;(R4) <--	"
		FROM	R2
		MULT	R5		;(R0) <-- SZ * (X sin) ( front )
		FROM	R4
		SUB	R0		;(R0)  <-- SY * (X cos) - SZ * (X sin)
		ADD	R0		;[ ASL ]
		TO	R11		;(R11) <-- rotation Y pos set ( front )
		ADD	R0		;[ ASL ]
		FROM	R3
		MULT	R5		;(R0) <-- SZ * (X sin) ( back )
		FROM	R4
		SUB	R0		;(R0) <-- SY * (X cos) - SZ * (X sin )
		ADD	R0		;[ ASL ]
		TO	R5		;(R5) <-- rotation Y pos set ( back )
		ADD	R0		;[ ASL ]
;
		LMS	R2,CWORK1D	;(R2) <-- zoom size
		FROM	R2
		MULT	R9
		HIB
		TO	R6
		SEX
		IWT	R9,#DIVBUF+(100H*2)
		FROM	R9
		ADD	R6		;Z pos x2
		ADD	R6
		TO	R6
		LDW	(R0)
		FROM	R11
		FMULT
		MULT	R2
		SWAP
		LM	R11,CWORK1F	;(R11) <-- center Y pos
		ADD	R11
		STB	(R1)		;2D Y pos set ( front )
		INC	R1
		FROM	R7
		FMULT
		MULT	R2
		SWAP
		LM	R7,CWORK1E	;(R7) <-- center X pos
		ADD	R7
		STB	(R1)		;2D X pos set ( front )
		INC	R1
;
		FROM	R2
		MULT	R10
		HIB
		TO	R6
		SEX
		FROM	R9
		ADD	R6		;Z pos x2
		ADD	R6
		TO	R6
		LDW	(R0)
		FROM	R5
		FMULT
		MULT	R2
		SWAP
		ADD	R11
		STB	(R1)		;2D Y pos set ( back )
		INC	R1
		FROM	R8
		FMULT
		MULT	R2
		SWAP
		ADD	R7
		STB	(R1)		;2D X pos set ( back )
;
		LOOP
		INC	R1
;
;-------------- face data set -----------------------------------
		IWT	R1,#MJPBTBL	;(R1) <-- block data pointer
		IWT	R2,#MJPFACE	;(R2) <-- face data pointer
		IBT	R3,#0		;(R3) <--      "    no.
		IBT	R4,#4		;(R4) <-- constant point no.
		IBT	R5,#2		;(R5) <-- add data
		IBT	R9,#CL0		;(R9) <-- front face color data
;
		TO	R11		;(R11) <-- number of block
		GETB
		INC	R14
		SMS	R11,CWORK1F	;(CWK1F) <--	   "
MJPOL020
		FROM	R2
		STW	(R1)		;block data face data pointer set
		INC	R1
		INC	R1
		FROM	R3
		STB	(R1)		;     "     start face no. set
		INC	R1
;
		GETB
		INC	R14
;
		TO	R6		;(R6) <-- back face data pointer
		ADD	R2
		INC	R6
		INC	R6
		STB	(R2)
		INC	R2
		STB	(R6)
		INC	R6
;
		MOVE	R8,R0		;(R8)  <-- number of point
		MOVE	R12,R0		;(R12) <--	  "
;
		ADD	R5
		STB	(R1)		;block data number of face set
		INC	R1
;
		TO	R3		;(R3) <-- next set face data no.
		ADD	R3
;
		MOVE	R0,R9		;(R0) <-- front face color data
		STB	(R2)
		INC	R2
		MOVE	R7,R2		;(R7) <-- 1st face point data pointer
		STB	(R6)
		WITH	R6
		ADD	R8
;
		MOVE	R13,R15
MJPOL030
		GETB
		INC	R14
		STB	(R2)
		INC	R0
		STB	(R6)
		INC	R2
		LOOP
		DEC	R6
;
		WITH	R2		;(R2) <-- 3st face data pointer
		ADD	R8
		INC	R2
		INC	R2
;
		LDB	(R7)		;(R0) <-- 1st point no.
		MOVE	R6,R0		;(R6) <--	"
		MOVE	R12,R8
		DEC	R12
		MOVE	R13,R15
MJPOL040
		FROM	R4
		STB	(R2)
		INC	R2
		TO	R8
		GETB			;(R0) <-- face color data
		INC	R14
		FROM	R8
		STB	(R2)
		INC	R2
		INC	R7
		STB	(R2)
		INC	R2
		INC	R0
		STB	(R2)
		INC	R2
		LDB	(R7)
		INC	R0
		STB	(R2)
		INC	R2
		DEC	R0
		STB	(R2)
		LOOP
		INC	R2
;
		FROM	R4
		STB	(R2)
		INC	R2
		TO	R8
		GETB			;(R0) <-- face color data
		INC	R14
		FROM	R8
		STB	(R2)
		INC	R2
		STB	(R2)
		INC	R2
		INC	R0
		STB	(R2)
		INC	R2
		MOVE	R0,R6
		INC	R0
		STB	(R2)
		INC	R2
		FROM	R6
		STB	(R2)
;
		DEC	R11
		BNE	MJPOL020
		INC	R2
;
;-------------- face status data set ----------------------------
		MOVE	R12,R3		;(R12) <-- number of face
;
		IWT	R1,#MJPFACE	;(R1)  <-- face data pointer
		IWT	R2,#MJPFACF	;(R2)  <-- face status data pointer
		IWT	R3,#MJP2DPS	;(R3)  <-- 2D pos data pointer
;
		MOVE	R13,R15
MJPOL050
		LDB	(R1)
		INC	R1
		INC	R1
		TO	R4		;(R4) <-- next pointer
		ADD	R1
;
		LDB	(R1)
		INC	R1
		ADD	R0		;x2
		TO	R5		;(R5) <-- 1st pos pointer
		ADD	R3
		LDB	(R1)
		INC	R1
		ADD	R0		;x2
		TO	R6		;(R6) <-- 2st pos pointer
		ADD	R3
		LDB	(R1)
		ADD	R0
		TO	R7		;(R7) <-- 3st pos pointer
		ADD	R3
;
		TO	R8
		LDB	(R5)
		INC	R5
		LDB	(R6)
		INC	R6
		MOVE	R9,R0
		TO	R8		;(R8) <-- SY1
		SUB	R8
;
		LDB	(R7)
		INC	R7
		TO	R9		;(R9) <-- SY2
		SUB	R9
;
		LDB	(R6)
		MOVE	R11,R0
		TO	R10
		LDB	(R5)
		SUB	R10		;(R0) <-- SX1
		TO	R9		;(R9) <-- SX1 * SY2
		MULT	R9
;
		LDB	(R7)
		SUB	R11		;(R0) <-- SX2
		MULT	R8		;(R0) <-- SY1 * SX2
		SUB	R9
		SWAP
MJPOL052
		STB	(R2)
;
		MOVE	R1,R4
;
		LOOP
		INC	R2
;
;-------------- display priority check --------------------------
		IWT	R1,#MJPFACF	;(R1) <-- face status data pointer
		GETB
		INC	R14
		ADD	R1
		LDB	(R0)
		SEX
		ADD	R0		;(C) <-- check face.1 display flag
		TO	R2
		ROL
		GETB
		INC	R14
		ADD	R1
		LDB	(R0)
		SEX
		ADD	R0		;(C) <-- check face.2 display flag
		WITH	R2
		ROL
		GETB
		INC	R14
		ADD	R1
		LDB	(R0)
		SEX
		ADD	R0		;(C) <-- check face.3 display flag
		FROM	R2
		ROL
		AND	#07H
		TO	R14
		ADD	R14
;
		CACHE
;
MJPOL060
		GETB
		WITH	R14
		ADD	#8
;
		ADD	R0		;x4
		ADD	R0		;
		IWT	R3,#MJPBTBL
		TO	R3		;(R3) <-- block data pointer
		ADD	R3
		TO	R4		;(R4) <-- face data pointer
		LDW	(R3)
		INC	R3
		INC	R3
		LDB	(R3)
		INC	R3
		IWT	R5,#MJPFACF
		TO	R5		;(R5) <-- face status data pointer
		ADD	R5
		LDB	(R3)
		SMS	R0,CWORK1E	;(CWK1E) <-- number of face
MJPOL070
		TO	R12		;(R12) <-- number of point
		LDB	(R4)
		INC	R4
		TO	R6		;(R6) <-- color data pointer
		LDB	(R4)
;
		LDB	(R5)
		SEX
		BPL	MJPOL0702	;face dispaly ? ( no:MJPOL0702 )
		INC	R5
;
		DEC	R6
		BPL	MJPOL071	;face dispaly ? ( yes:MJPOL071 )
		INC	R6
;
MJPOL0702
		WITH	R4
		ADD	R12
		IWT	R15,#MJPOL202	;[ JMP MJPOL202 ]
		INC	R4
;
;-------------- polygon display ---------------------------------
MJPOL071
;
;-------------- plot color set --------------------------
		INC	R4
		LDB	(R6)		;(R0) <-- color data
		COLOR
;
;-------------- pos set & min,max Y pos check -----------
		IWT	R6,#MJP2DPS	;(R6) <-- 2D pos data pointer
		IBT	R7,#CWORK0	;(R7) <-- face pos data set pointer
		MOVE	R0,R12
		DEC	R0
		TO	R10		;(R10) <-- max pos pointer
		ADD	R0
;
		IBT	R2,#0FFH	;(R2) <-- initial min Y pos
		IBT	R9,#0		;(R9) <--    "    max   "
;
		MOVE	R13,R15
MJPOL080
		LDB	(R4)
		ADD	R0		;x2
		ADD	R6
		LDW	(R0)
		STW	(R7)
		LOB
		SUB	R2
		BCS	MJPOL090	;new min Y pos ? ( no:MJPOL090 )
		ADD	R2
;
		MOVE	R2,R0		;(R2)  <-- new min Y pos
		MOVE	R11,R7		;(R11) <--	 "       pointer
MJPOL090
		SUB	R9
		BCC	MJPOL100	;new max Y pos ? ( no:MJPOL100 )
		ADD	R9
;
		MOVE	R9,R0		;(R9)  <-- new max Y pos
MJPOL100
		INC	R7
		INC	R7
		LOOP
		INC	R4
;
;-------------- polygon plot ----------------------------
		SMS	R4,REG4		;(R4) save
		SMS	R5,REG5		;(R5)  "
;
		SMS	R11,CWORK1C	;(CWK1C) <-- left  pos data pointer
		SMS	R11,CWORK1D	;(CWK1D) <-- right	   "
;
		MOVE	R7,R2		;(R7) <-- to left  Y pos
		MOVE	R8,R2		;(R8) <-- to right   "
;
		FROM	R9
		TO	R11		;(R11) <-- Y loop no
		SUB	R2
MJPOL110
;
;-------------- left check ----------------------
		FROM	R2
		SUB	R7
		BCC	MJPOL150	;left next change ? ( no:MJPOL150 )
		NOP
;
		LMS	R1,CWORK1C
		INC	R1
MJPOL112
		LDB	(R1)
		TO	R3
		SWAP
		DEC	R1
;
		DEC	R1
		BPL	MJPOL130	;pos data pointer over ? ( no:MJPOL130 )
		DEC	R1
;
		MOVE	R1,R10
MJPOL130
		SMS	R1,CWORK1C
		LDB	(R1)		;(R0) <-- next Y pos
		TO	R6		;(R6) <-- SY
		SUB	R7
		BEQ	MJPOL112	;next pos error ? ( yes:MJPOL112 )
		INC	R1
;
		MOVE	R7,R0		;(R7) <-- new to left Y pos
		IWT	R0,#DIVBUF	;(R0) <-- div data pointer
		ADD	R6
		ADD	R6
		LDW	(R0)
		TO	R6		;(R6) <-- div data
		LSR
		LDB	(R1)		;(R0)  <-- next X pos
		SWAP
		SUB	R3
		FMULT
		TO	R3
		ADD	R3
		TO	R5		;(R5) <-- new X step
		ADD	R0
;
;-------------- right check ---------------------
MJPOL150
		FROM	R2
		SUB	R8
		BCC	MJPOL190	;left next change ? ( no:MJPOL190 )
		NOP
;
		LMS	R1,CWORK1D
		INC	R1
MJPOL152
		LDB	(R1)
		TO	R4		;(R4) <-- new X pos set
		SWAP
;
		FROM	R1
		SUB	R10
		BCC	MJPOL170	;pos data pointer over ? ( no:MJPOL170 )
		INC	R1
;
		IBT	R1,#0
MJPOL170
		SMS	R1,CWORK1D
		LDB	(R1)		;(R0) <-- next Y pos
		TO	R6		;(R6) <-- SY
		SUB	R8
		BEQ	MJPOL152	;next pos error ? ( yes:MJPOL152 )
		INC	R1
;
		MOVE	R8,R0		;(R8) <-- new to left Y pos
		IWT	R0,#DIVBUF	;(R0) <-- div data pointer
		ADD	R6
		ADD	R6
		LDW	(R0)
		TO	R6		;(R6) <-- div data
		LSR
		LDB	(R1)		;(R0)  <-- next X pos
		SWAP
		SUB	R4
		FMULT
		TO	R4
		ADD	R4
		TO	R9		;(R9) <-- new X step
		ROL
;
;-------------- plot ----------------------------
MJPOL190
		FROM	R3
		TO	R1		;(R1) <-- left X pos ( plot start X pos )
		HIB
		FROM	R4
		HIB
		TO	R12		;(R12) <-- number of plot
		SUB	R1
		BMI	MJPOL201
		NOP
		BEQ	MJPOL201
		NOP
;
		MOVE	R13,R15
MJPOL200
		LOOP
		PLOT
;
MJPOL201
		WITH	R3		;left  X pos up !!
		ADD	R5
		WITH	R4		;right	    "
		ADD	R9
;
		DEC	R11
		BPL	MJPOL110
		INC	R2		;plot Y pos up !!
;
		LMS	R4,REG4		;(R4) load
		LMS	R5,REG5		;(R5)  "
;
MJPOL202
		LMS	R0,CWORK1E
		DEC	R0
		BEQ	MJPOL210
		NOP
;
		IWT	R15,#MJPOL070	;[ JMP MJPOL070 ]
		SBK
;
MJPOL210
		LMS	R0,CWORK1F
		DEC	R0
		BEQ	MJPOL220
		NOP
;
		IWT	R15,#MJPOL060	;[ JMP MJPOL060 ]
		SBK
;
MJPOL220
		INC	R2
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		face vector data					*
;************************************************************************
CL0		EQU	CWORK10
CL1		EQU	CL0+1
CL2		EQU	CL1+1
CL3		EQU	CL2+1
CL4		EQU	CL3+1
;
FACVCT		EQU	$
;			SX SZ SY color
		HEX	2D,20,E0,0C	;[CL0] front
		HEX	00,2D,2D,08	;[CL1] up & down
		HEX	2D,E0,20,08	;[CL2] side
		HEX	20,CA,F7,08	;[CL3] 45 angle
		HEX	E0,F7,CA,08	;[CL4]	  "    (/)
;
;;;;		HEX	00,3F,00,0C	;[CL0] front
;;;;		HEX	00,00,3F,08	;[CL1] up & down
;;;;		HEX	3F,00,00,08	;[CL2] side
;;;;		HEX	2D,00,D3,08	;[CL3] 45 angle
;;;;		HEX	D3,00,D3,08	;[CL4]	  "    (/)
;
;************************************************************************
;*		moji polygon data					*
;************************************************************************
MOJPOLIN	EQU	$
		WORD	MOJPOL_P	;[0]
		WORD	MOJPOL_A	;[1]
		WORD	MOJPOL_U	;[2]
		WORD	MOJPOL_S	;[3]
		WORD	MOJPOL_E	;[4]
		WORD	MOJPOL_D	;[5]  "D"
		WORD	MOJPOL_bik	;[6]  "!"
		WORD	KAZ_0		;[7]  "0"
		WORD	KAZ_1		;[8]  "1"
		WORD	KAZ_2		;[9]  "2"
		WORD	KAZ_3		;[A]  "3"
		WORD	KAZ_4		;[B]  "4"
		WORD	KAZ_5		;[C]  "5"
		WORD	KAZ_6		;[D]  "6"
		WORD	KAZ_7		;[E]  "7"
		WORD	KAZ_8		;[F]  "8"
		WORD	KAZ_9		;[10] "9"
		WORD	MOJPOL_L	;[11]
		WORD	MOJPOL_C	;[12]
		WORD	MOJPOL_T	;[13]
		WORD	CLEAR_POL	;[14] " "
		WORD	MOJPOL_G	;[15]
		WORD	MOJPOL_M	;[16]
		WORD	MOJPOL_O	;[17]
		WORD	MOJPOL_V	;[18]
		WORD	MOJPOL_R	;[19]
;
;----------------------------------------------------------------
;		"P"						-
;----------------------------------------------------------------
MOJPOL_P	EQU	$
;-------------- point data --------------------------------------
		BYTE	12			;number of point
		BYTE	 10H,-40H		;{00}-(00),(01) X pos , Y pos
		BYTE	-19H,-34H		;{01}-(02),(03)
		BYTE	-30H,-30H		;{02}-(04),(05)
		BYTE	 30H,-30H		;{03}-(06),(07)
		BYTE	-13H,-20H		;{04}-(08),(09)
		BYTE	 10H,-20H		;{05}-(10),(11)
		BYTE	 30H,-10H		;{06}-(12),(13)
		BYTE	-0CH,-08H		;{07}-(14),(15)
		BYTE	 20H, 00H		;{08}-(16),(17)
		BYTE	-02H, 10H		;{09}-(18),(19)
		BYTE	-20H, 40H		;{10}-(20),(21)
		BYTE	 10H, 40H		;{11}-(22),(23)
;-------------- face data ---------------------------------------
		BYTE	03			;number of face
		BYTE	04			;number of point
		BYTE	02,22,20,04		;{00}-(00),(01),(02),(03),(04),(05)
		BYTE	CL2,CL1,CL2,CL1		;color data
		BYTE	05			;number of point
		BYTE	00,06,10,08,02		;{01}-(06),(07),(08),(09),(10),(11),(12)
		BYTE	CL3,0,CL1,0,CL1		;color data
		BYTE	06			;number of point
		BYTE	06,12,16,18,14,10	;{02}-(13),(14),(15),(16),(17),(18),(19),(20)
		BYTE	CL2,CL4,CL1,0,CL4,0	;color data
;-------------- priority data -----------------------------------
; bit pos -->		 4  2  1
		BYTE	00,02,09		;check face no.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	02,01,00,00,02,01,00,00 ;(1) write priority
		BYTE	01,02,02,01,01,02,02,01 ;(2)
		BYTE	00,00,01,02,00,00,01,02 ;(3)
;
;----------------------------------------------------------------
;		"A"						-
;----------------------------------------------------------------
MOJPOL_A	EQU	$
;-------------- point data --------------------------------------
		BYTE	12			;number of point
		BYTE	-10H,-40H		;{00}-(00),(01) X pos , Y pos
		BYTE	 00H,-3CH		;{01}-(02),(03)
		BYTE	 10H,-38H		;{02}-(04),(05)
		BYTE	 00H,-10H		;{03}-(06),(07)
		BYTE	-06H, 10H		;{04}-(08),(09)
		BYTE	 09H, 10H		;{05}-(10),(11)
		BYTE	-0DH, 30H		;{06}-(12),(13)
		BYTE	 12H, 30H		;{07}-(14),(15)
		BYTE	-30H, 40H		;{08}-(16),(17)
		BYTE	-0CH, 40H		;{09}-(18),(19)
		BYTE	 0FH, 40H		;{10}-(20),(21)
		BYTE	 30H, 40H		;{11}-(22),(23)
;-------------- face data ---------------------------------------
		BYTE	03			;number of face
		BYTE	05			;number of point
		BYTE	00,02,06,18,16		;{00}-(00),(01),(02),(03),(04),(05),(06)
		BYTE	CL1,0,CL2,CL1,CL2	;color data
		BYTE	04			;number of point
		BYTE	08,10,14,12		;{01}-(07),(08),(09),(10),(11),(12)
		BYTE	CL1,0,CL1,0		;color data
		BYTE	05			;number of point
		BYTE	02,04,22,20,06		;{02}-(13),(14),(15),(16),(17),(18),(19)
		BYTE	CL1,CL2,CL1,CL2,0	;color data
;-------------- priority data -----------------------------------
; bit pos -->		 4  2  1
		BYTE	03,04,18		;check face no.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	01,02,00,02,01,02,00,00 ;(1) write priority
		BYTE	02,01,01,00,00,01,01,02 ;(2)
		BYTE	00,00,02,01,02,00,02,01 ;(3)
;
;----------------------------------------------------------------
;		"U"						-
;----------------------------------------------------------------
MOJPOL_U	EQU	$
;-------------- point data --------------------------------------
		BYTE	10			;number of point
		BYTE	-30H,-30H		;{00}-(00),(01) X pos , Y pos
		BYTE	-08H,-30H		;{01}-(02),(03)
		BYTE	 10H,-20H		;{02}-(04),(05)
		BYTE	 30H,-20H		;{03}-(06),(07)
		BYTE	-29H, 20H		;{04}-(08),(09)
		BYTE	-10H, 20H		;{05}-(10),(11)
		BYTE	 00H, 28H		;{06}-(12),(13)
		BYTE	 20H, 30H		;{07}-(14),(15)
		BYTE	-10H, 40H		;{08}-(16),(17)
		BYTE	 00H, 40H		;{09}-(18),(19)
;-------------- face data ---------------------------------------
		BYTE	03			;number of face
		BYTE	04			;number of point
		BYTE	00,02,10,08		;{00}-(00),(01),(02),(03),(04),(05)
		BYTE	CL1,CL2,0,CL2		;color data
		BYTE	05			;number of point
		BYTE	08,10,12,18,16		;{01}-(06),(07),(08),(09),(10),(11),(12)
		BYTE	0,CL3,0,CL1,CL3		;color data
		BYTE	05			;number of point
		BYTE	04,06,14,18,12		;{02}-(13),(14),(15),(16),(17),(18),(19)
		BYTE	CL1,CL2,CL4,0,CL2	;color data
;-------------- priority data -----------------------------------
; bit pos -->		 4  2  1
		BYTE	00,10,04		;check face no.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	02,02,01,00,02,02,01,00 ;(1) write priority
		BYTE	01,00,00,01,01,00,00,01 ;(2)
		BYTE	00,01,02,02,00,01,02,02 ;(3)
;
;----------------------------------------------------------------
;		"S"						-
;----------------------------------------------------------------
MOJPOL_S	EQU	$
;-------------- point data --------------------------------------
		BYTE	08			;number of point
		BYTE	 00H,-40H		;{00}-(00),(01) X pos , Y pos
		BYTE	 20H,-20H		;{01}-(02),(03)
		BYTE	-20H,-10H		;{02}-(04),(05)
		BYTE	 10H,-10H		;{03}-(06),(07)
		BYTE	 00H, 10H		;{04}-(08),(09)
		BYTE	 20H, 10H		;{05}-(10),(11)
		BYTE	-20H, 20H		;{06}-(12),(13)
		BYTE	 00H, 40H		;{07}-(14),(15)
;-------------- face data ---------------------------------------
		BYTE	03			;number of face
		BYTE	04			;number of point
		BYTE	00,02,06,04		;{00}-(00),(01),(02),(03),(04),(05)
		BYTE	CL3,CL4,0,CL4		;color data
		BYTE	04			;number of point
		BYTE	04,06,10,08		;{01}-(06),(07),(08),(09),(10),(11)
		BYTE	0,CL3,0,CL3		;color data
		BYTE	04			;number of point
		BYTE	08,10,14,12		;{02}-(12),(13),(14),(15),(16),(17)
		BYTE	0,CL4,CL3,CL4		;color data
;-------------- priority data -----------------------------------
; bit pos -->		 4  2  1
		BYTE	00,10,04		;check face no.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	02,02,01,00,02,02,01,00 ;(1) write priority
		BYTE	01,00,02,01,01,00,02,01 ;(2)
		BYTE	00,01,00,02,00,01,00,02 ;(3)
;
;----------------------------------------------------------------
;		"E"						-
;----------------------------------------------------------------
MOJPOL_E	EQU	$
;-------------- point data --------------------------------------
		BYTE	14			;number of point
		BYTE	-20H,-30H		;{00}-(00),(01) X pos , Y pos
		BYTE	 00H,-38H		;{01}-(02),(03)
		BYTE	 20H,-40H		;{02}-(04),(05)
		BYTE	-04H,-18H		;{03}-(06),(07)
		BYTE	 20H,-20H		;{04}-(08),(09)
		BYTE	-04H,-08H		;{05}-(10),(11)
		BYTE	 20H,-10H		;{06}-(12),(13)
		BYTE	 00H, 10H		;{07}-(14),(15)
		BYTE	 18H, 10H		;{08}-(16),(17)
		BYTE	-04H, 28H		;{09}-(18),(19)
		BYTE	 20H, 20H		;{10}-(20),(21)
		BYTE	-20H, 40H		;{11}-(22),(23)
		BYTE	 00H, 40H		;{12}-(24),(25)
		BYTE	 20H, 40H		;{13}-(26),(27)
;-------------- face data ---------------------------------------
		BYTE	04			;number of face
		BYTE	04			;number of point
		BYTE	00,02,24,22		;{00}-(00),(01),(02),(03),(04),(05)
		BYTE	CL1,CL2,CL1,CL2		;color data
		BYTE	04			;number of point
		BYTE	02,04,08,06		;{01}-(06),(07),(08),(09),(10),(11)
		BYTE	CL1,CL2,CL1,0		;color data
		BYTE	04			;number of point
		BYTE	10,12,16,14		;{02}-(12),(13),(14),(15),(16),(17)
		BYTE	CL1,CL2,CL1,0		;color data
		BYTE	04			;number of point
		BYTE	18,20,26,24		;{03}-(18),(19),(20),(21),(22),(23)
		BYTE	CL1,CL2,CL1,0		;color data
;-------------- priority data -----------------------------------
; bit pos -->		 4  2  1
		BYTE	00,03,04		;check face no.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	03,01,00,00,03,01,00,00 ;(1) write priority
		BYTE	02,02,03,01,02,02,03,01 ;(2)
		BYTE	01,03,02,02,01,03,02,02 ;(3)
		BYTE	00,00,01,03,00,00,01,03 ;(4)
;
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;;		   "?"						   -
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;MOJPOL_qest	   EQU	   $
;;95/7/27;;;-------------- point data --------------------------------------
;;95/7/27;;		   BYTE	   22			   ;number of point
;;95/7/27;;		   BYTE	   -2BH,-40H		   ;{00}-(00),(01) X pos , Y pos
;;95/7/27;;		   BYTE	   -15H,-40H		   ;{01}-(02),(03)
;;95/7/27;;		   BYTE	    15H,-40H		   ;{02}-(04),(05)
;;95/7/27;;		   BYTE	    2BH,-40H		   ;{03}-(06),(07)
;;95/7/27;;		   BYTE	   -40H,-2BH		   ;{04}-(08),(09)
;;95/7/27;;		   BYTE	   -15H,-2BH		   ;{05}-(10),(11)
;;95/7/27;;		   BYTE	    15H,-2BH		   ;{06}-(12),(13)
;;95/7/27;;		   BYTE	    40H,-2BH		   ;{07}-(14),(15)
;;95/7/27;;		   BYTE	   -40H,-15H		   ;{08}-(16),(17)
;;95/7/27;;		   BYTE	   -15H,-15H		   ;{09}-(18),(19)
;;95/7/27;;		   BYTE	    00H,-15H		   ;{10}-(20),(21)
;;95/7/27;;		   BYTE	    15H,-15H		   ;{11}-(22),(23)
;;95/7/27;;		   BYTE	    40H,-15H		   ;{12}-(24),(25)
;;95/7/27;;		   BYTE	   -15H, 00H		   ;{13}-(26),(27)
;;95/7/27;;		   BYTE	    15H, 00H		   ;{14}-(28),(29)
;;95/7/27;;		   BYTE	    2BH, 00H		   ;{15}-(30),(31)
;;95/7/27;;		   BYTE	   -15H, 15H		   ;{16}-(32),(33)
;;95/7/27;;		   BYTE	    15H, 15H		   ;{17}-(34),(35)
;;95/7/27;;		   BYTE	   -15H, 2BH		   ;{18}-(36),(37)
;;95/7/27;;		   BYTE	    15H, 2BH		   ;{19}-(38),(39)
;;95/7/27;;		   BYTE	   -15H, 40H		   ;{20}-(40),(41)
;;95/7/27;;		   BYTE	    15H, 40H		   ;{21}-(42),(43)
;;95/7/27;;;-------------- face data ---------------------------------------
;;95/7/27;;		   BYTE	   05			   ;number of face
;;95/7/27;;		   BYTE	   05			   ;number of point
;;95/7/27;;		   BYTE	   00,02,18,16,08	   ;{00}-(00),(01),(02),(03),(04),(05),(06)
;;95/7/27;;		   BYTE	   CL1,CL2,CL1,CL2,CL4	   ;color data
;;95/7/27;;		   BYTE	   04			   ;number of point
;;95/7/27;;		   BYTE	   02,04,12,10		   ;{01}-(07),(08),(09),(10),(11),(12)
;;95/7/27;;		   BYTE	   CL1,0,CL1,0		   ;color data
;;95/7/27;;		   BYTE	   06			   ;number of point
;;95/7/27;;		   BYTE	   04,06,14,24,30,28	   ;{02}-(13),(14),(15),(16),(17),(18),(19),(20)
;;95/7/27;;		   BYTE	   CL1,CL3,CL2,CL4,CL1,CL2 ;color data
;;95/7/27;;		   BYTE	   05			   ;number of point
;;95/7/27;;		   BYTE	   20,22,34,32,26	   ;{03}-(21),(22),(23),(24),(25),(26),(27)
;;95/7/27;;		   BYTE	   CL1,CL2,CL1,CL2,CL4	   ;color data
;;95/7/27;;		   BYTE	   04			   ;number of point
;;95/7/27;;		   BYTE	   36,38,42,40		   ;{01}-(28),(29),(30),(31),(32),(33)
;;95/7/27;;		   BYTE	   CL1,CL2,CL1,CL2	   ;color data
;;95/7/27;;;-------------- priority data -----------------------------------
;;95/7/27;;; bit pos -->	    4  2  1
;;95/7/27;;		   BYTE	   12,10,32		   ;check face no.
;;95/7/27;;; pattern no. -->	    0  1  2  3	4  5  6	 7
;;95/7/27;;		   BYTE	   00,00,00,00,02,02,00,00 ;(1) write priority
;;95/7/27;;		   BYTE	   02,02,04,01,04,01,02,02 ;(2)
;;95/7/27;;		   BYTE	   01,01,03,03,03,03,04,01 ;(3)
;;95/7/27;;		   BYTE	   03,03,01,04,01,04,03,03 ;(4)
;;95/7/27;;		   BYTE	   04,04,02,02,00,00,01,04 ;(5)
;;95/7/27;;;
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;;		   "Star"					   -
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;MOJPOL_star	   EQU	   $
;;95/7/27;;;-------------- point data --------------------------------------
;;95/7/27;;		   BYTE	   10			   ;number of point
;;95/7/27;;		   BYTE	    00H,-40H		   ;{00}-(00),(01) X pos , Y pos
;;95/7/27;;		   BYTE	   -3EH,-15H		   ;{01}-(02),(03)
;;95/7/27;;		   BYTE	   -0EH,-15H		   ;{02}-(04),(05)
;;95/7/27;;		   BYTE	    0EH,-15H		   ;{03}-(06),(07)
;;95/7/27;;		   BYTE	    3EH,-15H		   ;{04}-(08),(09)
;;95/7/27;;		   BYTE	   -19H, 09H		   ;{05}-(10),(11)
;;95/7/27;;		   BYTE	    19H, 09H		   ;{06}-(12),(13)
;;95/7/27;;		   BYTE	    00H, 19H		   ;{07}-(14),(15)
;;95/7/27;;		   BYTE	   -25H, 34H		   ;{08}-(16),(17)
;;95/7/27;;		   BYTE	    25H, 34H		   ;{09}-(18),(19)
;;95/7/27;;;-------------- face data ---------------------------------------
;;95/7/27;;		   BYTE	   06			   ;number of face
;;95/7/27;;		   BYTE	   03			   ;number of point
;;95/7/27;;		   BYTE	   00,06,04		   ;{00}-(00),(01),(02),(03),(04)
;;95/7/27;;		   BYTE	   CL2,0,CL2		   ;color data
;;95/7/27;;		   BYTE	   03			   ;number of point
;;95/7/27;;		   BYTE	   02,04,10		   ;{01}-(05),(06),(07),(08),(09)
;;95/7/27;;		   BYTE	   CL1,0,CL3		   ;color data
;;95/7/27;;		   BYTE	   05			   ;number of point
;;95/7/27;;		   BYTE	   04,06,12,14,10	   ;{02}-(10),(11),(12),(13),(14),(15),(16)
;;95/7/27;;		   BYTE	   0,0,0,0,0		   ;color data
;;95/7/27;;		   BYTE	   03			   ;number of point
;;95/7/27;;		   BYTE	   06,08,12		   ;{03}-(17),(18),(19),(20),(21)
;;95/7/27;;		   BYTE	   CL1,CL4,0		   ;color data
;;95/7/27;;		   BYTE	   03			   ;number of point
;;95/7/27;;		   BYTE	   10,14,16		   ;{04}-(22),(23),(24),(25),(26)
;;95/7/27;;		   BYTE	   0,CL4,CL2		   ;color data
;;95/7/27;;		   BYTE	   03			   ;number of point
;;95/7/27;;		   BYTE	   12,18,14		   ;{05}-(27),(28),(29),(30),(31)
;;95/7/27;;		   BYTE	   CL2,CL3,0		   ;color data
;;95/7/27;;;-------------- priority data -----------------------------------
;;95/7/27;;; bit pos -->	    4  2  1
;;95/7/27;;		   BYTE	   21,08,03		   ;check face no.
;;95/7/27;;; pattern no. -->	    0  1  2  3	4  5  6	 7
;;95/7/27;;		   BYTE	   04,00,04,00,05,00,00,00 ;(1) write priority
;;95/7/27;;		   BYTE	   05,01,05,01,04,03,01,01 ;(2)
;;95/7/27;;		   BYTE	   02,03,01,02,03,02,02,02 ;(3)
;;95/7/27;;		   BYTE	   01,02,02,03,02,01,03,03 ;(4)
;;95/7/27;;		   BYTE	   03,04,03,04,01,05,04,04 ;(5)
;;95/7/27;;		   BYTE	   00,05,00,05,00,04,05,05 ;(6)
;
;----------------------------------------------------------------
;-	"0"							-
;----------------------------------------------------------------
KAZ_0		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	11
		BYTE	 10H,-40H	;00
		BYTE	 30H,-20H	;01
		BYTE	 30H, 10H	;02
		BYTE	 00H, 40H	;03
		BYTE	-20H, 30H	;04
		BYTE	-30H, 00H	;05
		BYTE	-10H,-30H	;06
		BYTE	-04H,-20H	;07
		BYTE	 20H,-10H	;08
		BYTE	 00H, 20H	;09
		BYTE	-10H, 00H	;10
;---------------  f[^ --------------------------------------
		BYTE	04		; |S
		BYTE	04		; |Cg
		BYTE	00,02,16,14
		BYTE	CL3,0,CL3,0
		BYTE	05		; |Cg
		BYTE	16,02,04,06,18
		BYTE	0,CL2,CL4,0,CL4
		BYTE	05		; |Cg
		BYTE	18,06,08,10,20
		BYTE	0,CL3,CL3,0,CL3
		BYTE	04		; |Cg
		BYTE	12,00,20,10
		BYTE	CL4,CL4,0,CL4
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,23,24	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	01,00,02,03,01,00,02,03
		BYTE	00,03,03,00,00,03,03,00
		BYTE	02,01,01,02,02,01,01,02
		BYTE	03,02,00,01,03,02,00,01
;
;----------------------------------------------------------------
;-	"1"							-
;----------------------------------------------------------------
KAZ_1		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	04
		BYTE	 00H,-40H	;00
		BYTE	 20H,-30H	;01
		BYTE	 10H, 40H	;02
		BYTE	-20H, 30H	;03
;---------------  f[^ --------------------------------------
		BYTE	01		; |S
		BYTE	04		; |Cg
		BYTE	00,02,04,06
		BYTE	CL3,CL4,CL3,CL4
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,02,03	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	00,00,00,00,00,00,00,00
;
;----------------------------------------------------------------
;-	"2"							-
;----------------------------------------------------------------
KAZ_2		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	10
		BYTE	-10H,-40H	;00
		BYTE	 20H,-20H	;01
		BYTE	 30H, 00H	;02
		BYTE	-0AH, 20H	;03
		BYTE	 20H, 20H	;04
		BYTE	 30H, 40H	;05
		BYTE	-30H, 40H	;06
		BYTE	-30H, 30H	;07
		BYTE	 14H,-10H	;08
		BYTE	-30H,-20H	;09
;---------------  f[^ --------------------------------------
		BYTE	03		; |S
		BYTE	04		; |Cg
		BYTE	00,02,16,18
		BYTE	CL3,0,CL3,CL4
		BYTE	04		; |Cg
		BYTE	14,02,04,12
		BYTE	CL4,CL3,CL4,CL2
		BYTE	04		; |Cg
		BYTE	06,08,10,12
		BYTE	CL1,CL3,CL1,0
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,08,16	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	00,00,02,01,01,00,02,00
		BYTE	01,01,01,00,02,01,01,01
		BYTE	02,02,00,02,00,02,00,02
;
;----------------------------------------------------------------
;-	"3"							-
;----------------------------------------------------------------
KAZ_3		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	10
		BYTE	-10H,-40H	;00
		BYTE	 40H,-20H	;01
		BYTE	 20H, 00H	;02
		BYTE	 30H, 10H	;03
		BYTE	 00H, 40H	;04
		BYTE	-30H, 30H	;05
		BYTE	 10H, 10H	;06
		BYTE	 00H, 00H	;07
		BYTE	 10H,-10H	;08
		BYTE	-20H,-20H	;09
;---------------  f[^ --------------------------------------
		BYTE	04		; |S
		BYTE	04		; |Cg
		BYTE	00,02,16,18
		BYTE	CL3,0,CL3,CL4
		BYTE	04		; |Cg
		BYTE	02,04,14,16
		BYTE	CL4,0,CL4,0
		BYTE	04		; |Cg
		BYTE	04,06,12,14
		BYTE	CL3,0,CL3,0
		BYTE	04		; |Cg
		BYTE	12,06,08,10
		BYTE	0,CL4,CL3,CL4
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,21,22	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	03,00,00,00,03,00,00,00
		BYTE	02,01,01,01,02,01,01,01
		BYTE	01,02,03,02,01,02,02,02
		BYTE	00,03,02,03,00,03,03,03
;
;----------------------------------------------------------------
;-	"4"							-
;----------------------------------------------------------------
KAZ_4		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	14
		BYTE	-20H,-40H	;00
		BYTE	 10H,-40H	;01
		BYTE	-10H, 10H	;02
		BYTE	 05H, 16H	;03
		BYTE	 15H,-30H	;04
		BYTE	 30H,-30H	;05
		BYTE	 26H, 16H	;06
		BYTE	 30H, 10H	;07
		BYTE	 30H, 30H	;08
		BYTE	 22H, 2AH	;09
		BYTE	 20H, 40H	;10
		BYTE	-05H, 40H	;11
		BYTE	 00H, 2CH	;12
		BYTE	-30H, 2DH	;13
;---------------  f[^ --------------------------------------
		BYTE	04		; |S
		BYTE	04		; |Cg
		BYTE	00,02,04,26
		BYTE	CL1,CL4,0,CL4
		BYTE	04		; |Cg
		BYTE	08,10,12,06
		BYTE	CL1,CL4,0,CL4
		BYTE	04		; |Cg
		BYTE	04,14,16,26
		BYTE	CL1,CL2,CL3,0
		BYTE	04		; |Cg
		BYTE	24,18,20,22
		BYTE	0,CL4,CL1,CL4
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,15,16	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	03,01,00,00,03,01,03,00
		BYTE	02,00,03,01,02,00,02,01
		BYTE	01,02,02,02,01,02,01,02
		BYTE	00,03,01,03,00,03,00,03
;
;----------------------------------------------------------------
;-	"5"							-
;----------------------------------------------------------------
KAZ_5		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	14
		BYTE	 00H,-40H	;00
		BYTE	 24H,-40H	;01
		BYTE	 18H,-34H	;02
		BYTE	 40H,-40H	;03
		BYTE	 40H,-20H	;04
		BYTE	 08H,-20H	;05
		BYTE	 04H,-10H	;06
		BYTE	 20H, 00H	;07
		BYTE	 20H, 30H	;08
		BYTE	-20H, 40H	;09
		BYTE	-30H, 20H	;10
		BYTE	 00H, 20H	;11
		BYTE	 00H, 10H	;12
		BYTE	-20H, 00H	;13
;---------------  f[^ --------------------------------------
		BYTE	05		; |S
		BYTE	04		; |Cg
		BYTE	00,02,12,26
		BYTE	CL1,CL4,0,CL4
		BYTE	04		; |Cg
		BYTE	04,06,08,10
		BYTE	CL4,CL2,CL1,0
		BYTE	04		; |Cg
		BYTE	12,14,24,26
		BYTE	CL3,0,CL3,0
		BYTE	04		; |Cg
		BYTE	14,16,22,24
		BYTE	CL2,0,CL2,0
		BYTE	04		; |Cg
		BYTE	22,16,18,20
		BYTE	0,CL4,CL3,CL1
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,03,10	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	04,01,04,00,04,01,04,00
		BYTE	03,00,03,01,03,00,03,01
		BYTE	02,03,02,02,02,02,02,02
		BYTE	01,02,00,03,01,03,00,03
		BYTE	00,04,01,04,00,04,01,04
;
;----------------------------------------------------------------
;-	"6"							-
;----------------------------------------------------------------
KAZ_6		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	12
		BYTE	 00H,-40H	;00
		BYTE	 30H,-30H	;01
		BYTE	 08H,-0AH	;02
		BYTE	 30H, 00H	;03
		BYTE	 30H, 20H	;04
		BYTE	 06H, 40H	;05
		BYTE	-20H, 30H	;06
		BYTE	-30H, 00H	;07
		BYTE	-04H,-01H	;08
		BYTE	 10H, 10H	;09
		BYTE	 00H, 20H	;10
		BYTE	-08H, 10H	;11
;---------------  f[^ --------------------------------------
		BYTE	04		; |S
		BYTE	04		; |Cg
		BYTE	00,02,22,14
		BYTE	CL3,CL4,0,CL4
		BYTE	04		; |Cg
		BYTE	04,06,18,16
		BYTE	CL3,0,CL3,0
		BYTE	05		; |Cg
		BYTE	06,08,10,20,18
		BYTE	CL2,CL4,0,CL4,0
		BYTE	05		; |Cg
		BYTE	20,10,12,14,22
		BYTE	0,CL3,CL3,0,CL3
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,03,10	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	03,01,03,00,02,02,00,00
		BYTE	02,02,00,01,01,01,03,01
		BYTE	01,00,01,02,03,00,01,02
		BYTE	00,03,02,03,00,03,02,03
;
;----------------------------------------------------------------
;-	"7"							-
;----------------------------------------------------------------
KAZ_7		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	08
		BYTE	-20H,-40H	;00
		BYTE	 40H,-20H	;01
		BYTE	 20H, 00H	;02
		BYTE	 00H, 40H	;03
		BYTE	-30H, 40H	;04
		BYTE	-10H, 10H	;05
		BYTE	 10H,-10H	;06
		BYTE	-30H,-20H	;07
;---------------  f[^ --------------------------------------
		BYTE	03		; |S
		BYTE	04		; |Cg
		BYTE	00,02,12,14
		BYTE	CL3,0,CL3,CL4
		BYTE	04		; |Cg
		BYTE	02,04,10,12
		BYTE	CL4,0,CL4,0
		BYTE	04		; |Cg
		BYTE	04,06,08,10
		BYTE	CL4,CL1,CL4,0
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,03,04	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	02,00,00,00,02,00,00,00
		BYTE	01,01,02,02,01,01,02,01
		BYTE	00,02,01,01,00,02,01,02
;
;----------------------------------------------------------------
;-	"8"							-
;----------------------------------------------------------------
KAZ_8		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	18
		BYTE	 20H,-40H	;00
		BYTE	 40H,-20H	;01
		BYTE	 20H, 00H	;02
		BYTE	 30H, 30H	;03
		BYTE	 00H, 40H	;04
		BYTE	-40H, 20H	;05
		BYTE	-30H, 00H	;06
		BYTE	-10H,-10H	;07
		BYTE	-20H,-20H	;08
		BYTE	-20H,-30H	;09
		BYTE	 0CH,-32H	;10
		BYTE	 20H,-22H	;11
		BYTE	 10H,-08H	;12
		BYTE	-04H,-20H	;13
		BYTE	 02H,-04H	;14
		BYTE	 12H, 0EH	;15
		BYTE	 00H, 20H	;16
		BYTE	-10H, 10H	;17
;---------------  f[^ --------------------------------------
		BYTE	07		; |S
		BYTE	04		; |Cg
		BYTE	00,02,22,20
		BYTE	CL3,0,CL3,0
		BYTE	04		; |Cg
		BYTE	02,04,24,22
		BYTE	CL4,0,CL4,0
		BYTE	04		; |Cg
		BYTE	04,06,14,26
		BYTE	CL3,CL3,0,CL3
		BYTE	04		; |Cg
		BYTE	30,06,08,32
		BYTE	0,CL4,0,CL4
		BYTE	05		; |Cg
		BYTE	34,32,08,10,12
		BYTE	CL3,0,CL3,CL4,0
		BYTE	04		; |Cg
		BYTE	14,28,34,12
		BYTE	0,CL4,0,CL4
		BYTE	04		; |Cg
		BYTE	00,14,16,18
		BYTE	CL4,CL3,CL2,CL4
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,39,15	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	04,00,04,06,04,00,04,06
		BYTE	03,01,03,00,03,01,05,00
		BYTE	05,02,05,02,05,02,03,02
		BYTE	02,06,06,05,02,03,06,05
		BYTE	01,03,02,01,01,06,02,04
		BYTE	00,05,00,04,00,05,01,01
		BYTE	06,04,01,03,06,04,00,03
;
;----------------------------------------------------------------
;-	"9"							-
;----------------------------------------------------------------
KAZ_9		EQU	$
;--------------- |Cg f[^ --------------------------------
		BYTE	11
		BYTE	 20H,-40H	;00
		BYTE	 40H, 00H	;01
		BYTE	 10H, 40H	;02
		BYTE	-20H, 30H	;03
		BYTE	 02H, 10H	;04
		BYTE	-10H, 10H	;05
		BYTE	-30H,-20H	;06
		BYTE	 10H,-20H	;07
		BYTE	 20H,-10H	;08
		BYTE	 12H, 00H	;09
		BYTE	 00H,-10H	;10
;---------------  f[^ --------------------------------------
		BYTE	04		; |S
		BYTE	04		; |Cg
		BYTE	16,14,00,02
		BYTE	CL3,0,CL3,0
		BYTE	04		; |Cg
		BYTE	16,02,04,06
		BYTE	0,CL4,CL3,CL4
		BYTE	05		; |Cg
		BYTE	20,18,08,10,12
		BYTE	CL3,0,CL1,CL3,0
		BYTE	04		; |Cg
		BYTE	14,20,12,00
		BYTE	CL4,0,CL4,0
;--------------- D揇 f[^ --------------------------------
;	bit pos ---->	 4  2  1
		BYTE	00,24,02	; check  NO.
;	pattern NO.->	 0  1  2  3  4	5  6  7
		BYTE	01,01,02,00,01,00,02,03
		BYTE	02,00,03,02,00,01,03,00
		BYTE	00,03,01,03,02,03,00,02
		BYTE	03,02,00,01,03,02,01,01
;
;----------------------------------------------------------------
;		"L"						-
;----------------------------------------------------------------
MOJPOL_L	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	6			;number of point
		BYTE	-20H,-35H		;00
		BYTE	 10H,-40H		;01
		BYTE	-05H, 18H		;02
		BYTE	 28H, 15H		;03
		BYTE	 30H, 40H		;04
		BYTE	-30H, 40H		;05
;--------------  f[^ ---------------------------------------
		BYTE	02			; |S
		BYTE	04			; |Cg
		BYTE	04,10,00,02
		BYTE	0,CL2,CL1,CL2
		BYTE	04			;|Cg
		BYTE	04,06,08,10
		BYTE	CL1,CL2,CL1,0
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,03,04		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	00,01,00,01,00,01,00,01 ;(1) write priority
		BYTE	01,00,01,00,01,00,01,00 ;(2)
;
;----------------------------------------------------------------
;		"C"						-
;----------------------------------------------------------------
MOJPOL_C	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	13			;number of point
		BYTE	 00H,-40H		;00
		BYTE	 27H,-37H		;01
		BYTE	 34H,-24H		;02
		BYTE	 15H,-10H		;03
		BYTE	 12H,-24H		;04
		BYTE	-10H,-04H		;05
		BYTE	-10H, 10H		;06
		BYTE	 08H, 20H		;07
		BYTE	 29H, 11H		;08
		BYTE	 2EH, 35H		;09
		BYTE	 00H, 40H		;10
		BYTE	-30H, 20H		;11
		BYTE	-30H,-10H		;12
;--------------  f[^ ---------------------------------------
		BYTE	05			; |S
		BYTE	04			; |Cg
		BYTE	02,04,06,00
		BYTE	CL3,CL4,CL3,CL1
		BYTE	04			;|Cg
		BYTE	00,08,10,24
		BYTE	0,CL4,0,CL4
		BYTE	04			;|Cg
		BYTE	10,12,22,24
		BYTE	CL2,0,CL2,0
		BYTE	04			;|Cg
		BYTE	12,14,20,22
		BYTE	CL3,0,CL3,0
		BYTE	04			;|Cg
		BYTE	14,16,18,20
		BYTE	CL1,CL2,CL1,0
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,16,28		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	03,00,00,00,03,00,04,00 ;(1) write priority
		BYTE	04,01,04,01,04,01,03,01 ;(2)
		BYTE	02,02,03,02,02,02,00,02 ;(3)
		BYTE	01,03,01,04,01,03,02,04 ;(4)
		BYTE	00,04,02,03,00,04,01,03 ;(5)
;
;----------------------------------------------------------------
;		"T"						-
;----------------------------------------------------------------
MOJPOL_T	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	8			;number of point
		BYTE	-30H,-40H		;00
		BYTE	 30H,-40H		;01
		BYTE	 30H,-20H		;02
		BYTE	-27H,-15H		;03
		BYTE	-10H,-1BH		;04
		BYTE	 11H,-20H		;05
		BYTE	 15H, 40H		;06
		BYTE	-10H, 40H		;07
;--------------  f[^ ---------------------------------------
		BYTE	02			; |S
		BYTE	04			; |Cg
		BYTE	00,02,04,06
		BYTE	CL1,CL2,CL1,CL2
		BYTE	04			;|Cg
		BYTE	08,10,12,14
		BYTE	0,CL2,CL1,CL2
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,11,02		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	00,01,00,01,00,01,00,01 ;(1) write priority
		BYTE	01,00,01,00,01,00,01,00 ;(2)
;
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;;		   "{"						   -
;;95/7/27;;;----------------------------------------------------------------
;;95/7/27;;PURAS_POL	   EQU	   $
;;95/7/27;;		   BYTE	   12		   ;number of point
;;95/7/27;;		   BYTE	   -10H,-30H	   ;00
;;95/7/27;;		   BYTE	    10H,-30H	   ;01
;;95/7/27;;		   BYTE	    10H,-14H	   ;02
;;95/7/27;;		   BYTE	   -10H,-14H	   ;03
;;95/7/27;;		   BYTE	    30H,-10H	   ;04
;;95/7/27;;		   BYTE	    30H, 10H	   ;05
;;95/7/27;;		   BYTE	    10H, 0CH	   ;06
;;95/7/27;;		   BYTE	    10H, 30H	   ;07
;;95/7/27;;		   BYTE	   -10H, 30H	   ;08
;;95/7/27;;		   BYTE	   -10H, 0CH	   ;09
;;95/7/27;;		   BYTE	   -30H, 10H	   ;10
;;95/7/27;;		   BYTE	   -30H,-10H	   ;11
;;95/7/27;;;--------------  f[^ ---------------------------------------
;;95/7/27;;		   BYTE	   3		   ; |S
;;95/7/27;;		   BYTE	   04		   ; |Cg
;;95/7/27;;		   BYTE	   00,02,04,06
;;95/7/27;;		   BYTE	   CL1,CL2,0,CL2
;;95/7/27;;		   BYTE	   04		   ; |Cg
;;95/7/27;;		   BYTE	   22,08,10,20
;;95/7/27;;		   BYTE	   CL1,CL2,CL1,CL2
;;95/7/27;;		   BYTE	   04		   ; |Cg
;;95/7/27;;		   BYTE	   12,14,16,18
;;95/7/27;;		   BYTE	   CL2,CL1,CL2,0
;;95/7/27;;;-------------- D揇 f[^ ---------------------------------
;;95/7/27;;; bit pos -->	    4  2  1
;;95/7/27;;		   BYTE	   06,08,09		   ;check  NO.
;;95/7/27;;; pattern no. -->	    0  1  2  3	4  5  6	 7
;;95/7/27;;		   BYTE	   00,00,02,02,00,00,02,02 ;(1) write priority
;;95/7/27;;		   BYTE	   01,01,01,01,01,01,01,01 ;(2)
;;95/7/27;;		   BYTE	   02,02,00,00,02,02,00,00 ;(3)
;
;----------------------------------------------------------------
;		"G"						-
;----------------------------------------------------------------
MOJPOL_G	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	13			;number of point
		BYTE	 00H,-40H		;00
		BYTE	 20H,-20H		;01
		BYTE	-20H, 00H		;02
		BYTE	 04H, 24H		;03
		BYTE	 10H, 10H		;04
		BYTE	 00H, 00H		;05
		BYTE	 20H, 00H		;06
		BYTE	 30H, 00H		;07
		BYTE	 40H, 40H		;08
		BYTE	 20H, 40H		;09
		BYTE	 20H, 30H		;10
		BYTE	-20H, 40H		;11
		BYTE	-40H, 00H		;12
;--------------  f[^ ---------------------------------------
		BYTE	05			; |S
		BYTE	04			; |Cg
		BYTE	00,02,04,24
		BYTE	CL3,CL4,0,CL4
		BYTE	04			;|Cg
		BYTE	04,06,22,24
		BYTE	CL3,0,CL3,0
		BYTE	03			;|Cg
		BYTE	12,20,22
		BYTE	0,CL1,CL4
		BYTE	03			;|Cg
		BYTE	10,12,08
		BYTE	CL1,0,CL3
		BYTE	04			;|Cg
		BYTE	12,14,16,18
		BYTE	CL1,CL2,CL1,CL2
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,24,25		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	00,00,04,02,00,00,04,02 ;(1) write priority
		BYTE	04,03,02,01,04,04,02,01 ;(2)
		BYTE	02,01,03,04,03,03,03,03 ;(3)
		BYTE	03,02,01,03,02,02,01,00 ;(4)
		BYTE	01,04,00,00,01,01,00,04 ;(5)
;
;----------------------------------------------------------------
;		"M"						-
;----------------------------------------------------------------
MOJPOL_M	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	12			;number of point
		BYTE	-20H,-30H		;00
		BYTE	-10H,-20H		;01
		BYTE	 00H,-10H		;02
		BYTE	 18H,-20H		;03
		BYTE	 30H,-40H		;04
		BYTE	 40H, 40H		;05
		BYTE	 10H, 40H		;06
		BYTE	 10H, 00H		;07
		BYTE	 00H, 40H		;08
		BYTE	-10H, 10H		;09
		BYTE	-10H, 40H		;10
		BYTE	-40H, 40H		;11
;--------------  f[^ ---------------------------------------
		BYTE	04			; |S
		BYTE	04			; |Cg
		BYTE	00,02,20,22
		BYTE	CL3,CL2,CL1,CL2
		BYTE	04			;|Cg
		BYTE	02,04,16,18
		BYTE	CL3,0,CL3,0
		BYTE	04			;|Cg
		BYTE	04,06,14,16
		BYTE	CL4,0,CL4,0
		BYTE	04			;|Cg
		BYTE	06,08,10,12
		BYTE	CL4,CL2,CL1,CL2
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,03,04		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	03,03,00,00,03,03,00,00 ;(1) write priority
		BYTE	02,02,01,01,02,02,01,01 ;(2)
		BYTE	01,01,02,02,01,01,02,02 ;(3)
		BYTE	00,00,03,03,00,00,03,03 ;(4)
;
;----------------------------------------------------------------
;		"V"						-
;----------------------------------------------------------------
MOJPOL_V	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	 08			;number of point
		BYTE	-10H,-40H		;00
		BYTE	-12H, 20H		;01
		BYTE	 20H,-40H		;02
		BYTE	 40H,-20H		;03
		BYTE	 00H, 40H		;04
		BYTE	-10H, 40H		;05
		BYTE	-20H, 40H		;06
		BYTE	-40H,-30H		;07
;--------------  f[^ ---------------------------------------
		BYTE	02			; |S
		BYTE	04			; |Cg
		BYTE	00,10,12,14
		BYTE	CL2,CL1,CL3,CL4
		BYTE	05			;|Cg
		BYTE	02,04,06,08,10
		BYTE	CL4,CL3,CL4,CL1,CL2
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,02,03		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	01,01,00,00,01,01,00,00 ;(1) write priority
		BYTE	00,00,01,01,00,00,01,01 ;(2)
;
;----------------------------------------------------------------
;		"R"						-
;----------------------------------------------------------------
MOJPOL_R	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	 14			;number of point
		BYTE	 00H,-40H		;00
		BYTE	 20H,-30H		;01
		BYTE	 30H,-10H		;02
		BYTE	 1AH,-04H		;03
		BYTE	 40H, 20H		;04
		BYTE	 20H, 40H		;05
		BYTE	 00H, 10H		;06
		BYTE	-10H, 10H		;07
		BYTE	 00H, 40H		;08
		BYTE	-30H, 40H		;09
		BYTE	-40H,-30H		;10
		BYTE	-20H,-20H		;11
		BYTE	 10H,-20H		;12
		BYTE	-13H, 00H		;13
;--------------  f[^ ---------------------------------------
		BYTE	04			; |S
		BYTE	05			; |Cg
		BYTE	00,02,24,22,20
		BYTE	CL3,0,CL1,0,CL1
		BYTE	04			;|Cg
		BYTE	22,16,18,20
		BYTE	CL3,CL1,CL2,0
		BYTE	05			;|Cg
		BYTE	02,04,12,14,26
		BYTE	CL3,CL4,CL1,0,CL4
		BYTE	04			;|Cg
		BYTE	06,08,10,12
		BYTE	CL3,CL4,CL3,0
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,10,11		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	01,03,00,02,01,03,00,02 ;(1) write priority
		BYTE	03,02,01,03,02,02,01,00 ;(2)
		BYTE	02,01,02,00,00,01,02,03 ;(3)
		BYTE	00,00,03,01,03,00,03,01 ;(4)
;
;;;;;----------------------------------------------------------------
;;;;;		    "O"						    -
;;;;;----------------------------------------------------------------
;;;;MOJPOL_O	    EQU	    $
;;;;;-------------- |Cg f[^ ---------------------------------
;;;;		    BYTE    10			    ;number of point
;;;;		    BYTE     00H,-40H		    ;00
;;;;		    BYTE     40H,-20H		    ;01
;;;;		    BYTE     30H, 30H		    ;02
;;;;		    BYTE     10H, 40H		    ;03
;;;;		    BYTE    -20H, 40H		    ;04
;;;;		    BYTE    -40H, 00H		    ;05
;;;;		    BYTE    -10H,-10H		    ;06
;;;;		    BYTE     10H,-16H		    ;07
;;;;		    BYTE     20H, 10H		    ;08
;;;;		    BYTE    -10H, 20H		    ;09
;;;;;--------------  f[^ ---------------------------------------
;;;;		    BYTE    04			    ; |S
;;;;		    BYTE    03			    ; |Cg
;;;;		    BYTE    00,02,10
;;;;		    BYTE    CL3,CL1,CL4
;;;;		    BYTE    03			    ;|Cg
;;;;		    BYTE    02,04,14
;;;;		    BYTE    CL2,CL3,0
;;;;		    BYTE    05			    ;|Cg
;;;;		    BYTE    16,04,06,08,18
;;;;		    BYTE    0,CL1,CL1,0,CL1
;;;;		    BYTE    04			    ;|Cg
;;;;		    BYTE    18,08,10,12
;;;;		    BYTE    CL4,CL3,0,CL2
;;;;;-------------- D揇 f[^ ---------------------------------
;;;;; bit pos -->	     4	2  1
;;;;		    BYTE    00,14,22		    ;check  NO.
;;;;; pattern no. -->	     0	1  2  3	 4  5  6  7
;;;;		    BYTE    01,00,00,00,01,00,00,00 ;(1) write priority
;;;;		    BYTE    00,03,01,03,02,02,01,03 ;(2)
;;;;		    BYTE    02,02,02,02,03,03,02,01 ;(3)
;;;;		    BYTE    03,01,03,01,00,01,03,02 ;(4)
;
;----------------------------------------------------------------
;		"O"						-
;----------------------------------------------------------------
MOJPOL_O	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	10			;number of point
		BYTE	 00H,-40H		;00
		BYTE	 40H,-20H		;01
		BYTE	 30H, 30H		;02
		BYTE	 10H, 40H		;03
		BYTE	-20H, 40H		;04
		BYTE	-40H, 00H		;05
		BYTE	-10H,-10H		;06
		BYTE	 10H,-16H		;07
		BYTE	 20H, 10H		;08
		BYTE	-10H, 20H		;09
;--------------  f[^ ---------------------------------------
		BYTE	05			; |S
		BYTE	04			; |Cg
		BYTE	12,00,02,14
		BYTE	0,CL3,0,CL1
		BYTE	04			;|Cg
		BYTE	16,14,02,04
		BYTE	CL3,0,CL2,0
		BYTE	05			;|Cg
		BYTE	16,04,06,08,18
		BYTE	0,CL4,CL1,0,CL1
		BYTE	04			;|Cg
		BYTE	08,10,12,18
		BYTE	CL3,0,CL2,0
		BYTE	03			;|Cg
		BYTE	00,12,10
		BYTE	0,0,CL4
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,10,16		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	02,00,04,04,01,01,04,04 ;(1) write priority
		BYTE	03,04,03,00,02,00,03,03 ;(2)
		BYTE	01,01,00,03,03,02,02,00 ;(3)
		BYTE	00,03,02,01,00,04,00,01 ;(4)
		BYTE	04,02,01,02,04,03,01,02 ;(5)
;
;
;
;
;
;============== 95/7/27 o`kłł̒ǉύX ====================
;
;----------------------------------------------------------------
;		"D"						-
;----------------------------------------------------------------
MOJPOL_D	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	9			;number of point
		BYTE	 00H,-40H		;00
		BYTE	 30H,-20H		;01
		BYTE	 30H, 20H		;02
		BYTE	-20H, 40H		;03
		BYTE	-30H,-30H		;04
		BYTE	-10H,-20H		;05
		BYTE	 10H,-10H		;06
		BYTE	 10H, 08H		;07
		BYTE	-10H, 20H		;08
;--------------  f[^ ---------------------------------------
		BYTE	05			; |S
		BYTE	04			; |Cg
		BYTE	10,00,02,12
		BYTE	0,CL3,0,CL3
		BYTE	04			;|Cg
		BYTE	14,12,02,04
		BYTE	CL2,0,CL2,0
		BYTE	04			;|Cg
		BYTE	14,04,06,16
		BYTE	0,CL4,0,CL4
		BYTE	04			;|Cg
		BYTE	08,10,16,06
		BYTE	0,CL2,0,CL2
		BYTE	03			;|Cg
		BYTE	00,10,08
		BYTE	0,0,CL4
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,10,15		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	02,04,03,04,01,00,02,04 ;(1) write priority
		BYTE	03,00,02,03,02,04,03,03 ;(2)
		BYTE	01,03,01,00,03,01,04,00 ;(3)
		BYTE	04,01,04,01,00,02,01,01 ;(4)
		BYTE	00,02,00,02,04,03,00,02 ;(5)
;
;----------------------------------------------------------------
;		"!!"						-
;----------------------------------------------------------------
MOJPOL_bik	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	19			;number of point
		BYTE	-10H,-40H		;00
		BYTE	 00H,-30H		;01
		BYTE	-20H, 10H		;02
		BYTE	-30H,-10H		;03
		BYTE	-30H,-30H		;04
		BYTE	-20H, 20H		;05
		BYTE	-10H, 30H		;06
		BYTE	-20H, 40H		;07
		BYTE	-30H, 30H		;08
		BYTE	 20H,-40H		;09
		BYTE	 30H,-30H		;10
		BYTE	 30H,-20H		;11
		BYTE	 10H, 10H		;12
		BYTE	 00H,-20H		;13
		BYTE	 10H, 20H		;14
		BYTE	 20H, 20H		;15
		BYTE	 20H, 30H		;16
		BYTE	 10H, 40H		;17
		BYTE	 00H, 30H		;18
;--------------  f[^ ---------------------------------------
		BYTE	04			; |S
		BYTE	05			; |Cg
		BYTE	00,02,04,06,08
		BYTE	CL3,CL4,CL3,CL2,CL4
		BYTE	04			;|Cg
		BYTE	10,12,14,16
		BYTE	CL3,CL4,CL3,CL4
		BYTE	05			;|Cg
		BYTE	26,18,20,22,24
		BYTE	CL4,CL3,CL2,CL4,CL3
		BYTE	05			;|Cg
		BYTE	28,30,32,34,36
		BYTE	CL1,CL2,CL4,CL3,CL4
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,05,25		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	01,01,03,03,00,00,02,02 ;(1) write priority
		BYTE	00,00,01,01,02,02,00,00 ;(2)
		BYTE	03,03,02,02,01,01,03,03 ;(3)
		BYTE	02,02,00,00,03,03,01,01 ;(4)
;
;----------------------------------------------------------------
;		" "						-
;----------------------------------------------------------------
CLEAR_POL	EQU	$
;-------------- |Cg f[^ ---------------------------------
		BYTE	3			;number of point
		BYTE	 00H, 00H		;00
		BYTE	 00H, 00H		;01
		BYTE	 00H, 00H		;02
;--------------  f[^ ---------------------------------------
		BYTE	01			; |S
		BYTE	03			; |Cg
		BYTE	00,02,04
		BYTE	0,0,0
;-------------- D揇 f[^ ---------------------------------
; bit pos -->		 4  2  1
		BYTE	00,00,00		;check  NO.
; pattern no. -->	 0  1  2  3  4	5  6  7
		BYTE	00,00,00,00,00,00,00,00 ;(1) write priority
;
;
;
;
;
		END
