;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.2				*
;*	file name	: ys_chip1					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;		GLB
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_msub0 >-----------------------------------------------
		EXT	BGUNIT_READ_2
;
		EXT	ENBGCK_POINT_IN,ENBGCK_POINT
;
;-------------< ys_mplay0 >----------------------------------------------
		EXT	M_RAD_GET_S
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_A		GROUP	S_chip_1
S_chip_1	SECT	REL
;
;
;
;
;
;
;************************************************************************
;*		slime H-DMA set						*
;*			in  : (R2)   <-- kire Y pos			*
;*			      (R3)   <--   "  center Y pos              *
;*			      (CWK0) <-- foot X pos ( display )		*
;*			      (CWK1) <--   "  Y       "			*
;*			      (CWK2) <-- X zoom flag ( 100H=1.0 )	*
;*			      (CWK3) <-- Y	    "                   *
;*			      (CWK4) <-- sin data pointer		*
;*			      (CWK5) <--     "    X zoom flag           *
;*			      (CWK6) <--     "    Y spep                *
;*			      (CWK7) <-- eye X pos			*
;*			      (CWK8) <--   " Y  "			*
;*			      (CWK9) <-- slime enemy index		*
;*			      (CWKA) <-- player display X pos		*
;*			      (CWKB) <--	"       Y  "		*
;*			      (CWKC) <--    "   sit down flag           *
;*									*
;*			out : (CWKD) <--    "   cross flag              *
;*						[ 00011111B ]		*
;*						     +++++- foot	*
;*						     |||+-- down right	*
;*						     ||+---   "  left   *
;*						     |+---- up	 right	*
;*						     +-----   "  left   *
;*			      (CWKE) <-- player foot hosei dot		*
;*			      (CWKF) <--      "      cross saka flag    *
;*			      (CWK10) <- hed BG check Y pos		*
;*						0,5,4,9:not saka	*
;*						1,6    :67.5		*
;*						2,7    :45		*
;*						3,8    :22.5		*
;************************************************************************
;
SLIMEST		EQU	$
		WITH	R2		;(R2) <-- kire Y pos hosei
		SUB	#8
		WITH	R3		;(R3) <--   "  center Y pos hosei
		SUB	#8
;
		IBT	R0,#BANK EGG_DATA	;slime data address(B) set
		ROMB
;
		IWT	R14,#EGG_DATA	;(R14) <-- slime data address
		GETB
		SMS	R0,CWORK10	;(CWK10) <-- slime high
		TO	R10		;(R10) <-- slime data botom pointer
		SWAP
;
;;;;		    IWT	    R9,#0B2H-1	    ;(R9) <-- H-DMA data set line no.
		IWT	R9,#0D2H-1	;(R9) <-- H-DMA data set line no.
;
		LMS	R0,CWORK1
		TO	R1		;(R1) <-- foot Y pos
		SUB	#8
		IWT	R0,#DIVBUF
		LMS	R8,CWORK3
		ADD	R8
		ADD	R8
		TO	R8		;(R8) <-- Y zoom step
		LDW	(R0)
		SMS	R8,CWORK11	;(CWK11) <-- Y zoom step
;
		CACHE
;
		LMS	R0,CWORK0
		SMS	R0,CWORK12	;(CWK12) <-- scroll counter_H set center X pos
		IBT	R11,#060H
		ADD	R11
		IWT	R11,#100H+(60H+60H)
		SUB	R11
		BCC	SLIMS000	;display ? ( yes:SLIMS000 )
		NOP
;
;-------------- not display !! ----------------------------------
		IBT	R0,#80H		;[ IWT R0,#0FF80H ]
		SMS	R0,CWORK12	;(CWK12) <-- scroll counter_H set center X pos
		IWT	R15,#SLIMS130+1 ;[ JMP SLIMS130+1 ]
		LMS	R0,CWORK10	;[ dummy ]
;
SLIMS000
;;;;		    IWT	    R11,#HDMABF+(0B2H-1)*2  ;(R11) <-- H-DMA buffer address
		IWT	R11,#HDMABF+(0D2H-1)*2	;(R11) <-- H-DMA buffer address
;;;;		    IWT	    R13,#0B2H-2
		IWT	R13,#0D2H-2
		FROM	R13
		SUB	R1
		BPL	SLIMS010	;no under clear ? ( no:SLIMS010 )
		TO	R6
;
;-------------- no under clear !! -------------------------------
		NOT
		INC	R6
		FROM	R8
		LMULT
		WITH	R10
		SUB	R4
		BRA	SLIMS030
		INC	R14		;[ next program ]
;
SLIMS010
		MOVE	R12,R0		;(R12) <-- number of under clear line
		FROM	R13
		SUB	R12
		BPL	SLIMS012	;all clear ? ( no:SLIMS012 )
		INC	R12
;
		MOVE	R12,R13
		INC	R12
SLIMS012
;
;-------------- under clear !! ----------------------------------
		WITH	R9
		SUB	R12
;;;;		    IWT	    R0,#-0B2H-8
		IWT	R0,#-0D2H-8
		MOVE	R13,R15
SLIMS020
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		INC	R0
;
		BNE	SLIMS030	;H-DMA data set end ? ( no:SLIMS030 )
		INC	R14		;[ next program ]
;
		IWT	R15,#SLIMS130+1 ;[ JMP SLIMS130+1 ]
		LMS	R0,CWORK10	;[ dummy ]
;
;-------------- slime data set ----------------------------------
SLIMS030
;;;;		INC	R14
		LMS	R6,CWORK2	;(R6) <-- X zoom flag
		MOVE	R7,R14		;(R7) <-- slime data address
;;;;		    IBT	    R4,#07FH	    ;(R4) <-- max X wide
;
		FROM	R9
		TO	R12
		SUB	R2
		INC	R12
		MOVE	R13,R15
SLIMS040
		WITH	R10
		SUB	R8
		BMI	SLIMS060	;slime data set end ? ( yes:SLIMS060 )
		FROM	R10
;
		HIB
		TO	R14
		ADD	R7
		GETB
		SWAP
		FMULT
		INC	R0
		LSR			;1/2
;;;;		    CMP	    R4
;;;;		    BCC	    SLIMS050	    ;max X wide over ? ( no:SLIMS050 )
;;;;		    NOP
;;;;;
;;;;		    MOVE    R0,R4
;;;SLIMS050
		MOVE	R5,R0		;(R5) <-- now set X wide
		SUB	R9
		SUB	#8
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		DEC	R9
;
		BPL	SLIMS052	;H-DMA data set end ? ( no:SLIMS052 )
		NOP
;
		IWT	R15,#SLIMS130+1 ;[ JMP SLIMS130+1 ]
		LMS	R0,CWORK10	;[ dummy ]
;
SLIMS052
		BRA	SLIMS070+1
		FROM	R2		;[ nex tprogram ]
;
;-------------- to kire Y pos clear !! --------------------------
SLIMS060
		FROM	R9
		NOT
		SUB	#8
		WITH	R9
		SUB	R12
		MOVE	R13,R15
SLIMS062
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		INC	R0
;
		BNE	SLIMS064	;H-DMA data set end ? ( no:SLIMS064 )
		NOP
;
		IWT	R15,#SLIMS130+1 ;[ JMP SLIMS130+1 ]
		LMS	R0,CWORK10	;[ dummy ]
;
SLIMS064
		IBT	R5,#00		;(R5) <-- now set X wide
;
;-------------- kire data set -----------------------------------
SLIMS070
		FROM	R2
		SUB	R3
		MOVE	R13,R0
		BPL	SLIMS072
		NOP
;
		NOT
		INC	R0
SLIMS072
		MOVE	R12,R0
		IWT	R14,#KIRE_DATA	;(R14) <-- kire data address
		IBT	R0,#35-1
		CMP	R12
		BCS	SLIMS080	;kira data over ? ( no:SLIMS080 )
		FROM	R12
;
		MOVE	R12,R0
SLIMS080
		SUB	R9
		BCC	SLIMS082
		INC	R12
;
		MOVE	R12,R9
		INC	R12
SLIMS082
		WITH	R14
		ADD	R12
		TO	R4		;(R4) <-- kire point data
		GETB
		WITH	R5		;(R5) <-- (kire data - slime X wide)
		SUB	R4
;
;;;;		    IBT	    R6,#07FH	    ;(R6)  <-- max X wide
		IBT	R10,#0FFH	;(R10) <-- min	 "
;
		MOVES	R13,R13
		BPL	SLIMS084	;kire from up ? ( no:SLIMS084 )
		DEC	R14
;
		INC	R14
		IBT	R0,#35
		TO	R12
		SUB	R12
		BNE	SLIMS110	;kire data nothing ? ( no:SLIMS110 )
		INC	R14
;
		DEC	R14
		BRA	SLIMS110
		INC	R12		;[ IBT R12,#1 ]
;
SLIMS084
		MOVE	R13,R15
SLIMS090
		GETB
		DEC	R14
		ADD	R5
		BPL	SLIMS092
		NOP
;
		MOVE	R0,R10
SLIMS092
;;;;		    CMP	    R6
;;;;		    BMI	    SLIMS100	    ;max X wide over ? ( no:SLIMS100 )
;;;;		    NOP
;;;;;
;;;;		    FROM    R6
;;;;SLIMS100
		SUB	R9
		SUB	#8
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		DEC	R9
;
		BMI	SLIMS130	;H-DMA data set end ? ( yes:SLIMS130 )
		INC	R14		;[ to top data !! ]
;
		IBT	R12,#35
		FROM	R12
		SUB	R9
		BCC	SLIMS110
		INC	R12
;
		MOVE	R12,R9
		INC	R12
;
SLIMS110
		MOVE	R13,R15
SLIMS112
		GETB
		INC	R14
		ADD	R5
		BPL	SLIMS114
		NOP
;
		MOVE	R0,R10
SLIMS114
;;;;		    CMP	    R6
;;;;		    BMI	    SLIMS120	    ;max X wide over ? ( no:SLIMS120 )
;;;;		    NOP
;;;;;
;;;;		    FROM    R6
;;;;SLIMS120
		SUB	R9
		SUB	#8
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		DEC	R9
;
		BMI	SLIMS130	;H-DMA data set end ? ( yes:SLIMS130 )
		INC	R9
;
		MOVE	R12,R9
		MOVE	R13,R15
SLIMS122
		INC	R0
		STW	(R11)
		DEC	R11
		LOOP
		DEC	R11
;
;-------------- scroll counter_H H-DMA data set -------------------------
SLIMS130
		LMS	R0,CWORK10
		SWAP
		LMS	R6,CWORK3
		TO	R12		;(R12) <-- slime high
		FMULT
;
		IWT	R7,#HDMABF1	;(R7)  <-- scroll counter_H set H-DMA buffer address
		LMS	R0,CWORK1
		SUB	#8
		MOVE	R9,R0		;(R9) <-- foot Y pos
		ADD	R7
		TO	R1		;(R1) <--		"                   pointer
		ADD	R9
;
		LMS	R0,CWORK4
		TO	R2		;(R2) <-- sin data pointer
		SWAP
		LMS	R0,CWORK6
		LMS	R6,CWORK11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R3		;(R3) <-- sin data Y step
		OR	R4
		LMS	R0,CWORK5
		LMS	R6,CWORK2
		LMULT
		MOVE	R6,R4		;(R6) <-- sin data X zoom flag
		IWT	R11,#SIN	;(R11) <-- sin data address
;
		IWT	R0,#080H
		LMS	R5,CWORK12
		TO	R5		;(R5) <-- center scroll counter_H
		SUB	R5
		MOVE	R8,R5		;(R8) <--	    "
;
		IBT	R0,#BANK SIN
		ROMB
;
		MOVE	R10,R9		;(R10) <-- foot Y pos
;;;;		    IWT	    R4,#0B2H	    ;(R4)  <-- max Y pos
		IWT	R4,#0D2H	;(R4)  <-- max Y pos
		MOVE	R13,R15
SLIMS140
		MOVES	R0,R10
		BMI	SLIMS160	;H-DMA data set end ? ( yes:SLIMS160 )
		SUB	R4
;
		BCS	SLIMS150	;	"       ok ? ( no:SLIMS150 )
		FROM	R2
;
		HIB
		ADD	R0
		TO	R14		;(R14) <-- read sin data address
		ADD	R11
;
		GETB
		INC	R14
		GETBH
		FMULT
		ADD	R5
		STW	(R1)
SLIMS150
		WITH	R2		;sin data pointer up !!
		ADD	R3
		DEC	R1
		DEC	R1
		LOOP
		DEC	R10
;D
;-------------- eye pos calculate ---------------------------------------
SLIMS160
		LMS	R0,CWORK7
		SWAP
		LMS	R6,CWORK2
		FMULT
		TO	R2		;(R2) <-- calculate eye X pos
		ADC	#0
;
		LMS	R0,CWORK8
		SWAP
		LMS	R6,CWORK3
		FMULT
		ADC	#0
		SMS	R0,CWORK8	;(CWK8) <-- calculate eye Y pos
;
		ADD	R9
		MOVE	R1,R0		;(R1) <-- display eye Y pos
		SUB	R4
		BCS	SLIMS170	;Y pos over ? ( yes:SLIMS170 )
		SUB	R0		;[ IBT R0,#00 ]
;
		FROM	R7
		ADD	R1
		ADD	R1
		LDW	(R0)
		SUB	R8
		NOT
		INC	R0
SLIMS170
		ADD	R2
		SMS	R0,CWORK7	;(CWK7) <-- calculate eye X pos
;
;-------------- player cross check --------------------------------------
		IWT	R0,#SLIM_BGP	;(CWK10) <-- BG check point data pointer
		SMS	R0,CWORK10
;
BG3_CROSS_CK	EQU	$
;;;;		    mJSR_X  BG3PCROS	    ;[ return: (R5) <-- 0B2H ]
		mJSR_X	BG3PCROS	;[ return: (R5) <-- 0D2H ]
		CACHE
;
;-------------- VS enemy cross check ------------------------------------
		IWT	R1,#CENMODE	;(R1)  <-- enemy mode pointer
;;;;		    IWT	    R2,#CENMOD0+1   ;(R2)  <--	 "   cross check ok flag pointer
		IWT	R2,#CENSHOT	;(R2)  <--   "   cross check ok flag pointer
		IWT	R3,#CECENTX	;(R3)  <--   "   cross check center pos pointer
		IWT	R0,#CENCRPT
		LMS	R4,CWORK9
		ADD	R4
		LDB	(R0)
		ADD	R0
		TO	R4		;(R4)  <-- slime cross check start point
		ADD	R0
		LM	R10,CESCCH1	;(R10) <-- scroll counter_H
		IBT	R12,#CENNO	;(R12) <-- loop no
		LM	R0,CESCCV1
		TO	R11		;(R11) <--	  "      _V
		ADD	#8
;
		CACHE
;
		IWT	R13,#SLIMS180+1
SLIMS180
		WITH	R4
		SUB	#4
		BPL	SLIMS190	;cross check index over ? ( no:SLIMS190 )
		FROM	R1
;
		IBT	R4,#(CENNO-1)*4
		FROM	R1
SLIMS190
		ADD	R4
		LDB	(R0)
		SUB	#CEFAIL
		BCC	SLIMS210	;cross check ok mode ? ( no:SLIMS210 )
		FROM	R2
;
		ADD	R4
		LDW	(R0)
;;;;		    AND	    #02H
		SUB	#0
		BEQ	SLIMS210	;cross check ok ? ( no:SLIMS210 )
		FROM	R3
;
		ADD	R4
		TO	R14
		LDW	(R0)
		WITH	R14		;(R14) <-- display cross check center X pos
		SUB	R10
		INC	R0
		INC	R0
		LDW	(R0)
		SUB	R11
		SUB	R5
		BCS	SLIMS210	;Y pos over ? ( yes:SLIMS210 )
		ADD	R5
;
		MOVE	R9,R0		;(R9) <-- display cross check center Y pos
		ADD	R0		;x2
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#8+1
		TO	R8		;(R8) <-- now Y pos X wide
		LOB
;
		FROM	R7
		ADD	R9
		ADD	R9
		TO	R9
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R9
		SUB	R14
		MOVE	R14,R0		;(R14) <-- cross X wide
		BPL	SLIMS200
		NOP
;
		NOT
		INC	R0
SLIMS200
		ADD	R0		;x2
		SUB	R8
		BCC	SLIMS230	;cross ? ( yes:SLIMS230 )
		NOP
;
SLIMS210
		LOOP
		WITH	R4		;[ dummy ]
;
;-------------- not cross !! ------------------------------------
SLIMS220
		LMS	R0,CWORK9
		IWT	R1,#CECRSFG
		TO	R1
		ADD	R1
		SUB	R0		;[ IBT R0,#00 ]
		STB	(R1)
		BRA	SLIMS240+1
		LMS	R0,CWORK0	;[ dummy ]
;
;-------------- cross !! ----------------------------------------
SLIMS230
		LMS	R1,CWORK9
		IWT	R0,#CECROSX	;ՓˌZbg
		ADD	R1
		WITH	R14
		NOT
		INC	R14
		FROM	R14
		STW	(R0)
		IWT	R0,#CENCRPT
		TO	R2
		ADD	R1
		FROM	R4
		LSR
		LSR
		STB	(R2)		;slime cross check next start point set
		IWT	R0,#CECRSFG
		ADD	R1
		INC	R4
		FROM	R4
		STB	(R0)		;cross enemy index set
;
;-------------- BG check ------------------------------------------------
SLIMS240
		LMS	R0,CWORK0
		LM	R10,CESCCH1
		TO	R10		;(R10) <-- center X pos
		ADD	R10
		LMS	R9,CWORK9
		mLDW0	CENBGYP,R9
		LMS	R9,CWORK1
		ADD	R9
		LM	R9,CESCCV1
		TO	R9		;(R9) <-- center Y pos
		ADD	R9
		LMS	R12,CWORK2	;(R12) <-- X zoom flag
		LMS	R13,CWORK3	;(R13) <-- Y	"
;
		IBT	R0,#BANK SLIM_BGP
		ROMB
		LMS	R14,CWORK10	;(R14) <-- BG check point data pointer
;
;-------------- up left point BG check --------------------------
		IBT	R2,#00		;(R2) <-- BG cross flag
;
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#AL
		BEQ	SLIMS250	;BG cross ? ( no:SLIMS250 )
		NOP
;
		INC	R2
;
;-------------- up right point BG check -------------------------
SLIMS250
		WITH	R2
		ADD	R2
;
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#AL
		BEQ	SLIMS260	;BG cross ? ( no:SLIMS260 )
		NOP
;
		INC	R2
;
;-------------- low left point BG check -------------------------
SLIMS260
		WITH	R2
		ADD	R2
;
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#AL
		BEQ	SLIMS270	;BG cross ? ( no:SLIMS270 )
		NOP
;
		INC	R2
;
;-------------- low right point BG check ------------------------
SLIMS270
		WITH	R2
		ADD	R2
;
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#AL
		BEQ	SLIMS280	;BG cross ? ( no:SLIMS280 )
		NOP
;
		INC	R2
;
;-------------- hed point BG check ------------------------------
SLIMS280
		WITH	R2
		ADD	R2
;
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#AL
		BEQ	SLIMS290	;BG cross ? ( no:SLIMS290 )
		NOP
;
		INC	R2
;
SLIMS290
		LMS	R0,CWORK1	;(CWK10) <-- hed BG check Y pos
		SMS	R0,CWORK10
;
;-------------- foot point BG check -----------------------------
		WITH	R2
		ADD	R2
;
		IWT	R13,#0100H	;(R13) <-- Y zoom cancel !!
		mJSR_X	SLM_EBGSUB
		GETB
;
		AND	#MD+AL
		BEQ	SLIMS300	;BG cross ? ( no:SLIMS300 )
		NOP
;
		INC	R2
;
SLIMS300
		IWT	R0,#CENCBFG
		LMS	R1,CWORK9
		ADD	R1
		FROM	R2
		STW	(R0)		;BG cross flag set
;
		SUB	R0		;<<< END >>>
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		slime BG point address calculate sub			-
;------------------------------------------------------------------------
SLM_EBGSUB
		INC	R14
		SWAP
		MOVE	R6,R12		;(R6) <-- X zoom flag
		FMULT
		TO	R8		;(R8) <-- BG check point X pos
		ADD	R10
;
		GETB
		INC	R14
		SWAP
		MOVE	R6,R13		;(R6) <-- Y zoom flag
		FMULT
		ADD	R9
		MOVE	R7,R0		;(R7) <-- BG check point Y pos
;
		LM	R6,CESCCV1
		SUB	R6
		SUB	#8
;;;;		    IWT	    R6,#0B2H
		IWT	R6,#0D2H
		CMP	R6
		BCS	SLM_EBSB010	;Y pos over ? ( yes:SLM_EBSB010 )
		FROM	R8
;
		IWT	R6,#HDMABF1
		ADD	R0
		ADD	R6
		TO	R6
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R6
		LMS	R6,CWORK12
		SUB	R6
		ADD	R8
		MOVE	R8,R0
SLM_EBSB010
		MOVE	R0,R7
		IWT	R15,#BGUNIT_READ_2+1 ;[ JMP BGUNIT_READ_2+1 ]
		TO	R7		;[ dummy ]
;
;------------------------------------------------------------------------
;-		BG3 player cross check					-
;-			in  : (R0)   <-- size AND data			-
;-			      (CWKA) <-- player display X pos		-
;-			      (CWKB) <--	"       Y  "		-
;-			      (CWKC) <--    "   sit down flag           -
;-									-
;-			out : (CWKD) <--    "   cross flag              -
;-						[ 00011111B ]		-
;-						     +++++- foot	-
;-						     |||+-- down right	-
;-						     ||+---   "  left   -
;-						     |+---- up	 right	-
;-						     +-----   "  left   -
;-			      (CWKE) <-- player foot hosei dot		-
;-			      (CWKF) <--      "      cross saka flag    -
;-						0,5,4,9:not saka	-
;-						1,6    :67.5		-
;-						2,7    :45		-
;-						3,8    :22.5		-
;------------------------------------------------------------------------
BG3PCROS	EQU	$
		IWT	R0,#0FFH	;(R0) <-- size AND data
;
BG3PCROS2	EQU	$
		SMS	R11,RTS0	;return address save
		MOVE	R11,R0		;(R11) <-- size AND data
;
		IBT	R0,#BANK SLIM_PLC
		ROMB
		IWT	R14,#SLIM_PLC	;(R14) <-- player cross check point data pointer
		LMS	R0,CWORKC
		SUB	#0
		BEQ	B3PCR000	;sit down player ? ( no:B3PCR000 )
		WITH	R14
;
		ADD	#5*2
B3PCR000
		LMS	R1,CWORKA	;(R1) <-- player display X pos
		LMS	R0,CWORKB	;(R0) <--	 "       Y  "
B3PCR010
		TO	R2		;(R2) <-- to buffer player display Y pos
		SUB	#8
;
;;;;		    IWT	    R5,#0B2H	    ;(R5)  <-- max Y pos
		IWT	R5,#0D2H	;(R5)  <-- max Y pos
		IWT	R6,#HDMABF	;(R6)  <-- X wide H-DMA buffer address
		IWT	R7,#HDMABF1	;(R7)  <-- scroll counter_H H-DMA buffer address
;
		IWT	R3,#080H	;(R3)  <-- scroll counter_H H-DMA data check data
		IBT	R10,#00		;(R10) <-- cross point flag
;
		IBT	R12,#5
		IWT	R13,#B3PCR020+1
B3PCR020
		WITH	R10
		ADD	R10		;[ ASL ] cross point flag pos change
;
		GETBS
		INC	R14
		TO	R4		;(R4) <-- check point dispaly X pos
		ADD	R1
;
		GETBS
		INC	R14
		ADD	R2
		SUB	R5
		BCS	B3PCR040	;Y pos over ? ( yes:B3PCR040 )
		ADD	R5
;
		MOVE	R9,R0		;(R9) <-- check point dispaly Y pos
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		AND	R11
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		BPL	B3PCR030
		NOP
;
		NOT
		INC	R0
B3PCR030
		ADD	R0		;x2
		SUB	R8
		BCS	B3PCR040	;cross ? ( no:B3PCR040 )
		NOP
;
;-------------- cross !! --------------------------------
		INC	R10		;cross point flag set !!
B3PCR040
		LOOP
		WITH	R10		;[ dummy ]
;
		SMS	R10,CWORKA	;cross point flag set
;
;-------------- player foot pos hosei dot check -----------------
		FROM	R10
		LSR
		BCC	B3PCR110	;foot cross ? ( no:B3PCR110 )
		SUB	R0		;[ IBT R0,#00 ]
;
		MOVE	R1,R0		;(R1) <-- player hosei dot
B3PCR050
		DEC	R9
		BMI	B3PCR070	;Y pos over ? ( yes:B3PCR070 )
		FROM	R1
;
		ADD	#0AH
		BMI	B3PCR070	;hosei dot over ? ( yes:B3PCR070 )
		FROM	R9
;
		ADD	R9
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		AND	R11
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		MOVE	R2,R0		;(R2) <-- cross muki
		BPL	B3PCR060
		NOP
;
		NOT
		INC	R0
B3PCR060
		ADD	R0		;x2
		SUB	R8
		BCC	B3PCR050	;cross ? ( yes:B3PCR050 )
		DEC	R1
;
B3PCR070
		SMS	R1,CWORKB	;foot hosei dot
;
		FROM	R9
		ADD	#2
		CMP	R5
		BCS	B3PCR080	;Y pos over ? ( yes:B3PCR080 )
		FROM	R8
;
		FROM	R0
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		AND	R11		;(R0) <-- now Y pos X wide
B3PCR080
		SUB	R8
		LSR
		IBT	R3,#4
		CMP	R3
		BCC	B3PCR090
		NOP
;
		MOVE	R0,R3
B3PCR090
		MOVES	R2,R2
		BPL	B3PCR100
		NOP
;
		ADD	#5
B3PCR100
		ADD	R0		;x2
		SMS	R0,CWORKC	;saka angle data pointer
;
B3PCR110
		IWT	R0,#SLIM_BAC
		SUB	R14
		BCC	B3PCR120	;Ԃ`FbNH ( yes:B3PCR120 )
		TO	R14
;
		ADD	R14
;
		LMS	R0,CWORKA	;vC[Zbg
		SMS	R0,CWORKD
		LMS	R0,CWORKB
		SMS	R0,CWORKE
		LMS	R0,CWORKC
		SMS	R0,CWORKF
;
		LMS	R0,CDEATHCT0
		SUB	#0
		BEQ	B3PCR112	;Ԃ񎀐_ɎčsꂽH ( no:B3PCR112 )
		SUB	R0		;[ IBT R0,#0 ]
;
		SMS	R0,CWORKA	;cross point flag reset
		BRA	B3PCR120
		NOP
;
B3PCR112
		LM	R1,CENDSXL	;(R1) <-- Ԃ\wW
		LM	R0,CENDSYL	;(R0) <--      h     x h
		mDJMP_X B3PCR010+1
		TO	R2
;
B3PCR120
		LMS	R11,RTS0
		mRTS
;
;************************************************************************
;*		slime BG check point data				*
;************************************************************************
SLIM_BGP
		HEX	EA,C0	;[ up  left  ]
		HEX	0E,C0	;[ up  right ]
		HEX	E0,F0	;[ low left  ]
		HEX	18,F0	;[ low right ]
		HEX	00,B0	;[    hed    ]
		HEX	00,00	;[    foot   ]
;
;************************************************************************
;*		player cross check point data				*
;************************************************************************
SLIM_PLC
		HEX	02,04	;[big]	[ left.1  ]
		HEX	0E,04	;	[ right.1 ]
		HEX	02,14	;	[ left.1  ]
		HEX	0E,14	;	[ right.1 ]
		HEX	08,20	;	[ foot	  ]
;
		HEX	02,12	;[sit]	[ left.1  ]
		HEX	0E,12	;	[ right.1 ]
		HEX	02,14	;	[ left.1  ]
		HEX	0E,14	;	[ right.1 ]
		HEX	08,20	;	[ foot	  ]
;
;-------------- Ԃ`FbN|Cgf[^ --------------------------
SLIM_BAC
		HEX	02,02	;	[ left.1  ]
		HEX	0E,02	;	[ right.1 ]
		HEX	02,0A	;	[ left.1  ]
		HEX	0E,0A	;	[ right.1 ]
		HEX	08,10	;	[ foot	  ]
;
;************************************************************************
;*		slime data						*
;************************************************************************
EGG_DATA
		BYTE	060H
		BYTE	000H,016H,01FH,026H,02CH,031H,036H,03AH
		BYTE	03DH,041H,044H,047H,04AH,04DH,04FH,052H
		BYTE	054H,056H,058H,05BH,05CH,05EH,060H,062H
		BYTE	063H,065H,066H,068H,069H,06BH,06CH,06DH
		BYTE	06EH,06FH,071H,072H,073H,074H,074H,075H
		BYTE	076H,077H,078H,078H,079H,07AH,07AH,07BH
		BYTE	07BH,07CH,07CH,07DH,07DH,07EH,07EH,07EH
		BYTE	07EH,07FH,07FH,07FH,07FH,07FH,07FH,07FH
;
		BYTE	07FH,07FH,07FH,07EH,07EH,07DH,07CH,07BH
		BYTE	07AH,079H,078H,076H,074H,073H,071H,06EH
		BYTE	06CH,069H,066H,063H,060H,05CH,058H,054H
		BYTE	04FH,04AH,044H,03DH,036H,02CH,01FH,000H
;
;************************************************************************
;*		slime appear data					*
;************************************************************************
KIRE_DATA
		BYTE	000H,000H,000H,000H,001H,002H,003H,004H
		BYTE	006H,008H,00AH,00CH,00EH,010H,013H,016H
		BYTE	019H,01CH,020H,024H,028H,02CH,030H,034H
		BYTE	039H,03EH,043H,048H,04EH,054H,05AH,060H
		BYTE	066H,06CH,073H,07AH
;
;
;************************************************************************
;*		BG3 change						*
;*			in  : (R1)   <-- from data address		*
;*			      (R2)   <-- to data address		*
;*			      (R3)   <-- counter			*
;*			      (R4)   <-- base Y pos			*
;*			      (R5)   <--   "  X  "			*
;*			      (CWKA) <-- player display X pos		*
;*			      (CWKB) <--	"       Y  "		*
;*			      (CWKC) <--    "   sit down flag           *
;*									*
;*			out : (CWKD) <--    "   cross flag              *
;*						[ 00011111B ]		*
;*						     +++++- foot	*
;*						     |||+-- down right	*
;*						     ||+---   "  left   *
;*						     |+---- up	 right	*
;*						     +-----   "  left   *
;*			      (CWKE) <-- player foot hosei dot		*
;*			      (CWKF) <--      "      cross saka flag    *
;*						0,5,4,9:not saka	*
;*						1,6    :67.5		*
;*						2,7    :45		*
;*						3,8    :22.5		*
;************************************************************************
;
BG3CHNG		EQU	$
		IBT	R0,#BANK BG3CHNG
		ROMB
;
		SMS	R5,CWORK2		;(CWK2) <-- base X pos
;
		WITH	R4			;(R4) <-- base Y pos hosei
		SUB	#8
;;;;		    IWT	    R5,#0B2H-1		    ;(R5) <-- now set V pos
		IWT	R5,#0D2H-1		 ;(R5) <-- now set V pos
;;;;		    IWT	    R9,#HDMABF+((0B2H-1)*2)  ;(R9) <-- wide set buffer bottom pointer
		IWT	R9,#HDMABF+((0D2H-1)*2)	 ;(R9) <-- wide set buffer bottom pointer
;;;;		    IWT	    R7,#HDMABF1+((0B2H-1)*2) ;(R7) <-- scrool counter_H set buffer bottom pointer
		IWT	R7,#HDMABF1+((0D2H-1)*2) ;(R7) <-- scrool counter_H set buffer bottom pointer
;
		CACHE
;
;-------------- lower clear area set ----------------------------
		FROM	R5
		TO	R12
		SUB	R4
		BPL	B3CG000		;lower clear area nothing ? ( no:B3CG000 )
		FROM	R12
;
		NOT
		INC	R0
		TO	R5
		ADD	R5
		BRA	B3CG020+1
		MOVE	R14,R1		;[ dummy ]
;
B3CG000
		SUB	R5
		BCC	B3CG002		;all clear ? ( no:B3CG002 )
		INC	R12
;
		IWT	R15,#B3CG050+1	;[ JMP B3CG050 ]
		INC	R5		;[ dummy ]
;
B3CG002
		WITH	R5
		SUB	R12
		FROM	R7
		SUB	R12
		TO	R7
		SUB	R12
;;;;		    IWT	    R0,#-0B2H-8
		IWT	R0,#-0D2H-8
		MOVE	R13,R15
B3CG010
		STW	(R9)
		DEC	R9
		DEC	R9
		LOOP
		INC	R0
;
;-------------- change area set ---------------------------------
B3CG020
		MOVE	R14,R1
		INC	R1
		IWT	R10,#DIVBUF	;(R10) <-- div data pointer
		MOVE	R6,R3		;(R6) <-- bairitsu
		TO	R4		;(R4) <-- data.1 high
		GETB
		MOVE	R14,R2
		INC	R2
		TO	R8		;(R8) <-- data.2 high
		GETB
		FROM	R8
		SUB	R4
		SWAP
		FMULT
		ADC	R4
		MOVES	R12,R0		;(R12) <-- loop no. ( data high )
		BEQ	B3CG050
		ADD	R0		;[ ASL ]
;
		ADD	R10
		TO	R6
		LDW	(R0)
		FROM	R4
		SWAP
		FMULT
		TO	R4		;(R4) <-- data.1 step
		ADC	#0
		FROM	R8
		SWAP
		FMULT
		TO	R8		;(R8) <-- data.2 step
		ADC	#0
;
;;;;		    IWT	    R0,#CHNGSTEP
;;;;		    ADD	    R3
;;;;		    TO	    R14
;;;;		    ADD	    R3
;;;;		    TO	    R6
;;;;		    GETB
;;;;		    INC	    R14
		MOVE	R6,R3		;(R6) <-- bairitsu
		IBT	R10,#00		;(R10) <-- data.1 add pointer
		MOVE	R11,R10		;(R11) <-- data.2      "
;;;;		    WITH    R6
;;;;		    GETBH
;
		FROM	R5
		SUB	R12
		INC	R0
		BPL	B3CG022		;loop no over ? ( no:B3CG022 )
		TO	R12
;
		ADD	R12
B3CG022
;
		MOVE	R13,R15
B3CG030
;;;;		    IWT	    R0,#0B1H
		IWT	R0,#0B2H-1
		SUB	R5
		BMI	B3CG040		;set ok area ? ( no:B3CG040 )
		FROM	R10
;
		HIB
		ADD	R0		;[ ASL ]
		TO	R14
		ADD	R1
		GETBS
		INC	R14
		SMS	R0,CWORK0	;(WK0) <-- no.1 data ( center pos )
		TO	R3		;(R3)  <--	"    ( wide )
		GETB
;
		FROM	R11
		HIB
		ADD	R0		;[ ASL ]
		TO	R14
		ADD	R2
		GETBS
		INC	R14
		SMS	R0,CWORK1	;(WK1) <-- no.2 data ( center pos )
		GETB			;(R0)  <--	"    ( wide )
;
		SUB	R3
		SWAP
		FMULT
		ADC	R3
		SUB	R5
		SUB	#8
		STW	(R9)		;wide data set
;
		LMS	R3,CWORK0
		LMS	R0,CWORK1
		SUB	R3
		SWAP
		FMULT
		ADC	R3
		LMS	R3,CWORK2
		ADD	R3
		STW	(R7)		;scroll counter_H set
;
		DEC	R9
		DEC	R9
		DEC	R7
		DEC	R7
B3CG040
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R8
		LOOP
		DEC	R5
;
		BMI	B3CG070		;end ? ( yes:B3CG070 )
;
;-------------- clear area set ----------------------------------
B3CG050
		INC	R5
;
;;;;		    IWT	    R0,#0B2H
		IWT	R0,#0D2H
		SUB	R5
		BPL	B3CG052		;set buffer over ? ( no:B3CG052 )
		TO	R5
;
		ADD	R5
B3CG052
		MOVE	R12,R5
		FROM	R5
		NOT
		SUB	#8-1
		MOVE	R13,R15
B3CG060
		STW	(R9)
		DEC	R9
		DEC	R9
		LOOP
		INC	R0
;
BG3_PLCROSCK	EQU	$
B3CG070
		mJSR_X	BG3PCROS
		CACHE
;
		STOP
		NOP
;
;;;;;------------------------------------------------------------------------
;;;;;-	    change step data						    -
;;;;;------------------------------------------------------------------------
;;;;CHNGSTEP	    EQU	    $
;;;;		    WORD    0000H,0000H,0000H,0000H,0000H,0000H,0000H,0000H
;;;;		    WORD    0001H,0001H,0001H,0001H,0001H,0002H,0002H,0002H
;;;;		    WORD    0002H,0003H,0003H,0003H,0004H,0004H,0005H,0005H
;;;;		    WORD    0006H,0006H,0006H,0007H,0007H,0008H,0009H,0009H
;;;;		    WORD    000AH,000AH,000BH,000CH,000CH,000DH,000EH,000EH
;;;;		    WORD    000FH,0010H,0011H,0011H,0012H,0013H,0014H,0015H
;;;;		    WORD    0016H,0016H,0017H,0018H,0019H,001AH,001BH,001CH
;;;;		    WORD    001DH,001EH,001FH,0020H,0021H,0022H,0023H,0024H
;;;;		    WORD    0025H,0027H,0028H,0029H,002AH,002BH,002CH,002EH
;;;;		    WORD    002FH,0030H,0031H,0032H,0034H,0035H,0036H,0038H
;;;;		    WORD    0039H,003AH,003CH,003DH,003EH,0040H,0041H,0042H
;;;;		    WORD    0044H,0045H,0046H,0048H,0049H,004BH,004CH,004EH
;;;;		    WORD    004FH,0050H,0052H,0053H,0055H,0056H,0058H,0059H
;;;;		    WORD    005BH,005CH,005EH,005FH,0061H,0062H,0064H,0065H
;;;;		    WORD    0067H,0069H,006AH,006CH,006DH,006FH,0070H,0072H
;;;;		    WORD    0073H,0075H,0077H,0078H,007AH,007BH,007DH,007EH
;;;;		    WORD    0080H,0082H,0083H,0085H,0086H,0088H,0089H,008BH
;;;;		    WORD    008DH,008EH,0090H,0091H,0093H,0094H,0096H,0097H
;;;;		    WORD    0099H,009BH,009CH,009EH,009FH,00A1H,00A2H,00A4H
;;;;		    WORD    00A5H,00A7H,00A8H,00AAH,00ABH,00ADH,00AEH,00B0H
;;;;		    WORD    00B1H,00B2H,00B4H,00B5H,00B7H,00B8H,00BAH,00BBH
;;;;		    WORD    00BCH,00BEH,00BFH,00C0H,00C2H,00C3H,00C4H,00C6H
;;;;		    WORD    00C7H,00C8H,00CAH,00CBH,00CCH,00CEH,00CFH,00D0H
;;;;		    WORD    00D1H,00D2H,00D4H,00D5H,00D6H,00D7H,00D8H,00D9H
;;;;		    WORD    00DBH,00DCH,00DDH,00DEH,00DFH,00E0H,00E1H,00E2H
;;;;		    WORD    00E3H,00E4H,00E5H,00E6H,00E7H,00E8H,00E9H,00EAH
;;;;		    WORD    00EAH,00EBH,00ECH,00EDH,00EEH,00EFH,00EFH,00F0H
;;;;		    WORD    00F1H,00F2H,00F2H,00F3H,00F4H,00F4H,00F5H,00F6H
;;;;		    WORD    00F6H,00F7H,00F7H,00F8H,00F9H,00F9H,00FAH,00FAH
;;;;		    WORD    00FAH,00FBH,00FBH,00FCH,00FCH,00FDH,00FDH,00FDH
;;;;		    WORD    00FEH,00FEH,00FEH,00FEH,00FFH,00FFH,00FFH,00FFH
;;;;		    WORD    00FFH,0100H,0100H,0100H,0100H,0100H,0100H,0100H
;;;;		    WORD    0100H
;
;;;;;------------------------------------------------------------------------
;;;;;-		    BG3 change data					    -
;;;;;------------------------------------------------------------------------
;;;;BG3KAGCL	    EQU	    $
;;;;		    HEX	    00
;;;;		    HEX	    00,01
;;;;;
;;;;BG3KAG00	    EQU	    $
;;;;		    HEX	    03
;;;;		    HEX	    00,10
;;;;		    HEX	    00,0C
;;;;		    HEX	    00,08
;;;;;
;;;;BG3KAG01	    EQU	    $
;;;;		    HEX	    10
;;;;		    HEX	    00,10
;;;;		    HEX	    FF,0E
;;;;		    HEX	    FE,0D
;;;;		    HEX	    FD,0F
;;;;		    HEX	    FD,0E
;;;;		    HEX	    FC,0F
;;;;		    HEX	    FC,0E
;;;;		    HEX	    FC,0E
;;;;		    HEX	    FB,0F
;;;;		    HEX	    FB,0F
;;;;		    HEX	    FB,0F
;;;;		    HEX	    FC,0E
;;;;		    HEX	    FB,0D
;;;;		    HEX	    FB,0D
;;;;		    HEX	    FC,0B
;;;;		    HEX	    FC,08
;;;;;
;;;;BG3KAG02	    EQU	    $
;;;;		    HEX	    20
;;;;		    HEX	    00,10
;;;;		    HEX	    00,0F
;;;;		    HEX	    01,0F
;;;;		    HEX	    02,0E
;;;;		    HEX	    02,0F
;;;;		    HEX	    02,0F
;;;;		    HEX	    02,0F
;;;;		    HEX	    02,0F
;;;;		    HEX	    02,0E
;;;;		    HEX	    02,0E
;;;;		    HEX	    01,0F
;;;;		    HEX	    00,0F
;;;;		    HEX	    00,10
;;;;		    HEX	    FF,11
;;;;		    HEX	    FF,12
;;;;		    HEX	    FE,14
;;;;		    HEX	    FD,16
;;;;		    HEX	    FD,18
;;;;		    HEX	    FD,19
;;;;		    HEX	    FD,1B
;;;;		    HEX	    FD,1B
;;;;		    HEX	    FE,1C
;;;;		    HEX	    FE,1D
;;;;		    HEX	    FE,1D
;;;;		    HEX	    FF,1D
;;;;		    HEX	    FF,1D
;;;;		    HEX	    00,1C
;;;;		    HEX	    00,1B
;;;;		    HEX	    01,18
;;;;		    HEX	    01,15
;;;;		    HEX	    03,10
;;;;		    HEX	    03,0C
;;;;;
;;;;BG3KAG03	    EQU	    $
;;;;		    HEX	    30
;;;;		    HEX	    00,10
;;;;		    HEX	    FE,13
;;;;		    HEX	    FC,15
;;;;		    HEX	    FB,15
;;;;		    HEX	    FB,15
;;;;		    HEX	    FB,14
;;;;		    HEX	    FB,14
;;;;		    HEX	    FB,14
;;;;		    HEX	    FB,14
;;;;		    HEX	    FB,14
;;;;		    HEX	    FC,14
;;;;		    HEX	    FC,14
;;;;		    HEX	    FC,16
;;;;		    HEX	    FC,17
;;;;		    HEX	    FC,19
;;;;		    HEX	    FC,1B
;;;;		    HEX	    FC,1D
;;;;		    HEX	    FC,1F
;;;;		    HEX	    FD,20
;;;;		    HEX	    FC,21
;;;;		    HEX	    FC,21
;;;;		    HEX	    FD,22
;;;;		    HEX	    FD,22
;;;;		    HEX	    FD,21
;;;;		    HEX	    FE,22
;;;;		    HEX	    FE,23
;;;;		    HEX	    FF,23
;;;;		    HEX	    01,26
;;;;		    HEX	    02,27
;;;;		    HEX	    03,28
;;;;		    HEX	    03,27
;;;;		    HEX	    04,27
;;;;		    HEX	    04,27
;;;;		    HEX	    05,26
;;;;		    HEX	    05,26
;;;;		    HEX	    05,25
;;;;		    HEX	    05,25
;;;;		    HEX	    05,25
;;;;		    HEX	    05,24
;;;;		    HEX	    05,22
;;;;		    HEX	    05,20
;;;;		    HEX	    04,1F
;;;;		    HEX	    04,1B
;;;;		    HEX	    05,18
;;;;		    HEX	    06,12
;;;;		    HEX	    06,10
;;;;		    HEX	    06,0D
;;;;		    HEX	    06,09
;;;;;
;;;;BG3KAG04	    EQU	    $
;;;;		    HEX	    48
;;;;		    HEX	    00,11
;;;;		    HEX	    01,13
;;;;		    HEX	    02,14
;;;;		    HEX	    02,15
;;;;		    HEX	    02,15
;;;;		    HEX	    03,15
;;;;		    HEX	    03,15
;;;;		    HEX	    04,15
;;;;		    HEX	    04,15
;;;;		    HEX	    05,16
;;;;		    HEX	    05,16
;;;;		    HEX	    05,16
;;;;		    HEX	    04,17
;;;;		    HEX	    04,17
;;;;		    HEX	    04,17
;;;;		    HEX	    03,17
;;;;		    HEX	    03,17
;;;;		    HEX	    03,18
;;;;		    HEX	    02,18
;;;;		    HEX	    02,18
;;;;		    HEX	    02,1A
;;;;		    HEX	    01,1B
;;;;		    HEX	    01,1B
;;;;		    HEX	    01,1C
;;;;		    HEX	    01,1E
;;;;		    HEX	    01,20
;;;;		    HEX	    01,23
;;;;		    HEX	    01,25
;;;;		    HEX	    02,26
;;;;		    HEX	    01,27
;;;;		    HEX	    01,28
;;;;		    HEX	    01,29
;;;;		    HEX	    01,2A
;;;;		    HEX	    01,2A
;;;;		    HEX	    00,2C
;;;;		    HEX	    FF,2C
;;;;		    HEX	    FE,2D
;;;;		    HEX	    FE,2E
;;;;		    HEX	    FE,2E
;;;;		    HEX	    FE,30
;;;;		    HEX	    FE,30
;;;;		    HEX	    FF,32
;;;;		    HEX	    FF,33
;;;;		    HEX	    00,34
;;;;		    HEX	    00,34
;;;;		    HEX	    00,33
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,32
;;;;		    HEX	    01,31
;;;;		    HEX	    02,2F
;;;;		    HEX	    03,2C
;;;;		    HEX	    04,2A
;;;;		    HEX	    04,29
;;;;		    HEX	    04,29
;;;;		    HEX	    03,29
;;;;		    HEX	    03,29
;;;;		    HEX	    03,28
;;;;		    HEX	    03,28
;;;;		    HEX	    02,27
;;;;		    HEX	    02,24
;;;;		    HEX	    02,22
;;;;		    HEX	    02,20
;;;;		    HEX	    02,1E
;;;;		    HEX	    02,1D
;;;;		    HEX	    03,1A
;;;;		    HEX	    04,16
;;;;		    HEX	    03,11
;;;;;
;;;;BG3KAG05	    EQU	    $
;;;;		    HEX	    68
;;;;		    HEX	    00,10
;;;;		    HEX	    FF,11
;;;;		    HEX	    FF,13
;;;;		    HEX	    FF,14
;;;;		    HEX	    FF,14
;;;;		    HEX	    FE,15
;;;;		    HEX	    FE,16
;;;;		    HEX	    FD,17
;;;;		    HEX	    FE,18
;;;;		    HEX	    FD,19
;;;;		    HEX	    FD,1A
;;;;		    HEX	    FD,1A
;;;;		    HEX	    FD,1B
;;;;		    HEX	    FD,1C
;;;;		    HEX	    FD,1D
;;;;		    HEX	    FE,1E
;;;;		    HEX	    FD,1F
;;;;		    HEX	    FE,20
;;;;		    HEX	    FE,20
;;;;		    HEX	    FE,22
;;;;		    HEX	    FE,22
;;;;		    HEX	    FD,23
;;;;		    HEX	    FE,24
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,24
;;;;		    HEX	    FD,24
;;;;		    HEX	    FD,24
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FD,25
;;;;		    HEX	    FE,25
;;;;		    HEX	    FE,25
;;;;		    HEX	    FF,24
;;;;		    HEX	    FF,25
;;;;		    HEX	    00,24
;;;;		    HEX	    01,24
;;;;		    HEX	    01,23
;;;;		    HEX	    01,23
;;;;		    HEX	    02,23
;;;;		    HEX	    04,26
;;;;		    HEX	    05,26
;;;;		    HEX	    05,27
;;;;		    HEX	    06,28
;;;;		    HEX	    06,28
;;;;		    HEX	    06,28
;;;;		    HEX	    06,29
;;;;		    HEX	    06,29
;;;;		    HEX	    06,29
;;;;		    HEX	    06,2A
;;;;		    HEX	    06,2A
;;;;		    HEX	    05,2B
;;;;		    HEX	    05,2A
;;;;		    HEX	    04,2B
;;;;		    HEX	    04,2B
;;;;		    HEX	    04,2B
;;;;		    HEX	    04,2C
;;;;		    HEX	    04,2E
;;;;		    HEX	    04,31
;;;;		    HEX	    04,33
;;;;		    HEX	    04,34
;;;;		    HEX	    04,36
;;;;		    HEX	    03,38
;;;;		    HEX	    02,3A
;;;;		    HEX	    01,3B
;;;;		    HEX	    01,3C
;;;;		    HEX	    01,3C
;;;;		    HEX	    00,3D
;;;;		    HEX	    00,3D
;;;;		    HEX	    00,3D
;;;;		    HEX	    00,3E
;;;;		    HEX	    00,3E
;;;;		    HEX	    00,3E
;;;;		    HEX	    FF,3E
;;;;		    HEX	    FF,3E
;;;;		    HEX	    FF,3E
;;;;		    HEX	    FE,3D
;;;;		    HEX	    FE,3D
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FE,3A
;;;;		    HEX	    FE,3A
;;;;		    HEX	    FD,39
;;;;		    HEX	    FD,37
;;;;		    HEX	    FD,36
;;;;		    HEX	    FC,35
;;;;		    HEX	    FC,33
;;;;		    HEX	    FC,31
;;;;		    HEX	    FC,2F
;;;;		    HEX	    FC,2E
;;;;		    HEX	    FB,2B
;;;;		    HEX	    FB,29
;;;;		    HEX	    FB,25
;;;;		    HEX	    FB,21
;;;;		    HEX	    FA,1B
;;;;		    HEX	    FB,16
;;;;		    HEX	    FA,11
;;;;		    HEX	    F9,07
;;;;;
;;;;BG3KAG06	    EQU	    $
;;;;		    HEX	    7F
;;;;		    HEX	    00,10
;;;;		    HEX	    00,10
;;;;		    HEX	    FF,11
;;;;		    HEX	    FF,13
;;;;		    HEX	    FF,14
;;;;		    HEX	    FE,14
;;;;		    HEX	    FD,15
;;;;		    HEX	    FD,15
;;;;		    HEX	    FD,16
;;;;		    HEX	    FC,17
;;;;		    HEX	    FC,16
;;;;		    HEX	    FC,16
;;;;		    HEX	    FB,17
;;;;		    HEX	    FB,17
;;;;		    HEX	    FB,17
;;;;		    HEX	    FB,16
;;;;		    HEX	    FB,16
;;;;		    HEX	    FA,17
;;;;		    HEX	    FB,18
;;;;		    HEX	    FB,18
;;;;		    HEX	    FA,19
;;;;		    HEX	    FB,1A
;;;;		    HEX	    FA,1B
;;;;		    HEX	    FA,1C
;;;;		    HEX	    F9,1D
;;;;		    HEX	    F9,1F
;;;;		    HEX	    F9,21
;;;;		    HEX	    F9,21
;;;;		    HEX	    F9,23
;;;;		    HEX	    F9,25
;;;;		    HEX	    F9,26
;;;;		    HEX	    F9,26
;;;;		    HEX	    F9,28
;;;;		    HEX	    F9,28
;;;;		    HEX	    F9,2A
;;;;		    HEX	    F9,2B
;;;;		    HEX	    F9,2D
;;;;		    HEX	    FA,2E
;;;;		    HEX	    F9,2F
;;;;		    HEX	    FA,30
;;;;		    HEX	    FA,31
;;;;		    HEX	    FB,32
;;;;		    HEX	    FB,33
;;;;		    HEX	    FB,33
;;;;		    HEX	    FB,35
;;;;		    HEX	    FC,36
;;;;		    HEX	    FC,37
;;;;		    HEX	    FC,37
;;;;		    HEX	    FD,38
;;;;		    HEX	    FD,37
;;;;		    HEX	    FD,37
;;;;		    HEX	    FE,38
;;;;		    HEX	    FE,38
;;;;		    HEX	    FE,38
;;;;		    HEX	    FE,39
;;;;		    HEX	    FF,38
;;;;		    HEX	    FF,38
;;;;		    HEX	    FF,39
;;;;		    HEX	    00,38
;;;;		    HEX	    00,38
;;;;		    HEX	    00,37
;;;;		    HEX	    00,37
;;;;		    HEX	    01,36
;;;;		    HEX	    00,35
;;;;		    HEX	    01,34
;;;;		    HEX	    01,34
;;;;		    HEX	    01,33
;;;;		    HEX	    01,33
;;;;		    HEX	    01,33
;;;;		    HEX	    01,33
;;;;		    HEX	    02,32
;;;;		    HEX	    02,33
;;;;		    HEX	    02,33
;;;;		    HEX	    03,34
;;;;		    HEX	    03,34
;;;;		    HEX	    03,34
;;;;		    HEX	    03,35
;;;;		    HEX	    03,36
;;;;		    HEX	    03,36
;;;;		    HEX	    02,37
;;;;		    HEX	    02,37
;;;;		    HEX	    02,39
;;;;		    HEX	    02,3A
;;;;		    HEX	    01,3B
;;;;		    HEX	    01,3C
;;;;		    HEX	    01,3E
;;;;		    HEX	    01,3E
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,40
;;;;		    HEX	    FF,3F
;;;;		    HEX	    FF,3F
;;;;		    HEX	    FF,3F
;;;;		    HEX	    FF,3F
;;;;		    HEX	    FF,3F
;;;;		    HEX	    FF,3E
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FF,3A
;;;;		    HEX	    FE,39
;;;;		    HEX	    FF,38
;;;;		    HEX	    FE,37
;;;;		    HEX	    FF,36
;;;;		    HEX	    FF,35
;;;;		    HEX	    FF,35
;;;;		    HEX	    00,34
;;;;		    HEX	    00,33
;;;;		    HEX	    00,31
;;;;		    HEX	    01,30
;;;;		    HEX	    01,2E
;;;;		    HEX	    01,2C
;;;;		    HEX	    01,2B
;;;;		    HEX	    01,28
;;;;		    HEX	    01,26
;;;;		    HEX	    01,24
;;;;		    HEX	    01,21
;;;;		    HEX	    01,1D
;;;;		    HEX	    02,1A
;;;;		    HEX	    02,14
;;;;		    HEX	    01,0B
;;;;;
;;;;BG3KAG07	    EQU	    $
;;;;		    HEX	    7F
;;;;		    HEX	    00,10
;;;;		    HEX	    FF,11
;;;;		    HEX	    FF,12
;;;;		    HEX	    FE,12
;;;;		    HEX	    FD,13
;;;;		    HEX	    FD,14
;;;;		    HEX	    FC,15
;;;;		    HEX	    FC,16
;;;;		    HEX	    FB,19
;;;;		    HEX	    FB,1A
;;;;		    HEX	    FA,1D
;;;;		    HEX	    FA,1E
;;;;		    HEX	    FA,20
;;;;		    HEX	    FA,22
;;;;		    HEX	    F9,23
;;;;		    HEX	    F9,25
;;;;		    HEX	    FA,26
;;;;		    HEX	    FA,28
;;;;		    HEX	    F9,29
;;;;		    HEX	    FA,2A
;;;;		    HEX	    FA,2A
;;;;		    HEX	    FA,2C
;;;;		    HEX	    FA,2C
;;;;		    HEX	    F9,2D
;;;;		    HEX	    FA,2E
;;;;		    HEX	    FA,2E
;;;;		    HEX	    FA,2E
;;;;		    HEX	    FA,2E
;;;;		    HEX	    FA,2E
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FA,2F
;;;;		    HEX	    FB,2E
;;;;		    HEX	    FB,2E
;;;;		    HEX	    FB,2E
;;;;		    HEX	    FB,2E
;;;;		    HEX	    FB,2D
;;;;		    HEX	    FB,2D
;;;;		    HEX	    FC,2E
;;;;		    HEX	    FC,2D
;;;;		    HEX	    FC,2D
;;;;		    HEX	    FC,2D
;;;;		    HEX	    FC,2D
;;;;		    HEX	    FC,2D
;;;;		    HEX	    FD,2C
;;;;		    HEX	    FD,2C
;;;;		    HEX	    FD,2C
;;;;		    HEX	    FD,2C
;;;;		    HEX	    FD,2D
;;;;		    HEX	    FD,2D
;;;;		    HEX	    FD,2D
;;;;		    HEX	    FD,2D
;;;;		    HEX	    FE,2E
;;;;		    HEX	    FE,2E
;;;;		    HEX	    FE,2F
;;;;		    HEX	    FE,30
;;;;		    HEX	    FE,31
;;;;		    HEX	    FF,32
;;;;		    HEX	    FE,33
;;;;		    HEX	    FF,34
;;;;		    HEX	    FF,36
;;;;		    HEX	    FE,37
;;;;		    HEX	    FF,38
;;;;		    HEX	    FF,38
;;;;		    HEX	    FF,3A
;;;;		    HEX	    FF,3A
;;;;		    HEX	    FF,3B
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    00,3E
;;;;		    HEX	    00,3E
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    00,3F
;;;;		    HEX	    01,3E
;;;;		    HEX	    01,3E
;;;;		    HEX	    01,3C
;;;;		    HEX	    01,3C
;;;;		    HEX	    01,3B
;;;;		    HEX	    01,3B
;;;;		    HEX	    01,3A
;;;;		    HEX	    00,3B
;;;;		    HEX	    00,3B
;;;;		    HEX	    00,3C
;;;;		    HEX	    00,3C
;;;;		    HEX	    00,3C
;;;;		    HEX	    00,3C
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3D
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FF,3C
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FE,3B
;;;;		    HEX	    FE,3A
;;;;		    HEX	    FD,39
;;;;		    HEX	    FD,39
;;;;		    HEX	    FE,38
;;;;		    HEX	    FD,37
;;;;		    HEX	    FD,36
;;;;		    HEX	    FD,36
;;;;		    HEX	    FD,34
;;;;		    HEX	    FD,34
;;;;		    HEX	    FD,32
;;;;		    HEX	    FC,31
;;;;		    HEX	    FD,30
;;;;		    HEX	    FD,2E
;;;;		    HEX	    FD,2C
;;;;		    HEX	    FD,2A
;;;;		    HEX	    FD,26
;;;;		    HEX	    FD,24
;;;;		    HEX	    FE,20
;;;;		    HEX	    FE,1C
;;;;		    HEX	    FE,18
;;;;		    HEX	    FF,12
;;;;		    HEX	    FE,0D
;;;;;
;;;;BG3KAG08	    EQU	    $	    ;΂o
;;;;		    HEX	    5D
;;;;		    BYTE    013H,036H
;;;;		    BYTE    019H,043H
;;;;		    BYTE    01CH,049H
;;;;		    BYTE    020H,050H
;;;;		    BYTE    021H,053H
;;;;		    BYTE    024H,057H
;;;;		    BYTE    026H,05AH
;;;;		    BYTE    026H,05BH
;;;;		    BYTE    028H,05CH
;;;;		    BYTE    028H,05DH
;;;;		    BYTE    02AH,05EH
;;;;		    BYTE    02AH,05FH
;;;;		    BYTE    02BH,05FH
;;;;		    BYTE    02BH,05FH
;;;;		    BYTE    02CH,05FH
;;;;		    BYTE    02DH,05EH
;;;;		    BYTE    02DH,05DH
;;;;		    BYTE    02FH,05CH
;;;;		    BYTE    030H,059H
;;;;		    BYTE    032H,058H
;;;;		    BYTE    033H,056H
;;;;		    BYTE    034H,054H
;;;;		    BYTE    034H,054H
;;;;		    BYTE    034H,053H
;;;;		    BYTE    034H,053H
;;;;		    BYTE    034H,052H
;;;;		    BYTE    034H,052H
;;;;		    BYTE    034H,052H
;;;;		    BYTE    033H,052H
;;;;		    BYTE    032H,051H
;;;;		    BYTE    032H,052H
;;;;		    BYTE    031H,051H
;;;;		    BYTE    030H,051H
;;;;		    BYTE    02FH,051H
;;;;		    BYTE    02EH,051H
;;;;		    BYTE    02DH,050H
;;;;		    BYTE    02BH,04FH
;;;;		    BYTE    02AH,050H
;;;;		    BYTE    028H,04FH
;;;;		    BYTE    026H,04DH
;;;;		    BYTE    024H,04DH
;;;;		    BYTE    022H,04BH
;;;;		    BYTE    021H,04AH
;;;;		    BYTE    020H,048H
;;;;		    BYTE    01FH,048H
;;;;		    BYTE    01DH,047H
;;;;		    BYTE    01CH,047H
;;;;		    BYTE    01BH,047H
;;;;		    BYTE    01AH,045H
;;;;		    BYTE    01AH,044H
;;;;		    BYTE    019H,044H
;;;;		    BYTE    019H,044H
;;;;		    BYTE    018H,044H
;;;;		    BYTE    017H,043H
;;;;		    BYTE    017H,042H
;;;;		    BYTE    017H,042H
;;;;		    BYTE    016H,041H
;;;;		    BYTE    016H,040H
;;;;		    BYTE    016H,040H
;;;;		    BYTE    015H,03FH
;;;;		    BYTE    015H,03FH
;;;;		    BYTE    015H,03FH
;;;;		    BYTE    015H,03DH
;;;;		    BYTE    015H,03DH
;;;;		    BYTE    015H,03DH
;;;;		    BYTE    015H,03BH
;;;;		    BYTE    015H,03BH
;;;;		    BYTE    015H,03AH
;;;;		    BYTE    015H,03AH
;;;;		    BYTE    015H,039H
;;;;		    BYTE    015H,038H
;;;;		    BYTE    015H,037H
;;;;		    BYTE    015H,036H
;;;;		    BYTE    015H,035H
;;;;		    BYTE    015H,035H
;;;;		    BYTE    015H,033H
;;;;		    BYTE    015H,033H
;;;;		    BYTE    015H,031H
;;;;		    BYTE    016H,030H
;;;;		    BYTE    016H,02EH
;;;;		    BYTE    016H,02DH
;;;;		    BYTE    016H,02CH
;;;;		    BYTE    016H,02AH
;;;;		    BYTE    016H,029H
;;;;		    BYTE    016H,027H
;;;;		    BYTE    016H,025H
;;;;		    BYTE    017H,022H
;;;;		    BYTE    017H,01FH
;;;;		    BYTE    017H,01CH
;;;;		    BYTE    017H,019H
;;;;		    BYTE    018H,014H
;;;;		    BYTE    018H,010H
;;;;		    BYTE    018H,00BH
;;;;;
;;;;BG3KAG09	    EQU	    $	    ;΂ʃVbg
;;;;		    HEX	    66
;;;;		    BYTE    039H-048H,02DH
;;;;		    BYTE    037H-048H,031H
;;;;		    BYTE    035H-048H,035H
;;;;		    BYTE    033H-048H,037H
;;;;		    BYTE    031H-048H,03BH
;;;;		    BYTE    030H-048H,03EH
;;;;		    BYTE    02EH-048H,03FH
;;;;		    BYTE    02DH-048H,042H
;;;;		    BYTE    02BH-048H,043H
;;;;		    BYTE    02AH-048H,045H
;;;;		    BYTE    029H-048H,045H
;;;;		    BYTE    029H-048H,046H
;;;;		    BYTE    028H-048H,046H
;;;;		    BYTE    027H-048H,047H
;;;;		    BYTE    027H-048H,048H
;;;;		    BYTE    026H-048H,048H
;;;;		    BYTE    025H-048H,049H
;;;;		    BYTE    025H-048H,049H
;;;;		    BYTE    025H-048H,04AH
;;;;		    BYTE    025H-048H,04AH
;;;;		    BYTE    024H-048H,04BH
;;;;		    BYTE    025H-048H,04CH
;;;;		    BYTE    024H-048H,04DH
;;;;		    BYTE    024H-048H,04DH
;;;;		    BYTE    024H-048H,04EH
;;;;		    BYTE    024H-048H,04EH
;;;;		    BYTE    024H-048H,04FH
;;;;		    BYTE    024H-048H,04FH
;;;;		    BYTE    024H-048H,050H
;;;;		    BYTE    024H-048H,050H
;;;;		    BYTE    024H-048H,051H
;;;;		    BYTE    024H-048H,051H
;;;;		    BYTE    024H-048H,051H
;;;;		    BYTE    025H-048H,052H
;;;;		    BYTE    025H-048H,052H
;;;;		    BYTE    025H-048H,053H
;;;;		    BYTE    025H-048H,053H
;;;;		    BYTE    026H-048H,052H
;;;;		    BYTE    026H-048H,053H
;;;;		    BYTE    026H-048H,053H
;;;;		    BYTE    027H-048H,054H
;;;;		    BYTE    027H-048H,054H
;;;;		    BYTE    027H-048H,053H
;;;;		    BYTE    028H-048H,054H
;;;;		    BYTE    028H-048H,054H
;;;;		    BYTE    029H-048H,054H
;;;;		    BYTE    029H-048H,054H
;;;;		    BYTE    029H-048H,055H
;;;;		    BYTE    02AH-048H,054H
;;;;		    BYTE    02AH-048H,055H
;;;;		    BYTE    02AH-048H,055H
;;;;		    BYTE    02BH-048H,054H
;;;;		    BYTE    02BH-048H,055H
;;;;		    BYTE    02BH-048H,055H
;;;;		    BYTE    02CH-048H,054H
;;;;		    BYTE    02CH-048H,054H
;;;;		    BYTE    02CH-048H,055H
;;;;		    BYTE    02DH-048H,054H
;;;;		    BYTE    02DH-048H,054H
;;;;		    BYTE    02DH-048H,054H
;;;;		    BYTE    02EH-048H,054H
;;;;		    BYTE    02EH-048H,054H
;;;;		    BYTE    02EH-048H,053H
;;;;		    BYTE    02EH-048H,053H
;;;;		    BYTE    02FH-048H,052H
;;;;		    BYTE    02FH-048H,052H
;;;;		    BYTE    02FH-048H,051H
;;;;		    BYTE    030H-048H,050H
;;;;		    BYTE    030H-048H,050H
;;;;		    BYTE    030H-048H,050H
;;;;		    BYTE    030H-048H,04FH
;;;;		    BYTE    031H-048H,04EH
;;;;		    BYTE    031H-048H,04DH
;;;;		    BYTE    031H-048H,04DH
;;;;		    BYTE    032H-048H,04CH
;;;;		    BYTE    032H-048H,04BH
;;;;		    BYTE    032H-048H,04BH
;;;;		    BYTE    033H-048H,04AH
;;;;		    BYTE    033H-048H,048H
;;;;		    BYTE    033H-048H,047H
;;;;		    BYTE    034H-048H,046H
;;;;		    BYTE    034H-048H,044H
;;;;		    BYTE    034H-048H,044H
;;;;		    BYTE    034H-048H,043H
;;;;		    BYTE    034H-048H,041H
;;;;		    BYTE    035H-048H,040H
;;;;		    BYTE    035H-048H,03EH
;;;;		    BYTE    035H-048H,03DH
;;;;		    BYTE    035H-048H,03BH
;;;;		    BYTE    036H-048H,03AH
;;;;		    BYTE    036H-048H,038H
;;;;		    BYTE    036H-048H,035H
;;;;		    BYTE    037H-048H,033H
;;;;		    BYTE    038H-048H,030H
;;;;		    BYTE    038H-048H,02EH
;;;;		    BYTE    038H-048H,02BH
;;;;		    BYTE    038H-048H,027H
;;;;		    BYTE    039H-048H,024H
;;;;		    BYTE    039H-048H,020H
;;;;		    BYTE    039H-048H,01CH
;;;;		    BYTE    038H-048H,013H
;;;;		    BYTE    037H-048H,005H
;;;;;
;;;;BG3KAG0A	    EQU	    $	    ;΂ʃVbg
;;;;		    HEX	    51
;;;;		    BYTE    01FH+18H,05CH
;;;;		    BYTE    01AH+18H,075H
;;;;		    BYTE    01CH+18H,079H
;;;;		    BYTE    01DH+18H,079H
;;;;		    BYTE    01FH+18H,07AH
;;;;		    BYTE    020H+18H,07AH
;;;;		    BYTE    021H+18H,078H
;;;;		    BYTE    023H+18H,076H
;;;;		    BYTE    024H+18H,073H
;;;;		    BYTE    029H+18H,06BH
;;;;		    BYTE    02BH+18H,067H
;;;;		    BYTE    02DH+18H,065H
;;;;		    BYTE    02EH+18H,063H
;;;;		    BYTE    02FH+18H,061H
;;;;		    BYTE    030H+18H,060H
;;;;		    BYTE    030H+18H,060H
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    030H+18H,05FH
;;;;		    BYTE    02FH+18H,05FH
;;;;		    BYTE    02FH+18H,060H
;;;;		    BYTE    02EH+18H,060H
;;;;		    BYTE    02DH+18H,062H
;;;;		    BYTE    02CH+18H,062H
;;;;		    BYTE    02AH+18H,063H
;;;;		    BYTE    029H+18H,064H
;;;;		    BYTE    027H+18H,065H
;;;;		    BYTE    026H+18H,065H
;;;;		    BYTE    025H+18H,065H
;;;;		    BYTE    023H+18H,063H
;;;;		    BYTE    020H+18H,05FH
;;;;		    BYTE    01FH+18H,05EH
;;;;		    BYTE    01BH+18H,058H
;;;;		    BYTE    016H+18H,050H
;;;;		    BYTE    012H+18H,04CH
;;;;		    BYTE    011H+18H,04CH
;;;;		    BYTE    00FH+18H,04AH
;;;;		    BYTE    00DH+18H,049H
;;;;		    BYTE    00DH+18H,048H
;;;;		    BYTE    00BH+18H,047H
;;;;		    BYTE    00AH+18H,047H
;;;;		    BYTE    009H+18H,047H
;;;;		    BYTE    008H+18H,047H
;;;;		    BYTE    008H+18H,046H
;;;;		    BYTE    007H+18H,046H
;;;;		    BYTE    006H+18H,045H
;;;;		    BYTE    005H+18H,045H
;;;;		    BYTE    005H+18H,044H
;;;;		    BYTE    004H+18H,043H
;;;;		    BYTE    004H+18H,042H
;;;;		    BYTE    004H+18H,042H
;;;;		    BYTE    003H+18H,041H
;;;;		    BYTE    003H+18H,040H
;;;;		    BYTE    002H+18H,03FH
;;;;		    BYTE    002H+18H,03EH
;;;;		    BYTE    002H+18H,03EH
;;;;		    BYTE    001H+18H,03DH
;;;;		    BYTE    001H+18H,03CH
;;;;		    BYTE    000H+18H,03BH
;;;;		    BYTE    001H+18H,03AH
;;;;		    BYTE    000H+18H,039H
;;;;		    BYTE    0FFH+18H,037H
;;;;		    BYTE    0FFH+18H,036H
;;;;		    BYTE    0FFH+18H,035H
;;;;		    BYTE    0FFH+18H,033H
;;;;		    BYTE    0FFH+18H,031H
;;;;		    BYTE    000H+18H,030H
;;;;		    BYTE    000H+18H,02EH
;;;;		    BYTE    000H+18H,02CH
;;;;		    BYTE    000H+18H,02AH
;;;;		    BYTE    000H+18H,028H
;;;;		    BYTE    000H+18H,024H
;;;;		    BYTE    001H+18H,020H
;;;;		    BYTE    001H+18H,01CH
;;;;		    BYTE    001H+18H,019H
;;;;		    BYTE    002H+18H,014H
;;;;		    BYTE    002H+18H,00FH
;;;;		    BYTE    003H+18H,006H
;;;;;
;;;;BG3KAG08	    EQU	    $
;;;;		    HEX	    6C
;;;;		    HEX	    00,10
;;;;		    HEX	    01,13
;;;;		    HEX	    04,18
;;;;		    HEX	    08,21
;;;;		    HEX	    0C,28
;;;;		    HEX	    0F,2D
;;;;		    HEX	    12,32
;;;;		    HEX	    14,36
;;;;		    HEX	    1E,48
;;;;		    HEX	    23,52
;;;;		    HEX	    25,55
;;;;		    HEX	    26,57
;;;;		    HEX	    28,58
;;;;		    HEX	    29,5A
;;;;		    HEX	    2A,5B
;;;;		    HEX	    2C,5C
;;;;		    HEX	    2D,5C
;;;;		    HEX	    2E,5B
;;;;		    HEX	    30,59
;;;;		    HEX	    32,58
;;;;		    HEX	    33,56
;;;;		    HEX	    34,55
;;;;		    HEX	    34,55
;;;;		    HEX	    36,54
;;;;		    HEX	    36,54
;;;;		    HEX	    36,53
;;;;		    HEX	    37,52
;;;;		    HEX	    37,51
;;;;		    HEX	    38,50
;;;;		    HEX	    38,50
;;;;		    HEX	    38,4F
;;;;		    HEX	    38,4F
;;;;		    HEX	    38,4D
;;;;		    HEX	    38,4D
;;;;		    HEX	    38,4B
;;;;		    HEX	    38,4B
;;;;		    HEX	    38,4A
;;;;		    HEX	    37,49
;;;;		    HEX	    38,48
;;;;		    HEX	    37,47
;;;;		    HEX	    36,45
;;;;		    HEX	    36,45
;;;;		    HEX	    35,43
;;;;		    HEX	    35,42
;;;;		    HEX	    34,41
;;;;		    HEX	    33,3F
;;;;		    HEX	    32,3D
;;;;		    HEX	    31,3B
;;;;		    HEX	    30,38
;;;;		    HEX	    2F,36
;;;;		    HEX	    2E,34
;;;;		    HEX	    2D,34
;;;;		    HEX	    2C,33
;;;;		    HEX	    2B,31
;;;;		    HEX	    2B,30
;;;;		    HEX	    2A,2F
;;;;		    HEX	    29,2F
;;;;		    HEX	    29,2E
;;;;		    HEX	    28,2C
;;;;		    HEX	    27,2B
;;;;		    HEX	    27,2C
;;;;		    HEX	    26,2B
;;;;		    HEX	    26,2B
;;;;		    HEX	    26,2A
;;;;		    HEX	    26,2A
;;;;		    HEX	    25,29
;;;;		    HEX	    25,2A
;;;;		    HEX	    25,2A
;;;;		    HEX	    25,2A
;;;;		    HEX	    24,29
;;;;		    HEX	    24,29
;;;;		    HEX	    24,29
;;;;		    HEX	    24,29
;;;;		    HEX	    24,29
;;;;		    HEX	    24,29
;;;;		    HEX	    25,2A
;;;;		    HEX	    25,29
;;;;		    HEX	    25,29
;;;;		    HEX	    25,29
;;;;		    HEX	    25,29
;;;;		    HEX	    25,29
;;;;		    HEX	    25,29
;;;;		    HEX	    26,28
;;;;		    HEX	    26,28
;;;;		    HEX	    26,28
;;;;		    HEX	    26,28
;;;;		    HEX	    26,27
;;;;		    HEX	    26,27
;;;;		    HEX	    26,27
;;;;		    HEX	    26,26
;;;;		    HEX	    26,26
;;;;		    HEX	    26,26
;;;;		    HEX	    26,26
;;;;		    HEX	    26,24
;;;;		    HEX	    26,24
;;;;		    HEX	    26,24
;;;;		    HEX	    26,22
;;;;		    HEX	    25,21
;;;;		    HEX	    26,20
;;;;		    HEX	    26,20
;;;;		    HEX	    26,1E
;;;;		    HEX	    26,1D
;;;;		    HEX	    26,1B
;;;;		    HEX	    26,19
;;;;		    HEX	    27,14
;;;;		    HEX	    27,12
;;;;		    HEX	    27,0D
;;;;		    HEX	    27,06
;
;
;
;-------------- slime data --------------------------------------							*
BG3KAG0E	EQU	$
		HEX	03B

		HEX	000,01F
		HEX	000,02B
		HEX	000,034
		HEX	000,03B
		HEX	000,042
		HEX	000,047
		HEX	000,04B
		HEX	000,04F
		HEX	000,053
		HEX	000,056
		HEX	000,059
		HEX	000,05B
		HEX	000,05D
		HEX	000,05F
		HEX	000,060
		HEX	000,061

		HEX	000,062
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,063
		HEX	000,062
		HEX	000,062
		HEX	000,061
		HEX	000,061
		HEX	000,060
		HEX	000,060
		HEX	000,05F

		HEX	000,05E
		HEX	000,05D
		HEX	000,05C
		HEX	000,05B
		HEX	000,05A
		HEX	000,059
		HEX	000,057
		HEX	000,056
		HEX	000,055
		HEX	000,053
		HEX	000,051
		HEX	000,04F
		HEX	000,04E
		HEX	000,04B
		HEX	000,049
		HEX	000,047

		HEX	000,044
		HEX	000,042
		HEX	000,03F
		HEX	000,03B
		HEX	000,038
		HEX	000,034
		HEX	000,030
		HEX	000,02B
		HEX	000,025
		HEX	000,01F
		HEX	000,016
;

;
BG3KAG0F	EQU	$
		HEX	2E
		HEX	00,3C
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3E
		HEX	00,3C
;
BG3KAG10	EQU	$
		HEX	3E
		HEX	00,5C
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5E
		HEX	00,5C
;
BG3KAG11	EQU	$
		HEX	5E
		HEX	00,7C
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7E
		HEX	00,7C
;
;
;************************************************************************
;*		oEhaDafQZbg				*
;*		Ag~bNEv`v`afQZbg			*
;*			in :						*
;*			      (R1)   <-- pcxʒu			*
;*			      (R2)   <-- S\wW			*
;*			      (R3)   <--     h	 x h			*
;*			      (R5)   <-- w{				*
;*			      (R7)   <-- x h				*
;*			      (CWK9) <-- GCfbNX			*
;*			      (CWKA) <-- vC[\wW		*
;*			      (CWKB) <--	"       Y  "		*
;*			      (CWKC) <--     h	   tO		*
;*									*
;*			out : (CWKD) <-- vC[Ƃ̏Փ˃tO	*
;*						[ 00011111B ]		*
;*						     +++++- foot	*
;*						     |||+-- down right	*
;*						     ||+---   "  left   *
;*						     |+---- up	 right	*
;*						     +-----   "  left   *
;*			      (CWKE) <-- player foot hosei dot		*
;*			      (CWKF) <--      "      cross saka flag    *
;*			      (CWK10) <- hed BG check Y pos		*
;*						0,5,4,9:not saka	*
;*						1,6    :67.5		*
;*						2,7    :45		*
;*						3,8    :22.5		*
;************************************************************************
;
BPUCH_SET	EQU	$
		IWT	R0,#BPUCH_BGP	;(CWK10) <-- af`FbN|Cgf[^|C^[
		BRA	B_BROS_SET_0000
		NOP
;
B_BROS_SET	EQU	$
		IWT	R0,#BBROS_BGP	;(CWK10) <-- af`FbN|Cgf[^|C^[
B_BROS_SET_0000
		SMS	R0,CWORK10
;
		SMS	R2,CWORK0	;(CWK0)	 <-- S\wW
		SMS	R2,CWORK12	;(CWK12) <-- S\wW
		SMS	R3,CWORK1	;(CWK1)	 <--	 h  x h
		SMS	R5,CWORK2	;(CWK2)	 <-- w{
		SMS	R7,CWORK3	;(CWK3)	 <-- x h
;
		IBT	R0,#BANK BBROS_DATA ;oEhaD`f[^AhXiajZbg
		ROMB
		IWT	R14,#BBROS_DATA ;(R14) <-- oEhaD`f[^AhXikCgjZbg
;
		GETB
		TO	R10		;(R10) <-- `󍂂~POOg
		SWAP
;
		WITH	R3		;(R3) <-- S\xW␳
		SUB	#8
;
		IWT	R0,#DIVBUF
		ADD	R7
		ADD	R7
		TO	R8		;(R8) <-- xZl
		LDW	(R0)
;
;;;;		    IWT	    R9,#0B2H-1	    ;(R9) <-- g|cl`obt@Zbg
		IWT	R9,#0D2H-1	;(R9) <-- g|cl`obt@Zbg
;
		CACHE
;
		IBT	R0,#060H
		ADD	R2
		IWT	R11,#100H+(60H+60H)
		SUB	R11
		BCC	B_BROS_SET_0010 ;\H ( yes:B_BROS_SET_0010 )
		NOP
;
;-------------- \GAI[o[II ----------------------------------
		IBT	R2,#80H		;[ IWT R2,#0FF80H ]
		mDJMP	B_BROS_SET_0150
;
;-------------- uXN[JE^[g|cl`obt@Zbg ----------
B_BROS_SET_0010
;;;;		    IWT	    R11,#HDMABF+(0B2H-1)*2  ;(R11) <-- uXN[g|cl`obt@|C^[
		IWT	R11,#HDMABF+(0D2H-1)*2	;(R11) <-- uXN[g|cl`obt@|C^[
;;;;		    IWT	    R13,#0B2H-2
		IWT	R13,#0D2H-2
		FROM	R13
		SUB	R3
		BPL	B_BROS_SET_0020 ;Sxȉobt@NA[H ( yes:B_BROS_SET_0020 )
		TO	R6
;
;-------------- Sxȉobt@NA[ ------------------
		NOT
		INC	R6
		FROM	R8
		LMULT
		ADC	#0
		BEQ	B_BROS_SET_0014
		NOP
;
		MOVE	R4,R10
B_BROS_SET_0014
		WITH	R10
		SUB	R4
		MOVE	R12,R9
		BRA	B_BROS_SET_0050
		INC	R14		;[ next program ]
;
;-------------- Sxȉobt@NA[ ----------------------
B_BROS_SET_0020
		MOVE	R12,R0		;(R12) <-- Sxȉobt@NA[
		FROM	R13
		SUB	R12
		BPL	B_BROS_SET_0030 ;Sobt@NA[H ( no:B_BROS_SET_0030 )
		INC	R12
;
		MOVE	R12,R13
		INC	R12
B_BROS_SET_0030
		WITH	R9
		SUB	R12
;;;;		    IWT	    R0,#-0B2H-8
		IWT	R0,#-0D2H-8
		MOVE	R13,R15
B_BROS_SET_0040
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		INC	R0
;
		MOVES	R12,R9
		BPL	B_BROS_SET_0050 ;Sobt@NA[H ( no:B_BROS_SET_0050 )
		INC	R14		;[ next program ]
;
		mDJMP_X B_BROS_SET_0150
;
;-------------- `f[^Zbg --------------------------------
B_BROS_SET_0050
;;;;		INC	R14
		MOVE	R6,R5		;(R6) <-- w{
		MOVE	R7,R14		;(R7) <-- oEhaD`f[^AhX
;
		INC	R12
		MOVE	R13,R15
B_BROS_SET_0060
		WITH	R10
		SUB	R8
		BMI	B_BROS_SET_0100 ;`f[^ZbgIH ( yes:B_BROS_SET_0100 )
		FROM	R10
;
		HIB
		TO	R14
		ADD	R7
;
		IWT	R5,#0100H
		SUB	R1
		BCS	B_BROS_SET_0070 ;pcGAH ( yes:B_BROS_SET_0070 )
		NOP
;
		WITH	R5		;[ IWT R5,#0200H ]
		ADD	R5
B_BROS_SET_0070
		GETB
		SWAP
		FMULT
		SUB	R12
		SUB	#8
		ADD	R5
		STW	(R11)
		DEC	R11
		LOOP
		DEC	R11
;
		mDJMP_X B_BROS_SET_0150
;
;-------------- `f[^ȏobt@NA[ ------------------
B_BROS_SET_0100
		FROM	R12
		NOT
		SUB	#8-1
		MOVE	R13,R15
B_BROS_SET_0110
		STW	(R11)
		DEC	R11
		DEC	R11
		LOOP
		INC	R0
;
;-------------- gXN[JE^[g|cl`obt@Zbg ----------
B_BROS_SET_0150
		IWT	R0,#80H
		SUB	R2		;(R0) <-- gXN[JE^[
;
		IWT	R11,#HDMABF1	;(R11) <-- gXN[g|cl`obt@|C^[
;;;;		    IWT	    R12,#0B2H
		IWT	R12,#0D2H
		MOVE	R13,R15
B_BROS_SET_0160
		STW	(R11)
		INC	R11
		LOOP
		INC	R11
;
;-------------- Փ˃`FbN --------------------------------------------
		mDJMP	BG3_CROSS_CK
;
;************************************************************************
;*		Ag~bNEv`v`af`FbN|Cgf[^		*
;************************************************************************
BPUCH_BGP
		HEX	C1,C0	;[ up  left  ]
		HEX	3F,C0	;[ up  right ]
		HEX	D6,F0	;[ low left  ]
		HEX	2A,F0	;[ low right ]
		HEX	00,81	;[    hed    ]
		HEX	00,0E	;[    foot   ]
;
;************************************************************************
;*		oEhaDaf`FbN|Cgf[^		*
;************************************************************************
BBROS_BGP
		HEX	C1,C0	;[ up  left  ]
		HEX	3F,C0	;[ up  right ]
		HEX	D6,F0	;[ low left  ]
		HEX	2A,F0	;[ low right ]
		HEX	00,81	;[    hed    ]
		HEX	00,0A	;[    foot   ]
;
;************************************************************************
;*		oEhaD`f[^				*
;************************************************************************
BBROS_DATA
		HEX	7F	;`󍂂
		HEX	00,17,20,27,2D,32,36,3A
		HEX	3E,41,45,48,4B,4D,50,52
		HEX	55,57,59,5B,5D,5F,60,62
		HEX	64,65,67,68,6A,6B,6C,6D
		HEX	6F,70,71,72,73,74,75,75
		HEX	76,77,78,78,79,7A,7A,7B
		HEX	7B,7C,7C,7D,7D,7D,7E,7E
		HEX	7E,7E,7F,7F,7F,7F,7F,7F
		HEX	7F,7F,7F,7F,7F,7E,7E,7E
		HEX	7E,7D,7D,7D,7C,7C,7B,7B
		HEX	7A,7A,79,78,78,77,76,75
		HEX	75,74,73,72,71,70,6F,6D
		HEX	6C,6B,6A,68,67,65,64,62
		HEX	60,5F,5D,5B,59,57,55,52
		HEX	50,4D,4B,48,45,41,3E,3A
		HEX	36,32,2D,27,20,17,00
;
;************************************************************************
;*		afRGՓ˃`FbN				*
;************************************************************************
XBG3_CROSS_CK	EQU	$
;
;-------------- VS player cross check -----------------------------------
;;;;		    mJSR_X  XBG3PCROS	    ;[ return: (R5) <-- 0B2H ]
		mJSR_X	XBG3PCROS	;[ return: (R5) <-- 0D2H ]
		CACHE
;
;-------------- VS enemy cross check ------------------------------------
		IWT	R1,#CENMODE	;(R1)  <-- enemy mode pointer
		IWT	R2,#CENSHOT	;(R2)  <--   "   shot flag pointer
		IWT	R3,#CECENTX	;(R3)  <--   "   cross check center pos pointer
		IWT	R0,#CENCRPT
		LMS	R4,CWORK9
		ADD	R4
		LDB	(R0)
		ADD	R0
		TO	R4		;(R4)  <-- slime cross check start point
		ADD	R0
		LM	R10,CESCCH1	;(R10) <-- scroll counter_H
		IBT	R12,#CENNO	;(R12) <-- loop no
		LM	R0,CESCCV1
		TO	R11		;(R11) <--	  "      _V
		ADD	#8
;
		CACHE
;
		IWT	R13,#XBG3CRCK_0010+1
XBG3CRCK_0010
		WITH	R4
		SUB	#4
		BPL	XBG3CRCK_0020	;cross check index over ? ( no:XBG3CRCK_0020 )
		FROM	R1
;
		IBT	R4,#(CENNO-1)*4
		FROM	R1
XBG3CRCK_0020
		ADD	R4
		LDB	(R0)
		SUB	#CEFAIL
		BCC	XBG3CRCK_0040	;cross check ok mode ? ( no:XBG3CRCK_0040 )
		FROM	R2
;
		ADD	R4
		LDW	(R0)
		SUB	#0
		BEQ	XBG3CRCK_0040	;cross check ok ? ( no:XBG3CRCK_0040 )
		FROM	R3
;
		ADD	R4
		TO	R14
		LDW	(R0)
		WITH	R14		;(R14) <-- display cross check center X pos
		SUB	R10
		INC	R0
		INC	R0
		LDW	(R0)
		SUB	R11
		SUB	R5
		BCS	XBG3CRCK_0060	;Y pos over ? ( yes:XBG3CRCK_0060 )
		ADD	R5
;
		MOVE	R9,R0		;(R9) <-- display cross check center Y pos
		ADD	R0		;x2
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#8+1
		TO	R8		;(R8) <-- now Y pos X wide
		LOB
;
		FROM	R7
		ADD	R9
		ADD	R9
		TO	R9
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R9
		SUB	R14
		BPL	XBG3CRCK_0030
		NOP
;
		NOT
		INC	R0
XBG3CRCK_0030
		ADD	R0		;x2
		SUB	R8
		BCS	XBG3CRCK_0060	;cross ? ( yes:XBG3CRCK_0060 )
		NOP
;
XBG3CRCK_0040
		LOOP
		WITH	R4		;[ dummy ]
;
;-------------- not cross !! ------------------------------------
XBG3CRCK_0050
		LMS	R1,CWORK9
		TO	R4		;[ IBT R4,#0 ]
		BRA	XBG3CRCK_0070
		SUB	R0
;
;-------------- cross !! ----------------------------------------
XBG3CRCK_0060
		LMS	R1,CWORK9
		IWT	R0,#CENCRPT
		TO	R2
		ADD	R1
		FROM	R4
		LSR
		LSR
		STB	(R2)		;slime cross check next start point set
		INC	R4
XBG3CRCK_0070
		IWT	R0,#CECRSFG
		ADD	R1
		FROM	R4
		STB	(R0)		;cross enemy index set
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		BG3 player cross check					-
;-			in  : (R0)   <-- size AND data			-
;-			      (CWKA) <-- player display X pos		-
;-			      (CWKB) <--	"       Y  "		-
;-			      (CWKC) <--    "   sit down flag           -
;-									-
;-			out : (CWKD) <--    "   cross flag              -
;-						[ 00011111B ]		-
;-						     +++++- foot	-
;-						     |||+-- down right	-
;-						     ||+---   "  left   -
;-						     |+---- up	 right	-
;-						     +-----   "  left   -
;-			      (CWKE) <-- player foot hosei dot		-
;-			      (CWKF) <--      "      cross saka flag    -
;-						0,5,4,9:not saka	-
;-						1,6    :67.5		-
;-						2,7    :45		-
;-						3,8    :22.5		-
;------------------------------------------------------------------------
XBG3PCROS	EQU	$
		IBT	R0,#0FFH	;(R0) <-- size AND data
;
XBG3PCROS2	EQU	$
		SMS	R11,RTS0	;return address save
		MOVE	R11,R0		;(R11) <-- size AND data
;
		IBT	R0,#BANK SLIM_PLC
		ROMB
		IWT	R14,#SLIM_PLC	;(R14) <-- player cross check point data pointer
		LMS	R0,CWORKC
		SUB	#0
		BEQ	XB3PCR000	;sit down player ? ( no:XB3PCR000 )
		WITH	R14
;
		ADD	#5*2
XB3PCR000
		LMS	R1,CWORKA	;(R1) <-- player display X pos
		LMS	R0,CWORKB	;(R0) <--	 "       Y  "
XB3PCR010
		TO	R2		;(R2) <-- to buffer player display Y pos
		SUB	#8
;
;;;;		    IWT	    R5,#0B2H	    ;(R5)  <-- max Y pos
		IWT	R5,#0D2H	;(R5)  <-- max Y pos
		IWT	R6,#HDMABF	;(R6)  <-- X wide H-DMA buffer address
		IWT	R7,#HDMABF1	;(R7)  <-- scroll counter_H H-DMA buffer address
;
		IWT	R3,#080H	;(R3)  <-- scroll counter_H H-DMA data check data
		IBT	R10,#00		;(R10) <-- cross point flag
;
		IBT	R12,#5
		IWT	R13,#XB3PCR020+1
XB3PCR020
		WITH	R10
		ADD	R10		;[ ASL ] cross point flag pos change
;
		GETBS
		INC	R14
		TO	R4		;(R4) <-- check point dispaly X pos
		ADD	R1
;
		GETBS
		INC	R14
		ADD	R2
		MOVE	R9,R0		;(R9) <-- check point dispaly Y pos
		SUB	R5
		BCS	XB3PCR032	;Y pos over ? ( yes:XB3PCR032 )
		ADD	R5
;
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		AND	R11
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		BPL	XB3PCR030
		NOP
;
		NOT
		INC	R0
XB3PCR030
		ADD	R0		;x2
		SUB	R8
		BCC	XB3PCR040	;cross ? ( no:XB3PCR040 )
		NOP
;
;-------------- cross !! --------------------------------
XB3PCR032
		INC	R10		;cross point flag set !!
XB3PCR040
		LOOP
		WITH	R10		;[ dummy ]
;
		SMS	R10,CWORKA	;cross point flag set
;
;-------------- player foot pos hosei dot check -----------------
		FROM	R10
		LSR
		BCC	XB3PCR110	 ;foot cross ? ( no:XB3PCR110 )
		SUB	R0		;[ IBT R0,#00 ]
;
		MOVE	R1,R0		;(R1) <-- player hosei dot
XB3PCR050
		DEC	R9
		BMI	XB3PCR070	;Y pos over ? ( yes:XB3PCR070 )
		FROM	R1
;
		ADD	#0AH
		BMI	XB3PCR070	;hosei dot over ? ( yes:XB3PCR070 )
		FROM	R9
;
		SUB	R5
		BCC	XB3PCR052
		ADD	R5
;
		BRA	XB3PCR050
		DEC	R1
;
XB3PCR052
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		AND	R11
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		MOVE	R2,R0		;(R2) <-- cross muki
		BPL	XB3PCR060
		NOP
;
		NOT
		INC	R0
XB3PCR060
		ADD	R0		;x2
		SUB	R8
		BCS	XB3PCR050	;cross ? ( yes:XB3PCR050 )
		DEC	R1
;
XB3PCR070
		SMS	R1,CWORKB	;foot hosei dot
;
		FROM	R9
		ADD	#2
		CMP	R5
		BCS	XB3PCR080	;Y pos over ? ( yes:XB3PCR080 )
		FROM	R8
;
		FROM	R0
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		AND	R11		;(R0) <-- now Y pos X wide
XB3PCR080
		SUB	R8
		LSR
		IBT	R3,#4
		CMP	R3
		BCC	XB3PCR090
		NOP
;
		MOVE	R0,R3
XB3PCR090
		MOVES	R2,R2
		BPL	XB3PCR100
		NOP
;
		ADD	#5
XB3PCR100
		ADD	R0		;x2
		SMS	R0,CWORKC	;saka angle data pointer
;
XB3PCR110
		IWT	R0,#SLIM_BAC
		SUB	R14
		BCC	XB3PCR120	;Ԃ`FbNH ( yes:XB3PCR120 )
		TO	R14
;
		ADD	R14
;
		LMS	R0,CWORKA	;vC[Zbg
		SMS	R0,CWORKD
		LMS	R0,CWORKB
		SMS	R0,CWORKE
		LMS	R0,CWORKC
		SMS	R0,CWORKF
;
		LM	R1,CENDSXL	;(R1) <-- Ԃ\wW
		LM	R0,CENDSYL	;(R0) <--      h     x h
		mDJMP_X XB3PCR010+1
		TO	R2
;
XB3PCR120
		LMS	R11,RTS0
		mRTS
;
;------------------------------------------------------------------------
;-		BG3 enemy cross check					-
;-			out : (ENCBFG) <-- afRtO		-
;-						[ 00001111B ]		-
;-						      ++++- foot	-
;-						      ||+-- hed		-
;-						      |+--- right	-
;-						      +---- left	-
;-			      (CWKE) <-- enemy foot hosei dot		-
;-			      (CWKF) <--      "      cross saka flag    -
;-						0,5,4,9:not saka	-
;-						1,6    :67.5		-
;-						2,7    :45		-
;-						3,8    :22.5		-
;------------------------------------------------------------------------
XBG3ECROS	EQU	$
		IBT	R0,#BANK ENBGCK_POINT_IN
		ROMB
;
		IBT	R11,#00		;(R11) <-- G̃CfbNX
		IBT	R12,#CENNO
;
		CACHE
;
		MOVE	R13,R15
XBG3ECROS_010
		IBT	R10,#00		;(R10) <-- cross point flag
;
		mLDW0	CENMODE,R11
		SUB	#CENOK
		BCC	XBG3ECROS_012	;af`FbNnj[hH ( no:XBG3ECROS_012 )
		NOP
;
		mLDW0	CENSHOT,R11
		SUB	#0
		BNE	XBG3ECROS_012	;VbgH ( yes:XBG3ECROS_012 )
		NOP
;
		mLDW0	CENMOD1,R11
		IBT	R1,#01FH
		AND	R1
		BNE	XBG3ECROS_014	;af`FbNH ( yes:XBG3ECROS_014 )
		ADD	R0
;
XBG3ECROS_012
		mDJMP_X XB3ECR200+1
		INC	R11
;
XBG3ECROS_014
		IBT	R3,#4		;(R3) <-- `FbN|CgiS_j
		IWT	R2,#ENBGCK_POINT+2 ;[ +2:center cancel !! ]
		IBT	R1,#01CH*2
		SUB	R1
		BCC	XBG3ECROS_016
		ADD	R1
;
		IBT	R3,#1		;(R3) <-- `FbN|CgiP_j
		DEC	R2
		DEC	R2
XBG3ECROS_016
		IWT	R14,#ENBGCK_POINT_IN-2+1
		TO	R14
		ADD	R14
		GETB
		ADD	R0
		TO	R14
		ADD	R2
;
		mLDW	R1,CENDSXL,R11	;(R1) <-- enemy display X pos
		mLDW0	CENDSYL,R11	;(R0) <--	"       Y  "
		TO	R2		;(R2) <-- to buffer player display Y pos
		SUB	#8
;
;;;;		    IWT	    R5,#0B2H	    ;(R5)  <-- max Y pos
		IWT	R5,#0D2H	;(R5)  <-- max Y pos
		IWT	R6,#HDMABF	;(R6)  <-- X wide H-DMA buffer address
		IWT	R7,#HDMABF1	;(R7)  <-- scroll counter_H H-DMA buffer address
;
		SMS	R12,REG12	;(R12) save
		SMS	R13,REG13	;(R13) save
;
		MOVE	R12,R3		;(R12) <-- `FbN|Cg
		IWT	R3,#080H	;(R3)  <-- scroll counter_H H-DMA data check data
;
		IWT	R13,#XB3ECR020+1
XB3ECR020
		WITH	R10
		ADD	R10		;[ ASL ] cross point flag pos change
;
		GETBS
		INC	R14
		TO	R4		;(R4) <-- check point dispaly X pos
		ADD	R1
;
		GETBS
		INC	R14
		ADD	R2
		MOVE	R9,R0		;(R9) <-- check point dispaly Y pos
		SUB	R5
		BCS	XB3ECR032	;Y pos over ? ( yes:XB3ECR032 )
		ADD	R5
;
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		LOB			;[ AND #00FFH ]
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		BPL	XB3ECR030
		NOP
;
		NOT
		INC	R0
XB3ECR030
		ADD	R0		;x2
		SUB	R8
		BCC	XB3ECR040	;cross ? ( no:XB3ECR040 )
		NOP
;
;-------------- cross !! --------------------------------
XB3ECR032
		INC	R10		;cross point flag set !!
XB3ECR040
		LOOP
		WITH	R10		;[ dummy ]
;
		LMS	R12,REG12	;(R12) load
		LMS	R13,REG13	;(R13) load
;
;-------------- enemy foot pos hosei dot check ------------------
		FROM	R10
		LSR
		BCC	XB3ECR110	 ;foot cross ? ( no:XB3ECR110 )
		SUB	R0		;[ IBT R0,#00 ]
;
		MOVE	R1,R0		;[ IBT R1,#0 ] (R1) <-- enemy hosei dot
;
		FROM	R10
		AND	#0010B
		BEQ	XB3ECR050	;H ( no:XB3ECR050 )
		FROM	R9
;
		SEX
		BMI	XB3ECR050
		WITH	R10		;LZ
;
		BIC	#0001B
		BRA	XB3ECR110+1
		FROM	R10
;
XB3ECR050
		DEC	R9
		BMI	XB3ECR070	;Y pos over ? ( yes:XB3ECR070 )
		FROM	R1
;
		ADD	#0AH
		BMI	XB3ECR070	;hosei dot over ? ( yes:XB3ECR070 )
		FROM	R9
;
		SUB	R5
		BCC	XB3ECR052
		ADD	R5
;
		BRA	XB3ECR050
		DEC	R1
;
XB3ECR052
		ADD	R0
		ADD	R6
		LDW	(R0)
		ADD	R9
		ADD	#1+8
		TO	R8		;(R8) <-- now Y pos X wide
		LOB
;
		FROM	R7
		ADD	R9
		ADD	R9
		LDW	(R0)
		FROM	R3
		SUB	R0
		SUB	R4
		MOVE	R2,R0		;(R2) <-- cross muki
		BPL	XB3ECR060
		NOP
;
		NOT
		INC	R0
XB3ECR060
		ADD	R0		;x2
		SUB	R8
		BCS	XB3ECR050	;cross ? ( yes:XB3ECR050 )
		DEC	R1
;
XB3ECR070
		mLDW0	CENYPSL,R11	;␳II
		ADD	R1
		SBK			;[ mSTW R0,CENYPSL,R11 ]
;
;;;;		    DEC	    R11
;;;;		    BPL	    XB3ECR110	    ;ԂH ( no:XB3ECR110 )
;;;;		    INC	    R11
;;;;;
;;;;		    IBT	    R0,#01H	    ;tghnmhII
;;;;		    SM	    R0,CB_ONLFFG
;;;;;
XB3ECR110
		FROM	R10
		AND	#1100B
		BEQ	XB3ECR150	;TChH ( no:XB3ECR150 )
		FROM	R4
;
;-------------- TCh ------------------------------------
		SEX
		IBT	R4,#1
		BPL	XB3ECR120	;ֈړH ( yes:XB3ECR120 )
		NOP
;
		IBT	R4,#-1
XB3ECR120
		mLDW0	CENXPSL,R11
		ADD	R4
		SBK			;[ mSTW R0,CENXPSL,R11 ]
		mLDW0	CENXMAX,R11
		TO	R2
		XOR	R4
		BPL	XB3ECR130	;wXs[hl]H ( no:XB3ECR130 )
		NOP
;
		NOT
		INC	R0
		SBK			;[ mSTW R0,CENXMAX,R11 ]
XB3ECR130
		mLDW0	CENXSPD,R11
		TO	R2
		XOR	R4
		BPL	XB3ECR140	;wXs[h]H ( no:XB3ECR140 )
		INC	R4		;[ (R4) <-- 0 or 2 ]
;
		NOT
		INC	R0
		SBK			;[ mSTW R0,CENXSPD,R11 ]
XB3ECR140
		mSTW	R4,CENMUKI,R11	;Zbg
XB3ECR150
		FROM	R10
		AND	#0010B
		BEQ	XB3ECR200	;H ( no:XB3ECR200 )
		NOP
;
;--------------  ----------------------------------------
		mLDW0	CENYSPD,R11
		SUB	#0
		BPL	XB3ECR200
		TO	R2		;[ IBT R2,#0 ]
;
		SUB	R0
		mSTW	R2,CENYSPD,R11
;
XB3ECR200
		INC	R11
;
		mSTW	R10,CENCBFG-1,R11 ;cross point flag set
;
		INC	R11
		INC	R11
		LOOP
		INC	R11
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		QQ`̈ݑ܃|CgZbg			-
;-			in :						-
;-				(R0)  <-- |Cgf[^AhX	-
;-				(R14) <--	      h		-
;------------------------------------------------------------------------
INGER_P_RET	EQU	$
		ROMB
		MOVE	R14,R14
;
		IWT	R1,#BSPL_B_POINT ;(R1) <-- |Cgf[^|C^[
		TO	R12		 ;(R12) <-- |Cg
		LDB	(R1)
		INC	R1
;
		CACHE
;
		MOVE	R13,R15
INGER_P_RET_010
		LDB	(R1)
		TO	R2		;(R2) <-- |CgwW
		SEX
;
		GETBS			;(R0) <-- |CgwW
;
		SUB	R2
		BEQ	INGER_P_RET_020
		INC	R14
;
		ASR			;1/16
		ASR			;
		ASR			;
		ASR			;
		BNE	INGER_P_RET_020
		NOP
;
		INC	R0		;[ IBT R0,#01H ]
INGER_P_RET_020
		ADD	R2		;|CgwW␳
		STB	(R1)
		INC	R1
;
		LDB	(R1)
		TO	R2		;(R2) <-- |CgxW
		SEX
;
		GETBS			;(R0) <-- |CgxW
;
		SUB	R2
		BEQ	INGER_P_RET_030
		INC	R14
;
		ASR			;1/16
		ASR			;
		ASR			;
		ASR			;
		BNE	INGER_P_RET_030
		NOP
;
		INC	R0		;[ IBT R0,#01H ]
INGER_P_RET_030
		ADD	R2		;|CgxW␳
		STB	(R1)
;
		LOOP
		INC	R1
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		QQ`̈ݑ܃|CgړZbg			-
;-			in :						-
;-				(R1)   <-- `FbNwW		-
;-				(R2)   <--    h   x h		-
;-				(CWK2) <--    h   l`wa		-
;------------------------------------------------------------------------
INGER_P_MOV	EQU	$
		SMS	R1,CWORK0	;(CWK0) <-- `FbNwW
		SMS	R2,CWORK1	;(CWK1) <--	"   x h
;
;-------------- `FbN|Cg ------------------------------------
		mJSR	M_RAD_GET_1
;
		MOVE	R3,R1		;(R3) <-- px
;
		LMS	R4,CWORK2	;(R4) <-- `FbNl`wa
		FROM	R4
		TO	R5		;(R5) <-- `FbNl`waOQ
		MULT	R4
		LMS	R1,CWORK0	;(R1) <-- `FbNwW
		FROM	R1
		TO	R6
		MULT	R1
		LMS	R2,CWORK1	;(R2) <-- `FbNxW
		FROM	R2
		MULT	R2
		ADD	R6
		SUB	R5
		BCC	INGER_P_MOV_010 ;`FbNl`waI[o[H ( no:INGER_P_MOV_010 )
		NOP
;
		IBT	R0,#BANK LCOS
		ROMB
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R3
		GETB
		MULT	R4
		ADD	R0
		ADD	R0
		HIB
		SEX
		TO	R1
		NOT
		INC	R1
		SMS	R1,CWORK0
;
		IBT	R0,#040H
		TO	R14
		ADD	R14
		GETB
		MULT	R4
		ADD	R0
		ADD	R0
		HIB
		SEX
		TO	R2
		NOT
		INC	R2
		SMS	R2,CWORK1
;
INGER_P_MOV_010
		IBT	R0,#7FH
		XOR	R3
		INC	R0
		LOB
		ADD	#08H		;[ľܓ]
		LSR
		LSR
		LSR
		LSR
		SMS	R0,CWORK2	;(CWK2) <-- `FbN|CgmD
		MOVE	R4,R0		;(R4)	<--	     h
;
		ADD	R0
		IWT	R3,#BSPL_B_POINT+1
		TO	R3
		ADD	R3
		FROM	R1
		STB	(R3)
		INC	R3
		FROM	R2
		STB	(R3)
;
;-------------- `FbN|Cgi|j|CgvZ --------------------
		FROM	R4		;`FbN|CgmD|Q
		SUB	#2
		AND	#0FH
		ADD	R0		;x2
		IWT	R3,#BSPL_B_POINT+1
		TO	R3
		ADD	R3
		LDB	(R3)
		SEX
		TO	R1		;(R1) <-- pxvZpw
		SUB	R1
		INC	R3
		LDB	(R3)
		SEX
		TO	R2		;(R2) <-- pxvZpx
		SUB	R2
;
		mJSR	M_RAD_GET_COSIN
;
		LMS	R0,CWORK2
		DEC	R0
		AND	#0FH
		ADD	R0		;x2
		IWT	R4,#BSPL_B_POINT+1
		TO	R4
		ADD	R4
		LDB	(R4)
		MOVE	R6,R0		;(R6) <-- w
		LMS	R1,CWORK0
		SUB	R1
		TO	R5		;(R5) <-- w~rhm
		MULT	R3
		INC	R4
		LDB	(R4)
		MOVE	R7,R0		;(R7) <-- x
		LMS	R1,CWORK1
		SUB	R1
		MULT	R2		;(R0) <-- x~bnr
		FROM	R5
		SUB	R0
		ADD	R0
		ADD	R0
		HIB
		MOVE	R5,R0		;(R5) <-- w~rhm|x~bnr
;
		MULT	R2		;(R0) <-- iw~rhm|x~bnrj~bnr
		ADD	R0
		ADD	R0
		HIB
		ADD	R7
		STB	(R4)
		FROM	R5
		MULT	R3		;(R0) <-- iw~rhm|x~bnrj~rhm
		ADD	R0
		ADD	R0
		HIB
		FROM	R6
		SUB	R0
		DEC	R4
		STB	(R4)
;
;-------------- `FbN|Cgi{j|CgvZ --------------------
		LMS	R0,CWORK2
		ADD	#2		;`FbN|CgmD{Q
		AND	#0FH
		ADD	R0		;x2
		IWT	R3,#BSPL_B_POINT+1
		TO	R3
		ADD	R3
		LDB	(R3)
		SEX
		LMS	R1,CWORK0
		TO	R1		;(R1) <-- pxvZpw
		SUB	R1
		INC	R3
		LDB	(R3)
		SEX
		LMS	R2,CWORK1
		TO	R2		;(R2) <-- pxvZpx
		SUB	R2
;
		mJSR	M_RAD_GET_COSIN
;
		LMS	R0,CWORK2
		INC	R0
		AND	#0FH
		ADD	R0		;x2
		IWT	R4,#BSPL_B_POINT+1
		TO	R4
		ADD	R4
		LDB	(R4)
		MOVE	R6,R0		;(R6) <-- w
		LMS	R1,CWORK0
		SUB	R1
		TO	R5		;(R5) <-- w~rhm
		MULT	R3
		INC	R4
		LDB	(R4)
		MOVE	R7,R0		;(R7) <-- x
		LMS	R1,CWORK1
		SUB	R1
		MULT	R2		;(R0) <-- x~bnr
		FROM	R5
		SUB	R0
		ADD	R0
		ADD	R0
		HIB
		MOVE	R5,R0		;(R5) <-- w~rhm|x~bnr
;
		MULT	R2		;(R0) <-- iw~rhm|x~bnrj~bnr
		ADD	R0
		ADD	R0
		HIB
		ADD	R7
		STB	(R4)
		FROM	R5
		MULT	R3		;(R0) <-- iw~rhm|x~bnrj~rhm
		ADD	R0
		ADD	R0
		HIB
		FROM	R6
		SUB	R0
		DEC	R4
		STB	(R4)
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		pxvZbnrrhmf[^ǂݍ			-
;------------------------------------------------------------------------
M_RAD_GET_COSIN
		SMS	R11,RTS1
;
		mJSR	M_RAD_GET_1
;
		IBT	R0,#BANK LCOS
		ROMB
		IWT	R0,#LCOS
		TO	R14
		ADD	R1
		TO	R2		;(R2) <-- bnrf[^
		GETB
		IBT	R0,#40H		;[ IWT R0,#LSIN ]
		TO	R14
		ADD	R14
		TO	R3		;(R3) <-- rhmf[^
		GETB
;
		LMS	R11,RTS1
		mRTS
;
;------------------------------------------------------------------------
;-		pxvZ						-
;-			(R1) <-- pxvZpw			-
;-			(R2) <--     h	   x h			-
;------------------------------------------------------------------------
M_RAD_GET_1
		SMS	R11,RTS0
;
		IWT	R0,#M_RAD_GET_S
		IBT	R8,#BANK M_RAD_GET_S
		IBT	R5,#BANK INGER_P_MOV
		MOVE	R11,R15
		LJMP	R8
		NOP
;
		LMS	R11,RTS0
		mRTS
;
;
;****************************************************************
;*								*
;*		ݑ܃sNsN					*
;*				in				*
;*								*
;*				qP : 			*
;*				qQ : 			*
;*				qR : f[^[hXebv	*
;*								*
;*				qT	: obt@ AhX	*
;*								*
;*				c				*
;*				qV : 			*
;*				qW : 			*
;*				qX : f[^[hXebv	*
;*								*
;*				qPO : XN[l		*
;*				qPP : cXN[l		*
;*								*
;****************************************************************
PIKUPIKU	EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#BANK SIN
		ROMB			; TCf[^ oN Zbg
;
		WITH	R3
		LOB
		WITH	R9
		LOB
;;;;		    IWT	    R12,#000B2H	    ; [v
		IWT	R12,#000D2H	; [v
		MOVE	R13,R15		; AhX Zbg
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		X^[XN[			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		WITH	R1
		LOB
		IWT	R0,#SIN
		ADD	R1
		TO	R14
		ADD	R1
		GETB
		INC	R14
		GETBH			; R6 <- TCf[^
		MOVE	R6,R2
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
;
		ADD	R10
		STW	(R5)		; XN[l Zbg !!
		INC	R5
		INC	R5
;
		WITH	R1		; ̃f[^ AhX
		ADD	R3
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		cX^[XN[			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		WITH	R7
		LOB
		IWT	R0,#SIN
		ADD	R7
		TO	R14
		ADD	R7
		GETB
		INC	R14
		GETBH			; R6 <- TCf[^
		MOVE	R6,R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
;
		ADD	R11
		STW	(R5)		; XN[l Zbg !!
;
		WITH	R7		; ̃f[^ AhX
		ADD	R9
;
		INC	R5
		LOOP
		INC	R5
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNW|CggAkZbg			-
;-			in :						-
;-				(R0)  <-- |Cgf[^AhX	-
;-				(R14) <--	      h		-
;-				(R6)  <-- {				-
;------------------------------------------------------------------------
BKMKJ_P_ZOOM	EQU	$
		ROMB
		MOVE	R14,R14
;
		IWT	R1,#BSPL_B_POINT ;(R1) <-- |Cgf[^|C^[
		LDB	(R1)
		INC	R1
		MOVE	R12,R0		 ;(R12) <-- |Cg
		TO	R11		 ;(R11) <-- |Cg~Q
		ADD	R0
;
		GETB			;(R0) <-- |CgwW
		INC	R14
;
		SWAP
		FMULT
		STB	(R1)		;|CgmDPwWZbg
		INC	R1
;
		GETB			;(R0) <-- |CgxW
		INC	R14
;
		SWAP
		FMULT
		STB	(R1)		;|CgmDPxWZbg
		INC	R1
;
		IWT	R2,#0FFB1H-030H
		TO	R2		;(R2) <-- lhm|CgxW
		ADD	R2
;
		IBT	R3,#00		;(R3) <-- V䈳k`ύX`FbNf[^Zbg
;
		DEC	R12		;|Cg|P
;
		CACHE
;
		MOVE	R13,R15
BKMKJ_P_ZOOM_10
		GETB			;(R0) <-- |CgwW
		INC	R14
;
		SWAP
		FMULT
		STB	(R1)		;|CgwWZbg
;
		GETB			;(R0) <-- |CgxW
;
		SWAP
		FMULT
		TO	R4		;(R4) <-- V䈳k`ύXx
		SUB	R2
		BPL	BKMKJ_P_ZOOM_30 ;lhm|CgxWI[o[H ( no:BKMKJ_P_ZOOM_30 )
		INC	R14
;
		FROM	R2
		SUB	R3
		BPL	BKMKJ_P_ZOOM_20 ;O|CgxWI[o[H ( yes:BKMKJ_P_ZOOM_20 )
		FROM	R1
;
		TO	R5		;(R5) <-- O|CgwW|C^[
		SUB	#2
		TO	R3		;(R3) <-- O|CgwW
		LDB	(R5)
		FROM	R4		;V䈳k`ύXx^S
		NOT
		INC	R0
		LSR
		LSR
		ADD	R3
		STB	(R5)
BKMKJ_P_ZOOM_20
		MOVE	R0,R2
BKMKJ_P_ZOOM_30
		INC	R1
		STB	(R1)		;|CgxWZbg
		MOVE	R3,R0		;(R3) <-- V䈳k`ύX`FbNf[^
;
		LOOP
		INC	R1
;
		IWT	R1,#BSPL_B_POINT+1 ;(R1) <-- |Cgf[^|C^[
		IWT	R2,#BSPL_B_POINT_B ;(R2) <-- |Cgf[^a||C^[
;
		MOVE	R12,R11
		MOVE	R13,R15
BKMKJ_P_ZOOM_40
		LDB	(R1)
		STB	(R2)
		INC	R1
;
		LOOP
		INC	R2
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNW|CgZbg				-
;-			in :						-
;------------------------------------------------------------------------
BKMKJ_P_RET	EQU	$
		IWT	R3,#BSPL_B_POINT_B  ;(R3) <-- |Cgf[^a||C^[
		IWT	R1,#BSPL_B_POINT    ;(R1) <-- |Cgf[^|C^[
		TO	R12		    ;(R12) <-- |Cg
		LDB	(R1)
		INC	R1
;
		CACHE
;
		MOVE	R13,R15
BKMKJ_P_RET_010
		LDB	(R1)
		TO	R2		;(R2) <-- |CgwW
		SEX
;
		LDB	(R3)
		INC	R3
		SEX			;(R0) <-- |CgwW
;
		SUB	R2
		BEQ	BKMKJ_P_RET_030
		INC	R3
;
		HIB
		SEX
		BMI	BKMKJ_P_RET_020
		NOP
;
		INC	R0
BKMKJ_P_RET_020
		ADD	R2		;|CgwW␳
		STB	(R1)
BKMKJ_P_RET_030
		INC	R1
;
		LOOP
		INC	R1
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNW|CgړZbg				-
;-			in :						-
;-				(R6) <-- ړ				-
;------------------------------------------------------------------------
BKMKJ_P_MOVE	EQU	$
		IWT	R10,#BSPL_B_POINT_B ;(R1)  <-- |Cgf[^a||C^[
		IWT	R1,#BSPL_B_POINT    ;(R1)  <-- |Cgf[^|C^[
		TO	R12		    ;(R12) <-- |Cg
		LDB	(R1)
		INC	R1
;
		INC	R1
		TO	R3		;(R3) <-- lhmxW
		LDB	(R1)
		DEC	R1
;
		IWT	R2,#BSPL_MV_BUFF ;(R2) <-- |Cgړlobt@|C^[
;
		CACHE
;
		MOVE	R13,R15
BKMKJ_P_MOVE_10
		TO	R5		;(R5) <-- |CgwW
		LDB	(R1)
		MOVE	R7,R1
		INC	R1
;
		LDB	(R1)		;(R0) <-- |CgxW
		INC	R1
;
		SEX
		SUB	R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
;
		TO	R8		;(R8) <-- |Cgړvl
		LDW	(R2)
		INC	R2
		INC	R2
		SBK
;
		SUB	R8		;(R0) <-- |Cgړl
		MOVE	R8,R0		;(R8) <--	 "
		ADD	R5
		STB	(R7)
;
		LDB	(R10)
		ADD	R8
		STB	(R10)
		INC	R10
;
		LOOP
		INC	R10
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNWn`lZbg				-
;-			in :						-
;-				(R1) <-- \wW			-
;-				(R2) <-- \xW			-
;-				(R3) <-- lhmx			-
;-				(R4) <-- l`wx			-
;-				(R5) <-- n`lCfbNX		-
;-				(R6) <-- h`px			-
;-				(CWK0) <-- S\tOiO\j -
;-				(CWK1) <-- {				-
;-			out :						-
;-				(CWK0) <-- Ŝw␳l		-
;------------------------------------------------------------------------
;
;-------------- {XPNWn`lZbgf[^ --------------------------
BKMKJ_OAMDT	EQU	$
;			[Y]   [X]   n
		BYTE	0C8H,028H/2,2	;[]
		BYTE	0C8H,070H/2,2	;[E]
		BYTE	080H,04CH/2,1	;[]
		BYTE	09CH,0D0H/2,8	;[ق؂]
		BYTE	054H,0A8H/2,2	;[͂Ă]
		BYTE	040H,0C8H/2,1	;[͂Ă]
		BYTE	0E8H,010H/2,5	;[̖̔]
		BYTE	0E0H,0ECH/2,5	;[E̖̔]
		BYTE	0C0H,11CH/2,1	;[ÊP{̖]
BKMKJ_OAMDT_E	EQU	$
;
BKMKJ_OAMST	EQU	$
		IBT	R0,#BANK BKMKJ_OAMDT
		ROMB
		IWT	R14,#BKMKJ_OAMDT
;
		WITH	R2		;g|cl`obt@TCYɂxW␳
		SUB	#8
;
		WITH	R3
		SEX
		WITH	R4
		SEX
;
		FROM	R4
		TO	R3		;(R3) <-- x
		SUB	R3
;
		IWT	R8,#HDMABF	;(R8) <-- wg|cl`obt@|C^[
		IWT	R9,#HDMABF1	;(R9) <-- wړg|cl`obt@|C^[
;
		CACHE
;
		IBT	R7,#(BKMKJ_OAMDT_E-BKMKJ_OAMDT)/3
BKMKJ_OAMST_010
		GETB			;(R0) <-- xʒu{
		INC	R14
;
		UMULT	R3
		HIB
		TO	R10		;(R10) <-- \xŴx
		SUB	R4
;
		FROM	R2
		SUB	R10		;[^eXN[Ȃ̂łxTCYI[o[`FbNII]
		MOVE	R11,R0		;(R11) <-- `FbNxW
		ADD	R0		;x2
		ADD	R8
		LDW	(R0)
		ADD	R11
		ADD	#1+8
		TO	R12		;(R12) <-- `FbNxŴw
		LOB
;
		GETBS			;(R0)  <-- wʒu{
		MOVE	R13,R0		;(R13) <--     h
		INC	R14
;
		UMULT	R12
		ADD	R0		;x2
		HIB
		ADD	R0		;x2
		SUB	R12
		TO	R12		;(R12) <-- SwŴw
		DIV2
;
		FROM	R9
		ADD	R11
		ADD	R11
		TO	R11
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R11
		ADD	R12
		TO	R11		;(R11) <-- \wŴw
		SUB	R1
;
		IBT	R0,#040H	;h`pxW␳lvZ
		SUB	R13
		BCS	BKMKJ_OAMST_012
		ADD	R13
;
		ADD	R0		;[ IWT R0,#080H ]
		TO	R13
		SUB	R13
		BCC	BKMKJ_OAMST_014
		SUB	R0
;
BKMKJ_OAMST_012
		FROM	R13
BKMKJ_OAMST_014
		UMULT	R6
		ADD	R0		;x2
		HIB
		WITH	R10		;(R10) <-- \xŴx
		SUB	R0
;
		TO	R12
		GETB
		INC	R14
;
		MOVE	R13,R15
BKMKJ_OAMST_020
		LDW	(R5)
		ADD	R11
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
;
		LDW	(R5)
		SUB	R10
;
		WITH	R5
		ADD	#6
;
		LOOP
		SBK			;[ STW (R5) ]
;
		DEC	R7
		BNE	BKMKJ_OAMST_010+1
		GETB
;
;-------------- tbv̖т̂wW␳ ------------------------------
		LMS	R6,CWORK1	;(R6) <-- {
		IWT	R0,#2AH*100H
		TO	R7		;(R7) <-- tbv̖т̕␳l
		FMULT
;
		IBT	R0,#(5+5+1)*8
		WITH	R5
		SUB	R0
		LDW	(R5)
		SUB	R7
		SBK			;[ STW (R5) ]
;
		IBT	R0,#5*8
		TO	R5
		ADD	R5
		LDW	(R5)
		ADD	R7
		IBT	R7,#010H
		SUB	R7
		SBK			;[ STW (R5) ]
;
;-------------- ŜwW␳ ----------------------------------------
		LMS	R0,CWORK0
		SUB	#0
		BMI	BKMKJ_OAMST_050 ;S\H ( no:BKMKJ_OAMST_050 )
		NOP
;
		IBT	R0,#(5+1)*8
		TO	R5		;(R5) <-- Ŝn`lCfbNX
		ADD	R5
;
		IWT	R0,#08FH
		LMULT
		IWT	R0,#080H
		ADD	R4
		TO	R10
		HIB
;
		FROM	R8
		ADD	R2
		ADD	R2
		LDW	(R0)
		ADD	R2
		ADD	#1+8
		SUB	R10
		TO	R10
		DIV2
;
		FROM	R9
		ADD	R2
		ADD	R2
		TO	R11
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R11
		SUB	R1
		TO	R11		;(R11) <-- \wŴw
		ADD	R10
		SMS	R11,CWORK0	;(CWK0) <-- Ŝw␳l
;
		IBT	R12,#4
		MOVE	R13,R15
BKMKJ_OAMST_030
		LDW	(R5)
		ADD	R11
;
		WITH	R5
		ADD	#8
;
		LOOP
		SBK			;[ STW (R5) ]
;
BKMKJ_OAMST_050
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNW|CgZbg			-
;-			in :						-
;-				(R0)  <-- |Cgf[^AhX	-
;-				(R14) <--	      h		-
;-				(R7)  <-- {~POg			-
;------------------------------------------------------------------------
BKMKJ_P_DOWN	EQU	$
		ROMB
		WITH	R14
		ADD	#2*2
;
		IWT	R1,#BSPL_B_POINT+1+(2*2) ;(R1) <-- |Cgf[^|C^[
		IBT	R12,#16-3		 ;(R12) <-- |Cg
;
		IWT	R0,#010H*10H
		SUB	R7
		BMI	BKMKJ_P_DOWN_10 ;w{ύXH ( no:BKMKJ_P_DOWN_10 )
		ADD	R7
;
		MOVE	R0,R7
BKMKJ_P_DOWN_10
		MOVE	R8,R0		;(R8) <-- w{
		FROM	R7
		LSR
		LSR
		LSR
		TO	R7		;(R7) <-- x{
		LSR
;
		IBT	R2,#0B4H	;[ IWT R2,#0FFB4H ] (R2) <-- lhm|CgxW
		IBT	R3,#00		;(R3) <-- V䈳k`ύX`FbNf[
		IBT	R9,#38H		;(R9) <-- S|Cgx
;
		CACHE
;
		MOVE	R13,R15
BKMKJ_P_DOWN_20
		GETB			;(R0) <-- |CgwW
		INC	R14
;
		SWAP
		MOVE	R6,R8
		FMULT
		STB	(R1)		;|CgwWZbg
;
		GETBS			;(R0) <-- |CgxW
		SUB	R9
;
		MOVE	R6,R7
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R9
;
		TO	R4		;(R4) <-- V䈳k`ύXx
		SUB	R2
		BPL	BKMKJ_P_DOWN_40 ;lhm|CgxWI[o[H ( no:BKMKJ_P_DOWN_40 )
		INC	R14
;
		FROM	R2
		SUB	R3
		BPL	BKMKJ_P_DOWN_30 ;O|CgxWI[o[H ( yes:BKMKJ_P_DOWN_30 )
		FROM	R1
;
		TO	R5		;(R5) <-- O|CgwW|C^[
		SUB	#2
		TO	R3		;(R3) <-- O|CgwW
		LDB	(R5)
		FROM	R4		;V䈳k`ύXx^S
		NOT
		INC	R0
		LSR
		LSR
		ADD	R3
		STB	(R5)
BKMKJ_P_DOWN_30
		MOVE	R0,R2
BKMKJ_P_DOWN_40
		INC	R1
		STB	(R1)		;|CgxWZbg
		MOVE	R3,R0		;(R3) <-- V䈳k`ύX`FbNf[^
;
		LOOP
		INC	R1
;
;-------------- h`Zbg ----------------------------------------
		IWT	R10,#0100H
		FROM	R10
		SUB	R7
		ADD	R0		;x4
		ADD	R0		;
		SUB	R10
		BCC	BKMKJ_P_DOWN_50
		ADD	R10
;
		MOVE	R0,R10
BKMKJ_P_DOWN_50
		MOVE	R6,R0		;(R6) <-- h`x{
;
;-------------- ŉʃ|CgxZbg --------------------------
		IWT	R0,#(7FH-38H)*100H
		FMULT
		IBT	R3,#38H
		ADD	R3
		IWT	R1,#BSPL_B_POINT+1+(0*2)+1
		STB	(R1)
;
;-------------- ŉʗTCh|CgxZbg ------------------
		IWT	R0,#(40H-38H)*100H
		FMULT
		TO	R3
		ADD	R3
;
		IWT	R0,#0100H
		SUB	R8
		IWT	R6,#010H*100H
		FMULT
		ADD	R3
		INC	R1
		INC	R1
		STB	(R1)
;
		IWT	R2,#BSPL_B_POINT+1+(15*2)+1
		STB	(R2)
;
;-------------- ŉʗTCh|CgwZbg ------------------
		IBT	R0,#020H
		SUB	R8
		BPL	BKMKJ_P_DOWN_60
		ADD	R8
;
		MOVE	R0,R8
BKMKJ_P_DOWN_60
		IWT	R6,#040H*100H
		FMULT
		DEC	R2
		STB	(R2)
;
		NOT
		INC	R0
		DEC	R1
		STB	(R1)
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XPNWItZbgwʒuvZ			-
;-			in :						-
;-				(R1) <-- \wW			-
;-				(R2) <-- \xW			-
;-				(R3) <-- wʒu{			-
;-			out :						-
;-				(R0) <-- ItZbgwʒu		-
;------------------------------------------------------------------------
BKMKJ_OFX_CALC	EQU	$
		WITH	R2		;g|cl`obt@TCYɂxW␳
		SUB	#8
;
		FROM	R2		;x2
		ADD	R2
		IWT	R8,#HDMABF	;(R8) <-- wg|cl`obt@|C^[
		ADD	R8
		LDW	(R0)
		ADD	R2
		ADD	#1+8
		LOB
		MOVE	R12,R0		;(R12) <-- `FbNxŴw
;
		UMULT	R3
		HIB
		ADD	R0		;x2
		SUB	R12
		TO	R12		;(R12) <-- SwŴw
		DIV2
;
		IWT	R0,#HDMABF1	;(R0) <-- wړg|cl`obt@|C^[
		ADD	R2
		ADD	R2
		TO	R11
		LDW	(R0)
		IWT	R0,#0080H
		SUB	R11
		ADD	R12
		SUB	R1		;(R0) <-- \wŴw
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		Z							-
;-			in :						-
;-				(R4) <-- 폜				-
;-				(R6) <-- 				-
;-			out :						-
;-				(R7) <-- 				-
;-				(R0) <-- ]				-
;------------------------------------------------------------------------
DIV_DOUBLE	EQU	$
		SUB	R0		;(R0) <-- AL[^NA
		MOVE	R7,R0		;(R7) <-- NA
;
		IBT	R12,#32
		IWT	R13,#DIV_DOUBLE_010+1
DIV_DOUBLE_010
		WITH	R7		;փVtg
		ADD	R7
		WITH	R4		;폜փVtg
		ADD	R4
		ROL			;폜AL[^ɃVtg
		SUB	R6		;AL[^Ər
		BCC	DIV_DOUBLE_020	;AL[^ł΁AZȗ
		ADD	R6
;
		SUB	R6		;AL[^珜
		INC	R7		;ɂP
DIV_DOUBLE_020
		LOOP
		WITH	R7		;(R7) <-- vbgX^[gʒu
;
		STOP
		NOP
;
;************************************************************************
;*		~hLLhʃZbgvZ				*
;*			in :						*
;*				(R1) <-- _f[^			*
;*				(R2) <-- l`wa			*
;*				(R5) <-- ZbgXs[h			*
;*			out :						*
;*				(R1) <-- ZbgwW			*
;*				(R2) <-- ZbgxW			*
;*				(R3) <-- ZbgwXs[h		*
;*				(R4) <-- ZbgxXs[h		*
;************************************************************************
CIRCL_EXST_ST	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		FROM	R1
		LSR
		LSR
		LSR
		LSR
		LOB
		TO	R7		;(R7) <-- Zbga~POOg
		UMULT	R2
;
		FROM	R1
		AND	#0FH
		ADD	R0		;x16
		UMULT	#8		;
		IWT	R14,#LCOS
		TO	R14
		ADD	R14
		GETBS
		ADD	R0		;x4
		TO	R6		;(R6) <-- bnrf[^
		ADD	R0		;
;
		FROM	R7
		TO	R1		;(R1) <-- ZbgwW
		FMULT
;
		FROM	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3		;(R3) <-- ZbgwXs[h
		OR	R4
;
		IBT	R0,#040H	;[ IWT R14,#LSIN ]
		TO	R14
		ADD	R14
		GETBS
		ADD	R0		;x4
		TO	R6		;(R6) <-- rhmf[^
		ADD	R0		;
;
		FROM	R7
		TO	R2		;(R2) <-- ZbgxW
		FMULT
;
		FROM	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R4		;(R4) <-- ZbgxXs[h
		OR	R4
;
		STOP
		NOP
;
;
;
;
;
		END
