;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.5				*
;*	file name	: ys_chip5					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
		include		ys_chip2.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	WSIN,WCOS
;
		GLB	SPARK_XSPD,SPARK_YSPD,SPARK_NEXT,SPARK_ANG
		GLB	SPARK_XREV,SPARK_YREV
		GLB	SPARK_XSPD3,SPARK_YSPD3,SPARK_ANG3
		GLB	SPARK_XREV3,SPARK_YREV3
		GLB	SPARK_BGCKXP,SPARK_BGCKYP,SPARK_BGCKXP2,SPARK_BGCKYP2
		GLB	SPARK_BGCKDT_SK
		GLB	SPARK_RET_XREV,SPARK_RET_YREV
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_chip2 >-----------------------------------------------
;
;-------------< ys_mpldt >-----------------------------------------------
		EXT	M_TAN
;
;-------------< ys_mplay0 >-----------------------------------------------
		EXT	M_RAD_GET_S
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_B		GROUP	S_chip_5
S_chip_5	SECT	REL
;
;
;************************************************************************
;*	cos data							*
;************************************************************************
WCOS		EQU	$
		WORD	00100H,00100H,00100H,00100H,00100H,00100H,000FFH,000FFH
		WORD	000FFH,000FEH,000FEH,000FEH,000FDH,000FDH,000FCH,000FCH
		WORD	000FBH,000FAH,000FAH,000F9H,000F8H,000F8H,000F7H,000F6H
		WORD	000F5H,000F4H,000F3H,000F2H,000F1H,000F0H,000EFH,000EEH
		WORD	000EDH,000EBH,000EAH,000E9H,000E7H,000E6H,000E5H,000E3H
		WORD	000E2H,000E0H,000DFH,000DDH,000DCH,000DAH,000D8H,000D7H
		WORD	000D5H,000D3H,000D1H,000CFH,000CEH,000CCH,000CAH,000C8H
		WORD	000C6H,000C4H,000C2H,000C0H,000BEH,000BCH,000B9H,000B7H
		WORD	000B5H,000B3H,000B1H,000AEH,000ACH,000AAH,000A7H,000A5H
		WORD	000A2H,000A0H,0009DH,0009BH,00098H,00096H,00093H,00091H
		WORD	0008EH,0008CH,00089H,00086H,00084H,00081H,0007EH,0007BH
		WORD	00079H,00076H,00073H,00070H,0006DH,0006BH,00068H,00065H
		WORD	00062H,0005FH,0005CH,00059H,00056H,00053H,00050H,0004DH
		WORD	0004AH,00047H,00044H,00041H,0003EH,0003BH,00038H,00035H
		WORD	00032H,0002FH,0002CH,00029H,00026H,00022H,0001FH,0001CH
		WORD	00019H,00016H,00013H,00010H,0000DH,00009H,00006H,00003H
;
WSIN		EQU	$
		WORD	00000H,0FFFDH,0FFFAH,0FFF7H,0FFF3H,0FFF0H,0FFEDH,0FFEAH
		WORD	0FFE7H,0FFE4H,0FFE1H,0FFDEH,0FFDAH,0FFD7H,0FFD4H,0FFD1H
		WORD	0FFCEH,0FFCBH,0FFC8H,0FFC5H,0FFC2H,0FFBFH,0FFBCH,0FFB9H
		WORD	0FFB6H,0FFB3H,0FFB0H,0FFADH,0FFAAH,0FFA7H,0FFA4H,0FFA1H
		WORD	0FF9EH,0FF9BH,0FF98H,0FF95H,0FF93H,0FF90H,0FF8DH,0FF8AH
		WORD	0FF87H,0FF85H,0FF82H,0FF7FH,0FF7CH,0FF7AH,0FF77H,0FF74H
		WORD	0FF72H,0FF6FH,0FF6DH,0FF6AH,0FF68H,0FF65H,0FF63H,0FF60H
		WORD	0FF5EH,0FF5BH,0FF59H,0FF56H,0FF54H,0FF52H,0FF4FH,0FF4DH
		WORD	0FF4BH,0FF49H,0FF47H,0FF44H,0FF42H,0FF40H,0FF3EH,0FF3CH
		WORD	0FF3AH,0FF38H,0FF36H,0FF34H,0FF32H,0FF31H,0FF2FH,0FF2DH
		WORD	0FF2BH,0FF29H,0FF28H,0FF26H,0FF24H,0FF23H,0FF21H,0FF20H
		WORD	0FF1EH,0FF1DH,0FF1BH,0FF1AH,0FF19H,0FF17H,0FF16H,0FF15H
		WORD	0FF13H,0FF12H,0FF11H,0FF10H,0FF0FH,0FF0EH,0FF0DH,0FF0CH
		WORD	0FF0BH,0FF0AH,0FF09H,0FF08H,0FF08H,0FF07H,0FF06H,0FF06H
		WORD	0FF05H,0FF04H,0FF04H,0FF03H,0FF03H,0FF02H,0FF02H,0FF02H
		WORD	0FF01H,0FF01H,0FF01H,0FF00H,0FF00H,0FF00H,0FF00H,0FF00H
		WORD	0FF00H,0FF00H,0FF00H,0FF00H,0FF00H,0FF00H,0FF01H,0FF01H
		WORD	0FF01H,0FF02H,0FF02H,0FF02H,0FF03H,0FF03H,0FF04H,0FF04H
		WORD	0FF05H,0FF06H,0FF06H,0FF07H,0FF08H,0FF08H,0FF09H,0FF0AH
		WORD	0FF0BH,0FF0CH,0FF0DH,0FF0EH,0FF0FH,0FF10H,0FF11H,0FF12H
		WORD	0FF13H,0FF15H,0FF16H,0FF17H,0FF19H,0FF1AH,0FF1BH,0FF1DH
		WORD	0FF1EH,0FF20H,0FF21H,0FF23H,0FF24H,0FF26H,0FF28H,0FF29H
		WORD	0FF2BH,0FF2DH,0FF2FH,0FF31H,0FF32H,0FF34H,0FF36H,0FF38H
		WORD	0FF3AH,0FF3CH,0FF3EH,0FF40H,0FF42H,0FF44H,0FF47H,0FF49H
		WORD	0FF4BH,0FF4DH,0FF4FH,0FF52H,0FF54H,0FF56H,0FF59H,0FF5BH
		WORD	0FF5EH,0FF60H,0FF63H,0FF65H,0FF68H,0FF6AH,0FF6DH,0FF6FH
		WORD	0FF72H,0FF74H,0FF77H,0FF7AH,0FF7CH,0FF7FH,0FF82H,0FF85H
		WORD	0FF87H,0FF8AH,0FF8DH,0FF90H,0FF93H,0FF95H,0FF98H,0FF9BH
		WORD	0FF9EH,0FFA1H,0FFA4H,0FFA7H,0FFAAH,0FFADH,0FFB0H,0FFB3H
		WORD	0FFB6H,0FFB9H,0FFBCH,0FFBFH,0FFC2H,0FFC5H,0FFC8H,0FFCBH
		WORD	0FFCEH,0FFD1H,0FFD4H,0FFD7H,0FFDAH,0FFDEH,0FFE1H,0FFE4H
		WORD	0FFE7H,0FFEAH,0FFEDH,0FFF0H,0FFF3H,0FFF7H,0FFFAH,0FFFDH
		WORD	00000H,00003H,00006H,00009H,0000DH,00010H,00013H,00016H
		WORD	00019H,0001CH,0001FH,00022H,00026H,00029H,0002CH,0002FH
		WORD	00032H,00035H,00038H,0003BH,0003EH,00041H,00044H,00047H
		WORD	0004AH,0004DH,00050H,00053H,00056H,00059H,0005CH,0005FH
		WORD	00062H,00065H,00068H,0006BH,0006DH,00070H,00073H,00076H
		WORD	00079H,0007BH,0007EH,00081H,00084H,00086H,00089H,0008CH
		WORD	0008EH,00091H,00093H,00096H,00098H,0009BH,0009DH,000A0H
		WORD	000A2H,000A5H,000A7H,000AAH,000ACH,000AEH,000B1H,000B3H
		WORD	000B5H,000B7H,000B9H,000BCH,000BEH,000C0H,000C2H,000C4H
		WORD	000C6H,000C8H,000CAH,000CCH,000CEH,000CFH,000D1H,000D3H
		WORD	000D5H,000D7H,000D8H,000DAH,000DCH,000DDH,000DFH,000E0H
		WORD	000E2H,000E3H,000E5H,000E6H,000E7H,000E9H,000EAH,000EBH
		WORD	000EDH,000EEH,000EFH,000F0H,000F1H,000F2H,000F3H,000F4H
		WORD	000F5H,000F6H,000F7H,000F8H,000F8H,000F9H,000FAH,000FAH
		WORD	000FBH,000FCH,000FCH,000FDH,000FDH,000FEH,000FEH,000FEH
		WORD	000FFH,000FFH,000FFH,00100H,00100H,00100H,00100H,00100H
		WORD	00100H,00100H,00100H,00100H,00100H,00100H,000FFH,000FFH
		WORD	000FFH,000FEH,000FEH,000FEH,000FDH,000FDH,000FCH,000FCH
		WORD	000FBH,000FAH,000FAH,000F9H,000F8H,000F8H,000F7H,000F6H
		WORD	000F5H,000F4H,000F3H,000F2H,000F1H,000F0H,000EFH,000EEH
		WORD	000EDH,000EBH,000EAH,000E9H,000E7H,000E6H,000E5H,000E3H
		WORD	000E2H,000E0H,000DFH,000DDH,000DCH,000DAH,000D8H,000D7H
		WORD	000D5H,000D3H,000D1H,000CFH,000CEH,000CCH,000CAH,000C8H
		WORD	000C6H,000C4H,000C2H,000C0H,000BEH,000BCH,000B9H,000B7H
		WORD	000B5H,000B3H,000B1H,000AEH,000ACH,000AAH,000A7H,000A5H
		WORD	000A2H,000A0H,0009DH,0009BH,00098H,00096H,00093H,00091H
		WORD	0008EH,0008CH,00089H,00086H,00084H,00081H,0007EH,0007BH
		WORD	00079H,00076H,00073H,00070H,0006DH,0006BH,00068H,00065H
		WORD	00062H,0005FH,0005CH,00059H,00056H,00053H,00050H,0004DH
		WORD	0004AH,00047H,00044H,00041H,0003EH,0003BH,00038H,00035H
		WORD	00032H,0002FH,0002CH,00029H,00026H,00022H,0001FH,0001CH
		WORD	00019H,00016H,00013H,00010H,0000DH,00009H,00006H,00003H
;
;****************************************************************
;*		fuantei yuka check				*
;****************************************************************
;R1	[w@onrDPOOg
;R2	f[^
;R4	`FbNx@onrD̏
;R7	vC[`FbNw@onrD
;R8	vC[`FbNx@onrD
;R9	]piO`POOgj
;R12	͈̓`FbNpf[^
;R13	vC[nmtO
;
M_FYUKA_CHECK	EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R9

		IWT	R0,#COS
		TO	R10
		ADD	R9

		GETB
		INC	R14
		GETBH

		MOVE	R11,R0

		MOVE	R6,R4			;SIN * Y
		TO	R5
		FMULT

		MOVE	R14,R10

		GETB
		INC	R14
		GETBH

		MOVE	R10,R0

		MOVE	R6,R1			;COS * X
		FMULT
		SUB	R5			;R0 <- RANGE X POS.
		SUB	R7			;WO ?
		XOR	R12			;
		BPL	F_CHK0800		; yes: F_CHK0800
		SUB	R0			;

		MOVE	R6,R4			;R6 <- ( SIN * Y + X' )
		FROM	R11
		FMULT
		ADD	R7
		LOB
		TO	R6
		SWAP

		FROM	R2			;R3 <- TAN * Y
		TO	R3
		FMULT

		IBT	R5,#008H

		MOVE	R6,R4			;COS * Y
		FROM	R10
		FMULT
		SUB	R3			;R0 <- CHECK Y POS.
		MOVE	R7,R0

		MOVES	R13,R13			;vC[͂łɏĂ ?
		BNE	F_CHK0500		; yes: F_CHK0500
		NOP

		SUB	R8
		ADD	R5
		WITH	R5
		ADD	R5
		CMP	R5			;ɏĂ ?
		BCS	F_CHK0800		;  no: F_CHK0800
		SUB	R0

F_CHK0500
		SMS	R7,CWORK1E

		IBT	R0,#001
		SMS	R0,CWORK1F

		STOP
		NOP

F_CHK0800
		SMS	R0,CWORK1F

		STOP
		NOP
;
M_FYUKA_POSCALC EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R10
		ADD	R1

		GETB
		INC	R14
		GETBH

		TO	R1
		FMULT

		MOVE	R14,R10

		GETB
		INC	R14
		GETBH

		FMULT

		STOP
		NOP
;
;****************************************************************
;*		zoom char. vs player check			*
;****************************************************************
M_ZOOM_PLCHK	EQU	$
		FMULT
		ADD	R7
		SMS	R0,CWORK1E
		ADD	R0
		INC	R0
		SMS	R0,CWORK1C

		MOVE	R6,R9
		FROM	R1
		FMULT
		SMS	R0,CWORK1B
		ADD	R8
		ADD	R3
		SMS	R0,CWORK1F
		ADD	R0
		INC	R0
		SMS	R0,CWORK1D

		STOP
		NOP
;
;****************************************************************
;*		enemy 1 point rotation				*
;****************************************************************
;[IN]		R1	px	i@őPed@j
;		R6	aAXJ[ʁAD
;
;[OUT]		R0	w
;		R1	x
;
M_ENMY_1P_ROT	EQU	$
		mJSR	M_ENMY_1P_ROT_S

		STOP
		NOP
;
M_ENMY_1P_ROT_S EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R2
		ADD	R1

		GETB
		INC	R14
		GETBH
		LMULT
		IWT	R3,#00080H
		WITH	R4
		ADD	R3
		ADC	#00
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R1
		OR	R4

		MOVE	R14,R2
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		ADD	R3
		ADC	#00
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		mRTS
;
;****************************************************************
;*	ԃtĝn`lZbgɊւ鐔ľvZ		*
;*								*
;*	[In]							*
;*		R1	px	i@őPed@j		*
;*		R6	a					*
;*		R9	̐{P				*
;*	[Out]							*
;*		R7	w					*
;*		R8	x					*
;*		R9	w / R9				*
;*		R10	x / R9				*
;*								*
;****************************************************************
M_MILL0_OAM_CAL EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R2
		ADD	R1

		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8
		OR	R4

		MOVE	R14,R2
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R7
		OR	R4

		IWT	R1,#DIVBUF
		FROM	R9
		TO	R6
		ADD	R9
		WITH	R1
		ADD	R6

		TO	R6
		LDW	(R1)

		FROM	R7
		TO	R9
		FMULT

		FROM	R8
		TO	R10
		FMULT

		STOP
		NOP
;;
;****************************************************************
;*		maruta bashi vs player check			*
;****************************************************************
;
;		R2	ۑ̂w@onrDƑΏەƂ̋iۑ̈ʒuCfbNXvZpj
;		R3	ۑ̂w@onrDƑΏەƂ̋
;		R6	ۑ̂l`w
;		R8	Ώە̃Z^[x@onrD
;		R9	Ώە̂x`FbN
;		R10	ۑ̂x@onrD
;
;		WRK0	[̊ۑ̃ItZbgx@onrD
;		WRK1			h
;		WRK2	E		h
;		WRK2	E[		h
;		WRK1E	ۑ̂l`w@i[pj
;		WRK1F	ۑ̂l`w@ipj
;
M_MARUT_CHK	EQU	$
		IWT	R11,#CWORK0
		IBT	R5,#010H

		IBT	R7,#0F8H		;WRK10 <- Ԗڂ̊ۑɏĂ邩
		FROM	R2			;
		AND	R7			;
		LSR				;
		LSR				;
		SMS	R0,CWORK10		;
		ADD	R11
		LDW	(R0)
		ADD	R10
		SUB	R8
		CMP	R9			;vC[Ă ?
		BPL	M_MARUT_CHK1000		;
		NOP				;
						;
;		ADD	R5			;
;		CMP	R9			;
;		BMI	M_MARUT_CHK1000		;  no: M_MARUT_CHK1000
;		NOP				;
;
		ADD	R9
		BMI	M_MARUT_CHK1000
		NOP

		INC	R1

		LMS	R0,CWORK10
		TO	R10
		AND	#02
		WITH	R11
		ADD	R10

		WITH	R2
		SUB	R2
		LMS	R8,CWORK1E
		LMS	R9,CWORK1F
		IBT	R7,#010H
		IBT	R5,#038H
		IBT	R12,#004
		CACHE
		MOVE	R13,R15

		MOVES	R0,R3			;̊ۑ ?
		BMI	M_MARUT_CHK0500		; yes: M_MARUT_CHK0500
		NOP

		NOT
		INC	R0

M_MARUT_CHK0500
		ADD	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		STW	(R11)

		WITH	R3
		ADD	R7

		MOVES	R2,R2			;[̊ۑ ?
		BNE	M_MARUT_CHK0600		;  no: M_MARUT_CHK0600
		NOP

		MOVE	R6,R9

M_MARUT_CHK0600
		FROM	R2			;E[̊ۑ ?
		SUB	#002			;
		BNE	M_MARUT_CHK0700		;  no: M_MARUT_CHK0700
		NOP

		MOVE	R6,R8

M_MARUT_CHK0700
		WITH	R11
		ADD	#04

		LOOP
		INC	R2

M_MARUT_CHK0800
		FROM	R10			;␳ ?
		SUB	#0			;
		BNE	M_MARUT_CHK2000		;  no: M_MARUT_CHK2000
		NOP

		SUB	R0
		SMS	R0,CWORK8
		LMS	R2,CWORK0
		LMS	R3,CWORK2
		IWT	R10,#CWORK4
		IWT	R11,#CWORK1

		IBT	R12,#004

		MOVE	R13,R15

		FROM	R2
		ADD	R3
		LSR
		STB	(R11)

		MOVE	R2,R3
		TO	R3
		LDB	(R10)

		WITH	R10
		ADD	#4
		WITH	R11
		ADD	#4

		LOOP
		NOP

M_MARUT_CHK1000

		STOP
		NOP

M_MARUT_CHK2000
		IBT	R2,#000
		LMS	R3,CWORK1
		IWT	R10,#CWORK3
		IWT	R11,#CWORK0

		IBT	R12,#004

		MOVE	R13,R15

		FROM	R2
		ADD	R3
		LSR
		STB	(R11)

		MOVE	R2,R3
		TO	R3
		LDB	(R10)

		WITH	R10
		ADD	#4
		WITH	R11
		ADD	#4

		LOOP
		NOP

		STOP
		NOP
;
;****************************************************************
;*		|Z[`	( R0*R6/100H )			*
;*								*
;*	[In]							*
;*		R0						*
;*		R6						*
;*	[Out]							*
;*		R0						*
;*								*
;****************************************************************
MULTIPLY	EQU	$
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		STOP
		NOP
;
;****************************************************************
;*		Z[`	( R0*(100H/R6) )		*
;*								*
;*	[In]							*
;*		R0						*
;*		R6						*
;*	[Out]							*
;*		R0						*
;*								*
;****************************************************************
DIVIDE		EQU	$
		IWT	R1,#DIVBUF
		WITH	R6
		ADD	R6
		WITH	R1
		ADD	R6

		TO	R6
		LDW	(R1)

		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		STOP
		NOP
;
;****************************************************************
;*								*
;*		vZ[`				*
;*								*
;*	[In]							*
;*		r1	xXs[h				*
;*		r2	vZf[^ixXs[h^Sj	*
;*		r3	POO̎̃f[^			*
;*								*
;*	[Out]							*
;*		r0	result					*
;*								*
;****************************************************************
M_PERCENT_VALUE EQU	$
		IWT	R0,#DIVBUF
		ADD	R2

		TO	R6
		LDW	(R0)

		FROM	R1
		LSR
		LSR
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		MOVE	R6,R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		STOP
		NOP
;
;****************************************************************
;*								*
;*		oEhuU[Y@Z␳			*
;*								*
;*	[In]							*
;*		r0	ǂԂ̒a				*
;*		r1	̈ʒu				*
;*		r2	ENYPSL					*
;*		r6	{					*
;*		r3	̒				*
;*								*
;*	[Out]							*
;*		r0	result					*
;*								*
;****************************************************************
M_BBROS_B_REV	EQU	$
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		ADD	R2
		ADD	R1
		SUB	R3

		STOP
		NOP
;
;****************************************************************
;*								*
;*		ENEMY 1POINT ROTATION & ZOOM			*
;*								*
;*	[In]							*
;*		r1	px	i@őPed@j		*
;*		r2	w{					*
;*		r3	x{					*
;*		r5	aAXJ[ʁAD		*
;*								*
;*	[Out]							*
;*		r0	w					*
;*		r1	x					*
;*								*
;****************************************************************
M_ENMY_ROTZOM	EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R10
		ADD	R1

		GETB
		INC	R14
		GETBH
		MOVE	R6,R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4

		FROM	R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R1
		OR	R4

		MOVE	R14,R10
		GETB
		INC	R14
		GETBH
		MOVE	R6,R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4

		FROM	R2
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		STOP
		NOP
;
;****************************************************************
;*								*
;*		ENEMY TRIANGLE CALC				*
;*								*
;*	[In]							*
;*		r0	wvhcd	i@őPee@j	*
;*		r2	xvhcd	i@őPee@j	*
;*		r6	xroc				*
;*								*
;*	[Out]							*
;*		r0	wroc				*
;*								*
;****************************************************************
M_TRIANGLE_CALC EQU	$
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4

		IWT	R3,#DIVBUF
		FROM	R2
		ADD	R2
		ADD	R3
		LDW	(R0)

		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		STOP
		NOP
;
;********************************************************************************
;*		łԂف[ǂʂn`lZbg					*
;*										*
;*	[In]									*
;*		(R1)  <-- ENDSXL						*
;*		(R2)  <-- ENDSYL						*
;*		(R6)  <-- {						*
;*		REG6  <-- c{						*
;*		(R7)  <-- ENCHPT						*
;*		(R8)  <-- ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R0)  <-- n`lZbgf[^oN				*
;*		(R14) <-- n`lZbgonrDf[^AhX			*
;*		(R12) <-- n`lZbgonrDf[^w␳l			*
;*		(R13) <-- n`lZbgonrDf[^x␳l			*
;*		WRK0  <-- n`lZbgf[^AhX				*
;*										*
;********************************************************************************
M_DBAHO_OAMSET	EQU	$
		ROMB
;
		SMS	R1,CWORK1
		SMS	R2,CWORK2

		IWT	R0,#CENOAML
		ADD	R10
		LDW	(R0)
		MOVES	R4,R0
		BPL	DBAHO_OAMSET_000 ;n`lmہH ( yes:DBAHO_OAMSET_000 )
		FROM	R14
;
		STOP
		NOP
;
DBAHO_OAMSET_000
		ADD	R8		;onrDf[^AhX̌vZ
		TO	R14		;
		ADD	R8		;
;
		SMS	R4,REG4
;
		GETBS
		INC	R14
		TO	R3		;X0 Ô͂
		ADD	R12
		GETBS
		INC	R14
		TO	R11		;Y0
		ADD	R13
		GETBS
		INC	R14
		TO	R5		;X1 ̂͂
		ADD	R12
		GETBS
		TO	R9		;Y1
		ADD	R13
;
		FROM	R5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SUB	R5
		ADD	R1
		SMS	R0,CWORK1

		FROM	R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SUB	R3
		TO	R1
		ADD	R1
;
		LMS	R6,REG6
;
		FROM	R9
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
;		FROM	R9
;		SUB	R0
		SUB	R9
		ADD	R2
		SMS	R0,CWORK2
;
		FROM	R11
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
;		FROM	R11
;		SUB	R0
		SUB	R11
		TO	R2
		ADD	R2

		LMS	R4,REG4
;
		LMS	R0,CWORK0
		ADD	R7
		TO	R14
		ADD	R7
;
		GETB
		INC	R14
		TO	R14			;(R14) <-- Zbgp^[n`lZbgf[^AhX
		GETBH
;
		IWT	R0,#CENCLOR		;ATR SET
		ADD	R10
		TO	R3
		LDB	(R0)
		FROM	R8			;ENMUKI
		ADD	R8
		ADD	R0
		MULT	#008H
		XOR	R3
		TO	R3
		SWAP
;
		IWT	R0,#CENCHRB
		ADD	R10
		LDB	(R0)
		MULT	#8
		SMS	R0,CWORK0		;LN^[oN
;
		IWT	R0,#CENEMU0		;DATA SET
		ADD	R10
		LDB	(R0)
		TO	R10
		SWAP
;
		IBT	R12,#06			;n`lZbg
;
		CACHE
;
		MOVE	R13,R15			; loop address set
DBAHO_OAMSET_110
		GETBS
;
		IWT	R9,#4000H		;H flip check data
		WITH	R9
		AND	R3
		BEQ	DBAHO_OAMSET_120	;H frip ? [ no:DBAHO_OAMSET_120 ]
		INC	R14			;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC	R0
		IBT	R9,#008H
DBAHO_OAMSET_120
		TO	R5
		ADD	R1			; r5 <- x position
;
		GETBS
;
		IBT	R8,#00H			;V flip check data
		MOVES	R3,R3
		BPL	DBAHO_OAMSET_130	;V frip ? [ no:DBAHO_OAMSET_130 ]
		INC	R14
;
		NOT
		INC	R0
		IBT	R8,#008H
DBAHO_OAMSET_130
		TO	R6
		ADD	R2		; r6 <- y position
;
		GETB
		INC	R14
		GETBH
		INC	R14
;
		TO	R7
		XOR	R3		; R7 <- atoribute & chara No.
;
		GETB			; oamsb
		AND	#02H
		BNE	DBAHO_OAMSET_140
		NOP
;
		WITH	R5
		ADD	R9
		WITH	R6
		ADD	R8
DBAHO_OAMSET_140
		GETBH			;(R0) <-- sub,data
		INC	R14
;
		FROM	R5
		STW	(R4)		; x position
		INC	R4
		INC	R4
;
		TO	R5		; r5 <- sub,data
		XOR	R10
;
		FROM	R6
		STW	(R4)		; y position
		INC	R4
		INC	R4
		LMS	R0,CWORK0	;(R0) <-- LN^[oN
		ADD	R7
		STW	(R4)		; chara No., atoribute
		INC	R4
		INC	R4
		FROM	R5
		STW	(R4)		; oamsb,data
;
		FROM	R12			;ỎHƌ̉H̊ ?
		SUB	#004			;
		BNE	DBAHO_OAMSET_150	;  no: DBAHO_OAMSET_150
		INC	R4

		IBT	R0,#08*4
		WITH	R4
		ADD	R0
		LMS	R1,CWORK1
		LMS	R2,CWORK2

DBAHO_OAMSET_150
		LOOP
		INC	R4
;
		STOP
		NOP
;
;********************************************************
;*							*
;********************************************************
SPARK_XSPD	EQU	$
		HEX	000,000,059,000,0A7
SPARK_XSPD_RT	EQU	$
		HEX	059,0A7,000,000,000
SPARK_XSPD2	EQU	$
		HEX	000,000,0A7,000,059
SPARK_XSPD2_RT	EQU	$
		HEX	0A7,059,000,000,000
SPARK_XSPD2_SU	EQU	$
		HEX	059,0A7,000,000,000
SPARK_XSPD2_SUR EQU	$
		HEX	000,000,059,000,0A7
SPARK_XSPD2_SL	EQU	$
		HEX	000,000,0A7,000,059
SPARK_XSPD2_SLR EQU	$
		HEX	0A7,059,000,000,000

SPARK_YSPD	EQU	$
		HEX	0A7,059,000,000,000
SPARK_YSPD_RT	EQU	$
		HEX	000,000,059,000,0A7
SPARK_YSPD2	EQU	$
		HEX	059,0A7,000,000,000
SPARK_YSPD2_RT	EQU	$
		HEX	000,000,0A7,000,059
SPARK_YSPD2_SU	EQU	$
		HEX	000,000,059,000,0A7
SPARK_YSPD2_SUR EQU	$
		HEX	0A7,059,000,000,000
SPARK_YSPD2_SL	EQU	$
		HEX	059,0A7,000,000,000
SPARK_YSPD2_SLR EQU	$
		HEX	000,000,0A7,000,059

SPARK_NEXT	EQU	$
		HEX	008,004,001,000,002
SPARK_NEXT_RT	EQU	$
		HEX	004,008,002,000,001
SPARK_NEXT2	EQU	$
		HEX	004,008,002,000,001
SPARK_NEXT2_RT	EQU	$
		HEX	008,004,001,000,002
SPARK_NEXT2_SU	EQU	$
		HEX	001,002,004,000,008
SPARK_NEXT2_SUR EQU	$
		HEX	001,002,004,000,008
SPARK_NEXT2_SL	EQU	$
		HEX	004,008,002,000,001
SPARK_NEXT2_SLR EQU	$
		HEX	008,004,001,000,002

SPARK_ANG	EQU	$			;LOW BIT
		HEX	081,080,001,000,000
SPARK_ANG_RT	EQU	$
		HEX	001,000,080,000,081
SPARK_ANG2	EQU	$
		HEX	080,081,000,000,001
SPARK_ANG2_RT	EQU	$
		HEX	000,001,081,000,080
SPARK_ANG2_SU	EQU	$
		HEX	001,000,080,000,081
SPARK_ANG2_SUR	EQU	$
		HEX	081,080,001,000,000
SPARK_ANG2_SL	EQU	$
		HEX	080,081,000,000,001
SPARK_ANG2_SLR	EQU	$
		HEX	000,001,081,000,080

SPARK_XREV	EQU	$
		HEX	001,00F,00F,000,001
SPARK_XREV_RT	EQU	$
		HEX	00F,001,001,000,00F
SPARK_XREV2	EQU	$
		HEX	0FF,001,00F,000,001
SPARK_XREV2_RT	EQU	$
		HEX	00F,001,0FF,000,001
SPARK_XREV2_SU	EQU	$
		HEX	001,00F,00F,000,001
SPARK_XREV2_SUR EQU	$
		HEX	00F,001,001,000,00F
SPARK_XREV2_SL	EQU	$
		HEX	0FF,001,00F,000,001
SPARK_XREV2_SLR EQU	$
		HEX	00F,001,0FF,000,001

SPARK_YREV	EQU	$
		HEX	001,00F,001,000,00F
SPARK_YREV_RT	EQU	$
		HEX	00F,001,00F,000,001
SPARK_YREV2	EQU	$
		HEX	001,00F,0FF,000,001
SPARK_YREV2_RT	EQU	$
		HEX	001,0FF,00F,000,001
SPARK_YREV2_SU	EQU	$
		HEX	001,00F,001,000,00F
SPARK_YREV2_SUR EQU	$
		HEX	00F,001,00F,000,001
SPARK_YREV2_SL	EQU	$
		HEX	001,00F,0FF,000,001
SPARK_YREV2_SLR EQU	$
		HEX	001,0FF,00F,000,001
;
;********************************************************
;*		̃f[^				*
;********************************************************
SPARK_XSPD3	EQU	$
		HEX	03E,0C2,03E,000,0C2
		HEX	03E,0C2,03E,000,0C2
		HEX	03E,0C2,0C2,000,03E
		HEX	0C2,03E,03E,000,0C2
SPARK_YSPD3	EQU	$
		HEX	0C2,03E,03E,000,0C2
		HEX	0C2,03E,03E,000,0C2
		HEX	03E,0C2,03E,000,0C2
		HEX	0C2,03E,0C2,000,03E
SPARK_ANG3	EQU	$
		HEX	041,040,0C0,000,0C1
		HEX	041,040,0C0,000,0C1
		HEX	0C0,0C1,040,000,041
		HEX	0C1,0C0,041,000,040
SPARK_XREV3	EQU	$
		HEX	001,00F,00F,000,001		;
		HEX	00F,001,001,000,00F
;
		HEX	000,000,00F,000,001		;
		HEX	00F,001,000,000,000
;
SPARK_YREV3	EQU	$
		HEX	001,00F,001,000,00F		;
		HEX	00F,001,00F,000,001
;
		HEX	001,00F,000,000,001		;
		HEX	000,000,00F,000,001
;
SPARK_BGCKXP	EQU	$
		HEX	00F,000,001,000,00E
		HEX	001,00E,00F,000,000
SPARK_BGCKYP	EQU	$
		HEX	00E,001,00F,000,000
		HEX	000,00F,001,000,00E
;
SPARK_BGCKXP2	EQU	$
		HEX	000,00F,000,000,00F
SPARK_BGCKYP2	EQU	$
		HEX	00F,000,000,000,00F
;
SPARK_BGCKDT_SK EQU	$
		HEX	070,080,080,080,080,000,002,080		;EǂɂipFTAUAXA
		HEX	080,004,001,080,080,080,080,080		;ȊO͏Ƌpj
SPARK_BGCKDT_S2 EQU	$
		HEX	070,080,080,080,080,007,006,080		;ǂɂ
		HEX	080,005,009,080,080,080,080,080		;i{`F蕪̃CfbNXj
;
SPARK_RET_XREV	EQU	$
		HEX	000,000,0FF,000,001
		HEX	0FF,001,000,000,000
SPARK_RET_YREV	EQU	$
		HEX	001,0FF,000,000,000
		HEX	000,000,0FF,000,001
;
;
;************************************************************************
;*									*
;*		[vtĝaf`FbN				*
;*									*
;*	[In]								*
;*		(R10) <-- G̃CfbNX				*
;*									*
;*	[Out]								*
;*		WRKF  <-- pU					*
;*									*
;************************************************************************
M_ROPE_CHK	EQU	$
		mLDW	R1,CENWRKC,R10
		IWT	R0,#ENBGCK_UNIT_C
		TO	R5
		ADD	R1
		SMS	R5,REG5

		IBT	R0,#0FFH		;[CHK]
		SMS	R0,REG0
		SMS	R0,REG1

		mLDB0	CENWRKB,R10
		SMS	R0,CWORKC

		mLDW	R7,CENXPSL,R10
		mLDW	R8,CENYPSL,R10
		mLDW	R9,CENCONT,R10
		SMS	R7,CWORK17
		SMS	R8,CWORK18
		SMS	R9,CWORK19

		mJSR	ROPE_CHK_SB		;

		SUB	R0			;[CHK]
		SMS	R0,REG1

		LMS	R5,REG5
		LMS	R7,CWORK17
		LMS	R8,CWORK18
		LMS	R9,CWORK19

		mLDB	R1,CENWRKA,R10		;󒆂ɕĂ ?
		FROM	R1			;
		SEX				;
		BPL	ROPE_CHK0080		;  no: ROPE_CHK0080
		NOP

		STOP
		NOP

ROPE_CHK0080
		FROM	R1			;~̏ゾ ?
		SUB	#02			;
		BEQ	ROPE_CHK0100		; yes: ROPE_CHK0100
		NOP				;
		mDJMP	ROPE_CHK5000		;  no: ROPE_CHK5000

ROPE_CHK0100
		IBT	R0,#01			;[CHK]
		SMS	R0,REG1

		mLDW	R1,CENCONT,R10		;pxvZ
;		LMS	R5,CWORKF		;
;		MOVES	R5,R5			;v ?
;		BMI	ROPE_CHK0200		; yes: ROPE_CHK0200
;		SUB	R0
;		NOP
;
;		NOT
;		INC	R0
;
;		mLDW	R6,CENWRK6,R10		;
;		mLDW0	CENWRK8,R10		;
;		WITH	R6			;
;		HIB				;
;		LOB				;
;		SWAP				;
;		TO	R6			;
;		OR	R6			;
;		FROM	R5			;
;		LMULT				;
;		WITH	R4			;
;		HIB				;
;		LOB				;
;		SWAP				;
;		OR	R4			;
;
ROPE_CHK0200
		IWT	R0,#0E000H
		SMS	R0,CWORK3		;[CHK]
		SMS	R1,CWORK4		;[CHK]

		FROM	R1
		SUB	R0
		HIB
		SMS	R0,CWORK5		;[CHK]

		IBT	R4,#040H		;cɐił ?
		AND	R4			;
		BNE	ROPE_CHK1000		; yes: ROPE_CHK1000
		NOP

		IBT	R0,#02			;[CHK]
		SMS	R0,REG1

		FROM	R8
		AND	#0FH
		SUB	#08
		BMI	ROPE_CHK0300+1
		IBT	R1,#018H		;`FbN

		FROM	R8
		BIC	#0FH
		TO	R8
		OR	#06
		BRA	ROPE_CHK2000
		NOP

ROPE_CHK0300
		IBT	R1,#020H		;`FbN

		LMS	R0,REG1			;[CHK]
		INC	R0
		SBK

		FROM	R8
		BIC	#0FH
		TO	R8
		OR	#09
		BRA	ROPE_CHK2000
		NOP

ROPE_CHK1000
		IBT	R0,#04			;[CHK]
		SMS	R0,REG1

		FROM	R7
		AND	#0FH
		SUB	#08
		BMI	ROPE_CHK1300+1
		IBT	R1,#08			;`FbN

		FROM	R7
		BIC	#0FH
		TO	R7
		OR	#06
		BRA	ROPE_CHK2000
		NOP

ROPE_CHK1300
		IBT	R1,#010H		;E`FbN

		LMS	R0,REG1			;[CHK]
		INC	R0
		SBK

		FROM	R7
		BIC	#0FH
		TO	R7
		OR	#09

ROPE_CHK2000
		mSTW	R7,CENXPSL,R10
		mSTW	R8,CENYPSL,R10
		mSTW	R9,CENCONT,R10

		LMS	R5,REG5
		WITH	R5			;`FbN
		ADD	R1

		mJSR	ROPE_CHK_SB

		LMS	R7,CWORK17		;ɖ߂
		LMS	R8,CWORK18		;
		LMS	R9,CWORK19
		mSTW	R7,CENXPSL,R10		;
		mSTW	R8,CENYPSL,R10		;

		mLDW	R6,CENWRK6,R10		;pxvZ
		mLDW0	CENWRK8,R10		;
		WITH	R6			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R6			;
		OR	R6			;
		LMS	R5,CWORKF		;
		FROM	R5			;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		TO	R9			;
		ADD	R9			;
		mSTW	R9,CENCONT,R10		;

		IBT	R1,#0FFH
		mSTB	R1,CENWRKA,R10

		STOP
		NOP
;
ROPE_CHK5000
		INC	R0			;⁕ ?
		BEQ	ROPE_CHK5280		;  no: ROPE_CHK5280
		NOP

		IBT	R0,#010H		;[CHK]
		SMS	R0,REG1

		WITH	R9
		NOT
		INC	R9

		FROM	R8			;̃jbg`FbN ?
		AND	#0FH			;
		SUB	#08			;
		BMI	ROPE_CHK5100+1		;  no: ROPE_CHK5100
		IBT	R1,#018H		;`FbN

		LMS	R0,REG1			;[CHK]
		INC	R0
		SBK

		FROM	R8
		BIC	#0FH
		TO	R8
		OR	#06
		BRA	ROPE_CHK5200
		NOP

ROPE_CHK5100
		IBT	R1,#020H		;`FbN

		FROM	R8
		BIC	#0FH
		TO	R8
		OR	#09

ROPE_CHK5200
		mJSR	ROPE_ARCHK

		LMS	R0,CWORKC		;O͒ ?
		SUB	#06			;
		BNE	ROPE_CHK5250		;  no: ROPE_CHK5250
		NOP
		mDJMP	ROPE_CHK5500

ROPE_CHK5250
		IWT	R3,#08000H
		FROM	R3
		TO	R9
		SUB	R9

		FROM	R7			;̃jbg`FbN ?
		AND	#0FH			;
		SUB	#08			;
		BMI	ROPE_CHK5300+1		;  no: ROPE_CHK5300

ROPE_CHK5280
		IBT	R1,#08			;`FbN

		LMS	R0,REG1			;[CHK]
		ADD	#02
		SBK

		FROM	R7
		BIC	#0FH
		TO	R7
		OR	#06
		BRA	ROPE_CHK5400
		NOP

ROPE_CHK5300
		IBT	R1,#010H		;E`FbN

		LMS	R0,REG1			;[CHK]
		ADD	#04
		SBK

		FROM	R7
		BIC	#0FH
		TO	R7
		OR	#09

ROPE_CHK5400
		mJSR	ROPE_ARCHK

		mLDB0	CENWRKB,R10		;@@P̍ ?
		SUB	#02			;
		BPL	ROPE_CHK5500		;  no: ROPE_CHK5500
		NOP

		mLDW	R5,CENXMAX,R10		;Ă ?
		FROM	R5			;
		HIB				;
		DEC	R0			;
		BNE	ROPE_CHK5500		;  no: ROPE_CHK5500
		NOP

		IBT	R0,#040H		;[CHK]
		SMS	R0,REG1

		FROM	R5
		SWAP
		XOR	#01
		TO	R5
		SWAP

		mLDW	R6,CENWRK6,R10		;AiOWvZbg
		mLDW0	CENWRK8,R10		;
		WITH	R6			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R6			;
		OR	R6			;
		IWT	R0,#00180H
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4
						;
		IBT	R0,#BANK SIN		;
		ROMB				;
						;
		IWT	R0,#COS			;
		TO	R14			;
		ADD	R5			;
		IWT	R0,#SIN			;
		TO	R2			;
		ADD	R5			;
						;
		GETB				;
		INC	R14			;
		GETBH				;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R4			;
		OR	R4			;
		mSTW	R4,CENXSPD,R10		;
						;
		MOVE	R14,R2			;
		GETB				;
		INC	R14			;
		GETBH				;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R4			;
		OR	R4			;
		mSTW	R4,CENYSPD,R10		;

ROPE_CHK5500
		IBT	R1,#0FFH
		mSTB	R1,CENWRKA,R10

		STOP
		NOP
;
ROPE_ARCHK
		SMS	R11,RTS5

		mSTW	R7,CENXPSL,R10
		mSTW	R8,CENYPSL,R10
		mSTW	R9,CENCONT,R10
		LMS	R5,REG5

		WITH	R5
		ADD	R1

		mJSR	ROPE_CHK_SB

		LMS	R7,CWORK17		;ɖ߂
		LMS	R8,CWORK18		;
		LMS	R9,CWORK19
		mSTW	R7,CENXPSL,R10		;
		mSTW	R8,CENYPSL,R10		;
		mSTW	R9,CENCONT,R10

		LMS	R11,RTS5

		mRTS
;
ROPE_CHK_SB
		SMS	R11,RTS0

		SUB	R0			;[CHK]
		SMS	R0,REG2

		IBT	R3,#028H
		mSTW	R3,CENGPOW,R10

		IWT	R0,#UT8700
		TO	R2
		HIB
		TO	R7
		LDW	(R5)

		SMS	R7,REG7			;[CHK]

		FROM	R7
		HIB
		SUB	R2			;[vjbg ?
		BEQ	ROPE_CHK_SB0000		; yes: ROPE_CHK_SB0000
		NOP

		mRTS

ROPE_CHK_SB0000
		IBT	R0,#01			;[CHK]
		SMS	R0,REG2

		IWT	R0,#BANK ROPE_CHK_DT
		ROMB
		IWT	R3,#ROPE_CHK_DT
		FROM	R7
		LOB
		ADD	R0
		TO	R14
		ADD	R3
		GETB
		INC	R14
		TO	R14
		GETBH
		GETB
		MOVES	R8,R0			; ?
		BNE	ROPE_CHK_SB0100		;  no: ROPE_CHK_SB0100
		INC	R14

		IBT	R0,#02			;[CHK]
		SMS	R0,REG2

		mJSR	ROPE_CHK_SB1
		BRA	ROPE_CHK_SB0400
		NOP

ROPE_CHK_SB0100
		DEC	R0			; ?
		BNE	ROPE_CHK_SB0200		;  no: ROPE_CHK_SB0200
		NOP

		IBT	R0,#03			;[CHK]
		SMS	R0,REG2

		mJSR	ROPE_CHK_SB2
		BRA	ROPE_CHK_SB0400
		NOP

ROPE_CHK_SB0200
		DEC	R0			;~ ?
		BNE	ROPE_CHK_SB0300		;  no: ROPE_CHK_SB0300
		NOP

		IBT	R0,#04			;[CHK]
		SMS	R0,REG2

		mJSR	ROPE_CHK_SB3
		BRA	ROPE_CHK_SB0400
		NOP

ROPE_CHK_SB0300
		IBT	R0,#05			;[CHK]
		SMS	R0,REG2

		mJSR	ROPE_CHK_SB4

ROPE_CHK_SB0400
		LMS	R11,RTS0

		mRTS
;
;
ROPE_CHK_SB1
		SUB	R0			;[CHK]
		SMS	R0,REG0

		mLDB	R9,CENWRKA,R10		;O₾ ?
		FROM	R8			;
		SUB	R9			;
		BEQ	ROPE_CHK_SB1010		; yes: ROPE_CHK_SB1010
		NOP

ROPE_CHK_SB1000
		mDJMP_X ROPE_CHK_SB1100+1
		SMS	R11,RTS1

ROPE_CHK_SB1010
		IBT	R0,#010H		;[CHK]
		SMS	R0,CREG0

		TO	R3			;OƓO[vjbg ?
		GETB				;
		mLDB0	CENWRKB,R10		;
		CMP	R3			;
		BNE	ROPE_CHK_SB1000		;  no: ROPE_CHK_SB1000
		NOP

		IBT	R0,#011H		;[CHK]
		SMS	R0,CREG0

		IBT	R0,#BANK SIN
		ROMB

		LMS	R1,CWORKF
		IWT	R0,#COS
		TO	R14
		ADD	R1

		IWT	R2,#00100H

		SMS	R1,CWORK4		;[CHK]

		FROM	R1
		LOB
		TO	R5
		SEX
		BPL	ROPE_CHK_SB1011
		NOP

		NOT
		INC	R0
		ADD	R2

ROPE_CHK_SB1011
		SMS	R0,CWORK3		;[CHK]

		IWT	R2,#M_TAN
		TO	R2
		ADD	R2

		SMS	R1,CWORK9		;[CHK]

		mLDB	R7,CENXSDR,R10		;w@onrDvZ
		mLDW	R8,CENXPSL,R10		;
		SMS	R8,REG8			;
		FROM	R8			;
		LOB				;
		SWAP				;
		TO	R7			;
		OR	R7			;
		WITH	R8			;
		HIB				;
						;
		mLDW	R6,CENWRK6,R10		;
		mLDW0	CENWRK8,R10		;
		SMS	R0,CWORK0		;
		WITH	R6			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R6			;
		OR	R6			;
						;
		GETB				;
		INC	R14			;
		GETBH				;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		TO	R3			;
		SUB	#00			;
		BPL	ROPE_CHK_SB1020		;
		WITH	R7			;
						;
		SUB	R3			;
		WITH	R8			;
		ADC	#00			;
		BRA	ROPE_CHK_SB1030		;
		WITH	R8			;
						;
ROPE_CHK_SB1020					;
		SUB	R3			;
		BCS	ROPE_CHK_SB1030		;
		WITH	R8			;
		DEC	R8			;
		WITH	R8			;
						;
ROPE_CHK_SB1030					;
		SWAP				;
		FROM	R7			;
		HIB				;
		TO	R8			;
		OR	R8			;
		mSTW	R8,CENXPSL,R10		;
		mSTB	R7,CENXSDR,R10		;

		LMS	R0,REG8
		WITH	R8			;wړ
		SUB	R0			;

		IBT	R0,#BANK M_TAN		;x@onrDvZ
		ROMB				;
						;
		MOVE	R14,R2			;
		GETB				;
		INC	R14			;
		GETBH				;

		SMS	R0,CWORK5		;[CHK]

		MOVES	R5,R5			;
		BPL	ROPE_CHK_SB1031		;
		WITH	R0			;
						;
		NOT				;
		INC	R0			;
		WITH	R0			;
						;
ROPE_CHK_SB1031					;
		TO	R6			;

		SMS	R8,CWORK10		;[CHK]
		SMS	R6,CWORK6		;[CHK]

		FROM	R8			;
		NOT				;
		INC	R0			;
		TO	R1			;
		LMULT				;

		SMS	R1,CWORK7		;[CHK]
		SMS	R4,CWORK8		;[CHK]

		mLDB	R7,CENYSDR,R10		;x@onrDvZ
		mLDW	R8,CENYPSL,R10		;
		FROM	R8			;
		LOB				;
		SWAP				;
		TO	R7			;
		OR	R7			;
		WITH	R8			;
		HIB				;
		MOVES	R1,R1			;
		BPL	ROPE_CHK_SB1040		;
		WITH	R7			;
						;
		ADD	R4			;
		BCS	ROPE_CHK_SB1050		;
		WITH	R8			;
		DEC	R8			;
		BRA	ROPE_CHK_SB1050		;
		WITH	R8			;
						;
ROPE_CHK_SB1040					;
		ADD	R4			;
		WITH	R8			;
		ADC	#00			;
		WITH	R8			;
						;
ROPE_CHK_SB1050					;
		SWAP				;
						;
		FROM	R7			;
		HIB				;
		TO	R8			;
		OR	R8			;
		mSTW	R8,CENYPSL,R10		;
		mSTB	R7,CENYSDR,R10		;

		IBT	R3,#00
		mSTW	R3,CENGPOW,R10
		mSTW	R3,CENYSPD,R10
		mSTW	R3,CENXSPD,R10

		STOP
		NOP

ROPE_CHK_SB1100
		SMS	R11,RTS1

		LMS	R0,REG0			;[CHK]
		INC	R0
		SBK

		TO	R9
		GETB
		INC	R14

		SMS	R9,CWORKB		;WRKB <- ̎ރZbg
		SMS	R8,CWORKA		;WRKA <- af̎ރZbg

		mJSR	ROPE_CPOS_SB

		IWT	R0,#ROPE_SK_DATA
		TO	R14
		ADD	R9

		TO	R5
		GETB

		IBT	R0,#BANK M_TAN
		ROMB

		IWT	R1,#00100H
		FROM	R5
		LOB
		TO	R2
		SEX
		BPL	ROPE_CHK_SB1200
		NOP

		NOT
		INC	R0
		ADD	R1

ROPE_CHK_SB1200
		IWT	R1,#M_TAN
		TO	R14
		ADD	R1

		LMS	R6,CWORK0		;
		FROM	R9			;Eオ̍ ?
		AND	#01			;
		BNE	ROPE_CHK_SB1300		;  no: ROPE_CHK_SB1300
		NOP
		DEC	R6

ROPE_CHK_SB1300
		GETB
		INC	R14
		GETBH
		MOVES	R2,R2
		BPL	ROPE_CHK_SB1320
		NOP

		NOT
		INC	R0

ROPE_CHK_SB1320
		LMULT				;
		MOVE	R8,R4			;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R7			;
		OR	R4			;

		SMS	R7,REG7			;[CHK]

		mLDB0	CENWRKA,R10		;t@[Xgt[ ?
		ADD	R0			;
		SWAP				;
		DEC	R0			;
		BEQ	ROPE_CHK_SB1380		; yes: ROPE_CHK_SB1380
		NOP

		LMS	R3,CWORK1		;͈͓ ?
		DEC	R3			;
		FROM	R7			;
		NOT				;
		INC	R0			;
		SUB	R3			;
		ADD	#04			;
		SUB	#08			;
		BCC	ROPE_CHK_SB1380		; yes: ROPE_CHK_SB1380
		NOP

		LMS	R11,RTS1

		mRTS

ROPE_CHK_SB1380
		LMS	R0,REG0			;[CHK]
		INC	R0
		SBK

		LMS	R3,CWORKA
		mSTB	R3,CENWRKA,R10		;af̎ރZbg
		LMS	R3,CWORKB
		mSTB	R3,CENWRKB,R10		;̎ރZbg

		LMS	R0,CWORK12		;x@onrD␳
		WITH	R3			;	; ?
		SUB	#06			;	;
		BNE	ROPE_CHK_SB1400		;	;  no: ROPE_CHK_SB1400
		NOP				;
						;
		SUB	#02			;
						;
ROPE_CHK_SB1400					;
		ADD	R7			;
		TO	R7			;
		SUB	#08			;
		mSTW	R7,CENYPSL,R10		;
		mSTB	R8,CENYSDR,R10		;

		IWT	R7,#00100H		;ispxZbg
		LMS	R0,CWORKB		;A ?
		SUB	#06			;
		BEQ	ROPE_CHK_SB1700		; yes: ROPE_CHK_SB1700
		NOP

		LMS	R0,CWORKC		;OA ?
		SUB	#06			;
		BEQ	ROPE_CHK_SB1700		; yes: ROPE_CHK_SB1700
		NOP

		LMS	R0,REG1			;S`FbN ?
		SUB	#0			;
		BMI	ROPE_CHK_SB1700		; yes: ROPE_CHK_SB1700
		NOP

		mLDW0	CENCONT,R10		;
		HIB				;
		ADD	R0			;
		AND	R7			;
		TO	R5			;
		OR	R5			;
		BRA	ROPE_CHK_SB1800
		NOP

ROPE_CHK_SB1700
		IWT	R8,#001FEH		;
		IWT	R1,#00080H		;
		mLDW0	CENCONT,R10
		HIB
		ADD	R0
		SUB	R5			;
		ADD	R1			;
		AND	R8			;
		SUB	R7			;
		BMI	ROPE_CHK_SB1800		;
		WITH	R5			;
		OR	R7			;
						;
ROPE_CHK_SB1800					;
		SMS	R5,CWORKF		;

		FROM	R5			;
		LSR				;
		TO	R5			;
		SWAP				;
		mSTW	R5,CENCONT,R10		;

		IBT	R1,#000
		mSTB	R1,CENXSDR,R10
		mSTW	R1,CENGPOW,R10
		mSTW	R1,CENYSPD,R10
		mSTW	R1,CENXSPD,R10

		STOP
		NOP
;
ROPE_CHK_SB2
		SUB	R0			;[CHK]
		SMS	R0,REG0

		mLDB	R9,CENWRKA,R10		;Oǂ ?
		FROM	R8			;
		SUB	R9			;
		BNE	ROPE_CHK_SB2300		;  no: ROPE_CHK_SB2300
		NOP

		IBT	R0,#010H		;[CHK]
		SMS	R0,CREG0

		mLDW	R1,CENWRK6,R10
		mLDW	R2,CENWRK8,R10
		WITH	R1
		HIB
		FROM	R2
		LOB
		SWAP
		TO	R1
		OR	R1

		mLDB	R7,CENYSDR,R10		;x@onrDvZ
		mLDW	R8,CENYPSL,R10		;
		FROM	R8			;
		LOB				;
		SWAP				;
		TO	R7			;
		OR	R7			;
		WITH	R8			;
		HIB				;

		mLDW	R9,CENCONT,R10		; ?
		MOVES	R9,R9			;
		BPL	ROPE_CHK_SB2100		;  no: ROPE_CHK_SB2100
		WITH	R7
		SUB	R1
		BCS	ROPE_CHK_SB2200
		WITH	R8
		DEC	R8
		BRA	ROPE_CHK_SB2200
		WITH	R8

ROPE_CHK_SB2100
		ADD	R1
		WITH	R8
		ADC	#00
		WITH	R8

ROPE_CHK_SB2200
		LOB
		WITH	R8
		SWAP

		FROM	R7			;
		HIB				;
		TO	R8			;
		OR	R8			;
		mSTW	R8,CENYPSL,R10		;
		mSTB	R7,CENYSDR,R10		;

		IBT	R3,#00
		mSTW	R3,CENGPOW,R10
		mSTW	R3,CENYSPD,R10
		mSTW	R3,CENXSPD,R10

		STOP
		NOP

ROPE_CHK_SB2300
		SMS	R11,RTS1

		LMS	R0,REG0			;[CHK]
		INC	R0
		SBK

		TO	R9
		GETB
		INC	R14

		FROM	R9
		BIC	#07
		SMS	R0,CWORKB		;WRKB <- ̎ރZbg
		SMS	R8,CWORKA		;WRKA <- af̎ރZbg

		mLDW	R9,CENXPSL,R10		;͈͓ ?

		mLDB0	CENWRKA,R10		;t@[Xgt[ ?
		ADD	R0			;
		SWAP				;
		DEC	R0			;
		BEQ	ROPE_CHK_SB2500		; yes: ROPE_CHK_SB2500
		NOP

		FROM	R9			;
		AND	#00FH			;
		SUB	#08			;
		BPL	ROPE_CHK_SB2500		; yes: ROPE_CHK_SB2500
		NOP

		LMS	R11,RTS1

		mRTS

ROPE_CHK_SB2500
		LMS	R0,REG0			;[CHK]
		INC	R0
		SBK

		LMS	R3,CWORKB
		mSTB	R3,CENWRKB,R10		;̎ރZbg
		LMS	R3,CWORKA
		mSTB	R3,CENWRKA,R10		;af̎ރZbg

		FROM	R9			;w@onrD␳
		ADD	#08			;
		BIC	#00FH			;
		TO	R3			;
		SUB	#08			;
		mSTW	R3,CENXPSL,R10		;

		FROM	R9
		ADD	#008
		TO	R9
		AND	#00FH

		IWT	R7,#08000H		;ispxZbg
		mLDW	R8,CENYPSL,R10		;
		FROM	R8			;
		AND	#00FH			;
		SUB	#08			;
		BPL	ROPE_CHK_SB2600		;
		WITH	R8
		SUB	R9
		BRA	ROPE_CHK_SB2700		;
		INC	R7			;
						;
ROPE_CHK_SB2600					;
		ADD	R9

ROPE_CHK_SB2700
		FROM	R7			;
		SWAP				;
		SMS	R0,CWORKF		;
		LSR				;
		TO	R5			;
		SWAP				;
		mSTW	R5,CENCONT,R10		;
		mSTW	R8,CENYPSL,R10

		IBT	R1,#000
		mSTB	R1,CENXSDR,R10
		mSTB	R1,CENYSDR,R10
		mSTW	R1,CENGPOW,R10
		mSTW	R1,CENYSPD,R10
		mSTW	R1,CENXSPD,R10

		STOP
		NOP
;
ROPE_CHK_SB3
		SUB	R0			;[CHK]
		SMS	R0,REG0

		mLDB	R9,CENWRKA,R10
		FROM	R8			;O~ ?
		SUB	R9			;
		BEQ	ROPE_CHK_SB3010		; yes: ROPE_CHK_SB3010
		NOP

ROPE_CHK_SB3000
		mDJMP_X ROPE_CHK_SB3100+1	;  no: ROPE_CHK_SB3100+1
		SMS	R11,RTS1

ROPE_CHK_SB3010
		TO	R3
		GETB				;OƓjbg ?
		FROM	R3			;
		TO	R6			;
		BIC	#03			;
		mLDB0	CENWRKB,R10		;
		CMP	R6			;
		BNE	ROPE_CHK_SB3000		;  no: ROPE_CHK_SB3000
		NOP

		FROM	R3			;aPOg̉~ ?
		AND	#03			;
		SUB	#03			;
		BNE	ROPE_CHK_SB3020		;  no: ROPE_CHK_SB3020
		INC	R14

		INC	R14			;

ROPE_CHK_SB3020
		mJSR	ROPE_CPOS_SB		;~̒SvZ

		FROM	R6			;(R3) <-- ~̔a
		LSR
		LSR
		BIC	#007H
		TO	R6
		ADD	#04
		IWT	R0,#ROPE_EN_DATA
		TO	R14
		ADD	R6
		TO	R3			;
		GETB				;

		mJSR	ROPE_EN_POS_CALC

		IBT	R3,#00
		mSTW	R3,CENGPOW,R10
		mSTW	R3,CENYSPD,R10
		mSTW	R3,CENXSPD,R10

		STOP
		NOP

ROPE_CHK_SB3100
		SMS	R11,RTS1

		LMS	R0,CREG0		;[CHK]
		INC	R0
		SBK

		TO	R9
		GETB
		INC	R14

		FROM	R9
		BIC	#03
		SMS	R0,CWORKB		;WRKB <- ~̎ރZbg
		SMS	R8,CWORKA		;WRKA <- af̎ރZbg

		FROM	R9			;aPOg̉~ ?
		AND	#03			;
		SUB	#03			;
		BNE	ROPE_CHK_SB3180		;  no: ROPE_CHK_SB3180
		NOP

		TO	R13			;
		GETB				;(R13) <-- Spx
		INC	R14			;
		SMS	R13,REG13
		SMS	R14,REG12

ROPE_CHK_SB3180
		mJSR	ROPE_CPOS_SB

		LMS	R0,CWORK0
		MOVE	R6,R0
		LMULT
		MOVE	R11,R4
		LMS	R0,CWORK1
		MOVE	R6,R0
		LMULT
		WITH	R11			;X2+Y2
		ADD	R4

		FROM	R9
		LSR
		LSR
		TO	R3
		BIC	#007H
		IWT	R0,#ROPE_EN_DATA
		TO	R14
		ADD	R3

		mLDB0	CENWRKA,R10		;t@[Xgt[ ?
		ADD	R0			;
		SWAP				;
		DEC	R0			;
		BEQ	ROPE_CHK_SB3370		; yes: ROPE_CHK_SB3370
		NOP

		GETB				;`FbN͈͓ ?
		INC	R14			;
		GETBH				;
		CMP	R11			;
		BPL	ROPE_CHK_SB3350		;  no: ROPE_CHK_SB3350
		INC	R14			;
		GETB				;
		INC	R14			;
		GETBH				;
		CMP	R11			;
		BPL	ROPE_CHK_SB3380		; yes: ROPE_CHK_SB3380
		INC	R14			;

ROPE_CHK_SB3350
		LMS	R11,RTS1

		mRTS

ROPE_CHK_SB3370
		WITH	R14
		ADD	#04

ROPE_CHK_SB3380
		LMS	R0,CREG0		;[CHK]
		INC	R0
		SBK

		LMS	R3,CWORKB
		mSTB	R3,CENWRKB,R10		;~̎ރZbg
		LMS	R3,CWORKA
		mSTB	R3,CENWRKA,R10		;af̎ރZbg

		SMS	R14,REG14

		LMS	R0,CWORK0
		TO	R1
		NOT
		INC	R1
		LMS	R0,CWORK1
		TO	R2
		NOT
		INC	R2

		IWT	R0,#M_RAD_GET_S		;pxvZ
		IBT	R8,#BANK M_RAD_GET_S	;
		IBT	R5,#BANK M_ROPE_CHK	;
		MOVE	R11,R15			;
		LJMP	R8			;
		NOP

		IBT	R0,#BANK ROPE_EN_DATA
		ROMB
		LMS	R14,REG14
		TO	R3			;
		GETB				;(R3) <-- ~̔a
		INC	R14

		IWT	R4,#04000H		;(R5) <-- ispxZbgil`w@eegj
		FROM	R1			;
		SWAP				;
		TO	R5			;
		ADD	R4			;

		GETB				;(R1) <-- pU
		INC	R14			;
		TO	R1			;
		GETBH				;

		mLDW	R7,CENCONT,R10
		FROM	R5
		SUB	R7
		ADD	R4
		BPL	ROPE_CHK_SB3400
		NOP

		FROM	R5			;ispx𔽓]
		ADD	R4			;
		TO	R5			;
		ADD	R4			;

		WITH	R1			;pU𔽓]
		NOT				;
		INC	R1			;

ROPE_CHK_SB3400 EQU	$
		SMS	R1,CWORKF		;WRKF <-- pU

		IWT	R2,#00100H		;px␳
		MOVES	R1,R1			;
		BPL	ROPE_CHK_SB3500		;
		WITH	R5			;
						;
		SUB	R2			;
		BRA	ROPE_CHK_SB3600		;
		NOP				;
						;
ROPE_CHK_SB3500					;
		ADD	R2			;

ROPE_CHK_SB3600
		mSTW	R5,CENCONT,R10		;pxZbg

		MOVE	R1,R5
		LMS	R5,CWORKF
		mJSR	ROPE_EN_POS_CALC2

		IBT	R3,#00
		mSTW	R3,CENGPOW,R10
		mSTW	R3,CENYSPD,R10
		mSTW	R3,CENXSPD,R10

		STOP
		NOP
;
ROPE_EN_POS_CALC
		mLDW	R1,CENCONT,R10		;pxvZ
		mLDW	R6,CENWRK6,R10		;
		mLDW0	CENWRK8,R10		;
		WITH	R6			;
		HIB				;
		LOB				;
		SWAP				;
		TO	R6			;
		OR	R6			;
		LMS	R5,CWORKF		;
		FROM	R5			;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		TO	R1			;
		ADD	R1			;
		mSTW	R1,CENCONT,R10		;

ROPE_EN_POS_CALC2
		IWT	R7,#04000H
		MOVES	R5,R5
		BPL	ROPE_E_P_C0100
		WITH	R1
		ADD	R7
		BRA	ROPE_E_P_C0200
		NOP

ROPE_E_P_C0100
		SUB	R7

ROPE_E_P_C0200
		FROM	R1
		LSR
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R1
		BIC	#01
;;;;;;;;		FROM	R1			;ʒuvZ
;;;;;;;;		HIB				;
;;;;;;;;		TO	R1			;
;;;;;;;;		ADD	R0			;
		MOVE	R6,R3			;

		IBT	R0,#BANK WSIN
		ROMB

		IWT	R0,#WSIN
		TO	R14
		ADD	R1

		IWT	R0,#WCOS
		TO	R2
		ADD	R1

		GETB
		INC	R14
		GETBH
		LMULT
		IWT	R3,#00080H
		WITH	R4
		ADD	R3
		ADC	#00
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R1
		OR	R4

		MOVE	R14,R2
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		ADD	R3
		ADC	#00
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4

		ADD	#08
		LMS	R3,CWORK11		;w@onrD␳
		WITH	R3			;
		SUB	R0			;
		mSTW	R3,CENXPSL,R10		;
		LMS	R3,CWORK12		;x@onrD␳
		FROM	R3			;
		SUB	R1			;
		TO	R3
		SUB	#08
		mSTW	R3,CENYPSL,R10		;

		mRTS
;
ROPE_CHK_SB4
		IBT	R0,#002		;[CHK]
		SMS	R0,REG0

		mLDW0	CENXPSL,R10
		TO	R1
		BIC	#0FH
		mLDW0	CENYPSL,R10
		TO	R2
		BIC	#0FH
		GETB
		INC	R14
		TO	R1
		OR	R1
		GETB
		OR	R2
;		FROM	R2		;[ mSTW R2,CENYPSL,R10 ]
		SBK
		mSTW	R1,CENXPSL,R10

		IWT	R3,#00100H
		IWT	R2,#001FEH
		mLDB	R1,CENWRKA,R10
		LMS	R0,CWORKF
		WITH	R1
		SUB	#02
		BPL	ROPE_CHK_SB4100
		NOP

		ADD	R3
		BRA	ROPE_CHK_SB4200
		AND	R2

ROPE_CHK_SB4100
		NOT
		INC	R0

ROPE_CHK_SB4200
		SMS	R0,CWORKF

		IBT	R3,#03
		mSTB	R3,CENWRKA,R10

		IWT	R3,#08000H
		mLDW0	CENCONT,R10
		ADD	R3
		SBK

		STOP
		NOP
;
ROPE_CPOS_SB
		SMS	R11,RTS2

		mLDW0	CENXPSL,R10		;(R7) <- tg̒Ŝw@onrD
		TO	R7			;
		ADD	#08			;
		FROM	R7			;
		TO	R11			;(R11) <-- `FbNjbĝw@onrD
		BIC	#00FH			;

		mLDW0	CENYPSL,R10		;(R8) <- tg̒Ŝx@onrD
		TO	R8			;
		ADD	#08			;
		FROM	R8			;
		TO	R12			;(R12) <-- `FbNjbĝx@onrD
		BIC	#00FH			;

		GETBS			;X OFFSET POS
		SUB	#0
		BMI	ROPE_CPOS_SB3200
		INC	R14

		ADD	R0

ROPE_CPOS_SB3200
		ADD	R11			;
		SMS	R0,CWORK11		;WRK11 <-- ~̒Ŝw@onrD
		SUB	R7
		SMS	R0,CWORK0		;WRK0  <-- tg̒SƉ~̒ŜwL

		GETBS			;Y OFFSET POS

		SUB	#0
		BMI	ROPE_CPOS_SB3300
		INC	R14

		ADD	R0

ROPE_CPOS_SB3300
		ADD	R12
		SMS	R0,CWORK12		;WRK12 <-- ~̒Ŝx@onrD
		SUB	R8
		SMS	R0,CWORK1		;WRK1  <-- tg̒SƉ~̒ŜxL

		LMS	R11,RTS2

		mRTS
;
ROPE_CHK_DT	EQU	$
;UT87**			[00]	[01]	[02]	[03]	[04]	[05]	[06]	[07]
		WORD	UT00_DA,UT01_DA,UT02_DA,UT03_DA,UT04_DA,UT05_DA,UT06_DA,UT07_DA
;UT87**			[08]	[09]	[0A]	[0B]	[0C]	[0D]	[0E]	[0F]
		WORD	UT08_DA,UT09_DA,UT0A_DA,UT0B_DA,UT0C_DA,UT0D_DA,UT0E_DA,UT0F_DA
;UT87**			[10]	[11]	[12]	[13]	[14]	[15]	[16]	[17]
		WORD	UT10_DA,UT11_DA,UT12_DA,UT13_DA,UT14_DA,UT15_DA,UT16_DA,UT17_DA
;UT87**			[18]	[19]	[1A]	[1B]	[1C]	[1D]	[1E]	[1F]
		WORD	UT18_DA,UT19_DA,UT1A_DA,UT1B_DA,UT1C_DA,UT1D_DA,UT1E_DA,UT1F_DA
;UT87**			[20]	[21]	[22]	[23]	[24]	[25]	[26]	[27]
		WORD	UT20_DA,UT21_DA,UT22_DA,UT23_DA,UT24_DA,UT25_DA,UT26_DA,UT27_DA
;UT87**			[28]	[29]	[2A]	[2B]	[2C]	[2D]	[2E]	[2F]
		WORD	UT28_DA,UT29_DA,UT2A_DA,UT2B_DA,UT2C_DA,UT2D_DA,UT2E_DA,UT2F_DA
;UT87**			[30]	[31]	[32]	[33]	[34]	[35]	[36]	[37]
		WORD	UT30_DA,UT31_DA,UT32_DA,UT33_DA,UT34_DA,UT35_DA,UT36_DA,UT37_DA
;UT87**			[38]	[39]	[3A]	[3B]	[3C]	[3D]	[3E]	[3F]
		WORD	UT38_DA,UT39_DA,UT3A_DA,UT3B_DA,UT3C_DA,UT3D_DA,UT3E_DA,UT3F_DA
;UT87**			[40]	[41]	[42]	[43]	[44]	[45]	[46]	[47]
		WORD	UT40_DA,UT41_DA,UT42_DA,UT43_DA,UT44_DA,UT45_DA,UT46_DA,UT47_DA
;UT87**			[48]	[49]	[4A]	[4B]	[4C]	[4D]	[4E]	[4F]
		WORD	UT48_DA,UT49_DA,UT4A_DA,UT4B_DA,UT4C_DA,UT4D_DA,UT4E_DA,UT4F_DA
;UT87**			[50]	[51]	[52]	[53]	[54]	[55]	[56]	[57]
		WORD	UT50_DA,UT51_DA,UT52_DA,UT53_DA,UT54_DA,UT55_DA,UT56_DA,UT57_DA
;UT87**			[58]	[59]	[5A]	[5B]	[5C]	[5D]	[5E]	[5F]
		WORD	UT58_DA,UT59_DA,UT5A_DA,UT5B_DA,UT5C_DA,UT5D_DA,UT5E_DA,UT5F_DA
;
;[[
;			af̎ށiOFj,̎ށW
;			w@onrD/02HiȂ/01Hj,ix@onrD{Qj/02HiȂ/01Hj
;
;[~[
;			af̎ށiQF~j,~̎ށW{wiwFO[^񒆁AP[vAQ[vAR[j,
;			w@onrD/02HiȂ/01Hj,x@onrD/02HiȂ/01Hj
;
;[Xgbp[[
;			af̎ށiRF~j,w␳l,x␳l
;
ROPE_DATA	EQU	$
UT00_DA		EQU	$
		BYTE	00,00H,000H/2,(00FH+2)/2
UT01_DA		EQU	$
		BYTE	00,01H,010H/2,(00FH+2)/2
UT02_DA		EQU	$
		BYTE	00,02H,0F0H/1,(00FH+2)/2
UT03_DA		EQU	$
		BYTE	00,02H,000H/2,(00FH+2)/2
UT04_DA		EQU	$
		BYTE	00,03H,020H/2,(00FH+2)/2
UT05_DA		EQU	$
		BYTE	00,03H,010H/2,(00FH+2)/2
UT06_DA		EQU	$
		BYTE	00,04H,0D0H/1,(00FH+2)/2
UT07_DA		EQU	$
		BYTE	00,04H,0E0H/1,(00FH+2)/2
UT08_DA		EQU	$
		BYTE	00,04H,0F0H/1,(00FH+2)/2
UT09_DA		EQU	$
		BYTE	00,04H,000H/2,(00FH+2)/2
UT0A_DA		EQU	$
		BYTE	00,05H,040H/2,(00FH+2)/2
UT0B_DA		EQU	$
		BYTE	00,05H,030H/2,(00FH+2)/2
UT0C_DA		EQU	$
		BYTE	00,05H,020H/2,(00FH+2)/2
UT0D_DA		EQU	$
		BYTE	00,05H,010H/2,(00FH+2)/2
UT0E_DA		EQU	$
		BYTE	00,06H,000H/2,(000H+2)/2
UT0F_DA		EQU	$
		BYTE	01
;
UT10_DA		EQU	$
		BYTE	02,00H*8+3,0E0H,010H/02,010H/02
UT11_DA		EQU	$
		BYTE	02,01H*8+3,0A0H,000H/02,010H/02
UT12_DA		EQU	$
		BYTE	02,03H*8+3,020H,010H/02,000H/02
UT13_DA		EQU	$
		BYTE	02,02H*8+3,060H,000H/02,000H/02
UT14_DA		EQU	$
		BYTE	02,04H*8+0,020H/02,020H/02
UT15_DA		EQU	$
		BYTE	02,04H*8+1,010H/02,020H/02
UT16_DA		EQU	$
		BYTE	02,05H*8+2,000H/02,020H/02
UT17_DA		EQU	$
		BYTE	02,05H*8+0,0F0H/01,020H/02
UT18_DA		EQU	$
		BYTE	02,04H*8+2,020H/02,010H/02
UT19_DA		EQU	$
		BYTE	02,05H*8+1,0F0H/01,010H/02
UT1A_DA		EQU	$
		BYTE	02,07H*8+0,020H/02,0F0H/01
UT1B_DA		EQU	$
		BYTE	02,07H*8+2,010H/02,0F0H/01
UT1C_DA		EQU	$
		BYTE	02,06H*8+1,000H/02,0F0H/01
UT1D_DA		EQU	$
		BYTE	02,06H*8+0,0F0H/01,0F0H/01
UT1E_DA		EQU	$
		BYTE	02,07H*8+1,020H/02,000H/02
UT1F_DA		EQU	$
		BYTE	02,06H*8+2,0F0H/01,000H/02
;
UT20_DA		EQU	$
		BYTE	02,08H*8+0,040H/02,080H/02
UT21_DA		EQU	$
		BYTE	02,08H*8+0,030H/02,080H/02
UT22_DA		EQU	$
		BYTE	02,08H*8+0,020H/02,080H/02
UT23_DA		EQU	$
		BYTE	02,08H*8+1,010H/02,080H/02
UT24_DA		EQU	$
		BYTE	02,08H*8+0,060H/02,070H/02
UT25_DA		EQU	$
		BYTE	02,08H*8+0,050H/02,070H/02
UT26_DA		EQU	$
		BYTE	02,08H*8+0,040H/02,070H/02
UT27_DA		EQU	$
		BYTE	02,08H*8+0,070H/02,060H/02
UT28_DA		EQU	$
		BYTE	02,08H*8+0,060H/02,060H/02
UT29_DA		EQU	$
		BYTE	02,08H*8+0,070H/02,050H/02
UT2A_DA		EQU	$
		BYTE	02,08H*8+0,080H/02,040H/02
UT2B_DA		EQU	$
		BYTE	02,08H*8+0,070H/02,040H/02
UT2C_DA		EQU	$
		BYTE	02,08H*8+0,080H/02,030H/02
UT2D_DA		EQU	$
		BYTE	02,08H*8+0,080H/02,020H/02
UT2E_DA		EQU	$
		BYTE	02,08H*8+2,080H/02,010H/02
UT2F_DA		EQU	$
		BYTE	03,008H,008H
;
UT30_DA		EQU	$
		BYTE	02,0BH*8+0,040H/02,090H/01
UT31_DA		EQU	$
		BYTE	02,0BH*8+0,030H/02,090H/01
UT32_DA		EQU	$
		BYTE	02,0BH*8+0,020H/02,090H/01
UT33_DA		EQU	$
		BYTE	02,0BH*8+2,010H/02,090H/01
UT34_DA		EQU	$
		BYTE	02,0BH*8+0,060H/02,0A0H/01
UT35_DA		EQU	$
		BYTE	02,0BH*8+0,050H/02,0A0H/01
UT36_DA		EQU	$
		BYTE	02,0BH*8+0,040H/02,0A0H/01
UT37_DA		EQU	$
		BYTE	02,0BH*8+0,070H/02,0B0H/01
UT38_DA		EQU	$
		BYTE	02,0BH*8+0,060H/02,0B0H/01
UT39_DA		EQU	$
		BYTE	02,0BH*8+0,070H/02,0C0H/01
UT3A_DA		EQU	$
		BYTE	02,0BH*8+0,080H/02,0D0H/01
UT3B_DA		EQU	$
		BYTE	02,0BH*8+0,070H/02,0D0H/01
UT3C_DA		EQU	$
		BYTE	02,0BH*8+0,080H/02,0E0H/01
UT3D_DA		EQU	$
		BYTE	02,0BH*8+0,080H/02,0F0H/01
UT3E_DA		EQU	$
		BYTE	02,0BH*8+1,080H/02,000H/01
UT3F_DA		EQU	$
		BYTE	03,007H,008H
;
UT40_DA		EQU	$
		BYTE	02,09H*8+1,090H/01,010H/02
UT41_DA		EQU	$
		BYTE	02,09H*8+0,090H/01,020H/02
UT42_DA		EQU	$
		BYTE	02,09H*8+0,090H/01,030H/02
UT43_DA		EQU	$
		BYTE	02,09H*8+0,0A0H/01,040H/02
UT44_DA		EQU	$
		BYTE	02,09H*8+0,090H/01,040H/02
UT45_DA		EQU	$
		BYTE	02,09H*8+0,0A0H/01,050H/02
UT46_DA		EQU	$
		BYTE	02,09H*8+0,0B0H/01,060H/02
UT47_DA		EQU	$
		BYTE	02,09H*8+0,0A0H/01,060H/02
UT48_DA		EQU	$
		BYTE	02,09H*8+0,0D0H/01,070H/02
UT49_DA		EQU	$
		BYTE	02,09H*8+0,0C0H/01,070H/02
UT4A_DA		EQU	$
		BYTE	02,09H*8+0,0B0H/01,070H/02
UT4B_DA		EQU	$
		BYTE	02,09H*8+2,000H/01,080H/02
UT4C_DA		EQU	$
		BYTE	02,09H*8+0,0F0H/01,080H/02
UT4D_DA		EQU	$
		BYTE	02,09H*8+0,0E0H/01,080H/02
UT4E_DA		EQU	$
		BYTE	02,09H*8+0,0D0H/01,080H/02
UT4F_DA		EQU	$
		BYTE	03,008H,008H
;
UT50_DA		EQU	$
		BYTE	02,0AH*8+2,090H/01,000H/01
UT51_DA		EQU	$
		BYTE	02,0AH*8+0,090H/01,0F0H/01
UT52_DA		EQU	$
		BYTE	02,0AH*8+0,090H/01,0E0H/01
UT53_DA		EQU	$
		BYTE	02,0AH*8+0,0A0H/01,0D0H/01
UT54_DA		EQU	$
		BYTE	02,0AH*8+0,090H/01,0D0H/01
UT55_DA		EQU	$
		BYTE	02,0AH*8+0,0A0H/01,0C0H/01
UT56_DA		EQU	$
		BYTE	02,0AH*8+0,0B0H/01,0B0H/01
UT57_DA		EQU	$
		BYTE	02,0AH*8+0,0A0H/01,0B0H/01
UT58_DA		EQU	$
		BYTE	02,0AH*8+0,0D0H/01,0A0H/01
UT59_DA		EQU	$
		BYTE	02,0AH*8+0,0C0H/01,0A0H/01
UT5A_DA		EQU	$
		BYTE	02,0AH*8+0,0B0H/01,0A0H/01
UT5B_DA		EQU	$
		BYTE	02,0AH*8+1,000H/01,090H/01
UT5C_DA		EQU	$
		BYTE	02,0AH*8+0,0F0H/01,090H/01
UT5D_DA		EQU	$
		BYTE	02,0AH*8+0,0E0H/01,090H/01
UT5E_DA		EQU	$
		BYTE	02,0AH*8+0,0D0H/01,090H/01
UT5F_DA		EQU	$
		BYTE	03,008H,007H
;
;[[
;		BYTE	pxf[^
;
ROPE_SK_DATA
		BYTE	040H		;iEオ@@@Pj
;
		BYTE	0C0H		;iオ@@@Pj
;
		BYTE	026H		;iEオ@@@P^Qj
;
		BYTE	0DAH		;iオ@@@P^Qj
;
		BYTE	014H		;iEオ@@@P^Sj
;
		BYTE	0ECH		;iオ@@@P^Sj
;
		BYTE	000H		;
;
;
;[~[
;		WORD	aS*aS
;		WORD	aL*aL
;		HEX	a
;		WORD	pUiPt[ɉxj*100H/2  ipxO`Oeegj
;		HEX	000
;
ROPE_EN_DATA
		WORD	(010H-1-2)*(010H-1-2)		;[00]-[03]
		WORD	(010H+2)*(010H+2)		;
		BYTE	010H-1
		WORD	0051FH/2
		HEX	000
;
		WORD	(020H-1-2)*(020H-1-2)		;[04]-[07]
		WORD	(020H+2)*(020H+2)		;
		BYTE	020H-1
		WORD	0028DH/2
		HEX	000
;
		WORD	(080H-1-2)*(080H-1-2)		;[08]-[0B]
		WORD	(080H+2)*(080H+2)		;
		BYTE	080H-1
		WORD	000A3H/2
		HEX	000
;
;****************************************************************
;*		̂n`lZbgʒuvZ			*
;*								*
;*	[In]							*
;*		R1	Ԓ̂̉]p			*
;*		R5	ԊỔ]p			*
;*		R8	L				*
;*								*
;****************************************************************
OSARU_POS_CALC	EQU	$
		IWT	R6,#100H/3*100H
		TO	R9
		FMULT

		IWT	R10,#001FEH

		IBT	R6,#-00AH
		mJSR	M_ENMY_1P_ROT_S
		SMS	R0,CWORK10
		SMS	R1,CWORK11

		FROM	R7
		ADD	R9
		TO	R1
		AND	R10
		IBT	R6,#-00AH*3
		mJSR	M_ENMY_1P_ROT_S
		SMS	R0,CWORK12
		SMS	R1,CWORK13

		FROM	R5
		SUB	R9
		TO	R1
		AND	R10
		IBT	R6,#-00AH*5
		mJSR	M_ENMY_1P_ROT_S
		SMS	R0,CWORK14
		SMS	R1,CWORK15

		MOVE	R1,R5
		IBT	R6,#-00AH*7
		mJSR	M_ENMY_1P_ROT_S
		SMS	R0,CWORK16
		SMS	R1,CWORK17

		MOVES	R8,R8			; ?
		BEQ	OSARU_P_C0800		; yes: OSARU_P_C0800
		NOP

		IWT	R7,#CWORK10
		IBT	R12,#04
		CACHE
		MOVE	R13,R15

		LDW	(R7)
		NOT
		INC	R0
		WITH	R7
		ADD	#04

		LOOP
		SBK

OSARU_P_C0800
		STOP
		NOP
;
;
;
;
;****************************************************************
;*								*
;*   Ⴒ낲̔{A]pAIuWFՓ˃`FbNTCYvZ	*
;*								*
;*	[IN]							*
;*		R10	G̃CfbNX			*
;*								*
;****************************************************************
M_YGORO_CALC	EQU	$
		mLDW0	CENXSPD,R10
		ADD	R0
		ADD	R0
		TO	R6
		ADD	R0

		IWT	R3,#DIVBUF
		mLDW	R1,CENWRK6,R10
		FROM	R1
		LSR
		LSR
		BIC	#01H
		ADD	R3
		LDW	(R0)

		LMULT
		SUB	#0
		BPL	YGORO_CALC0100
		NOP

		NOT
		INC	R0

YGORO_CALC0100
		DIV2
		ADD	R1
		IWT	R6,#001FFH*8
		CMP	R6
		BPL	YGORO_CALC0200
		WITH	R0

		TO	R6

YGORO_CALC0200
		mSTW	R6,CENWRK6,R10
		MOVE	R7,R6

		mLDW0	CENMOVX,R10
		ADD	R0
		ADD	R0
		TO	R2
		ADD	R0
		FROM	R6
		LSR
		LSR
		BIC	#01H
		ADD	R3
		TO	R6
		LDW	(R0)
		mLDW	R1,CENWRK8,R10
		FROM	R2
		LMULT
		FROM	R1
		SUB	R4
		SBK

		FROM	R7
		LSR
		LSR
		TO	R6
		LSR
		IBT	R0,#00CH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R1
		OR	R4
		mSTW	R1,CEWIDEX,R10
		mSTW	R1,CEWIDEY,R10

		STOP
		NOP
;
;****************************************************************
;*		ނWQ̒ގn`lZbg			*
;*	[In]							*
;*		R6						*
;*		R8	l( TJUGMSPD )			*
;*		R10	G̃CfbNX			*
;*		R11	̒				*
;*								*
;****************************************************************
;
;WQ̃TI
TJUGM_CHAR_ADR	EQU	$
		BYTE	0F6H,0FBH	;[00]
		HEX	24,02,02
;
		BYTE	0F6H,0FBH	;[01]
		HEX	24,02,02
;
		BYTE	0FAH,0E9H	;[02]
		HEX	24,02,02
;
M_TJUGM_OAMSET	EQU	$
		FROM	R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8
		OR	R4

		mLDW	R1,CENDSXL,R10
		mLDW	R2,CENDSYL,R10
		IWT	R3,#02000H
		mLDB0	CENCHRB,R10
		MULT	#08
		TO	R3
		ADD	R3
;
		IBT	R0,#BANK TJUGM_CHAR_ADR ;TĨLf[^oNZbg
		ROMB				;
		IWT	R4,#TJUGM_CHAR_ADR	;TĨLf[^AhXvZ
		mLDB0	CENCHPT,R10		;
		MULT	#05			;
		TO	R14			;
		ADD	R4			;
		mLDW	R4,CENOAML,R10

		GETBS				;X position set
		INC	R14			;
		ADD	R1			;
		STW	(R4)			;
		MOVE	R1,R0			;
		INC	R4			;
		INC	R4			;
		GETBS				;Y position set
		INC	R14			;
		ADD	R2			;
		STW	(R4)			;
		MOVE	R2,R0			;
		INC	R4			;
		INC	R4			;
		GETB				;Attribute & char no. set
		INC	R14			;
		GETBH				;
		INC	R14			;
		ADD	R3			;
		STW	(R4)			;
		INC	R4			;
		INC	R4			;
		GETB				;other data set
		INC	R14			;
		STW	(R4)			;
		INC	R4			;

		FROM	R8			;Zbgw@onrDvZ
		TO	R9
		ADD	R8

		WITH	R2			;Zbgx@onrDvZ
		ADD	#08			;

		mLDB0	CENMOD2+1,R10		;̐vZ
		LSR				;
		LSR				;
		LSR				;
		TO	R12			;
		SUB	#05+02			; ?
		BEQ	TJUGM_OAMSET100		;  no: TJUGM_OAMSET100
		INC	R4

		IWT	R0,#00234H		;Attribute & char no. f[^Zbg
		TO	R7			;
		ADD	R3			;

		CACHE
		MOVE	R13,R15

		FROM	R11			;Zbgx@onrDvZ
		SUB	#08			;
		BMI	TJUGM_OAMSET010		;
		NOP				;
						;
		WITH	R11			;
		SUB	#08			;
		WITH	R9			;
		ADD	R8			;
		IBT	R0,#08			;
		BRA	TJUGM_OAMSET020		;
		NOP				;
						;
TJUGM_OAMSET010					;
		MOVE	R5,R4			;
		FROM	R8			;
		DIV2				;
		DIV2				;
		TO	R6			;
		DIV2				;
		FROM	R11			;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		TO	R9			;
		ADD	R9			;
		MOVE	R4,R5			;
						;
		FROM	R11			;
						;
TJUGM_OAMSET020					;
		TO	R2			;
		ADD	R2			;

		FROM	R9			;Zbgw@onrDvZ
		HIB				;
		SEX				;
		TO	R1			;
		ADD	R1			;

		FROM	R1			;X position set
		STW	(R4)			;
		INC	R4			;
		INC	R4			;
		FROM	R2			;Y position set
		STW	(R4)			;
		INC	R4			;
		INC	R4			;
		FROM	R7			;Attribute & char no. set
		STW	(R4)			;
		INC	R4			;
		INC	R4			;
		SUB	R0			;other data set
		STW	(R4)			;
		INC	R4			;

		LOOP
		INC	R4

TJUGM_OAMSET100
		WITH	R9			;Zbgw@onrDvZ
		ADD	R8			;
		FROM	R9			;
		HIB				;
		SEX				;
		TO	R1			;
		ADD	R1			;

		WITH	R2			;Zbgx@onrDvZ
		ADD	#08			;

		WITH	R1
		SUB	#07

		FROM	R1
		STW	(R4)
		INC	R4
		INC	R4
		FROM	R2
		STW	(R4)
		INC	R4
		INC	R4
		IWT	R0,#00226H
		ADD	R3
		STW	(R4)
		INC	R4
		INC	R4
		IBT	R0,#02
		STW	(R4)
		INC	R4
		INC	R4

		WITH	R9
		ADD	R8
		FROM	R9
		HIB
		TO	R9
		SEX

		STOP
		NOP
;
;****************************************************************
;*								*
;*		Nbp hX EF[u Zbg			*
;*								*
;*	[In]							*
;*		R2	g̗					*
;*		R4						*
;*		R5	obt@CfbNXZf[^		*
;*		R6						*
;*		R7						*
;*		R8	Phbgi񂾂Ƃ̔g̗͉Zl	*
;*		R9	g̐擪 DS pos.			*
;*								*
;*								*
;*								*
;****************************************************************
KUPPA_DOSUN	EQU	$
		CACHE			; LbV X^[g!!
		IWT	R1,#02000H
		LMS	R0,CESCCH1
		SM	R0,CBG2OFH
		OR	R1		; R0 <- {gXN[l
		IWT	R10,#CBG2OFF
		IBT	R12,#020H
		MOVE	R13,R15
;
		STW	(R10)		; hp obt@ NA
		INC	R10		;
		LOOP			;
		INC	R10		;
;
		LMS	R0,CESCCV1
		OR	R1		; R0 <- {uXN[l
		MOVE	R3,R0
		IBT	R12,#020H
		MOVE	R13,R15
;
		STW	(R10)		; chp obt@ NA
		INC	R10		;
		LOOP			;
		INC	R10		;
;
		STOP
		NOP
;
;
KUPPA_DOSUN2	EQU	$
		CACHE				; LbV X^[g!!
;
		IBT	R1,#0F8H		;(R10) <- obt@ZbgCfbNX
		FROM	R9			;
		AND	R1			;
		DIV2				;
		DIV2				;
		IWT	R1,#CBG2OFF+040H	;
		TO	R10			;
		ADD	R1			;
;
		FROM	R9			;(R2) <- obt@ɃZbgŏ̔g̗
		AND	#07H			;
		SUB	#04H			;
		MULT	R8			;
		TO	R2			;
		ADD	R2			;
		MOVE	R4,R2			;(R4) <- obt@ɃZbgŏ̔g̍
;
		IWT	R8,#0FC00H		;(R8) <- Whbgi񂾂Ƃ̔g̗͉Zl
;
		IWT	R1,#02000H		;(R3) <- {uXN[l
		LMS	R0,CESCCV1		;
		TO	R3			;
		OR	R1			;
;
		IWT	R6,#CBG2OFF+040H
		IWT	R7,#CBG2OFF+040H+040H+1
;
KP_DSN_100
		FROM	R10			;obt@͈͊Oi[j ?
		CMP	R6			;
		BMI	KP_DSN_200		; yes: KP_DSN_200
		NOP
		FROM	R10			;obt@͈͊OiE[j ?
		CMP	R7			;
		BPL	KP_DSN_200		; yes: KP_DSN_200
		NOP

		FROM	R4			;(R1) <- obt@ɃZbgf[^
		HIB				;
		SEX				;
		TO	R1			;
		ADD	R3			;
		LDW	(R10)			;OɃZbgĂf[^̕傫 ?
		SUB	R1			;
		BPL	KP_DSN_200		; yes: KP_DSN_200
		NOP
;
		FROM	R1			;f[^Zbg
		STW	(R10)			;
;
KP_DSN_200
		WITH	R10			;(R10) <- ̃obt@CfbNX
		ADD	R5			;

		WITH	R2			;g̒_߂ ?
		ADD	R8			;
		BPL	KP_DSN_300		;  no: KP_DSN_300
		WITH	R4

		IWT	R8,#0FC80H
		WITH	R4

KP_DSN_300
;		WITH	R4			;g ?
		ADD	R2			;
		BPL	KP_DSN_100+1		;  no: KP_DSN_100+1
		FROM	R10
;
;
		LMS	R1,CESCCH1
		IBT	R2,#0F8H
		IBT	R0,#018H
		CMP	R1		; [܂łĂ邩 ?
		BEQ	KP_DSN_400	;
		NOP			;	NO -> KP_DSN_400
		BCC	KP_DSN_400	;
		SUB	R1
		ADD	#007
		AND	R2
		LSR
		LSR
		TO	R12
		LSR
		IWT	R10,#CBG2OFF+040H
		MOVE	R0,R3
		MOVE	R13,R15
		STW	(R10)
		INC	R10
		LOOP
		INC	R10
;
KP_DSN_400
		IWT	R0,#00160H
		SUB	R1
		TO	R1
		HIB			; E[܂łĂ邩 ?
		BNE	KP_DSN_500	;	NO -> KP_DSN_500
		NOP
		SUB	#007
		AND	R2
		LSR
		TO	R1
		LSR
		TO	R12
		LSR
		IWT	R0,#CBG2OFF+040H
		TO	R11
		ADD	R1
		IBT	R0,#040H
		TO	R12
		SUB	R12
		MOVE	R0,R3
		MOVE	R13,R15
		STW	(R11)
		INC	R11
		LOOP
		INC	R11
;
KP_DSN_500
		IWT	R0,#CBG2OFF+040H
		LDW	(R0)
		SM	R0,CBG2OFV
;
		STOP
		NOP
;
;
;
;
;
;
;
;
;
;
		mEND_NOP
;
		END
