/****************************************************************/
/*	bZ[WRo[^[					*/
/*		( gcc msgcnvS.c -o msgcnvS )			*/
/*						by S.Takahata	*/
/****************************************************************/
#include	<stdio.h>
#include	<string.h>

#define		MAXMUM	1000
#if 0
#define		DSP
#endif

typedef struct{
    unsigned short	name;
    unsigned char	label[6];
}LABEL;

static LABEL	cnvdat[MAXMUM];
static int	num;
static FILE	*fpr, *fpw;

static int moji_label(unsigned short s);
static int moji_number(unsigned short s);

void main(int argc, char **argv)
{
    int		i;
    unsigned char	in_file[40], out_file[44], label_file[40], title[40];
    
    if(argc < 2){
	printf("Input Error !!\n");
	printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
	exit(1);
    }
    
    strcpy(in_file, argv[1]);
    strcpy(out_file, argv[1]);
    strcat(out_file, ".OUT");
    strcpy(label_file, "msg.LBL");
    title[0] = '\0';
    if(argc >= 3){
	for(i = 2; i < argc; i++){
	    if(*argv[i] != '-'){
		printf("Input Error !!\n");
		printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
		exit(1);
	    }
	    switch(*(argv[i]+1)){
		case 'l' :
		case 'L' :
		    strcpy(title, argv[i]+2);
		    strcat(title, "\tEQU\t$\n");
		    break;
		case 'h' :
		case 'H' :
		    strcpy(label_file, argv[i]+2);
		    break;
		default :
		    printf("Input Error !!\n");
		    printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
		    exit(1);
	    }
	}
    }

    if((fpr = fopen(label_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", label_file);
	exit(1);
    }

    num = fread(cnvdat, sizeof(LABEL), MAXMUM, fpr);
    
    for(i=0; i<num; i++)
	cnvdat[i].label[5] = '\0';
    
    fclose(fpr);

    if((fpr = fopen(in_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", in_file);
	exit(1);
    }
    if((fpw = fopen(out_file, "w")) == NULL){
	printf("File Open Error !! [%s]\n", out_file);
	exit(1);
    }

    printf("JnII <<< %s >>>\n", in_file);
    
    fprintf(fpw, "%s", title);
#ifdef DSP
    printf("%s", title);
#endif
    mojicheck();
    
    fclose(fpr);
    fclose(fpw);

    printf("III\n");
}

mojicheck()
{
    static unsigned char
		number[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'},
		Mctl[4] = "";
    int		i, j, c, no, sp;
    unsigned char	str[256], suu[5];
    unsigned short	s, *ctl;

    ctl = (unsigned short *)Mctl;
	
    i = 0;
    while((c = getc(fpr)) != EOF){
	if(i == 0){
	    if(c < 0x20){
#ifdef DSP
		printf(";\n", str);
#endif
		fprintf(fpw, ";\n", str);
	    }
	    else{
		s = (unsigned short)c << 8;
		c = getc(fpr);
		s = s | (unsigned short)c;
		if((no = moji_label(s)) >= 0){
		    i ++;
		    strcpy(str, "\t\tBYTE\t");
		    strcat(str, cnvdat[no].label);
		    if(cnvdat[no].name == *ctl){
			strcat(str, ",0");
			c = getc(fpr);
			s = (unsigned short)c << 8;
			c = getc(fpr);
			s = s | (unsigned short)c;
			j = moji_number(s);
			suu[0] = number[j];
			c = getc(fpr);
			s = (unsigned short)c << 8;
			c = getc(fpr);
			s = s | (unsigned short)c;
			j = moji_number(s);
			suu[1] = number[j];
			suu[2] = 'H';
			suu[3] = '\0';
			strcat(str, suu);
		    }
		}
	    }
	}
	else{
	    if(c < 0x20){
#ifdef DSP
		printf("%s\n", str);
#endif
		fprintf(fpw, "%s\n", str);
		i = 0;
	    }
	    else{
		i ++;
		s = (unsigned short)c << 8;
		c = getc(fpr);
		s = s | (unsigned short)c;
		if((no = moji_label(s)) >= 0){
		    strcat(str, ",");
		    strcat(str, cnvdat[no].label);
		    if(cnvdat[no].name == *ctl){
			strcat(str, ",0");
			c = getc(fpr);
			s = (unsigned short)c << 8;
			c = getc(fpr);
			s = s | (unsigned short)c;
			j = moji_number(s);
			suu[0] = number[j];
			c = getc(fpr);
			s = (unsigned short)c << 8;
			c = getc(fpr);
			s = s | (unsigned short)c;
			j = moji_number(s);
			suu[1] = number[j];
			suu[2] = 'H';
			suu[3] = '\0';
			strcat(str, suu);
		    }
		}
	    }
	}
    }
}

static int moji_label(unsigned short s)
{
    int		i;

    for(i = 0; i < num; i ++){
	if(s == cnvdat[i].name)	return i;
    }
    return -1;
}

static int moji_number(unsigned short s)
{
    static unsigned char
    		Wnum[16][4] = {"O","P","Q","R","S","T","U","V","W","X","`","a","b","c","d","e"};
    int		i;
    unsigned short	*w_num[16];

    for(i = 0; i < 16; i++){
	w_num[i] = (unsigned short *)(Wnum[i]);
    }

    i = 16 - 1;
    while(i > -1){
	  if(s == *w_num[i])	return i;
	  i --;
    }
    printf("Error !! << Not Hex !! >>");
    exit(1);
}


