;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: kouka main					*
;*	file name	: ys_exst					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_pld.h
		include		ys_color.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	EXSTRA,EXINSR,M_HZKIN
		GLB	WTUP0,WTUP1,BABL0,EGGWR,DOON0,SCORE
		GLB	SMOK0,SMOK1,CCHG0,BRBG0,MSMK0
		GLB	KIRA0,TRSMK,YGUP0,KIRA1,SOPB1,SNOW0,SNOW1
		GLB	SNWBR,FUSNB,SHIBU,BRETH,AWASP,SLMAP,SSLMB
		GLB	KPF_P,KUMOB,SMK00,BUBBR,ASE01,SMK01
		GLB	SMK02,STAR0,SMK03,DOSN0,DUST0
		GLB	STAR1,DSMK0,DSMK1,AWABR,NAG_P,ARROW
		GLB	FLKIR,TUBU0,FSMK0,FSMK1,SMK04,STAR2
		GLB	TATE0,YARI0
		GLB	PACHI,SMK05,PONBR,KACHB,COLDK,DSMK2,ICECL
		GLB	TRBBR,PURBR,MC2S0,MC2S1,TAKEU,KINTS,MSNSK
		GLB	FHHIK,FVHIK,TEN_2,PKSB0,PKSB1,AHANE
		GLB	REFAW,PICHA,HANA0,YUGE0,SIBU0,HANE0,MIZU0
		GLB	KABUT,FSMK2,PIYOS,EBSMK,SBALL,GOKOU,SBALS
		GLB	HIRA0,HIRA1
		GLB	ONPU0,ICEBR,YKCHI,BRTOG,BR2CR,BHANE,BONE0
		GLB	SLMSB,KPSMK,BONE1,CPSMK,YOGN0,DORO0,DORO1
		GLB	SIBUY,BSQKR,KIRA2,IKSMK,MPKBR,BS0BR,QAROW
		GLB	LFAWA,COINX,ASE02,HADOU,TANE0
;
		GLB	SKSNOW
;
		GLB	FSMK2P,KPSMK_P
		GLB	M_SM0,M_ATA,M_HAZ,M_ATK,M_HZK
;;;;K;;;;		GLB	MP_SB
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
		EXT	SOUND_3_ON
;
;-------------< sy_mini >------------------------------------------------
		EXT	MHDPLY_JSL
;
;-------------< sy_play >------------------------------------------------
		EXT	EBSTAT
;
;-------------< sy_enmy2 >-----------------------------------------------
		EXT	NMZ_HOSEI
;
;-------------< sy_data >------------------------------------------------
		EXT	SIN,COS
;-------------< sy_rpro >------------------------------------------------
		EXT	CHIPON
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;		EQU	8DH
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
Group_0		GROUP	Exst_pro
Exst_pro	SECT	REL
;
;************************************************************************
;*		exstra move name table					*
;************************************************************************
EXNAME		EQU	$-EXSTART*2
WTUP0N		WORD	WTUP0MV-1	;[WTUP0]
WTUP1N		WORD	WTUP1MV-1	;[WTUP1]
BABL0N		WORD	BABL0MV-1	;[BABL0]
EGGWRN		WORD	EGGWRMV-1	;[EGGWR]
DOON0N		WORD	DOON0MV-1	;[DOON0]
SCOREN		WORD	SCOREMV-1	;[SCORE]
SMOK0N		WORD	SMOK0MV-1	;[SMOK0]
SMOK1N		WORD	SMOK1MV-1	;[SMOK1]
CCHG0N		WORD	CCHG0MV-1	;[CCHG0]
BRBG0N		WORD	BRBG0MV-1	;[BRBG0]
MSMK0N		WORD	MSMK0MV-1	;[MSMK0]
KIRA0N		WORD	KIRA0MV-1	;[KIRA0]
TRSMKN		WORD	TRSMKMV-1	;[TRSMK]
YGUP0N		WORD	YGUP0MV-1	;[YGUP0]
KIRA1N		WORD	KIRA1MV-1	;[KIRA1]
SOPB1N		WORD	SOPB1MV-1	;[SOPB1]
SNOW0N		WORD	SNOW0MV-1	;[SNOW0]
SNOW1N		WORD	SNOW1MV-1	;[SNOW1]
SNWBRN		WORD	SNWBRMV-1	;[SNWBR]
FUSNBN		WORD	FUSNBMV-1	;[FUSNB]
SHIBUN		WORD	SHIBUMV-1	;[SHIBU]
BRETHN		WORD	BRETHMV-1	;[BRETH]
AWASPN		WORD	AWASPMV-1	;[AWASP]
SLMAPN		WORD	SLMAPMV-1	;[SLMAP]
SSLMBN		WORD	SSLMBMV-1	;[SSLMB]
KPF_PN		WORD	KPF_PMV-1	;[KPF_P]
KUMOBN		WORD	KUMOBMV-1	;[KUMOB]
SMK00N		WORD	SMK00MV-1	;[SMK00]
BUBBRN		WORD	BUBBRMV-1	;[BUBBR]
ASE01N		WORD	ASE01MV-1	;[ASE01]
SMK01N		WORD	SMK01MV-1	;[SMK01]
SMK02N		WORD	SMK02MV-1	;[SMK02]
STAR0N		WORD	STAR0MV-1	;[STAR0]
SMK03N		WORD	SMK03MV-1	;[SMK03]
DOSN0N		WORD	DOSN0MV-1	;[DOSN0]
DUST0N		WORD	DUST0MV-1	;[DUST0]
STAR1N		WORD	STAR1MV-1	;[STAR1]
DSMK0N		WORD	DSMK0MV-1	;[DSMK0]
DSMK1N		WORD	DSMK1MV-1	;[DSMK1]
AWABRN		WORD	AWABRMV-1	;[AWABR]
NAG_PN		WORD	NAG_PMV-1	;[NAG_P]
ARROWN		WORD	ARROWMV-1	;[ARROW]
FLKIRN		WORD	FLKIRMV-1	;[FLKIR]
TUBU0N		WORD	TUBU0MV-1	;[TUBU0]
FSMK0N		WORD	FSMK0MV-1	;[FSMK0]
FSMK1N		WORD	FSMK1MV-1	;[FSMK1]
SMK04N		WORD	SMK04MV-1	;[SMK04]
STAR2N		WORD	STAR2MV-1	;[STAR2]
TATE0N		WORD	TATE0MV-1	;[TATE0]
YARI0N		WORD	YARI0MV-1	;[YARI0]
PACHIN		WORD	PACHIMV-1	;[PACHI]
SMK05N		WORD	SMK05MV-1	;[SMK05]
PONBRN		WORD	PONBRMV-1	;[PONBR]
KACHBN		WORD	KACHBMV-1	;[KACHB]
COLDKN		WORD	COLDKMV-1	;[COLDK]
DSMK2N		WORD	DSMK2MV-1	;[DSMK2]
ICECLN		WORD	ICECLMV-1	;[ICECL]
TRBBRN		WORD	TRBBRMV-1	;[TRBBR]
PURBRN		WORD	PURBRMV-1	;[PURBR]
MC2S0N		WORD	MC2S0MV-1	;[MC2S0]
MC2S1N		WORD	MC2S1MV-1	;[MC2S1]
TAKEUN		WORD	TAKEUMV-1	;[TAKEU]
KINTSN		WORD	KINTSMV-1	;[KINTS]
MSNSKN		WORD	MSNSKMV-1	;[MSNSK]
FHHIKN		WORD	FHHIKMV-1	;[FHHIK]
FVHIKN		WORD	FVHIKMV-1	;[FVHIK]
TEN_2N		WORD	TEN_2MV-1	;[TEN_2]
PKSB0N		WORD	PKSB0MV-1	;[PKSB0]
PKSB1N		WORD	PKSB1MV-1	;[PKSB1]
AHANEN		WORD	AHANEMV-1	;[AHANE]
REFAWN		WORD	REFAWMV-1	;[REFAW]
PICHAN		WORD	PICHAMV-1	;[PICHA]
HANA0N		WORD	HANA0MV-1	;[HANA0]
YUGE0N		WORD	YUGE0MV-1	;[YUGE0]
SIBU0N		WORD	SIBU0MV-1	;[SIBU0]
HANE0N		WORD	HANE0MV-1	;[HANE0]
MIZU0N		WORD	MIZU0MV-1	;[MIZU0]
KABUTN		WORD	KABUTMV-1	;[KABUT]
FSMK2N		WORD	FSMK2MV-1	;[FSMK2]
PIYOSN		WORD	PIYOSMV-1	;[PIYOS]
EBSMKN		WORD	EBSMKMV-1	;[EBSMK]
BRTOGN		WORD	BRTOGMV-1	;[BRTOG]
BR2CRN		WORD	BR2CRMV-1	;[BR2CR]
SBALLN		WORD	SBALLMV-1	;[SBALL]
GOKOUN		WORD	GOKOUMV-1	;[GOKOU]
SBALSN		WORD	SBALSMV-1	;[SBALS]
HIRA0N		WORD	HIRA0MV-1	;[HIRA0]
HIRA1N		WORD	HIRA1MV-1	;[HIRA1]
ONPU0N		WORD	ONPU0MV-1	;[ONPU0]
ICEBRN		WORD	ICEBRMV-1	;[ICEBR]
YKCHIN		WORD	YKCHIMV-1	;[YKCHI]
BHANEN		WORD	BHANEMV-1	;[BHANE]
BONE0N		WORD	BONE0MV-1	;[BONE0]
SLMSBN		WORD	SLMSBMV-1	;[SLMSB]
KPSMKN		WORD	KPSMKMV-1	;[KPSMK] NbpoN_
BONE1N		WORD	BONE0MV-1	;[BONE1] [l̍
CPSMKN		WORD	CPSMKMV-1	;[CPSMK]
YOGN0N		WORD	YOGN0MV-1	;[YOGN0]
DORO0N		WORD	DORO0MV-1	;[DORO0]
DORO1N		WORD	DORO1MV-1	;[DORO1]
SIBUYN		WORD	SIBUYMV-1	;[SIBUY]
BSQKRN		WORD	BSQKRMV-1	;[BSQKR]
KIRA2N		WORD	KIRA2MV-1	;[KIRA2]
IKSMKN		WORD	IKSMKMV-1	;[IKSMK]
MPKBRN		WORD	MPKBRMV-1	;[MPKBR]
BS0BRN		WORD	BS0BRMV-1	;[BS0BR]
QAROWN		WORD	QAROWMV-1	;[QAROW] H
LFAWAN		WORD	LFAWAMV-1	;[LFAWA]
COINXN		WORD	COINXMV-1	;[COINX] RC
ASE02N		WORD	ASE02MV-1	;[ASE02] JbN(KAMC3)̊
HADOUN		WORD	HADOUMV-1	;[HADOU] g̏[U
TANE0N		WORD	TANE0MV-1	;[TANE0] Z̎
;
M_SM0N		WORD	M_SM0MV-1	;[M_SM0] ~jQ[piĈނjk;
M_ATAN		WORD	M_ATAMV-1	;[M_ATA] ~jQ[pi蕶j
M_HAZN		WORD	M_HAZMV-1	;[M_HAZ] ~jQ[pinYj
M_ATKN		WORD	M_ATKMV-1	;[M_ATK] ~jQ[piʁj
M_HZKN		WORD	M_HZKMV-1	;[M_HZK] ~jQ[pinYʁj
;
;;;;K;;;;MP_SBN		WORD	MP_SBMV-1	;[MP_SB] l`opiԂj
EXENDN		EQU	$
;
EXTR_NAME	EQU	$
WTUP0		EQU	(WTUP0N-EXNAME)/2
WTUP1		EQU	(WTUP1N-EXNAME)/2
BABL0		EQU	(BABL0N-EXNAME)/2
EGGWR		EQU	(EGGWRN-EXNAME)/2
DOON0		EQU	(DOON0N-EXNAME)/2
SCORE		EQU	(SCOREN-EXNAME)/2
SMOK0		EQU	(SMOK0N-EXNAME)/2
SMOK1		EQU	(SMOK1N-EXNAME)/2
CCHG0		EQU	(CCHG0N-EXNAME)/2
BRBG0		EQU	(BRBG0N-EXNAME)/2
MSMK0		EQU	(MSMK0N-EXNAME)/2
KIRA0		EQU	(KIRA0N-EXNAME)/2
TRSMK		EQU	(TRSMKN-EXNAME)/2
YGUP0		EQU	(YGUP0N-EXNAME)/2
KIRA1		EQU	(KIRA1N-EXNAME)/2
SOPB1		EQU	(SOPB1N-EXNAME)/2
SNOW0		EQU	(SNOW0N-EXNAME)/2
SNOW1		EQU	(SNOW1N-EXNAME)/2
SNWBR		EQU	(SNWBRN-EXNAME)/2
FUSNB		EQU	(FUSNBN-EXNAME)/2
SHIBU		EQU	(SHIBUN-EXNAME)/2
BRETH		EQU	(BRETHN-EXNAME)/2
AWASP		EQU	(AWASPN-EXNAME)/2
SLMAP		EQU	(SLMAPN-EXNAME)/2
SSLMB		EQU	(SSLMBN-EXNAME)/2
KPF_P		EQU	(KPF_PN-EXNAME)/2
KUMOB		EQU	(KUMOBN-EXNAME)/2
SMK00		EQU	(SMK00N-EXNAME)/2
BUBBR		EQU	(BUBBRN-EXNAME)/2
ASE01		EQU	(ASE01N-EXNAME)/2
SMK01		EQU	(SMK01N-EXNAME)/2
SMK02		EQU	(SMK02N-EXNAME)/2
STAR0		EQU	(STAR0N-EXNAME)/2
SMK03		EQU	(SMK03N-EXNAME)/2
DOSN0		EQU	(DOSN0N-EXNAME)/2
DUST0		EQU	(DUST0N-EXNAME)/2
STAR1		EQU	(STAR1N-EXNAME)/2
DSMK0		EQU	(DSMK0N-EXNAME)/2
DSMK1		EQU	(DSMK1N-EXNAME)/2
AWABR		EQU	(AWABRN-EXNAME)/2
NAG_P		EQU	(NAG_PN-EXNAME)/2
ARROW		EQU	(ARROWN-EXNAME)/2
FLKIR		EQU	(FLKIRN-EXNAME)/2
TUBU0		EQU	(TUBU0N-EXNAME)/2
FSMK0		EQU	(FSMK0N-EXNAME)/2
FSMK1		EQU	(FSMK1N-EXNAME)/2
SMK04		EQU	(SMK04N-EXNAME)/2
STAR2		EQU	(STAR2N-EXNAME)/2
TATE0		EQU	(TATE0N-EXNAME)/2
YARI0		EQU	(YARI0N-EXNAME)/2
PACHI		EQU	(PACHIN-EXNAME)/2
SMK05		EQU	(SMK05N-EXNAME)/2
PONBR		EQU	(PONBRN-EXNAME)/2
KACHB		EQU	(KACHBN-EXNAME)/2
COLDK		EQU	(COLDKN-EXNAME)/2
DSMK2		EQU	(DSMK2N-EXNAME)/2
ICECL		EQU	(ICECLN-EXNAME)/2
TRBBR		EQU	(TRBBRN-EXNAME)/2
PURBR		EQU	(PURBRN-EXNAME)/2
MC2S0		EQU	(MC2S0N-EXNAME)/2
MC2S1		EQU	(MC2S1N-EXNAME)/2
TAKEU		EQU	(TAKEUN-EXNAME)/2
KINTS		EQU	(KINTSN-EXNAME)/2
MSNSK		EQU	(MSNSKN-EXNAME)/2
FHHIK		EQU	(FHHIKN-EXNAME)/2
FVHIK		EQU	(FVHIKN-EXNAME)/2
TEN_2		EQU	(TEN_2N-EXNAME)/2
PKSB0		EQU	(PKSB0N-EXNAME)/2
PKSB1		EQU	(PKSB1N-EXNAME)/2
AHANE		EQU	(AHANEN-EXNAME)/2
REFAW		EQU	(REFAWN-EXNAME)/2
PICHA		EQU	(PICHAN-EXNAME)/2
HANA0		EQU	(HANA0N-EXNAME)/2
YUGE0		EQU	(YUGE0N-EXNAME)/2
SIBU0		EQU	(SIBU0N-EXNAME)/2
HANE0		EQU	(HANE0N-EXNAME)/2
MIZU0		EQU	(MIZU0N-EXNAME)/2
KABUT		EQU	(KABUTN-EXNAME)/2
FSMK2		EQU	(FSMK2N-EXNAME)/2
PIYOS		EQU	(PIYOSN-EXNAME)/2
EBSMK		EQU	(EBSMKN-EXNAME)/2
BRTOG		EQU	(BRTOGN-EXNAME)/2
BR2CR		EQU	(BR2CRN-EXNAME)/2
SBALL		EQU	(SBALLN-EXNAME)/2
GOKOU		EQU	(GOKOUN-EXNAME)/2
SBALS		EQU	(SBALSN-EXNAME)/2
HIRA0		EQU	(HIRA0N-EXNAME)/2
HIRA1		EQU	(HIRA1N-EXNAME)/2
ONPU0		EQU	(ONPU0N-EXNAME)/2
ICEBR		EQU	(ICEBRN-EXNAME)/2
YKCHI		EQU	(YKCHIN-EXNAME)/2
BHANE		EQU	(BHANEN-EXNAME)/2
BONE0		EQU	(BONE0N-EXNAME)/2
SLMSB		EQU	(SLMSBN-EXNAME)/2
KPSMK		EQU	(KPSMKN-EXNAME)/2
BONE1		EQU	(BONE1N-EXNAME)/2
CPSMK		EQU	(CPSMKN-EXNAME)/2
YOGN0		EQU	(YOGN0N-EXNAME)/2
DORO0		EQU	(DORO0N-EXNAME)/2
DORO1		EQU	(DORO1N-EXNAME)/2
SIBUY		EQU	(SIBUYN-EXNAME)/2
BSQKR		EQU	(BSQKRN-EXNAME)/2
KIRA2		EQU	(KIRA2N-EXNAME)/2
IKSMK		EQU	(IKSMKN-EXNAME)/2
MPKBR		EQU	(MPKBRN-EXNAME)/2
BS0BR		EQU	(BS0BRN-EXNAME)/2
QAROW		EQU	(QAROWN-EXNAME)/2
LFAWA		EQU	(LFAWAN-EXNAME)/2
COINX		EQU	(COINXN-EXNAME)/2
ASE02		EQU	(ASE02N-EXNAME)/2
HADOU		EQU	(HADOUN-EXNAME)/2
TANE0		EQU	(TANE0N-EXNAME)/2
;
M_SM0		EQU	(M_SM0N-EXNAME)/2
M_ATA		EQU	(M_ATAN-EXNAME)/2
M_HAZ		EQU	(M_HAZN-EXNAME)/2
M_ATK		EQU	(M_ATKN-EXNAME)/2
M_HZK		EQU	(M_HZKN-EXNAME)/2
;
;;;;K;;;;MP_SB		EQU	(MP_SBN-EXNAME)/2
;
EXEND		EQU	(EXENDN-EXNAME)/2
;
;************************************************************************
;*		kouka main						*
;************************************************************************
EXSTRA		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDA	ENSTFG
		ORA	BIRIBIRI
		ORA	ITEMNO
		STA	MOVE_STOP	;rsno`FbNtOZbg
;
		LDX	#(EXNO-1)*4
EX0010		EQU	$
		LDY	EXMODE,X
		BEQ	EX0020		;݁H ( no:EX0020 )
;
		JSR	EXMAIN
EX0020		EQU	$
		DEX
		DEX
		DEX
		DEX
		BPL	EX0010
;
		PLB
		RTL
;
;************************************************************************
;*		kouka main sub						*
;*			in  : (A) <-- kouka type no.			*
;************************************************************************
EXMAIN		EQU	$
		LDA	EXSTNO,X
		ASL	A
;
		I16
;
		TAY
		LDA	EXNAME,Y
;
		I8
;
		PHA
		RTS
;
;************************************************************************
;*		exstra mode check					*
;************************************************************************
EXMDCK		EQU	$
		LDA	MOVE_STOP
		BEQ	EX_TIMER	;enemy stop ? ( no:EX_TIMER )
;
		PLA			;pull pull return !!
		RTS
;
EXMDCK_2	EQU	$
		LDA	MOVE_STOP
		BEQ	EX_TIMER	;enemy stop ? ( no:EX_TIMER )
		RTS
;
;------------------------------------------------------------------------
;-		^C}[vZ						-
;------------------------------------------------------------------------
EX_TIMER	EQU	$
		LDA	EXTIM0,X
		BNE	EXM010
;
		PLA			;[ pull pull return !! ]
;
;------------------------------------------------------------------------
;-		NA[Zbg						-
;------------------------------------------------------------------------
EXCLEAR		EQU	$
		STZ	EXMODE,X
		LDA	#00FFH
		STA	EXYUSN,X
		LDY	EXTROB,X
		BMI	EXM000		;]GAgpH ( no:EXM000 )
;
		LDA	TROBJ_SIZE,Y
		TRB	TROBJ_ARIA
EXM000		EQU	$
		RTS
;
EXM010		EQU	$
		DEC	EXTIM0,X
		LDA	EXTIM1,X
		BEQ	EXM018
		DEC	EXTIM1,X
EXM018		EQU	$
		LDY	EXSPTM,X
		BEQ	RTSSUB
		DEC	EXSPTM,X
RTSSUB		EQU	$
		RTS
;
;************************************************************************
;*		kouka area search					*
;*			in  : (A) <-- exstra no.			*
;*			out : (Y) <--	 "   index                      *
;************************************************************************
EXINSR		EQU	$
		PHA
		LDY	#(EXNO-1)*4
EIS010		EQU	$
		LDA	EXMODE,Y
		BEQ	EIS020		;area find ? ( yes:EIS020 )
		DEY
		DEY
		DEY
		DEY
		BPL	EIS010
		LDY	EXSTCT
		DEY
		DEY
		DEY
		DEY
		BPL	EIS012
		LDY	#(EXNO-1)*4
EIS012		EQU	$
		STY	EXSTCT
;
EIS020		EQU	$
		LDA	#0000H
		STA	EXXSPD,Y
		STA	EXYSPD,Y
		STA	EXMUKI,Y
		STA	EXEMU0,Y	;[ & STA EXXSDR,Y ]
		STA	EXCHRB,Y	;[ & STA EXYSDR,Y ]
		STA	EXWRK0,Y	;[ & STA EXWRK1,Y ]
		STA	EXWRK2,Y	;[ & STA EXWRK3,Y ]
		STA	EXWRK4,Y	;[ & STA EXWRK5,Y ]
		STA	EXTIM0,Y
		STA	EXTIM1,Y
		STA	EXCHPT,Y
		STA	EXCBFG,Y
		STA	EXSLOP,Y	;[ & STA EX_ADD_XSP,Y ]
		STA	EXBGYP,Y
		STA	EXDSXL,Y
		STA	EXDSYL,Y
		STA	EXXPOW,Y
		STA	EXXMAX,Y
		STA	EXWRKX,Y	;[ & STA EXWRKX,Y ]
		DEC	A		;[ LDA #0FFFFH ]
		STA	EXOAML,Y
		STA	EXTROB,Y
		LDA	#0FFH+(((100H/8)-1)*100H)
		STA	EXWATR,Y
		PLA
		STA	EXSTNO,Y	;exstra no. set
		PHX
		ASL	A
;
		I16
;
		TAX
;
		M8
;
		PHY			;(Y) save
;
		LDA	>EXCHR_BNK-EXSTART*2,X ;(A) <-- GLN^[oN
		LDY	#6
EIS24		EQU	$
		CMP	OBJCHR_BNK-1,Y
		BEQ	EIS26		;̃LN^[oNLH ( yes:EIS26 )
		DEY
		BNE	EIS24
		TYA			;[ LDA #0 ]
		BRA	EIS28
;
EIS26		EQU	$
		TYA
;;;;		    CLC			;[ * CMP : (Z)=(C) ]
		ADC	#(8-1)-1	;[ 8 --> 8*4*8 = 100H ]
		ASL	A		;[ 9 --> 9*4*8 = 120H ]
		ASL	A		;[	   "          ]
;
EIS28		EQU	$
;
		M16
;
		AND	#00FFH
		PLY			;(Y) load
		STA	EXCHRB,Y	;[ & STA EXYSDR,Y ]
		LDA	>EXDATA0-EXSTART*2+1,X
		AND	#00FFH
;;;;		    EOR	    #0020H	    ;pri. initial set
		EOR	#0030H		;pri. initial set
		STA	EXCLOR,Y
		LDA	>EXDATA0-EXSTART*2,X
		AND	#00FFH
		STA	EXYUSN,Y
		LDA	>EXDATA1-EXSTART*2-1,X
		AND	#0FF00H
		BPL	EIS030
		ORA	#00FFH
EIS030		EQU	$
		XBA
		STA	EXGPOW,Y
		LDA	>EXDATA1-EXSTART*2,X
		AND	#0FF00H
		BPL	EIS040
		ORA	#00FFH
EIS040		EQU	$
		XBA
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	EXGMAX,Y
		LDA	>EXMODE0-EXSTART*2,X
		STA	EXMOD0,Y
		LDA	>EXMODE1-EXSTART*2,X
		STA	EXMOD1,Y
		LDA	>EXMODE2-EXSTART*2,X
		STA	EXMOD2,Y
		LDA	#CENOK		;move "ON"
		STA	EXMODE,Y
		LDA	#00FFH
		STA	EXRETN,Y	;[ & STA EXDORE,Y ]
;
		I8
;
		PLX
		RTL
;
;************************************************************************
;*									*
;*		ʂ̍WvZ						*
;*									*
;************************************************************************
;
EX_XYMOVE	EQU	$
		LDA	EXXMAX,X
		SEC
		SBC	EXXSPD,X
		ASL	A		;(C) <-- (N)
		LDA	EXXPOW,X
		BCC	EX_XYMOVE_010
		EOR	#0FFFFH
		INC	A
EX_XYMOVE_010	EQU	$
		CLC
		ADC	EXXSPD,X
		STA	EXXSPD,X
;
		AND	#00FFH
		XBA
		CLC
		ADC	EXXSDR-1,X
		STA	EXXSDR-1,X	;(C) set
;
		LDA	EXXSPD,X
		AND	#0FF00H
		BPL	EX_XYMOVE_020
		ORA	#00FFH
EX_XYMOVE_020	EQU	$
		XBA
		ADC	#0
		STA	EXMOVX,X
;
		CLC
		ADC	EXXPSL,X
		STA	EXXPSL,X
;
		LDA	EXGMAX,X
		SEC
		SBC	EXYSPD,X
		ASL	A		;(C) <-- (N)
		LDA	EXGPOW,X
		BCC	EX_XYMOVE_030
		EOR	#0FFFFH
		INC	A
EX_XYMOVE_030	EQU	$
		CLC
		ADC	EXYSPD,X
		STA	EXYSPD,X
;
		AND	#00FFH
		XBA
		CLC
		ADC	EXYSDR-1,X
		STA	EXYSDR-1,X	;(C) set
;
		LDA	EXYSPD,X
		AND	#0FF00H
		BPL	EX_XYMOVE_040
		ORA	#00FFH
EX_XYMOVE_040	EQU	$
		XBA
		ADC	#0
		STA	EXMOVY,X
;
		CLC
		ADC	EXYPSL,X
		STA	EXYPSL,X
		RTS
;
;
;
;************************************************************************
;*		water in & out "basha--'n" set				*
;************************************************************************
WUP0CH		EQU	$
		WORD	0007H,0008H,0009H,000AH,0009H,0008H,0007H,0006H
		WORD	0005H,0004H,0003H,0002H,0001H
WUP0TM		EQU	$
		WORD	0003H,0004H,0005H,0004H,0003H,0003H,0003H,0003H
		WORD	0003H,0003H,0003H,0003H,0003H
;
WTUP0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	WUP020		;pattern change ? ( no:WUP020 )
		LDA	EXWRK0,X
		DEC	A
		DEC	A
		BPL	WUP010		;end ? ( no:WUP010 )
		RTS
;
WUP010		EQU	$
		STA	EXWRK0,X
		TAY
		LDA	!WUP0CH,Y
		STA	EXCHPT,X
		LDA	!WUP0TM,Y
		STA	EXTIM0,X
WUP020		EQU	$
		RTS
;
;************************************************************************
;*		water in & out "picha picha" set			*
;************************************************************************
WUP1YA		EQU	$-2
		WORD	00000H,00002H,00001H,00001H,00000H,00000H,00001H,00000H
		WORD	00000H,00000H,00000H,0FFFFH,00000H,00000H,0FFFFH,0FFFFH
		WORD	0FFFEH,00000H
WUP1YE		EQU	$
;
WTUP1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		ASL	A
		TAY
		LDA	!WUP1YA,Y
		CLC
		ADC	EXYPSL,X
		STA	EXYPSL,X
		RTS
;
;************************************************************************
;*		water in bable set					*
;************************************************************************
BABL0X		EQU	$
		WORD	00001H,00000H,00000H,00000H,00000H,00000H,0FFFFH,00000H
		WORD	0FFFFH,00000H,00000H,00000H,00000H,00000H,00001H,00000H
;
BABL0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXWATR,X
		AND	#00FFH
		STA	EXTIM0,X
		BNE	BABS10		;end ? ( no:BABS10 )
		JMP	EXCLEAR
;
BABS10		EQU	$
		LDA	#00FFH		;[ ԂoȂlɁII ]
		ORA	EXWATR,X
		STA	EXWATR,X
		LDA	#002H		;OAM set "ON" !!
		STA	EXYUSN,X	;[ EXYSDR dummy clear ! ]
		INC	EXWRK0,X
		LDA	EXWRK0,X
		BIT	#018H
		BEQ	BAB020
		DEC	EXYPSL,X
BAB020		EQU	$
		AND	#0FH
		ASL	A
		TAY
		LDA	EXXPSL,X
		CLC
		ADC	!BABL0X,Y
		STA	EXXPSL,X
		RTS
;
;************************************************************************
;*		egg ware						*
;************************************************************************
EGGWRMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	EGW010		;next pattern set ? ( no:EGW010 )
;
		INC	EXTIM0,X	;continue set
		LDA	EXCLOR,X
		ORA	#10000000B
		STA	EXCLOR,X	;V flip set
EGW010		EQU	$
		RTS
;
;************************************************************************
;*		enemy VS enemy cross "Doon" set				*
;************************************************************************
DON0PT		EQU	$-2
		BYTE	01000000B,01000000B,0FFH,00000000B,00000000B
;
DOON0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		INC	EXCHPT,X	;pattern change
		RTS
;
;************************************************************************
;*	RCZbg							*
;************************************************************************
COINXMV		EQU	$
		JSR	EXMDCK_2	;mode check
;
		LDA	<FRCNT2
		LSR	A
		LSR	A
		LSR	A
		AND	#00003H
		STA	!EXCHPT,X
		RTS
;
;
;************************************************************************
;*		score set						*
;************************************************************************
SCOREMV		EQU	$
		JSR	EXMDCK_2	;mode check
		RTS
;
;************************************************************************
;*		smoke.1 set						*
;************************************************************************
SMK0PT		EQU	$
		HEX	02,01,00,FF,00
SMK0TM		EQU	$
		HEX	06,06,06,03
;
SMOK0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		M8
;
		LDY	EXWRK0,X
		LDA	EXTIM0,X
		BNE	SMK020		;pattern change ? ( no:SMK020 )
;
		DEC	EXWRK0,X
		BMI	SMK040		;end ? ( yes:SMK040 )
;
		DEY
		CPY	#03
		BNE	SMK010		;OAM set type change ? ( no:SMK010 )
;
		LDA	EXMOD2,X
		AND	#1111111111111100B
		STA	EXMOD2,X	;1 chara OAM set type set
SMK010		EQU	$
		LDA	!SMK0TM,Y	;timer set
		STA	EXTIM0,X
SMK020		EQU	$
		LDA	!SMK0PT,Y	;pattern no. set
		STA	EXCHPT,X
		BMI	SMK030		;OAM set ? ( no:SMK030 )
;
		LDA	#006H
SMK030		EQU	$
		STA	EXYUSN,X	;OAM not set
;
SMK040		EQU	$
;
		M16
;
		RTS
;
;************************************************************************
;*		smoke.2 set						*
;************************************************************************
SMOK1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		M8
;
		LDA	EXTIM0,X
		LSR	A
		LSR	A
		LSR	A
		STA	EXCHPT,X
;
		M16
;
		RTS
;
;************************************************************************
;*		player chara change					*
;************************************************************************
CCHG0MV		EQU	$
		DEC	EXTIM0,X
		LDA	EXTIM0,X
		BNE	CHG010		;end ? ( no:CHG010 )
		JMP	EXCLEAR
;
CHG010		EQU	$
		CMP	#03FH
		BCS	CHG020
		DEC	EXTIM0,X
CHG020		EQU	$
;
		M8
;
		LSR	A
		AND	#07H
		STA	EXCHPT,X
;
		M16
;
		RTS
;
;************************************************************************
;*		break BG set						*
;************************************************************************
BRBG0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDY	EXCHPT,X
		LDA	EXTIM0,X
		BNE	BRB020		;pattern change ? ( no:BRB020 )
;
		DEC	EXCHPT,X
		BPL	BRB010		;end ? ( no:BRB010 )
		JMP	EXCLEAR
;
BRB010		EQU	$
		LDA	#02H		;timer set
		STA	EXTIM0,X
BRB020		EQU	$
		RTS
;
;************************************************************************
;*		submarin missile shot smoke				*
;************************************************************************
MSMK0T		EQU	$
		HEX	09,07,06
MSMK0P		EQU	$
		HEX	03,02,01,00
;
MSMK0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		M8
;
		LDY	EXWRK0,X
		LDA	EXTIM0,X
		BNE	MSK010		;pattern change ? ( no:MSK010 )
;
		DEC	EXWRK0,X
		BMI	MSK020		;end ? ( yes:MSK020 )
;
		LDA	!MSMK0T-1,Y	;timer set
		STA	EXTIM0,X
MSK010		EQU	$
		LDA	!MSMK0P,Y	;pattern no. set
		STA	EXCHPT,X
;
MSK020		EQU	$
;
		M16
;
		RTS
;
;************************************************************************
;*		"kirarin" smoke						*
;************************************************************************
KIRA0T		EQU	$
		HEX	06,06,06,06,04,03
;
KIRA0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		M8
;
		LDY	EXCHPT,X
		LDA	EXTIM0,X
		BNE	KIR010		;pattern change ? ( no:KIR010 )
;
		DEY
		BMI	KIR010		;end ? ( yes:KIR010 )
;
		DEC	EXCHPT,X
		LDA	!KIRA0T,Y	;timer set
		STA	EXTIM0,X
KIR010		EQU	$
;
		M16
;
		RTS
;
;************************************************************************
;*		train smoke						*
;************************************************************************
TRSMK0T		EQU	$
		HEX	06,06,05,05
;
TRSMKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		M8
;
		LDY	EXCHPT,X
		LDA	EXTIM0,X
		LSR	A
		BNE	TRS010		;pattern change ? ( no:TRS010 )
;
		DEY
		DEY
		BMI	TRS010		;end ? ( yes:TRS010 )
;
		TYA
		STA	EXCHPT,X
		LDA	!TRSMK0T,Y	;timer set
		STA	EXTIM0,X
TRS010		EQU	$
;
		I16
;
;-------------- move speed set ----------------------------------
		LDA	EXCHPT,X
		LSR	A		;(C) <-- size [ 0:big 1:small ]
		TXY
		LDX	EXWRK0,Y	;(X) <-- angle
		LDA	>COS,X
		STA	211BH
		LDA	>COS+1,X
		STA	211BH
		LDA	#-04H
		BCC	TRS020		;big ? ( yes:TRS020 )
		LDA	#-02H
TRS020		EQU	$
		CLC
		ADC	EXWRK2,Y	;speed change
		STA	EXWRK2,Y
		STA	211CH
;
		M16
;
		LDA	2135H
		ASL	A
		ASL	A
		ASL	A
		STA	EXXSPD,Y
;
		LDA	>SIN,X
;
		M8
;
		STA	211BH
		XBA
		STA	211BH
		LDA	EXWRK2,Y
		STA	211CH
;
		M16
;
		LDA	2135H
		ASL	A
		ASL	A
		ASL	A
		STA	EXYSPD,Y
;
		I8
;
		TYX
		RTS
;
;************************************************************************
;*		yogan "pocha-n" set					*
;************************************************************************
YGUP0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXYSPD,X
		BMI	YGU010
		LDA	#01
		STA	EXCHPT,X
YGU010		EQU	$
		RTS
;
;************************************************************************
;*		"kirarin.2" set						*
;************************************************************************
KIRA1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		LSR	A
		LSR	A
		LSR	A
		STA	EXCHPT,X	;pattern no. set
		RTS
;
;************************************************************************
;*		soap bable set						*
;************************************************************************
SOPB1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		CMP	#08
		BNE	SOPB110		;clear pattern no. set ? ( no:SOPB110 )
;
		INC	EXCHPT,X
SOPB110		EQU	$
		AND	#07H
		BNE	SOPB130		;X pos change ? ( no:SOPB130 )
;
		LDA	RANDM0
		AND	#01H
		BNE	SOPB120
		DEC	A		;[ LDA #0FFFFH ]
SOPB120		EQU	$
		CLC
		ADC	EXXPSL,X
		STA	EXXPSL,X
SOPB130		EQU	$
		RTS
;
;************************************************************************
;*		player ski snow set					*
;************************************************************************
SNOW0PT		EQU	$
		HEX	02,02,02,01,01,01    ;[sking]
SNOW0TM		EQU	$
		HEX	03,03,03,02,02,02    ;[sking]
SKSNOWT		EQU	$
SKSNOW		EQU	SKSNOWT-SNOW0TM
;
SNOW0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SNOW020		;pattern change ? ( no:SNOW020 )
;
		M8
;
		DEC	EXWRK0,X
		BEQ	SNOW010		;end ? ( yes:SNOW010 )
;
		LDY	EXWRK0,X
		LDA	!SNOW0TM-1,Y	;timer set
		STA	EXTIM0,X
		LDA	!SNOW0PT-1,Y
		STA	EXCHPT,X	;pattern no. set
;
SNOW010		EQU	$
;
		M16
;
SNOW020		EQU	$
		RTS
;
;************************************************************************
;*		player yukidaruma break snow set			*
;************************************************************************
SNOW1PT		EQU	$
		HEX	05,04,03,01,01,02,01
SNOW1TM		EQU	$
		HEX	03,03,03,03,03,04,04
;
SNOW1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SNOW110		;pattern change ? ( no:SNOW110 )
;
		DEC	EXWRK0,X
		BMI	SNOW110		;end ? ( yes:SNOW110 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SNOW1PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SNOW1TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SNOW110		EQU	$
		RTS
;
;************************************************************************
;*		yukidaruma crashing set					*
;************************************************************************
SNWBRPT		EQU	$
		HEX	08,07,06,05,04,03,02,01
SNWBRTM		EQU	$
		HEX	40,02,02,02,02,02,02,02
;		HEX	10,10,0E,0C,09,05,05,03
;

SNWBRMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SNWBR10		;pattern change ? ( no:SNWBR10 )
;

		DEC	EXWRK0,X
		BMI	SNWBR10		;end ? ( yes:SNWBR10 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SNWBRPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SNWBRTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SNWBR10		EQU	$
		RTS
;
;
;************************************************************************
;*		fusen crashing set					*
;************************************************************************
FUSNBPT		EQU	$
		HEX	0B,0A,09,08,07,06
		HEX	05,04,03,02,01
FUSNBTM		EQU	$
		HEX	04,04,04,04,04,04
		HEX	03,03,02,02,01
;
FUSNBMV		EQU	$
		LDY	EXWRK2,X
		BEQ	FUSNB00		;GrsnołH ( no:FUSNB00 )
;
		LDA	MOVE_STOP
		BEQ	FUSNB00		;GrsnoH ( no:FUSNB00 )
		DEC	EXTIM0,X
		BPL	FUSNB02
		JMP	EXCLEAR
;
FUSNB00		EQU	$
		JSR	EXMDCK		;mode check
;
FUSNB02		EQU	$
		LDA	EXTIM0,X
		BNE	FUSNB10		;pattern change ? ( no:FUSNB10 )
;
		DEC	EXWRK0,X
		BMI	FUSNB10		;end ? ( yes:FUSNB10 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!FUSNBPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!FUSNBTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
FUSNB10		EQU	$
		RTS
;
;
;************************************************************************
;*		namazu mizu shibuki					*
;************************************************************************
SHIBUPT		EQU	$
		HEX	01
SHIBUTM		EQU	$
		HEX	11
;
SHIBUMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SHIBU10		;pattern change ? ( no:SHIBU10 )
;
		DEC	EXWRK0,X
		BMI	SHIBU10		;end ? ( yes:SHIBU10 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SHIBUPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SHIBUTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SHIBU10		EQU	$
		RTS
;
;
;************************************************************************
;*		namazu suikomi						*
;************************************************************************
BRETHMV		EQU	$
		JSR	EXMDCK		;mode check

		LDY	EXWRK0,X
		LDA	ENXPSL,Y
		STA	<EWORK0
		LDA	ENYPSL,Y
		CLC
		ADC	#00008H
		STA	<EWORK2

		LDA	EXWRK2,X
		STA	<EWORK6

		LDA	EXWRK4,X
		STA	<EWORK4

		LDA	EXXPSL,X
		STA	<EWORK8
		LDA	EXYPSL,X
		STA	<EWORKA

		JSL	>NMZ_HOSEI

		LDA	<EWORK4
		STA	EXWRK4,X
		BPL	BRETHMV010

		EOR	#0FFFFH
		INC	A
		STA	<EWORK4

BRETHMV010	EQU	$
		LDA	<EWORK6
		STA	EXWRK2,X
		BPL	BRETHMV020

		EOR	#0FFFFH
		INC	A

BRETHMV020	EQU	$
		CLC
		ADC	<EWORK4
		CMP	#00030H
		BCS	BRETHMV030

		LDA	#00001H
		STA	EXCHPT,X

BRETHMV030	EQU	$
		LDA	<EWORK8
		STA	EXXPSL,X
		LDA	<EWORKA
		STA	EXYPSL,X

		RTS
;
;
;************************************************************************
;*		soap bowl sparking					*
;************************************************************************
AWASPPT		EQU	$
		HEX	0A,09,08,07,06,05,04,03,02,01
AWASPTM		EQU	$
		HEX	05,05,05,04,04,04,03,03,02,02
;
AWASPMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	AWASP10		;pattern change ? ( no:AWASP10 )
;
		DEC	EXWRK0,X
		BMI	AWASP10		;end ? ( yes:AWASP10 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!AWASPPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!AWASPTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
AWASP10		EQU	$
		RTS
;
;************************************************************************
;*		slime appearance					*
;************************************************************************
SLMAPMV		EQU	$
		JSR	EXMDCK_2	;mode check
		RTS
;
;************************************************************************
;*		move	( тՂ )					*
;************************************************************************
SSLMB_TM	EQU	$
		HEX	06,04,04,03,03
;
SSLMBMV		EQU	$
		JSR	EXMDCK		;mode check

		LDA	EXTIM0,X
		BNE	SSLMBMV0500

		DEC	EXCHPT,X
		BPL	SSLMBMV0100

		JMP	EXCLEAR

SSLMBMV0100	EQU	$
		LDY	EXCHPT,X
		LDA	!SSLMB_TM,Y
		AND	#000FFH
		STA	EXTIM0,X

SSLMBMV0500	EQU	$

		RTS
;
;************************************************************************
;*		? kumo crashing set					*
;************************************************************************
KUMOBPT		EQU	$
		HEX	0B,0A,09,08,07,06,05,04,03,02,01
KUMOBTM		EQU	$
		HEX	06,06,06,06,06,06,06,03,03,03,03
;
KUMOBMV		EQU	$
		LDY	EXWRK2,X
		BEQ	KUMOBMV_010	;GrsnoH ( no:KUMOBMV_010 )
;
		JSR	EX_TIMER
		BRA	KUMOBMV_020
;
KUMOBMV_010	EQU	$
		JSR	EXMDCK		;mode check
;
KUMOBMV_020	EQU	$
		LDA	EXTIM0,X
		BNE	KUMOB_030	;pattern change ? ( no:KUMOB_030 )
;
		DEC	EXWRK0,X
		BMI	KUMOB_030	;end ? ( yes:KUMOB_030 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!KUMOBPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!KUMOBTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
KUMOB_030	EQU	$
		RTS
;
;
;************************************************************************
;*		hodai smoke						*
;************************************************************************
SMK00PT		EQU	$
		HEX	06,05,04,03,02,01
SMK00TM		EQU	$
		HEX	04,08,08,08,04,02
;
SMK00MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SMK0010		;pattern change ? ( no:SMK0010 )
;
		DEC	EXWRK0,X
		BMI	SMK0010		;end ? ( yes:SMK0010 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SMK00PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SMK00TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SMK0010		EQU	$
		RTS
;
;************************************************************************
;*		bubble ex.						*
;************************************************************************
BUBBRPT		EQU	$
		HEX	03,02,01
BUBBRTM		EQU	$
		HEX	06,04,02
;
BUBBRMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	BUBBR10		;pattern change ? ( no:BUBBR10 )
;
		DEC	EXWRK0,X
		BMI	BUBBR10		;end ? ( yes:BUBBR10 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!BUBBRPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!BUBBRTM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
BUBBR10		EQU	$
		RTS
;
;************************************************************************
;*		tuchi smoke						*
;************************************************************************
SMK01PT		EQU	$
		HEX	03,02,01
SMK01TM		EQU	$
		HEX	06,04,02
;
SMK01MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SMK0110		;pattern change ? ( no:SMK0110 )
;
		DEC	EXWRK0,X
		BMI	SMK0110		;end ? ( yes:SMK0110 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SMK01PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SMK01TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SMK0110		EQU	$
		RTS
;
;************************************************************************
;*		4WD smoke						*
;************************************************************************
SMK02PT		EQU	$
		HEX	02,01
SMK02TM		EQU	$
		HEX	0C,08
;
SMK02MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	SMK0210		;pattern change ? ( no:SMK0210 )
;
		DEC	EXWRK0,X
		BMI	SMK0210		;end ? ( yes:SMK0210 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SMK02PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SMK02TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SMK0210		EQU	$
		RTS
;
;************************************************************************
;*		baby magician stick star				*
;************************************************************************
STAR0PT		EQU	$
		HEX	03,02,01
STAR0TM		EQU	$
		HEX	08,08,04
;
STAR0MV		EQU	$
		JSR	EX_XYMOVE

		LDA	EXXMAX,X
		CMP	EXXSPD,X
		BNE	STAR0MV001

		EOR	#0FFFFH
		INC	A
		STA	EXXMAX,X

STAR0MV001	EQU	$
		LDA	EXGMAX,X
		CMP	EXYSPD,X
		BNE	STAR0MV002

		EOR	#0FFFFH
		INC	A
		STA	EXGMAX,X

STAR0MV002	EQU	$
		DEC	EXTIM0,X
		BNE	STAR010		;pattern change ? ( no:STAR010 )
;
		DEC	EXWRK0,X
		BPL	STAR0MV003	;end ? ( no:STAR0MV003 )

		JSR	EXCLEAR

		RTS

STAR0MV003	EQU	$
;
		M8
;
		LDY	EXWRK0,X
		LDA	!STAR0PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!STAR0TM,Y	;timer set
		STA	EXTIM0,X
;
		M16

		CPY	#002
		BMI	STAR010

		LDA	#00080H
		STA	EXYSPD,X
;
STAR010		EQU	$

		RTS
;
;************************************************************************
;*		zoom door smoke						*
;************************************************************************
;*		JbN(KAMC3)̊					*
;************************************************************************
SMK03PT		EQU	$
		HEX	03,02,01
SMK03TM		EQU	$
		HEX	08,08,08
;
SMK03MV		EQU	$
ASE02MV		EQU	$
		JSR	EX_XYMOVE

		JSR	EX_TIMER
;
		LDA	EXTIM0,X
		BNE	SMK0310		;pattern change ? ( no:SMK0310 )
;
		DEC	EXWRK0,X
		BMI	SMK0310		;end ? ( yes:SMK0310 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!SMK03PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!SMK03TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
SMK0310		EQU	$
		RTS
;
;************************************************************************
;*		player 'dosun'						*
;************************************************************************
DOSN0PT		EQU	$
		HEX	0B,0A,09,08,07,06,05,04,03,02,01
DOSN0TM		EQU	$
		HEX	01,01,01,01,01,01,01,01,01,01,02
;
DOSN0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	DOSN010		;pattern change ? ( no:DOSN010 )
;
		DEC	EXWRK0,X
		BMI	DOSN010		;end ? ( yes:DOSN010 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!DOSN0PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!DOSN0TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
DOSN010		EQU	$
		RTS
;
;************************************************************************
;*		player's dust                                           *
;************************************************************************
DUST0PT		EQU	$
		HEX	04,03,02,01
DUST0TM		EQU	$
		HEX	06,06,06,06
;
DUST0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	DUST010		;pattern change ? ( no:DUST010 )
;
		DEC	EXWRK0,X
		BMI	DUST010		;end ? ( yes:DUST010 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!DUST0PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	!DUST0TM,Y	;timer set
		STA	EXTIM0,X
;
		M16
;
DUST010		EQU	$
		RTS
;
;************************************************************************
;*		fundara smoke						*
;************************************************************************
FSMK0TM		EQU	$
		HEX	03,03,03,03,03,03,03
;
FSMK1MV		EQU	$
		LDA	MOVE_STOP
		BEQ	FSMK0MV
;
		JSR	EX_XYMOVE
;
FSMK0MV		EQU	$
		JSR	EX_TIMER
;
		LDA	EXTIM0,X
		BNE	FSMK0MV0800	;pattern change ? ( no:FSMK0MV0800 )
;
		DEC	EXWRK0,X
		BMI	FSMK0MV0800	;end ? ( yes:FSMK0MV0800 )
;
		M8
		LDY	EXWRK0,X
		TYA			;pattern no. set
		STA	EXCHPT,X
		LDA	!FSMK0TM,Y	;timer set
		STA	EXTIM0,X
		M16
;
FSMK0MV0800	EQU	$
		RTS
;
;************************************************************************
;*		baby magician stick star2				*
;************************************************************************
STAR1PT		EQU	$
		HEX	03,02,00,01
;
STAR1_XPOS	EQU	$
		WORD	00008H,0FFFAH,0FFFDH,00001H,00009H
		WORD	0FFF8H,00006H,00003H,0FFFFH,0FFF7H
STAR1_YPOS	EQU	$
		WORD	0FFFEH,00004H,0FFFEH,0FFFCH,0FFFBH
;
;		wrk0 <- 4
;		tim0 <- 4
;		chpt <- 2
;
STAR1MV		EQU	$
		LDY	EXWRK2,X
		LDA	ENMUKI,Y
		STA	<EWORK0
		LDA	ENCHPT,Y
		SEC
		SBC	#0001BH
		ASL	A

		PHY
		TAY
		LDA	<EWORK0
		BEQ	STAR1MV0100

		LDA	!STAR1_XPOS+00AH,Y
		BRA	STAR1MV0200

STAR1MV0100	EQU	$
		LDA	!STAR1_XPOS,Y

STAR1MV0200	EQU	$
		STA	<EWORK0
		LDA	!STAR1_YPOS,Y
		STA	<EWORK2
		PLY

		LDA	ENXPSL,Y
		CLC
		ADC	<EWORK0
		CLC
		ADC	EXWRKA,X
		CMP	EXXPSL,X
		BEQ	STAR1MV0500
		BMI	STAR1MV0400

		INC	EXXPSL,X
		BRA	STAR1MV0500

STAR1MV0400	EQU	$
		DEC	EXXPSL,X

STAR1MV0500	EQU	$
		LDA	ENYPSL,Y
		CLC
		ADC	<EWORK2
		CLC
		ADC	EXWRKC,X
		CMP	EXYPSL,X
		BEQ	STAR1MV0700
		BMI	STAR1MV0600

		INC	EXYPSL,X
		BRA	STAR1MV0700

STAR1MV0600	EQU	$
		DEC	EXYPSL,X

STAR1MV0700	EQU	$
		DEC	EXTIM0,X
		BNE	STAR1MV0900	;pattern change ? ( no:STAR1MV0900 )
;
		DEC	EXWRK0,X
		BPL	STAR1MV0800	;end ? ( no:STAR1MV0800 )

		JSR	EXCLEAR

		RTS

STAR1MV0800	EQU	$
;
		M8
;
		LDY	EXWRK0,X
		LDA	!STAR1PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	#004		;timer set
		STA	EXTIM0,X
;
		M16
;
;;;;;;;;		LDA	EXWRKA,X
;;;;;;;;		BEQ	STAR1MV005
;;;;;;;;		BMI	STAR1MV004
;;;;;;;;
;;;;;;;;		DEC	EXWRKA,X
;;;;;;;;		BRA	STAR1MV005
;;;;;;;;
;;;;;;;;STAR1MV004	EQU	$
;;;;;;;;		INC	EXWRKA,X
;;;;;;;;
;;;;;;;;STAR1MV005	EQU	$
;;;;;;;;		LDA	EXWRKC,X
;;;;;;;;		BEQ	STAR1MV007
;;;;;;;;		BMI	STAR1MV006
;;;;;;;;
;;;;;;;;		DEC	EXWRKC,X
;;;;;;;;		BRA	STAR1MV007
;;;;;;;;
;;;;;;;;STAR1MV006	EQU	$
;;;;;;;;		INC	EXWRKC,X
;;;;;;;;
;;;;;;;;STAR1MV007	EQU	$
		CPY	#002
		BMI	STAR1MV0900

		LDA	#00080H
		STA	EXYSPD,X
;
STAR1MV0900	EQU	$

		RTS
;
;************************************************************************
;*		player's dash smoke                                     *
;************************************************************************
DSMK0PT		EQU	$
		HEX	03,02,01,00,04
;
DSMK0MV		EQU	$
		LDY	EXWRK2,X
		BEQ	DSMK000		;GrsnołH ( no:DSMK000 )
;
		JSR	EX_TIMER
		BRA	DSMK002
;
DSMK000		EQU	$
		JSR	EXMDCK		;mode check
;
DSMK002		EQU	$
		LDA	EXTIM0,X
		BNE	DSMK010		;pattern change ? ( no:DSMK010 )
;
		DEC	EXWRK0,X
		BMI	DSMK010		;end ? ( yes:DSMK010 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!DSMK0PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	#004		;timer set
		STA	EXTIM0,X
;
		M16
;
DSMK010		EQU	$
		RTS
;
;************************************************************************
;*		player's dash smoke                                     *
;************************************************************************
DSMK1PT		EQU	$
		HEX	04,03,02,01
DSMK1MV		EQU	$
		JSR	EXMDCK		;mode check

		LDA	EXTIM0,X
		BNE	DSMK1MV0800	;pattern change ? ( no:DSMK1MV0800 )
;
		DEC	EXWRK0,X
		BMI	DSMK1MV0800	;end ? ( yes:DSMK1MV0800 )
;
		M8
		LDY	EXWRK0,X
		LDA	!DSMK1PT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	#004		;timer set
		STA	EXTIM0,X
		M16
;
DSMK1MV0800	EQU	$
		RTS
;
;************************************************************************
;*		awa break						*
;************************************************************************
AWABRPT		EQU	$
		HEX	09,08,07,06,05,04,03,02,01,00,FF,00,FF
AWABRTM		EQU	$
		HEX	03,03,03,03,03,02,02,02,01,03,01,01,01
;tim0 <- 1
;wrk0 <- 0ch
;wrk2 <- special char no.
AWABRMV		EQU	$
		JSR	EX_TIMER
;
		LDA	EXTIM0,X
		BNE	AWABRMV0800	;pattern change ? ( no:AWABRMV0800 )
;
		DEC	EXWRK0,X
		BMI	AWABRMV0800	;end ? ( yes:AWABRMV0800 )
;
		M8
		LDY	EXWRK0,X
		LDA	!AWABRPT,Y	;pattern no. set
		BPL	AWABRMV0100

		LDA	EXWRK2,X
		BPL	AWABRMV0100

		STA	EXYUSN,X
		BRA	AWABRMV0200

AWABRMV0100	EQU	$
		STA	EXCHPT,X

		LDA	#002
		STA	EXYUSN,X

AWABRMV0200	EQU	$
		LDA	!AWABRTM,Y	;timer set
		STA	EXTIM0,X
		M16
;
AWABRMV0800	EQU	$
		RTS
;
;************************************************************************
;*		ՂՂ̒Ԃ					*
;************************************************************************
PKSB1TM		EQU	$
		HEX	02,04,06,0A,06,04
PKSB1MV		EQU	$
		JSR	EXMDCK			;mode check
;
		LDA	EXTIM0,X
		BNE	PKSB1MV0800		;pattern change ? ( no:PKSB1MV0800 )
;
		DEC	EXCHPT,X
		BPL	PKSB1MV0500		;end ? ( yes:PKSB1MV0500 )
;
		JMP	EXCLEAR

PKSB1MV0500	EQU	$
		LDY	EXCHPT,X
		LDA	!PKSB1TM,Y		;pattern no. set
		AND	#000FFH
		STA	EXTIM0,X
;
PKSB1MV0800	EQU	$
		RTS
;
;************************************************************************
;*		vC[^}S^[Qbg				*
;************************************************************************
NAG_PMV		EQU	$
		LDA	EXOAML,X
		BPL	NAG_PMV_FFD	;n`lZbgnjH ( yes:NAG_PMV_FFD )
		LDA	KOOPA_FG
		BEQ	NAG_PMV_FFC	;NbpH ( no:NAG_PMV_FFC )
;
		LDA	#06H
		STA	EXYUSN,X
NAG_PMV_FFC	EQU	$
		JMP	NAG_PMV_010
;
NAG_PMV_FFD	EQU	$
		LDA	KOOPA_FG
		BEQ	NAG_PMV_FFD2	;NbpH ( no:NAG_PMV_FFD2 )
;
		LDA	EXXPSL,X
		STA	R1		;(R1) <-- wW
		LDA	EXYPSL,X
		STA	R2		;(R2) <-- xW
		LDA	EXWRK4,X
		STA	R3		;(R3) <-- wW
		LDA	EXOAML,X
		STA	R5		;(R5) <-- n`lCfbNX
		LDA	#4
		STA	R7		;(R7) <-- n`l
		PHX			;(X) save
		M_CHIP	KOOPA_3D_OAM
		PLX			;(X) load
;
NAG_PMV_FFD2	EQU	$
;
		I16
;
		TAY			;(Y) <-- n`lCfbNX
;
		LDA	EXWRK2,X
;;;;		    BEQ	    NAG_PMV_000	    ;GT[`[hH ( no:NAG_PMV_000 )
		BNE	NAG_PMV_FFE	;GT[`[hH ( no:NAG_PMV_FFE )
;
		LDA	#010H
		SEC
		SBC	EXWRK0,X
		BPL	NAG_PMV_FFF
NAG_PMV_FFE	EQU	$
		LDA	#0
NAG_PMV_FFF	EQU	$
		STA	<EWORK0		;(EWK0,1) <-- ^[QbgTCY
;
		LDA	SOAM_DX+(8*0),Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*0),Y
		LDA	SOAM_DX+(8*0)+2,Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*0)+2,Y
		LDA	SOAM_DX+(8*1),Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*1),Y
		LDA	SOAM_DX+(8*1)+2,Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*1)+2,Y
		LDA	SOAM_DX+(8*2),Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*2),Y
		LDA	SOAM_DX+(8*2)+2,Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*2)+2,Y
		LDA	SOAM_DX+(8*3),Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*3),Y
		LDA	SOAM_DX+(8*3)+2,Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*3)+2,Y
		BRA	NAG_PMV_002
;
NAG_PMV_000	EQU	$
		LDA	#020H
		SEC
		SBC	EXWRK0,X
		STA	<EWORK0		;(EWK0,1) <-- ^[QbgTCY
;
		LDA	SOAM_DX+(8*0)+2,Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*0)+2,Y
		LDA	SOAM_DX+(8*1),Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*1),Y
		LDA	SOAM_DX+(8*2),Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*2),Y
		LDA	SOAM_DX+(8*3)+2,Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*3)+2,Y
;
NAG_PMV_002	EQU	$
;
		I8
;
NAG_PMV_010	EQU	$
		JSR	EX_TIMER
;
;-------------- ^[QbgTCYZbg ----------------------------------
		LDA	EXWRK0,X
		CLC
;;;;		    ADC	    #2
		ADC	#4
		CMP	#020H
		BCC	NAG_PMV_020
		LDA	#020H
NAG_PMV_020	EQU	$
		STA	EXWRK0,X
		RTS
;
;************************************************************************
;	Z̎							*
;************************************************************************
TANE0MV		EQU	$
;
;************************************************************************
;*	oSĈԂ						*
;************************************************************************
SIBUYMV		EQU	$
;
;************************************************************************
;*	ό`tg̖A							*
;************************************************************************
LFAWAMV		EQU	$
;
;************************************************************************
;*	Ƃ񂪂̊							*
;************************************************************************
KABUTMV		EQU	$
;
;************************************************************************
;*	Ԃ̉							*
;************************************************************************
HANA0MV		EQU	$
;
;************************************************************************
;*	RÊĂĂ						*
;************************************************************************
TEN_2MV		EQU	$
;
;************************************************************************
;*	g̏[U							*
;************************************************************************
HADOUMV		EQU	$
;
;************************************************************************
;*	TAKEUMA								*
;************************************************************************
;*	TATE								*
;************************************************************************
;*	YARI								*
;************************************************************************
;*		J~iWQij				*
;************************************************************************
;*		J~iWQi^}j				*
;************************************************************************
;*		z}[J[					*
;************************************************************************
;*		΂Ƃ̂ႷƂ݁[ƌ				*
;************************************************************************
;*		΂̉Ή						*
;************************************************************************
;*		ǂځ[̊					*
;************************************************************************
;*		J{X̔					*
;************************************************************************
BS0BRMV		EQU	$
GOKOUMV		EQU	$
SBALLMV		EQU	$
TAKEUMV		EQU	$
TATE0MV		EQU	$
YARI0MV		EQU	$
ARROWMV		EQU	$
STAR2MV		EQU	$
PACHIMV		EQU	$
ASE01MV		EQU	$
		JSR	EXMDCK_2
		RTS
;
;************************************************************************
;*		J~iWQiCʂ̔ہj			*
;************************************************************************
SBALSMV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	SBALSMV0500

;;;;;;;;		LDA	#00001
		INC	EXTIM0,X

		DEC	EXCHPT,X
		BMI	SBALSMV0800

SBALSMV0500	EQU	$
		RTS

SBALSMV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*		Ăہ[̂DvC[Ԃ			*
;************************************************************************
;*		Ԃ̓C						*
;************************************************************************
;*		Ԃ						*
;************************************************************************
;*		Ղ񔚔						*
;************************************************************************
;*		ShX̌					*
;************************************************************************
;*		̐ڐG					*
;************************************************************************
;*		}U[pbN̕Ă䂭				*
;************************************************************************
SIBU0MV		EQU	$
YUGE0MV		EQU	$
PICHAMV		EQU	$
PURBRMV		EQU	$
DSMK2MV		EQU	$
KACHBMV		EQU	$
MPKBRMV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	KACHBMV0500

		LDA	#00002
		STA	EXTIM0,X

		DEC	EXCHPT,X
		BMI	KACHBMV0800

KACHBMV0500	EQU	$
		RTS

KACHBMV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*		ՂՂ̏㏸ԂԂ				*
;************************************************************************
;*		Ԃ́hLh				*
;************************************************************************
;*		ق̃oN_̔				*
;************************************************************************
PKSB0MV		EQU	$
FLKIRMV		EQU	$
SMK05MV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	SMK05MV0500

		LDA	#00003
		STA	EXTIM0,X

		DEC	EXCHPT,X
		BMI	SMK05MV0800

SMK05MV0500	EQU	$
		RTS

SMK05MV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*		Ăہ[̂Ԃ̂͂				*
;************************************************************************
;*		ɂɂՂ̂΂͂				*
;************************************************************************
;*		JbN̖@̂				*
;************************************************************************
HANE0MV		EQU	$
SMK04MV		EQU	$
TUBU0MV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	TUBU0MV0500

		LDA	#00004
		STA	EXTIM0,X

		DEC	EXCHPT,X
		BMI	TUBU0MV0800

TUBU0MV0500	EQU	$
		RTS

TUBU0MV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*	t@C[ʁicj̉΂̕					*
;************************************************************************
;*	t@C[ʁij̉΂̕					*
;************************************************************************
FVHIKMV		EQU	$
FHHIKMV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	FVHIKMV0500

		LDA	#00006
		STA	EXTIM0,X

		DEC	EXCHPT,X
		BMI	FVHIKMV0800

FVHIKMV0500	EQU	$
		RTS

FVHIKMV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*		WQ̋l_̂					*
;************************************************************************
KINTSMV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	KINTSMV0500

		LDA	#00008
		STA	EXTIM0,X

		DEC	EXCHPT,X
		BMI	KINTSMV0800

KINTSMV0500	EQU	$
		RTS

KINTSMV0800	EQU	$
		JMP	EXCLEAR
;
;************************************************************************
;*		󔠂̔j						*
;************************************************************************
TRBBR_CHPT	EQU	$
		WORD	00020H,00022H,08020H,04002H,00000H
		WORD	00002H,00020H,00022H,08020H,08002H
;
TRBBR_MUKI	EQU	$
		WORD	00000H,00000H,08000H,04000H,00000H
		WORD	00000H,00000H,00000H,08000H,08000H
;
TRBBRMV		EQU	$
		LDA	EXOAML,X
		BMI	TRBBRMV0050

		LDY	EXWRK2,X
		LDA	!TRBBR_CHPT,Y
		STA	<EWORK0
		LDA	!TRBBR_MUKI,Y
		STA	<EWORK2

		I16
		LDY	EXOAML,X
		LDA	SOAM_DX+4,Y
		ORA	<EWORK0
		EOR	<EWORK2
		CLC
		ADC	EXWRK4,X
		STA	SOAM_DX+4,Y
		I8
;
TRBBRMV0050	EQU	$
		JSR	EXMDCK

		LDA	EXTIM1,X
		BNE	TRBBRMV0800

		LDA	EXWRKA,X
		STA	EXTIM1,X

		LDA	EXWRK2,X
		CLC
		ADC	#00002
		STA	EXWRK2,X
		CMP	#00014H
		BMI	TRBBRMV0800

		STZ	EXWRK2,X

TRBBRMV0800	EQU	$
		RTS
;
;************************************************************************
;*		hLLh					*
;************************************************************************
COLDKPT		EQU	$
		HEX	04,03,02,01,00,00,00
;
COLDKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	COLDK_010	;pattern change ? ( no:COLDK_010 )
;
		DEC	EXWRK0,X
		BMI	COLDK_010	;end ? ( yes:COLDK_010 )
;
		M8
;
		LDY	EXWRK0,X
		LDA	!COLDKPT,Y	;pattern no. set
		STA	EXCHPT,X
		LDA	#04H		;timer set
		STA	EXTIM0,X
;
		M16
;
COLDK_010	EQU	$
		RTS
;
;************************************************************************
;*		XɂȂG̕p^[				*
;************************************************************************
ICECL_TMDT	EQU	$
; EXCHPT -->		 0  1  2  3  4	5  6  7	 8  9  A  B
		HEX	04,04,04,04,04,04,04,03,03,02,02
;
ICECLMV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		PHX			;(X) save
;
		TXA
		AND	#00FFH
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK ICECLC_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#ICECLC_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
;
		PLX			;(X) load
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	ICECLMV_050	;pattern change ? ( no:ICECLMV_050 )
;
		DEC	EXCHPT,X
		BPL	ICECLMV_010	;end ? ( no:ICECLMV_050 )
		JMP	EXCLEAR
;
ICECLMV_010	EQU	$
;
		M8
;
		LDY	EXCHPT,X
		LDA	!ICECLC_NO,Y	;n`lgpZbg
		STA	EXMOD2+1,X
		LDA	!ICECL_TMDT,Y	;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
ICECLMV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
ICECLC_NO	EQU	$
		BYTE	((ICECLC_E-ICECLC_C)/5)<<3
		BYTE	((ICECLC_C-ICECLC_B)/5)<<3
		BYTE	((ICECLC_B-ICECLC_A)/5)<<3
		BYTE	((ICECLC_A-ICECLC_9)/5)<<3
		BYTE	((ICECLC_9-ICECLC_8)/5)<<3
		BYTE	((ICECLC_8-ICECLC_7)/5)<<3
		BYTE	((ICECLC_7-ICECLC_6)/5)<<3
		BYTE	((ICECLC_6-ICECLC_5)/5)<<3
		BYTE	((ICECLC_5-ICECLC_4)/5)<<3
		BYTE	((ICECLC_4-ICECLC_3)/5)<<3
		BYTE	((ICECLC_3-ICECLC_2)/5)<<3
;;;;		    BYTE    ((ICECLC_2-ICECLC_1)/5)<<3
ICECLC_ADRS	EQU	$
		WORD	ICECLC_C
		WORD	ICECLC_B
		WORD	ICECLC_A
		WORD	ICECLC_9
		WORD	ICECLC_8
		WORD	ICECLC_7
		WORD	ICECLC_6
		WORD	ICECLC_5
		WORD	ICECLC_4
		WORD	ICECLC_3
		WORD	ICECLC_2
		WORD	ICECLC_1
;
ICECLC_1	BYTE	008H,008H	;[01]
		HEX	6A,C6,02
		BYTE	0F8H,008H
		HEX	6A,86,02
		BYTE	008H,0F8H
		HEX	6A,46,02
		BYTE	0F8H,0F8H
		HEX	6A,06,02
;
ICECLC_2	BYTE	004H,0FCH	;[02]
		HEX	45,06,00
		BYTE	000H,008H
		HEX	55,06,00
		BYTE	004H,004H
		HEX	42,C2,02
		BYTE	0FCH,004H
		HEX	42,82,02
		BYTE	004H,0FCH
		HEX	42,42,02
		BYTE	0FCH,0FCH
		HEX	42,02,02
		BYTE	00FH,00DH
		HEX	4C,06,00
		BYTE	000H,00FH
		HEX	4C,46,00
		BYTE	0F7H,006H
		HEX	4C,06,00
		BYTE	012H,003H
		HEX	4C,46,00
		BYTE	009H,0F9H
		HEX	4C,46,00
		BYTE	0FEH,0FBH
		HEX	4C,46,00
		BYTE	004H,006H
		HEX	4C,06,00
;
ICECLC_3	BYTE	004H,0FCH	;[03]
		HEX	54,06,00
		BYTE	010H,010H
		HEX	55,06,00
		BYTE	000H,008H
		HEX	45,06,00
		BYTE	000H,008H
		HEX	55,06,00
		BYTE	010H,012H
		HEX	4C,06,00
		BYTE	0FFH,014H
		HEX	4C,46,00
		BYTE	0F6H,009H
		HEX	4C,06,00
		BYTE	013H,006H
		HEX	4C,46,00
		BYTE	00AH,0FCH
		HEX	4C,46,00
		BYTE	0FDH,0FEH
		HEX	4C,46,00
		BYTE	004H,009H
		HEX	4C,06,00
;
ICECLC_4	BYTE	004H,0FCH	;[04]
		HEX	44,06,00
		BYTE	0F8H,010H
		HEX	55,06,00
		BYTE	000H,008H
		HEX	54,06,00
		BYTE	010H,010H
		HEX	45,06,00
		BYTE	011H,016H
		HEX	4C,06,00
		BYTE	0FEH,018H
		HEX	4C,46,00
		BYTE	0F5H,00DH
		HEX	4C,06,00
		BYTE	014H,00AH
		HEX	4C,46,00
		BYTE	00BH,000H
		HEX	4C,06,00
		BYTE	0FCH,002H
		HEX	4C,46,00
		BYTE	004H,00DH
		HEX	4C,06,00
;
ICECLC_5	BYTE	000H,018H	;[05]
		HEX	55,06,00
		BYTE	000H,008H
		HEX	44,06,00
		BYTE	010H,010H
		HEX	54,06,00
		BYTE	0F8H,010H
		HEX	45,06,00
		BYTE	012H,01AH
		HEX	4C,06,00
		BYTE	0FDH,01CH
		HEX	4D,46,00
		BYTE	0F5H,011H
		HEX	4C,06,00
		BYTE	015H,00EH
		HEX	4D,46,00
		BYTE	00CH,004H
		HEX	4D,06,00
		BYTE	0FBH,006H
		HEX	4D,46,00
		BYTE	004H,011H
		HEX	4C,06,00
;
ICECLC_6	BYTE	008H,008H	;[06]
		HEX	55,06,00
		BYTE	010H,010H
		HEX	44,06,00
		BYTE	0F8H,010H
		HEX	54,06,00
		BYTE	000H,018H
		HEX	45,06,00
		BYTE	012H,01EH
		HEX	4D,06,00
		BYTE	0FDH,020H
		HEX	4E,46,00
		BYTE	0F4H,015H
		HEX	4D,06,00
		BYTE	015H,012H
		HEX	4E,46,00
		BYTE	00CH,008H
		HEX	4E,06,00
		BYTE	0FBH,00AH
		HEX	4E,46,00
		BYTE	004H,015H
		HEX	4C,06,00
;
ICECLC_7	BYTE	010H,020H	;[07]
		HEX	55,06,00
		BYTE	0F8H,010H
		HEX	44,06,00
		BYTE	000H,018H
		HEX	54,06,00
		BYTE	008H,008H
		HEX	45,06,00
		BYTE	012H,023H
		HEX	4E,46,00
		BYTE	0FDH,025H
		HEX	4F,46,00
		BYTE	0F4H,01AH
		HEX	4E,06,00
		BYTE	015H,017H
		HEX	4F,46,00
		BYTE	00CH,00DH
		HEX	4F,06,00
		BYTE	0FBH,00FH
		HEX	4F,46,00
		BYTE	004H,01AH
		HEX	4D,06,00
;
ICECLC_8	BYTE	012H,027H	;[08]
		HEX	4F,46,00
		BYTE	0F4H,01FH
		HEX	4F,06,00
		BYTE	004H,01FH
		HEX	4E,06,00
		BYTE	0FCH,028H
		HEX	55,06,00
		BYTE	000H,018H
		HEX	44,06,00
		BYTE	008H,008H
		HEX	54,06,00
		BYTE	010H,020H
		HEX	45,06,00
;
ICECLC_9	BYTE	004H,024H	;[09]
		HEX	4F,06,00
		BYTE	008H,030H
		HEX	55,06,00
		BYTE	0FCH,028H
		HEX	45,06,00
		BYTE	010H,020H
		HEX	54,06,00
		BYTE	008H,008H
		HEX	44,06,00
;
ICECLC_A	BYTE	008H,030H	;[0A]
		HEX	45,06,00
		BYTE	0FCH,028H
		HEX	54,06,00
		BYTE	010H,020H
		HEX	44,06,00
;
ICECLC_B	BYTE	008H,030H	;[0B]
		HEX	54,06,00
		BYTE	0FCH,028H
		HEX	44,06,00
;
ICECLC_C	BYTE	008H,030H	;[0C]
		HEX	44,06,00
;
ICECLC_E	EQU	$
;
;
;************************************************************************
;*	Mitsan Catch Smoke						*
;*		EXWRK0 <- 0002H						*
;*		EXWRK2 <- 0005H						*
;*		EXTIM0 <- 0002H						*
;************************************************************************
MSNSKMV		EQU	$
;
;************************************************************************
;*	Mucho 2 Breath							*
;*		EXWRK0 <- 0006H						*
;*		EXWRK2 <- 0002H						*
;*		EXTIM0 <- 0006H						*
;************************************************************************
MC2S0MV		EQU	$
;
;************************************************************************
;*	Mucho 2 Smoke							*
;*		EXWRK0 <- 0002H						*
;*		EXWRK2 <- 0005H						*
;*		EXTIM0 <- 0002H						*
;************************************************************************
MC2S1MV		EQU	$
		JSR	EXMDCK		;mode check
;
MC2S0000	EQU	$
		LDA	!EXTIM0,X
		BNE	MC2S0100	; pattern change ? [no->MC2S0100]
;
		DEC	!EXWRK2,X
		BMI	MC2S0100	; end ? [yes->MC2S0100]
;
		INC	!EXCHPT,X
		LDA	!EXWRK0,X
		STA	!EXTIM0,X
MC2S0100	EQU	$
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_SM0MV ( ~jQ[@[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SMXHAND		EQU	$
		WORD	0000BH*4,0000FH*4,00014H*4,00019H*4,0001AH*4
;
SMYHAND		EQU	$
		WORD	00003H*4,00003H*4,00005H*4,00006H*4,00007H*4
;
SMTIMED		EQU	$
		WORD	00004H,00004H,00004H,00005H,00006H
;
SMPATND		EQU	$
		WORD	00000H,00001H,00002H,00001H,00003H
;
;
M_SM0MV		EQU	$
		PHX			; CfbNXޔ
		LDA	EXWRKA,X
		STA	R1		; waZbg
		LDA	EXWRKC,X
		STA	R2		; xaZbg
		LDA	EXOAML,X
		STA	R3		; n`lAhXZbg
		LDA	EXWRK4,X
		STA	R4		; CgpxZbg
		LDA	EXXPSL,X
		STA	R5		; wWZbg
		LDA	EXYPSL,X
		STA	R6		; xWZbg
;
		M_CHIP	M_SM0SET
;
		PLX
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM1,X
		BNE	M_SM0MV_100	; p^[`FW@H
;					; Yes !!
		INC	EXWRK0,X
		LDA	EXWRK0,X
		ASL	A
		TAY
		CPY	#SMYHAND-SMXHAND
		BNE	M_SM0MV_050	; p^[`FWI@H
;					; Yes !!
		LDA	#00000
		BRA	M_SM0MV_100
;
M_SM0MV_050	EQU	$
		LDA	!SMXHAND,Y
		STA	EXWRKA,X	; waZbg
		LDA	!SMYHAND,Y
		STA	EXWRKC,X	; xaZbg
		LDA	!SMTIMED,Y
		STA	EXTIM1,X	; p^[`FW^C}[Zbg
		LDA	!SMPATND,Y
		STA	EXCHPT,X	; p^[mDZbg
		LDA	#00003H
;
M_SM0MV_100	EQU	$
		STA	EXTIM0,X
		RTS
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
;
;########################################################################
;# (LABEL)	M_ATAMV		(蕶ړ)			#
;########################################################################
M_ATAMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
;
		LDA	!EXGPOW,X
		BEQ	M_ATAMV_800
;
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_ATAMV_500
;
		LDA	#3
		STA	!EXWRK0,X
		INC	!EXWRK2,X
		LDA	!EXWRK2,X
		CMP	#0006H
		BCC	M_ATAMV_500
		STZ	!EXWRK2,X
M_ATAMV_500
		LDA	!EXWRK2,X
		ASL	A
		TAY
		LDA	M_ATAMV_CHDT,Y
		STA	!EXCHPT,X
;
		LDA	!EXYSPD,X
		BMI	M_ATAMV_800
		STZ	!EXYSPD,X
		STZ	!EXGPOW,X
		LDA	#0003H
		STA	!EXCHPT,X
		LDA	#M_ATK
		JSL	>EXINSR
		LDA	!EXXPSL,X
		CLC
		ADC	#0FFCCH
		STA	!EXXPSL,Y
		LDA	!EXYPSL,X
		CLC
		ADC	#0FFD4H
		STA	!EXYPSL,Y
		PHX
		TYX
		JSL	>M_ATKIN
		PLX
M_ATAMV_800
;
		RTS
;
M_ATAMV_CHDT	EQU	$
		WORD	0000H,0001H,0002H,0003H,0002H,0001H
;
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/19] *****************
;
;########################################################################
;# (LABEL)	M_ATAMV		(蕶ړ)			#
;########################################################################
M_ATAMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#1
		STA	!EXTIM0,X
;
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_ATAMV_500
;
		LDA	#1
		STA	!EXWRK0,X
		INC	!EXWRK2,X
		LDA	!EXWRK2,X
		CMP	#000FH
		BCC	M_ATAMV_500
		LDA	#0EH
		STA	!EXWRK2,X
		LDA	!EXYUSN,X
		AND	#00FFH
		CMP	#00FFH
		BEQ	M_ATAMV_500
;
		PHX
		PHY
		JSR	M_ATAMV_700
		PLY
		PLX
		LDA	#0FFH
		STA	!EXYUSN,X
M_ATAMV_500
		LDA	!EXWRK2,X
		ASL	A
		TAY
		LDA	M_ATAMV_CHDT,Y
		STA	!EXCHPT,X
;
		RTS
;
M_ATAMV_700
		LDA	#M_ATK
		JSL	>EXINSR
		LDA	!EXXPSL,X
		STA	!EXXPSL,Y
		LDA	!EXYPSL,X
		STA	!EXYPSL,Y
		PHX
		TYX
		JSL	>M_ATKIN
		PLX
M_ATAMV_800
;
		RTS
;
M_ATAMV_CHDT	EQU	$
		WORD	0000H,0001H,0002H,0003H,0004H,0005H,0006H,0007H
		WORD	0008H,0009H,000AH,000BH,000CH,000EH,000DH
;
 ENDIF	  ;**** NES or PAL Ή [1995/7/19] **********************
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/07/27] *****************************
;
;########################################################################
;# (LABEL)	MHAZMV		(nYړ)			#
;########################################################################
M_HAZMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
;
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_HAZMV_500
		LDY	!EXWRK2,X
		LDA	M_HAZMV_FRDT,Y
		AND	#00FFH
		STA	!EXWRK0,X
		INC	!EXWRK2,X
M_HAZMV_500
		LDA	!EXWRK2,X
		AND	#00000011B
		ASL	A
		TAY
		LDA	M_HAZMV_CHDT,Y
		STA	!EXCHPT,X
;
		LDA	!EXYSPD,X
		BMI	M_HAZMV_800
		CMP	#0280H
		BCC	M_HAZMV_700
		LDA	#0
		STA	!EXTIM0,X
		RTS
M_HAZMV_700
		LDA	!EXWRK4,X
		BNE	M_HAZMV_800
		INC	!EXWRK4,X
		LDA	#M_HZK
		JSL	>EXINSR
		LDA	!EXXPSL,X
		CLC
		ADC	#0FFD8H
		STA	!EXXPSL,Y
		LDA	!EXYPSL,X
		CLC
		ADC	#0000H
		STA	!EXYPSL,Y
		LDA	#3
		STA	!EXTIM0,Y
		PHX
		TYX
		JSL	>M_HZKIN
		PLX
M_HAZMV_800
;
		RTS
;
M_HAZMV_CHDT	EQU	$
		WORD	0000H,0001H,0002H,0001H
M_HAZMV_FRDT	EQU	$
		HEX	02,03,03,03,03,20,03,03,03
;
 ELSE
;
;########################################################################
;# (LABEL)	M_HAZMV		(nYړ)			#
;########################################################################
M_HAZMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
;
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_HAZMV_500
		LDY	!EXWRK2,X
		LDA	M_HAZMV_FRDT,Y
		AND	#00FFH
		STA	!EXWRK0,X
		INC	!EXWRK2,X
M_HAZMV_500
		LDA	!EXWRK2,X
		AND	#00000011B
		ASL	A
		TAY
		LDA	M_HAZMV_CHDT,Y
		STA	!EXCHPT,X
;
		LDA	!EXYSPD,X
		BMI	M_HAZMV_800
		CMP	#0280H
		BCC	M_HAZMV_700
		LDA	#0
		STA	!EXTIM0,X
		RTS
M_HAZMV_700
		LDA	!EXWRK4,X
		BNE	M_HAZMV_800
		INC	!EXWRK4,X
		LDA	#M_HZK
		JSL	>EXINSR
		LDA	!EXXPSL,X
		CLC
		ADC	#0FFD8H
		STA	!EXXPSL,Y
		LDA	!EXYPSL,X
		CLC
		ADC	#0FFE8H
		STA	!EXYPSL,Y
		LDA	#3
		STA	!EXTIM0,Y
		PHX
		TYX
		JSL	>M_HZKIN
		PLX
M_HAZMV_800
;
		RTS
;
M_HAZMV_CHDT	EQU	$
		WORD	0000H,0001H,0002H,0001H
M_HAZMV_FRDT	EQU	$
		HEX	02,03,03,03,03,20,03,03,03
;
 ENDIF	  ;**** NES or PAL Ή [1995/07/27] *****************************
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/07/27] *****************************
;
;########################################################################
;# (LABEL)	M_ATKMV		(ʈړ)			#
;########################################################################
M_ATKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
		PHX
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_ATKMV_500
		LDA	!EXWRK2,X
		AND	#00000001B
		CLC
		ADC	#0
		STA	!EXWRK0,X
		INC	!EXWRK2,X
		LDA	!EXWRK2,X
		CMP	#0CH
		BCC	M_ATKMV_500
		LDA	#4
		STA	!EXWRK2,X
M_ATKMV_500
		LDA	!EXWRK2,X
		STA	!EXCHPT,X
		LDA	!EXTIM1,X
		BNE	M_ATKMV_700
		PHD
		LDA	#BANK WORK
		PHA
		PLD
		JSL	>MHDPLY_JSL
		M16
		PLD
M_ATKMV_700
		PLX
;
 IF BUG00	;;; Tue Aug  8 12:08:05 JST 1995
		STX	!EXSTCT
 ENDIF
;
		RTS
;
 ELSE
;
;########################################################################
;# (LABEL)	M_ATKMV		(ʈړ)			#
;########################################################################
M_ATKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
		PHX
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_ATKMV_500
		LDA	#3
		STA	!EXWRK0,X
		INC	!EXWRK2,X
		LDA	!EXWRK2,X
		CMP	#8
		BCC	M_ATKMV_500
		LDA	#5
		STA	!EXWRK2,X
M_ATKMV_500
		LDA	!EXWRK2,X
		STA	!EXCHPT,X
		LDA	!EXTIM1,X
		BNE	M_ATKMV_700
		PHD
		LDA	#BANK WORK
		PHA
		PLD
		JSL	>MHDPLY_JSL
		M16
		PLD
M_ATKMV_700
		PLX
;
 IF BUG00	;;; Tue Aug  8 12:08:05 JST 1995
		STX	!EXSTCT
 ENDIF
;
		RTS
;
 ENDIF	  ;**** NES or PAL Ή [1995/07/27] *****************************
;
;########################################################################
;# (LABEL)	M_HZKMV		(nYʈړ)			#
;########################################################################
M_HZKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	#2
		STA	!EXTIM0,X
;
		DEC	!EXWRK0,X
		LDA	!EXWRK0,X
		BPL	M_HZKMV_500
		LDA	#3
		STA	!EXWRK0,X
		INC	!EXWRK2,X
		LDA	!EXWRK2,X
		CMP	#8
		BCC	M_HZKMV_500
		LDA	#0
		STA	!EXTIM0,X
		RTS
M_HZKMV_500
		LDA	!EXWRK2,X
		STA	!EXCHPT,X
;
		RTS
;
;
;########################################################################
;# (LABEL)	M_ATKIN		(ʃCjV)			#
;########################################################################
M_ATKIN		EQU	$
		LDA	#2
		STA	!EXTIM0,X
		LDA	#3
		STA	!EXWRK0,X
		STZ	!EXWRK2,X
		STZ	!EXGPOW,X
		LDA	#0000H
		STA	!EXYUSN,X
		LDA	#040H
		STA	!EXTIM1,X
		LDA	#08H
		JSL	>SOUND_3_ON
;
 IF BUG00	;;; Tue Aug  8 12:08:05 JST 1995
		STX	!EXSTCT
 ENDIF		;;; Tue Aug  8 12:08:05 JST 1995
;
		RTL
;
;########################################################################
;# (LABEL)	M_HZKIN		(nYʃCjV)			#
;########################################################################
M_HZKIN		EQU	$
		LDA	#3
		STA	!EXTIM0,X
		STZ	!EXWRK2,X
		STZ	!EXGPOW,X
		LDA	#0000H
		STA	!EXYUSN,X
		LDA	#3FH
		JSL	>SOUND_3_ON
;
		RTL
;
;************************************************************************
;*		ف[ǂ̂͂					*
;************************************************************************
AHANE_XSPD	EQU	$
		WORD	00040H,0FFC0H
;
BHANEMV		EQU	$
AHANEMV		EQU	$
		JSR	EX_TIMER
;
		LDA	EXTIM1,X
		BNE	AHANEMV0100

		JMP	EXCLEAR

AHANEMV0100	EQU	$
		CMP	#00040H*1		;tbVO ?
		BPL	AHANEMV0600		;  no: AHANEMV0600

		LDY	#0FFH
		AND	#00001
		BEQ	AHANEMV0300

		LDY	#001

AHANEMV0300	EQU	$
		TYA
		STA	EXYUSN,X

AHANEMV0600	EQU	$
		LDA	EXTIM1,X
		AND	#0003FH
		BNE	AHANEMV0800

		LDA	EXMUKI,X
		EOR	#00002
		STA	EXMUKI,X
		TAY
		LDA	!AHANE_XSPD,Y
		STA	EXXSPD,X

AHANEMV0800	EQU	$

		RTS
;
;************************************************************************
;*	ˉ_̖							*
;************************************************************************
REFAWMV		EQU	$
		JSR	EXMDCK			; mode check
;
		LDY	!EXYUSN,X
		CPY	#0FFH
		BNE	RFAWMV0040		; \ ? [yes->RFAWMV0040]
;
		LDA	#00001H
		STA	!EXYUSN,X
		BRA	RFAWMV00F0
;
RFAWMV0040	EQU	$
		LDA	!EXWRK4,X
		CLC
		ADC	!EXWRK2,X
		STA	!EXWRK4,X
		BIT	#0FF00H
		BEQ	RFAWMV0050		; [->RFAWMV0050]
;
		AND	#000FFH
		STA	!EXWRK4,X
		LDA	#000FFH
		STA	!EXYUSN,X
RFAWMV0050	EQU	$
		LDA	!EXWRK2,X
		CLC
		ADC	#00004H
		CMP	#00100H
		BMI	RFAWMV0060		; max over ? [no->RFAWMV0060]
;
		LDA	#00100H
RFAWMV0060	EQU	$
		STA	!EXWRK2,X
RFAWMV00F0	EQU	$
		RTS
;
;************************************************************************
;*		ՂՂ̒Ԃ					*
;************************************************************************
MIZU0TM		EQU	$
		HEX	0C,10
;
YOGN0MV		EQU	$
;
MIZU0MV		EQU	$
		JSR	EXMDCK			;mode check
;
		LDA	EXTIM0,X
		BNE	MIZU0MV0800		;pattern change ? ( no:MIZU0MV0800 )
;
		DEC	EXCHPT,X
		BPL	MIZU0MV0500		;end ? ( yes:MIZU0MV0500 )
;
		JMP	EXCLEAR

MIZU0MV0500	EQU	$
		LDY	EXCHPT,X
		LDA	!MIZU0TM,Y		;pattern no. set
		AND	#000FFH
		STA	EXTIM0,X
;
MIZU0MV0800	EQU	$
		RTS
;
;************************************************************************
;*		^}SGɓ̌				*
;************************************************************************
FSMK2TM		EQU	$
		HEX	03,03,03,03,03,03,03,03 ;[0]
		HEX	03,02,02,02,02,02,02,02 ;[8]
		HEX	02,02,02,02,02,02	;[10]
FSMK2TM_E	EQU	$
FSMK2P		EQU	FSMK2TM_E-FSMK2TM
;
FSMK2MV		EQU	$
		JSR	EXMDCK			; mode check
;
		M8
;
		LDA	EXTIM0,X
		BEQ	FSMK2MV_0010	;pattern change ? ( no:FSMK2MV_0010 )
;
		LDY	EXCHPT,X
		CPY	#FSMK2P
		BNE	FSMK2MV_0030	;\`FbNp^[H ( no:FSMK2MV_0030 )
;
		CMP	#02H
		BCS	FSMK2MV_0030	;\H ( no:FSMK2MV_0030 )
;
		LDA	#0FFH		;(A) <-- naiD揇
		BRA	FSMK2MV_0040
;
FSMK2MV_0010	EQU	$
		DEC	EXCHPT,X
		BPL	FSMK2MV_0020	;end ? ( yes:FSMK2MV_0020 )
;
		M16
;
		JMP	EXCLEAR
;
		MEM8
;
FSMK2MV_0020	EQU	$
		LDY	EXCHPT,X
		LDA	!FSMK2TM,Y	;timer set
		STA	EXTIM0,X
;
FSMK2MV_0030	EQU	$
		LDA	#05H		;(A) <-- naiD揇
FSMK2MV_0040	EQU	$
		STA	EXYUSN,X
;
		M16
;
		RTS
;
;************************************************************************
;*		҂҂悷[i[ނڂĂ̋Cp^[j		*
;************************************************************************
PIYOSMV		EQU	$
		JSR	EXMDCK
;
		LDA	EXTIM0,X
		BNE	PIYOSMV0100
		JMP	EXCLEAR

PIYOSMV0100	EQU	$
		LDA	EXTIM1,X
		BNE	PIYOSMV0500

		LDA	#00004
		STA	EXTIM1,X

		DEC	EXCHPT,X
		BPL	PIYOSMV0500

		LDA	#00005
		STA	EXCHPT,X

PIYOSMV0500	EQU	$

		RTS
;
;
;************************************************************************
;*	CevC[ɓƂ̉				*
;************************************************************************
EBSMK_TIME	EQU	$
		HEX	08, 06, 04, 02, 02
;
EBSMKMV		EQU	$
		JSR	EXMDCK
;
		LDA	!EXTIM0,X
		BNE	EBSMKMV00F0		; pattern change ? [no->EBSMKMV00F0]
;
		DEC	!EXWRK0,X
		BPL	EBSMKMV0040		; ʏI ? [no->EBSMKMV0040]
;
		JMP	EXCLEAR
;
EBSMKMV0040	EQU	$
;
		M8				; memory 8bit mode !!
;
		DEC	!EXCHPT,X
		LDY	!EXWRK0,X
		LDA	EBSMK_TIME,Y
		STA	!EXTIM0,X
;
		M16				; memory 16bit mode !!
;
		LDA	#1
		CPY	#03
		BNE	EBSMKMV0080		; [->EBSMKMV0080]
;
		LDA	#-1
EBSMKMV0080	EQU	$
		STA	!EXYUSN,X
EBSMKMV00F0	EQU	$
		RTS
;
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;K;;;;;x		l`opiԂj					x
;;;;K;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;K;;;;MP_SBMV		EQU	$
;;;;K;;;;		LDY	#000
;;;;K;;;;		LDA	EXTIM0,X
;;;;K;;;;		AND	#00008
;;;;K;;;;		BNE	MP_SBMV_050
;;;;K;;;;;
;;;;K;;;;		INY
;;;;K;;;;;
;;;;K;;;;MP_SBMV_050	EQU	$
;;;;K;;;;		TYA
;;;;K;;;;		STA	EXCHPT,X
;;;;K;;;;		RTS
;
;************************************************************************
;*		gQubN̕p^[				*
;************************************************************************
BRTOG_TMDT	EQU	$
; EXCHPT -->		 0  1  2  3  4	5  6  7	 8  9  A  B  C
		HEX	03,03,03,03,03,03,03,02,02,02,02,02
;
BRTOGMV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		PHX			;(X) save
;
		TXA
		AND	#00FFH
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK BRTOGC_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#BRTOGC_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
;
		PLX			;(X) load
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	BRTOGMV_050	;pattern change ? ( no:BRTOGMV_050 )
;
		DEC	EXCHPT,X
		BPL	BRTOGMV_010	;end ? ( no:BRTOGMV_050 )
		JMP	EXCLEAR
;
BRTOGMV_010	EQU	$
;
		M8
;
		LDY	EXCHPT,X
		LDA	!BRTOGC_NO,Y	;n`lgpZbg
		STA	EXMOD2+1,X
		LDA	!BRTOG_TMDT,Y	;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
BRTOGMV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
BRTOGC_NO	EQU	$
		BYTE	((BRTOGC_EN-BRTOGC_F)/5)<<3
		BYTE	((BRTOGC_F-BRTOGC_E)/5)<<3
		BYTE	((BRTOGC_E-BRTOGC_D)/5)<<3
		BYTE	((BRTOGC_D-BRTOGC_C)/5)<<3
		BYTE	((BRTOGC_C-BRTOGC_B)/5)<<3
		BYTE	((BRTOGC_B-BRTOGC_A)/5)<<3
		BYTE	((BRTOGC_A-BRTOGC_9)/5)<<3
		BYTE	((BRTOGC_9-BRTOGC_8)/5)<<3
		BYTE	((BRTOGC_8-BRTOGC_7)/5)<<3
		BYTE	((BRTOGC_7-BRTOGC_6)/5)<<3
		BYTE	((BRTOGC_6-BRTOGC_5)/5)<<3
		BYTE	((BRTOGC_5-BRTOGC_4)/5)<<3
;;;;		    BYTE    ((BRTOGC_4-BRTOGC_3)/5)<<3
BRTOGC_ADRS	EQU	$
		WORD	BRTOGC_F
		WORD	BRTOGC_E
		WORD	BRTOGC_D
		WORD	BRTOGC_C
		WORD	BRTOGC_B
		WORD	BRTOGC_A
		WORD	BRTOGC_9
		WORD	BRTOGC_8
		WORD	BRTOGC_7
		WORD	BRTOGC_6
		WORD	BRTOGC_5
		WORD	BRTOGC_4
		WORD	BRTOGC_3
;
BRTOGC_3	BYTE	003H,0FEH	;[03]
		HEX	55,06,00
		BYTE	009H,00BH
		HEX	4C,04,00
		BYTE	009H,000H
		HEX	4C,04,00
		BYTE	0FFH,001H
		HEX	4C,04,00
		BYTE	005H,007H
		HEX	4C,04,00
		BYTE	00EH,007H
		HEX	4C,04,00
		BYTE	000H,00BH
		HEX	4C,04,00
		BYTE	0FEH,006H
		HEX	4C,04,00
		BYTE	004H,0FDH
		HEX	4D,04,00
;
BRTOGC_4	BYTE	003H,0FEH	;[04]
		HEX	55,06,00
		BYTE	00AH,00DH
		HEX	4C,04,00
		BYTE	00AH,0FDH
		HEX	4C,04,00
		BYTE	0FEH,0FEH
		HEX	4C,04,00
		BYTE	005H,008H
		HEX	4C,04,00
		BYTE	010H,006H
		HEX	4C,04,00
		BYTE	0FFH,00CH
		HEX	4D,84,00
		BYTE	0FCH,007H
		HEX	4C,04,00
		BYTE	004H,0FEH
		HEX	4D,04,00
;
BRTOGC_5	BYTE	00CH,002H	;[05]
		HEX	55,06,00
		BYTE	003H,0FEH
		HEX	45,06,00
		BYTE	00AH,00FH
		HEX	4C,04,00
		BYTE	009H,0FBH
		HEX	4D,44,00
		BYTE	0FDH,0FDH
		HEX	4C,04,00
		BYTE	005H,009H
		HEX	4C,04,00
		BYTE	012H,006H
		HEX	4D,04,00
		BYTE	0FEH,00DH
		HEX	4E,84,00
		BYTE	0FAH,008H
		HEX	4C,04,00
		BYTE	004H,0FFH
		HEX	4D,04,00
;
BRTOGC_6	BYTE	00CH,002H	;[06]
		HEX	55,06,00
		BYTE	003H,0FEH
		HEX	54,06,00
		BYTE	00BH,012H
		HEX	4D,44,00
		BYTE	00BH,0FAH
		HEX	4D,44,00
		BYTE	0FDH,0FDH
		HEX	4C,04,00
		BYTE	005H,00BH
		HEX	4C,04,00
		BYTE	013H,006H
		HEX	4D,04,00
		BYTE	0FEH,00FH
		HEX	4E,84,00
		BYTE	0FAH,00AH
		HEX	4D,04,00
		BYTE	004H,001H
		HEX	4E,04,00
;
BRTOGC_7	BYTE	0FCH,008H	;[07]
		HEX	55,06,00
		BYTE	00CH,002H
		HEX	45,06,00
		BYTE	003H,0FEH
		HEX	44,06,00
		BYTE	00CH,015H
		HEX	4D,44,00
		BYTE	00CH,0FAH
		HEX	4D,44,00
		BYTE	0FCH,0FEH
		HEX	4C,04,00
		BYTE	005H,00DH
		HEX	4C,04,00
		BYTE	014H,007H
		HEX	4D,04,00
		BYTE	0FDH,011H
		HEX	4F,84,00
		BYTE	0F9H,00CH
		HEX	4D,04,00
		BYTE	004H,003H
		HEX	4E,04,00
;
BRTOGC_8	BYTE	0FCH,008H	;[08]
		HEX	55,06,00
		BYTE	00CH,002H
		HEX	54,06,00
		BYTE	00CH,019H
		HEX	4E,44,00
		BYTE	00CH,0FBH
		HEX	4E,44,00
		BYTE	0FCH,0FFH
		HEX	4D,44,00
		BYTE	005H,010H
		HEX	4D,44,00
		BYTE	015H,008H
		HEX	4D,04,00
		BYTE	0FDH,014H
		HEX	4F,84,00
		BYTE	0F9H,00FH
		HEX	4D,04,00
		BYTE	004H,006H
		HEX	4E,04,00
;
BRTOGC_9	BYTE	007H,016H	;[09]
		HEX	55,06,00
		BYTE	0FCH,008H
		HEX	55,06,00
		BYTE	00CH,002H
		HEX	44,06,00
		BYTE	00DH,01DH
		HEX	4E,44,00
		BYTE	00DH,0FCH
		HEX	4E,44,00
		BYTE	0FBH,001H
		HEX	4E,44,00
		BYTE	005H,013H
		HEX	4E,44,00
		BYTE	015H,009H
		HEX	4E,04,00
		BYTE	0FCH,017H
		HEX	4F,84,00
		BYTE	0F8H,012H
		HEX	4E,04,00
		BYTE	004H,009H
		HEX	4F,04,00
;
BRTOGC_A	BYTE	007H,017H	;[0A]
		HEX	55,06,00
		BYTE	0FCH,009H
		HEX	55,06,00
		BYTE	00CH,003H
		HEX	44,06,00
		BYTE	00DH,01FH
		HEX	4F,44,00
		BYTE	00DH,0FEH
		HEX	4F,44,00
		BYTE	0FBH,003H
		HEX	4E,44,00
		BYTE	005H,015H
		HEX	4E,44,00
		BYTE	016H,00AH
		HEX	4E,04,00
		BYTE	0FCH,019H
		HEX	4F,84,00
		BYTE	0F8H,014H
		HEX	4E,04,00
		BYTE	004H,00AH
		HEX	4F,04,00
;
BRTOGC_B	BYTE	003H,020H	;[0B]
		HEX	44,06,00
		BYTE	007H,016H
		HEX	45,06,00
		BYTE	0FCH,008H
		HEX	54,06,00
		BYTE	00DH,022H
		HEX	4F,44,00
		BYTE	00EH,001H
		HEX	4F,44,00
		BYTE	0FBH,005H
		HEX	4F,44,00
		BYTE	005H,019H
		HEX	4E,44,00
		BYTE	017H,00DH
		HEX	4E,04,00
		BYTE	0F7H,017H
		HEX	4F,04,00
;
BRTOGC_C	BYTE	017H,010H	;[0C]
		HEX	4F,04,00
		BYTE	003H,020H
		HEX	54,06,00
		BYTE	007H,016H
		HEX	54,06,00
		BYTE	0FCH,008H
		HEX	44,06,00
		BYTE	00EH,005H
		HEX	4F,44,00
		BYTE	0F7H,01AH
		HEX	4F,04,00
		BYTE	005H,01CH
		HEX	4F,44,00
;
BRTOGC_D	BYTE	018H,012H	;[0D]
		HEX	4F,04,00
		BYTE	003H,020H
		HEX	45,06,00
		BYTE	007H,016H
		HEX	44,06,00
		BYTE	005H,01FH
		HEX	4F,44,00
;
BRTOGC_E	BYTE	003H,020H	;[0E]
		HEX	54,06,00
		BYTE	005H,022H
		HEX	4F,44,00
;
BRTOGC_F	BYTE	003H,020H	;[0F]
		HEX	44,06,00
		BYTE	005H,025H
		HEX	4F,44,00
;
BRTOGC_EN	EQU	$
;
;************************************************************************
;*		xăubN̕p^[			*
;************************************************************************
BR2CRMV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		PHX			;(X) save
;
		TXA
		AND	#00FFH
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK BR2CRC_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#BR2CRC_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
;
		PLX			;(X) load
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	BR2CRMV_050	;pattern change ? ( no:BR2CRMV_050 )
;
		DEC	EXCHPT,X
		BPL	BR2CRMV_010	;end ? ( no:BR2CRMV_050 )
		JMP	EXCLEAR
;
BR2CRMV_010	EQU	$
;
		M8
;
		LDY	EXCHPT,X
		LDA	!BR2CRC_NO,Y	;n`lgpZbg
		STA	EXMOD2+1,X
		LDA	#02H		;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
BR2CRMV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
BR2CRC_NO	EQU	$
		BYTE	((BR2CRC_EN-BR2CRC_F)/5)<<3
		BYTE	((BR2CRC_F-BR2CRC_E)/5)<<3
		BYTE	((BR2CRC_E-BR2CRC_D)/5)<<3
		BYTE	((BR2CRC_D-BR2CRC_C)/5)<<3
		BYTE	((BR2CRC_C-BR2CRC_B)/5)<<3
		BYTE	((BR2CRC_B-BR2CRC_A)/5)<<3
		BYTE	((BR2CRC_A-BR2CRC_9)/5)<<3
		BYTE	((BR2CRC_9-BR2CRC_8)/5)<<3
		BYTE	((BR2CRC_8-BR2CRC_7)/5)<<3
		BYTE	((BR2CRC_7-BR2CRC_6)/5)<<3
		BYTE	((BR2CRC_6-BR2CRC_5)/5)<<3
		BYTE	((BR2CRC_5-BR2CRC_4)/5)<<3
		BYTE	((BR2CRC_4-BR2CRC_3)/5)<<3
;;;;		    BYTE    ((BR2CRC_3-BR2CRC_2)/5)<<3
BR2CRC_ADRS	EQU	$
		WORD	BR2CRC_F
		WORD	BR2CRC_E
		WORD	BR2CRC_D
		WORD	BR2CRC_C
		WORD	BR2CRC_B
		WORD	BR2CRC_A
		WORD	BR2CRC_9
		WORD	BR2CRC_8
		WORD	BR2CRC_7
		WORD	BR2CRC_6
		WORD	BR2CRC_5
		WORD	BR2CRC_4
		WORD	BR2CRC_3
		WORD	BR2CRC_2
;
BR2CRC_2	BYTE	007H,008H	;[02]
		HEX	42,C2,02
		BYTE	0F7H,008H
		HEX	42,82,02
		BYTE	007H,0F8H
		HEX	42,42,02
		BYTE	0F7H,0F8H
		HEX	42,02,02
		BYTE	009H,001H
		HEX	86,08,02
		BYTE	0FFH,008H
		HEX	86,08,02
		BYTE	0F5H,0FEH
		HEX	86,08,02
		BYTE	001H,0F6H
		HEX	86,08,02
		BYTE	00CH,009H
		HEX	86,08,02
		BYTE	0F5H,00AH
		HEX	86,08,02
		BYTE	00BH,0F4H
		HEX	86,08,02
		BYTE	0F6H,0F3H
		HEX	86,08,02
;
BR2CRC_3	BYTE	005H,005H	;[03]
		HEX	42,C2,02
		BYTE	0FDH,005H
		HEX	42,82,02
		BYTE	005H,0FDH
		HEX	42,42,02
		BYTE	0FDH,0FDH
		HEX	42,02,02
		BYTE	011H,001H
		HEX	86,08,02
		BYTE	0FFH,010H
		HEX	86,08,02
		BYTE	0EDH,0FEH
		HEX	86,08,02
		BYTE	001H,0F2H
		HEX	86,08,02
		BYTE	010H,00DH
		HEX	86,08,02
		BYTE	0F1H,00EH
		HEX	86,08,02
		BYTE	00DH,0EEH
		HEX	86,08,02
		BYTE	0F4H,0EDH
		HEX	86,08,02
;
BR2CRC_4	BYTE	008H,008H	;[04]
		HEX	6A,C6,02
		BYTE	0F8H,008H
		HEX	6A,86,02
		BYTE	008H,0F8H
		HEX	6A,46,02
		BYTE	0F8H,0F8H
		HEX	6A,06,02
		BYTE	015H,003H
		HEX	86,08,02
		BYTE	0FFH,014H
		HEX	86,08,02
		BYTE	0E9H,0FFH
		HEX	86,08,02
		BYTE	001H,0F0H
		HEX	86,08,02
		BYTE	014H,00FH
		HEX	86,08,02
		BYTE	0EFH,010H
		HEX	86,08,02
		BYTE	00FH,0ECH
		HEX	86,08,02
		BYTE	0F2H,0EBH
		HEX	86,08,02
;
BR2CRC_5	BYTE	008H,008H	;[05]
		HEX	E3,06,02
		BYTE	0F8H,000H
		HEX	E3,06,02
		BYTE	019H,005H
		HEX	86,08,02
		BYTE	0FFH,01AH
		HEX	86,08,02
		BYTE	0E5H,001H
		HEX	86,08,02
		BYTE	001H,0EEH
		HEX	E3,06,02
		BYTE	016H,012H
		HEX	86,08,02
		BYTE	0EDH,013H
		HEX	86,08,02
		BYTE	011H,0EAH
		HEX	86,08,02
		BYTE	0F0H,0E9H
		HEX	86,08,02
;
BR2CRC_6	BYTE	008H,0F8H	;[06]
		HEX	E3,06,02
		BYTE	008H,008H
		HEX	E5,06,02
		BYTE	0F8H,000H
		HEX	E5,06,02
		BYTE	01DH,007H
		HEX	86,08,02
		BYTE	0FFH,01EH
		HEX	E3,06,02
		BYTE	0E1H,003H
		HEX	86,08,02
		BYTE	001H,0EDH
		HEX	E5,06,02
		BYTE	018H,016H
		HEX	86,08,02
		BYTE	0EBH,017H
		HEX	86,08,02
		BYTE	013H,0E9H
		HEX	86,08,02
		BYTE	0EEH,0E8H
		HEX	86,08,02
;
BR2CRC_7	BYTE	000H,000H	;[07]
		HEX	E3,06,02
		BYTE	008H,0F8H
		HEX	E5,06,02
		BYTE	008H,008H
		HEX	E5,06,02
		BYTE	0F8H,000H
		HEX	E7,06,02
		BYTE	021H,009H
		HEX	86,08,02
		BYTE	0FFH,024H
		HEX	E5,06,02
		BYTE	0DDH,005H
		HEX	86,08,02
		BYTE	001H,0EDH
		HEX	E7,06,02
		BYTE	01AH,01AH
		HEX	86,08,02
		BYTE	0E9H,01BH
		HEX	86,08,02
		BYTE	015H,0E9H
		HEX	86,08,02
		BYTE	0ECH,0E8H
		HEX	86,08,02
;
BR2CRC_8	BYTE	000H,010H	;[08]
		HEX	E3,06,02
		BYTE	000H,000H
		HEX	E5,06,02
		BYTE	008H,0F8H
		HEX	E7,06,02
		BYTE	024H,00CH
		HEX	E3,06,02
		BYTE	0FFH,02AH
		HEX	E7,06,02
		BYTE	0DAH,008H
		HEX	86,08,02
		BYTE	01DH,020H
		HEX	86,08,02
		BYTE	0E6H,021H
		HEX	86,08,02
		BYTE	018H,0EAH
		HEX	86,08,02
		BYTE	0E9H,0E9H
		HEX	86,08,02
;
BR2CRC_9	BYTE	0F0H,008H	;[09]
		HEX	E3,06,02
		BYTE	000H,010H
		HEX	E5,06,02
		BYTE	000H,000H
		HEX	E7,06,02
		BYTE	026H,00FH
		HEX	E5,06,02
		BYTE	0D8H,00BH
		HEX	86,08,02
		BYTE	01FH,025H
		HEX	86,08,02
		BYTE	0E4H,026H
		HEX	86,08,02
		BYTE	01AH,0ECH
		HEX	86,08,02
		BYTE	0E7H,0EBH
		HEX	E3,06,02
;
BR2CRC_A	BYTE	0E8H,018H	;[0A]
		HEX	E3,06,02
		BYTE	008H,020H
		HEX	E3,06,02
		BYTE	0F0H,008H
		HEX	E5,06,02
		BYTE	000H,010H
		HEX	E7,06,02
		BYTE	028H,014H
		HEX	E7,06,02
		BYTE	0D6H,010H
		HEX	86,08,02
		BYTE	021H,02CH
		HEX	86,08,02
		BYTE	0E2H,02DH
		HEX	E3,06,02
		BYTE	01CH,0EFH
		HEX	86,08,02
		BYTE	0E5H,0EEH
		HEX	E5,06,02
;
BR2CRC_B	BYTE	018H,010H	;[0B]
		HEX	E3,06,02
		BYTE	0E8H,018H
		HEX	E5,06,02
		BYTE	008H,020H
		HEX	E5,06,02
		BYTE	0F0H,008H
		HEX	E7,06,02
		BYTE	000H,010H
		HEX	E7,06,02
		BYTE	0D5H,015H
		HEX	86,08,02
		BYTE	022H,032H
		HEX	86,08,02
		BYTE	0E1H,033H
		HEX	E5,06,02
		BYTE	01DH,0F3H
		HEX	E5,06,02
		BYTE	0E4H,0F2H
		HEX	E7,06,02
;
BR2CRC_C	BYTE	000H,038H	;[0C]
		HEX	E3,06,02
		BYTE	018H,010H
		HEX	E5,06,02
		BYTE	0E8H,018H
		HEX	E7,06,02
		BYTE	008H,020H
		HEX	E7,06,02
		BYTE	0D3H,01BH
		HEX	86,08,02
		BYTE	024H,038H
		HEX	E3,06,02
		BYTE	0E0H,039H
		HEX	E7,06,02
		BYTE	01FH,0F9H
		HEX	E5,06,02
;
BR2CRC_D	BYTE	008H,010H	;[0D]
		HEX	E3,06,02
		BYTE	000H,038H
		HEX	E5,06,02
		BYTE	018H,010H
		HEX	E7,06,02
		BYTE	0D3H,021H
		HEX	E3,06,02
		BYTE	024H,03EH
		HEX	E5,06,02
		BYTE	01FH,0FFH
		HEX	E7,06,02
;
BR2CRC_E	BYTE	008H,010H	;[0E]
		HEX	E5,06,02
		BYTE	000H,038H
		HEX	E7,06,02
		BYTE	0D2H,027H
		HEX	E5,06,02
		BYTE	025H,044H
		HEX	E7,06,02
;
BR2CRC_F	BYTE	008H,010H	;[0F]
		HEX	E7,06,02
		BYTE	0D1H,02DH
		HEX	E7,06,02
;
BR2CRC_EN	EQU	$
;
;************************************************************************
;*		ԂтЂЂ					*
;************************************************************************
;*		͂˂ЂЂ					*
;************************************************************************
HIRA0_TM	EQU	$
		HEX	04,04,04,04,04,04,04,04,04,04,04,04,04,04,04
		HEX	03,03,03
		HEX	02,02
		HEX	01,01,01
;
HIRA0MV		EQU	$
HIRA1MV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		PHX			;(X) save
;
		TXA
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK HIRA0C_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#HIRA0C_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
;
		PLX			;(X) load
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	HIRA0MV_050	;pattern change ? ( no:HIRA0MV_050 )
;
		DEC	EXCHPT,X
		BPL	HIRA0MV_010	;end ? ( no:HIRA0MV_050 )
		JMP	EXCLEAR
;
HIRA0MV_010	EQU	$
;
		M8
;
		LDY	EXCHPT,X
		LDA	!HIRA0C_NO,Y	;n`lgpZbg
		STA	EXMOD2+1,X
		LDA	!HIRA0_TM,Y	;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
HIRA0MV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
HIRA0C_NO	EQU	$
		BYTE	((HIRA0C_EN-HIRA0C_17)/5)<<3
		BYTE	((HIRA0C_17-HIRA0C_16)/5)<<3
		BYTE	((HIRA0C_16-HIRA0C_15)/5)<<3
		BYTE	((HIRA0C_15-HIRA0C_14)/5)<<3
		BYTE	((HIRA0C_14-HIRA0C_13)/5)<<3
		BYTE	((HIRA0C_13-HIRA0C_12)/5)<<3
		BYTE	((HIRA0C_12-HIRA0C_11)/5)<<3
		BYTE	((HIRA0C_11-HIRA0C_10)/5)<<3
		BYTE	((HIRA0C_10-HIRA0C_F)/5)<<3
		BYTE	((HIRA0C_F-HIRA0C_E)/5)<<3
		BYTE	((HIRA0C_E-HIRA0C_D)/5)<<3
		BYTE	((HIRA0C_D-HIRA0C_C)/5)<<3
		BYTE	((HIRA0C_C-HIRA0C_B)/5)<<3
		BYTE	((HIRA0C_B-HIRA0C_A)/5)<<3
		BYTE	((HIRA0C_A-HIRA0C_9)/5)<<3
		BYTE	((HIRA0C_9-HIRA0C_8)/5)<<3
		BYTE	((HIRA0C_8-HIRA0C_7)/5)<<3
		BYTE	((HIRA0C_7-HIRA0C_6)/5)<<3
		BYTE	((HIRA0C_6-HIRA0C_5)/5)<<3
		BYTE	((HIRA0C_5-HIRA0C_4)/5)<<3
		BYTE	((HIRA0C_4-HIRA0C_3)/5)<<3
		BYTE	((HIRA0C_3-HIRA0C_2)/5)<<3
		BYTE	((HIRA0C_2-HIRA0C_1)/5)<<3
;;;;;;;;		BYTE	((HIRA0C_1-HIRA0C_0)/5)<<3
;
HIRA0C_ADRS	EQU	$
		WORD	HIRA0C_17
		WORD	HIRA0C_16
		WORD	HIRA0C_15
		WORD	HIRA0C_14
		WORD	HIRA0C_13
		WORD	HIRA0C_12
		WORD	HIRA0C_11
		WORD	HIRA0C_10
		WORD	HIRA0C_F
		WORD	HIRA0C_E
		WORD	HIRA0C_D
		WORD	HIRA0C_C
		WORD	HIRA0C_B
		WORD	HIRA0C_A
		WORD	HIRA0C_9
		WORD	HIRA0C_8
		WORD	HIRA0C_7
		WORD	HIRA0C_6
		WORD	HIRA0C_5
		WORD	HIRA0C_4
		WORD	HIRA0C_3
		WORD	HIRA0C_2
		WORD	HIRA0C_1
		WORD	HIRA0C_0
;
HIRA0C_0	BYTE	002H,000H	;[00]
		HEX	11,00,00
		BYTE	0FCH,000H
		HEX	10,00,00
		BYTE	004H,0FCH
		HEX	01,00,00
		BYTE	0FCH,0FCH
		HEX	00,00,00
		BYTE	0FBH,000H
		HEX	11,00,00
		BYTE	0F8H,000H
		HEX	10,00,00
		BYTE	0FBH,0FAH
		HEX	01,00,00
		BYTE	0F6H,0FCH
		HEX	00,00,00
;
HIRA0C_1	BYTE	006H,003H	;[01]
		HEX	01,00,00
		BYTE	0FCH,005H
		HEX	10,40,00
		BYTE	008H,0F7H
		HEX	10,00,00
		BYTE	0FCH,0F7H
		HEX	10,00,00
		BYTE	0FBH,000H
		HEX	11,40,00
		BYTE	0F3H,003H
		HEX	10,40,00
		BYTE	0FBH,0F1H
		HEX	01,40,00
		BYTE	0F2H,0F7H
		HEX	01,00,00
;
HIRA0C_2	BYTE	009H,003H	;[02]
		HEX	10,40,00
		BYTE	0FCH,008H
		HEX	00,40,00
		BYTE	00BH,0F5H
		HEX	10,40,00
		BYTE	0FCH,0F4H
		HEX	11,00,00
		BYTE	0FBH,001H
		HEX	10,40,00
		BYTE	0F0H,003H
		HEX	10,00,00
		BYTE	0FBH,0EDH
		HEX	01,C0,00
		BYTE	0EFH,0F4H
		HEX	01,80,00
;
HIRA0C_3	BYTE	00CH,004H	;[03]
		HEX	01,40,00
		BYTE	0FCH,008H
		HEX	01,40,00
		BYTE	00DH,0F3H
		HEX	01,40,00
		BYTE	0FCH,0F3H
		HEX	10,40,00
		BYTE	0FBH,002H
		HEX	00,40,00
		BYTE	0EDH,004H
		HEX	00,00,00
		BYTE	0FBH,0EBH
		HEX	00,C0,00
		BYTE	0EDH,0F2H
		HEX	10,80,00
;
HIRA0C_4	BYTE	00DH,005H	;[04]
		HEX	00,C0,00
		BYTE	0FCH,00AH
		HEX	01,C0,00
		BYTE	00EH,0F2H
		HEX	01,C0,00
		BYTE	0FCH,0F3H
		HEX	00,40,00
		BYTE	0FBH,003H
		HEX	01,40,00
		BYTE	0ECH,005H
		HEX	01,00,00
		BYTE	0FBH,0E9H
		HEX	11,80,00
		BYTE	0ECH,0F1H
		HEX	10,C0,00
;
HIRA0C_5	BYTE	00EH,006H	;[05]
		HEX	11,80,00
		BYTE	0FBH,00CH
		HEX	00,C0,00
		BYTE	00FH,0F1H
		HEX	00,C0,00
		BYTE	0FCH,0F3H
		HEX	00,C0,00
		BYTE	0FBH,004H
		HEX	01,C0,00
		BYTE	0EBH,006H
		HEX	01,80,00
		BYTE	0FBH,0E8H
		HEX	10,80,00
		BYTE	0EBH,0F0H
		HEX	01,C0,00
;
HIRA0C_6	BYTE	00EH,006H	;[06]
		HEX	01,80,00
		BYTE	0FCH,00CH
		HEX	11,80,00
		BYTE	00FH,0F1H
		HEX	11,80,00
		BYTE	0FCH,0F3H
		HEX	11,80,00
		BYTE	0FBH,005H
		HEX	00,C0,00
		BYTE	0EBH,006H
		HEX	00,80,00
		BYTE	0FBH,0E8H
		HEX	00,80,00
		BYTE	0EBH,0F0H
		HEX	00,40,00
;
HIRA0C_7	BYTE	00DH,00AH	;[07]
		HEX	10,00,00
		BYTE	0FDH,00FH
		HEX	10,80,00
		BYTE	010H,0F2H
		HEX	10,80,00
		BYTE	0FEH,0F6H
		HEX	00,80,00
		BYTE	0FBH,006H
		HEX	11,80,00
		BYTE	0EBH,007H
		HEX	11,80,00
		BYTE	0FCH,0EBH
		HEX	01,00,00
		BYTE	0EDH,0F4H
		HEX	11,00,00
;
HIRA0C_8	BYTE	00CH,00EH	;[08]
		HEX	10,40,00
		BYTE	0FEH,013H
		HEX	00,80,00
		BYTE	011H,0F6H
		HEX	01,00,00
		BYTE	0FEH,0F8H
		HEX	00,00,00
		BYTE	0FDH,009H
		HEX	00,80,00
		BYTE	0E9H,009H
		HEX	00,C0,00
		BYTE	0FCH,0EEH
		HEX	10,00,00
		BYTE	0EFH,0F3H
		HEX	00,00,00
;
HIRA0C_9	BYTE	00BH,00EH	;[09]
		HEX	00,40,00
		BYTE	0FEH,016H
		HEX	01,00,00
		BYTE	010H,0F9H
		HEX	00,00,00
		BYTE	0FCH,0FBH
		HEX	11,00,00
		BYTE	0FDH,00CH
		HEX	00,00,00
		BYTE	0E9H,00CH
		HEX	00,40,00
		BYTE	0FAH,0F2H
		HEX	11,00,00
		BYTE	0EEH,0F3H
		HEX	01,00,00
;
HIRA0C_A	BYTE	00AH,00FH	;[0A]
		HEX	01,40,00
		BYTE	0FDH,019H
		HEX	10,00,00
		BYTE	00FH,0FEH
		HEX	11,00,00
		BYTE	0FBH,0FBH
		HEX	00,40,00
		BYTE	0FBH,00FH
		HEX	11,00,00
		BYTE	0EBH,010H
		HEX	11,00,00
		BYTE	0FAH,0F2H
		HEX	10,40,00
		BYTE	0EEH,0F4H
		HEX	01,00,00
;
HIRA0C_B	BYTE	009H,010H	;[0B]
		HEX	01,40,00
		BYTE	0FBH,01AH
		HEX	00,40,00
		BYTE	00EH,0FDH
		HEX	00,40,00
		BYTE	0FAH,0FCH
		HEX	01,40,00
		BYTE	0F9H,010H
		HEX	00,40,00
		BYTE	0ECH,011H
		HEX	00,00,00
		BYTE	0F9H,0F3H
		HEX	00,40,00
		BYTE	0EDH,0F6H
		HEX	00,00,00
;
HIRA0C_C	BYTE	00BH,013H	;[0C]
		HEX	00,40,00
		BYTE	0FAH,01DH
		HEX	01,40,00
		BYTE	00DH,0FEH
		HEX	01,40,00
		BYTE	0FBH,0FEH
		HEX	01,C0,00
		BYTE	0FAH,011H
		HEX	01,40,00
		BYTE	0EDH,011H
		HEX	01,00,00
		BYTE	0F9H,0F3H
		HEX	01,40,00
		BYTE	0EBH,0FCH
		HEX	10,00,00
;
HIRA0C_D	BYTE	00CH,016H	;[0D]
		HEX	10,40,00
		BYTE	0F9H,01EH
		HEX	01,40,00
		BYTE	00DH,0FFH
		HEX	01,40,00
		BYTE	0FBH,000H
		HEX	00,C0,00
		BYTE	0FAH,012H
		HEX	01,C0,00
		BYTE	0EDH,013H
		HEX	01,00,00
		BYTE	0F9H,0F5H
		HEX	01,40,00
		BYTE	0E9H,0FEH
		HEX	11,00,00
;
HIRA0C_E	BYTE	00DH,019H	;[0E]
		HEX	11,00,00
		BYTE	0FAH,020H
		HEX	00,40,00
		BYTE	00EH,002H
		HEX	00,40,00
		BYTE	0FBH,001H
		HEX	10,C0,00
		BYTE	0FAH,015H
		HEX	01,C0,00
		BYTE	0ECH,016H
		HEX	00,00,00
		BYTE	0FAH,0F8H
		HEX	00,40,00
		BYTE	0E9H,0FDH
		HEX	10,40,00
;
HIRA0C_F	BYTE	00FH,01AH	;[0F]
		HEX	10,00,00
		BYTE	0FBH,023H
		HEX	10,40,00
		BYTE	00EH,005H
		HEX	10,40,00
		BYTE	0FCH,003H
		HEX	10,C0,00
		BYTE	0FAH,017H
		HEX	01,40,00
		BYTE	0ECH,019H
		HEX	10,00,00
		BYTE	0FBH,0FBH
		HEX	10,40,00
		BYTE	0E9H,0FDH
		HEX	00,40,00
;
HIRA0C_10	BYTE	011H,01CH	;[10]
		HEX	01,00,00
		BYTE	0FDH,026H
		HEX	00,00,00
		BYTE	011H,008H
		HEX	01,00,00
		BYTE	0FBH,009H
		HEX	00,C0,00
		BYTE	0FBH,01CH
		HEX	10,00,00
		BYTE	0E9H,01CH
		HEX	00,40,00
		BYTE	0E9H,000H
		HEX	01,40,00
;
HIRA0C_11	BYTE	010H,01BH	;[11]
		HEX	00,00,00
		BYTE	0FCH,025H
		HEX	10,00,00
		BYTE	010H,009H
		HEX	10,00,00
		BYTE	0FCH,006H
		HEX	10,C0,00
		BYTE	0FBH,01AH
		HEX	10,40,00
		BYTE	0EAH,01BH
		HEX	10,40,00
		BYTE	0FBH,0FDH
		HEX	11,00,00
		BYTE	0E9H,0FEH
		HEX	01,40,00
;
HIRA0C_12	BYTE	012H,01DH	;[12]
		HEX	01,00,00
		BYTE	0FEH,028H
		HEX	01,00,00
		BYTE	011H,009H
		HEX	01,00,00
		BYTE	0FBH,00BH
		HEX	00,C0,00
		BYTE	0FDH,01DH
		HEX	01,00,00
		BYTE	0E9H,004H
		HEX	00,40,00
;
HIRA0C_13	BYTE	011H,021H	;[13]
		HEX	00,00,00
		BYTE	010H,00CH
		HEX	00,00,00
		BYTE	0FAH,00EH
		HEX	01,C0,00
		BYTE	0FDH,01EH
		HEX	01,00,00
		BYTE	0EAH,007H
		HEX	10,40,00
;
HIRA0C_14	BYTE	010H,00EH	;[14]
		HEX	10,00,00
		BYTE	0FBH,011H
		HEX	01,40,00
		BYTE	0FCH,022H
		HEX	10,00,00
		BYTE	0EAH,00AH
		HEX	10,00,00
;
HIRA0C_15	BYTE	00FH,013H	;[15]
		HEX	11,00,00
		BYTE	0FBH,025H
		HEX	11,00,00
		BYTE	0EBH,00AH
		HEX	00,00,00
;
HIRA0C_16	BYTE	0FAH,026H	;[16]
		HEX	10,40,00
		BYTE	0EBH,00BH
		HEX	01,00,00
;
HIRA0C_17	BYTE	0F9H,027H	;[17]
		HEX	01,40,00
HIRA0C_EN	EQU	$
;
;
;****************************************************************
;*								*
;****************************************************************
ONPU0_GMAX	EQU	$
		WORD	-00800H,  00800H
;
ONPU0MV		EQU	$
		JSR	EXMDCK			; mode check
;
		LDY	#00
		LDA	!EXYPSL,X
		CMP	!EXWRK0,X
		BPL	ONPU0MV0080		;  ? [no->ONPU0MV0080]
;
		INY
		INY
ONPU0MV0080	EQU	$
		LDA	ONPU0_GMAX,Y
		STA	!EXGMAX,X
		RTS
;
;************************************************************************
;*		XubNnނ					*
;************************************************************************
ICEBRTM		EQU	$
		HEX	07,07,05,04,04,04,04,04
;
ICEBRMV		EQU	$
		JSR	EXMDCK			; mode check
;
		LDA	EXTIM0,X
		BNE	ICEBR_0020	;p^[؂ւH ( no:ICEBR_0020 )
;
		DEC	EXCHPT,X
		BPL	ICEBR_0010	;IH ( no:ICEBR_0010 )
		JMP	EXCLEAR
;
ICEBR_0010	EQU	$
		LDY	EXCHPT,X
		LDA	!ICEBRTM,Y	;p^[؂ւ^C}[Zbg
		AND	#00FFH
		STA	EXTIM0,X
ICEBR_0020	EQU	$
		RTS
;
;************************************************************************
;*		̖؂Ƀ^}Š			*
;************************************************************************
YKCHIC_TMDT	EQU	$
; EXCHPT -->		 0  1  2  3  4	5  6  7	 8  9  A  B  C	D  E
		HEX	06,06,06,06,06,05,05,05,05,05,05,04,04,04
;
YKCHIMV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		PHX			;(X) save
;
		TXA
		AND	#00FFH
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK YKCHIC_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#YKCHIC_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
;
		PLX			;(X) load
;
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	YKCHIMV_050	;pattern change ? ( no:YKCHIMV_050 )
;
		DEC	EXCHPT,X
		BPL	YKCHIMV_010	;end ? ( no:YKCHIMV_050 )
		JMP	EXCLEAR
;
YKCHIMV_010	EQU	$
;
		M8
;
		LDY	EXCHPT,X
		LDA	!YKCHIC_NO,Y	;n`lgpZbg
		STA	EXMOD2+1,X
		LDA	!YKCHIC_TMDT,Y	;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
YKCHIMV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
YKCHIC_NO	EQU	$
		BYTE	((YKCHIC_EN-YKCHIC_1A)/5)<<3
		BYTE	((YKCHIC_1A-YKCHIC_19)/5)<<3
		BYTE	((YKCHIC_19-YKCHIC_18)/5)<<3
		BYTE	((YKCHIC_18-YKCHIC_17)/5)<<3
		BYTE	((YKCHIC_17-YKCHIC_16)/5)<<3
		BYTE	((YKCHIC_16-YKCHIC_15)/5)<<3
		BYTE	((YKCHIC_15-YKCHIC_14)/5)<<3
		BYTE	((YKCHIC_14-YKCHIC_13)/5)<<3
		BYTE	((YKCHIC_13-YKCHIC_12)/5)<<3
		BYTE	((YKCHIC_12-YKCHIC_11)/5)<<3
		BYTE	((YKCHIC_11-YKCHIC_10)/5)<<3
		BYTE	((YKCHIC_10-YKCHIC_0F)/5)<<3
		BYTE	((YKCHIC_0F-YKCHIC_0E)/5)<<3
		BYTE	((YKCHIC_0E-YKCHIC_0D)/5)<<3
		BYTE	((YKCHIC_0D-YKCHIC_0C)/5)<<3
YKCHIC_ADRS	EQU	$
		WORD	YKCHIC_1A
		WORD	YKCHIC_19
		WORD	YKCHIC_18
		WORD	YKCHIC_17
		WORD	YKCHIC_16
		WORD	YKCHIC_15
		WORD	YKCHIC_14
		WORD	YKCHIC_13
		WORD	YKCHIC_12
		WORD	YKCHIC_11
		WORD	YKCHIC_10
		WORD	YKCHIC_0F
		WORD	YKCHIC_0E
		WORD	YKCHIC_0D
		WORD	YKCHIC_0C
;
YKCHIC_0C	EQU	$
		BYTE	000H,000H	;[0C]
		HEX	E3,06,02
;
YKCHIC_0D	EQU	$
		BYTE	000H,001H	;[0D]
		HEX	E3,06,02
;
YKCHIC_0E	EQU	$
		BYTE	000H,000H	;[0E]
		HEX	F8,06,00
		BYTE	000H,003H
		HEX	E3,06,02
;
YKCHIC_0F	EQU	$
		BYTE	000H,000H	;[0F]
		HEX	F8,46,00
		BYTE	000H,006H
		HEX	E3,06,02
;
YKCHIC_10	EQU	$
		BYTE	000H,000H	;[10]
		HEX	F8,06,00
		BYTE	000H,00AH
		HEX	E5,06,02
;
YKCHIC_11	EQU	$
		BYTE	008H,009H	;[11]
		HEX	F8,06,00
		BYTE	000H,001H
		HEX	F7,46,00
		BYTE	000H,00EH
		HEX	E5,46,02
;
YKCHIC_12	EQU	$
		BYTE	008H,00AH	;[12]
		HEX	F8,46,00
		BYTE	000H,003H
		HEX	F7,06,00
		BYTE	000H,012H
		HEX	E5,06,02
;
YKCHIC_13	EQU	$
		BYTE	008H,00CH	;[13]
		HEX	F7,06,00
		BYTE	000H,005H
		HEX	F7,46,00
		BYTE	000H,016H
		HEX	E5,46,02
;
YKCHIC_14	EQU	$
		BYTE	008H,00EH	;[14]
		HEX	F7,46,00
		BYTE	000H,007H
		HEX	F7,06,00
		BYTE	000H,01AH
		HEX	E7,06,02
;
YKCHIC_15	EQU	$
		BYTE	000H,00BH	;[15]
		HEX	E1,06,00
		BYTE	004H,018H
		HEX	F8,06,00
		BYTE	008H,010H
		HEX	E1,06,00
		BYTE	000H,01EH
		HEX	E7,46,02
;
YKCHIC_16	EQU	$
		BYTE	004H,019H	;[16]
		HEX	F8,46,00
		BYTE	008H,012H
		HEX	E1,06,00
		BYTE	000H,022H
		HEX	E7,86,02
;
YKCHIC_17	EQU	$
		BYTE	004H,01BH	;[17]
		HEX	F8,06,00
		BYTE	000H,026H
		HEX	E7,C6,02
;
YKCHIC_18	EQU	$
		BYTE	004H,01DH	;[18]
		HEX	59,06,00
;
YKCHIC_19	EQU	$
		BYTE	004H,01FH	;[19]
		HEX	F7,46,00
;
YKCHIC_1A	EQU	$
		BYTE	004H,021H	;[1A]
		HEX	E1,06,00
;
YKCHIC_EN	EQU	$
;
;
;****************************************************************
;*	ف[ǂ̍					*
;****************************************************************
BONE1MV		EQU	$
BONE0MV		EQU	$
		JSR	EXMDCK
;
		LDA	!EXTIM0,X
		BNE	BONE0MV0040		; I ? [no->BONE0MV0040]
;
		JMP	EXCLEAR
;
BONE0MV0040	EQU	$
		LDA	!EXTIM1,X
		BNE	BONE0MV00F0		; pattern change ? [no->BONE0MV00F0]
;
		M8				; memory 8bit mode !!
;
		LDA	#02
		STA	!EXTIM1,X
;
		DEC	!EXCHPT,X
		BPL	BONE0MV00E0		; pattern max ? [no->BONE0MV00E0]
;
		LDA	!EXWRK0,X
		STA	!EXCHPT,X
BONE0MV00E0	EQU	$
;
		M16				; memory 16bit mode !!
;
BONE0MV00F0	EQU	$
		RTS

;
;************************************************************************
;*		move	( Ղ悵Ԃ )					*
;************************************************************************
SLMSBMV		EQU	$			;-- slmsbmv --
		JSR	EXMDCK		;mode check

		LDA	EXCBFG,X
		AND	#00001H
		BEQ	SLMSB08

		LDA	EXCHPT,X
		BNE	SLMSB05

		LDA	#0000000000011100B	;_`FbN
		STA	EXMOD1,X		;

SLMSB05		EQU	$
		CMP	#00003H
		BEQ	SLMSB06

		INC	EXCHPT,X

SLMSB06		EQU	$
		LDA	EXYSPD,X
		BMI	SLMSB08

		LSR	A
		CMP	#00020H
		BCS	SLMSB07

		JMP	EXCLEAR

SLMSB07		EQU	$
		EOR	#0FFFFH
		INC	A
		STA	EXYSPD,X

SLMSB08		EQU	$

		RTS
;
;;;;;****************************************************************
;;;;;*	    ^C						    *
;;;;;****************************************************************
;;;;TMKNXMV	    EQU	    $
;;;;		    JSR	    EXMDCK	    ;mode check
;;;;;
;;;;		    RTS
;;;;;
;;;;;[1994.11.24.TH]		    LDA	    !EXYSPD,X
;;;;;[1994.11.24.TH]		    BMI	    TMKNXMV00F0		    ; [->TMKNXMV00F0]
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    LDA	    #KACHB
;;;;;[1994.11.24.TH]		    JSR	    >EXINSR
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    LDA	    !EXXPSL,X
;;;;;[1994.11.24.TH]		    CLC
;;;;;[1994.11.24.TH]		    ADC	    #0008
;;;;;[1994.11.24.TH]		    STA	    !EXXPSL,Y
;;;;;[1994.11.24.TH]		    LDA	    !EXYPSL,X
;;;;;[1994.11.24.TH]		    CLC
;;;;;[1994.11.24.TH]		    ADC	    #0008
;;;;;[1994.11.24.TH]		    STA	    !EXYPSL,Y
;;;;;[1994.11.24.TH]		    LDA	    #0004
;;;;;[1994.11.24.TH]		    STA	    !EXCHPT,Y
;;;;;[1994.11.24.TH]		    LDA	    #0002
;;;;;[1994.11.24.TH]		    STA	    !EXTIM0,Y
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    LDA	    #0001CH
;;;;;[1994.11.24.TH]		    STA	    !SOUND3		    ; TEh Zbg !!
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    JMP	    EXCLEAR
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]TMKNXMV00F0	    EQU	    $
;;;;;[1994.11.24.TH]		    RTS
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    LDA	    !EXCBFG,X
;;;;;[1994.11.24.TH]		    BIT	    #0000000000000001B
;;;;;[1994.11.24.TH]		    BEQ	    TMKNXMV00F0		    ; ˂ ? [no->TMKNXMV00F0]
;;;;;[1994.11.24.TH];
;;;;;[1994.11.24.TH]		    LDA	    !EXMOD1,X
;;;;;[1994.11.24.TH]		    AND	    #1111111111100000B
;;;;;[1994.11.24.TH]		    STA	    !EXMOD1,X		    ; af`FbNnee !!
;;;;;[1994.11.24.TH]		    LDA	    !EXYSPD,X
;;;;;[1994.11.24.TH]		    LSR	    A
;;;;;[1994.11.24.TH]		    EOR	    #0FFFFH
;;;;;[1994.11.24.TH]		    INC	    A
;;;;;[1994.11.24.TH]		    STA	    !EXYSPD,X
;;;;;[1994.11.24.TH]TMKNXMV00F0	    EQU	    $
;;;;;[1994.11.24.TH]		    RTS
;;;;;
;
;****************************************************************
;*	tJR[X̐̉					*
;****************************************************************
CPSMKPTN	EQU	$
		HEX	0A, 09, 08, 07, 06, 05, 04, 03
		HEX	02, 01, 00, 00
;
CPSMKTIM	EQU	$
		HEX	04, 04, 03, 03, 02, 02, 01, 01
		HEX	01, 01, 01, 01
;
CPSMKYSN	EQU	$
		HEX	01, 01, 01, 01, 01, 01, 01, 01
		HEX	01, 01, FF, 01
;
CPSMKMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	!EXTIM0,X
		BNE	CPSMKMV00F0		; pattern change ? [no->CPSMKMV00F0]
;
		DEC	!EXWRK0,X
		BPL	CPSMKMV0080		; IH [no->CPSMKMV0080]
;
		JMP	EXCLEAR
;
CPSMKMV0080	EQU	$
;
		M8				; memory 8bit mode !!
;
		LDY	!EXWRK0,X
		LDA	CPSMKPTN,Y
		STA	!EXCHPT,X
		LDA	CPSMKTIM,Y
		STA	!EXTIM0,X
		LDA	CPSMKYSN,Y
		STA	!EXYUSN,X
;
		M16				; memory 16bit mode !!
;
CPSMKMV00F0	EQU	$
		RTS
;
;************************************************************************
;*		DˁinAu[Lj				*
;************************************************************************
DORO0_TMDT	EQU	$
; EXCHPT -->		 0  1  2  3  4	5  6  7	 8  9
		HEX	03,03,03,03,03,03,03,02,02
;
DORO0MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	DORO0MV_050	;pattern change ? ( no:DORO0MV_050 )
;
		DEC	EXCHPT,X
		BPL	DORO0MV_010	;end ? ( no:DORO0MV_050 )
		JMP	EXCLEAR
;
DORO0MV_010	EQU	$
		LDY	EXCHPT,X
		LDA	!DORO0_TMDT,Y	;p^[؂ւ^C}[Zbg
		AND	#00FFH
		STA	EXTIM0,X
;
DORO0MV_050	EQU	$
		RTS
;
;************************************************************************
;*		Dˁij						*
;************************************************************************
DORO1MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	DORO1MV_050	;pattern change ? ( no:DORO1MV_050 )
;
		DEC	EXCHPT,X
		BPL	DORO1MV_010	;end ? ( no:DORO1MV_050 )
		JMP	EXCLEAR
;
DORO1MV_010	EQU	$
		LDA	#03H		;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
DORO1MV_050	EQU	$
		RTS
;
;************************************************************************
;*		{Xp񐯂ɂȂ鎞́hL[h			*
;************************************************************************
BSQKRMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	BSQKRMV_050	;pattern change ? ( no:BSQKRMV_050 )
;
		DEC	EXCHPT,X
		BPL	BSQKRMV_010	;end ? ( no:BSQKRMV_050 )
		JMP	EXCLEAR
;
BSQKRMV_010	EQU	$
		LDA	#04H		;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
BSQKRMV_050	EQU	$
		RTS
;
;
;****************************************************************
;*	LL@						*
;****************************************************************
KIRA2MV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	!EXTIM0,X
		BNE	KIRA2MV0080		; pattern change ? [no->KIRA2MV0080]
;
		M8				; memory 8bit mode !!
;
		LDA	#01
		STA	!EXYUSN,X
;
		M16				; memory 16bit mode !!
;
		LDA	#04
		STA	!EXTIM0,X
		DEC	!EXCHPT,X
		BPL	KIRA2MV0080		; IH [no->KIRA2MV0080]
;
		LDA	#01
		STA	!EXCHPT,X
		LDA	!EXYPSL,X
		CLC
		ADC	#0008
		STA	!EXYPSL,X
;
KIRA2MV0080	EQU	$
		RTS
;
;
;************************************************************************
;*		ۂ񂽂𓥂񂾂Ƃ̔				*
;************************************************************************
PONBRTM		EQU	$
		HEX	03,03,02,02,02,01,01,01,02
;
PONBRMV		EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	PONBR020	;p^[؂ւH ( no:PONBR020 )
;
		DEC	EXCHPT,X
		BPL	PONBR010	;IH ( no:PONBR010 )
		JMP	EXCLEAR
;
PONBR010	EQU	$
		LDY	EXCHPT,X
		LDA	!PONBRTM,Y	;p^[؂ւ^C}[Zbg
		AND	#000FFH
		STA	EXTIM0,X

PONBR020	EQU	$

		RTS
;
;************************************************************************
;*		QQ[̈ݑ܂̈݉t̏łނ			*
;************************************************************************
IKSMKMV		EQU	$
		JSR	EXMDCK		;[h`FbN
;
		LDA	EXTIM0,X
		BNE	IKSMKMV_020	;p^[؂ւH ( no:IKSMKMV_020 )
;
		DEC	EXCHPT,X
		BPL	IKSMKMV_010	;IH ( no:IKSMKMV_010 )
		JMP	EXCLEAR
;
IKSMKMV_010	EQU	$
		LDA	#02H		;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
IKSMKMV_020	EQU	$
		RTS
;
;************************************************************************
;*		H							*
;************************************************************************
QAROWMV		EQU	$
		JSR	EX_TIMER	;mode check
		RTS
;
;************************************************************************
;*		NbpoN_					*
;************************************************************************
KPSMK_PTDT	EQU	$
; EXWRK0 -->		 0  1  2  3  4	5  6  7	 8  9  A  B  C	D  E  F 10 11
		BYTE	(0CH-1)*4,(0BH-1)*4,(0AH-1)*4,(09H-1)*4
		BYTE	(08H-1)*4,(07H-1)*4,0FFH,     (06H-1)*4
		BYTE	0FFH,	  (05H-1)*4,0FFH,     (04H-1)*4
		BYTE	0FFH,	  (03H-1)*4,0FFH,     (02H-1)*4
		BYTE	0FFH,	  (01H-1)*4
KPSMK_TMDT	EQU	$
		HEX	04,	  04,	    04,	      04
		HEX	04,	  04,	    02,	      02
		HEX	02,	  02,	    02,	      02
		HEX	02,	  02,	    02,	      02
		HEX	02
KPSMK_TMDT_E	EQU	$
KPSMK_P		EQU	KPSMK_TMDT_E-KPSMK_TMDT
;
KPSMKMV		EQU	$
;
;-------------- n`lZbg --------------------------------------------
		LDY	EXWRK0,X
		LDA	!KPSMK_PTDT-1,Y ;p^[mDZbg
		BMI	KPSMKMV_000	;\H ( no:KPSMKMV_000 )
;
		XBA
		ORA	EXWRK2,X
		AND	#00FFH
		STA	EXCHPT,X
;
		STX	<EWORK0		;(X) save
;
		TXA
		AND	#00FFH
		STA	R10		;(R10) <-- G̃CfbNX
		LDA	#BANK KPSMKC_ADRS
		STA	R0		;(R0)  <-- n`lZbgf[^AhX
		LDA	#KPSMKC_ADRS
		STA	R14		;(R14) <--		h
		M_CHIP	ENOAMSET_SP
		LDX	<EWORK0		;(X) load
;
		LDA	#4
		STA	R7		;(R7) <-- n`l
		LDA	EXXPSL,X
		STA	R1		;(R1) <-- wW
		LDA	EXYPSL,X
		STA	R2		;(R2) <-- xW
		LDA	EXWRKC,X
		STA	R3		;(R3) <-- wW
		LDA	EXOAML,X
		STA	R5		;(R5) <-- n`lCfbNX
		M_CHIP	KOOPA_3D_OAM
		LDX	<EWORK0
;
KPSMKMV_000	EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	KPSMKMV_050	;pattern change ? ( no:KPSMKMV_050 )
;
		DEC	EXWRK0,X
		BPL	KPSMKMV_010	;end ? ( no:KPSMKMV_050 )
		JMP	EXCLEAR
;
KPSMKMV_010	EQU	$
;
		M8
;
		LDY	EXWRK0,X
		LDA	!KPSMK_TMDT,Y	;p^[؂ւ^C}[Zbg
		STA	EXTIM0,X
;
		M16
;
KPSMKMV_050	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		n`lZbgf[^					-
;------------------------------------------------------------------------
KPSMKC_ADRS	EQU	$
		WORD	KPSMKC_1	;[0]
		WORD	KPSMKC_11
		WORD	KPSMKC_21
		WORD	KPSMKC_31
		WORD	KPSMKC_2	;[1]
		WORD	KPSMKC_12
		WORD	KPSMKC_22
		WORD	KPSMKC_32
		WORD	KPSMKC_3	;[2]
		WORD	KPSMKC_13
		WORD	KPSMKC_23
		WORD	KPSMKC_33
		WORD	KPSMKC_4	;[3]
		WORD	KPSMKC_14
		WORD	KPSMKC_24
		WORD	KPSMKC_34
		WORD	KPSMKC_5	;[4]
		WORD	KPSMKC_15
		WORD	KPSMKC_25
		WORD	KPSMKC_35
		WORD	KPSMKC_6	;[5]
		WORD	KPSMKC_16
		WORD	KPSMKC_26
		WORD	KPSMKC_36
		WORD	KPSMKC_7	;[6]
		WORD	KPSMKC_17
		WORD	KPSMKC_27
		WORD	KPSMKC_37
		WORD	KPSMKC_8	;[7]
		WORD	KPSMKC_18
		WORD	KPSMKC_28
		WORD	KPSMKC_38
		WORD	KPSMKC_9	;[8]
		WORD	KPSMKC_19
		WORD	KPSMKC_29
		WORD	KPSMKC_39
		WORD	KPSMKC_A	;[9]
		WORD	KPSMKC_1A
		WORD	KPSMKC_2A
		WORD	KPSMKC_3A
		WORD	KPSMKC_B	;[A]
		WORD	KPSMKC_1B
		WORD	KPSMKC_2B
		WORD	KPSMKC_3B
		WORD	KPSMKC_C	;[B]
		WORD	KPSMKC_1C
		WORD	KPSMKC_2C
		WORD	KPSMKC_3C
;
KPSMKC_1	BYTE	008H-0CH,008H-08H	;[01]
		HEX	42,C2,02
		BYTE	008H-0CH,0F8H-08H
		HEX	42,42,02
		BYTE	0F8H-0CH,008H-08H
		HEX	42,82,02
		BYTE	0F8H-0CH,0F8H-08H
		HEX	42,02,02
;
KPSMKC_2	BYTE	018H-0CH,004H-08H	;[02]
		HEX	42,C2,02
		BYTE	008H-0CH,004H-08H
		HEX	42,82,02
		BYTE	018H-0CH,0F4H-08H
		HEX	42,42,02
		BYTE	008H-0CH,0F4H-08H
		HEX	42,02,02
;
KPSMKC_3	BYTE	020H-0CH,010H-08H	;[03]
		HEX	42,C2,02
		BYTE	020H-0CH,000H-08H
		HEX	42,42,02
		BYTE	010H-0CH,010H-08H
		HEX	42,82,02
		BYTE	010H-0CH,000H-08H
		HEX	42,02,02
;
KPSMKC_4	BYTE	018H-0CH,01CH-08H	;[04]
		HEX	42,C2,02
		BYTE	008H-0CH,01CH-08H
		HEX	42,82,02
		BYTE	018H-0CH,00CH-08H
		HEX	42,42,02
		BYTE	008H-0CH,00CH-08H
		HEX	42,02,02
;
KPSMKC_5	BYTE	008H-0CH,018H-08H	;[05]
		HEX	42,C2,02
		BYTE	0F8H-0CH,018H-08H
		HEX	42,82,02
		BYTE	008H-0CH,008H-08H
		HEX	42,42,02
		BYTE	0F8H-0CH,008H-08H
		HEX	42,02,02
;
KPSMKC_6	BYTE	014H-0CH,010H-08H	;[06]
		HEX	42,C2,02
		BYTE	004H-0CH,010H-08H
		HEX	42,82,02
		BYTE	014H-0CH,000H-08H
		HEX	42,42,02
		BYTE	004H-0CH,000H-08H
		HEX	42,02,02
;
KPSMKC_7	BYTE	014H-0CH,00CH-08H	;[07]
		HEX	E3,06,02
		BYTE	008H-0CH,010H-08H
		HEX	E3,06,02
		BYTE	010H-0CH,004H-08H
		HEX	E3,06,02
		BYTE	004H-0CH,000H-08H
		HEX	E3,06,02
;
KPSMKC_8	BYTE	014H-0CH,00AH-08H	;[08]
		HEX	E3,06,02
		BYTE	008H-0CH,00EH-08H
		HEX	E3,06,02
		BYTE	010H-0CH,002H-08H
		HEX	E3,06,02
		BYTE	004H-0CH,0FEH-08H
		HEX	E5,06,02
;
KPSMKC_9	BYTE	014H-0CH,008H-08H	;[09]
		HEX	E5,06,02
		BYTE	008H-0CH,00CH-08H
		HEX	E3,06,02
		BYTE	010H-0CH,000H-08H
		HEX	E3,06,02
		BYTE	004H-0CH,0FCH-08H
		HEX	E7,06,02
;
KPSMKC_A	BYTE	014H-0CH,0F6H-08H	;[0A]
		HEX	E0,02,00
		BYTE	014H-0CH,006H-08H
		HEX	E7,06,02
		BYTE	008H-0CH,00AH-08H
		HEX	E3,06,02
		BYTE	010H-0CH,0FEH-08H
		HEX	E5,06,02
;
KPSMKC_B	BYTE	014H-0CH,0F4H-08H	;[0B]
		HEX	E0,02,00
		BYTE	014H-0CH,0ECH-08H
		HEX	E0,02,00
		BYTE	008H-0CH,008H-08H
		HEX	E5,06,02
		BYTE	010H-0CH,0FCH-08H
		HEX	E7,06,02
;
KPSMKC_C	BYTE	014H-0CH,0FEH-08H	;[0C]
		HEX	E0,02,00
		BYTE	014H-0CH,0F6H-08H
		HEX	E0,02,00
		BYTE	014H-0CH,0EEH-08H
		HEX	E0,02,00
		BYTE	008H-0CH,006H-08H
		HEX	E7,06,02
;
KPSMKC_10	BYTE	00CH-0CH,018H-08H	;[10]
		HEX	E0,02,00
		BYTE	00CH-0CH,010H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,008H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,000H-08H
		HEX	E0,02,00
;
KPSMKC_11	BYTE	00BH-0CH,00AH-08H	;[11]
		HEX	60,C3,02
		BYTE	00BH-0CH,0FAH-08H
		HEX	60,43,02
		BYTE	0FBH-0CH,00AH-08H
		HEX	60,83,02
		BYTE	0FBH-0CH,0FAH-08H
		HEX	60,03,02
;
KPSMKC_12	BYTE	017H-0CH,007H-08H	;[12]
		HEX	60,C3,02
		BYTE	007H-0CH,007H-08H
		HEX	60,83,02
		BYTE	017H-0CH,0F7H-08H
		HEX	60,43,02
		BYTE	007H-0CH,0F7H-08H
		HEX	60,03,02
;
KPSMKC_13	BYTE	01DH-0CH,010H-08H	;[13]
		HEX	60,C3,02
		BYTE	01DH-0CH,000H-08H
		HEX	60,43,02
		BYTE	00DH-0CH,010H-08H
		HEX	60,83,02
		BYTE	00DH-0CH,000H-08H
		HEX	60,03,02
;
KPSMKC_14	BYTE	017H-0CH,019H-08H	;[14]
		HEX	60,C3,02
		BYTE	007H-0CH,019H-08H
		HEX	60,83,02
		BYTE	017H-0CH,009H-08H
		HEX	60,43,02
		BYTE	007H-0CH,009H-08H
		HEX	60,03,02
;
KPSMKC_15	BYTE	00BH-0CH,016H-08H	;[15]
		HEX	60,C3,02
		BYTE	0FBH-0CH,016H-08H
		HEX	60,83,02
		BYTE	00BH-0CH,006H-08H
		HEX	60,43,02
		BYTE	0FBH-0CH,006H-08H
		HEX	60,03,02
;
KPSMKC_16	BYTE	014H-0CH,010H-08H	;[16]
		HEX	60,C3,02
		BYTE	004H-0CH,010H-08H
		HEX	60,83,02
		BYTE	014H-0CH,000H-08H
		HEX	60,43,02
		BYTE	004H-0CH,000H-08H
		HEX	60,03,02
;
KPSMKC_17	BYTE	012H-0CH,00BH-08H	;[17]
		HEX	63,07,02
		BYTE	009H-0CH,00EH-08H
		HEX	63,07,02
		BYTE	00FH-0CH,005H-08H
		HEX	63,07,02
		BYTE	006H-0CH,002H-08H
		HEX	63,07,02
;
KPSMKC_18	BYTE	012H-0CH,009H-08H	;[18]
		HEX	63,07,02
		BYTE	009H-0CH,00CH-08H
		HEX	63,07,02
		BYTE	00FH-0CH,003H-08H
		HEX	63,07,02
		BYTE	006H-0CH,000H-08H
		HEX	65,07,02
;
KPSMKC_19	BYTE	012H-0CH,008H-08H	;[19]
		HEX	65,07,02
		BYTE	009H-0CH,00BH-08H
		HEX	63,07,02
		BYTE	00FH-0CH,002H-08H
		HEX	63,07,02
		BYTE	006H-0CH,0FFH-08H
		HEX	67,07,02
;
KPSMKC_1A	BYTE	014H-0CH,0F8H-08H	;[1A]
		HEX	E0,02,00
		BYTE	012H-0CH,006H-08H
		HEX	67,07,02
		BYTE	009H-0CH,009H-08H
		HEX	63,07,02
		BYTE	00FH-0CH,000H-08H
		HEX	65,07,02
;
KPSMKC_1B	BYTE	014H-0CH,0EFH-08H	;[1B]
		HEX	E0,02,00
		BYTE	014H-0CH,0F7H-08H
		HEX	E0,02,00
		BYTE	009H-0CH,008H-08H
		HEX	65,07,02
		BYTE	00FH-0CH,0FFH-08H
		HEX	67,07,02
;
KPSMKC_1C	BYTE	014H-0CH,0EDH-08H	;[1C]
		HEX	E0,02,00
		BYTE	014H-0CH,0F5H-08H
		HEX	E0,02,00
		BYTE	014H-0CH,0FDH-08H
		HEX	E0,02,00
		BYTE	009H-0CH,005H-08H
		HEX	67,07,02
;
KPSMKC_20	BYTE	00CH-0CH,018H-08H	;[20]
		HEX	E0,02,00
		BYTE	00CH-0CH,010H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,008H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,000H-08H
		HEX	E0,02,00
;
KPSMKC_21	BYTE	00EH-0CH,00CH-08H	;[21]
		HEX	72,C3,00
		BYTE	00EH-0CH,004H-08H
		HEX	72,43,00
		BYTE	006H-0CH,00CH-08H
		HEX	72,83,00
		BYTE	006H-0CH,004H-08H
		HEX	72,03,00
;
KPSMKC_22	BYTE	016H-0CH,00AH-08H	;[22]
		HEX	72,C3,00
		BYTE	00EH-0CH,00AH-08H
		HEX	72,83,00
		BYTE	016H-0CH,002H-08H
		HEX	72,43,00
		BYTE	00EH-0CH,002H-08H
		HEX	72,03,00
;
KPSMKC_23	BYTE	01AH-0CH,010H-08H	;[23]
		HEX	72,C3,00
		BYTE	01AH-0CH,008H-08H
		HEX	72,43,00
		BYTE	012H-0CH,010H-08H
		HEX	72,83,00
		BYTE	012H-0CH,008H-08H
		HEX	72,03,00
;
KPSMKC_24	BYTE	016H-0CH,016H-08H	;[24]
		HEX	72,C3,00
		BYTE	00EH-0CH,016H-08H
		HEX	72,83,00
		BYTE	016H-0CH,00EH-08H
		HEX	72,43,00
		BYTE	00EH-0CH,00EH-08H
		HEX	72,03,00
;
KPSMKC_25	BYTE	00EH-0CH,014H-08H	;[25]
		HEX	72,C3,00
		BYTE	006H-0CH,014H-08H
		HEX	72,83,00
		BYTE	00EH-0CH,00CH-08H
		HEX	72,43,00
		BYTE	006H-0CH,00CH-08H
		HEX	72,03,00
;
KPSMKC_26	BYTE	014H-0CH,010H-08H	;[26]
		HEX	72,C3,00
		BYTE	00CH-0CH,010H-08H
		HEX	72,83,00
		BYTE	014H-0CH,008H-08H
		HEX	72,43,00
		BYTE	00CH-0CH,008H-08H
		HEX	72,03,00
;
KPSMKC_27	BYTE	00CH-0CH,008H-08H	;[27]
		HEX	69,07,00
		BYTE	012H-0CH,00AH-08H
		HEX	69,07,00
		BYTE	014H-0CH,00EH-08H
		HEX	69,07,00
		BYTE	00EH-0CH,010H-08H
		HEX	69,07,00
;
KPSMKC_28	BYTE	00CH-0CH,007H-08H	;[28]
		HEX	6A,07,00
		BYTE	012H-0CH,009H-08H
		HEX	69,07,00
		BYTE	014H-0CH,00DH-08H
		HEX	69,07,00
		BYTE	00EH-0CH,00FH-08H
		HEX	69,07,00
;
KPSMKC_29	BYTE	00CH-0CH,006H-08H	;[29]
		HEX	6B,07,00
		BYTE	012H-0CH,008H-08H
		HEX	69,07,00
		BYTE	014H-0CH,00CH-08H
		HEX	6A,07,00
		BYTE	00EH-0CH,00EH-08H
		HEX	69,07,00
;
KPSMKC_2A	BYTE	014H-0CH,0FFH-08H	;[2A]
		HEX	E0,02,00
		BYTE	012H-0CH,007H-08H
		HEX	6A,07,00
		BYTE	014H-0CH,00BH-08H
		HEX	6B,07,00
		BYTE	00EH-0CH,00DH-08H
		HEX	69,07,00
;
KPSMKC_2B	BYTE	014H-0CH,0F6H-08H	;[2B]
		HEX	E0,02,00
		BYTE	014H-0CH,0FEH-08H
		HEX	E0,02,00
		BYTE	012H-0CH,006H-08H
		HEX	6B,07,00
		BYTE	00EH-0CH,00CH-08H
		HEX	6A,07,00
;
KPSMKC_2C	BYTE	014H-0CH,0EDH-08H	;[1C]
		HEX	E0,02,00
		BYTE	014H-0CH,0F5H-08H
		HEX	E0,02,00
		BYTE	014H-0CH,003H-08H	;[2C]
		HEX	E0,02,00
		BYTE	00EH-0CH,00BH-08H
		HEX	6B,07,00
;
KPSMKC_30	BYTE	00CH-0CH,018H-08H	;[30]
		HEX	E0,02,00
		BYTE	00CH-0CH,010H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,008H-08H
		HEX	E0,02,00
		BYTE	00CH-0CH,000H-08H
		HEX	E0,02,00
;
KPSMKC_31	BYTE	011H-0CH,00EH-08H	;[31]
		HEX	62,C3,00
		BYTE	011H-0CH,006H-08H
		HEX	62,43,00
		BYTE	009H-0CH,00EH-08H
		HEX	62,83,00
		BYTE	009H-0CH,006H-08H
		HEX	62,03,00
;
KPSMKC_32	BYTE	017H-0CH,005H-08H	;[32]
		HEX	62,43,00
		BYTE	017H-0CH,00DH-08H
		HEX	62,C3,00
		BYTE	00FH-0CH,00DH-08H
		HEX	62,83,00
		BYTE	00FH-0CH,005H-08H
		HEX	62,03,00
;
KPSMKC_33	BYTE	017H-0CH,008H-08H	;[33]
		HEX	62,43,00
		BYTE	017H-0CH,010H-08H
		HEX	62,C3,00
		BYTE	00FH-0CH,010H-08H
		HEX	62,83,00
		BYTE	00FH-0CH,008H-08H
		HEX	62,03,00
;
KPSMKC_34	BYTE	00FH-0CH,013H-08H	;[34]
		HEX	62,83,00
		BYTE	017H-0CH,00BH-08H
		HEX	62,43,00
		BYTE	017H-0CH,013H-08H
		HEX	62,C3,00
		BYTE	00FH-0CH,00BH-08H
		HEX	62,03,00
;
KPSMKC_35	BYTE	010H-0CH,012H-08H	;[35]
		HEX	62,C3,00
		BYTE	010H-0CH,00AH-08H
		HEX	62,43,00
		BYTE	008H-0CH,012H-08H
		HEX	62,83,00
		BYTE	008H-0CH,00AH-08H
		HEX	62,03,00
;
KPSMKC_36	BYTE	014H-0CH,008H-08H	;[36]
		HEX	62,43,00
		BYTE	014H-0CH,010H-08H
		HEX	62,C3,00
		BYTE	00CH-0CH,010H-08H
		HEX	62,83,00
		BYTE	00CH-0CH,008H-08H
		HEX	62,03,00
;
KPSMKC_37	BYTE	011H-0CH,00BH-08H	;[37]
		HEX	79,07,00
		BYTE	012H-0CH,00DH-08H
		HEX	79,07,00
		BYTE	00FH-0CH,00EH-08H
		HEX	79,07,00
		BYTE	00EH-0CH,00AH-08H
		HEX	79,07,00
;
KPSMKC_38	BYTE	011H-0CH,00AH-08H	;[38]
		HEX	79,07,00
		BYTE	012H-0CH,00CH-08H
		HEX	79,07,00
		BYTE	00FH-0CH,00DH-08H
		HEX	79,07,00
		BYTE	00EH-0CH,009H-08H
		HEX	7A,07,00
;
KPSMKC_39	BYTE	011H-0CH,00AH-08H	;[39]
		HEX	79,07,00
		BYTE	012H-0CH,00CH-08H
		HEX	7A,07,00
		BYTE	00FH-0CH,00DH-08H
		HEX	79,07,00
		BYTE	00EH-0CH,009H-08H
		HEX	7B,07,00
;
KPSMKC_3A	BYTE	014H-0CH,001H-08H	;[3A]
		HEX	E0,02,00
		BYTE	011H-0CH,009H-08H
		HEX	7A,07,00
		BYTE	012H-0CH,00BH-08H
		HEX	7B,07,00
		BYTE	00FH-0CH,00CH-08H
		HEX	79,07,00
;
KPSMKC_3B	BYTE	014H-0CH,0F9H-08H	;[3B]
		HEX	E0,02,00
		BYTE	014H-0CH,001H-08H
		HEX	E0,02,00
		BYTE	011H-0CH,009H-08H
		HEX	7B,07,00
		BYTE	00FH-0CH,00CH-08H
		HEX	7A,07,00
;
KPSMKC_3C	BYTE	014H-0CH,0F3H-08H	;[3C]
		HEX	E0,02,00
		BYTE	014H-0CH,0FBH-08H
		HEX	E0,02,00
		BYTE	014H-0CH,003H-08H
		HEX	E0,02,00
		BYTE	00FH-0CH,00BH-08H
		HEX	7B,07,00
;
KPSMKC_E	EQU	$
;
;************************************************************************
;*		Nbpt@C[^[Qbg				*
;************************************************************************
KPF_PMV		EQU	$
		LDA	EXOAML,X
		BMI	KPF_PMV_0100	;n`lZbgnjH ( no:KPF_PMV_0100 )
;
		I16
;
		TAY			;(Y) <-- n`lCfbNX
;
		LDA	EXWRK0,X
		STA	<EWORK0		;(EWK0,1) <-- ^[QbgTCY
		LDA	SOAM_DX+(8*0),Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*0),Y
		LDA	SOAM_DX+(8*0)+2,Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*0)+2,Y
		LDA	SOAM_DX+(8*1),Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*1),Y
		LDA	SOAM_DX+(8*1)+2,Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*1)+2,Y
		LDA	SOAM_DX+(8*2),Y
		SEC
		SBC	<EWORK0
		STA	SOAM_DX+(8*2),Y
		LDA	SOAM_DX+(8*2)+2,Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*2)+2,Y
		LDA	SOAM_DX+(8*3),Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*3),Y
		LDA	SOAM_DX+(8*3)+2,Y
		CLC
		ADC	<EWORK0
		STA	SOAM_DX+(8*3)+2,Y
;
		I8
;
KPF_PMV_0100	EQU	$
		JSR	EXMDCK		;mode check
;
		LDA	EXTIM0,X
		BNE	KPF_PMV_0150	;end ? ( no:KPF_PMV_0150 )
		JMP	EXCLEAR
;
KPF_PMV_0150	EQU	$
		RTS
;
;
;
;
;
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;****************************************************************
;
		END
;
