;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: RAM program					*
;*	file name	: ys_rpro					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_color.h
		include		ys_ename.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	RPRO_ROM
		GLB	IRQSUB,NMISUB,CHIPON,CHIPON1,MPCHIPON,CHIPON_RAM_READ
		GLB	CHIPON_SPECIAL,CHIPON_C
		GLB	BGSCWTL,VMADSPL,NEWVMADL,OBJDMA,BGCDMA_L
		GLB	COURSE_IN_DM,INCSMSG,INCSMSG_100
		GLB	SFC_BGCLR_4_L,BLUE_COIN_ST_SB
;
		GLB	FADINTM
;
;-------------- BG write data table no, ---------------------------------
		GLB	VTCL,MTCL,B3CL,GLB1CL,BG1DT,HLCL,DMCL,ENCL
		GLB	GLB3CL,WNCL,HF_DT,B3WRCL
;
		GLB	MWIN,MLOS
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VCLDAT
		EXT	OAMDXCLR,JSRSUB,JSLSUB,SOUND_3_ON
		EXT	DMA_D_M,DMA_M_M
;
		EXT	MINPL,GMIN,HMPIN
;
;-------------< ys_rpro >------------------------------------------------
		EXT	COS,SIN
;
;-------------< ys_map >-------------------------------------------------
		EXT	MPROGOCLR,MPHLDRCLR
;
;-------------< ys_game >------------------------------------------------
		EXT	BG3SCRCLR,BG3WANCLR,BG3WTRCLR
		EXT	GLBG1SCRCLR,GOAL_B1SCRDAT,EGG_SAVE
		EXT	DWNMOJI_DAT,GLBG3SCRCLR
		EXT	HALF_MSG_DAT,Pause_move
;
;-------------< ys_play >------------------------------------------------
		EXT	PLAYER,PLCSET
		EXT	TIMEUP_SET_S,TONNEL_INOUT_IN
		EXT	ECHNG
		EXT	PYGN
		EXT	PFLP
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENCLEAR,ENCLEAR_NORETN,ENINSR
		EXT	ENEMY_IN,ENCSET,EGGKILL,PL_1UP_SET,PLFLST_S
		EXT	EX_COIN_SET_2,EX_COIN_SET_3
;
		EXT	EGG00,COIN1
;
;-------------< ys_enmy2 >-----------------------------------------------
		EXT	TO_PLDOWN
		EXT	COIN1_GET
;
;-------------< ys_enmy3 >-----------------------------------------------
		EXT	GO_NEXTGOTO
;
;-------------< ys_enmy6 >-----------------------------------------------
		EXT	FLOWER_GET
;
;-------------< ys_enmy9 >-----------------------------------------------
		EXT	COINR_GET
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXINSR
		EXT	FLKIR
;
;-------------< ys_demo >------------------------------------------------
		EXT	DM_01_SCRCLR
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	UNITCHG
		EXT	BGCG,BLK0,DWCG,TGTM,CNCL
;
;-------------< ys_mapdt >-----------------------------------------------
		EXT	INT_STAT,MOJI_DAT
;
;-------------< ys_unit >------------------------------------------------
		EXT	UNDATA
;
;-------------< ys_mini1 >-----------------------------------------------
		EXT	WINVRMD,LOSVRMD
;
;-------------< ys_ending >----------------------------------------------
		EXT	END_BITMAP_CLR
;
;-------------< ys_msgdt >-----------------------------------------------
		EXT	MOJI_DAT
;
;-------------< ys_msgdt_f >---------------------------------------------
		EXT	MOJI_DAT_F
;
;-------------< ys_msgdt_g >---------------------------------------------
		EXT	MOJI_DAT_G
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_R		GROUP	Ram_pro
Ram_pro		SECT	REL
;
;************************************************************************
;*		RAM program						*
;************************************************************************
RPRO_ROM	EQU	$
;
;
;************************************************************************
;*		NMI							*
;************************************************************************
;
NMISUB		EQU	$+7E0000H
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
		LDA	#00000H
		TCD
;
		MI8
;
		PHA			;(DBR) <-- 00H
		PLB
;
		LDY	4210H		;NMI reset
;
;-------------- mlh[`ZNg ----------------------------------
		LDX	NMITYP
		JSR	(!NMISEL,X)
;
;-------------- TEhtO`FbN ----------------------------------
		LDA	<SOUND_0
		BNE	NMISUB_010	;sound "ON" ? ( yes:NMISUB_010 )
		LDX	2140H
		CPX	<SOUND_0_CK
		BNE	NMISUB_020	;transfer ok ? ( no:NMISUB_020 )
NMISUB_010	EQU	$
		STA	2140H		;sound port set !!
		STA	<SOUND_0_CK	;port set data save !!
		STZ	<SOUND_0
NMISUB_020	EQU	$
		LDA	<SOUND_1
		STA	2141H		;sound port set !!
		STZ	<SOUND_1
;
		LDA	2143H
		CMP	<SOUND_3_CK
		BNE	NMISUB_050	;tOZbgnjH ( no:NMISUB_050 )
;
		LDY	<SOUND_3
		BEQ	NMISUB_030	;DrdH ( no:NMISUB_030 )
;
		CMP	<SOUND_3
		BEQ	NMISUB_032	;tOZbgH ( yes:NMISUB_032 )
		STZ	<SOUND_3
		BRA	NMISUB_040

NMISUB_030	EQU	$
		LDX	<SOUND_3_P
		BEQ	NMISUB_040	;rdZbgH ( no:NMISUB_040 )
;
		CMP	<SOUND_3_BF
		BNE	NMISUB_034	;tOZbgH ( no:NMISUB_034 )
NMISUB_032	EQU	$
		LDY	#0
		BRA	NMISUB_040
;
NMISUB_034	EQU	$
		DEX
		CPX	#7
		BCC	NMISUB_036
		LDX	#7-1
NMISUB_036	EQU	$
		STX	<SOUND_3_P
		LDY	<SOUND_3_BF
		LDX	#0
NMISUB_038	EQU	$
		LDA	<SOUND_3_BF+1,X
		STA	<SOUND_3_BF,X
		INX
		CPX	<SOUND_3_P
		BCC	NMISUB_038
NMISUB_040	EQU	$
		STY	2143H
		STY	<SOUND_3_CK
;
NMISUB_050	EQU	$
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		RTI
;
		MEM8
		IDX8
;
;-------------- NMI program address table -----------------------
NMISEL		EQU	$		;[NMITYP]
		WORD	NMI000		;[0]  normal
		WORD	NMI100		;[2]  game( normal )
		WORD	NMI200		;[4]  game( offset )
		WORD	NMI300		;[6]  map
		WORD	NMI400		;[8]  ~[WJ
		WORD	NMI500		;[A]  game( mode 7 )
		WORD	NMI600		;[C]  XN[}bv
		WORD	NMI700		;[E]  {[iXXe[W
;
;
;************************************************************************
;*		NMI ( normal )						*
;************************************************************************
;
NMI000		EQU	$
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDA	NMIFLG
		BNE	NMI0010		;timer over ? ( no:NMI0010 )
		JMP	NMI0020
;
NMI0010		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		JSR	OB7DMA		;Y[naiL]
;
		LDA	#0000H		;0 page set ( 0000H- )
		TCD
;
;
		DPAGE	WORK
;
;
		M8
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
;-------------- PPU Reg. set ------------------------------------
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;work BG1 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
NMI0020		EQU	$
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
		RTS
;
;************************************************************************
;*		NMI ( game( normal ) )					*
;************************************************************************
;
NMI100		EQU	$
;;;;		    RTS
;
;************************************************************************
;*		NMI ( game( offset ) )					*
;************************************************************************
;
NMI200		EQU	$
;;;;		    RTS
;
;************************************************************************
;*		NMI ( game( mode 7 ) )					*
;************************************************************************
;
NMI500		EQU	$
;;;;		    RTS
;
;************************************************************************
;*		NMI ( ~[WJ )					*
;************************************************************************
;
NMI400		EQU	$
;;;;		RTS
;
;************************************************************************
;*		NMI ( {[iXXe[W )				*
;************************************************************************
;
NMI700		EQU	$
		RTS
;
;************************************************************************
;*		NMI ( XN[}bv )				*
;************************************************************************
;
NMI600		EQU	$
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
;-------------- constant color set ------------------------------
		LDA	!WIND30
		STA	2130H
		LDA	MPFADB
		ORA	#10000000B
		STA	2132H		;[blue]
		LDA	MPFADG
		ORA	#01000000B
		STA	2132H		;[green]
		LDA	MPFADR
		ORA	#00100000B
		STA	2132H		;[red]
;
		LDA	NMIFLG
		BNE	NMI6010		;timer over ? ( no:NMI6010 )
		JMP	NMI6020
;
NMI6010		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	OBJDMA		;OBJ DMA set
		JSR	CGDMA		;color DMA set
;
		LDA	#0000H		;0 page set ( 0000H- )
		TCD
;
;
		DPAGE	WORK
;
;
		LDA	<SCCH1
		STA	>MPHDMA1+1
		LDA	<SCCV1
		STA	>MPHDMA1+3
		LDA	<MPSCH1
		STA	>MPHDMA1+6
		LDA	<MPSCV1
		STA	>MPHDMA1+8
;
		LDA	<SCCH2
		STA	>MPHDMA2+1
		LDA	<SCCV2
		STA	>MPHDMA2+3
		LDA	<MPSCH2
		STA	>MPHDMA2+6
		LDA	<MPSCV2
		STA	>MPHDMA2+8
;
		LDA	!MKMN_CLS
		STA	>MPHDMABF51
;
		M8
;
		LDA	!SUBADF
		STA	>MPHDMA6+3
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
;-------------- PPU Reg. set ------------------------------------
		LDA	!WMANSL		;window main select set
		STA	212EH
		LDA	!WIND25		;OBJ window "ON/OFF" set
		STA	2125H
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;work BG1 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
NMI6020		EQU	$
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
		RTS
;
;************************************************************************
;*		NMI ( map )						*
;************************************************************************
;
;-------------- bitmap chara DMA dara -----------------------------------
MPDMAVAD	EQU	($-1*4)+7E0000H
; MPBANK -->		 [0]   [1]			;[MPDMAFG]
		WORD	4000H,6000H			;[1]
		WORD	4700H,6700H			;[2]
		WORD	5180H,7180H			;[3]
MPDMABAD	EQU	($-1*4)+7E0000H
		WORD	MPDMABF,MPDMABF			;[1]
		WORD	MPDMABF+0E00H,MPDMABF+0E00H	;[2]
		WORD	MPDMABF+2300H,MPDMABF+2300H	;[3]
MPDMABYT	EQU	($-1*4)+7E0000H
		WORD	0E00H,0E00H			;[1]
		WORD	1500H,1500H			;[2]
		WORD	1500H,1500H			;[3]
MPOBJBNK	EQU	$+7E0000H
		BYTE	01100011B,01100010B
;
;-------------- map fade in/out data ------------------------------------
FADECINC	EQU	$		;[FADMK]
		BYTE	00111111B	;[0]
		BYTE	10111111B	;[1]
;
FADINTM		EQU	$
;			B  G  R
		HEX	00,50,28,0	;[0]
		HEX	00,00,00,0	;[1]
;
FADTD		EQU	$
		HEX	01,00,01,0	;[0]
		HEX	01,00,00,0	;[1]
;
FADAD		EQU	$
		HEX	FF,FF,FF,0	;[0]
		HEX	01,01,01,0	;[1]
;
NMI300		EQU	$
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDA	!PL_FRASH_FG
		BEQ	NMI300_50
		STA	<SOUND_1
;
;-------------- constant color set ------------------------------
NMI300_50	EQU	$
		LDA	SUBADF		;sub & add flag set
		STA	2131H
		LDA	MPFADB
		ORA	#10000000B
		STA	2132H		;[blue]
		LDA	MPFADG
		ORA	#01000000B
		STA	2132H		;[green]
		LDA	MPFADR
		ORA	#00100000B
		STA	2132H		;[red]
;
;-------------- NMI counter set ---------------------------------
;
		M16
;
		INC	NMICONT
;
		LDY	#10000000B		;inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDY	#00000001B		;(Y) <-- DMA "ON" flag
;
		M8
;
;-------------- bitmap chara DMA --------------------------------
		LDA	MPDMAFG
		BEQ	NMI0320		;bitmap chara DMA ? ( no:NMI0320 )
;
		ASL	A
		ORA	MPBANK
		ASL	A
		TAX
;
		M16
;
;;;;		LDY	#10000000B		;inc mode set
;;;;		STY	2115H
		LDA	>MPDMAVAD,X		;VRAM address set
		STA	2116H
;;;;		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
;;;;		STA	4300H
		LDA	>MPDMABAD,X		;A bus address(L,H) set
		STA	4302H
		LDA	>MPDMABYT,X		;number of byte ser
		STA	4305H
		LDX	#BANK MPDMABF		;	"     (B) set
		STX	4304H
;;;;		LDY	#00000001B		;DMA "ON" !!
		STY	420BH
;
		M8
;
		DEC	MPDMAFG
		BNE	NMI0330		;bitmap chara DMA end ? ( no:NMI0330 )
;
;-------------- normal NMI ----------------------------------------------
NMI0320		EQU	$
		LDA	NMIFLG
		BNE	NMI0340		;time over ? ( no:NMI0340 )
;
NMI0330		EQU	$
		JMP	NMI0360
;
NMI0340		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
;;;;		LDA	NMICONT
;;;;		STZ	NMICONT
;
		LDA	MPWDMAFG
		STZ	MPWDMAFG
		STA	MPDMAFG		;bitmap chara DMA flag "ON" !!
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
;
		M16
;
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	OBJDMA		;OBJ DMA set
		JSR	CGDMA		;C.G DMA set
;
;-------------- mode 7 parameter H-DMA buffer transfer ----------
NMI0348		EQU	$
		LDA	#MPHDMABF0	;to address set
		STA	2181H
		LDY	#BANK MPHDMABF0
		STY	2183H
		LDA	#00000000B+(80H*100H)
		STA	<4300H		;DMA parameter & B bus address set
		LDA	#MPHDMAB0
		STA	<4302H		;from address(L,H) set
		LDY	#BANK MPHDMAB0
		STY	<4304H		;      "     (B) set
		LDA	#(70H*2)*4
		STA	<4305H		;number of byte set
		STX	<420BH		;DMA "ON"
;
		LDA	#0000H		;0 page set ( 0000H- )
		TCD
;
;
		DPAGE	WORK
;
		M8
;
;-------------- PPU Reg. set ------------------------------------
		LDY	MPBANK		;OBJ chara bank set
		LDA	!MPOBJBNK,Y
		STA	2101H
;
		LDA	WMANSL		;window main select set
		STA	212EH
		LDA	WIND25		;OBJ window "ON/OFF" set
		STA	2125H
;
;-------------- scroll counter set ------------------------------
NMI0350		EQU	$
		LDA	<SCCH1		;mode 7 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	CENTX		;center pos set
		STA	211FH
		LDA	CENTX+1
		STA	211FH
		LDA	CENTY
		STA	2120H
		LDA	CENTY+1
		STA	2120H
;
		LDA	<SCCH2		;mode 0 BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
;
NMI0360		EQU	$
;
;-------------- BG3,4 scroll counter set ------------------------
;
		M16
;
		LDA	<SCCH3		;mode 0 BG4 scroll counter set
		CLC
		ADC	MPBG3SP
		STA	<SCCH3
		LSR	A
		STA	MPSCH47		;1/2
		LSR	A
		LSR	A
		LSR	A
		STA	MPSCH40
		ADC	MPSCH47
		STA	MPSCH46		;9/16 <-- 1/2 + 1/16
		ADC	MPSCH40
		STA	MPSCH45		;10/16 <-- 9/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH44		;11/16 <-- 10/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH43		;12/16 <-- 11/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH42		;13/16 <-- 12/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH41		;14/16 <-- 13/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH40		;15/16 <-- 14/16 + 1/16
;
		M8
;
;-------------- PPU Reg. set ------------------------------------
		LDA	BG1SCF		;BG1 screen base set
		STA	2107H
		LDA	BG2SCF		;BG2	    "
		STA	2108H
;
;-------------- H-DMA buffer set --------------------------------
		LDA	BGMODE		;BG mode set
		STA	>HDMADB0+1
		LDA	MANSEL		;main select set
		STA	>HDMADB1+1
;
;-------------- wiaf̂g|cl`f[^Zbg ----------------
		LDA	MP_BG3_BBUS	;B bus address set
		STA	4311H
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
;-------------- V-blank process end -----------------------------
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
;
;-------------- fade in/out check -------------------------------
		LDA	MPFADFG
		BEQ	NMI03130	;fade ? ( no:NMI03130 )
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
		PHB			;(DBR) save
 ENDIF	  ;**** PAL Ή [1995/08/03] *****************************

		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDY	!FADMK
;
		LDX	!FADECINC,Y
		STX	SUBADF		;constant color sub & add set
;
		TYA
		ASL	A
		ASL	A
		TAY			;(X) <-- color add data start pointer
;
		LDX	#(3-1)*2
NMI0370		EQU	$
		DEC	MPFADRTM,X
		BPL	NMI03100	;color change timming ? ( no:NMI03100 )
;
		LDA	!FADTD,Y
		STA	MPFADRTM,X	;timer set
		LDA	MPFADR,X
		CLC
		ADC	!FADAD,Y
		BPL	NMI0380
		LDA	#00
NMI0380		EQU	$
		CMP	#01FH
		BCC	NMI0390
		LDA	#01FH
NMI0390		EQU	$
		STA	MPFADR,X
NMI03100	EQU	$
		INY
		DEX
		DEX
		BPL	NMI0370
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
		PLB
 ENDIF	  ;**** PAL Ή [1995/08/03] *****************************

NMI03130	EQU	$
		RTS
;
;************************************************************************
;*		IRQ							*
;************************************************************************
IRQSUB		EQU	$+7E0000H
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
;
		LDA	#0000H
		TCD
;
		MI8
;
		PHA			;(DBR) <-- 00H
		PLB
;
		LDA	4211H
;
		LDX	IRQTYP
		JSR	(!IRQSEL,X)
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		CLI
		RTI
;
		MEM8
		IDX8
;
;-------------- IRQ program address table -----------------------
IRQSEL		EQU	$		;[IRQTYP]
		WORD	IRQ000		;[0] game ( initial )
		WORD	IRQ100		;[2] ~[WJ
		WORD	IRQ200		;[4] GfBOQTUJ[rbg}bv
		WORD	IRQ300		;[6] {[iXXe[W
;
;
;************************************************************************
;*		IRQ ( game( initial ) )					*
;************************************************************************
;
IRQ000		EQU	$
		LDA	IRQFLG
		BNE	IRQ010		;H-DMA "ON" IRQ ? ( no:IRQ010 )
;
;-------------- H-DMA "ON" IRQ ------------------------------------------
IRQ0002		EQU	$
		BIT	4212H
		BVS	IRQ0002
IRQ0004		EQU	$
		BIT	4212H
		BVC	IRQ0004
;
 IF  JPN | NES ;**** { or NES Ή [1995/6/30] ****************
		LDA	HD420C
 ELSE	       ;**** PAL Ή [1995/7/24] ************************
		LDA	NMI_HD420C
 ENDIF
		STA	420CH		;H-DMA "ON"
		STZ	2100H		;fade "OFF"
;
;-------------- blanking "OFF" IRQ timer set --------------------
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#08H		;V counter set
IRQ022		EQU	$
		INC	IRQFLG
;
IRQ_TIMER_SET	EQU	$
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
RTSSUB		EQU	$
		RTS
;
IRQ010		EQU	$
		DEC	A
		BNE	IRQ030		;blanking "OFF" IRQ ? ( no:IRQ030 )
;
;-------------- blanking "OFF" IRQ --------------------------------------
IRQ0102		EQU	$
		BIT	4212H
		BVS	IRQ0102
IRQ0104		EQU	$
		BIT	4212H
		BVC	IRQ0104
;
 IF  JPN | NES ;**** { or NES Ή [1995/6/30] ****************
		LDA	FADNO		;fade in
 ELSE	       ;**** PAL Ή [1995/7/24] ************************
		LDA	NMI_FADNO	    ;fade in
 ENDIF
		STA	2100H
;
;-------------- NMI-IRQ timer set -------------------------------
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
;
		LDX	NMI_PROG_NO
		BNE	IRQ012		;񏈗H ( yes:IRQ012 )
		JMP	IRQ022
;
IRQ012		EQU	$
		JSR	IRQ022
;
		JMP	(!NMI_PROG_SEL,X)
;
;------------------------------------------------------------------------
;-		NMI-IRQ							-
;------------------------------------------------------------------------
IRQ030		EQU	$
		BIT	4212H
		BVS	IRQ030
IRQ0304		EQU	$
		BIT	4212H
		BVC	IRQ0304
;
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDX	NMITYP
		JMP	(!IRQ_NMI_SEL,X)
;
;-------------- NMI program address table -----------------------
IRQ_NMI_SEL	EQU	$		;[NMITYP]
		WORD	RTSSUB		;[0]  normal ( dummy )
		WORD	IRQ_NMI_00	;[2]  game( normal )
		WORD	IRQ_NMI_01	;[4]  game( offset )
		WORD	RTSSUB		;[6]  map ( dummy )
		WORD	IRQ_NMI_04	;[8]  ~[WJ
		WORD	IRQ_NMI_05	;[A]  game( mode 7 )
		WORD	RTSSUB		;[C]  XN[
		WORD	RTSSUB		;[E]  {[iXXe[W
;
;----------------------------------------------------------------
;-		game( normal )					-
;----------------------------------------------------------------
IRQ_NMI_00	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0010	;time over ? ( no:IRQ_NMI_0010 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0010	EQU	$
;
;-------------- BG1 scroll counter set --------------------------
;
		M16
;
		LDA	<SCCV1		;BG1 scroll counter_V set
		CLC
		ADC	TILTAL
		STA	NMISCV1		;NMI set scroll counter_V set
		LDA	<SCCH1		;NMI set scroll counter_H set
IRQ_NMI_SUB	EQU	$
		STA	NMISCH1
;
		M8
;
		STA	210EH
		XBA
		STA	210EH
;
 IF  PAL  ;**** PAL Ή [1995/7/24] *****************************
		LDA	HD420C
		STA	NMI_HD420C	;NMI set H-DMA flag
		LDA	FADNO
		STA	NMI_FADNO	;NMI set contrast flag
 ENDIF	  ;**** PAL Ή [1995/7/24] *****************************
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		PHD			;(D) save
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		LDY	GMPAUSE
		BEQ	IRQ_NMI_0030	;game pause ? ( no:IRQ_NMI_0030 )
;
;-------------- game pause DMA set ----------------------
		CPY	#Pause_move
		BCC	IRQ_NMI_0030	;pause chara DMA timming ? ( no:IRQ_NMI_0030 )
;;;;K;;;;		BCC	IRQ_NMI_0050	;pause chara DMA timming ? ( no:IRQ_NMI_0050 )
;
;-------------- pause chara DMA set ---------------------
		LDA	#4E00H
		STA	2116H		;VRAM address set
		LDA	#WOB7CHR+(80H*20H)
		STA	<4302H		;A bus address(L,H) set
		LDY	#BANK WOB7CHR
		STY	<4304H		;	"       (B)
		LDA	#(16*6)*20H
		STA	<4305H		;number of byte set
		STX	<420BH		;DMA "ON" !!
		BRA	IRQ_NMI_0050
;
;-------------- game play DMA set -----------------------
IRQ_NMI_0030	EQU	$
		JSR	PCHDMA		;player chara DMA set
		JSR	BGCDMA		;BG chara DMA set
		JSR	OB7DMA		;OBJ mode 7 chara DMA set
;
		LDY	MSGTRF
		BEQ	IRQ_NMI_0040	;massage bitmap transfer ? ( no:IRQ_NMI_0040 )
;
		JSR	MSGDMA		;massage bitmap DMA set
		STZ	MSGTRF		;	"       transfer flag clear !!
;
IRQ_NMI_0040	EQU	$
		JSR	BGSCWT		;BG screen write
		JSR	SP_VRAM_ST
;
IRQ_NMI_0050	EQU	$
		PLD			;(D) load
;
;
		DPAGE	WORK
;
;
;-------------- Of[VJ[XN[Zbg ------------
		LDY	!GRDTN_FLG	; XyV Of[V nm ?
		BNE	IRQ_NMI_0055	;	YES -> IRQ_NMI_0055
;
		LDY	NUKINO
		CPY	#10H
		BCC	IRQ_NMI_0060	;Of[VJ[XN[H ( no:IRQ_NMI_0060 )
;
IRQ_NMI_0055	EQU	$
		LDA	NUKCOL_SCRL_B
		STA	>HDMAPR4+1
		CLC
		ADC	#069H
		STA	>HDMAPR4+4
		LDA	NUKCOL_SCRL_RG
		STA	>HDMAPR3+1
		CLC
		ADC	#069H*2
		STA	>HDMAPR3+4
IRQ_NMI_0060	EQU	$
;
		M8
;
;-------------- scroll counter set ------------------------------
		LDA	NMISCH1		;BG1 scroll counter set
		STA	210DH
		LDA	NMISCH1+1
		STA	210DH
		LDA	NMISCV1
		STA	210EH
		LDA	NMISCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
IRQ_NMI_ON	EQU	$
;
		M16			; memory 16bit mode
		LDA	#2100H
		TCD
;
		DPAGE	2100H
;
;-------------- PPU Reg. set ------------------------------------
		LDA	MANSEL		;main & sub select set
		STA	<212CH
		LDA	WMANSL		;window main & sub select set
		STA	<212EH
		LDA	BG12CH		;BG1,2,3,4 character base address set
		STA	<210BH
		LDA	BG1SCF		;BG1,2 screen base address set
		STA	<2107H
		LDA	WIND23		;window "ON/OFF" set
		STA	<2123H
		LDA	WIND30		;color window "ON/OFF" & main & sub add set
		STA	<2130H
		LDA	WLOGIC		;window logic set
		STA	<212AH
;
		M8			; memory 8bit mode
;
		LDA	BG3SCF		;BG3 screen base address set
		STA	<2109H
		LDA	BGMODE		;BG mode set
		STA	<2105H
		LDA	MOZNO		;mozaiku set
		STA	<2106H
		LDA	WIND25
		STA	<2125H
;
;-------------- H-DMA initial start set -------------------------
;
		M16
;
		LDA	#4300H
		TCD
;
;
		DPAGE	4300H
;
;
		LDA	<4312H		 ;H-DMA start table address set
		STA	<4318H
		LDA	<4322H
		STA	<4328H
		LDA	<4332H
		STA	<4338H
		LDA	<4342H
		STA	<4348H
		LDA	<4352H
		STA	<4358H
		LDA	<4362H
		STA	<4368H
		LDA	<4372H
		STA	<4378H
;
		M8
;
		LDA	#01H		;start line counter set
		STA	<431AH
		STA	<432AH
		STA	<433AH
		STA	<434AH
		STA	<435AH
		STA	<436AH
		STA	<437AH
;
		STZ	IRQFLG
;
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#006H		;V counter set
		JMP	IRQ_TIMER_SET
;
;
		DPAGE	WORK
;
;
;----------------------------------------------------------------
;-		game( offset )					-
;----------------------------------------------------------------
IRQ_NMI_01	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0110	;timer over ? ( no:IRQ_NMI_0110 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0110	EQU	$
 IF  PAL  ;**** PAL Ή [1995/7/24] *****************************
		LDA	HD420C
		STA	NMI_HD420C	;NMI set H-DMA flag
		LDA	FADNO
		STA	NMI_FADNO	;NMI set contrast flag
 ENDIF	  ;**** PAL Ή [1995/7/24] *****************************
;
;-------------- offset data set ---------------------------------
		LDA	#10000000B
		STA	2115H		;VRAM address inc mode set
;
		M16
;
		LDA	#3600H		;VRAM address set ( offset )
		STA	2116H
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#BG2OFF		;A bus address
		STA	4302H
		LDY	#BANK BG2OFF
		STY	4304H
		LDY	#080H		;number of byte
		STY	4305H
		LDX	#00000001B	;DMA "ON" !!
		STX	420BH
;
		LDA	#0080H		;offset data address( 7600H- )
		STA	<SCCV3
		STZ	<SCCH3
;
		LDA	BG2OFV		;BG1 scroll counter_V set
		STA	NMISCV1		;NMI set scroll counter_V set
		LDA	BG2OFH		;BG1 scroll counter_H set
		JMP	IRQ_NMI_SUB
;
		MEM8
;
;----------------------------------------------------------------
;-		game( mode 7 )					-
;----------------------------------------------------------------
IRQ_NMI_05	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0510	;timer over ? ( no:IRQ_NMI_0510 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0510	EQU	$
 IF  PAL  ;**** PAL Ή [1995/7/24] *****************************
		LDA	HD420C
		STA	NMI_HD420C	;NMI set H-DMA flag
		LDA	FADNO
		STA	NMI_FADNO	;NMI set contrast flag
 ENDIF	  ;**** PAL Ή [1995/7/24] *****************************
;
;-------------- mode 7 parameter set ----------------------------
		LDA	M7SEL		;mode 7 initial set flag set
		STA	211AH
		LDA	M7A		;mode 7 matrix_A set
		STA	211BH
		LDA	M7A+1
		STA	211BH
		LDA	M7B		;mode 7 matrix_B set
		STA	211CH
		LDA	M7B+1
		STA	211CH
		LDA	M7C		;mode 7 matrix_C set
		STA	211DH
		LDA	M7C+1
		STA	211DH
		LDA	M7D		;mode 7 matrix_D set
		STA	211EH
		LDA	M7D+1
		STA	211EH
		LDA	M7X		;mode 7 center_X set
		STA	211FH
		LDA	M7X+1
		STA	211FH
		LDA	M7Y		;mode 7 center_Y set
		STA	2120H
		LDA	M7Y+1
		STA	2120H
;
;-------------- [hVafhnm^neehZbg --------------
;
		M16
;
		LDA	OBJ_BG_FG
		STA	>HDMABUF2+1
		STA	>HDMABUF2+4
		LDA	MANSEL		;[ & SUBSEL ]
		STA	>HDMABUF2+7
;
;-------------- BG1 scroll counter set --------------------------
		LDA	<SCCH1		;BG1 scroll counter_H set
		STA	<SCCH2
		LDA	<SCCV1		;BG1 scroll counter_V set
		CLC
		ADC	TILTAL
		STA	<SCCV2
;
		LDA	<SCCV3
		LDY	DSPMOD
		CPY	#09H
		BNE	IRQ_NMI_0520	;{XpH ( no:IRQ_NMI_0520 )
;
		CLC
		ADC	TILTAL
IRQ_NMI_0520	EQU	$
		STA	NMISCV1
		LDA	<SCCH3
		JMP	IRQ_NMI_SUB
;
;--------------------------------------------------------
;-		ԃI[o[II			-
;--------------------------------------------------------
IRQ_NMI_TMOV	EQU	$
		LDA	NMI_PROG_NO
		BEQ	IRQ_NMI_TMOV_10 ;荞݃vOH ( no:IRQ_NMI_TMOV_10 )
;
		M16
;
		PHD			;(D) save
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
;-------------- game play DMA set -----------------------
		JSR	PCHDMA		;player chara DMA set
		JSR	OB7DMA		;OBJ mode 7 chara DMA set
;
;-------------- joy-controller read -----------------------------
		PLD			;(D) load
;
		M8
;
		JSR	CONT2		;controller read
;
		DPAGE	WORK
;
;-------------- BG1 scroll counter set --------------------------
IRQ_NMI_TMOV_10 EQU	$
		LDA	NMISCH1
		STA	210DH
		LDA	NMISCH1+1
		STA	210DH
		LDA	NMISCV1
		STA	210EH
		LDA	NMISCV1+1
		STA	210EH
		JMP	IRQ_NMI_ON
;
;----------------------------------------------------------------
;-		vOe[u				-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
NMI_PROG_SEL	EQU	$		;[NMI_PROG_NO]
		WORD	NMI_PROG_00	;[0] 
		WORD	NMI_PROG_01	;[2] R[XC^Cgf
;
;--------------------------------------------------------
;-							-
;--------------------------------------------------------
NMI_PROG_00	EQU	$
		RTS
;
;--------------------------------------------------------
;-		R[XC^Cgf			-
;--------------------------------------------------------
NMI_PROG_01	EQU	$
;
;-------------- f --------------------------------
		JSL	>COURSE_IN_DM
		RTS
;
;------------------------------------------------------------------------
;-		R[XC^Cgfnai			-
;------------------------------------------------------------------------
COURSE_IN_DM	EQU	$
		JSL	>OAMDXCLR	;OAM clear
;
		JSL	>ENCSET		;enemy OAM set
		JSL	>PLCSET		;player OAM set
;
		JSL	>PLAYER		;player move
		JSL	>ENEMY_IN	;enemy move
;
		M16
;
		M_CHIP	DX_OAM		;OAM convert
;
		INC	INCSTIM		;^C}[Z
		INC	INCSCNT		;\JE^[Z
		LDA	INCSCNT
		CMP	#010H
		BCC	CRE_IN_DM_90
;
		LDA	KEYA2L
		ORA	KEYB2L
		BEQ	CRE_IN_DM_60
		LDA	INCSTIM		;^C}[Z
		CLC
		ADC	#08H-1-1
		STA	INCSTIM		;^C}[Z
CRE_IN_DM_60	EQU	$
		LDA	INCSCNT
		AND	#03H		; \H
		BEQ	CRE_IN_DM_80	;	YES -> CRE_IN_DM_80
;
		JMP	>INCSMSG_100
;
CRE_IN_DM_80	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
		LDY	!MAPOINT
		JMP	>INCSMSG	;R[XC^Cg\
;
		IDX8
;
CRE_IN_DM_90	EQU	$
;
		M8
;
		RTL
;
 IF  NES  ;**** NES Ή [1995/07/31] *****************************
;
;****************************************************************
;*								*
;*	R[Xɓ鎞 bZ[WZbg			*
;*				in				*
;*				X <- messege data read index	*
;*				Y <- MAPOINT			*
;*				     or				*
;*				player down messege index	*
;****************************************************************
		IDX16
INCSMSG		EQU	$
		M16			; memory 16bit mode
;
		PHB
		PHK
		PLB
		LDA	!INCSNXT
		AND	#0003FH
		STA	R11
		STY	R14
		LDA	#BANK MOJI_DAT
		STA	R0
		LDA	#MOJI_DAT
		STA	R10
		I8			; index 8bit mode
		LDA	!INCSMJX
		STA	R9
		LDA	!INCSMJY
		STA	R8
;
		M_CHIP	INCOSEMOJI
;
		LDA	R11
		STA	!INCSNXT
		LDA	R8
		STA	!INCSMJY
		LDA	R9
		STA	!INCSMJX
;
		INC	OBM7WF
		PLB
;
INCSMSG_010	EQU	$
		LDA	#05038H
		STA	!MSGWK2
;
INCSMSG_100	EQU	$
		I16			; index 16bit mode
		LDA	#0AAAAH
		STA	!OAMSUB
		STA	!OAMSUB+2
		LDA	#000E0H
		STA	!MSGWK0
		M8			; memory 8bit mode
;
		LDX	#00000H
INCSMSG_200	EQU	$
		M16			; memory 16bit mode
		TXA
		AND	#000FFH
		LSR	A
		ORA	#035C0H		; LN^[ m.
		STA	!OAM+002,X	;	
		ORA	#00020H		; Agr[g
		STA	!OAM+034,X	;		Zbg
;
		LDA	!GMFADE_CT	; w
		SEC
		SBC	!MSGWK0
		M8			; memory 8bit mode
		STA	!OAM+000,X
		STA	!OAM+032,X
		LDA	!MSGWK0
		SEC
		SBC	#010H
		STA	!MSGWK0
;
		LDA	!MSGWK2		; x
		STA	!OAM+001,X
		LDA	!MSGWK3
		STA	!OAM+033,X
;
		INX
		INX
		INX
		INX
		CPX	#00004*8
		BCC	INCSMSG_200
;
INCSMSG_900	EQU	$
		I8			; index 8bit mode
		RTL
;
 ENDIF	  ;**** NES Ή [1995/07/31] *****************************
;
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
;
;****************************************************************
;*								*
;*	R[Xɓ鎞 bZ[WZbg			*
;*				in				*
;*				X <- messege data read index	*
;*				Y <- MAPOINT			*
;*				     or				*
;*				player down messege index	*
;****************************************************************
		IDX16
INCSMSG		EQU	$
		M16			; memory 16bit mode
;
		PHB
		PHK
		PLB
		LDA	!INCSNXT
		AND	#0003FH
		STA	R11
		STY	R14
		LDA	#BANK MOJI_DAT
		STA	R0
		LDA	!LNGG_SL
		ASL	A
		TAX
		LDA	INCSMSG_DAT,X
		STA	R10
		I8			; index 8bit mode
		LDA	!INCSMJX
		STA	R9
		LDA	!INCSMJY
		STA	R8
;
		M_CHIP	INCOSEMOJI
;
		LDA	R11
		STA	!INCSNXT
		LDA	R8
		STA	!INCSMJY
		LDA	R9
		STA	!INCSMJX
;
		INC	OBM7WF
		PLB
;
INCSMSG_010	EQU	$
		LDA	#05038H
		STA	!MSGWK2
;
INCSMSG_100	EQU	$
		I16			; index 16bit mode
		LDA	#0AAAAH
		STA	!OAMSUB
		STA	!OAMSUB+2
		LDA	#000E0H
		STA	!MSGWK0
		M8			; memory 8bit mode
;
		LDX	#00000H
INCSMSG_200	EQU	$
		M16			; memory 16bit mode
		TXA
		AND	#000FFH
		LSR	A
		ORA	#035C0H		; LN^[ m.
		STA	!OAM+002,X	;	
		ORA	#00020H		; Agr[g
		STA	!OAM+034,X	;		Zbg
;
		LDA	!GMFADE_CT	; w
		SEC
		SBC	!MSGWK0
		M8			; memory 8bit mode
		STA	!OAM+000,X
		STA	!OAM+032,X
		LDA	!MSGWK0
		SEC
		SBC	#010H
		STA	!MSGWK0
;
		LDA	!MSGWK2		; x
		STA	!OAM+001,X
		LDA	!MSGWK3
		STA	!OAM+033,X
;
		INX
		INX
		INX
		INX
		CPX	#00004*8
		BCC	INCSMSG_200
;
INCSMSG_900	EQU	$
		I8			; index 8bit mode
		RTL
;
INCSMSG_DAT	EQU	$
		WORD	MOJI_DAT,MOJI_DAT_F,MOJI_DAT_G
 ENDIF	  ;**** PAL Ή [1995/07/31] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
;
;****************************************************************
;*								*
;*	R[Xɓ鎞 bZ[WZbg			*
;*				in				*
;*				X <- messege data read index	*
;*				Y <- MAPOINT			*
;*				     or				*
;*				player down messege index	*
;****************************************************************
		IDX16
INCSMSG		EQU	$
		PHX
		M16			; memory 16bit mode
;
		LDA	!INCSNXT
		AND	#000FFH
		CMP	#00020H
		BCS	INCSMSG_010
		STA	R11
		PHB
		PHK
		PLB
		STY	R14
		LDA	#BANK MOJI_DAT
		STA	R0
		LDA	INCSMSG_DAT,X
		STA	R10
		I8			; index 8bit mode
		LDA	!INCSMJX
		STA	R9
		LDA	!INCSMJY
		STA	R8
;
		M_CHIP	INCOSEMOJI
;
		LDA	R11
		STA	!INCSNXT
		LDA	R8
		STA	!INCSMJY
		LDA	R9
		STA	!INCSMJX
;
		INC	OBM7WF
		PLB
;
INCSMSG_010	EQU	$
		I16			; index 16bit mode
		LDY	#05038H
		PLX
		TXA			; " xnt@knrs "
		AND	#000FFH		;	bZ[W Zbg ?
		BEQ	INCSMSG_080	;	NO -> INCSMSG_100
;
		LDY	#06870H
		LDA	!PLDSYL		; v[[ ʂ̉ ?
		BMI	INCSMSG_030	;	YES -> INCSMSG_030
		AND	#00100H		;	     ʂ̏ ?
		BNE	INCSMSG_080	;	YES -> INCSMSG_100
		LDA	!PLDSYL
		AND	#000FFH
		CMP	#00060H
		BCC	INCSMSG_080
INCSMSG_030	EQU	$
		LDY	#05850H
;
INCSMSG_080	EQU	$
		STY	!MSGWK2
;
INCSMSG_100	EQU	$
		I16			; index 16bit mode
		LDA	#0AAAAH
		STA	!OAMSUB
		STA	!OAMSUB+2
		LDA	#000E0H
		STA	!MSGWK0
		M8			; memory 8bit mode
;
		LDX	#00000H
INCSMSG_200	EQU	$
		M16			; memory 16bit mode
		TXA
		AND	#000FFH
		LSR	A
		ORA	#035C0H		; LN^[ m.
		STA	!OAM+002,X	;	
		ORA	#00020H		; Agr[g
		STA	!OAM+034,X	;		Zbg
;
		LDA	!GMFADE_CT	; w
		SEC
		SBC	!MSGWK0
		M8			; memory 8bit mode
		STA	!OAM+000,X
		STA	!OAM+032,X
		LDA	!MSGWK0
		SEC
		SBC	#010H
		STA	!MSGWK0
;
		LDA	!MSGWK2		; x
		STA	!OAM+001,X
		LDA	!MSGWK3
		STA	!OAM+033,X
;
		INX
		INX
		INX
		INX
		CPX	#00004*8
		BCC	INCSMSG_200
;
INCSMSG_900	EQU	$
		I8			; index 8bit mode
		RTL
;
INCSMSG_DAT	EQU	$
		WORD	MOJI_DAT,DWNMOJI_DAT
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		MEM8
		IDX8
;
;************************************************************************
;*		IRQ ( ~[WJ )					*
;************************************************************************
;
IRQ100		EQU	$
		LDA	IRQFLG
		BNE	IRQ110		;H-DMA "ON" IRQ ? ( no:IRQ110 )
;
;-------------- H-DMA "ON" IRQ ------------------------------------------
IRQ102		EQU	$
		BIT	4212H
		BVS	IRQ102
IRQ104		EQU	$
		BIT	4212H
		BVC	IRQ104
;
		LDA	HD420C
		STA	420CH		;H-DMA "ON"
		STZ	2100H		;fade "OFF"
;
;-------------- blanking "OFF" IRQ timer set --------------------
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0EH		;V counter set
		BRA	IRQ120
;
IRQ110		EQU	$
		DEC	A
		BNE	IRQ130		;blanking "OFF" IRQ ? ( no:IRQ130 )
;
;-------------- blanking "OFF" IRQ --------------------------------------
IRQ112		EQU	$
		BIT	4212H
		BVS	IRQ112
IRQ114		EQU	$
		BIT	4212H
		BVC	IRQ114
;
		LDA	FADNO		;fade in
		STA	2100H
;
;-------------- NMI-IRQ timer set -------------------------------
;;;;		    LDA	    #080H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0C6H		;V counter set
IRQ120		EQU	$
		INC	IRQFLG
		JMP	IRQ_TIMER_SET
;
;------------------------------------------------------------------------
;-		NMI-IRQ							-
;------------------------------------------------------------------------
IRQ130		EQU	$
		BIT	4212H
		BVS	IRQ130
IRQ140		EQU	$
		BIT	4212H
		BVC	IRQ140
;
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDX	NMITYP
		JMP	(!IRQ_NMI_SEL,X)
;
;----------------------------------------------------------------
;-		~[WJiaf[hPj			-
;----------------------------------------------------------------
IRQ_NMI_04	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0410	;time over ? ( no:IRQ_NMI_0410 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_04_ON
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0410	EQU	$
 IF  PAL  ;**** PAL Ή [1995/7/24] *****************************
		LDA	HD420C
		STA	NMI_HD420C	;NMI set H-DMA flag
		LDA	FADNO
		STA	NMI_FADNO	;NMI set contrast flag
 ENDIF	  ;**** PAL Ή [1995/7/24] *****************************
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		PHD			;(D) save
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
;-------------- bZ[W]`FbN --------------------------
		LDA	MSGTRF
		BEQ	IRQ_NMI_0420	;bZ[W]H ( no:IRQ_NMI_0420 )
;
		LDA	#7000H		;VRAM address set
		STA	2116H
		LDA	#DM01_MSGBITMP	;A bus address set
		STA	<4302H
		LDY	#BANK DM01_MSGBITMP
		STY	<4304H
		LDA	#0800H		;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
;
		STZ	MSGTRF
;
;-------------- Y[nai]`FbN ------------------------
IRQ_NMI_0420	EQU	$
		LDA	OBM7WF
		BEQ	IRQ_NMI_0430	;Y[nai]H ( no:IRQ_NMI_0430 )
;
		STA	<4305H		;number of byte set
		LDA	#5000H		;VRAM address set
		STA	2116H
		LDA	#DM01_OBJBITMP	;A bus address set
		STA	<4302H
		LDY	#BANK DM01_OBJBITMP
		STY	<4304H
		STX	<420BH		;DMA "ON"
;
		STZ	OBM7WF
;
IRQ_NMI_0430	EQU	$
		LDA	BABYTRF
		BNE	IRQ_NMI_0440	;naiLN^[]H ( yes:IRQ_NMI_0440 )
		JMP	IRQ_NMI_0450
;
;-------------- vC[LN^[] ------------------------------
IRQ_NMI_0440	EQU	$
		LDA	#05400H		;VRAM address set ( 5400H- )
		STA	2116H
;
		LDY	#0040H		;(Y) <-- number of byte data
;
		LDA	PCHNO0		;A bus address(L,H)
		STA	<4302H
		LDA	#BANK CHRE0	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+24	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+28	;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	#05500H		;VRAM address set ( 5500H- )
		STA	2116H
;
		M8
;
		LDA	PCHNO0		;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+3	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+7	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+11	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+15	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+19	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+23	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+24	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+27	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+28	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+31	;      "      (H)
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		M16
;
		STZ	BABYTRF
;
IRQ_NMI_0450	EQU	$
		PLD			;(D) load
;
;
		DPAGE	WORK
;
;
;-------------- joy-controller read -----------------------------
;
		M8
;
		JSR	CONT2		;controller read
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;BG1 scroll counter_H set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
		LDA	<SCCH4		;BG4 scroll counter set
		STA	2113H
		LDA	<SCCH4+1
		STA	2113H
		LDA	<SCCV4
		STA	2114H
		LDA	<SCCV4+1
		STA	2114H
;
IRQ_NMI_04_ON	EQU	$
;
;-------------- PPU Reg. set ------------------------------------
		LDA	OBJSEL		;OBJ status data set
		STA	2101H
		LDA	BG1SCF		;BG1 screen base address set
		STA	2107H
		LDA	BG2SCF		;BG2 screen base address set
		STA	2108H
		LDA	WIND30
		STA	2130H
		LDA	SUBADF
		STA	2131H
		LDA	MOZNO		;mozaiku set
		STA	2106H
;
;-------------- H-DMA initial start set -------------------------
;
		M16
;
		LDA	DM_HDMA_PR	;CTuʐݒf[^Zbg
		STA	>HDMAPR1+1
		STA	>HDMAPR1+4
;
		LDA	#4300H
		TCD
;
;
		DPAGE	4300H
;
;
		LDA	<4312H		 ;H-DMA start table address set
		STA	<4318H
		LDA	<4322H
		STA	<4328H
		LDA	<4332H
		STA	<4338H
		LDA	<4342H
		STA	<4348H
		LDA	<4352H
		STA	<4358H
		LDA	<4362H
		STA	<4368H
		LDA	<4372H
		STA	<4378H
;
		M8
;
		LDA	#01H		;start line counter set
		STA	<431AH
		STA	<432AH
		STA	<433AH
		STA	<434AH
		STA	<435AH
		STA	<436AH
		STA	<437AH
;
		STZ	IRQFLG
;
;;;;		    LDA	    #0C0H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#00CH		;V counter set
		JMP	IRQ_TIMER_SET
;
;
		DPAGE	WORK
;
;
;************************************************************************
;*		IRQ ( GfBOrbg}bv )			*
;************************************************************************
BITMAP_VRAM_ADR EQU	$-4+7E0000H
; BITMAP_BANK -->	 [0]		  [1]		  ;[BITMAP_TRF]
		WORD	2000H,		 2000H		  ;[0]
		WORD	1000H,		 3000H		  ;[1]
		WORD	0000H,		 4000H		  ;[2]
BITMAP_BUFF_ADR EQU	$-4+7E0000H
		WORD	BITMAP_BUF+4000H,BITMAP_BUF	  ;[0]
		WORD	BITMAP_BUF+2000H,BITMAP_BUF+2000H ;[1]
		WORD	BITMAP_BUF,	 BITMAP_BUF+4000H ;[2]
;
BITMAP_BG1_BANK EQU	$+7E0000H
		BYTE	01010000B,01010010B
;
IRQ200		EQU	$
		BIT	4212H
		BVS	IRQ200
IRQ210		EQU	$
		BIT	4212H
		BVC	IRQ210
;
		LDA	#10001111B	;blanking "ON"
		STA	2100H
;
		JSR	END_OBJDMA	;OBJ DMA set
;
		LDA	BITMAP_TRF
		BEQ	IRQ220		;rbg}bvLN^[]H ( no:IRQ220 )
;
;-------------- rbg}bvLN^[] ----------------------------
		ASL	A
		ORA	BITMAP_BANK
		ASL	A
		TAX
;
		M16
;
		LDY	#10000000B		;inc mode set
		STY	2115H
		LDA	>BITMAP_VRAM_ADR,X	;VRAM address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	>BITMAP_BUFF_ADR,X	;A bus address(L,H) set
		STA	4302H
		LDA	#2000H			;number of byte ser
		STA	4305H
		LDY	#BANK BITMAP_BUF	;A bus address(B) set
		STY	4304H
		LDY	#00000001B		;DMA "ON" !!
		STY	420BH
;
		M8
;
		DEC	BITMAP_TRF	;rbg}bvLN^[]IH
		BNE	IRQ250		;	NO -> IRQ250
;
		LDX	<BITMAP_BANK	;LN^[oN؂ւ
		LDA	>BITMAP_BG1_BANK,X
		STA	210BH		;BG1 chara bank change
		TXA
		EOR	#01H
		STA	<BITMAP_BANK
;
IRQ220		EQU	$
		LDA	NMIFLG
		BNE	IRQ260		;ԃI[o[H ( no:IRQ260 )
;
IRQ250		EQU	$
		BIT	4212H
		BVS	IRQ250
IRQ252		EQU	$
		BIT	4212H
		BVC	IRQ252
;
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
		JMP	EDG_OAM_SET
;;;;K;;;;		RTS
;
IRQ260		EQU	$
		STZ	NMIFLG		;mlhtOhnmh
;
		M16
;
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
		LDX	#004H*2-2
IRQ270		EQU	$
		LDA	!END_MJ_COL_BF+000H*2,X
		STA	>BITMAP_COL+(010H*2)*00EH+001H*2,X
		LDA	!END_MJ_COL_BF+004H*2,X
		STA	>BITMAP_COL+(010H*2)*00FH+001H*2,X
		DEX
		DEX
		BPL	IRQ270
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	BITMAP_COLDMA	;color DMA
;
		LDA	!END_NXT	; afQXN[ ւ ?
		BEQ	IRQ280		;	NO -> IRQ280
		LDA	!END_ADR
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	<4300H		; DMA parameter & B bus address
		LDA	#BITMAP_BF
		STA	<4302H		; A bus address(L,H) set
		LDY	#BANK BITMAP_BF
		STY	<4304H		;	"       (B) set
		LDA	!END_KAZU
		STA	<4305H		; number of byte set
		LDY	#00000001B		;DMA "ON" !!
		STY	<420BH
		STZ	!END_NXT
;
IRQ280		EQU	$
		LDA	#0000H		;0 page set ( 0000H- )
		TCD
;
;
		DPAGE	WORK
;
;
		M8
;
;-------------- Rg[[ǂݍ ----------------------------------
		JSR	CONT2		;controller read
;
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
;-------------- rbg}bvobt@] --------------------------------
		LDA	BITMAP_WTRF
		BEQ	IRQ290		;rbg}bvLN^[]H ( no:IRQ290 )
;
		STZ	BITMAP_WTRF
		STA	BITMAP_TRF	;rbg}bvLN^[]tOhnmh
;
		M16
;
		LDA	#BITMAP_BUF
		STA	<WORK20		;(WK20,21,22) <-- ]AhX
		LDY	#BANK BITMAP_BUF
		STY	<WORK22
		LDA	#BITMAP_BF
		STA	<WORK23		;(WK23,24,25) <-- ]AhX
		LDY	#BANK BITMAP_BF
		STY	<WORK25
		LDA	#6000H		;(A) <-- ]oCg
		JSL	>DMA_M_M
;
		M8
;
IRQ290		EQU	$
;;;;K;;;;		RTS
;
 IF  NES  ;**** NES Ή [1995/07/27] *****************************
;
;****************************************************************
;*								*
;*	GfBO bZ[W n`l Zbg			*
;*								*
;****************************************************************
EDG_OAM_SET	EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		PHA
;
		LDX	!END_MK
		LDA	!END_MJ_COL_BF+000H*2+000H*2
		CLC
		ADC	>BTMP_COL_DT,X
		BMI	EDG_OAM_500
		STA	!END_MJ_COL_BF+000H*2+000H*2
		STA	!END_MJ_COL_BF+000H*2+002H*2
		STA	!END_MJ_COL_BF+004H*2+001H*2
		STA	!END_MJ_COL_BF+004H*2+002H*2
;
EDG_OAM_500	EQU	$
		LDX	#000H
		LDA	#0F080H
EDG_OAM_550	EQU	$		; n`lNA
		STA	!END_OAM+000H,X
		STZ	!END_OAM+002H,X
		STA	!END_OAM+100H,X
		STZ	!END_OAM+102H,X
		DEX
		DEX
		DEX
		DEX
		BNE	EDG_OAM_550
;
		LDA	!END_OBJ_CT
		ASL	A
		TAX
		LDA	>EDG_OAM_ADR,X
		STA	<WORK0
		LDA	#BANK EDG_OAM_ADR
		STA	<WORK2
;
EDG_OAM_620	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
		TXY
EDG_OAM_630	EQU	$
		M16			; memory 16bit mode
		LDA	[<WORK0],Y
		STA	<WORKA
		INY
		INY
		M8			; memory 8bit mode
;
EDG_OAM_640	EQU	$
		LDA	[<WORK0],Y
		CMP	#0FFH
		BEQ	EDG_OAM_660
		PHA
		AND	#0EFH
		STA	!END_OAM+2,X	; LN^[m.
		ORA	#010H
		STA	!END_OAM+6,X
		PLA
		AND	#010H
		LSR	A
		LSR	A
		LSR	A
		ORA	#00111101B
		STA	!END_OAM+3,X	; Agr[g
		STA	!END_OAM+7,X
		LDA	<WORKA
		STA	!END_OAM+0,X	; wW
		STA	!END_OAM+4,X
		INY
		CLC
		ADC	[<WORK0],Y
		STA	<WORKA
		LDA	<WORKB
		STA	!END_OAM+1,X	; xW
		CLC
		ADC	#008
		STA	!END_OAM+5,X
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#008
		TAX
		INY
		M8			; memory 8bit mode
		BRA	EDG_OAM_640
;
EDG_OAM_660	EQU	$
		INY
		LDA	[<WORK0],Y	; f[^ ?
		BEQ	EDG_OAM_990	;	YES -> EDG_OAM_990
		INY
		DEC	A		; w,xW`FW ?
		BEQ	EDG_OAM_630	;	YES -> EDG_OAM_630
		DEC	A
		BEQ	EDG_OAM_670
		LDA	<WORKA		; wW`FW
		CLC
		ADC	#008
		STA	<WORKA
		BRA	EDG_OAM_640
EDG_OAM_670	EQU	$		; xW`FW
		LDA	[<WORK0],Y
		CLC
		ADC	<WORKB
		STA	<WORKB
		INY
		BRA	EDG_OAM_640
;
EDG_OAM_990	EQU	$
		M16			; memory 16bit mode
		PLA
		STA	<WORK0
		MI8			; memory , index 8bit mode
		RTS
;
;
BTMP_COL_DT	EQU	$+7E0000H
		WORD	0F7BEH,00842H
;
;--------------------------------------------------------
;-		X^bt[ f[^			-
;-			0FFH : Rg[ R[h	-
;-				00 : f[^I		-
;-				01 : w,xW`FW	-
;-				02 : xW`FW	-
;-				03 : wW`FW	-
;--------------------------------------------------------
EDG_OAM_DT00	EQU	$+7E0000H
		BYTE	057H,0A8H
		BYTE		ED_CSL2,8,ED_E__D,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__e,7,ED_E__c,8,ED_E__t,8,ED_E__o,8
		BYTE		ED_E__r,7,ED_E__s,8,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT01	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__T,8,ED_E__e,7,ED_E__z,8,ED_E__u,8
		BYTE		ED_E__k,8,ED_E__a,8
		BYTE	0FFH,001H,043H,0B4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__h,8,ED_E__i,4,ED_E__k,8
		BYTE		ED_E__o,8+8
		BYTE		ED_E__N,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__g,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT02	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__f,7,ED_E__u,8,ED_E__m,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__n,8,ED_E__o,8
		BYTE	0FFH,001H,050H,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__d,8,ED_E__e,7
		BYTE		ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__n,8,ED_E__n,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT03	EQU	$+7E0000H
		BYTE	049H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__g,8,ED_E__r,7,ED_E__a,8,ED_E__m,8
		BYTE		ED_E__m,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE		0FFH,000H
;
EDG_OAM_DT04	EQU	$+7E0000H
		BYTE	04AH,0A4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__o,8+8
		BYTE		ED_E__I,6,ED_E__w,8,ED_E__a,8,ED_E__w,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,8
		BYTE	0FFH,001H,05AH,0B4H
		BYTE		ED_E__M,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__N,8,ED_E__i,4,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT05	EQU	$+7E0000H
		BYTE	052H,0A4H
		BYTE		ED_E__K,8,ED_E__i,4,ED_E__y,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__h,8,ED_E__i,8+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__d,8,ED_E__a,8
		BYTE	0FFH,001H,042H,0B4H
		BYTE		ED_E__S,8,ED_E__a,8,ED_E__t,8,ED_E__o,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__t,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT06	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__z,8,ED_E__u,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__M,8,ED_E__o,8,ED_E__r,7,ED_E__i,4
		BYTE		ED_E__t,8,ED_E__a,8
		BYTE	0FFH,001H,043H,0B4H
		BYTE		ED_E__Y,8,ED_E__u,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__o,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT07	EQU	$+7E0000H
		BYTE	038H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__a,8,ED_E__t,8,ED_E__s,8
		BYTE		ED_E__u,8
		BYTE	0FFH,001H,049H,0B4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__d,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT08	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__n,8,ED_E__o,8,ED_E__r,7,ED_E__i,4+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__e,7
		BYTE		ED_E__t,8,ED_E__a,8,ED_E__n,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT09	EQU	$+7E0000H
		BYTE	03DH,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__o,8,ED_E__u,8
		BYTE		ED_E__r,7,ED_E__s,8,ED_E__e,7+8
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__s,8,ED_E__i,4
		BYTE		ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0A	EQU	$+7E0000H
		BYTE	03EH,0A4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__s,8,ED_E__a,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__u,8,ED_E__r,7,ED_E__a,8
		BYTE	0FFH,001H,05AH,0B4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__n,8,ED_E__t,8
		BYTE		ED_E__a,8+8
		BYTE		ED_E__U,8,ED_E__s,8,ED_E__u,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT0B	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__m,8,ED_E__o,8
		BYTE		ED_E__t,8,ED_E__o,8
		BYTE	0FFH,001H,060H,0B4H
		BYTE		ED_E__E,7,ED_E__i,4,ED_E__j,7,ED_E__i,4+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0C	EQU	$+7E0000H
		BYTE	03FH,0A8H
		BYTE		ED_CSL2,8,ED_E__S,8,ED_E__o,8,ED_E__u,8
		BYTE		ED_E__n,8,ED_E__d,8+8
		BYTE		ED_E__C,8,ED_E__o,8,ED_E__m,8,ED_E__p,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0D	EQU	$+7E0000H
		BYTE	05AH,0A4H
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__j,7,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__n,8,ED_E__d,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0E	EQU	$+7E0000H
		BYTE	030H,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__h,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__a,8,ED_E__c,8,ED_E__t,8
		BYTE		ED_E__e,7,ED_E__r,7+8
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__s,8,ED_E__i,4
		BYTE		ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0F	EQU	$+7E0000H
		BYTE	04EH,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__f,7,ED_E__u,8,ED_E__m,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__n,8,ED_E__o,8
		BYTE	0FFH,001H,04CH,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__g,8
		BYTE		ED_E__a,8,ED_E__m,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT10	EQU	$+7E0000H
		BYTE	04AH,0A4H
		BYTE		ED_E__M,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__I,6,ED_E__i,4,ED_E__m,8,ED_E__u,8
		BYTE		ED_E__r,7,ED_E__a,8
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__m,8,ED_E__o,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__u,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__u,8,ED_E__m,8,ED_E__e,7
		BYTE	0FFH,000H
;
EDG_OAM_DT11	EQU	$+7E0000H
		BYTE	04BH,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_TEN4,8,ED_E__G,8
		BYTE		ED_TEN4,8,ED_E__D,8,ED_E__e,7,ED_E__s,8
		BYTE		ED_E__i,4,ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT12	EQU	$+7E0000H
		BYTE	048H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__i,4,ED_E__z,8
		BYTE		ED_E__u,8,ED_E__m,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT13	EQU	$+7E0000H
		BYTE	038H,0A8H
		BYTE		ED_CSL2,8,ED_E__S,8,ED_E__p,8
		BYTE		ED_E__e,7,ED_E__c,8,ED_E__i,4,ED_E__a,8
		BYTE		ED_E__l,4+8
		BYTE		ED_E__T,8,ED_E__h,8,ED_E__a,8,ED_E__n,8
		BYTE		ED_E__k,8,ED_E__s,8+8
		BYTE		ED_E__T,8,ED_E__o,8,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT14	EQU	$+7E0000H
		BYTE	043H,0A4H
		BYTE		ED_E__W,8,ED_E__a,8,ED_E__t,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__g,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__h,8,ED_E__i,4
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__a,8,ED_E__r,7,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__n,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT15	EQU	$+7E0000H
		BYTE	050H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__t,8,ED_E__a,8
		BYTE		ED_E__b,8,ED_E__e,7
		BYTE	0FFH,001H,04BH,0B4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__S,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT16	EQU	$+7E0000H
		BYTE	04BH,0A4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__n,8,ED_E__o,8,ED_E__b,8,ED_E__u,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__k,8,ED_E__u,8
		BYTE		ED_E__i,4
		BYTE	0FFH,001H,040H,0B4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT17	EQU	$+7E0000H
		BYTE	04CH,0A4H
		BYTE		ED_E__K,8,ED_E__i,4,ED_E__m,8,ED_E__i,4
		BYTE		ED_E__y,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__F,7,ED_E__u,8,ED_E__k,8,ED_E__u,8
		BYTE		ED_E__i,4
		BYTE	0FFH,001H,05BH,0B4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__i,4,ED_E__z,8
		BYTE		ED_E__o,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT18	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__S,8,ED_E__o,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__m,8,ED_E__i,4
		BYTE		ED_E__t,8,ED_E__a,8
		BYTE	0FFH,001H,04FH,0B4H
		BYTE		ED_E__M,8,ED_E__i,4,ED_E__e,7+8
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__m,8,ED_E__u,8,ED_E__r,7
		BYTE		ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT19	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__n,8,ED_E__s,8
		BYTE		ED_E__u,8,ED_E__k,8,ED_E__e,7+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__n,8,ED_E__a,8
		BYTE		ED_E__b,8,ED_E__e,7
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__T,8,ED_E__e,7,ED_E__t,8,ED_E__s,8
		BYTE		ED_E__u,8+8
		BYTE		ED_E__H,8,ED_E__a,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__m,8,ED_E__o,8,ED_E__t,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL0	EQU	$+7E0000H
		BYTE	051H,0A4H
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__r,7,ED_E__e,7
		BYTE		ED_E__k,7+8
		BYTE		ED_E__W,8,ED_E__h,8,ED_E__i,4,ED_E__p,8
		BYTE		ED_E__p,8,ED_E__l,4,ED_E__e,7
		BYTE	0FFH,001H,057H,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__d,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1A	EQU	$+7E0000H
		BYTE	058H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__d,8,ED_E__u,8,ED_E__c,8,ED_E__e,7
		BYTE		ED_E__r,7,ED_CSL1,8
		BYTE	0FFH,000h
;
EDG_OAM_DT1B	EQU	$+7E0000H
		BYTE	043H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__M,8,ED_E__i,4,ED_E__y,8
		BYTE		ED_E__a,8,ED_E__m,8,ED_E__o,8,ED_E__t,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1C	EQU	$+7E0000H
		BYTE	034H,0A8H
		BYTE		ED_CSL2,8,ED_E__E,7,ED_E__x,8,ED_E__e,7
		BYTE		ED_E__c,8,ED_E__u,8,ED_E__t,8,ED_E__i,4
		BYTE		ED_E__v,8,ED_E__e,7+8
		BYTE		ED_E__P,8,ED_E__r,7,ED_E__o,8,ED_E__d,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1D	EQU	$+7E0000H
		BYTE	046H,0A4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__h,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT1E	EQU	$+7E0000H
		BYTE	01EH,0A4H
		BYTE		ED_E__L,7,ED_E__o,8,ED_E__o,8,ED_E__k,8
		BYTE		ED_E__s,8+8
		BYTE		ED_E__l,4,ED_E__i,4,ED_E__k,8,ED_E__e,7+8
		BYTE		ED_E__t,8,ED_E__h,8,ED_E__e,7,ED_E__y,8+8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__v,8,ED_E__e,7+8
		BYTE		ED_E__a,8,ED_E__r,7,ED_E__r,7,ED_E__i,4
		BYTE		ED_E__v,8,ED_E__e,7,ED_E__d,8
		BYTE	0FFH,001H,024H,0B4H
		BYTE		ED_E__w,8,ED_E__h,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_E__e,7+8
		BYTE		ED_E__m,8,ED_E__o,8,ED_E__m,8+8
		BYTE		ED_E__a,8,ED_E__n,8,ED_E__d,8+8
		BYTE		ED_E__d,8,ED_E__a,8,ED_E__d,8+8
		BYTE		ED_E__l,4,ED_E__i,4,ED_E__v,8,ED_E__e,7
		BYTE		ED_TEN4,8,ED_TEN4,8,ED_TEN4,8,ED_TEN4,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1F	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__H,8,ED_E__e,7,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__e,7,ED_E__s,8+8
		BYTE		ED_E__a,8,ED_E__r,7,ED_E__e,7+8
		BYTE		ED_E__b,8,ED_E__o,8,ED_E__r,7,ED_E__n,8
		BYTE		ED____X,8,ED____X,8
		BYTE	0FFH,000H
;
EDG_OAM_DT20	EQU	$+7E0000H
		BYTE	062H,0A4H
		BYTE		ED_E__T,8,ED_E__H,8,ED_E__E,7+8
		BYTE		ED_E__E,7,ED_E__N,8,ED_E__D,8
		BYTE	0FFH,000H
;
EDG_OAM_ADR	EQU	$+7E0000H
		WORD	EDG_OAM_DT00	; _~[
		WORD	EDG_OAM_DT00,EDG_OAM_DT01,EDG_OAM_DT02
		WORD	EDG_OAM_DT03,EDG_OAM_DT04,EDG_OAM_DT05
		WORD	EDG_OAM_DT06,EDG_OAM_DT07,EDG_OAM_DT08
		WORD	EDG_OAM_DT09,EDG_OAM_DT0A,EDG_OAM_DT0B
		WORD	EDG_OAM_DT0C,EDG_OAM_DT0D,EDG_OAM_DT0E
		WORD	EDG_OAM_DT0F,EDG_OAM_DT10,EDG_OAM_DT11
		WORD	EDG_OAM_DT12,EDG_OAM_DT13,EDG_OAM_DT14
		WORD	EDG_OAM_DT15,EDG_OAM_DT16,EDG_OAM_DT17
		WORD	EDG_OAM_DT18,EDG_OAM_DT19,EDG_OAM_PAL0
		WORD	EDG_OAM_DT1A
		WORD	EDG_OAM_DT1B,EDG_OAM_DT1C,EDG_OAM_DT1D
		WORD	EDG_OAM_DT1E,EDG_OAM_DT1F,EDG_OAM_DT20
;
EDG_OAM_ADR_END EQU	$+7E0000H
;
EDG_OAM_ADR_CT	EQU	EDG_OAM_ADR_END-EDG_OAM_ADR-2
;
 ENDIF	  ;**** NES Ή [1995/07/27] *****************************
;
 IF  PAL  ;**** PAL Ή [1995/07/27] *****************************
;
;****************************************************************
;*								*
;*	GfBO bZ[W n`l Zbg			*
;*								*
;****************************************************************
EDG_OAM_SET	EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		PHA
;
		LDX	!END_MK
		LDA	!END_MJ_COL_BF+000H*2+000H*2
		CLC
		ADC	>BTMP_COL_DT,X
		BMI	EDG_OAM_500
		STA	!END_MJ_COL_BF+000H*2+000H*2
		STA	!END_MJ_COL_BF+000H*2+002H*2
		STA	!END_MJ_COL_BF+004H*2+001H*2
		STA	!END_MJ_COL_BF+004H*2+002H*2
;
EDG_OAM_500	EQU	$
		LDX	#000H
		LDA	#0F080H
EDG_OAM_550	EQU	$		; n`lNA
		STA	!END_OAM+000H,X
		STZ	!END_OAM+002H,X
		STA	!END_OAM+100H,X
		STZ	!END_OAM+102H,X
		DEX
		DEX
		DEX
		DEX
		BNE	EDG_OAM_550
;
		LDA	#BANK EDG_OAM_ADR
		STA	<WORK2
		LDA	!LNGG_SL
		ASL	A
		TAX
		LDA	>EDG_ADR_PAL,X
		STA	<WORK0
		LDA	!END_OBJ_CT
		ASL	A
		TAY
		LDA	[<WORK0],Y
		STA	<WORK0
;
EDG_OAM_620	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
		TXY
EDG_OAM_630	EQU	$
		M16			; memory 16bit mode
		LDA	[<WORK0],Y
		STA	<WORKA
		INY
		INY
		M8			; memory 8bit mode
;
EDG_OAM_640	EQU	$
		LDA	[<WORK0],Y
		CMP	#0FFH
		BEQ	EDG_OAM_660
		PHA
		AND	#0EFH
		STA	!END_OAM+2,X	; LN^[m.
		ORA	#010H
		STA	!END_OAM+6,X
		PLA
		AND	#010H
		LSR	A
		LSR	A
		LSR	A
		ORA	#00111101B
		STA	!END_OAM+3,X	; Agr[g
		STA	!END_OAM+7,X
		LDA	<WORKA
		STA	!END_OAM+0,X	; wW
		STA	!END_OAM+4,X
		INY
		CLC
		ADC	[<WORK0],Y
		STA	<WORKA
		LDA	<WORKB
		STA	!END_OAM+1,X	; xW
		CLC
		ADC	#008
		STA	!END_OAM+5,X
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#008
		TAX
		INY
		M8			; memory 8bit mode
		BRA	EDG_OAM_640
;
EDG_OAM_660	EQU	$
		INY
		LDA	[<WORK0],Y	; f[^ ?
		BEQ	EDG_OAM_990	;	YES -> EDG_OAM_990
		INY
		DEC	A		; w,xW`FW ?
		BEQ	EDG_OAM_630	;	YES -> EDG_OAM_630
		DEC	A
		BEQ	EDG_OAM_670
		LDA	<WORKA		; wW`FW
		CLC
		ADC	#008
		STA	<WORKA
		BRA	EDG_OAM_640
EDG_OAM_670	EQU	$		; xW`FW
		LDA	[<WORK0],Y
		CLC
		ADC	<WORKB
		STA	<WORKB
		INY
		BRA	EDG_OAM_640
;
EDG_OAM_990	EQU	$
		M16			; memory 16bit mode
		PLA
		STA	<WORK0
		MI8			; memory , index 8bit mode
		RTS
;
;
BTMP_COL_DT	EQU	$+7E0000H
		WORD	0F7BEH,00842H
;
;--------------------------------------------------------
;-		X^bt[ f[^			-
;-			0FFH : Rg[ R[h	-
;-				00 : f[^I		-
;-				01 : w,xW`FW	-
;-				02 : xW`FW	-
;-				03 : wW`FW	-
;--------------------------------------------------------
EDG_OAM_DT00	EQU	$+7E0000H
		BYTE	057H,0A8H
		BYTE		ED_CSL2,8,ED_E__D,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__e,7,ED_E__c,8,ED_E__t,8,ED_E__o,8
		BYTE		ED_E__r,7,ED_E__s,8,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT01	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__T,8,ED_E__e,7,ED_E__z,8,ED_E__u,8
		BYTE		ED_E__k,8,ED_E__a,8
		BYTE	0FFH,001H,043H,0B4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__h,8,ED_E__i,4,ED_E__k,8
		BYTE		ED_E__o,8+8
		BYTE		ED_E__N,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__g,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT02	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__f,7,ED_E__u,8,ED_E__m,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__n,8,ED_E__o,8
		BYTE	0FFH,001H,050H,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__d,8,ED_E__e,7
		BYTE		ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__n,8,ED_E__n,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT03	EQU	$+7E0000H
		BYTE	049H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__g,8,ED_E__r,7,ED_E__a,8,ED_E__m,8
		BYTE		ED_E__m,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE		0FFH,000H
;
EDG_OAM_DT04	EQU	$+7E0000H
		BYTE	04AH,0A4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__o,8+8
		BYTE		ED_E__I,6,ED_E__w,8,ED_E__a,8,ED_E__w,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,8
		BYTE	0FFH,001H,05AH,0B4H
		BYTE		ED_E__M,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__N,8,ED_E__i,4,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT05	EQU	$+7E0000H
		BYTE	052H,0A4H
		BYTE		ED_E__K,8,ED_E__i,4,ED_E__y,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__h,8,ED_E__i,8+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__d,8,ED_E__a,8
		BYTE	0FFH,001H,042H,0B4H
		BYTE		ED_E__S,8,ED_E__a,8,ED_E__t,8,ED_E__o,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__t,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT06	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__z,8,ED_E__u,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__M,8,ED_E__o,8,ED_E__r,7,ED_E__i,4
		BYTE		ED_E__t,8,ED_E__a,8
		BYTE	0FFH,001H,043H,0B4H
		BYTE		ED_E__Y,8,ED_E__u,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__o,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT07	EQU	$+7E0000H
		BYTE	038H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__a,8,ED_E__t,8,ED_E__s,8
		BYTE		ED_E__u,8
		BYTE	0FFH,001H,049H,0B4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__d,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT08	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__n,8,ED_E__o,8,ED_E__r,7,ED_E__i,4+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__k,8,ED_E__e,7
		BYTE		ED_E__t,8,ED_E__a,8,ED_E__n,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT09	EQU	$+7E0000H
		BYTE	03DH,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__o,8,ED_E__u,8
		BYTE		ED_E__r,7,ED_E__s,8,ED_E__e,7+8
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__s,8,ED_E__i,4
		BYTE		ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0A	EQU	$+7E0000H
		BYTE	03EH,0A4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__s,8,ED_E__a,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__m,8,ED_E__u,8,ED_E__r,7,ED_E__a,8
		BYTE	0FFH,001H,05AH,0B4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__n,8,ED_E__t,8
		BYTE		ED_E__a,8+8
		BYTE		ED_E__U,8,ED_E__s,8,ED_E__u,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT0B	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__m,8,ED_E__o,8
		BYTE		ED_E__t,8,ED_E__o,8
		BYTE	0FFH,001H,060H,0B4H
		BYTE		ED_E__E,7,ED_E__i,4,ED_E__j,7,ED_E__i,4+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0C	EQU	$+7E0000H
		BYTE	03FH,0A8H
		BYTE		ED_CSL2,8,ED_E__S,8,ED_E__o,8,ED_E__u,8
		BYTE		ED_E__n,8,ED_E__d,8+8
		BYTE		ED_E__C,8,ED_E__o,8,ED_E__m,8,ED_E__p,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0D	EQU	$+7E0000H
		BYTE	05AH,0A4H
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__j,7,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__n,8,ED_E__d,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0E	EQU	$+7E0000H
		BYTE	030H,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__h,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__a,8,ED_E__c,8,ED_E__t,8
		BYTE		ED_E__e,7,ED_E__r,7+8
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__s,8,ED_E__i,4
		BYTE		ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT0F	EQU	$+7E0000H
		BYTE	04EH,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__f,7,ED_E__u,8,ED_E__m,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__n,8,ED_E__o,8
		BYTE	0FFH,001H,04CH,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__N,8,ED_E__o,8,ED_E__g,8
		BYTE		ED_E__a,8,ED_E__m,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT10	EQU	$+7E0000H
		BYTE	04AH,0A4H
		BYTE		ED_E__M,8,ED_E__a,8,ED_E__s,8,ED_E__a,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__I,6,ED_E__i,4,ED_E__m,8,ED_E__u,8
		BYTE		ED_E__r,7,ED_E__a,8
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__m,8,ED_E__o,8
		BYTE		ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__u,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__u,8,ED_E__m,8,ED_E__e,7
		BYTE	0FFH,000H
;
EDG_OAM_DT11	EQU	$+7E0000H
		BYTE	04BH,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_TEN4,8,ED_E__G,8
		BYTE		ED_TEN4,8,ED_E__D,8,ED_E__e,7,ED_E__s,8
		BYTE		ED_E__i,4,ED_E__g,8
		BYTE		ED_E__n,8,ED_E__e,7,ED_E__r,7,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT12	EQU	$+7E0000H
		BYTE	048H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__a,8,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__i,4,ED_E__z,8
		BYTE		ED_E__u,8,ED_E__m,8,ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT13	EQU	$+7E0000H
		BYTE	038H,0A8H
		BYTE		ED_CSL2,8,ED_E__S,8,ED_E__p,8
		BYTE		ED_E__e,7,ED_E__c,8,ED_E__i,4,ED_E__a,8
		BYTE		ED_E__l,4+8
		BYTE		ED_E__T,8,ED_E__h,8,ED_E__a,8,ED_E__n,8
		BYTE		ED_E__k,8,ED_E__s,8+8
		BYTE		ED_E__T,8,ED_E__o,8,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT14	EQU	$+7E0000H
		BYTE	043H,0A4H
		BYTE		ED_E__W,8,ED_E__a,8,ED_E__t,8,ED_E__a,8
		BYTE		ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__g,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__h,8,ED_E__i,4
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__a,8,ED_E__r,7,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__n,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT15	EQU	$+7E0000H
		BYTE	050H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__K,8,ED_E__o,8,ED_E__t,8,ED_E__a,8
		BYTE		ED_E__b,8,ED_E__e,7
		BYTE	0FFH,001H,04BH,0B4H
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__s,8,ED_E__u,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__S,8,ED_E__a,8,ED_E__k,8,ED_E__a,8
		BYTE		ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_DT16	EQU	$+7E0000H
		BYTE	04BH,0A4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__n,8,ED_E__o,8,ED_E__b,8,ED_E__u,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__k,8,ED_E__u,8
		BYTE		ED_E__i,4
		BYTE	0FFH,001H,040H,0B4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__k,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT17	EQU	$+7E0000H
		BYTE	04CH,0A4H
		BYTE		ED_E__K,8,ED_E__i,4,ED_E__m,8,ED_E__i,4
		BYTE		ED_E__y,8
		BYTE		ED_E__o,8,ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__F,7,ED_E__u,8,ED_E__k,8,ED_E__u,8
		BYTE		ED_E__i,4
		BYTE	0FFH,001H,05BH,0B4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__i,4,ED_E__z,8
		BYTE		ED_E__o,8+8
		BYTE		ED_E__K,8,ED_E__a,8,ED_E__t,8,ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT18	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__S,8,ED_E__o,8,ED_E__i,4,ED_E__c,8
		BYTE		ED_E__h,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__T,8,ED_E__o,8,ED_E__m,8,ED_E__i,4
		BYTE		ED_E__t,8,ED_E__a,8
		BYTE	0FFH,001H,04FH,0B4H
		BYTE		ED_E__M,8,ED_E__i,4,ED_E__e,7+8
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__m,8,ED_E__u,8,ED_E__r,7
		BYTE		ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_DT19	EQU	$+7E0000H
		BYTE	049H,0A4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__n,8,ED_E__s,8
		BYTE		ED_E__u,8,ED_E__k,8,ED_E__e,7+8
		BYTE		ED_E__T,8,ED_E__a,8,ED_E__n,8,ED_E__a,8
		BYTE		ED_E__b,8,ED_E__e,7
		BYTE	0FFH,001H,045H,0B4H
		BYTE		ED_E__T,8,ED_E__e,7,ED_E__t,8,ED_E__s,8
		BYTE		ED_E__u,8+8
		BYTE		ED_E__H,8,ED_E__a,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__m,8,ED_E__o,8,ED_E__t,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL0	EQU	$+7E0000H
		BYTE	051H,0A4H
		BYTE		ED_E__D,8,ED_E__e,7,ED_E__r,7,ED_E__e,7
		BYTE		ED_E__k,7+8
		BYTE		ED_E__W,8,ED_E__h,8,ED_E__i,4,ED_E__p,8
		BYTE		ED_E__p,8,ED_E__l,4,ED_E__e,7
		BYTE	0FFH,001H,057H,0B4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__d,8,ED_E__a,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL1	EQU	$
		BYTE	047H,0A4H
		BYTE		ED_E__Y,8,ED_E__o,8,ED_E__s,8,ED_E__h,8
		BYTE		ED_E__i,4,ED_E__y,8,ED_E__u,8,ED_E__k,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__O,8,ED_E__n,8,ED_E__i,4,ED_E__s,8
		BYTE		ED_E__h,8,ED_E__i,4
		BYTE	0FFH,001H,048H,0B4H
		BYTE		ED_E__K,8,ED_E__e,7,ED_E__n,8,ED_E__j,7
		BYTE		ED_E__i,4+8
		BYTE		ED_E__H,8,ED_E__a,8,ED_E__r,7,ED_E__a,8
		BYTE		ED_E__g,8,ED_E__u,8,ED_E__c,8,ED_E__h,8
		BYTE		ED_E__i,4
		BYTE	0FFH,000H
;
EDG_OAM_PAL2	EQU	$
		BYTE	04EH,0A4H
		BYTE		ED_E__J,8,ED_E__o,8,ED_E__h,8,ED_E__n,8+8
		BYTE		ED_E__D,8,ED_TEN4,4+8
		BYTE		ED_E__K,8,ED_E__r,7,ED_E__a,8,ED_E__f,7
		BYTE		ED_E__t,8
		BYTE	0FFH,001H,040H,0B4H
		BYTE		ED_E__V,8,ED_H_Oo,7,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__n,8,ED_E__i,4,ED_E__q,8,ED_E__u,8
		BYTE		ED_E__e,7+8
		BYTE		ED_E__C,8,ED_E__h,8,ED_E__a,8,ED_E__n,8
		BYTE		ED_E__t,8,ED_E__e,8,ED_E__l,4
		BYTE	0FFH,000H
;
EDG_OAM_DT1A	EQU	$+7E0000H
		BYTE	058H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__d,8,ED_E__u,8,ED_E__c,8,ED_E__e,7
		BYTE		ED_E__r,7,ED_CSL1,8
		BYTE	0FFH,000h
;
EDG_OAM_DT1B	EQU	$+7E0000H
		BYTE	043H,0A4H
		BYTE		ED_E__S,8,ED_E__h,8,ED_E__i,4,ED_E__g,8
		BYTE		ED_E__e,7,ED_E__r,7,ED_E__u,8+8
		BYTE		ED_E__M,8,ED_E__i,4,ED_E__y,8
		BYTE		ED_E__a,8,ED_E__m,8,ED_E__o,8,ED_E__t,8
		BYTE		ED_E__o,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1C	EQU	$+7E0000H
		BYTE	034H,0A8H
		BYTE		ED_CSL2,8,ED_E__E,7,ED_E__x,8,ED_E__e,7
		BYTE		ED_E__c,8,ED_E__u,8,ED_E__t,8,ED_E__i,4
		BYTE		ED_E__v,8,ED_E__e,7+8
		BYTE		ED_E__P,8,ED_E__r,7,ED_E__o,8,ED_E__d,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1D	EQU	$+7E0000H
		BYTE	046H,0A4H
		BYTE		ED_E__H,8,ED_E__i,4,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__s,8,ED_E__h,8,ED_E__i,4+8
		BYTE		ED_E__Y,8,ED_E__a,8,ED_E__m,8,ED_E__a,8
		BYTE		ED_E__u,8,ED_E__c,8,ED_E__h,8,ED_E__i,4
		BYTE	0FFH,000H
;
;--------------------------------------------- p
EDG_OAM_DT1E	EQU	$+7E0000H
		BYTE	01EH,0A4H
		BYTE		ED_E__L,7,ED_E__o,8,ED_E__o,8,ED_E__k,8
		BYTE		ED_E__s,8+8
		BYTE		ED_E__l,4,ED_E__i,4,ED_E__k,8,ED_E__e,7+8
		BYTE		ED_E__t,8,ED_E__h,8,ED_E__e,7,ED_E__y,8+8
		BYTE		ED_E__h,8,ED_E__a,8,ED_E__v,8,ED_E__e,7+8
		BYTE		ED_E__a,8,ED_E__r,7,ED_E__r,7,ED_E__i,4
		BYTE		ED_E__v,8,ED_E__e,7,ED_E__d,8
		BYTE	0FFH,001H,024H,0B4H
		BYTE		ED_E__w,8,ED_E__h,8,ED_E__e,7,ED_E__r,7
		BYTE		ED_E__e,7+8
		BYTE		ED_E__m,8,ED_E__o,8,ED_E__m,8+8
		BYTE		ED_E__a,8,ED_E__n,8,ED_E__d,8+8
		BYTE		ED_E__d,8,ED_E__a,8,ED_E__d,8+8
		BYTE		ED_E__l,4,ED_E__i,4,ED_E__v,8,ED_E__e,7
		BYTE		ED_TEN4,8,ED_TEN4,8,ED_TEN4,8,ED_TEN4,8
		BYTE	0FFH,000H
;
EDG_OAM_DT1F	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__H,8,ED_E__e,7,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__e,7,ED_E__s,8+8
		BYTE		ED_E__a,8,ED_E__r,7,ED_E__e,7+8
		BYTE		ED_E__b,8,ED_E__o,8,ED_E__r,7,ED_E__n,8
		BYTE		ED____X,8,ED____X,8
		BYTE	0FFH,000H
;
EDG_OAM_DT20	EQU	$+7E0000H
		BYTE	062H,0A4H
		BYTE		ED_E__T,8,ED_E__H,8,ED_E__E,7+8
		BYTE		ED_E__E,7,ED_E__N,8,ED_E__D,8
		BYTE	0FFH,000H
;
;--------------------------------------------- tX
EDG_OAM_DT21	EQU	$+7E0000H
		BYTE	024H,0A4H
		BYTE		ED_E__O,8,ED_E__n,8+8
		BYTE		ED_E__d,8,ED_E__i,4,ED_E__r,7,ED_E__a,8
		BYTE		ED_E__i,4,ED_E__t,8+8
		BYTE		ED_E__q,8,ED_E__u,8,ED_H_He,7,ED_E__i,4
		BYTE		ED_E__l,4,ED_E__s,8+8
		BYTE		ED_E__o,8,ED_E__n,8,ED_E__t,8+8
		BYTE		ED_E__e,7,ED_E__n,8,ED_E__f,7,ED_E__i,4
		BYTE		ED_E__n,8+8
		BYTE	0FFH,001H,029H,0B4H
		BYTE		ED_E__a,8,ED_E__t,8,ED_E__t,8,ED_E__e,7
		BYTE		ED_E__i,4,ED_E__n,8,ED_E__t,8+8
		BYTE		ED_E__l,4,ED_E__e,7,ED_E__u,8,ED_E__r,7+8
		BYTE		ED_E__d,8,ED_E__e,7,ED_E__s,8,ED_E__t,8
		BYTE		ED_E__i,4,ED_E__n,8,ED_E__a,8,ED_E__t,8
		BYTE		ED_E__i,4,ED_E__o,8,ED_E__n,8,ED_TEN4,8
		BYTE	0FFH,000H
;
EDG_OAM_DT22	EQU	$+7E0000H
		BYTE	044H,0A4H
		BYTE		ED_E__A,8,ED_E__i,4,ED_E__n,8,ED_E__s,8
		BYTE		ED_E__i,4+8
		BYTE		ED_E__s,8,ED_E__o,8,ED_E__n,8,ED_E__t,8+8
		BYTE		ED_E__n,8,ED_H_Oo,7,ED_E__s,8
		BYTE	0FFH,001H,02CH,0B4H
		BYTE		ED_E__d,8,ED_E__e,7,ED_E__u,8,ED_E__x,8+8
		BYTE		ED_E__n,8,ED_E__o,8,ED_E__u,8,ED_E__v,8
		BYTE		ED_E__e,7,ED_E__a,8,ED_E__u,8,ED_E__x,8+8
		BYTE		ED_E__h,8,ED_H_Oo,7,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__s,8,ED_TEN4,8,ED_TEN4,8,ED_TEN4,8
		BYTE	0FFH,000H
;
EDG_OAM_DT23	EQU	$+7E0000H
		BYTE	06CH,0A4H
		BYTE		ED___HI,8+2
		BYTE		ED_E__F,7,ED_E__I,7,ED_E__N,8+2
		BYTE		ED___HI,8
		BYTE	0FFH,000H
;
;--------------------------------------------- hCc
EDG_OAM_DT24	EQU	$+7E0000H
		BYTE	01CH,0A4H
		BYTE		ED_E__E,7,ED_E__n,8,ED_E__d,8,ED_E__l,4
		BYTE		ED_E__i,4,ED_E__c,8,ED_E__h,8+8
		BYTE		ED_E__e,7,ED_E__r,7,ED_E__r,7,ED_E__e,7
		BYTE		ED_E__i,4,ED_E__c,8,ED_E__h,8,ED_E__e,8
		BYTE		ED_E__n,8+8
		BYTE		ED_E__d,8,ED_E__i,4,ED_E__e,7+8
		BYTE		ED_E__b,8,ED_E__e,7,ED_E__i,4,ED_E__d,8
		BYTE		ED_E__e,7,ED_E__n,8
		BYTE	0FFH,001H,034H,0B4H
		BYTE		ED_E__B,8,ED_E__a,8,ED_E__b,8,ED_E__y,8
		BYTE		ED_E__s,8+8
		BYTE		ED_E__i,4,ED_E__h,8,ED_E__r,7+8
		BYTE		ED_E__Z,8,ED_E__u,8,ED_E__h,8,ED_E__a,8
		BYTE		ED_E__u,8,ED_E__s,8,ED_E__e,7
		BYTE		ED_TEN4,8,ED_TEN4,8,ED_TEN4,8
		BYTE	0FFH,000H
;
EDG_OAM_DT25	EQU	$+7E0000H
		BYTE	02AH,0A4H
		BYTE		ED_E__D,8,ED_E__i,4,ED_E__e,7+8
		BYTE		ED_E__H,8,ED_E__e,7,ED_E__l,4,ED_E__d,8
		BYTE		ED_E__e,7,ED_E__n,8+8
		BYTE		ED_E__e,7,ED_E__r,7,ED_E__b,8,ED_E__l,4
		BYTE		ED_E__i,4,ED_E__c,8,ED_E__k,8,ED_E__e,7
		BYTE		ED_E__n,8+8
		BYTE		ED_E__d,8,ED_E__a,8,ED_E__s,8
		BYTE	0FFH,001H,04AH,0B4H
		BYTE		ED_E__L,7,ED_E__i,4,ED_E__c,8,ED_E__h,8
		BYTE		ED_E__t,8+8
		BYTE		ED_E__d,8,ED_E__e,7,ED_E__r,7+8
		BYTE		ED_E__W,8,ED_E__e,7,ED_E__l,4,ED_E__t,8
		BYTE		ED____X,8
		BYTE	0FFH,000H
;
EDG_OAM_DT26	EQU	$+7E0000H
		BYTE	072H,0A4H
		BYTE		ED_E__E,7,ED_E__N,8,ED_E__D,8,ED_E__E,7
		BYTE	0FFH,000H
;
EDG_OAM_PAL00	EQU	$+7E0000H
		BYTE	054H,0A8H
		BYTE		ED_CSL2,8,ED_E__D,8,ED_E__i,4,ED_E__r,7
		BYTE		ED_E__e,7,ED_E__c,8,ED_E__t,8,ED_E__e,8
		BYTE		ED_E__u,8,ED_E__r,7,ED_E__s,8,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL03	EQU	$+7E0000H
		BYTE	048H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__g,8,ED_E__r,7,ED_E__a,8,ED_E__m,8
		BYTE		ED_E__m,8,ED_E__e,7,ED_E__u,8,ED_E__r,7
		BYTE		ED_E__s,8,ED_CSL1,8
		BYTE		0FFH,000H
;
EDG_OAM_PAL09	EQU	$+7E0000H
		BYTE	031H,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__o,8,ED_E__n,8
		BYTE		ED_E__c,8,ED_E__e,7,ED_E__p,8,ED_E__t,8+8
		BYTE		ED_E__d,8,ED_E__e,7,ED_E__s,8+8
		BYTE		ED_E__M,8,ED_E__o,8,ED_E__n,8,ED_E__d,8
		BYTE		ED_E__e,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL0C	EQU	$+7E0000H
		BYTE	03FH,0A8H
		BYTE		ED_CSL2,8,ED_E__M,8,ED_E__u,8,ED_E__s,8
		BYTE		ED_E__i,4,ED_E__q,8,ED_E__u,8,ED_E__e,7+8
		BYTE		ED_E__e,7,ED_E__t,8+8
		BYTE		ED_E__s,8,ED_E__o,8,ED_E__n,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL0E	EQU	$+7E0000H
		BYTE	020H,0A8H
		BYTE		ED_CSL2,8,ED_E__C,8,ED_E__o,8,ED_E__n,8
		BYTE		ED_E__c,8,ED_E__e,7,ED_E__p,8,ED_E__t,8+8
		BYTE		ED_E__d,8,ED_E__e,7,ED_E__s,8+8
		BYTE		ED_E__P,8,ED_E__e,7,ED_E__r,7,ED_E__s,8
		BYTE		ED_E__o,8,ED_E__n,8,ED_E__n,8,ED_E__a,8
		BYTE		ED_E__g,8,ED_E__e,7,ED_E__s,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL11	EQU	$7E0000H
		BYTE	050H,0A8H
		BYTE		ED_CSL2,8,ED_E__I,5,ED_E__n,8,ED_E__f,7
		BYTE		ED_E__o,8,ED_E__g,8,ED_E__r,7,ED_E__a,8
		BYTE		ED_E__p,8,ED_E__h,8,ED_E__i,4,ED_E__e,7
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL13	EQU	$+7E0000H
		BYTE	036H,0A8H
		BYTE		ED_CSL2,8,ED_E__U,8,ED_E__n,8+8
		BYTE		ED_E__g,8,ED_E__r,7,ED_E__a,8,ED_E__n,8
		BYTE		ED_E__d,8+8
		BYTE		ED_E__m,8,ED_E__e,8,ED_E__r,7,ED_E__c,8
		BYTE		ED_E__i,4+8
		BYTE		ED_H_Aa,4+8
		BYTE		ED_H_Zu,7,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL1A	EQU	$+7E0000H
		BYTE	058H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__d,8,ED_E__u,8,ED_E__c,8,ED_E__t,8
		BYTE		ED_E__e,7,ED_E__u,8,ED_E__r,7,ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_PAL1C	EQU	$+7E0000H
		BYTE	030H,0A8H
		BYTE		ED_CSL2,8,ED_E__P,8,ED_E__r,7,ED_E__o,8
		BYTE		ED_E__d,8,ED_E__u,8,ED_E__c,8,ED_E__t,8
		BYTE		ED_E__e,7,ED_E__u,8,ED_E__r,7+8
		BYTE		ED_E__E,8,ED_E__x,8,ED_H_Oo,7,ED_E__c,8
		BYTE		ED_E__u,8,ED_E__t,8,ED_E__i,4,ED_E__f,8
		BYTE		ED_CSL1,8
		BYTE	0FFH,000H
;
EDG_OAM_ADR	EQU	$+7E0000H
		WORD	EDG_OAM_DT00	; _~[
		WORD	EDG_OAM_DT00,EDG_OAM_DT01,EDG_OAM_DT02
		WORD	EDG_OAM_DT03,EDG_OAM_DT04,EDG_OAM_DT05
		WORD	EDG_OAM_DT06,EDG_OAM_DT07,EDG_OAM_DT08
		WORD	EDG_OAM_DT09,EDG_OAM_DT0A,EDG_OAM_DT0B
		WORD	EDG_OAM_DT0C,EDG_OAM_DT0D,EDG_OAM_DT0E
		WORD	EDG_OAM_DT0F,EDG_OAM_DT10,EDG_OAM_DT11
		WORD	EDG_OAM_DT12,EDG_OAM_DT13,EDG_OAM_DT14
		WORD	EDG_OAM_DT15,EDG_OAM_DT16,EDG_OAM_DT17
		WORD	EDG_OAM_DT18,EDG_OAM_DT19,EDG_OAM_PAL0
		WORD	EDG_OAM_PAL1,EDG_OAM_PAL2,EDG_OAM_DT1A
		WORD	EDG_OAM_DT1B,EDG_OAM_DT1C,EDG_OAM_DT1D
		WORD	EDG_OAM_DT1E,EDG_OAM_DT1F,EDG_OAM_DT20
;
EDG_OAM_ADR_END EQU	$+7E0000H
;
;
EDG_OAM_PAL_F	EQU	$+7E0000H
		WORD	EDG_OAM_DT00	; _~[
		WORD	EDG_OAM_PAL00,EDG_OAM_DT01,EDG_OAM_DT02
		WORD	EDG_OAM_PAL03,EDG_OAM_DT04,EDG_OAM_DT05
		WORD	EDG_OAM_DT06,EDG_OAM_DT07,EDG_OAM_DT08
		WORD	EDG_OAM_PAL09,EDG_OAM_DT0A,EDG_OAM_DT0B
		WORD	EDG_OAM_PAL0C,EDG_OAM_DT0D,EDG_OAM_PAL0E
		WORD	EDG_OAM_DT0F,EDG_OAM_DT10,EDG_OAM_PAL11
		WORD	EDG_OAM_DT12,EDG_OAM_PAL13,EDG_OAM_DT14
		WORD	EDG_OAM_DT15,EDG_OAM_DT16,EDG_OAM_DT17
		WORD	EDG_OAM_DT18,EDG_OAM_DT19,EDG_OAM_PAL0
		WORD	EDG_OAM_PAL1,EDG_OAM_PAL2,EDG_OAM_PAL1A
		WORD	EDG_OAM_DT1B,EDG_OAM_PAL1C,EDG_OAM_DT1D
		WORD	EDG_OAM_DT21,EDG_OAM_DT22,EDG_OAM_DT23
;
EDG_OAM_PAL_D	EQU	$+7E0000H
		WORD	EDG_OAM_DT00	; _~[
		WORD	EDG_OAM_DT00,EDG_OAM_DT01,EDG_OAM_DT02
		WORD	EDG_OAM_DT03,EDG_OAM_DT04,EDG_OAM_DT05
		WORD	EDG_OAM_DT06,EDG_OAM_DT07,EDG_OAM_DT08
		WORD	EDG_OAM_DT09,EDG_OAM_DT0A,EDG_OAM_DT0B
		WORD	EDG_OAM_DT0C,EDG_OAM_DT0D,EDG_OAM_DT0E
		WORD	EDG_OAM_DT0F,EDG_OAM_DT10,EDG_OAM_DT11
		WORD	EDG_OAM_DT12,EDG_OAM_DT13,EDG_OAM_DT14
		WORD	EDG_OAM_DT15,EDG_OAM_DT16,EDG_OAM_DT17
		WORD	EDG_OAM_DT18,EDG_OAM_DT19,EDG_OAM_PAL0
		WORD	EDG_OAM_PAL1,EDG_OAM_PAL2,EDG_OAM_DT1A
		WORD	EDG_OAM_DT1B,EDG_OAM_DT1C,EDG_OAM_DT1D
		WORD	EDG_OAM_DT24,EDG_OAM_DT25,EDG_OAM_DT26
;
EDG_ADR_PAL	EQU	$+7E0000H
		WORD	EDG_OAM_ADR,EDG_OAM_PAL_F,EDG_OAM_PAL_D
;
EDG_OAM_ADR_CT	EQU	EDG_OAM_ADR_END-EDG_OAM_ADR-2
;
 ENDIF	  ;**** PAL Ή [1995/07/27] *****************************
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
;
;****************************************************************
;*								*
;*	GfBO bZ[W n`l Zbg			*
;*								*
;****************************************************************
EDG_OAM_SET	EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		PHA
;
		LDX	!END_MK
		LDA	!END_MJ_COL_BF+000H*2+000H*2
		CLC
		ADC	>BTMP_COL_DT,X
		BMI	EDG_OAM_500
		STA	!END_MJ_COL_BF+000H*2+000H*2
		STA	!END_MJ_COL_BF+000H*2+002H*2
		STA	!END_MJ_COL_BF+004H*2+001H*2
		STA	!END_MJ_COL_BF+004H*2+002H*2
;
EDG_OAM_500	EQU	$
		LDX	#000H
		LDA	#0F080H
EDG_OAM_550	EQU	$		; n`lNA
		STA	!END_OAM+000H,X
		STZ	!END_OAM+002H,X
		STA	!END_OAM+100H,X
		STZ	!END_OAM+102H,X
		DEX
		DEX
		DEX
		DEX
		BNE	EDG_OAM_550
;
		LDA	!END_OBJ_CT
		ASL	A
		TAX
		LDA	>EDG_OAM_ADR,X
		STA	<WORK0
		LDA	#BANK 7E0000H
		STA	<WORK2
;
EDG_OAM_620	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
		TXY
EDG_OAM_630	EQU	$
		M16			; memory 16bit mode
		LDA	[<WORK0],Y
		STA	<WORKA
		INY
		INY
		M8			; memory 8bit mode
;
EDG_OAM_640	EQU	$
		LDA	[<WORK0],Y
		CMP	#0FFH
		BEQ	EDG_OAM_660
		PHA
		AND	#0EFH
		STA	!END_OAM+2,X	; LN^[m.
		ORA	#010H
		STA	!END_OAM+6,X
		PLA
		AND	#010H
		LSR	A
		LSR	A
		LSR	A
		ORA	#00111101B
		STA	!END_OAM+3,X	; Agr[g
		STA	!END_OAM+7,X
		LDA	<WORKA
		STA	!END_OAM+0,X	; wW
		STA	!END_OAM+4,X
		CLC
		ADC	<END_OAM_XCT
		STA	<WORKA
		LDA	<WORKB
		STA	!END_OAM+1,X	; xW
		CLC
		ADC	#008
		STA	!END_OAM+5,X
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#008
		TAX
		INY
		M8			; memory 8bit mode
		BRA	EDG_OAM_640
;
EDG_OAM_660	EQU	$
		INY
		LDA	[<WORK0],Y	; f[^ ?
		BEQ	EDG_OAM_990	;	YES -> EDG_OAM_990
		INY
		DEC	A		; w,xW`FW ?
		BEQ	EDG_OAM_630	;	YES -> EDG_OAM_630
		DEC	A
		BEQ	EDG_OAM_670
		LDA	<WORKA		; wW`FW
		CLC
		ADC	#008
		STA	<WORKA
		BRA	EDG_OAM_640
EDG_OAM_670	EQU	$		; xW`FW
		LDA	[<WORK0],Y
		CLC
		ADC	<WORKB
		STA	<WORKB
		INY
		BRA	EDG_OAM_640
;
EDG_OAM_990	EQU	$
		M16			; memory 16bit mode
		PLA
		STA	<WORK0
		MI8			; memory , index 8bit mode
		RTS
;
;
BTMP_COL_DT	EQU	$+7E0000H
		WORD	0F7BEH,00842H
;
;--------------------------------------------------------
;-		X^bt[ f[^			-
;-			0FFH : Rg[ R[h	-
;-				00 : f[^I		-
;-				01 : w,xW`FW	-
;-				02 : xW`FW	-
;-				03 : wW`FW	-
;--------------------------------------------------------
EDG_OAM_DT00	EQU	$+7E0000H
		BYTE	054H,0A8H
		BYTE		ED_CSL2,ED_E__D,ED_E__i,ED_E__r,ED_E__e
		BYTE		ED_E__c,ED_E__t,ED_E__o,ED_E__r,ED_E__s
		BYTE		ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT01	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__T,ED_E__a,ED_E__k,ED_E__a,ED_E__s
		BYTE		ED_E__h,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__e,ED_E__z,ED_E__u,ED_E__k
		BYTE		ED_E__a
		BYTE	0FFH,001H,038H,0B4H
		BYTE		ED_E__T,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__h,ED_E__i,ED_E__k,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__N,ED_E__a,ED_E__k,ED_E__a
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT02	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__f,ED_E__u,ED_E__m,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__H,ED_E__i,ED_E__n,ED_E__o
		BYTE	0FFH,001H,04AH,0B4H
		BYTE		ED_E__H,ED_E__i,ED_E__d,ED_E__e,ED_E__k
		BYTE		ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__o,ED_E__n,ED_E__n,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT03	EQU	$+7E0000H
		BYTE	046H,0A8H
		BYTE		ED_CSL2,ED_E__P,ED_E__r,ED_E__o
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__r,ED_E__a,ED_E__m,ED_E__m,ED_E__e
		BYTE	ED_E__r,ED_E__s,ED_CSL1
		BYTE		0FFH,000H
;
EDG_OAM_DT04	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__T,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__I,ED_E__w,ED_E__a,ED_E__w,ED_E__a
		BYTE		ED_E__k,ED_E__i
		BYTE	0FFH,001H,050H,0B4H
		BYTE		ED_E__M,ED_E__a,ED_E__s,ED_E__a,ED_E__r
		BYTE		ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__N,ED_E__i,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT05	EQU	$+7E0000H
		BYTE	04AH,0A4H
		BYTE		ED_E__K,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__y
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__o,ED_E__s
		BYTE		ED_E__h,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__o,ED_E__d,ED_E__a
		BYTE	0FFH,001H,03CH,0B4H
		BYTE		ED_E__S,ED_E__a,ED_E__t,ED_E__o,ED_E__r
		BYTE		ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__a,ED_E__k,ED_E__a,ED_E__h
		BYTE		ED_E__a,ED_E__t,ED_E__a
		BYTE	0FFH,000H
;
EDG_OAM_DT06	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__K,ED_E__a,ED_E__z,ED_E__u,ED_E__a
		BYTE		ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__M,ED_E__o,ED_E__r,ED_E__i,ED_E__t
		BYTE		ED_E__a
		BYTE	0FFH,001H,03CH,0B0H
		BYTE		ED_E__Y,ED_E__u,ED_E__i,ED_E__c,ED_E__h
		BYTE		ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__a,ED_E__m,ED_E__a,ED_E__m
		BYTE		ED_E__o,ED_E__t,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT07	EQU	$+7E0000H
		BYTE	02CH,0A4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__h,ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__a,ED_E__s,ED_E__a,ED_E__m
		BYTE		ED_E__a,ED_E__t,ED_E__s,ED_E__u
		BYTE	0FFH,001H,03CH,0B4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__d,ED_E__a
		BYTE	0FFH,000H
;
EDG_OAM_DT08	EQU	$+7E0000H
		BYTE	038H,0A4H
		BYTE		ED_E__Y,ED_E__a,ED_E__s,ED_E__u,ED_E__n
		BYTE		ED_E__o,ED_E__r,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__a,ED_E__k,ED_E__e,ED_E__t
		BYTE		ED_E__a,ED_E__n,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT09	EQU	$+7E0000H
		BYTE	038H,0A8H
		BYTE		ED_CSL2,ED_E__C,ED_E__o,ED_E__u
		BYTE		ED_E__r,ED_E__s,ED_E__e
		BYTE	0FFH,003H
		BYTE		ED_E__D,ED_E__e,ED_E__s,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__n,ED_E__e,ED_E__r,ED_E__s,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT0A	EQU	$+7E0000H
		BYTE	034H,0A4H
		BYTE		ED_E__Y,ED_E__a,ED_E__s,ED_E__u
		BYTE		ED_E__h,ED_E__i,ED_E__s,ED_E__a
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__a,ED_E__m,ED_E__a,ED_E__m
		BYTE		ED_E__u,ED_E__r,ED_E__a
		BYTE	0FFH,001H,054H,0B4H
		BYTE		ED_E__K,ED_E__e,ED_E__n,ED_E__t,ED_E__a
		BYTE	0FFH,003H
		BYTE		ED_E__U,ED_E__s,ED_E__u,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT0B	EQU	$+7E0000H
		BYTE	03AH,0A4H
		BYTE		ED_E__Y,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__h,ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__N,ED_E__o,ED_E__m,ED_E__o,ED_E__t
		BYTE		ED_E__o
		BYTE	0FFH,001H,058H,0B4H
		BYTE		ED_E__E,ED_E__i
		BYTE	0FFH,002H,002H
		BYTE		ED_E__j
		BYTE	0FFH,002H,0FEH
		BYTE		ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__N,ED_E__o,ED_E__t,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT0C	EQU	$+7E0000H
		BYTE	039H,0A8H
		BYTE		ED_CSL2,ED_E__S,ED_E__o,ED_E__u,ED_E__n
		BYTE		ED_E__d
		BYTE	0FFH,003H
		BYTE		ED_E__C,ED_E__o,ED_E__m
		BYTE	0FFH,002H,004H
		BYTE		ED_E__p
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__o,ED_E__s,ED_E__e,ED_E__r,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT0D	EQU	$+7E0000H
		BYTE	054H,0A4H
		BYTE		ED_E__K,ED_E__o
		BYTE	0FFH,002H,002H
		BYTE		ED_E__j
		BYTE	0FFH,002H,0FEH
		BYTE		ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__o,ED_E__n,ED_E__d,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT0E	EQU	$+7E0000H
		BYTE	023H,0A8H
		BYTE		ED_CSL2,ED_E__C,ED_E__h,ED_E__a,ED_E__r
		BYTE		ED_E__a,ED_E__c,ED_E__t,ED_E__e,ED_E__r
		BYTE	0FFH,003H
		BYTE		ED_E__D,ED_E__e,ED_E__s,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__n,ED_E__e,ED_E__r,ED_E__s,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT0F	EQU	$+7E0000H
		BYTE	042H,0A4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__f,ED_E__u,ED_E__m,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__H,ED_E__i,ED_E__n,ED_E__o
		BYTE	0FFH,001H,042H,0B4H
		BYTE		ED_E__H,ED_E__i,ED_E__s,ED_E__a,ED_E__s
		BYTE		ED_E__h,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__N,ED_E__o
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__a,ED_E__m,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT10	EQU	$+7E0000H
		BYTE	03CH,0A4H
		BYTE		ED_E__M,ED_E__a,ED_E__s,ED_E__a,ED_E__h
		BYTE		ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__I,ED_E__i,ED_E__m,ED_E__u,ED_E__r
		BYTE		ED_E__a
		BYTE	0FFH,001H,03CH,0B4H
		BYTE		ED_E__T,ED_E__o,ED_E__m,ED_E__o,ED_E__a
		BYTE		ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__u,ED_E__r,ED_E__o,ED_E__u
		BYTE		ED_E__m,ED_E__e
		BYTE	0FFH,000H
;
EDG_OAM_DT11	EQU	$+7E0000H
		BYTE	040H,0A8H
		BYTE		ED_CSL2,ED_E__C,ED_TEN4,ED_E__G,ED_TEN4
		BYTE		ED_E__D,ED_E__e,ED_E__s,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__n,ED_E__e,ED_E__r,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT12	EQU	$+7E0000H
		BYTE	03EH,0A4H
		BYTE		ED_E__Y,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__a,ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__o,ED_E__i,ED_E__z,ED_E__u
		BYTE		ED_E__m,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT13	EQU	$+7E0000H
		BYTE	02CH,0A8H
		BYTE		ED_CSL2,ED_E__S
		BYTE	0FFH,002,004H
		BYTE		ED_E__p
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__c,ED_E__i,ED_E__a,ED_E__l
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__h,ED_E__a,ED_E__n,ED_E__k
		BYTE		ED_E__s
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__o,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT14	EQU	$+7E0000H
		BYTE	03CH,0A4H
		BYTE		ED_E__W,ED_E__a,ED_E__t,ED_E__a,ED_E__r
		BYTE		ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__a,ED_E__m,ED_E__a
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__u,ED_E__c,ED_E__h,ED_E__i
		BYTE	0FFH,001H,03CH,0B4H
		BYTE		ED_E__Y,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__H,ED_E__a,ED_E__r,ED_E__u,ED_E__h
		BYTE		ED_E__a,ED_E__n,ED_E__a
		BYTE	0FFH,000H
;
EDG_OAM_DT15	EQU	$+7E0000H
		BYTE	046H,0A4H
		BYTE		ED_E__Y,ED_E__o,ED_E__i,ED_E__c,ED_E__h
		BYTE		ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__o,ED_E__t,ED_E__a,ED_E__b
		BYTE		ED_E__e
		BYTE	0FFH,001H,042H,0B4H
		BYTE		ED_E__Y,ED_E__a,ED_E__s,ED_E__u,ED_E__h
		BYTE		ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__S,ED_E__a,ED_E__k,ED_E__a,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT16	EQU	$+7E0000H
		BYTE	040H,0A4H
		BYTE		ED_E__H,ED_E__i,ED_E__r,ED_E__o,ED_E__n
		BYTE		ED_E__o,ED_E__b,ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__a,ED_E__k,ED_E__u,ED_E__i
		BYTE	0FFH,001H,032H,0B4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__k,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__a,ED_E__m,ED_E__a,ED_E__s
		BYTE		ED_E__h,ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT17	EQU	$+7E0000H
		BYTE	03EH,0A4H
		BYTE		ED_E__K,ED_E__i,ED_E__m,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__y
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__F,ED_E__u,ED_E__k,ED_E__u,ED_E__i
		BYTE	0FFH,001H,054H,0B4H
		BYTE		ED_E__K,ED_E__e,ED_E__i,ED_E__z,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__K,ED_E__a,ED_E__t,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT18	EQU	$+7E0000H
		BYTE	03CH,0A4H
		BYTE		ED_E__S,ED_E__o,ED_E__i,ED_E__c,ED_E__h
		BYTE		ED_E__i,ED_E__r,ED_E__o
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__o,ED_E__m,ED_E__i,ED_E__t
		BYTE		ED_E__a
		BYTE	0FFH,001H,044H,0B4H
		BYTE		ED_E__M,ED_E__i,ED_E__e
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__o,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__m,ED_E__u,ED_E__r,ED_E__a
		BYTE	0FFH,000H
;
EDG_OAM_DT19	EQU	$+7E0000H
		BYTE	03CH,0A4H
		BYTE		ED_E__K,ED_E__e,ED_E__n,ED_E__s,ED_E__u
		BYTE		ED_E__k,ED_E__e
		BYTE	0FFH,003H
		BYTE		ED_E__T,ED_E__a,ED_E__n,ED_E__a,ED_E__b
		BYTE		ED_E__e
		BYTE	0FFH,001H,03CH,0B4H
		BYTE		ED_E__T,ED_E__e,ED_E__t,ED_E__s,ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__H,ED_E__a,ED_E__s,ED_E__h,ED_E__i
		BYTE		ED_E__m,ED_E__o,ED_E__t,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT1A	EQU	$+7E0000H
		BYTE	050H,0A8H
		BYTE		ED_CSL2,ED_E__P,ED_E__r,ED_E__o,ED_E__d
		BYTE		ED_E__u,ED_E__c,ED_E__e,ED_E__r,ED_CSL1
		BYTE	0FFH,000h
;
EDG_OAM_DT1B	EQU	$+7E0000H
		BYTE	038H,0A4H
		BYTE		ED_E__S,ED_E__h,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__g
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__e,ED_E__r,ED_E__u
		BYTE	0FFH,003H
		BYTE		ED_E__M,ED_E__i
		BYTE	0FFH,002H,004H
		BYTE		ED_E__y
		BYTE	0FFH,002H,0FCH
		BYTE		ED_E__a,ED_E__m,ED_E__o,ED_E__t,ED_E__o
		BYTE	0FFH,000H
;
EDG_OAM_DT1C	EQU	$+7E0000H
		BYTE	026H,0A8H
		BYTE		ED_CSL2,ED_E__E,ED_E__x,ED_E__e,ED_E__c
		BYTE		ED_E__u,ED_E__t,ED_E__i,ED_E__v,ED_E__e
		BYTE	0FFH,003H
		BYTE		ED_E__P,ED_E__r,ED_E__o,ED_E__d,ED_E__u
		BYTE		ED_E__c,ED_E__e,ED_E__r,ED_CSL1
		BYTE	0FFH,000H
;
EDG_OAM_DT1D	EQU	$+7E0000H
		BYTE	038H,0A4H
		BYTE		ED_E__H,ED_E__i,ED_E__r,ED_E__o,ED_E__s
		BYTE		ED_E__h,ED_E__i
		BYTE	0FFH,003H
		BYTE		ED_E__Y,ED_E__a,ED_E__m,ED_E__a,ED_E__u
		BYTE		ED_E__c,ED_E__h,ED_E__i
		BYTE	0FFH,000H
;
EDG_OAM_DT1E	EQU	$+7E0000H
		BYTE	048H,0A4H
		BYTE		ED_H_Do,ED_H_Uu,ED_H_Ya,ED_H_Ra,ED_KANM
		BYTE		ED_K_Pa,ED_K_Pa,ED_H_To,ED_K_Ma,ED_K_Ma
		BYTE		ED_H_No,ED_H_Su,ED_H_Mu
		BYTE	0FFH,001H,048H,0B4H
		BYTE		ED_H_Ku,ED_H_Ni,ED_H_Ni,ED_H_Tu,ED_H_Ii
		BYTE		ED_H_Ta,ED_H_Yo,ED_H_Uu,ED_H_De,ED_H_Su
		BYTE		ED_MARU
		BYTE	0FFH,000H
;
EDG_OAM_DT1F	EQU	$+7E0000H
		BYTE	050H,0A4H
		BYTE		ED_K_Hi,ED___HI,ED_K_Ro,ED___HI
		BYTE		ED_H_Ta,ED_H_Nn,ED_H_Zi,ED_H_yo,ED_H_Uu,ED____X ,ED____X
		BYTE	0FFH,000H
;
EDG_OAM_DT20	EQU	$+7E0000H
		BYTE	062H,0A4H
		BYTE		ED_E__T,ED_E__H,ED_E__E
		BYTE	0FFH,003H
		BYTE		ED_E__E,ED_E__N,ED_E__D
;;;;K;;;;		BYTE		0DEH,0DFH,0F8H,0F9H,0FAH,0FBH,058H
;;;;K;;;;		BYTE		0FAH,0FBH,0FCH,0FDH,0FEH,03EH
		BYTE	0FFH,000H
;
EDG_OAM_ADR	EQU	$+7E0000H
		WORD	EDG_OAM_DT00	; _~[
		WORD	EDG_OAM_DT00,EDG_OAM_DT01,EDG_OAM_DT02
		WORD	EDG_OAM_DT03,EDG_OAM_DT04,EDG_OAM_DT05
		WORD	EDG_OAM_DT06,EDG_OAM_DT07,EDG_OAM_DT08
		WORD	EDG_OAM_DT09,EDG_OAM_DT0A,EDG_OAM_DT0B
		WORD	EDG_OAM_DT0C,EDG_OAM_DT0D,EDG_OAM_DT0E
		WORD	EDG_OAM_DT0F,EDG_OAM_DT10,EDG_OAM_DT11
		WORD	EDG_OAM_DT12,EDG_OAM_DT13,EDG_OAM_DT14
		WORD	EDG_OAM_DT15,EDG_OAM_DT16,EDG_OAM_DT17
		WORD	EDG_OAM_DT18,EDG_OAM_DT19,EDG_OAM_DT1A
		WORD	EDG_OAM_DT1B,EDG_OAM_DT1C,EDG_OAM_DT1D
		WORD	EDG_OAM_DT1E,EDG_OAM_DT1F,EDG_OAM_DT20
;
EDG_OAM_ADR_END EQU	$+7E0000H
;
EDG_OAM_ADR_CT	EQU	EDG_OAM_ADR_END-EDG_OAM_ADR-2
;
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
;************************************************************************
;*		IRQ ( {[iXXe[W )				*
;************************************************************************
;
IRQ300		EQU	$
		LDA	IRQFLG
		BNE	IRQ310		;H-DMA "ON" IRQ ? ( no:IRQ310 )
;
;-------------- H-DMA "ON" IRQ ------------------------------------------
IRQ3002		EQU	$
		BIT	4212H
		BVS	IRQ3002
IRQ3004		EQU	$
		BIT	4212H
		BVC	IRQ3004
;
 IF  JPN | NES ;**** { or NES Ή [1995/8/7] ************************
		LDA	HD420C
 ELSE	       ;**** PAL Ή [1995/8/7] ********************************
		LDA	NMI_HD420C
 ENDIF
		STA	420CH		;H-DMA "ON"
		STZ	2100H		;fade "OFF"
;
;-------------- blanking "OFF" IRQ timer set --------------------
;;;;		    LDA	    #070H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#08H		;V counter set
		BRA	IRQ320
;
IRQ310		EQU	$
		DEC	A
		BNE	IRQ350		;blanking "OFF" IRQ ? ( no:IRQ350 )
;
;-------------- blanking "OFF" IRQ --------------------------------------
IRQ3102		EQU	$
		BIT	4212H
		BVS	IRQ3102
IRQ3104		EQU	$
		BIT	4212H
		BVC	IRQ3104
;
 IF  JPN | NES ;**** { or NES Ή [1995/8/7] ************************
		LDA	FADNO		;fade in
 ELSE	       ;**** PAL Ή [1995/8/7] ********************************
		LDA	NMI_FADNO	    ;fade in
 ENDIF
		STA	2100H
;
;-------------- NMI-IRQ timer set -------------------------------
;;;;		    LDA	    #070H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
IRQ320		EQU	$
		INC	IRQFLG
;
IRQ330		EQU	$
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
		RTS
;
;------------------------------------------------------------------------
;-		NMI-IRQ							-
;------------------------------------------------------------------------
IRQ350		EQU	$
		BIT	4212H
		BVS	IRQ350
IRQ3504		EQU	$
		BIT	4212H
		BVC	IRQ3504
;
		LDY	#10001111B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDA	NMIFLG
		BNE	IRQ360		;time over ? ( no:IRQ360 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ380
;
;-------------- ԃI[o[II ----------------------------
IRQ360		EQU	$

 IF  PAL  ;**** PAL Ή [1995/8/7] *************************************
		LDA	HD420C
		STA	NMI_HD420C	;NMI set H-DMA flag
		LDA	FADNO
		STA	NMI_FADNO	;NMI set contrast flag
 ENDIF	  ;**** PAL Ή [1995/8/7] *************************************
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		PHD			;(D) save
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
;
		DPAGE	420BH
;
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		JSR	PCHDMA		;player chara DMA set
;
		LDY	MSGTRF
		BEQ	IRQ370		;massage bitmap transfer ? ( no:IRQ370 )
;
		JSR	MSGDMA		;massage bitmap DMA set
		STZ	MSGTRF		;	"       transfer flag clear !!
		BRA	IRQ371
IRQ370		EQU	$
		JSR	OB7DMA		;
;
IRQ371		EQU	$
		LDA	MODENO
		CMP	#MINPL+1
		BNE	IRQ373		; ~jQ[@H
;					; Yes !!
		LDA	HD420C
		AND	#00020H		; H-DMA "ON" ?
		BEQ	IRQ374		;	NO -> IRQ374
;
		LDA	HDMCNT
		STA	>HDMABUF+00H
		EOR	#0FFFFH
		INC	A
		STA	>HDMABUF+02H
;
IRQ374		EQU	$
;
;-------------- af XN[  ------------------------
		JSR	BGSCWT		;BG screen write
;
IRQ373		EQU	$
		PLD			;(D) load
;
;
		DPAGE	WORK
;
;
		M8			; memory 8bit mode
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;BG1 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
;-------------- PPU Reg. set ------------------------------------
		LDA	MANSEL		;main select set
		STA	212CH
		LDA	SUBSEL		;sub	  "
		STA	212DH
		LDA	WMANSL		;window main select set
		STA	212EH
		LDA	WSUBSL		;   "   sub     "
		STA	212FH
		LDA	BG12CH		;BG1,2 character base address set
		STA	210BH
		LDA	BG1SCF		;BG1 screen base address set
		STA	2107H
		LDA	BGMODE		;BG mode set
		STA	2105H
;
		LDA	WIND23		;window "ON/OFF" set
		STA	2123H
		LDA	WIND24
		STA	2124H
		LDA	WIND25
		STA	2125H
		LDA	WIND30		;color window "ON/OFF" set
		STA	2130H
		LDA	SUBADF		;main & sub add set
		STA	2131H
		LDA	WLOGIC		;window logic set
		STA	212AH
		LDA	WLOGIC+1
		STA	212BH
		LDA	BG2SCF		;BG2 screen base address set
		STA	2108H
		LDA	BG3SCF		;BG3	      "
		STA	2109H
		LDA	MOZNO		;mozaiku set
		STA	2106H
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
;-------------- H-DMA initial start set -------------------------
IRQ380		EQU	$
;
		M16
;
		LDA	#4300H
		TCD
;
;
		DPAGE	4300H
;
;
		LDA	<4312H		 ;H-DMA start table address set
		STA	<4318H
		LDA	<4322H
		STA	<4328H
		LDA	<4332H
		STA	<4338H
		LDA	<4342H
		STA	<4348H
		LDA	<4352H
		STA	<4358H
		LDA	<4362H
		STA	<4368H
		LDA	<4372H
		STA	<4378H
;
		M8
;
		LDA	#01H		;start line counter set
		STA	<431AH
		STA	<432AH
		STA	<433AH
		STA	<434AH
		STA	<435AH
		STA	<436AH
		STA	<437AH
;
		STZ	IRQFLG
;
;;;;		    LDA	    #0C0H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#006H		;V counter set
		JMP	IRQ330
;
;
;
;
;
		DPAGE	420BH
;
;
;************************************************************************
;*		OBJ DMA							*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
		MEM16
		IDX8
;
OBJDMA		EQU	$
		STZ	2102H		;OAM address set ( 00~ )
;
		STZ	<4300H		;DMA control parameter
		LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
		STA	<4301H
		LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H)	;DMA A bus address(H,B)
		STA	<4303H
		LDA	#0220H		;DMA number of byte
		STA	<4305H
		STX	<420BH
		RTS
;
;
;************************************************************************
;*		OBJ DMA							*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
END_OBJDMA	EQU	$
		M16			; memory 16bit mode
		STZ	2102H		;OAM address set ( 00~ )
;
		STZ	4300H		;DMA control parameter
		LDA	#04+((END_OAM&0000FFH)*100H)
		STA	4301H		;DMA B bus address & A bus address(L)
		LDA	#((END_OAM&00FF00H)/100H)+((END_OAM&0FF0000H)/100H)
		STA	4303H		;DMA A bus address(H,B)
		LDA	#0220H		;DMA number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH		;DMA "ON" flag
		M8			; memory 8bit mode
		RTS
;
;************************************************************************
;*		color DMA						*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
		MEM16
		IDX8
;
COLDMA		EQU	$
;
;------------------------------------------------------------------------
;-		constant color set					-
;------------------------------------------------------------------------
		LDA	NUKCOL
		AND	#00011111B	;[ red ]
		ORA	#00100000B
		TAY
		STY	2132H
		LDA	NUKCOL		;[ green ]
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		TAY
		STY	2132H
		LDA	NUKCOL+1	;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		TAY
		STY	2132H
;
;------------------------------------------------------------------------
;-		C.G RAM DMA set						-
;------------------------------------------------------------------------
CGDMA		EQU	$
		LDY	#00
		STY	2121H			;C.G RAM address set
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address set
		STA	<4300H
		LDA	#DATACOL		;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK DATACOL		;	"     (B) set
		STY	<4304H
		LDA	#0200H			;number of byte
		STA	<4305H
		STX	<420BH			;DMA "ON"
		RTS
;
;************************************************************************
;*		GfBOrbg}bvp color DMA			*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
BITMAP_COLDMA	EQU	$
;
;------------------------------------------------------------------------
;-		constant color set					-
;------------------------------------------------------------------------
		LDA	NUKCOL
		AND	#00011111B	;[ red ]
		ORA	#00100000B
		TAY
		STY	2132H
		LDA	NUKCOL		;[ green ]
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		TAY
		STY	2132H
		LDA	NUKCOL+1	;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		TAY
		STY	2132H
;
;------------------------------------------------------------------------
;-		C.G RAM DMA set						-
;------------------------------------------------------------------------
		LDY	#00
		STY	2121H			;C.G RAM address set
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address set
		STA	<4300H
		LDA	#BITMAP_COL		;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK BITMAP_COL	;	"     (B) set
		STY	<4304H
		LDA	#0200H			;number of byte
		STA	<4305H
		STX	<420BH			;DMA "ON"
;
		RTS
;
;************************************************************************
;*									*
;*		BG chara DMA set ( to initial set )			*
;*									*
;************************************************************************
BGCDMA_L	EQU	$
		PHB			;(DBR) save
		PHD			;(D) save
;
		PHK			;(DBR) <-- (PBR)
		PLB
;
		M16
;
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		LDA	#020H
		STA	WORK		;(WK0,1) <-- loop no
BGCDMA_L_010	EQU	$
		INC	FRCNT2
;
		JSR	BGCDMA
;
		DEC	WORK
		BNE	BGCDMA_L_010
;
		M8
;
		PLD
		PLB
		RTL
;
		MEM16
;
;************************************************************************
;*		BG chara DMA set					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
CHRTR_MAIN_VADR EQU	$
		WORD	1400H,		 1400H
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
CHRTR_MAIN_CADR EQU	$
		WORD	CHR34+(000H*20H),CHR34+(000H*20H)	;pattern.1 [ RC ]
		WORD	CHR34+(020H*20H),CHR34+(008H*20H)	;	   [ _ubN ]
		WORD	CHR34+(028H*20H),CHR34+(000H*20H)	;	   [ _RC ]
		WORD	CHR34+(020H*20H),CHR64+(144H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(004H*20H),CHR34+(004H*20H)	;pattern.2 [ RC ]
		WORD	CHR34+(024H*20H),CHR34+(00CH*20H)	;	   [ _ubN ]
		WORD	CHR34+(02CH*20H),CHR34+(004H*20H)	;	   [ _RC ]
		WORD	CHR34+(024H*20H),CHR64+(154H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(010H*20H),CHR34+(010H*20H)	;pattern.3 [ RC ]
		WORD	CHR34+(030H*20H),CHR34+(018H*20H)	;	   [ _ubN ]
		WORD	CHR34+(038H*20H),CHR34+(010H*20H)	;	   [ _RC ]
		WORD	CHR34+(030H*20H),CHR64+(164H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(014H*20H),CHR34+(014H*20H)	;pattern.4 [ RC ]
		WORD	CHR34+(034H*20H),CHR34+(01CH*20H)	;	   [ _ubN ]
		WORD	CHR34+(03CH*20H),CHR34+(014H*20H)	;	   [ _RC ]
		WORD	CHR34+(034H*20H),CHR64+(174H*20H)	;	   [ }IubN ]
;
CHRTR_MAIN_SWCK EQU	$	;XCb``FbNp`mcf[^
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
BGCDMA		EQU	$
		LDA	ENSTFG
		BNE	BGCDMA_000
		INC	!CHR_ANIME_TM
BGCDMA_000	EQU	$
;
;-------------- ւLN^[ -----------------------------------
		LDA	CHRTRP
		ASL	A
		TAX
		JSR    (!BGCDMA_TBL,X)
;
;-------------- 풓LN^[ ---------------------------------------
		LDA	FRCNT2
		AND	#0FH<<1
		ASL	A
		TAY
		LDA	SWITCH_1
		AND	!CHRTR_MAIN_SWCK,Y
		BEQ	BGCDMA_010	;XCb`hnmhH ( no:BGCDMA_010 )
		INY
		INY
BGCDMA_010	EQU	$
		LDA	!CHRTR_MAIN_VADR,Y
		STA	2116H		;VRAM address set
		LDA	!CHRTR_MAIN_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDY	#BANK CHR34
		STY	<4304H		;	"     (B) set
		LDY	#080H
		STY	<4305H		;number of byte set
		STX	<420BH		;DMA "ON"
;
;-------------- ւݏLN^[] --------------------------------
		LDA	BGCGWF
		BEQ	BGCDMA_050	;DMA ? ( no:BGCDMA_050 )
;
		LDA	#1280H
		STA	2116H		;VRAM address set
		LDA	#WOB7CHR+(46H*20H)
		STA	<4302H		;A bus address(L,H) set
		LDY	#BANK WOB7CHR
		STY	<4304H		;	"     (B) set
		LDA	#(20H*8)
		STA	<4305H		;number of byte set
		STX	<420BH		;DMA "ON"
;
		STA	<4305H		;number of byte set
		LDA	#1380H
		STA	2116H		;VRAM address set
		LDA	#WOB7CHR+(56H*20H)
		STA	<4302H		;A bus address(L,H) set
		STX	<420BH		;DMA "ON"
;
		STZ	BGCGWF
BGCDMA_050	EQU	$
		RTS
;
;-------------- BG chara DMA set pattern table data ---------------------
BGCDMA_TBL	EQU	$
		WORD	CHRTR_00	;[00] 
		WORD	CHRTR_01	;[01] afR
		WORD	CHRTR_02	;[02] afQ_
		WORD	CHRTR_03	;[03] afR_
		WORD	CHRTR_04	;[04] ܂
		WORD	CHRTR_05	;[05] afRAX`bN()
		WORD	CHRTR_06	;[06] n`
		WORD	CHRTR_07	;[07] JxR[X (n)
		WORD	CHRTR_08	;[08] R[X g
		WORD	CHRTR_09	;[09] afR 
		WORD	CHRTR_0A	;[0A] afR 𒹂̌Q
		WORD	CHRTR_0B	;[0B] afR eknvdq
		WORD	CHRTR_0C	;[0C] WOR[X 
		WORD	CHRTR_0D	;[0D] n`Ɨn
		WORD	CHRTR_0E	;[0E] n`ƃWOR[X 
		WORD	CHRTR_0F	;[0F] afR n`pXe _
		WORD	CHRTR_10	;[10] afR {X
		WORD	CHRTR_11	;[11] afR_ƃWOR[X 
;
;-------------- ] ------------------------------------------------
CHRTR_04	EQU	$
		PLA			;[ pull pull return !! ]
		LDX	#00000001B	;DMA "ON" data set
		RTS
;
CHRTR_00	EQU	$
		LDA	!FRCNT2
		AND	#00007H
		XBA
		LSR	A
		ORA	#01000H
;
		STA	2116H		; VRAM address set
		LDA	#CHR64+001A0H*020H
		STA	<4302H		; A bus address(L,H) set
		LDX	#BANK CHR64
		STX	<4304H		;	"       (B) set
		LDA	#00100H
		STA	<4305H		; number of byte set
		LDX	#00000001B
		STX	<420BH		; DMA "ON" data set
		RTS
;
;-------------- afR ----------------------------------------------
CHRTR_01_CADR	EQU	$
		WORD	CHR3F+0800H
		WORD	CHR3F+0A00H
		WORD	CHR3F+0C00H
		WORD	CHR3F+0E00H
;
CHRTR_01	EQU	$
		LDA	#2F00H		;VRAM address set
		STA	2116H
		LDA	#200H		;number of byte set
		STA	<4305H
		LDY	#BANK CHR3F
		STY	<4304H		;A bus address(B) set
;
		LDA	FRCNT2
		LSR	A
		LSR	A
		AND	#03H*2
		TAY
		LDA	!CHRTR_01_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#00000001B
		STX	<420BH		;DMA "ON"
		RTS
;
;-------------- afQ_ ------------------------------------------------
CHRTR_02_VADR0	EQU	$
		WORD	1000H
		WORD	1080H
		WORD	1200H
		WORD	1280H
CHRTR_02_VADR1	EQU	$
		WORD	1100H
		WORD	1180H
		WORD	1300H
		WORD	1380H
CHRTR_02_CADR	EQU	$
		WORD	CHR34+(080H*20H)	;pattern.1 [ _ij]
		WORD	CHR34+(0C0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(090H*20H)	;pattern.2 [ _ij]
		WORD	CHR34+(0D0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(0A0H*20H)	;pattern.3 [ _ij]
		WORD	CHR34+(0E0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(0B0H*20H)	;pattern.4 [ _ij]
		WORD	CHR34+(0F0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
CHRTR_02	EQU	$
		LDA	FRCNT2
		AND	#0FH<<1
		TAY
		LDA	!CHRTR_02_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
;
		TYA
		AND	#03H<<1
		TAY
		LDA	!CHRTR_02_VADR0,Y
		STA	2116H		;VRAM address set
		LDA	#0100H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	<420BH		;DMA "ON"
;
		STA	<4305H		;number of byte set
		LDA	!CHRTR_02_VADR1,Y
		STA	2116H		;VRAM address set
		STX	<420BH		;DMA "ON"
		RTS
;
;-------------- afR_ ------------------------------------------------
CHRTR_03_CADR	EQU	$
		WORD	CHR70			;pattern.1 [ _ ]
		WORD	CHR70			;	   [	]
		WORD	CHR70			;	   [	]
		WORD	CHR70			;	   [	]
;
		WORD	CHR70+(020H*10H)	;pattern.2 [ _ ]
		WORD	CHR70+(020H*10H)	;	   [	]
		WORD	CHR70+(020H*10H)	;	   [	]
		WORD	CHR70+(020H*10H)	;	   [	]
;
		WORD	CHR70+(040H*10H)	;pattern.3 [ _ ]
		WORD	CHR70+(040H*10H)	;	   [	]
		WORD	CHR70+(040H*10H)	;	   [	]
		WORD	CHR70+(040H*10H)	;	   [	]
;
		WORD	CHR70+(060H*10H)	;pattern.4 [ _ ]
		WORD	CHR70+(060H*10H)	;	   [	]
		WORD	CHR70+(060H*10H)	;	   [	]
		WORD	CHR70+(060H*10H)	;	   [	]
;
CHRTR_03	EQU	$
		LDA	FRCNT2
		AND	#0FH
		ASL	A
		TAY
		LDA	!CHRTR_03_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
;
		LDA	#02F00H
		STA	2116H		;VRAM address set
		LDA	#0200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	<420BH		;DMA "ON"
		RTS
;
;-------------- afRAX`bN() --------------------
CHRTR_05_CADR	EQU	$
		WORD	CHR70+(080H*10H)
		WORD	CHR70+(0A0H*10H)
		WORD	CHR70+(0C0H*10H)
		WORD	CHR70+(0E0H*10H)
		WORD	CHR71+(000H*10H)
		WORD	CHR71+(020H*10H)
		WORD	CHR71+(040H*10H)
		WORD	CHR71+(060H*10H)
		WORD	CHR71+(040H*10H)
		WORD	CHR71+(020H*10H)
		WORD	CHR71+(000H*10H)
		WORD	CHR70+(0E0H*10H)
		WORD	CHR70+(0C0H*10H)
		WORD	CHR70+(0A0H*10H)
;
;
CHRTR_05	EQU	$
		LDA	!CHR_ANIME_CT
		INC	A
		CMP	#0000EH<<2
		BCC	CHRTR_05_100
		LDA	#00000
CHRTR_05_100	EQU	$
		STA	!CHR_ANIME_CT
		LSR	A
		AND	#000FEH
		TAY
CHRTR_05_SET	EQU	$
		LDA	CHRTR_05_CADR,Y
CHRTR_05_SET_SB EQU	$
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
		LDA	#02F00H
		STA	2116H		;VRAM address set
		LDA	#00200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	<420BH		;DMA "ON"
		RTS
;
;-------------- n`	-----------------------------------------
CHRTR_06	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00006
		BCC	CHRTR_06_10
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		INC	A
		AND	#00007H*2
		STA	!CHR_ANIME_CT
CHRTR_06_10	EQU	$
		LDY	!CHR_ANIME_CT
		LDA	!DSPMOD
		CMP	#0000AH		; _ueTpL] ?
		BNE	CHRTR_05_SET	;	NO -> CHRTR_05_SET
;
		LDA	CHRTR_05_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
		LDA	#07F00H
		STA	2116H		;VRAM address set
		LDA	#00200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	<420BH		;DMA "ON"
		RTS
;
;-------------- JxR[X (n) -------------------------------
CHRTR_07_CADR0	EQU	$
		WORD	CHR34+(040H*020H)
		WORD	CHR34+(050H*020H)
		WORD	CHR34+(060H*020H)
		WORD	CHR34+(070H*020H)
		WORD	CHR119+(000H*020H)
		WORD	CHR119+(010H*020H)
		WORD	CHR119+(020H*020H)
		WORD	CHR119+(030H*020H)
;
CHRTR_07_CADR1	EQU	$
		WORD	CHR34+(048H*020H)
		WORD	CHR34+(058H*020H)
		WORD	CHR34+(068H*020H)
		WORD	CHR34+(078H*020H)
		WORD	CHR119+(008H*020H)
		WORD	CHR119+(018H*020H)
		WORD	CHR119+(028H*020H)
		WORD	CHR119+(038H*020H)
;
CHRTR_07_CADR2	EQU	$
		WORD	CHR34+(160H*020H)
		WORD	CHR34+(170H*020H)
		WORD	CHR34+(180H*020H)
		WORD	CHR34+(190H*020H)
		WORD	CHR119+(040H*020H)
		WORD	CHR119+(050H*020H)
		WORD	CHR119+(060H*020H)
		WORD	CHR119+(070H*020H)
;
CHRTR_07_CADR3	EQU	$
		WORD	CHR34+(168H*020H)
		WORD	CHR34+(178H*020H)
		WORD	CHR34+(188H*020H)
		WORD	CHR34+(198H*020H)
		WORD	CHR119+(048H*020H)
		WORD	CHR119+(058H*020H)
		WORD	CHR119+(068H*020H)
		WORD	CHR119+(078H*020H)
;
;
CHRTR_07	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#0000BH
		BCC	CHRTR_07_00
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		AND	#00003
		STA	!CHR_ANIME_CT
CHRTR_07_00	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
;
		LDX	#BANK CHR34
		LDA	!BG1TYP
		CMP	#0000AH		; ؂̏邩 ?
		BNE	CHRTR_07_05	;	NO -> CHRTR_07_05
		TYA
		ORA	#00008
		TAY
		LDX	#BANK CHR119
;
CHRTR_07_05	EQU	$
		STX	<4304H		;A bus address(B) set
		LDX	#00000001B
		LDA	!FRCNT2
		AND	#00001
		BEQ	CHRTR_07_10
;
		LDA	CHRTR_07_CADR0,Y
		STA	<4302H
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_07_CADR1,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
CHRTR_07_10	EQU	$
		LDA	CHRTR_07_CADR2,Y
		STA	<4302H
		LDA	#01080H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_07_CADR3,Y
		STA	<4302H
		LDA	#01180H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- R[X g -------------------------------------
CHRTR_08_CADR0	EQU	$
		WORD	CHR34+(0120H*020H)
		WORD	CHR34+(0130H*020H)
		WORD	CHR34+(0140H*020H)
		WORD	CHR34+(0150H*020H)
;
CHRTR_08_CADR1	EQU	$
		WORD	CHR34+(0128H*020H)
		WORD	CHR34+(0138H*020H)
		WORD	CHR34+(0148H*020H)
		WORD	CHR34+(0158H*020H)
;
;
CHRTR_08	EQU	$
		INC	!CHR_ANIME_TM
		LDA	!CHR_ANIME_TM
		CMP	#00010H
		BCC	CHRTR_08_00
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		AND	#00003
		STA	!CHR_ANIME_CT
CHRTR_08_00	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
		LDA	CHRTR_08_CADR0,Y
		STA	<4302H
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_08_CADR1,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- afR  ------------------------------------
CHRTR_09	EQU	$
		INC	!CHR_ANIME_TM
		LDA	!CHR_ANIME_TM
		CMP	#00008H
		BCC	CHRTR_09_100
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		CLC
		ADC	#00200H
		AND	#00600H
		STA	!CHR_ANIME_CT
CHRTR_09_100	EQU	$
		LDA	#CHR3F
		CLC
		ADC	!CHR_ANIME_CT
		JMP	CHRTR_05_SET_SB
;
;-------------- afR 𒹂̌Q -----------------------------
CHRTR_0A	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00008H
		BCC	CHRTR_0A_100
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		CLC
		ADC	#00200H
		AND	#00E00H
		STA	!CHR_ANIME_CT
CHRTR_0A_100	EQU	$
		LDA	#CHR72
		CLC
		ADC	!CHR_ANIME_CT
		JMP	CHRTR_05_SET_SB
;
;-------------- afR eknvdq -----------------------------
CHRTR_0B_DAT	EQU	$
		WORD	CHR72+(000H*10H),CHR72+(020H*10H)
		WORD	CHR72+(040H*10H),CHR72+(060H*10H)
		WORD	CHR72+(080H*10H),CHR72+(0A0H*10H)
		WORD	CHR72+(0C0H*10H),CHR72+(0E0H*10H)
		WORD	CHR72+(0C0H*10H),CHR72+(0A0H*10H)
		WORD	CHR72+(080H*10H),CHR72+(060H*10H)
		WORD	CHR72+(040H*10H),CHR72+(020H*10H)
;
CHRTR_0B_CNT	EQU	$
		WORD	00010,00004,00004,00004
		WORD	00004,00004,00004,00010
		WORD	00004,00004,00004,00004
		WORD	00004,00004
;
;
CHRTR_0B	EQU	$
		LDA	!FRCNT2
		AND	#00001
		BNE	CHRTR_0B_100
		JSR	CHRTR_02
		RTS
;
CHRTR_0B_100	EQU	$
		LDA	!CHR_ANIME_CT
		AND	#0000FH
		ASL	A
		TAY
		LDA	!CHR_ANIME_TM
		CMP	CHRTR_0B_CNT,Y
		BCC	CHRTR_0B_150
		STZ	!CHR_ANIME_TM
		INC	!CHR_ANIME_CT
		LDA	!CHR_ANIME_CT
		CMP	#(CHRTR_0B-CHRTR_0B_CNT)/2
		BCC	CHRTR_0B_150
		STZ	!CHR_ANIME_CT
CHRTR_0B_150	EQU	$
		LDA	CHRTR_0B_DAT,Y
		JMP	CHRTR_05_SET_SB
;
;-------------- WOR[X  ---------------------------
CHRTR_0C_DAT0	EQU	$
		WORD	CHR34+(0100H*020H),CHR34+(0108H*020H)
		WORD	CHR34+(0110H*020H),CHR34+(0118H*020H)
		WORD	CHR34+(01A0H*020H),CHR34+(01A8H*020H)
		WORD	CHR34+(01B0H*020H),CHR34+(01B8H*020H)
		WORD	CHR34+(01A0H*020H),CHR34+(01A8H*020H)
		WORD	CHR34+(0110H*020H),CHR34+(0118H*020H)
;
CHRTR_0C_DAT1	EQU	$
		WORD	CHR34+(01C0H*020H),CHR34+(01C8H*020H)
		WORD	CHR34+(01D0H*020H),CHR34+(01D8H*020H)
		WORD	CHR34+(01E0H*020H),CHR34+(01E8H*020H)
		WORD	CHR34+(01F0H*020H),CHR34+(01F8H*020H)
		WORD	CHR34+(01E0H*020H),CHR34+(01E8H*020H)
		WORD	CHR34+(01D0H*020H),CHR34+(01D8H*020H)
;
CHRTR_0C_CMP	EQU	$
		WORD	00010H,0000CH,0000CH,00010H,0000CH,0000CH
;
;
CHRTR_0C	EQU	$
		LDX	!CHR_ANIME_CT
		LDA	!CHR_ANIME_TM
		CMP	CHRTR_0C_CMP,X
		BCC	CHRTR_0C_20
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		INC	A
		CMP	#(CHRTR_0C_DAT1-CHRTR_0C_DAT0)/2
		BCC	CHRTR_0C_10
		LDA	#00000H
CHRTR_0C_10	EQU	$
		STA	!CHR_ANIME_CT
CHRTR_0C_20	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
		LDX	#00000001B
		LDA	!FRCNT2
		AND	#00002
		BNE	CHRTR_0C_40
CHRTR_0C_30	EQU	$
		LDA	CHRTR_0C_DAT0,Y
		STA	<4302H
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_0C_DAT0+2,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
CHRTR_0C_40	EQU	$
		LDA	CHRTR_0C_DAT1,Y
		STA	<4302H
		LDA	#01080H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_0C_DAT1+2,Y
		STA	<4302H
		LDA	#01180H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- n`Ɨn ------------------------------------
CHRTR_0D	EQU	$
		INC	!CHR_AM_TM_SB
		LDA	!CHR_AM_TM_SB
		CMP	#00006
		BCS	CHRTR_0D_00
		JMP	CHRTR_07
;
CHRTR_0D_00	EQU	$
		STZ	!CHR_AM_TM_SB
		LDA	!CHR_AM_CT_SB
		INC	A
		INC	A
		AND	#00007H*2
		STA	!CHR_AM_CT_SB
		LDY	!CHR_AM_CT_SB
		JMP	CHRTR_05_SET
;
;-------------- n`ƃWOR[X  -------------------
CHRTR_0E	EQU	$
		INC	!CHR_AM_TM_SB
		LDA	!FRCNT2
		AND	#00001
		BEQ	CHRTR_0D_00
		JMP	CHRTR_0C
;
;-------------- afQ,R̃n`pXe -------------------------
CHRTR_0F_DAT0	EQU	$
		WORD	CHR71+((2*8*16)*08H)
		WORD	CHR71+((2*8*16)*0AH)
		WORD	CHR71+((2*8*16)*0CH)
		WORD	CHR71+((2*8*16)*0EH)
;
;
CHRTR_0F	EQU	$
		LDA	!CHR_PAST_TM
		INC	A
		CMP	#00006
		BCC	CHRTR_0F_050
		INC	!CHR_PAST_CT
		LDA	#00000H
CHRTR_0F_050	EQU	$
		STA	!CHR_PAST_TM
		LDX	#00000001B
		LDY	!CHR_PAST_CT
		CMP	#00000H		; afR] ?
		BNE	CHRTR_0F_100	;	NO -> CHRTR_0F_100
;
		TYA
		AND	#00006H
		TAY
		LDA	CHRTR_0F_DAT0,Y
		JMP	CHRTR_05_SET_SB
;
CHRTR_0F_100	EQU	$
;
CHRTR_0F_990	EQU	$
		RTS
;
;-------------- afR {X ---------------------------------
CHRTR_10_DAT0	EQU	$
		WORD	CHR73+((2*8*16)*00H)+(2*8*0)
		WORD	CHR73+((2*8*16)*01H)+(2*8*0)
		WORD	CHR73+((2*8*16)*02H)+(2*8*0)
		WORD	CHR73+((2*8*16)*03H)+(2*8*0)
;
CHRTR_10_DAT1	EQU	$
		WORD	CHR73+((2*8*16)*00H)+(2*8*8)
		WORD	CHR73+((2*8*16)*01H)+(2*8*8)
		WORD	CHR73+((2*8*16)*02H)+(2*8*8)
		WORD	CHR73+((2*8*16)*03H)+(2*8*8)
;
;
CHRTR_10	EQU	$
		LDA	!CHR_ANIME_TM
		AND	#0000CH
		LSR	A
		TAY
		LDX	#BANK CHR73
		STX	<4304H		; A bus address(B) set
		LDA	CHRTR_10_DAT0,Y
		STA	<4302H		; A bus address(L,H) set
		LDA	#02F00H
		STA	2116H		; VRAM address set
		LDA	#2*8*8
		STA	<4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
		STA	<4305H		; number of byte set
		LDA	CHRTR_10_DAT1,Y
		STA	<4302H		; A bus address(L,H) set
		LDA	#02F80H
		STA	2116H		; VRAM address set
		STX	420BH		; DMA "ON"
		RTS
;
;-------------- afR_ƃWOR[X  ------------------------
CHRTR_11	EQU	$
		LDA	FRCNT2
		AND	#00003
		BNE	CHRTR_11_500
		JMP	CHRTR_03
;
CHRTR_11_500	EQU	$
		JMP	CHRTR_0C
;
;
;************************************************************************
;*		JSL type BG screen write sub				*
;************************************************************************
;
BGSCWTL		EQU	$
;
		REP	#00100000B	;memory 16 bit mode
;
		PHD			;(D) save
		LDA	#420BH		;0 page set ( 420BH- )
		TCD
;
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	<4300H
		LDX	#00000001B	;(X) <-- DMA "ON" flag
		JSR	BGSCWT
;
		PLD			;(D) load
;
		SEP	#00100000B	;memory 8 bit mode
		RTL
;
;************************************************************************
;*		BG screen write						*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
BGSCWT		EQU	$
		LDY	#BANK BGHSCRBF	;A bus address(B) set
		STY	<4304H
;
;-------------- gXN[ ------------------------------------
		LDY	#10000001B	;inc mode set
		STY	2115H
;
;-------------- afP ------------------------------------------
		LDY	BGWHF1
		BEQ	BGSW10		;BG1 H write ? ( no:BGSW10 )
;
		LDA	#BGHSCRBF	;A bus address(L,H) set
		STA	<4302H
;
		LDA	BGWAH1_0	;VRAM address set
		STA	2116H
		LDY	#20H*2		;number of byte set
		STY	<4305H
		STX	<420BH		;DMA "ON"
;
		LDA	BGWAH1_1	;VRAM address set
		STA	2116H
;;;;		    LDY	    #20H*2	    ;number of byte set
		STY	<4305H
		STX	<420BH		;DMA "ON"
;
		STZ	BGWHF1		;BG write end set
;
;-------------- uXN[ ------------------------------------
BGSW10		EQU	$
		LDY	#10000000B	;inc mode set
		STY	2115H
;
;-------------- afP ------------------------------------------
		LDY	BGWVF1
		BEQ	BGSW40		;BG V write ? ( no:BGSW40 )
;
		LDA	#BGVSCRBF	;A bus address(L,H) set
		STA	<4302H
;
		LDA	BGWAV1_00	;VRAM address set
		STA	2116H
		LDA	BGWNO1_0	;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
		LDA	BGWAV1_10	;VRAM address set
		STA	2116H
		LDA	BGWNO1_1	;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
;
		LDA	BGWAV1_01	;VRAM address set
		STA	2116H
		LDA	BGWNO1_0	;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
		LDA	BGWAV1_11	;VRAM address set
		STA	2116H
		LDA	BGWNO1_1	;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
;
		STZ	BGWVF1		;BG write end set
BGSW40		EQU	$
		RTS
;
;****************************************************************
;*								*
;*		X[p[ cl`] vO			*
;*								*
;****************************************************************
		MEM16
		IDX8
SP_VRAM_ST	EQU	$
		LDA	!VRAMDSP
		BEQ	SP_VRAM_END
		LDX	#080H		; uq`l AhX
		STX	2115H		;	CN [h
		LDX	#001H
		STX	<4300H		; cl` p[^
		LDX	#018H
		STX	<4301H		; aoX AhX
		LDX	#BANK UNDATA
		STX	<4304H		; `oX oNAhX
;
		LDY	#000H
		LDX	#001H
SP_VRAM_LOP	EQU	$
		LDA	!VRAMDSP+2,Y
		BMI	SP_VRAM_END
		PHA
		STA	2116H		; ] AhX
		LDA	!VRAMDSP+4,Y
		STA	<4302H		; ] AhX
		LDA	#00004H
		STA	<4305H		; ]oCg
		STX	<420BH		; cl` "nm"!!
		PLA
		CLC
		ADC	#00020H
		STA	2116H		; ] AhX
		LDA	#00004H
		STA	<4305H		; ]oCg
		STX	<420BH		; cl` "nm"!!
		INY
		INY
		INY
		INY
		BRA	SP_VRAM_LOP
;
SP_VRAM_END	EQU	$
		LDA	#00000H
		STA	!VRAMDSP
		DEC	A
		STA	!VRAMDSP+2
		RTS
;
;************************************************************************
;*		OBJ mode 7 chara DMA					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
OB7DMA		EQU	$
		LDA	OBM7WF
		BEQ	OB7DMA_050	;DMA set ? ( no:OB7DMA_050 )
;
		BPL	OB7DMA_010	;ʓ]H ( no:OB7DMA_010 )
;
		AND	#7FE0H
		STA	2116H
		LDA	#WOB7CHR+1000H	;A bus address(L,H) set
		BRA	OB7DMA_020
;
OB7DMA_010	EQU	$
		LDA	#5C00H		;VRAM address set
		STA	2116H
		LDA	#WOB7CHR	;A bus address(L,H) set
OB7DMA_020	EQU	$
		STA	<4302H
		LDY	#BANK WOB7CHR	;      "      (B) set
		STY	<4304H
		LDA	#0800H		;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON"
;
		STZ	OBM7WF
OB7DMA_050	EQU	$
		RTS
;
;************************************************************************
;*		massage bitmap chara DMA set				*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
MSGDMA		EQU	$
		LDA	#3000H		;VRAM address set
		STA	2116H
		LDA	#MSGBITMP	;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK MSGBITMP	;	"     (B) set
		STY	<4304H
		LDA	#0800H		;number of byte set
		STA	<4305H
		STX	<420BH		;DMA "ON" !!
		RTS
;
;************************************************************************
;*		player chara DMA					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
PCHDMA		EQU	$
;
;-------------- vC[LN^[] ------------------------------
		LDA	#04000H		;VRAM address set ( 4000H- )
		STA	2116H
;
		LDY	#0040H		;(Y) <-- number of byte data
;
		LDA	PCHNO0		;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+2	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+6	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+10	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+14	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+18	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+22	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
;-------------- JEg_EpLN^[] --------------------
		LDA	PCHNO0+24	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+26	;      "      (B)
		STA	<4304H
		LDA	#0020H
		STA	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		STA	<4305H		;number of byte
		LDA	PCHNO0+29	;      "      (B)
		STA	<4303H
		LDA	PCHNO0+28	;A bus address(L,H)
		STA	<4302H
		STX	<420BH		;DMA ch "ON"
;
;-------------- vC[LN^[] ------------------------------
		LDA	#04100H		;VRAM address set ( 4100H- )
		STA	2116H
;
		LDA	PCHNO0		;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+2	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+6	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+10	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+14	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+18	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+22	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
;-------------- JEg_EpLN^[] --------------------
		LDA	PCHNO0+24	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+26	;      "      (H)(B)
		XBA
		STA	<4303H
		LDA	#0020H
		STA	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		STA	<4305H		;number of byte
		LDA	PCHNO0+28	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+30	;      "      (H)(B)
		XBA
		STA	<4303H
		STX	<420BH		;DMA ch "ON"
;
;-------------- mario-baby chara DMA set ------------------------
		LDA	BABYTRF
		BEQ	PCHD010		;mario-baby chara DMA ? ( no:PCHD010 )
;
		LDA	#4620H		;VRAM address set ( 4620H- )
		STA	2116H
;
		LDA	BABYCH0		;A bus address(L,H)
		STA	<4302H
		LDA	#BANK CHR50	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	BABYCH0+4	 ;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	#4720H		;VRAM address set ( 4720H- )
		STA	2116H
;
		LDA	BABYCH0+2	;A bus address(L)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		LDA	BABYCH0+6	;A bus address(L)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	<420BH		;DMA ch "ON"
;
		STZ	BABYTRF
;
;-------------- player spacial chara DMA set --------------------
PCHD010		EQU	$
		LDA	PCHTRF
		BEQ	PCHD020		;spacial chara DMA ? ( no:PCHD020 )
;
		STA	<4302H		;A bus address(L)
		LDY	#BANK CHR64
		STY	<4304H		;	"     (B)
		LDA	#04200H		;VRAM address set ( 4200H- )
		STA	2116H
;
		LDY	#01H		;number of byte
		STY	<4306H
		STX	<420BH		;DMA ch "ON"
;
		LDA	#04300H		;VRAM address set ( 420BH- )
		STA	2116H
;
		STY	<4306H		;number of byte
		STX	<420BH
;
		STZ	PCHTRF		;spacial chara DMA "OFF"
;
PCHD020		EQU	$
		RTS
;
;************************************************************************
;*		memory DMA set						*
;*			M_DMA_BUF					*
;*			[xx],[xx],[xxx],[xxx],[xx],[xxx],[xxx]...,[00]	*
;*			 |    |	    |	  |				*
;*			 |    |	    |	  +-- ]AhX		*
;*			 |    |	    +--------	h   h		*
;*			 |    +--------------	hoCgiOŏI)	*	    *
;*			 +------------------- Zbg|C^[	*
;************************************************************************
;
		MEM16
;
MEMDMA		EQU	$
		LDA	#00000000B+(80H*100H)	;DMA parameter & B bus address set
		STA	<4300H
;
		LDY	#2
		LDA	M_DMA_BUF,Y
		BEQ	MDMA_020	;end ? ( yes:MDMA_020 )
;
MDMA_010	EQU	$
		STA	<4305H		;number of byte set
		LDA	M_DMA_BUF+2,Y
		STA	2181H		;to address set
		LDA	M_DMA_BUF+3,Y
		STA	2182H
		LDA	M_DMA_BUF+5,Y	;from address set
		STA	<4302H
		LDA	M_DMA_BUF+6,Y
		STA	<4303H
		STX	<420BH		;DMA "ON"
;
		TYA
		CLC
		ADC	#8
		TAY
		LDA	M_DMA_BUF,Y
		BNE	MDMA_010	;end ? ( no:MDMA_010 )
;
		STZ	M_DMA_BUF	;next set pointer reset
		STZ	M_DMA_BUF+2	;end code set
;
MDMA_020	EQU	$
		RTS
;
;
		DPAGE	WORK
;
;
;
;
;
;************************************************************************
;*		M-chip start						*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON		EQU	$+7E0000H
		STZ	3030H		;LbVZbg
CHIPON_C	EQU	$+7E0000H
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		LDA	#00100000B
CHIPON10	EQU	$
		BIT	3030H
		BNE	CHIPON10	;chip move ? ( yes:CHIPON10 )
;
		LDY	#00
		STY	303AH		;SFC ROM use enable
		RTL
;
;************************************************************************
;*		M-chip start ( game )					*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON1		EQU	$+7E0000H
		PHB			;(DBR) save
;
		STZ	3030H		;LbVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		PHK			;(DBR) <-- (PBR)
		PLB
		JSR	METERST
;
		PLB
;
		LDA	#00100000B
CHIPON110	EQU	$
		BIT	3030H
		BNE	CHIPON110	;chip move ? ( yes:CHIPON110 )
;
		LDY	#00
		STY	303AH		;SFC ROM use enable
		RTL
;
;************************************************************************
;*		M-chip start ( SFC-RAM read type )			*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON_RAM_READ EQU	$+7E0000H
		STZ	3030H		;LbVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		I16
;
		LDA	#00100000B
		TAY
CHIPON_RR_20	EQU	$
		BIT	3030H
		BNE	CHIPON_RR_20	;chip move ? ( yes:CHIPON_RR_20 )
;
		LDX	R0
		BEQ	CHIPON_RR_30	;SFC-RAM read ? ( no:CHIPON_RR_30 )
;
		LDA	>7F0000H,X
		STA	R0		;(R0) <-- read RAM data
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_RR_20
;
CHIPON_RR_30	EQU	$
		LDY	#00
		STY	303AH		;SFC ROM use enable
;
		I8
;
		RTL
;
;************************************************************************
;*		M-chip start ( special type )				*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON_SPECIAL	EQU	$+7E0000H
		STZ	3030H		;LbVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		I16
;
		LDA	#00100000B
		TAY
CHIPON_SP_20	EQU	$
		BIT	3030H
		BNE	CHIPON_SP_20	;chip move ? ( yes:CHIPON_SP_20 )
;
		LDX	R0
		BPL	CHIPON_SP_30	;RAM read ? ( no:CHIPON_SP_30 )
;
		LDA	>7F0000H,X
		STA	R0		;(R0) <-- read RAM data
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_SP_20
;
CHIPON_SP_30	EQU	$
		BEQ	CHIPON_SP_40	;M-chip END ? ( yes:CHIPON_SP_40 )
;
		STZ	303AH		;SFC ROM use enable
;
		JSR	(!SPMODE_SUB-2,X)
;
		M8
;
		LDA	CIPSCR
		STA	303AH
;
		M16
;
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_SP_20
;
CHIPON_SP_40	EQU	$
		LDY	#00
		STY	303AH		;SFC ROM use enable
;
		I8
;
		RTL
;
;------------------------------------------------------------------------
;-		XyV[h[`e[u			-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
SPMODE_SUB	EQU	$		;[X]
		WORD	SFC_COIN	;[02] RC
		WORD	SFC_EATBLK	;[04] Hׂaf
		WORD	SFC_KUI		;[06] Ył݂af
		WORD	SFC_EGG_KILL	;[08] ^}SIvV
		WORD	SFC_BGCLR	;[0A] ʂaf
		WORD	SFC_BGCLR_4	;[0C] ʂafiSjbgj
		WORD	SFC_BGCHNG	;[0E] w胆jbgaf
		WORD	SFC_TNIO_IN	;[10] glhm^ntsfX^[gZbg
		WORD	SFC_PLDOWNST	;[12] vC[_EZbg
		WORD	SFC_PLFAILST	;[14] vC[_[WZbg
		WORD	SFC_GOTO_1W_1	;[16] Pv|PփZbg
		WORD	SFC_TOGEBLK	;[18] gQubNaf
		WORD	SFC_YOGAN_IN	;[1A] vC[n◎
		WORD	SFC_POINT_GET	;[1C] IuWFRCAY[t[
;
;----------------------------------------------------------------
;-		Pv|PփZbg				-
;----------------------------------------------------------------
SFC_GOTO_1W_1	EQU	$
		PHY			;(Y) save
;
		LDA	MAPOINT
		CMP	#INT_STAT
		BNE	SFC_GOTO_6W_8	;Uv|WR[XH ( no:SFC_GOTO_6W_8 )
;
		STZ	MAPOINT		;Pv|PZbg
;;;;K;;;;		LDA	#GMIN
		LDA	#HMPIN
		STA	MODENO
		LDA	#001
		STA	!MPCLRTBL+INT_STAT
;
		JSL	>EGG_SAVE
;
		PLY			;(Y) load
		RTS
;
;-------------- mdws fnsnII ---------------------------
SFC_GOTO_6W_8	EQU	$
;
		JSL	>GO_NEXTGOTO
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		RC					-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_COIN	EQU	$
		PHY			;(Y) save
;
		I8
;
		LDA	R6
		CMP	#UTA400
		BNE	SFC_COIN_0050	;RCH ( no:SFC_COIN_0050 )
;
		JSR	BLUE_COIN_SET
;
		I8
;
		BRA	SFC_COIN_0060
;
SFC_COIN_0050	EQU	$
;;;;		    INC	    COIN_ADD	    ;coin counter add !!
		LDA	CCWORK0		;wWZbg
		AND	#0FFF0H
		STA	WORK0
		LDA	CCWORK1		;xWZbg
		AND	#0FFF0H
		STA	WORK2
		JSL	>EX_COIN_SET_3
		LDA	#09H		;[]
		JSL	>SOUND_3_ON
;
SFC_COIN_0060	EQU	$
		LDA	#FLKIR		;(A) <-- ʂmD
		JSL	>EXINSR		;ʃGAm
		LDA	WORK0
		STA	EXXPSL,Y	;wWZbg
		LDA	WORK2
		STA	EXYPSL,Y	;xWZbg
		LDA	#0CH
		STA	EXCHPT,Y	;p^[mDZbg
		LDA	#08H
		STA	EXTIM0,Y	;^C}[Zbg
;
		I16
;
;;;;K;;;;		PLY			;(Y) load
		LDA	#UT0000
		STA	BGUTNO		;BG change unit no.
		LDA	#CNCL
		BRA	SFC_COIN_PAS
;
SFC_BGCLR	EQU	$
		LDA	#UT0000
		STA	BGUTNO		;     "    unit no.
;
SFC_BG_WT	EQU	$
		PHY			;(Y) save
;
		LDA	#BGCG
;
SFC_COIN_PAS	EQU	$
		STA	BGCGNO		;BG change type no. set
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		naiRCZbg				-
;----------------------------------------------------------------
BLUE_COIN_SET	EQU	$
		LDA	#00093H
		INC	CORS_COIN	;RCJE^[
		LDY	CORS_COIN
		CPY	#014H
		BMI	BLUE_COIN_I_008

		INC	A
;;;;;;;;		LDA	#00094H
;
BLUE_COIN_I_008 EQU	$
;;;;;;;;		LDA	#018H		;[]
		JSL	>SOUND_3_ON
;
		LDA	#000000010B	;(A) <-- RCJ[
BLUE_COIN_I_010 EQU	$
		STA	WORK6
;
		I8			; index 8bit mode
;
		LDA	CCWORK0		;wWZbg
		AND	#0FFF0H
		STA	WORK0
		LDA	CCWORK1		;xWZbg
		AND	#0FFF0H
		JSL	>EX_COIN_SET_2
;
		I16			; index 16bit mode
;
		RTS
;
;----------------------------------------------------------------
;-		RCRCJE^[			-
;----------------------------------------------------------------
BLUE_COIN_ST_SB EQU	$
		JSR	BLUE_COIN_SET
		RTL
;
;;;;;----------------------------------------------------------------
;;;;;-		    naim[}RCZbg			    -
;;;;;----------------------------------------------------------------
;;;;COIN_SET	    EQU	    $
;;;;		    LDA	    #09H	    ;[]
;;;;		    JSL	    >SOUND_3_ON
;;;;;
;;;;		    LDA	    #00000000B	    ;(A) <-- RCJ[
;;;;		    BRA	    BLUE_COIN_I_010
;
;----------------------------------------------------------------
;-		w胆jbgaf			-
;-			in :					-
;-				(R5)   <-- jbgmD	-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_BGCHNG	EQU	$
		LDA	R5
		STA	BGUTNO		;jbgmDZbg
		BRA	SFC_BG_WT
;
;----------------------------------------------------------------
;-		ʂafiSjbgj			-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_BGCLR_4_L	EQU	$
		JSR	SFC_BGCLR_4
		RTL
;
SFC_BGCLR_4	EQU	$
		JSR	SFC_BGCLR
;
		PHY			;(Y) save
;
		LDA	BGXPS1
		CLC
		ADC	#010H
		STA	BGXPS1		;BG write X pos set
		JSL	>UNITCHG
;
		LDA	BGYPS1
		CLC
		ADC	#010H
		STA	BGYPS1		;BG write Y pos set
		JSL	>UNITCHG
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		Hׂaf				-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_EATBLK	EQU	$
		PHY			;(Y) save
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		LDA	#BLK0
		STA	BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		gQubNaf			-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_TOGEBLK	EQU	$
		PHY			;(Y) save
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		LDA	#TGTM
		STA	BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		Ył݂af				-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;-				(R6)   <-- YjbgmD	-
;----------------------------------------------------------------
KUI_CHANGE_UP	EQU	$
; ̃jbgmD -> UT6B00 UT6B01 UT6B02 UT6B03
		WORD	UT0000,UT0000,UT0000,UT2A0D
; ̃jbgmD -> UT6B10 UT6B11 UT6B12,UT6B13
		WORD	UT0000,UT0000,UT0000,UT2A1D
; ̃jbgmD -> UT6B20 UT6B21,UT6B22 UT6B23
		WORD	UT0000,UT0000,UT0000,UT2A2D
; ̃jbgmD -> UT6B30 UT6B31 UT6B32 UT6B33
		WORD	UT0000,UT0000,UT0000,UT2A3D
; ̃jbgmD -> UT6B60 UT6B61 UT6B62 UT6B63
		WORD	UT0000,UT0000,UT0000,UT964C
;
SFC_KUI		EQU	$
		PHY			;(Y) save
;
		LDA	R6
		AND	#00FFH
		ASL	A
		TAX
		LDA	>KUI_CHANGE_UP,X
		STA	<BGUTNO
		LDA	CCWORK0
		STA	<BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	<BGYPS1		;    "    Y   "
		LDA	#DWCG
		STA	<BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY
		RTS
;
;----------------------------------------------------------------
;-		^}SIvV				-
;-			in :					-
;-				(R1) <-- ^}S̓GCfbNX -
;----------------------------------------------------------------
SFC_EGG_KILL	EQU	$
		PHY			;(Y) save
;
		LDX	R1		;(X) <-- ^}S̓GCfbNX
		JSL	>EGGKILL	;^}SIvV
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		glhm^ntsfX^[gZbg	-
;----------------------------------------------------------------
SFC_TNIO_IN	EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BNE	SFC_TNIO_IN_010 ;afRO}XNR[XH ( no:SFC_TNIO_IN_010 )
;
		PHY			;(Y) save
;
		JSL	>TONNEL_INOUT_IN
;
		PLY			;(Y) load
;
SFC_TNIO_IN_010 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		vC[_EZbg				-
;----------------------------------------------------------------
SFC_PLDOWNST	EQU	$
		LDA	PL_NO_DOWN
		BNE	SFC_PLDOWNST_10 ;vC[_ELZH ( yes:SFC_PLDOWNST_10 )
;
		PHY			;(Y) save
;
		JSL	>TO_PLDOWN	;vC[_E[h
;
		PLY			;(Y) load
;
SFC_PLDOWNST_10 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		vC[_[WZbg			-
;----------------------------------------------------------------
SFC_PLFAILST	EQU	$
		PHY			;(Y) save
;
		I8
;
		JSL	>PLFLST_S
;
		I16
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		vC[n◎				-
;----------------------------------------------------------------
YOGAN_IN_XSP	EQU	$
; PLCMKI -->
		WORD	00080H,0FF80H
;
SFC_YOGAN_IN	EQU	$
		LDA	PL_NO_DOWN
		BNE	SFC_YOGAN_IN_10 ;vC[_ELZH ( yes:SFC_YOGAN_IN_10 )
;
		PHY			;(Y) save
;
		LDA	#PYGN		;(A) <-- vC[n◎[h
		JSL	>TIMEUP_SET_S
		LDA	#0FB00H		;xXs[hZbg
		STA	PLYSPD
		LDX	PLCMKI
		LDA	>YOGAN_IN_XSP,X ;wXs[hZbg
		STA	PLXSPD
		LDA	#020H		;EFCg^C}[Zbg
		STA	PLWORKTM
;
		PLY			;(Y) load
;
SFC_YOGAN_IN_10 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		IuWFRCAY[t[		-
;-			in :					-
;-				(CWK0) <-- ENINDX	-
;----------------------------------------------------------------
SFC_POINT_GET	EQU	$
		PHY			;(Y) save

 IF BUG00  ;*** NES ΉioOCj[1995/7/13] *****************
		LDA	CCWORK0
		STA	>ENINDX
;
		I8
;
		TAX

 ELSE	   ;*** JPN Ή [1995/6/30] ***********************
;
		I8
;
		LDX	CCWORK0
 ENDIF	   ;*** NES ΉioOCj[1995/7/13] *****************
	   ;*** JPN Ή [1995/6/30] ***********************

		LDA	ENMYNO,X		;̂̓RC ?
		CMP	#COIN1			;
		BEQ	SFC_P_G0100		; yes: SFC_P_G0100
		CMP	#COINR			;
		BNE	SFC_P_G1000		;  no: SFC_P_G1000

		JSL	>COINR_GET
		BRA	SFC_P_G3000

SFC_P_G0100	EQU	$
		JSL	>COIN1_GET
		BRA	SFC_P_G3000

SFC_P_G1000	EQU	$
		JSL	>FLOWER_GET
;
SFC_P_G3000	EQU	$
		I16
;
		PLY			;(Y) load
		RTS
;
;************************************************************************
;*		M-chip start ( map )					*
;*			in  : (WK0)   <-- counter ( 6->4->->2->0 )	*
;*			      (WK4,5) <-- cos,sin data pointer		*
;*			      (WK6,7) <-- H-DMA buffer	  "             *
;************************************************************************
;
		MEM16
		IDX8
;
MPCHIPON	EQU	$+7E0000H
		PHB			;(DBR) save
;
		STZ	3030H		;LbVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		LDA	TITLEFG
		BEQ	MPCPON00	;title map ? ( yes:MPCPON00 )
		JMP	MPCPON60
;
MPCPON00	EQU	$
		PHK			;(DBR) <-- (PBR)
		PLB
;
;-------------- title scroll counter calculate ------------------
;
		I16
;
		LDX	<WORK4		;(X) <-- cos,sin data pointer
		LDY	<WORK6		;(Y) <-- H-DMA buffer pointer
;;;;		    LDA	    #38H/4
		LDA	#30H/4
		STA	<WORKC		;(WKC,D) <-- loop no.
MPCPON10	EQU	$
		CPX	#01FEH
		BCC	MPCPON12	;wave set ? ( yes:MPCPON12 )
;
		STZ	<WORKE
		LDA	<SCCV2
		BRA	MPCPON50
;
MPCPON12	EQU	$
		TYA
		LSR	A
		LSR	A
		STA	<WORK8		;(WK8,9) <-- set V pointer
		CLC
		ADC	#08H
		CMP	#20H
		BCC	MPCPON14
		LDA	#20H
MPCPON14	EQU	$
		ASL	A
		STA	<WORKA		;(WKA,B) <-- wave size
;
		LDA	SIN,X
		PHP
		BPL	MPCPON20
		EOR	#0FFFFH
		INC	A
MPCPON20	EQU	$
		CMP	#0100H
;
		M8
;
		XBA
		LDA	<WORKA		;(A) <-- wave size
		BCS	MPCPON30	;1.0 ? ( yes:MPCPON30 )
;
		STA	>4202H
		XBA
		STA	>4203H
		NOP			;[ 8 cycle wait ]
		NOP			;	 "
		NOP			;	 "
;					;	 "
		M16			;	 "
;					;	 "
		LDA	>4217H
		BRA	MPCPON32
;
MPCPON30	EQU	$
;
		M16
;
MPCPON32	EQU	$
		AND	#00FFH
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		PLP
		BPL	MPCPON34
		EOR	#0FFFFH
		INC	A
MPCPON34	EQU	$
		STA	<WORKE
		CLC
		ADC	<WORK8
		AND	#00FFH
		CMP	#002FH+1	;(C) set
		LDA	<WORKE
		BCC	MPCPON40	;scroll counter_V over ? ( no:MPCPON40 )
		LDA	<WORK8
		EOR	#0FFFFH
;;;;		SEC
		ADC	#30H-1
MPCPON40	EQU	$
		CLC
		ADC	<SCCV2
MPCPON50	EQU	$
		STA	MPHDMABF5+4+2,Y ;scroll counter_V set
		LDA	<WORKE
		STA	MPHDMABF5+4,Y	;scroll counter_H set
;
		PHX			;(X) save
;
;;;;		LDA	<WORKE
;;;;		CLC
;;;;		ADC	#0100H		;[ (+) <-- (-) ]
;;;;		CLC
;;;;		ADC	#080H
;;;;		LSR	A
;;;;		LSR	A
;;;;		LSR	A
;;;;		STZ	<WORKE
;;;;		CMP	#20H
;;;;		BCC	MPCPON51
;;;;;
;;;;		LDX	#1FH
;;;;		STX	<WORKE
;;;;;;;;		SEC
;;;;		SBC	#20H
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		CMP	#20H<<5
;;;;		BCC	MPCPON51
;;;;;
;;;;		LDX	#(1FH<<5)+1FH
;;;;		STX	<WORKE
;;;;;;;;		SEC
;;;;		SBC	#20H<<5
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;		ASL	A
;;;;MPCPON51	EQU	$
;;;;		ORA	<WORKE
;
		TXA
		CMP	#1FEH
		BCC	MPCPON51
		LDA	#1FEH
MPCPON51	EQU	$
		LSR	A
		AND	#3FH<<2
		TAX
		LDA	MPHDMABF4+(040H*4)+2,X
		STA	MPHDMABF4+2,Y	;color set
;
		PLA
		SEC
		SBC	#010H
		AND	#07FEH
		TAX
		INY
		INY
		INY
		INY
		DEC	<WORKC
		BEQ	MPCPON52
		JMP	MPCPON10
;
MPCPON52	EQU	$
		STX	<WORK4
		STY	<WORK6
;
		I8
;
MPCPON60	EQU	$
		PLB
;
		LDA	#00100000B
MPCPON70	EQU	$
		BIT	3030H
		BNE	MPCPON70	;chip move ? ( yes:MPCPON70 )
;
		LDY	#00
		STY	303AH		;SFC ROM use enable
		RTL
;
;************************************************************************
;*		meter screen buffer set					*
;************************************************************************
TOKUDAT		EQU	$
		WORD	100,10
;
TIM_CNT_ADD	EQU	$
		WORD	00010,-00010
;
TIM_CNT_MAX	EQU	$
		WORD	00300,00000
;
;
METERST		EQU	$
		I16			; index 16bit mode
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		RCZbg				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MTRCINCNT	EQU	$
;;;;		    LDA	    !CRS_CIN_ADD
;;;;		    BEQ	    MTRCINCNT_200
;;;;		    CLC
;;;;		    ADC	    !CORS_COIN
;;;;		    STA	    !CORS_COIN
;;;;;
;;;;MTRCINCNT_200   EQU	    $
;;;;		    STZ	    !CRS_CIN_ADD
;;;;		    LDA	    !COIN_ADD
;;;;		    BEQ	    MTRCINCNT_900
;;;;		    CLC
;;;;		    ADC	    !COIN_CNT
;;;;		    CMP	    #00100
;;;;		    BCC	    MTRCINCNT_800
;;;;		    SEC
;;;;		    SBC	    #00100
;;;;		    INC	    !PLCONT
;;;;;
;;;;MTRCINCNT_800   EQU	    $
;;;;		    STA	    !COIN_CNT
;;;;MTRCINCNT_900   EQU	    $
;;;;		    STZ	    !COIN_ADD
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		vC[lZbg				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLCNTST		EQU	$
		LDA	!PLCONT		; player counter load !!
		CMP	#01000
		BCC	PLCNTST_990
		LDA	#0999
		STA	!PLCONT
		LDA	!PLUPCT
		CMP	#01000
		BCC	PLCNTST_990
		LDA	#0999
		STA	!PLUPCT
PLCNTST_990	EQU	$
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		x Zbg					x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COLOR_CHG	EQU	$
;;;;		    LDA	    !TIMER	    ; ^C}[  O ?
;;;;		    BEQ	    TIMERST	    ;	    YES -> TIMERST
;;;;		    CPY	    #00090	    ; x Zbg ?
;;;;		    BCS	    TIMERST	    ;	    NO -> TIMERST
;;;;		    LDX	    !GOAL_IN
;;;;		    BNE	    TIMERST
;;;;		    LDX	    #00029H
;;;;		    STX	    <SOUND3	    ;[]
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		timer set program				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TIMERST		EQU	$
		STZ	!TIMCHG
		INC	!MTR_CNT
		LDY	#00000
		LDA	!TIMCNT_UP	; timer inc. ?
		BEQ	TET000		;	NO -> TET000
		BPL	TIM_CNT_200
		INY
		INY
TIM_CNT_200	EQU	$
		LDA	!GOAL_IN
		BNE	TIM_CNT_230
		LDA	!MTR_CNT
;;;;K;;;;		CMP	#00004
 IF  JPN | NES ;**** { or NES Ή [1995/6/30] ****************
		CMP	#00008
 ENDIF	       ;**** { or NES Ή [1995/6/30] ****************
;
 IF  PAL  ;**** PAL Ή [1995/7/24] *****************************
		CMP	#00006
 ENDIF	  ;**** PAL Ή [1995/7/24] *****************************
		BCC	TIM_CNT_310
TIM_CNT_230	EQU	$
		LDA	#036H		;[]
		JSR	RPRO_SOUND
		STZ	!MTR_CNT
		LDA	!TIMER
		CLC
		ADC	TIM_CNT_ADD,Y
		BMI	TIM_CNT_250
		STA	!TIMER
		CMP	TIM_CNT_MAX,Y
		BCC	TIM_CNT_300
TIM_CNT_250	EQU	$
		LDA	TIM_CNT_MAX,Y
		STA	!TIMER
		STZ	!TIMCNT_UP
		JMP	TET050
TIM_CNT_300	EQU	$
		LDA	!TIMCNT_UP
		SEC
		SBC	TIM_CNT_ADD,Y
		STA	!TIMCNT_UP
		TYA
		BNE	TIM_CNT_310
		INC	!TIMCHG		; ^C}[`FW !!
TIM_CNT_310	EQU	$
		BRA	TET050
;
TET000		EQU	$
		LDA	!BABYDWN	; ԂĂ ?
		BMI	TET005_50	;	JEgto ?	(YES -> TET005_50)
		BNE	TET050		;	YES -> TET050
		LDA	!GOAL_IN	; S[  Q[g
		ORA	!GATE_IN	; ^C}[Xgbv  bZ[W\
		ORA	!TIMER_STOP	;
		ORA	!MSGMOD		;	tO nmH
		BEQ	TET010		;	NO -> TET010
		BRA	TET050
;
TET005_50	EQU	$
		LDA	!TIMER
		CMP	#00109		; ^C}[  POȏ ?
		BCS	TET050		;	YES -> TET050
		INC	!TIMCNT_SB
		LDA	!TIMCNT_SB
		CMP	#00004*3	; JEgto nj ?
		BCC	TET050		;	NO -> TET050
		STZ	!TIMCNT_SB
		INC	!TIMER
		LDA	!TIMER
		CMP	#00100
		BNE	TET050
		LDA	#00032H		;[]
		JSR	RPRO_SOUND
		BRA	TET050
;
TET010		EQU	$
		STZ	!TIMCNT_SB
		LDA	!CCHGMK		; ϐg H
		BNE	TETEND
;
		LDA	!TIMER		; timer = 0 ?
		BEQ	TETEND		;	YES -> TETEND
;
		INC	!TIMCNT
		LDA	!TIMCNT
		CMP	#00004
		BCC	TET050
		STZ	!TIMCNT
		DEC	!TIMER		; timer = 0 ?
;
		LDA	!TIMER
		CMP	#00090		; timer = 90 ?
		BCS	TET050		;	NO -> TET050
		LDA	!SND_SPUP
		AND	#000FFH
		BNE	TET050
		INC	!SND_SPUP
		LDA	#00024H		;[]
		JSR	RPRO_SOUND
;
TET050		EQU	$
		LDX	#00000H
		LDA	!TIMER
		CMP	#01000		; ^C}[  POOO ?
		BCC	TET070		;	YES -> TET070
		LDA	#01000-1
		STA	!TIMER
;
TET070		EQU	$
		LDY	#00000H
;
TET100		EQU	$
		CMP	TOKUDAT,X
		BCC	TET150
		SBC	TOKUDAT,X
		INY
		BRA	TET100
;
TET150		EQU	$
		STY	<WORK0,X
		INX
		INX
		CPX	#00004
		BNE	TET070
;
		STA	<WORK0,X
		LDA	<WORK0
		STA	!TIMER_HI
		LDA	<WORK2
		STA	!TIMER_MID
		LDA	<WORK4
		STA	!TIMER_LOW	; ̈ʁO ?
		BNE	TETEND		;	NO -> TETEND
		LDA	!TIMCNT
		BNE	TETEND
		INC	!TIMCHG		; ^C}[`FW !!
;
TETEND		EQU	$
		I8			; index 8 bit mode !!
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	q`lvOpTEhZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
RPRO_SOUND	EQU	$
		PHX
		LDX	<SOUND_3_P
		STA	<SOUND_3_BF,X	;[]
		INC	<SOUND_3_P
		PLX
		RTS
;
		MEM8
		IDX8
;
;************************************************************************
;*		JSL type VRAM write sub ( VRAMD )			*
;************************************************************************
VMADSPL		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	VMADSP
;
		PLB
		RTL
;
;************************************************************************
;*		VRAM write sub ( VRAMD )				*
;************************************************************************
VTABLE		EQU	$
VTB00		LWORD	VRAMD+2
VTB01		LWORD	VCLDAT		;VRAM clear data
VTB03		LWORD	MPROGOCLR	;title map "rogo" clear data
VTB04		LWORD	BG3SCRCLR	;BG3 no set screen data
VTB05		LWORD	GLBG1SCRCLR	;BG1 screen clear data
VTB06		LWORD	GOAL_B1SCRDAT	;BG1 screen data
VTB07		LWORD	MPHLDRCLR	;map holder screen clear data
VTB08		LWORD	DM_01_SCRCLR	;~[WJfXN[NA[f[^
VTB09		LWORD	GLBG3SCRCLR	;afRXN[NA[f[^
VTB0A		LWORD	BG3WANCLR	;afRXN[NA[f[^iafRj
VTB0B		LWORD	HALF_MSG_DAT	;ԃ|Cg ăX^[gZNg bZ[Wf[^
VTB0C		LWORD	BG3WTRCLR	;afRXN[NA[f[^iafRAX`bNj
VTB0D		LWORD	END_BITMAP_CLR	;GfBOrbg}bvNA[f[^
;
VTCL		EQU	VTB01-VTABLE
MTCL		EQU	VTB03-VTABLE
B3CL		EQU	VTB04-VTABLE
GLB1CL		EQU	VTB05-VTABLE
BG1DT		EQU	VTB06-VTABLE
HLCL		EQU	VTB07-VTABLE
DMCL		EQU	VTB08-VTABLE
GLB3CL		EQU	VTB09-VTABLE
WNCL		EQU	VTB0A-VTABLE
HF_DT		EQU	VTB0B-VTABLE
B3WRCL		EQU	VTB0C-VTABLE
ENCL		EQU	VTB0D-VTABLE
;
VMADSP		EQU	$
;
		I16
;
		LDY	VRFLG
		LDX	VTABLE,Y	;BG data address(L) set
		LDA	VTABLE+2,Y	;	"       (B) set
		JSR	VRAMTR		;VRAM write
;
		IDX8
;
		LDA	VRFLG
		BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
		STA	>VRAMD
		STA	>VRAMD+1
		DEC	A		;[ LDA	#0FFFFH ]
		STA	>VRAMD+3
VMD010		EQU	$
		STZ	VRFLG
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NEWVMAD ( new VMADSP sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRFLDAT		EQU	$
VRTB00		LWORD	VRAMDX
VRTB01		LWORD	WINVRMD
VRTB02		LWORD	LOSVRMD
;
;
MWIN		EQU	VRTB01-VRFLDAT
MLOS		EQU	VRTB02-VRFLDAT
;
;
NEWVMADL	EQU	$
		PHB			;(DBR) save
		PHK
		PLB
;
		JSR	NEWVMAD
;
		PLB
		RTL
;
NEWVMAD		EQU	$
		I16
;
		LDX	VRFLG2
		LDY	!VRFLDAT,X	;BG data address(L) set
		LDA	!VRFLDAT+2,X	;	"       (B) set
		PHB
		PHA
		PLB
		STA	<WORK0
;
		M16
;
		LDA	0,Y
		STA	<WORK4		; end address set
		CMP	#VRAMDX+2
		BEQ	NVD150
		INY
		INY
;
NVD100		EQU	$
		LDA	0,Y
		STA	>2116H
;
		LDA	4,Y
		STA	>4301H
;
		LDA	6,Y
		STA	>4303H
;
		LDA	8,Y
		STA	>4305H
;
		LDA	2,Y
;
		M8
;
		STA	>2115H
		XBA
		STA	>4300H
;
		LDA	#00000001B
		STA	>420BH
;
		M16
;
		LDA	10,Y
		TAY
		CMP	<WORK4
		BNE	NVD100		; end ?
;					; Yes!
		LDA	>VRFLG2
		BNE	NVD150
;
		LDA	#VRAMDX+2
		STA	VRAMDX		; end code set
;
NVD150		EQU	$
		PLB
		STZ	VRFLG2
;
		MI8
;
		RTS
;
;****************************************************************
;*		VRAM transfer sub				*
;*			in  : (X) <-- data address(L,H)		*
;*			      (A) <--	    "     (B)           *
;****************************************************************
;
		IDX16
;
VRAMTR		EQU	$
		PHB			;(DBR) save
		PHA			;(DBR) <-- data bank
		PLB
		STA	<WORK		;(WK0) <-- data address(B)
;
		M16
;
VTR010		EQU	$
		LDY	0000,X
		BPL	VTR020		;end ? ( no:VTR020 )
;
;-------------- end return ------------------------------
		SEP	#00110000B	;memory,index 8 bit mode set
		PLB
		RTS
;
VTR020		EQU	$
		LDA	0002,X		;number of byte set
		AND	#01FFFH
		INC	A
		STA	<WORK+1		;(WK1,2) <-- number of byte
		STA	<WORK+3		;(WK3,4) <-- data index up add data
;
		LDA	#10000000B
		BIT	0002,X
		BPL	VTR030		;tate ? ( no:VTR030 )
;-------------- tate write set --------------------------
		LDA	#10000001B
VTR030		EQU	$
		STA	>2115H		;inc mode set
		STA	<WORK+5		;(WK5,6) <-- inc mode
		TYA
		STA	>2116H		;VRAM address set
;
		LDA	0002,X
		AND	#0010000000000000B
		BEQ	VTR040		;VRAM read ? ( no:VTR040 )
;-------------- VRAM read -------------------------------
		LDA	#0003H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	0004,X		;A bus address(L,H) set
		STA	>4302H
		LDA	0005,X		;      "      (B) set
		STA	>4303H
		LDA	>2139H		;read intial
		LDA	#10000001B+(39H*100H)
		BRA	VTR060
;
VTR040		EQU	$
		LDA	<WORK		;A bus address(B) set
		STA	>4304H
		LDY	#00000001B+(18H*100H)
		BVC	VTR050		;= data set ? ( no:VTR050 )
;-------------- = data set ------------------------------
		LSR	<WORK+1		;(number of byte)/2
		LDA	#0002H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	#00001000B+(19H*100H)	;control parameter & B bus address set
		STA	>4300H
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0005H
		STA	>4302H
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		LDA	<WORK+5
		AND	#01111111B
		STA	>2115H		;inc mode set
		LDA	0000,X
		STA	>2116H		;VRAM address set
		LDY	#00001000B+(18H*100H)
VTR050		EQU	$
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0004H
		STA	>4302H
		TYA
VTR060		EQU	$
		STA	>4300H		;control parameter & B bus address set
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		TXA
		CLC
		ADC	#0004H		;[ not (C)=1 !! if (C)=1 then error data !! ]
		ADC	<WORK+3
		TAX
		JMP	VTR010
;
		MEM8
		IDX8
;
;************************************************************************
;		joy-controller read					*
;************************************************************************
;
CONT2		EQU	$
		LDA	4212H
		LSR	A
		BCS	CONT2		;read ok ? ( no:CONT2 )
;
		MI16
;
		LDA	4218H		;1p controller
		BIT	#0000000000001111B
		BEQ	CONT2_010	;controler ok ? ( yes:CONT2_010 )
		LDA	#00
CONT2_010	EQU	$
		STA	KEYA1L
		TAY
		EOR	KEYABFL
		AND	KEYA1L
		STA	KEYA2L
		STY	KEYABFL
;
		LDA	421AH		;2p controller
		BIT	#0000000000001111B
		BEQ	CONT2_020	;controler ok ? ( yes:CONT2_020 )
		LDA	#00
CONT2_020	EQU	$
		STA	KEYB1L
		TAY
		EOR	KEYBBFL
		AND	KEYB1L
		STA	KEYB2L
		STY	KEYBBFL
;
		LDA	KEYA1L		;move controller set
		STA	<KEYC1L
		LDA	KEYA2L
		STA	<KEYC2L
;
		MI8
;
		RTS
;
		MEM8
		IDX8
;
;
;
;
;
;
		END
