;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: start demo main				*
;*	file name	: ys_start					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_presno.h
		include		ys_color.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	START_INIT,START_PLAY
;
		GLB	STT_PL_STP,STT_PL_GO
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VRAMCL,VRAMCL2,URAMCLR,OAMDXCLR,RAMCLR
		EXT	SOUND_TR_2,DMA_D_M
;
		EXT	HMPIN
		EXT	W1_0_SOUND
;
;-------------< ys_title >------------------------------------------------
		EXT	MODINC
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENRAMCLR,ENCSET,ENEMY,ENINSR_I
;
		EXT	EMOVE,YOSSY
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	BGINT,UNITST_SUB,BGSET
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ
;
;-------------< ys_init >------------------------------------------------
		EXT	CHRSET,DIVDTST,GMMDST,UNCOMPRES,M_DMA_BFST_N
;
		EXT	GM01,GMCHR
;
;-------------< ys_hajime-chan >-----------------------------------------
		EXT	BABYM_RMODE38
;
;-------------< ys_game >------------------------------------------------
		EXT	MSGDSP,PLSCRL,GMURAMCLR
;
		EXT	INT_MSG_0,INT_MSG_1
;
;-------------< ys_play >------------------------------------------------
		EXT	PLAYER,PLCSET,PLINIT_2
;
		EXT	PCLR
;
;-------------< ys_mapdt >------------------------------------------------
		EXT	MPSTATBL,MPSTATUS,STT_IN
		EXT	COURSTBL
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
		MEM8
		IDX8
;
;
Group_10	GROUP	Start_pro
Start_pro	SECT	REL
;
;
;****************************************************************
;*								*
;*	CjV X^[g f CjV Zbg		*
;*								*
;****************************************************************
;
;------------------------------------------------------------------------
;-		bV[B̃Zbgʒu					-
;------------------------------------------------------------------------
ST_DM_CX	EQU	01C0H
ST_DM_CY	EQU	07A0H
;
ST_DM_YOSSY_X	EQU	$
		WORD	00000H+ST_DM_CX	 ;[0]
		WORD	0FFE0H+ST_DM_CX	 ;[2]
		WORD	0FFA4H+ST_DM_CX	 ;[4]
		WORD	0FF84H+ST_DM_CX	 ;[6]
		WORD	0FF96H+ST_DM_CX	 ;[8]
		WORD	0FFAEH+ST_DM_CX	 ;[A]
		WORD	0FFD2H+ST_DM_CX	 ;[C]
		WORD	0FFEEH+ST_DM_CX	 ;[E]
ST_DM_YOSSY_Y	EQU	$
		WORD	00000H+ST_DM_CY	 ;[0]
		WORD	00006H+ST_DM_CY	 ;[2]
		WORD	00006H+ST_DM_CY	 ;[4]
		WORD	00000H+ST_DM_CY	 ;[6]
		WORD	0FFFAH+ST_DM_CY	 ;[8]
		WORD	0FFF8H+ST_DM_CY	 ;[A]
		WORD	0FFF8H+ST_DM_CY	 ;[C]
		WORD	0FFFAH+ST_DM_CY	 ;[E]
;
;-------------- bZ[W EBhD -----------------
STAT_HDMA_DT5	EQU	$
		BYTE	01000100B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
STT_HDMA_DT5	EQU	$
		BYTE	69H+80H		;line no.
		WORD	WINDBUF
		BYTE	69H+80H		;line no.
		WORD	WINDBUF+(69H*4)
		HEX	00		;end code
STT_HDMA_DT5E	EQU	$
;
;-------------- afP XN[ -----------------
STAT_HDMA_DT6	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0DH		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
STT_HDMA_DT6	EQU	$
		BYTE	69H+80H		;line no.
		WORD	HDMABUF0
		BYTE	69H+80H		;line no.
		WORD	HDMABUF0+(69H*2)
		HEX	00		;end code
STT_HDMA_DT6E	EQU	$
;
;-------------- afQ XN[ -----------------
STAT_HDMA_DT7	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
STT_HDMA_DT7	EQU	$
		BYTE	69H+80H		;line no.
		WORD	HDMABUF1
		BYTE	69H+80H		;line no.
		WORD	HDMABUF1+(69H*2)
		HEX	00		;end code
STT_HDMA_DT7E	EQU	$
;
;
START_INIT	EQU	$
		JSL	>VRAMCL		; VRAM clear
		JSL	>GMURAMCLR	; use RAM clear
;
;-------------- Gq`lNA[ -----------------------
		JSL	>ENRAMCLR
;
;-------------- Q[vCq`lNA[ ---------
		M16			; memory 16bit mode
		LDY	#000		;(Y) <-- 0 clear
		STZ	<WORK21		;(WK20,21,22) <-- to memory address
		LDA	#GM_INIT_RAM_S
		STA	<WORK20
		LDA	#GM_INIT_RAM_SE ;(A) <-- number of byte
		JSL	>DMA_D_M
;
;-------------- }IG^C}[NA[ -------------
		STZ	!SUPER_FLAG
;
		I16			; index 16bit mode
;
;-------------- R[Xf[^AhXZbg -------------
		LDA	#STT_IN
		ASL	A
		TAX
		LDA	>MPSTATBL,X
		TAX
		LDA	>MPSTATUS,X
		AND	#000FFH
		ASL	A
		STA	<WORK0
		ASL	A
		ADC	<WORK0
		TAX
;
		LDA	>COURSTBL,X	;BG course data address set
		STA	<BGDTADR
		LDA	>COURSTBL+1,X
		STA	<BGDTADR+1
		LDA	>COURSTBL+3,X	;enemy data address set
		STA	>EDTADR
		LDA	>COURSTBL+5,X
		STA	>EDTADR+2
;
;-------------- R[XLN^[Zbg ---------------
		M8			; memory 8bit mode
;
		LDA	#CHR5C		; afPLN^[
		STA	<WORK10
		STA	<WORK11
		STA	<WORK12
;
		LDA	#CHR112-CHR10	; afQLN^[
		STA	<WORK13
		LDA	#CHR113-CHR10
		STA	<WORK14
;
		LDA	#CHR25A		; afRLN^[
		STA	<WORK15
		LDA	#CHR23B
		STA	<WORK16
;
		LDA	#CHR110C-CHR10	; naiLN^[
		STA	<WORK17
		STA	!OBJCHR_BNK+0
		LDA	#CHR110D-CHR10
		STA	<WORK18
		STA	!OBJCHR_BNK+1
		LDA	#CHR40A-CHR10
		STA	<WORK19
		STA	!OBJCHR_BNK+2
		STA	<WORK1A
		STA	!OBJCHR_BNK+3
		STA	<WORK1B
		STA	!OBJCHR_BNK+4
		STA	<WORK1C
		STA	!OBJCHR_BNK+5
;
		I16			; index 16bit mode
		LDY	#GMCHR
		JSL	>CHRSET
;
;-------------- afQ,R XN[ Zbg ------------
		MI16			; memory , index16bit mode
;
		LDA	#W1DMB2		; (A) <-- kf[^m.
		LDX	#WOB7CHR	; (X) <-- 𓀐AhX
		JSL	>UNCOMPRES
		LDX	#03800H		; Vram address
		JSR	INT_DM_DMA
;
		LDA	#W1DMB3		; (A) <-- kf[^m.
		LDX	#WOB7CHR	; (X) <-- 𓀐AhX
		JSL	>UNCOMPRES
		LDX	#03400H		; Vram address
		JSR	INT_DM_DMA
;
;-------------- J[ f[^ Zbg -------------------
		MI16			; memory , index 16bit mode
		LDX	#00000
STAT_INT_0100	EQU	$
		LDA	#07FFFH
		STA	>DATACOL+000H,X
		STA	>MOTOCOL+000H,X
;
		LDA	>COL_ADDRESS+INT_STT_COL_0,X
		STA	>CHNGCOL+000H,X
		LDA	>COL_ADDRESS+INT_STT_COL_1,X
		STA	>CHNGCOL+100H,X
		STA	>DATACOL+100H,X
		STA	>MOTOCOL+100H,X
		INX
		INX
		CPX	#00100H
		BCC	STAT_INT_0100
;
;-------------- ootWX^ Zbg ------------------
		MI8			; memory , index 8bit mode
		LDX	#GM01
		JSL	>GMMDST
;
		LDA	#068H
		STA	!BG1SCF
;
;-------------- gcl`ݒ -----------------------
		LDX	#004
STAT_INT_0250	EQU	$
		LDA	STAT_HDMA_DT5,X
		STA	4350H,X
		LDA	STAT_HDMA_DT6,X
		STA	4360H,X
		LDA	STAT_HDMA_DT7,X
		STA	4370H,X
		DEX
		BPL	STAT_INT_0250
;
		LDA	#BANK HDMABUF
		STA	4357H
		STA	4367H
		STA	4377H
;
		LDX	#STT_HDMA_DT5E-STT_HDMA_DT5-1
STAT_INT_0260	EQU	$
		LDA	STT_HDMA_DT5,X
		STA	>HDMAPR0,X
		LDA	STT_HDMA_DT6,X
		STA	>HDMAPR1,X
		LDA	STT_HDMA_DT7,X
		STA	>HDMAPR2,X
		DEX
		BPL	STAT_INT_0260
;
;-------------- Etc initial set ------------------------
		JSL	>DIVDTST	;div data set
;
;-------------- TEhvO] -----------------
		LDX	#W1_0_SOUND	;(X) <-- TEhvO]e[umD
		JSL	>SOUND_TR_2
;
;-------------- R[Xf[^WJ -----------------------
		JSL	>UNITST_SUB
;
;--------------  XN[l ----------------------
		M16			; memory 16bit mode
		LDA	#00720H
		STA	!ATSCRL_SCCV1
		STA	<SCCV1
		STA	!WRSCV1
		STA	<SCCV2
		STA	!ESCCV2
		STA	<SCCV3
		STA	!ESCCV3
		LDA	#00000H
		STA	<SCCH1
		SEC
		SBC	#00100H
		STA	!WRSCH1
;
		M8			; memory 8bit mode
;
		INC	!NEXTGOTO
		JSL	>BGINT
		STZ	!NEXTGOTO
;
		M16			; memory 16bit mode
		LDA	#00040H
		STA	!ATSCRL_SCCH1
		STA	<SCCH2
		STA	<SCCH3
		STA	!ESCCH2
		STA	!ESCCH3
;
		LDA	#00300
		STA	!TIMER
		LDA	#0003
		STA	!TIMER_HI
		LDA	#0000FH
		STA	!SCRLNO		; BG2,3 XN[Ȃ
		LDA	#00001
		STA	!ATSCRL_H
		STA	!ATSCRL_V
;
;------------------------------------------------------------------------
;-		naiZbg					-
;------------------------------------------------------------------------
		LDA	#0FFC0H+ST_DM_CX ;vC[wW
		STA	PLXPSL
		LDA	#0FFF0H+ST_DM_CY ;vC[xW
		STA	PLYPSL
;
;-------------- vC[Zbg ------------------------------------
		JSL	>PLINIT_2
;
		MEM8
		IDX8
;
;-------------- Ԃ񏉊Zbg --------------------------------------
		LDA	#EMOVE
		STA	ENMODE
		LDA	#BABYM_RMODE38
		STA	ENWRK2
		STZ	ENWRKC
;
		M16			; memory 16bit mode
		STZ	BABYNO
;
;-------------- vC[Zbg ------------------------------------
		LDA	#PCLR		;vC[[hZbg
		STA	PLMODE
		LDA	#02H		;vC[Zbg
		STA	PLCMKI
;
;-------------- bV[BZbg ----------------------------------------
		LDX	#0EH		;(X) <-- bV[BmD
STAT_INT_0530	EQU	$
		LDA	#YOSSY		;(A) <-- GmD
		JSL	>ENINSR_I	;GGAm
;;;;		    BCC	    STAT_INT_0540   ;	  h	 H ( no:STAT_INT_0540 )
;
		LDA	!ST_DM_YOSSY_X,X
		STA	ENXPSL,Y	;wWZbg
		LDA	!ST_DM_YOSSY_Y,X
		STA	ENYPSL,Y	;xWZbg
		TXA
		STA	ENCONT,Y	;bV[BmDZbg
		SEC
		SBC	#(3-1)*2
		CMP	#(6-3+1)*2
		BCS	STAT_INT_0540	;]H ( no:STAT_INT_0540 )
;
		LDA	#02H		;Zbg
		STA	ENMUKI,Y
STAT_INT_0540	EQU	$
		TXA
		LSR	A
		DEC	A		;[ SBC #(2-1) ]
		LSR	A		;[ CMP #2 ]
		BNE	STAT_INT_0550	;naiD揇ʑOɁH ( no:STAT_INT_0550 )
;
		LDA	#02H
		STA	ENYUSN,Y
STAT_INT_0550	EQU	$
		DEX
		DEX
		BPL	STAT_INT_0530
;
		LDA	#01F0H		;gXN[JE^[l`wZbg
		STA	PLSCRL_MAXX
;
		M8			; memory 8bit mode
;
		LDA	#001H		; n
		STA	<SOUND_0
;
		STZ	!NMI_PROG_NO	;荞݃vOmD
		LDA	#002H
		STA	!IRQFLG		;IRQ counter set
;;;;		    LDA	    #070H
		LDA	#050H
		STA	4207H		;H counter set
		LDA	#0D8H
		STA	4209H		;V counter set
		LDA	#10110001B
		STA	4200H		;timer IRQ "ON"
;
		LDA	#00FH
		STA	!FADNO
		LDA	!FADMK
		EOR	#001H
		AND	#001H
		STA	!FADMK
;
		JMP	>MODINC
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cl`]			+
;+			in			+
;+			A : ]oCg	+
;+			X : uq`lAhX	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
;
INT_DM_DMA	EQU	$
		STX	<WORK0
		I8			; index 8bit mode
		STA	4305H
		LDX	#10000000B
		STX	2115H		; inc mode set
		LDA	<WORK0
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & A bus address set
		LDA	#WOB7CHR
		STA	4302H		;(A) bus address(L,H)
		LDX	#BANK WOB7CHR
		STX	4304H		;	"       (B)
		LDX	#00000001B
		STX	420BH		; DMA "ON"
		I16			; index 16bit mode
		RTS
;
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*		CjV X^[g f			*
;*								*
;****************************************************************
STT_PLY_ADR	EQU	$
		WORD	STT_PLY_0000,STT_PLY_WAIT
		WORD	STT_PLY_0100,STT_PLY_WAIT
STT_PLY_STOP	EQU	$
		WORD	STT_PLY_0200,STT_PLY_0300
		WORD	STT_PLY_0400,STT_PLY_WAIT
STT_PLY_GO	EQU	$
		WORD	STT_PLY_0600
;
STT_PL_STP	EQU	(STT_PLY_STOP-STT_PLY_ADR)/2
STT_PL_GO	EQU	(STT_PLY_GO-STT_PLY_ADR)/2
;
;
START_PLAY	EQU	$
		JSL	>OAMDXCLR	; OAM clear
;
		LDA	!DEMO_NO
		ASL	A
		TAX
		JSR	(STT_PLY_ADR,X)
;
;----------------------------------------------- XN[ Zbg
;
		M16
;
		LDA	#081H
		STA	PLSCRL_CX
;
		M8
;
		JSL	>PLSCRL
;
;----------------------------------------------- n`lZbg
		JSL	>ENCSET		;enemy
		JSL	>PLCSET		;player
;
;----------------------------------------------- vC[ lnud
		JSL	>PLAYER
;
;----------------------------------------------- G lnud
		JSL	>ENEMY
;
		M16			; memory 16bit mode
		M_CHIP	DX_OAM
;
		LDA	<SCCH1
		STA	<SCCH3
		STA	ESCCH3
		M8			; memory 8bit mode
;
		JSR	STAT_PART_SCRL
;
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		J[ tF[h  XN[			+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_0000	EQU	$
		LDA	<FRCNT
		AND	#001
		BNE	STT_PLY_0090
		M16			; memory 16bit mode
		LDA	!ATSCRL_SCCH1
		CMP	#00100H
		BCS	STT_PLY_0010
		INC	A
STT_PLY_0010	EQU	$
		STA	!ATSCRL_SCCH1
		STA	<SCCH2
		STA	ESCCH2
		M8			; memory 8bit mode
		INC	!DEMO_WAIT
		LDA	!DEMO_WAIT
		AND	#007
		BNE	STT_PLY_0090
;
		LDA	>CLFDCNT
		CMP	#020H
		BCC	STT_PLY_0080
		LDA	#000
		STA	>CLFDCNT
		INC	!DEMO_NO
		INC	!MSGMOD
		LDA	#030H
		STA	!DEMO_WAIT
		BRA	STT_PLY_0090
;
STT_PLY_0080	EQU	$
		M16			; memory 16bit mode
		LDA	#MOTOCOL
		STA	>MOTOADR
		LDA	#CHNGCOL
		STA	>CHNGADR
;
		M_CHIP	COLFADE
;
		M8			; memory 8bit mode
;
STT_PLY_0090	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		bZ[W\ ̂P				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_0100	EQU	$
		LDA	#INT_MSG_0
		STA	>MSG_NO
		JSR	STT_PLY_MSG
;
		LDA	!MSGMOD
		BNE	STT_PLY_0190
		LDA	#040H
		STA	!DEMO_WAIT
STT_PLY_0190	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+	CjVX^[g [hmDCNg҂ !!	+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_0200	EQU	$
STT_PLY_0600	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		bZ[W\ ̂Q CjV Zbg		+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_0300	EQU	$
		INC	!MSGMOD
		LDA	#INT_MSG_1
		STA	>MSG_NO
		INC	!DEMO_NO
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		bZ[W\ ̂Q				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_0400	EQU	$
		JSR	STT_PLY_MSG
;
		LDA	!MSGMOD
		BNE	STT_PLY_0490
		LDA	#030H
		STA	!DEMO_WAIT
STT_PLY_0490	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		 ҂Ăˁ`				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_WAIT	EQU	$
		DEC	!DEMO_WAIT
		BNE	STT_PLY_WAT_PS
		STZ	!DEMO_WAIT
		INC	!DEMO_NO
STT_PLY_WAT_PS	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W\ !!			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STT_PLY_MSG	EQU	$
		JSL	>MSGDSP
		LDA	#00100000B
		TSB	!HD420C
		LDA	#000
		STA	!PLSTFG
		STA	!ENSTFG
;
		LDA	!MSGMOD		; bZ[WI ?
		BNE	STT_PLY_MSG_90	;	NO -> STT_PLY_MSG_90
		INC	!DEMO_NO
		LDA	!HD420C
		EOR	#00100000B
		STA	!HD420C
STT_PLY_MSG_90	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		XN[ Zbg				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STAT_PART_BG1	EQU	$
		BYTE	000H
		WORD	00140H
		WORD	00100H*6+(10H*15H)+7
		BYTE	000H
		WORD	00100H
		WORD	00100H*6+(10H*1BH)+7
		BYTE	000H
		WORD	00280H
		WORD	00100H*8	;end line
;
STAT_PART_BG2	EQU	$
		BYTE	000H
		WORD	00180H
		WORD	00100H*6+(10H*14H)+7
		BYTE	000H
		WORD	00200H
		WORD	00100H*8	;end line
;
;
STAT_PART_SCRL	EQU	$
		M16			; memory 16bit mode
		LDA	#0000		; afP
		STA	R1
		STA	CCWORK0
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDA	<SCCV1
		STA	R2		; R2 <- XN[JE^[u
		LDA	#STAT_PART_BG1
		STA	R3
		LDA	#BANK STAT_PART_BG1
		STA	R4
		LDA	#HDMABF0
		STA	R10
;
		M_CHIP	BG2SCSP
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF0	;]AhX
		LWORD	HDMABF0		;]AhX
;
		LDA	#0000		; afQ
		STA	R1
		STA	CCWORK0
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDA	<SCCV2
		STA	R2		; R2 <- XN[JE^[u
		LDA	#STAT_PART_BG2
		STA	R3
		LDA	#BANK STAT_PART_BG2
		STA	R4
		LDA	#HDMABF1
		STA	R10
;
		M_CHIP	BG2SCSP
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF1	;]AhX
		LWORD	HDMABF1		;]AhX
;
		M8			; memory 8bit mode
		LDA	#11000000B
		TSB	!HD420C
		RTS
;
;
;
;
		END
