;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: BG data file					*
;*	file name	: ys_w55.asm					*
;*									*
;************************************************************************
;
;
		include		ys_ename.h
;
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_play >------------------------------------------------
		EXT	PO_NORMAL,PO_DK_O_R,PO_DK_O_L,PO_DK_O_D,PO_DK_O_U
		EXT	PO_DK_I_R,PO_DK_I_L,PO_DK_I_D,PO_DK_I_U
;
;-------------< ys_mapdt >-----------------------------------------------
		EXT	CORS_54_00,CORS_54_01,CORS_54_02,CORS_54_03
;
		EXT	CORS_MIN0,CORS_MIN1,CORS_MIN2,CORS_MIN3
		EXT	CORS_MIN4,CORS_MIN5,CORS_MIN6,CORS_MIN7
		EXT	CORS_MIN8,CORS_MIN9
;
;
;************************************************************************
;*									*
;*		data							*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_16	GROUP	W55_data
W55_data	SECT	REL
;
;;;;K;;;;Group_5F	GROUP	W55_data
;;;;K;;;;W55_data	SECT	REL
;
;************************************************************************
;*		BG course data						*
;************************************************************************
;
;------------------------------------------------------------------------
;-		"ahoba00a.dat" (1995/06/26 04:42:38)			-
;------------------------------------------------------------------------
		GLB	BGDT_54_00
BGDT_54_00	EQU	$
		HEX	C3,9E,49,34,93,50,59,40,3D,00,02,52,C0,03,05,52
		HEX	C1,01,03,07,52,B3,01,04,03,52,95,06,02,52,9A,06
		HEX	04,52,9B,05,06,05,53,C1,01,03,03,53,B3,04,04,51
		HEX	C3,01,03,05,51,D7,01,02,07,51,C9,01,03,03,51,AB
		HEX	05,02,53,A8,05,05,53,A9,03,05,01,53,8D,01,07,04
		HEX	53,8F,01,07,06,54,91,01,06,04,54,B3,03,04,01,54
		HEX	D7,01,02,05,54,D9,01,02,07,54,CB,01,03,03,54,AD
		HEX	05,01,51,D5,01,02,01,51,B1,00,04,05,50,CF,01,03
		HEX	01,50,C0,0E,03,06,55,84,03,07,01,55,83,00,07,02
		HEX	55,82,07,04,55,C8,01,03,05,55,DC,01,02,01,55,DA
		HEX	01,02,07,55,CE,01,03,01,56,A0,00,05,03,56,A1,05
		HEX	06,51,B2,00,04,05,56,B6,03,04,06,56,9A,01,06,04
		HEX	56,BC,01,04,02,56,B5,04,01,56,CE,01,03,05,59,A0
		HEX	01,05,06,59,92,01,06,04,59,B4,01,04,01,59,C6,01
		HEX	03,05,59,C8,01,03,01,59,BA,00,04,01,5A,B2,03,04
		HEX	05,5A,B6,01,04,03,5A,A8,05,02,58,A9,05,01,58,AA
		HEX	05,05,01,5D,BF,00,04,05,5E,20,01,0D,67,5E,72,09
		HEX	08,01,5E,12,0F,05,02,5D,2F,09,00,4E,FF,FD,01,5F
		HEX	0B,04,06,05,5F,19,01,05,02,4F,2B,0E,03,4F,2F,0E
		HEX	01,4F,2C,02,0E,04,5D,A1,03,05,01,5D,C5,07,03,05
		HEX	5D,CD,01,03,01,5F,12,02,05,14,5E,54,07,0C,14,5D
		HEX	5F,06,05,5F,5E,52,01,00,62,5E,50,00,00,67,5E,51
		HEX	00,00,7F,5D,7F,01,02,67,5E,7C,13,0A,14,5E,2B,05
		HEX	10,14,5F,80,0F,0A,7F,5E,9B,14,09,7C,5F,98,FE,7C
		HEX	5F,99,02,7C,5E,9B,05,7C,5F,9F,FD,7C,5F,92,FD,7C
		HEX	5F,93,03,00,6F,00,FF,14,5E,B6,01,05,14,5E,C4,02
		HEX	01,14,5D,DE,09,03,5F,5E,C4,01,00,5F,5D,DE,01,00
		HEX	14,5E,45,04,01,61,5E,47,01,00,5F,5E,45,01,00,14
		HEX	5E,1F,05,03,60,5E,2D,01,01,14,5F,30,02,05,14,5F
		HEX	72,02,01,61,5F,72,01,00,7F,5F,A3,02,01,7F,5E,D6
		HEX	03,03,7F,5E,E8,02,03,7F,5E,A8,02,02,7F,5E,C7,02
		HEX	02,7F,5E,D5,02,03,7F,5E,E3,03,02,7F,5E,72,02,02
		HEX	7F,5E,63,03,02,00,6E,00,FF,14,5E,C0,03,01,5F,5E
		HEX	C0,01,00,61,5E,C2,01,00,5C,5E,B0,01,00,59,5E,B2
		HEX	01,00,01,5E,06,01,03,05,5E,14,01,02,04,5E,08,01
		HEX	02,14,5F,76,02,01,5F,5F,76,01,00,62,5F,78,00,00
		HEX	14,5F,7B,03,01,5F,5F,7B,01,00,62,5F,7E,00,00,01
		HEX	4B,96,13,18,01,4B,53,01,01,02,4B,95,16,03,4C,9A
		HEX	18,01,49,EB,06,11,02,49,EA,0D,03,4A,E2,0D,14,59
		HEX	4A,08,06,5C,59,BB,01,00,59,59,BE,01,00,02,4A,ED
		HEX	11,01,4A,EE,03,11,03,4B,E2,11,14,4A,AD,02,10,14
		HEX	4A,CE,04,10,7F,4A,9D,05,0E,00,49,FF,FF,00,4A,F0
		HEX	FF,02,5D,A0,05,14,5D,F5,09,01,14,5D,C0,01,04,14
		HEX	5D,D1,02,03,14,5D,E3,02,02,61,5D,E4,01,00,61,5D
		HEX	D2,01,00,62,5D,C1,00,00,7F,5D,E0,01,02,7F,5D,E1
		HEX	01,03,7F,5D,F1,03,03,00,6D,0F,FF,01,4D,97,04,15
		HEX	02,4D,96,13,03,4D,9C,13,7F,5D,46,06,04,7F,5D,76
		HEX	01,03,7F,5D,89,03,02,14,4D,B6,06,10,67,5D,B8,00
		HEX	00,59,5D,C9,01,00,5D,5D,C7,00,00,7F,4D,B6,06,0C
		HEX	7F,5D,69,03,03,7B,5D,79,01,02,7F,5D,66,01,04,7F
		HEX	5D,8B,01,02,00,4D,FF,FF,00,5A,A3,6A,00,58,9C,6A
		HEX	14,59,2C,03,03,57,59,3D,02,57,59,4C,02,03,58,C3
		HEX	03,06,57,A7,01,05,04,57,C9,01,03,05,57,DC,01,02
		HEX	01,57,CE,04,03,01,57,DB,00,02,00,57,AF,6B,5A,5A
		HEX	CE,00,00,59,5A,DF,01,00,57,5E,AC,01,57,5E,8E,01
		HEX	67,5E,2B,01,01,14,5E,49,03,01,5F,5E,4A,01,00,67
		HEX	5E,49,00,00,67,5E,A5,00,01,5D,5E,B4,00,00,67,59
		HEX	AD,00,00,67,5F,74,00,00,67,5F,62,00,00,5D,5F,62
		HEX	02,00,57,5F,60,01,01,57,A5,01,05,05,57,C0,01,03
		HEX	01,57,B2,00,04,05,57,B3,01,04,01,5F,15,03,05,14
		HEX	4B,C5,04,16,14,4C,C3,07,16,14,5B,89,0B,0A,14,5B
		HEX	29,0A,02,14,5B,4B,06,02,5D,5C,61,00,00,5C,5B,7F
		HEX	01,00,14,5C,62,01,03,14,5C,70,02,02,5F,5C,70,01
		HEX	00,60,5C,62,00,00,67,5C,42,00,00,14,5C,00,03,02
		HEX	5F,5C,00,01,01,60,5C,02,00,00,7F,5B,15,01,03,7F
		HEX	4C,E5,05,08,7F,5C,14,02,02,7F,5C,56,02,02,7B,5C
		HEX	6A,04,09,7B,5C,DE,01,03,7F,5B,C3,01,02,7F,5B,99
		HEX	10,07,7C,5B,99,02,7F,5C,82,04,02,7C,5B,9D,FF,7C
		HEX	5B,9E,01,7C,5C,91,FF,7C,5C,82,02,7F,5C,C8,02,02
		HEX	57,5C,CB,02,00,4B,FF,FF,00,6C,00,FF,03,5C,B7,04
		HEX	67,5B,2C,00,00,67,5B,3D,02,00,14,5B,4A,01,01,59
		HEX	5B,7C,01,00,5A,5B,6B,00,00,67,5B,5A,00,00,14,5B
		HEX	79,03,01,61,5B,7B,01,00,14,5B,69,01,01,61,5B,2B
		HEX	01,01,62,5B,2A,00,00,04,5B,CF,01,03,01,5C,D1,00
		HEX	02,07,5B,DE,00,02,7F,5B,65,05,0B,7F,5B,85,04,08
		HEX	7C,5B,6A,FD,62,5B,6A,00,00,00,6B,0F,FF,7F,5B,91
		HEX	01,02,7B,5A,5F,01,02,7B,5A,5E,FF,02,7F,5A,7D,01
		HEX	02,04,5B,C6,01,03,05,5B,D8,03,02,06,5B,BC,01,04
		HEX	02,5C,B6,02,01,5C,D2,04,02,02,5B,C5,03,00,50,A2
		HEX	50,7A,50,67,02,05,7B,50,67,FE,05,7B,50,69,04,05
		HEX	7F,50,74,02,02,7F,50,68,02,03,7F,50,A7,01,01,C6
		HEX	50,6B,FE,C6,50,8D,00,C4,50,7A,02,00,53,7D,A4,00
		HEX	55,CA,A4,00,56,BE,A4,00,59,B6,A4,00,4E,F6,A4,00
		HEX	4F,F5,50,00,4F,F7,50,00,5C,B2,50,68,51,7D,01,00
		HEX	C6,51,8F,02,68,52,90,00,00,68,51,8C,00,00,68,52
		HEX	57,01,00,68,53,64,03,00,68,53,73,00,00,68,53,78
		HEX	00,00,C6,55,41,FC,68,55,53,00,00,68,58,75,02,00
		HEX	68,58,84,00,00,68,58,88,00,00,68,5A,7A,02,00,68
		HEX	5A,89,00,00,68,5A,8D,00,00,14,4F,CB,04,03,7F,4F
		HEX	DB,03,00,14,4F,9D,01,01,00,40,A6,FF,67,5A,40,00
		HEX	01,60,5A,41,00,00,57,59,5D,02,7F,59,5A,01,04,7F
		HEX	5A,71,01,02,7F,59,6C,03,02,7F,59,7F,01,02,3C,5C
		HEX	17,FF,00,4C,F0,FF,FF
;-------------- next go to data -----------------------------------------
		HEX	4F		;door pos
		BYTE	CORS_54_01	;corse data table pointer
		HEX	00,4A		;player X,Y pos
		BYTE	PO_DK_I_R	;player mode
;
		HEX	5C		;door pos
		BYTE	CORS_54_03	;corse data table pointer
		HEX	04,4C		;player X,Y pos
		BYTE	PO_DK_O_U	;player mode
		HEX	FF
;
;------------------------------------------------------------------------
;-		"ahoba01a.dat" (1995/06/26 04:43:13)			-
;------------------------------------------------------------------------
		GLB	BGDT_54_01
BGDT_54_01	EQU	$
		HEX	C3,9E,49,34,93,50,59,40,3D,20,01,40,C6,07,03,02
		HEX	30,F0,10,01,30,F1,04,10,03,30,F6,0D,14,40,51,01
		HEX	01,05,40,CE,03,13,07,41,A2,03,15,05,41,66,03,19
		HEX	01,41,4A,03,1B,04,41,4E,01,1B,03,42,50,1A,14,41
		HEX	7E,02,1A,14,41,6A,04,0B,14,41,6E,01,01,14,41,78
		HEX	02,0B,14,41,86,02,0B,14,41,A5,01,0A,14,41,B3,02
		HEX	0A,14,41,D1,02,09,61,41,6E,01,00,5F,41,6A,01,00
		HEX	5F,41,78,01,00,60,41,86,01,01,60,41,A5,00,00,60
		HEX	41,B3,01,01,60,41,D1,01,01,14,40,FD,04,04,5F,40
		HEX	FD,03,01,7F,41,98,08,18,7F,41,8A,05,02,7F,41,D5
		HEX	03,16,7F,41,B6,03,03,7F,50,5D,07,08,7C,41,8D,01
		HEX	7C,41,8C,FF,00,60,0F,FF,00,61,00,FF,00,62,00,FF
		HEX	7F,41,E3,03,04,00,41,2B,50,14,40,80,06,03,00,50
		HEX	0F,FF,00,51,00,FF,00,52,00,FF,06,46,0F,01,08,04
		HEX	47,21,01,06,07,46,2C,01,06,05,47,34,01,05,07,47
		HEX	26,01,06,01,47,08,03,08,02,46,2B,0F,03,47,0C,11
		HEX	00,37,EB,50,14,46,4B,03,0F,14,47,29,03,10,14,46
		HEX	7E,0B,0C,7F,46,AB,11,0A,14,47,47,02,03,14,47,55
		HEX	02,02,60,47,55,01,01,61,46,4C,01,00,14,46,6E,02
		HEX	01,7F,46,6B,01,05,7F,46,8C,04,03,7F,47,79,03,04
		HEX	7F,47,95,05,02,7F,47,3B,01,02,7C,46,8D,FF,7C,46
		HEX	8E,01,7C,47,A2,FF,7C,47,A3,01,7C,47,97,FF,7C,47
		HEX	98,01,7C,47,7B,01,7C,47,7A,FF,60,47,74,00,00,62
		HEX	47,47,00,02,60,47,48,00,01,60,47,29,01,01,5F,47
		HEX	2A,01,00,01,46,0E,00,03,01,47,33,00,03,14,46,4E
		HEX	02,02,60,46,4E,00,00,14,47,60,01,01,62,46,4F,01
		HEX	01,14,47,60,02,01,62,47,62,01,01,00,56,0F,FF,00
		HEX	57,00,FF,02,2C,DA,0C,03,2D,D3,0C,01,2C,DB,07,0C
		HEX	14,2C,EA,09,0A,67,3C,7D,00,01,5D,3C,9B,01,00,59
		HEX	3C,8F,03,00,7F,2C,BA,09,07,7F,3C,2D,02,01,7F,3C
		HEX	1A,01,05,7F,3C,1B,01,03,7F,3D,52,01,02,7B,3D,01
		HEX	FF,02,7B,3D,02,01,02,58,3C,AA,09,00,00,2C,FF,FF
		HEX	00,2D,F0,FF,7F,3D,32,01,01,02,2E,B2,2B,01,2E,B3
		HEX	1C,2A,14,2E,D2,0B,29,14,2E,DD,0A,1D,14,4F,27,07
		HEX	06,7F,3E,92,01,03,7F,4E,02,03,07,7F,4E,B2,03,08
		HEX	7C,4E,B5,FE,14,4E,CD,04,04,14,4F,D1,05,04,14,4F
		HEX	F6,01,02,61,4F,D3,01,00,62,4F,D5,02,04,5C,4E,CC
		HEX	01,00,5F,4E,DD,01,00,62,4E,DC,00,00,67,4E,CE,03
		HEX	00,5D,4F,A7,00,00,5C,4F,B5,01,00,5D,4F,98,00,00
		HEX	59,4F,99,01,00,61,4F,2A,01,00,60,4F,2C,00,00,62
		HEX	4F,2E,00,00,7F,2E,E2,11,07,7F,2F,F2,03,02,7F,3F
		HEX	03,01,03,7F,3E,49,08,03,7F,4E,34,05,05,7F,3E,7B
		HEX	04,03,7C,4E,05,FE,7C,4E,39,FE,7B,3E,35,FF,02,7B
		HEX	3E,36,01,02,7B,3E,59,01,02,7B,3E,8B,01,02,7B,3E
		HEX	8F,FF,02,7C,3E,0E,03,7C,3E,0D,FD,7C,3E,09,02,7C
		HEX	3E,08,FE,7F,4E,86,01,01,7F,4E,D5,01,02,7F,3E,D2
		HEX	01,01,7F,3E,42,01,02,00,5F,00,FF,00,5E,0F,FF,00
		HEX	2E,FF,FF,7F,4E,59,01,02,14,4F,07,02,02,62,4F,08
		HEX	01,01,7F,3E,FC,06,04,7F,4F,01,02,02,7F,3E,E9,05
		HEX	04,7F,3E,D8,03,02,7C,3E,FF,FF,7C,3F,F0,01,7B,4E
		HEX	09,01,02,7F,4E,2E,02,02,7F,4F,62,03,02,7F,4F,44
		HEX	03,03,7F,4F,80,03,01,62,3F,A4,03,03,67,3F,94,03
		HEX	00,5E,3F,84,00,00,57,4E,7F,02,57,3E,84,02,67,3F
		HEX	65,02,02,14,3F,17,07,04,5D,3F,65,01,00,59,3F,57
		HEX	03,00,61,3F,18,01,00,60,3F,1B,00,00,62,3F,1E,00
		HEX	00,67,3F,1A,00,00,7C,4F,47,FE,7F,4E,B3,02,02,01
		HEX	44,C9,00,08,04,44,B7,01,07,05,44,CA,01,06,07,44
		HEX	BC,00,02,01,44,AD,01,03,06,44,A6,00,03,01,44,A4
		HEX	01,05,03,44,AF,06,02,44,A3,07,14,44,C3,02,04,14
		HEX	44,CD,02,04,5F,44,CD,01,00,14,44,D5,03,03,14,44
		HEX	DA,03,03,60,44,DA,01,00,62,44,D7,01,01,61,44,C4
		HEX	01,00,7F,44,E3,03,02,7F,44,EC,03,02,7F,44,D3,02
		HEX	02,7F,44,DD,02,01,00,54,09,FF,6C,38,00,77,00,6C
		HEX	30,00,7F,00,57,4E,A6,02,7F,4E,92,01,03,7B,4E,B1
		HEX	03,05,7A,4D,B9,08,05,7B,4D,B9,FC,05,7F,4D,BD,02
		HEX	01,7F,4D,A8,03,03,7F,4D,D8,02,01,7F,4E,C2,01,02
		HEX	57,4D,DC,05,00,5D,0F,FF,00,5E,00,FF,68,43,15,05
		HEX	01,68,45,18,01,02,68,45,27,03,00,68,49,0A,07,01
		HEX	00,37,E8,50,00,44,83,50,00,44,8E,50,14,3C,9D,02
		HEX	01,60,3C,9D,00,00,62,3C,9F,00,00,67,3C,7E,00,01
		HEX	15,44,1E,06,15,34,80,04,15,34,68,06,15,36,B0,05
		HEX	15,45,98,05,15,46,96,02,15,48,91,05,15,49,66,05
		HEX	15,4A,AB,05,15,4C,4D,04,15,3B,DD,04,15,4B,41,04
		HEX	15,3A,A3,05,15,38,4A,04,68,46,26,00,00,68,3B,AB
		HEX	00,00,68,3B,B7,00,00,7F,40,91,04,01,14,40,54,01
		HEX	01,7A,40,6A,02,05,7B,40,6A,FF,05,7B,40,6C,01,05
		HEX	00,40,A7,50,15,49,AE,04,15,4C,74,04,15,48,8D,04
		HEX	03,2F,CF,23,14,4F,5E,01,03,00,2F,F2,FF,00,20,D1
		HEX	FF,FF
;-------------- next go to data -----------------------------------------
		HEX	40		;door pos
		BYTE	CORS_54_00	;corse data table pointer
		HEX	FF,4E		;player X,Y pos
		BYTE	PO_DK_I_L	;player mode
;
		HEX	4F		;door pos
		BYTE	CORS_54_02	;corse data table pointer
		HEX	00,44		;player X,Y pos
		BYTE	PO_DK_I_R	;player mode
		HEX	FF
;
;------------------------------------------------------------------------
;-		"ahoba02a.dat" (1995/06/26 04:43:46)			-
;------------------------------------------------------------------------
		GLB	BGDT_54_02
BGDT_54_02	EQU	$
		HEX	C3,9E,49,34,93,50,59,40,3D,40,01,41,80,07,07,03
		HEX	21,C0,1C,01,20,C0,0F,23,14,20,E8,08,19,7F,20,D0
		HEX	10,06,7F,40,4F,01,02,7F,30,2A,06,0C,7B,30,8A,06
		HEX	06,7F,30,AC,01,03,7F,40,0F,01,02,14,30,C5,03,05
		HEX	59,40,78,03,00,5A,40,67,00,00,5C,40,65,01,00,14
		HEX	40,11,0A,04,67,30,C5,01,01,60,30,C7,00,00,60,30
		HEX	E5,01,01,14,40,03,02,01,7F,40,06,03,02,7F,30,F8
		HEX	04,02,7F,30,EA,03,02,7F,40,0A,03,03,7F,40,0D,01
		HEX	02,7F,40,15,02,01,7F,40,26,02,01,05,41,88,01,07
		HEX	03,41,7C,08,01,41,7A,01,08,00,41,5B,50,02,42,52
		HEX	0A,06,42,53,01,0A,04,42,75,01,08,01,42,87,02,07
		HEX	05,42,8A,03,07,07,42,6E,02,09,03,43,31,0C,02,43
		HEX	06,0F,0D,43,54,02,07,43,07,01,0F,00,32,F0,FD,04
		HEX	44,3E,03,0C,01,45,52,01,0A,03,45,54,0A,02,44,3D
		HEX	0C,05,33,E9,01,11,04,34,D0,03,12,06,34,F4,02,10
		HEX	03,44,27,0D,01,33,DB,04,12,14,43,26,05,02,14,43
		HEX	1A,08,03,5F,43,1A,01,00,14,44,60,07,02,0D,44,97
		HEX	02,0D,44,7B,02,0D,44,47,02,14,43,3E,06,03,59,43
		HEX	6E,01,01,5A,44,70,01,02,59,44,92,01,00,14,44,54
		HEX	01,01,61,44,34,01,02,14,33,DC,02,04,62,44,11,02
		HEX	04,61,43,1F,01,00,57,43,0C,02,02,45,7A,08,00,35
		HEX	0F,FD,00,36,00,FD,01,45,7B,04,08,02,05,9F,3E,01
		HEX	06,90,0F,46,03,07,90,46,14,06,B7,09,3B,14,05,BF
		HEX	0A,0B,7F,05,CF,11,07,7F,36,CD,03,08,7F,36,EC,02
		HEX	02,7F,46,2C,02,01,7F,36,6A,06,03,7F,36,3D,03,04
		HEX	7F,36,9B,02,01,7F,36,0F,01,04,7F,36,5C,02,02,7F
		HEX	26,AF,01,03,14,45,2F,08,04,7F,45,3F,01,02,7F,16
		HEX	3D,03,08,7F,16,BF,01,04,7F,16,6C,02,03,7B,16,18
		HEX	01,02,7B,16,17,FF,02,7F,16,3A,02,01,7F,16,31,02
		HEX	01,7F,26,1C,04,05,7C,26,1C,02,7F,26,5E,02,02,7F
		HEX	26,4B,02,01,14,46,53,0A,03,59,46,83,03,00,5C,46
		HEX	9A,03,00,14,46,05,02,02,60,36,F5,03,03,61,46,22
		HEX	01,00,5A,36,D7,01,00,67,46,24,00,00,67,36,E7,01
		HEX	00,00,45,5B,50,60,36,27,02,02,67,26,F7,02,02,5A
		HEX	26,C7,02,03,5A,16,87,02,02,67,16,B7,02,03,60,16
		HEX	F7,02,02,14,26,46,01,04,14,36,76,01,03,60,36,76
		HEX	00,00,60,26,46,00,00,5A,26,96,00,00,5A,36,B6,00
		HEX	00,01,07,9A,10,46,01,18,CB,02,33,03,08,9B,13,02
		HEX	07,99,46,14,07,B9,0A,46,14,08,A3,08,11,7F,07,C9
		HEX	12,0A,00,06,FF,FF,00,07,F0,FF,00,08,F0,FF,00,05
		HEX	FF,FF,00,57,0F,FF,00,58,00,FF,7F,47,69,02,07,7F
		HEX	37,89,03,06,7F,27,A9,05,05,7F,47,8B,01,02,7F,47
		HEX	39,01,02,7F,37,DB,02,02,7F,37,39,01,03,7F,27,FB
		HEX	02,01,7F,37,9C,01,01,7C,27,AE,FD,7F,17,E9,02,06
		HEX	7F,17,59,02,04,7F,27,0B,01,02,7F,27,79,01,02,7F
		HEX	17,89,01,03,7F,17,6E,03,01,7B,18,34,FE,03,7B,18
		HEX	35,02,03,7F,18,8A,01,02,7F,18,68,01,01,7F,18,46
		HEX	02,02,62,38,71,02,02,67,38,41,02,02,5D,38,41,02
		HEX	00,5D,38,E2,01,00,5D,48,20,01,00,67,38,F2,01,10
		HEX	67,48,30,01,0C,03,18,CE,09,01,28,5E,02,0A,5D,18
		HEX	C4,01,00,67,28,50,03,00,61,28,60,01,00,62,28,62
		HEX	01,03,00,19,F0,FD,14,28,03,0B,04,04,29,51,03,0A
		HEX	03,29,75,02,01,29,95,01,06,04,29,97,03,06,03,29
		HEX	BB,04,14,18,D3,04,03,62,18,D4,01,01,61,18,D6,01
		HEX	02,7F,28,1D,01,02,7F,18,F0,03,03,7F,17,DE,03,03
		HEX	7F,17,ED,02,01,00,21,F0,FF,5C,28,50,03,00,59,28
		HEX	44,03,00,7F,46,28,02,02,7F,46,19,02,02,7F,46,46
		HEX	03,02,6B,29,CC,33,03,00,2A,BB,82,5A,18,B6,01,00
		HEX	14,18,B8,01,05,67,38,0E,01,1F,68,27,08,00,00,68
		HEX	27,15,00,00,8B,37,C3,04,00,8B,37,34,04,00,8B,27
		HEX	C5,04,00,8B,27,91,03,00,8B,26,6F,01,00,57,27,EF
		HEX	03,8B,36,7C,00,01,7F,27,FF,03,02,8B,38,00,01,00
		HEX	8B,27,A1,00,02,8A,47,42,02,00,8A,47,55,00,00,8A
		HEX	37,A8,02,00,8A,37,BB,00,00,8A,36,7F,02,00,8A,37
		HEX	92,02,00,8A,37,12,02,00,C7,27,75,02,C7,27,64,04
		HEX	7B,41,25,02,05,7B,41,24,FE,05,68,19,90,00,00,00
		HEX	29,AD,50,02,20,90,26,14,40,10,01,04,5F,40,03,01
		HEX	00,00,2F,23,FF,00,20,F0,FF,FF
;-------------- next go to data -----------------------------------------
		HEX	40		;door pos
		BYTE	CORS_54_01	;corse data table pointer
		HEX	FF,47		;player X,Y pos
		BYTE	PO_DK_I_L	;player mode
;
		HEX	FF
;
;------------------------------------------------------------------------
;-		"trkun0.dat" (1995/06/26 21:34:03)						-
;------------------------------------------------------------------------
		GLB	BGDT_54_03
BGDT_54_03	EQU	$
		HEX	C3,9E,49,34,90,00,59,40,3D,60,66,40,00,0F,01,66
		HEX	40,C2,0D,03,66,40,2F,01,09,66,40,7B,03,01,3C,40
		HEX	C4,03,00,41,00,FF,FF
;-------------- next go to data -----------------------------------------
		HEX	40		;door pos
		BYTE	CORS_54_00	;corse data table pointer
		HEX	C7,50		;player X,Y pos
		BYTE	PO_DK_O_D	;player mode
;
		HEX	FF
;
;
;
;
;
;
;************************************************************************
;*		enemy data						*
;************************************************************************
;
;		LWORD	[enemy no.]+([X pos]<<16)+([Y pos]<<9)
;		LWORD	[x] : [y]
;
;------------------------------------------------------------------------
;-		"ahoba00a.end" (1995/06/24 13:47:00)			-
;------------------------------------------------------------------------
		GLB	ENDT_54_00
ENDT_54_00	EQU	$
		LWORD	AHOBD+(029H<<16)+(054H<<9)
		LWORD	AHOBD+(01FH<<16)+(052H<<9)
		LWORD	AHOBD+(035H<<16)+(050H<<9)
		LWORD	AHOBD+(041H<<16)+(052H<<9)
		LWORD	SNXGO+(0FFH<<16)+(04FH<<9)
		LWORD	ZPAC3+(0E9H<<16)+(055H<<9)
		LWORD	AHOB2+(09FH<<16)+(052H<<9)
		LWORD	AHOB2+(080H<<16)+(05BH<<9)
		LWORD	AHOB2+(0BDH<<16)+(052H<<9)
		LWORD	BAHOB+(04BH<<16)+(052H<<9)
		LWORD	BAHOB+(057H<<16)+(054H<<9)
		LWORD	BAHOB+(069H<<16)+(054H<<9)
		LWORD	BAHOB+(097H<<16)+(052H<<9)
		LWORD	AHOBD+(0F1H<<16)+(05AH<<9)
		LWORD	AHOBD+(0D9H<<16)+(054H<<9)
		LWORD	DBAHO+(061H<<16)+(059H<<9)
		LWORD	DBAH2+(081H<<16)+(05BH<<9)
		LWORD	DBAH2+(0C7H<<16)+(05AH<<9)
		LWORD	AHOBD+(07CH<<16)+(053H<<9)
		LWORD	AHOBD+(07FH<<16)+(054H<<9)
		LWORD	YAJI1+(0EDH<<16)+(056H<<9)
		LWORD	YAJI1+(0C2H<<16)+(053H<<9)
		LWORD	COINR+(0E8H<<16)+(05BH<<9)
		LWORD	COINR+(0E9H<<16)+(05CH<<9)
		LWORD	COIN2+(0EAH<<16)+(05BH<<9)
		LWORD	QKM0C+(0F6H<<16)+(04BH<<9)
		LWORD	COIN2+(0BDH<<16)+(055H<<9)
		LWORD	COINR+(0BFH<<16)+(055H<<9)
		LWORD	COIN2+(0C1H<<16)+(054H<<9)
		LWORD	COIN2+(0BBH<<16)+(054H<<9)
		LWORD	MC1UP+(07EH<<16)+(054H<<9)
		LWORD	FLWH0+(05AH<<16)+(05CH<<9)
		LWORD	FLWH0+(06EH<<16)+(05BH<<9)
		LWORD	FLWH0+(0E6H<<16)+(04FH<<9)
		LWORD	PANSY+(023H<<16)+(059H<<9)
		LWORD	PANSY+(048H<<16)+(05CH<<9)
		LWORD	PANSY+(0E3H<<16)+(050H<<9)
		LWORD	PANSY+(0EBH<<16)+(050H<<9)
		LWORD	BTFLY+(0E7H<<16)+(04EH<<9)
		LWORD	BTFLY+(096H<<16)+(05AH<<9)
		LWORD	BTFLY+(05AH<<16)+(05AH<<9)
		LWORD	BTFLY+(03DH<<16)+(055H<<9)
		LWORD	EGG02+(0FDH<<16)+(04AH<<9)
		LWORD	QKM00+(09CH<<16)+(052H<<9)
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		"ahoba01a.end" (1995/06/20 00:15:44)			-
;------------------------------------------------------------------------
		GLB	ENDT_54_01
ENDT_54_01	EQU	$
		LWORD	CHG02+(01DH<<16)+(040H<<9)
		LWORD	CHG02+(073H<<16)+(040H<<9)
		LWORD	CHG02+(0CDH<<16)+(034H<<9)
		LWORD	YAJI1+(0D1H<<16)+(035H<<9)
		LWORD	YAJI1+(0CFH<<16)+(035H<<9)
		LWORD	YAJI1+(0D1H<<16)+(033H<<9)
		LWORD	SNXGO+(0FFH<<16)+(048H<<9)
		LWORD	WARPS+(0F0H<<16)+(046H<<9)
		LWORD	YAJI1+(0F9H<<16)+(043H<<9)
		LWORD	YAJI1+(0E9H<<16)+(043H<<9)
		LWORD	YAJI0+(0EDH<<16)+(046H<<9)
		LWORD	ZPAC2+(0E7H<<16)+(049H<<9)
		LWORD	ZPAC2+(0E5H<<16)+(037H<<9)
		LWORD	ZFLW2+(0FDH<<16)+(033H<<9)
		LWORD	AHOBD+(029H<<16)+(03AH<<9)
		LWORD	AHOBD+(029H<<16)+(038H<<9)
		LWORD	AHOBD+(029H<<16)+(036H<<9)
		LWORD	AHOBD+(02DH<<16)+(042H<<9)
		LWORD	AHOBD+(04FH<<16)+(03CH<<9)
		LWORD	AHOBD+(04FH<<16)+(03AH<<9)
		LWORD	AHOBD+(04FH<<16)+(038H<<9)
		LWORD	AHOBD+(05BH<<16)+(032H<<9)
		LWORD	AHOBD+(05DH<<16)+(034H<<9)
		LWORD	AHOBD+(05FH<<16)+(036H<<9)
		LWORD	AHOBD+(067H<<16)+(03CH<<9)
		LWORD	AHOBD+(065H<<16)+(03AH<<9)
		LWORD	AHOBD+(069H<<16)+(03EH<<9)
		LWORD	AHOBD+(063H<<16)+(048H<<9)
		LWORD	AHOBD+(069H<<16)+(04AH<<9)
		LWORD	AHOBD+(059H<<16)+(04AH<<9)
		LWORD	AHOBD+(053H<<16)+(04AH<<9)
		LWORD	AHOBD+(057H<<16)+(046H<<9)
		LWORD	AHOBD+(089H<<16)+(03AH<<9)
		LWORD	AHOBD+(08BH<<16)+(038H<<9)
		LWORD	AHOBD+(08DH<<16)+(036H<<9)
		LWORD	AHOBD+(095H<<16)+(036H<<9)
		LWORD	AHOBD+(095H<<16)+(038H<<9)
		LWORD	AHOBD+(095H<<16)+(03AH<<9)
		LWORD	AHOBD+(08BH<<16)+(044H<<9)
		LWORD	AHOBD+(08BH<<16)+(046H<<9)
		LWORD	AHOBD+(08BH<<16)+(048H<<9)
		LWORD	AHOBD+(09BH<<16)+(044H<<9)
		LWORD	AHOBD+(09BH<<16)+(046H<<9)
		LWORD	AHOBD+(09BH<<16)+(048H<<9)
		LWORD	AHOBD+(0B1H<<16)+(038H<<9)
		LWORD	AHOBD+(0AFH<<16)+(03AH<<9)
		LWORD	AHOBD+(0BDH<<16)+(040H<<9)
		LWORD	AHOBD+(0BFH<<16)+(042H<<9)
		LWORD	AHOBD+(0C1H<<16)+(044H<<9)
		LWORD	AHOBD+(0A7H<<16)+(046H<<9)
		LWORD	AHOBD+(0A5H<<16)+(040H<<9)
		LWORD	AHOBD+(0A5H<<16)+(044H<<9)
		LWORD	AHOBD+(0A3H<<16)+(042H<<9)
		LWORD	AHOBD+(0A7H<<16)+(03EH<<9)
		LWORD	AHOBD+(02BH<<16)+(04EH<<9)
		LWORD	AHOBD+(02DH<<16)+(04CH<<9)
		LWORD	AHOBD+(02FH<<16)+(04AH<<9)
		LWORD	AHOBD+(031H<<16)+(048H<<9)
		LWORD	AHOBD+(033H<<16)+(046H<<9)
		LWORD	GATE0+(00BH<<16)+(049H<<9)
		LWORD	CHG02+(049H<<16)+(048H<<9)
		LWORD	AHOBD+(0D9H<<16)+(04EH<<9)
		LWORD	AHOBD+(0DBH<<16)+(04CH<<9)
		LWORD	AHOBD+(0DDH<<16)+(04AH<<9)
		LWORD	CHG02+(071H<<16)+(048H<<9)
		LWORD	YAJI1+(0E9H<<16)+(04CH<<9)
		LWORD	YAJI0+(075H<<16)+(048H<<9)
		LWORD	YAJI0+(079H<<16)+(046H<<9)
		LWORD	SNXG2+(000H<<16)+(04BH<<9)
		LWORD	COINR+(071H<<16)+(03FH<<9)
		LWORD	COINR+(06FH<<16)+(03EH<<9)
		LWORD	COINR+(075H<<16)+(03FH<<9)
		LWORD	COINR+(077H<<16)+(03EH<<9)
		LWORD	ZFLW2+(0CEH<<16)+(03AH<<9)
		LWORD	COINR+(05EH<<16)+(042H<<9)
		LWORD	COINR+(062H<<16)+(042H<<9)
		LWORD	COINR+(052H<<16)+(047H<<9)
		LWORD	COINR+(054H<<16)+(045H<<9)
		LWORD	COINR+(03CH<<16)+(044H<<9)
		LWORD	COINR+(03FH<<16)+(047H<<9)
		LWORD	COINR+(0ABH<<16)+(03EH<<9)
		LWORD	COINR+(0AFH<<16)+(03DH<<9)
		LWORD	COINR+(0B3H<<16)+(03CH<<9)
		LWORD	AHOBD+(0C3H<<16)+(03CH<<9)
		LWORD	QKM0C+(0F6H<<16)+(044H<<9)
		LWORD	EGG01+(002H<<16)+(046H<<9)
		LWORD	EGG01+(005H<<16)+(046H<<9)
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		"ahoba02a.end" (1995/06/26 03:53:11)			-
;------------------------------------------------------------------------
		GLB	ENDT_54_02
ENDT_54_02	EQU	$
		LWORD	SNXG2+(000H<<16)+(045H<<9)
		LWORD	GATE0+(014H<<16)+(045H<<9)
		LWORD	ZPAC2+(03DH<<16)+(03FH<<9)
		LWORD	FLIPH+(037H<<16)+(043H<<9)
		LWORD	ZFLW2+(03CH<<16)+(042H<<9)
		LWORD	AHOBD+(01DH<<16)+(03EH<<9)
		LWORD	AHOBD+(021H<<16)+(040H<<9)
		LWORD	AHOBD+(029H<<16)+(040H<<9)
		LWORD	AHOBD+(019H<<16)+(040H<<9)
		LWORD	AHOBD+(01FH<<16)+(044H<<9)
		LWORD	NLFLR+(075H<<16)+(047H<<9)
		LWORD	NLFUD+(07CH<<16)+(046H<<9)
		LWORD	NLFUD+(07CH<<16)+(03FH<<9)
		LWORD	NLFUD+(06FH<<16)+(03AH<<9)
		LWORD	NLFUD+(071H<<16)+(033H<<9)
		LWORD	NLFUD+(07DH<<16)+(031H<<9)
		LWORD	ZPAC2+(082H<<16)+(032H<<9)
		LWORD	ZPAC2+(082H<<16)+(03DH<<9)
		LWORD	ZPAC2+(068H<<16)+(03DH<<9)
		LWORD	ZPAC2+(069H<<16)+(02DH<<9)
		LWORD	YAJI1+(07FH<<16)+(022H<<9)
		LWORD	YAJI0+(08BH<<16)+(022H<<9)
		LWORD	AHOBD+(069H<<16)+(024H<<9)
		LWORD	GOAL1+(0A5H<<16)+(02BH<<9)
		LWORD	AHOBD+(065H<<16)+(022H<<9)
		LWORD	AHOBD+(087H<<16)+(018H<<9)
		LWORD	AHOBD+(083H<<16)+(01AH<<9)
		LWORD	YAJI0+(089H<<16)+(01DH<<9)
		LWORD	ZFLW2+(08DH<<16)+(019H<<9)
		LWORD	COINR+(072H<<16)+(022H<<9)
		LWORD	COINR+(06FH<<16)+(023H<<9)
		LWORD	COINR+(03AH<<16)+(043H<<9)
		LWORD	COINR+(03EH<<16)+(043H<<9)
		LWORD	ZPACK+(047H<<16)+(048H<<9)
		LWORD	QKM0C+(096H<<16)+(021H<<9)
		LWORD	SW000+(080H<<16)+(02DH<<9)
		LWORD	SW000+(06EH<<16)+(046H<<9)
		LWORD	HBLK4+(067H<<16)+(045H<<9)
		LWORD	HBLK4+(068H<<16)+(045H<<9)
		LWORD	DRBF2+(07CH<<16)+(03BH<<9)
		LWORD	DRBF2+(072H<<16)+(02FH<<9)
		LWORD	DRBF2+(080H<<16)+(02AH<<9)
		LWORD	COIN2+(080H<<16)+(03FH<<9)
		LWORD	COIN2+(07FH<<16)+(040H<<9)
		LWORD	MC1UP+(028H<<16)+(040H<<9)
		LWORD	QKM00+(091H<<16)+(019H<<9)
		LWORD	DGFLY+(096H<<16)+(024H<<9)
		LWORD	DGFLY+(098H<<16)+(025H<<9)
		LWORD	DGFLY+(09AH<<16)+(024H<<9)
		LWORD	DGFLY+(027H<<16)+(044H<<9)
		LWORD	DGFLY+(029H<<16)+(045H<<9)
		LWORD	DGFLY+(04FH<<16)+(041H<<9)
		LWORD	DGFLY+(051H<<16)+(042H<<9)
		LWORD	DGFLY+(053H<<16)+(043H<<9)
		LWORD	DGFLY+(042H<<16)+(046H<<9)
		LWORD	DGFLY+(009H<<16)+(044H<<9)
		LWORD	DGFLY+(00CH<<16)+(044H<<9)
		LWORD	DGFLY+(00FH<<16)+(046H<<9)
		LWORD	QKM00+(03DH<<16)+(03EH<<9)
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		"trkun0.end" (1995/06/26 21:34:22)			-
;------------------------------------------------------------------------
		GLB	ENDT_54_03
ENDT_54_03	EQU	$
		LWORD	STRKN+(00CH<<16)+(04BH<<9)
		LWORD	STRKN+(00EH<<16)+(04BH<<9)
		LWORD	HIMI2+(008H<<16)+(045H<<9)
		LWORD	STRKN+(00DH<<16)+(04BH<<9)
		LWORD	STRKN+(00EH<<16)+(046H<<9)
		LWORD	STRKN+(00BH<<16)+(046H<<9)
		LWORD	STRKN+(00DH<<16)+(046H<<9)
		WORD	0FFFFH
;
;
;
;
;
;
;
;
;
;
		END
;
;
