;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: mapexp.asm				*
;* 	Description	: map explain 				*
;*	Date		: 1994.10.22				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;---------------------------------------------------------------------
xxstart	equ	11
;---------------------------------------------------------------------
;
;
;
;*********************************************************************
;	explain
;*********************************************************************
;
; mapexp_dispflag
;
; counter
;
;---------------------------------------------------------------------
;
; ME_enddemo		;;; demomessage NO owari
;		;;; mapmessage GA initialize SARERU
;
; ME_stop		;;; demomessage NO owari
;		;;; kono address de wait sareru
;
; ME_endmessage	;;; mapmessage NO owari
;		;;; tsugi no message wo wait suru
;
;---------------------------------------------------------------------
;
;
;*********************************************************************
;	flags
;*********************************************************************
;
;-------------------------------------------------
; next object WO hyouji saseru
;-------------------------------------------------
;
; mapexp_nextobj	0000h ..... ON wait
;		4000h ..... ON display
;		FFFFh ..... OFF
;
;-------------------------------------------------


;*********************************************************************
;	explain message macros
;*********************************************************************

;---------------------------------------------------------------------
xME_init	macro	
	db	idx_mapexp_init
	endm

;---------------------------------------------------------------------
xME_initdemo	macro	
	db	idx_mapexp_initdemo
	endm

;---------------------------------------------------------------------
ME_end	macro
	db	idx_mapexp_end
	endm

;---------------------------------------------------------------------
ME_program	macro	[progaddr]
	db	idx_mapexp_program
	dw	({progaddr})&WM
	endm

;---------------------------------------------------------------------
xME_jmp	macro	[jmpaddr]
	db	idx_mapexp_jmp
	dw	({jmpaddr})&WM
	endm

;---------------------------------------------------------------------
xME_sound	macro	[sound]
	db	idx_mapexp_sound
	db	{sound}
	endm

;---------------------------------------------------------------------
xME_objset	macro	[posX,posY,characterNo]
	db	idx_mapexp_objset
	db	{posX}
	db	{posY}
	db	{characterNo}
	endm

;---------------------------------------------------------------------
xME_faceopen	macro
	db	idx_mapexp_faceopen
	endm
;---------------------------------------------------------------------
xME_faceclose macro
	db	idx_mapexp_faceclose
	endm

;---------------------------------------------------------------------
ME_wait	macro	[waittime]
	db	idx_mapexp_wait
	db	{waittime}
	endm

;---------------------------------------------------------------------
xME_objclear	macro
	db	idx_mapexp_objclear
	endm

;---------------------------------------------------------------------
ME_stop	macro
	db	idx_mapexp_stop
	endm

;---------------------------------------------------------------------
ME_enddemo	macro
	db	idx_mapexp_enddemo
	endm

;---------------------------------------------------------------------
ME_endmessage macro
	db	idx_mapexp_endmessage
	endm

;---------------------------------------------------------------------
xME_corneria	macro
	db	idx_mapexp_calc_corneria
	endm

;---------------------------------------------------------------------
xME_sos	macro
	db	idx_mapexp_calc_sos
	endm

;---------------------------------------------------------------------
xME_planet	macro
	db	idx_mapexp_calc_planet
	endm

;---------------------------------------------------------------------
ME_message	macro	[messageNo]
	db	idx_mapexp_message
	db	{messageNo}
	endm

;---------------------------------------------------------------------
ME_messageONvoise	macro	[messageNo]
	db	idx_mapexp_messageONvoise
	db	{messageNo}
	endm

;---------------------------------------------------------------------
ME_levelmessage macro
	db	idx_mapexp_LVmessage
	endm

;---------------------------------------------------------------------
ME_triggermessage macro
	db	idx_mapexp_TGmessage
	endm

;---------------------------------------------------------------------
xME_setW	macro	[addr,data]
	db	idx_mapexp_setW
	dw	({addr})&WM
	dw	{data}
	endm

;---------------------------------------------------------------------
xME_clrbit	macro	[addr,data]
	db	idx_mapexp_clrbit
	dw	({addr})&WM
	dw	{data}^0ffffh
	endm

;---------------------------------------------------------------------
xME_setbit	macro	[addr,data]
	db	idx_mapexp_setbit
	dw	({addr})&WM
	dw	{data}
	endm

;---------------------------------------------------------------------
xME_setWmario macro	[addr,data]
	db	idx_mapexp_setWmario
	dw	({addr})&WM
	dw	{data}
	endm

;---------------------------------------------------------------------
xME_moveposY	macro	[data]
	db	idx_mapexp_moveposY
	db	{data}
	endm

;---------------------------------------------------------------------
xME_timestop	macro	[data]
	db	idx_mapexp_timestop
	endm

;---------------------------------------------------------------------
xME_timestart macro	[data]
	db	idx_mapexp_timestart
	endm

;---------------------------------------------------------------------
xME_speedcheck macro	[addr]
	db	idx_mapexp_speedcheck
	dw	{addr}&WM
	endm

;---------------------------------------------------------------------
ME_triggerwait macro
	db	idx_mapexp_triggerwait
	endm

;---------------------------------------------------------------------
xME_messagepos_UP macro
	db	idx_mapexp_messagepos_UP
	endm

;---------------------------------------------------------------------
xME_messagepos_DOWN macro
	db	idx_mapexp_messagepos_DOWN
	endm

;---------------------------------------------------------------------
xME_TGmessageALLOFF	macro
	db	idx_mapexp_TGmessageALLOFF
	endm

;---------------------------------------------------------------------
;
;
;
;
;
;
;---------------------------------------------------------------------

mapexp_addr	=	*&$ff0000
m_marioaddr	=	700000h






;*********************************************************************
;	---------------------
;	 speedup demomessage
;	---------------------
;*********************************************************************


speedup_demomessage

	lda	mapexp_demoflag
	beq	.exit

	lda	mmw_trigger	
	and	#button_start
	beq	.exit

	lda	#mapexp_speedend&WM
	sta	mapexp_pointer

.exit
	rts

;*********************************************************************
;	----------------------
;	 demo message program
;	----------------------
;*********************************************************************
expdemo_main
	Mbank7e
	php
	ai16

	jsr	mapexp_nextcode
	jsr	speedup_demomessage

	plp
	Mbankrts

;======================================================================


mapexp_nextcode
	ldx	mapexp_pointer
	beq	.exit
.next	lda.l	mapexp_addr,x
	inx			; code inc
	txy
	and	#00ffh
	asl	a
	tax
	jsr	(.process,x)
	stx	mapexp_pointer	; x = ROM pointer
	bra	.next
.exit	rts
;----------------------------------------------------------------------
.process
	Mindexliststart
	Mindexlist	mapexp_end
	Mindexlist	mapexp_init
	Mindexlist	mapexp_initdemo
	Mindexlist	mapexp_jmp
	Mindexlist	mapexp_faceopen
	Mindexlist	mapexp_faceclose
	Mindexlist	mapexp_wait
	Mindexlist	mapexp_calc_corneria
	Mindexlist	mapexp_calc_sos
	Mindexlist	mapexp_calc_planet
	Mindexlist	mapexp_message
	Mindexlist	mapexp_messageONvoise
	Mindexlist	mapexp_objset
	Mindexlist	mapexp_objclear
	Mindexlist	mapexp_setW
	Mindexlist	mapexp_setbit
	Mindexlist	mapexp_clrbit
	Mindexlist	mapexp_setWmario
	Mindexlist	mapexp_moveposY
	Mindexlist	mapexp_stop
	Mindexlist	mapexp_enddemo
	Mindexlist	mapexp_endmessage
	Mindexlist	mapexp_program
	Mindexlist	mapexp_sound
	Mindexlist	mapexp_timestop
	Mindexlist	mapexp_timestart
	Mindexlist	mapexp_speedcheck
	Mindexlist	mapexp_LVmessage
	Mindexlist	mapexp_TGmessage
	Mindexlist	mapexp_triggerwait
	Mindexlist	mapexp_messagepos_UP
	Mindexlist	mapexp_messagepos_DOWN
	Mindexlist	mapexp_TGmessageALLOFF

;*********************************************************************
;	ME codes
;*********************************************************************
MEcode_end	macro
	pla		; << del return value
	rts		
	endm

;---------------------------------------------------------------------
mapexp_moveposY
	tyx
	a8
	clc
	lda.l	mapexp_addr+0,x
	adc	mapexp_objpos+1		; Y position
	sta	mapexp_objpos+1
	a16

	inx
	rts

;=====================================================================
mapexp_messagepos_UP
	tyx
	lda	#message_scrollpos_up
	ldy	#faceobjposV_up
	bra	mapexp_messagepos_common

mapexp_messagepos_DOWN
	tyx
	lda	#message_scrollpos_down
	ldy	#faceobjposV_down

mapexp_messagepos_common
	sta.l	m_mapBG1scrollY
	tya
	ora	faceobj_initpos
	sta	faceobj_position
	rts

;=====================================================================
mapexp_TGmessageALLOFF
	tyx
	jsr	clear_triggermessage
	rts

;=====================================================================
mapexp_setW
	tyx
	lda.l	mapexp_addr+0,x
	tay
	lda.l	mapexp_addr+2,x
	sta.w	0,y

	inx
	inx
	inx
	inx
	rts

;=====================================================================
mapexp_setbit
	tyx
	lda.l	mapexp_addr+0,x
	tay
	lda.l	mapexp_addr+2,x
	ora.w	0,y
	sta.w	0,y

	inx
	inx
	inx
	inx
	rts

;=====================================================================
mapexp_clrbit
	tyx
	lda.l	mapexp_addr+0,x
	tay
	lda.l	mapexp_addr+2,x
	and.w	0,y
	sta.w	0,y

	inx
 	inx
	inx
	inx
	rts

;=====================================================================
mapexp_setWmario
	tyx
	lda.l	mapexp_addr+0,x
	tay
	lda.l	mapexp_addr+2,x
	phx			; >>
	tyx
	sta.l	m_marioaddr,x	; 
	plx			; <<
	inx
	inx
	inx
	inx
	rts
;=====================================================================
mapexp_init
	tyx
	bra	mapexp_initcommon

;=====================================================================
mapexp_initdemo

;---------------------------------------------------
	tyx

	MsetL	m_mapmessageNo,0
	MsetL	m_messagetimer,TIME_demomessage

	lda	mapexp_pointer	; NOW pointer set
	sta	mapexp_demoflag

mapexp_initcommon
	stz	mapexp_objNo	; RESET object
	stz	mapexp_counter	; RESET counter
	stz	mapexp_nextobj	; RESET nextobj

	rts

;=====================================================================
mapexp_end	
	tyx
	MEcode_end

;=====================================================================
mapexp_jmp	tyx
	lda.l	mapexp_addr+0,x
	tax
	rts

;=====================================================================
mapexp_faceopen
	tyx
	lda	#1
	sta	openface_count
	sta.l	m_mapmessage_faceflag
	rts

;=====================================================================
mapexp_faceclose
	tyx
	lda	#1
	sta	closeface_count
	lda	#0		; message off
	sta.l	m_mapmessageNo
	sta.l	m_mapmessage_faceflag
	stz	mapexp_objNo
	rts

;=====================================================================
mapexp_sound
	tyx
	lda.l	mapexp_addr+0,x
	and	#00ffh
	ksound_a
	inx
	rts

;=====================================================================
mapexp_enddemo
	tyx
	stz	mapexp_pointer
	stz	mapexp_demoflag

	MsetL	m_gyoulimit,127
	MsetL	m_mapmessageNO,0
	MsetL	m_messagetimer,TIME_mapmessage

	jsr	clear_messageparam

	MEcode_end

;=====================================================================
mapexp_endmessage
	tyx
	stz	mapexp_pointer	;  pointer Reset
	MEcode_end

;=====================================================================
mapexp_stop
	tyx
	MEcode_end

;=====================================================================
mapexp_program
	tyx
	jsr	(0,x)
	bcc	.exit
	inx			; next code 
	inx
	stx	mapexp_pointer
.exit	MEcode_end

;=====================================================================
mapexp_wait
	tyx
	lda.l	mapexp_addr+0,x
	and	#00ffh
	cmp	mapexp_counter
	bcs	.exit
	stz	gameframe_trigger
	stz	mapexp_counter
	inx
	stx	mapexp_pointer
	MEcode_end

;-----------------------------------------------------
.exit	inc	mapexp_counter
	MEcode_end

;=====================================================================
mapexp_TGmessage
	lda	#TGmessage_speedup
	bra	mapexp_CMmessage
;=====================================================================
mapexp_LVmessage
	lda	#LVmessage_speedup
mapexp_CMmessage
	tyx
	and	mapmessage_messagestatus
	bne	.speedup

	lda.l	m_mapmessageNo
	bpl	.exit

.speedup
	stz	mapmessage_messagestatus
	MsetL	m_mapmessageNo,0

	rts			; next !!!


.exit	MEcode_end

;=====================================================================
Mmessage_nextcheck	macro	[data]

	lda	mapexp_counter		; nextobj check
	cmp	#xxstart-1-{data}
	bcc	.skip\@

	jsr	Setbit_nextobj

.skip\@	jsr	Check_nextkey		; key check
	beq	.EXIT_DEMOMESSAGE

	lda	mapexp_counter		; timer check
	cmp	#xxstart-{data}
	bcs	.NEXT_DEMOMESSAGE
	cmp	#xxstart-3-{data}
	bcs	.EXIT_DEMOMESSAGE

	lda	#xxstart-3-{data}	; speedup set
	sta	mapexp_counter
	sta.l	m_mapmessage_counter
	bra	.EXIT_DEMOMESSAGE

	endm

;----------------------------------------------------------------------
Setbit_nextobj
	pha			; >>
	lda	#4000h		; nexmark start
	tsb	mapexp_nextobj	;
	pla			; <<
	rts
;-------------------------------------------------
; next object GA arutoki TO naitoki
;-------------------------------------------------
Check_nextkey
	lda	mapexp_nextobj
	bpl	.skip1
	lda	#button_B+button_Y+button_jyuujikey
	bra	.skip2
.skip1	lda	#button_B+button_Y
.skip2	and	mmw_trigger
	rts
;-------------------------------------------------
;
;
;
;
;----------------------------------------------------------------------

mapexp_messageONvoise
	lda	#0ffffh
	sta	Xwork0
	bra	mapexp_message_common

mapexp_message
	stz	Xwork0
mapexp_message_common

	tyx
	lda	mapexp_counter
	bne	.endcheck

;-------------------------------------------------
; initialize
;-------------------------------------------------
	bit	Xwork0
	bpl	.offsound

	ksound	p_warning_0
.offsound
	lda	#0		 ; Reset Counter
	sta.l	m_mapmessage_counter
	lda.l	mapexp_addr+0,x	 ; Set Bitmap message
	and	#00ffh
	sta.l	m_mapmessageNo
	bra	.EXIT_DEMOMESSAGE

;-------------------------------------------------
.endcheck
	cmp	#100		; AUTO NEXT TIME
	bcs	.NEXT_DEMOMESSAGE_nosound
	lda.l	m_gamemessageheight
	cmp	#40
	bcs	.3line

;-------------------------------------------------
; 	(2)line mode 
;-------------------------------------------------

.2line	Mmessage_nextcheck	4

.3line	Mmessage_nextcheck	0

;----------------------------------- 
; 	SAMEprocess
;----------------------------------- 
.EXIT_DEMOMESSAGE
	inc	mapexp_counter
	lda.l	m_mapmessage_counter	; <<< Set gyoulimit >>>
	lsr	a
	lsr	a
	sta.l	m_gyoulimit
	MEcode_end

;----------------------------------- 
; 	NEXTprocess
;----------------------------------- 
.NEXT_DEMOMESSAGE
	ksound	next_message

.NEXT_DEMOMESSAGE_nosound
	stz	mapexp_counter	; counter reset
	stz	mapexp_nextobj	; nextmark clear
	inx
	stx	mapexp_pointer	; next pointer
	MEcode_end

;=====================================================================

mapexp_objset			; <<<<< yajirushi obj set >>>>>
	tyx

	lda.l	mapexp_addr+0,x  ; Set sprite X
	sta	mapexp_objpos
	lda.l	mapexp_addr+2,x
	and	#00ffh
	sta	mapexp_objNo

	jsr	set_yajirushi

	inx
	inx
	inx
	rts

;=====================================================================

mapexp_objclear
	tyx
	stz	mapexp_objpos
	stz	mapexp_objNo
	rts

;=====================================================================

mapexp_calc_corneria
	phy				; >> ROM pointer

	ldx	kx_planetlistptr
	beq	.exit

.next	lda.w	mmx_planetflag,x
	bit	#mmpnf_corneria
	bne	.entry
	lda.w	mmx_planetnext,x
	tax
	bne	.next
	bra	.exit
;---------------------------------------------------
.entry
	a8
	lda.w	mmx_planetcy,x		 ; sprite position
	xba
	lda.w	mmx_planetcx,x		 ; sprite position
	a16
	sta	mapexp_objpos
	jsr	set_yajirushi

;---------------------------------------------------
.exit
	plx				; << ROM pointer
	rts

;=====================================================================

set_yajirushi
	phx
	phy
	ai8

	ldy	mapexp_objpos+1
	beq	.exit
	cpy	#60h
	bcs	.Ydown
	lda	#cd_objanime_yajirushi_up
	bra	.set
.Ydown	lda	#cd_objanime_yajirushi_dw
.set	sta	mapexp_objNo

.exit	ai16
	ply
	plx
	rts

;=====================================================================
mapexp_calc_planet
	phy			  ; >> ROM pointer

	ldx	kx_planetlistptr
	beq	.exit

	lda	#0ffffh
	sta	mapexp_work	  ; Yposition Reset

.next	lda.w	mmx_planetflag,x
	bit	#mmpnf_corneria
	bne	.skip

;---------------------------------------
	lda.w	mmx_planetcy,x	; Ymin check
	and	#00ffh
	cmp	mapexp_work
	bcs	.skip
	sta	mapexp_work
	txy
;---------------------------------------

.skip	lda.w	mmx_planetnext,x
	tax
	bne	.next

	tyx
	lda.w	mmx_planetcx,x		 ; sprite position
	sta	mapexp_objpos
	jsr	set_yajirushi

;---------------------------------------------------
.exit
	plx			; << ROM pointer
	rts

;=====================================================================
mapexp_calc_sos
	phy			; >> ROM pointer

	jsr	check_posenemy
	bcs	.exit

;---------------------------------------------------
	tyx
	a8
	lda.w	mmx_enposy+1,x
	xba
	lda.w	mmx_enposx+1,x
	a16
	sta	mapexp_objpos

	jsr	set_yajirushi

;---------------------------------------------------
.exit
	plx			; << ROM pointer		
	rts


;=====================================================================
mapexp_timestop
	tyx

	km_setflag16	kw_MisMapFreezeFlag,(kfz_timefreeze!kfz_pausefreeze!kfz_syorifreeze)

	rts

;=====================================================================
mapexp_timestart
	tyx

	km_clrflag16	kw_MisMapFreezeFlag,(kfz_timefreeze!kfz_pausefreeze!kfz_syorifreeze)

	rts

;=====================================================================
mapexp_speedcheck
	tyx

	Mbitflagcheck	mapmessage_easykeycheck,maptime_speedup
	beq	.jmp

	inx				; next program
	inx
	rts

.jmp	lda.l	mapexp_addr+0,x		; jump program
	tax
	rts

;=====================================================================
mapexp_triggerwait
	tyx

	lda	mapmessage_messagestatus
	beq	.wait

	rts

.wait	MEcode_end


;*********************************************************************
;	planet yajirushi moveing
;*********************************************************************
;
; timer = 0		 (OFF)
;         1 .... FFFF (ON)
;
; list  = 0           (OFF)
;       = xpointer    (ON)
;
;---------------------------------------------------------------------
;;;disp_enemyplanet
;;;
;;;	lda	mapexp_planettimer	; check flag
;;;	beq	.exit
;;;	inc	mapexp_planettimer
;;;
;;;	ldx	mapexp_planetlist
;;;	beq	.start
;;;.entry	lda	mapexp_planettimer
;;;	and	#07h
;;;	bne	.exit
;;;
;;;.next	lda.w	mmx_planetflag,x
;;;	bit	#mmpnf_corneria		; 1 = corneria planet
;;;	bne	.skip
;;;	bit	#mmpnf_neutral		; 1 = neutoral planet
;;;	beq	.set_yaji
;;;
;;;.skip	lda.w	mmx_planetnext,x
;;;	tax
;;;	bne	.next
;;;.start	ldx	kx_planetlistptr
;;;	bra	.next
;;;
;;;.set_yaji	
;;;	lda.w	mmx_planetnext,x
;;;	bne	.skip2
;;;	lda	kx_planetlistptr
;;;.skip2	sta	mapexp_planetlist
;;;
;;;;---------------------------------------------------
;;;	lda.w	mmx_planetcx,x		 ; sprite position
;;;	sta	mapexp_objpos
;;;	jsr	set_yajirushi
;;;;---------------------------------------------------
;;;
;;;.exit	rts
;;;
;;;
;*********************************************************************
; 	enemy position check
;*********************************************************************

check_posenemy

	ldx	kx_enlistptr
	beq	.exit

	lda	#0ffffh
	sta	mapexp_work	  ; Yposition Reset

.next	
	lda.w	mmx_enposy+1,x	; Ymin check
	and	#00ffh
	cmp	mapexp_work
	bcs	.skip
	sta	mapexp_work
	txy

.skip	lda.w	mmx_ennext,x
	tax
	bne	.next

	clc
	rts

.exit	sec
	rts

;*********************************************************************
; mapexp demo1endcheck
;*********************************************************************
mapexp_demo1endcheck

	phx		; >>

	ldx	#stepup_work
	ldy	#stepup_worktotal
;---------------------------------
.loop	lda	_stepup_flag,x
	beq	.next
	lda	_stepup_anime,x	
	bmi	.exit
	cmp	#80
	bcc	.exit
.next	Madx	stepup_workcount
	dey
	bne	.loop
;---------------------------------
	plx		; <<
	sec
	rts
;---------------------------------
.exit	plx		; <<
	clc
	rts

;*********************************************************************
; mapexp demo2endcheck
;*********************************************************************

mapexp_demo2endcheck

;-------------------------------------------------
	lda	kx_demonumber
	cmp	#demo_explainstart
	bne	.wait
	sec
	rts
;-------------------------------------------------
.wait	clc
	rts
;-------------------------------------------------

;*********************************************************************
; finalboss bitcheck
;*********************************************************************

mapexp_finalboss_check

	km_bitcheckmismapflag	finalboss
	bne	.boss

;-------------------------------------------------
.wait	clc
	rts
.boss	sec
	rts
;-------------------------------------------------
;
;
;
;
;
;*********************************************************************
;		*************************************************
; MESSAGE DATAS	*************************************************
;		*************************************************
;*********************************************************************
;
;
;
;
;	mapexp_debugdisplay	; debug mode display
;	mapexp_easystart	; easy map openning explain
;	mapexp_easyreturn	; easy map return explain
;	mapexp_boss		; boss demo program
;	mapexp_openning		; openning explain
;	mapexp_mapspeedup	; mapspeedup message
;	
;
;
;
;
;*********************************************************************
;	----------------------------
; 	 debug mode message display
;	----------------------------
;*********************************************************************

mapexp_debugdisplay

	xME_timestop
.loop
	xME_initdemo
	xME_faceopen

;-----------------------------------------	; debug datas
	ME_message	1
	ME_message	2
	ME_message	3
	ME_message	4
	ME_message	5
	ME_message	6
	ME_message	7
	ME_message	8
	ME_message	9
	ME_message	10
	ME_message	11
	ME_message	12
	ME_message	13
	ME_message	14
	ME_message	15
	ME_message	16
	ME_message	17
	ME_message	18
	ME_message	19
	ME_message	20
	ME_message	21
	ME_message	22
	ME_message	23
	ME_message	24
	ME_message	25
	ME_message	26
	ME_message	27
	ME_message	28
	ME_message	29
	ME_message	30
	ME_message	31
	ME_message	32
	ME_message	33
	ME_message	34
	ME_message	35
	ME_message	36
	ME_message	37
	ME_message	38
	ME_message	39
	ME_message	40
	ME_message	41
	ME_message	42
	ME_message	43
	ME_message	44
	ME_message	45
	ME_message	46
	ME_message	47
	ME_message	48
	ME_message	49
;-----------------------------------------	
	ME_message	98
	ME_message	99
	ME_message	100
	ME_message	101
	ME_message	102
	ME_message	103
	ME_message	104
	ME_message	105
	ME_message	106
	ME_message	107
	ME_message	108
	ME_message	109
	ME_message	110
	ME_message	111
	ME_message	112
	ME_message	113
	ME_message	114
	ME_message	115
	ME_message	116
	ME_message	117
;-----------------------------------------	
	ME_message	124
	ME_message	125
	ME_message	126
;-----------------------------------------	

	xME_faceclose
	ME_wait		5

	xME_jmp	.loop




;*********************************************************************
;	--------------------
;	 map normal message
;	--------------------
;*********************************************************************

;--------------------------------------------------------------------
; levelmessage program
;--------------------------------------------------------------------
mapexp_levelmessage

	xME_init
	xME_faceopen

	ME_wait		2
	ME_levelmessage

	xME_faceclose
	ME_wait		3

	ME_endmessage

;--------------------------------------------------------------------
; trigger message program
;--------------------------------------------------------------------
mapexp_triggermessage

	xME_init
	xME_sound	sport3_p_warning_2
	xME_faceopen

	ME_wait		2
	ME_triggermessage

	xME_sound	sport3_tsushin_end
	xME_faceclose
	ME_wait		3

	xME_setW	pepper_message,0	; trigger OFF

	ME_endmessage

;--------------------------------------------------------------------
 

;*********************************************************************
;	speed up demo message
;*********************************************************************

mapexp_speedend
	xME_setW	HPmeter_flag,OFF_HPmeter
	xME_setW	mapexp_nextobj,OFF_nextobj
	xME_setW	yajirushi_flag,OFF_enemyyaji
	xME_objclear
	xME_timestart
	xME_setWmario	m_mapmessageNO,0
	ME_wait		10
	ME_enddemo


;*********************************************************************
;	---------------------
;	 map speedup message
;	---------------------
;*********************************************************************

mapexp_mapspeedup

	xME_init
	xME_setWmario	m_mapmessageNo,108	; set message
	xME_setWmario	m_mapmessage_color,mapmessage_blackcolor
	ME_triggermessage
	ME_wait		5
	ME_endmessage

;*********************************************************************
;	----------------------------
; 	 Easy Map Start message
;	----------------------------
;*********************************************************************

mapexp_easystart

 	xME_initdemo
	xME_timestop
	xME_objset	0e7h,20h,cd_objanime_yajirushi_up ; <== ON
	ME_message	116

	xME_objclear
	xME_setW	yajirushi_flag,ON_enemyyaji
	ME_message	110
	ME_message	111

	xME_setW	yajirushi_flag,OFF_enemyyaji
	ME_message	109

	xME_setW	mapexp_nextobj,OFF_nextobj
	xME_timestart
	ME_message	107

;;;;;;;	ME_message	108		; Bpush

	xME_TGmessageALLOFF
	xME_setWmario	m_mapmessageNo,0
	ME_wait		3
	ME_enddemo

;*********************************************************************
;	-------------------------
; 	 Easy Map Return message
;	-------------------------
;*********************************************************************

mapexp_easyreturn

	xME_initdemo
	xME_timestop

	xME_messagepos_UP
	xME_setW	HPmeter_flag,ON_HPmeter
	xME_corneria
	xME_moveposY	-28
	xME_setW	mapexp_nextobj,OFF_nextobj
	ME_message	117

	xME_objclear
	xME_timestart
	xME_setW	HPmeter_flag,OFF_HPmeter
	xME_setWmario	m_mapmessageNo,OFF_mapmessage
	ME_wait		3
	ME_enddemo




;---------------------------------------------------------------------

	ifeq	1

	xME_initdemo
	xME_timestop

	xME_messagepos_UP
	xME_setW	HPmeter_flag,ON_HPmeter
	xME_corneria
	xME_moveposY	-28
	ME_message	117

	xME_objclear			; <= OFF
	xME_timestart
	xME_speedcheck	.speeddisp
	xME_setW	mapexp_nextobj,OFF_nextobj
	ME_message	107
	xME_jmp		.exit

.speeddisp
	ME_message	107
	xME_setW	mapexp_nextobj,OFF_nextobj 
	ME_message	108

.exit
	xME_setW	HPmeter_flag,OFF_HPmeter
	xME_setWmario	m_mapmessageNo,OFF_mapmessage
	ME_wait		3
	ME_enddemo

	endc

;---------------------------------------------------------------------

;*********************************************************************
;	---------------------
;	 bossmode mapexplain
;	---------------------
;*********************************************************************

mapexp_boss
	xME_init
	ME_wait		2
	ME_program	mapexp_finalboss_check
	xME_setW	kx_demonumber,demo_scrollopentrig
	ME_program	mapexp_demo1endcheck
	xME_setW	kx_demonumber,demo_scrollclosetrig

	ME_stop

;*********************************************************************
;	-------------------
;	 map explain chart
;	-------------------
;*********************************************************************

mapexp_openning

	xME_init
;-----------------------------
; openning demo 
;-----------------------------
	ME_wait		2
	xME_setW	kx_demonumber,demo_scrollopentrig
	ME_program	mapexp_demo1endcheck

; speedup-start --------------

	xME_setW	kx_demonumber,demo_scrollclosetrig
	ME_program	mapexp_demo2endcheck

;-----------------------------
; stepup arrived wait !!!
;-----------------------------

;-----------------------------
; mapobj explain animation
;-----------------------------

	xME_initdemo
	ME_wait		2

;-----------------------------
; openning message
;-----------------------------

.loop


;-----------------------------------------------------------
; 1ST MESSGAE
;-----------------------------------------------------------
	xME_messagepos_DOWN
	xME_sound	sport3_tsushin_start
	xME_faceopen
	ME_messageONvoise	1
	ME_messageONvoise	2

	xME_setW	yajirushi_flag,ON_enemyyaji
	ME_messageONvoise	3

	xME_setW	yajirushi_flag,OFF_enemyyaji
	xME_sos
	ME_messageONvoise	4
	ME_messageONvoise	5
	xME_sound	sport3_tsushin_end
	xME_faceclose
	ME_wait		3

;-----------------------------------------------------------
; 2ND MESSAGE
;-----------------------------------------------------------

	xME_messagepos_UP
	xME_sound	sport3_tsushin_start
	xME_faceopen
	xME_corneria		; <=== ON  yajirushi
	ME_messageONvoise	6

	xME_objclear		; <=== OFF yajirushi
	ME_messageONvoise	98
	xME_sound	sport3_tsushin_end
	xME_faceclose
	ME_wait		3

;-----------------------------------------------------------
; 3ND MESSAGE
;-----------------------------------------------------------

	xME_messagepos_DOWN
	xME_faceopen
	xME_sound	sport3_tsushin_start
	xME_setW	yajirushi_flag,ON_enemyyaji
	ME_messageONvoise	99

	ifeq	janglish
	ME_messageONvoise	155
	endc

	ME_messageONvoise	100

	xME_setW	yajirushi_flag,OFF_enemyyaji
	xME_objset	0e7h,20h,cd_objanime_yajirushi_up	; <= ON
	ME_messageONvoise	101
	ME_messageONvoise	102

	xME_sound	sport3_tsushin_end
	xME_faceclose
	ME_wait		3

;-----------------------------------------------------------
; 4TH MESSAGE
;-----------------------------------------------------------

	xME_messagepos_UP
	xME_sound	sport3_tsushin_end
	xME_faceopen
	xME_corneria		; <= ON
	ME_messageONvoise	103

	xME_moveposY	-28
	xME_setW	HPmeter_flag,ON_HPmeter
	ME_messageONvoise	104
	ME_messageONvoise	105


	xME_objclear		; <= OFF
	xME_setW	HPmeter_flag,OFF_HPmeter
	xME_setW	mapexp_nextobj,OFF_nextobj
	ME_messageONvoise	106

	xME_sound	sport3_tsushin_end
	xME_faceclose
	ME_wait		3


;---------------------------------------------------------------
; exit map explain program
;---------------------------------------------------------------

	xME_setW	kx_demonumber,demo_explainfinish
	ME_stop

;=====================================================================
;=====================================================================
; END END END END END END EDN END END END END END END END END END END
;=====================================================================
;=====================================================================

