;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: oamset.asm				*
;* 	Description	: oamset				*
;*	Date		: 1994.11.3				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;
;*********************************************************************
;	OAMset macros
;*********************************************************************

;---------------------------------------------------------------------
MSseq_liststart macro
seqlist = 0
	endm

;---------------------------------------------------------------------
MSseq_list	macro	[name,seqaddr,oamaddr]
	dw	{seqaddr}&WM
	dw	{oamaddr}&WM
{name}	equ	seqlist
seqlist = seqlist+1
	endm

;---------------------------------------------------------------------
MSseq_end	macro	
	db	80h
	endm

;---------------------------------------------------------------------
MSseq_kill	macro	
	db	81h
	endm

;---------------------------------------------------------------------
MSseq_sound	macro	[sound]
	db	82h
	db	{sound}
	endm

;---------------------------------------------------------------------
MSseq_jmp	macro	[addr]
	db	83h
	dw	{addr}&WM
	endm

;---------------------------------------------------------------------
MSoam_small	macro	[counter]
	db	{counter}+40h
	endm

;---------------------------------------------------------------------
MSoam_big	macro	[counter]
	db	{counter}
	endm

;---------------------------------------------------------------------
MSoam_subon	macro	[counter]
	db	{counter}+80h
	endm

;---------------------------------------------------------------------
MS_getB	macro
	lda.w	0,y
	iny
	and	#00ffh
	endm

;---------------------------------------------------------------------
MS_getBS	macro
	lda.w	0,y
	iny
	Msex
	endm

;---------------------------------------------------------------------
MS_getW	macro
	lda.w	0,y
	iny
	iny
	endm

;---------------------------------------------------------------------
MS_setsubpointer	macro
	lda	sprite_register
	sec
	sbc	sprite_offset	; 0 or 220h
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	clc
	adc	sprite_offset	; 0 or 220h
	endm
;---------------------------------------------------------------------


;***********************************************************************
;	OAMset works
;***********************************************************************

SWrompointer	equ	Xaddr	; ROM address-pointer
SWcenterH	equ	Xwork0	; ******** VVVVVVVV.
SWcenterV	equ	Xwork1	; ******** HHHHHHHH.
SWobjcounter	equ	Xwork2	; 00000000 00******
SWobjmask	equ	Xwork3
SWobjadd	equ	Xwork4
SWsubset	equ	Xwork5	; subset counter

;***********************************************************************
;	oamset program
;***********************************************************************

Newoamset	phb
	phk			; NOW BANK ONLY !!
	plb

	jsr	New_skipoam
	jsr	New_setanime
	ldx	register
	lda	_program,x
	beq	.exit
	jsr	New_setoamparam
	jsr	New_setoam
	jsr	New_skipoam

.exit	plb
	rtl
;-----------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;***********************************************************************
;	new Set sprite animation
;***********************************************************************
;;
;;
;;-------------------------------------------------------
;; _anime_trigger	<---- input sprite animation
;; _animeNo		<---- animation NOW number
;;-------------------------------------------------------
;; _anime_counter	<---- animation loopcounter
;; _anime_poitner	<---- animation program pointer
;;-------------------------------------------------------
;;
;;
;;
;------------------------------------------------------------------------
New_setanime

	ldx	register
	lda	_anime_trigger,x
	bne	.newanime
;------------------------------------------------------------------------
	lda	_anime_counter,x	;time-wait
	beq	.entryanime
	dec	a
	sta	_anime_counter,x
.exitanime
	lda	_obj_pointer,x		; copy rom pointer
	sta	SWrompointer
	rts
;------------------------------------------------------------------------




;------------------------------------------------------------------------
.newanime	sta	_anime_now,x		; now animation number
	stz	_anime_trigger,x	; reset animation trigger
	stz	_anime_counter,x	; reset animation counter  
	jsr	anime_make
;------------------------------------------------------------------------
.entryanime
	ldy	_anime_pointer,x	; ROM pointer
.nextcode
	lda.w	0,y			; ROM-READ
	bit	#0080h
	beq	.timerset
	and	#007fh
	asl	a
	tax
	jsr	(.newanime_code,x)
	sty	_anime_pointer,x
	bra	.nextcode
;------------------------------------------------------------------------
.timerset	and	#007fh
	dec	a
	sta	_anime_counter,x
;------------------------------------------------------------------------
	lda.w	1,y			; ROM-READ
	and	#00ffh
	asl	a
	adc	_OBJaddress,x		; basic address
	tax
	lda.w	0,x			; pointer address
	ldx	register
	sta	_obj_pointer,x
	iny				; pointer++ (INC)
	iny
	sty	_anime_pointer,x	; pointer next
	bra	.exitanime

;------------------------------------------------------------------------







;------------------------------------------------------------------------
.newanime_code
	dwcode	anime_repeat
	dwcode	anime_kill
	dwcode	anime_sound
	dwcode	anime_jmp
;------------------------------------------------------------------------


;------------------------------------------------------------------------
; animation sound
;------------------------------------------------------------------------
anime_jmp
	ldx	register
	lda.w	1,y		; jmp new pointer
	tay
	rts

;------------------------------------------------------------------------
; animation sound
;------------------------------------------------------------------------
anime_sound
	phy			; >>
	lda.w	1,y
	and	#00ffh
	ksound_a
	ply			; <<
	ldx	register
	iny
	iny
	rts

;------------------------------------------------------------------------
; animation kill
;------------------------------------------------------------------------
anime_kill
	ldx	register
	stz	_program,x
	pla			; << return program
	rts
;------------------------------------------------------------------------
; animation reset
;------------------------------------------------------------------------
anime_repeat	
	ldx	register
	lda	_anime_now,x
	jsr	anime_make
	ldy	_anime_pointer,x
	rts

;------------------------------------------------------------------------
; make anime
;------------------------------------------------------------------------
anime_make	phy
	txy				; y = register
	asl	a
	asl	a
	tax
	lda.l	New_oamlist+0,x
	sta.w	_anime_pointer,y	; anime SEQ address
	lda.l	New_oamlist+2,x
	sta.w	_OBJaddress,y		; object table address
	tyx
	ply
	rts

;------------------------------------------------------------------------
;***********************************************************************
;	Set oam parameter
;***********************************************************************

New_setoamparam

	ldx	register
	Mcp_work	x,SWobjmask,_charmask
	Mcp_work	x,SWobjadd,_charadd
	Mcp_work	x,SWcenterH,_axisX
	Mcp_work	x,SWcenterV,_axisY

	rts




;***********************************************************************
;	Set oam parameter
;***********************************************************************
;;
;; Y ... sprite pointer
;; X ... rom pointer
;;
;=======================================================================

oamsetlib
	Mbankprog
	sty	sprite_register
	stx	SWrompointer
	jsr	New_setoam
	ldy	sprite_register
	Mbankrts

;***********************************************************************
;	Set oam parameter
;***********************************************************************
exit_setoam	rts

New_setoam
	ldy	SWrompointer
	ldx	sprite_register

;-----------------------------------------------------------------------
;	nomal set sprite
;-----------------------------------------------------------------------

	lda.w	0,y
	iny
	bit	#0c0h
	beq	.bigonly
	bit	#080h
	beq	.smallonly

;-----------------------------------------------------------------------
;	subset object		code (11)
;-----------------------------------------------------------------------
	and	#003fh
	beq	exit_setoam
	sta	SWobjcounter
	dec	a
	lsr	a
	lsr	a
	sta	SWsubset
;
	MS_setsubpointer
	tax			; X = subpointer
;
	a8
.subsetloop	lda.w	0,y		; sizedata READ
	iny
	sta.l	sprites+200h,x	; Set OAM-SUB
	inx
	dec	SWsubset
	bpl	.subsetloop
	a16
	bra	.oamset

;-----------------------------------------------------------------------
;	big only object		code (00)
;-----------------------------------------------------------------------
.bigonly	and	#003fh
	beq	exit_setoam
	PHY			; >>
	sta	SWobjcounter
	dec	a
	lsr	a
	lsr	a
	tay			; Y = loopcounter
;
	MS_setsubpointer
	tax			; X = subpointer
;
	a8
	lda	#0aah		; size big
.bigloop	sta.l	sprites+200h,x	; Set OAM-SUB
	inx
	dey
	bpl	.bigloop
	a16
	PLY			; <<
	bra	.oamset

;-----------------------------------------------------------------------
;	small only object	code (01)
;-----------------------------------------------------------------------
.smallonly	and	#03fh
	beq	.exit
	sta	SWobjcounter

;-----------------------------------------------------------------------
;	nomal set sprite
;-----------------------------------------------------------------------
.oamset
	ldx	sprite_register
.oamloop
	MS_getBS
	clc
	adc	SWcenterH
	cmp	#100h
	bcc	.entry
	iny
	lda	#0e0h		; overflow(H)
	bra	.setV

.entry	sta.l	sprites+0,x

	MS_getBS
	clc
	adc	SWcenterV
.setV	a8
	sta.l	sprites+1,x
	a16

	MS_getW
	and	SWobjmask
	clc
	adc	SWobjadd
	sta.l	sprites+2,x

	Minx4

	dec	SWobjcounter
	bne	.oamloop

	stx	sprite_register

.exit	rts
;-----------------------------------------------------------------------
;;
;;
;;
;;
;;
;;
;;
;***********************************************************************
;	oamset skip
;***********************************************************************
New_skipoam
	lda	sprite_register
	ldy	#0e0e0h
.loop	bit	#01111b
	beq	.exit
	tax
	tya
	sta.l	sprites,x
	txa
	inc	a
	inc	a
	inc	a
	inc	a
	bra	.loop
.exit	sta	sprite_register
	rts

;***********************************************************************
;	test sprite list
;***********************************************************************
;;
;; seq animation table
;;
;;
;;----------------------------------------------------------------------

New_oamlist
	MSseq_liststart
	MSseq_list	ys_cls,seq_testspr,oam_testtable
	MSseq_list	ys_pselstart,seq_testspr,oam_testtable
;-- face ---------
	MSseq_list	ys_foxSTpose,seq_foxst,oam_testtable
	MSseq_list	ys_foxOKpose,seq_foxok,oam_testtable
	MSseq_list	ys_falcoSTpose,seq_falcost,oam_testtable
	MSseq_list	ys_falcoOKpose,seq_falcook,oam_testtable
	MSseq_list	ys_peppySTpose,seq_peppyst,oam_testtable
	MSseq_list	ys_peppyOKpose,seq_peppyok,oam_testtable
	MSseq_list	ys_slippySTpose,seq_slippyst,oam_testtable
	MSseq_list	ys_slippyOKpose,seq_slippyok,oam_testtable
	MSseq_list	ys_catSTpose,seq_catst,oam_testtable
	MSseq_list	ys_catOKpose,seq_catok,oam_testtable
	MSseq_list	ys_girlSTpose,seq_girlst,oam_testtable
	MSseq_list	ys_girlOKpose,seq_girlok,oam_testtable
;-- plane ---------
	MSseq_list	ys_foxplane,seq_foxplane,oam_testtable
	MSseq_list	ys_falcoplane,seq_falcoplane,oam_testtable
	MSseq_list	ys_peppyplane,seq_peppyplane,oam_testtable
	MSseq_list	ys_slippyplane,seq_slippyplane,oam_testtable
	MSseq_list	ys_catplane,seq_catplane,oam_testtable
	MSseq_list	ys_girlplane,seq_girlplane,oam_testtable
;-- fire ----------
	MSseq_list	ys_planefire,seq_planefire,oam_testtable
;-- open/close ----
	MSseq_list	ys_planeopen,seq_planeopen,oam_testtable
	MSseq_list	ys_planeclose,seq_planeclose,oam_testtable
	MSseq_list	ys_faceopen,seq_faceopen,oam_testtable
	MSseq_list	ys_faceclose,seq_faceclose,oam_testtable
;-- big number ----
	MSseq_list	ys_big0,seq_bignum_0,oam_testtable
	MSseq_list	ys_big1,seq_bignum_1,oam_testtable
	MSseq_list	ys_big2,seq_bignum_2,oam_testtable
	MSseq_list	ys_big3,seq_bignum_3,oam_testtable
	MSseq_list	ys_big4,seq_bignum_4,oam_testtable
	MSseq_list	ys_big5,seq_bignum_5,oam_testtable
	MSseq_list	ys_big6,seq_bignum_6,oam_testtable
	MSseq_list	ys_big7,seq_bignum_7,oam_testtable
	MSseq_list	ys_big8,seq_bignum_8,oam_testtable
	MSseq_list	ys_big9,seq_bignum_9,oam_testtable
	MSseq_list	ys_target,seq_bigtarget,oam_testtable
;-------------------


;***********************************************************************
;	test sprite data
;***********************************************************************

;---------------------------------------------------------------------
Msprdata	macro	[h,v,fp,pno,ano,char]
	db	{h},{v}
	db	{char}&0ffh
	db	oamdata_pri{pno}+oamdata_attr{ano}+oamdata_{fp}flip+{char}/256
	endm

;---------------------------------------------------------------------
seq_testspr
	db	16,idx_oam_testspr
	db	16,idx_oam_nothing
	db	80h

;---------------------------------------------------------------------
oam_testtable
	Mindexliststart
	Mindexlist	oam_nothing	; "sprite clear"
	Mindexlist	oam_testspr	; "SYUTSUGEKI"

	Mindexlist	obj_d2_0_0	; "fox face"
	Mindexlist	obj_d2_0_1
	Mindexlist	obj_d2_0_2
	Mindexlist	obj_d2_0_3
	Mindexlist	obj_d2_0_4
	Mindexlist	obj_d2_0_5

	Mindexlist	obj_d2_1_0	; "falco face"
	Mindexlist	obj_d2_1_1
	Mindexlist	obj_d2_1_2
	Mindexlist	obj_d2_1_3
	Mindexlist	obj_d2_1_4
	Mindexlist	obj_d2_1_5

	Mindexlist	obj_d2_2_0	; "peppy face"
	Mindexlist	obj_d2_2_1
	Mindexlist	obj_d2_2_2
	Mindexlist	obj_d2_2_3
	Mindexlist	obj_d2_2_4
	Mindexlist	obj_d2_2_5

	Mindexlist	obj_d2_3_0	; "slippy face"
	Mindexlist	obj_d2_3_1
	Mindexlist	obj_d2_3_2
	Mindexlist	obj_d2_3_3
	Mindexlist	obj_d2_3_4

	Mindexlist	obj_d2_4_0	; "cat face"
	Mindexlist	obj_d2_4_1
	Mindexlist	obj_d2_4_2
	Mindexlist	obj_d2_4_3
	Mindexlist	obj_d2_4_4

	Mindexlist	obj_d2_5_0	; "girl face"
	Mindexlist	obj_d2_5_1
	Mindexlist	obj_d2_5_2
	Mindexlist	obj_d2_5_3
	Mindexlist	obj_d2_5_4
	Mindexlist	obj_d2_5_5

	Mindexlist	obj_d4_1_0	; "plane sprite"
	Mindexlist	obj_d4_1_1
	Mindexlist	obj_d4_1_2
	Mindexlist	obj_d4_1_3
	Mindexlist	obj_d4_1_4
	Mindexlist	obj_d4_1_5

	Mindexlist	obj_d4_1_8	; "plane fire sprite"
	Mindexlist	obj_d4_1_9
	Mindexlist	obj_d4_1_10

	Mindexlist	obj_d4_0_0	; "face/plane shutter"
	Mindexlist	obj_d4_0_1
	Mindexlist	obj_d4_0_2
	Mindexlist	obj_d4_0_3
	Mindexlist	obj_d4_0_4
	Mindexlist	obj_d4_0_5	
	Mindexlist	obj_d4_0_6
	Mindexlist	obj_d4_0_7
	Mindexlist	obj_d4_0_8

	Mindexlist	obj_w0_1_0
	Mindexlist	obj_w0_1_1
	Mindexlist	obj_w0_1_2
	Mindexlist	obj_w0_1_3
	Mindexlist	obj_w0_1_4
	Mindexlist	obj_w0_1_5
	Mindexlist	obj_w0_1_6
	Mindexlist	obj_w0_1_7
	Mindexlist	obj_w0_1_8
	Mindexlist	obj_w0_1_9

	Mindexlist	obj_target

	Mindexlistend_print

;---------------------------------------------------------------------
oam_nothing	db	0
;---------------------------------------------------------------------
oam_testspr2
oam_testspr
	db	3
	Msprdata	000h,0,n,3,0,10ch
	Msprdata	010h,0,n,3,0,10eh
	Msprdata	020h,0,n,3,0,120h

;======================================================================




;======================================================================
;======================================================================
; END END END END END END END END END END END END END END END END END 
;======================================================================
;======================================================================

