;*********************************************************************
;*								*
;*	------------------------				*
;*		SAMPLE1 					*
;*	------------------------				*
;*								*
;*	File 		: ymacs.inc				*
;* 	Description	; yajima macros				*
;*	Date		: 1994.8.1				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************


;*********************************************************************
;		*************************************************
; assembler add	*************************************************
;		*************************************************
;*********************************************************************



;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************
Mprogram	macro
	longa
	longi
	endm
;---------------------------------------------------------------------
mWxWcC	macro
	ai16
	clc
	endm
;---------------------------------------------------------------------
mWxW	macro
	ai16
	endm
;---------------------------------------------------------------------
mBxB	macro
	ai8
	endm
;---------------------------------------------------------------------
mW	macro
	a16
	endm
;---------------------------------------------------------------------
mB	macro
	a8
	endm
;---------------------------------------------------------------------
xW	macro
	i16
	endm
;---------------------------------------------------------------------
xB	macro
	i8
	endm
;---------------------------------------------------------------------
Madx	macro	[data]
	clc
	txa
	adc	#{data}
	tax
	endm
;---------------------------------------------------------------------
Mady	macro	[data]
	clc
	tya
	adc	#{data}
	tay
	endm
;---------------------------------------------------------------------

;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************
;*********************************************************************

;*********************************************************************
;		*************************************************
; library macro	*************************************************
;		*************************************************
;*********************************************************************

;---------------------------------------------------------------------
xx	equ	0ffffh
;---------------------------------------------------------------------
dl	macro	[data]
	dw	{data}&0ffffh
	db	{data}>>16
	endm
;---------------------------------------------------------------------
dwc	macro	[data]
	dw	{data}&0ffffh
	endm
;---------------------------------------------------------------------
Mset	macro	[work,data]
	lda	#{data}
	sta	{work}
	endm
;---------------------------------------------------------------------
MsetX	macro	[work,data]
	ldx	#{data}
	stx	{work}
	endm
;---------------------------------------------------------------------
MsetY	macro	[work,data]
	ldy	#{data}
	sty	{work}
	endm
;---------------------------------------------------------------------
Mmvncode	macro	[abank,bbank]
	db	54h		; MVN
	db	{abank}>>16
	db	{bbank}>>16
	endm
;---------------------------------------------------------------------
Mmvn	macro	[addr1,addr2,count]
	ldx	#{addr1}&xx
	ldy	#{addr2}&xx
	lda	#{count}-1
	db	54h		; MVN
	db	{addr1}>>16
	db	{addr2}>>16
	endm
;---------------------------------------------------------------------
MresetClear	macro	[from,count]
	ldx	#{from}
	stz	0,x
	txy
	iny
	lda	#{count}-2
	Mmvncode 0,0
	endm
;---------------------------------------------------------------------

;*********************************************************************
;		*************************************************
; library subroutine	*************************************************
;		*************************************************
;*********************************************************************

;---------------------------------------------------------------------
MclearVRAM	macro	[address,byte,clearcode]
	jsl	Clear_VRAM
	dw	{clearcode}
	dw	{address}
	dw	{byte}
	endm
;---------------------------------------------------------------------
MclearRAM	macro	[address,byte,clearcode]
	jsl	Clear_RAM
	dw	{clearcode}
	dl	{address}
	dw	{byte}
	endm
;---------------------------------------------------------------------


;*********************************************************************
;		*************************************************
; debug macro	*************************************************
;		*************************************************
;*********************************************************************

;--------------------------------------------------------------------
blinkX	macro
	jmp.l	blink_l
	endm
;--------------------------------------------------------------------
blinkR	macro
	jmp.l	blinkR_l
	endm
;--------------------------------------------------------------------
blinkG	macro
	jmp.l	blinkG_l
	endm
;--------------------------------------------------------------------
blinkB	macro
	jmp.l	blinkB_l
	endm
;--------------------------------------------------------------------
Mstoploop	macro
\@p1	bra	\@p1
	endm
;--------------------------------------------------------------------





;*********************************************************************
;		*************************************************
; reset macro	*************************************************
;		*************************************************
;*********************************************************************


;--------------------------------------------------------------------
MwaitNMI	macro
 	ifne	longa
	error	<Must be in shorta>
	endc
\@p1	bit	4212h
	bmi	\@p1
\@p2	bit	4212h
	bpl	\@p2
	endm
;--------------------------------------------------------------------
MwaitNMItime	macro	[data]
 	ifne	longa
	error	<Must be in shorta>
	endc
	ldx	#{data}
\@p1	bit	4212h
	bmi	\@p1
\@p2	bit	4212h
	bpl	\@p2
	dex
	bne	\@p1
	endm
;--------------------------------------------------------------------
Msetppucolor	macro	[addr,b,g,r]
 	ifne	longa
	error	<Must be in shorta>
	endc
	lda	#{addr}
	stz	Color_address
	lda	#{r}+({g}&07h)*32
	sta	Color_write
	lda	#({b}<<2)+({g}>>3)
	sta	Color_write
	endm

;--------------------------------------------------------------------
Mresetjoypad	macro
	a8
	Mset	4200h,1
	MwaitNMItime 2
\@p1	lda	4212h
	lsr	a
	bcs	\@p1
	a16
	lda	4218h
	endm
;--------------------------------------------------------------------
MresetDirectRegister	macro	
 	ifeq	longa
	error	<Must be in longa>
	endc
	lda	#0
	tcd
	endm
;--------------------------------------------------------------------
MresetDataBank	macro
	phk
	plb
	endm
;--------------------------------------------------------------------
MresetStackPointer	macro
 	ifeq	longa
	error	<Must be in longa>
	endc
	lda	#1fffh
	tcs
	endm
;--------------------------------------------------------------------
MresetDecimalBit	macro
	cld
	endm
;--------------------------------------------------------------------
MsetscrollBG1	macro	[hdata,vdata]
 	ifne	longa
	error	<Must be in shorta>
	endc
	lda	#{data}&0ffh
	sta	210dh
	lda	#{data}>>8
	sta	210dh
	lda	#{data}&0ffh
	sta	210eh
	lda	#{data}>>8
	sta	210eh
	endm
;--------------------------------------------------------------------



;********************************************************************
