;===================================================================
;===================================================================
;===================================================================
;*******************************************************************
;*		***********************************************
;*  WIPE (8)		***********************************************
;*		***********************************************
;* (new wipetest )	***********************************************
;*		***********************************************
;*	192line	***********************************************
;*******************************************************************
;===================================================================
;===================================================================
;===================================================================
;
;
;*******************************************************************
;
;*******************************************************************

;;	equ	wipe_test+0
;;	equ	wipe_test+2


;*******************************************************************
;	work memoery	( common )
;*******************************************************************

work_x1	equ	Xwork0		;  
work_y1	equ	Xwork1		;
work_x2	equ	Xwork2		;
work_y2	equ	Xwork3		; 
work_ycount	equ	Xwork4		; y LINE COUNT
work_pointer	equ	Xwork5		; window pointer
;---------------------------------------------
;;;;	equ	Xwork6		; multiply
;;;;	equ	Xwork7		; multiply
;---------------------------------------------
wp_minpointer equ	Xwork8	
wp_maxpointer equ	Xwork9
wp_mainpointer equ	Xwork10
;---------------------------------------------

;*******************************************************************
;	work memoery
;*******************************************************************

;--------------------------------------------------
;;	equ	wipe_test+0
;;	equ	wipe_test+2
;;	equ	wipe_test+4
;==================================================
wp_pointerend equ	wipe_test+6	; WORK !!
work_xadd	 equ	wipe_test+8	; WORK !!
;==================================================
wp_angle	equ	wipe_test+10	; angleset work
wp_angsin	equ	wipe_test+12	; sin angle data
wp_angcos	equ	wipe_test+14	; cos angle data
wp_test	equ	wipe_test+16	; work
wp_spotwork	equ	wipe_test+18	;
;--------------------------------------------------
;
;
;
;--------------------------------------------------------------------

wp_coloranime equ	wipe_test+22	; color anime pointer

wp_centerX	equ	wipe_test+24	; rotation center X
wp_centerY	equ	wipe_test+26	; rotation center Y
wp_mainangle	equ	wipe_test+28	; rotation angle
wp_mainzoom	equ	wipe_test+30	; rotation zoom
wp_rotspeed	equ	wipe_test+32	; rotation speed

wp_total	equ	wipe_test+40	; total count
wp_world	equ	wipe_test+42	; 4*4 (16byte)
wp_rotate	equ	wipe_test+60	; 4*8 (32byte)
wp_rottotal	equ	wipe_test+100	; clip totalcount
wp_tmprotate	equ	wipe_test+102	; 4*4 (16byte)

;--------------------------------------------------------------------
;;
;*******************************************************************
;	test wipe close
;*******************************************************************
wipetitle_close

	a8
	alloc_window wipe,1
	stz	wm_coldata_r,x	; 
	stz	wm_coldata_g,x	; 
	stz	wm_coldata_b,x	; 
	a16
		
	rts

;*******************************************************************
;	test wipe open
;*******************************************************************
wipetitle_open
	jsr	dc_program
	dwstart			
	dwwait	5
	dwnext	clear_fullclose
	dwnext	title_wipeinit
	dwstop	title_wipemain


;*******************************************************************
;	initialize
;*******************************************************************

title_wipeinit

	jsr	set_param
	db	000h,000h,0a0h	; window switch
	db	00h,00h		; window logic
	db	00h		; 212dh
	db	10h,03fh,0e8h	; 2130,31,32
	rts






;*******************************************************************
;	window program
;*******************************************************************
title_wipemain

	jsr	winpoly_coloranime

	jsr	swap_buffer

;---------------------------------------------
; clear window
;---------------------------------------------
	ldy	#0
	ldx	#192
	lda	#0001h
	jsr	wipe_bufferset12

;---------------------------------------------
; move param
;---------------------------------------------
	inc	wp_spotwork

	lda	wp_mainangle
	clc
	adc	#00300h
	sta	wp_mainangle

;---------------------------------------------
; window(1)
;---------------------------------------------
	stz	work_pointer
;;;	jsr	spot_window

	lda	wp_mainangle
	sta	wp_angle

	jsr	param_windowpolygon
	jsr	world_window
	jsr	point_rotate
	jsr	rotate_window

;---------------------------------------------
; window(2)
;---------------------------------------------
	lda	#2
	sta	work_pointer

	lda	wp_mainangle
	clc
	adc	#4000h
	sta	wp_angle

	jsr	param_windowpolygon
	jsr	world_window
	jsr	point_rotate
	jsr	rotate_window

;---------------------------------------------

	rts


;*******************************************************************
;	window-polygon
;*******************************************************************

param_windowpolygon


	lda	wp_angle
	jsr	Func_SIN
	sta	wp_angsin
	lda	wp_angle
	jsr	Func_COS
	sta	wp_angcos

;----------------------------------------------

	Mset	wp_centerX,080h	; center x
	Mset	wp_centerY,060h	; center y

;----------------------------------------------

	rts

;*******************************************************************
;	wipetest
;*******************************************************************

world_window
	Mset	wp_total,4		; point total
	Mset	wp_world+00,0		; X1
	Mset	wp_world+02,-60		; Y1
	Mset	wp_world+04,30		; X2
	Mset	wp_world+06,0		; Y2
	Mset	wp_world+08,0		; X3
	Mset	wp_world+10,60		; Y3
	Mset	wp_world+12,-30		; X4
	Mset	wp_world+14,0		; Y4
	

;----------------------------------------------
	ifeq	1
	lda	wp_test
	and	#1fh
	bit	#10h
	beq	.set
	eor	#0fh
.set	clc	
	pha
	adc	wp_world+10	; Y3
	sta	wp_world+10	; Y3
	pla
	Mnegative
	clc
	adc	wp_world+2
	sta	wp_world+2
	inc	wp_test
	endc
;----------------------------------------------


	rts



;*******************************************************************
;	color animation
;*******************************************************************

winpoly_coloranime

	a8
	alloc_window wipe,1

	lda	wp_coloranime
	inc	a
	and	#000111111b
	sta	wp_coloranime
	bit	#000100000b
	beq	.setcol
	eor	#000011111b
.setcol


	and	#000011111b
;;;;	ora	#011100000b	; WHITE BEAM !!
;;;;	ora	#000100000b	; 
;;;;	lda	#000101111b	; Red Addition

	sta	wm_coldata_r,x	; 
	stz	wm_coldata_g,x	; 
	stz	wm_coldata_b,x	; 
	stz	wm_coldata,x	; set color

	a16
;---------------------------------------------
	rts

;*******************************************************************
;	wipetest
;*******************************************************************


rotate_window

;--------------------------------------------
	jsr	ymin_check

;--------------------------------------------
	ldx	wp_minpointer
	stx	wp_mainpointer
.loop1	jsr	get_leftparam
	jsr	setleft1
	ldx	wp_mainpointer
	cpx	wp_maxpointer
	bne	.loop1
;--------------------------------------------
	ldx	wp_minpointer
	stx	wp_mainpointer
.loop2	jsr	get_rightparam
	jsr	setright1
	ldx	wp_mainpointer
	cpx	wp_maxpointer
	bne	.loop2
;--------------------------------------------

	rts


;*******************************************************************
;	window polygon rotation
;*******************************************************************
Mmult_winpoly macro
	jsl	ML_s16s16_l
	sty	work_x1
	asl	work_x1
	rol	a
	endm
;-------------------------------------------------------------------

point_rotate


	lda	wp_total	; vartex total
	sta	work_y1

	ldx	#0

.loop	
	lda	wp_world+0,x

	ifeq	0
	ldy	wp_angcos		; cos
	Mmult_winpoly
	sta	work_x2

	lda	wp_world+2,x
	Mnegative
	ldy	wp_angsin		; sin
	Mmult_winpoly
	clc
	adc	work_x2
	endc

	clc
	adc	wp_centerX
	sta	wp_rotate+0,x
					; X sin + Y cos
	lda	wp_world+0,x

	ifeq	0
	ldy	wp_angsin
	Mmult_winpoly
	sta	work_x2

	lda	wp_world+2,x
	ldy	wp_angcos
	Mmult_winpoly
	clc
	adc	work_x2
	endc

	clc
	adc	wp_centerY
	sta	wp_rotate+2,x

	inx
	inx
	inx
	inx
	dec	work_y1
	bne	.loop

	rts

;--------------------------------------------------------------------
;
;
;
;
;
;
;
;
;*******************************************************************
;	Ymin check & go 
;*******************************************************************
;
;
; wp_total .......	polygon window CYOUTEN NO KAZU
; wp_pointerend ..	wp_rotate NO OWARI
; wp_minpointer ..   Y min
; wp_maxpointer ..   Y max
;
;
;-------------------------------------------------------------------

ymin_check
	lda	wp_total
	tay
	asl	a
	asl	a
	sta	wp_pointerend	; 

	lda	#07fffh
	sta	work_x1		; min pointer
	lda	#0ffffh
	sta	work_x2		; max pointer
	
	ldx	#0
.loop	lda	wp_rotate+2,x
	cmp	work_x1		; dataY MIN
	bpl	.next1
	sta	work_x1		; dataY MIN
	stx	wp_minpointer
.next1	cmp	work_x2
	bmi	.next2
	sta	work_x2
	stx	wp_maxpointer
.next2
	inx
	inx
	inx
	inx	
	dey
	bne	.loop

	rts

;*******************************************************************
;	get right fill parameter
;*******************************************************************

get_rightparam

	ldx	wp_mainpointer

	lda	wp_rotate+0,x	; ( point 1 )
	sta	work_x1
	lda	wp_rotate+2,x
	sta	work_y1

	inx
	inx
	inx
	inx
	cpx	wp_pointerend
	bcc	.next1
	ldx	#0

.next1	lda	wp_rotate+0,x	; ( point 2 )
	sta	work_x2
	lda	wp_rotate+2,x
	sta	work_y2

	stx	wp_mainpointer
	rts

;*******************************************************************
;	get left fill parameter
;*******************************************************************

get_leftparam
	ldx	wp_mainpointer

	lda	wp_rotate+0,x	; ( point 1 )
	sta	work_x1
	lda	wp_rotate+2,x
	sta	work_y1

	cpx	#0
	bne	.skip
	ldx	wp_pointerend

.skip	dex
	dex
	dex
	dex

	lda	wp_rotate+0,x	; ( point 2 )
	sta	work_x2
	lda	wp_rotate+2,x
	sta	work_y2

	stx	wp_mainpointer
	rts

;*******************************************************************
;	WRITE WIPE BUFFER
;*******************************************************************
;
; [window polygon] 
;
;  Xaddr .... window pointer
;  x1    ...  xposition
;  y1    ...  yposition
;
;-------------------------------------------------------------------
; (1) LEFT WINDOW LINE
;-------------------------------------------------------------------

setright1
	lda	#1
	tsb	work_pointer
;--------------------------------------
setleft1	

	lda	work_y2	
	sec
	sbc	work_y1		; Y2 - Y1
	sta	work_ycount
	tax
	bmi	setwinbuff_exit
	beq	setwinbuff_exit

	lda	work_x2
	sec
	sbc	work_x1		; X2 - X1
	and	#00ffh
	xba
	cmp	#0
	Mdiv
	sta	work_xadd	; x addinc

;--------------------------------------

	lda	work_x1
	xba
	sta	work_x1		; initial x data
	ldx	work_ycount	; 
	lda	work_y1		; initial y pointer
	asl	a
	asl	a
	adc	work_pointer
	tay			; y Counter

.loop	a8
	lda	work_x1+1
	sta	(Xaddr),y	; left OR right
	iny
	iny
	iny
	iny
	a16cC
	lda	work_x1
	adc	work_xadd
	sta	work_x1
	dex
	bne	.loop

setwinbuff_exit
	rts

;*******************************************************************
;	COS/SIN
;*******************************************************************
; 
; Aregister Angle 0000 - FFFF
;
;
;-------------------------------------------------------------------
Func_cos	clc
	adc	#04000h
Func_sin	and	#0ff00h
	xba
	tax
	lda.l	ramsintab,x
	and	#000ffh
	xba
	rts

;-------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;*******************************************************************
;	--------------------------
;	 spot window test program
;	--------------------------
;*******************************************************************

spot_window
	Mset	work_x1,040h
	Mset	work_y1,000h
	Mset	work_x2,000h
	Mset	work_y2,0bfh

	a8
	lda	wp_spotwork
	bpl	.set1
	eor	#0ffh
.set1
	sta	work_x2
	a16

	jsr	setleft1

;--------------------------------------------- 

	Mset	work_x1,040h+20
	Mset	work_y1,000h
	Mset	work_x2,000h
	Mset	work_y2,0bfh

	a8
	lda	wp_spotwork
	bpl	.set11
	eor	#0ffh
.set11	clc
	adc	#20
	sta	work_x2
	a16

	jsr	setright1

	rts

;--------------------------------------------------------------------
;
;
;

;====================================================================
;====================================================================
; END END END END END END END END END END END END END END END END
;====================================================================
;====================================================================

