;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: yjradar.asm				*
;* 	Description	: object radar ( blockmap )		*
;*	Date		: 1994.7.26				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  yjradar
;---------------------------------------------------------------------
	incfile yajima.inc
;---------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;	labels
;*********************************************************************

ON_CHAR	equ	303eh+40h+obj_p5	; radar OBJ character
OFF_CHAR	equ	303fh+40h+obj_p5	;	//

yjradarposH	equ	0c7h
yjradarposV	equ	02fh

;*********************************************************************
;	blockmap radar 0page work memory
;*********************************************************************

radarHV	equ	Xwork0
countH	equ	Xwork1
countV	equ	Xwork2
temp1	equ	Xwork3
temp2	equ	Xwork4
radar_X	equ	Xwork5
radar_Z	equ	Xwork6
radar_tx	equ	Xwork7
radar_scroll	equ	Xwork8

;*********************************************************************
;	blockmap radar macros
;*********************************************************************

XXscale_mask	macro
	phx
	and	#7
	asl	a
	tax
	lda.l	XXbitmasks,x
	plx
	endm

;--------------------------------------------------------------------

ldaxx	macro
	lda	\1
	sec
	sbc	#200h
	endm

;--------------------------------------------------------------------

XXbitmasks	dw	1
	dw	2
	dw	4
	dw	8
	dw	16
	dw	32
	dw	64
	dw	128


;*********************************************************************
;	yjradar main program
;*********************************************************************
;
; y = oam pointer
; program RAM move
;
;---------------------------------------------------------------------

yjradar_l
	rtl

 
	Mbank7e
	php
	ai16

;---------------------------------------

	ldaxx	kpx
	and	#0fc00h
	sec
	sbc	#0800h
	sta 	radar_X

	ldaxx	kpz
	and	#0fc00h
	sec
	sbc	#0800h
	sta 	radar_Z

;---------------------------------------

	ldaxx	kpx
	and	#0380h
	asl	a
	xba
	Mnegative
	clc
	adc	#yjradarposH
	sta	radar_scroll

	ldaxx	kpz
	and	#0380h
	asl	a
	clc
	adc	#yjradarposV*256
	ora	radar_scroll

	tyx
	jsr	setradar
	txy

.exit	plp
	Mbankrtl

;---------------------------------------------------------------------





;*********************************************************************
;	set blockmap radar obj
;*********************************************************************

Mcalcmap	macro
	phx
	lda	radar_tx	; position X
	blockmap_scale_x
	tax
	lsr	a
	lsr	a
	lsr	a
	sta	temp1
	txa
	XXscale_mask
	sta	temp2

	lda	radar_Z		; position Z
	blockmap_scale_z
	clc
	adc	temp1
	tax

	lda	radar_tx
	clc
	adc	#400h
	sta	radar_tx

	lda.l	solidblockmap,x
	plx
	bit	temp2
	endm

;=====================================================================
;
; Areg ... start position
; Xreg ... oam pointer
;
;------------------------------------------
setradar	
;------------------------------------------
	ldy	#6
	sty	countV
;------------------------------------------
.loop1	sta	radarHV
	pha
	lda	radar_X
	sta	radar_tx
	pla
	ldy	#6
	sty	countH
;------------------------------------------
.loop2	sta.l	sprites+0,x
	clc
	adc	#0008h
	tay

	Mcalcmap
	beq	.set

	lda	#OFF_CHAR
	bra	.set2
.set	lda	#ON_CHAR
.set2	sta.l	sprites+2,x
	inx
	inx
	inx
	inx
	tya
	dec	countH
	bne	.loop2	
;------------------------------------------

	lda	radar_Z
	clc
	adc	#0400h
	sta	radar_Z

	lda	radarHV
	sec
	sbc	#0800h
	dec	countV
	bne	.loop1
;------------------------------------------
	rts


;====================================================================
;====================================================================
;END END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================

