;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: yajima.def				*
;*	Description	; Yajima's Macros			*
;*	Date		: 1994.7.15				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;
;
;
;
;=====================================================================
;=====================================================================
;===========	MACRO SAFETY ============================================
;===========	MACRO SAFETY ============================================
;=====================================================================
;=====================================================================

Mmodecheck_a16 macro
	ifeq	longa
	printf	"** %q%f%q: (%l) Error: Should be in longa mode%n"
	error+
	endc
	endm

;-------------------------------------------------------------------
Mmodecheck_a8 macro
	ifeq	shorta
	printf	"** %q%f%q: (%l) Error: Should be in shorta mode%n"
	error+
	endc
	endm

;-------------------------------------------------------------------
Msetdate	macro	[year,month,date,ver]
	db	{year}h
	db	{month}h
	db	{date}h
	db	{ver}h
	endm

;-------------------------------------------------------------------

;=====================================================================
;=====================================================================
;===========	PARAMETER SET MACROS ====================================
;===========	PARAMETER SET MACROS ====================================
;=====================================================================
;=====================================================================



;-------------------------------------------------------------------
Moff_objmeter macro
	Mmodecheck_a16
	lda	#0
	sta.l	meterswitch
	endm

;-------------------------------------------------------------------
Mon_objmeter macro
	Mmodecheck_a16
	lda	#1
	sta.l	meterswitch
	endm

;-------------------------------------------------------------------

;=====================================================================
;=====================================================================
;===========	YAJIMA MACRO ============================================
;===========	YAJIMA MACRO ============================================
;=====================================================================
;=====================================================================


;*********************************************************************
;	data conntrol macros 
;*********************************************************************
;-------------------------------------------------------------------

dwcode	macro
	dw	\1&0ffffh
	endm

;--------------------------------------------------------------------

Mdw	macro
	dw	\1&0ffffh
	endm

;--------------------------------------------------------------------

xx	equ	0ffffh

;--------------------------------------------------------------------

Mbank7e	macro
	phb
	pea	7e7eh
	plb
	plb
	endm

;-------------------------------------------------------------------

Mbank0	macro
	phb
	pea	0000h
	plb
	plb
	endm

;-------------------------------------------------------------------

Mbank7f	macro
	phb
	pea	7f7fh
	plb
	plb
	endm

;-------------------------------------------------------------------

Mbankprog	macro
	phb		; >
	phk		;  >
	plb		;  <
	endm

;-------------------------------------------------------------------
Mbankprog_start	macro
	Mbankprog
	php
	ai16
	endm

;-------------------------------------------------------------------

Mbankrts	macro
	plb		; <
	rts
	endm

;-------------------------------------------------------------------

Mbankrtl	macro
	plb		; <
	rtl
	endm

;-------------------------------------------------------------------
Mbankrtl_end	macro
	plp
	plb		; <
	rtl
	endm

;-------------------------------------------------------------------


;*********************************************************************
;	memory mode macros
;*********************************************************************


;-------------------------------------------------------------------

a16cC	macro
	longa
	rep	#21h
	endm

;-------------------------------------------------------------------

ai16cC	macro
	longa
	longi
	rep	#31h
	endm

;-------------------------------------------------------------------

;*********************************************************************
;	memory compare macros
;*********************************************************************



;-------------------------------------------------------------------

Mbcslimit	macro	[data]
	cmp	#{data}
	bcc	.\@p1
	lda	#{data}
.\@p1
	endm

;-------------------------------------------------------------------








;*********************************************************************
;	add/sub/asl/asr macros 
;*********************************************************************

Mnegative	macro
	ifne	longa
	eor	#0ffffh
	inc	a
	elseif
	eor	#0ffh
	inc	a
	endc
	endm

;--------------------------------------------------------------------

Mabsolute	macro
	bpl	.skip\@
	eor	#0ffffh
	inc	a
.skip\@
	endm

;--------------------------------------------------------------------

Msex	macro
	and	#000ffh	; 8bit singed ===> 16bit signed
	eor	#0ff80h
	clc
	adc	#00080h
	endm

;--------------------------------------------------------------------
Minx4	macro
	inx
	inx
	inx
	inx
	endm

;--------------------------------------------------------------------

Mlsr3	macro
	lsr	a
	lsr	a
	lsr	a
	endm

;--------------------------------------------------------------------

Mlsr4	macro
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	endm

;--------------------------------------------------------------------

Mlsr5	macro
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	endm

;--------------------------------------------------------------------

Masl3	macro
	asl	a
	asl	a
	asl	a
	endm

;--------------------------------------------------------------------

Masl4	macro
	asl	a
	asl	a
	asl	a
	asl	a
	endm

;--------------------------------------------------------------------

Masl5	macro
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	endm

;--------------------------------------------------------------------

Madx	macro
	txa
	clc
	adc	#\1
	tax
	endm

;--------------------------------------------------------------------

Mady	macro
	tya
	clc
	adc	#\1
	tay
	endm

;--------------------------------------------------------------------

Masr1	macro
	cmp	#8000h
	ror	a
	endm

;--------------------------------------------------------------------

Mdivasr	macro
	cmp	#0ffffh
	bne	.\@p1
	lda	#0
.\@p1	cmp	#8000h
	ror	a
	endm

;--------------------------------------------------------------------

Masr2	macro
	cmp	#8000h
	ror	a
	cmp	#8000h
	ror	a
	endm

;--------------------------------------------------------------------

;
;
;




;*********************************************************************
;	memory move macros
;*********************************************************************

Mset	macro
	lda	#\2
	sta	\1
	endm

;--------------------------------------------------------------------
Mmov	macro	[dist,source]
	lda	{source}
	sta	{dist}
	endm

;--------------------------------------------------------------------
MmovL	macro	[dist,source]
	lda.l	{source}
	sta.l	{dist}
	endm

;--------------------------------------------------------------------
Mcmpbeq	macro	[jmp,addr,value]
	lda	{addr}
	cmp	#{value}
	beq	{jmp}
	endm

;--------------------------------------------------------------------
Mcp_work	macro	[obj,work,addr]
	lda	{addr},{obj}
	sta	{work}
	endm

;--------------------------------------------------------------------

MsetL	macro
	lda	#\2
	sta.l	\1
	endm

;--------------------------------------------------------------------

MsetBL	macro	[address,data]
	a8
	lda	#{data}
	sta.l	{address}
	a16
	endm

;-------------------------------------------------------------------

Mmvn	macro	[source,dist,count]
	phb
	ldx	#({source})&WM
	ldy	#({dist})&WM
	lda	#({count})-1
	db	54h
	db	({dist})>>16
	db	({source})>>16
	plb
	endm

;-------------------------------------------------------------------

;=====================================================================
;=====================================================================
;===========	INDEX MACROS ============================================
;=========== INDEX MACROS ============================================
;=====================================================================
;=====================================================================

;*********************************************************************
;	index macro
;*********************************************************************



;-------------------------------------------------------------------

Mindexliststart	macro
yj_indexNo	= 0
	endm

;-------------------------------------------------------------------

Mindexlist	macro	[address]
idx_{address} equ	yj_indexNo
	dw	{address}&0ffffh
yj_indexNo	= yj_indexNo+1
	endm

;-------------------------------------------------------------------
Mindexlistend_print macro
	printf	"oamdata.asm oamlist %xyj_indexNo  %n"
	endm

;---------------------------------------------------------------------

;*********************************************************************
;	index macro
;*********************************************************************

;---------------------------------------------------------------------
MbitBjsrdata	macro	[bitdata,jmpaddr]
	db	{bitdata}
	dw	{jmpaddr}&WM
	endm

;---------------------------------------------------------------------
MbitBjsrdataend	macro
	db	0
	endm

;---------------------------------------------------------------------
Mbitflagliststart	macro
yj_bitflag	= 1
	endm

;---------------------------------------------------------------------
Mbitflaglist	macro	[label]
{label}	equ	yj_bitflag
yj_bitflag	= yjbitflag<<1
	endm

;---------------------------------------------------------------------
Mbitflagcheck macro	[addr,label]
	lda	{addr}
	bit	#{label}
	endm

;---------------------------------------------------------------------
Mbitcheck 	macro	[addr,label]
	lda	{addr}
	bit	#{label}
	endm

;---------------------------------------------------------------------
Mbitset	macro	[addr,bit]
	lda	#{bit}
	tsb	{addr}
	endm

;---------------------------------------------------------------------
Mbitclr	macro	[addr,bit]
	lda	#{bit}
	trb	{addr}
	endm

;*********************************************************************
;	animation macro
;*********************************************************************

Manime	macro	[addr,max]
	lda	{addr}
	inc	a
	cmp	#{max}
	bcc	.set\@
	lda	#0
.set\@	sta	{addr}
	endm






;=====================================================================
;=====================================================================
;===========	OAMSET MACROS ===========================================
;===========	OAMSET MACROS ===========================================
;=====================================================================
;=====================================================================

Msprdata	macro	[h,v,fp,pno,ano,char]
	db	{h},{v}
	db	({char})&0ffh
	db	oamdata_pri{pno}+oamdata_attr{ano}+oamdata_{fp}flip+({char})/256
	endm

;---------------------------------------------------------------------
messet	macro
	db	\1+40h
	db	\2+\3+30h
	endm

;---------------------------------------------------------------------
;
;
;*********************************************************************
;	OAM SET MACROS
;*********************************************************************
MSoam_romjmp	macro	[addr]
	db	80h	; H-offset = 80h
	dw	{addr}&WM
	endm

;---------------------------------------------------------------------
MSoam_small	macro	[counter]
	db	{counter}+40h
	endm

;---------------------------------------------------------------------
MSoam_big	macro	[counter]
	db	{counter}
	endm

;---------------------------------------------------------------------
MSoam_subon	macro	[counter]
	db	{counter}+80h
	endm

;---------------------------------------------------------------------
MS_getB	macro
	lda.w	0,y
	iny
	and	#00ffh
	endm

;=====================================================================


;=====================================================================
;=====================================================================
;===========	DATA MACROS =============================================
;===========	DATA MACROS =============================================
;=====================================================================
;=====================================================================

;*********************************************************************
;	data macro
;*********************************************************************

MoamCA	macro	[fp,pri,attr,char]
	db	{char}
	db	oamdata_{pri}+oamdata_{attr}+oamdata_{fp}flip
	endm

;---------------------------------------------------------------------
Manimation_count macro	[addr,max]
	lda	{addr}
	inc	a
	cmp	#{max}
	bcc	.\@p1
	lda	#0
.\@p1	sta	{addr}
	endm



;=====================================================================
;=====================================================================
;=========== vram lib ================================================
;=====================================================================
;=====================================================================
;*******************************************************************
;
;*******************************************************************

Mclear_vram	macro	[vram_address,clear_count,clear_data]
	jsr	yjclear_vram
	dw	{vram_address}
	dw	{clear_count}
	dw	{clear_data}
	endm

;=====================================================================
;=====================================================================
;===========	YAJIMA MACRO ============================================
;===========	YAJIMA MACRO ============================================
;=====================================================================
;=====================================================================
;*******************************************************************
;	gamemode indexselect
;*******************************************************************

yjcall_mario	macro	[addr]
	a8
	POLL_MARIO
	call_mario	{addr}
	UNPOLL_MARIO
	a16
	endm

;-------------------------------------------------------------------
Mgamemode_liststart	macro
gamemode_listwork = 0
	endm

;-------------------------------------------------------------------
Mgamemode_list	macro	[data,addr]
	db	{data}
	dw	{addr}&WM
gamemode_listwork = gamemode_listwork+1
	endm

;-------------------------------------------------------------------
Mgamemode_listend	macro	[label]
{label}	equ	gamemode_listwork
	endm

;-------------------------------------------------------------------




;*******************************************************************
;	calclration macro 2 ( mult / div )
;*******************************************************************
;
; unsigned 8bit * unsigned 8bit 
;
; <in>  A reg low*high
; <out> A reg 16bit
;
; DBR = rombank
;
;------------------------------------------------

Mmult_u8u8	macro	[data]
	ora	#({data})*256
	jsr	mult_u8u8
	endm

;-------------------------------------------------------------------
;	
; MDV_s16u08	signed 16bit/ unsigned 8bit
;
; <in>	Areg ( s16bit ) 
;	Xreg ( u8bit  )
; <out> 	Areg ( s16bit )
;
; DBR = 7e or 7f
;
;------------------------------------------------

Mdiv	macro	
	php
	bpl	\@p1
	eor	#0ffffh
	inc	a
\@p1	sta.l	4204h
	a8
	txa
	sta.l	4206h
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	a16
	lda.l	4214h
	plp
	bpl	\@p2
	eor	#0ffffh
	inc	a
\@p2
	endm


;-------------------------------------------------------------------

Mdiv_u16u8	macro	[div_data]
	sta.l	4204h
	a8
	lda	#{div_data}
	sta.l	4206h
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	a16
	lda.l	4214h
	endm

;-------------------------------------------------------------------
Mdiv_u16u8_X	macro	[div_data]
	sta.l	4204h
	a8
	txa
	sta.l	4206h
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	a16
	lda.l	4214h
	endm

;*******************************************************************
; 	--------------------------
;	 macro
; 	--------------------------
;*******************************************************************

;-------------------------------------------------------------------
Mbnejsr	macro	[addr,exit]
	beq	.skip\@
	jsr	{addr}		; if bne then JSR ADDR
	bra	{exit}
.skip\@
	endm

;-------------------------------------------------------------------
Mbeqjsr	macro	[addr,exit]
	bne	.skip\@
	jsr	{addr}		; if beq then JSR ADDR
	bra	{exit}
.skip\@
	endm

;-------------------------------------------------------------------


;*******************************************************************
; 	--------------------------
;  	 mapexp message set macro
; 	--------------------------
;*******************************************************************







;------------------------------------------------------------------

Mstart_demomapmessage macro	[number]
	Mmodecheck_a16
	lda	#{number}
	sta.l	mapexp_kawanumber+0
	lda	#mapexp_bokan_idou&WM
	sta.l	mapexp_pointer		; demomessage set pointer
	lda	#0
	sta.l	mapexp_kawaflag		; flag reset
	endm

Mnext_demomapmessage macro	[number]
	Mmodecheck_a16
	lda	#{number}
	sta.l	mapexp_kawanumber+0
	lda	#mapexp_bokan_idou&WM
	sta.l	mapexp_pointer		; demomessage set pointer
	lda	#0
	sta.l	mapexp_kawaflag		; flag reset
	endm

Mend_demomapmessage macro
	Mmodecheck_a16
	lda	#1
	sta.l	mapexp_kawaflag
	endm

;------------------------------------------------------------------

Mdebug_demomapmessage macro  [number]
	
	lda	cont0
	and	#button_L+button_R
	beq	\@p1
	Mstart_demomapmessage	{number}
\@p1
	endm
;------------------------------------------------------------------

Mdebug_trigmessage macro 
	lda	cont0
	and	#button_R
	beq	\@p1
	lda	#0ffffh
	sta	map_trigmessage
\@p1
	endm

;------------------------------------------------------------------

Mdebug_gamemessage macro 
	lda	cont0
	and	#button_L
	beq	\@p1
	lda	#0fffdh
	sta	mmx_message_sos
\@p1
	endm

;------------------------------------------------------------------
Mdebug_gameovermessage macro 
	lda	cont0
	and	#button_select
	beq	\@p1
	lda	#1
	sta	mmx_message_sos
\@p1
	endm

;------------------------------------------------------------------

;*******************************************************************
;	debug macro
;*******************************************************************

Mdebugstart	macro
	ifne	AFdebugcpuspeed
	lda	cont0
	and	#button_X
	beq	\@p1
	MsetBL	2100h,06h
\@p1
	endc
	endm

;-------------------------------------------------------------------

Mdebugend	macro
	ifne	AFdebugcpuspeed
	lda	cont0
	and	#button_X
	beq	\@p1
	MsetBL	2100h,0fh
\@p1
	endc
	endm	

;-------------------------------------------------------------------

MBRK	macro
	lda.l	7ffff0h
	endm

;--------------------------------------------------------------------

CheckArea	macro

	lda.l	kpx		; player (X)
	blockmap_scale_x
	tax			;
	lsr	a		; bitmap pointer X
	lsr	a
	lsr	a
	sta	Xwork0		;
	txa			;
	blockmap_scale_mask
	sta	Xwork1

	lda.l	kpz		; player (Z)
	blockmap_scale_z
	ora	Xwork0
	tax

	lda.l	solidblockmap,x
	and	Xwork1

	endm

;--------------------------------------------------------------------

;====================================================================
;====================================================================
;END END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================

