/************************************************************************/
/**                                                                    **/
/**    Starfox Cad Tools - (c) 1994 Dylan Cuthbert (Argonaut Software) **/
/**                                                                    **/
/************************************************************************/

#define _MESSAGES_

#include "sfc.h"

#include "fonts.h"
#include "japan.h"

Window *fw;


FRPath messagepath=
	{
	"*.msg"
	};

FRPath fontpath=
	{
	"*.bin"
	};

char *messagefile,*fontfile;

unsigned char *messagelist,*currentmessage;
int messagelistsize;
int messagelistnum;
char *messagelistnumlist;

char lastmessagefile[MAXPATH];

struct FontHeader *mfh;
unsigned char *mfc;
struct CharData *mfd;
unsigned char *mfont;

int wordwrap;

char *nameslist;
char *soundslist;

#define FONTWIDTH 16
#define FONTHEIGHT 16

#define MG_NEW 1
#define MG_BACKSPACE 2
#define MG_SPACE 3
#define MG_NUMBERLIST 4
#define MG_SAVE 6
#define MG_NAMESLIST 7
#define MG_SOUNDSLIST 9
#define MG_WRAP 11

//
// Program Code  
//

//
// GetPixelFromFont(x,y)
// Gets pixel from packed font

int inline GetPixelFromFont(int x,int y)
	{
	return mfont[x/8+((unsigned int)mfh->width)*y] & (1<<(7-(x&7)));
	}

//
// Draws the cursor in the font window

void DrawFWCursor(int x,int y)
	{
	oldx = x; oldy = y;

	if (x == -1 || y == -1) return;

	if (y*fw->SizeX()/FONTWIDTH+x > mfh->lastentry-mfh->firstentry+1) return;

	fw->FGcolor(GrXOR|RED);
	fw->filledbox(x*FONTWIDTH,y*FONTHEIGHT,x*FONTWIDTH+FONTWIDTH-1,y*FONTHEIGHT+FONTHEIGHT-1);

	}

//
// MFontChar(Window *w,int x,int y,unsigned char c)
// Draw a character to the specified window
// returns width of character including space

int MFontChar(Window *w,int x,int y,unsigned char c)
	{
	int ox,width,spacing;
	int i,j;

	if (c<mfh->firstentry || c >mfh->lastentry) c = 255;
	else c = mfc[c-mfh->firstentry];

	if (c != 255)
		{
		width = (mfd[c].startwidth&widthmask)>>widthshift;
		ox = (mfd[c].startwidth&startmask)>>startshift;
		spacing = mfh->spacing;
		}
	else	
		{
		ox = 0;
		width = 0;
		spacing = mfh->height/2;
		}

	for (j=0;j<mfh->height;j++)
		{
		for (i=0;i<width;i++)
			{
			if (GetPixelFromFont(i+ox,j)) w->plot(i+x,j+y);
			else w->unplot(i+x,j+y);
			}
		for (i=width;i<width+spacing;i++)
			w->unplot(i+x,j+y);
		}

	return width+spacing;
	}


//
// MCharWidth(unsigned char c)
// returns width of character including space

int MCharWidth(unsigned char c)
	{
	int ox,width,spacing;

	if (c<mfh->firstentry || c >mfh->lastentry) c = 255;
	else c = mfc[c-mfh->firstentry];

	if (c != 255)
		{
		width = (mfd[c].startwidth&widthmask)>>widthshift;
		ox = (mfd[c].startwidth&startmask)>>startshift;
		spacing = mfh->spacing;
		}
	else	
		{
		ox = 0;
		width = 0;
		spacing = mfh->height/2;
		}

	return width+spacing;
	}

//
// MFontString(Window *w,int x,int y,unsigned char c)
// returns width of string


int MFontString(Window *w,int x,int y,unsigned char *s,int l)
	{
	int width=0;
	int n;

	for (n=0;n<l;n++)
		{
		if (width+x+MCharWidth(s[n])>w->MaxX())
			{
			width = 0;
			y += mfh->height;
			}
		width += MFontChar(w,x+width,y,s[n]);
		}

	return width;
	}

int MFontString(Window *w,int x,int y,unsigned char *s)
	{
	int width=0;
	int n,lastspace=-1,lastwidth=0;

	for (n=0;n<strlen(s);n++)
		{
		if (width>wordwrap)
			{
			if (lastspace!=-1)
				{
				MFontString(w,x,y,s,lastspace);
				return lastwidth+MFontString(w,x,y+FONTHEIGHT,s+lastspace+1);
				}
			else
				{
				MFontString(w,x,y,s,n-1);
				return lastwidth+MFontString(w,x,y+FONTHEIGHT,s+n);
				}
			}
		if (s[n]==' ')
			{
			lastspace = n;
			lastwidth = width;
			}
		width += MCharWidth(s[n]);
		}

	MFontString(w,x,y,s,n);

	return width;
	}

//
// Display the current message

void DisplayCurrentMessage()
	{
	char temp[1024];
	char *s;

	if (currentmessage)
		{
		strcpy(temp,currentmessage);
		*strchr(temp,' ') = '\0';
		if (fw->SearchList(MG_NAMESLIST,GS_FROMTOP,temp)!= -1) fw->SetSelectedItem(MG_NAMESLIST,fw->SearchList(MG_NAMESLIST,GS_FROMTOP,temp));

		strcpy(temp,strchr(currentmessage,' ')+1);
		*strchr(temp,' ') = '\0';
		if (fw->SearchList(MG_SOUNDSLIST,GS_FROMTOP,temp)!= -1) fw->SetSelectedItem(MG_SOUNDSLIST,fw->SearchList(MG_SOUNDSLIST,GS_FROMTOP,temp));

		s = strchr(strchr(currentmessage,' ')+1,' ')+1;

		tw->BGcolor(WHITE);
		tw->cls();
		tw->FGcolor(BLACK);
		tw->BGcolor(LIGHTGRAY);
		MFontString(tw, 8,8, s);
		tw->FGcolor(RED);
		tw->line(8+wordwrap,0,8+wordwrap,tw->MaxY());
		tw->line(7,0,7,tw->MaxY());
		tw->flush();
		}
	}
//
// Add a char to the end of the current message

void AddChar(unsigned char c,int n)
	{
	int coff,cendoff;
	if (currentmessage)
		{
		coff = currentmessage-messagelist;
		cendoff = (currentmessage+n)-messagelist;
		messagelist = (unsigned char *)realloc(messagelist,messagelistsize+1);
		memcpy(messagelist+cendoff+1,
			messagelist+cendoff,
			messagelistsize-cendoff);

		currentmessage = messagelist+coff;
		currentmessage[n] = c;
		messagelistsize ++;
		}
	}

void AddChar(unsigned char c)
	{
	if (currentmessage)
		AddChar(c,strlen(currentmessage));
	}

//
// Add a string to the end of the current message

void AddString(unsigned char *s)
	{
	while (*s != '\0')
		AddChar(*s++);
	}

void AddString(unsigned char *s,int n)
	{
	while (*s != '\0')
		AddChar(*s++,n++);
	}

//
// Del a char from the end of the current message

void DelChar(int n)
	{
	if (currentmessage)
		{

		memcpy(currentmessage+n,
			currentmessage+n+1,
			messagelistsize-((currentmessage+n+1) - messagelist));
		messagelistsize --;
		}
	}

void DelChar()
	{
	if (currentmessage)
		{
		if (*currentmessage=='\0') return;

		DelChar(strlen(currentmessage)-1);
		}
	}

//
// Set up the font selector window

void SetupFontWindow()
	{
	int x,y,c;

	*fw << WT_BLACK;

	for (c=mfh->firstentry,x=0,y=0;c<mfh->lastentry-1;c++)
		{
		MFontChar(fw,x,y,c);
		x += FONTWIDTH;
		if (x>fw->SizeX()-FONTWIDTH) { x = 0; y += FONTHEIGHT; }
		}
	}

//
unsigned char *MakeMessageList()
	{
	unsigned char *m=NULL,*s,temp[256];
	int total=0,n,num=0;

	if (s = messagefile)
		{
		while (*s != 0x1b && *s != 0x1a)
			{
			if (*s++ == '<')
				{
				n = 0;
				while (*s != 0x1b && *s != 0x1a && *s != '>') temp[n++] = *s++;
				temp[n] = '\0';
				m = (unsigned char *)realloc(m,total+n+1);
				strcpy(m+total,temp);
				total += n+1;
				num++;
				}
			}
		m = (unsigned char *)realloc(m,total+1);
		m[total++] = '\0';
		}

	messagelistsize=total;
	messagelistnum = num;
	return m;
	}

//
// get message address from the messagelist

unsigned char *GetMessage(int n)
	{
	char *s=NULL;
	int m;
	if (messagelist)
		for (s=messagelist,m=0;(n!=m)&&(*s!='\0');m++,s+=strlen(s)+1)
			;

	return s;
	}

//
// Save the messages off

void SaveMessages()
	{
	FILE *fp;
	char *s;
	int n;

	if (messagefile = getfilename("Save Message file",&messagepath, lastmessagefile, FR_SETPATH))
		{
		if (fp = fopen(messagefile,"w"))
			{
			for (n=0,s=messagelist;n<messagelistnum;n++,s+=strlen(s)+1)
				{
				fprintf(fp,"\tMSG\t<%s>\n",s);
				}
			fclose(fp);
			}
		}
	}

//
void GenerateMessageNums()
	{
	char temp[10];
	int n;

	if (messagelistnumlist) sl_free(&messagelistnumlist);

	sl_init(&messagelistnumlist);
	for (n=0;n<messagelistnum;n++)
		{
		sprintf(temp,"%d",n+1);
		sl_add(&messagelistnumlist,temp);
		}
	sl_end(&messagelistnumlist);

	fw->SetList(4,messagelistnumlist);
	}

//
// Open the messages windows

void OpenMessages()
	{
	int n;
	char temp[MAXEXT];

	messagelistnumlist = NULL;
	messagelist = NULL;
	messagefile = NULL;
	fontfile = NULL;


	sl_init(&nameslist);
	sl_add(&nameslist,"FOX");
	sl_add(&nameslist,"FALCO");
	sl_add(&nameslist,"PEPPY");
	sl_add(&nameslist,"SLIPPY");
	sl_add(&nameslist,"ANDROSS");
	sl_end(&nameslist);

	sl_init(&soundslist);
	sl_add(&soundslist,"OTHER");
	sl_add(&soundslist,"HELP");
	sl_add(&soundslist,"DOWN");
	sl_end(&soundslist);


	tw = new Window(32,64,mw->MaxX()-maxx-32,32+128,WHITE,"Starfox Messages",W_BACKINGSTORE|W_MOTIFBORDER);
	fw = new Window(32,mw->SizeY()/2,mw->MaxX()-32,mw->SizeY()-32,LIGHTGRAY,"Font Selector",W_BACKINGSTORE|W_MOTIFBORDER);

	fw->setfont(nicefont);
	fw->FGcolor(BLACK);
	new Gadget(fw,0,fw->MaxY()-GADGETSIZEY(fw)*2-GADGETSPACING,0,0,"Back",MG_BACKSPACE,G_BOXHIGHLIGHT|G_TEXTHIGHLIGHT|G_BOXTEXT,8);
	new Gadget(fw,AUTOSPACING,0,0,0,"Space",MG_SPACE,G_BOXHIGHLIGHT|G_TEXTHIGHLIGHT|G_BOXTEXT,0);
	new Gadget(fw,0,fw->MaxY()-GADGETSIZEY(fw),0,0,"New",MG_NEW,G_BOXHIGHLIGHT|G_TEXTHIGHLIGHT|G_BOXTEXT,'N');
	new Gadget(fw,AUTOSPACING,0,0,0,"Save",MG_SAVE,G_BOXHIGHLIGHT|G_TEXTHIGHLIGHT|G_BOXTEXT,'S');
	new Gadget(fw,AUTOSPACING,0,0,0,"Wrap",MG_WRAP,G_BOXHIGHLIGHT|G_TEXTHIGHLIGHT|G_BOXTEXT,'W');
	new Gadget(fw,AUTOSPACING,-64,64,fw->MaxY(),NULL,MG_NUMBERLIST,G_BOXHIGHLIGHT|G_LIST,0);
	new Gadget(fw,AUTOSPACING,0,0,fw->MaxY(),nameslist,MG_NAMESLIST,G_BOXHIGHLIGHT|G_LIST,0);
	new Gadget(fw,AUTOSPACING,0,0,fw->MaxY(),soundslist,MG_SOUNDSLIST,G_BOXHIGHLIGHT|G_LIST,0);

	fw->Direct();
	tw->flush();

	if (messagefile = getfilename("Message file",&messagepath, "", FR_SETPATH))
		{
		fnsplit(messagefile,NULL,NULL,lastmessagefile,temp);
		strcat(lastmessagefile,temp);
		messagefile = LoadFile(messagefile);
		}
	if (!(fontfile = getfilename("Font binary file",&fontpath, "", FR_SETPATH))) return;
	fontfile = LoadFile(fontfile);

// Set up font information data

	mfh = (struct FontHeader *)fontfile;
	mfc = fontfile+sizeof(struct FontHeader);
	mfd = (struct CharData *)(fontfile+sizeof(struct FontHeader) + mfh->lastentry-mfh->firstentry +1);
	mfont = mfh->offset + fontfile;

	SetupFontWindow();

	DrawFWCursor(-1,-1);

	messagelist = MakeMessageList();

	currentmessage = messagelist;

	wordwrap=tw->SizeX();
	DisplayCurrentMessage();

	GenerateMessageNums();

	fw->SetSelectedItem(MG_NUMBERLIST,0);

	}

//
// Close the messages windows

void CloseMessages()
	{
	delete tw;
	delete fw;
	if (messagefile) free(messagefile);
	if (fontfile) free(fontfile);
	if (messagelist) free(messagelist);
	if (messagelistnumlist) sl_free(&messagelistnumlist);
	sl_free(&nameslist);
	sl_free(&soundslist);
	}

//
// Add a new message to end of list

void AddNewMessage()
	{
	if (*currentmessage=='\0') AddString("FOX OTHER ");

	currentmessage = GetMessage(messagelistnum++);
	AddString("FOX OTHER ");
	AddChar('\0');

	GenerateMessageNums();

	}
//
// Change the name of the character that says the message

void ChangeName(unsigned char *name)
	{

// First delete the old name

	while (*currentmessage!=' ')
		DelChar(0);

	AddString(name,0);

	}


//
// Change the sound associated with the message

void ChangeSound(unsigned char *sound)
	{
	int n;
// Find second word

	n = (unsigned long)strchr(currentmessage,' ')-(unsigned long)currentmessage+1;

	while (currentmessage[n]!=' ')
		DelChar(n);

	AddString(sound,n);

	}

//
// Do the messages windows

void DoMessages()
	{
	int newx=oldx,newy=oldy;

	if (!messagelist || !messagelistnum) return;

	if (tw->mouse())
		{
		}
	if (fw->mouse())
		{
		if (fw->input.flags&M_MOTION)
			{
			newx = fw->input.x/FONTWIDTH; newy = fw->input.y/FONTWIDTH;
			}

		if (newx>=fw->SizeX()/FONTWIDTH) newx = -1;

		if (oldx != newx || oldy != newy)
			{
			DrawFWCursor(oldx,oldy);
			DrawFWCursor(newx,newy);
			}

		if ((fw->input.flags&M_BUTTON_DOWN) && (fw->input.buttons&M_LEFT) && oldx != -1 && oldy != -1)
			{
			AddChar(mfh->firstentry+oldy*fw->SizeX()/FONTWIDTH+oldx);
			DisplayCurrentMessage();
			}

		if ((fw->input.gflags&GF_SELECTED))
			{
			switch(fw->input.gadget)
				{
				case MG_WRAP:
					GetNumber("Enter Wrap Width",&wordwrap,32,256);
					DisplayCurrentMessage();
					break;
				case MG_SAVE:
					SaveMessages();
					break;
				case MG_SPACE:
					AddChar(' ');
					DisplayCurrentMessage();
					break;
				case MG_BACKSPACE:
					DelChar();
					DisplayCurrentMessage();
					break;
				case MG_NEW:
					AddNewMessage();
					DisplayCurrentMessage();
					fw->SetSelectedItem(MG_NUMBERLIST,messagelistnum-1);
					break;
				default:
					break;
				}
			}
		if ((fw->input.gflags&GF_HIGHLIGHT))
			{
			switch(fw->input.gadget)
				{
// check if the sound has been changed
				case MG_SOUNDSLIST:
					if (fw->GetSelectedItemNum(MG_SOUNDSLIST)!=-1)
						ChangeSound(fw->GetSelectedItem(MG_SOUNDSLIST));
					break;
// check if the name has been changed
				case MG_NAMESLIST:
					if (fw->GetSelectedItemNum(MG_NAMESLIST)!=-1)
						ChangeName(fw->GetSelectedItem(MG_NAMESLIST));
					break;
// check if the list has been selected
				case MG_NUMBERLIST:
					if (*currentmessage == '\0') AddString("FOX OTHER ");
					currentmessage = GetMessage(fw->input.slider);
					DisplayCurrentMessage();
					break;
				default:
					break;
				}
			}
		}
	}





