;
	include		mn_hp_smram.asm
;
	 ORG	  3AD60H
		EXTEND
		IDX8
		MEM8
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1985. 8.12	    V.1.0  Super Mario
;				   File name : SMPLAY
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	EXT	MINCTR,VSPLCK2
	EXT	PS_RESET,ZD_RESET
;=========================================================== SMSUB0 ==
	 EXT	  CLSET2,KFDOWN,COBINT,BOMBPT,PLPECE
;=========================================================== SMMAIN ==
;........................................................... ( VRFLG No. )
	 EXT	  SCDISP
	 EXT	  CLGN0,BGD02
	 EXT	  BGBKES,GMBGOT,BGCOES,BGBKST,BGBLNK
	 EXT	  SCHEG,CAINC,JSRSUB,VRMCLZ
	EXT	GMOVR,KEYCNG
;........................................................... ( Block No. )
	 EXT	  SKY0,HOLE0,HOLE1,GRS0,MT0,WATR0,WATR1,CHM0
	 EXT	  LND0
	 EXT	  CLBK0,BRIK0,GRND0,CLD00,WOOD0
	 EXT	  BKBSW,BLNKBK,COIN0,COIN1,BRIK2
	 EXT	  BXMUS,BXCON,STBCO,STBMS
	 EXT	  BKMUS,BKWOD,BKSTR,RBCOS,SBMUS
	 EXT	  BRMUS,BRWOD,BRSTR,BRBCS,BRSMS
;=========================================================== SMINIT ==
	 EXT	  GMINT0,GMINT1,GMOVER,PLFAIL,PLOUT,NWFRST,BGMSET
;=========================================================== SMPLAY ==
	 GLB	  GMPROS,GMPLAY,GMPLAY_DEMO,PLBLPS,BGLNWT,SCRCAL,PLATMV
	 GLB	  GCALC,CALCX0,ENGCAL,ENGCL2,ENCLX0,BKGCL0,BKGCL1
	 GLB	  ENGCLS,ENFCLS,DSXPCR,LFGCL0,LFGCL1,LFGCL2,ENGCL3
	 GLB	  GCALC,LFGCLH,ENGC15
	 GLB	  BKPINT,DWBLOK,AGBLOK,COINHM,MSINT1,MSMOVE
	 GLB	  WDINIT,WDMOVE,GUINIT,GUMOVE,COINUP,BKPSSB
	 GLB	  HMINIT,BKPSSET,STBBK,SPRING,PLSCR20,GUN
	 GLB	  WHPLMV,SCORUP,NOTRMV1,BNBKDT,PLSCORE
	 GLB	  BKSCUP,MOZAIK,PLAYER
;
	GLB	AA2,GCALCY
	EXT	AA1,MRFLCL
;........................................................... ( Player flag )
	 GLB	  WKRT,PLLRMV
;........................................................... ( Game pros mode )
	 GLB	  GMITMD,GMBGMD,GMPYMD
;........................................................... ( Mode No. )
	 GLB	  PLSMMD,PLWUMD,PLC0MD,PLMDFL,PLC1MD,PLMDPY
	 GLB	  PLSB,PLBS,PLBX,PLSF,PLTPMD,PLCRMD,NOCRMD
;........................................................... ( Statsu )
	 GLB	  BWALK,BJUMP,BDROP,PWIRE,WKSLW
;........................................................... ( LF & RT move value )
	 GLB	  WKLF,RNLF,WKRT,RNRT
;=========================================================== SMENMY ==
	 EXT	  ENLDWY,ENCLER
	 EXT	  ENWKMV,ENPYMV
;----------------------------------------------------------- ( Enemy kind No. )
	 EXT	  ENEMY
	 EXT	  BWOD,BMUS
;........................................................... Enemy No.
	 EXT	  SHTR,BKTR,RDTR,TUTR,FTR0,FTR2
	 EXT	  FTR6,FTR7,ENDTR
	 EXT	  EXT0,EXFF,JFS0,GFLG,LFT5
	 EXT	  SST0,SST1,SST2,SST3
	 EXT	  LFT0,LFT1,LFT2,LFT3,ELV0,ELV1
	 EXT	  FREND
;........................................................... ( Statsu )
	 EXT	  WALK,DOWN,JUMP,STOP,TIME,DROP,FIRE,GSHL
;=========================================================== SMCSET ==
	 EXT	  PLFRCK,FIFRCK,PLCSET,PLBLCT
	 EXT	  PLPSCV,FIPSCV,BLPSCV,GFCSET
	 EXT	  BKCST1,BKCST2,BLFRCK,BKFRCK
	 EXT	  FRMCHK,FRMXCK,FRMYCK,FICST1,FICST2,COCSET
	 EXT	  BKPSCV,COPSCV,MSFRCK,ENCSET,COFRCK
	 EXT	  MSCSET,MSPSCV,ENFRCK,ENPSCV,WDCSET
;;;;	 EXT	  SHCSET
	 EXT	  HMFRCK,HMPSCV,HMCRDS,CRPLHM,HMCSET
;=========================================================== SMCROS ==
	 EXT	  CRDTST,CRPLBG,CRFIBG
	 EXT	  FICRDS,CRFIEN,HEDC15
	 EXT	  CRPM80,BRBKCK,CRPLCO,COCRDS
	 EXT	  ENCRDS,CRENPL,CRPLMS,MSCRDS,CRBGCK,CRECMP
	 EXT	  CRENBG,CREB03
	 EXT	  COCMD,GUCMD,ENCMD2,ENCMD
;;;;;;	 EXT	  MSCMD
;........................................................... ( OBJ cross mode No. )
	 EXT	  PBCMD,PSCMD,PDCMD,FICMD
;........................................................... ( Etc data )
	 EXT	  PCBDY0,PCBDY2
;=========================================================== SMFRDT ==
	 EXT	  RDCRDT
;=====================================================================
		EXT	HDMAMV
;=========================================================== SMSUB1 ==
		GLB	PCSCDT
;=====================================================================
		EXT	PLCNT_SET
;=====================================================================
;
;#####################################################################
;#	 JSR	  GMPROS    [ Game pros ]			     #
;#####################################################################
GMPROS		EQU	$	  ; Game pros !
		LDA	GMMODE
		ASL	A
		TAX
		JMP	(PROSTBL,X)
;;;;;;;;		JSR	JSRSUB
PROSTBL		EQU	$
GMPS10		WORD	GMINT0		; 0 Game initial-0
GMPS20		WORD	GMBGOT		; 1	 BG out
		WORD	GMINT1		; 2	 initial-1
GMPS50		WORD	GMPLAY		; 3	 play
;
GMITMD		EQU	(GMPS10-GMPS10)/2    ; Game initial mode value
GMBGMD		EQU	(GMPS20-GMPS10)/2    ;	    BG display
GMPYMD		EQU	(GMPS50-GMPS10)/2    ;	    play
;
;#####################################################################
;#	 JSR	  GMPLAY    [ Game play routine ]		     #
;#####################################################################
GMPLAY	 EQU	  $
;mariomariomario;	 BEQ	 GMJM10
	JSL	>KEYCNG
GMPLAY_DEMO	EQU	$
GMJM10	EQU	$
	LDA	<PLSTAT
	BNE	GMJM20
	STZ	ENCLFG
GMJM20	EQU	$
	 LDX	  MRLGFG
	 LDA	  KEYA1,X
	 STA	  KEYA1
;			    < Player vs Enmey >
	 JSR	  PLAYER	  ; Player main
;
	 LDA	  GMMODE
	 CMP	  #GMPYMD
	 BCS	  GMPY20	  ;- IF	 change next environment ?  ( NO ; GMPY20 )
;
	 RTS
;
GMPY20	 EQU	  $
	 JSR	  PLTOOL	  ;   "    tool chara main
;
GMPY30	 EQU	  $
	 LDX	  #0
;
GMPY40	 EQU	  $
	 STX	  <INDEX
;
	LDA	ENCLFG
	BEQ	GMPY41
	CMP	#07FH
	BEQ	GMPY42
GMPY41	EQU	$
	 JSR	  ENEMY		  ; Enemy main
	LDA	!ENCLFG
	BNE	GMPY41X
	 JSR	  SCDISP	  ; score display
GMPY41X EQU	$
	 INX
	 CPX	  #CMEND-ENCMOD	  ;+1
	 BNE	  GMPY40
;
	JSL	>BOMBPT		;kame bakuhatu chr set
	LDA	ENCLFG
	BEQ	GMPY42
	LDA	#7FH
	STA	ENCLFG
;
GMPY42	EQU	$
	 JSR	  PLFRCK	  ; Player frame side check
	 JSR	  PLPSCV	  ;    "   position convert
	 JSR	  PLCSET	  ;    "   chara cset
;			    < Exstra pros >
;;t	    JSR	     AGBLOK	     ; Again block set
;
	 LDX	  #1
	 STX	  <INDEX
	 JSR	  DWBLOK	  ; Down block
;
	 DEX
	 STX	  <INDEX
;
	 JSR	  DWBLOK	  ; Down block
	 JSR	  AGBLOK	  ; Again block set
;
	 JSR	  COINHM	  ; Coin & tomafork
	 JSR	  GUN		  ; Gun move
	 JSR	  WHPLMV	  ; Whirlpool move
	 JSR	  GLFGMV	  ; Gorl flag move
	 JSR	  PLYTIM	  ; Play   time calc
	 JSR	  BGBLNK	  ; BG color blinking
;
	 LDA	  <PLYPS0
	 CMP	  #2
	 BPL	  GMPY44
;
	 LDA	  SPMTIM
	 BEQ	  GMPY50
	 CMP	  #4
	 BNE	  GMPY44
	 LDA	  TMEM
	 BNE	  GMPY44
;
	JSL	>BGMSET			; <S! @@@@@@@@@@@@@@@@@@
;
GMPY44	EQU	$
	LDA	<FMCNT
	PHY
	LDY	SPMTIM
	CPY	#8
	BCS	GMPY45
	LSR	A
	LSR	A
GMPY45	EQU	$
	PLY
	JSR	PLFLSH			; No. Death Mario flashing
	BRA	GMPY60
;
GMPY50	EQU	$
	LDA	TMEM
	CMP	#1
	BNE	GMPY55
	LDA	<PLCMOD
	CMP	#0CH
	BEQ	GMPY55
	JSL	>CLSET2
GMPY55	EQU	$
	JSR	PLBX20
;
GMPY60	EQU	$
	LDA	<KEYAB
	STA	<WKEYUD			; <WKEYUD <-- <KEYUD up & down infomate
;
	STZ	<KEYLR
;
;#####################################################################
;#	 JSR	  BGLNWT    [ BG line wright & Frame data read ]     #
;#####################################################################
BGWTMD	 EQU	  020H	    ; BG write time data !
;
BGLNWT	 EQU	  $
	 LDA	  VRFLG
	 CMP	  #BGD02
	 BEQ	  BGLW90	  ;- IF	 now down block move ?	( YES ; BGLW90 )
;
	 LDA	  NWSTCT
	 BNE	  BGLW10
;
	 LDA	  BGWTIM
	 CMP	  #BGWTMD
	 BMI	  BGLW90
;
	 LDA	  BGWTIM
;;	 SEC
	 SBC	  #BGWTMD
	 STA	  BGWTIM
;
;;K;;	      LDA      #0
;;K;;	      STA      BGDBPT	       ; BG display buffer index init
	 STZ	  BGDBPT	  ; BG display buffer index init
;
BGLW10	 EQU	  $
	 JSR	  NWFRST
;
BGLW90	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  SCRPRS    [ Scroll pros ]			     #
;#		  SCRMVL -- Scroll move value			     #
;#####################################################################
SCRPRS	 EQU	  $
	 LDA	  PLXMVL    ; Clac on lift move value !
	 CLC
	 ADC	  LFXMVL
	 STA	  PLXMVL
;
	 LDA	  SRSTFG
	 BEQ	  SRP010
	 JMP	  SRPS80    ;- IF  scroll stop ?		     ( YES ; SRPS80 )
;
SRP010	EQU	$
	 LDA	  PLOXPS
	 CMP	  #50H
	 BCC	  SRPS80    ;- IF  OBJ (x) pos < scroll point ?	     ( YES ; SRPS80 )
;
;			    < Scroll move value calc >
	 LDA	  TMES4		  ; Ground & Undergorund & Underwater scroll calc !
	 BNE	  SRPS80	       ;- IF  strike to wall ?	     ( YES ; SRPS80 )
;
	 LDY	  PLXMVL
	 DEY
	 BMI	  SRPS80	       ;- IF  player right move ?    ( NO ; SRPS80 )
;
	 INY
	 CPY	  #2
	 BCC	  SRPS30	       ;- IF  player 0 dot move ?    ( YES ; SRPS30 )
;
	 DEY
;
SRPS30	 EQU	  $
	 LDA	  PLOXPS
	 CMP	  #70H
	 BCC	  SRPS60
;
	 LDY	  PLXMVL
;
SRPS60	 EQU	  $	    ; New scroll position calc !
;#####################################################################
;#		      Yr -- Scroll dot value			     #
;#	 JSR	  SCRCAL    [ Scroll calc ]			     #
;#####################################################################
SCRCAL	 EQU	  $
	 TYA
	 STA	  SCRMVL	  ; Scroll move value set
;
	 CLC
	 ADC	  BGWTIM
	 STA	  BGWTIM
;
	LDA	DSXP01
	STA	<WORK
	LDA	DSXP00
	STA	<WORK+1
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16 bit mode
;
	TYA
	AND	#00FFH
	CLC
	ADC	<WORK
	STA	<WORK
	LSR	A
	STA	SCCH21			; BG2 scroll
	LSR	A
	STA	SCCH31			; BG3 bu-bu-n scroll
;
	MEM8
	IDX8
	SEP	#00110000B		; memory , index 8 bit mode
;
	LDA	<WORK
	STA	DSXP01
	STA	SCCH
	STA	<SCCH1
	LDA	<WORK+1
	STA	DSXP00
	STA	<SCCH1+1
;
	AND	#00000001B
	STA	<WORK
;
	LDA	CTLR0
	AND	#11111110B
	ORA	<WORK
	STA	CTLR0
;
	JSR	DSXPCR			; Frame must Right pos(x) calc !
;
	LDA	#08
	STA	TMEL0			; Random enmey out time
	BRA	SRPS82
;
SRPS80	EQU	$			; Scroll stop pros !
;;;;K;;;;	LDA	#0
;;;;K;;;;	STA	SCRMVL			; Clear	 scroll move value
	STZ	SCRMVL			; Clear	 scroll move value
;
SRPS82	EQU	$			; Frame left & right side check !
	LDX	#0
	JSR	FRMXCK			; Frame side limit check
	STA	<WORK
;
	LDY	#0
	ASL	A
	BCS	SRPS85			; IF left side limit ?	( YES ; SRPS85 )
;
	INY
;
	LDA	<WORK
	AND	#00100000B
	BEQ	SRPS90			; IF right side limit ? ( YES ; SRPS90 )
;
SRPS85	EQU	$			; Player position settile !
	LDA	DSXP01,Y
	SEC
	SBC	FRSDCD,Y
	STA	PLXPS1
;
	LDA	DSXP00,Y
	SBC	#0
	STA	<PLXPS0			; Player pos(x) <-- Flame LF pos(x)
;
	LDA	<KEYLR
	CMP	FRSDCD+2,Y
	BEQ	SRPS90			; IF move muki = come out muki ?  ( YES ; SRPS90 )
;
	STZ	<PLXSD0			; Stop left move
;
SRPS90	EQU	$
	LDA	#0
	STA	LFXMVL			; Clear	 move left value
	RTS
;
FRSDCD	EQU	$			; Frame side check data !
	HEX	00,10
	BIN	00000001,00000010
;
;#####################################################################
;#	 JSR	  DSXPCR    [ Display pos right side calc ]	     #
;#####################################################################
DSXPCR	 EQU	  $
	 LDA	  DSXP01    ; Frame must Right pos(x) calc !
	 CLC
	 ADC	  #0FFH
	 STA	  DSXP11
;
	 LDA	  DSXP00
	 ADC	  #0
	 STA	  DSXP10	  ; DSXP10,DSXP10 <-- DSXP10,DSXP11 + 0FFH
	 RTS
;
;---------------------------------------------------------------------<< Player routine
;
;#####################################################################
;#	 JSR	  PLAYER    [ Player pros ]			     #
;#####################################################################
PLAYER		EQU	$
		LDA	<PLCMOD
		ASL	A
		TAX
		JMP	(PLAYERTBL,X)
;;;;;;;;		JSR	JSRSUB
PLAYERTBL	EQU	$
PLY010		WORD	PLOUT	  ; Player out
PLY025		WORD	PLWUPR	  ;	   up on wood
PLY040		WORD	PLICP1	  ;	   in L-chimney
PLY030		WORD	PLICP0	  ;	   in I-chimney
PLY050		WORD	PLTPPS	  ;	   tach gorl pole
PLY060		WORD	PLGMCL	  ;	   game	  clear
PLY070		WORD	PLFAIL	  ;	   fail
PLY080		WORD	PLSMPR	  ;	   start move
PLY090		WORD	PLPRS0	  ;	   move
PLY100		WORD	PLSTOB	  ;	   Small --! Big
PLY110		WORD	PLBTOS	  ;	   Big	 --! Small
PLY120		WORD	PLSTOF	  ;	   Small --! Fail
PLY130		WORD	PLBTOX	  ;	   Big	 --! Super
;
PLSMMD		EQU	(PLY080-PLY010)/2    ; Player start move
PLMDPY		EQU	(PLY090-PLY010)/2    ;	      game play
PLWUMD		EQU	(PLY025-PLY010)/2    ;	      up on wood
PLC0MD		EQU	(PLY030-PLY010)/2    ;	      in I-chimney
PLC1MD		EQU	(PLY040-PLY010)/2    ;	      in L-chimney
PLSB		EQU	(PLY100-PLY010)/2    ;	      small to big
PLBS		EQU	(PLY110-PLY010)/2    ;	      big   to small
PLSF		EQU	(PLY120-PLY010)/2    ;	      small to fail
PLBX		EQU	(PLY130-PLY010)/2    ;	      big   to super
PLTPMD		EQU	(PLY050-PLY010)/2    ;	      touch gorl pole
PLCRMD		EQU	(PLY060-PLY010)/2    ;	      game clear
PLMDFL		EQU	(PLY070-PLY010)/2    ;	      fail
;
TIMEMD		EQU	(PLY090-PLY010)/2    ; Time clac mode
NOCRMD		EQU	(PLY030-PLY010)/2    ; No cross check mode
;
;#####################################################################
;#	 JSR	  PLSMPR    [ Player start move pros ]		     #
;#####################################################################
PLSMPR	 EQU	  $
	 LDA	  CHEVFG
	 CMP	  #2
	 BEQ	  PLS050	  ;- IF	 bottom ev. --! top ev. ?  ( YES : PLS050 )
;
	 LDA	  #0
	 LDY	  PLYPS1
	 CPY	  #30H
	 BCS	  PLS038
	 JMP	  PLATMV	  ;- IF	 in chimney ?		   ( YES ; PLATMV )
PLS038	 EQU	  $
;
	 LDA	  PLFPFG
	 CMP	  #6
	 BEQ	  PLS040
;
	 CMP	  #7
	 BNE	  PLS120	  ;- IF	 no walk start move ?	   ( YES ; PLS120 )
;
PLS040	 EQU	  $		  ; Start walk playe !
	 LDA	  PLOJBG
	 AND	  #11110000B
	 BEQ	  PLS045	       ;- IF  in L-chimney ?	   ( YES ; PLS045 )
;
	 LDA	  #00000001B		    ; Normal wark
	 JMP	  PLATMV
;
PLS045	 EQU	  $
	 JSR	  INLCSB		    ; In L-chimney move sub pros
;;T;;
;;	 LDA	  PLICCT
;;	 CMP	  #1FH
;;	 BNE	  PLS048
;;	 LDA	  #01H
;;	 STA	  MFFLG
;;	STA	FADFLG
PLS048	 EQU	  $
;;T;;
	 DEC	  PLICCT		    ; DEC  in L-chimney counter
	 BNE	  PLS190	       ;- IF  next OK time ?	   ( NO ; PLS190 )
;
	 LDA	  #01H
	 STA	  MFFLG
	STA	FADFLG
;				  ; Next set  underground & underwater >
	 INC	  MGSTFG	       ; Messarge display stop flag ON
		INC	CORSID			; Next frame information data & Flag set !
	 JMP	  NXFIFS	       ; Next information data & flag set
;
PLS050	 EQU	  $		  ; Up or Up on move !
	 LDA	  PLUWFG
	 BNE	  PLS090	       ;- IF  up wood player ?	   ( YES ; PLS090 )
;
	LDA	PLYPS1
	CMP	#0B0H
	BNE	PLS060
	LDA	#04
	STA	!SOUND0
PLS060	EQU	$
	STA	UCHFLG
	 LDA	  #0FFH		       ; UP I-chimney !
	 JSR	  PLUDCL		    ; Chimney up player
;
	 LDA	  PLYPS1
	 CMP	  #091H
	 BCC	  PLS120		    ;- IF  up end ?	   ( YES ; PLS120 )
;
	 RTS
;
PLS090	 EQU	  $		       ; Up on wood !
	 LDA	  WDLONG
	 CMP	  #60H
	 BNE	  PLS190		    ;- IF  wood grow end ? ( NO ; BLS190 )
;
	 LDA	  PLYPS1
	 CMP	  #099H
	 LDY	  #0
	 LDA	  #00000001B
	 BCC	  PLS100		    ;- IF  up end ?	   ( YES ; PLS190 )
;
	 LDA	  #PWIRE
	 STA	  <PLSTAT
;
	 INY
;
	 LDA	  #00001000B
	 STA	  FRMTB0+0B4H		    ; Set  Dummy block
;
PLS100	 EQU	  $
	 STY	  BGCROF		    ; Set  BG cross stop flag
;
	 JSR	  PLATMV		    ; Player auto move
;
	 LDA	  PLXPS1
	 CMP	  #48H
	 BCC	  PLS190		    ;- IF  side move end ? ( NO ; PLS190 )
;
PLS120	 EQU	  $		  ; Next set  ground !
	STZ	UCHFLG
	 LDA	  #PLMDPY
	 STA	  <PLCMOD		; Playe game start mode set
;
	 LDA	  #00000001B
	 STA	  PLCMKI
;
	 LSR	  A
	 STA	  CHEVFG	       ; Change environment flag OFF
	 STA	  BGCROF	       ; BG cross stop flag OFF
	 STA	  PLUWFG	       ; Clear	Player up on wood flag
;
PLS190	 EQU	  $
	 RTS
;
;#####################################################################
;#		      Ar -- Auto move key data			     #
;#	 JSR	  PLATMV    [ Player auto move ]		     #
;#####################################################################
;
NUTSL	 EQU	  $
	 HEX	  03,FD
NUTSH	 EQU	  $
	 HEX	  00,FF
;

PLATMV	 EQU	  $
	 STA	  KEYA1
	LDA	#1
	STA	!PLATFG
	BRA	PLPRS0X
;
;#####################################################################
;#	 JSR	  PLPRS0    [ Player move pros No.0 ]		     #
;#####################################################################
PLPRS0	 EQU	  $	    ; Key convert !
	STZ	PLATFG
PLPRS0X	  EQU	   $	     ; Key convert !
	 LDA	  <PLCMOD
	 CMP	  #PLSF
	 BEQ	  PLP040	  ;- IF	 drop ( fail ) player ?	 ( YES ; PLP040 )
;
	 LDA	  <ENVRFG
	 BNE	  PLP030	  ;- IF	 in water ?		 ( NO ; PLP030 )
;
	 LDY	  <PLYPS0
	 DEY
	 BNE	  PLP020
;
	 LDA	  PLYPS1
	 CMP	  #0D0H
	 BCC	  PLP030	  ;- IF	 must bottom ?		 ( NO ; PLP030 )
;
PLP020	 EQU	  $
	STZ	KEYA1			; Stop	inkey
;
PLP030	 EQU	  $
	 LDA	  KEYA1		  ; Read 'A' & 'B' key data !
	 AND	  #11000000B
	 STA	  <KEYAB		; <KEYAB <-- Key (A,B)
;
	 LDA	  KEYA1		  ; Read LF & RT key check !
	 AND	  #00000011B
	 STA	  <KEYLR		; <KEYLR <-- Key (left,right)
;
	 LDA	  KEYA1		  ; UP & DW key check !
	 AND	  #00001100B
	 STA	  <KEYUD		; <KEYUD <-- Key (up,down)
	 AND	  #00000100B
	 BEQ	  PLP040	       ;- IF  down in key ?	 ( NO ; PLP040 )
;
	 LDA	  <PLSTAT
;;;;   ( CMP	  #BWALK )
	 BNE	  PLP040	       ;- IF  walk mario ?	 ( NO ; PLP040 )
;
	 LDY	  <KEYLR
	 BEQ	  PLP040	       ;- IF  LF or RT in key ?	 ( NO ; PLP040 )
;
	 STZ	  <KEYLR		     ; Clear  key LF & RT
	 STZ	  <KEYUD		     ;		  UP & DW
;;K;;	      LDA      #0
;;K;;	      STA      <KEYLR			  ; Clear  key LF & RT
;;K;;	      STA      <KEYUD			  ;	       UP & DW
;
PLP040	 EQU	  $	    ; Player move pros !
;;T;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AA2	EQU	$
	LDA	>KEYMOD+1
	BNE	AA2X
	JMP	NUTSFIN		;;Nomal mode	(Not select key)	;;;
AA2X	EQU	$
;;T;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	PHX
	LDX	MLFLG2
	LDA	KEYA1L,X
	PLX
	AND	#0C0H
	BEQ	EBSK10
	AND	#080H
	BEQ	EBSK05
	STZ	PLSIZE
	LDA	#1
	STA	POWLEV
	BRA	EBSK10
EBSK05	EQU	$
	STZ	PLSIZE
	LDA	#2
	STA	POWLEV
EBSK10	EQU	$
	 LDA	  KEYA2
	 AND	  #00100000B
	 BEQ	  EBIJ3
	 EOR	  NUTS
	 STA	  NUTS
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 STA	  BGCROF
EBIJ3	 EQU	  $
	 LDA	  NUTS
	 BNE	  PLP049
	 JMP	  NUTSFIN
;
PLP049	 EQU	  $
	 LDA	  #10H
	 STA	  SPMTIM
;
	PHX
	LDX	MRLGFG
	 LDA	  KEYA1L,X
	PLX
	 AND	  #00010000B
	 BEQ	  NUTSFIN3
	 LDA	  <FMCNT
	 AND	  #07H
	 BNE	  NUTSFIN3
NUTSFIN4 EQU	  $
	 LDA	  KEYA1
	 LSR	  A
	 BCS	  TIMMAX
	 LSR	  A
	 BCS	  TIMMIN
	 LSR	  A
	 BCS	  PLYDEC
	 LSR	  A
	 BCS	  PLYINC
	 JMP	  NUTSFIN2
TIMMAX	 EQU	  $
	 LDA	  #09H
	 STA	  PLYTM0
	 STA	  PLYTM0+1
	 STA	  PLYTM0-1
	 JMP	  NUTSFIN2
TIMMIN	 EQU	  $
	 STZ	  PLYTM0
	 STZ	  PLYTM0+1
	 STZ	  PLYTM0-1
	 STZ	  NUTS
	 JMP	  NUTSFIN2
PLYINC	 EQU	  $
;;;;;;;;		INC	!PLCNT
		JSL	>PLCNT_SET		; player count set
	 JMP	  NUTSFIN2
PLYDEC	 EQU	  $
;	 DEC	  PLCNT
;
	 JMP	  NUTSFIN2
NUTSFIN3 EQU	  $
	 LDA	  <FMCNT
	 AND	  #07H
	 BNE	  NUTSFIN5
	 LDA	  KEYA1
	 AND	  #10000000B
	 BEQ	  NUTSFIN5
	 LDA	  PLSIZE
	 EOR	  #01H
	 STA	  PLSIZE
	 LDA	  POWLEV
	 EOR	  #02H
	 STA	  POWLEV
	 JSL	  >CLSET2
;
NUTSFIN5 EQU	  $
	 LDA	  KEYA1
	 AND	  #03H
	 BEQ	  NOTLR
	 TAY
	LDA	<KEYLR
	STA	PLCMKI
	 LDA	  PLXPS1
	 CLC
	 ADC	  NUTSL-1,Y
	 STA	  PLXPS1
	 LDA	  <PLXPS0
	 ADC	  NUTSH-1,Y
	 STA	  <PLXPS0
;
NOTLR	 EQU	  $
;
	 LDA	  KEYA1
	 AND	  #0CH
	 BEQ	  NUTSFIN2
	 LSR	  A
	 LSR	  A
	 TAY
	 LDA	  PLYPS1
	 CLC
	 ADC	  NUTSL-1,Y
	 STA	  PLYPS1
	 LDA	  <PLYPS0
	 ADC	  NUTSH-1,Y
	 STA	  <PLYPS0
	 BRA	  NUTSFIN2
;
NUTSFIN	 EQU	  $		;Normal mode play
;
	 JSR	  PLMOVE	  ; Player move calc !
;
NUTSFIN2 EQU	  $
;
	 LDY	  #PSCMD	  ; Player cross size mode set !
	 LDA	  PLSIZE
	 BNE	  PLP060	       ;- IF  small mario ?	 ( YES ; PLP060 )
;
	 LDY	  #PBCMD
	 LDA	  PLSDFG
	 BEQ	  PLP060	       ;- IF  sit down mario ?	 ( NO ; PLP060 )
;
	 LDY	  #PDCMD
;
PLP060	 EQU	  $
	 STY	  CRSZMD
;				  < Player etc pros >
	 LDA	  #00000001B
	 LDY	  <XSPED0
	 BEQ	  PLP100
	 BPL	  PLP080	       ;- IF  now right move ?	 ( YES ; PLP080 )
;
	 ASL	  A		       ; A <-- #00000010B
;
PLP080	 EQU	  $
	 STA	  <MMUKI		; Move muki set
;
PLP100	 EQU	  $
	 JSR	  SCRPRS	       ; Scroll pros
	 JSR	  PLFRCK	       ; Player frame side check
	 JSR	  PLPSCV	       ;	position convert
	 LDX	  #0
	 JSR	  CRDTST	       ;	cross data set
	 JSR	  CRPLBG	       ;	vs BG
;
;#####################################################################
;#	 JSR	  PLFBMC    [ Player in frame bottom check ]	     #
;#####################################################################
PLFBMC	 EQU	  $
	 LDA	  PLYPS1
	 CMP	  #40H
	 BCC	  PLFM20
;
	 LDA	  <PLCMOD
	 CMP	  #PLCRMD
	 BEQ	  PLFM20    ;- IF  game clear mode ?	      ( YES ; PLFM20 )
;
	 CMP	  #PLSMMD
	 BEQ	  PLFM20    ;- IF  start move mode ?	      ( YES ; PLFM20 )
;
	 CMP	  #NOCRMD+1
	 BCC	  PLFM20    ;- IF  in L-chimney ?	      ( YES ; PLFM20 )
;
	LDA	<PLCMOD
	CMP	#0BH
	BNE	PLFM10
	 LDA	  PLOJBG
	 AND	  #11001110B
	 ORA	  #00110000B	;;T;;
	BRA	PLFM15
PLFM10	EQU	$
	 LDA	  PLOJBG
	 AND	  #11001110B
	 ORA	  #00100000B	;;T;;
PLFM15	EQU	$
	 STA	  PLOJBG	  ; Priority  OBJ ! BG
;
PLFM20	 EQU	  $
	 LDA	  <PLYPS0
	 CMP	  #2
	 BMI	  PLFM60    ;- IF  out bottom frame player ?  ( NO ; PLFM60 )
;
	 LDX	  #1
	 STX	  SRSTFG	  ; Scroll stop flag ON
;
PLFM30	 EQU	  $
	 LDY	  #04H
	 STY	  <WORK+7
;
	 LDX	  #0
	 LDY	  TMUPFG
	 BNE	  PLFM32    ;- IF  time up ?		      ( YES ; PLFM32 )
;
	 LDY	  SKYFLG
	 BNE	  PLFM40    ;- IF  sky ?		      ( YES ; PLFM40 )
;
PLFM32	 EQU	  $
	 INX
;
	 LDY	  <PLCMOD
	 CPY	  #PLSF
	 BEQ	  PLFM40    ;- IF  small --! fail mario ?     ( YES : PLFM40 )
;
	 LDY	  DFLSFG
	 BNE	  PLFM35    ;- IF  drop fail sound ON ?	      ( YES ; PLFM35 )
;
	 INY
	 STY	  DFLSFG
	LDY	#9
	STY	!SOUND2			; Sound set  Drop fail player @@@@
	STA	ENCLFG
;
	LDA	#1
	STA	!PLSIZE
	STZ	!POWLEV
PLFM35	 EQU	  $
	 LDY	  #06H
	 STY	  <WORK+7
;
PLFM40	 EQU	  $
	 CMP	  <WORK+7
	 BMI	  PLFM60    ;- IF  must bottom ?	      ( NO ; PLFM60 )
;
	 DEX
	 BMI	  PLFM70    ;- IF  sky --! ground ?	      ( YES : PLFM70 )
;
	 LDY	  07B1H
	 BNE	  PLFM60    ;- IF  end player fail sound ?    ( NO ; PLFM60 )
;
	 LDA	  #PLMDFL   ; Fail mode !
	 STA	  <PLCMOD	   ; Player fail mode set
;
PLFM60	 EQU	  $
	 RTS
;
PLFM70	 EQU	  $	    ;< Return environment ( Sky --! Ground ) >
;;K;;	      LDA      #0
;;K;;	      STA      PLUWFG	       ; Clear	up on wood flag
	 STZ	  PLUWFG	  ; Clear  up on wood flag
;
	 JSR	  RTEVST	  ; Return environment
	 INC	  CHEVFG
;
	 RTS
;
;#####################################################################
;#	 JSR	  PLWUPR    [ Player up on wood next sky pros ]	     #
;#####################################################################
PLWUPR	 EQU	  $
	 LDA	  <PLYPS0
	 BNE	  PLWP30
;
	 LDA	  PLYPS1
	 CMP	  #0E4H
	 BCC	  RTEVST
;
PLWP30	 EQU	  $	    ; Up on wood pros !
	 LDA	  #00001000B
	 STA	  PLUWFG	  ; Up wood flag ON
	STA	ENCLFG
;
;#####################################################################
;#	 JSR	  PLATMW    [ Player auto move on wood ]	     #
;#####################################################################
PLATMW	 EQU	  $
	 LDY	  #PWIRE
	 STY	  <PLSTAT
	 JMP	  PLATMV	  ; Player auto move
;
;#####################################################################
;#	 JSR	  RTEVST    [ Return environment set ]		     #
;#####################################################################
RTEVST	 EQU	  $
	 LDA	  #2
	 STA	  CHEVFG    ; Change environment flag ON
	 JMP	  GMD0ST    ; Set  Next frame displa mode
;
;#####################################################################
;#	 JSR	  PLICP0    [ Player in I-chimney pros ]	     #
;#####################################################################
PLICP0	 EQU	  $
	 LDA	  #1
	STA	FADFLG
	STA	INCMPS
	LDA	<FMCNT		;DOKAN SANPLE
	LSR	A
	BCC	PLCP10
	LDA	#1
	 JSR	  PLUDCL	  ; Player down move clac
PLCP10	EQU	$
	 JSR	  SCRPRS	  ; Scroll pros
;
	 LDY	  #0
	 LDA	  CMSLFG
	 BNE	  PIP060	  ;- IF	 in select chimney ?  ( YES ; PIP060 )
;
	 INY
	 LDA	  <ENVRFG
	 CMP	  #3
	 BNE	  PIP060	  ;- IF	 in castle ?	      ( NO ; PIP060 )
;
	 INY
	 BRA	  PIP060
;;K;;	      JMP      PIP060
;
;#####################################################################
;#		      Ar -- FF : UP move			     #
;#			    01 : DW move			     #
;#	 JSR	  PLUDCL    [ Player UP & Down move calc ]	     #
;#####################################################################
PLUDCL	 EQU	  $
	 CLC
	 ADC	  PLYPS1
	 STA	  PLYPS1
;
	 RTS
;
;#####################################################################
;#	 JSR	  PLICP1    [ Player in L-chimney pros ]	     #
;#####################################################################
PLICP1	 EQU	  $
	LDA	#01H
	STA	ENCLFG
	STA	FADFLG
	 JSR	  INLCSB	  ; In L-chimney move sub pros
;
	 LDY	  #2
;
PIP060	 EQU	  $
	 DEC	  PLICCT	  ; DEC	 in chimney counter
	 BNE	  PIP090	  ;- IF	 next OK time ?		   ( NO ; PIP090 )
;
	 STY	  CHEVFG	       ; Change environment flag ON
;
;#####################################################################
;#	 JSR	  GMD0ST    [ GMMODE <-- 00H ]			     #
;#		      Ar -- 00H					     #
;#####################################################################
GMD0ST	 EQU	  $
	LDA	#1H
	STA	MFFLG
	STA	ENCLFG
;;T;;	STA	OAMFG
;	  INC	   BGBKFG		; BG blanking ON
;
	 LDA	  #0
	 STA	  GMMODE	       ; Set  Next frame display mode
	 STA	  SCRFLG	       ; Prat scroll stop flag ON
;
PIP090	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  INLCSB    [ In L-chimney sub ]		     #
;#####################################################################
INLCSB	 EQU	  $
	 LDA	  #8
	 STA	  <PLXSD0	   ; Set  walk speed
;
	 LDY	  #00000001B
	 LDA	  PLXPS1
	 AND	  #0FH
	 BNE	  INLC50	  ;- IF	 all in L-chimney ?  ( YES ; INLC50 )
;
	 STA	  <PLXSD0
	 TAY
;
INLC50	 EQU	  $
	 TYA
	 JSR	  PLATMV	  ; Player move pros
;
	 RTS
;
;#####################################################################
;#	 JSR	  PLSTOB    [ Small mario --> Big ]		     #
;#####################################################################
PLSTOB	 EQU	  $
	 LDA	  GMSTTM
	 CMP	  #0F8H
	 BNE	  PLSB10
	 JMP	  PLCHEG
;
PLSB10	 EQU	  $
	 CMP	  #0C4H
	 BNE	  PLSB20
;
	 JSR	  CMCOM
PLSB20	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  PLBTOS    [ Big mario --> Small ]		     #
;#####################################################################
PLBTOS	 EQU	  $
	 LDA	  GMSTTM
	 CMP	  #0F0H
	 BCS	  PLBTS2
;
	 CMP	  #0C8H
	 BEQ	  CMCOM
;
PLBTS1	 EQU	  $
	 JMP	  PLPRS0	  ; PLayer move pross
;
PLBTS2	 EQU	  $
	 BNE	  PLBTS3
;
;#####################################################################
;#	 JSR	  PLCHEG    [ Change player size flag set ]	     #
;#####################################################################
PLCHEG	 EQU	  $
	 LDY	  PLCHFG
	 BNE	  PLBTS3
;
	 STY	  CNOCNT	       ; Chara counter init
;
	 INC	  PLCHFG	       ; Change flag ON
;
	 LDA	  PLSIZE
	 EOR	  #1
	 STA	  PLSIZE	       ; Size set
;
PLBTS3	 EQU	  $
;
	 RTS
;#####################################################################
;#	 JSR	  PLSTOF    [ Small mario --> Fail ]		     #
;#####################################################################
PLSTOF	 EQU	  $
	 LDA	  GMSTTM
	 CMP	  #0F0H
	 BCS	  PLEXT1
;
;;;;	 JMP	  PLEXT0
	 JMP	  PLPRS0    ; PLayer move pross
;
;-------------------------------
CMCOM	EQU	$
	STZ	GMSTTM
	JSL	>CLSET2
;;;;;	      LDA      #0
;;;;;	      STA      GMSTTM
;TEST	 STA	  XSPED0
;TEST	 STA	  PLYCL0
;;;;;	 STA	  PLSTAT
CMCOM2	 EQU	  $
	 LDA	  #PLMDPY
	 STA	  <PLCMOD
	 RTS
;#####################################################################
;#	 JSR	  PLBTOX    [ Big   mario --> Supaer ]		     #
;#####################################################################
PLBTOX	 EQU	  $
	 LDA	  GMSTTM
	 CMP	  #0C0H
	 BEQ	  PLBX10
;
	 EOR	#0FFH
	ASL	A
PLFLSH	 EQU	  $
	ASL	A
	ASL	A
	ASL	A
	PHY
	PHX
	MEM16
	IDX16
	REP	#30H
	AND	#0060H
	TAX
	LDA	!MRLGFG		; luige coler
	AND	#00FFH		;
	BEQ	PLFL05		;
	TXA			;
	CLC			;
	ADC	#0020H		;
	TAX			;
PLFL05	EQU	$		;
	LDY	#01E0H
PLFL10	EQU	$
	LDA	>MRFLCL,X
	STA	!CGWORK,Y
	INX
	INX
	INY
	INY
	CPY	#0200H
	BNE	PLFL10
	MEM8
	IDX8
	SEP	#30H
	PLX
	PLY
	LDA	#1
	STA	!CGVMAF
	RTS
;;;;
;
PLBX10	 EQU	  $
	 JSR	  CMCOM
;
PLBX20	 EQU	  $
	 LDA	  PLOJBG
	 AND	  #11110001B
	 ORA	  #00001110B
	 STA	  PLOJBG
	 RTS
;
;#####################################################################
;#	 JSR	  PLEXT1    [ Plyaer existra mode 1  ]		     #
;#####################################################################
PLEXT1	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  PLTPPS    [ Player touch gorl pole pros ]	     #
;#####################################################################
PLTPPS	 EQU	  $
	 LDA	  <ENMYNO+5
	 CMP	  #GFLG
	 BNE	  PLTP40    ;- IF  gorl flag set OK ?  ( NO ; PLTP40 )
;
;;;;;;	       LDA	GPSDFG	  ; Gorl flag pros !
;;;;;;	       STA	0FFH		; Sound	 Gole pole score  @@@@@@@
;
	 LDA	  #0
	 STA	  GPSDFG
;
	 LDY	  PLYPS1
	 CPY	  #09EH
	 BCS	  PLTP30	  ;- IF	 player must bottom gorl pole ?	 ( YES ; PLTP30 )
;
PLTP20	 EQU	  $
	 LDA	  #00000100B
;
PLTP30	 EQU	  $
	 JMP	  PLATMV	  ; Player move
;
PLTP40	 EQU	  $	    ; Copulsion pros !
	 INC	  <PLCMOD	   ; Next game clear pros
;
	 RTS
;
;#####################################################################
;#	 JSR	  PLGMCL    [ Player game clear pros ]		     #
;#####################################################################
SCOCKD	 EQU	  $	    ; Secret coin check data !
	 BYTE	  21,35,22,27
	 BYTE	  23,24,35,99
;
PLGMCL	 EQU	  $
	JSL	>PLPECE
	BEQ	PGM040
	 LDA	  #00000001B
	 JSR	  PLATMV
	 LDA	  PLYPS1
	 CMP	  #0AEH
	 BCC	  PGM040	  ;- IF	 mario ground walk ?	( NO ; PGM010 )
	STZ	SRSTFG
;
PGM040	 EQU	  $
	 LDA	  CSINFG
	 CMP	  #5
	 BNE	  PGM090	  ;- IF	 end clac time score ?	( NO ; PLG120 )
;				  < Goto next set pros >
	 INC	  GOALCT	       ; INC  gorl counter
;
	 LDA	  GOALCT
	 CMP	  #3
	 BNE	  NXFIFS1	       ;- IF  frame 3 ?		( NO ; NXFIFS )
;
	 LDY	  CORSNO
	 LDA	  SCOCNT
	 CMP	  SCOCKD,Y
	 BCC	  NXFIFS1	       ;- IF  just coin ?	( NO ; NXFIFS )
;
	 INC	  SEMSFG		    ; See thru mushroom flag ON
NXFIFS1 EQU	$
		INC	CORSID			; Next frame information data & Flag set !
	 STZ	  PLOWXP	       ; Clear	Player on the way flag
	JSR	VSPLCK2			 ; PLAYER CHANGE
;
;#####################################################################
;#	 JSR	  NXFIFS    [ Next information data & flag set ]     #
;#####################################################################
NXFIFS	 EQU	  $
;;;;;;;;;;;;;	      INC      CORSID	      ; Next frame information data & Flag set !
;
	 JSL	  >RDCRDT		; Read course data
;
	 INC	  PLFSFG	       ; Player first start flag ON
;
	 JSR	  GMD0ST	       ; Set  Next frame displa mode
;
;;;;;	      LDA      #80H
;;;;;	      STA      0FCH		    ; Sound  BGM clear @@@@@@
;
PGM090	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  PLMOVE    [ Player moving process ]		     #
;#####################################################################
PLMOVE	 EQU	  $
;
	 LDA	  #00H
	 LDY	  PLSIZE
	 BNE	  PMV140	  ;- IF	 small player ?	      ( NO ; PMV140 )
;
	 LDA	  <PLSTAT
	 BNE	  PMV150	  ;- IF	 walk player ?	      ( NO ; PMV150 )
;
	 LDA	  <KEYUD
	 AND	  #00000100B
;
PMV140	 EQU	  $
	 STA	  PLSDFG	       ; Set  Sit down flag
;
PMV150	 EQU	  $
	 JSR	  PLMVVS	  ; Player move value set
;
	 LDA	  PLCHFG
	 BNE	  PMV300	  ;- IF	 mario change mode ?  ( YES ; PMV300 )
;
	 LDA	  <PLSTAT
	 CMP	  #PWIRE
	 BEQ	  PMV200	  ;- IF	 touch wire ?	      ( YES ; PMV200 )
;
	 LDY	  #PLLRMV
	 STY	  PLWMTM		    ; LF & RT move speed time set
;
PMV200		EQU	$
		ASL	A
		TAX
		JMP	(PMV200TBL,X)
;;;;;;;;		JSR	JSRSUB
PMV200TBL	EQU	$
PMV220		WORD	PLWKMV		     ; Player walk
PMV240		WORD	PLJSMV		     ;	      jump & swim
PMV260		WORD	PLDPMV		     ;	      drop
PMV280		WORD	PLWRMV		     ;	      tuch wire
;
PMV300	 EQU	  $
	 RTS
;
;#####################################################################
;#	 Player status value					     #
;#####################################################################
BWALK	 EQU	  (PMV220-PMV220)/2    ; Player walk
BJUMP	 EQU	  (PMV240-PMV220)/2    ;	jump & swim
BDROP	 EQU	  (PMV260-PMV220)/2    ;	drop
PWIRE	 EQU	  (PMV280-PMV220)/2    ;	tuch wire
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  PLWKMV    [ Player walk move ]		     #
;#####################################################################
PLWKMV	 EQU	  $
	 JSR	  PLCCTS	  ;   "    chara change time set
;
	 LDA	  <KEYLR
	 BEQ	  PLWM60
;
	 STA	  PLCMKI
;
PLWM60	 EQU	  $
	 JSR	  PLSPCL	       ; Player LF & RT move speed calc
	 JSR	  PLCLX0	       ;	   "    (x) pos calc
	 STA	  PLXMVL
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  PLDPMV    [ Player drop move ]		     #
;#####################################################################
PLDPMV	 EQU	  $
	 LDA	  WGPOWR
	 STA	  PLGPWR	       ; 'JUMP' off --- Down G power set
	 JMP	  PJSM60
;
;#####################################################################
;#	 JSR	  PLJSMV    [ Player jump & swiming move ]	     #
;#####################################################################
PLJSMV	 EQU	  $
	 LDY	  <YCALC0    ; Jump & Swim !
	 BPL	  PJSM10	  ;- IF	 jump down ?	     ( YES ; PJSM10 )
;
	 LDA	  <KEYAB
	 AND	  #10000000B
	 AND	  <WKEYUD
	 BNE	  PJSM20	  ;- IF	 repeat 'JUMP' ON ?  ( YES ; PJSM20 )
;
	 LDA	  STEP1
	 SEC
	 SBC	  PLYPS1
	 CMP	  PLJPLW
	 BCC	  PJSM20	  ;- IF	 must low jump ?     ( NO ; PJSM20 )
;
PJSM10	 EQU	  $
	 LDA	  WGPOWR
	 STA	  PLGPWR	       ; 'JUMP' off --- Down G power set
;
PJSM20	 EQU	  $
	 LDA	  PLSMFG
	 BEQ	  PJSM60    ;- IF  in water ?		     ( NO ; PJSM60 )
;
;			    < Swimming >
	 JSR	  PLCCTS	  ; Player chara change time set
;
	 LDA	  PLYPS1
	 CMP	  #14H
	 BCS	  PJSM50	  ;- IF	 water line ?	     ( NO ; PJSM50 )
;
	 LDA	  #018H
	 STA	  PLGPWR	       ; Water line over G-Power set
;
PJSM50	 EQU	  $
	 LDA	  <KEYLR
	 BEQ	  PJSM60
;
	 STA	  CMUKI
;
PJSM60	 EQU	  $
	 LDA	  <KEYLR
	 BEQ	  PJSM90    ;- IF  LF & RT key IN ?	     ( NO ; PJSM90 )
;
	 JSR	  PLSPCL	  ; Player LF & RT move speed calc
;
PJSM90	 EQU	  $
	 JSR	  PLCLX0	  ; Player LF & RT (x) pos calc
	 STA	  PLXMVL
;
	 LDA	  <PLCMOD
	 CMP	  #PLSF
	 BNE	  PJSMA0    ;- IF  fail player ?	     ( NO ; PJSMA0 )
;
	 LDA	  #28H
	 STA	  PLGPWR	  ; Fail G power
;
PJSMA0	 EQU	  $
	 JMP	  PLGCAL	  ; Jump calclate
;
;#####################################################################
;#	 JSR	  PLWRMV    [ Player tuch wire move ]		     #
;#####################################################################
PLLRMV	 EQU	  018H		  ; Player LF & RT move speed value !
;
PLWXMD	 EQU	  $		  ; Player move (x) data !
	 HEX	  0E,04		       ; Left  side --! Right side
	 HEX	  FC,F2		       ; Right side --! Left  side
;
	 HEX	  00,00
	 HEX	  FF,FF
;
PLWRMV	 EQU	  $
	 LDA	  PLYPS2	  ; Move up & down !
	 CLC
	 ADC	  PLYCL1
	 STA	  PLYPS2
;
	 LDY	  #0
	 LDA	  <PLYCL0
	 BPL	  PLWM20
;
	 DEY
;
PLWM20	 EQU	  $
	 STY	  <WORK
;
	 ADC	  PLYPS1
	 STA	  PLYPS1
;
	 LDA	  <PLYPS0
	 ADC	  <WORK
	 STA	  <PLYPS0
;
	 LDA	  <KEYLR	   ; Move left & right !
	 AND	  PLCRFG
	 BEQ	  PLWM90
;
	 LDY	  PLWMTM
	 BNE	  PLWM80	       ;- IF  LF & RT move time = 0 ?  ( NO ; PLWM80 )
;
	 LDY	  #PLLRMV
	 STY	  PLWMTM		    ; LF & RT move speed time set
;
PLWM30	 EQU	  $
	 LDX	  #0
	 LDY	  PLCMKI
	 LSR	  A
	 BCS	  PLWM40	       ;- IF  player muki=right ?  ( YES ; PLWM40 )
;
	LDA	PLOBJX
	CMP	#10H
	BCC	PLWM80
	 INX
	 INX
;
PLWM40	 EQU	  $
	 DEY
	 BEQ	  PLWM50	       ;- IF  move right ?	   ( YES ; PLWM50 )
;
	 INX
;
PLWM50	 EQU	  $		       ; Player move LF & RT pos calc !
	 LDA	  PLXPS1
	 CLC
	 ADC	  PLWXMD,X
	 STA	  PLXPS1
;
	 LDA	  <PLXPS0
	 ADC	  PLWXMD+4,X
	 STA	  <PLXPS0
;
	 LDA	  <KEYLR
	 EOR	  #00000011B
	 STA	  PLCMKI	       ; Chara muki set
;
PLWM80	 EQU	  $
	 RTS
;
PLWM90	 EQU	  $
	 STA	  PLWMTM	       ; Clear LF & RT move speed time
	 RTS
;
;#####################################################################
;#	 Player move value data					     #
;#####################################################################
GPWRD0	 EQU	  $	    ; Jump up G power !
	 HEX	  20		  ; Stop
	 HEX	  20,1E		  ; Walk
	 HEX	  28,28		  ; Run
;
SWMD	 HEX	  0D		  ; Swim
	 HEX	  04		  ; Swim on hole
;
GPWRD1	 EQU	  $	    ; Jump down G power !
	 HEX	  70		  ; Stop
	 HEX	  70,60		  ; Walk
	 HEX	  90,90		  ; Run
;
	 HEX	  0A		  ; Swim
	 HEX	  09		  ; Swim on hole
;
JPSPD0	 EQU	  $	    ; Jump step speed (H) !
	 HEX	  FC		  ; Stop
	 HEX	  FC,FC		  ; Walk
	 HEX	  FB,FB		  ; Run
;
	 HEX	  FE		  ; Swim
	 HEX	  FF		  ; Swim on hole
;
JPSPD1	 EQU	  $	    ; Jump step speed (L) !
	 HEX	  00		  ; Stop
	 HEX	  00,00		  ; Walk
	 HEX	  00,00		  ; Run
;
	 HEX	  80		  ; Swim
	 HEX	  00		  ; Swim on hole
;
;;;;;;JMPLWD   EQU	$	  < Jump must low (y) >
;;;;;;	       HEX	01
;;;;;;	       HEX	01,01
;;;;;;	       HEX	01,01
;
;			    < LF & RT move value >
WKLF	 EQU	  0E8H		       ; Walk  left  max speed
RNLF	 EQU	  0D8H		       ; Run
WKRT	 EQU	  018H		       ; Walk  right
RNRT	 EQU	  028H		       ; Run
WKSLW	 EQU	  WKRT/3+1	       ; Walk  slow limit
SWKL	 EQU	  0F0H		       ; In water walk left  max speed
SWKR	 EQU	  010H		       ;	       right
;
PLMSD0	 EQU	  $	    ; Player max speed left !
	 BYTE	  RNLF,WKLF	       ; Run,Walk
	 BYTE	  SWKL		       ; In water ( walk )
;
PLMSD1	 EQU	  $	    ; Player max speed right !
	 BYTE	  RNRT,WKRT	       ; Run,Walk
	 BYTE	  SWKR		       ; In water ( walk )
PAD	 BYTE	  0CH		       ; Game start auto walk
;
PLACLD	 EQU	  $	    ; Player accel data !
	 HEX	  E4,98,D0	       ; Low  Run,Walk,Run --! stop
;;;;;;	 HEX	  00,00,00	       : Hi
;
PWUDD0	 EQU	  $	    ; Player tuch wire UP & DW speed data !
	 HEX	  00		       ; Stop
	 HEX	  FF		       ; Up speed
	 HEX	  01		       ; Dw speed
;
PWUDD1	 EQU	  $
	 HEX	  00
	 HEX	  20
	 HEX	  FF
;
;#####################################################################
;#	 JSR	  PLMVVS    [ Player move value set ]		     #
;#####################################################################
PLMVVS	 EQU	  $
	 LDA	  <PLSTAT
	 CMP	  #PWIRE
	 BNE	  PLJPVS    ;- IF  tuch wire ?	( NO ; PLJPVS )
;
;#####################################################################
;#	 JSR	  PLWRVS    [ Player tuch wire value set ]	     #
;#####################################################################
PLWRVS	 EQU	  $
	 LDY	  #0
	 LDA	  <KEYUD
	 AND	  PLCRFG
	 BEQ	  PLWR30	  ;- IF	 in key up or down ?	( NO ; PLWR30 )
;
	 INY
	 AND	  #00001000B
	 BEQ	  PLWR25	  ;- IF	 in key up ?		( YES ; PLWR25 )
	LDA	<FMCNT
	AND	#00000111B
	BNE	PLWR30
	LDA	#30H
	STA	!SOUND0
	BRA	PLWR30
;
PLWR25	EQU	$
	 INY
;
PLWR30	 EQU	  $		  ; Player UP & DW value set !
	 LDX	  PWUDD1,Y
	 STX	  PLYCL1
;
	 LDA	  #8		  ; Player chara change time set !
	 LDX	  PWUDD0,Y
	 STX	  <PLYCL0
	 BMI	  PLWR70	       ;- IF  player up move ?	( YES ; PLWR70 )
;
	 LSR	  A
;
PLWR70	 EQU	  $
	 STA	  PLCHTV	       ; Chara change time value set
;
	 RTS
;
;#####################################################################
;#	 JSR	  PLJPVS    [ Player jump value set ]		     #
;#####################################################################
PLJPVS	 EQU	  $
	 LDA	  PLSPON
	 BNE	  PLJS10	  ;- IF	 on jump borad ?     ( YES ; PLSJ10 )
;
	 LDA	  <KEYAB
	 AND	  #10000000B
	 BEQ	  PLJS10	  ;- IF	 'A' ON ?	     ( NO ; PLJS10 )
;
	 AND	  <WKEYUD
	 BEQ	  PLJS20	  ;- IF	 before 'JUMP' IN ?  ( NO ; PLJS20 )
;
PLJS10	 EQU	  $
	 JMP	  PLJS90
;
PLJS20	 EQU	  $
	 LDA	  <PLSTAT
;;;;;  ( CMP	  #BWALK )
	 BEQ	  PLJS30	  ;- IF	 now walk ?	     ( YES ; PLJS30 )
;
	 LDA	  PLSMFG
	 BEQ	  PLJS10	  ;- IF	 now swim ?	     ( NO ; PLJS10 )
;
	 LDA	  PLATM
	 BNE	  PLJS30	  ;- IF	 'A' no continue ?   ( YES ; PLJS30 )
;
	 LDA	  <YCALC0
	 BPL	  PLJS30	  ;- IF	 jump down ?	     ( YES ; PLJS30 )
	 JMP	  PLJS90
;
PLJS30	 EQU	  $		  ; Initial jump pros !
	 LDA	  #20H
	 STA	  PLATM		       ; 'A' no continue check time set
;
	 LDY	  #0
	 STY	  PLYPS2
	 STY	  YCALC1
;
	 LDA	  <PLYPS0
	 STA	  STEP0
;
	 LDA	  PLYPS1
	 STA	  STEP1		       ; STEP1 <-- Jump step (y) position
;
	 LDA	  #BJUMP
	 STA	  <CSTAT		; Jump flag set
;
	 LDA	  XSPLV
	 CMP	  #WKRT/3+1
	 BCC	  PLJS50
;
	 INY
	 CMP	  #WKRT/2+4
	 BCC	  PLJS50
;
	 INY
	 CMP	  #WKRT+1
	 BCC	  PLJS50
;
	 INY
	 CMP	  #WKRT+(RNRT-WKRT)/2-4
	 BCC	  PLJS50
;
	 INY
;
PLJS50	 EQU	  $
;;;;;; ( LDA	  JMPLWD,Y )
	 LDA	  #1
	 STA	  PLJPLW	       ; Jump must low (y) level set
;
	 LDA	  PLSMFG
	 BEQ	  PLJS55	       ;- IF  now swiming ?	      ( NO ; PLJS55 )
;
	 LDY	  #SWMD-GPWRD0
	 LDA	  ONWLFG
	 BEQ	  PLJS55	       ;- IF  swim on hole ?	      ( NO ; PLJS55 )
;
	 INY
;
PLJS55	 EQU	  $
	 LDA	  GPWRD0,Y
	 STA	  PLGPWR	       ; Jump up G power set
;
	 LDA	  GPWRD1,Y
	 STA	  WGPOWR	       ; Jump down G powr set
;
	 LDA	  JPSPD1,Y
	 STA	  PLYCL1	       ; Jump step speed (L) set
;
	 LDA	  JPSPD0,Y
	 STA	  <PLYCL0		; Jump step speed (H) set
;
	 LDA	  PLSMFG
	 BEQ	  PLJS70	       ;- IF  in water ?	      ( NO ; PLJS70 )
;
	 LDA	  #0EH
	 STA	  !SOUND0		       ; Swim sound set @@@@@@
;
	 LDA	  PLYPS1
	 CMP	  #14H
	 BCS	  PLJS90	       ;- IF  water line over ?	      ( NO ; PLJS90 )
;
	STZ	<YCALC0			; Water line over step speed step speed set
	BRA	PLJS90
;
PLJS70	 EQU	  $		  ; Jump sound set !
	 LDA	  #01
;;;T;;	      LDY      PLSIZE
;;;T;;	      BEQ      PLJS80		    ;- IF  big mario ?	( YES ; PLJS80 )
;;;T;;
;;;T;;PLJS80   EQU	$
	 STA	  !SOUND1	;0FFH		      ; Jump sound set	@@@@@@
;
PLJS90	 EQU	  $
;
;#####################################################################
;#	 JSR	  PLLRVS    [ Player left & right value set ]	     #
;#####################################################################
PLLRVS	 EQU	  $
	 LDY	  #0
	 STY	  <WORK
;
	 LDA	  <PLSTAT
;;;;;  ( CMP	  #BWALK )
	 BEQ	  MLRF50	  ;- IF	 walk ?			      ( YES ; MLRF50 )
;
	 LDA	  XSPLV		  ; Jump move value set check !
	 CMP	  #WKRT+1
	 BCS	  MLRF80	       ;- IF  hi jump power ?	      ( YES ; MLRF80 )
	 BCC	  MLRF60
;
MLRF50	 EQU	  $		  ; Walk & Run move value set check !
	 INY
	 LDA	  <ENVRFG
	 BEQ	  MLRF60	       ;- IF  in water ?	      ( YES ; MLRF60 )
;
	 DEY
	 LDA	  <KEYLR
	 CMP	  <MMUKI
	 BNE	  MLRF60	       ;- IF  move muki = key muki ?  ( NO ; MLRF60 )
;
	 LDA	  <KEYAB
	 AND	  #01000000B
	 BNE	  MLRF75	       ;- IF  'B' ON ?		      ( YES ; MLRF75 )
;
	 LDA	  PLBTM
	 BNE	  MLRF80	       ;- IF  countinue 'B' ON ?      ( YES ; MLRF80 )
;
MLRF60	 EQU	  $		  ; 'B' off pros !
	 INY
	 INC	  <WORK
;
	 LDA	  MXSPFG
	 BNE	  MLRF70	       ;- IF  run --! stop ?	 ( YES : MLRF70 )
;
	 LDA	  XSPLV
	 CMP	  #WKRT+(RNRT-WKRT)/2+1
	 BCC	  MLRF80	       ;- IF  max speed ?	 ( NO ; MLRF80 )
;
MLRF70	 EQU	  $
	 INC	  <WORK
	 BRA	  MLRF80
;;K;;	      JMP      MLRF80
;
MLRF75	 EQU	  $		  ; 'B' on pros !
	 LDA	  #0AH
	 STA	  PLBTM		       ; 'B' ON continue time set
;
MLRF80	 EQU	  $
;#####################################################################
;#		     (X) -- Index				     #
;#		     (Y) -- Data index ( Max speed )		     #
;#		    WORK --   "    "   ( Accel )		     #
;#	 JSR	  MVLRDS    [ Move LF & RT value data set ]	     #
;#####################################################################
MVLRDS	EQU	$
	LDA	PLMSD0,Y
	STA	MXXSPL			; Left max speed set
;
	LDA	<PLCMOD
	CMP	#PLSMMD
	BNE	MLRS30			; IF player game start mode ?  ( NO ; MLRS30 )
;
	LDY	#PAD-PLMSD1
;
MLRS30	EQU	$
	LDA	PLMSD1,Y
	STA	MXXSPR			; Right max speed set
;
	LDY	<WORK
	LDA	PLACLD,Y
	STA	ACLPW1			; Player accel value (L) set
;
;;;;;; ( LDA	  PLACLD+3,Y )
	STZ	ACLPW0			;    "   accel value (H) set
;
	LDA	PLCMKI
	CMP	<PLMMKI
	BEQ	MVL100			; IF now slip ?	      ( NO ; MVL100 )
;
	ASL	ACLPW1
	ROL	ACLPW0			; Player accel value (H),(L) * 2
;
MVL100	EQU	$
	RTS
;
;#####################################################################
;#	 Player move value data	  [ Chara change time ]		     #
;#####################################################################
PLCTMD	 EQU	  $	    ; Player chara change time !
	 HEX	  02,04,07	  ; Run,Walk,Slow walk
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  PLCCTS    [ Player chara change time set ]	     #
;#####################################################################
PLCCTS	 EQU	  $
	 LDY	  #0
	 LDA	  XSPLV
	 CMP	  #WKRT+4
	 BCS	  PLCT30	  ;- IF	 run speed ?	    ( YES ; PLCT30 )
;
	 INY
	 CMP	  #WKRT/2+2
	 BCS	  PLCT20	  ;- IF	 slow walk speed ?  ( NO ; PLCT20 )
;
	 INY
;
PLCT20	 EQU	  $
	 LDA	  KEYA1
	 AND	  #01111111B
	 BEQ	  PLCT70	  ;- IF	 any key IN ?	    ( NO ; PLCT70 )
;
	 AND	  #00000011B
	 CMP	  <MMUKI
	 BNE	  PLCT50	  ;- IF	 now slip ?	    ( YES ; PLCT50 )
;
	 LDA	  #0
;
PLCT30	 EQU	  $
	 STA	  MXSPFG	       ; Run max speed flag set
	 BRA	  PLCT70
;;K;;	      JMP      PLCT70
;
PLCT50	 EQU	  $
	 LDA	  XSPLV
	 CMP	  #WKRT/2-1
	 BCS	  PLCT70	  ;- IF	 must slow walk speed ?	 ( NO ; PLCT20 )
;
	 LDA	  PLCMKI	  ; Must slow walk muki change !
	 STA	  <PLMMKI
;
;;K;;	      LDA      #0
;;K;;	      STA      <PLXSD0
;;K;;	      STA      PLXSD1
	 STZ	  <PLXSD0
	 STZ	  PLXSD1
;
PLCT70	 EQU	  $
	 LDA	  PLCTMD,Y
	 STA	  PLCHTV	       ; Chara change time value set
;
PLCT90	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#		     (A) -- Left & Right key data		     #
;#	 JSR	  PLSPCL    [ Player LF & RT move speed calc ]	     #
;#####################################################################
PLSPCL	 EQU	  $
	 AND	  CRFLG
;;K;;	      CMP      #0
	 BNE	  PMSC40    ;- IF  LF or RT key IN ?   ( YES ; PMSC40 )
;
PMSC30	 EQU	  $	    ; Speed down calc !
	 LDA	  <XSPED0
	 BEQ	  PMSC90	  ;- IF	 now stop ?	     ( YES ; PMSC90 )
	 BPL	  PMSC70	  ;- IF	 now right moving ?  ( YES ; PMSC70 )
	 BMI	  PMSC50
;
PMSC40	 EQU	  $	    ; Speed up calc !
	 LSR	  A
	 BCC	  PMSC70	  ;- IF	 move left ?   ( YES ; CLCX10 )
;
PMSC50	 EQU	  $
	 LDA	  XSPED1	       ; Right speed up
	 CLC
	 ADC	  ACLPW1
	 STA	  XSPED1
;
	 LDA	  <XSPED0
	 ADC	  ACLPW0
	 STA	  <XSPED0
;
	 CMP	  MXXSPR
	 BMI	  PMSC80	  ;- IF	 right max speed ?  ( NO ; PMSC80 )
;
	 LDA	  MXXSPR	       ; Right max speed set
	 STA	  <XSPED0
	 BRA	  PMSC90
;;K;;	      JMP      PMSC90
;
PMSC70	 EQU	  $
	 LDA	  XSPED1	       ; Left speed up
	 SEC
	 SBC	  ACLPW1
	 STA	  XSPED1
;
	 LDA	  <XSPED0
	 SBC	  ACLPW0
	 STA	  <XSPED0
;
	 CMP	  MXXSPL
	 BPL	  PMSC80	  ;- IF	 left max speed ?   ( NO ; PMSC80 )
;
	 LDA	  MXXSPL		; Left max speed set
	 STA	  <XSPED0
;
PMSC80	 EQU	  $	    ; XSPLV <-- (x)speed level set !
	 CMP	  #0
	 BPL	  PMSC90
;
	 EOR	  #0FFH
	 CLC
	 ADC	  #1
;
PMSC90	 EQU	  $
	 STA	  XSPLV
	 RTS
;
;#####################################################################
;#	 JSR	  PLTOOL    [ Player tool chara main ]		     #
;#####################################################################
PLTOOL	 EQU	  $		   ; Player fire !
	 LDA	  POWLEV
	 CMP	  #2
	 BCC	  PLTL40	       ; Super Mario ?
;
	 LDA	  <KEYAB		; Yes !
	 AND	  #01000000B
	 BEQ	  PLTL30	       ; "B" Button on ?
;				       : Yes !
	 AND	  <WKEYUD
	 BNE	  PLTL30	       ; Repeat "B" on ?
;
	 LDA	  FICNT
	 AND	  #00000001B
	 TAX
	 LDA	  <FISTAT,X
	 BNE	  PLTL30	       ;- IF fire move ?	   ( YES ; PLTL30 )
;
	 LDY	  <PLYPS0
	 DEY
	 BNE	  PLTL30	       ;- IF  in frame player ?	   ( NO ; PLTL30 )
;
	 LDA	  PLSDFG
	 BNE	  PLTL30	       ;- IF  sit down player ?	   ( YES ; PLTL30 )
;
	 LDA	  <PLSTAT
	 CMP	  #PWIRE
	 BEQ	  PLTL30	       ;- IF  up on wood player ?  ( YES ; PLTL30 )
;
	 LDA	  #6H
	 STA	  !SOUND3		  ; <S! Fire sound
;
	 LDA	  #2
	 STA	  <FISTAT,X
;
	 LDY	  PLCHTV
	 STY	  PLFTFG	       ; Player fire thru flag ON
	 DEY
	 STY	  PLCHTM	       ;	chara change timer
;
	 INC	  FICNT
;
PLTL30	 EQU	  $
	 LDX	  #0
	 JSR	  FIMOVE	       ; Fire move 1
;
	 LDX	  #1
	 JSR	  FIMOVE	       ; Fire move 2
;
PLTL40	 EQU	  $
	 LDA	  <ENVRFG
	 BNE	  PLTL90	  ;- IF	 underwater ?  ( NO ; PLTL90 )
;				  < Player bubble >
	 LDX	  #2
;
PLTL60	 EQU	  $
	 STX	  <INDEX
;
	 JSR	  PLBLMV	       ; Bubble move
	 JSR	  BLPSCV	       ;   "   position convert
	 JSR	  BLFRCK	       ;   "   frame side check
	 JSL	  >PLBLCT		; Bubble chara set
	 DEX
	 BPL	  PLTL60
;
PLTL90	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  FIMOVE    [ FIRE move	 ]			     #
;#####################################################################
FISPDT	 EQU	  $
	 HEX	  40,C0
;
FIMOVE	 EQU	  $
	 STX	  <INDEX
;
	 LDA	  <FISTAT,X
	 ASL	  A
	BCC	FMX010
	 JMP	  FIEXPL	  ; Fire Hit On ?     ; YES (FIEXPL)
FMX010	EQU	$
;
	 LDY	  <FISTAT,X
	BNE	FMX020
	 JMP	  FIMRET	  ; Fire shot Ok ?
FMX020	EQU	$
	 DEY
	 BEQ	  FIMV50
;
	 LDA	  XPOS1		  ; No !  (Shot initial)
;;;;	 CLC
	 ADC	  #4
	 STA	  FIXPS1,X
;
	 LDA	  <XPOS0
	 ADC	  #0
	 STA	  <FIXPS0,X
;
	 LDA	  PLYPS1
	 STA	  FIYPS1,X
;
	 LDA	  #1
	 STA	  <FIYPS0,X
;
;;;	 LSR	  A		       : A <-- #0
;;;	 STA	  FIYCL1,X
;
	 LDY	  CMUKI
	 DEY
	 LDA	  FISPDT,Y
	 STA	  <FIXSD0,X
;
	 LDA	  #4
	 STA	  <FIYCL0,X
;
	 LDA	  #FICMD
	 STA	  FICSMD,X
;
	 DEC	  <FISTAT,X	   ; Shot flag on !
FIMV50	 EQU	  $
	 TXA
	 CLC
	 ADC	  #FIXPS0-XPOS0
	 TAX
;
	 LDA	  #50H
	 STA	  <WORK		   ; G power
;
	 LDA	  #3		  ; Max dot
	 STA	  <WORK+2
;
	 LDA	  #0
;--- Move -------------------------------------
	 JSR	  GCALC		  ; y move.
	 JSR	  CALCX0	  ; x move.
;---------------------------------------------
	 LDX	  <INDEX
;
	 JSR	  FIPSCV	  ; Fire  position convert
	 JSR	  FIFRCK	  ;   "   frame side check
	 JSR	  FICRDS	  ; Cross data set.
	 JSR	  CRFIBG	  ; Cross BG check
;
	 LDA	  FIFMSD
	 AND	  #11111100B
	BEQ	FISK20
	AND	#11110000B
	BNE	FIMEND
;
	LDA	FIXSD0,X
	BMI	FISK10
	 LDA	  FIFMSD
	AND	#00001111B
	CMP	#0FH
	BEQ	FIMEND
	BRA	FISK30
FISK10	EQU	$
	LDA	FIFMSD
	AND	#0CH
	CMP	#0CH
	BEQ	FIMEND
	BRA	FISK30
FISK20	EQU	$
;
	 JSR	  CRFIEN	  ; Cross Enemy check
FISK30	EQU	$
	 JMP	  FICST1	  ; Character set.
;
FIMEND	 EQU	  $		  ; Yes !
	 LDA	  #0
	 STA	  <FISTAT,X	   ; Shotting flag off.
FIMRET	 EQU	  $
	 RTS
;
FIEXPL	 EQU	  $
	 JSR	  FIPSCV	  ; Fire  position convert
	 JMP	  FICST2	  ; Expling  fire display
;
;#####################################################################
;#		     (X) -- Bubble Index			     #
;#	 JSR	  PLBLMV    [ Player bubble move ]		     #
;#####################################################################
PLBLMV	 EQU	  $
	 LDA	  RDM+1,X
	 AND	  #00000001B
	 STA	  <WORK+7
;
	 LDA	  BLYPS1,X
	 CMP	  #0F8H
	 BNE	  PLBLPC	  ;- IF	 no display bubble ?   ( NO ; PLBLPC )
;
	 LDA	  PLBLTM
	 BNE	  PLBL90	  ;- IF	 out OK next bubble ?  ( NO ; PLBL90 )
;
;#####################################################################
;#		     (X) -- Bubble Index			     #
;#	 JSR	  PLBLPS    [ Player bubble position set ]	     #
;#####################################################################
PLBLPS	 EQU	  $
	 LDY	  #0		  ; Init !
	 LDA	  PLCMKI
	 LSR	  A
	 BCC	  PLBS10	       ;- IF  player muki = right ?  ( NO ; PLBS10 )
;
	 LDY	  #8
;
PLBS10	 EQU	  $
	 TYA
	 ADC	  PLXPS1
	 STA	  BLXPS1,X	       ; Set  Bubble (x) pos (L)
;
	 LDA	  <PLXPS0
	 ADC	  #0
	 STA	  <BLXPS0,X		; Set  Bubble (x) pos (H)
;
	 LDA	  PLYPS1
	 CLC
	 ADC	  #8
	 STA	  BLYPS1,X	       ; Set  Bubble (y) pos (L)
;
	 LDA	  #1
	 STA	  <BLYPS0,X		; Set  Bubble (y) pos (H)
;
	 LDY	  <WORK+7
	 LDA	  BLOTTM,Y
	 STA	  PLBLTM	       ; Set  Next bubble out time
;
;#####################################################################
;#	 JSR	  PLBLPC    [ Player bubble position calc ]	     #
;#####################################################################
PLBLPC	 EQU	  $		  ; Up bubble !
	 LDY	  <WORK+7
	 LDA	  BLYPS2,X
	 SEC
	 SBC	  BLMVVL,Y
	 STA	  BLYPS2,X
;
	 LDA	  BLYPS1,X
	 SBC	  #0
	 CMP	  #20H		  ; End check !
	 BCS	  PLBL80	       ;- IF  water face ?  ( NO ; PLBL80 )
;
	 LDA	  #0F8H			    ; Erase  Bubble
;
PLBL80	 EQU	  $
	 STA	  BLYPS1,X
;
PLBL90	 EQU	  $
;
	 RTS
;
BLMVVL	 EQU	  $	    ; Bubble move value !
	 HEX	  FF,50
;
BLOTTM	 EQU	  $	    ; Bubble out time !
	 HEX	  40,20
;
;---------------------------------------------------------------------<< Information routine
;#####################################################################
;#	 JSR	  PLYTIM    [ Play limit time calc ]		     #
;#####################################################################
PLYTIM	 EQU	  $
	 LDA	  SYMODE
	 BEQ	  PLTMRT
;
	 LDA	  <PLCMOD
	 CMP	  #TIMEMD
	 BCC	  PLTMRT	  ; Timer calc ok ?
;
	 CMP	  #PLSF
	 BEQ	  PLTMRT
;
	 LDA	  <PLYPS0
	 CMP	  #2
	 BPL	  PLTMRT
;
	 LDA	  TMES6		  ; yes !
	 BNE	  PLTMRT
;
	 LDA	  PLYTM0-1
	 ORA	  PLYTM0
	 ORA	  PLYTM1
	 BEQ	  PLTM20	  ; Time 0 ?  Yes =! PLTM20
;
PLTM10	 EQU	  $		  ; No.
	 LDY	  PLYTM0-1
	 DEY
	 BNE	  PLTM15
;
	 LDA	  PLYTM0	  ; Timer = 100 ?
	 ORA	  PLYTM1
	 BNE	  PLTM15
;				  : Yes !
	 LDA	  #0FFH
	 STA	  !SOUND0      ; <S! : Time up BGM start
;
PLTM15	 EQU	  $
	 LDA	  #18H
	 STA	  TMES6
;
	 LDY	  #35
	 LDA	  #0FFH
	 STA	  WPOIN+5
	LDA	NUTS
	BNE	TIMESP
	 JSR	  CAINC		  ;Timer dec. (-1)
TIMESP	EQU	$
;
	 LDA	  #0A4H
	 JMP	  SCHEG		  ;time display
;
PLTM20	 EQU	  $
;;;;;	 LDA	  #PLMDFL
;;;;;	 LDA	  #PLSF
;;;;;	 STA	  CMODE		  : Fail player
;
;;;;;	 LDA	  #0
	 STA	  POWLEV
	 JSR	  HEDC15
;
	 INC	  TMUPFG	  ; Time up flag ON
;
PLTMRT	 EQU	  $
NOT110	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  NOTRMV1     * NOTHING TR MOVE 1		     #
;#		    Scrool stop check				     #
;#####################################################################
NOTRMV1	 EQU	  $
	 LDA	  SRSTFG
	 BEQ	  PLTMRT	  ; Scrool stopping ?
;				  : yes !
	 LDA	  PLYPS1
	 AND	  <PLYPS0
	 BNE	  PLTMRT	  ; Player Y pos = 0 ?
;
	 STA	  SRSTFG	  ; yes !
	 INC	  CMSLFG	  ; Chimney  select flag
;
	 JMP	  ENCLER
;
;---------------------------------------------------------------------<< Exstra chara routine
;*********************************************************************
;*	 Whirlpool move				   (WHPLMV)	     *
;*********************************************************************
WHPLMV	 EQU	  $
	 LDA	  <ENVRFG
	 BNE	  WHPLM50     ;sea ?
;			      ;yes
	 STA	  ONWLFG      ;flag off
;
		JSL	>HDMAMV
;
	 LDA	  GMSTTM
	 BNE	  WHPLM50     ;player ok ?
;			      ;yes
	 LDY	  #04H
WHPLM20	 EQU	  $
	 LDA	  WHPLX1,Y
	 CLC
	 ADC	  WHPLX2,Y
	 STA	  <WORK+2
	 LDA	  WHPLX0,Y
	 BEQ	  WHPLM40     ;check ok ?
;			      ;yes
	 ADC	  #00H
	 STA	  <WORK+1      ;right side data work set
;
	 LDA	  PLXPS1
	 SEC
	 SBC	  WHPLX1,Y
	 LDA	  <PLXPS0
	 SBC	  WHPLX0,Y
	 BMI	  WHPLM40     ;left side ok ?
;			      ;yes
	 LDA	  <WORK+2
	 SEC
	 SBC	  PLXPS1
	 LDA	  <WORK+1
	 SBC	  <PLXPS0
	 BPL	  WHPLM60     ;right side ok ?
;			      ;no
WHPLM40	 EQU	  $
	 DEY
	 BPL	  WHPLM20     ;end ?
;			      ;yes
WHPLM50	 EQU	  $
	 RTS
;
WHPLM60	 EQU	  $
	 LDA	  WHPLX2,Y
	 LSR	  A
	 STA	  <WORK
	 LDA	  WHPLX1,Y
	 CLC
	 ADC	  <WORK
	 STA	  <WORK+1
	 LDA	  WHPLX0,Y
	 ADC	  #00H
	 STA	  <WORK
;
	 LDA	  <FMCNT
	 LSR	  A
	 BCC	  WHPLM120    ;frame ok ?
;			      ;yes
	 LDA	  <WORK+1
	 SEC
	 SBC	  PLXPS1
	 LDA	  <WORK
	 SBC	  <PLXPS0
	 BPL	  WHPLM80     ;player > ?
;			      ;no
	 LDA	  PLXPS1
	 SEC
	 SBC	  #01H
	 STA	  PLXPS1
	 LDA	  <PLXPS0
	 SBC	  #00H
	 JMP	  WHPLM100
;
WHPLM80	 EQU	  $
	 LDA	  PLCRFG
	 LSR	  A
	 BCC	  WHPLM120    ;wall cross ?
;			      ;no
	 LDA	  PLXPS1
	 CLC
	 ADC	  #01H
	 STA	  PLXPS1
	 LDA	  <PLXPS0
	 ADC	  #00H
WHPLM100 EQU	  $
	 STA	  <PLXPS0      ;player x-pos. replace
;
WHPLM120 EQU	  $
	 LDA	  #10H
	 STA	  <WORK
	 LDA	  #01H
	 STA	  ONWLFG      ;flag on
	 STA	  <WORK+2
	 LSR	  A
	 TAX
	 JMP	  GCALC	      ;G-calc.
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  GLFGMV    [ Goul Flag Move ]			     #
;#####################################################################
GLPONT	 EQU	  $
	 HEX	  05	    ; 5000
	 HEX	  02	    ; 2000
	 HEX	  08	    ;  800
	 HEX	  04	    ;  400
	 HEX	  01	    ;  100
;
GLPONT2	 EQU	  $
	 HEX	  03	    ; 5000
	 HEX	  03	    ; 2000
	 HEX	  04	    ;  800
	 HEX	  04	    ;  400
	 HEX	  04	    ;  100
;
GLFGMV	 EQU	  $
	 LDX	  #5
	 STX	  <INDEX
;
	 LDA	  <ENMYNO,X
	 CMP	  #GFLG
	BEQ	GLFG00
	JMP	GLFG90		;(RETURN)
;;K;;	      BNE      GLFG90	 ;(RETURN)
;
GLFG00	EQU	$
	 LDA	  <PLCMOD
	 CMP	  #PLTPMD
	 BNE	  GLFGR0
;
	 LDA	  <PLSTAT
	 CMP	  #PWIRE
	 BNE	  GLFGR0
;
	 LDA	  ENYPS1,X
	 CMP	  #0AAH
	 BCS	  GLFGR1
;
	 LDA	  PLYPS1
	 CMP	  #0A2H
	 BCS	  GLFGR1
;
	 LDA	  ENYPS2,X
;;;;;	 ADC	  PLYCL1
	 ADC	  #0FFH
	 STA	  ENYPS2,X
;
	 LDA	  ENYPS1,X
;;;;;	 ADC	  PLYCL0
	 ADC	  #1
	 STA	  ENYPS1,X
;
	 LDA	  GLSCY2
;;;;;	 LDA	  BKYPS2
	 SEC
;;;;;;	 SBC	  PLYCL1
	 SBC	  #0FFH
	 STA	  GLSCY2
;;;;;	 STA	  BKYPS2
;
	 LDA	  GLSCY1
;;;;;;	 SBC	  PLYCL0
	 SBC	  #1
	 STA	  GLSCY1
;;;;;;	 STA	  BKYPS1
GLFGR0	 EQU	  $
	 BRA	  GLFG10
;;K;;	      JMP      GLFG10
;
GLFGR1	 EQU	  $
	 LDY	  GLSCRE
	 LDA	  GLPONT,Y
	 LDX	  GLPONT2,Y
	 STA	  WPOIN,X
;
	 JSR	  BKSCUP
;;	(LDX	  INDEX)
;
	 LDA	  #PLCRMD
	 STA	  <PLCMOD
;;;
	LDA	#0CH
	STA	!SOUND2
	LDA	PLCMKI
	AND	#2
	BNE	GLF005
	LDA	#6EH
	BRA	GLF009
GLF005	EQU	$
	LDA	#60H
GLF009	EQU	$
	STA	PLMVXP
	LDA	PLXPS1
	STA	PEXPS1
	LDA	<PLXPS0
	STA	PEXPS0
	LDA	#20H
	STA	PLFDMV
	STA	PESTFG
;;;
	LDA	#20H
	STA	PLFDMV
	STA	PESTFG
;
GLFG10	 EQU	  $
	 JSR	  ENFRCK
	 JSR	  ENPSCV
	 JSL	  >GFCSET
;
GLFG90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  SPRING    [ Spring move     ]			     #
;#####################################################################
SPDATA	 EQU	  $
	 HEX	  08,10,08,00
;
SPRING	 EQU	  $
	 JSR	  ENFRCK	  ; The fist frame check
;
	 LDA	  GMSTTM
	 BNE	  SPM040
;
;;	 LDA	  ENFMSD
;;	 BNE	  SPM050
;
;---- Move main--------
	 LDA	  PLSPON
	 BEQ	  SPM040
;
	 TAY
	 DEY
	 TYA
	 AND	  #00000010B
	 BNE	  SPM010
	 INC	  YPOS1
	 INC	  YPOS1
	 JMP	  SPM020
SPM010	 EQU	  $
	 DEC	  YPOS1
	 DEC	  YPOS1
;
SPM020	 EQU	  $
	 LDA	  <ENCTPS,X
	 CLC
	 ADC	  SPDATA,Y
	 STA	  ENYPS1,X
;
;;;;;;	 JSR	  SPGCLC	  : Jump G power Calclate
;SPGCLC	  EQU	   $
	 CPY	  #1
	 BCC	  SPM035
;				       : Jumping timing ?
	 LDA	  <KEYAB		; Yes !
	 AND	  #10000000B
	 BEQ	  SPM035	       ; "A" Button on ?
;				       : Yes !
	 AND	  <WKEYUD
	 BNE	  SPM035	       ; Repeat "B" on ?
;
	 LDA	  #0F4H		       ; No !  High jump
	 STA	  SPGPWR
SPM035	 EQU	  $
;
	 CPY	  #3
	 BNE	  SPM040
;
	 LDA	  SPGPWR
	 STA	  <YCALC0
;
	STZ	PLSPON
;;;;;	      LDA      #0
;;;;;	      STA      PLSPON
	LDA	#8
	STA	!SOUND3
;
SPM040	 EQU	  $
	 JSR	  ENPSCV
;;;;;	 JSR	  SPCSET
	 JSR	  ENCSET
	 JSR	  ENLDWY
;
	 LDA	  PLSPON
	 BEQ	  SPM050
;
	 LDA	  TMES5
	 BNE	  SPM050
	 LDA	  #4
	 STA	  TMES5
;
	 INC	  PLSPON
SPM050	 EQU	  $
	 RTS
;
;
;#####################################################################
;#		     (Y) -- Index   block			     #
;#		     (X) -- Index   Wood			     #
;#	 JSR	  WDINIT    [ Wood initial set ]		     #
;#####################################################################
WDINIT	 EQU	  $
	 LDA	  #BWOD
	 STA	  <ENMYNO,X
;
	 LDA	  #1
	 STA	  <ENCMOD,X
;
	 LDA	  BKXPS0,Y			 ; Max 2 Times
	 STA	  <ENXPS0,X
;
	 LDA	  BKXPS1,Y
	 STA	  ENXPS1,X
;
	 LDA	  BKYPS1,Y
	BNE	WDI005
	LDA	#0F0H
WDI005	EQU	$
	 STA	  ENYPS1,X
WDI007	EQU	$
	 LDY	  WDPONT
	 BNE	  WDI010
	 STA	  WDMAPS	  ; Main position
;;T;;
;	 LDA	  WDMAPS
;	 BNE	  WDI010
;	 LDA	  #0F0H
;	 STA	  WDMAPS
;;T;;
WDI010	 EQU	  $
	 TXA
	 STA	  WDUSED,Y	  ; Use index store
;
	 INC	  WDPONT
;
	 LDA	  #03H
	 STA	  !SOUND3      ; <S!   Wood sound
	 RTS
;
;#####################################################################
;#		     (x) -- Index				     #
;#	 JSR	  WDMOVE    [ Wood initial set ]		     #
;#####################################################################
WDLIMT	 EQU	  $
	 HEX	  60,90		;50,60
;
WDMOVE	 EQU	  $
	 CPX	  #WDXPS0-ENXPS0
	 BEQ	  WDM010
;
	 RTS
;
;--- Wood Move---
WDM010	 EQU	  $
	LDA	WDSTFG
	BNE	WDM015
	LDA	WDLIMT+1
	BRA	WDM020
WDM015	EQU	$
	LDA	WDLIMT
WDM020	EQU	$
	CMP	WDLONG
	 BEQ	  WDM030
;
	 LDA	  <FMCNT
	 LSR	  A
	 BCC	  WDM030
;
	 LDA	  WDYPS1
	 SBC	  #1
	 STA	  WDYPS1
;
	 INC	  WDLONG
;
WDM030	 EQU	  $
	 LDA	  WDLONG
	 CMP	  #8H
	 BCC	  WDMEND	  ; display ok ?
;				  : Yes !
;--------------------------
	 JSR	  ENPSCV
	 JSR	  ENFRCK
;--------------------------
;
	 LDY	  #0
WDM050	 EQU	  $
;--------------------------
	 JSL	  >WDCSET
;--------------------------
;
	 LDA	  ENFMSD
	 AND	  #00001111B
	CMP	#0FH
	 BNE	  WDM070	  ; Display out ?
;	  BEQ	   WDM070	   ; Display out ?
;
WDM060	 EQU	  $
	 LDX	  #9
	 JSR	  ENCLER
	 STA	  WDPONT
	 STA	  WDLONG
;
WDM070	 EQU	  $
	 LDA	  WDLONG
	 CMP	  #20H
	 BCC	  WDMEND
;
	 LDX	  #WDXPS0-XPOS0
	 LDA	  #1
	 LDY	  #1BH	; (#CRBD04-CRBD00)
;-------------------------------------
	 JSR	  CRBGCK
;-------------------------------------
	 LDY	  <WORK+2
	 CPY	  #0D0H
	 BCS	  WDMEND	  ; No Data ?
;				  : Yes !
		LDA     !WDSTFG		;bug (Ver.up)/H5.7.8
		BNE     WDMLOP		;bug (Ver.up)/H5.7.8
		TYA			;bug (Ver.up)/H5.7.8
		BMI     WDMEND		;bug (Ver.up)/H5.7.8
;
WDMLOP          EQU     $		;bug (Ver.up)/H5.7.8
	 LDA	  (<WORK+6),Y
	 BNE	  WDMEND
;
	 LDA	  #WOOD0
	 STA	  (<WORK+6),Y
;
WDMEND	 EQU	  $
	 LDX	  <INDEX
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  GUINIT    [ Gun  initial set ]		     #
;#####################################################################
GURND	 BIN	  00001111,00000111
;
GUN	 EQU	  $
GUINIT	 EQU	  $
	 LDA	  <ENVRFG
	 BEQ	  GUIRET
;
	 LDX	  #2
GUI000	 EQU	  $
	 STX	  <INDEX
;
	 LDA	  <ENCMOD,X
	 BNE	  GUI010
;
	 LDA	  RND0,X
	 LDY	  ENLVFG
;;;;;	 AND	  #00000111B
	 AND	  GURND,Y
	 CMP	  #6
	 BCS	  GUI010
;
	 TAY
	 LDA	  GUSTAT,Y
	 BEQ	  GUI010
;
	 LDA	  GUTMER,Y
	 BEQ	  GUI005	  ; Next shot ok ?
;				  : No.
;;	 SEC
	 SBC	  #0
	 STA	  GUTMER,Y
	 BRA	  GUI010
;;K;;	      JMP      GUI010
;
GUI005	 EQU	  $
	 LDA	  GMSTTM
	 BNE	  GUI010
;
	 LDA	  #0EH
	 STA	  GUTMER,Y	  ; Next shot timer set
;
	 LDA	  GUXPS0,Y
	 STA	  <ENXPS0,X
	 LDA	  GUXPS1,Y
	 STA	  ENXPS1,X
	 LDA	  GUYPS1,Y
	 SEC
	 SBC	  #8
	 STA	  ENYPS1,X
	 LDA	  #1
	 STA	  <ENYPS0,X
	 STA	  <ENCMOD,X
;
	 LSR	  A
	 STA	  <ENSTAT,X
;
	 LDA	  #GUCMD
	 STA	  ENCSMD,X
;
	 LDA	  #GSHL
	 STA	  <ENMYNO,X
	 BRA	  GUI020
;;K;;	      JMP      GUI020
;
GUI010	 EQU	  $
	 LDA	  <ENMYNO,X
	 CMP	  #GSHL
	 BNE	  GUI020
;
	 JSR	  ENLDWY	  ; The first clear check
	 LDA	  <ENCMOD,X
	 BEQ	  GUI020
;
	 JSR	  ENFRCK
;
	 JSR	  GUMOVE
;
GUI020	 EQU	  $
	 DEX
	 BPL	  GUI000
GUIRET	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  GUMOVE    [ Gun  initial set ]		     #
;#####################################################################
GUMKDT	 EQU	  $
	 HEX	  18,E8
;
GUMOVE	 EQU	  $
	 LDA	  GMSTTM
	 BNE	  GUM020
;
	 LDA	  <ENSTAT,X
	 BNE	  GUM010
;
	 LDA	  ENFMSD	  ; Gun display ?
	 AND	  #00001100B
	 CMP	  #00001100B
	 BEQ	  GUM080
;				  : Yes !
	 LDY	  #1
	 JSR	  CRECMP
	 BMI	  GUM040
	 INY
GUM040	 EQU	  $
	 STY	  <ENMMKI,X
	 DEY
	 LDA	  GUMKDT,Y
	 STA	  <ENXSD0,X
;				 :	     [ A gun.]
	 LDA	  <WORK		  ; Tar |  20H	I----I	20H  |
	 ADC	  #28H		 ; get |<------I_||_I------!|  Target
	 CMP	  #50H		 ; area| No	/||\  No    |  area
	 BCC	  GUM080	 ;     |  Shot	|  |   Shot |
;				 :
	 LDA	  #1	    ; Shot
	 STA	  <ENSTAT,X  ;	 on
	 LDA	  #0AH
	 STA	  ETMS01,X
;;;;	 STA	  ENCRCT,X
;;;;	 LDA	  #00100000B
;
;;	   LDA	    #08H
;;	   STA	    0FEH      ; <S!  Gun sound
	LDA	#4AH
	STA	!SOUND3
	JSR	TMSMIN
;
GUM010	 EQU	  $
;;;	 LDA	  ENCRCT,X
;;;	 BEQ	  GUM000
;;;	 DEC	  ENCRCT,X
;GUM000	  EQU	   $
	 LDA	  ENFMSD	  ; Gun display ?
	 AND	  #11110000B
	 CMP	  #11110000B
	 BEQ	  GUM080
;
	 LDA	  <ENSTAT,X
	 AND	  #00100000B	  ; Fail ?
	 BEQ	  GUM015
;
	 JSR	  ENGCAL	  ; Yes !
;
GUM015	 EQU	  $
	LDA	ENCLFG
	BNE	GUM020
	 JSR	  ENCLX0
	JSR	TMASMK
GUM020	 EQU	  $
	 JSR	  ENFRCK
	 JSR	  ENPSCV
	 JSR	  ENCRDS
	 JSR	  CRENPL
	 JMP	  ENCSET
;
GUM080	 EQU	  $
	 JSR	  ENCLER
;;;;;;;	 LDA	  #0
;;;;;;;	 STA	  ENCMOD,X
;;;;;;;	 STA	  ENMYNO,X
GUM090	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  HMINIT    [ Enwmy hammer set No.1 ]		     #
;#####################################################################
COENID	 EQU	  $
;		   0  1	 2  3  4  5  6	7  8	<-- Coin index
	 HEX	  04,04,04,05,05,05,06,06,06   ;<-- Enemy index
;
HMMKDT	 EQU	  $
	 HEX	  10,F0
;
HMINIT	 EQU	  $
;;;;	 JSR	  COIDCL
;;;;	 CMP	  #0
;;;;	 BNE	  HMIRTS	  : No. space aleas
;
;;;;	 LDX	  INDEX
;
	 LDA	  RND0
	 AND	  #00000111B	  ;   0 - 8
	 BNE	  L1		  ;  Randams
	 LDA	  RND0		  ;
	 AND	  #00001000B	  ;
L1	 EQU	  $
	 TAY
	 LDA	  HMSTAT,Y
	 BNE	  HMIRTS
;
	 LDX	  COENID,Y
	 LDA	  <ENCMOD,X
	 BNE	  HMIRTS
;
;;	 LDA	  #1
;;	 STA	  ENCMOD,X
;
	 LDX	  <INDEX
	 TXA
	 STA	  HMENIX,Y
;
	 LDA	  #10010000B
	 STA	  HMSTAT,Y
;
	 LDA	  #COCMD
	 STA	  COCSMD,Y	  ; OBJ cross size set
	 SEC
	 RTS
;
HMIRTS	 EQU	  $
	 LDX	  <INDEX
	 CLC
	 RTS
;
;#####################################################################
;#		     (Y) -- Index				     #
;#	 JSR	  HMMOVE    [ Hammer move	    ]		     #
;#####################################################################
HMMOVE	 EQU	  $
;;;	 LDX	  #8
;HM010	  EQU	   $
;;;	 STX	  INDEX
;
;;;;	 LDA	  HMSTAT,X
;;;;	 BEQ	  HM0A0
;
;;;;	 LDA	  HMSTAT,X
;;;	 AND	  #10000000B	  : Coin ?
;;;;	 BEQ	  HM0A0		  : Yes ! No. coment
;
	 LDA	  GMSTTM	  ; Game stop ? yes --! Move stop
	BEQ	HM090X
	 JMP	  HM090
HM090X	EQU	$
;
	 LDA	  <HMSTAT,X
	 AND	  #01111111B
;
	 LDY	  HMENIX,X
;
	 CMP	  #2
	 BEQ	  HMSHOT
	 BCS	  HMWAIT
;
	 TXA
	 CLC
	 ADC	  #HMXPS0-XPOS0
	 TAX
;
	 LDA	  #10H
	 STA	  <WORK
;
	 LDA	  #0FH
	 STA	  <WORK+1
;
	 LDA	  #4
	 STA	  <WORK+2
;-----------------------------
	 LDA	  #0
	 JSR	  GCALC
;
	 JSR	  CALCX0
;-----------------------------
	 LDX	  <INDEX
;
	 JMP	  HM080
;
HMSHOT	 EQU	  $
	 LDA	  #0FEH
	 STA	  <HMYCL0,X
;
;;;;	 LDA	  #DOWN
	 LDA	  ENSTAT,Y
	 AND	  #11110111B
	 STA	  ENSTAT,Y
;
	 LDX	  <ENMMKI,Y
	 DEX
	 LDA	  HMMKDT,X
;
	 LDX	  <INDEX
	 STA	  <HMXSD0,X
;
HMWAIT	 EQU	  $
	 DEC	  <HMSTAT,X
	LDA	<HMSTAT,X
	CMP	#081H
	BNE	HMC051
	LDA	#37H
	STA	!SOUND0
HMC051	EQU	$
;
	LDA	ENMYNO,Y
	CMP	#2DH
	BNE	HMC050
	 LDA	  #8
	BRA	HMC070
HMC050	EQU	$
	LDA	ENMMKI,Y
	CMP	#2
	BNE	HMC060
	LDA	#6
	BRA	HMC070
HMC060	EQU	$
	LDA	#2
HMC070	EQU	$
	CLC
	ADC	ENXPS1,Y
	 STA	  HMXPS1,X
;
	 LDA	  ENXPS0,Y
	 ADC	  #0
	 STA	  <HMXPS0,X
;
	 LDA	  ENYPS1,Y
	 SEC
	 SBC	  #0AH
	 STA	  HMYPS1,X
;
	 LDA	  #1
	 STA	  <HMYPS0,X
	 BNE	  HM090
;
HM080	 EQU	  $
	 JSR	  CRPLHM
HM090	 EQU	  $
	 JSR	  HMFRCK
	 JSR	  HMPSCV
	 JSR	  HMCRDS
	 JSL	  >HMCSET
;
HM0A0	 EQU	  $
;;;	 DEX
;;;	 BPL	  HM010
;;;	 LDX	  INDEX	    ????????????????????????
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  CONIT0    [ Coin initial set No.0 ]		     #
;#####################################################################
CONIT0	 EQU	  $
	 JSR	  COIDCL	  ; Coin use index calc
;
	 LDA	  <BKXPS0,X
	 STA	  COXPS0,Y	  ; (x)pos (H) set
;
	 LDA	  BKXPS1,X
	 ORA	  #5
	 STA	  COXPS1,Y	  ; (x)pos (L) set
;
;;;	 LDA	  #1
;;;	 STA	  COYPS0,Y	  : (y)pos (H) set
;
	 LDA	  BKYPS1,X
;;;	 SEC
	 SBC	  #10H
	 STA	  COYPS1,Y	  ; (y)pos (L) set
;
	 BRA	  COIT60
;;K;;	      JMP      COIT60
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  CONIT1    [ Coin initial set No.1 ]		     #
;#####################################################################
CONIT1	 EQU	  $
	 JSR	  COIDCL	  ; Coin use index calc
;
	 LDA	  AGBXP0,X
	 STA	  COXPS0,Y	  ; (x)pos (H) set
;
	 LDA	  <WORK+6
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ORA	  #5
	 STA	  COXPS1,Y	  ; (x)pos (L) set
;
	 LDA	  <WORK+2
;;;	 CLC
	 ADC	  #20H
	 STA	  COYPS1,Y	  ; (y)pos (L) set
;
COIT60	 EQU	  $
	 LDA	  #0FBH
	 STA	  COYCL0,Y
;
	 LDA	  #1
	 STA	  COYPS0,Y	  ; (y)pos (H) set
	 STA	  COSTAT,Y
	 STA	  !SOUND3	     ; <S! Coin sound
;
	 STX	  <INDEX
;
	 JSR	  COINUP	  ; Coin count up
	 INC	  SCOCNT	  ; INC	 Secret coin count
;
	 RTS
;
;#####################################################################
;#	 JSR	  COIDCL    [ Coin use index calc ]		     #
;#####################################################################
;COENID	  EQU	   $
;;		    0  1  2  3	4  5  6	 7  8	 <-- Coin index
;	  HEX	   04,04,04,05,05,05,06,06,06	 <-- Enemy index
;
COIDCL	 EQU	  $
	 LDY	  #8
;
COIC10	 EQU	  $
	 LDA	  COSTAT,Y
	 BEQ	  COIC80
;
COIC20	 EQU	  $
	 DEY
	 CPY	  #5
	 BNE	  COIC10
;
	 LDY	  #8
;
COIC80	 EQU	  $
	 STY	  COINID
;------------------------------
;;;;;	 LDX	  DWBKID
;
	 RTS
;
;#####################################################################
;#	 JSR	  COINHM    [ Coin & Hammer ]			     #
;#####################################################################
COINHM	 EQU	  $
COIN	 EQU	  $
	 LDX	  #8
;
COIN20	 EQU	  $
	 STX	  <INDEX
;
	 LDA	  <COSTAT,X
	 BEQ	  COMRET
;;;;	 CMP	  #0FFH
;;;;	 BEQ	  COMRET	  : protect  --> No. move
;
	 ASL	  A
	 BCC	  COIN00
;
	 JSR	  HMMOVE
	 JMP	  COMRET
;
;;;	 STX	  INDEX
;;;	 LDA	  COSTAT,X
;;;	 BEQ	  COMRET	  *- IF	 move coin ?  ( NO : COMRET )
;;;	 AND	  #10000000B
;;;	 BNE	  COMRET	  : Tamafork ?
;
COIN00	 EQU	  $
;;;;;	 LDA	  COSTAT,X
;;;;;	 CMP	  #1		  : NO.
	 LDY	  <COSTAT,X
	 DEY
	 BEQ	  COJUMP
;
COSCRE	 EQU	  $		  ; small score display
	 INC	  <COSTAT,X
;
	 LDA	  COXPS1,X
	 CLC
	 ADC	  SCRMVL	  ; sclool
	 STA	  COXPS1,X
;
	 LDA	  <COXPS0,X
	 ADC	  #0
	 STA	  <COXPS0,X
;
	 LDA	  <COSTAT,X
	 CMP	  #30H		;;CO;;
	 BNE	  COM010
;
	 LDA	  #0
	 STA	  <COSTAT,X
	 JMP	  COMRET
;
;#####################################################################
;#		  Xr--index					     #
;#	 JSR	  COMOVE    [ Coin move ]			     #
;#####################################################################
COJUMP	 EQU	  $
	 TXA
	 CLC
	 ADC	  #COXPS0-XPOS0
	 TAX
;
	 LDA	  #50H
	 STA	  <WORK
;
	 LDA	  #6
	 STA	  <WORK+2
;
	 LSR	  A		  ; A <-- #3
	 STA	  <WORK+1
;
	 LDA	  #0
	 JSR	  GCALC
;
	 LDX	  <INDEX
	 LDA	  <COYCL0,X
	 CMP	  #5	;;T;;	#0
	 BNE	  COM010
;
	 INC	  <COSTAT,X
;
COM010	 EQU	  $
	LDA	<COYCL0,X
	BNE	CMM010
	JSL	>COBINT
CMM010	EQU	$
	 JSR	  COPSCV
	 JSR	  COFRCK
;
	 JSR	  COCRDS    ; Cross data set.
;;;;;;	 JSR	  CRCOBG    : vs BG. Check
;;;;;;	 JSR	  CRPLCO    : vs Player Check
	 JSL	  >COCSET    ; C set
;
COMRET	 EQU	  $
	 DEX
	 BPL	  COIN20
;
	 RTS
;
;---------------------------
COSCDT	 EQU	  $	    ;CAINC coin data
;		   M  L
	 BYTE	  23,29
;
PLSCDT	 EQU	  $	    ;CAINC player data
;		   M  L
	 BYTE	  11,17
;
PCSCDT	 EQU	  $	    ;SCHEG data
;		   M  L
	 HEX	  02,13
;
;
COINUP	 EQU	  $
	 LDA	  #1
	 STA	  WPOIN+5
;;;;	 STA	  WORK
;;;;	 LDA	  #00000011B		    :** Every "1" count up
;;;;	 STA	  WORK+1
;
	 LDX	  MRLGFG
	 LDY	  COSCDT,X
;
	 JSR	  CAINC			    ; Coin score up
;
	 INC	  ENCOCT1		    ; Coin count up
	 LDA	  ENCOCT1
	 CMP	  #100
	 BNE	  COIUP10		    ; "100" count ?
;					    : Yes !
	 STZ	  ENCOCT1
;;K;;	      LDA      #00H
;;K;;	      STA      ENCOCT1
;
;;;;;;;;		INC	!PLCNT		 ; Existra Player up
;;;;;;;;		LDA	!PLCNT
;;;;;;;;		CMP	#0FFH
;;;;;;;;		BNE	CUP10
;;;;;;;;		DEC	!PLCNT
		JSL	>PLCNT_SET		; player count set
CUP10	EQU	$
;
	LDA	#5
	STA	!SOUND3
;;	   LDA	    #40H	    ; <S! Existra player sound
;;	   STA	    0FEH
;
COIUP10	 EQU	  $
COIUP40	 EQU	  $
;;;;;;	 LDA	  #20H
	 LDA	  #02H
SCORUP	 EQU	  $
;;;;;;	 STA	  WORK
;;;;;;	 LDA	  #00000000B		    :** Every "200" point up
	 STA	  WPOIN+4
BKSCUP	 EQU	  $
;;;;;;	 STA	  WORK+1
	 LDX	  MRLGFG
	 LDY	  PLSCDT,X
;
	 JSR	  CAINC			    ; Player score up
;
PLSCORE	 EQU	  $
;;;;;;	 LDA	  #03H
		LDY	!MLFLG2
		LDA	PCSCDT,Y
PLSCR20	 EQU	  $
;;;;;;	 STA	  WORK
	 JSR	  SCHEG			    ; Coin count display
	 LDY	  VRAMD
	 LDA	  VRAMD-10,Y
	 BNE	  PLSCR40		    ; = 0 ?
;					    ;yes
	 LDA	  #28H
	 LDX	  VRAMD-14,Y
	 CPX	  #02H
	 BNE	  PLSCR28
	 LDA	  #24H
PLSCR28	 EQU	  $
	 STA	  VRAMD-10,Y		     ;zero suppless
PLSCR40	 EQU	  $
	 LDX	  <INDEX
	 RTS
;
;#####################################################################
;#		     (X) -- Index ( Atack block )		     #
;#	 JSR	  MSINT0    [ Mushroom initial No.0 ]		     #
;#####################################################################
MSINT0	 EQU	  $
;;;;	 LDA	  #1
;;;;;	 STA	  MSCMOD
;
	 LDA	  #BMUS
	 STA	  <ENMYNO+9	  ; Mushroom No. set
;
	 LDA	  <BKXPS0,X
	 STA	  <MSXPS0	   ;	      (x)pos (H) set
;
	 LDA	  BKXPS1,X
	 STA	  MSXPS1	  ;	     (x)pos (L) set
;
	 LDA	  #1
	 STA	  <MSYPS0	   ;	      (y)pos (H) set
;
	 LDA	  BKYPS1,X
	 SEC
	 SBC	  #8
	 STA	  MSYPS1	  ;	     (y)pos (L) set
;
;#####################################################################
;#	 JSR	  MSINT1    [ Mushroom initial No.1 ]		     #
;#####################################################################
MSINT1	 EQU	  $
	 LDA	  #1
	 STA	  <MSSTAT
	 STA	  <MSCMOD
;
	 LDA	  #ENCMD
	 STA	  MSCSMD	  ; OBJ cross size set
;
	 LDA	  MSFLFG
	 CMP	  #2
	 BCS	  MSI090
;
	 LDA	  POWLEV
	 CMP	  #2
	 BCC	  MSI080
	 LSR	  A
MSI080	 EQU	  $
	 STA	  MSFLFG	  ; 0;Mush 1;Flower 2;Star
MSI090	 EQU	  $
	 LDA	  #00110000B
	 STA	  MSOJBG
;
	 LDA	  #02H
	 STA	  !SOUND3      ; <S! Mush room sound
;
	 RTS
;
;#####################################################################
;#	 JSR	  MSMOVE    [ Mushroom move ]			     #
;#####################################################################
MSMOVE	 EQU	  $
	 LDX	  #MSXPS0-ENXPS0
	 STX	  <INDEX
;
	 LDA	  <MSSTAT
	 BNE	  MSSJP
	 JMP	  MSMVRT
MSSJP	 EQU	  $
;
	 ASL	  A
	 BCC	  MSMV05
;
	 LDA	  GMSTTM
	 BNE	  MSMV20    ; Game stop ?
;			    : No.
	 LDA	  MSFLFG
	 BEQ	  MSMV01    ; Mush room 1
	 CMP	  #3
	 BEQ	  MSMV01    ; MusH room 2
	 CMP	  #2
	 BNE	  MSMV20    ; Star ?
;			    : Yes !
	 JSR	  ENPYMV    ; Bounus star move
	 JSR	  CREB03
	 JMP	  MSMV20
;
MSMV01	 EQU	  $	    ; Mush room 1,2
	 JSR	  ENWKMV    ; Walk move
	 JSR	  CRENBG
	 JMP	  MSMV20
;
MSMV05	 EQU	  $
	 LDA	  <FMCNT
	 AND	  #3
	 BNE	  MSMV10
;
	 DEC	  MSYPS1
;
	 LDA	  <MSSTAT
	 INC	  <MSSTAT
	 CMP	  #11H
	 BCC	  MSMV10
;
	 LDA	  #10H
	 STA	  <ENXSD0,X
;
	 LDA	  #10000000B
	 STA	  <MSSTAT
	 ASL	  A		  ; A <-- #0
	 STA	  MSOJBG
	 ROL	  A		  ; A <-- #1
	 STA	  <ENMMKI,X
;
MSMV10	 EQU	  $
	 LDA	  <MSSTAT
	 CMP	  #6
	BCS	MSMV20
	JMP	 MSMVRT
;
MSMV20	 EQU	  $
;;	CPX	#09H
;;	BEQ	MSM000
	JMP	MSM010
MSM000	EQU	$
	LDA	<ENXPS0,X
	STA	<YWORK5
	LDA	ENXPS1,X
	STA	<YWORK4
	MEM16
	REP	#20H
	LDA	<YWORK4
	CMP	<SCCH1
	BCS	MSM030
	CLC
	ADC	#0CH
	STA	<YWORK2
	MEM8
	SEP	#20H
	LDA	<YWORK2
	STA	ENXPS1,X
	LDA	<YWORK3
	STA	<ENXPS0,X
MSM030	EQU	$
	MEM8
	SEP	#20H
	 JSR	  ENPSCV
	 JSR	  ENFRCK
	 JSR	  ENCRDS    ; Cross data set.
	 JSR	  MSCSET    ; Chara set
	 JSR	  CRENPL    ; vs Player Check
	 JSR	  ENLDWY
	LDA	<YWORK4
	STA	ENXPS1,X
	LDA	<YWORK5
	STA	<ENXPS0,X
;;;	BRA	MSMVRT
;
MSM010	EQU	$
	 JSR	  ENPSCV
	 JSR	  ENFRCK
	 JSR	  ENCRDS    ; Cross data set.
	 JSR	  MSCSET    ; Chara set
;;;;;;	 JSR	  CRPLMS    : vs Player Check
	 JSR	  CRENPL    ; vs Player Check
	 JSR	  ENLDWY
;
MSMVRT	 EQU	  $
	 RTS
;---------------------------------------------------------------------<< Down block
;
;#####################################################################
;#		     (A) -- Block area No.			     #
;#		  WORK+2 -- Frame table block index		     #
;#		  WORK+6 --		"     address (L)            #
;#		  WORK+7 --		"             (H)            #
;#	 JSR	  BKPINT    [ Block pros initial ]		     #
;#####################################################################
;				  < Block status value >
STSBK	 EQU	  01H		       ; Small up block
STBBK	 EQU	  02H		       ; Break block
;
PLHCBY	 EQU	  $		  ;< Player head cross BG data !
	 BYTE	  PCBDY0,PCBDY2
;
BKPINT	 EQU	  $
	 PHA			  ;stack! <-- Block No.
;
	 LDA	  #STSBK+00010000B
	 LDX	  DWBKID
	 LDY	  PLSIZE	  ; Block status set !
	 BNE	  BPI020	       ;- IF  small mario ?		       ( YES ; BPI020 )
;
	 LDA	  #STBBK+00010000B
;
BPI020	 EQU	  $
	 STA	  <BKSTAT,X		; Block kind status set
;
;				  < Initial down block >
	 JSR	  BGBKES	       ; BG Block erase
;
	 LDX	  DWBKID
	 LDA	  <WORK+2
	 STA	  AGBKD0,X	       ; AGBKD0 <-- Frame table index
	 TAY
;
	 LDA	  <WORK+6
	 STA	  AGBKD1,X	       ; AGBKD1 <-- Frame table address (L)
;
	 LDA	  (<WORK+6),Y
	 JSR	  BNBKCK	       ; Bonus block check
	 STA	  <WORK
;
	 LDY	  PLSIZE
	 BNE	  BPI025	       ;- IF  small mario ?	      ( YES ; BPI025 )
;
	 TYA
;
BPI025	 EQU	  $
	 BCC	  BPI055	       ;- IF  bonus block ?	      ( NO ; BPI055 )
;
	 LDY	  #STSBK+00010000B     ; Bonus block check !
	 STY	  <BKSTAT,X
;
	 LDA	  #BRIK2		    ; Return bonus block No.
	 LDY	  <WORK
	 CPY	  #RBCOS
	 BEQ	  BPI028		    ;- IF  repeat coin in block ?   ( YES ; BPI028 )
;
	 CPY	  #BRBCS
	 BNE	  BPI055		    ;- IF  repeat coin in block ?   ( NO ; BPI055 )
;
BPI028	 EQU	  $			    ; Repeat bonus coin pros !
	 LDA	  RCOCNT
	 BNE	  BPI030			 ;- IF first time ?	    ( YES ; BPI030 )
;
	 LDA	  #0BH
	 STA	  RCONTM			      ; Set  Repeat time
;
	 INC	  RCOCNT
;
BPI030	 EQU	  $
	 LDA	  RCONTM
	 BNE	  BPI040			 ;- IF	end repeat time ?   ( NO ; BPI040 )
;
	 LDY	  #BRIK2			       ; Return bonus block No.
;
BPI040	 EQU	  $
	 TYA
;
BPI055	 EQU	  $
	 STA	  AGBKD2,X	       ; AGBKD2 <-- Again block No.
;
	 JSR	  BKPSSB	       ; Block position set sub
;
	 LDY	  <WORK+2
	 LDA	  #BKBSW
	 STA	  (<WORK+6),Y		; Now break block switch ON
;
	 LDA	  #10H
	 STA	  TMES3		       ; Break next block OK time set
;
	 PLA
	 STA	  <WORK+5		; <WORK+5 <-- Block No. atack now
;
	 LDY	  #0
	 LDA	  PLSDFG
	 BNE	  BPI080	       ;- IF  sit down plyer ?	( YES ; BPI080 )
;
	 LDA	  PLSIZE
	 BEQ	  BPI090	       ;- IF  small mario ?	( NO ; BPI090 )
;
BPI080	 EQU	  $
	 INY
;
BPI090	 EQU	  $
	 LDA	  PLYPS1
	 CLC
	 ADC	  PLHCBY,Y
	 AND	  #0F0H
	 STA	  BKYPS1,X		    ; Low (y) pos. set
;
	 LDY	  <BKSTAT,X
	 CPY	  #STSBK+00010000B
	 BEQ	  BPI150	  ;- IF	 small up block ?	( YES ; BPI150 )
;
;				  < Init  break block >
	 JSR	  BBKINT	       ; Break block init
	 BRA	  BPI200
;;K;;	      JMP      BPI200
;
BPI150	 EQU	  $		  ; Init  small up block !
	 JSR	  SBKINT	       ; Small up block init
;
BPI200	 EQU	  $		  ; Clac  Down block index ( DWBKID ) !
	 LDA	  DWBKID
	 EOR	  #00000001B
	 STA	  DWBKID
;
BPI400	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Index ( Block )			     #
;#	 JSR	  BKPSSB    [ Block position set sub ]		     #
;#####################################################################
BKPSSB	 EQU	  $
	 LDA	  PLXPS1
	 CLC
	 ADC	  #8
	 AND	  #0F0H
	 STA	  BKXPS1,X	       ; Block (x)pos (L) set
	STA	FMXBKL
;
	 LDA	  <PLXPS0
	 ADC	  #0
	 STA	  <BKXPS0,X		; Block (x)pos (H) set
	 STA	  AGBXP0,X
	STA	FMXBKH
;
	 LDA	  <PLYPS0
	 STA	  <BKYPS0,X		; Block (y)pos (H) set
;
	 RTS
;
;#####################################################################
;#		     (X) -- Index ( Block )			     #
;#		  WORK+5 -- Block No. atack now			     #
;#	 JSR	  SBKINT    [ Small up block initial ]		     #
;#####################################################################
SBKINT	 EQU	  $
	 JSR	  ONCOCK	  ; On coin chaeck
;
	 LDA	  #01H
	 STA	  !SOUND0	     ; Sound  No break block set  @@@@@@@@@
;
	 STZ	  <BKXSD0,X
	 STZ	  BKYCL1,X
	 STZ	  <PLYCL0	   ; Player shock jump up
;;K;;	      LDA      #0
;;K;;	      STA      <BKXSD0,X
;;K;;	      STA      BKYCL1,X
;;K;;	      STA      <PLYCL0		; Player shock jump up
;
	 LDA	  #0FEH
	 STA	  <BKYCL0,X
;
	 LDA	  <WORK+5
	 JSR	  BNBKCK	  ; Bonus block check
	 BCC	  SBI200	  ;- IF	 bonus block ?	( NO ; SBI200 )
;
	 TYA
	 CMP	  #BBD50-BNBKDT
	 BCC	  SBI050
;
	 SBC	  #BBD50-BBD30
;
SBI050		EQU	$
		ASL	A
		TAY
		LDA	SBI050TBL,Y
		STA	<WORK+4
		LDA	SBI050TBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
SBI050TBL	EQU	$
		WORD	SBI070		; 0 Initial bonus   mushroom   in block
		WORD	CONIT0		; 1		    coin       in
		WORD	CONIT0		; 2	    special coin       in see through  block
		WORD	SBI100		; 3	    special mushroom   in
		WORD	SBI070		; 4 Initial bonus   mushroom   in normal block
		WORD	SBI150		; 5		    wood       in
		WORD	SBI080		; 6		    super star in
		WORD	CONIT0		; 7	    repeat  coin       in
		WORD	SBI100		; 8	    special mushroom   in
;
SBI070	 EQU	  $		  ; Initial  Mushroom !
	 LDA	  #0
	 BRA	  SBI120
;
SBI080	 EQU	  $		  ; Initial  Super star !
	 LDA	  #2
	 BRA	  SBI120
;
SBI100	 EQU	  $
	 LDA	  #3
;
SBI120	 EQU	  $
	 STA	  MSFLFG
	 JMP	  MSINT0
;
SBI150	 EQU	  $		  ; Initial  Wood !
	 LDX	  #WDCMOD-ENCMOD
	 LDY	  DWBKID
	 JSR	  WDINIT
;
SBI200	 EQU	  $
;
	 RTS
;
;#####################################################################
;#	 JSR	  BNBKCK    [ Bonus block check ]		     #
;#		     <Y> -- Bonus block index ( in BNBKDT )	     #
;#		     <C> -- 0 : No bonus block			     #
;#			    1 : Bonus block			     #
;#####################################################################
BNBKDT	 EQU	  $		  ; Bonus block data !
	 BYTE	  BXMUS,BXCON,STBCO,STBMS
BBD30	 BYTE	  BKMUS,BKWOD,BKSTR,RBCOS,SBMUS	 ; Ground
BBD50	 BYTE	  BRMUS,BRWOD,BRSTR,BRBCS,BRSMS	 ; Underground
BBD	 EQU	  $
;
BNBKCK	 EQU	  $
	 LDY	  #BBD-BNBKDT-1
;
BBCK20	 EQU	  $
	 CMP	  BNBKDT,Y
	 BEQ	  BBCK80	  ;- IF	 bonus block ?	  ( YES ; BBCK80 )
;
	 DEY
	 BPL	  BBCK20	  ;- IF	 all check end ?  ( NO ; BBCK20 )
;
	 CLC
;
BBCK80	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		  WORK+2 -- Break block frame table index	     #
;#	 JSR	  BBKINT    [ Break block initial ]		     #
;#####################################################################
BBKINT	 EQU	  $
	 JSR	  ONCOCK	       ; On coin chaeck
;
	 LDA	  #1
	 STA	  AGBKSW,X	       ; Again block time set
	 LDA	!SOUND3
	BNE	BKSD10
	 LDA	#07
	 STA	  !SOUND3		  ; Block break sound set  @@@@@@@
BKSD10	EQU	$
;
	 JSR	  BKPSSET	       ; Breack block position set sub	      #
;
	 LDA	  #0FEH
	 STA	  <PLYCL0		; Player shock jump up
;
	 LDA	  #5
;;;;;	 JSR	  SCORUP
	 STA	  WPOIN+5
	 JSR	  BKSCUP
;;;	 STA	  WORK
;;;	 LDA	  #0
;;;	 JSR	  BKSCUP	       : "50" point score up
;
	 LDX	  DWBKID
;
	 RTS
;
;#####################################################################
;#	 JSR	  ONCOCK    [ On coin check ]			     #
;#####################################################################
ONCOCK	 EQU	  $
	 LDX	  DWBKID
	 LDY	  <WORK+2
	 BEQ	  ONCC80	  ;- IF	 must top frame ?  ( YES ; ONCC80 )
;
	 TYA
	 SEC
	 SBC	  #10H
	 STA	  <WORK+2
	 TAY
;
	 LDA	  (<WORK+6),Y
	 CMP	  #COIN0
	 BNE	  ONCC80	  ;- IF	 block on coin ?   ( NO ; ONCC80 )
;
	 LDA	  #0
	 STA	  (<WORK+6),Y		; Clear	 coin data
	LDA	#01
	STA	!SOUND3
;
	 JSR	  BGCOES	       ; Clear	BG coin
;
	 LDX	  DWBKID
	 JSR	  CONIT1	       ; Init	coin move
;
ONCC80	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Breack block index			     #
;#	 JSR	  BKPSSET   [ Breack block position set sub ]	     #
;#####################################################################
BKPSSET	 EQU	  $
	 LDA	  BKXPS1,X
	 STA	  BKCTPS,X	       ; Center pos set
;
	 LDA	  #0F0H
	 STA	  <BKXSD0,X
	 STA	  <BKXSD0+2,X
;
	 LDA	  #0FAH
	 STA	  <BKYCL0,X		; Down block up value
;
	 LDA	  #0FCH
	 STA	  <BKYCL0+2,X		; Top block up value set
;
	 STZ	  BKYCL1,X
	 STZ	  BKYCL1+2,X
;;K;;	      LDA      #0
;;K;;	      STA      BKYCL1,X
;;K;;	      STA      BKYCL1+2,X
;
	 LDA	  <BKXPS0,X
	 STA	  <BKXPS0+2,X
;
	 LDA	  BKXPS1,X
	 STA	  BKXPS1+2,X
;
	 LDA	  BKYPS1,X
	 CLC
	 ADC	  #8
	 STA	  BKYPS1+2,X
;
	 LDA	  #0FAH
	 STA	  <BKYCL0,X		; First up power set
;
	 RTS
;
;#####################################################################
;#		     (X) -- Index ( Block )			     #
;#		  BKSTAT -- xxxx xxxx				     #
;#			      |	   +-- 1 - 3 ( Block down No. )	     #
;#			      +------- 0 <> : Initial		     #
;#	 JSR	  DWBLOK    [ Down block ]			     #
;#####################################################################
DWBLOK	 EQU	  $
	 LDA	  <BKSTAT,X
	 BEQ	  DWB110	  ;- IF	 move block ?	      ( YES ; DWBK90 )
;
	 AND	  #0FH
	 PHA
	 TAY
;
	 TXA
	 CLC
	 ADC	  #BKXPS0-XPOS0
	 TAX
;
	 DEY
	 BEQ	  DWB100	  ;- IF	 small up block ?     ( YES ; DWB100 )
;
DWBK50	 EQU	  $		  ; Break up block move calc !
	 JSR	  BKGCL1	       ; (y) pos calc
	 JSR	  CALCX0	       ; (x) pos calc
;
	INX
	INX
;;K;;	      TXA
;;K;;	      CLC
;;K;;	      ADC      #2
;;K;;	      TAX
;
	 JSR	  BKGCL1	       ; (y) pos calc
	 JSR	  CALCX0	       ; (x) pos calc
;
	 LDX	  <INDEX
	 JSR	  BKPSCV	       ; Block position convert
	 JSR	  BKFRCK	       ;   "   frame check
	 JSR	  BKCST2	       ;   "   chara set
;
	 PLA
	 LDY	  <BKYPS0,X
	 BEQ	  DWB110	  ; Up limit -! No. clear
;
	 PHA
	 LDA	  #0F0H
	 CMP	  BKYPS1+2,X
	 BCS	  DWBK80
;
	 STA	  BKYPS1+2,X
;
DWBK80	 EQU	  $		  ; End check !
	 LDA	  BKYPS1,X
	 CMP	  #0F0H
	 PLA
	 BCC	  DWB110	      ;- IF  break up end ?  ( NO ; DWB110 )
	 BCS	  DWB105
;
;
DWB100	 EQU	  $		  ; Small up block move calc !
	 JSR	  BKGCL1	       ; (y) pos calc
;;;;;;;	 JSR	  CALCX0	       : (x) pos calc
;
	 LDX	  <INDEX
	 JSR	  BKPSCV	       ; Block position convert
	 JSR	  BKFRCK	       ;   "   frame check
	 JSR	  BKCST1	       ;   "   chara set
;
	PLA
	 STA	  <BKSTAT,X
;
	 LDA	  BKYPS1,X	  ; End check !
	 AND	  #0FH
	 CMP	  #5
	 BCS	  DWB110	       ;- IF  small up end ?  ( NO ; DWB110 )
;
	 LDA	  #1
	 STA	  AGBKSW,X		    ; Again block time set
;
DWB105	 EQU	  $
	 STZ	  <BKSTAT,X
DWB110	 EQU	  $
	 RTS
;
;#####################################################################
;#	 JSR	  AGBLOK    [ Again block ]			     #
;#####################################################################
AGBLOK	 EQU	  $
	 LDX	  #AGBKD1-AGBKD0-1
;
AGBK20	 EQU	  $
	 STX	  <INDEX
;
;K;	    LDA	     VRAMD+1
;K;	    BNE	     AGBK90	     ;- IF  VRAMD area full ?	  ( YES ; AGBK90 )
;
	 LDA	  AGBKSW,X
	 BEQ	  AGBK90	  ;- IF	 again block ?	       ( NO ; AGBK90 )
;
	 LDA	  AGBKD1,X
	 STA	  <WORK+6		; <WORK+6 <-- Frame table address (L)
;
	 LDA	  #5
	 STA	  <WORK+7		; <WORK+7 <-- Frame table address (H)
;
	 LDA	  AGBKD0,X
	 STA	  <WORK+2		; <WORK+2 <-- Frame table index
	 TAY
;
	 LDA	  AGBKD2,X	       ; Ar <-- Again block No.
	 STA	  (<WORK+6),Y
;
	 JSR	  BGBKST	       ; BG block again set
;
	 LDA	  #0
	 STA	  AGBKSW,X	       ; Clear again block timer
;
AGBK90	 EQU	  $
	 DEX
	 BPL	  AGBK20	  ;- IF	 again block all check end ?	( NO ; AGBK20 )
;
AGB100	 EQU	  $
;
	 RTS
;
;---------------------------------------------------------------------<< Player & Enemy common routine
;#####################################################################
;#		     (X) -- Index ( Enmey )			     #
;#	 JSR	  ENCLX0    [ Player RT & LF (x) pos calc ]	     #
;#####################################################################
ENCLX0	 EQU	  $
;;	 TXA
;;	 CLC
;;	 ADC	  #ENXPS0-XPOS0
;;	 TAX
	 INX
;
	 JSR	  CALCX0
;
	 LDX	  <INDEX
	 RTS
;
;#####################################################################
;#	 JSR	  PLCLX0    [ Player RT & LF (x) pos calc ]	     #
;#####################################################################
PLCLX0	 EQU	  $
	 LDA	  PLSPON	  ; On spring ?
	 BNE	  CALRTS
;
	 TAX
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  CALCX0    [ RT & LF (x) pos calc ]		     #
;#		     (A) -- (x) move value			     #
;#####################################################################
CALCX0	 EQU	  $	    ; Speed value calclate !
	 LDA	  <XSPED0,X
;;;;;;	 AND	  #00001111B
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 STA	  <WORK+1
;
	 LDA	  <XSPED0,X
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 CMP	  #8
	 BCC	  CALX60
;
	 ORA	  #11110000B
;
CALX60	 EQU	  $
	 STA	  <WORK
	STA	XMOVRL
;
	 LDY	  #0
	 CMP	  #0
	 BPL	  CALX70
;
	 DEY
;
CALX70	 EQU	  $
	 STY	  <WORK+2
;
	 LDA	  XPOS2,X   ; New (x) position calclate !
	 CLC
	 ADC	  <WORK+1
	 STA	  XPOS2,X
;
	 LDA	  #0
	 ROL	  A
	 PHA
	 ROR	  A
;
	 LDA	  XPOS1,X
	 ADC	  <WORK
	 STA	  XPOS1,X
;
	 LDA	  <XPOS0,X
	 ADC	  <WORK+2
	 STA	  <XPOS0,X
;
	 PLA
	 CLC
	 ADC	  <WORK		   ; Ar <-- (x) Move value
;
CALRTS	 EQU	  $
	 RTS
;#####################################################################
;#	 JSR	  PLGCAL    [ Player G calclate ]		     #
;#####################################################################
PLGCAL	 EQU	  $
	 LDX	  #0
	 LDA	  GMSTTM
	 BNE	  PLG010	  ; Game stop ?
;				  : Yes --> No. spring check
	 LDA	  PLSPON	  ; On spring ?
	 BNE	  CALRTS
;				  : No.
PLG010	 EQU	  $
	 LDA	  PLGPWR
	 STA	  <WORK
;
	 LDA	  #4
	 JMP	  BKGC20
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENGCAL    [ Enemy G calclate 1 ]		     #
;#####################################################################
ENGCAL	 EQU	  $
;;;	 LDA	  <ENVRFG
;;;	 CMP	  #3
;;;	 BEQ	  ENGCL2
;
	 LDY	  #3DH
;;;	 LDA	  ENMYNO,X
;;;	 CMP	  #EXT0
;;;	 BNE	  ENGCBL	  : Bakudan ?
;
	 LDA	  <ENSTAT,X	   ; Yes !
	 CMP	  #DROP
;;;;;;;;	 BNE	  ENGCBL	  ; Dropping ?
		BNE	ENGC10
;				  : Yes !
;;;;;;;	 JMP	  ENGCBL
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFGCL1    [ Lift G calculate No.2 ]		     #
;#####################################################################
LFGCL2	 EQU	  $
	 LDY	  #20H
ENGCBL	 EQU	  $
	BRA	ENGC10
;;;	    JMP	     ENGC10
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENGCLS    [ Enemy slow G calc ]		     #
;#####################################################################
ENGCLS	 EQU	  $
	 LDY	  #0
	BRA	ENFC10
;;;	    JMP	     ENGC10
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENFCLS    [ Enemy Fly calc ]			     #
;#####################################################################
ENFCLS	 EQU	  $
	 LDY	  #1
ENFC10	 EQU	  $
;;	 TXA
;;	 CLC
;;	 ADC	  #ENXPS0-XPOS0
;;	 TAX
	 INX
;
	 LDA	  #3
	 STA	  <WORK		   ; G power
;
	 LDA	  #6
	 STA	  <WORK+1	   ; Fly power
;
	 LDA	  #2
	 STA	  <WORK+2	   ; Max down dot set
;
	 TYA
	 JMP	  LFGC40
;
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFGCLH    [ Lift super hi speed down calc ]	     #
;#####################################################################
LFGCLH	 EQU	  $
	 LDY	  #7FH
	 BNE	  ENG3
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENGCL3    [ Big kame calclate	 ]		     #
;#####################################################################
ENGCL3	 EQU	  $
	 LDY	  #0FH		  ; G
ENG3	 EQU	  $
	 LDA	  #2		  ; Max dot
	 BNE	  ENGC15
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  ENGCL2    [ Enemy G calclate 3 ]		     #
;#####################################################################
ENGCL2	 EQU	  $
;;;;;;	 LDA	  <ENVRFG
;;;;;;	 BEQ	  ENGCL3
;
	 LDY	  #1CH	    ; G power
;
ENGC10	 EQU	  $
;;	 TXA
;;	 CLC
;;	 ADC	  #ENXPS0-XPOS0
;;	 TAX
;
	 LDA	  #3	    ; Max dot
ENGC15	 EQU	  $
	 STY	  <WORK
	 INX
ENGC20	 EQU	  $
	 JSR	  BKGC20
;
	 LDX	  <INDEX
	 RTS
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  BKGCL0    [ Down block G calculate No.0 ]	     #
;#####################################################################
BKDWDD	 EQU	  $	    ; Block max down dot data !
	 HEX	  6
	 HEX	  8		  ; Break block
;
BKGCL0	 EQU	  $
	 LDY	  #0
	 BRA	  BKGCL1
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  BKGCL1    [ Down block G calculate No.1 ]	     #
;#####################################################################
BKGCL1	 EQU	  $
	 LDY	  #1
;
BKGC10	 EQU	  $
	 LDA	  #50H
	 STA	  <WORK		   ; G power set
;
	 LDA	  BKDWDD,Y
;
BKGC20	 EQU	  $
	 STA	  <WORK+2	   ; Max down dot set
;
	 LDA	  #0
	 JMP	  GCALC
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFGCL0    [ Lift G calculate No.1 ]		     #
;#####################################################################
LFGCL0	 EQU	  $
	 LDA	  #0
	 BRA	  LFGCLC
;
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFGCL1    [ Lift G calculate No.2 ]		     #
;#####################################################################
LFGCL1	 EQU	  $
	 LDA	  #1	    ; Fly calc
;;;;	  JMP	   LFGCLC
;#####################################################################
;#		     (X) -- Index				     #
;#	 JSR	  LFGCL1    [ Lift G calculate No.2 ]		     #
;#####################################################################
;LFGCL2	  EQU	   $
;	  LDY	   #0	     : Down calc
;	  TXA
;	  CLC
;	  ADC	   #ENXPS0-XPOS0
;	  TAX
;	  LDA	   #30H
;	  JMP	   LFGC10
;
;---------------------------------------------------
LFGCLC	 EQU	  $
	 PHA
;
	 LDY	  <ENMYNO,X
;
;;	 TXA
;;	 CLC
;;	 ADC	  #ENXPS0-XPOS0
;;	 TAX
	 INX
;
	 LDA	  #05H
;
	 CPY	  #LFT5
	 BNE	  LFGC10
;
	 LDA	  #09H
LFGC10	 EQU	  $
	 STA	  <WORK	     ; G power
;
	 LDA	  #0AH
	 STA	  <WORK+1    ; Fly power
;
	 LDA	  #3
	 STA	  <WORK+2    ; Max dot
;
	 PLA
	 TAY
;
LFGC40	 EQU	  $
	 JSR	  GCALC
	 LDX	  <INDEX
	 RTS
;
GCALCY	EQU	$
	JSR	GCALC
	RTL
;
;#####################################################################
;#		     (X) -- Index				     #
;#		     (A) -- 0 : No fly calc			     #
;#			    1 : Fly calc			     #
;#		    WORK -- G	Power				     #
;#		  WORK+1 -- Fly	  "                                  #
;#		  WORK+2 -- Max down dot			     #
;#	 JSR	  GCALC	    [ G power calclate ]		     #
;#####################################################################
GCALC	 EQU	  $
	 PHA
;
	 LDA	  YPOS2,X	  ; New (y) position calclate !
	 CLC
	 ADC	  YCALC1,X
	 STA	  YPOS2,X
;
	 LDY	  #0
	 LDA	  <YCALC0,X
	 BPL	  CALY10
;
	 DEY
;
CALY10	 EQU	  $
	 STY	  <WORK+7
;
	 ADC	  YPOS1,X
	 STA	  YPOS1,X
;
	 LDA	  <YPOS0,X
	 ADC	  <WORK+7
	 STA	  <YPOS0,X
;
	 LDA	  YCALC1,X	  ; G power calclate !
	 CLC
	 ADC	  <WORK
	 STA	  YCALC1,X
;
	 LDA	  <YCALC0,X
	 ADC	  #0
	 STA	  <YCALC0,X
;
	 CMP	  <WORK+2
	 BMI	  CALY30
;
	 LDA	  YCALC1,X
	 CMP	  #80H
	 BCC	  CALY30
;
	 LDA	  <WORK+2
	 STA	  <YCALC0,X
;
;;;;;;;;	 LDA	  #0
;;;;;;;;	 STA	  YCALC1,X
		STZ	YCALC1,X
;
CALY30	 EQU	  $
	 PLA
	 BEQ	  CALY90
;
	 LDA	  <WORK+2	   ; Flying calclate !
	 EOR	  #0FFH
;;;;;;;;	 TAY
;;;;;;;;	 INY
;;;;;;;;	 STY	  <WORK+7
		INC	A
		STA	<WORK+7
;
	 LDA	  YCALC1,X
	 SEC
	 SBC	  <WORK+1
	 STA	  YCALC1,X
;
	 LDA	  <YCALC0,X
	 SBC	  #0
	 STA	  <YCALC0,X
	 CMP	  <WORK+7
	 BPL	  CALY90
;
	 LDA	  YCALC1,X
	 CMP	  #80H
	 BCS	  CALY90
;
	 LDA	  <WORK+7
	 STA	  <YCALC0,X
;
	 LDA	  #0FFH
	 STA	  YCALC1,X
;
CALY90	 EQU	  $
	 RTS
;
;#####################################################################
;#		     (X) -- Enemy  index			     #
;#	 JSR	  TMASMK	  [ Killer hattsha smoke ]	     #
;#####################################################################
;
TMASMK	EQU	$
	LDA	KSMKFG,X
	BEQ	KSMKEN
	INC	KSMKCT,X
	LDA	KSMKCT,X
	LSR	A
	LSR	A
	LSR	A
	CMP	#03
	BEQ	KSMCLR
	ASL	A
	CLC
	ADC	#40H
	STA	<YWORK
	LDA	KLXPS1,X
	STA	<YWORK1
	LDA	KLXPS0,X
	STA	<YWORK2
	MEM16
	REP	#20H
	LDA	<YWORK1
	SEC
	SBC	<SCCH1
	PHA
	LDA	XMOVRL-1
	BMI	KLLMOV
	PLA
	CLC
	ADC	#0CH
	BRA	KLLRFN
KLLMOV	EQU	$
	PLA
	SEC
	SBC	#0CH
KLLRFN	EQU	$
	STA	<YWORK1
	MEM8
	SEP	#20H
;
	PHY
;
	LDY	OAMEN,X
;
	LDA	<YWORK1
	STA	OAM2+00,Y
	LDA	KLYPS1,X
	STA	OAM2+01,Y
	LDA	<YWORK
	STA	OAM2+02,Y
	LDA	#2DH
	STA	OAM2+03,Y
;
	LDA	#2
	STA	OAMSB2,Y
	LDA	<YWORK2
	BEQ	KSMKFN
	LDA	#3
	STA	OAMSB2,Y
KSMKFN	EQU	$
	PLY
KSMKEN	EQU	$
	RTS
;
KSMCLR	EQU	$
	STZ	KSMKFG,X
	TXA
	ASL	A
	ASL	A
	ASL	A
	STA	<YWORK4
	ASL	A
	CLC
	ADC	<YWORK4
	PHX
	TAX
	LDA	#0F0H
	STA	OAM2+01,X
	STZ	OAMSB2,X
	PLX
	RTS
;
TMSMIN	EQU	$
	STA	KSMKFG,X
	STZ	KSMKCT,X
	LDA	ENXPS1,X
	STA	KLXPS1,X
	LDA	<ENXPS0,X
	STA	KLXPS0,X
	LDA	ENYPS1,X
	CLC
	ADC	#8
	STA	KLYPS1,X
	RTS
;
;#####################################################################
;#		     (MFFLG) -- 1.Fade out 2.Fade in		     #
;#	 JSR	  MOZIK		  [ Fade & Mozaik ]		     #
;#####################################################################
MOZAIK		EQU	$
		LDA	MFFLG
		LSR	A
		BCC	FADIN
FADOUT		EQU	$
		LDA	!PASCFG
		BMI	MZSKIP		; fade out end ?
;					; no
;		CMP	#02H
;		BNE	FADOUT00
;		JSL	>MINCTR
;
FADOUT00	EQU	$
		LDA	!WNDMSG
		BEQ	NOEND00
		LDA	!PASCFG
		BEQ	FADOUT01
NOEND00		EQU	$
		DEC	!PASCFG
		BNE	FADIJ10		; fade out end ?
;					; yes
FADOUT01	EQU	$
		LDA	#10000000B
		STA	2100H
		STA	!PASCFG		; blanking on
		STZ	420CH
		STZ	!WD420C		; H-DMA disable
		STZ	!WINDMD
		STZ	!WNDMSG
;
		LDA	>701FF2H
		BEQ	RSTPS1
		LDA	!MZRTFG
		BNE	RSTPS2
		JMP	>ZD_RESET
RSTPS2		EQU	$
		JMP	>PS_RESET
;
RSTPS1		EQU	$
		JSL	>VRMCLZ		; BG.1,2,3 VCL
;
		JSR	OAMCLR
		JSR	FDVRSB
;
;;;;;;;;		LDA	<ENVRFG
;;;;;;;;		CMP	#02H
;;;;;;;;		BNE	MZSKIP
MZSKIP		EQU	$
		STZ	MFFLG
		LDA	#01
		STA	!BGBKFG
;;;;;;;;		BRA	MOZRET
		BRA	FADIJ10
FADIN		EQU	$
;				;;TF
	LDA	PLNOST
	BNE	FDI010
	LDA	<PLSTFG
	BNE	FDI010
	LDA	#1
	STA	<PLSTFG
	JSR	GMPLAY
FDI010	EQU	$
		STZ	ENCLFG
;;;;;;;;		INC	PASCFG
;;;;;;;;		LDA	PASCFG
;;;;;;;;		CMP	#10H
;;;;;;;;		BCC	FADIJ10
		LDA	!PASCFG
		CMP	#00001111B
		BEQ	FADIN01		; fade in end ?
;					; no
		INC	!PASCFG
		LDA	!PASCFG
		CMP	#00001111B
		BNE	FADIJ10		; fade in end ?
;					; yes
;;;;;;;;		DEC	PASCFG
FADIN01		EQU	$
		STZ	MFFLG
		STZ	BGBKFG
		STZ	<PLSTFG		;;;TF
FADIJ10		EQU	$
		LDA	FADFLG
		BEQ	MOZRET2		; mozaiku ?
;					; yes
;		LDA	MFFLG
;		LSR	A
;		BCC	FD10
		JSR	OAMCLR
FD10		EQU	$
		LDA	PASCFG
		EOR	#0FH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	#0FH
		STA	MOZNO
		JSR	PLCLAR
MOZRET		EQU	$
		LDA	PASCFG
		CMP	#0FH
		BNE	MOZRET2
		STZ	FADFLG
MOZRET2		EQU	$
		RTS
;
;
;
OAMCLR	EQU	$
	PHX
	LDX	#0
	LDA	#0F0H
OCLR10	EQU	$
	STA	OAM+1,X
	STA	OAM2+1,X
	STZ	OAMSB,X
	STZ	OAMSB+100H,X
	INX
	INX
	INX
	INX
	BNE	OCLR10
	PLX
	RTS
;
PLCLAR	EQU	$
	PHY
	LDY	#0D0H
	LDA	#0F0H
PLCL10	EQU	$
	STA	OAM+01,Y
	INY
	INY
	INY
	INY
	CPY	#0F0H
	BNE	PLCL10
	PLY
	RTS
;
FDVRSB	EQU	$
	JSL	>MINCTR
	STZ	!PLNOWR
	STZ	SELFLG
	STZ	!BBSCHL
	STZ	SMKFLG
	STZ	SMKFLG2
	STZ	SMKCNT
	STZ	WDWFLG
;
	LDA	PLNOST
	BNE	FDVREN
	LDA	PLYPS1
	STA	PLOBJY
	LDA	PLXPS1
	STA	PLOBJX
;
	BRA	FDSKIP
FDVREN	EQU	$
	STZ	PLNOST
FDSKIP	EQU	$
	STZ	<PLSTFG
	RTS
;;;
;---------------------------------------------------------------------------------------------------
;
	 END
