;
	include		mn_hp_smram.asm
;
	 ORG	  0D9CF0H
		EXTEND
		IDX8
		MEM8
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1985. 8.12	    V.1.0  Super Mario
;				   File	 name ; SMINIT
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	EXT	LDINIT,CMPBE
;=========================================================== SMMAIN ==
	 EXT	  BNBKDT,JSRSUB,MLSLPST,ENCSET
;........................................................... ( VRFLG )
	 EXT	  BKCG00
;........................................................... ( System mode )
	 EXT	  TLMOD,PYMOD,SCMOD,GVMOD,PRM400
	 EXT	  TLBGOT,GMBGOT,BGCVST,BGCRST,GVBGOT,PRMDSP
;........................................................... ( Block No. )
	 EXT	  SKY0,HOLE0,HOLE1,GRS0,WATR0,WATR1,CHM0
	 EXT	  HNDR0,CHM2,POLE0,MUSH0,LND0,CHM1,CORL0,WOOD3
	 EXT	  CLBK0,BRIK0,BRIK1,GRND0,PUBK1,FENC0,WOOD1,WOOD2
	 EXT	  WIRE0,WIRE1,PLY0,WIRE2,CAS0,ROCK0,BRGE0
	 EXT	  WOOD0,BGUN0,SPRIG,HDBK0,CSWL0,MSHP0,CHIN0
	 EXT	  STTL0,STEK0,BKBSW,BRIK2,COIN0,COIN1,WCHM0
	 EXT	  BXMUS,BKMUS,BRMUS
	 EXT	  BRWOD
	 EXT	  BKSTR,BRSTR
	 EXT	  BXCON
;.......................................................................... index )
	 EXT	  CLSET2,CLSET1
;........................................................... ( Cross Bk No. index )
	 EXT	  B00CS,B01CS,B10CS,B11CS
	 EXT	  BLNKBK
;..................................................................................
	 EXT	  DMTMDT,RAMCL0
;=========================================================== SMINIT ==
	 GLB	  ENFLFWR,FRIPFW;;;;,FICHMS1,FICHMS2
;=========================================================== SMINIT ==
	 GLB	  TLINT0,TLINT1,GMINT0,GMINT1,PLOUT,PLFAIL
	 GLB	  NWFRST,FRTADC,OAMCSD,OAMUCT
	 GLB	  GMOVER,CHRCLR,GMOVSB,GMOS50
	 GLB	  FRTBA0,FRTBA1,GRSTPD
	 GLB	  CMSTSB,ENEPCK,CMST200,OBSTST,CMSCBD
;........................................................... ( Obst set corde )
	 GLB	  OLD0,OHL0,OCM0,OMS0,OCO0,OBK0,OBK1,OWD0
	 GLB	  OPB0,OPB1,OPB2,OEW0,OEP0,OCS0,OWT0,OBOD
	 GLB	  OBG0,OBG1,OBG2,OCM2,OBCO,OBC1,OBC2,OST0
	 GLB	  OBBM,OBBW,OBBS,OLW0,OWC0,OSK0,OCH0,OSL0
	 GLB	  OSP0,SLON,OSCO,OSMS,ORBC,OBSM,ODMS,ODMT,OSDM,OSBM
	 GLB	  OCM1,OCM3,OPL0,OGN0,OBMS,BGCH,FCM1,FCM2
	 GLB	  SCON,SCOF,JFST,WFST,CSLP,EXOF,KZST,KZOF
	GLB	STTR,STST
	GLB	BRI0,BRI1,BRI2,OLBK
	GLB	OKID,ONBK,OCTL,OCTR,OCLC,OCRC,ORCK
;=========================================================== SMPLAY ==
	 EXT	  WDINIT,BKPSSB,BNBDID
;........................................................... ( Mode No. )
	 EXT	  PLSMMD,PLMDPY,PLSB,PLBS,PLBX,PLSF,GMBGMD
	 EXT	  PLTPMD
;........................................................... ( Statsu )
	 EXT	  BWALK,BJUMP,BDROP,PWIRE
;........................................................... ( LF & RT move value )
	 EXT	  WKLF,RNLF,WKRT,RNRT
;=========================================================== SMENMY ==
	 EXT	  FXFWRES,BITDT
;........................................................... ( Enemy kind No. )
	 EXT	  SHTR,BKTR,RDTR,FTR0,FTR2,FLWR,CFLG
	 EXT	  LFT0,LFT1,LFT2,LFT3,LFT4,ELV0,ELV1,GFLG
	 EXT	  SST0,SST1,SST2,SST3,SST4,SPRG
	 EXT	  PLBLPS,DSXPCR
	 EXT	  JFS0,TMK0,EXFF,FFWR
;=========================================================== SMCROS ==
;........................................................... ( Cross size No. )
	 EXT	  ENCMD,ELCMD,LFCMD
	 EXT	  CRDTST
;=========================================================== SMCROS ==
;;;;;;	 EXT	  MRFIC1
;=========================================================== SMCSET ==
	 EXT	  PLFRCK,PLPSCV,PLCSET
;=========================================================== SMFRDT ==
	 EXT	  FRDAST,RDCRDT,RDCOSS
;=========================================================== SMCOM ===
;
;=========================================================== SUB1 ====
	GLB	S1OBST,S1OBWK,S1FXTO,S1ENEP
	GLB	S1OBIT
	EXT	LRMVD,INCSLE,BG3SET
	EXT	PCHEND,ELWSET
;=========================================================== SMCNT
	 EXT	  GMOVSEL,CSDTSET
;=========================================================== SMSUB
	 EXT	  KAZEON,KAZEOFF,FRLPTD
;;;	    EXT	     FICHMS1,FICHMS2
;=================================================================
		EXT	CONTROL_C,ROM_ERROR
;=================================================================
;
;#####################################################################
;#	 OAM used area initial data				     #
;#####################################################################
OAMUD	 EQU	  $	    ;< OAM used area data !
	 HEX	  D0			    ; Player
	 HEX	  00,18,30,48,60,78,90,A8,C0	  ; Enemy
	 HEX	  D8,D8			    ; Mushu
	 HEX	  B0,C0			    ; Break block
	 HEX	  40,44,48		    ; Bubble
	 HEX	  50,54			    ; Fire ball
	 HEX	  60,68,70,78,80,88	    ; Score Up
	 HEX	  00,08,10,18		    ; Score Up
OME	 EQU	  $
;
;#####################################################################
;#	 OAM countrol data					     #
;#####################################################################
OAMUCT	 EQU	  OME-OAMUD-1	       ; Countrol OAM count !
;
OAMCSD	 EQU	  028H		       ; Countrol start point data !
;
OMCTD0	 EQU	  060H-028H	       ; Countrol OAM index data !
OMCTD1	 EQU	  0A8H-060H
OMCTD2	 EQU	  0FFH-0A8H+1
;
SCLOMDT	 EQU	  $		       ; Scroll oam data !
	 HEX	  18,FF,23,58
;
;
;#####################################################################
;#	 JSR	  TLINT0    [ Title initial No.0 ]		     #
;#####################################################################
TLINT0		EQU	$		; Clear	 score !
;;take;;		LDA	#00001111B
		LDA	#80H
		STA	!PASCFG
;
		LDA	#0FFH
		STA	>CGWORK+102H
		LDA	#07FH
		STA	>CGWORK+103H
		INC	!CGVMAF
;
		LDA	#0FFH
		STA	!VRAMD+2
		STA	!VRAMD+3
;
		LDA	#00001001B
		STA	!WD2105		; BG. mode&character size
		LDA	#00010000B
		STA	!WD212C		; display main
		LDA	#00100000B
		STA	!WD2131		; add.&sub. set
		LDA	#00100000B
		STA	!CGRED
		LDA	#01000000B
		STA	!CGGRN
		LDA	#10000000B
		STA	!CGBLU		; R.G.B. set
;
		LDY	#(RAMCR6)&0FFH
		LDX	#TPSCE-TOPSCR
GIT320		EQU	$
		LDA	TOPSCR,X
		CMP	#00AH
		BCS	GIT340
;
		DEX
		BPL	GIT320
;
		LDA	RSCKFG
		CMP	#0A5H
		BNE	GIT340
;
		LDY	#(RAMCR5-1)&0FFH
GIT340		EQU	$
		JSL	>RAMCL0		; RAM clear
;
		LDA	#0A5H
		STA	RSCKFG		; Reset start check flag
		STA	RDM		; Random intial set
;
		STZ	B2ADFG
		STZ	B2VFG
		STZ	BG2AD
		STZ	BG2AD+1
;
;
	 LDY	  #(RAMCR2-1)&0FFH
	 JSL	  >RAMCL0		; RAM clear
;
	 LDA	  #DMTMDT	  ; Flag set !
	 STA	  DEMOTM	       ; Demo start time set
;
	 JSL	  >RDCRDT		; Read course data
;
	JSR	GMINT0
	STZ	MFFLG
	RTS
;
;#####################################################################
;#	 JSR	  GMINT0    [ Game initial set No.0 ]		     #
;#####################################################################
GMINT0		EQU	$	  ; Clear RAM !
		LDY	!CORSNO
		CPY	#00DH
		BCC	GIT000			; course no. reset ?
;						; yes
		JSL	>RDCRDT			; Read course data
GIT000		EQU	$
	 LDY	  #(RAMCR1-1)&0FFH
	 JSL	  >RAMCL0	   ; RAM clear
;
GIT020	 EQU	  $
	 LDX	  #RMC251-RMC250
	 LDA	  #0
;
GIT030	 EQU	  $
	 STA	  TMES0,X	  ; Timer clear
	 DEX
	 BPL	  GIT030
;
	 LDA	  PLOWXP    ; Flag set !
	 LDY	  CHEVFG
	 BEQ	  GIT080	  ;- IF	 change environment ?	( NO ; GIT080 )
;
	 LDA	  NXFPT0
;
GIT080	 EQU	  $
	 STA	  DSXP00	       ; Display start (x)pos (H)
	 STA	  FRPTP0	       ; Start frame pattern index (H)
	 STA	  OBRDFG	       ; Obstacle read flag
;
	PHY
	MEM16
	REP	#00100000B		; memory 16 bit mode
;
	XBA
	AND	#0FF00H
	STA	<SCCH1
	LSR	A
GIT085	EQU	$
	STA	  SCCH21
	LSR	A
	STA	SCCH31
;
	MEM8
	SEP	#00100000B		; memory 8 bit mode
	PLY
;
	JSR	DSXPCR			; Display pos right side calc
;
	 LDY	  #00H
	 AND	  #00000001B
	 BEQ	  GIT100
;
	 LDY	  #04H
;
GIT100	EQU	$
	STY	VRWTA0			; V-RAM BG wright address (H) set
;
	STZ	VRWTA1			; V-RAM BG wright address (L) set
;
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 STA	  FRTWPT	       ; Frame table wright point init
;
	LDA	#0FFH
	STA	OBWORK			; Obstacle display work area No.1 init
	STA	OBWORK+1		;			     No.2
	STA	OBWORK+2		;			     No.3
	STA	OBWORK+3		;			     No.4
	STA	OBWORK+4		;			     No.5
;
	 LDA	  #0BH
	 STA	  BSBGCT	       ; Base BG display counter set
;
	 JSL	  >FRDAST		; Display frame data address & flag set
;
;;;;	     LDA      GMLOOP		   ; Enemy level check & set !
	 LDA	  URAFLG
	 BNE	  GIT170		    ;2loop > ?
;					    ;no
	 LDA	  CORSNO
	 CMP	  #03H
	 BCC	  GIT180		    ;set ok ?
;					    ;yes
	 BNE	  GIT170		    ;5 course ?
;					    ;yes
	 LDA	  GOALCT
	 CMP	  #03H
	 BCC	  GIT180		    ;set ok ?
;					    ;yes
GIT170	 EQU	  $
	 INC	  ENLVFG
;
GIT180	 EQU	  $
	 LDA	  PLOWXP
	 BEQ	  GIT200	       ;- IF  out player on the way ?  ( NO ; GIT200 )
;
	 LDA	  #2
	 STA	  PLFPFG		    ; Player first pos flag walk set
;
GIT200	EQU	$
	LDA	<BG2COS
	CMP	#07H
	BEQ	GIT205
	CMP	#41H
	BEQ	GIT205
	LDA	#80H
	STA	!SOUND2			; Sound BGM clear ( temp up no clear )@@@
;
GIT205	EQU	$
	 LDA	  #1
	STA	MFFLG		;;T;;
;	  STA	   BGBKFG		; BG Branking ON
;
	 INC	  GMMODE	       ; Next game BG out mode set
;
	 RTS
;
;#####################################################################
;#	 JSR	  TLINT1    [ Title initial No.1 ]		     #
;#####################################################################
TLINT1	 EQU	  $
		LDA	02142H
		CMP	#015H
		BEQ	TITL1_40		; title B.G.M. set ?
;						; yes
		JSL	>CONTROL_C		; controlor check
		LDA	#015H
		STA	02142H
TITL1_40	EQU	$
	 LDA	  #1
	 STA	  PLFSFG	  ; Player first start flag ON
	 STA	  PLSIZE	  ;	   size small set
;
;	 LDA	  #2
;	 STA	  PLCNT		  ; Player existra set
;	 STA	  WPLCNT
;;;;;----------------------------- NUTS CLEAR
	 STZ	  NUTS
;
;#####################################################################
;#	 JSR	  GMINT1    [ Game initial set No.1 ]		     #
;#####################################################################
GMINT1	 EQU	  $
	 LDA	  #02H
	STA	MFFLG
	LDA	#20H
	TSB	!SOUND1
	LDA	#000H
	STA	PASCFG
	 STA	  BGBKFG	  ; BG Branking OFF
	 STA	  KAZEFG	  ;kaze check flag clear
	 STA	  GLSNDF	  ;goal sound check flag off
;
	 TAY
;
GMI130	 EQU	  $
	 STA	  0300H,Y	  ; 300H - 3FFH	 0 clear
	 INY
	 BNE	  GMI130
;
	 STA	  TMUPFG	  ; Clear  time up flag
	 STA	  MGSTFG	  ; Messarge display stop flag OFF
	 STA	  OBRDFG	  ; Obstacle read flag
;
	 LDA	  #0FFH
	 STA	  LFSTWK	  ; Lift set work aera
		STA	!VRAMD+2
;
	 LDA	  DSXP00
	 AND	  #00000001B
	 STA	  MSBH		  ; MSBH  set
;;;	    LSR	     CTLR0
;;;	    AND	     #00000001B
;;;	    ROR	     A
;;;	    ROL	     CTLR0	     ; MSB set
;
;;TM	     JSR      BGMSET	      ; BGM set
;
	 LDA	  #OMCTD0	  ; OAM countrol data set !
	 STA	  OAMCTD+2
;
	 LDA	  #OMCTD1
	 STA	  OAMCTD+1
;
	 LDA	  #OMCTD2
	 STA	  OAMCTD
;
	 LDX	  #OAMUCT	  ; OAM used data initial set !
;
GMI175	 EQU	  $
	 LDA	  OAMUD,X
	 STA	  OAM00,X
;
	 DEX
	 BPL	  GMI175
;;T;;	LDA	#080H
;	STA	OAMFEN
;	LDA	#098H
;	STA	OAMFEN+1
;	LDA	#0B0H
;	STA	OAMFEN+2
;
;	  LDY	   #03H		   ; OBJ set used Scroll parts move !
;;
;GMI177	  EQU	   $
;	  LDA	   SCLOMDT,Y
;	  STA	   OAM,Y
;	  DEY
;	  BPL	   GMI177		;- IF  set end ?  ( NO ; GMI177 )
;
;;;;;	      JSR      GMLVST	       ; Game level set
	 JSR	  ENFSIN	  ; Enemy     "      "
;
	 INC	  SCRFLG	  ; Prats scroll flag ON
	 INC	  GMMODE	  ; Next game play mode set
;
;
	 RTS
;
;---------------------------------------------------------------<< Player routine
;
;#####################################################################
;#	 Player out data					     #
;#####################################################################
PLOTXP	 EQU	  $	    ; Out pos(x) !
	 HEX	  28,18,38,28
;
PYFXID	 EQU	  $-2	    ; Out pos(y)  sub data !
	 BYTE	  POY90-PLOTYP
	 BYTE	  PLOTYP-PLOTYP
;
PLOTYP	 EQU	  $	    ; Out pos(y) !
	 HEX	  00		  ; 0 Set drop ( xxx	--! water )
	 HEX	  20		  ; 1	       ( ground --! underground )
	 HEX	  B0		  ; 2 Set walk
	 HEX	  50		  ; 3	       ( in castle )
	 HEX	  00		  ; 4
	 HEX	  00		  ; 5
	 HEX	  B0		  ; 6 Set walk ( next underwater )
	 HEX	  B0		  ; 7	       (      underground )
POY90	 HEX	  F0		  ; 8 L-Chimney --! Ground chimney
;
PLOJPD	 EQU	  $	    ; OBJ priority !
	 HEX	  2E,0E,2E,2E
	 HEX	  2E,2E,2E,2E
	 HEX	  0E
;
PYTMD0	 EQU	  $-1	    ; Game playing time data !
	 HEX	  04,03,02
;
;#####################################################################
;#	 JSR	  PLOUT	    [ Player out set ]			     #
;#####################################################################
PLOUT	 EQU	  $
	 LDA	  DSXP00
	 STA	  <PLXPS0
;
	 LDA	  #28H
	 STA	  WGPOWR	  ; G power set
;
	 LDA	  #00000001B
	 STA	  PLCMKI	  ; Chara muki set
	 STA	  <PLYPS0	   ; (y)pos (H) set
;
	 LDA	  #BWALK
	 STA	  <PLSTAT	   ; Status set
;
	 DEC	  PLCRFG	  ; Cross flag
;
	 LDY	  #0
	 STY	  PLOWXP	  ; Clear  Player on the way (x)pos (H)
;
	 LDA	  <ENVRFG
	 BNE	  PLOT30
;
	 INY
;
PLOT30	 EQU	  $
	 STY	  PLSMFG	  ; In water flag set
;
	 LDX	  PLFPFG
	 LDY	  CHEVFG
	 BEQ	  PLOT60	  ;- IF	 set turning point ?	      ( NO ; PLOT60 )
;
	 CPY	  #1
	 BEQ	  PLOT60	  ;- IF	 I-chimney --! underground ?  ( YES ; PLOT60 )
;
	 LDX	  PYFXID,Y
;
PLOT60	 EQU	  $
	 LDA	  PLOTXP,Y
	 STA	  PLXPS1	  ; First (x) pos (L) set
;
	 LDA	  PLOTYP,X
	 STA	  PLYPS1	  ; First (y) pos (L) set
;
	 LDA	  PLOJPD,X
	 STA	  PLOJBG	  ; OBJ & BG priority
;;T;;
	 LDX	  #0
	 JSR	  CRDTST

;;T;;
	 JSL	  >CLSET2	   ; Player color set
;;;;;;	 LDA	  POWLEV
;;;;;;	 CMP	  #2
;;;;;;	 BNE	  PLOT65	  ;- IF	 have fire ball ?	      ( NO ; PLOT65 )
;
;;;;;;	 JSR	  MRFIC1	       ; Set mario color change
;
PLOT65	 EQU	  $
	 LDY	  PYGMTM	  ; Play time set !
	 BEQ	  PLOT70	       ;- IF  no set play time ?      ( YES ; PLOT70 )
;
	 LDA	  PLFSFG
	 BEQ	  PLOT70	       ;- IF  first start player ?    ( NO ; PLOT70 )
;
	 LDA	  PYTMD0,Y
	 STA	  PLYTM0-1		    ; Play time (H) set
;
	 LDA	  #1
	 STA	  PLYTM1		    ; Play time (L) set
;
	 LSR	  A
	 STA	  PLYTM0		    ; Play time buffer
	 STA	  PLFSFG		    ; Player first start flag OFF
	 STA	  SPMTIM		    ; Clear super mario mode
;
PLOT70	 EQU	  $		  ; Wood set !
	 LDY	  PLUWFG
	 BEQ	  PLOT75	       ;- IF  up on wood flag ON ?    ( NO ; PLOT75 )
;
	 LDA	  #PWIRE
	 STA	  <PLSTAT		     ; Player status is up on wood
;
	 LDX	  #0
	 JSR	  BKPSSB		    ; Wood (x)pos (H,L) & (y)pos (h) set
;
	 LDA	  #0F0H
	 STA	  <BKYPS1		     ; Wood (y)pos (L) set
;
	 LDX	  #WDCMOD-ENCMOD
	 LDY	  #0
	 JSR	  WDINIT		    ; Wood set
;
PLOT75	 EQU	  $		  ; Bubble set !
	 LDY	  <ENVRFG
	 BNE	  PLOT80	       ;- IF  underwater ?	      ( NO ; PLOT80 )
;
	 JSR	  PLBLPS	       ; Player bubble pos set
;
PLOT80	 EQU	  $
	 LDA	  #PLSMMD
	 STA	  <PLCMOD	   ; Player start move mode set
;
	 RTS
;
;#####################################################################
;#	 Game restart point data				     #
;#####################################################################
GRSTPD	 EQU	  $
	 HEX	  66,60		  ; Course - 1
	 HEX	  88,60		  ;	   - 2
	 HEX	  66,70		  ;	   - 3
	 HEX	  77,60		  ;	   - 4
	 HEX	  D6,00		  ;	   - 5
	 HEX	  77,80		  ;	   - 6
	 HEX	  70,B0		  ;	   - 7
	 HEX	  00,00		  ;	   - 8
	 HEX	  00,00		  ;	   - 9
	 HEX	  00,00		  ;	   - A
	 HEX	  00,00		  ;	   - B
	 HEX	  00,00		  ;	   - C
	 HEX	  00,00		  ;	   - D
;
;#####################################################################
;#	 JSR	  PLFAIL    [ Player fail ]			     #
;#####################################################################
PLFAIL	EQU	$
	LDA	#01
	STA	MFFLG
	STA	ENCLFG
;	INC	BGBKFG			; BG blanking ON
;
	STZ	SCRFLG			; Scroll parts move OFF
;
;;;;;;;;	LDA	#80H
;;;;;;;;	STA	0FCH			; Sound BGM clear @@@@@@@@
;
;;PL	LDA	PLCNT
;;PL	BNE	PLFL40
;;;;;;;;;;;;;;;;;;;		   PHX				   ; (X) push
;;;;;;;;;;;;;;;;;;;		   LDX	   #000H
;;;;;;;;;;;;;;;;;;;		   TXA
;;;;;;;;;;;;;;;;;;;		   CLC
;;;;;;;;;;;;;;;;;;;ROM_CK_00	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   ADC	   >ROM_CK_S,X
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   CPX	   #ROM_CK_E-ROM_CK_S
;;;;;;;;;;;;;;;;;;;		   BNE	   ROM_CK_00		   ;
;;;;;;;;;;;;;;;;;;;;						   ;
;;;;;;;;;;;;;;;;;;;		   CMP	   #067H
;;;;;;;;;;;;;;;;;;;		   BEQ	   ROM_CK_S		   ; check-sum ok ?
;;;;;;;;;;;;;;;;;;;;						   ; no
;;;;;;;;;;;;;;;;;;;		   PLX				   ; (X) pull
;;;;;;;;;;;;;;;;;;;		   JMP	   >ROM_ERROR
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;ROM_CK_S	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   PLX				   ; (X) pull
		DEC	PLCNT
		BPL	PLFL40			; IF  player != 0 ? ( YES ; PLFL40 )
;
		STZ	GMMODE			; Game over flag set !
;
		LDA	#GVMOD
		STA	SYMODE			; Next mode Game Over
		RTS
;;;;;;;;;;;;;;;;;;;ROM_CK_E	   EQU	   $
;
;
PLFL40	EQU	$			; Onecemore game flag set !
;;PL	DEC	PLCNT
	LDA	CORSNO			; Restart player on the way point calc !
	ASL	A
	TAX
;
	LDA	GOALCT
	AND	#00000010B
	BEQ	PLFL60
;
	INX
;
PLFL60	EQU	$
	LDY	GRSTPD,X
	LDA	GOALCT
	LSR	A
	TYA
	BCS	PLFL70
;
	LSR	A
	LSR	A
	LSR	A
	LSR	A
;
PLFL70	EQU	$
	AND	#0FH
	CMP	DSXP00
	BEQ	PLFL80
	BCC	PLFL80			; IF over restart point ? ( YES ; PLFL80 )
;
	LDA	#0
;
PLFL80	EQU	$
	STA	PLOWXP			; Set Player on the way (x)pos (H)
;
	JSR	VSPLCK			; vs Player check
	JMP	GMOS50			; Set Next game mode
;
;#####################################################################
;#	 JSR	  GMOVER    [ Game over ]			     #
;#####################################################################
GMOVER		EQU	$
		LDA	GMMODE
		ASL	A
		TAX
		JMP	(OVERTBL,X)
;;;;;;;;		JSR	JSRSUB
OVERTBL		EQU	$
		WORD	GMOVIT		; Game over init
		WORD	GVBGOT		;	    BG messarge
		WORD	GMOVPR		;	    pros
;
;#####################################################################
;#	 JSR	  GMOVIT    [ Game over initial ]		     #
;#####################################################################
GMOVIT	EQU	$
	STZ	BGOTMD
	STZ	SCRFLG
	STZ	SELFLG
	STZ	PASTIM			;corsol flash timer clear (game over use)
;
	LDA	#0AH
	STA	!SOUND2			; Sound game over @@@@@@@@@@
;
	INC	BGBKFG			; BG blanking ON
	INC	GMMODE
;
	RTS
;
;#####################################################################
;#	 JSR	  GMOVPR    [ Game over pros ]			     #
;#####################################################################
GMOVPR	EQU	$
;;;	LDA	#02
;;;	STA	MFFLG
;;;	STZ	FADFLG
;	STZ	BGBKFG			; BG blanking OFF
;
;;;	    LDA	     CORSNO
;;;	    CMP	     #08H
;;;	    BEQ	     GMPR40	     ;W-9 ?
;				  ;no
	 JMP	  GMOVSEL	  ;game over select sub.
;
;
GMPR40	 EQU	  $
	 LDA	  MSDSTM
	 BNE	  GMOS20	  ;timer = 0 ?
;				  ;yes
;
;#####################################################################
;#	 JSR	  GMOVSB    [ Game over pros sub ]		     #
;#####################################################################
GMOVSB	EQU	$
;;;;;;;;	LDA	#080H
;;;;;;;;	STA	0FCH		; Sound	 BGM clear @@@@@@
;
	JSR	VSPLCK
	BCC	GMOS50		; IF next vs player ?  ( YES ; GMOS50 )
;
	LDA	CORSNO		; Next title mode set !
	STA	CTNCOS		; Save	countinue start course No.
;
	STZ	GMMODE
	STZ	GMOVTM
;
;;;;	( LDA	#TLMOD )
	STZ	SYMODE		; Next systeme mode - Title
;
GMOS20	 EQU	  $
	RTS
;
GMOS50	EQU	$		; Next game mode set !
	JSL	>RDCRDT		; Read course data
;
	LDA	#1
	STA	PLSIZE		; Player size small set
;
	INC	PLFSFG		; first start check flag ON
;
	STZ	GMSTTM		; Clear game stop timer
	STZ	POWLEV		;	power level ( fire ball )
	STZ	<CMODE		;	 out mode set
	STZ	GMMODE		; Next game initial mode set
;
	LDA	#PYMOD
	STA	SYMODE		; Next game mode set
;
GMOS90	EQU	$
;
	RTS
;
;#####################################################################
;#	 JSR	  VSPLCK    [ vs player check & set ]		     #
;#		     <C> -- 0 ; vs Player OK  next game		     #
;#			    1 ;		  END			     #
;#####################################################################
VSPLCK	 EQU	  $
	 SEC
	 LDA	  PLAYSW
	 BEQ	  VSPC90	  ;- IF	 2 player game ?	    ( NO ; VSPC90 )
;
	 LDA	  WPLCNT
	 BMI	  VSPC90	  ;- IF	 vs player game over ?	    ( YES ; VSPC90 )
;
	 LDA	  MRLGFG	  ; Change player !
	 EOR	  #1
	 STA	  MRLGFG	       ; Change Mario & Luige flag
;
	 LDX	  #MLCRM1-MLCRM0-1
;
VSPC50	 EQU	  $
	 LDA	  MLCRM0,X
	 PHA
	 LDA	  MLCRM1,X
	 STA	  MLCRM0,X
	 PLA
	 STA	  MLCRM1,X	       ; Change	 Player exstra
;				       ;	 Course No. & Course index
	 DEX			       ;	 Gorl count
	 BPL	  VSPC50	       ;	 Coin count
;
	 CLC
;
VSPC90	 EQU	  $
;
	 RTS
;
;---------------------------------------------------------------------<< Enemy routine
;
;#####################################################################
;#	 JSR	  ENFSIN    [ Enemy farst flag initial ]	     #
;#####################################################################
ENFSIN	 EQU	  $
	 LDA	  #0FFH
	 STA	  ENOTCT	  ; Enmey out counter	  init
;
;---------------------------------------------------------------------<< Game level set routine
;
;#####################################################################
;#	 JSR	  GMLVST    [ Game level set ]			     #
;#####################################################################
GMLVST	 EQU	  $
;
	 RTS
;
;---------------------------------------------------------------------<< New frame data set routine
;
;#####################################################################
;#	 JSR	  NWFRST    [ New frame data set ]		     #
;#####################################################################
NWFRST	EQU	$
	LDY	NWSTCT
	BNE	NWFS10
;
	LDY	#8
	STY	NWSTCT
;
NWFS10	EQU	$
	DEY
	TYA
	JSR	NWFS30		; New frame read data set
;
	DEC	NWSTCT
	BNE	NWFS20		; IF  all set end ?  ( NO ; NWFS20 )
;
	LDA	#20H
	STA	<WORK0
	LDA	<KDVRFG
	CMP	#03H
	BNE	NWFS01		; Castle ?
	ASL	<WORK0		; yes
;
NWFS01	EQU	$
	LDA	!BBSCHL
	BNE	NWFS20
	LDA	SCCH21
	AND	<WORK0
	BEQ	NWFS11
	LDA	BG2WT
	BEQ	NWFS12
	BRA	NWFS20
NWFS11	EQU	$
	LDA	BG2WT
	BEQ	NWFS20
	STZ	BG2WT
	BRA	NWFS15
NWFS12	EQU	$
	LDA	#01H
	STA	BG2WT
;
NWFS15	EQU	$
	JSL	>LRMVD
;
	 JSR	  BGCRST	       ; BG area color set
;
NWFS20	EQU	$
;
	LDA	SCCH31
	AND	#10H
	BEQ	NWFS21
	LDA	BG3WT
	BEQ	NWFS22
	BRA	NWFS28
NWFS21	EQU	$
	LDA	BG3WT
	BEQ	NWFS28
	STZ	BG3WT
	BRA	NWFS25
NWFS22	EQU	$
	LDA	#01H
	STA	BG3WT
;
NWFS25	EQU	$
	JSL	>BG3SET
NWFS28	EQU	$
	RTS
;
NWFS30		EQU	$
		ASL	A
		TAX
		JMP	(NWFS30TBL,X)
;;;;;;;;		JSR	JSRSUB
NWFS30TBL	EQU	$
		WORD	POITCL		; 0  Pointer calc
		WORD	BGCVST		; 1  BG convert data set Right
		WORD	BGCVST		; 2	   "      "	 Left
		WORD	NWFRRD		; 3  New data read
;
		WORD	POITCL		; 4  Pointer calc
		WORD	BGCVST		; 5  BG convert data set Right
		WORD	BGCVST		; 6	   "      "	 Left
		WORD	NWFRRD		; 7  New data read
;
;#####################################################################
;#	 JSR	  POITCL    [ Frame data set pointer calc ]	     #
;#####################################################################
POITCL	 EQU	  $
	 INC	  FRPTP1	  ; Calc frame pattren & floor pattren index !
	 LDA	  FRPTP1
	 AND	  #0FH
	 BNE	  PTCL20
;
	 STA	  FRPTP1
;
	 INC	  FRPTP0
;
PTCL20	 EQU	  $		  ; Calc frame data table wright index !
	 INC	  FRTWPT
	 LDA	  FRTWPT
	 AND	  #1FH
	 STA	  FRTWPT
;
	 RTS
;
;#####################################################################
;#	 Frame pattern data					     #
;#####################################################################
FRPIDD	 EQU	  $
	 BYTE	  000H			 ; Sky
	 BYTE	  030H			 ; Ground
	 BYTE	  060H			 ; Ground 2
;
;#####################################################################
;#	 Block line No. data table  ( JSR  FRPTST )		     #
;#####################################################################
BKLNDT	EQU	$
;
	BYTE	HOLE0,HOLE0,HOLE0	; KUMO	    1
	BYTE	HOLE0,HOLE0,HOLE0	; KUMO	    2
	BYTE	HOLE0,HOLE0,HOLE0	; KUMO	    3
;
	BYTE	GRS0,SKY0,SKY0		; KUSA	    4
	BYTE	GRS0+1,SKY0,SKY0	; KUSA	    5
	BYTE	GRS0+2,SKY0,SKY0	; KUSA	    6
;
	BYTE	HOLE0,HOLE0,HOLE0	; YAMA	    7
	BYTE	HOLE0,HOLE0,HOLE0	; YAMA	    8
	BYTE	HOLE0,HOLE0,HOLE0	; YAMA	    9
;
	BYTE	FENC0,SKY0,SKY0		; SAKU	    A
;
	BYTE	WOOD1,WOOD1+2,WOOD2	; KI 1	    B
;
	BYTE	WOOD1+1,WOOD2,WOOD2	; KI 2	    C
;
;#####################################################################
;#	 Frame base BG data    ( JSR  FRBBST )			     #
;#####################################################################
NWFBID	EQU	$-1
NFL30	BYTE	BSL3-NWFLBD		; 1 Underwater
NFLE0	BYTE	BSLD-NWFLBD		; 2 Castle wall
NFL40	BYTE	BSL4-NWFLBD		; 3 Water face
;
NWFLBD	EQU	$		; Base block line data !
BSL3	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,HOLE0		; Underwater
	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,ROCK0,ROCK0
;
BSLD	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,HOLE0		; Castle wall
	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,HOLE0
;;K;;BSLD	BYTE	SKY0,SKY0,SKY0,SKY0,SKY0,CAS0			; Castle wall
;;K;;	BYTE	CAS0+2,CAS0+2,CAS0+2,CAS0+2,CAS0+2,SKY0,SKY0
;
BSL4	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,HOLE0		; Water face
	BYTE	HOLE0,HOLE0,HOLE0,HOLE0,HOLE0,WATR0+2,WATR1+1
;
ENBKDT	EQU	$		; environment data
	BYTE	ROCK0+1,GRND0,BRIK1,CSWL0
;
;*********************************************************************
;*	 Frame floor set data  ( JSR  FRFLST )			     *
;*********************************************************************
FLRNDT	 EQU	  $
	 BIN	  00000000,00000000		   ; 0
	 BIN	  00000000,00011000		   ; 1
	 BIN	  00000001,00011000		   ; 2
	 BIN	  00000111,00011000		   ; 3
	 BIN	  00001111,00011000		   ; 4
	 BIN	  11111111,00011000		   ; 5
	 BIN	  00000001,00011111		   ; 6
	 BIN	  00000111,00011111		   ; 7
	 BIN	  00001111,00011111		   ; 8
	 BIN	  10000001,00011111		   ; 9
	 BIN	  00000001,00000000		   ; A
	 BIN	  10001111,00011111		   ; B
	 BIN	  11110001,00011111		   ; C
	 BIN	  11111001,00011000		   ; D
	 BIN	  11110001,00011000		   ; E
	 BIN	  11111111,00011111		   ; F
;
;#####################################################################
;#	 JSR	  NWFRRD    [ New frame data read ]		     #
;#####################################################################
NWFRRD	 EQU	  $
	 LDA	  OBRDFG
	 BEQ	  NWFD30    ;- IF  read idle ?	( NO ; NWFD30 )
;
	 JSR	  FROCST	  ; Read idle frame obst chara data
;
NWFD30	 EQU	  $
;#####################################################################
;#	 JSR	  FRPTST    [ Frame pattern set ]		     #
;#####################################################################
FRPTST	 EQU	  $
	 LDX	  #NWF1L-NWFRLD	  ; Clear new frame line buffer !
	 LDA	  #HOLE0
;
FRPS10	 EQU	  $
	 STA	  NWFRLD,X
	 DEX
	 BPL	  FRPS10
;
	 LDY	  BBGFG1
	 BEQ	  BKLS90	     ; TO RETURN
;
	 LDA	  FRPTP0	      ; SET BG HIGH X
;
FRPS12	 EQU	  $
;
	 CMP	  #03H
	 BMI	  FRPS14
;
	 SEC
	 SBC	  #03H
	 BPL	  FRPS12
;
FRPS14	 EQU	  $
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
;
	 ADC	  FRPIDD-1,Y	      ;
;
	 ADC	  FRPTP1	      ; SET BG LOW  X
	 TAX
;
	 LDA	  >FRLPTD,X
	 BEQ	  BKLS90	       ; TO RETURN
;
	 PHA
	 AND	  #0FH		       ; POINTER KEISAN
	 SEC
	 SBC	  #01H		       ; ;: 0->0
	 STA	  <WORK			;    1->3
	 ASL	  A		       ;    2->6
	 ADC	  <WORK
;
	 TAX
;
	 PLA
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAY
;
	 LDA	  #03H		  ; 3 CHARA SET
	 STA	  <WORK
;
BKLS80	 EQU	  $
;
	 LDA	  BKLNDT,X	  ; DATA SET
	 STA	  NWFRLD,Y
;
	 INX
	 INY
	 CPY	  #0BH
	 BEQ	  BKLS90
;
;
	 DEC	  <WORK
	 BNE	  BKLS80
;
BKLS90	 EQU	  $
;#####################################################################
;#	 JSR	  FRBBST    [ Frame base BG set ]		     #
;#####################################################################
FRBBST	EQU	$
	LDX	BBGFG0
	BEQ	FBBS30
	LDY	NWFBID,X
;
	LDX	#0
;
FBBS10	EQU	$
	LDA	NWFLBD,Y
	BEQ	FBBS20
;
	PHY
	LDY	<ENVRFG
	BNE	FBBS11
	LDY	<BG2COS
	CPY	#45H
	BEQ	FBBS15
	LDY	WTRLFG
	BNE	FBBS13
	INC	WTRLFG
	INC	A
	BRA	FBBS12
FBBS13	EQU	$
	STZ	WTRLFG
	BRA	FBBS15
FBBS11	EQU	$
	CPY	#03H		; Castle ?
	BNE	FBBS15
	CMP	#86H
	BNE	FBBS15
FBBS12	EQU	$
	INC	A		; yes
	INC	A
FBBS15	EQU	$
	PLY
;
	STA	NWFRLD,X
;
FBBS20	EQU	$
	INY
;
	INX
	CPX	#NWF1L-NWFRLD+1
	BNE	FBBS10
;
FBBS30	EQU	$
;*********************************************************************
;*	 JSR	  FRFLST    [ Frame floor set ]			     *
;*********************************************************************
FRFLST	EQU	$
	STZ	KWORK7
	STZ	<KWORK6
	LDA	BSBGMT
	STA	BSBGKZ
	INC	BSBGMT
	LDY	<ENVRFG
	BNE	FRFLS10		; water ?
;				; yes
	LDA	<BG2COS		;CORSNO
	CMP	#41H
	BNE	FRFLS10		; 8world ?
;				; yes
	LDA	#CSWL0
	BRA	FRFLS20
;
FRFLS10 EQU	$
	LDA	ENBKDT,Y
	LDY	SKYFLG
	BEQ	FRFLS20		; sky ?
;				; yes
	LDA	#CLBK0
FRFLS20 EQU	$
	STA	<WORK+7
;
	 LDX	  #00H
FRFLS40	 EQU	  $
	 LDA	  FLRNO
	 ASL	  A
	 TAY
FRFLS60	 EQU	  $
	 LDA	  FLRNDT,Y
	 STA	  <WORK
	 INY
	 STY	  <WORK+1      ;(work+1) <-- next pointer
;
	 LDA	  SKYFLG
	 BEQ	  FRFLS70     ;sky ?
;			      ;yes
	 CPX	  #00H
	 BEQ	  FRFLS70     ;secound ?
;			      ;yes
	LDA	<WORK
	AND	#08H
	STA	<WORK
FRFLS70 EQU	$
	LDY	#00H
FRFLS80 EQU	$
	LDA	BITDT,Y
	BIT	<WORK
	BEQ	FRFLS95		; bit on ?
;				; yes
	LDA	!BG2COS
	CMP	#09H
	BEQ	FRFLS85
	LDA	<KDVRFG
	CMP	#03H		; in Castle ?
	BNE	FRFLS85		; no --> FRFLS85
	LDA	<KWORK6
	BEQ	FRFLS85
	LDA	#CSWL0+3
	STA	<WORK7
	BRA	FRFLS88
FRFLS85 EQU	$
	LDA	<WORK7
FRFLS88 EQU	$
	STA	NWFRLD,X	; unit NO. set
;
	LDA	<KWORK6
	BEQ	FRFLS90
	LDA	<KDVRFG
	CMP	#03H
	BNE	FRFLS90
	LDA	<KWORK6
	INC	<KWORK6
	INC	A
	BNE	FRFLS100
	INC	NWFRLD,X
	INC	<WORK7
	BRA	FRFLS100
;
FRFLS90 EQU	$
	LDA	<KDVRFG
	CMP	#03H
	BNE	FRFLS100
	LDA	!SKYFLG
	BNE	FRFLS100
	LDA	KWORK7
	BNE	FRFLS100
	LDA	BSBGKZ
	AND	#01H
	BNE	FRFLS100
	INC	NWFRLD,X
	BRA	FRFLS100
FRFLS95 EQU	$
	LDA	#0FEH
	STA	<KWORK6
	INC	KWORK7
FRFLS100 EQU	  $
	 INX
	 CPX	  #NWF1L-NWFRLD+1
	 BEQ	  FRFLS200    ;end ?
;			      ;no
	 LDA	  <ENVRFG
	 CMP	  #02H
	 BNE	  FRFLS120    ;underground ?
;			      ;yes
	 CPX	  #NWF1L-NWFRLD-1
	 BNE	  FRFLS120    ;set data change ?
;			      ;yes
	 LDA	  #GRND0
	 STA	  <WORK+7      ;set data change
FRFLS120 EQU	  $
	INC	BSBGKZ
	 INY
	 CPY	  #08H
	 BNE	  FRFLS80     ;pointer change ?
;			      ;yes
	LDY	<WORK+1
	BEQ	FRFLS200
	JMP	FRFLS60
;;;;;	BNE	FRFLS60
;
FRFLS200	EQU	$
		LDA	!NWFRLD+0CH
		CMP	#GRND0
		BEQ	FRFLS201
		CMP	#ROCK0+1
		BNE	FRFLS205
FRFLS201	EQU	$
		INC	!NWFRLD+0CH
FRFLS205	EQU	$
;#####################################################################
;#	 JSR	  FROCST    [ Frame obstacle chara set ]	     #
;#####################################################################
	 JSR	  FROCST
;
;#####################################################################
;#	 JSR	  FRTBST    [ Frame table set ]			     #
;#####################################################################
FRTBST		EQU	$
		LDA	FRTWPT
		JSR	FRTADC
;
		LDA	!NWFRLD+0BH
		CMP	#ROCK0
		BNE	FRTS05
		STA	!NWFRLD+0CH
FRTS05		EQU	$
		LDX	#00H
		TXY
;
FRTS10		EQU	$
		STY	<WORK
;
		LDA	!PHEDFG
		BNE	FRTS49
;
		LDA	NWFRLD,X
		AND	#11000000B
		ASL	A
		ROL	A
		ROL	A
		TAY
		LDA	NWFRLD,X
		CMP	CRBNID,Y
		BCS	FRTS40
;
		LDA	#0
;
FRTS40		EQU	$
		LDY	<WORK
		STA	(<WORK+6),Y
;
		TYA
		CLC
		ADC	#FRT1L-FRMTB0+1
		TAY
;
		INX
		CPX	#NWF1L-NWFRLD+1
		BCC	FRTS10
;
FRTS49		EQU	$
		RTS
;
CRBNID		EQU	$			; Cross block index data !
		BYTE	B00CS,B01CS,B10CS,B11CS
;
;######################################################################
;#	 Obstacle data value					     #
;#####################################################################
OLD0	 EQU	  010H	    ; 1	 Land
OMS0	 EQU	  OLD0	    ; 1	 Mushroom
OGN0	 EQU	  OLD0	    ; 1	 Big gun
OBK0	 EQU	  020H	    ; 2	 Floor ( break )
OBK1	 EQU	  030H	    ; 3	 Floor ( no break )
OCO0	 EQU	  040H	    ; 4	 Bonus coin
OPB0	 EQU	  050H	    ; 5	 * Pile up brick-0 ( break )
OPB1	 EQU	  060H	    ; 6	 *		-1 ( no break )
OPB2	 EQU	  OPB1	    ;
OCM0	 EQU	  078H	    ; 7	 I-chimney ( enter )
OCM2	 EQU	  070H	    ; 8		   ( no enter )
;
;
OHL0	 EQU	  000H	    ; 0	 Sky & Hole
OEP0	 EQU	  010H	    ; 1	 Elevator wire & pulley
OBG0	 EQU	  020H	    ; 2	 Bridge-0
OBG1	 EQU	  030H	    ; 3	 Bridge-1
OBG2	 EQU	  040H	    ; 4	 Bridge-2
OWT0	 EQU	  050H	    ; 5	 Water face
OBC1	 EQU	  060H	    ; 6	 Coin in block ( floor-2 )
OBC2	 EQU	  070H	    ; 7		       ( floor-3 )
;
OEW0	 EQU	  000H	    ; 0	 Elevator wire
OLW0	 EQU	  010H	    ; 1	 Lift	  wire
OCS0	 EQU	  020H	    ; 2	 Castle
OST0	 EQU	  030H	    ; 3	 Block step
OCM1	 EQU	  040H	    ; 4	 L-chimney No.0 ( underground --! ground )
OWD0	 EQU	  050H	    ; 5	 Wood
FCM1	 EQU	  060H	    ; 6	 Flip chimmy - 1 (20H)
FCM2	 EQU	  070H	    ; 7	 Flip chimmy - 2 (60H)
;
;;K;;
STTR	EQU	016H	; see thru tu-ru
STST	EQU	018H	; see thru star
BRI0	EQU	022H	; Bridge-0
BRI1	EQU	024H	; Bridge-1
BRI2	EQU	026H	; Bridge-2
OLBK	EQU	028H	; yo-ko ni na-ga-i brock
OKID	EQU	032H	; ka-i-da-n unit NO.
ONBK	EQU	034H	; No Break Block unit NO.
OCTL	EQU	036H	; Cut Left side
OCTR	EQU	038H	; Cut Right side
OCLC	EQU	03AH	; Cut left side carbe
OCRC	EQU	03CH	; Cut Right side carbe
ORCK	EQU	03EH	; Rock Block (Under Water)
;;K;;
;
OBMS	 EQU	  000H	  ;* ; 0  Bonus	  mushroom   in block
ODMS	 EQU	  001H	  ;* ; 1  Death	  mushroom   in
OBCO	 EQU	  002H	  ;* ; 2	  coin	     in
OSCO	 EQU	  003H	  ;* ; 3  Bonus	  coin	     in see thru bl
OSMS	 EQU	  004H	  ;* ; 4  Special mushroom   in
OSDM	 EQU	  005H	  ;* ; 5  Death	  mushroom   in
OSBM	 EQU	  006H	  ;* ; 6  Bonus	  mushroon   in
OBBM	 EQU	  007H	  ;* ; 7  Bonus	  mushroom   in normal bloc
ODMT	 EQU	  008H	  ;* ; 8  Death	  mushroom   in
OBBW	 EQU	  009H	  ;* ; 9	  wood	     in
OBBS	 EQU	  00AH	  ;* ; A	  super star in
ORBC	 EQU	  00BH	  ;* ; B  Repeat  coin	     in
OBSM	 EQU	  00CH	  ;* ; C  Special mushroom   in
;
OWC0	 EQU	  00DH	  ;  ; D  In water chimney
OSP0	 EQU	  00EH	  ;  ; E  Spin steck center point block
OBOD	 EQU	  00FH	  ;  ; F  Jump bord ( spring )
;
;
OCM3	 EQU	  000H+01000000B  ; 0 L-chimney No.1 ( ground --! underground,underwater )
OPL0	 EQU	  001H+01000000B  ; 1 Gole pole
OSK0	 EQU	  002H+01000000B  ; 2	   steck
OCH0	 EQU	  003H+01000000B  ; 3 Chain
OSL0	 EQU	  004H+01000000B  ; 4 Still
SLON	 EQU	  005H+01000000B  ; 5 Select chimney mode ON
SCON	 EQU	  006H+01000000B  ; 6 Scroll ON
SCOF	 EQU	  007H+01000000B  ; 7	     OFF
JFST	 EQU	  008H+01000000B  ; 8 Jump  fish start
WFST	 EQU	  009H+01000000B  ; 9 Water fish start
EXOF	 EQU	  00AH+01000000B  ; A Ship stop
CSLP	 EQU	  00BH+01000000B  ; B Castle loop set
KZST	 EQU	  00CH+01000000B  ; C Kaze start
KZOF	 EQU	  00DH+01000000B  ; D Kaze stop
;
;
BGCH	 EQU	  001H	    ; 0	 BG change environment corde
;
;*********************************************************************
;*	 Frame obstacle set			   (FROCST)	     *
;*	 [in]	  OBDTPT      <-- obstacle data pointer		     *
;*********************************************************************
FROCST	EQU	$
FRCST20 EQU	$
;
	IDX16
	REP	#00010000B		; index 16bit mode
;
	LDX	#0004H
FRCST40 EQU	$
	STZ	KWORK9
	STX	<INDEX
;
	STZ	OBPCSW			; set check sw off
;
	LDY	OBDTPT			; (y) <-- data pointer
	LDA	[<FXODA0],Y
	CMP	#0FDH
	BEQ	FRCST100		; data end ?
	AND	#0FH
	CMP	#0FH
	BNE	FRCST50
	INC	KWORK9
;					; no
FRCST50 EQU	$
	LDA	OBWORK,X
	BPL	FRCST100		; now obstacle set ?
;					; no
	LDA	KWORK9
	BEQ	FRCST55
	INY
FRCST55 EQU	$
	INY
	LDA	[<FXODA0],Y
	ASL	A
	BCC	FRCST60			; next x-pos.(H) ?
;					; yes
	LDA	OBXHFG
	BNE	FRCST60			; set ok ?
;					; yes
	INC	OBXHFG
	INC	OBXHCT			; next x-pos.(H) set
FRCST60 EQU	$
	LDY	OBDTPT			; (y) <-- data pointer
	LDA	[<FXODA0],Y
	AND	#0FH
	CMP	#0DH
	BNE	FRCST80			; x-pos.(H) set ?
;					; yes
	INY
	LDA	[<FXODA0],Y
	LDY	OBDTPT
	AND	#40H
	BNE	FRCST90			; x-pos.(H) set ?
;					; yes
	LDA	OBXHFG
	BNE	FRCST90			; set ok ?
;					; yes
	LDA	KWORK9
	BEQ	FRCST68
	INY
FRCST68 EQU	$
	INY
	LDA	[<FXODA0],Y
	AND	#1FH
	STA	OBXHCT			; x-pos.(H) set
	INC	OBXHFG
	BRA	FRCST130
;
FRCST80 EQU	$
	CMP	#0EH
	BNE	FRCST90			; environment data ?
;					; yes
	LDA	OBRDFG
	BNE	FRCST100		; nothing read ?
;					; no
FRCST90 EQU	$
	LDA	OBXHCT
	CMP	FRPTP0
	BCC	FRCST120		; data side limit over ?
;					; no
FRCST100 EQU	$
	JSR	FROSSB			; obstacle data set
;
	IDX16
	REP	#00010000B		; index 16bit mode
;
	BRA	FRCST140
;
FRCST120 EQU	  $
	 INC	  OBPCSW
FRCST130 EQU	  $
	JSR	FRPTSET			; pointer inc.
;
FRCST140 EQU	  $
	LDX	<INDEX
	LDA	OBWORK,X
	BMI	FRCST150		; now obstacle set ?
;					; yes
	 DEC	  OBWORK,X
FRCST150 EQU	  $
	 DEX
	BMI	FRCST155		; check end ?
	JMP	FRCST40
FRCST155 EQU	$			; yes
;
	LDA	OBPCSW
	BEQ	FRCST158		; set on ?
	JMP	FRCST20
FRCST158 EQU	$			; yes
;
	LDA	OBRDFG
	BEQ	FRCST200
	JMP	FRCST20			; set on ?
;					; yes
FRCST200 EQU	  $
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	RTS
;
;*********************************************************************
;*	 Frame data pointer inc.		   (FRPTSET)	     *
;*	 [in]	  (x)	      <-- set index			     *
;*********************************************************************
FRPTSET EQU	$
;
	MEM16
	REP	#00100000B		; memory 16bit mode
;
	INC	OBDTPT
	INC	OBDTPT			; data pointer inc.
;
	LDA	KWORK9
	AND	#00FFH
	BEQ	FRPST10
	INC	OBDTPT
FRPST10 EQU	$
;
	MEM8
	SEP	#00100000B
;
	LDA	#00H
	STA	OBXHFG			; x-pos.(H) check flag off
	STA	KWORK9
	RTS
;
;*********************************************************************
;*	 Frame obstacle data set		   (FROSSB)	     *
;*	 [in]	  (x)	      <-- set index			     *
;*********************************************************************
FROSSB	EQU	$
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	TXA
	AND	#00FFH
	TAX
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
	LDA	OBWORK,X
	BMI	FRSSB10			; now obstacle set ?
;					; yes
	MEM16
	REP	#00100000B		; memory 16bit mode
;
	TXA
	ASL	A
	TAX
	LDY	OBSTPT,X
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
FRSSB10		EQU	$
		LDA	!PCHFLG
		BEQ	FRSSB13
		JSL	>PCHEND
		STZ	!PCHFLG
		RTS
;
FRSSB13		EQU	$
		STY	<KWORK4
;
		STZ	<KWORK3
		STZ	KWORK9
		LDX	#(OSBP2-OSBP0)/2
		LDA	[<FXODA0],Y
		CMP	#0FDH
		BEQ	FRCST200		; data end ?
;						; no
		AND	#0FH
		CMP	#0FH
		BNE	FRSSB15
		INC	<KWORK3
		BRA	FRSSB20
;
;;;;;	      BEQ      FRSSB20	   ;data-3 ?
;			      ;no
FRSSB15 EQU	$
	 LDX	  #(OSBP1-OSBP0)/2
	 CMP	  #0CH
	 BEQ	  FRSSB20     ;data-2 ?
;			      ;no
	LDX	#(OSBP0-OSBP0)/2
FRSSB20 EQU	$
	STX	<WORK+7
	LDX	<INDEX			; (x) pull
	CMP	#0EH
	BNE	FRSSB40			; BG. change ?
;
	STZ	<WORK+7
	LDA	#(OSBP5-OSBP0)/2
	BNE	FRSSB115
;
;
FRSSB40	 EQU	  $
	 CMP	  #0DH
	 BNE	  FRSSB50     ;fix ?
;			      ;yes
	 LDA	  #(OSBP4-OSBP0)/2
	 STA	  <WORK+7
	LDA	<KWORK3
	BEQ	FRSSB43
	INY
FRSSB43 EQU	$
	INY
	LDA	[<FXODA0],Y
	AND	#40H
	BEQ	FRSSB125		; data ?
;					; yes
	LDA	[<FXODA0],Y
	AND	#7FH
	CMP	#CSLP
	BNE	FRSSB45			; frame loop ?
;					; yes
	INC	FRLPFG
FRSSB45 EQU	$
	AND	#3FH
	BRA	FRSSB115
;
FRSSB50 EQU	$
	CMP	#0CH
	BCS	FRSSB100		; data check ?
;					; yes
	LDA	<KWORK3
	BEQ	FRSSB55
	INY
FRSSB55 EQU	$
	INY
	LDA	[<FXODA0],Y
	AND	#70H
	BNE	FRSSB60			; fix ?
;					; yes
	LDA	#(OSBP3-OSBP0)/2
	STA	<WORK+7
	LDA	[<FXODA0],Y
	AND	#0FH
	BRA	FRSSB115
;
FRSSB60 EQU	$
	STA	<WORK
;
	CMP	#70H
	BNE	FRSSB80			; chimmy ?
;					; yes
	LDA	[<FXODA0],Y
	AND	#08H
	BEQ	FRSSB80			; in ok ?
;					; yes
	STZ	<WORK
FRSSB80 EQU	$
	LDA	<WORK
	BRA	FRSSB110
;
FRSSB100 EQU	  $
	LDA	<KWORK3
	BEQ	FRSSB105
	INY
FRSSB105 EQU	$
	INY
	LDA	[<FXODA0],Y
	AND	#70H
FRSSB110 EQU	  $
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
FRSSB115 EQU	  $
	 STA	  <WORK
FRSSB120 EQU	  $
	 LDA	  OBWORK,X
	 BPL	  FRSSB140    ;now obstacle set ?
;			      ;no
	 LDA	  OBXHCT
	 CMP	  FRPTP0
	 BEQ	  FRSSB130    ;set x-pos.(H) ?
;
FRSSB122 EQU	  $
	 LDY	  OBDTPT
	 LDA	  [<FXODA0],Y
	 AND	  #0FH
	 CMP	  #0EH
	 BNE	  FRSSB125    ;environment data ?
;			      ;yes
	 LDA	  OBRDFG
	 BNE	  FRSSB135    ;nothing read ?
;			      ;no
FRSSB125 EQU	  $
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	RTS
;			      ;yes
	IDX16
FRSSB130 EQU	  $
	 LDA	  OBRDFG
	 BEQ	  FRSSB133    ;nothing read end ?
;			      ;yes
	LDA	#00H
	STA	OBRDFG
	STA	OBPCSW
	STA	<INDEX
	STA	<INDEX+1
;;K;;	      LDA      #00H
;;K;;	      STA      OBRDFG
;;K;;	      STA      OBPCSW
;;K;;	      STA      <INDEX
FRSSB900 EQU	  $
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	 RTS
;
	IDX16
FRSSB133 EQU	  $
	 LDY	  OBDTPT
	 LDA	  [<FXODA0],Y
	 AND	  #0F0H
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 CMP	  FRPTP1
	 BNE	  FRSSB125    ;set x-pos.(L) ?
;			      ;yes
FRSSB135 EQU	  $
;
	PHX
	MEM16
	REP	#00100000B		; memory 16bit mode
;
	TXA
	ASL	A
	TAX
	LDA	OBDTPT
	STA	OBSTPT,X		; data pointer set
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
	PLX
;
;;;;	     LDA      OBDTPT
;;;;	     STA      OBSTPT,X	  ;data pointer set
	LDA	<KWORK3
	BEQ	FRSB138
	INC	KWORK9
FRSB138 EQU	$
;
	 JSR	  FRPTSET     ;pointer inc.
FRSSB140 EQU	  $
	LDA	<KWORK3
	BEQ	FRSSB145
	LDY	<KWORK4
	JSL	>INCSLE
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	RTS
;
FRSSB145 EQU	$
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	LDA	<WORK
	CLC
	ADC	<WORK+7
		ASL	A
		TAY
		LDA	OSBPTBL,Y
		STA	<WORK+4
		LDA	OSBPTBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
OSBPTBL		EQU	$
;---------------------------------  In line behind  --------------------------
OSBP0	 WORD	  ICHMST	       ; 0  I-chimney ( enter )
	 WORD	  LMGSET	       ; 1  Land . Mushroom . Big gun
	 WORD	  BRKST0	       ; 2  Floor ( break )
	 WORD	  BRKST1	       ; 3	  ( no break )
	 WORD	  BCOIST	       ; 4  Bonus coin
PILP	 WORD	  PILST0	       ; 5  Pile up brick-0 ( no break )
	 WORD	  PILST1	       ; 6		 -1 ( break )
	 WORD	  ICHMST	       ; 7  I-chimney ( enter )
;---------------------------------  In line side  ----------------------------
OSBP1	 WORD	  HOLEST	       ; 0  Hole
	 WORD	  ELWPST	       ; 1  Elevator wire & pulley set
	 WORD	  BRGST0	       ; 2  Bridge set No.0
	 WORD	  BRGST1	       ; 3	       No.1
	 WORD	  BRGST2	       ; 4	       No.2
	 WORD	  WATFST	       ; 5  Water face set
	 WORD	  BXCOS1	       ; 6  Bonus coin in block ( floor-2 )
	 WORD	  BXCOS2	       ; 7			( floor-3 )
;---------------------------------  Fix behind	------------------------------
OSBP2	 WORD	  OSEND		     ; 0 Elevatore wire
	 WORD	  OSEND		     ; 1  Lift	    wire
	 WORD	  OSEND		     ; 2  Castle
	 WORD	  OSEND		     ; 3  Block step
	 WORD	  OSEND		     ; 4  L-chimney No.0 ( underground --! ground )
	 WORD	  OSEND		     ; 5  Wood
	 WORD	  OSEND		     ; 6  SAKASA DOKAN
	 WORD	  OSEND		     ; 7  SAKASA DOKAN
;---------------------------------  Fix size  --------------------------------
OSBP3	 EQU	  $
BNP10	 WORD	  BXMSST	       ; 0  Bonus   mushroom   in block
	 WORD	  BKDTMS1	       ; 1  Death   mushroom   in
	 WORD	  BXCOS0	       ; 2	    coin       in
	 WORD	  STBCOS	       ; 3  Special coin       in see thru block
	 WORD	  STBMSS	       ; 4	    mushroom   in
	 WORD	  BKDTMS3	       ; 5  Death   mushroom   in
	 WORD	  STBNMS	       ; 6  Bonus   mushroom   in
BNP40	 WORD	  BKMSST	       ; 7  Bonus   mushroom   in normal block
	 WORD	  BKDTMS2	       ; 8  Death   mushroom   in
	 WORD	  BKWDST	       ; 9	    wood       in
	 WORD	  BKSTRS	       ; a	    super star in
	 WORD	  BKRCOS	       ; b  Repeat  coin       in
BNP80	 WORD	  BKSMHS	       ; c  Special mushroom   in
	 WORD	  WCHMST	       ; d  In water chimney
	 WORD	  SPSTS0	       ; e  Spin steck center point block
	 WORD	  JBODST	       ; f  Jump bord ( spring )
;---------------------------------  Fix size  --------------------------------
OSBP4	 WORD	  LCH1ST	       ; 0  L-chimney No.1 ( ground --! underground,underwater )
	 WORD	  POLEST	       ; 1  Gole pole
BBP60	 WORD	  GLSTST	       ; 2	 steck
	 WORD	  CAINST	       ; 3  Chain
	 WORD	  STILST	       ; 4  Sttil
	 WORD	  SLCMON	       ; 5  Select chimney mode ON
	 WORD	  SCRON		       ; 6  Scroll ON
	 WORD	  SCROFF	       ; 7	   OFF
BBP80	 WORD	  JFSHST	       ; 8  Jump  fish start
	 WORD	  WFSHST	       ; 9  Water fish start
	 WORD	  JWSOFF	       ; A  J-fish & W-fish Ship OFF
	 WORD	  FRSSB900	       ; B  Castle loop set
	 WORD	  KAZEON1		; C  Kaze start
	 WORD	  KAZEOFF1		; D  Kaze stop
;---------------------------------  BG change  -------------------------------
OSBP5	 WORD	  BGEVCH	       ;    BG change
;
KAZEON1 EQU	$
	JSL	>KAZEON
	RTS
;
KAZEOFF1	EQU	$
	JSL	>KAZEOFF
	RTS
;
;*********************************************************************
;*	 JSR	  S1INCS					     *
;*********************************************************************
OSEND	EQU	$
	RTS
;
;
;*********************************************************************
;*		     (X) -- Set obst. index			     *
;*	 JSR	  BGEVCH    [ BG environment change ]		     *
;*********************************************************************
BGEVCH	EQU	$
;
	PHX
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	TXA
	ASL	A
	TAX
	LDY	OBSTPT,X
;
	MEM8
	SEP	#00100000B		; memory , index 8bit mode
;
	INY
	LDA	[<FXODA0],Y
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	PLX
;
	PHA
	AND	#01000000B
	BNE	BGEVC40			; BG. set ?
;					; no
	PLA
	PHA
	 AND	  #00001111B
	 STA	  FLRNO	      ;floor no. set
	 PLA
	 AND	  #00110000B
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 STA	  BBGFG1      ;BG. set
	 RTS
;
BGEVC40	 EQU	  $
	 PLA
	 AND	  #00000111B
	 CMP	  #00000100B
	 BCC	  BGEVC60     ;night flag set ?
;			      ;yes
	 STA	  NIGTFG
	 LDA	  #00H
BGEVC60	 EQU	  $
	 STA	  BBGFG0      ;init. BG. set
;
	RTS
;
;---------------------------------  BG change  -------------------------------
;#####################################################################
;#	 JSR	  SLCMON    [ Select chimney mode ON ]		     #
;#####################################################################
SLCMON	 EQU	  $	    ;< Message set >
	 LDX	  #10000000B	       ; Set  W1-2 message flag
	 LDA	  URAFLG
	 BNE	  SLUR20	  ;ura-world ?
;				  ;no
	 LDA	  CORSNO
	 BNE	  SLCO61	  ;- IF	 W1-2 warp zoon ?  ( NO ; SLCO61 )
	 LDY	  <ENVRFG
	 DEY
	 BEQ	  SLCO62	  ;Ground ? < YES ; SLCO62 >
	 LDA	  ENVRID
	 BEQ	  SLCO63	  ;Underground-0 ? < YES ; SLCO63 >
	 INX			  ;No
;
SLCO62	 EQU	  $
	 INX
;
SLCO63	 EQU	  $
	 BRA	  SLCO60
;
SLUR20	 EQU	  $
	 LDA	  #10000111B
	 CLC
	 ADC	  GOALCT
	 BNE	  SLUR40
;
;
SLCO61	 EQU	  $
	 LDX	  #10000011B	       ; Set  W3-1 Ground messarge flag
;
	 LDA	  CORSNO
	 CMP	  #02H
	 BEQ	  SLCO60	  ;- IF	 W3-1 warp zoon ? ( YES ; SLCO60 )
	 INX			       ; Set  W5-1 Ground messarge flag
	 CMP	  #04H
	 BNE	  SLCO64	  ;- IF	 W5 warp zoon ? ( NO ; SLCO60 )
;
	 LDA	  ENVRID
	 CMP	  #0BH
	 BEQ	  SLCO60	       ; Ground-11 ? ( YES ; SLCO60 )
;
	 LDY	  <ENVRFG
	 DEY
	 BEQ	  SLCO65	  ;- IF	 W5-2 warp zoon ? ( YES ; SLCO66 )
	 BRA	  SLCO66
;
SLCO64	 EQU	  $
	 INX			  ; Set	 W7-4 & W8-1 ground messarge flag
;
SLCO65	 EQU	  $
	 INX			  ; Set	 W5-2 ground messarge flag
;
SLCO66	 EQU	  $
	 INX			  ; Set	 W5-2 <Underground-3>
;
SLCO60	 EQU	  $
	 TXA
SLUR40	 EQU	  $
	 STA	  CMSLFG	       ; Chimeny select flag ON
;
	 JSR	  PRM400	  ; BG Message set "WELCOME TO ..."
;
	 LDA	  #FLWR	    ;; Clear  in chimney flower >
	 JSR	  CHRCLR
;
;#####################################################################
;#	 JSR	  SCRON	    [ Scroll ON ]			     #
;#####################################################################
SCRON	 EQU	  $
;
;#####################################################################
;#	 JSR	  SCROFF    [ Scroll stop flag ]		     #
;#####################################################################
SCROFF	 EQU	  $
	 LDA	  SRSTFG
	 EOR	  #1
	 STA	  SRSTFG
;
	 RTS
;
;#####################################################################
;#		     (A) -- Enemy kind No.			     #
;#	 JSR	  CHRCLR    [ Character clear ]			     #
;#####################################################################
CHRCLR	 EQU	  $
	 STA	  <WORK
;
	 LDA	  #0
	 LDX	  #MSXPS0-ENXPS0-1
;
SLC070	 EQU	  $
	 LDY	  <ENMYNO,X
	 CPY	  <WORK
	 BNE	  SLC080	  ;- IF	 clear character ?  ( NO ; SLC080 )
;
	 STA	  <ENCMOD,X		; Clear	 character
;
SLC080	 EQU	  $
	 DEX
	 BPL	  SLC070
;
	 RTS
;
;
;#####################################################################
;#	 Jump & Water fish , Fall ship	enemy No. data		     #
;#####################################################################
JWFEDT	 EQU	  $-(BBP80-OSBP4)/2
	 BYTE	  JFS0,TMK0,EXFF
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  JFSHST    [ Jump fish start set ]		     #
;#####################################################################
JFSHST	 EQU	  $
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  WFSHST    [ Water fish start set ]		     #
;#####################################################################
WFSHST	 EQU	  $
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  JWSOFF    [ J-fish & W-fish Ship OFF set ]	     #
;#####################################################################
JWSOFF	 EQU	  $
	 LDX	  <WORK
	 LDA	  JWFEDT,X
;
	 LDY	  #MSXPS0-ENXPS0
SMCHK20	 EQU	  $
	 DEY
	 BMI	  SMCHK80     ;check end ?
;			      ;no
	 CMP	  ENMYNO,Y
	 BNE	  SMCHK20     ;same ?
;			      ;yes
	 LDA	  #00H
SMCHK80	 EQU	  $
	 STA	  BGFALFG
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LMGSET    [ Land or Mushroom or Big gun set ]	     #
;#####################################################################
LMGSET		EQU	$
		LDA	OBSTFG
		ASL	A
		TAY
		LDA	LMGSETTBL,Y
		STA	<WORK+4
		LDA	LMGSETTBL+1,Y
		STA	<WORK+5
		JMP	(WORK+4)
;;;;;;;;		JSR	JSRSUB
LMGSETTBL	EQU	$
		WORD	LANDST	  ; Land set
		WORD	MUSHST	  ; Mushroom set
		WORD	BGUNST	  ; Big gun set
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LANDST    [ Land set ]			     #
;#####################################################################
LANDST	EQU	$
	JSR	OBSTPC			; Set position calc
;
	STX	LDPLFG
	LDA	OBWORK,X
	BEQ	LDST70			; IF right side ?     ( YES ; LDST70 )
	BPL	LDST50			; IF center ?	      ( YES ; LDST50 )
;
	TYA				; Land left side set & initial !
	STA	OBWORK,X
;
	LDA	FRPTP0
	ORA	FRPTP1
	BEQ	LDST50			; IF first frame ?    ( YES ; LDST50 )
;
	LDA	#LND0			; Land left set
	JMP	MSST60
;
LDST50	EQU	$			; Land center set !
	STA	LDWORK
	LDX	<WORK+7
	LDA	#LND0+1
	STA	NWFRLD,X		; Land center top set
;
	TXY
	INY
	LDX	LDPLFG
	DEC	LDWORK
	BEQ	LDST51
	LDA	LNDPOL,X
	BNE	LDST53
	INC	LNDPOL,X
	LDA	#PUBK1
	STA	NWFRLD,Y
	LDA	#PUBK1+4
	BRA	LDST54
LDST53	EQU	$
	LDA	#PUBK1+1
	STA	NWFRLD,Y
	LDA	#PUBK1+5
	BRA	LDST54
LDST51	EQU	$
	LDA	LNDPOL,X
	BEQ	LDST52
	STZ	LNDPOL,X
	LDA	#PUBK1+2
	STA	NWFRLD,Y
	LDA	#PUBK1+6
	BRA	LDST54
LDST52	EQU	$
	STZ	LNDPOL,X
	LDA	#PUBK1+3
	STA	NWFRLD,Y
	LDA	#PUBK1+7		; Land prop set
LDST54	EQU	$
	TYX
;
	JMP	MSST50
;
LDST70	EQU	$			; Land right side set !
	LDA	#LND0+2			; Land right set
	JMP	MSST60
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  MUSHST    [ Mushroom set ]			     #
;#####################################################################
MUSHST	EQU	$
	JSR	OBITSB			; Initial
	STY	<WORK+6
	BCC	MSST20			; IF initial ?	 ( NO ; MSST20 )
;
	LDA	OBWORK,X		; Left side set & Initial !
	LSR	A
	STA	OBMSWK,X
;
	LDA	#MUSH0
	BRA	MSST60
;
MSST20	EQU	$
	LDA	#MUSH0+2
	LDY	OBWORK,X
	BEQ	MSST60			; IF right set ?  ( YES ; MSST60 )
;
	LDA	OBMSWK,X
	STA	<WORK+6
;
	LDX	<WORK+7
	LDA	#MUSH0+1
	STA	NWFRLD,X
	RTS
;
;;;	CPY	<WORK+6
;;;	BNE	PPST90			; IF center pole ? ( NO ; PPST90 )
;
;;;MSST30	EQU	$			; Center pole set !
;;;	INX
;
;;;	LDA	#MSHP0
;;;	STA	NWFRLD,X
;
;;;	LDA	#MSHP0+1
;
MSST50	EQU	$
	INX
	LDY	#0FH
	JMP	OBSTST
;
MSST60	EQU	$			; Land & Mush left & right side set !
	LDX	<WORK+7
	LDY	#0
	JMP	OBSTST
;;;K;;;;
;;;K;;;;#####################################################################
;;;K;;;;#	Elevatore wire & pulley block No. data			    #
;;;K;;;;#####################################################################
;;;K;;;WRBKND	EQU	 $	   ; Wire & Pulley data !
;;;K;;;		BYTE	 PLY0,WIRE1,PLY0+1    ; right.center.left
;;;K;;;;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  ELWPST    [ Elevatore wire & pulley set ]	     #
;#####################################################################
ELWPST		EQU	$
		JSL	>ELWSET
		RTS
;;;K;;;		JSR	 OBITSB		 ; Initial sub
;;;K;;;		LDY	 #0
;;;K;;;;
;;;K;;;PPST20	EQU	 $
;;;K;;;		BCS	 PPST40		 ;- IF	left side ( initial ) ?	  ( YES ; PPST30 )
;;;K;;;;
;;;K;;;		INY
;;;K;;;;
;;;K;;;		LDA	 OBWORK,X
;;;K;;;		BNE	 PPST40		 ;- IF	right side ?		  ( NO ; PPST40 )
;;;K;;;;
;;;K;;;		INY
;;;K;;;;
;;;K;;;PPST40	EQU	 $
;;;K;;;		LDA	 WRBKND,Y
;;;K;;;		STA	 NWFRLD		      ; NWFRLD <-- Pipe data
;;;K;;;;
;;;K;;;PPST90	EQU	 $
;;;K;;;		RTS
;
;#####################################################################
;#	 Castle data						     #
;#####################################################################
;;K;;CASBND   EQU      $	 ; Castle block No. data !
;;K;;	      BYTE	   HOLE0,CAS0,CAS0,CAS0,HOLE0
;;K;;	      BYTE	HOLE0,CAS0+3,CAS0+2,CAS0+1,HOLE0
;;K;;	      BYTE	 CAS0,CAS0+4,CAS0+4,CAS0+4,CAS0
;;K;;	      BYTE     CAS0+2,CAS0+2,CAS0+5,CAS0+2,CAS0+2
;;K;;	      BYTE     CAS0+2,CAS0+2,CAS0+6,CAS0+2,CAS0+2
;;K;;;
;;K;;	      BYTE     CAS0+4,CAS0+4,CAS0+4,CAS0+4,CAS0+4
;;K;;	      BYTE     CAS0+2,CAS0+5,CAS0+2,CAS0+5,CAS0+2
;;K;;	      BYTE     CAS0+2,CAS0+6,CAS0+2,CAS0+6,CAS0+2
;;K;;	      BYTE     CAS0+2,CAS0+2,CAS0+2,CAS0+2,CAS0+2
;;K;;	      BYTE     CAS0+5,CAS0+2,CAS0+5,CAS0+2,CAS0+5
;;K;;	      BYTE     CAS0+6,CAS0+2,CAS0+6,CAS0+2,CAS0+6
;;K;;CSBD     EQU      $
;;K;;;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  CASTST    [ Castle set ]			     #
;#####################################################################
;;;;;;;;CASTST	 EQU	  $
;;;;;;;;	JSL	>S1CAST
;;;;;;;;	RTS
;;;;;	      JSR      OBSTPC	       ; Set castle block !
;;;;;	      STY      <WORK+7		     ; <WORK+7 <-- Set (y)pos
;;;;;;
;;;;;	      LDY      #4
;;;;;	      JSR      OBWKIT		    ; Initial set OBWORK
;;;;;;
;;;;;	      TXA
;;;;;	      PHA
;;;;;;
;;;;;	      LDY      OBWORK,X
;;;;;	      LDX      <WORK+7
;;;;;	      LDA      #(CSBD-CASBND)/5
;;;;;	      STA      <WORK+6
;;;;;;
;;;;;CASS30   EQU      $
;;;;;	      LDA      CASBND,Y
;;;;;	      STA      NWFRLD,X
;;;;;;
;;;;;	      INX
;;;;;;
;;;;;	      LDA      <WORK+6
;;;;;	      BEQ      CASS50
;;;;;;
;;;;;	      INY
;;;;;	      INY
;;;;;	      INY
;;;;;	      INY
;;;;;	      INY
;;;;;;
;;;;;	      DEC      <WORK+6
;;;;;;
;;;;;CASS50   EQU      $
;;;;;	      CPX      #0BH
;;;;;	      BNE      CASS30
;;;;;;
;;;;;	      PLA
;;;;;	      TAX
;;;;;;
;;;;;	      LDA      FRPTP0
;;;;;	      BEQ      CASS90	       ;- IF  gorl castle ?		( NO ; CASS90 )
;;;;;;
;;;;;	      LDA      OBWORK,X
;;;;;	      CMP      #1
;;;;;	      BEQ      CASS80	       ;- IF  small castle gate ?	( YES ; CASS80 )
;;;;;;
;;;;;	      LDY      <WORK+7
;;;;;	      BNE      CASS60
;;;;;;
;;;;;	      CMP      #3
;;;;;	      BEQ      CASS80	       ;- IF  big castle gate ?		( YES ; CASS80 )
;;;;;;
;;;;;CASS60   EQU      $
;;;;;	      CMP      #2
;;;;;	      BNE      CASS90	       ;- IF  castle center ?		( NO ; CASS80 )
;;;;;;
;;;;;	      JSR      FXTOCX	       ; Initial set  flag on caltle !
;;;;;	      PHA
;;;;;	      JSR      ENEPCK
;;;;;	      PLA
;;;;;	      STA      ENXPS1,X		    ; (x)pos (L) set
;;;;;;
;;;;;	      LDA      FRPTP0
;;;;;	      STA      <ENXPS0,X	     ; (x)pos (H) set
;;;;;;
;;;;;	      LDA      #1
;;;;;	      STA      <ENYPS0,X	     ; (y)pos (H) set
;;;;;	      STA      <ENCMOD,X
;;;;;;
;;;;;	      LDA      #90H
;;;;;	      STA      ENYPS1,X		    ; (Y)pos (L) set
;;;;;;
;;;;;	      LDA      #CFLG
;;;;;	      STA      <ENMYNO,X	     ; Enemy No.
;;;;;;
;;;;;	      RTS
;;;;;;
;;;;;CASS80   EQU      $	       ; Castle gate stoper set !
;;;;;	      LDY      #BRIK1
;;;;;	      STY      NWFRLD+10	    ; Set  Gorl stopper
;;;;;;
;;;;;CASS90   EQU      $
;;;;;;
;;;;;	      RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  WCHMST    [ Water chimney ]			     #
;#####################################################################
WCHMST	 EQU	  $
	 JSR	  OBSTPC	  ; Set position calc
;
	 LDY	  OBWORK,X
	 LDX	  <WORK+7
	 LDA	  #WCHM0
	 STA	  NWFRLD,X
;
	 LDA	  #WCHM0+1
	 STA	  NWFRLD+1,X
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LCH1ST    [ L-chimney set No.1 ]		     #
;#####################################################################
LCH1ST	 EQU	  $
	 LDY	  #3
	 JSR	  OBWKIT	  ; Initial set OBWORK
;
	 LDY	  #0AH
	 DEY
	 DEY
	 STY	  <WORK+5
;
	 LDY	  OBWORK,X
	 STY	  <WORK+6
;
	 LDX	  <WORK+5
	 INX
;
	 LDA	  CMBND0,Y
	 CMP	  #HOLE0
	 BEQ	  LCMS60	  ;- IF	 set block hole ?     ( YES ; LCMS60 )
;
	 LDX	  #0
	 LDY	  <WORK+5
	 JSR	  OBSTST
;
	 CLC
;
LCMS60	 EQU	  $
	 LDY	  <WORK+6
	 LDA	  CMBND0+4,Y
	 STA	  NWFRLD,X
;
	 LDA	  CMBND0+8,Y
	 STA	  NWFRLD+1,X
;
;;k;;	      JSR      LCMS30	       ; Set  Normal L-chimney
	 BCS	  LC1S90	  ;- IF	 V-chimney set ?  ( NO ; LC1S90 )
;
	 LDX	  #6
;
LC1S40	 EQU	  $
	 LDA	  #SKY0
	 STA	  NWFRLD,X
	 DEX
	 BPL	  LC1S40
;
	 LDA	  CMSCBD,Y
	 STA	  NWFRLD+7
;
LC1S90	 EQU	  $
;
	 RTS
;
CMBND0	 EQU	  $		  ; L-chimney block No. data !
	 BYTE	  CHM0+5,CHM0+4,HOLE0,HOLE0
	 BYTE	  CHM0+5,CHM1+2,CHM1+1,CHM1	 ; right <--! left
	 BYTE	  CHM0+5,CHM1+5,CHM1+4,CHM1+3
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LCH0ST    [ L-chimney set No.0 ]		     #
;#		     <C> -- 0 ; V chimney set			     #
;#			    1 ; H				     #
;#####################################################################
;;;;;CMBND0   EQU      $	       ; L-chimney block No. data !
;;;;;	      BYTE     CHM0+5,CHM0+4,HOLE0,HOLE0
;;;;;	      BYTE     CHM0+5,CHM1+2,CHM1+1,CHM1      ; right <--! left
;;;;;	      BYTE     CHM0+5,CHM1+5,CHM1+4,CHM1+3
;;;;;CDEND    EQU      $
;;;;;;
;;;;;;;;LCH0ST	 EQU	  $
;;;;;;;;	JSL	>S1LCH0
;;;;;;;;	RTS
;;;;;	      LDY      #3
;;;;;	      JSR      OBWKIT	       ; Initial set OBWORK
;;;;;	      JSR      OBSTPC	       ; Calc set count
;;;;;;
;;;;;LCMS30   EQU      $
;;;;;	      DEY
;;;;;	      DEY
;;;;;	      STY      <WORK+5
;;;;;;
;;;;;	      LDY      OBWORK,X
;;;;;	      STY      <WORK+6
;;;;;;
;;;;;	      LDX      <WORK+5
;;;;;	      INX
;;;;;;
;;;;;	      LDA      CMBND0,Y
;;;;;	      CMP      #HOLE0
;;;;;	      BEQ      LCMS60	       ;- IF  set block hole ?	   ( YES ; LCMS60 )
;;;;;;
;;;;;	      LDX      #0
;;;;;	      LDY      <WORK+5
;;;;;	      JSR      OBSTST
;;;;;;
;;;;;	      CLC
;;;;;;
;;;;;LCMS60   EQU      $
;;;;;	      LDY      <WORK+6
;;;;;	      LDA      CMBND0+4,Y
;;;;;	      STA      NWFRLD,X
;;;;;;
;;;;;	      LDA      CMBND0+8,Y
;;;;;	      STA      NWFRLD+1,X
;;;;;;
;;;;;	      RTS
;
;#####################################################################
;#	 I-chimney No. data					     #
;#####################################################################
CMSCBD	 EQU	  $		  ; I-chimney block No. data !
	 BYTE	  CHM0+1,CHM0	       ; Chimney top data ( enter )
	 BYTE	  CHM0+5,CHM0+4	       ;    "    down
;
	 BYTE	  CHM2+1,CHM2	       ; Chimney top data ( no enter )
	 BYTE	  CHM0+5,CHM0+4	       ;    "    down
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  ICHMST    [ I-Chimney set ]			     #
;#####################################################################
ICHMST	 EQU	  $
	 JSR	  CMSTSB	  ; Chimney set sub
	 LDA	  <WORK		   ; Chimney set !
	 BEQ	  CMST30	       ;- IF  no enter chimney ?  ( NO ; CMST30 )
;
	 INY
	 INY
	 INY
	 INY
;
CMST30	 EQU	  $		       ; Set  Enemy in chimney !
	 TYA
	 PHA
;
	 LDY	  OBWORK,X
	 BEQ	  CMST60
;
	 JSR	  ENEPCK2		     ; Enemy empty area check
	 BCS	  CMST60		    ;- IF  empty area ?		 ( NO ; CMST60 )
;
	 JSR	  FXTOCX
	 CLC
	 ADC	  #8
	 STA	  ENXPS1,X			 ; (x)pos (L) set
;
	 LDA	  FRPTP0
	 ADC	  #0
	 STA	  <ENXPS0,X			  ; (x)pos (H) set
;
	 LDA	  #1
	 STA	  <ENYPS0,X			  ; (y)pos (H) set
	 STA	  <ENCMOD,X			  ; Enemy mode ON
;
	 JSR	  FYTOCY
	 STA	  ENYPS1,X			 ; (y)pos (L) set
;
	 LDA	  #FLWR
	 STA	  <ENMYNO,X			  ; Enemy No. set
;
	 JSR	  FXFWRES			 ; In chimney chara init
;
CMST60	 EQU	  $
	 PLA
	 TAY
;
	 LDX	  <WORK+7
;
CMST80	 EQU	  $		  ; Chimney block No. set !
	 LDA	  CMSCBD,Y
	 STA	  NWFRLD,X	       ; Top set
;
	 INX
;
	 LDA	  CMSCBD+2,Y	       ; Prop set
	 LDY	  <WORK+6
	 DEY
	 JMP	  OBSTST	       ; Chimney set
;
CMSTSB	 EQU	  $		  ; Chimney set sub !
;
	 LDY	  #1
	 JSR	  OBWKIT	       ; Initial set OBWORK
	 JSR	  OBSTPC	       ; Obstacle set pos calc
	 TYA
	 AND	  #00000111B
	 STA	  <WORK+6
;
	 LDY	  OBWORK,X
;
	 RTS
;
CMST200	 EQU	  $
	 STA	  ENMYNO,X			 ; Enemy No. set
;
	 JSR	  FXTOCX
	 CLC
	 ADC	  #8
	 STA	  ENXPS1,X			 ; (x)pos (L) set
;
	 LDA	  FRPTP0
	 ADC	  #0
	 STA	  ENXPS0,X			 ; (x)pos (H) set
;
	 LDA	  #1
	 STA	  <ENYPS0,X			  ; (y)pos (H) set
	 STA	  ENCMOD,X			 ; Enemy mode ON
;
	 JSR	  FYTOCY
	 STA	  ENYPS1,X			 ; (y)pos (L) set
;
	 JMP	  FXFWRES			 ; In chimney chara init
;
;
;#####################################################################
;#	 JSR	  ENEPCK    [ Enemy empty area check ]		     #
;#		     <C> -- 0 ; Empty				     #
;#			    1 ; No empty			     #
;#		     <X> -- Empty area index			     #
;#####################################################################
ENEPCK	 EQU	  $
	 LDX	  #0
;
EEPC40	 EQU	  $
	 CLC
;
	 LDA	  <ENCMOD,X
	 BEQ	  EEPC70
;
	 INX
;
	 CPX	  #8
	 BNE	  EEPC40
;
EEPC70	 EQU	  $
;
	 RTS
;
ENEPCK2 EQU	$
	LDX	#8
EEEE10	EQU	$
	CLC
	LDA	<ENCMOD,X
	BEQ	EEEE20
	DEX
	CPX	#0FFH
	BNE	EEEE10
EEEE20	EQU	$
	RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  WATFST    [ Water face set ]			     #
;#####################################################################
;
WATDAT	EQU	$
	BYTE	WATR0,WATR0+1,WATR0+1,WATR0+2
WATDT1	EQU	$
	BYTE	WATR1,WATR1+1
;
WATFST	EQU	$
	JSR	OBITSB		; Initial
	LDX	#0AH
	LDA	<ENVRFG
	CMP	#03H
	BNE	WTSTPS
	INX
WTSTPS	EQU	$
	LDY	<ENVRFG
	LDA	WATDAT,Y
;;;;;;;;	LDA	#WATR0
	STA	NWFRLD,X
;
	INX
	TYA
	LSR	A
	TAY
	LDA	WATDT1,Y
	LDY	#1
;;;;;;;;	LDA	#WATR1
	JMP	OBSTST
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BXCOS1    [ Coin in block set No.1 ]		     #
;#####################################################################
BXCOS1	 EQU	  $
	 LDA	  #3
	 BRA	  BXCOS2X	    ; SKIP   (LDA   #7)
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BXCOS2    [ Coin in block set No.2 ]		     #
;#####################################################################
BXCOS2	 EQU	  $
	 LDA	  #7
BXCOS2X	 EQU	  $
	 PHA
;
BXC120	 EQU	  $
	 JSR	  OBITSB
;
	 PLA
	 TAX
;
	 LDA	  #BXCON
	 STA	  NWFRLD,X
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRGST0    [ Bridge set No.0 ]			     #
;#####################################################################
BRGST0	 EQU	  $
	 LDA	  #06
	 BRA	  BRGST2X	 ; SKIP	  (LDA	 #7; , LDA   #9)
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRGST1    [ Bridge set No.1 ]			     #
;#####################################################################
BRGST1	 EQU	  $
	 LDA	  #07H
	 BRA	  BRGST2X
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRGST2    [ Bridge set No.2 ]			     #
;#####################################################################
BRGST2	 EQU	  $
	 LDA	  #09H
BRGST2X	 EQU	  $
	 PHA
;
BRGS60	 EQU	  $
	JSR	OBITSB		; Initial set
;
	LDA	OBWORK,X
	BEQ	BRGS61
	LDA	LNDPOL,X
	BNE	BRGS62
	INC	LNDPOL,X
	LDA	#HNDR0+1
	BRA	BRGS69
;
BRGS62	EQU	$
	LDA	#HNDR0
	BRA	BRGS69
;
BRGS61	EQU	$
	STZ	LNDPOL,X
	LDA	#HNDR0+2
;
BRGS69	EQU	$
	PLX
	STA	 NWFRLD,X
;
	INX
;
	 LDY	  #0
	 LDA	  #BRGE0
	 JMP	  OBSTST
;
;#####################################################################
;#	 JSR	  WOODST					     #
;#####################################################################
;;;;;;;;WOODST	 EQU	  $
;;;;;;;;	JSL	>S1WOOD
;;;;;;;;	RTS
;;;;;	      JSR      OBSTPC	       ; Clac  set count
;;;;;;
;;;;;	      LDX      #2
;;;;;	      LDA      #WOOD3
;;;;;	      JMP      OBSTST
;
;#####################################################################
;#	 JSR	  POLEST    [ Pole set ]			     #
;#####################################################################
POLEST	 EQU	  $
	 LDA	  #POLE0
	 STA	  NWFRLD	       ; Pole top ball set
;
	 LDX	  #1
	 LDY	  #8
	 LDA	  #POLE0+1
	 JSR	  OBSTST	       ; Pole set
;
	 LDA	  #HDBK0
	 STA	  NWFRLD+10
;
	 JSR	  FXTOCX	       ; Gorl flag (x)pos (L) calc
;;	   SEC
;;	   SBC	    #08H
	CLC
	ADC	#08H
	 STA	  ENXPS1+5	       ; Main flag (x)pos (L) set
;
	 LDA	  FRPTP0
	 ADC	  #0
	 STA	  <ENXPS0+5		;	    (x)pos (H) set
;
	 LDA	  #30H
	 STA	  ENYPS1+5	       ; Main flag (y)pos (L) set
;
	 LDA	  #0B0H
	 STA	  GLSCY1	       ; Sub
;
	 LDA	  #GFLG
	 STA	  <ENMYNO+5		; Set  Enemy No.
;
	 INC	  <ENCMOD+5
;
	LDA	#0FFH
	STA	ENCWOK+14H
	STA	ENCWOK+15H
	STA	ENCWOK+16H
	STA	ENCWOK+17H
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  ELWRST    [ Elevator wire set ]		     #
;#####################################################################
;;;;;;;;ELWRST	EQU	$
;;;;;;;;	JSL	>S1ELWR
;;;;;;;;	RTS
;;;;;	LDX	#0
;;;;;	LDY	#0FH
;;;;;	BRA	LWST50
;;;;;;K;	 JMP	  LWST50
;;;;;;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LFWRST    [ Lift wire set ]			     #
;#####################################################################
;;;;;;;;LFWRST	 EQU	  $
;;;;;;;;	JSL	>S1LFWR
;;;;;;;;	RTS
;;;;;	      TXA
;;;;;	      PHA
;;;;;;
;;;;;	      LDX      #1
;;;;;	      LDY      #0FH
;;;;;	      LDA      #WIRE2
;;;;;	      JSR      OBSTST	       ; Set wire color
;;;;;;
;;;;;	      PLA
;;;;;	      TAX
;;;;;	      JSR      OBSTPC	       ; Set position calc
;;;;;;
;;;;;	      LDX      #1
;;;;;;
;;;;;LWST50   EQU      $
;;;;;	      LDA      #WIRE0
;;;;;	      JMP      OBSTST	       ; Set wire
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BCOIST    [ Bonus coin set ]			     #
;#####################################################################
BNCODT	 EQU	  $	    ; Coin block data !
	 BYTE	  COIN1		  ; in water
	 BYTE	  COIN0		  ; Sky,Ground
	 BYTE	  COIN0		  ; Underground,Castle
	 BYTE	  COIN0		  ; Castle
;
BCOIST	 EQU	  $
	 LDY	  <ENVRFG
	 LDA	  BNCODT,Y
	 JMP	  BCBRST
;
;#####################################################################
;#	 Gorl steck & Chain & Sttil set data			     #
;#####################################################################
SCSSTD	 EQU	  $-(BBP60-OSBP4)/2
	 HEX	  06,07,08	       ; (y)pos
	 BYTE	  STEK0,CHIN0,STTL0    ; Block No.
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  STILST    [ Sttil floor set ]			     #
;#####################################################################
STILST	EQU	$
	LDY	#0CH
	JSR	OBWKIT
	BRA	CAINST
;k;	    JMP	     CAINST
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  GLSTST    [ Gorl steck set ]			     #
;#####################################################################
GLSTST	 EQU	  $
	 LDA	  #BKCG00
	 STA	  VRFLG		  ; Crymax color set
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  CAINST    [ Chain set ]			     #
;#####################################################################
CAINST	EQU	$
	LDY	<WORK
	LDX	SCSSTD,Y
	LDA	SCSSTD+3,Y
	BRA	SPSTS40
;K;	    JMP	     SPSTS40
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  SPSTS0    [ Spin steck center block set ]	     #
;#####################################################################
SPSTS0	 EQU	  $
	 JSR	  OBSTPC
;
	 LDX	  <WORK+7
	 LDA	  #BRIK2
SPSTS40	 EQU	  $
	 LDY	  #0
	 JMP	  OBSTST    ; Center block set
;
;#####################################################################
;#	 Pile up & Floor block No. data				     #
;#####################################################################
BKBND0	EQU	$			; No break !
	BYTE	ROCK0			; Underwater
	BYTE	HDBK0			; Ground
	BYTE	HDBK0			; Underground
	BYTE	CSWL0+5			; Castle
;
BKBND1	EQU	$			; break !
	BYTE	CORL0,BRIK0,BRIK1,BRIK1
	BYTE	CLBK0			; Sky
BKBND2	EQU	$
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRKST0    [ Break brick ]			     #
;#####################################################################
BRKST0	 EQU	  $
	 LDY	  <ENVRFG
	 LDA	  SKYFLG
	 BEQ	  BRKS40     ;sky ?
;			     ;yes
	 LDY	  #BKBND2-BKBND1-1
BRKS40	 EQU	  $
	 LDA	  BKBND1,Y
	 BRA	  BCBRST
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRKST1    [ No break brick ]			     #
;#####################################################################
BRKST1	 EQU	  $
	 LDY	  <ENVRFG
	 LDA	  BKBND0,Y
;
BCBRST	 EQU	  $
	 PHA
;
	 JSR	  OBITSB	  ; Initial
;
BCBS40	 EQU	  $
	 LDX	  <WORK+7
	 LDY	  #0
	 PLA
	 JMP	  OBSTST
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  PILST0    [ Pile up block ( break ) set ]	     #
;#####################################################################
PILST0	EQU	$
	LDY	<ENVRFG
	LDA	BKBND1,Y
	BRA	PLST50
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  PILST1    [ Pile up block ( no break ) set ]	     #
;#####################################################################
PILST1	EQU	$			; in Castle set
	LDY	<ENVRFG
	LDA	BKBND0,Y
;
PLST50	EQU	$
	PHA
;
	JSR	OBSTPC			; Initial
;
	PLA
	LDX	<WORK+7
	JMP	OBSTST			; Pile up block set
;
;#####################################################################
;#	 JSR	  BGUNST    [ Big gun set ]			     #
;#####################################################################
BGUNST	 EQU	  $	    ; Big-gun BG block No. set !
	 JSR	  OBSTPC	  ; Calc set position
;
	 LDX	  <WORK+7
	 LDA	  #BGUN0
	 STA	  NWFRLD,X
;
	 INX
	 DEY
	 BMI	  BGNS30	  ;- IF	 set end ?  ( YES ; BGNS30 )
;
	 LDA	  #BGUN0+1
	 STA	  NWFRLD,X
;
	 INX
	 DEY
	 BMI	  BGNS30	  ;- IF	 set end ?  ( YES ; BGNS30 )
;
	 LDA	  #BGUN0+2
	 JSR	  OBSTST	       ; Big-gun foot set
;
BGNS30	 EQU	  $
	 LDX	  GUNPT	    ; Big-gun chara position set !
;
BGNS60	 EQU	  $
	 JSR	  FYTOCY
	 STA	  GUYPS1,X	  ; (y)pos (L) set
;
	 LDA	  FRPTP0
	 STA	  GUXPS0,X	  ; (x)pos (H) set
;
	 JSR	  FXTOCX
	 STA	  GUXPS1,X	  ; (x)pos (L) set
;
	 INX
	 CPX	  #GUXPS1-GUXPS0
	 BCC	  BGNS70
;
	 LDX	  #0
;
BGNS70	 EQU	  $
	 STX	  GUNPT
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BSTEP0    [ Block step set No.0 ]		     #
;#####################################################################
;;;;;BSTPD0   EQU      $	       ; Block step value set data !
;;;;;	      HEX      07,07,06,05,04,03,02,01,00
;;;;;;
;;;;;BSTPD1   EQU      $	       ; Block step set (y)pos data !
;;;;;	      HEX      03,03,04,05,06,07,08,09,0A
;;;;;;
;;;;;;;;BSTEP0	 EQU	  $
;;;;;;;;	JSL	>S1BSTE
;;;;;;;;	RTS
;;;;;	      JSR      OBITSB
;;;;;	      BCC      BSTP30
;;;;;;
;;;;;	      LDA      #9
;;;;;	      STA      OBSTCT
;;;;;;
;;;;;BSTP30   EQU      $
;;;;;	      DEC      OBSTCT
;;;;;;
;;;;;	      LDY      OBSTCT
;;;;;	      LDX      BSTPD1,Y
;;;;;	      LDA      BSTPD0,Y
;;;;;	      TAY
;;;;;	      LDA      #HDBK0
;;;;;	      JMP      OBSTST	       ; Step set
;
;#####################################################################
;#		     (X) -- INDEX				     #
;#	 JSR	  JBODST    [ Jump bord & bord block set ]	     #
;#####################################################################
JBODST	 EQU	  $
	 JSR	  OBSTPC	  ; Set	 position clac
;;;;;	      JSR      ENEPCK	       ; Enemy empty area check
	 LDX	  #0
EEPC40X	 EQU	  $
	 CLC
	 LDA	  <ENCMOD,X
	 BEQ	  EEPC70X
	 INX
	 CPX	  #7
	 BNE	  EEPC40X
EEPC70X	 EQU	  $
;
	 JSR	  FXTOCX	  ;
	 STA	  ENXPS1,X	  ; Set	 (x)pos (L)
;
	 LDA	  FRPTP0
	 STA	  <ENXPS0,X	   ; Set  (X)pos (H)
;
	 JSR	  FYTOCY
	 STA	  ENYPS1,X	  ; Set	 (y)pos (L)
	 STA	  <ENCTPS,X	   ; Set  Main position
;
	 LDA	  #SPRG
	 STA	  <ENMYNO,X	   ; Set  Enemy No.
;
	 LDY	  #1
	 STY	  <ENYPS0,X	   ; Set  (y)pos (H)
;
	LDA	#1
	 STA	  <ENCMOD,X
;
	 LDX	  <WORK+7
	 LDA	  #SPRIG
	 STA	  NWFRLD,X
;
	 LDA	  #SPRIG+1
	 STA	  NWFRLD+1,X
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BXMSST    [ Mushroom in block ]		     #
;#	 JSR	  BXCOS0    [ Coin     in block set No.0 ]	     #
;#	 JSR	  STBCOS    [ Coin     in see thru block set ]	     #
;#	 JSR	  STBMSS    [ Mushroom in		     ]	     #
;#####################################################################
STBMSS	EQU	$
	LDA	SEMSFG
	BEQ	BBSB90		;- IF  see thru mushroom block set OK ?	 ( NO ; BBSB90 )
;
	STZ	SEMSFG		; Clear	 see thru mushroom block flag
	BRA	BKMSST
;
BXMSST	 EQU	  $
BXCOS0	 EQU	  $
STBCOS	 EQU	  $
STBNMS	 EQU	  $
BKDTMS1	 EQU	  $
BKDTMS3	 EQU	  $
	 JSR	  BNBSSB
	 JMP	  BMS030
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BKMSST    [ Bonus   mushroom	 in normal block ]   #
;#	 JSR	  BKWDST    [	      wood	 in		 ]   #
;#	 JSR	  BKSTRS    [	      super star in		 ]   #
;#	 JSR	  BKRCOS    [ Repeat  coin	 in		 ]   #
;#	 JSR	  BKSMHS    [ Special mushroom	 in normal block ]   #
;#####################################################################
BKRCOS	 EQU	  $
	STZ	RCOCNT		; Clear	 Repeat coin inital flag
;
BKMSST	 EQU	  $
BKWDST	 EQU	  $
BKSTRS	 EQU	  $
BKSMHS	 EQU	  $
BKDTMS2	 EQU	  $
	 JSR	  BNBSSB
	 STY	  <WORK+7
;
	 LDA	  #0
	 LDY	  <ENVRFG
	 DEY
	 BEQ	  BMS020	  ;- IF	 ground ?  ( YES ; BMS020 )
;
;;;;;;;;;	  LDA	   #(BNP80-BNP40)/2+1
	 LDA	  #BNBDID
;
BMS020	 EQU	  $
	 CLC
	 ADC	  <WORK+7
	 TAY
;
BMS030	 EQU	  $	    ; Set bonus block !
	 LDA	  !BNBKDT,Y
	 PHA
;
	 JSR	  OBSTPC	  ; Set position calc
;;K;;	      JMP      BCBS40
	LDX	<WORK+7
	PLA
	STA	NWFRLD,X
	RTS
;
;#####################################################################
;#	 JSR	  BNBSSB    [ Bonus block set sub ]		     #
;#####################################################################
BNBSSB	 EQU	  $
	 LDA	  <WORK
	 SEC
	 SBC	  #(BNP10-OSBP3)/2
	 TAY
;
BBSB90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  HOLEST    [ Hole & Sky set ]			     #
;#####################################################################
;;;;;;;;;HOLBND	  EQU	   $	     ; Hole block No. data !
;;;;;;;;;	  BYTE	   WATR1	   ; Underwater
;;;;;;;;;	  BYTE	   HOLE0	   ; Ground
;;;;;;;;;	  BYTE	   HOLE0	   ; Underground
;;;;;;;;;	  BYTE	   HOLE0	   ; Castle
;
HOLEST	EQU	$
	JSR	OBITSB			; Initial
	BCC	HLST80			; IF  initial now ?   ( NO ; HLST80 )
;
	LDA	<ENVRFG
	BNE	HLST80			; IF  in underwater ? ( NO ; HLST80 )
;
	LDX	WHPLPT			; Whirlpool position set !
	JSR	FXTOCX
	SEC
	SBC	#10H
	STA	WHPLX1,X		; (x)pos (L) set
;
	LDA	FRPTP0
	SBC	#00H
	STA	WHPLX0,X		; (x)pos (H) set
;
	INY
	INY
	TYA
	ASL	A
	ASL	A
	ASL	A
	ASL	A
	STA	WHPLX2,X		; Long range set
;
	INX
	CPX	#05H
	BCC	HLST40			; counter limit ?
;					; yes
	LDX	#00H
HLST40	EQU	$
	STX	WHPLPT			; next pointer set
;
HLST80	EQU	$			; Hole set !
	LDX	<ENVRFG
	LDA	#HOLE0
;;;;;	      LDA      HOLBND,X
;
	LDX	#8
	LDY	#0FH
;
;#####################################################################
;#		     (X) -- Set (y) pos				     #
;#		     (Y) --	count				     #
;#		     (A) -- Obstacle set block No.		     #
;#	 JSR	  OBSTST    [ NWFRLD <-- Obstacle data ]	     #
;#		     (X) -- Next set (y) pos			     #
;#####################################################################
OBSTST	EQU	$			; Check set obstacle data !
OBST30	EQU	$
	STY	OBSTWK
;
	LDY	NWFRLD,X
	BEQ	OBST40
;
	CPY	#LND0+1
	BEQ	OBST60			; IF  land ?
;
	CPY	#MUSH0+1
	BEQ	OBST60			; IF  mushroom ?
;
	CPY	#BXCON
	BEQ	OBST40			; IF  bonus coin ?
;
	CPY	#PUBK1+1
	BEQ	OBST60
;
	CPY	#PUBK1+5
	BEQ	OBST60
;
	CPY	#BLNKBK
	BCS	OBST60			; IF  bonus blink block ?
;
	CPY	#GRND0
	BNE	OBST40			; IF  ground block ?
;
	CMP	#MSHP0+1
	BEQ	OBST60			; IF  mushroom pole ?
;
OBST40	EQU	$
	STA	NWFRLD,X		; NWFRLD <-- Block No. set
;
OBST60	EQU	 $
	 INX
	 CPX	  #NWF1L-NWFRLD+1
	 BCS	  OBST90	       ;- IF  over new frame data area ?
;
	 LDY	  OBSTWK
	 DEY
	 BPL	  OBST30	  ;- IF	 all set end ?
;
OBST90	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  OBITSB    [ Obstacle set initial ]		     #
;#		     <C> -- 0 ; Not initial			     #
;#			    1 ; Initial				     #
;#####################################################################
OBITSB	 EQU	  $
	 JSR	  OBSTPC	  ; Set pos calc
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#		     (Y) -- Inital set value			     #
;#	 JSR	  OBWKIT    [ OBWORK initial set ]		     #
;#####################################################################
OBWKIT	 EQU	  $
	 LDA	  OBWORK,X
	 CLC
	 BPL	  OBWI80	  ;- IF	 initial ?  ( NO ; OBWI80 )
;
	 TYA
	 STA	  OBWORK,X
;
	 SEC
;
OBWI80	 EQU	  $
;
	 RTS
;
;#####################################################################
;#		     (X) -- Obstacle data table index		     #
;#	 JSR	  OBSTPC    [ Obstacle set position calc ]	     #
;#		  WORK+7 -- Set (y) pos				     #
;#		     (Y) --  "  count                                #
;#####################################################################
OBSTPC	EQU	$
	PHX
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	TXA
	AND	#00FFH
	ASL	A
	TAX
	LDY	OBSTPT,X
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
	 LDA	  [<FXODA0],Y
	 AND	  #0FH
	 STA	  <WORK+7		; <WORK+7 <-- (Y) pos
;
	 INY
;
	 LDA	  [<FXODA0],Y
	 AND	  #0FH
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	TAY				; Yr <-- Set count
;
	PLX
	RTS
;
;#####################################################################
;#		  FRPTP1 -- Frame table line pos		     #
;#	 JSR	  FXTOCX    [ Frame line pos --> Chara (x)pos (L) ]  #
;#		     (A) -- Chara (x)pos (L)			     #
;#####################################################################
FXTOCX	 EQU	  $
	 LDA	  FRPTP1
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
;
	 RTS
;
;#####################################################################
;#		  WORK+7 -- Frame table set (y)pos		     #
;#	 JSR	  FYTOCY    [ Frame (y)pos --> Chara (y)pos (L) ]    #
;#		     (A) -- Chara (y)pos (L)			     #
;#####################################################################
FYTOCY	 EQU	  $
	 LDA	  <WORK+7
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 CLC
	 ADC	  #20H
;
	 RTS
;
;#####################################################################
;#		     (A) -- Frame table line pos ( 00 - 1F )	     #
;#	 JSR	  FRTADC    [ Frame table address calc ]	     #
;#		  WORK+6 -- Frame table line address (L)	     #
;#		  WORK+7 --	   "         "	     (H)	     #
;#####################################################################
FRTBA0	 EQU	  $	    ; Frame data table address data !
	 BYTE	  (FRMTB0)&0FFH
	 BYTE	  (FRMTB1)&0FFH
;
FRTBA1	 EQU	  $
	 BYTE	  (FRMTB0)/100H
	 BYTE	  (FRMTB1)/100H
;
FRTADC	 EQU	  $
	 PHA
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 TAY
;
	 LDA	  FRTBA1,Y
	 STA	  <WORK+7
;
	 PLA
	 AND	  #0FH
	 CLC
	 ADC	  FRTBA0,Y
	 STA	  <WORK+6
;
	 RTS
;
;####################################################################
;#     JSL    S1OBIT						    #
;####################################################################
S1OBIT	EQU	$
	PHB
	PHK
	PLB
;
	JSR	OBITSB
;
	PLB
	RTL
;
;####################################################################
;#     JSL    S1OBST						    #
;####################################################################
S1OBST	EQU	$
	PHB
	PHK
	PLB
;
	JSR	OBSTST
;
	PLB
	RTL
;
;####################################################################
;#     JSL    S1OBWK						    #
;####################################################################
;
S1OBWK	EQU	$
	PHB
	PHK
	PLB
;
	JSR	OBWKIT
;
	PLB
	RTL
;
;####################################################################
;#     JSL    S1FXTO						    #
;####################################################################
S1FXTO	EQU	$
	PHB
	PHK
	PLB
;
	JSR	FXTOCX
;
	PLB
	RTL
;
;####################################################################
;#     JSL    S1ENEP						    #
;####################################################################
S1ENEP	EQU	$
	PHB
	PHK
	PLB
;
	JSR	ENEPCK
;
	PLB
	RTL
;
FRIPFW	EQU	$
	PHB
	PHK
	PLB
;
	PHA
	 JSR	  CMSTSB
	 PLA
	 STA	  WORK+7	  ;y-pos. set
;
	 TYA
	 PHA			  ;(y) push
;
	 LDY	  OBWORK,X
	 BEQ	  FICHS60
;
	 JSR	  ENEPCK
	 BCS	  FICHS60	  ;enemy area ok ?
;				  ;yes
	 LDA	  #FFWR
	 JSR	  CMST200	  ;enemy set
	 LDA	  WORK+6
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 ASL	  A
	 CLC
	 ADC	  ENYPS1,X
	 SEC
	 SBC	  #0AH
	 STA	  ENYPS1,X	  ;y-pos. reset
	 STA	  FWRFLG3,X
	 CLC
	 ADC	  #18H
	 STA	  FWRFLG4,X
	 INC	  FWRFLG2,X
;
FICHS60	 EQU	  $
	 PLA
	 TAY			  ;(y) pull
	 PHA			  ;(y) push
;
	 LDX	  WORK+7
	 LDA	  !CMSCBD+2,Y
	 LDY	  WORK+6
	 DEY
	 JSR	  OBSTST
	 PLA
	 TAY			  ;(y) pull
	 LDA	  !CMSCBD,Y
	 STA	  NWFRLD,X
;
	PLB
	RTL
;
;*********************************************************************
;*	 Flip flower enemy move			   (ENFLFWR)	     *
;*	 [in]	  (x)	      <-- index				     *
;*********************************************************************
ENFLFWR	 EQU	  $
;
	 LDA	  <ENSTAT,X
	 BNE	  EFFWR120    ;fail ?
;			      ;no.
	 LDA	  ETMS01,X
	 BNE	  EFFWR120    ;timer = 0 ?
;			      ;yes
	 LDA	  FWRFLG2,X
	 BNE	  EFFWR40     ;start check ?
;			      ;yes
	 LDA	  <FWRFLG1,X
	 EOR	  #0FFH
	 CLC
	 ADC	  #01H
	 STA	  <FWRFLG1,X   ;up,down flag set
	 INC	  FWRFLG2,X   ;move flag on
EFFWR40	 EQU	  $
	 LDA	  FWRFLG4,X
	 LDY	  <FWRFLG1,X
	 BPL	  EFFWR80     ;up move ?
;			      ;no
	 LDA	  FWRFLG3,X
EFFWR80	 EQU	  $
	 STA	  WORK	      ;(work) <-- y-pos. limit data
;
	 LDA	  GMSTTM
	 BNE	  EFFWR120    ;move ok ?
;			      ;yes
	 LDA	  ENYPS1,X
	 CLC
	 ADC	  <FWRFLG1,X
	 STA	  ENYPS1,X    ;y-pos. move
	 CMP	  WORK
	 BNE	  EFFWR120    ;limit ?
;			      ;yes
	 LDA	  #00H
	 STA	  FWRFLG2,X   ;move flag off
	 LDA	  #20H
	 STA	  ETMS01,X    ;timer set
EFFWR120 EQU	  $
	RTS
;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
	 END
