;
	include		mn_hp_smram.asm
;
	 ORG	  0E8000H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1991.12.03	    V.1.0  Super Mario-CD
;				   File	 name : SMSUB0
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		GLB	GST_INIT,CRGNS1X,CLSET1X,CLSET2
		GLB	NXCODT,NXBGDT,GMED20,GMED30
;
		EXT	WINDAT0,DIVDAT
;=========================================================== SMMAIN ==
		GLB	NXTBG,GMOVR,MRCLDT,GHORE,YURYUR
		GLB	ENWIND,GMEDSL
		EXT	WIRE2,WIRE0,BRIK1,HDBK0,CHM0,WOOD3,VRMCL3
		EXT	HOLE0,CAS0,CHM1,MUSH0,GRND0
		EXT	KIDN,CSWL0,CUTLT,CUTRT,CTLTC,CTRTC
		EXT	HOLE1,BRIK2,ROCK0,GRNDK
		EXT	HNDR0
		EXT	STRTR,STRST
		EXT	PLY0,WIRE1
;=========================================================== SMINIT ==
		GLB	INCSLE,BG3SET
		GLB	PCHEND,ELWSET
;;;;;;;;		GLB	S1ELWR,S1LFWR,S1CAST,S1BSTE,S1LCH0,S1WOOD
		EXT	PUBK1,FRIPFW
		EXT	S1OBST,S1OBWK,S1FXTO,S1ENEP
		EXT	S1OBIT
;=========================================================== SMENMY==
		EXT	CFLG
;=========================================================== SMSUB0 ==
		GLB	LRMVD,FLSHST
		EXT	BG2PTR,MARIOW,GRAUNT,CSIDDT,PASSUB
;=========================================================== SMCROS ==
		GLB	GLBGST
;=====================================================================
		EXT	M2SAVE
;
		EXTEND
		IDX8
		MEM8

;
;
;
;************************************************************************
;*		Game Start initial			(GST_INIT)	*
;************************************************************************
GST_INIT	EQU	$
		LDA	#1		; character change cancel
		STA	BGWFG2
		LDA	#3
		STA	ENDING
		STZ	PLCNFG
		STZ	ENCLFG
;
		LDA	>CORSRM
		STA	GOALRM
		STA	>LOADBF+1
		LDA	>WALDRM
		STA	CORSNO
		STA	>LOADBF
		ASL	A
		ASL	A
		CLC
		ADC	>CORSRM
		TAX
		LDA	>CSIDDT,X
		STA	>CORSRM
		STA	>LOADBF+2
		STA	CORSID
;
;------- PPU reset --------------------------------------
		LDA	#00000011B
		STA	2101H		; OBJ. size&address
		LDA	#00000001B
		STA	2107H		; BG.1 size&address
		LDA	#00001001B
		STA	2108H		; BG.2 size&address
		LDA	#01011001B
		STA	2109H		; BG.3 size&address
		STZ	210AH		; BG.4
		LDA	#00010001B
		STA	210BH		; BG.1,2 charactre address
		LDA	#00000101B
		STA	210CH		; BG.3,4 character address
		STZ	2133H		; gamen initial
;--------------------------------------------------------
;
		STZ	!SYMODE
		STZ	!GMMODE
		LDA	#000H
		STA	>GSTFLG
;
;;;;;;;;;;		  JSR	  SCROFF	  ; scroll count off
;
;*********************************************************************
;*	 Scroll initialize			   (SCROFF)	     *
;*********************************************************************
SCROFF		EQU	$
		STZ	SCCH
		STZ	SCCV
;
		STZ	210DH
		STZ	210DH
		STZ	210EH
		STZ	210EH
		STZ	210FH
		STZ	210FH
		STZ	2110H
		STZ	2110H
		STZ	2111H
		STZ	2111H
		STZ	2112H
		STZ	2112H
;
;;;;;;;;;;		  RTS
;
;
		LDA	#00001001B
		STA	!WD2105		; BG. mode&character size
		STZ	!MOZNO
;
		LDA	#00010000B
		STA	!WD212C		; display main
		STZ	!WD212D		; display sub
;
		STZ	!WD2123
		STZ	!WD2124
		STZ	!WD2125		; window on/off set
;
		STZ	!WD2130		; color window on/off set
		LDA	#00100000B
		STA	!WD2131		; add.&sub. set
;
		LDA	#00100000B
		STA	!CGRED
		LDA	#01000000B
		STA	!CGGRN
		LDA	#10000000B
		STA	!CGBLU		; R.G.B. set
;
		STZ	!WD420C		; H-DMA flag set
;
		LDA	#10000000B
		STA	!PASCFG
;
		STZ	!NMIFLG
		STZ	!PAUSEF
		STZ	!MFFLG
		STZ	!PASFLG
		STA	!SCRFLG
;
		STZ	ENCLFG
;
		STZ	<KDVRFG
;
		STZ	!PHEDFG
		STZ	!SKIPST
		STZ	!B2VFG
		STZ	!B3VFG
		STZ	!CGVMAF
		STZ	!VRFLG
		STZ	!WRTFLG		; flag initial
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00000H
		STA	>CGWORK
		STA	>CGWORK+100H
		LDA	#0FFFFH
		STA	!VRAMD+2
		STA	>B2VRAM+2
		STA	>B3VRAM+2
;
;------ BG character set --------------------------------
		PHD			; (D) push
		LDA	#04300H
		TCD			; (D) <-- #4300H
;
		LDX	#10000000B	;inc mode
		STX	2115H
;
		MEM16
		REP	#00100000B
;
		LDA	#1000H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)	;parameter & B bus address
		STA	<4300H
		LDA	#28000H		;A bus address
		STA	<4302H
		LDY	#BANK 108000H
		STY	<4304H
		LDA	#4000H		;number of byte
		STA	<4305H
		LDX	#00000001B	;DMA "ON"
		STX	420BH
;
;------ OBJ character set -------------------------------
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#6000H		; VRAM adress set
		STA	2116H
		LDA	#38000H		;A bus address
		STA	<4302H
		LDY	#BANK 78000H
		STY	<4304H
		LDA	#4000H		;number of byte
		STA	<4305H
		STX	420BH		;DMA "ON"
;
;------ BG.3 CHR SET ------------------------------------
		LDA	#5000H
		STA	2116H
		LDA	#7F800H
		STA	<4302H
		LDY	#BANK 0CF800H
		STY	<4304H
		LDA	#0800H
		STA	<4305H
		STX	420BH
;
;
		PLD			; (D) pull
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;--------------------------------------------------------
		RTL
;
;
;
;
;
;
;################################################################
;#								#
;#	game end key select					#
;#								#
;################################################################
GMEDSL		EQU	$
		LDA	!WNDMSG
		BMI	GMED15
		BNE	GMED10
		LDA	!KEYA2
		AND	#00010000B
		BEQ	GMED15
		INC	!WNDMSG
		LDA	#043H
		STA	!SOUND0
GMED10		EQU	$
		DEC	!WNHNKI
		DEC	!WNHNKI
		LDA	!WNHNKI
		BPL	GMED15
		LDA	#00DH
		STA	!GMMODE
		LDA	#001H
		STA	!BSLFG
GMED15		EQU	$
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	window initial set			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMED20		EQU	$
		JSL	>PASSUB
		LDA	!CORSNO
		CMP	#008H
		BCS	GMED28
		LDA	#010H
		STA	!WNDMSG
		STZ	!CORSID		; Course index clear
		STZ	!GOALCT		; Gorl counter clear
		LDA	!WARPCT
		BEQ	GMED25
		LDA	#001H
		STA	!URAFLG
		INC	!CORSNO
GMED25		EQU	$
		INC	!CORSNO
;
GMED28		EQU	$
		LDA	#022H
		STA	!WD2123
		LDA	#002H
		STA	!WD2124
		INC	!GMMODE
		LDA	!PLAYSW
		BEQ	GMED21
		LDA	#002H
		STA	!WD212F
		STZ	!PASFLG
		LDA	#004H
		STA	!WNDMSG
GMED21		EQU	$
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	pause window open			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMED30		EQU	$
		LDA	02140H
		BNE	GMED35			;
;						;
		LDA	#00AH
		STA	!GMMODE
		LDA	!WNDMSG
		ORA	#080H
		STA	!WNDMSG
GMED35		EQU	$
		RTL
;
;
;
;################################################################
;#	JSL	ENWIND						#
;#			( waip wind )				#
;#								#
;################################################################
;
ENWIND		EQU	$
		LDA	!WNHNKI
		CMP	#030H
		BCC	EN0000
		RTL
;
EN0000		EQU	$
		PHB
		PHK
		PLB
		PHD			; (D) push
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDA	#0B00H
		TCD			; (D) <-- #0B00H
;
		STZ	<DWORK4
		STZ	<DWORKE
		STZ	<WNYBUF		; Y
		STZ	<WNXBUF		; X
		LDA	<WNHNKI
		AND	#00FFH
		ASL	A
		TAX
		LDA	>DIVDAT,X
		STA	<WNDIVD
;
		LDA	#0078H		; Y-pos (center)
		STA	<WNYPL0
;
		LDA	#00B0H		; X-pos (center)
		STA	<WNXPL0
;
ENST00		EQU	$
		LDA	#00100H
		STA	<DWORK0		; x-pos 1 clear
		STA	<DWORK2		; x-pos 2 clear
;
		LDA	<WNYBUF		; Y
		INC	A
		CMP	<WNHNKI
		BCS	ENST10
;
		LDA	<WNXBUF
		CLC
		ADC	<WNDIVD
		STA	<WNXBUF
		XBA
		AND	#00FFH
		LSR	A
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
;
		TAX
		LDA	>WINDAT0,X
		STA	4202H
		LDA	<WNHNKI
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4217H
		STA	<DWORK8
		STZ	<DWORK9
;
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	<DWORK8
		CLC
		ADC	<WNXPL0
		STA	<DWORK2
		LDA	<WNXPL0			; window x-pos 1 set
		SEC
		SBC	<DWORK8
		STA	<DWORK0
;
ENST10		EQU	$
		LDA	<WNYPL0			; h-dma buff index --> x
		SEC
		SBC	<WNYBUF
		DEC	A
		ASL	A
		STA	<DWORK4
		TAX
		LDA	<DWORK0			; (L) x-pos 1 set
		TAY
		BMI	ENST20
		AND	#0FF00H
		BEQ	ENST30
		CMP	#00100H
		BNE	ENST20
		LDY	#00FFH
		BRA	ENST30
ENST20		EQU	$
		LDY	#0000H
ENST30		EQU	$
		TYA
		AND	#00FFH
		STA	<DWORK6
;
		LDA	<DWORK2			; (H) x-pos 2 set
		TAY
		AND	#0FF00H
		BEQ	ENST50
		LDY	#00FFH
ENST50		EQU	$
		TYA
		AND	#00FFH
		XBA
		ORA	<DWORK6
		STA	<DWORK6
		CPX	#001C0H
		BCS	ENST54
		CMP	#0FFFFH
		BNE	ENST52
		LDA	#000FFH
ENST52		EQU	$
		STA	>HDMABW,X		; h-dma (H),(L) 0 set
;
ENST54		EQU	$
		LDA	<WNYPL0			; h-dma buff index --> x
		CLC
		ADC	<WNYBUF
		DEC	A
		ASL	A
		STA	<DWORKE
		CMP	#001C0H
		BCS	ENST56
		TAX
		LDA	<DWORK6
		CMP	#0FFFFH
		BNE	ENST55
		LDA	#000FFH
ENST55		EQU	$
		STA	>HDMABW,X
;
ENST56		EQU	$
		INC	<WNYBUF
		LDA	<DWORK4
		CMP	#001C0H
		BCC	ENST5C
		LDA	<DWORKE
		CMP	#001C0H
		BCS	ENST60
;
ENST5C		EQU	$
		JMP	ENST00
;
ENST60		EQU	$
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
;
		INC	<WNHNKI			; ha-n-ke-i inc.
;
		PLD				; pop (D)
		PLB
		RTL
;
;
;################################################################
;#	JSL	PCHEND						#
;#			( peach ending )			#
;#								#
;################################################################
;
PCHEND		EQU	$
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		LDX	#000H
;
PHED10		EQU	$
		STZ	!FRMTB1+000H,X
		STZ	!FRMTB1+010H,X
		STZ	!FRMTB1+020H,X
		STZ	!FRMTB1+030H,X
		STZ	!FRMTB1+040H,X
		STZ	!FRMTB1+050H,X
		STZ	!FRMTB1+060H,X
		STZ	!FRMTB1+070H,X
		STZ	!FRMTB1+080H,X
		STZ	!FRMTB1+090H,X
		STZ	!FRMTB1+0A0H,X
		STZ	!FRMTB1+0B0H,X
		STZ	!FRMTB1+0C0H,X
		INX
		TXA
		AND	#00FH
		BNE	PHED10
;
		LDA	#CSWL0+3
		STA	!FRMTB1+070H
		STA	!FRMTB1+071H
		STA	!FRMTB1+072H
;
		STA	!FRMTB1+0A3H
		STA	!FRMTB1+0A4H
		STA	!FRMTB1+0A5H
		STA	!FRMTB1+0A6H
;
		STA	!FRMTB1+079H
		STA	!FRMTB1+07AH
		STA	!FRMTB1+07BH
		STA	!FRMTB1+07CH
		STA	!FRMTB1+07DH
		STA	!FRMTB1+07EH
;
		LDA	#001H
		STA	!PHEDFG
		RTL
;
;
;
;
;####################################################################
;#	 yu-ra yu-ra bu-bu-n scroll				    #
;#								    #
;####################################################################
;
YURYUR		EQU	$
		STZ	<KWORK3
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	!YURCNT
		STA	<KWORK0
		STZ	<KWORK4
YRYRLOP		EQU	$
		LDX	<KWORK0
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	>SINDT,X		; sin data(L)*hankei
		CLC
		ROL	A
		ROL	A
		AND	#01H
		STA	<KWORK2
		LDA	>SINDT+1,X		; sin data(H)*hankei
		ASL	A
		MEM16
		REP	#00100001B		; memory 16bit mode
		LDX	<KWORK4
		ADC	<KWORK2
		AND	#00FFH
		CMP	#0080H
		BCC	YRYR10
		ORA	#0FF00H
YRYR10		EQU	$
		CLC
		ADC	!SCCH21
		CLC
		ADC	#0008H
		STA	>B3VRAM+000H,X
;
		LDA	<KWORK0
		CLC
		ADC	#0010H
		AND	#01FFH
		STA	<KWORK0
		INC	<KWORK4
		INC	<KWORK4
		LDA	<KWORK4
		CMP	#0040H		; 01c0h <--> 0040h
		BNE	YRYRLOP
;
		LDA	!YURCNT
		CLC
		ADC	#0004H
		AND	#01FFH
		STA	!YURCNT
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
;
		PHB
		LDA	#BANK B3VRAM
		PHA
		PLB
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDY	#03EH
HDMSET		EQU	$
		LDA	B3VRAM+000H,Y
		STA	B3VRAM+040H,Y
		STA	B3VRAM+080H,Y
		STA	B3VRAM+0C0H,Y
		STA	B3VRAM+100H,Y
		STA	B3VRAM+140H,Y
		STA	B3VRAM+180H,Y
		STA	B3VRAM+1C0H,Y
		DEY
		DEY
		BPL	HDMSET
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
;
YRYRED		EQU	$
		RTL
;
;
;************************************************************************
;*		H-DMA  data						*
;************************************************************************
SINDT	EQU	$				; sin data
	WORD	00000H,0FFFAH,0FFF4H,0FFEEH,0FFE7H,0FFE1H,0FFDBH,0FFD5H
	WORD	0FFCFH,0FFC8H,0FFC2H,0FFBCH,0FFB6H,0FFB0H,0FFAAH,0FFA4H
	WORD	0FF9FH,0FF99H,0FF93H,0FF8DH,0FF88H,0FF82H,0FF7DH,0FF78H
	WORD	0FF72H,0FF6DH,0FF68H,0FF63H,0FF5EH,0FF59H,0FF55H,0FF50H
	WORD	0FF4BH,0FF47H,0FF43H,0FF3FH,0FF3BH,0FF37H,0FF33H,0FF2FH
	WORD	0FF2CH,0FF28H,0FF25H,0FF22H,0FF1FH,0FF1CH,0FF19H,0FF16H
	WORD	0FF14H,0FF12H,0FF0FH,0FF0DH,0FF0CH,0FF0AH,0FF08H,0FF07H
	WORD	0FF05H,0FF04H,0FF03H,0FF02H,0FF02H,0FF01H,0FF01H,0FF01H
	WORD	0FF01H,0FF01H,0FF01H,0FF01H,0FF02H,0FF02H,0FF03H,0FF04H
	WORD	0FF05H,0FF07H,0FF08H,0FF0AH,0FF0CH,0FF0DH,0FF0FH,0FF12H
	WORD	0FF14H,0FF16H,0FF19H,0FF1CH,0FF1FH,0FF22H,0FF25H,0FF28H
	WORD	0FF2CH,0FF2FH,0FF33H,0FF37H,0FF3BH,0FF3FH,0FF43H,0FF47H
	WORD	0FF4BH,0FF50H,0FF55H,0FF59H,0FF5EH,0FF63H,0FF68H,0FF6DH
	WORD	0FF72H,0FF78H,0FF7DH,0FF82H,0FF88H,0FF8DH,0FF93H,0FF99H
	WORD	0FF9FH,0FFA4H,0FFAAH,0FFB0H,0FFB6H,0FFBCH,0FFC2H,0FFC8H
	WORD	0FFCFH,0FFD5H,0FFDBH,0FFE1H,0FFE7H,0FFEEH,0FFF4H,0FFFAH
	WORD	00000H,00006H,0000CH,00012H,00019H,0001FH,00025H,0002BH
	WORD	00031H,00038H,0003EH,00044H,0004AH,00050H,00056H,0005CH
	WORD	00061H,00067H,0006DH,00073H,00078H,0007EH,00083H,00088H
	WORD	0008EH,00093H,00098H,0009DH,000A2H,000A7H,000ABH,000B0H
	WORD	000B5H,000B9H,000BDH,000C1H,000C5H,000C9H,000CDH,000D1H
	WORD	000D4H,000D8H,000DBH,000DEH,000E1H,000E4H,000E7H,000EAH
	WORD	000ECH,000EEH,000F1H,000F3H,000F4H,000F6H,000F8H,000F9H
	WORD	000FBH,000FCH,000FDH,000FEH,000FEH,000FFH,000FFH,000FFH
	WORD	000FFH,000FFH,000FFH,000FFH,000FEH,000FEH,000FDH,000FCH
	WORD	000FBH,000F9H,000F8H,000F6H,000F4H,000F3H,000F1H,000EEH
	WORD	000ECH,000EAH,000E7H,000E4H,000E1H,000DEH,000DBH,000D8H
	WORD	000D4H,000D1H,000CDH,000C9H,000C5H,000C1H,000BDH,000B9H
	WORD	000B5H,000B0H,000ABH,000A7H,000A2H,0009DH,00098H,00093H
	WORD	0008EH,00088H,00083H,0007EH,00078H,00073H,0006DH,00067H
	WORD	00061H,0005CH,00056H,00050H,0004AH,00044H,0003EH,00038H
	WORD	00031H,0002BH,00025H,0001FH,00019H,00012H,0000CH,00006H
;
;
;####################################################################
;#	 BG3 bu-bu-n scroll					    #
;#								    #
;####################################################################
;
B3STIT		EQU	$
		PHB
		PHK
		PLB
		BRA	B3ST05
;
BG3SET		EQU	$
		PHB
		PHK
		PLB
;
		LDA	WDWFLG
		BEQ	B3ST99
;
		JSR	BG3AD
;
B3ST05		EQU	$
		PHX
		PHY
;
		LDA	!SKIPST		; skip flag clear
		AND	#080H
		STA	!SKIPST
		LDA	<ENVRFG
		BNE	B3ST10		; Water ?
		JSR	B3WFS		; yes -> Water face set
		LDA	#06H
		STA	VRFLG
		JMP	B3ST90
;
B3ST10		EQU	$
		CMP	#01H		; Ground ?
		BNE	B3ST00
;
		JSR	B3CLD
		LDA	#01H
		STA	!B3VFG
;
B3ST90		EQU	$
		LDA	#01H
		STA	SCHFLG
B3ST00		EQU	$
		PLY
		PLX
;
B3ST99		EQU	$
		PLB
		RTL
;
;
;####################################################################
;#	 BG3 Cloud set						    #
;#								    #
;####################################################################
;
B3CLD		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
;
		LDA	#000EH
		STA	<KWORK4
		LDA	!BG3IDX
		STA	<WORK0
;
		LDA	>B3VRAM
		TAX
		LDA	<KWORK0			; Adress set
		XBA				;
		STA	>B3VRAM+02H,X		;
		INC	A			;
		STA	>B3VRAM+(1CH*2+4),X	;
;
B3CLD10		EQU	$			; unit NO. read
		PHX				;
		LDX	<WORK0			;
		LDA	>B3BUFF,X		;
		AND	#00FFH			;
		ASL	A			;
		ASL	A			;
		ASL	A			;
		TAY				;
		PLX				;
;
		LDA	CLDUNT,Y		; Left
		STA	>B3VRAM+04H,X		;  side ta-te
		LDA	CLDUNT+02H,Y		;   line data set
		STA	>B3VRAM+06H,X		;
;
		LDA	CLDUNT+04H,Y		; Right
		STA	>B3VRAM+(1CH*2+6),X	;  side ta-te
		LDA	CLDUNT+06H,Y		;   line data set
		STA	>B3VRAM+(1CH*2+8),X	;
;
		INX
		INX
		INX
		INX
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		DEC	<KWORK4
		BNE	B3CLD10
;
		LDA	>B3VRAM
		TAX
		LDA	#0FFFFH			; end code
		STA	>B3VRAM+(1CH*4+6),X	;
;
		LDA	>B3VRAM
		CLC
		ADC	#0074H
		STA	>B3VRAM
;
		LDA	!BG3IDX
		INC	A
		AND	#000FH
		BNE	B3CLD90
		LDA	!BG3IDX
		AND	#0FFF0H
		CLC
		ADC	#00E0H
		STA	!BG3IDX
		BRA	B3CLD95
B3CLD90		EQU	$
		INC	!BG3IDX
B3CLD95		EQU	$
		LDA	!BG3IDX
		CMP	#0A80H
		BCC	B3CLD99
		STZ	!BG3IDX
;
B3CLD99		EQU	$
		LDA	<KWORK0
		CLC
		ADC	#0200H
		STA	<KWORK0
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
;
		RTS
;
;####################################################################
;#	 BG3 Water face set					    #
;#								    #
;####################################################################
;
B3WFS		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDX	BGDBPT		; X <-- BG data display buffer index
;
		LDA	<KWORK0		; Adress set
		STA	BGDSBF,X	;
		CLC			;
		ADC	#0100H		;
		STA	BGDSBF+06H,X	;
		CLC
		ADC	#0100H
		STA	<KWORK0
;
		LDA	#0100H		; Data ku-su-u set
		STA	BGDSBF+02H,X	;
		STA	BGDSBF+08H,X	;
;
		LDA	<KWORK0		; Data set
		AND	#0200H		;
		BNE	B3WFS0		;
		LDA	#2C2CH		; Right data
		LDY	#2C2DH		;
		BRA	B3WFS3		;
B3WFS0		EQU	$		;
		LDA	#2C2EH		; Left data
		LDY	#2C2FH		;
B3WFS3		EQU	$		;
		STA	BGDSBF+04H,X	;
		TYA
		STA	BGDSBF+0AH,X	;
;
		LDA	#0FFFFH		; end code
		STA	BGDSBF+0CH,X
;
		LDA	BGDBPT
		CLC
		ADC	#000CH
		STA	BGDBPT
;
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
;
		RTS
;
;####################################################################
;#	 BG3 adress set						    #
;#								    #
;####################################################################
;
;
BG3AD		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDA	SCCH31
		CLC
		ADC	#0120H
		XBA
		STA	<KWORK0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
;
B3AD00		EQU	$
		LDA	<KWORK0		; BG3 Adress
		AND	#01H		;	High set
		BNE	B3AD10		;
		LDA	#58H		;
		BRA	B3AD20		;
B3AD10		EQU	$		;
		LDA	#5CH		;
B3AD20		EQU	$		;
		STA	<KWORK0		;
;
		LDA	<KWORK1		; BG3 Adress
		LSR	A		;	Low set
		LSR	A		;
		LSR	A		;
		CLC			;
		ADC	#80H		;
		STA	<KWORK1		;
;
		RTS
;
;####################################################################
;#	JSL	GLBGST						    #
;#								    #
;####################################################################
;
SMBLDT		EQU	$
		HEX	00,00,80,07
		WORD		2E62H,2E72H,2E73H,2E72H
		HEX	00,00,80,07
		WORD		2E63H,2E73H,2E72H,2E73H
		HEX	00,00,80,07
		WORD		2E64H,2E74H,2E4EH,2E74H
		WORD	0FFFFH
;
BIGGLDT		EQU	$
		HEX	00,00,80,07
		WORD		2E73H,2E72H,2E73H,2E72H
		HEX	00,00,80,07
		WORD		2E72H,2E73H,2E72H,2E73H
		HEX	00,00,80,07
		WORD		2E5EH,2E66H,6E67H,0AE66H
		WORD	0FFFFH
;
;
GLDTAD		EQU	$
		WORD	SMBLDT,BIGGLDT
;
;
GLBGST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	#BANK GLDTAD
		STA	<KWORK2
		LDA	!GLGTFG		; data read adress index set
		AND	#01H		;
		ASL	A		;
;
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		AND	#0002H		; data read adress set
		TAY			;
		LDA	GLDTAD,Y	;
		STA	<KWORK0		;
		LDX	!VRAMD
		LDY	#0000H
;
GLBG10		EQU	$
		LDA	[<KWORK0],Y	; BG set
		STA	!VRAMD+2,X	;
		INY			;
		INY			;
		INX			;
		INX			;
		CMP	#0FFFFH		;
		BNE	GLBG10		;
;
		LDX	!VRAMD
;
		LDA	!STPADL
		AND	#0020H
		BEQ	GLBG20
		LDA	!STPADL
		AND	#0FDFH
		EOR	#0400H
		STA	!STPADL
;
GLBG20		EQU	$
		LDA	!STPADL
		CLC
		ADC	#02C1H
		AND	#0FDFH
		TAY
;
		XBA
		STA	!VRAMD+2,X
;
		INY
		TYA
		AND	#0020H
		BEQ	GLBG30
		TYA
		AND	#0FDFH
		EOR	#0400H
		TAY
GLBG30		EQU	$
		TYA
		XBA
		STA	!VRAMD+14,X
;
		INY
		TYA
		XBA
		STA	!VRAMD+26,X
;
		LDA	!VRAMD
		CLC
		ADC	#0024H
		STA	!VRAMD
;
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
		STZ	!GLGTFG
		LDA	#06H
		STA	VRFLG
		PLB
		RTL
;
;
;#################################################################
;#	 JSL	HORE						 #
;#################################################################
;
		MEM16
		IDX16
;
GHORE		EQU	$
		LDY	BGDBPT
		LDA	BGDSBF-10,Y
;
		CMP	#0024H		; Water data
		BEQ	GHOR10		;
		CMP	#10A4H		;
		BNE	GHORE1		;
GHOR10		EQU	$
		LDA	GSITAL
		AND	#00FFH
		BEQ	GHOR13
		JMP	GHORE2
GHOR13		EQU	$
		INC	GSITAL
		LDX	VRAMD
		LDA	GSTAD
		DEC	A
		AND	#041FH
		CLC
		ADC	#0340H
		XBA
		STA	VRAMD+2,X
		LDA	#0780H
		STA	VRAMD+4,X
		LDA	#0A0DH
		STA	VRAMD+6,X
		LDA	#0A1DH
		STA	VRAMD+8,X
		LDA	#0A0FH
		STA	VRAMD+10,X
		LDA	#0A1FH
		STA	VRAMD+12,X
		BRA	GHORE3
GHORE1		EQU	$
;
		CMP	#0A08H
		BNE	GHORE2
GHORE4		EQU	$
		LDA	GSITAR
		AND	#00FFH
		BEQ	GHORE2
		STZ	GSITAL
		LDA	<SCCH1+1		; Start point left side check
		BNE	GHOR15		; scrol(H) = 0	NO->GHOR15
		LDA	GSTAD		;
		BEQ	GHORE2
;
GHOR15		EQU	$
		LDX	VRAMD
		LDA	GSTAD
		CLC
		ADC	#0340H
		XBA
		STA	VRAMD+2,X
		LDA	#0780H
		STA	VRAMD+4,X
		LDA	#0A0CH
		STA	VRAMD+6,X
		LDA	#0A1CH
		STA	VRAMD+8,X
		LDA	#0A0EH
		STA	VRAMD+10,X
		LDA	#0A1EH
		STA	VRAMD+12,X
GHORE3		EQU	$
		LDA	#0FFFFH
		STA	VRAMD+14,X
		TXA
		CLC
		ADC	#000CH
		STA	VRAMD
GHORE2		EQU	$
;
		RTL
;
		MEM8
		IDX8
;
;
;#####################################################################
;#	 Elevatore wire & pulley block No. data			     #
;#####################################################################
WRBKND	 EQU	  $	    ; Wire & Pulley data !
	 BYTE	  PLY0,WIRE1,PLY0+1    ; right.center.left
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  ELWPST    [ Elevatore wire & pulley set ]	     #
;#####################################################################
ELWSET		EQU	$
		JSL	>S1OBIT		; Initial sub
;;;;K;;;;		JSR	OBITSB		; Initial sub
		LDY	#0
;
PPST20		EQU	$
		BCS	PPST40		; IF left side ( initial )?  (YES ; PPST30)
;
		INY
;
		LDA	OBWORK,X
		BNE	PPST40		; IF right side ? ( NO ; PPST40 )
;
		INY
;
PPST40		EQU	$
		PHB
		PHK
		PLB
		LDA	WRBKND,Y
		STA	!NWFRLD		; NWFRLD <-- Pipe data
		PLB
;
PPST90		EQU	$
		RTL
;
;
;
;####################################################################
;#	 JSL   INCSLE						    #
;####################################################################
;
	IDX16
;
INCSLE	EQU	$
	PHB
	PHK
	PLB
;
	INY
	INY
	LDA	<FXODA0
	STA	<KWORK0
	LDA	<FXODA0+1
	STA	<KWORK1
	LDA	<FXODA0+2
	STA	<KWORK2
	LDA	[KWORK0],Y
;
	MEM16
	REP	#00100000B		; memory 16bit mode
;
	AND	#007FH
	TAX
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
	LDA	JPOSBP,X
	STA	<WORK
	LDA	JPOSBP+1,X
	STA	<WORK1
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	LDX	<INDEX
	LDY	<KWORK4
	JMP	(WORK)
;
;
JPOSBP	EQU	$
	WORD	ELWRST		; 0 Elevatore wire
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	LFWRST		; 1 Lift      wire
	WORD	BGCSST,RTSEND
	WORD	SRTRST,SRSTST
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	CASTST		; 2  Castle
	WORD	BRIGE0,BRIGE1
	WORD	BRIGE2,LONGBK
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	BSTEP0		; 3  Block step
	WORD	KIDNST
	WORD	NBBLK,CUTLS
	WORD	CUTRS,CTLCS
	WORD	CTRCS,RCKST
	WORD	LCH0ST		; 4  L-chimney No.0 ( underground --! ground )
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	WOODST		; 5  Wood
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	FICHMS1		; 6  SAKASA DOKAN
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND
	WORD	FICHMS2		; 7  SAKASA DOKAN
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND,RTSEND
	WORD	RTSEND
;
;####################################################################
;#	RTS end							    #
;####################################################################
;
RTSEND	EQU	$
	PLB
	RTL
;
;
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  SRTRST					     #
;#####################################################################
BGCSST		EQU	$
;
		JSR	S1OBPC
		JSL	>S1OBWK
;
		LDX	<WORK7
		LDA	#HOLE0
		STA	!NWFRLD,X
;
		PLB
		RTL
;
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  SRTRST    [ Elevator wire set ]		     #
;#####################################################################
;
SRTRST		EQU	$
;
		JSR	S1OBPC
		JSL	>S1OBWK
;
		LDX	<WORK7
		LDA	#STRTR
		STA	NWFRLD,X
;
		PLB
		RTL
;
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  SRSTST    [ Elevator wire set ]		     #
;#####################################################################
;
SRSTST		EQU	$
;
		JSR	S1OBPC
		JSL	>S1OBWK
;
		LDX	<WORK7
		LDA	#STRST
		STA	!NWFRLD,X
;
		PLB
		RTL
;
;
;*********************************************************************
;*	 Up,down Flip chimmy set - 1		   (FICHMS1)	     *
;*********************************************************************
FICHMS1		EQU	$
;
		LDA	#01H
		BNE	FICHS20
;
;*********************************************************************
;*	 Up,down Flip chimmy set - 2		   (FICHMS2)	     *
;*********************************************************************
FICHMS2		EQU	$
		LDA	#04H
FICHS20		EQU	$
		JSL	>FRIPFW
;
		LDA	#CHM0+6
		STA	NWFRLD,X
		LDA	NWFRLD-1,X
		CMP	#CHM0+5
		BNE	FICHS29
		INC	NWFRLD,X
FICHS29		EQU	$
;
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  ELWRST    [ Elevator wire set ]		     #
;#####################################################################
ELWRST	EQU	$
	LDX	#0
	LDY	#0FH
	BRA	LWST50
;K;	    JMP	     LWST50
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LFWRST    [ Lift wire set ]			     #
;#####################################################################
LFWRST	 EQU	  $
	 TXA
	 PHA
;
	 LDX	  #1
	 LDY	  #0FH
	 LDA	  #WIRE2
	JSL	>S1OBST
;;;;;	      JSR      OBSTST	       ; Set wire color
;
	 PLA
	 TAX
	JSR	S1OBPC
;;;;;	      JSR      OBSTPC	       ; Set position calc
;
	 LDX	  #1
;
LWST50	 EQU	  $
	 LDA	  #WIRE0
	JSL	>S1OBST
	PLB
	RTL
;;;;;	      JMP      OBSTST	       ; Set wire
;
;#####################################################################
;#	 Castle data						     #
;#####################################################################
CASBND	EQU	$			; Castle block No. data !
	BYTE	HOLE0,HOLE0,HOLE0,CAS0+31,CAS0+06,CAS0+05,CAS0+30,HOLE0,HOLE0,HOLE0
	BYTE	HOLE0,HOLE0,HOLE0,CAS0+20,CAS0+27,CAS0+26,CAS0+16,HOLE0,HOLE0,HOLE0
	BYTE	HOLE0,HOLE0,CAS0+35,CAS0+34,CAS0+07,CAS0+04,CAS0+33,CAS0+32,HOLE0,HOLE0
	BYTE	HOLE0,HOLE0,CAS0+20,CAS0+19,CAS0+13,CAS0+12,CAS0+17,CAS0+16,HOLE0,HOLE0
	BYTE	CAS0+38,HOLE0,CAS0+25,CAS0+24,CAS0+29,CAS0+28,CAS0+22,CAS0+21,CAS0+37,CAS0+36
;
	BYTE	CAS0+11,CAS0+10,CAS0+09,CAS0+08,CAS0+07,CAS0+04,CAS0+03,CAS0+02,CAS0+01,CAS0+00
	BYTE	CAS0+20,CAS0+19,CAS0+18,CAS0+13,CAS0+12,CAS0+13,CAS0+12,CAS0+18,CAS0+17,CAS0+16
	BYTE	CAS0+25,CAS0+24,CAS0+23,CAS0+29,CAS0+28,CAS0+29,CAS0+28,CAS0+23,CAS0+22,CAS0+21
	BYTE	CAS0+25,CAS0+24,CAS0+23,CAS0+23,CAS0+23,CAS0+23,CAS0+23,CAS0+23,CAS0+22,CAS0+21
	BYTE	CAS0+25,CAS0+24,CAS0+15,CAS0+14,CAS0+15,CAS0+14,CAS0+15,CAS0+14,CAS0+22,CAS0+21
	BYTE	CAS0+25,CAS0+24,CAS0+29,CAS0+28,CAS0+29,CAS0+28,CAS0+29,CAS0+28,CAS0+22,CAS0+21
CSBD		EQU	$
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  CASTST    [ Castle set ]			     #
;#####################################################################
CASTST		EQU	$
		JSR	S1OBPC		; Set castle block !
;;;;;	      JSR      OBSTPC
		STY	<WORK+7		; <WORK+7 <-- Set (y)pos
;
		STZ	!GLADFG
		TYA
		BNE	CASS10
		LDY	#8		; 8 <--> 4
CASS10		EQU	$
		INY
		JSL	>S1OBWK		; Initial set OBWORK
;;;;;	      JSR      OBWKIT
;
		PHX
;
		LDY	OBWORK,X
		LDX	<WORK+7
		LDA	#(CSBD-CASBND)/5
		STA	<WORK+6
;
CASS30		EQU	$
		LDA	CASBND,Y
		STA	NWFRLD,X
		INX
		LDA	<WORK+6
		BEQ	CASS50
;
		TYA			; INY*A <--> INY*5
		CLC			;
		ADC	#0AH		;
		TAY			;
;
		DEC	<WORK+6
;
CASS50		EQU	$
		CPX	#0BH
		BNE	CASS30
;
		PLX
		LDA	<WORK7
		BEQ	CASS60
		LDA	!OBWORK,X
		BNE	CASS60
		STZ	!NWFRLD+10
;
CASS60		EQU	$
		LDA	FRPTP0
		BEQ	CASS90		; IF gorl castle ?	 (NO ; CASS90)
;
		LDA	OBWORK,X
		CMP	#05H
		BNE	CASS90		; IF castle center ?	 (NO ; CASS80)
;
		JSL	>S1FXTO		; Initial set  flag on caltle !
		PHA
		JSL	>S1ENEP
		PLA
		CLC
		ADC	#08
		STA	ENXPS1,X	; (x)pos (L) set
;
		LDA	FRPTP0
		ADC	#0
		STA	<ENXPS0,X	; (x)pos (H) set
;
		LDA	#1
		STA	<ENYPS0,X	; (y)pos (H) set
		STA	<ENCMOD,X
;
		LDA	#90H
		STA	ENYPS1,X	; (Y)pos (L) set
;
		LDA	#CFLG
		STA	<ENMYNO,X	; Enemy No.
;
		INC	!GLADFG
		LDA	<WORK7
		BEQ	CASS90
		INC	!GLADFG
;
CASS90		EQU	$
		LDA	FRPTP0
		BEQ	CASS99		; IF gorl castle ? (NO ; CASS99)
		LDA	NWFRLD+11
		CMP	#GRND0
		BEQ	CASS95
		CMP	#MUSH0+1
		BEQ	CASS97
		CMP	#ROCK0
		BEQ	CASS96
		CMP	#CSWL0+3
		BEQ	CASS94
		LDA	#ROCK0+4
		BRA	CASS98
CASS94		EQU	$
		LDA	#CSWL0+6
		BRA	CASS98
CASS95		EQU	$
		LDA	#GRNDK
		BRA	CASS98
CASS96		EQU	$
		LDA	#ROCK0+3
		STA	!NWFRLD+12
		BRA	CASS98
CASS97		EQU	$
		LDA	#MUSH0+3
CASS98		EQU	$
		STA	NWFRLD+11
;
CASS99		EQU	$
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRIGE0    [ Bridge set No.0 ]			     #
;#####################################################################
BRIGE0		EQU	$
		LDA	#06H
		BRA	BRIGE2X
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRIGE1    [ Bridge set No.1 ]			     #
;#####################################################################
BRIGE1		EQU	$
		LDA	#07H
		BRA	BRIGE2X
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BRIGE2    [ Bridge set No.2 ]			     #
;#####################################################################
BRIGE2		EQU	$
		LDA	#09H
BRIGE2X		EQU	$
		PHA
;
		JSR	S1OBPC
		JSL	>S1OBWK
;
		LDA	#HNDR0
		PLX
		STA	NWFRLD,X
;
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LONGBK    [ Bridge set No.2 ]			     #
;#####################################################################
;
LONGBK		EQU	$
		JSR	S1OBPC
		JSL	>S1OBWK
		LDA	NWFRLD
		STA	<KWORK0
		CMP	#CSWL0
		BEQ	LONG10
		DEC	A
		BRA	LONG20
LONG10		EQU	$
		INC	A
LONG20		EQU	$
		STA	<KWORK1
		LDA	<WORK7
		TAY
		AND	#01H
		BEQ	LONG30
;
LONGLP		EQU	$
		LDA	<KWORK1
		STA	NWFRLD,Y
		DEC	OBWORK,X
		BMI	LONGEND
		INY
;
LONG30		EQU	$
		LDA	<KWORK0
		STA	NWFRLD,Y
		DEC	OBWORK,X
		BMI	LONGEND
		INY
		BRA	LONGLP
;
LONGEND		EQU	$
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  BSTEP0    [ Block step set No.0 ]		     #
;#####################################################################
BSTPD0	 EQU	  $		  ; Block step value set data !
	 HEX	  07,07,06,05,04,03,02,01,00
;
BSTPD1	 EQU	  $		  ; Block step set (y)pos data !
	 HEX	  03,03,04,05,06,07,08,09,0A
;
BSTEP0	 EQU	  $
	JSR	S1OBPC
	JSL	>S1OBWK
;;;;;	      JSR      OBITSB
	 BCC	  BSTP30
;
	 LDA	  #9
	 STA	  OBSTCT
;
BSTP30	 EQU	  $
	 DEC	  OBSTCT
;
	 LDY	  OBSTCT
	 LDX	  BSTPD1,Y
	 LDA	  BSTPD0,Y
	 TAY
	 LDA	  #HDBK0
	JSL	>S1OBST
	PLB
	RTL
;;;;;	      JMP      OBSTST	       ; Step set
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  KIDNST    [ Castle BG set ]			     #
;#####################################################################
;
KIDNST	EQU	$
	JSR	S1OBPC
	JSL	>S1OBWK
	LDY	<WORK7
	LDA	OBWORK,X
	BNE	KDST10
	LDA	#KIDN
	STA	NWFRLD,Y
	INY
	LDA	NWFRLD,Y
	BNE	KDST15
	LDA	#KIDN+1
	STA	NWFRLD,Y
	INY
	BRA	KDST15
KDST10	EQU	$
	LDA	NWFRLD,Y
	BNE	KDST20
	LDA	#KIDN+2
	STA	NWFRLD,Y
KDST15	EQU	$
	LDA	NWFRLD,Y
	BNE	KDST20
	LDA	#KIDN+3
	STA	NWFRLD,Y
KDST20	EQU	$
	INY
	CPY	#0DH
	BNE	KDST15
;
	PLB
	RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  NBBLK	   [ Castle BG set ]			    #
;#####################################################################
;
NBBLK	EQU	$
	JSR	S1OBPC
	JSL	>S1OBWK
	LDY	<WORK7
	LDA	#CSWL0+2
	STA	NWFRLD,Y
	INY
	INY
NBBLK2	EQU	$
	LDA	NWFRLD,Y
	CMP	#CSWL0
	BEQ	NBBLK1
	CMP	#CSWL0+1
	BNE	NBBLKE
NBBLK1	EQU	$
	LDA	#CSWL0+2
	STA	NWFRLD,Y
	INY
	INY
	BRA	NBBLK2
NBBLKE	EQU	$
;
	PLB
	RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	CUTLS	     [ Castle BG set ]			     #
;#####################################################################
;
CUTLS	EQU	$
	JSR	S1OBPC
	JSL	>S1OBWK
	LDY	<WORK7
	LDA	#CUTLT
	STA	NWFRLD,Y
	INY
CTLSLP	EQU	$
	LDA	NWFRLD,Y
	CMP	#CTLTC
	BEQ	CTLSED
	LDA	#CUTLT+1
	STA	NWFRLD,Y
	INY
	CPY	#0DH
	BNE	CTLSLP
CTLSED	EQU	$
;
	PLB
	RTL
;
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	CUTRS	     [ Castle BG set ]			     #
;#####################################################################
;
CUTRS	EQU	$
	JSR	S1OBPC
	JSL	>S1OBWK
	LDY	<WORK7
	LDA	NWFRLD,Y
	CMP	#BRIK2
	BEQ	CTRS10
	LDA	#CUTRT
	STA	NWFRLD,Y
CTRS10	EQU	$
	INY
CTRSLP	EQU	$
	LDA	NWFRLD,Y
	CMP	#CTRTC+1
	BEQ	CTRSED
	LDA	#CUTRT+1
	STA	NWFRLD,Y
	INY
	CPY	#0DH
	BNE	CTRSLP
CTRSED	EQU	$
;
	PLB
	RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	CTLCS	     [ Castle BG set ]			     #
;#####################################################################
;
CTLCS		EQU	$
		JSR	S1OBPC
		JSL	>S1OBWK
		LDY	<WORK7
		LDA	OBWORK,X
		BNE	CTLCS1
		LDA	NWFRLD,Y
		CMP	#CSWL0+5
		BEQ	CTLCS05
		LDA	#HOLE1+1
		STA	NWFRLD,Y
CTLCS05		EQU	$
		LDA	#CTLTC+2
		STA	NWFRLD+1,Y
		BRA	CTLCSE
;
CTLCS1		EQU	$
		LDA	NWFRLD,Y
		CMP	#CSWL0+3
		BNE	CTLCS2
		LDA	#CTLTC+3
		BRA	CTLCS3
;
CTLCS2		EQU	$
		LDA	#CTLTC
CTLCS3		EQU	$
		STA	NWFRLD,Y
		LDA	#CTLTC+1
		STA	NWFRLD+1,Y
		LDA	#CSWL0+4
		STA	NWFRLD+12
;
CTLCSE		EQU	$
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	CTRCS	     [ Castle BG set ]			     #
;#####################################################################
;
CTRCS		EQU	$
		JSR	S1OBPC
		JSL	>S1OBWK
		LDY	<WORK7
		LDA	OBWORK,X
		BNE	CTRCS1
		LDA	NWFRLD,Y
		CMP	#CSWL0+3
		BNE	CTRCS2
		LDA	#CTRTC+3
		BRA	CTRCS3
;
CTRCS2		EQU	$
		LDA	#CSWL0+4
		INY
		INY
CTRCSLP		EQU	$
		STA	NWFRLD,Y
		INY
		CPY	#0DH
		BNE	CTRCSLP
		LDY	<WORK7
		LDA	#CTRTC+1
CTRCS3		EQU	$
		STA	NWFRLD,Y
		LDA	#CTRTC+2
		STA	NWFRLD+1,Y
		BRA	CTRCSE
;
CTRCS1		EQU	$
		LDA	NWFRLD,Y
		CMP	#CSWL0+5
		BEQ	CTRCS15
		LDA	#HOLE1+2
		STA	NWFRLD,Y
CTRCS15		EQU	$
		LDA	#CTRTC
		STA	NWFRLD+1,Y
;
CTRCSE		EQU	$
		PLB
		RTL
;
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	RCKST	     [ Under water BG set ]		     #
;#####################################################################
;
RCKST		EQU	$
		JSR	S1OBPC
		JSL	>S1OBWK
		LDY	<WORK7
RCKST1		EQU	$
		LDA	#ROCK0
		STA	NWFRLD,Y
		INY
		DEC	OBWORK,X
		BPL	RCKST1
;
		PLB
		RTL
;
;#####################################################################
;#		     (X) -- Set obst. index			     #
;#	 JSR	  LCH0ST    [ L-chimney set No.0 ]		     #
;#		     <C> -- 0 : V chimney set			     #
;#			    1 : H				     #
;#####################################################################
CMBND0	 EQU	  $		  ; L-chimney block No. data !
	 BYTE	  CHM0+5,CHM0+4,HOLE0,HOLE0
	 BYTE	  CHM0+5,CHM1+2,CHM1+1,CHM1	 ; right <--! left
	 BYTE	  CHM0+5,CHM1+5,CHM1+4,CHM1+3
CDEND	 EQU	  $
;
LCH0ST	 EQU	  $
	 LDY	  #3
	JSL	>S1OBWK
;;;;;	      JSR      OBWKIT	       ; Initial set OBWORK
	JSR	S1OBPC
;;;;;	      JSR      OBSTPC	       ; Calc set count
;
LCMS30	 EQU	  $
	 DEY
	 DEY
	 STY	  <WORK+5
;
	 LDY	  OBWORK,X
	 STY	  <WORK+6
;
	 LDX	  <WORK+5
	 INX
;
	 LDA	  CMBND0,Y
	 CMP	  #HOLE0
	 BEQ	  LCMS60	  ;- IF	 set block hole ?     ( YES ; LCMS60 )
;
	 LDX	  #0
	 LDY	  <WORK+5
	JSL	>S1OBST
;;;;;	      JSR      OBSTST
;
	 CLC
;
LCMS60	 EQU	  $
	 LDY	  <WORK+6
	 LDA	  CMBND0+4,Y
	 STA	  NWFRLD,X
;
	 LDA	  CMBND0+8,Y
	 STA	  NWFRLD+1,X
;
	PLB
	RTL
;
;
;#####################################################################
;#	 JSR	  WOODST					     #
;#####################################################################
WOODST	 EQU	  $
	JSR	S1OBPC
;;;;;	      JSR      OBSTPC	       ; Clac  set count
;
	 LDX	  #2
	 LDA	  #WOOD3
	JSL	>S1OBST
	PLB
	RTL
;;;;;	      JMP      OBSTST
;
;
;
;#####################################################################
;#	 JSR	  S1OBPC					     #
;#####################################################################
S1OBPC	EQU	$
	PHX
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	TXA
	ASL	A
	TAX
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
	LDY	OBSTPT,X
	INY
	LDA	[KWORK0],Y
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	STA	<WORK+7
;
	LDA	[KWORK0],Y
	AND	#0FH
;
	IDX8
	SEP	#00010000B		; index 8bit mode
;
	TAY
	PLX
	RTS
;
; ------------------------------------------------------------------------
;#####################################################################
;#	 JSL   GMOVR	    [ Next BG Window ]			     #
;#####################################################################
;
GMOVR		EQU	$
		PHB
		PHK
		PLB
		PHX
;
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDX	#0000H
		LDY	BGDBPT
;
		LDA	MRLGFG
		AND	#00FFH
		BEQ	GMOVR1
GMOVRA		EQU	$
		LDA	GOVLIG,X
		STA	BGDSBF,Y
		INC	A
		BEQ	GMOVR15
		INX
		INX
		INY
		INY
		BRA	GMOVRA
;
GMOVR1		EQU	$
		LDA	GOVRBG,X
		STA	BGDSBF,Y
		INC	A
		BEQ	GMOVR15
		INX
		INX
		INY
		INY
		BRA	GMOVR1
;
GMOVR15		EQU	$
		LDX	#0
GMOVR18		EQU	$
		LDA	GOVSMB,X
		STA	BGDSBF,Y
		INC	A
		BEQ	GMOVR2
		INX
		INX
		INY
		INY
		BRA	GMOVR18
;
GMOVR2		EQU	$
		STY	BGDBPT
;
		LDA	#CGG0
		STA	<WORK2
		LDX	#00A0H
		LDY	#0000H
		JSR	CGLOP
		JSR	CGLOP
		JSR	CGLOP
;
		STZ	SCCH21
		STZ	SCCH31
;
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
;
		LDA	#06H
		STA	VRFLG
;
		STZ	!BBSCHL
		STZ	210FH
		STZ	210FH
		STZ	2111H
		STZ	2111H
		LDA	#17H
		STA	!WD212C
;;;;;;;;		STA	212CH
		LDA	#0AH
		STA	BGWFLG
		LDA	#01H
		STA	!CGVMAF
		JSL	>MARIOW
;
		LDA	#0FFH
		STA	PLNOST		; mario cls
		STZ	FLSHFG
		STZ	SCCV21
		STZ	SCCV22
		STZ	2110H
		STZ	2110H
;
		PLX
		PLB
		RTL
;
;
;#####################################################################
;#	 JSL   NXTBG	    [ Next BG Window ]			     #
;#####################################################################
;
NXTWD	EQU	$
; W1
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTUG-NXTWT		; 2 under ground
	WORD	NXTGA-NXTWT		; 6 ku-sa asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; W2
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTGD-NXTWT		; 0 water
	WORD	NXTG3-NXTWT		; 5 ha-si
	WORD	NXTCT-NXTWT		; 3 casle
; W3
	WORD	NXTT2-NXTWT		; 8 wood & sa-ku snow ground
	WORD	NXTWT-NXTWT		; 8 wood & sa-ku snow ground
	WORD	NXTGA-NXTWT		; 9 yoru ku-sa asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; W4
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTGD-NXTWT		; 2 under ground
	WORD	NXTGA-NXTWT		; 4 asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; W5
	WORD	NXTT2-NXTWT		; 8 wood & sa-ku snow ground
	WORD	NXTUG-NXTWT		; 8 wood & sa-ku snow ground
	WORD	NXTGA-NXTWT		; 6 ku-sa asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; W6
	WORD	NXTT1-NXTWT		; 1 ground
	WORD	NXTWT-NXTWT		; 1 ground
	WORD	NXTBR-NXTWT		; 9 yoru ku-sa asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; W7
	WORD	NXTGD-NXTWT		; 8 wood & sa-ku snow ground
	WORD	NXTGD-NXTWT		; 0 water
	WORD	NXTG3-NXTWT		; 5 ha-si
	WORD	NXTCT-NXTWT		; 3 casle
; W8
	WORD	NXTT1-NXTWT		; 1 ground
	WORD	NXTT2-NXTWT		; 1 ground
	WORD	NXTA2-NXTWT		; 1 ground
	WORD	NXTC2-NXTWT		; 3 casle
; W9
	WORD	NXTWT-NXTWT		; 1 ground
	WORD	NXTWT-NXTWT		; 1 ground
	WORD	NXTGS-NXTWT		; 1 ground
	WORD	NXTWT-NXTWT		; 3 casle
; WA
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTUG-NXTWT		; 2 under ground
	WORD	NXTBR-NXTWT		; 4 asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; WB
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTWT-NXTWT		; 2 under ground
	WORD	NXTGA-NXTWT		; 4 asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; WC
	WORD	NXTGD-NXTWT		; 1 ground
	WORD	NXTGD-NXTWT		; 2 under ground
	WORD	NXTG3-NXTWT		; 4 asrechick
	WORD	NXTCT-NXTWT		; 3 casle
; WD
	WORD	NXTT1-NXTWT		; 1 ground
	WORD	NXTT1-NXTWT		; 2 under ground
	WORD	NXTSK-NXTWT		; 4 asrechick
	WORD	NXTC2-NXTWT		; 3 casle
;
FLADAT	EQU	$
	HEX	00,00,00,00,00,00,00,04 ;00-	;1-taki
	HEX	00,00,00,00,00,04,00,01 ;08-	;2-yoru
	HEX	02,02,02,00,01,00,00,00 ;10-	;3-tijyo
	HEX	01,00,01,00,00,02,02,02 ;18-	;4-shiro
	HEX	00,00,01,00,00,00,00,00 ;20-
	HEX	00,00,00,00,00,00,01,02 ;28-
	HEX	02,02,00,00,00,00,00,03 ;30-
	HEX	03,00,03,00,03,00,00,00 ;38-
	HEX	00,00,00,00,00,00,00,00 ;40-
;
NEXTDT	EQU	$
	HEX	02,03,0E,06	;01
	HEX	2B,2B,2B,06	;02
	HEX	05,08,0E,06	;03
	HEX	02,02,0E,06	;04
	HEX	05,03,0E,06	;05
	HEX	05,08,10,06	;06
	HEX	2B,2B,2B,06	;07
	HEX	05,05,0D,04	;08
	HEX	08,08,06,08	;09
	HEX	02,03,10,06	;0A
	HEX	02,08,0E,06	;0B
	HEX	2B,2B,2B,06	;0C
	HEX	05,05,0C,04	;0D
;
NXBGDT	EQU	$
	HEX	01,02,02,06,03	;World 1
	HEX	11,11,16,03,03	;World 2
	HEX	08,00,00,06,03	;World 3
	HEX	01,01,06,03,03	;World 4
	HEX	08,02,02,06,03	;World 5
	HEX	07,00,00,05,03	;World 6
	HEX	11,11,16,03,03	;World 7
	HEX	07,07,07,03,03	;World 8
	HEX	00,00,03,00,00	;World 9
	HEX	01,02,02,05,03	;World A
	HEX	08,00,00,06,03	;World B
	HEX	11,11,16,03,03	;World C
	HEX	07,07,07,03,03	;World D
;
;	HEX	01,02,02,06,03	;World 1
;	HEX	07,00,00,05,03	;World 2
;	HEX	18,18,16,03,03	;World 3
;	HEX	01,02,02,04,03	;World 4
;	HEX	08,08,06,03,03	;World 5
;	HEX	11,11,16,03,03	;World 6
;	HEX	08,00,00,05,03	;World 7
;	HEX	07,07,07,03,03	;World 8
NXCODT	EQU	$
	HEX	01,02,02,03,04	;W1
	HEX	05,06,07,08,08	;W2
	HEX	09,0A,0A,0B,0C	;W3
	HEX	0D,0E,0F,10,10	;W4
	HEX	11,12,12,13,14	;W5
	HEX	15,16,16,17,18	;W6
	HEX	19,1A,1B,1C,1C	;W7
	HEX	1D,1E,1F,20,20	;W8
	HEX	21,22,23,24,24	;W9
	HEX	25,26,26,27,28	;WA
	HEX	29,2A,2A,2B,2C	;WB
	HEX	2D,2E,2F,30,30	;WC
	HEX	31,32,33,34,34	;WD
;
FLSHST	EQU	$
	PHB
	PHK
	PLB
;
	LDY	BG2COS
	LDA	FLADAT,Y
	STA	FLSHFG
;
	PLB
	RTL
;
NXTBG	EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
;
	LDA	SVCKFG
	BEQ	SAVESKIP
;;;;;;	      JSL     >M2SAVE
	STZ	SVCKFG
;
SAVESKIP	EQU	$
	JSL	>FLSHST
	LDA	#80H
	STA	!SOUND2		;SOUND CLEAR
	LDY	NEXTNO
	DEY
	LDA	NEXTDT,Y
	AND	#1FH
	STA	<BGWFLG
	LDA	#001H
	STA	BGBKFG
	STA	!SKIPST
	JSL	>MARIOW
;
;;;;K;;;;	INC	!SKIPST
	STZ	WTRLFG
	STZ	LDPLFG
	STZ	LNDPOL
	STZ	SONDFG
	STZ	!BBSCHL
	STZ	!PHEDFG
	STZ	!LPSDFG
	STZ	!WNHNKI
	STZ	!WNDMSG
;
	STZ	WDWFLG
;
	JSL	>VRMCL3
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	STZ	LDPLFG+1
	STZ	LNDPOL+1
	STZ	LNDPOL+3
	LDY	BGDBPT
;
	LDA	#0C709H			; Wa-ku Line set
	STA	BGDSBF,Y		; ( ta-te line )
	LDA	#12C0H
	STA	BGDSBF+2,Y
	LDA	#30A2H
	STA	BGDSBF+4,Y
	LDA	#0D809H
	STA	BGDSBF+6,Y
	LDA	#12C0H
	STA	BGDSBF+8,Y
	LDA	#70A2H
	STA	BGDSBF+10,Y
;
	LDA	#0A809H			; Wa-ku Line set
	STA	BGDSBF+12,Y		; ( yo-ko line )
	LDA	#1E40H
	STA	BGDSBF+14,Y
	LDA	#3078H
	STA	BGDSBF+16,Y
	LDA	#080BH
	STA	BGDSBF+18,Y
	LDA	#1E40H
	STA	BGDSBF+20,Y
	LDA	#0B078H
	STA	BGDSBF+22,Y
;
	TYA
	CLC
	ADC	#0018H
	TAY
;
	LDX	#0000H
AOLOP	EQU	$
	LDA	AOSET,X			; Window nu-ki set
	STA	BGDSBF,Y		;
	INX				;
	INX				;
	INY				;
	INY				;
	INC	A			;
	BNE	AOLOP			;
;
	DEY
	DEY
BLUPS	EQU	$
	LDA	NEXTNO
	DEC	A
	AND	#00FFH
	ASL	A
	TAX
	LDA	NXTWD,X
	TAX
NXTLP	EQU	$
	LDA	NXTWT,X			; Window BG set
	STA	BGDSBF,Y		;
	INX				;
	INX				;
	INY				;
	INY				;
	INC	A			;
	BNE	NXTLP			;
;
	LDA	NEXTBG
	AND	#00FFH
	CMP	#0011H
	BNE	NXTPS
	DEY
	DEY
	LDX	#0000H
YMNKST	EQU	$			; Night ya-ma ke-su
	LDA	YAMNUK,X		;
	STA	BGDSBF,Y		;
	INX				;
	INX				;
	INY				;
	INY				;
	INC	A			;
	BNE	YMNKST			;
;
NXTPS	EQU	$
	LDA	NEXTBG
	AND	#00F0H
	BEQ	NXTPS2
	LDA	NEXTBG
	AND	#00FFH
	CMP	#0016H
	BEQ	NXTPS2
	DEY
	DEY
	LDX	#0000H
NGTSET	EQU	$
	LDA	NGTBCK,X
	STA	BGDSBF,Y
	INX
	INX
	INY
	INY
	INC	A
	BNE	NGTSET
NXTPS2	EQU	$
;
	STY	BGDBPT
;
	MEM8
	IDX8
	SEP	#00110000B		; memory , index 8bit mode
;
	JSR	WNDWCL		;
	DEC	BGOTMD		;
	LDA	#01H
	STA	!CGVMAF
	STZ	CGWORK
	STZ	CGWORK+1
;
	LDA	POWLEV		; player color set
	STA	<WORK8		;
	LDA	#01H		;
	STA	POWLEV		;
	LDA	NEXTBG
	AND	#0F0H
	BEQ	HIRU
	LDA	#04H
HIRU	EQU	$
	STA	NIGTFG
	LDA	NEXTBG
	CMP	#02H
	BNE	KURO
	LDA	#03H
	STA	NIGTFG
KURO	EQU	$
	LDA	<BG2COS
	CMP	#8
	BNE	KURO2
	LDA	#1
	STA	NIGTFG
KURO2	EQU	$
	JSL	>CLSET2
	DEC	!CGVMAF		;
	LDA	<WORK8		;
	STA	POWLEV		;
;;K;;	LDA	<KWORK0		;
;;K;;	STA	NIGTFG		;
	STZ	NEXTBG		;
;
	LDA	#17H
		STA	!WD212C
;;;;;;;;		STA	212CH
;
	LDA	#06H
	STA	VRFLG
	STZ	SCHFLG
	STZ	SCCV21
	STZ	SCCV22
	STZ	2110H
	STZ	2110H
;
		PLY
		PLX
		PLB
		RTL
;
;
;
;#####################################################################
;#	 JSR	BG2GRK	  [ BG2 set ]				     #
;#####################################################################
;
;
;
BG2GRK	EQU	$
;;T;;
	LDA	<SCCHFG
	BEQ	JJJ010
	STZ	<SCCHFG
	LDA	<SCCHWK
	STA	DSXP01
	STA	SCCH
	LDA	<SCCHWK+1
	STA	DSXP00
;
	MEM16
	REP	#00100000B		; memory 16bit mode
;
	LDA	<SCCHWK
	LSR	A
	STA	SCCH21
	LSR	A
	STA	SCCH31
	STA	BG3SCH
;
	MEM8
	SEP	#00100000B		; memory 8bit mode
;
;;T;;
JJJ010	EQU	$
	LDA	SCCH22
	AND	#01H
	STA	B2ADFG
	STZ	BG2WT
	STZ	BG2AD+1

;
		JSL	>BG2PTR
		JSR	RMVMD
;
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		LDA	<KDVRFG
		CMP	#03
		BEQ	JJJ020
		JSR	BG2SET
		JSR	BG2SET
;
		JSR	BG2SET
		JSR	BG2SET
		LDA	!BBSCHL
		BEQ	JJJ020
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
		JSR	BG2SET
;
JJJ020	EQU	$
	RTS
;
;
HDMADR		EQU	$
		BYTE	0F8H
		WORD	B3VRAM
		BYTE	0F8H
		WORD	B3VRAM+78H*2
		BYTE	00
;
;#####################################################################
;#	 JSR	  CRGNS1    [ Color generate set No.1 ]		     #
;#####################################################################
;
CRGNS1X		EQU	$
		PHB
		PHK
		PLB		; (DBR) set
;
		JSR	BG2GRK			; BG2 set
;
		STZ	SCCV21
		STZ	SCCV22
		LDA	<ENVRFG			; in water ?
		BEQ	BG2WRT			;  yes --> goto BG2WRT
;
		CMP	#001H
		BNE	B2SCCV
		LDA	#0F8H
		STA	SCCV21
B2SCCV		EQU	$
		LDA	#06H
		STA	!WD2130
		LDX	#11H
		BRA	BG2END
;
BG2WRT		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00F42H
		STA	4320H
		LDA	#HDMADR
		STA	4322H
		LDX	#BANK HDMADR
		STX	4324H
		LDY	#BANK B3VRAM
		STY	4327H
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	!YURCNT
		STZ	!YURFLG
		LDA	!WD420C
		ORA	#04H
		STA	!WD420C
		LDA	#00H
		LDX	#17H
;
BG2END		EQU	$
		STX	!WD212C		; display main
		STA	!WD212D		;	  sub
;;;;;;;;		STX	212CH
;;;;;;;;		STA	212DH
		STZ	!BG3IDX
;
		LDA	#01FH
		STA	!VSHCTR
		LDA	!BBSCHL
		BEQ	CRGNSED
		LDA	!SKYFLG
		BEQ	PPAASS
		STZ	!BBSCHL
		BRA	CRGNSED
PPAASS		EQU	$
		LDA	#0AFH
		STA	!VSHCTR
		LDA	#01H
		STA	!SCHFLG
;
CRGNSED		EQU	$
		JSR	WNDWCL
;
		PLB
		RTL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TT;;;;;;;;;
WNDWCL	EQU	$
;
	LDA	CGCFLG
	BEQ	CSKP10
	STA	<BG2COS
	STZ	CGCFLG
	BRA	CSKP20
CSKP10	EQU	$
	LDA	<BG2COS
	CMP	#17H
	BEQ	CSKP11
	CMP	#26H
	BEQ	CSKP11
	BRA	CSKP20
CSKP11	EQU	$
	STA	CGCFLG
	LDA	CORSNO
	BEQ	CSKP12
	CMP	#04H
	BEQ	CSKP12
	CMP	#09H
	BEQ	CSKP12
	LDA	#3EH
	STA	<BG2COS
	BRA	CSKP20
CSKP12	EQU	$
	LDA	#37H
	STA	<BG2COS
	LDA	#3
	STA	FLSHFG
CSKP20	EQU	$
;
	IDX16
	MEM16
	REP	#00110000B		; memory , index 16 bit mode
;
	LDA	<BG2COS
	AND	#00FFH
	ASL	A
	ASL	A
	ASL	A
	ASL	A
	TAY
	STY	<WORK6
	STZ	<WORK2
CGLP10	EQU	$
	LDY	<WORK6
	LDA	CGCSNO,Y
	AND	#00FFH
	INY
	STY	<WORK6
	ASL	A
	TAX
	LDA	CORSCG,X
	TAY
	LDX	<WORK2
	LDA	#07H
	STA	<WORK4
CGLP20	EQU	$
	LDA	CG1,Y
	STA	CGWORK,X
	LDA	CG1+10H,Y
	STA	CGWORK+10H,X
	INX
	INX
	INY
	INY
	DEC	<WORK4
	BPL	CGLP20
	TXA
	CLC
	ADC	#0010H
	STA	<WORK2
	CMP	#01E0H
	BNE	CGLP10
;
	LDA	BGWKSB
	BEQ	CLST40
	LDA	MRLGFG
	AND	#00FFH
	BEQ	CLST40
	LDY	#0
	LDX	#0E0H
CLST25	EQU	$
	LDA	LUCLDT,Y
	STA	CGWORK,X
	INX
	INX
	INY
	INY
	CPY	#20H
	BNE	CLST25
	BRA	CLST40
;
LUCLDT	EQU	$
	WORD	772FH,7FFFH,14A5H,57F0H,0340H,0200H,46BFH,365DH
	WORD	25BBH,04EFH,0D73H,4F7FH,7F0FH,4E06H,001EH,0012H
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CLST40		EQU	$
		LDA	<SCCH1
		LSR	A
		LSR	A
		STA	SCCH31
		AND	#0FF00H
		XBA
		STA	<KWORK0
		LDA	!CORSNO
		AND	#00FFH
		ASL	A
		CMP	#000CH
		BCC	CLST45
		LDA	#0000H
CLST45		EQU	$
		CLC
		ADC	<KWORK0
		STA	<KWORK0
		STZ	!BG3IDX
;
B3IDXST		EQU	$		; BG3 buffer read index initial set
		LDA	<KWORK0		;
		BEQ	B3IDXPS		;
		LDA	!BG3IDX		;
		CLC			;
		ADC	#00E0H		;
		STA	!BG3IDX		;
		DEC	<KWORK0		;
		BRA	B3IDXST		;
B3IDXPS		EQU	$		;
		LDA	!SCCH31		;
		AND	#00F0H		;
		LSR	A		;
		LSR	A		;
		LSR	A		;
		LSR	A		;
		CLC			;
		ADC	!BG3IDX		;
		STA	!BG3IDX		;
		CMP	#0A80H
		BCC	B3IXPS5
		STZ	!BG3IDX
;
B3IXPS5		EQU	$
		IDX8
		MEM8
		SEP	#00110000B	; memory , index 8 bit mode
;
		JSR	CDBFST
;
		LDA	WDWFLG
		BEQ	B3PASS
		LDA	!SCCH32
		STA	<KWORK0
		LDA	!SCCH31
		STA	<KWORK1
		JSR	B3AD00
		LDA	#13H
		STA	<KWORK2
B3WLOP		EQU	$
		JSL	>B3STIT		; BG3 initial set
		LDA	<KWORK1
		CMP	#0A0H
		BCC	B3JJJ
		LDA	<KWORK0
		EOR	#04H
		STA	<KWORK0
		LDA	#80H
		STA	<KWORK1
B3JJJ		EQU	$
		DEC	<KWORK2
		BNE	B3WLOP
;
B3PASS		EQU	$
		LDA	#01H
		STA	!CGVMAF
		INC	BGOTMD
;
		RTS
;
	MEM16
	IDX16
;
CGLOP	EQU	$
	LDA	#BANK CG1
	STA	<WORK4
	LDA	#0010H
	STA	<WORK
LOP	EQU	$
	LDA	[<WORK2],Y
	STA	!CGWORK,X
	INY
	INY
	INX
	INX
	DEC	<WORK
	BNE	LOP
	RTS
;
	MEM8
	IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	BG3 Cloud set						     x
;x		(Buff set)					     x
;x					X --> data read index	     x
;x					Y --> buffer set index	     x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CDBFST		EQU	$
;
		PHB
		LDA	#BANK B3BUFF
		PHA
		PLB
;
		LDX	#00H
B3BFCL		EQU	$
		STZ	!B3BUFF+0000H,X
		STZ	!B3BUFF+0100H,X
		STZ	!B3BUFF+0200H,X
		STZ	!B3BUFF+0300H,X
		STZ	!B3BUFF+0400H,X
		STZ	!B3BUFF+0500H,X
		STZ	!B3BUFF+0600H,X
		STZ	!B3BUFF+0700H,X
		STZ	!B3BUFF+0800H,X
		STZ	!B3BUFF+0900H,X
		STZ	!B3BUFF+0A00H,X
		DEX
		BNE	B3BFCL
		PLB
;
		PHB
		PHK
		PLB
;
		LDA	#BANK B3BUFF
		STA	<KWORK2
		STZ	<KWORK3
;
		MEM16
		IDX16
		REP	#00110000B		; memory ,index 16bitmode
;
		LDA	#B3BUFF
		STA	<KWORK0
		LDY	#0000H
		STZ	<KWORK5
;
CLDDT00		EQU	$
;
		LDX	<KWORK5
		LDA	B3CLDDT,X
		CMP	#0FFFFH			; end ?
		BEQ	CLDDTED			; yes --> CLDDTED
		BPL	CLDDT10			; next page ? (no -> CLDDT10)
		PHA
		LDA	<KWORK0
		CLC
		ADC	#00E0H
		STA	<KWORK0
		PLA
;
CLDDT10		EQU	$
		PHA
		AND	#00FFH			; Y posint set
		TAY				;
;
		PLA
		ASL	A
		ASL	A
		LDA	#0000H			; re-n-zo-ku flag set
		ROL	A			;
		STA	<KWORK3			;
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		INX
		LDA	B3CLDDT,X		; unit NO. set
		AND	#3FH			;
		STA	<KWORK4			;
CLDDT20		EQU	$
		LDA	<KWORK4
		STA	[<KWORK0],Y		;
		LDA	<KWORK3			; re-n-zo-ku ?
		BEQ	CLDDT25			;  NO --> CLDDT25
		TYA
		AND	#0F0H
		CMP	#0D0H
		BEQ	CLDDT25
		TYA
		CLC
		ADC	#10H
		TAY
		BRA	CLDDT20
;
CLDDT25		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		INC	<KWORK5
		INC	<KWORK5
		BRA	CLDDT00			; goto CLDDT00
;
CLDDTED		EQU	$
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
;
		PLB
		RTS
;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CGCSNO	EQU	$
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;00
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;01
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;02
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;03
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;04
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;05
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;06
	HEX	00,01,1B,1C,04,2F,1E,30,08,20,0A,3F,0C,21,0E,0F ;07
	HEX	00,01,02,03,04,19,1E,1A,08,09,0A,0B,0C,0D,0E,0F ;08
	HEX	00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;09
	HEX	00,01,1B,3E,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;0A
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;0B
	HEX	00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;0C
	HEX	00,01,1B,1C,04,2F,1E,30,08,20,0A,3F,0C,21,0E,0F ;0D
;
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;0E
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;0F
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;10
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;11
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;12
	HEX	00,01,35,41,04,3D,06,2D,08,09,0A,0B,0C,0D,0E,0F ;13
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;14
	HEX	00,01,02,03,04,05,06,07,08,09,0A,0B,0C,0D,0E,0F ;15
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;16
	HEX	00,01,02,03,04,05,06,07,08,09,0A,0B,0C,0D,0E,0F ;17
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;18
	HEX	00,01,35,41,04,3D,06,2D,08,09,0A,0B,0C,0D,0E,0F ;19
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;1A
	HEX	00,01,02,03,04,05,06,2B,08,09,0A,0B,0C,0D,0E,0F ;1B
	HEX	00,01,02,03,04,3A,06,3B,08,09,0A,0B,0C,0D,0E,0F ;1C
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;1D
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;1E
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;1F
	HEX	00,01,02,03,04,05,06,2B,08,09,0A,0B,0C,0D,0E,0F ;20
	HEX	00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;21
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;22
	HEX	00,01,02,03,04,05,29,3C,08,09,0A,0B,0C,0D,0E,0F ;23
	HEX	00,01,26,03,28,05,29,2A,08,09,0A,0B,0C,0D,0E,0F
;;	HEX	00,01,02,03,04,05,06,2E,08,09,0A,0B,0C,0D,0E,0F ;24
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;25
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;26
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;27
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;28
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;29
	HEX	00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;2A
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;2B
	HEX	00,01,02,03,04,3A,29,3B,08,09,0A,0B,0C,0D,0E,0F ;2C
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;2D
	HEX	00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;2E
	HEX	00,01,35,41,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;2F
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;30
	HEX	00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;31
	HEX	00,01,02,03,04,05,06,2B,08,09,0A,0B,0C,0D,0E,0F ;32
	HEX	00,01,02,03,04,05,06,2B,08,09,0A,0B,0C,0D,0E,0F ;33
	HEX	00,01,02,03,04,05,06,2E,08,09,0A,0B,0C,0D,0E,0F ;34
	HEX	00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;35
	HEX	00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;36
;
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
	HEX	00,01,13,14,04,15,06,16,08,17,0A,0B,0C,18,0E,0F ;37
	HEX	00,01,13,14,04,15,1E,16,08,17,0A,0B,0C,18,0E,0F ;38
	HEX	00,01,13,14,04,19,06,1A,08,17,0A,0B,0C,18,0E,0F ;39
	HEX	00,01,13,14,04,15,06,16,08,17,0A,0B,0C,18,0E,0F ;3A
	HEX	00,01,13,14,04,19,06,1A,08,17,0A,0B,0C,18,0E,0F ;3B
	HEX	00,01,13,14,04,15,06,16,08,17,0A,0B,0C,18,0E,0F ;3C
	HEX	00,01,13,14,04,19,06,1A,08,17,0A,0B,0C,18,0E,0F ;3D
;
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;3E
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;3F
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;40
	HEX	00,01,1B,03,04,39,11,12,08,09,0A,0B,0C,0D,0E,0F ;41
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;42
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;43
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;44
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;45
	HEX	00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;46
;
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
;	 HEX	 00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;00
;	 HEX	 00,01,02,03,04,10,11,12,08,09,0A,0B,0C,0D,0E,0F ;01
;	 HEX	 00,01,1B,03,04,39,11,12,08,09,0A,0B,0C,0D,0E,0F ;02
;	 HEX	 00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;03
;	 HEX	 00,01,02,03,04,05,06,2E,08,09,0A,0B,0C,0D,0E,0F ;04
;	 HEX	 00,01,02,03,04,2C,06,07,08,09,0A,0B,0C,0D,0E,0F ;05
;	 HEX	 00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;06
;	 HEX	 00,01,35,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;07
;	 HEX	 00,01,02,03,04,05,31,07,08,09,0A,0B,0C,0D,0E,0F ;08
;	 HEX	 00,01,02,03,04,05,06,38,08,09,0A,0B,0C,0D,0E,0F ;09
;	 HEX	 00,01,02,03,04,3A,06,3B,08,09,0A,0B,0C,0D,0E,0F ;0A
;	 HEX	 00,01,02,03,04,05,06,2B,08,09,0A,0B,0C,0D,0E,0F ;0B
;	 HEX	 00,01,02,03,04,05,06,07,08,09,0A,0B,0C,0D,0E,0F ;0C
;	 HEX	 00,01,34,03,04,3D,06,2D,08,09,0A,0B,0C,0D,0E,0F ;0D
;	 HEX	 00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;0E
;	 HEX	 00,01,26,27,28,05,29,2A,08,09,0A,0B,0C,0D,0E,0F ;0F
;
;;;;;;;		C0 C1 C2 C3 C4 C5 C6 C7 O0 O1 O2 O3 O4 O5 O6 O7
;	 HEX	 00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;10
;	 HEX	 00,01,02,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;11
;	 HEX	 00,01,26,27,28,05,29,2A,08,09,0A,0B,0C,0D,0E,0F ;12
;	 HEX	 00,01,02,03,04,05,06,07,08,09,0A,0B,0C,0D,0E,0F ;13
;	 HEX	 00,01,34,03,04,3D,06,2D,08,09,0A,0B,0C,0D,0E,0F ;14
;	 HEX	 00,01,02,03,04,05,06,3C,08,09,0A,0B,0C,0D,0E,0F ;15
;	 HEX	 00,01,35,03,04,3D,06,2D,08,09,0A,0B,0C,0D,0E,0F ;16
;	 HEX	 00,01,02,03,04,19,06,1A,08,09,0A,0B,0C,0D,0E,0F ;17
;	 HEX	 00,01,35,03,04,36,06,37,08,09,0A,0B,0C,0D,0E,0F ;18
;	 HEX	 00,01,13,14,04,15,06,16,08,17,0A,0B,0C,18,0E,0F ;19
;	 HEX	 00,01,13,14,04,15,06,16,08,17,0A,0B,0C,18,0E,0F ;1A
;	 HEX	 00,01,13,14,04,19,06,1A,08,17,0A,0B,0C,18,0E,0F ;1B
;	 HEX	 00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;1C
;	 HEX	 00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;1D
;	 HEX	 00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;1E
;	 HEX	 00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;1F
;	 HEX	 00,01,1B,1C,04,1D,1E,1F,08,20,0A,0B,0C,21,0E,0F ;20
;	 HEX	 00,01,1B,1C,04,2F,1E,30,08,20,0A,0B,0C,21,0E,0F ;21

;#####################################################################
;#	 JSR	  CLSET1    [ Player color & BG. color set ]	     #
;#####################################################################
;
CLDT2	EQU	$
	WORD	7FF8H,7FF8H,0000H,0000H,3908H,7FF8H,3908H,3908H
;
MRCLDT	EQU	$
	WORD	0000H,7FFFH,0C63H,0155H,1A1CH,1B3EH,2D9CH,3ABFH ; Mario
	WORD	0000H,152FH,0014H,0C19H,1C9FH,762EH,5D68H,44E6H ;
;
LGCLDT	EQU	$
	WORD	0000H,7FFFH,0C63H,0155H,1A1CH,1B3EH,2D9CH,3ABFH ; Luigi
	WORD	0000H,152FH,1E60H,3304H,4388H,7655H,7190H,58CAH ;
;
MFCLDT	EQU	$
	WORD	0000H,7FFFH,0C63H,0155H,1A1CH,1B3EH,2D9CH,3ABFH ; Fire Mario
	WORD	0000H,152FH,3ED9H,4F5DH,639FH,0D9FH,001DH,0015H ;
;
LFCLDT	EQU	$
	WORD	0000H,7FFFH,0C63H,0155H,1A1CH,1B3EH,2D9CH,3ABFH ; Fire Luigi
	WORD	0000H,152FH,3ED9H,4F5DH,639FH,0352H,02ADH,0208H ;
;
CLSET1X	  EQU	   $
	LDA	NEXTBG
	BEQ	CLS115
	JMP	CLS225			; goto RTL
CLS115	EQU	$
	INC	BGOTMD
;#####################################################################
;#	 JSR	  CLSET2    [ Player color set ]		     #
;#####################################################################
CLSET2	EQU	$
		PHB
		PHK
		PLB		; (DBR) set
		PHX
;
	LDA	NIGTFG
	BNE	CLS240
;
	LDA	<KDVRFG
CLS240	EQU	$
;
	MEM16
	IDX16
	REP	#00110000B		; memory , index 16bit mode
;
	AND	#00FFH
	ASL	A
	TAY
	LDA	SKYFLG			; goto Sky ? (no -> goto CLS243)
	AND	#00FFH
	BEQ	CLS243
	LDA	NIGTFG			; Night ? (yes -> goto CLS243)
	AND	#0004H
	BNE	CLS243
	LDA	!PLCNT			; player end ?
	AND	#0080H			;    yes -> goto CLS243
	BNE	CLS243
	LDA	#522AH			; ko-yu-i a-o
	BRA	CLS244
CLS243	EQU	$
	LDA	CLDT2,Y
CLS244	EQU	$
	STA	!CGWORK			; Obj "00" color set
	AND	#001FH			; Red set
	CLC
	ADC	#0020H
	STA	CGRED
	LDA	!CGWORK			; Green set
	AND	#03E0H
	ASL	A
	ASL	A
	ASL	A
	XBA
	CLC
	ADC	#0040H
	STA	CGGRN
	LDA	!CGWORK			; Blue set
	AND	#7C00H
	LSR	A
	LSR	A
	XBA
	CLC
	ADC	#0080H
	STA	CGBLU
	STZ	!CGWORK
	BRA	CLS255
;
CLS250	EQU	$
	LDA	#00E0H
	STA	CGRED
	STA	CGGRN
	STA	CGBLU
;
CLS255	EQU	$
;
	IDX8
	MEM8
	SEP	#00110000B		; memory , index 8bit mode
	LDA	PLCLFD
	BNE	CLS223
;
	LDY	#0
	LDA	MRLGFG			; Mario;0  Luigi;1
	BEQ	CLS210
;
	LDY	#20H			; Luigi
CLS210	EQU	$
;
	LDA	POWLEV			; With fire ?
	CMP	#2
	BNE	CLS220
;
	TYA				; Yes !
	CLC
	ADC	#40H
	TAY
CLS220	EQU	$
;
	MEM16
	REP	#00100000B		; memory 16 bit mode
;
	LDX	#00H
CHLOP	EQU	$
	LDA	MRCLDT,Y
	STA	!CGWORK+1E0H,X
	LDA	MRCLDT+10H,Y
	STA	!CGWORK+1F0H,X
	INX
	INX
	INY
	INY
	CPX	#10H
	BNE	CHLOP
;
	MEM8
	SEP	#00100000B		; memory 8 bit mode
;
	INC	!CGVMAF
CLS223	EQU	$
		PLX
		PLB		; (DBR) reset
CLS225	EQU	$
	RTL
;
;**********************************************************
;*	under file coll					  *
;*							  *
;**********************************************************
LRMVD		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
		PHA
;
		LDA	SCCH22		;
		CMP	#07FH		;
		BNE	TAIHI10		; 0 > SCCH21 ?
		LDA	SCH2PH		;  yes --> LDA	SCH2PH
		BRA	TAIHI20		;  no  --> STA	SCH2PH
TAIHI10		EQU	$		;
		STA	SCH2PH		;
TAIHI20		EQU	$		;
		STA	<KWORK0		;
;
		LDA	#20H
		STA	<WORK0
		LDA	<KDVRFG
		CMP	#03H
		BNE	LRMVMD0
		ASL	<WORK0
LRMVMD0		EQU	$
;
		LDA	SCCH21		; ram
		CLC			;
		ADC	<WORK0		;
		AND	#0F0H		;  low
		LSR	A		;   address
		LSR	A		;     point
		STA	BG2AD		;
;
		LSR	A		; BG low
		STA	<WORK		;   address point
;
		LDA	<WORK		;
		BNE	SUNOPG		; next page ?
;					; yes
		LDA	B2ADFG		;
		BEQ	MAEPG		; BG
		STZ	B2ADFG		;  high
		LDA	#14H		;   address
		BRA	PGSET		;    point
MAEPG		EQU	$		;
		LDA	#10H		;
		STA	B2ADFG		;
		BRA	PGSET		;
;
SUNOPG		EQU	$
;;K;;		LDA	SCCH22		;
		LDA	<KWORK0		;
		AND	#01H		; BG
		BEQ	TUGPG		;  high
		LDA	#10H		;   address
		BRA	PGSET		;    point
TUGPG		EQU	$		;
		LDA	#14H		;
PGSET		EQU	$		;
		STA	<WORK1		;
;
;;K;;		LDA	SCCH22		;
		LDA	<KWORK0		;
		AND	#0FH		;
		LDX	<WORK		;
		BNE	RAMPG		;
		INC	A		;
RAMPG		EQU	$		;
		INC	A		; ram
		ASL	A		;  high
		ASL	A		;   address
		ASL	A		;    point
		STA	BG2AD+1		;
;
		JSR	BG2SET
;
B2UEND		EQU	$
;
		PLA
		PLY
		PLX
		PLB
;
		RTL
;
;**********************************************************
;*	RAM -> VRAMD					  *
;*	  address point					  *
;**********************************************************
;
RMVMD		EQU	$
		LDA	SCCH21		; ram
		AND	#0F0H		;  low
		LSR	A		;   address
		LSR	A		;     point
		STA	BG2AD		;
;
		LSR	A		; BG low
		STA	<WORK		;   address point
;
		LDA	SCCH22		;
		ASL	A		; ram
		ASL	A		;  high
		ASL	A		;   address
		STA	BG2AD+1		;    point
;
		LDA	SCCH22		;
		AND	#01H		; BG
		BEQ	RMVMD01		;  high
		LDA	#14H		;   address
		BRA	RMVMD02		;    point
RMVMD01		EQU	$		;
		LDA	#10H		;
RMVMD02		EQU	$		;
		STA	<WORK1		;
;
		RTS
;
;
;
;**********************************************************
;*	RAM -> VRAMD					  *
;*		data set				  *
;**********************************************************
;
BG2SET		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16 bit mode
;

		LDA	#0004H
		STA	BG2CNT
		LDA	<KDVRFG
		AND	#00FFH
		CMP	#0003H
		BNE	BG2ST0
		ASL	BG2CNT
;
BG2ST0		EQU	$
		LDA	>B2VRAM
		TAY
BG2ST		EQU	$
		LDA	<WORK			;
		AND	#0020H			; #1000H or #1400H
		BEQ	NOWPG			;   point
		LDA	<WORK			;
		CLC				;
		ADC	#0400H			;
		AND	#16C0H			;
		STA	<WORK			;
NOWPG		EQU	$
;
		TYX
		LDA	<WORK			; Aderss set
		SEC
		SBC	#0800H
		STA	>B2VRAM+2,X		;
		LDA	#0020H			; Loop count
		STA	<WORK2			;
;
BG2ST30		EQU	$
		TXY
		LDA	BG2AD			;
		AND	#0040H			; Next page ?
		BEQ	NORMIC			;  no -> goto NORMIC
		LDA	#0800H			;  yes
		CLC				;     ->
		ADC	BG2AD			;      BG2AD + 800h
		AND	#0FF00H			;		= BG2AD
		STA	BG2AD			;
NORMIC		EQU	$
		LDX	BG2AD
		STX	<WORK4
;
RMDTST		EQU	$
		LDA	>BG2DT,X		; RAM
		TYX				;   ->
		STA	>B2VRAM+4,X		;     VRAMD
		INY
		INY
		LDA	<WORK4
		CLC
		ADC	#0040H
		STA	<WORK4
		TAX
		DEC	<WORK2
		BPL	RMDTST
;
		TYX
		LDA	#0024H
		STA	>B2VRAM,X
;
		INC	BG2AD
		INC	BG2AD
		INC	<WORK
		DEC	BG2CNT
		BNE	BG2ST
;
		TYA				; ko-su-u
		STA	>B2VRAM			;  ->  B2VRAM
;
		TAX
		LDA	#0FFFFH			; end
		STA	>B2VRAM+2,X		;
;
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8 bit mode
;
		LDA	#01H
		STA	B2VFG
;
		RTS
;
;
;
;**********************************************************
;*	SELECT						  *
;*	  window data					  *
;**********************************************************
;
GOVRBG	EQU	$
	HEX	0A,8D,00,0B
	WORD		0024H,0024H,1E45H,1E46H,1E47H,0024H
	HEX	0A,AD,00,0B
	WORD		1E4AH,1E4BH,1E48H,1E49H,1E59H,0024H
	HEX	0A,CD,00,0B
	WORD		1E5AH,1E5BH,1E69H,1E6AH,1E6FH,0024H
	HEX	0A,ED,00,0B
	WORD		0024H,1E6BH,1E4CH,1E4DH,1E4EH,1E4FH
	HEX	0B,0D,00,0B
	WORD		0024H,0024H,1E5CH,1E5DH,1E5EH,1E5FH
	HEX	0B,2D,00,0B
	WORD		0024H,1E7AH,1E6CH,1E6DH,1E6EH,0024H
	HEX	0B,4D,00,0B
	WORD		0024H,1E7BH,1E7CH,1E7DH,1E7EH,0024H
	WORD	0FFFFH
;
GOVLIG	EQU	$
	HEX	0A,4D,00,0B
	WORD		0024H,1680H,1681H,1682H,0024H,0024H
	HEX	0A,6D,00,0B
	WORD		0024H,1683H,1684H,1685H,0024H,0024H
	HEX	0A,8D,00,0B
	WORD		0024H,1686H,1687H,1688H,0024H,0024H
	HEX	0A,AD,00,0B
	WORD		0024H,1689H,168AH,168BH,168CH,0024H
	HEX	0A,CD,00,0B
	WORD		0024H,168DH,168EH,168FH,1690H,0024H
	HEX	0A,ED,00,0B
	WORD		1691H,1692H,1693H,1694H,1695H,0024H
	HEX	0B,0D,00,0B
	WORD		1696H,1697H,1698H,1699H,0024H,0024H
	HEX	0B,2D,00,0B
	WORD		0024H,169AH,169BH,169CH,0024H,0024H
	HEX	0B,4D,00,0B
	WORD		0024H,169DH,169EH,169FH,16A0H,0024H
	WORD	0FFFFH
;
GOVSMB	EQU	$
	HEX	0A,D3,00,09
	WORD		1A40H,1A41H,1A42H,1A43H,1A44H
	HEX	0A,F3,00,11
	WORD		1A50H,1A51H,1A52H,1A53H,1A54H,1A55H,1A56H,1A57H,1A58H
	HEX	0B,13,00,13
	WORD		1A60H,1A61H,1A62H,1A63H,1A64H,1A65H,1A66H,1A67H,1A68H,19FDH
	HEX	0B,33,00,13
	WORD		1AB2H,1AB3H,1AB4H,1AB5H,1AB6H,1AB7H,1AB8H,1AB9H,1ABAH,1A79H
	HEX	0B,53,00,11
	WORD		19EAH,19EBH,19ECH,19EDH,19EEH,19EFH,19FAH,19FBH,19FCH
	WORD	0FFFFH
;
;**********************************************************
;*	SELECT						  *
;*	  window data					  *
;**********************************************************
;
;
AOSET	EQU	$
	HEX	01,C8,40,1E
	WORD		0024H
	HEX	01,E8,40,1E
	WORD		0024H
	HEX	02,08,40,1E
	WORD		0024H
	HEX	02,28,40,1E
	WORD		0024H
	HEX	02,48,40,1E
	WORD		0024H
	HEX	02,68,40,1E
	WORD		0024H
	HEX	02,88,40,1E
	WORD		0024H
	HEX	02,A8,40,1E
	WORD		0024H
	HEX	02,C8,40,1E
	WORD		0024H
	HEX	02,E8,40,1E
	WORD		0024H
	WORD	0FFFFH
;
NXTWT	EQU	$			; water
	HEX	01,E8,00,1F
	WORD		18ECH,18EDH,18EEH,18EFH,18ECH,18EDH,18EEH,18EFH
	WORD		18ECH,18EDH,18EEH,18EFH,18ECH,18EDH,18EEH,18EFH
	HEX	02,4C,80,0B
	WORD		1D4AH,1D5AH,1D4AH,1D5AH,1082H,1084H
	HEX	02,4D,80,0B
	WORD		1D4BH,1D5BH,1D4BH,1D5BH,1083H,1085H
	HEX	0A,08,40,1E
	WORD		1900H
	HEX	0A,28,40,1E
	WORD		1900H
	HEX	0A,48,40,1E
	WORD		1901H
	HEX	0A,68,40,1E
	WORD		1901H
	HEX	0A,88,40,1E
	WORD		1901H
	HEX	0A,A8,40,1E
	WORD		1901H
	HEX	0A,C8,40,1E
	WORD		1901H
	HEX	0A,E8,40,1E
	WORD		1901H
	WORD	0FFFFH
;
NXTT1	EQU	$			; 2-1 GRAND
	HEX	09,CA,00,09
	WORD	1DDFH,1DC3H,1DC0H,1DC1H,1DCAH
	HEX	09,EA,00,0B
	WORD	1DDCH,1DD3H,1DD0H,1DD1H,1DDAH,1DDBH
	HEX	0A,09,00,0D
	WORD	1DDDH,1DE2H,1DE3H,1DE0H,1DE1H,1DE2H,1DF8H
	HEX	0A,29,00,0D
	WORD	1DDEH,1DF2H,1DF3H,1DF0H,1DF1H,1DF2H,1DF3H
	HEX	0A,49,00,1B
	WORD	1DE9H,1DC6H,1DC7H,1DC4H,1DC5H,1DC6H,1DC7H
	WORD	1DE8H,0024H,0024H,1DE9H,1DEAH,1DEBH,1DE8H
	HEX	0A,69,00,1B
	WORD	1DF9H,1DD6H,1DD7H,1DD4H,1DD5H,1DD6H,1DD7H
	WORD	1DF8H,0024H,0024H,1DF9H,1DFAH,1DFBH,1DF8H
	HEX	0A,89,00,1B
	WORD	1DE5H,1DE6H,1DE7H,1DE4H,1DE5H,1DE6H,1DE7H
	WORD	1DE4H,0024H,0024H,1DE5H,1DE6H,1DE7H,1DE4H
	HEX	0A,A9,00,1B
	WORD	1DF5H,1DF6H,1DF7H,1DF4H,1DF5H,1DF6H,1DF7H
	WORD	1DF4H,0024H,0024H,1DF5H,1DF6H,1DF7H,1DF4H
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTT2	EQU	$			; 5-1 GRAND
	HEX	09,CA,00,09
	WORD	1DDFH,1DC3H,1DC0H,1DC1H,1DCAH
	HEX	09,EA,00,0B
	WORD	1DDCH,1DD3H,1DD0H,1DD1H,1DDAH,1DDBH
	HEX	0A,09,00,0D
	WORD	1DDDH,1DE2H,1DE3H,1DE0H,1DE1H,1DE2H,1DF8H
	HEX	0A,29,00,0D
	WORD	1DDEH,1DF2H,1DF3H,1DF0H,1DF1H,1DF2H,1DF3H
	HEX	0A,49,00,1B
	WORD	1DE9H,1DC6H,1DC7H,1DC4H,1DC5H,1DC6H,1DC7H
	WORD	1DE8H,0024H,0024H,1DE9H,1DEAH,1DEBH,1DE8H
	HEX	0A,69,00,1B
	WORD	1DF9H,1DD6H,1DD7H,1DD4H,1DD5H,1DD6H,1DD7H
	WORD	1DF8H,0024H,0024H,1DF9H,1DFAH,1DFBH,1DF8H
	HEX	0A,89,00,1B
	WORD	1DE5H,1DE6H,1DE7H,1DE4H,1DE5H,1DE6H,1DE7H
	WORD	1DE4H,0024H,0024H,1DE5H,1DE6H,1DE7H,1DE4H
	HEX	0A,A9,00,1B
	WORD	1DF5H,1DF6H,1DF7H,1DF4H,1DF5H,1DF6H,1DF7H
	WORD	1DF4H,0024H,0024H,1DF5H,1DF6H,1DF7H,1DF4H
	HEX	02,0A,80,0B
	WORD		08B8H,08BAH,08BAH,08BCH,0CBEH,0CBEH
	HEX	02,0B,80,0B
	WORD		08B9H,08BBH,08BBH,08BDH,0CBFH,0CBFH
	HEX	02,92,00,07
	WORD		1214H,1215H,1214H,1215H
	HEX	02,B2,00,07
	WORD		1216H,1217H,1216H,1217H
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTGS	EQU	$			; 9-3 GRAND
	HEX	02,0A,80,0B
	WORD		08B8H,08BAH,08BAH,08BCH,0CBEH,0CBEH
	HEX	02,0B,80,0B
	WORD		08B9H,08BBH,08BBH,08BDH,0CBFH,0CBFH
	HEX	02,92,00,07
	WORD		1214H,1215H,1214H,1215H
	HEX	02,B2,00,07
	WORD		1216H,1217H,1216H,1217H
	HEX	02,C8,00,1F
	WORD		09CAH,09CBH,09CAH,09CBH,09CAH,09CBH,09CAH,09CBH
	WORD		09CAH,09CBH,09CAH,09CBH,09CAH,09CBH,09CAH,09CBH
	HEX	02,E8,00,1F
	WORD		09DAH,09DBH,09DAH,09DBH,09DAH,09DBH,09DAH,09DBH
	WORD		09DAH,09DBH,09DAH,09DBH,09DAH,09DBH,09DAH,09DBH
	WORD	0FFFFH
;
NXTSK	EQU	$		;8-3 BG
	HEX	09,C8,00,1F
	WORD	1DC2H,1DC3H,1DC0H,1DC1H,1DC2H,1DC3H,1DC0H,1DC1H
	WORD	1DC2H,1DC3H,1DC0H,1DC1H,1DC2H,1DC3H,1DC0H,1DC1H
	HEX	09,E8,00,1F
	WORD	1DD2H,1DD3H,1DD0H,1DD1H,1DD2H,1DD3H,1DD0H,1DD1H
	WORD	1DD2H,1DD3H,1DD0H,1DD1H,1DD2H,1DD3H,1DD0H,1DD1H
	HEX	0A,08,00,1F
	WORD	1DE2H,1DE1H,1DE2H,1DE1H,1DE2H,1DE1H,1DE2H,1DE1H
	WORD	1DE2H,1DE1H,1DE2H,1DE1H,1DE2H,1DE1H,1DE2H,1DE1H
	HEX	0A,28,00,1F
	WORD	1DD2H,1DD1H,1DE4H,1DE5H,1DD2H,1D82H,1D83H,1D84H
	WORD	1D85H,1D80H,1D81H,1DD1H,1DE4H,1DE5H,1DD2H,1DD1H
	HEX	0A,48,00,1F
	WORD	1DE2H,1DE1H,1DF4H,1DF5H,1DE2H,1DDCH,1DDDH,1DDEH
	WORD	1DDFH,1D90H,1D91H,1DE1H,1DF4H,1DF5H,1DE2H,1DE1H
	HEX	0A,68,00,1F
	WORD	1DD2H,1DD1H,1DD8H,1DE8H,1DD2H,1DECH,1DEDH,1DEEH
	WORD	1DEFH,1DA0H,1DA1H,1DD1H,1DD8H,1DE8H,1DD2H,1DD1H
	HEX	0A,88,00,1F
	WORD	1DE2H,1DE1H,1DE2H,1DE1H,1DE2H,1DFCH,1DFDH,1DFEH
	WORD	1DFFH,1DB0H,1DB1H,1DE1H,1DE2H,1DE1H,1DE2H,1DE1H
	HEX	0A,A8,00,1F
	WORD	1DF0H,1DF1H,1DF2H,1DF3H,1DF0H,1DF1H,1DF2H,1DF3H
	WORD	1DF0H,1DF1H,1DF2H,1DF3H,1DF0H,1DF1H,1DF2H,1DF3H
;;;
	HEX	02,0A,80,0B
	WORD		08B8H,08BAH,08BAH,08BCH,0CBEH,0CBEH
	HEX	02,0B,80,0B
	WORD		08B9H,08BBH,08BBH,08BDH,0CBFH,0CBFH
	HEX	02,92,00,07
	WORD		1214H,1215H,1214H,1215H
	HEX	02,B2,00,07
	WORD		1216H,1217H,1216H,1217H
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTGD	EQU	$			; ground
	HEX	01,EB,00,03
	WORD		10D6H,10D7H
	HEX	02,0A,00,07
	WORD		10D8H,10D9H,10DAH,10DBH
	HEX	02,2A,00,07
	WORD		10DCH,10DDH,10DEH,10DFH
	HEX	02,53,00,07
	WORD		1501H,1502H,1503H,1504H
	HEX	02,72,00,0B
	WORD		1510H,1511H,150AH,1505H,1514H,1515H
	HEX	02,91,00,0D
	WORD		1506H,1516H,150AH,1512H,150AH,150AH,150DH
	HEX	02,B0,00,0F
	WORD		1506H,1516H,150AH,150AH,9512H,1519H,150AH,151DH
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTUG	EQU	$			; under ground
	HEX	01,C8,40,1E
	WORD		0C47H
	HEX	01,CD,00,07
	WORD		0868H,0869H,0897H,086AH
	HEX	01,E8,80,0D
	WORD		0C45H,0C47H,0C45H,0C47H,0C45H,0C47H,0C45H
	HEX	01,E9,00,1D
	WORD		1D32H,1D33H,1D30H,1D31H,8864H,8865H,8866H,8867H
	WORD		1D32H,1D33H,1D30H,1D31H,1D32H,1D33H,1D30H
	HEX	02,09,00,1D
	WORD		1D02H,1D03H,1D00H,1D01H,8860H,8861H,8862H,8863H
	WORD		1D02H,1D03H,1D48H,1D49H,1D4AH,1D4BH,1D00H
	HEX	02,29,00,1D
	WORD		153AH,1D13H,1D10H,1D11H,1D12H,1D13H,1D10H,1D11H
	WORD		1D12H,1D13H,1D58H,1D59H,1D5AH,1D5BH,1D10H
	HEX	02,49,00,1D
	WORD		1D22H,1D23H,1D20H,1D21H,1D22H,1D23H,1D20H,1D21H
	WORD		1D22H,1D23H,1D68H,1D69H,1D6AH,1D6BH,1D20H
	HEX	02,69,00,1D
	WORD		1D32H,1D33H,151DH,151DH,1D32H,1D33H,1D30H,1D31H
	WORD		1D32H,1D33H,1D78H,1D79H,1D7AH,1D7BH,1D30H
	HEX	02,89,00,1D
	WORD		1D02H,1D03H,1528H,1529H,1D02H,1D03H,1D00H,1D01H
	WORD		1D02H,1D03H,1D00H,1D01H,1D02H,1D03H,1D00H
	HEX	02,A9,00,1D
	WORD		1D12H,1D13H,1D10H,1D11H,1D12H,1D13H,1D10H,1D11H
	WORD		1D12H,1D13H,1D10H,1D11H,1D12H,1D13H,1D10H
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTCT	EQU	$			; casle
	HEX	01,C8,00,1F
	WORD		09E6H,09E7H,09E8H,09E9H,09E6H,09E7H,09E8H,09E9H
	WORD		09E6H,09E7H,09E8H,09E9H,09E6H,09E7H,09E8H,09E9H
	HEX	01,E8,00,1F
	WORD		09F6H,09F7H,09F8H,09F9H,09F6H,09F7H,09F8H,09F9H
	WORD		09F6H,09F7H,09F8H,09F9H,09F6H,09F7H,09F8H,09F9H
	HEX	0A,08,40,1E
	WORD		1534H
	HEX	0A,28,40,1E
	WORD		1534H
	HEX	0A,48,40,1E
	WORD		1534H
	HEX	0A,68,40,1E
	WORD		1534H
	HEX	0A,88,40,1E
	WORD		1534H
	HEX	0A,A8,40,1E
	WORD		1534H
	HEX	0A,CB,40,18
	WORD		1534H
	HEX	0A,EB,40,0E
	WORD		1534H
	HEX	0A,0B,C0,0E
	WORD		1536H
	HEX	0A,0C,C0,0E
	WORD		1537H
	HEX	0A,0D,C0,0E
	WORD		1528H
	HEX	0A,13,C0,0C
	WORD		1536H
	HEX	0A,14,C0,0C
	WORD		1537H
	HEX	0A,15,C0,0C
	WORD		1528H
	HEX	02,C8,00,1F
	WORD		09CAH,09CBH,09CAH,09C3H,0024H,0024H,0024H,0024H
	WORD		09C0H,09CBH,09CAH,09C3H,189BH,189CH,189BH,189CH
	HEX	02,E8,00,1F
	WORD		09DAH,09DBH,09DAH,09D3H,18E0H,18E1H,18E0H,18E1H
	WORD		09D0H,09DBH,09DAH,09D3H,189DH,189EH,189DH,189EH
	WORD	0FFFFH
;
NXTC2	EQU	$			; 8-4
	HEX	09,C8,40,1E
	WORD		1534H
	HEX	09,E8,40,1E
	WORD		1534H
	HEX	0A,08,40,1E
	WORD		1534H
	HEX	0A,28,40,1E
	WORD		1534H
	HEX	0A,48,40,1E
	WORD		1534H
	HEX	0A,68,40,1E
	WORD		1534H
	HEX	0A,88,40,1E
	WORD		1534H
	HEX	0A,A8,40,1E
	WORD		1534H
	HEX	0A,CB,40,18
	WORD		1534H
	HEX	0A,EB,40,0E
	WORD		1534H
	HEX	09,CE,C0,09
	WORD		1536H
	HEX	09,CF,C0,09
	WORD		1537H
;					; POLE
	HEX	0A,6E,00,03
	WORD	9526H,9527H
	HEX	0A,8D,00,07
	WORD	9524H,9516H,9517H,9518H
	HEX	0A,AD,00,07
	WORD	1532H,1522H,1522H,1523H
;
	HEX	09,D2,00,0B
	WORD	1DA8H,1DA9H,1D8AH,1D8BH,5DA9H,1DACH
	HEX	09,F2,00,0B
	WORD	1DA8H,1DB9H,1DB9H,1DB9H,1DBAH,1DACH
	HEX	0A,12,00,0B
	WORD	1DA8H,1D89H,1D8AH,1D8BH,5D89H,1D9CH
	HEX	0A,32,00,0B
	WORD	1DA8H,1D99H,1D9AH,1D9BH,5D99H,1DACH
	HEX	0A,52,00,0B
	WORD	1DA8H,1DA9H,1D8AH,1D8BH,5DA9H,1DACH
	HEX	0A,72,00,0B
	WORD	1DB8H,1DB9H,1DB9H,1DB9H,1DB9H,1DBAH
;					; FIRE
	HEX	09,E9,00,07
	WORD	1DB0H,1DB1H,5DB1H,5DB0H
	HEX	0A,09,00,07
	WORD	1DB2H,1CE8H,1CE9H,5DB2H
	HEX	0A,29,00,07
	WORD	1DB3H,1CEAH,1CEBH,5DB3H
	HEX	0A,49,00,07
	WORD	1D34H,1D8EH,1D8FH,1D34H
;					;
	HEX	0A,C8,00,1F
	WORD	1510H,1511H,1510H,1511H,1510H,1511H,1510H,1511H
	WORD	1510H,1511H,1510H,1511H,1510H,1511H,1510H,1511H
	HEX	0A,E8,00,1F
	WORD	1520H,1521H,1520H,1521H,1520H,1521H,1520H,1521H
	WORD	1520H,1521H,1520H,1521H,1520H,1521H,1520H,1521H
;
	HEX	02,C8,00,1F
	WORD		09CAH,09CBH,09CAH,09C3H,0024H,0024H,0024H,0024H
	WORD		09C0H,09CBH,09CAH,09C3H,189BH,189CH,189BH,189CH
	HEX	02,E8,00,1F
	WORD		09DAH,09DBH,09DAH,09D3H,18E0H,18E1H,18E0H,18E1H
	WORD		09D0H,09DBH,09DAH,09D3H,189DH,189EH,189DH,189EH
	WORD	0FFFFH
;
NXTAC	EQU	$			; asrechick
	HEX	02,08,00,0B
	WORD		186BH,182CH,186CH,186DH,186EH,186FH
	HEX	02,28,00,0B
	WORD		1870H,182DH,1871H,1872H,1873H,1874H
	HEX	02,4A,00,03
	WORD		1875H,1876H
	HEX	02,6A,C0,09
	WORD		189FH
	HEX	02,6B,C0,09
	WORD		589FH
	HEX	02,50,00,0B
	WORD		186BH,182CH,186CH,186DH,186EH,186FH
	HEX	02,70,00,0B
	WORD		1870H,182DH,1871H,1872H,1873H,1874H
	HEX	02,92,00,03
	WORD		1875H,1876H
	HEX	02,B2,00,03
	WORD		189FH,589FH
	HEX	02,C8,00,1F
	WORD		186BH,182CH,186CH,186DH,186EH,182CH,186CH,186DH
	WORD		186EH,182CH,186CH,186DH,186EH,182CH,186CH,186FH
	HEX	02,E8,00,1F
	WORD		1870H,182DH,1871H,1872H,1873H,182DH,1871H,1872H
	WORD		1873H,182DH,1871H,1872H,1873H,182DH,1873H,1874H
;;;		bg2
	HEX	09,CA,00,0B
	WORD	1DCAH,1DCBH,1DCCH,1DCDH,1DCEH,1DCFH
	HEX	09,EA,00,0B
	WORD	1DDAH,1DDBH,1DDCH,1DDDH,1DDEH,1DDFH
	HEX	0A,0C,80,0B
	WORD	1DF2H,1DE2H,1DE2H,1DE2H,1DE2H,1DE2H
	HEX	0A,0D,80,0B
	WORD	1DF3H,1DE3H,1DE3H,1DE3H,1DE3H,1DE3H
	HEX	09,F1,00,0B
	WORD	1DCAH,1DCBH,1DCCH,1DCDH,1DCEH,1DCFH
	HEX	0A,11,00,0B
	WORD	1DDAH,1DDBH,1DDCH,1DDDH,1DDEH,1DDFH
	HEX	0A,33,80,0B
	WORD	1DF2H,1DE2H,1DE2H,1DE2H,1DE2H,1DE2H
	HEX	0A,34,80,0B
	WORD	1DF3H,1DE3H,1DE3H,1DE3H,1DE3H,1DE3H
	WORD	0FFFFH
;
NXTA2	EQU	$			; asrechick
	HEX	02,08,00,0B
	WORD		186BH,182CH,186CH,186DH,186EH,186FH
	HEX	02,28,00,0B
	WORD		1870H,182DH,1871H,1872H,1873H,1874H
;;	HEX	02,4A,00,03
;;	WORD		1875H,1876H
;;	HEX	02,6A,C0,09
;;	WORD		189FH
;;	HEX	02,6B,C0,09
;;	WORD		589FH
	HEX	02,50,00,0B
	WORD		186BH,182CH,186CH,186DH,186EH,186FH
	HEX	02,70,00,0B
	WORD		1870H,182DH,1871H,1872H,1873H,1874H
;;	HEX	02,92,00,03
;;	WORD		1875H,1876H
;;	HEX	02,B2,00,03
;;	WORD		189FH,589FH
	HEX	02,C8,00,1F
	WORD		186BH,182CH,186CH,186DH,186EH,182CH,186CH,186DH
	WORD		186EH,182CH,186CH,186DH,186EH,182CH,186CH,186FH
	HEX	02,E8,00,1F
	WORD		1870H,182DH,1871H,1872H,1873H,182DH,1871H,1872H
	WORD		1873H,182DH,1871H,1872H,1873H,182DH,1873H,1874H
;;;		bg2
;;K;;	HEX	09,CA,00,0B
;;K;;	WORD	1DCAH,1DCBH,1DCCH,1DCDH,1DCEH,1DCFH
;;K;;	HEX	09,EA,00,0B
;;K;;	WORD	1DDAH,1DDBH,1DDCH,1DDDH,1DDEH,1DDFH
;;K;;	HEX	0A,0C,80,0B
;;K;;	WORD	1DF2H,1DE2H,1DE2H,1DE2H,1DE2H,1DE2H
;;K;;	HEX	0A,0D,80,0B
;;K;;	WORD	1DF3H,1DE3H,1DE3H,1DE3H,1DE3H,1DE3H
;;K;;	HEX	09,F1,00,0B
;;K;;	WORD	1DCAH,1DCBH,1DCCH,1DCDH,1DCEH,1DCFH
;;K;;	HEX	0A,11,00,0B
;;K;;	WORD	1DDAH,1DDBH,1DDCH,1DDDH,1DDEH,1DDFH
;;K;;	HEX	0A,33,80,0B
;;K;;	WORD	1DF2H,1DE2H,1DE2H,1DE2H,1DE2H,1DE2H
;;K;;	HEX	0A,34,80,0B
;;K;;	WORD	1DF3H,1DE3H,1DE3H,1DE3H,1DE3H,1DE3H
	WORD	0FFFFH
;
NXTBR	EQU	$			; ha-si
	HEX	02,C8,00,03
	WORD		0CABH,0CADH
	HEX	02,E8,00,03
	WORD		0CACH,0CAEH
	HEX	02,CA,40,1B
	WORD		3221H
	HEX	02,AA,00,01
	WORD		0881H
	HEX	02,AB,40,19
	WORD		2A20H
;		BG2
	HEX	0A,0E,80,0F
	WORD		1DE0H,1DF0H,1DC3H,1DD3H,1DE3H,1DF3H,1DC1H,1DE2H
	HEX	0A,0F,80,0F
	WORD		1DE1H,5DF0H,1DC4H,1DD4H,1DE4H,1DF4H,1DD0H,1DF2H
	HEX	0A,4D,00,01
	WORD		1DC2H
	HEX	0A,50,00,01
	WORD		1DC5H
	HEX	0A,CD,00,01
	WORD		1DC0H
	HEX	0A,D0,00,01
	WORD		1DD1H
	HEX	0A,54,80,0B
	WORD		15CAH,15F1H,15C6H,15D6H,15E6H,15F6H
	HEX	0A,55,80,0B
	WORD		15CBH,55F1H,15C7H,15D7H,15E7H,15F7H
	WORD	0FFFFH
;
NXTG3	EQU	$			; ku-sa asrechick
	HEX	02,09,00,13
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,1050H
	HEX	02,29,00,13
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104EH,1051H
	HEX	02,4D,80,07
	WORD		1204H,1210H,1200H,1210H
	HEX	02,4E,80,07
	WORD		1207H,1213H,1203H,1213H
	HEX	02,C8,00,1F
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,104DH,104DH,104DH,104DH,104DH,104DH,1050H
	HEX	02,E8,00,1F
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104FH,104AH,104FH,104AH,104FH,104AH,104EH,1051H
	HEX	09,EA,00,01
	WORD	01CC0H
	HEX	09,F6,00,01
	WORD	01CC4H
	HEX	09,D5,00,01
	WORD	01CC1H
	HEX	09,CF,00,01
	WORD	01CC6H
	HEX	0A,15,00,01
	WORD	01CC2H
	HEX	0A,71,00,01
	WORD	01CC5H
	HEX	0A,36,00,01
	WORD	01CC5H
	HEX	0A,50,00,01
	WORD	01CC4H
	HEX	0A,54,00,01
	WORD	01CC7H
	HEX	0A,77,00,01
	WORD	01CC3H
	HEX	0A,6F,00,01
	WORD	01CC4H
	HEX	0A,93,00,01
	WORD	01CC2H
	HEX	0A,89,00,01
	WORD	01CC5H
	HEX	0A,6B,00,01
	WORD	01CC1H
	HEX	0A,48,00,01
	WORD	01CC0H
;;
	WORD	0FFFFH
;;;
NXTG2	EQU	$			; ku-sa asrechick
	HEX	02,09,00,13
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,1050H
	HEX	02,29,00,13
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104EH,1051H
	HEX	02,4D,80,07
	WORD		1204H,1210H,1200H,1210H
	HEX	02,4E,80,07
	WORD		1207H,1213H,1203H,1213H
	HEX	02,C8,00,1F
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,104DH,104DH,104DH,104DH,104DH,104DH,1050H
	HEX	02,E8,00,1F
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104FH,104AH,104FH,104AH,104FH,104AH,104EH,1051H
	WORD	0FFFFH
;;;
NXTGA	EQU	$			; ku-sa asrechick
	HEX	02,09,00,13
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,1050H
	HEX	02,29,00,13
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104EH,1051H
	HEX	02,4D,80,07
	WORD		1204H,1210H,1200H,1210H
	HEX	02,4E,80,07
	WORD		1207H,1213H,1203H,1213H
	HEX	02,C8,00,1F
	WORD		104BH,104DH,104DH,104DH,104DH,104DH,104DH,104DH
	WORD		104DH,104DH,104DH,104DH,104DH,104DH,104DH,1050H
	HEX	02,E8,00,1F
	WORD		104CH,104EH,104FH,104AH,104FH,104AH,104FH,104AH
	WORD		104FH,104AH,104FH,104AH,104FH,104AH,104EH,1051H
;;;		bg2
	HEX	0A,68,00,1F
	WORD		1DD4H,1DD5H,1DC1H,1DC2H,1CCAH,1CCBH,1CCAH,1CCBH
	WORD		1CCAH,1CCBH,1CCAH,1CCBH,1DC0H,1DD1H,1DD2H,1DD3H
	HEX	0A,88,00,1F
	WORD		1DE8H,1DE9H,1DEAH,1DEBH,1DE0H,1DE1H,1DE4H,1DE5H
	WORD		1DE0H,1DE1H,1DE4H,1DE5H,1DE8H,1DE9H,1DEAH,1DEBH
	HEX	0A,A8,00,1F
	WORD		1DF8H,1DF9H,1DFAH,1DFBH,1DF0H,1DF1H,1DF4H,1DF5H
	WORD		1DF0H,1DF1H,1DF4H,1DF5H,1DF8H,1DF9H,1DFAH,1DFBH
	HEX	0A,C8,00,1F
	WORD		1DC8H,1DC9H,1DCAH,1DCBH,1DE2H,1DE3H,1DE6H,1DE7H
	WORD		1DE2H,1DE3H,1DE6H,1DE7H,1DC8H,1DC9H,1DCAH,1DCBH
	HEX	0A,E8,00,1F
	WORD		1DD8H,1DD9H,1DDAH,1DDBH,1DF2H,1DF3H,1DF6H,1DF7H
	WORD		1DF2H,1DF3H,1DF6H,1DF7H,1DD8H,1DD9H,1DDAH,1DDBH
	WORD	0FFFFH
;
NXTSG	EQU	$			; wood & sa-ku ground
	HEX	02,8A,00,0B
	WORD		1214H,1215H,1214H,1215H,1214H,1215H
	HEX	02,AA,00,0B
	WORD		1216H,1217H,1216H,1217H,1216H,1217H
	HEX	02,4C,80,07
	WORD		08B8H,08BCH,0CBEH,0CBEH
	HEX	02,4D,80,07
	WORD		08B9H,08BDH,0CBFH,0CBFH
	HEX	01,F3,00,03
	WORD		10D6H,10D7H
	HEX	02,12,00,07
	WORD		10D8H,10D9H,10DAH,10DBH
	HEX	02,32,00,07
	WORD		10DCH,10DDH,10DEH,10DFH
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
NXTSS	EQU	$			; wood & sa-ku snow ground
	HEX	02,0A,80,0B
	WORD		08B8H,08BAH,08BAH,08BCH,0CBEH,0CBEH
	HEX	02,0B,80,0B
	WORD		08B9H,08BBH,08BBH,08BDH,0CBFH,0CBFH
	HEX	02,92,00,07
	WORD		1214H,1215H,1214H,1215H
	HEX	02,B2,00,07
	WORD		1216H,1217H,1216H,1217H
	HEX	02,C8,00,1F
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	WORD		0A08H,0A09H,0A08H,0A09H,0A08H,0A09H,0A08H,0A09H
	HEX	02,E8,00,1F
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD		0A18H,0A19H,0A18H,0A19H,0A18H,0A19H,0A18H,0A19H
	WORD	0FFFFH
;
YAMNUK	EQU	$
	HEX	01,EB,40,02
	WORD		0024H
	HEX	02,0A,40,06
	WORD		0024H
	HEX	02,2A,40,06
	WORD		0024H
	HEX	02,53,40,06
	WORD		0024H
	HEX	02,72,40,0A
	WORD		0024H
	HEX	02,91,40,0C
	WORD		0024H
	HEX	02,B0,40,0E
	WORD		0024H
	WORD	0FFFFH
;
NGTBCK	EQU	$
	HEX	09,EB,00,09
	WORD		1CC0H,0024H,1CC5H,0024H,1CC3H
	HEX	0A,0C,00,05
	WORD		1CC2H,0024H,1CC1H
	HEX	0A,29,00,01
	WORD		1CC2H
	HEX	0A,4B,00,01
	WORD		1CC1H
	HEX	0A,14,00,01
	WORD		1CC5H
	HEX	0A,53,00,07
	WORD		1CC3H,0024H,1CC4H,0024H
	HEX	0A,68,00,1F
	WORD		15C6H,15C7H,15C8H,15C9H,15CAH,15CBH,1CC6H,15CDH
	WORD		15C6H,15C7H,15C8H,15C9H,15CAH,15CBH,15CCH,15CDH
	HEX	0A,88,00,1F
	WORD		15D6H,15D7H,15D8H,15D9H,15DAH,15DBH,15DCH,15DDH
	WORD		15D6H,15D7H,15D8H,15D9H,15DAH,15DBH,15DCH,15DDH
	HEX	0A,A8,00,1F
	WORD		15E6H,15E7H,15E8H,15E9H,15EAH,15EBH,15ECH,15EDH
	WORD		15E6H,15E7H,15E8H,15E9H,15EAH,15EBH,15ECH,15EDH
	WORD	0FFFFH
;
;******************************
;	CORS CGDATA
;******************************
;
CORSCG	EQU	$
	WORD	CGK0-CG1	;00
	WORD	CGK1-CG1	;01
	WORD	CGK2-CG1	;02
	WORD	CGK3-CG1	;03
	WORD	CGK4-CG1	;04
	WORD	CGK5-CG1	;05
	WORD	CGK6-CG1	;06
	WORD	CGK7-CG1	;07
	WORD	OJK0-CG1	;08
	WORD	OJK1-CG1	;09
	WORD	OJK2-CG1	;0A
	WORD	OJK3-CG1	;0B
	WORD	OJK4-CG1	;0C
	WORD	OJK5-CG1	;0D
	WORD	OJK6-CG1	;0E
	WORD	OJK7-CG1	;0F
;				;	;WATER CG
	WORD	CG05-CG1	;10
	WORD	CG06-CG1	;11
	WORD	CG07-CG1	;12
;				;	;CHIKA CG
	WORD	CG22-CG1	;13
	WORD	CG23-CG1	;14
	WORD	CG25-CG1	;15
	WORD	CG27-CG1	;16
;				;	;CHIKA OJ
	WORD	OJ21-CG1	;17
	WORD	OJ25-CG1	;18
;				;	;BONUS CG
	WORD	CGB5-CG1	;19
	WORD	CGB7-CG1	;1A
;				;	;SHIRO CG
	WORD	CG32-CG1	;1B
	WORD	CG33-CG1	;1C
	WORD	CG35-CG1	;1D
	WORD	CG36-CG1	;1E
	WORD	CG37-CG1	;1F
;				;	;SHIRO OJ
	WORD	OJ31-CG1	;20
	WORD	OJ35-CG1	;21
;				;	;DUMMY
	WORD	OJ21-CG1	;22
	WORD	OJ21-CG1	;23
	WORD	OJ21-CG1	;24
	WORD	OJ21-CG1	;25
;				;	;KINOKO BG
	WORD	CGM2-CG1	;26
	WORD	CGM3-CG1	;27
	WORD	CGM4-CG1	;28
	WORD	CGM6-CG1	;29
	WORD	CGM7-CG1	;2A
;				;	;CORS CG
	WORD	CG08-CG1	;2B	;2-1 C7
	WORD	CG09-CG1	;2C	;4-1 C5
	WORD	CG0A-CG1	;2D	;7-1 C7
	WORD	CG0B-CG1	;2E	;8-3 C7
	WORD	CG0C-CG1	;2F	;8-4 C5
	WORD	CG0D-CG1	;30	;8-4 C7
;				;	;TITL CG
	WORD	CGT6-CG1	;31
;				;	;GMOV CG
	WORD	CGG6-CG1	;32
	WORD	CGG7-CG1	;33
;				;	;HIRU SNOW
	WORD	CGH4-CG1	;34
;				;	;NIGHT SNOW
	WORD	CGN4-CG1	;35
	WORD	CGN5-CG1	;36
	WORD	CGN7-CG1	;37
;				;	;ASLETICK
	WORD	CGA7-CG1	;38
;				;	;8-4 WATER C5
	WORD	CG0E-CG1	;39
;				;	;2-3,7-3 (C5 C7)
	WORD	CGH5-CG1	;3A
	WORD	CGH7-CG1	;3B
;				;	;8-2 C7
	WORD	CGY7-CG1	;3C
;				;	;5-1 C5
	WORD	CGX5-CG1	;3D
;				;	;A-4 BG C3
	WORD	CG3A-CG1	;3E
;				;	;NISE KUPPA O_3
	WORD	OJBK-CG1	;3F
;				;	;HIRU SNOW
	WORD	CGH3-CG1	;40
;				;	;NIGHT SNOW
	WORD	CGN3-CG1	;41
;
;####################################################################
;#	 CG1	  Color generate data				     #
;#####################################################################
;
CG1	 EQU	  $	    ;-------------------------------------< Ground >
;				  < BG >
CGK0	EQU	$
	WORD	42DDH,7FFFH,1084H,3800H,7708H,035FH,0259H,3800H ; 0 Mountain,Chimney,Gras
	WORD	7708H,7FFFH,73B9H,6335H,7708H,7FFFH,722BH,65C8H ;
CGK1	EQU	$
	WORD	7708H,7FFFH,1084H,1BDFH,027FH,0139H,1ADAH,0DF3H ; 1 Block
	WORD	050DH,4F7FH,3298H,15B1H,3FFFH,45BFH,20D4H,2D3AH ;
CGK2	EQU	$
	WORD	7BAFH,7FFFH,1084H,57F3H,0340H,01A0H,0000H,0000H ; 2 Cloud,Word's
	WORD	0000H,04D0H,0554H,11D8H,125CH,2BAAH,3800H,0A62H ;
CGK3	EQU	$
	WORD	7BAFH,7FFFH,0842H,2B30H,14B8H,0D3FH,029FH,035FH ; 3 Block,Coin
	WORD	0008H,008EH,1575H,1A3AH,3F5FH,5AD6H,2529H,3DEFH ;
;;	WORD	3908H,7FFFH,0842H,5EF7H,2529H,3908H,3908H,3908H ; 3 Block,Coin
;;	WORD	0006H,008EH,1575H,1A3AH,3F5FH,5AD6H,2529H,3DEFH ;
CGK4	EQU	$
	WORD	7BAFH,7FFFH,1084H,7FB8H,72B0H,32FCH,2256H,11CFH ; 4 Mountain,Chimney,Gras
	WORD	054BH,09E6H,1AABH,2B30H,3BB4H,287FH,000EH,0015H ;
CGK5	EQU	$
	WORD	7BAFH,376DH,1084H,22A9H,219BH,1538H,04B4H,0470H ; 5
	WORD	040CH,21C2H,3246H,3EA9H,4B0CH,534EH,01C3H,1646H ;
;	WORD	778CH,26E9H,1084H,1225H,2975H,1D12H,0C8EH,7FFFH ; 5
;	WORD	73B9H,21C2H,3246H,42CAH,4F2DH,6372H,0180H,05C2H ;
CGK6	EQU	$
	WORD	772FH,7FFFH,1084H,729FH,51B8H,30B0H,7E97H,6DB0H ; 6 Cloud,word's
	WORD	54EAH,294AH,4210H,5EF7H,6F7BH,571FH,251CH,3E3FH ;
CGK7	EQU	$
	WORD	7BAFH,7FFFH,1084H,778CH,6F4AH,6708H,5EC6H,5684H ; 7 Block,Coin
	WORD	4E42H,21C2H,3246H,42CAH,4F2DH,6372H,1084H,1084H ;
;
;				  < OBJ >
OJK0	EQU	$
	WORD	45BCH,7FFFH,14A5H,01A5H,0249H,02CDH,4631H,5AD6H ;0
	WORD	0000H,0351H,0019H,011FH,061FH,129FH,017AH,0113H ;0
OJK1	EQU	$
	WORD	45BCH,7FFFH,14A5H,008DH,0112H,19D9H,2A9EH,36FFH ;1
	WORD	0000H,7FFFH,0813H,2D9BH,465FH,539FH,1B9FH,1A5FH ;1
OJK2	EQU	$
	WORD	45BCH,7FFFH,14A5H,013BH,027FH,179FH,0135H,265EH ;2
	WORD	0000H,0C9BH,0135H,261DH,42DFH,6ADFH,4A1DH,28FAH ;2
OJK3	EQU	$
	WORD	734EH,7FFFH,14A5H,3D84H,5229H,27BFH,31BBH,3ABFH ;7 Player
	WORD	0000H,152FH,355DH,525FH,169BH,1C9FH,0C19H,0C19H ;7
OJK4	EQU	$
	WORD	45BCH,7FFFH,14A5H,013BH,027FH,179FH,0135H,265EH ;4
	WORD	0000H,0C9BH,0220H,0EE0H,23A0H,6ADFH,4A1DH,28FAH ;4
OJK5	EQU	$
	WORD	45BCH,7FFFH,14A5H,0203H,0F0AH,2BF1H,0135H,265EH ;5
	WORD	0000H,3F5FH,294AH,4631H,6318H,1A3AH,1575H,008EH ;5
OJK6	EQU	$
	WORD	45BCH,7FFFH,14A5H,0055H,0C3EH,3D9FH,0135H,265EH ;6
	WORD	0000H,42DFH,4025H,74D2H,7EB2H,261DH,1557H,00AFH ;6
OJK7	EQU	$
	WORD	45BCH,7FFFH,14A5H,0111H,0DB9H,22DDH,2D9CH,3ABFH ;7 Player
	WORD	0000H,0000H,14ECH,1DD4H,369AH,20BCH,1096H,000FH ;7
;
;
;#####################################################################
;#	 WTER C.G. DATA						     #
;#								     #
;#     CG**							     #
;#	 ||							     #
;#	 |+- Color NO.?						     #
;#	 |							     #
;#	 +- 0: BG Color						     #
;#	    1: OBJ color					     #
;#####################################################################
;
CG05	EQU	$
	WORD	7F92H,7FFFH,1084H,5B0CH,568AH,5208H,4DA6H,4944H
	WORD	44E2H,0887H,14EAH,214DH,298FH,2936H,0831H,1CD3H
;
CG06	EQU	$
	WORD	7F92H,7FFFH,1084H,722BH,65C8H,5D86H,7F36H,6DB0H
	WORD	54EAH,294AH,4210H,5EF7H,6F7BH,52FFH,35BCH,469CH
;
CG07	EQU	$
	WORD	7F92H,7FFFH,0000H,0A1FH,011DH,0013H,0000H,0000H
	WORD	0000H,0887H,14EAH,214DH,298FH,4280H,2940H,35E0H
;
;#####################################################################
;#	 TIKA C.G. DATA						     #
;#								     #
;#     CG**							     #
;#	 ||							     #
;#	 |+- Color NO.?						     #
;#	 |							     #
;#	 +- 0: BG Color						     #
;#	    1: OBJ color					     #
;#####################################################################
;
CG22	EQU	$
	WORD	772FH,7FFFH,1084H,57F0H,0340H,01A0H,1BDFH,027FH
	WORD	0139H,3CE1H,5186H,662BH,7AD0H,2BAAH,3800H,0A62H
;
CG23	EQU	$
	WORD	772FH,7FFFH,1084H,0000H,0000H,0000H,1ADAH,0DF3H
	WORD	050DH,3961H,4E06H,62ABH,7750H,5AD6H,2529H,3DEFH
;
CG25	EQU	$
	WORD	772FH,7FFFH,0000H,264EH,49ECH,41AAH,3968H,3126H
	WORD	28E4H,1C41H,28A3H,3506H,3D48H,0525H,0D88H,19EBH
;
CG27	EQU	$
	WORD	772FH,6739H,0000H,2CC5H,3D89H,3DCDH,4E51H,2EF8H
	WORD	1E74H,1C41H,28A3H,3506H,3D48H,4210H,2108H,318CH
;
OJ21	EQU	$
	WORD	45BCH,7FFFH,14A5H,2CE0H,41A3H,5648H,6AEDH,7F71H ;Kuribou
	WORD	0000H,7FFFH,3013H,4D9BH,625FH,539FH,1B9FH,1A5FH
;
OJ25	EQU	$
	WORD	45BCH,7FFFH,14A5H,1E22H,2F01H,3FE0H,0135H,1A9FH ;5
	WORD	0000H,7750H,294AH,4631H,6318H,62ABH,4E06H,3961H ;5
;
CGB5	EQU	$
	WORD	772FH,7FFFH,1084H,3B1FH,035FH,029FH,11D7H,0153H ; BONUS color
	WORD	00CFH,0000H,0000H,0000H,0000H,0000H,0000H,0000H
;
CGB7	EQU	$
	WORD	772FH,7FFFH,14A5H,05BFH,001EH,0017H,46BFH,365DH
	WORD	25BBH,04EFH,0D73H,4F7FH,7F0FH,0000H,0000H,0000H
;
;#####################################################################
;#	Castle BLOCK C.G. DATA					     #
;#								     #
;#     CG**							     #
;#	 ||							     #
;#	 |+- Color NO.?						     #
;#	 |							     #
;#	 +- 0: BG Color						     #
;#	    1: OBJ color					     #
;#####################################################################
;
OJ31	EQU	$
	WORD	45BCH,7FFFH,14C5H,256DH,3A12H,4A96H,5B1AH,6B9EH ;Kuribou
	WORD	0000H,7FFFH,210EH,35B7H,4E79H,539FH,1B9FH,1A5FH
;
OJ35	EQU	$
	WORD	45BCH,7FFFH,14A5H,1E22H,2F01H,3FE0H,0135H,1A9FH ;5
	WORD	0000H,5B1AH,294AH,4631H,6318H,4A96H,3A12H,256DH ;5
;
CG32	EQU	$
	WORD	7708H,7FFFH,1084H,57F3H,0340H,01A0H,0000H,0000H
	WORD	0000H,1D28H,2DACH,3E30H,4EB4H,2BAAH,3800H,0A62H
;
CG35	EQU	$
	WORD	7708H,15EFH,114CH,012EH,00ECH,00AAH,090AH,1D63H
	WORD	1521H,0864H,10A6H,18E8H,212AH,296CH,31AEH,39F0H
;
CG33	EQU	$
CG36	EQU	$
	WORD	7708H,7FFFH,1084H,097FH,005AH,000FH,7E97H,6DB0H
	WORD	54EAH,256DH,3A12H,4A96H,5B1AH,571FH,251CH,3E3FH
;
CG3A	EQU	$
	WORD	7708H,7FFFH,1084H,097FH,005AH,000FH,7E97H,6DB0H ; 3 Block,Coin
	WORD	54EAH,256DH,3A12H,4A96H,5B1AH,5AD6H,2529H,3DEFH ;
;
CG37	EQU	$
	WORD	7708H,7FFFH,3DADH,314AH,24E7H,01F6H,0192H,012FH
	WORD	00ACH,0864H,10A6H,18E8H,212AH,296CH,0088H,00CAH
;
;#####################################################################
;#	 Back smow afternoon					     #
;#####################################################################
CGH3	EQU	$
	WORD	7BAFH,7FFFH,0842H,2B30H,14B8H,0D3FH,029FH,035FH ; 3
	WORD	0008H,008EH,1575H,1A3AH,3F5FH,6F7BH,5AD6H,3DEFH
;
CGH4	EQU	 $		;
	WORD	7708H,7FFFH,1084H,77BDH,5EF7H,3DEFH,1BDFH,027FH
;;;TTT	WORD	7E51H,7FFFH,4631H,5AD6H,5EF7H,3DEFH,1BDFH,027FH ; 4
	WORD	0139H,0492H,0D17H,25DDH,3A7FH,6F7BH,3800H,5294H ;
;
;#####################################################################
;#	 Back smow night					     #
;#####################################################################
CGN3	EQU	$
	WORD	3908H,7FFFH,0842H,2B30H,14B8H,0D3FH,029FH,035FH ; 3
	WORD	0008H,008EH,1575H,1A3AH,3F5FH,6F7BH,5AD6H,3DEFH
;
CGN4	EQU	$		;
	WORD	7708H,7FFFH,1084H,77BDH,5EF7H,3DEFH,1BDFH,027FH
	WORD	0139H,0492H,0D17H,25DDH,3A7FH,6F7BH,3800H,5294H
;
CGN5	EQU	$		;
	WORD	3908H,4D4BH,18C6H,4509H,4D2DH,44EBH,3CA9H,7FFFH
	WORD	73B9H,21C2H,3246H,42CAH,4F2DH,6372H,30C3H,3904H
;
CGN7	EQU	$		;
	WORD	3C63H,7F7BH,7E73H,5D6BH,6FFBH,4FF3H,2EEBH,0DE3H
	WORD	3FFFH,1EF7H,0A52H,01CEH,6F7FH,4E7FH,2D77H,0C75H
;
;#####################################################################
;#	 Mushroom BG. color					     #
;#####################################################################
CGM2	EQU	$
	WORD	7708H,7FFFH,1084H,57F3H,0340H,01A0H,1BDFH,027FH ; 2
	WORD	0139H,04D0H,0554H,11D8H,125CH,2BAAH,3800H,0A62H ;
CGM3	EQU	$
	WORD	7708H,7FFFH,1084H,0000H,0000H,0000H,1ADAH,0DF3H ; 3
	WORD	050DH,008EH,1575H,1A3AH,3F5FH,5AD6H,2529H,3DEFH ;
CGM4	EQU	$
	WORD	7708H,7FFFH,1084H,7FB8H,72B0H,32FCH,2256H,11CFH ; 4
	WORD	054BH,5AD6H,6739H,739CH,7FFFH,287FH,000EH,0015H ;
;
CGM6	EQU	$
	WORD	7BAFH,7FFFH,1CE7H,7FF9H,7F93H,770FH,32DFH,225BH ; 6
	WORD	11D7H,01B3H,0A37H,1ABBH,2F5FH,1D3CH,0034H,0CB8H ;
CGM7	EQU	$
	WORD	7BAFH,7FFFH,1CE7H,4EFFH,42BFH,53FFH,479DH,3B3AH ; 7
	WORD	2ED7H,2E7EH,3ADFH,473FH,4B9FH,0000H,0000H,0000H ;
CGA7	EQU	$
	WORD	7BAFH,7F38H,216DH,7FBFH,7F38H,5B3BH,4AB7H,3A33H ; 7
	WORD	29AFH,2A13H,3A97H,4B1BH,5B9EH,76B4H,69C9H,7230H ;
;
;#####################################################################
;#	 World Corse BG. color					     #
;#   W****							     #
;#    |||+-> Color NO.?						     #
;#    ||+--> 0: BG Color					     #
;#    ||     1: OBJ color					     #
;#    |+-> Corse NO.?						     #
;#    +--> World NO.?						     #
;#####################################################################
CG08	EQU	$		;2-1 C7
	WORD	7BAFH,7FFFH,1084H,2B96H,1713H,3B9DH,12F8H,0A74H
	WORD	01F0H,2A03H,3A87H,4B0BH,576EH,6BB3H,020BH,028FH
;
CG09	EQU	$		;4-1 C5
	WORD	7BAFH,130FH,05C5H,0A8BH,01F8H,0172H,010DH,7FFFH
	WORD	73B9H,21C2H,3246H,3EA9H,4B0CH,5FB1H,0589H,0A29H
;
CG0A	EQU	$		;7-1 C7
	WORD	7BAFH,7FFFH,1084H,7FFFH,6FD9H,7FFFH,777BH,66F7H
	WORD	5673H,4E7FH,5EFFH,6F7FH,7FFFH,6372H,4ED1H,5F55H
;
CG0B	EQU	$		;8-3 C7
	WORD	7BAFH,7FFFH,0883H,4EF4H,4B19H,3A95H,2A11H,198DH
	WORD	0909H,10A7H,212BH,31AFH,4233H,52B7H,2DECH,3E70H
;
CG0C	EQU	$		;8-4 C5
	WORD	7708H,15EFH,114CH,012EH,00ECH,00AAH,090AH,1D63H
	WORD	1521H,0C63H,14A3H,1CE5H,2527H,2D69H,35ABH,3DEDH
;
CG0D	EQU	$		;8-4 C7
	WORD	7708H,0C63H,1CE5H,2D69H,2527H,1D0BH,18EAH,10A8H
	WORD	0866H,0C63H,14A3H,1CE5H,2527H,2D69H,00D6H,015AH
;
CG0E	EQU	$		;8-4W C5
	WORD	7F92H,7FFFH,0842H,4631H,3DEFH,35ADH,2D6BH,2529H
	WORD	1CE7H,10EAH,1D4DH,29B0H,3613H,3208H,1942H,25A5H
;
CGH5	EQU	$		;2-3,7-3 C5
	WORD	7F92H,7FFFH,29F8H,67FFH,4BDFH,3B7EH,331BH,26B8H
	WORD	1A55H,2E79H,3ADCH,473FH,539FH,4F1FH,365BH,42BEH
;
CGH7	EQU	$
	WORD	7F92H,7FFFH,29F8H,6BFFH,5FFCH,53B9H,4756H,3AF3H
	WORD	2E90H,2E79H,3ADCH,473FH,539FH,4F1FH,365BH,42BEH
;
CGY7	EQU	$
	WORD	7BAFH,7FFFH,1084H,29F9H,1975H,1A98H,0E15H,0191H
	WORD	010DH,184DH,20D1H,2955H,31D9H,3A5DH,006EH,08F1H
;
CGX5	EQU	$		;7-1 C5
	WORD	7BAFH,02D4H,1084H,7FFFH,3E99H,2E15H,1D91H,092EH
	WORD	00AAH,21C2H,3246H,3EA9H,4B0CH,534EH,6739H,739CH
;
OJBK	EQU	$		;NISE KUPPA O3
	WORD	45BCH,7FFFH,0C63H,40C0H,5565H,65E9H,4631H,5AD6H
	WORD	0000H,766DH,0012H,101AH,311FH,367AH,21D5H,0D30H
;
;#####################################################################
;#	 titl color generate data				     #
;#####################################################################
;
CGT6	EQU	$		;TITL C6
	WORD	7708H,7FFFH,1084H,53BFH,033EH,025CH,4A5FH,315FH ;
	WORD	001DH,004AH,04B2H,0A1CH,133DH,677FH,017CH,0019H ;
;
;
;#####################################################################
;#	 Game over color generate data ( No.6,7 )		     #
;#####################################################################
;
CGG0	EQU	$		;GMOV C0 (Luiji)
;not;	WORD	1084H,7FFFH,04CAH,0155H,1A1CH,1B3EH,2DFFH,471FH
;not;	WORD	56B5H,1173H,5144H,79E6H,1C9FH,0C18H,2B30H,09E6H
	WORD	1084H,7FFFH,04CAH,0155H,1A1CH,1B3EH,2DFFH,471FH
	WORD	56B5H,1173H,1242H,3329H,1C9FH,0C18H,79E6H,5144H
CGG6	EQU	$		;GMOV C6
	WORD	7BAFH,7FFFH,1084H,53BFH,033EH,025CH,0000H,0000H
	WORD	0000H,1058H,015FH,0E1FH,140EH,02BFH,017CH,0019H
CGG7	EQU	$		;GMOV C7 (Mario)
;not;	WORD	1084H,7FFFH,0C63H,0113H,11DAH,1B3EH,2DFFH,471FH
;not;	WORD	5EF7H,152FH,3D84H,5229H,56ECH,1C9FH,0C19H,0012H
	WORD	1084H,7FFFH,0C63H,0113H,11DAH,1B3EH,2DFFH,471FH
	WORD	5EF7H,152FH,0012H,0C19H,1C9FH,762DH,7189H,5905H
;
;
;
B3CLDDT		EQU	$
;-------------------------------------------------------------------- Display 1
		BYTE	0D0H,00000000B+CDUT04,0B1H,00000000B+CDUT20
		BYTE	0C1H,00000000B+CDUT23,0D1H,00000000B+CDUT14
		BYTE	092H,00000000B+CDUT04,0A2H,00000000B+CDUT23
		BYTE	0B2H,00000000B+CDUT14,0C2H,01000000B+CDUT07
		BYTE	083H,00000000B+CDUT20,093H,00000000B+CDUT14
		BYTE	0A3H,01000000B+CDUT07,074H,00000000B+CDUT04
		BYTE	084H,00000000B+CDUT14,094H,01000000B+CDUT07
		BYTE	055H,00000000B+CDUT04,065H,00000000B+CDUT09
		BYTE	075H,00000000B+CDUT06,085H,01000000B+CDUT07
		BYTE	0D5H,00000000B+CDUT17,046H,00000000B+CDUT20
		BYTE	056H,00000000B+CDUT14,066H,00000000B+CDUT0C
		BYTE	076H,00000000B+CDUT14,086H,01000000B+CDUT07
		BYTE	0C6H,00000000B+CDUT17,0D6H,00000000B+CDUT14
		BYTE	047H,00000000B+CDUT21,057H,00000000B+CDUT01
		BYTE	067H,01000000B+CDUT07,0B7H,00000000B+CDUT10
		BYTE	0C7H,00000000B+CDUT14,048H,00000000B+CDUT22
		BYTE	058H,00000000B+CDUT08,068H,00000000B+CDUT1A
		BYTE	078H,01000000B+CDUT07,0B8H,00000000B+CDUT13
		BYTE	059H,00000000B+CDUT15,069H,00000000B+CDUT1B
		BYTE	079H,01000000B+CDUT07,0A9H,00000000B+CDUT10
		BYTE	0B9H,00000000B+CDUT14,04AH,00000000B+CDUT20
		BYTE	05AH,00000000B+CDUT14,06AH,01000000B+CDUT07
		BYTE	0AAH,00000000B+CDUT18,04BH,00000000B+CDUT22
		BYTE	05BH,00000000B+CDUT08,06BH,01000000B+CDUT07
		BYTE	09BH,00000000B+CDUT10,0ABH,00000000B+CDUT14
		BYTE	05CH,00000000B+CDUT06,06CH,01000000B+CDUT07
		BYTE	08CH,00000000B+CDUT17,09CH,00000000B+CDUT02
		BYTE	05DH,00000000B+CDUT05,06DH,00000000B+CDUT08
		BYTE	07DH,01000000B+CDUT07,08DH,00000000B+CDUT19
		BYTE	09DH,00000000B+CDUT03,0ADH,00000000B+CDUT1A
		BYTE	0BDH,00000000B+CDUT08,06EH,00000000B+CDUT22
		BYTE	07EH,00000000B+CDUT08,08EH,01000000B+CDUT07
		BYTE	09EH,00000000B+CDUT19,0AEH,00000000B+CDUT2F
		BYTE	0BEH,00000000B+CDUT11,0CEH,00000000B+CDUT08
		BYTE	07FH,00000000B+CDUT21,08FH,01000000B+CDUT07
		BYTE	0CFH,00000000B+CDUT19
;-------------------------------------------------------------------- Display 2
		BYTE	060H,10000000B+CDUT20,070H,00000000B+CDUT14
		BYTE	080H,01000000B+CDUT07,061H,00000000B+CDUT21
		BYTE	071H,00000000B+CDUT2C,081H,01000000B+CDUT07
		BYTE	062H,00000000B+CDUT21,072H,00000000B+CDUT2D
		BYTE	082H,01000000B+CDUT07,063H,00000000B+CDUT05
		BYTE	073H,00000000B+CDUT08,083H,00000000B+CDUT1A
		BYTE	093H,01000000B+CDUT07,074H,00000000B+CDUT22
		BYTE	084H,00000000B+CDUT0B,094H,00000000B+CDUT22
		BYTE	0A4H,00000000B+CDUT08,0B4H,01000000B+CDUT07
		BYTE	0A5H,00000000B+CDUT21,0B5H,01000000B+CDUT07
		BYTE	0A6H,00000000B+CDUT05,0B6H,00000000B+CDUT08
		BYTE	0C6H,01000000B+CDUT07,0B7H,00000000B+CDUT22
		BYTE	0C7H,00000000B+CDUT08,0D7H,00000000B+CDUT07
		BYTE	018H,00000000B+CDUT20,028H,00000000B+CDUT29
		BYTE	0C8H,00000000B+CDUT22,0D8H,00000000B+CDUT08
		BYTE	009H,00000000B+CDUT20,019H,00000000B+CDUT14
		BYTE	029H,00000000B+CDUT0C,039H,00000000B+CDUT09
		BYTE	0D9H,00000000B+CDUT05,00AH,00000000B+CDUT21
		BYTE	01AH,00000000B+CDUT2C,02AH,00000000B+CDUT07
		BYTE	03AH,00000000B+CDUT0A,00BH,00000000B+CDUT21
		BYTE	01BH,00000000B+CDUT2D,02BH,00000000B+CDUT07
		BYTE	03BH,00000000B+CDUT0A,00CH,00000000B+CDUT22
		BYTE	01CH,00000000B+CDUT08,02CH,00000000B+CDUT1A
		BYTE	03CH,00000000B+CDUT2B,01DH,00000000B+CDUT22
		BYTE	02DH,00000000B+CDUT0B
;-------------------------------------------------------------------- Display 3
		BYTE	0D0H,10000000B+CDUT20,0A1H,00000000B+CDUT20
		BYTE	0B1H,01000000B+CDUT23,0D1H,00000000B+CDUT14
		BYTE	082H,00000000B+CDUT04,092H,00000000B+CDUT23
		BYTE	0A2H,00000000B+CDUT14,0B2H,01000000B+CDUT07
		BYTE	033H,00000000B+CDUT04,043H,00000000B+CDUT23
		BYTE	053H,00000000B+CDUT09,063H,00000000B+CDUT20
		BYTE	073H,00000000B+CDUT23,083H,00000000B+CDUT14
		BYTE	093H,01000000B+CDUT07,024H,00000000B+CDUT20
		BYTE	034H,00000000B+CDUT02,044H,01000000B+CDUT07
		BYTE	054H,00000000B+CDUT0C,064H,00000000B+CDUT14
		BYTE	025H,00000000B+CDUT22,035H,00000000B+CDUT03
		BYTE	045H,01000000B+CDUT07,036H,00000000B+CDUT05
		BYTE	046H,00000000B+CDUT08,056H,01000000B+CDUT07
		BYTE	037H,00000000B+CDUT20,047H,00000000B+CDUT19
		BYTE	057H,00000000B+CDUT08,067H,01000000B+CDUT07
		BYTE	028H,00000000B+CDUT04,038H,00000000B+CDUT14
		BYTE	048H,01000000B+CDUT07,029H,00000000B+CDUT22
		BYTE	039H,00000000B+CDUT08,049H,01000000B+CDUT07
		BYTE	03AH,00000000B+CDUT05,04AH,00000000B+CDUT10
		BYTE	05AH,00000000B+CDUT14,06AH,01000000B+CDUT07
		BYTE	08AH,00000000B+CDUT1A,09AH,00000000B+CDUT10
		BYTE	0AAH,00000000B+CDUT14,03BH,00000000B+CDUT20
		BYTE	04BH,00000000B+CDUT14,05BH,01000000B+CDUT07
		BYTE	07BH,00000000B+CDUT1A,08BH,00000000B+CDUT0B
		BYTE	09BH,00000000B+CDUT21,09CH,00000000B+CDUT10
		BYTE	03CH,00000000B+CDUT21,04CH,00000000B+CDUT01
		BYTE	05CH,01000000B+CDUT07,07CH,00000000B+CDUT0A
		BYTE	08CH,00000000B+CDUT00,09CH,00000000B+CDUT05
		BYTE	0ACH,00000000B+CDUT08,0BCH,00000000B+CDUT1A
		BYTE	0CCH,00000000B+CDUT08,03DH,00000000B+CDUT05
		BYTE	04DH,00000000B+CDUT08,05DH,00000000B+CDUT07
		BYTE	06DH,00000000B+CDUT1A,07DH,00000000B+CDUT0B
		BYTE	0ADH,00000000B+CDUT22,0BDH,00000000B+CDUT0B
		BYTE	0CDH,00000000B+CDUT06,0DDH,00000000B+CDUT1A
		BYTE	04EH,00000000B+CDUT22,05EH,00000000B+CDUT24
		BYTE	06EH,00000000B+CDUT0B,0CEH,00000000B+CDUT05
		BYTE	0DEH,00000000B+CDUT0B
;-------------------------------------------------------------------- Display 4
		BYTE	0B0H,10000000B+CDUT04,0C0H,00000000B+CDUT23
		BYTE	0D0H,00000000B+CDUT29,0A1H,00000000B+CDUT20
		BYTE	0B1H,01000000B+CDUT07,082H,00000000B+CDUT20
		BYTE	092H,00000000B+CDUT0F,0A2H,00000000B+CDUT14
		BYTE	0B2H,01000000B+CDUT07,013H,00000000B+CDUT20
		BYTE	023H,00000000B+CDUT09,073H,00000000B+CDUT04
		BYTE	083H,00000000B+CDUT02,093H,01000000B+CDUT07
		BYTE	004H,00000000B+CDUT20,014H,00000000B+CDUT14
		BYTE	024H,00000000B+CDUT07,034H,00000000B+CDUT29
		BYTE	074H,00000000B+CDUT15,084H,00000000B+CDUT03
		BYTE	094H,01000000B+CDUT07,005H,00000000B+CDUT21
		BYTE	015H,00000000B+CDUT01,025H,00000000B+CDUT07
		BYTE	035H,00000000B+CDUT0A,065H,00000000B+CDUT04
		BYTE	075H,01000000B+CDUT07,085H,00000000B+CDUT18
		BYTE	006H,00000000B+CDUT05,016H,00000000B+CDUT08
		BYTE	026H,00000000B+CDUT1A,036H,00000000B+CDUT0B
		BYTE	066H,00000000B+CDUT06,076H,00000000B+CDUT10
		BYTE	086H,00000000B+CDUT11,096H,00000000B+CDUT08
		BYTE	0A6H,01000000B+CDUT07,017H,00000000B+CDUT22
		BYTE	027H,00000000B+CDUT0B,067H,00000000B+CDUT21
		BYTE	077H,00000000B+CDUT18,087H,01000000B+CDUT07
		BYTE	058H,00000000B+CDUT20,068H,00000000B+CDUT14
		BYTE	078H,00000000B+CDUT19,088H,00000000B+CDUT08
		BYTE	098H,01000000B+CDUT07,0A8H,00000000B+CDUT1A
		BYTE	0B8H,00000000B+CDUT08,039H,00000000B+CDUT04
		BYTE	049H,00000000B+CDUT0F,059H,00000000B+CDUT14
		BYTE	069H,01000000B+CDUT07,089H,00000000B+CDUT11
		BYTE	099H,00000000B+CDUT1F,0A9H,00000000B+CDUT1B
		BYTE	0B9H,00000000B+CDUT19,0C9H,00000000B+CDUT08
		BYTE	02AH,00000000B+CDUT27,03AH,00000000B+CDUT28
		BYTE	04AH,01000000B+CDUT07,0AAH,00000000B+CDUT08
		BYTE	0CAH,00000000B+CDUT13,03BH,00000000B+CDUT22
		BYTE	04BH,00000000B+CDUT08,05BH,01000000B+CDUT07
		BYTE	06BH,00000000B+CDUT1A,07BH,00000000B+CDUT08
		BYTE	0ABH,00000000B+CDUT11,0BBH,00000000B+CDUT1C
		BYTE	0CBH,00000000B+CDUT08,04CH,00000000B+CDUT05
		BYTE	05CH,00000000B+CDUT24,06CH,00000000B+CDUT0B
		BYTE	07CH,00000000B+CDUT05,08CH,00000000B+CDUT08
		BYTE	09CH,01000000B+CDUT07,0CCH,00000000B+CDUT19
		BYTE	08DH,00000000B+CDUT22,09DH,00000000B+CDUT08
		BYTE	0ADH,01000000B+CDUT07,09EH,00000000B+CDUT05
		BYTE	0AEH,00000000B+CDUT08,0BEH,00000000B+CDUT1A
		BYTE	0CEH,00000000B+CDUT08,0DEH,00000000B+CDUT07
		BYTE	0AFH,00000000B+CDUT22,0BFH,00000000B+CDUT0B
		BYTE	0CFH,00000000B+CDUT05,0DFH,00000000B+CDUT0B
;-------------------------------------------------------------------- Display 5
		BYTE	0D0H,10000000B+CDUT20,091H,00000000B+CDUT20
		BYTE	0A1H,00000000B+CDUT29,0C1H,00000000B+CDUT20
		BYTE	0D1H,00000000B+CDUT14,072H,00000000B+CDUT04
		BYTE	082H,00000000B+CDUT23,092H,00000000B+CDUT14
		BYTE	0A2H,00000000B+CDUT0C,0B2H,00000000B+CDUT0F
		BYTE	0C2H,00000000B+CDUT14,0D2H,00000000B+CDUT07
		BYTE	043H,00000000B+CDUT20,053H,00000000B+CDUT09
		BYTE	063H,00000000B+CDUT20,073H,00000000B+CDUT14
		BYTE	083H,01000000B+CDUT07,034H,00000000B+CDUT04
		BYTE	044H,00000000B+CDUT14,054H,00000000B+CDUT0C
		BYTE	064H,00000000B+CDUT1D,074H,00000000B+CDUT14
		BYTE	084H,01000000B+CDUT07,025H,00000000B+CDUT20
		BYTE	035H,00000000B+CDUT14,045H,00000000B+CDUT2C
		BYTE	055H,01000000B+CDUT07,026H,00000000B+CDUT22
		BYTE	036H,00000000B+CDUT08,046H,00000000B+CDUT2D
		BYTE	056H,01000000B+CDUT07,037H,00000000B+CDUT05
		BYTE	047H,00000000B+CDUT08,057H,01000000B+CDUT07
		BYTE	097H,00000000B+CDUT17,0A7H,00000000B+CDUT2E
		BYTE	048H,00000000B+CDUT22,058H,00000000B+CDUT08
		BYTE	068H,00000000B+CDUT1A,078H,01000000B+CDUT07
		BYTE	088H,00000000B+CDUT10,098H,00000000B+CDUT14
		BYTE	0A8H,00000000B+CDUT0C,059H,00000000B+CDUT15
		BYTE	069H,00000000B+CDUT1B,079H,01000000B+CDUT07
		BYTE	089H,00000000B+CDUT18,099H,00000000B+CDUT01
		BYTE	04AH,00000000B+CDUT20,05AH,00000000B+CDUT14
		BYTE	06AH,01000000B+CDUT07,08AH,00000000B+CDUT19
		BYTE	09AH,00000000B+CDUT08,0AAH,00000000B+CDUT1A
		BYTE	04BH,00000000B+CDUT21,05BH,00000000B+CDUT01
		BYTE	06BH,01000000B+CDUT07,09BH,00000000B+CDUT19
		BYTE	0ABH,00000000B+CDUT1B,04CH,00000000B+CDUT05
		BYTE	05CH,00000000B+CDUT08,06CH,01000000B+CDUT07
		BYTE	05DH,00000000B+CDUT22,06DH,00000000B+CDUT25
		BYTE	07DH,00000000B+CDUT28,08DH,01000000B+CDUT07
		BYTE	07EH,00000000B+CDUT22,08EH,00000000B+CDUT08
		BYTE	09EH,00000000B+CDUT1A,0AEH,00000000B+CDUT08
		BYTE	0BEH,00000000B+CDUT07,0CEH,00000000B+CDUT1A
		BYTE	0DEH,00000000B+CDUT08,08FH,00000000B+CDUT05
		BYTE	09FH,00000000B+CDUT0B,0AFH,00000000B+CDUT05
		BYTE	0BFH,00000000B+CDUT24,0CFH,00000000B+CDUT0B
		BYTE	0DFH,00000000B+CDUT05
;-------------------------------------------------------------------- Display 6
		BYTE	0A1H,10000000B+CDUT04,0B1H,00000000B+CDUT09
		BYTE	0D1H,00000000B+CDUT20,002H,00000000B+CDUT04
		BYTE	012H,00000000B+CDUT23,022H,00000000B+CDUT29
		BYTE	092H,00000000B+CDUT20,0A2H,00000000B+CDUT14
		BYTE	0B2H,00000000B+CDUT0C,0C2H,00000000B+CDUT0F
		BYTE	0D2H,00000000B+CDUT14,003H,00000000B+CDUT21
		BYTE	013H,00000000B+CDUT2C,023H,00000000B+CDUT0A
		BYTE	063H,00000000B+CDUT20,073H,00000000B+CDUT23
		BYTE	083H,00000000B+CDUT26,093H,00000000B+CDUT28
		BYTE	0A3H,00000000B+CDUT01,0B3H,01000000B+CDUT07
		BYTE	004H,00000000B+CDUT21,014H,00000000B+CDUT2D
		BYTE	024H,00000000B+CDUT0A,054H,00000000B+CDUT20
		BYTE	064H,00000000B+CDUT14,074H,01000000B+CDUT07
		BYTE	094H,00000000B+CDUT11,0A4H,00000000B+CDUT08
		BYTE	005H,00000000B+CDUT05,015H,00000000B+CDUT24
		BYTE	025H,00000000B+CDUT0B,055H,00000000B+CDUT21
		BYTE	065H,00000000B+CDUT01,075H,01000000B+CDUT07
		BYTE	056H,00000000B+CDUT22,066H,00000000B+CDUT08
		BYTE	076H,01000000B+CDUT07,086H,00000000B+CDUT17
		BYTE	096H,00000000B+CDUT14,067H,00000000B+CDUT05
		BYTE	077H,00000000B+CDUT08,087H,00000000B+CDUT19
		BYTE	097H,00000000B+CDUT08,0A7H,01000000B+CDUT07
		BYTE	068H,00000000B+CDUT20,078H,00000000B+CDUT14
		BYTE	088H,01000000B+CDUT07,098H,00000000B+CDUT11
		BYTE	0A8H,00000000B+CDUT08,059H,00000000B+CDUT04
		BYTE	069H,00000000B+CDUT14,079H,00000000B+CDUT2C
		BYTE	089H,01000000B+CDUT07,0A9H,00000000B+CDUT18
		BYTE	05AH,00000000B+CDUT22,06AH,00000000B+CDUT08
		BYTE	07AH,00000000B+CDUT2D,08AH,01000000B+CDUT07
		BYTE	0AAH,00000000B+CDUT19,0BAH,00000000B+CDUT08
		BYTE	06BH,00000000B+CDUT22,07BH,00000000B+CDUT08
		BYTE	08BH,01000000B+CDUT07,0BBH,00000000B+CDUT11
		BYTE	0CBH,00000000B+CDUT1B,0DBH,00000000B+CDUT08
		BYTE	07CH,00000000B+CDUT22,08CH,00000000B+CDUT08
		BYTE	09CH,01000000B+CDUT07,0ACH,00000000B+CDUT1A
		BYTE	0BCH,00000000B+CDUT08,0DCH,00000000B+CDUT19
		BYTE	08DH,00000000B+CDUT05,09DH,00000000B+CDUT24
		BYTE	0ADH,00000000B+CDUT0B,0BDH,00000000B+CDUT05
		BYTE	0CDH,00000000B+CDUT08,0DDH,00000000B+CDUT07
		BYTE	0CEH,00000000B+CDUT22,0DEH,00000000B+CDUT08
		BYTE	0DFH,00000000B+CDUT22
;-------------------------------------------------------------------- Display 7
		BYTE	0D0H,10000000B+CDUT20,0B1H,00000000B+CDUT04
		BYTE	0C1H,00000000B+CDUT0F,0D1H,00000000B+CDUT14
		BYTE	0A2H,00000000B+CDUT20,0B2H,00000000B+CDUT14
		BYTE	0C2H,01000000B+CDUT07,093H,00000000B+CDUT04
		BYTE	0A3H,01000000B+CDUT07,094H,00000000B+CDUT21
		BYTE	0A4H,00000000B+CDUT01,0B4H,01000000B+CDUT07
		BYTE	095H,00000000B+CDUT22,0A5H,00000000B+CDUT08
		BYTE	0B5H,01000000B+CDUT07,0A6H,00000000B+CDUT22
		BYTE	0B6H,00000000B+CDUT08,0C6H,01000000B+CDUT07
		BYTE	077H,00000000B+CDUT04,087H,00000000B+CDUT09
		BYTE	0B7H,00000000B+CDUT15,0C7H,00000000B+CDUT08
		BYTE	0D7H,00000000B+CDUT07,068H,00000000B+CDUT20
		BYTE	078H,00000000B+CDUT14,088H,00000000B+CDUT0C
		BYTE	098H,00000000B+CDUT09,0A8H,00000000B+CDUT20
		BYTE	0B8H,00000000B+CDUT14,0C8H,00000000B+CDUT19
		BYTE	0D8H,00000000B+CDUT08,049H,00000000B+CDUT20
		BYTE	059H,00000000B+CDUT0F,069H,00000000B+CDUT14
		BYTE	079H,01000000B+CDUT07,099H,00000000B+CDUT0C
		BYTE	0A9H,00000000B+CDUT14,03AH,00000000B+CDUT04
		BYTE	04AH,00000000B+CDUT14,05AH,01000000B+CDUT07
		BYTE	03BH,00000000B+CDUT06,04BH,01000000B+CDUT07
		BYTE	02CH,00000000B+CDUT20,03CH,00000000B+CDUT14
		BYTE	04CH,00000000B+CDUT2C,05CH,01000000B+CDUT07
		BYTE	02DH,00000000B+CDUT22,03DH,00000000B+CDUT08
		BYTE	04DH,00000000B+CDUT2D,05DH,01000000B+CDUT07
		BYTE	07DH,00000000B+CDUT1A,08DH,00000000B+CDUT08
		BYTE	03EH,00000000B+CDUT05,04EH,01000000B+CDUT07
		BYTE	06EH,00000000B+CDUT1A,07EH,00000000B+CDUT0B
		BYTE	08EH,00000000B+CDUT15,09EH,00000000B+CDUT08
		BYTE	04FH,00000000B+CDUT22,05FH,00000000B+CDUT08
		BYTE	06FH,00000000B+CDUT0C,07FH,00000000B+CDUT23
		BYTE	08FH,00000000B+CDUT14,09FH,00000000B+CDUT19
		BYTE	0AFH,00000000B+CDUT08,0BFH,01000000B+CDUT07
;-------------------------------------------------------------------- Display 8
		BYTE	040H,10000000B+CDUT20,050H,00000000B+CDUT14
		BYTE	060H,01000000B+CDUT07,0A0H,00000000B+CDUT19
		BYTE	0B0H,00000000B+CDUT1C,0C0H,00000000B+CDUT08
		BYTE	0D0H,00000000B+CDUT07,031H,00000000B+CDUT20
		BYTE	041H,00000000B+CDUT14,051H,01000000B+CDUT07
		BYTE	032H,00000000B+CDUT21,042H,01000000B+CDUT07
		BYTE	052H,00000000B+CDUT01,033H,00000000B+CDUT22
		BYTE	043H,00000000B+CDUT08,053H,01000000B+CDUT07
		BYTE	044H,00000000B+CDUT05,054H,00000000B+CDUT08
		BYTE	064H,01000000B+CDUT07,045H,00000000B+CDUT20
		BYTE	055H,00000000B+CDUT14,065H,01000000B+CDUT07
		BYTE	036H,00000000B+CDUT04,046H,00000000B+CDUT0E
		BYTE	056H,00000000B+CDUT14,066H,01000000B+CDUT07
		BYTE	076H,00000000B+CDUT17,086H,00000000B+CDUT14
		BYTE	027H,00000000B+CDUT20,037H,01000000B+CDUT07
		BYTE	067H,00000000B+CDUT10,077H,00000000B+CDUT14
		BYTE	028H,00000000B+CDUT05,038H,00000000B+CDUT24
		BYTE	048H,00000000B+CDUT08,058H,01000000B+CDUT07
		BYTE	068H,00000000B+CDUT18,049H,00000000B+CDUT05
		BYTE	059H,00000000B+CDUT10,069H,00000000B+CDUT14
		BYTE	079H,00000000B+CDUT2C,089H,01000000B+CDUT07
		BYTE	05AH,00000000B+CDUT22,06AH,00000000B+CDUT08
		BYTE	07AH,00000000B+CDUT2D,08AH,01000000B+CDUT07
		BYTE	06BH,00000000B+CDUT05,07BH,00000000B+CDUT08
		BYTE	08BH,01000000B+CDUT07,07CH,00000000B+CDUT22
		BYTE	08CH,00000000B+CDUT08,09CH,00000000B+CDUT1A
		BYTE	0ACH,00000000B+CDUT24,0BCH,00000000B+CDUT08
		BYTE	0CCH,01000000B+CDUT07,08DH,00000000B+CDUT05
		BYTE	09DH,00000000B+CDUT0B,0BDH,00000000B+CDUT22
		BYTE	0CDH,00000000B+CDUT08,0DDH,00000000B+CDUT07
		BYTE	0CEH,00000000B+CDUT05,0DEH,00000000B+CDUT08
		BYTE	0DFH,00000000B+CDUT22
;-------------------------------------------------------------------- Display 9
		BYTE	0D2H,10000000B+CDUT20,053H,00000000B+CDUT20
		BYTE	063H,00000000B+CDUT09,0C3H,00000000B+CDUT04
		BYTE	0D3H,00000000B+CDUT14,044H,00000000B+CDUT04
		BYTE	054H,00000000B+CDUT14,064H,00000000B+CDUT0C
		BYTE	074H,00000000B+CDUT23,084H,00000000B+CDUT09
		BYTE	094H,00000000B+CDUT04,0A4H,00000000B+CDUT09
		BYTE	0C4H,00000000B+CDUT05,0D4H,00000000B+CDUT08
		BYTE	035H,00000000B+CDUT20,045H,00000000B+CDUT14
		BYTE	055H,01000000B+CDUT07,075H,00000000B+CDUT10
		BYTE	085H,00000000B+CDUT0E,095H,00000000B+CDUT14
		BYTE	0A5H,00000000B+CDUT0C,0B5H,00000000B+CDUT29
		BYTE	0C5H,00000000B+CDUT20,0D5H,00000000B+CDUT14
		BYTE	036H,00000000B+CDUT21,046H,01000000B+CDUT07
		BYTE	076H,00000000B+CDUT14,0B6H,00000000B+CDUT0C
		BYTE	0C6H,00000000B+CDUT14,027H,00000000B+CDUT20
		BYTE	037H,01000000B+CDUT07,057H,00000000B+CDUT01
		BYTE	028H,00000000B+CDUT05,038H,00000000B+CDUT08
		BYTE	048H,01000000B+CDUT07,0A8H,00000000B+CDUT10
		BYTE	0B8H,00000000B+CDUT2E,039H,00000000B+CDUT22
		BYTE	049H,00000000B+CDUT08,059H,00000000B+CDUT1A
		BYTE	069H,00000000B+CDUT08,079H,01000000B+CDUT07
		BYTE	099H,00000000B+CDUT17,0A9H,00000000B+CDUT14
		BYTE	0B9H,00000000B+CDUT0C,04AH,00000000B+CDUT05
		BYTE	05AH,00000000B+CDUT0B,06AH,00000000B+CDUT22
		BYTE	07AH,00000000B+CDUT08,08AH,00000000B+CDUT17
		BYTE	09AH,00000000B+CDUT14,0AAH,01000000B+CDUT07
		BYTE	06BH,00000000B+CDUT04,07BH,00000000B+CDUT14
		BYTE	08BH,00000000B+CDUT19,09BH,00000000B+CDUT08
		BYTE	0ABH,01000000B+CDUT07,06CH,00000000B+CDUT05
		BYTE	07CH,00000000B+CDUT24,08CH,00000000B+CDUT17
		BYTE	09CH,00000000B+CDUT14,0ACH,01000000B+CDUT07
		BYTE	07DH,00000000B+CDUT04,08DH,00000000B+CDUT14
		BYTE	09DH,01000000B+CDUT07,07EH,00000000B+CDUT21
		BYTE	08EH,01000000B+CDUT07,09EH,00000000B+CDUT2C
		BYTE	07FH,00000000B+CDUT21,08FH,01000000B+CDUT07
		BYTE	09FH,00000000B+CDUT2D
;-------------------------------------------------------------------- Display 10
		BYTE	070H,10000000B+CDUT05,080H,00000000B+CDUT08
		BYTE	090H,01000000B+CDUT07,071H,00000000B+CDUT20
		BYTE	081H,00000000B+CDUT19,091H,00000000B+CDUT08
		BYTE	0A1H,00000000B+CDUT1A,0B1H,00000000B+CDUT08
		BYTE	0C1H,01000000B+CDUT07,052H,00000000B+CDUT04
		BYTE	062H,00000000B+CDUT0F,072H,00000000B+CDUT14
		BYTE	082H,01000000B+CDUT07,092H,00000000B+CDUT19
		BYTE	0A2H,00000000B+CDUT1B,0B2H,00000000B+CDUT19
		BYTE	0C2H,00000000B+CDUT08,043H,00000000B+CDUT20
		BYTE	053H,00000000B+CDUT02,063H,01000000B+CDUT07
		BYTE	0C3H,00000000B+CDUT19,0D3H,00000000B+CDUT08
		BYTE	044H,00000000B+CDUT05,054H,00000000B+CDUT03
		BYTE	064H,01000000B+CDUT07,0D4H,00000000B+CDUT19
		BYTE	055H,00000000B+CDUT22,065H,00000000B+CDUT1B
		BYTE	075H,01000000B+CDUT07,066H,00000000B+CDUT05
		BYTE	076H,00000000B+CDUT08,086H,01000000B+CDUT07
		BYTE	077H,00000000B+CDUT22,087H,00000000B+CDUT08
		BYTE	097H,00000000B+CDUT1A,0A7H,00000000B+CDUT08
		BYTE	0B7H,01000000B+CDUT07,088H,00000000B+CDUT05
		BYTE	098H,00000000B+CDUT0B,0A8H,00000000B+CDUT05
		BYTE	0B8H,00000000B+CDUT08,0C8H,01000000B+CDUT07
		BYTE	0B9H,00000000B+CDUT22,0C9H,00000000B+CDUT08
		BYTE	0D9H,00000000B+CDUT07,0CAH,00000000B+CDUT05
		BYTE	0DAH,00000000B+CDUT0B
;-------------------------------------------------------------------- Display 11
		BYTE	020H,10000000B+CDUT04,030H,00000000B+CDUT23
		BYTE	040H,00000000B+CDUT09,011H,00000000B+CDUT20
		BYTE	021H,00000000B+CDUT14,031H,00000000B+CDUT07
		BYTE	041H,00000000B+CDUT0C,051H,00000000B+CDUT09
		BYTE	012H,00000000B+CDUT21,022H,00000000B+CDUT01
		BYTE	032H,00000000B+CDUT07,042H,00000000B+CDUT07
		BYTE	052H,00000000B+CDUT0A,013H,00000000B+CDUT05
		BYTE	023H,00000000B+CDUT08,033H,00000000B+CDUT07
		BYTE	043H,00000000B+CDUT07,053H,00000000B+CDUT0B
		BYTE	0A3H,00000000B+CDUT04,0B3H,00000000B+CDUT23
		BYTE	0C3H,00000000B+CDUT09,024H,00000000B+CDUT22
		BYTE	034H,00000000B+CDUT24,044H,00000000B+CDUT0B
		BYTE	094H,00000000B+CDUT20,0A4H,00000000B+CDUT14
		BYTE	0B4H,00000000B+CDUT07,0C4H,00000000B+CDUT17
		BYTE	0D4H,00000000B+CDUT0F,085H,00000000B+CDUT20
		BYTE	095H,00000000B+CDUT14,0A5H,01000000B+CDUT07
		BYTE	0C5H,00000000B+CDUT14,086H,00000000B+CDUT22
		BYTE	096H,00000000B+CDUT08,0A6H,01000000B+CDUT07
		BYTE	067H,00000000B+CDUT20,077H,00000000B+CDUT09
		BYTE	087H,00000000B+CDUT04,097H,00000000B+CDUT13
		BYTE	0A7H,01000000B+CDUT07,058H,00000000B+CDUT20
		BYTE	068H,00000000B+CDUT14,078H,00000000B+CDUT0C
		BYTE	088H,00000000B+CDUT14,098H,00000000B+CDUT13
		BYTE	0A8H,01000000B+CDUT07,049H,00000000B+CDUT04
		BYTE	059H,00000000B+CDUT14,069H,01000000B+CDUT07
		BYTE	089H,00000000B+CDUT17,099H,00000000B+CDUT14
		BYTE	0A9H,00000000B+CDUT2C,04AH,00000000B+CDUT06
		BYTE	05AH,01000000B+CDUT07,08AH,00000000B+CDUT19
		BYTE	09AH,00000000B+CDUT08,0AAH,00000000B+CDUT2D
		BYTE	03BH,00000000B+CDUT20,04BH,00000000B+CDUT14
		BYTE	05BH,01000000B+CDUT07,09BH,00000000B+CDUT19
		BYTE	0ABH,00000000B+CDUT08,03CH,00000000B+CDUT21
		BYTE	04CH,01000000B+CDUT07,05CH,00000000B+CDUT10
		BYTE	06CH,00000000B+CDUT2E,07CH,00000000B+CDUT10
		BYTE	08CH,00000000B+CDUT14,09CH,00000000B+CDUT10
		BYTE	0ACH,00000000B+CDUT14,03DH,00000000B+CDUT05
		BYTE	04DH,00000000B+CDUT10,05DH,00000000B+CDUT14
		BYTE	06DH,00000000B+CDUT0C,07DH,00000000B+CDUT14
		BYTE	08DH,01000000B+CDUT07,09DH,00000000B+CDUT14
		BYTE	04EH,00000000B+CDUT06,05EH,01000000B+CDUT07
		BYTE	06EH,00000000B+CDUT2C,04FH,00000000B+CDUT05
		BYTE	05FH,00000000B+CDUT08,06FH,00000000B+CDUT2D
		BYTE	07FH,01000000B+CDUT07
;-------------------------------------------------------------------- Display 12
		BYTE	050H,10000000B+CDUT22,060H,00000000B+CDUT08
		BYTE	070H,01000000B+CDUT07,061H,00000000B+CDUT06
		BYTE	071H,01000000B+CDUT07,052H,00000000B+CDUT20
		BYTE	062H,00000000B+CDUT11,072H,00000000B+CDUT1F
		BYTE	082H,00000000B+CDUT08,092H,01000000B+CDUT07
		BYTE	053H,00000000B+CDUT21,063H,01000000B+CDUT07
		BYTE	083H,00000000B+CDUT19,093H,00000000B+CDUT1F
		BYTE	0A3H,00000000B+CDUT08,054H,00000000B+CDUT05
		BYTE	064H,00000000B+CDUT08,074H,01000000B+CDUT07
		BYTE	0A4H,00000000B+CDUT19,0B4H,00000000B+CDUT08
		BYTE	065H,00000000B+CDUT22,075H,00000000B+CDUT08
		BYTE	085H,01000000B+CDUT07,0B5H,00000000B+CDUT13
		BYTE	076H,00000000B+CDUT06,086H,01000000B+CDUT07
		BYTE	0B6H,00000000B+CDUT11,0C6H,00000000B+CDUT08
		BYTE	067H,00000000B+CDUT04,077H,00000000B+CDUT14
		BYTE	087H,00000000B+CDUT2C,097H,01000000B+CDUT07
		BYTE	0C7H,00000000B+CDUT19,0D7H,00000000B+CDUT08
		BYTE	068H,00000000B+CDUT22,078H,00000000B+CDUT08
		BYTE	088H,00000000B+CDUT2D,098H,01000000B+CDUT07
		BYTE	0D8H,00000000B+CDUT11,079H,00000000B+CDUT05
		BYTE	089H,00000000B+CDUT08,099H,01000000B+CDUT07
		BYTE	07AH,00000000B+CDUT20,08AH,00000000B+CDUT14
		BYTE	09AH,01000000B+CDUT07,07BH,00000000B+CDUT22
		BYTE	08BH,00000000B+CDUT24,09BH,00000000B+CDUT08
		BYTE	0ABH,01000000B+CDUT07,09CH,00000000B+CDUT21
		BYTE	0ACH,01000000B+CDUT07,0BCH,00000000B+CDUT1A
		BYTE	0CCH,00000000B+CDUT08,09DH,00000000B+CDUT22
		BYTE	0ADH,00000000B+CDUT24,0BDH,00000000B+CDUT2B
		BYTE	0CDH,00000000B+CDUT22,0DDH,00000000B+CDUT08
		BYTE	0DEH,00000000B+CDUT05
;
		WORD	0FFFFH
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	BG3 ku-mo unit data				   x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CLDUNT		EQU	$
CLDUT00		WORD	0085CH,0085CH,0085CH,0085CH	; 00
CLDUT01		WORD	00855H,00856H,00855H,04856H	; 01
CLDUT02		WORD	00854H,00853H,00855H,00856H	; 02
CLDUT03		WORD	00855H,04856H,04854H,00853H	; 03
CLDUT04		WORD	0085CH,00857H,00857H,00854H	; 04
CLDUT05		WORD	04857H,04854H,0085CH,04857H	; 05
CLDUT06		WORD	04857H,04854H,00857H,00854H	; 06
CLDUT07		WORD	00853H,00853H,00853H,00853H	; 07
CLDUT08		WORD	00853H,00853H,04854H,00853H	; 08
CLDUT09		WORD	08850H,08851H,00853H,08852H	; 09
CLDUT0A		WORD	00853H,0C852H,00853H,08852H	; 0A
CLDUT0B		WORD	00853H,0C852H,0C850H,0C851H	; 0B
CLDUT0C		WORD	00853H,08854H,00853H,00853H	; 0C
CLDUT0D		WORD	0C854H,04854H,0C857H,04857H	; 0D
CLDUT0E		WORD	08858H,00858H,00853H,00853H	; 0E
CLDUT0F		WORD	08857H,00857H,08854H,00854H	; 0F
;
CLDUT10		WORD	00853H,0085BH,0085BH,00854H	; 10
CLDUT11		WORD	0485BH,04854H,08853H,0485BH	; 11
CLDUT12		WORD	00853H,08854H,04854H,00853H	; 12
CLDUT13		WORD	0485BH,04854H,0085BH,00854H	; 13
CLDUT14		WORD	00854H,00853H,00853H,00853H	; 14
CLDUT15		WORD	04857H,04854H,00857H,0485BH	; 15
CLDUT16		WORD	04857H,0085BH,00857H,00854H	; 16
CLDUT17		WORD	00859H,00858H,0085AH,00853H	; 17
CLDUT18		WORD	0485AH,00853H,0085AH,00853H	; 18
CLDUT19		WORD	0485AH,00853H,04859H,04858H	; 19
CLDUT1A		WORD	00853H,00853H,00853H,0C854H	; 1A
CLDUT1B		WORD	0C854H,0C85BH,0C85BH,00853H	; 1B
CLDUT1C		WORD	0C854H,04854H,0C85BH,0485BH	; 1C
CLDUT1D		WORD	0885BH,0085BH,08854H,00854H	; 1D
CLDUT1E		WORD	0C854H,00853H,08854H,00853H	; 1E
CLDUT1F		WORD	00853H,00853H,0C858H,04858H	; 1F
;
CLDUT20		WORD	00851H,00850H,00852H,00853H	; 20
CLDUT21		WORD	04852H,00853H,00852H,00853H	; 21
CLDUT22		WORD	04852H,00853H,04851H,04850H	; 22
CLDUT23		WORD	08850H,00850H,00853H,00853H	; 23
CLDUT24		WORD	00853H,00853H,0C850H,04850H	; 24
CLDUT25		WORD	0C854H,0085BH,0C857H,04857H	; 25
CLDUT26		WORD	08857H,00857H,08854H,0485BH	; 26
CLDUT27		WORD	0085CH,00857H,0085CH,04857H	; 27
CLDUT28		WORD	00854H,00853H,04854H,00853H	; 28
CLDUT29		WORD	08857H,0085CH,08854H,08857H	; 29
CLDUT2A		WORD	0C854H,0C857H,08854H,08857H	; 2A
CLDUT2B		WORD	0C854H,0C857H,0C857H,0085CH	; 2B
CLDUT2C		WORD	00853H,00853H,00855H,00856H	; 2C
CLDUT2D		WORD	00855H,04856H,00853H,00853H	; 2D
CLDUT2E		WORD	08858H,08859H,00853H,0885AH	; 2E
CLDUT2F		WORD	00853H,0C85AH,0C858H,0C859H	; 2F
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	BG3 ku-mo unit NO.				   x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CDUT00		EQU	(CLDUT00-CLDUNT)/8
CDUT01		EQU	(CLDUT01-CLDUNT)/8
CDUT02		EQU	(CLDUT02-CLDUNT)/8
CDUT03		EQU	(CLDUT03-CLDUNT)/8
CDUT04		EQU	(CLDUT04-CLDUNT)/8
CDUT05		EQU	(CLDUT05-CLDUNT)/8
CDUT06		EQU	(CLDUT06-CLDUNT)/8
CDUT07		EQU	(CLDUT07-CLDUNT)/8
CDUT08		EQU	(CLDUT08-CLDUNT)/8
CDUT09		EQU	(CLDUT09-CLDUNT)/8
CDUT0A		EQU	(CLDUT0A-CLDUNT)/8
CDUT0B		EQU	(CLDUT0B-CLDUNT)/8
CDUT0C		EQU	(CLDUT0C-CLDUNT)/8
CDUT0D		EQU	(CLDUT0D-CLDUNT)/8
CDUT0E		EQU	(CLDUT0E-CLDUNT)/8
CDUT0F		EQU	(CLDUT0F-CLDUNT)/8
;
CDUT10		EQU	(CLDUT10-CLDUNT)/8
CDUT11		EQU	(CLDUT11-CLDUNT)/8
CDUT12		EQU	(CLDUT12-CLDUNT)/8
CDUT13		EQU	(CLDUT13-CLDUNT)/8
CDUT14		EQU	(CLDUT14-CLDUNT)/8
CDUT15		EQU	(CLDUT15-CLDUNT)/8
CDUT16		EQU	(CLDUT16-CLDUNT)/8
CDUT17		EQU	(CLDUT17-CLDUNT)/8
CDUT18		EQU	(CLDUT18-CLDUNT)/8
CDUT19		EQU	(CLDUT19-CLDUNT)/8
CDUT1A		EQU	(CLDUT1A-CLDUNT)/8
CDUT1B		EQU	(CLDUT1B-CLDUNT)/8
CDUT1C		EQU	(CLDUT1C-CLDUNT)/8
CDUT1D		EQU	(CLDUT1D-CLDUNT)/8
CDUT1E		EQU	(CLDUT1E-CLDUNT)/8
CDUT1F		EQU	(CLDUT1F-CLDUNT)/8
;
CDUT20		EQU	(CLDUT20-CLDUNT)/8
CDUT21		EQU	(CLDUT21-CLDUNT)/8
CDUT22		EQU	(CLDUT22-CLDUNT)/8
CDUT23		EQU	(CLDUT23-CLDUNT)/8
CDUT24		EQU	(CLDUT24-CLDUNT)/8
CDUT25		EQU	(CLDUT25-CLDUNT)/8
CDUT26		EQU	(CLDUT26-CLDUNT)/8
CDUT27		EQU	(CLDUT27-CLDUNT)/8
CDUT28		EQU	(CLDUT28-CLDUNT)/8
CDUT29		EQU	(CLDUT29-CLDUNT)/8
CDUT2A		EQU	(CLDUT2A-CLDUNT)/8
CDUT2B		EQU	(CLDUT2B-CLDUNT)/8
CDUT2C		EQU	(CLDUT2C-CLDUNT)/8
CDUT2D		EQU	(CLDUT2D-CLDUNT)/8
CDUT2E		EQU	(CLDUT2E-CLDUNT)/8
CDUT2F		EQU	(CLDUT2F-CLDUNT)/8
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	END
;
;
;
;
