	INCLUDE mn_hp_mr3ram.asm
; 
;<MR3MAIN>================================================================================
         EXT      JSRSUB,BUFFCLR,BUFFCLR1,DATASET,JSRSUBL
; 
         EXT      MPGM,BLGM,MSGM,YMGM,SLGM,CDGM,SRGM,ALGM,BNGM
         EXT      PYGM,MZGM,SPGM,MTGM,ICGM
; 
;<MR3END0>================================================================================
         EXT      E000,E001,E002,E003,E004,E005,E006,E007,E008,E00A 
         EXT      E00B,E00C,E00D,E00E,E00F,E010 
         EXT      E108,E129,E131
         EXT      E204,E207,E20A
         EXT      E301,E303,E306,E30E,E310,E315,E316,E319 
         EXT      E513
; 
;<MR3BGD1>================================================================================
         EXT      B108,B129,B131
         EXT      B204,B207,B20A
         EXT      B513
; 
;<MR3BGD5>================================================================================
         EXT      B513
; 
;<MR3DAT3>================================================================================
         EXT      TWOBGDT,BETASET,HAT1SET,HAT2SET,BYM0SET,BYM1SET,BYM2SET 
         EXT      BDK0SET,BDK1SET,DKY0SET,DKY1SET,TAIHSET,HASISET,HAT3SET 
         EXT      NKUMSET,KORASET,BDK2SET,DOR2SET,KURGSET,VELCSET,CIKUSET 
         EXT      KEB0SET,KEB1SET,KEB2SET,KEB3SET,KEB4SET,KEB5SET 
; 
         EXT      YPINCST 
; 
;<MR3BGD3>================================================================================
         GLB      COLADR6,ALLCRS6,DTRMST6,KAH6SET,KOT6SET 
; 
;------- asultic unit-no. ----------------------------------------------------------------
         GLB      KEBL0,KEBL1,KEBL2,KEBL3,KEBL4,KEBL5,KEBL6,KEBL7 
         GLB      VELC0,VELC1,KBEND 
; 
         GLB      VVELC0
; 
;------- ice unit-no. --------------------------------------------------------------------
         GLB      ENHL0,ENHL1,ENHL2,ENHL3,ENHL4,ENHL5,IBKCN,IBKPK 
         GLB      MARUB,IBLK0,IBLK1,IBLK4,IHIL0,IHIL1,IHIL2,MARU0 
         GLB      MARU1,MARU2,IHIL6,IHIL7,IHIL8,AIWA0,IHIL9
	GLB	ENHL6,ENHL7,ENHL8,ENHL9,ENHLA,ENHLB,ENHLC,ENHLD,ENHLE,ENHLF
;
         GLB      B300,B301,B302,B303,B304,B305,B306,B307,B308,B309,B30A,B30B,B30C,B30D,B30E,B30F 
         GLB      B310,B311,B312,B313,B314,B315,B316,B317,B318,B319,B31A,B31B,B31C,B31D,B31E,B31F 
         GLB      B320,B321,B322,B323,B324,B325,B326,B327,B328,B329,B32A,B32B,B32C,B32D,B32E,B32F 
         GLB      B330,B331,B332,B333,B334,B335,B336,B337,B338,B339,B33A,B33B,B33C,B33D,B33E,B33F 
;
;<MR3BG2ST>================================================================================
	EXT	ICEYUK
;
;-----------------------------------------------------------------------------------------
;
         ORG      024DE00H
		EXTEND
		IDX8
		MEM8
; 
;-----------------------------------------------------------------------------------------
;======= asultic display unit-no. data ===============================
COLADR6  EQU      $ 
ASDT00   EQU      $ 
		WORD	010FCH,010FCH,010FCH,010FCH	; 00
		WORD	00C3BH,00C3AH,010FCH,010FCH	; 01
AKUMO0		WORD	01005H,0100AH,01007H,0100CH	; 02
JPTOMI		WORD	01005H,01006H,01007H,01008H	; 03
GHASI0		WORD	01005H,00CD6H,01007H,00CD6H	; 04 ha-si (te-su-ri)
GHASI1		WORD	014E8H,014E9H,014EAH,014EBH	; 05
AKUMO1		WORD	01005H,0107CH,01007H,0100CH	; 06
AKUMO2		WORD	01005H,0107CH,01007H,0107EH	; 07
IKUMO0		WORD	00C05H,00C06H,00C07H,00C46H	; 08  ice cloud up left
IKUMO1		WORD	00C44H,00CFDH,00C45H,00CFDH	; 09  ice cloud up center
IKUMO2		WORD	00C05H,00C47H,00C07H,00C08H	; 0A  ice cloud up right
IKUMO3		WORD	00C05H,00C06H,00C48H,00C08H	; 0B  ice cloud down left
IKUMO4		WORD	00C49H,00C06H,00C4AH,00C08H	; 0C  ice cloud down center
IKUMO5		WORD	00C4BH,00C06H,00C07H,00C08H	; 0D  ice cloud down right
IHILL3		WORD	01C10H,01C10H,01C11H,01C11H	; 0E  ice namigata moyou dai middle left
IHILL4		WORD	01C28H,01C28H,01C11H,01C11H	; 0F  ice namigata moyou dai middle center
IHILL5		WORD	01C28H,01C28H,01C29H,01C29H	; 10  ice namigata moyou dai middle right
ENHIL0		WORD	00E06H,00E16H,00E07H,00E17H	; 11
ENHIL1		WORD	00E08H,00E18H,00E08H,00E18H	; 12
ENHIL2		WORD	00E09H,00E19H,00E0AH,00E1AH	; 13
ENHIL3		WORD	00E16H,00E16H,00E17H,00E17H	; 14
ENHIL4		WORD	00E18H,00E18H,00E18H,00E18H	; 15
ENHIL5		WORD	00E19H,00E19H,00E1AH,00E1AH	; 16
ENWAK0		WORD	00CFCH,00CFCH,00CFCH,00C68H	; 17 --------------
ENWAK1		WORD	00CFCH,00C13H,00CFCH,00C13H	; 18    |
ENWAK2		WORD	00CFCH,00C69H,00CFCH,00CFCH	; 19    |
ENWAK3		WORD	00CFCH,00CFCH,00C23H,00C23H	; 1A  goal item
ENWAK4		WORD	00C23H,00C23H,00CFCH,00CFCH	; 1B   panel waku
ENWAK5		WORD	00CFCH,00CFCH,00C6AH,00CFCH	; 1C    |
ENWAK6		WORD	00C13H,00CFCH,00C13H,00CFCH	; 1D    |
ENWAK7		WORD	00C6BH,00CFCH,00CFCH,00CFCH	; 1E --------------
;
AKUMO3		WORD	0100BH,01006H,0100DH,01008H	; 1F
AKUMO4		WORD	0107DH,01006H,0100DH,01008H	; 20
AKUMO5		WORD	0107DH,01006H,0107FH,01008H	; 21
IHILL0		WORD	01C00H,01C10H,01C01H,01C11H	; 22  ice namigata moyou dai top left 
IHILL1		WORD	01C18H,01C28H,01C01H,01C11H	; 23  ice namigata moyou dai top center
IHILL2		WORD	01C18H,01C28H,01C19H,01C29H	; 24  ice namigata moyou dai top right
IHILL9		WORD	01C18H,01C28H,01C39H,01C29H	; 25  ice namigata moyou dai top right
;;K;;IHILL9		WORD	01018H,01028H,01001H,01011H	; 25
		WORD	010FFH,010FFH,010FFH,010FFH	; 26
		WORD	010FFH,010FFH,010FFH,010FFH	; 27
		WORD	010FFH,010FFH,010FFH,010FFH	; 28
		WORD	010FFH,010FFH,010FFH,010FFH	; 29
		WORD	010FFH,010FFH,010FFH,010FFH	; 2A
		WORD	010FFH,010FFH,010FFH,010FFH	; 2B
NKUMO0		WORD	0104CH,0104DH,0104EH,0104FH	; 2C
		WORD	010FFH,010FFH,010FFH,010FFH	; 2D
NSJUMP		WORD	014B8H,014B9H,014BAH,014BBH	; 2E --------------
HKABE9		WORD	014B8H,014B9H,014BAH,014BBH	; 2F  nomal
HNJUMP		WORD	014B8H,014B9H,014BAH,014BBH	; 30   jump dai
HSJUMP		WORD	014B8H,014B9H,014BAH,014BBH	; 31 --------------
KOHRA0		WORD	014BCH,014BDH,014BEH,014BFH	; 32  ice block
		WORD	010FFH,010FFH,010FFH,010FFH	; 33
VELCN0		WORD	010B0H,010B1H,010B0H,010B1H	; 34
VELCN1		WORD	010B1H,010B0H,010B1H,010B0H	; 35
IBLOK0		WORD	01C14H,01C24H,01C15H,01C25H	; 36  ice block big left up
IBLOK1		WORD	01C1CH,01C2CH,01C1DH,01C2DH	; 37  ice block big right up
IBLOK2		WORD	01C4CH,01C0EH,01C4DH,01C0FH	; 38  ice block big left down
IBLOK3		WORD	01C4EH,01C1EH,01C4FH,01C1FH	; 39  ice block big right down
IBLOK4		WORD	01C0AH,01C0BH,01C0CH,01C0DH	; 3A  ice block small
		WORD	010FFH,010FFH,010FFH,010FFH	; 3B
		WORD	010FFH,010FFH,010FFH,010FFH	; 3C
		WORD	010FFH,010FFH,010FFH,010FFH	; 3D
		WORD	010FFH,010FFH,010FFH,010FFH	; 3E
		WORD	010FFH,010FFH,010FFH,010FFH	; 3F
;
ASDT01		EQU	$
GCOIN0		WORD	01CDCH,01CDDH,01CDEH,01CDFH	; 00 BG coin
GCOIN1		WORD	01405H,01406H,01407H,01408H	; 01
DOOR0D		WORD	01664H,01674H,01665H,01675H	; 02 door
DOOR1D		WORD	01264H,01274H,01265H,01275H	; 03 door
CNTOMI		WORD	01405H,01406H,01407H,01408H	; 04
UPTOMI		WORD	01405H,01406H,01407H,01408H	; 05
SPTOMI		WORD	01405H,01406H,01407H,01408H	; 06
ASHASR		WORD	01003H,01003H,01004H,01004H	; 07 wood ha-si-ra (big)
ASHAS0		WORD	01059H,01059H,01007H,01008H	; 08	"	(small)
ASHAS1		WORD	01005H,01006H,01059H,01059H	; 09	"	(small)
;
MARUT0		WORD	0103CH,0103DH,0103EH,0103FH	; 0A --------------
MARUT1		WORD	0103EH,0103FH,0103EH,0103FH	; 0B	|
MARUT2		WORD	0103EH,0103FH,0102EH,0102FH	; 0C	|
MARUT3		WORD	01000H,01010H,01001H,01011H	; 0D	|
MARUT4		WORD	01001H,01011H,01001H,01011H	; 0E	|
MARUT5		WORD	01001H,01011H,01002H,01012H	; 0F  ma-ru-ta
MARUT6		WORD	01020H,01030H,01021H,01031H	; 10	|
MARUT7		WORD	01021H,01031H,01021H,01031H	; 11	|
MARUT8		WORD	01021H,01031H,01022H,01032H	; 12	|
MARUT9		WORD	01022H,01032H,01021H,01031H	; 13	|
MARUTA		WORD	01022H,01032H,01002H,01012H	; 14 --------------
IBLKCN		WORD	01C58H,01C59H,01C5AH,01C5BH	; 15 ice block
IBLKPK		WORD	01C54H,01C55H,01C56H,01C57H	; 16 ice packn
		WORD	014FFH,014FFH,014FFH,014FFH	; 17
		WORD	014FFH,014FFH,014FFH,014FFH	; 18
		WORD	014FFH,014FFH,014FFH,014FFH	; 19
		WORD	014FFH,014FFH,014FFH,014FFH	; 1A
MARUTB		WORD	0105CH,0105DH,0105EH,0105FH	; 1B chikuwa block
		WORD	014FFH,014FFH,014FFH,014FFH	; 1C
		WORD	014FFH,014FFH,014FFH,014FFH	; 1D
		WORD	014FFH,014FFH,014FFH,014FFH	; 1E
NSBLOK		WORD	01E54H,01E55H,01E56H,01E57H	; 1F no move block
KNQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 20 --------------
HNQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 21	|
HSQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 22 ha-te-na
CNQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 23   block
HCQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 24	|
TCQEST		WORD	01C98H,01C99H,01C9AH,01C9BH	; 25 --------------
ENQEST		WORD	01C92H,01C93H,01CCAH,01CCBH	; 26 BG pa-ku-n
BLBLK0		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 27 --------------
KNBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 28	|
HNBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 29	|
HSBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2A	|
CNBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2B  wa-re-ru
HCBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2C    block
TCBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2D	|
UPBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2E	|
RPBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 2F	|
ENBLOK		WORD	01CB4H,01CB5H,01CB6H,01CB7H	; 30 --------------
SPJMP0		WORD	010B8H,010B9H,010BAH,010BBH	; 31
NSJMPY		WORD	01244H,01245H,01246H,01247H	; 32 --------------
KNJMPY		WORD	01244H,01245H,01246H,01247H	; 33  si-ma
HNJMPY		WORD	01244H,01245H,01246H,01247H	; 34   block
HSJMPY		WORD	01244H,01245H,01246H,01247H	; 35 --------------
TAIHO0		WORD	01648H,01649H,0164AH,0164BH	; 36 houdai top
TAIHO1		WORD	0164CH,0164DH,0164EH,0164FH	; 37 houdai center
TAIHO2		WORD	01658H,01658H,01659H,01659H	; 38 houdai down
BLBLK1		WORD	01244H,01245H,01246H,01247H	; 39 si-ma block
SABAK0		WORD	014D5H,014B2H,014D5H,014B2H	; 3A
SABAK2		WORD	014B2H,014B2H,014B2H,014B2H	; 3B
		WORD	014FFH,014FFH,014FFH,014FFH	; 3C
		WORD	014FFH,014FFH,014FFH,014FFH	; 3D
		WORD	014FFH,014FFH,014FFH,014FFH	; 3E
		WORD	014FFH,014FFH,014FFH,014FFH	; 3F
;
ASDT02		EQU	$
ABACK0		WORD	01805H,01806H,01807H,01808H	; 00
ASIWA0		WORD	01C50H,01C51H,01C52H,01C53H	; 01 --------------
ASIWA1		WORD	01C50H,01C51H,01C56H,01C57H	; 02  small
ASIWA2		WORD	01C54H,01C55H,01C56H,01C57H	; 03    ku-sa
ASIWA3		WORD	01C54H,01C55H,01C52H,01C53H	; 04 --------------
HANA06		WORD	01CC4H,01CC4H,01CC6H,01CC6H	; 05 tu-ru
CARTEN		WORD	01805H,01806H,01807H,01808H	; 06
AHILL3		WORD	00D26H,00D36H,00D27H,00D37H	; 07 --------------
AHILL4		WORD	00D28H,00D38H,00D27H,00D37H	; 08	|
AHILL5		WORD	00D28H,00D38H,00D29H,00D39H	; 09  auto scroll
;							       land data
AHILL0		WORD	00D20H,00D30H,00D21H,00D31H	; 0A	|
AHILL1		WORD	00D22H,00D32H,00D23H,00D33H	; 0B	|
AHILL2		WORD	00D24H,00D34H,00D25H,00D35H	; 0C --------------
;;K;;AHILL3		WORD	00C26H,00C26H,00C27H,00C27H	; 07 --------------
;;K;;AHILL4		WORD	00C28H,00C28H,00C29H,00C29H	; 08	|
;;K;;AHILL5		WORD	00C2AH,00C2AH,00C2BH,00C2BH	; 09  auto scroll
;;K;;;							       land data
;;K;;AHILL0		WORD	00C16H,00C26H,00C17H,00C27H	; 0A	|
;;K;;AHILL1		WORD	00C18H,00C28H,00C19H,00C29H	; 0B	|
;;K;;AHILL2		WORD	00C1AH,00C2AH,00C1BH,00C2BH	; 0C --------------
IBLOK5		WORD	0180EH,0181EH,0180FH,0181FH	; 0D
IHILL6		WORD	00C16H,00C26H,00C17H,00C27H	; 0E  ice asletic dai left
IHILL7		WORD	00C1AH,00C2AH,00C17H,00C27H	; 0F  ice asletic dai center
IHILL8		WORD	00C1AH,00C2AH,00C1BH,00C2BH	; 10  ice asletic dai right
		WORD	018FFH,018FFH,018FFH,018FFH	; 11
		WORD	018FFH,018FFH,018FFH,018FFH	; 12
		WORD	018FFH,018FFH,018FFH,018FFH	; 13
		WORD	018FFH,018FFH,018FFH,018FFH	; 14
		WORD	018FFH,018FFH,018FFH,018FFH	; 15
		WORD	018FFH,018FFH,018FFH,018FFH	; 16
		WORD	018FFH,018FFH,018FFH,018FFH	; 17
		WORD	018FFH,018FFH,018FFH,018FFH	; 18
		WORD	018FFH,018FFH,018FFH,018FFH	; 19
		WORD	018FFH,018FFH,018FFH,018FFH	; 1A
		WORD	018FFH,018FFH,018FFH,018FFH	; 1B
		WORD	018FFH,018FFH,018FFH,018FFH	; 1C
		WORD	018FFH,018FFH,018FFH,018FFH	; 1D
		WORD	018FFH,018FFH,018FFH,018FFH	; 1E
		WORD	018FFH,018FFH,018FFH,018FFH	; 1F
		WORD	018FFH,018FFH,018FFH,018FFH	; 20
		WORD	018FFH,018FFH,018FFH,018FFH	; 21
		WORD	018FFH,018FFH,018FFH,018FFH	; 22
		WORD	018FFH,018FFH,018FFH,018FFH	; 23
		WORD	018FFH,018FFH,018FFH,018FFH	; 24
		WORD	018FFH,018FFH,018FFH,018FFH	; 25
		WORD	018FFH,018FFH,018FFH,018FFH	; 26
		WORD	018FFH,018FFH,018FFH,018FFH	; 27
		WORD	018FFH,018FFH,018FFH,018FFH	; 28
		WORD	018FFH,018FFH,018FFH,018FFH	; 29
		WORD	018FFH,018FFH,018FFH,018FFH	; 2A
		WORD	018FFH,018FFH,018FFH,018FFH	; 2B
		WORD	018FFH,018FFH,018FFH,018FFH	; 2C
BLDOK1		WORD	01E40H,01E50H,01E41H,01E51H	; 2D --------------
BLDOK2		WORD	01E42H,01E52H,01E43H,01E53H	; 2E	|
BLDOK5		WORD	01E40H,01E50H,01E41H,01E51H	; 2F	|
BLDOK6		WORD	01E42H,01E52H,01E43H,01E53H	; 30	|
BLDOK7		WORD	01E40H,01E50H,01E41H,01E51H	; 31	|
BLDOK8		WORD	01E42H,01E52H,01E43H,01E53H	; 32	|
BLDOKE		WORD	01E40H,01E50H,01E41H,01E51H	; 33	|
BLDOKF		WORD	01E42H,01E52H,01E43H,01E53H	; 34  do-ka-n
BLDOK9		WORD	01C76H,01C77H,01C7AH,01C7BH	; 35	|
BLDOKA		WORD	01C76H,01C77H,01C7AH,01C7BH	; 36	|
BLDOKB		WORD	01C74H,01C75H,01C78H,01C79H	; 37	|
BLDOKC		WORD	01C70H,01C71H,01C70H,01C71H	; 38	|
BLDOKD		WORD	01C72H,01C73H,01C72H,01C73H	; 39	|
BLDOK3		WORD	01E60H,01E60H,01E61H,01E61H	; 3A	|
BLDOK4		WORD	01E62H,01E62H,01E63H,01E63H	; 3B --------------
JUMP01		WORD	018B8H,018B9H,018BAH,018BBH	; 3C all cross jump dai
		WORD	018FFH,018FFH,018FFH,018FFH	; 3D
		WORD	018FFH,018FFH,018FFH,018FFH	; 3E
		WORD	018FFH,018FFH,018FFH,018FFH	; 3F
;
ASDT03		EQU	$
AKUMO6		WORD	00C44H,00C45H,00C46H,00C47H	; 00 big na-ru-to ku-mo
GHASI3		WORD	01C05H,01C06H,01C07H,01C08H	; 01
AKUMO7		WORD	00C48H,00C49H,00C4AH,00C4BH	; 02 big na-ru-to ku-mo
AKUMO8		WORD	00C05H,00C0EH,00C07H,00C0FH	; 03 small na-ru-to ku-mo
HIMO00		WORD	01C05H,01C06H,00C1EH,00C1EH	; 04 --------------
HIMO01		WORD	01C05H,01C06H,00C1EH,00C1FH	; 05  tu-ru-su
HIMO02		WORD	00C1EH,00C1EH,01C06H,01C07H	; 06   hi-mo
HIMO03		WORD	00C1EH,00C1FH,01C06H,01C07H	; 07 --------------
KEBUL0		WORD	00C05H,00C6CH,00C07H,00C6CH	; 08 sen lift no yoko sen
KEBUL1		WORD	00C05H,00C06H,00C6DH,00C6DH	; 09 sen lift no tate sen
KEBUL2		WORD	00C6EH,00C06H,00C07H,00C6EH	; 0A left up sen 45do
KEBUL3		WORD	00C05H,00C6FH,00C6FH,00C08H	; 0B right up sen 45do
KEBUL4		WORD	00C35H,00C36H,00C07H,00C08H	; 0C left up sen 62.5do [hidari yori]
KEBUL5		WORD	00C05H,00C06H,00C35H,01036H	; 0D left up sen 62.5do [migi yori]
KEBUL6		WORD	00C05H,00C06H,00C37H,00C38H	; 0E right up sen 62.5do [migi yori]
KEBUL7		WORD	00C37H,00C38H,00C07H,00C08H	; 0F right up sen 62.5do [hidari yori]
KBLEND		WORD	01CD0H,01CD1H,01CD2H,01CD3H	; 10
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 11
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 12
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 13
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 14
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 15
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 16
BKBOT0		WORD	000FFH,00CE6H,000FFH,00CE7H	; 17 break P swich
CKROK0		WORD	01CB3H,01CCDH,01CB3H,01CCFH	; 18
CKROK1		WORD	01CCCH,01CCDH,01CCEH,01CCFH	; 19
CKROK2		WORD	01CFCH,01CCDH,01CFCH,01CCFH	; 1A
MIZU35		WORD	01CC5H,01CFEH,01CC5H,01CFEH	; 1B
MIZU36		WORD	00CC7H,00CFEH,00CC7H,00CFEH	; 1C water fise
MIZU37		WORD	01CD4H,01CFEH,01CD4H,01CFEH	; 1D
MIZU38		WORD	00CFEH,00CFEH,00CFEH,00CFEH	; 1E water
MIZU39		WORD	01CFCH,01CFEH,01CFCH,01CFEH	; 1F
TAKI00		WORD	00CA6H,00CAEH,00CA7H,00CAFH	; 20
TAKI01		WORD	00CACH,00CAEH,00CADH,00CAFH	; 21
;;K;;TAKI00		WORD	01CAAH,01CAAH,01CABH,01CABH	; 20
;;K;;TAKI01		WORD	01CABH,01CABH,01CABH,01CABH	; 21
;
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 22
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 23
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 24
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 25
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 26
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 27
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 28
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 29
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2A
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2B
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2C
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2D
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2E
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 2F
RENGA0		WORD	01CC0H,01CC1H,01CC2H,01CC3H	; 30
GHASI2		WORD	01CD7H,01C06H,01CD7H,01C08H	; 31
BKBOT1		WORD	00CE0H,00CE1H,00CE2H,00CE3H	; 32 P swich
SPACE0		WORD	01C05H,01C06H,01C07H,01C08H	; 33
KURAG0		WORD	01CF0H,01CF2H,01CF1H,01CF3H	; 34
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 35
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 36
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 37
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 38
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 39
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3A
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3B
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3C
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3D
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3E
		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 3F
;
DOOR2D		WORD	01270H,01272H,01271H,01273H	; 100 door
MIZUNK		WORD	01CFFH,01CFFH,01CFFH,01CFFH	; 101 mizu nuki
ENHIL6		WORD	00E09H,00E19H,00E0BH,00E1AH	; 102
ENHIL7		WORD	00E1BH,00E16H,00E07H,00E17H	; 103
ENHIL8		WORD	01224H,01234H,01225H,01235H	; 104
ENHIL9		WORD	01226H,01236H,01225H,01235H	; 105
ENHILA		WORD	01226H,01236H,01227H,01237H	; 106
ENHILB		WORD	01229H,01229H,0122AH,01239H	; 107
ENHILC		WORD	01239H,0122AH,0122AH,01239H	; 108
ENHILD		WORD	01239H,0122AH,0123AH,0123AH	; 109
ENHILE		WORD	01226H,01236H,01238H,01237H	; 10A
ENHILF		WORD	01228H,01234H,01225H,01235H	; 10B
;
;=====================================================================
AKUM0    EQU      (AKUMO0-ASDT00)/8
JPTOM    EQU      (JPTOMI-ASDT00)/8
GHAS0    EQU      (GHASI0-ASDT00)/8
GHAS1    EQU      (GHASI1-ASDT00)/8
AKUM1    EQU      (AKUMO1-ASDT00)/8
AKUM2    EQU      (AKUMO2-ASDT00)/8
IKUM0    EQU      (IKUMO0-ASDT00)/8
IKUM1    EQU      (IKUMO1-ASDT00)/8
IKUM2    EQU      (IKUMO2-ASDT00)/8
IKUM3    EQU      (IKUMO3-ASDT00)/8
IKUM4    EQU      (IKUMO4-ASDT00)/8
IKUM5    EQU      (IKUMO5-ASDT00)/8
IHIL3    EQU      (IHILL3-ASDT00)/8
IHIL4    EQU      (IHILL4-ASDT00)/8
IHIL5    EQU      (IHILL5-ASDT00)/8
ENHL0    EQU      (ENHIL0-ASDT00)/8
ENHL1    EQU      (ENHIL1-ASDT00)/8
ENHL2    EQU      (ENHIL2-ASDT00)/8
ENHL3    EQU      (ENHIL3-ASDT00)/8
ENHL4    EQU      (ENHIL4-ASDT00)/8
ENHL5    EQU      (ENHIL5-ASDT00)/8
ENWK0    EQU      (ENWAK0-ASDT00)/8
ENWK1    EQU      (ENWAK1-ASDT00)/8
ENWK2    EQU      (ENWAK2-ASDT00)/8
ENWK3    EQU      (ENWAK3-ASDT00)/8
ENWK4    EQU      (ENWAK4-ASDT00)/8
ENWK5    EQU      (ENWAK5-ASDT00)/8
ENWK6    EQU      (ENWAK6-ASDT00)/8
ENWK7    EQU      (ENWAK7-ASDT00)/8
;
AKUM3    EQU      (AKUMO3-ASDT00)/8
AKUM4    EQU      (AKUMO4-ASDT00)/8
AKUM5    EQU      (AKUMO5-ASDT00)/8
IHIL0    EQU      (IHILL0-ASDT00)/8
IHIL1    EQU      (IHILL1-ASDT00)/8
IHIL2    EQU      (IHILL2-ASDT00)/8
IHIL9    EQU      (IHILL9-ASDT00)/8
NKUMO    EQU      (NKUMO0-ASDT00)/8
NSJMP    EQU      (NSJUMP-ASDT00)/8
HKAB9    EQU      (HKABE9-ASDT00)/8
HNJMP    EQU      (HNJUMP-ASDT00)/8
HSJMP    EQU      (HSJUMP-ASDT00)/8
KOHRA    EQU      (KOHRA0-ASDT00)/8
VELC0    EQU      (VELCN0-ASDT00)/8
VELC1    EQU      (VELCN1-ASDT00)/8
IBLK0    EQU      (IBLOK0-ASDT00)/8
IBLK1    EQU      (IBLOK1-ASDT00)/8
IBLK2    EQU      (IBLOK2-ASDT00)/8
IBLK3    EQU      (IBLOK3-ASDT00)/8
IBLK4    EQU      (IBLOK4-ASDT00)/8
;
;
GCOIN    EQU      (GCOIN0-ASDT00)/8
GCIN1    EQU      (GCOIN1-ASDT00)/8
DOOR0    EQU      (DOOR0D-ASDT00)/8
DOOR1    EQU      (DOOR1D-ASDT00)/8
CNTOM    EQU      (CNTOMI-ASDT00)/8
UPTOM    EQU      (UPTOMI-ASDT00)/8
SPTOM    EQU      (SPTOMI-ASDT00)/8
AHASR    EQU      (ASHASR-ASDT00)/8
AHAS0    EQU      (ASHAS0-ASDT00)/8
AHAS1    EQU      (ASHAS1-ASDT00)/8
;
MARU0    EQU      (MARUT0-ASDT00)/8
MARU1    EQU      (MARUT1-ASDT00)/8
MARU2    EQU      (MARUT2-ASDT00)/8
MARU3    EQU      (MARUT3-ASDT00)/8
MARU4    EQU      (MARUT4-ASDT00)/8
MARU5    EQU      (MARUT5-ASDT00)/8
MARU6    EQU      (MARUT6-ASDT00)/8
MARU7    EQU      (MARUT7-ASDT00)/8
MARU8    EQU      (MARUT8-ASDT00)/8
MARU9    EQU      (MARUT9-ASDT00)/8
MARUA    EQU      (MARUTA-ASDT00)/8
IBKCN    EQU      (IBLKCN-ASDT00)/8
IBKPK    EQU      (IBLKPK-ASDT00)/8
MARUB    EQU      (MARUTB-ASDT00)/8
NSBLK    EQU      (NSBLOK-ASDT00)/8
KNQST    EQU      (KNQEST-ASDT00)/8
HNQST    EQU      (HNQEST-ASDT00)/8
HSQST    EQU      (HSQEST-ASDT00)/8
CNQST    EQU      (CNQEST-ASDT00)/8
HCQST    EQU      (HCQEST-ASDT00)/8
TCQST    EQU      (TCQEST-ASDT00)/8
ENQST    EQU      (ENQEST-ASDT00)/8
BBLK0    EQU      (BLBLK0-ASDT00)/8
KNBLK    EQU      (KNBLOK-ASDT00)/8
HNBLK    EQU      (HNBLOK-ASDT00)/8
HSBLK    EQU      (HSBLOK-ASDT00)/8
CNBLK    EQU      (CNBLOK-ASDT00)/8
HCBLK    EQU      (HCBLOK-ASDT00)/8
TCBLK    EQU      (TCBLOK-ASDT00)/8
UPBLK    EQU      (UPBLOK-ASDT00)/8
RPBLK    EQU      (RPBLOK-ASDT00)/8
ENBLK    EQU      (ENBLOK-ASDT00)/8
SPJP0    EQU      (SPJMP0-ASDT00)/8
NSJPY    EQU      (NSJMPY-ASDT00)/8
KNJPY    EQU      (KNJMPY-ASDT00)/8
HNJPY    EQU      (HNJMPY-ASDT00)/8
HSJPY    EQU      (HSJMPY-ASDT00)/8
TAIH0    EQU      (TAIHO0-ASDT00)/8
TAIH1    EQU      (TAIHO1-ASDT00)/8
TAIH2    EQU      (TAIHO2-ASDT00)/8
BBLK1    EQU      (BLBLK1-ASDT00)/8
SABA0    EQU      (SABAK0-ASDT00)/8
SABA2    EQU      (SABAK2-ASDT00)/8
;
;
ABAC0    EQU      (ABACK0-ASDT00)/8
AIWA0    EQU      (ASIWA0-ASDT00)/8
AIWA1    EQU      (ASIWA1-ASDT00)/8
AIWA2    EQU      (ASIWA2-ASDT00)/8
AIWA3    EQU      (ASIWA3-ASDT00)/8
HANA6    EQU      (HANA06-ASDT00)/8
ACATN    EQU      (CARTEN-ASDT00)/8
AHIL3    EQU      (AHILL3-ASDT00)/8
AHIL4    EQU      (AHILL4-ASDT00)/8
AHIL5    EQU      (AHILL5-ASDT00)/8
;
AHIL0    EQU      (AHILL0-ASDT00)/8
AHIL1    EQU      (AHILL1-ASDT00)/8
AHIL2    EQU      (AHILL2-ASDT00)/8
IBLK5    EQU      (IBLOK5-ASDT00)/8
IHIL6    EQU      (IHILL6-ASDT00)/8
IHIL7    EQU      (IHILL7-ASDT00)/8
IHIL8    EQU      (IHILL8-ASDT00)/8
BDOK1    EQU      (BLDOK1-ASDT00)/8
BDOK2    EQU      (BLDOK2-ASDT00)/8
BDOK5    EQU      (BLDOK5-ASDT00)/8
BDOK6    EQU      (BLDOK6-ASDT00)/8
BDOK7    EQU      (BLDOK7-ASDT00)/8
BDOK8    EQU      (BLDOK8-ASDT00)/8
BDOKE    EQU      (BLDOKE-ASDT00)/8
BDOKF    EQU      (BLDOKF-ASDT00)/8
BDOK9    EQU      (BLDOK9-ASDT00)/8
BDOKA    EQU      (BLDOKA-ASDT00)/8
BDOKB    EQU      (BLDOKB-ASDT00)/8
BDOKC    EQU      (BLDOKC-ASDT00)/8
BDOKD    EQU      (BLDOKD-ASDT00)/8
BDOK3    EQU      (BLDOK3-ASDT00)/8
BDOK4    EQU      (BLDOK4-ASDT00)/8
JUMP1    EQU      (JUMP01-ASDT00)/8
;
;
AKUM6    EQU      (AKUMO6-ASDT00)/8
AKUM7    EQU      (AKUMO7-ASDT00)/8
AKUM8    EQU      (AKUMO8-ASDT00)/8
HIMO0    EQU      (HIMO00-ASDT00)/8
HIMO1    EQU      (HIMO01-ASDT00)/8
HIMO2    EQU      (HIMO02-ASDT00)/8
HIMO3    EQU      (HIMO03-ASDT00)/8
KEBL0    EQU      (KEBUL0-ASDT00)/8
KEBL1    EQU      (KEBUL1-ASDT00)/8
KEBL2    EQU      (KEBUL2-ASDT00)/8
KEBL3    EQU      (KEBUL3-ASDT00)/8
KEBL4    EQU      (KEBUL4-ASDT00)/8
KEBL5    EQU      (KEBUL5-ASDT00)/8
KEBL6    EQU      (KEBUL6-ASDT00)/8
KEBL7    EQU      (KEBUL7-ASDT00)/8
KBEND    EQU      (KBLEND-ASDT00)/8
GHAS3    EQU      (GHASI3-ASDT00)/8
BKBT0    EQU      (BKBOT0-ASDT00)/8
CKRK0    EQU      (CKROK0-ASDT00)/8
CKRK1    EQU      (CKROK1-ASDT00)/8
CKRK2    EQU      (CKROK2-ASDT00)/8
MIZ35    EQU      (MIZU35-ASDT00)/8
MIZ36    EQU      (MIZU36-ASDT00)/8
MIZ37    EQU      (MIZU37-ASDT00)/8
MIZ38    EQU      (MIZU38-ASDT00)/8
MIZ39    EQU      (MIZU39-ASDT00)/8
TAKI0    EQU      (TAKI00-ASDT00)/8
TAKI1    EQU      (TAKI01-ASDT00)/8
;
RENG0    EQU      (RENGA0-ASDT00)/8
GHAS2    EQU      (GHASI2-ASDT00)/8
BKBT1    EQU      (BKBOT1-ASDT00)/8
SPACE    EQU      (SPACE0-ASDT00)/8
KURA0    EQU      (KURAG0-ASDT00)/8
;
;
DOOR2	EQU	(DOOR2D-ASDT00)/8
MIZNK	EQU	(MIZUNK-ASDT00)/8
ENHL6	EQU	(ENHIL6-ASDT00)/8
ENHL7	EQU	(ENHIL7-ASDT00)/8
ENHL8	EQU	(ENHIL8-ASDT00)/8
ENHL9	EQU	(ENHIL9-ASDT00)/8
ENHLA	EQU	(ENHILA-ASDT00)/8
ENHLB	EQU	(ENHILB-ASDT00)/8
ENHLC	EQU	(ENHILC-ASDT00)/8
ENHLD	EQU	(ENHILD-ASDT00)/8
ENHLE	EQU	(ENHILE-ASDT00)/8
ENHLF	EQU	(ENHILF-ASDT00)/8
;
ALLCRS6  EQU      $ 
         BYTE     AKUM3 
         BYTE     MARU0 
         BYTE     AHIL0 
         BYTE     RENG0 
; 
         BYTE     NSJMP 
         BYTE     MARU0 
         BYTE     IBLK5 
         BYTE     RENG0 
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
;x       JSR      DTRMST6   (data buffer clear sub)   x 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
DTRMST6  EQU      $ 
         LDX      #00H
; 
DM6050   EQU      $ 
         LDA      #ABAC0
         JSL      >BUFFCLR1
         LDA      #ACATN
         JSL      >BUFFCLR 
         CPX      #010H 
         BNE      DM6050
; 
DM6070   EQU      $ 
         LDA      #ABAC0
         JSL      >BUFFCLR1
         JSL      >BUFFCLR 
         CPX      #0F0H 
         BNE      DM6070
;
;;;;DM6100   EQU      $ 
;;;;         LDA      #ASYK0
;;;;         JSR      BUFFCLR1
;;;;         LDA      #ABAC0
;;;;         JSR      BUFFCLR 
;;;;         CPY      #0D0H 
;;;;         BNE      DM6100
;;;;; 
;;;;DM6150   EQU      $ 
;;;;         LDA      #ASYK1
;;;;         JSR      BUFFCLR1
;;;;         LDA      #ABAC0
;;;;         JSR      BUFFCLR 
;;;;         CPY      #0F0H 
;;;;         BNE      DM6150
;;;;; 
         JSL      >DATASET 
	 RTL
; 
;=====================================================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
;x       JSR      KAH6SET                             x 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
POIND    EQU      $ 
         HEX      00,0F,1E,2D,3C,4B,5A,69 
; 
KAH6SET  EQU      $ 
         LDA      <WORKE 
         AND      #11100000B
         LSR      A 
         LSR      A 
         LSR      A 
         LSR      A 
         LSR      A 
         TAX
; 
         LDA      !UNITFG 
         LSR      A 
         LSR      A 
         LSR      A 
         LSR      A 
         CLC
         ADC      >POIND,X 
         TAX
         DEX
         TXA
         JSL      >JSRSUBL
KAH601   LWORD     MAR0SET              ; asultic maruta 1 data set
KAH602   LWORD     MAR1SET              ; asultic maruta 2 data set
KAH603   LWORD     MAR1SET              ; asultic maruta 2 data set
KAH604   LWORD     IWA0SET              ; asultic iwa 1 data set 
KAH605   LWORD     IWA1SET              ; asultic iwa 2 data set 
KAH606   LWORD     HILLSET              ; asultic oka data set 
KAH607   LWORD     HILLSET              ; Ice oka data set 
KAH608   LWORD     KEB0SET              ; asultic elveter kebul yoko data set
KAH609   LWORD     KEB1SET              ; asultic elveter kebul tate data set
KAH60A   LWORD     KEB2SET              ; asultic elveter kebul left up data set 
KAH60B   LWORD     KEB3SET              ; asultic elveter kebul rigth up data set
KAH60C   LWORD     KUMOSET              ; Ice kumo data set
KAH60D   LWORD     KEB4SET              ; asultic elveter kebul left up 67.5 data set
KAH60E   LWORD     KEB5SET              ; asultic elveter kebul rigth up 67.5 data set 
KAH60F   LWORD     NKM0SET              ; asultic noreru kumo data set 
KAH611   LWORD     HAT2SET              ; kowareru block data set
KAH612   LWORD     HAT2SET              ; hatena coin block data set 
KAH613   LWORD     HAT2SET              ; kowareru coin block data set 
KAH614   LWORD     HAT2SET              ; kowarenai block data set 
KAH615   LWORD     HAT2SET              ; all cross jump dai data set
KAH616   LWORD     HAT2SET              ; up & down cross jump dai data set
KAH617   LWORD     HAT2SET              ; left & rigth jump dai data set 
KAH618   LWORD     HAT2SET              ; coin data set
KAH619   LWORD     BDK0SET              ; bill dokan up data set 
KAH61A   LWORD     BDK0SET              ; bill hairenai dokan up data set
KAH61B   LWORD     BDK0SET              ; bill one display dokan up data set 
KAH61C   LWORD     BDK1SET              ; bill dokan down data set 
KAH61D   LWORD     BDK1SET              ; bill hairenai dokan down data set
KAH61E   LWORD     DKY0SET              ; dokan yoko left hairenai data set
KAH61F   LWORD     DKY0SET              ; dokan yoko left haireru data set 
KAH621   LWORD     DKY1SET              ; dokan yoko rigth hairenai data set 
KAH622   LWORD     DKY1SET              ; dokan yoko rigth haireru data set
KAH623   LWORD     TAIHSET              ; taiho data set 
KAH624   LWORD     HASISET              ; hashi data set 
KAH625   LWORD     HASISET              ; yureru hashi data set
KAH626   LWORD     HAT3SET              ; taki data set
KAH627   LWORD     HAT3SET              ; left nagareru kawa data set
KAH628   LWORD     HAT3SET              ; nagarenai kawa data set
KAH629   LWORD     HAT3SET              ; rigth nagareru kawa data set 
KAH62A   LWORD     HAT3SET              ; chika iwa data set 
KAH62B   LWORD     HAT3SET              ; chika renga data set 
KAH62C   LWORD     HAT3SET              ; sabaku data set
KAH62D   LWORD     HAT3SET              ; ryusa data set 
KAH62E   LWORD     KORASET              ; koura data set 
KAH62F   LWORD     BDK2SET              ; dokan tate scroll data set 
KAH631   LWORD     ICE0SET              ; Ice block 1 data set 
KAH632   LWORD     ICE0SET              ; Ice pakkun data set
KAH633   LWORD     ICE0SET              ; Ice coin data set
KAH634   LWORD     CIKUSET              ; chikuwa data set 
KAH635   LWORD     VELCSET              ; veltconver 0 data set
KAH636   LWORD     VELCSET              ; veltconver 1 data set
KAH637   LWORD     KURGSET              ; kurage data set
KAH638   LWORD     ICE1SET              ; Ice block 2 data set 
KAH639   LWORD     NKUMSET              ; noreru kumo data set 
KAH63A   LWORD     PKBKSET              ; noreru packn block data set
KAH63B	 LWORD	   ICEYUK		; ice yu-ka set ;KK;
;
VMARU0   EQU      (KAH601-KAH601)/3*010H+010H 
VMARU1   EQU      (KAH602-KAH601)/3*010H+010H 
VMARU2   EQU      (KAH603-KAH601)/3*010H+010H 
VAIWA0   EQU      (KAH604-KAH601)/3*010H+010H 
VAIWA1   EQU      (KAH605-KAH601)/3*010H+010H 
VHILL0   EQU      (KAH606-KAH601)/3*010H+010H 
VHILL1   EQU      (KAH607-KAH601)/3*010H+010H 
VKEBL0   EQU      (KAH608-KAH601)/3*010H+010H 
VKEBL1   EQU      (KAH609-KAH601)/3*010H+010H 
VKEBL2   EQU      (KAH60A-KAH601)/3*010H+010H 
VKEBL3   EQU      (KAH60B-KAH601)/3*010H+010H 
VIKUMO   EQU      (KAH60C-KAH601)/3*010H+010H 
VKEBL4   EQU      (KAH60D-KAH601)/3*010H+010H 
VKEBL5   EQU      (KAH60E-KAH601)/3*010H+010H 
VNKUMO   EQU      (KAH60F-KAH601)/3*010H+010H 
; 
VBBLK0   EQU      (KAH611-KAH611)/3*010H+010H 
VCNQST   EQU      (KAH612-KAH611)/3*010H+010H 
VCNBLK   EQU      (KAH613-KAH611)/3*010H+010H 
VBBLK1   EQU      (KAH614-KAH611)/3*010H+010H 
VHZJP0   EQU      (KAH615-KAH611)/3*010H+010H 
VHZJP1   EQU      (KAH616-KAH611)/3*010H+010H 
VHZJP2   EQU      (KAH617-KAH611)/3*010H+010H 
VGCOIN   EQU      (KAH618-KAH611)/3*010H+010H 
VBLDK0   EQU      (KAH619-KAH611)/3*010H+010H 
VBLDK3   EQU      (KAH61A-KAH611)/3*010H+010H 
VBLDK2   EQU      (KAH61B-KAH611)/3*010H+010H 
VBLDK1   EQU      (KAH61C-KAH611)/3*010H+010H 
VBLDK4   EQU      (KAH61D-KAH611)/3*010H+010H 
VDOKY0   EQU      (KAH61E-KAH611)/3*010H+010H 
VDOKY1   EQU      (KAH61F-KAH611)/3*010H+010H 
; 
VDOKY2   EQU      (KAH621-KAH621)/3*010H+010H 
VDOKY3   EQU      (KAH622-KAH621)/3*010H+010H 
VTAIHO   EQU      (KAH623-KAH621)/3*010H+010H 
VHASI0   EQU      (KAH624-KAH621)/3*010H+010H 
VHASI1   EQU      (KAH625-KAH621)/3*010H+010H 
VTAKI0   EQU      (KAH626-KAH621)/3*010H+010H 
VREVR0   EQU      (KAH627-KAH621)/3*010H+010H 
VREVR1   EQU      (KAH628-KAH621)/3*010H+010H 
VREVR2   EQU      (KAH629-KAH621)/3*010H+010H 
VCKROK   EQU      (KAH62A-KAH621)/3*010H+010H 
VCKREN   EQU      (KAH62B-KAH621)/3*010H+010H 
VSABA0   EQU      (KAH62C-KAH621)/3*010H+010H 
VSABA1   EQU      (KAH62D-KAH621)/3*010H+010H 
VKORA0   EQU      (KAH62E-KAH621)/3*010H+010H 
VBLDKT   EQU      (KAH62F-KAH621)/3*010H+010H 
; 
VICEB0   EQU      (KAH631-KAH631)/3*010H+010H 
VIBKPK   EQU      (KAH632-KAH631)/3*010H+010H 
VIBKCN   EQU      (KAH633-KAH631)/3*010H+010H 
VMARU3   EQU      (KAH634-KAH631)/3*010H+010H 
VVELC0   EQU      (KAH635-KAH631)/3*010H+010H 
VVELC1   EQU      (KAH636-KAH631)/3*010H+010H 
VKURAG   EQU      (KAH637-KAH631)/3*010H+010H 
VICEB1   EQU      (KAH638-KAH631)/3*010H+010H 
VNKUM0   EQU      (KAH639-KAH631)/3*010H+010H 
VPACKN   EQU      (KAH63A-KAH631)/3*010H+010H 
VICEYK   EQU      (KAH63B-KAH631)/3*010H+010H 
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
;x       JSR      KOT6SET                             x 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
KOT6SET  EQU      $ 
         LDA      <WORKE 
         AND      #11100000B
         LSR      A 
         CLC
         ADC      !UNITFG 
         TAX
         JSL      >JSRSUBL
KOT600   LWORD     KUM0SET              ; asultic kumo 1 data set
KOT601   LWORD     KUM1SET              ; asultic kumo 2 data set
KOT602   LWORD     HIM0SET              ; asultic himo 1 data set
KOT603   LWORD     HIM1SET              ; asultic himo 2 data set
KOT604   LWORD     ASHRSET              ; asultic hashira data set 
KOT605   LWORD     DOR2SET              ; asultic door data set
KOT606   LWORD     IMOYSET              ; Ice moyoh data set 
KOT607   LWORD     IMOYSET              ; kebul end data set 
KOT608   LWORD     000000H                ;
KOT609   LWORD     000000H                ;
KOT60A   LWORD     000000H                ;
KOT60B   LWORD     000000H                ;
KOT60C   LWORD     000000H                ;
KOT60D   LWORD     000000H                ;
KOT60E   LWORD     000000H                ;
KOT60F   LWORD     000000H                ;
KOT610   LWORD     HAT1SET              ; hatena kinoko block data set 
KOT611   LWORD     HAT1SET              ; hatena hana block data set 
KOT612   LWORD     HAT1SET              ; hatena hoshi block data set
KOT613   LWORD     HAT1SET              ; hatena coin & hoshi block data set 
KOT614   LWORD     HAT1SET              ; hatena ten coin block data set 
KOT615   LWORD     HAT1SET              ; hatena enmey block data set
KOT616   LWORD     HAT1SET              ; wareru kinoko block data set 
KOT617   LWORD     HAT1SET              ; wareru hana block data set 
KOT618   LWORD     HAT1SET              ; wareru hoshi block data set
KOT619   LWORD     HAT1SET              ; wareru coin & hoshi block data set 
KOT61A   LWORD     HAT1SET              ; wareru ten coin block data set 
KOT61B   LWORD     HAT1SET              ; wareru 1 up block data set 
KOT61C   LWORD     HAT1SET              ; wareru rop block data set
KOT61D   LWORD     HAT1SET              ; wareru enmey block data set
KOT61E   LWORD     HAT1SET              ; tohmei coin block data set 
KOT61F   LWORD     HAT1SET              ; tohmei 1 up block data set 
KOT620   LWORD     HAT1SET              ; tohmei jump dai block data set 
KOT621   LWORD     HAT1SET              ; up & down jump dai kinoko data set 
KOT622   LWORD     HAT1SET              ; up & down jump dai hana data set 
KOT623   LWORD     HAT1SET              ; up & down jump dai star data set 
KOT624   LWORD     HAT1SET              ; left & rigth jump dai kinoko data set
KOT625   LWORD     HAT1SET              ; left & rigth jump dai hana data set
KOT626   LWORD     HAT1SET              ; left & rigth jump dai star data set
KOT627   LWORD     HAT1SET              ; bill spaer jmup dai data set 
KOT628   LWORD     HAT1SET              ; bill bakdan swichi data set
KOT629   LWORD     BETASET              ; bill blak beta data set
; 
FASKM0   EQU      (KOT600-KOT600)/3 
FASKM1   EQU      (KOT601-KOT600)/3 
FHIMO0   EQU      (KOT602-KOT600)/3 
FHIMO1   EQU      (KOT603-KOT600)/3 
FASHSR   EQU      (KOT604-KOT600)/3 
FADOR0   EQU      (KOT605-KOT600)/3 
FICEMY   EQU      (KOT606-KOT600)/3 
FKBEND   EQU      (KOT607-KOT600)/3 
; 
FKNQST   EQU      (KOT610-KOT610)/3 
FHNQST   EQU      (KOT611-KOT610)/3 
FHSQST   EQU      (KOT612-KOT610)/3 
FHCQST   EQU      (KOT613-KOT610)/3 
FTCQST   EQU      (KOT614-KOT610)/3 
FENQST   EQU      (KOT615-KOT610)/3 
FKNBLK   EQU      (KOT616-KOT610)/3 
FHNBLK   EQU      (KOT617-KOT610)/3 
FHSBLK   EQU      (KOT618-KOT610)/3 
FHCBLK   EQU      (KOT619-KOT610)/3 
FTCBLK   EQU      (KOT61A-KOT610)/3 
FUPBLK   EQU      (KOT61B-KOT610)/3 
FRPBLK   EQU      (KOT61C-KOT610)/3 
FENBLK   EQU      (KOT61D-KOT610)/3 
FCNTOM   EQU      (KOT61E-KOT610)/3 
FUPTOM   EQU      (KOT61F-KOT610)/3 
; 
FJPTOM   EQU      (KOT620-KOT620)/3 
FKNJMP   EQU      (KOT621-KOT620)/3 
FHNJMP   EQU      (KOT622-KOT620)/3 
FHSJMP   EQU      (KOT623-KOT620)/3 
FKNJMY   EQU      (KOT624-KOT620)/3 
FHNJMY   EQU      (KOT625-KOT620)/3 
FHSJMY   EQU      (KOT626-KOT620)/3 
FSPJP0   EQU      (KOT627-KOT620)/3 
FBOTAN   EQU      (KOT628-KOT620)/3 
FBLBET   EQU      (KOT629-KOT620)/3 
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      IMOYSET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
IMOYD    EQU      $ 
         BYTE     IBLK5,KBEND 
; 
IMOYSET  EQU      $ 
         LDA      !UNITFG 
         SEC
         SBC      #FICEMY 
         TAX
         LDY      !XYPSFG 
;
         LDA      >IMOYD,X
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
         RTL
; 
;======= asultic unit-no. buffer data set sub ========================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      MAR0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MAR0SET  EQU      $ 
         JSR      FORDATA 
; 
;;;;         LDY      #00H
;;;;         LDA      [DATANO],Y
;;;;         TAX
;;;;         LDA      DATANO
;;;;         CLC
;;;;         ADC      #01H
;;;;         STA      DATANO
;;;;         LDA      DATANO+1
;;;;         ADC      #00H
;;;;         STA      DATANO+1
;;;;; 
;;;;         LDA      >UNITFG 
;;;;         AND      #00001111B
;;;;         TAX
         LDY      !XYPSFG 
; 
         LDA      #MARU0
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         BRA      MR0100
; 
MR0050   EQU      $ 
         LDA      #MARU1
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
MR0100   EQU      $ 
         JSL      >YPINCST 
; 
MR0150   EQU      $ 
         DEX
         BNE      MR0050
; 
         LDA      #MARU2
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
         RTL
;
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      MAR1SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MARUTD0  EQU      $ 
         BYTE     MARU3,MARU6,IHIL6,MARU6 
; 
MARUTD1  EQU      $ 
         BYTE     MARU4,MARU7,IHIL7,MARU9 
; 
MARUTD2  EQU      $ 
         BYTE     MARU5,MARU8,IHIL8,MARUA 
; 
;======= Program =====================================================
MAR1SET  EQU      $ 
         LDA      <BUFFNO
         STA      <WORK0 
         LDA      <BUFFNO+1
         STA      <WORK1 
; 
         LDX      #00H
         LDA      !UNITFG 
         AND      #11110000B
         CMP      #VMARU1 
         BEQ      MR1050
; 
         LDX      #02H
; 
MR1050   EQU      $ 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
         LDY      !XYPSFG 
;
         LDA      >MARUTD0,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         BRA      MR1150
; 
MR1100   EQU      $
         LDA      >MARUTD1,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
MR1150   EQU      $ 
         JSL      >YPINCST 
; 
MR1200   EQU      $ 
         DEC      <WORK2 
         BNE      MR1100
; 
         LDA      >MARUTD2,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
         LDA      !XYPSFG 
         CLC
         ADC      #010H 
         STA      !XYPSFG 
; 
         LDA      <WORK1 
         ADC      #00H
         STA      <BUFFNO+1
; 
         LDA      <WORK0 
         STA      <BUFFNO
; 
         INX
         TXA
         AND      #00000001B
         BNE      MR1050
; 
         RTL
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      IWA0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
IWA0SET  EQU      $ 
         LDA      <BUFFNO
         STA      <WORK0 
         LDA      <BUFFNO+1
         STA      <WORK1 
; 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
         TAX
         LDY      !XYPSFG 
; 
IW0050   EQU      $ 
         LDA      #AIWA0
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         JSL      >YPINCST 
; 
         DEX
         BPL      IW0050
; 
         LDA      !PLMNFG 
         CMP      #ICGM 
         BNE      IW0150
; 
         JSR      ADDRESS 
; 
;;;;         LDA      WORK0 
;;;;         STA      BUFFNO
;;;;         LDA      WORK1 
;;;;         STA      BUFFNO+1
;;;;         LDA      >XYPSFG 
;;;;         CLC
;;;;         ADC      #010H 
;;;;         STA      >XYPSFG 
;;;;         TAY
;;;;; 
;;;;         LDA      BUFFNO+1
;;;;         ADC      #00H
;;;;         STA      BUFFNO+1
;;;;         STA      WORK1 
         LDX      <WORK2 
; 
IW0100   EQU      $ 
         LDA      #IHIL9
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         JSL      >YPINCST 
         DEX
         BPL      IW0100
; 
IW0150   EQU      $ 
         RTL
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      IWA1SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
IWA1SET  EQU      $ 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
; 
         LDY      !XYPSFG 
; 
         LDA      #AIWA1
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         BRA      IWA150
; 
IWA100   EQU      $ 
         LDA      #AIWA2
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
IWA150   EQU      $ 
         JSL      >YPINCST 
; 
IWA200   EQU      $ 
         DEC      <WORK2 
         BNE      IWA100
; 
         LDA      #AIWA3
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
         RTL
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      HILLSET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
HILLDT0  EQU      $ 
         BYTE     AHIL0,AHIL3,IHIL0,IHIL3 
; 
HILLDT1  EQU      $ 
         BYTE     AHIL1,AHIL4,IHIL1,IHIL4 
; 
HILLDT2  EQU      $ 
         BYTE     AHIL2,AHIL5,IHIL2,IHIL5 
; 
;======= Program =====================================================
HILLSET  EQU      $ 
         LDA      <BUFFNO
         STA      <WORK0 
         LDA      <BUFFNO+1
         STA      <WORK1 
; 
         LDX      #00H
         LDA      !UNITFG 
         AND      #11110000B
         CMP      #VHILL0 
         BEQ      HLT050
; 
         LDX      #02H
; 
HLT050   EQU      $ 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
         LDY      !XYPSFG 
; 
;;K;;         LDA      (<BUFFNO),Y
	LDA	[<BUFFNO],Y
;;;;         CMP      #ASYK0
;;;;         BEQ      HLT060
;;;;; 
;;;;         CMP      #ASYK1
;;;;         BEQ      HLT060
;;;;; 
         CMP      #ABAC0
         BNE      HLT250
; 
;;;;HLT060   EQU      $
		LDA	>HILLDT0,X
		STA	[<BUFFNO],Y
		BRA	HLT150
;
HLT100		EQU	$
		LDA	>HILLDT1,X
		STA	[<BUFFNO],Y
;
HLT150		EQU	$
		JSL	>YPINCST 
;
HLT200		EQU	$
		DEC	<WORK2
		BNE	HLT100
;
		CPX	#002H
		BNE	HLT210
		LDA	[<BUFFNO],Y
		CMP	#ABAC0
		BEQ	HLT210
		LDA	#IHIL9
		BRA	HLT215
;
HLT210		EQU	$
		LDA	>HILLDT2,X
;
HLT215		EQU	$
		STA	[<BUFFNO],Y
;
		JSR	ADDRESS
;
;;;;         LDA      WORK0 
;;;;         STA      BUFFNO
;;;;         LDA      WORK1 
;;;;         STA      BUFFNO+1
;;;;; 
;;;;         LDA      >XYPSFG 
;;;;         CLC
;;;;         ADC      #010H 
;;;;         STA      >XYPSFG 
;;;;; 
;;;;         LDA      BUFFNO+1
;;;;         ADC      #00H
;;;;         STA      BUFFNO+1
;;;;         STA      WORK1 
;
		TXA
		ORA	#01H
		TAX
		BRA	HLT050
;
HLT250		EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      NKM0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
NKUMD1   EQU      $ 
         BYTE     AKUM0,AKUM3 
; 
NKUMD2   EQU      $ 
         BYTE     AKUM1,AKUM4 
; 
NKUMD3   EQU      $ 
         BYTE     AKUM2,AKUM5 
;
NKM0SET		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
		LDA	<BUFFNO
		STA	<WORK0
		MEM8
		SEP	#00100000B	; memory 8bit mode
;;K;;         LDA      <BUFFNO
;;K;;         STA      <WORK0 
;;K;;         LDA      <BUFFNO+1
;;K;;         STA      <WORK1 
;
		LDA	!UNITFG
		AND	#00001111B
		STA	<WORK2
		LDY	!XYPSFG
		LDX	#00H
;
NKM050		EQU	$
		LDA	<WORK2
		STA	<WORK3
;
		LDA	>NKUMD1,X
		STA	[<BUFFNO],Y
		BRA	NKM150
;
NKM100		EQU	$
		LDA	>NKUMD2,X
		STA	[<BUFFNO],Y
;
NKM150		EQU	$
		JSL	>YPINCST 
		DEC	<WORK3
		BNE	NKM100
;
		LDA	>NKUMD3,X
		STA	[<BUFFNO],Y
;
		JSR	ADDRESS
;
;;;;         LDA      WORK0 
;;;;         STA      BUFFNO
;;;;         LDA      WORK1 
;;;;         STA      BUFFNO+1
;;;;; 
;;;;         LDA      >XYPSFG 
;;;;         CLC
;;;;         ADC      #010H 
;;;;         STA      >XYPSFG 
;;;;         TAY
;;;;         LDA      BUFFNO+1
;;;;         ADC      #00H
;;;;         STA      BUFFNO+1
;;;;         STA      WORK1 
;;;;; 
		INX
		CPX	#02H
		BNE	NKM050
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      ICE0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ICED0    EQU      $ 
         BYTE     IBLK4,IBKPK,IBKCN 
; 
ICE0SET  EQU      $ 
         LDA      !UNITFG 
         PHA
         SEC
         SBC      #VICEB0 
         LSR      A 
         LSR      A 
         LSR      A 
         LSR      A 
         TAX
         PLA
         AND      #00001111B
         STA      <WORK2 
         LDY      !XYPSFG 
; 
I0T050   EQU      $
         LDA      >ICED0,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         JSL      >YPINCST 
         DEC      <WORK2 
         BPL      I0T050
; 
         RTL
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      ICE1SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ICED1    EQU      $ 
         BYTE     IBLK0,IBLK2 
; 
ICED2    EQU      $ 
         BYTE     IBLK1,IBLK3 
; 
ICE1SET  EQU      $ 
         LDA      <BUFFNO
         STA      <WORK0 
         LDA      <BUFFNO+1
         STA      <WORK1 
; 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
         LDY      !XYPSFG 
         LDX      #00H
; 
I1T050   EQU      $ 
         LDA      <WORK2 
         STA      <WORK3 
; 
I1T100   EQU      $
         LDA      >ICED1,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         JSL      >YPINCST 
         LDA      >ICED2,X 
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         JSL      >YPINCST 
; 
         DEC      <WORK3 
         BPL      I1T100
; 
         JSR      ADDRESS 
; 
;;;;         LDA      WORK0 
;;;;         STA      BUFFNO
;;;;         LDA      WORK1 
;;;;         STA      BUFFNO+1
;;;;; 
;;;;         LDA      >XYPSFG 
;;;;         CLC
;;;;         ADC      #010H 
;;;;         STA      >XYPSFG 
;;;;         TAY
;;;;         LDA      BUFFNO+1
;;;;         ADC      #00H
;;;;         STA      BUFFNO+1
;;;;         STA      WORK1 
;;;;; 
         INX
         CPX      #02H
         BNE      I1T050
; 
         RTL
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      KUMOSET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KUMOD1   EQU      $ 
         BYTE     IKUM0,IKUM3 
; 
KUMOD2   EQU      $ 
         BYTE     IKUM1,IKUM4 
; 
KUMOD3   EQU      $ 
         BYTE     IKUM2,IKUM5 
; 
KUMOSET  EQU      $ 
         LDA      <BUFFNO
         STA      <WORK0 
         LDA      <BUFFNO+1
         STA      <WORK1 
; 
         LDA      !UNITFG 
         AND      #00001111B
         STA      <WORK2 
         LDY      !XYPSFG 
         LDX      #00H
; 
KOT050   EQU      $ 
         LDA      <WORK2 
         STA      <WORK3 
;
         LDA      >KUMOD1,X
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
         BRA      KOT150
; 
KOT100   EQU      $
         LDA      >KUMOD2,X
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
KOT150   EQU      $ 
         JSL      >YPINCST 
         DEC      <WORK3 
         BNE      KOT100
; 
         LDA      >KUMOD3,X
;;K;;         STA      (<BUFFNO),Y
	STA	[<BUFFNO],Y
; 
         JSR      ADDRESS 
; 
;;;;         LDA      WORK0 
;;;;         STA      BUFFNO
;;;;         LDA      WORK1 
;;;;         STA      BUFFNO+1
;;;;; 
;;;;         LDA      >XYPSFG 
;;;;         CLC
;;;;         ADC      #010H 
;;;;         STA      >XYPSFG 
;;;;         TAY
;;;;         LDA      BUFFNO+1
;;;;         ADC      #00H
;;;;         STA      BUFFNO+1
;;;;         STA      WORK1 
;;;;; 
         INX
         CPX      #02H
         BNE      KOT050
; 
         RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      KUM0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KUM0SET		EQU	$
;;K;;		LDY	!XYPSFG
;;K;;;
;;K;;		LDA	#AKUM8
;;K;;		STA	[<BUFFNO],Y
;;K;;;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      KUM1SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KUM1SET		EQU	$
;;K;;		LDY	!XYPSFG
;;K;;;
;;K;;		LDA	#AKUM6
;;K;;		STA	[<BUFFNO],Y
;;K;;		JSL	>YPINCST
;;K;;;
;;K;;KUM050		EQU	$
;;K;;		LDA	#AKUM7
;;K;;		STA	[<BUFFNO],Y
;;K;;;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      HIM0SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
HIM0SET		EQU	$
		LDX	#00H
		BRA	HIM050
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      HIM1SET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
HIMODT0  EQU      $ 
         BYTE     HIMO1,HIMO3 
; 
HIMODT1  EQU      $ 
         BYTE     HIMO0,HIMO2 
; 
;======= Program =====================================================
HIM1SET		EQU	$
		LDX	#01H
;
HIM050		EQU	$
		LDY	!XYPSFG
;
		LDA	>HIMODT0,X
		STA	[<BUFFNO],Y
		BRA	HIM150
;
HIM100		EQU	$
		LDA	[<BUFFNO],Y
		CMP	#ABAC0
		BNE	HIM200
;
		LDA	>HIMODT1,X 
		STA	[<BUFFNO],Y
;
HIM150		EQU	$
		TYA
		SEC
		SBC	#010H
		TAY
;
		LDA	<BUFFNO+1
		SBC	#00H
		STA	<BUFFNO+1
;
		BRA	HIM100
;
HIM200		EQU	$
		LDA	>HIMODT1,X 
		STA	[<BUFFNO],Y
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      ASHRSET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ASHRSET		EQU	$
		LDY	!XYPSFG
;
ART050		EQU	$
		LDA	[<BUFFNO],Y
;;;;         CMP      #ASYK0
;;;;         BEQ      ART060
;;;;; 
;;;;         CMP      #ASYK1
;;;;         BEQ      ART060
;;;;;
		CMP	#ABAC0
		BNE	ART100
;
;;;;ART060   EQU      $
		LDA	#AHASR
		STA	[<BUFFNO],Y
		TYA
		CLC
		ADC	#010H
		TAY
;
		LDA	<BUFFNO+1
		ADC	#00H
		STA	<BUFFNO+1
;
		BRA	ART050
;
ART100		EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      PKBKSET                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PKBKSET  EQU      $ 
         JSR      FORDATA 
;
         LDY      !XYPSFG 
; 
PKT050		EQU	$
		LDA	#ENQST
		STA	[<BUFFNO],Y
		JSL	>YPINCST 
		DEX
		CPX	#0FFH
		BNE	PKT050
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      FORDATA                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
FORDATA		EQU	$
		LDY	#00H
		LDA	[<DATANO],Y
		TAX
		MEM16
		REP	#00100000B	; memory 16bit mode
		INC	<DATANO
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTS
;
;;K;;         LDA      <DATANO
;;K;;         CLC
;;K;;         ADC      #01H
;;K;;         STA      <DATANO
;;K;;         LDA      <DATANO+1
;;K;;         ADC      #00H
;;K;;         STA      <DATANO+1
;
;;K;;         RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x       JSR      ADDRESS                                            x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ADDRESS		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
		LDA	<WORK0
		STA	<BUFFNO
		MEM8
		SEP	#00100000B	; memory 8bit mode
;;K;;         LDA      <WORK0 
;;K;;         STA      <BUFFNO
;;K;;         LDA      <WORK1 
;;K;;         STA      <BUFFNO+1
;
         LDA      !XYPSFG 
         CLC
         ADC      #010H 
         STA      !XYPSFG 
         TAY
; 
         LDA      <BUFFNO+1
         ADC      #00H
         STA      <BUFFNO+1
         STA      <WORK1 
; 
         RTS
; 
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x                BG data                                            x
;x                                                                   x
;x       BYTE     00000000B,00000000B                                x
;x                |~|||~~|     |||~|                                 x
;x                 | |  |       | |_ BG color no. 0 ~ 111            x
;x                 | |  |       |___ OBJ color no. 0 ~ 11            x
;x                 | |  |                                            x
;x                 | |  |                                            x
;x                 | |  |                                            x
;x                 | |  |                                            x
;x                 | |  |___________ display no. data 0 ~ 1111       x
;x                 | |______________ player jyoutai bit 0 or 1       x
;x                 |________________ player Y-position 0 ~ 111       x
;x                                                                   x
;x                                                                   x
;x                    Y      X                                       x
;x       BYTE     00000000B,000H,+000H                         x
;x                |~||~~~|   ||  |~~~~|   |__ data counter 0 ~ F     x
;x                 |   |     ||    |_________ BG data set no.        x
;x                 |   |     ||                                      x
;x                 |   |     ||______________ X-position             x
;x                 |   |     |_______________ display no.            x
;x                 |   |                                             x
;x                 |   |_____________________ Y-position             x
;x                 |_________________________ BG data set no. chenge x
;x                                                                   x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;=====================================================================
;***** 7/25       **********
; 
B300     EQU      $ 
; 
         LWORD     B301        ; BG dtaa address 
         LWORD     E301        ; Enmy data address 
;
         BYTE     01100111B,10011000B,11000100B,00000100B,00001000B,01110001B
	 BYTE	  01EH
; 
         BYTE     00000000B+015H,000H,FHIMO0
         BYTE     00000000B+015H,007H,FHIMO1
         BYTE     00000000B+016H,000H,VMARU0+000H,007H
;;K;;         BYTE     00000000B+011H,002H,FASKM1
         BYTE     00000000B+015H,002H,VAIWA0+003H 
         BYTE     00000000B+017H,00DH,VKEBL3+000H 
         BYTE     00000000B+015H,00CH,VKEBL2+001H 
         BYTE     00000000B+014H,00CH,VKEBL3+001H 
         BYTE     00000000B+011H,00CH,VKEBL2+001H 
         BYTE     00000000B+010H,00BH,FKBEND
         BYTE     00000000B+018H,00CH,FKBEND
;;K;;         BYTE     00000000B+012H,00EH,FASKM1
; 
         BYTE     00000000B+017H,011H,VKEBL3+001H 
         BYTE     00000000B+014H,011H,VKEBL2+001H 
         BYTE     00000000B+013H,011H,VKEBL3+000H 
         BYTE     00000000B+012H,012H,FKBEND
         BYTE     00000000B+018H,010H,FKBEND
         BYTE     00000000B+016H,015H,FHIMO0
         BYTE     00000000B+016H,019H,FHIMO1
         BYTE     00000000B+017H,015H,VMARU0+000H,004H
         BYTE     01100000B+013H,016H,VMARU3+004H 
         BYTE     00100000B+013H,019H,FKNQST
;;K;;         BYTE     00000000B+011H,01EH,FASKM1
; 
         BYTE     00100000B+012H,021H,VBBLK1+000H 
         BYTE     01000000B+013H,021H,FHSJMY
         BYTE     00100000B+014H,021H,VBBLK1+004H 
         BYTE     00000000B+013H,023H,VAIWA0+001H 
;;K;;         BYTE     00000000B+010H,026H,FASKM1
         BYTE     00100000B+014H,028H,VGCOIN+002H 
         BYTE     00100000B+012H,02CH,VGCOIN+002H 
         BYTE     00100000B+014H,02DH,VCNQST+000H 
; 
         BYTE     00100000B+014H,031H,VGCOIN+002H 
;;K;;         BYTE     00000000B+012H,036H,FASKM1
;;K;;         BYTE     00000000B+014H,03BH,FASKM0
;;K;;         BYTE     00000000B+010H,03CH,FASKM1
         BYTE     00100000B+015H,036H,FHCQST
; 
         BYTE     00100000B+012H,040H,VGCOIN+002H 
;;K;;         BYTE     00000000B+012H,046H,FASKM1
         BYTE     01100000B+016H,04EH,VMARU3+001H 
         BYTE     00100000B+013H,04FH,FHCQST
; 
         BYTE     00100000B+014H,052H,VGCOIN+002H 
         BYTE     00100000B+018H,051H,VBBLK1+000H 
; 
;;K;;         BYTE     00000000B+013H,064H,FASKM1
;;K;;         BYTE     00000000B+010H,068H,FASKM1
         BYTE     00100000B+013H,06FH,VBBLK0+005H 
; 
         BYTE     00100000B+013H,071H,FENBLK
;;K;;         BYTE     00000000B+010H,076H,FASKM1
         BYTE     00100000B+010H,073H,VGCOIN+002H 
         BYTE     00100000B+013H,07BH,VBLDK0+002H 
         BYTE     00100000B+016H,07BH,VBBLK1+001H 
         BYTE     00100000B+013H,079H,VBBLK0+000H 
         BYTE     00100000B+013H,078H,FUPTOM
         BYTE     00100000B+017H,078H,VGCOIN+002H 
         BYTE     00100000B+013H,07EH,VCNBLK
         BYTE     00100000B+017H,07EH,FKNQST
         BYTE     01000000B+019H,000H,VREVR1+001H,080H
; 
         BYTE     00000000B+016H,01DH,VKEBL2+000H 
         BYTE     00000000B+016H,01EH,VKEBL0+00FH 
         BYTE     00000000B+016H,02EH,VKEBL0+003H 
         BYTE     00000000B+017H,032H,VKEBL2+000H 
         BYTE     00000000B+017H,033H,VKEBL0+006H 
         BYTE     00000000B+017H,03AH,VKEBL3+002H 
         BYTE     00000000B+015H,03DH,VKEBL2+002H 
         BYTE     00000000B+017H,040H,VKEBL3+002H 
         BYTE     00000000B+015H,043H,VKEBL2+002H 
         BYTE     00000000B+017H,046H,VKEBL3+000H 
         BYTE     00000000B+016H,047H,VKEBL0+002H 
         BYTE     00000000B+016H,04AH,VKEBL3+000H 
; 
         BYTE     00000000B+016H,054H,VKEBL2+000H 
         BYTE     00000000B+016H,055H,VKEBL0+00AH 
         BYTE     00000000B+017H,060H,VKEBL2+000H 
         BYTE     00000000B+017H,061H,VKEBL0+003H 
         BYTE     00000000B+017H,065H,VKEBL3+002H 
         BYTE     00000000B+014H,068H,VKEBL0+003H 
         BYTE     00000000B+015H,06CH,VKEBL2+002H 
         BYTE     00000000B+017H,06FH,VKEBL3+000H 
         BYTE     00000000B+016H,070H,VKEBL0+004H 
         BYTE     00000000B+016H,075H,VKEBL3+000H 
; 
         BYTE     11100000B+007H,052H,090H
; 
         BYTE     0FFH
; 
;=====================================================================
;***** 7/25       **********
; 
B301     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     01100010B,10011000B,00000000B,00000100B,00001000B,00000000B
	 BYTE	  016H
; 
         BYTE     00000000B+017H,007H,FHIMO0
         BYTE     00000000B+018H,007H,VMARU0+000H,006H
         BYTE     00100000B+011H,009H,VBBLK1+001H 
         BYTE     00100000B+012H,009H,VBLDK4+003H 
         BYTE     00000000B+017H,00DH,VMARU0+000H,006H
         BYTE     00000000B+016H,00FH,VAIWA0+002H 
         BYTE     00000000B+016H,013H,FHIMO1
         BYTE     00000000B+018H,013H,VMARU0+000H,003H
         BYTE     00000000B+017H,016H,FHIMO1
         BYTE     01000000B+000H,017H,FBLBET
         BYTE     00000000B+01AH,017H,VMARU0+000H,030H
         BYTE     00100000B+00AH,00BH,VGCOIN+004H 
         BYTE     00100000B+006H,00BH,VGCOIN+000H 
         BYTE     00100000B+006H,00FH,VGCOIN+000H 
         BYTE     00100000B+001H,009H,FUPTOM
         BYTE     00000000B+003H,00AH,VKEBL3+000H 
         BYTE     00000000B+002H,00BH,VKEBL0+000H 
         BYTE     00000000B+003H,00CH,VKEBL2+000H 
         BYTE     00000000B+003H,00DH,VKEBL0+000H 
         BYTE     00000000B+003H,00EH,VKEBL3+000H 
         BYTE     00000000B+002H,00FH,VKEBL0+000H 
         BYTE     00000000B+004H,00BH,VKEBL0+000H 
         BYTE     00000000B+004H,00AH,VKEBL2+000H 
         BYTE     00000000B+005H,00CH,VKEBL2+000H 
         BYTE     00000000B+006H,00CH,VKEBL1+002H 
         BYTE     00000000B+008H,00DH,VKEBL3+000H 
         BYTE     00000000B+006H,00DH,VKEBL1+001H 
         BYTE     00000000B+005H,00EH,VKEBL3+000H 
         BYTE     00000000B+004H,00FH,VKEBL0+000H 
         BYTE     00000000B+003H,010H,VKEBL2+000H 
         BYTE     00000000B+004H,010H,VKEBL3+000H 
; 
         BYTE     01000000B+01AH,000H,VREVR1+000H,016H
; 
         BYTE     0FFH
; 
;=====================================================================
;***** 7/25       **********
; 
B302     EQU      $ 
; 
         LWORD     B303        ; BG dtaa address 
         LWORD     E303        ; Enmy data address 
; 
         BYTE     01100111B,10011000B,11000100B,00000100B,00001000B,00000000B
	 BYTE	  00FH
; 
         BYTE     00000000B+016H,000H,VMARU1+00AH 
         BYTE     00000000B+015H,002H,VAIWA0+003H 
         BYTE     00000000B+018H,001H,FASHSR
         BYTE     00000000B+018H,009H,FASHSR
;;K;;         BYTE     00000000B+014H,007H,FASKM1
;;K;;         BYTE     00000000B+017H,00CH,FASKM0
;;K;;         BYTE     00000000B+011H,004H,FASKM1
;;K;;         BYTE     00000000B+012H,00DH,FASKM0
         BYTE     01100000B+014H,00EH,VMARU3+001H 
; 
         BYTE     01100000B+016H,011H,VMARU3+003H 
         BYTE     00100000B+011H,012H,FKNQST
         BYTE     00000000B+013H,015H,VMARU0+000H,003H
;;K;;         BYTE     00000000B+018H,01AH,FASKM1
;;K;;         BYTE     00000000B+011H,01EH,FASKM1
;;K;;         BYTE     00000000B+014H,011H,FASKM1
;;K;;         BYTE     00000000B+015H,017H,FASKM0
; 
         BYTE     00000000B+013H,023H,VMARU0+000H,002H
         BYTE     00000000B+013H,027H,VMARU0+000H,006H
         BYTE     00000000B+012H,023H,VAIWA0+001H 
;;K;;         BYTE     00000000B+016H,022H,FASKM0
         BYTE     00000000B+019H,024H,VMARU0+000H,001H
         BYTE     00000000B+019H,027H,VMARU0+000H,005H
;;;;;;   BYTE     00100000B+015H,028H,FTCBLK
;;K;;         BYTE     00000000B+015H,02EH,FASKM1
         BYTE     00100000B+018H,029H,FTCBLK
         BYTE     01100000B+016H,02FH,VMARU3+000H 
         BYTE     01100000B+018H,02DH,VMARU3+000H 
         BYTE     01100000B+013H,026H,VMARU3+000H 
;;K;;         BYTE     00000000B+015H,028H,FASKM1
         BYTE     00100000B+015H,02AH,VGCOIN+002H 
         BYTE     00000000B+012H,028H,VAIWA0+004H 
         BYTE     01100000B+014H,020H,VMARU3+001H 
; 
         BYTE     00000000B+013H,030H,VMARU0+000H,005H
         BYTE     00000000B+013H,037H,VMARU0+000H,005H
         BYTE     00000000B+014H,03EH,VMARU0+000H,003H
         BYTE     00000000B+019H,037H,VMARU0+000H,00AH
         BYTE     01100000B+013H,036H,VMARU3+000H 
         BYTE     00000000B+018H,039H,VAIWA0+003H 
         BYTE     01000000B+012H,036H,VKORA0+000H 
         BYTE     00100000B+013H,03DH,VBBLK0+000H 
         BYTE     00100000B+014H,030H,VBBLK1+000H 
         BYTE     00100000B+015H,030H,VBBLK1+000H 
         BYTE     00100000B+016H,030H,VBBLK1+000H 
         BYTE     00100000B+018H,03DH,FHNBLK
         BYTE     00100000B+010H,039H,VGCOIN+002H 
         BYTE     00100000B+016H,039H,VGCOIN+002H 
;;K;;         BYTE     00000000B+010H,03DH,FASKM1
;;K;;         BYTE     00000000B+017H,031H,FASKM0
; 
         BYTE     00100000B+013H,041H,VCNBLK+000H 
         BYTE     00100000B+014H,049H,VCNBLK+000H 
         BYTE     00000000B+015H,047H,VMARU0+000H,002H
;;K;;         BYTE     00000000B+012H,046H,FASKM1
;;K;;         BYTE     00000000B+018H,04DH,FASKM1
; 
         BYTE     00100000B+014H,055H,VCNBLK+000H 
         BYTE     00000000B+015H,050H,VMARU0+000H,005H
         BYTE     00000000B+014H,051H,VAIWA0+002H 
;;K;;         BYTE     00000000B+01AH,054H,FASKM0
;;K;;         BYTE     00000000B+017H,058H,FASKM1
         BYTE     01100000B+019H,05CH,VMARU3+001H 
         BYTE     00000000B+015H,05EH,VMARU0+000H,004H
         BYTE     01000000B+019H,05EH,VKORA0+002H 
;;K;;         BYTE     00000000B+012H,05FH,FASKM1
; 
         BYTE     00000000B+015H,064H,VMARU0+000H,001H
         BYTE     00000000B+015H,06AH,VMARU0+000H,004H
         BYTE     00000000B+019H,068H,VMARU0+000H,007H
         BYTE     00000000B+01AH,060H,VMARU0+000H,006H
         BYTE     00100000B+015H,063H,FUPBLK
         BYTE     00100000B+014H,065H,VBBLK0+000H 
         BYTE     00100000B+015H,066H,VBBLK0+003H 
         BYTE     00100000B+016H,066H,VBBLK0+003H 
         BYTE     00100000B+019H,065H,FENBLK
         BYTE     00100000B+019H,066H,VBBLK0+001H 
;;K;;         BYTE     00000000B+014H,06EH,FASKM0
; 
         BYTE     00100000B+012H,072H,VGCOIN+002H 
         BYTE     01100000B+015H,072H,VMARU3+002H 
;;K;;         BYTE     00000000B+018H,077H,FASKM1
         BYTE     00100000B+017H,07BH,VBLDK0+003H 
;;K;;         BYTE     00000000B+014H,07EH,FASKM1
         BYTE     11100000B+007H,01000010B,090H 
; 
         BYTE     0FFH
; 
;=====================================================================
B303     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     01100010B,10011000B,01000000B,00000100B,00001000B,00000000B
	 BYTE	  00FH
; 
         BYTE     00100000B+00FH,009H,VBLDK4+001H 
         BYTE     00000000B+017H,007H,VMARU0+000H,004H
         BYTE     00000000B+016H,008H,VAIWA0+002H 
         BYTE     00000000B+018H,008H,FASHSR
         BYTE     00000000B+018H,00AH,FASHSR
         BYTE     00000000B+018H,00EH,VMARU0+000H,005H
         BYTE     00000000B+017H,00FH,VAIWA0+003H 
         BYTE     00000000B+019H,00FH,FASHSR
         BYTE     00000000B+019H,012H,FASHSR
         BYTE     00000000B+01AH,016H,VMARU0+000H,020H
         BYTE     01000000B+000H,019H,FBLBET
; 
; 
         BYTE     0FFH
; 
;=====================================================================
; 
; 
B304     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     01101000B,00010000B,00000000B,00000011B,00011000B,00100010B
	 BYTE	  018H
;
; 0 
         BYTE     00000000B+016H,000H,VMARU2+004H 
         BYTE     00000000B+018H,001H,FASHSR
         BYTE     00000000B+018H,003H,FASHSR
         BYTE     01100000B+010H,00FH,VICEB0+000H 
         BYTE     01100000B+011H,00FH,VICEB0+000H 
         BYTE     01100000B+012H,00FH,VICEB0+000H 
         BYTE     01100000B+013H,00FH,VICEB0+000H 
         BYTE     01100000B+014H,00FH,VICEB0+000H 
         BYTE     01100000B+015H,00FH,VICEB0+000H 
         BYTE     01100000B+016H,00FH,VICEB0+000H 
         BYTE     00100000B+016H,009H,VHZJP1+001H 
;;K;;         BYTE     00000000B+00AH,00BH,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,007H,VIKUMO+002H 
; 
; 1 
         BYTE     01100000B+014H,011H,VICEB0+002H 
         BYTE     01100000B+018H,01AH,VICEB0+002H 
         BYTE     01100000B+018H,01EH,VICEB0+000H 
         BYTE     01100000B+019H,01EH,VICEB0+000H 
         BYTE     01100000B+01AH,01EH,VICEB0+000H 
         BYTE     00100000B+015H,01FH,VGCOIN+002H 
         BYTE     00100000B+017H,01AH,FHNQST
;;K;;         BYTE     00000000B+005H,014H,VIKUMO+002H 
;;K;;         BYTE     00000000B+00FH,018H,VIKUMO+002H 
; 
; 2 
         BYTE     01100000B+018H,020H,VICEB0+000H 
         BYTE     01100000B+019H,020H,VICEB0+000H 
         BYTE     01100000B+01AH,020H,VICEB0+000H 
         BYTE     01100000B+018H,022H,VICEB0+000H 
         BYTE     01100000B+019H,022H,VICEB0+000H 
         BYTE     01100000B+01AH,022H,VICEB0+000H 
         BYTE     01100000B+018H,024H,VICEB0+000H 
         BYTE     01100000B+019H,024H,VICEB0+000H 
         BYTE     01100000B+01AH,024H,VICEB0+000H 
         BYTE     01100000B+018H,026H,VICEB0+000H 
         BYTE     01100000B+019H,026H,VICEB0+000H 
         BYTE     01100000B+01AH,026H,VICEB0+000H 
         BYTE     01100000B+018H,028H,VICEB0+000H 
         BYTE     01100000B+019H,028H,VICEB0+000H 
         BYTE     01100000B+01AH,028H,VICEB0+000H 
         BYTE     01100000B+018H,02AH,VICEB1+001H 
         BYTE     00100000B+013H,02CH,VHZJP1+000H 
         BYTE     00100000B+015H,025H,VGCOIN+002H 
;;K;;         BYTE     00000000B+005H,027H,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,027H,VIKUMO+002H 
; 
; 3 
         BYTE     01100000B+007H,03AH,VICEB1+000H 
         BYTE     01100000B+015H,030H,VICEB0+000H 
         BYTE     01100000B+016H,030H,VICEB0+000H 
         BYTE     01100000B+017H,030H,VICEB0+000H 
         BYTE     01100000B+018H,030H,VICEB0+000H 
         BYTE     01100000B+019H,030H,VICEB0+005H 
         BYTE     01100000B+016H,03CH,VICEB0+003H 
         BYTE     00100000B+004H,03AH,VBLDK2+002H 
         BYTE     00100000B+007H,037H,VBBLK1+000H 
         BYTE     00100000B+00BH,038H,VHZJP1+000H 
         BYTE     00100000B+016H,037H,FRPBLK
;;K;;         BYTE     00000000B+006H,034H,VIKUMO+002H 
;;K;;         BYTE     00000000B+010H,038H,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,032H,VIKUMO+002H 
         BYTE     00100000B+016H,039H,VBBLK0+001H 
; 
         BYTE     11100000B+003H,052H,025H       ;bonas goto data 
; 
; 4 
         BYTE     01100000B+015H,045H,VICEB0+001H 
         BYTE     01100000B+015H,04CH,VICEB0+002H 
         BYTE     01100000B+019H,04FH,VICEB0+000H 
         BYTE     00100000B+011H,04EH,FTCBLK
;;K;;         BYTE     00000000B+007H,046H,VIKUMO+002H 
;;K;;         BYTE     00000000B+016H,044H,VIKUMO+002H 
;;K;;         BYTE     00000000B+017H,04AH,VIKUMO+002H 
; 
; 5 
         BYTE     01100000B+019H,052H,VICEB0+001H 
         BYTE     01100000B+015H,059H,VICEB0+000H 
         BYTE     01100000B+016H,059H,VICEB0+000H 
         BYTE     01100000B+017H,059H,VICEB0+000H 
         BYTE     01100000B+018H,059H,VICEB0+000H 
         BYTE     01100000B+019H,05FH,VICEB0+001H 
;;K;;         BYTE     00000000B+006H,05BH,VIKUMO+002H 
;;K;;         BYTE     00000000B+009H,055H,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,053H,VIKUMO+002H 
;;K;;         BYTE     00000000B+010H,05FH,VIKUMO+002H 
; 
; 6 
         BYTE     01100000B+015H,060H,VICEB0+000H 
         BYTE     01100000B+016H,060H,VICEB0+000H 
         BYTE     01100000B+017H,060H,VICEB0+000H 
         BYTE     01100000B+018H,060H,VICEB0+000H 
         BYTE     01100000B+011H,067H,VICEB0+000H 
         BYTE     01100000B+012H,067H,VICEB0+000H 
         BYTE     01100000B+013H,067H,VICEB0+000H 
         BYTE     01100000B+014H,067H,VICEB0+000H 
         BYTE     01100000B+015H,067H,VICEB0+000H 
         BYTE     01100000B+016H,067H,VICEB0+000H 
         BYTE     00100000B+011H,063H,VGCOIN+002H 
         BYTE     00100000B+015H,064H,FUPBLK
;;K;;         BYTE     00000000B+00FH,066H,VIKUMO+002H 
;
; 7
         BYTE     00000000B+01AH,076H,VHILL1+00FH
         BYTE     00000000B+01AH,086H,VHILL1+00FH
         BYTE     01100000B+01AH,085H,VICEYK+000H
         BYTE     00000000B+01AH,096H,VHILL1+00FH
;;K;;         BYTE     00000000B+014H,077H,VIKUMO+002H 
         BYTE     01000000B+000H,07BH,FBLBET
; 
; 
         BYTE     0FFH
; 
;=====================================================================
B305     EQU      $ 
;*****   7/25     **********
; 
; 
         LWORD     B306        ; BG dtaa address 
         LWORD     E306        ; Enmy data address 
; 
         BYTE     11100111B,10000000B,11001100B,00000101B,00010011B,01001001B
	 BYTE	  006H
; 
         BYTE     01100000B+00FH,000H,VICEB0+00FH 
         BYTE     01100000B+01AH,000H,VICEB0+00FH 
         BYTE     01100000B+018H,007H,VICEB1+004H 
         BYTE     01100000B+017H,008H,VICEB0+008H 
         BYTE     01100000B+013H,00BH,VICEB0+006H 
         BYTE     01100000B+016H,00EH,VICEB0+000H 
; 
         BYTE     01100000B+00FH,010H,VICEB0+00FH 
         BYTE     01100000B+01AH,010H,VICEB0+00DH 
         BYTE     01100000B+017H,013H,VICEB0+007H 
         BYTE     01100000B+010H,015H,VICEB1+002H 
         BYTE     01100000B+012H,015H,VICEB1+002H 
         BYTE     01100000B+013H,01BH,VICEB0+003H 
         BYTE     01100000B+017H,01DH,VICEB0+002H 
         BYTE     01100000B+016H,017H,VICEB0+003H 
         BYTE     01100000B+014H,017H,VICEB1+001H 
         BYTE     01100000B+010H,01BH,VICEB0+000H 
         BYTE     01100000B+011H,01BH,VICEB0+000H 
         BYTE     01100000B+012H,01BH,VICEB0+000H 
         BYTE     00100000B+017H,01BH,FHNQST
; 
         BYTE     01100000B+012H,024H,VICEB0+000H 
         BYTE     01100000B+014H,028H,VICEB0+000H 
         BYTE     01100000B+015H,028H,VICEB0+000H 
         BYTE     01100000B+016H,028H,VICEB0+000H 
         BYTE     01100000B+00FH,020H,VICEB0+00FH 
         BYTE     01100000B+013H,022H,VICEB0+009H 
         BYTE     01100000B+01AH,02CH,VICEB0+00BH 
         BYTE     01100000B+017H,02DH,VICEB0+008H 
         BYTE     01100000B+010H,02FH,VICEB0+008H 
         BYTE     01100000B+011H,02FH,VICEB0+004H 
         BYTE     01100000B+012H,02FH,VICEB0+004H 
         BYTE     01100000B+013H,02DH,VICEB0+008H 
         BYTE     01100000B+014H,02FH,VICEB0+006H 
         BYTE     01100000B+017H,028H,VICEB0+003H 
; 
         BYTE     01100000B+00FH,030H,VICEB0+00FH 
         BYTE     01100000B+013H,039H,VICEB1+002H 
         BYTE     01100000B+015H,039H,VICEB1+002H 
         BYTE     01100000B+017H,038H,VICEB0+008H 
         BYTE     01100000B+015H,031H,VICEB0+004H 
         BYTE     01100000B+016H,031H,VICEB0+004H 
         BYTE     01100000B+010H,03CH,VICEB0+000H 
         BYTE     01100000B+011H,03CH,VICEB0+000H 
; 
         BYTE     01100000B+00FH,040H,VICEB0+00FH 
         BYTE     01100000B+017H,044H,VICEB0+00CH 
         BYTE     01100000B+010H,048H,VICEB1+000H 
         BYTE     01100000B+012H,048H,VICEB1+000H 
         BYTE     01100000B+013H,04AH,VICEB0+003H 
         BYTE     01100000B+010H,04AH,VICEB0+005H 
         BYTE     01100000B+011H,04AH,VICEB0+000H 
         BYTE     01100000B+012H,04AH,VICEB0+000H 
         BYTE     00100000B+013H,047H,FHNQST
; 
         BYTE     01100000B+00FH,050H,VICEB0+00FH 
         BYTE     01100000B+013H,051H,VICEB0+005H 
         BYTE     01100000B+013H,058H,VICEB0+00BH 
         BYTE     01100000B+012H,053H,VICEB0+000H 
; 
         BYTE     01100000B+00FH,060H,VICEB0+009H 
         BYTE     01100000B+017H,060H,VICEB0+002H 
         BYTE     01100000B+016H,060H,VICEB0+000H 
         BYTE     01100000B+01AH,065H,VICEB0+00FH 
         BYTE     01100000B+010H,067H,VICEB0+002H 
         BYTE     01100000B+011H,067H,VICEB0+002H 
         BYTE     01100000B+012H,067H,VICEB0+002H 
         BYTE     01100000B+013H,067H,VICEB0+002H 
         BYTE     01100000B+014H,067H,VICEB0+002H 
         BYTE     01100000B+015H,069H,VICEB0+000H 
         BYTE     01100000B+016H,069H,VICEB0+000H 
         BYTE     01100000B+017H,064H,VICEB0+00DH 
         BYTE     01100000B+01AH,063H,VICEB0+001H 
         BYTE     01100000B+016H,060H,VICEB0+000H 
         BYTE     01100000B+015H,060H,VICEB0+000H 
; 
         BYTE     01100000B+01AH,075H,VICEB0+00AH 
         BYTE     01100000B+00FH,06AH,VICEB1+00AH 
         BYTE     01100000B+011H,06AH,VICEB1+003H 
         BYTE     01100000B+013H,06AH,VICEB1+003H 
         BYTE     01100000B+015H,06AH,VICEB1+003H 
; 
         BYTE     01100000B+016H,07AH,VICEB1+002H 
         BYTE     01100000B+018H,07AH,VICEB1+002H 
         BYTE     01100000B+011H,07FH,VICEB0+000H 
         BYTE     01100000B+012H,07FH,VICEB0+000H 
         BYTE     01100000B+013H,07FH,VICEB0+000H 
         BYTE     01100000B+014H,07FH,VICEB0+000H 
         BYTE     01100000B+015H,07FH,VICEB0+000H 
         BYTE     00000000B+014H,07DH,FADOR0
         BYTE     01100000B+016H,076H,VICEB1+001H 
         BYTE     01100000B+018H,079H,VICEB0+000H 
         BYTE     01100000B+019H,079H,VICEB0+000H 
; 
         BYTE     11100000B+007H,01101000B,070H 
; 
         BYTE     0FFH
; 
;=====================================================================
;*****   7/25     **********
;chu bosu no room BOS 
; 
B306     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00000001B,00000000B,01000000B,00000101B,00010011B,01001001B
	 BYTE	  006H
; 
         BYTE     01100000B+00FH,000H,VICEB1+002H 
         BYTE     01100000B+011H,000H,VICEB1+002H 
         BYTE     01100000B+013H,000H,VICEB1+002H 
         BYTE     01100000B+015H,000H,VICEB1+002H 
         BYTE     01100000B+017H,000H,VICEB1+002H 
         BYTE     01100000B+019H,000H,VICEB1+00FH 
         BYTE     01100000B+00FH,006H,VICEB0+00FH 
         BYTE     01100000B+00FH,016H,VICEB0+009H 
         BYTE     01100000B+010H,006H,VICEB1+004H 
         BYTE     01100000B+012H,006H,VICEB1+004H 
         BYTE     01100000B+014H,006H,VICEB1+004H 
; 
         BYTE     01100000B+00FH,01FH,VICEB0+000H 
         BYTE     01100000B+010H,01FH,VICEB0+000H 
         BYTE     01100000B+011H,01FH,VICEB0+000H 
         BYTE     01100000B+012H,01FH,VICEB0+000H 
         BYTE     01100000B+013H,01FH,VICEB0+000H 
         BYTE     01100000B+014H,01FH,VICEB0+000H 
         BYTE     01100000B+015H,01FH,VICEB0+000H 
         BYTE     01100000B+016H,01FH,VICEB0+000H 
         BYTE     01100000B+017H,01FH,VICEB0+000H 
         BYTE     01100000B+018H,01FH,VICEB0+000H 
;;;;;    BYTE     00000000B+017H,007H,FDORD0
         BYTE     01100000B+015H,014H,VICEB0+000H 
         BYTE     01100000B+013H,018H,VICEB0+000H 
         BYTE     01100000B+016H,01BH,VICEB0+003H 
; 
         BYTE     0FFH
; 
;=====================================================================
B307     EQU      $ 
; 
         LWORD     B204        ; BG dtaa address 
         LWORD     E204        ; Enmy data address 
; 
         BYTE     00000101B,00010001B,11001110B,00001100B,01000000B,00000000B
	 BYTE	  008H
;0
         BYTE     01100000B+000H,00EH,VICEB0+00FH 
         BYTE     01100000B+001H,00EH,VICEB1+00FH 
         BYTE     01100000B+003H,00EH,VICEB1+00FH 
         BYTE     01100000B+005H,00EH,VICEB1+00FH 
         BYTE     01100000B+007H,00EH,VICEB1+00FH 
         BYTE     01100000B+009H,00EH,VICEB1+00FH 
         BYTE     01100000B+00BH,00EH,VICEB1+00FH 
         BYTE     01100000B+00DH,00EH,VICEB1+00FH 
         BYTE     01100000B+00FH,00EH,VICEB1+00FH 
         BYTE     01100000B+011H,00EH,VICEB1+006H 
         BYTE     01100000B+013H,00CH,VICEB1+007H 
         BYTE     01100000B+015H,006H,VICEB1+000H 
         BYTE     01100000B+015H,00AH,VICEB1+008H 
         BYTE     01100000B+017H,004H,VICEB1+001H 
         BYTE     01100000B+017H,00EH,VICEB1+006H 
         BYTE     01100000B+019H,000H,VICEB1+00FH 
         BYTE     00100000B+000H,000H,VBBLK1+00DH 
;;K;;         BYTE     00000000B+012H,001H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,008H,VIKUMO+002H 
         BYTE     00100000B+017H,00CH,VDOKY0+001H 
         BYTE     11100000B+000H,052H,020H
; 
         BYTE     01100000B+000H,01EH,VICEB0+00FH 
; 
         BYTE     01100000B+000H,02EH,VICEB0+00FH 
         BYTE     01100000B+001H,02EH,VICEB1+004H 
         BYTE     01100000B+003H,02EH,VICEB1+004H 
         BYTE     01100000B+005H,02EH,VICEB1+004H 
         BYTE     01100000B+007H,02EH,VICEB1+004H 
         BYTE     01100000B+009H,02EH,VICEB1+004H 
         BYTE     01100000B+00BH,02EH,VICEB1+004H 
         BYTE     01100000B+00DH,02EH,VICEB1+004H 
         BYTE     01100000B+00FH,02EH,VICEB1+004H 
         BYTE     01100000B+011H,026H,VICEB1+008H 
         BYTE     01100000B+013H,026H,VICEB1+008H 
         BYTE     01100000B+015H,026H,VICEB1+008H 
         BYTE     01100000B+017H,026H,VICEB1+008H 
         BYTE     01100000B+019H,020H,VICEB1+00FH 
         BYTE     01000000B+017H,01CH,VDOKY2+001H 
         BYTE     00100000B+015H,020H,FHNQST
         BYTE     00100000B+017H,024H,VBLDK0+001H 
         BYTE     11100000B+001H,064H,096H
         BYTE     11100000B+002H,052H,041H
; 
         BYTE     01100000B+000H,03FH,VICEB0+000H 
         BYTE     01100000B+001H,038H,VICEB0+007H 
         BYTE     01100000B+002H,038H,VICEB0+007H 
         BYTE     01100000B+003H,038H,VICEB0+007H 
         BYTE     01100000B+004H,038H,VICEB0+007H 
         BYTE     01100000B+005H,038H,VICEB0+007H 
         BYTE     01100000B+006H,038H,VICEB0+007H 
         BYTE     01100000B+007H,038H,VICEB0+007H 
         BYTE     01100000B+008H,038H,VICEB0+007H 
         BYTE     01100000B+009H,038H,VICEB0+007H 
         BYTE     01100000B+00AH,038H,VICEB0+007H 
         BYTE     01100000B+00BH,038H,VICEB0+007H 
         BYTE     01100000B+00CH,038H,VICEB0+007H 
         BYTE     01100000B+00DH,038H,VICEB0+007H 
         BYTE     01100000B+00EH,038H,VICEB0+007H 
         BYTE     01100000B+00FH,038H,VICEB0+007H 
         BYTE     01100000B+010H,038H,VICEB0+007H 
         BYTE     01100000B+011H,038H,VICEB0+007H 
         BYTE     01100000B+012H,038H,VICEB0+007H 
         BYTE     01100000B+013H,038H,VICEB0+007H 
         BYTE     01100000B+014H,038H,VICEB0+007H 
         BYTE     01100000B+015H,038H,VICEB0+007H 
         BYTE     01100000B+016H,038H,VICEB0+007H 
         BYTE     01100000B+017H,038H,VICEB0+007H 
         BYTE     01100000B+018H,038H,VICEB0+007H 
         BYTE     01100000B+019H,038H,VICEB0+007H 
         BYTE     00000000B+01AH,038H,VMARU0+000H,027H
; 
         BYTE     00100000B+017H,041H,VBLDK3+002H 
;;K;;         BYTE     00000000B+013H,047H,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,043H,VIKUMO+002H 
         BYTE     01000000B+000H,04CH,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
B308     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00001010B,10000000B,00000100B,00000100B,00001000B,00000000B
	 BYTE	  000H
;0
         BYTE     00000000B+019H,000H,VHILL0+008H 
         BYTE     00000000B+018H,002H,VAIWA0+002H 
         BYTE     00000000B+018H,00AH,VMARU1+002H 
         BYTE     00000000B+01AH,00BH,FASHSR
         BYTE     00000000B+015H,00DH,VMARU1+002H 
         BYTE     00000000B+017H,00EH,FASHSR
         BYTE     00000000B+011H,00FH,VMARU1+004H 
;1
         BYTE     00100000B+010H,010H,VGCOIN+002H 
         BYTE     00000000B+019H,011H,VHILL0+003H 
         BYTE     00000000B+013H,011H,FASHSR
         BYTE     00100000B+016H,012H,FKNQST
         BYTE     00100000B+018H,012H,VGCOIN+001H 
         BYTE     00100000B+016H,015H,VHZJP1+002H 
         BYTE     00000000B+016H,019H,VMARU1+004H 
         BYTE     00000000B+015H,01AH,VAIWA0+002H 
         BYTE     00000000B+018H,01AH,FASHSR
         BYTE     00000000B+018H,01CH,FASHSR
         BYTE     00100000B+011H,01FH,VGCOIN+002H 
;2
         BYTE     00100000B+016H,020H,VHZJP1+001H 
         BYTE     00000000B+013H,023H,VMARU0+000H,003H
         BYTE     00000000B+019H,023H,VHILL0+003H 
         BYTE     00000000B+012H,024H,VAIWA0+001H 
         BYTE     00000000B+014H,024H,FASHSR
         BYTE     00100000B+016H,025H,VBBLK0+000H 
         BYTE     00100000B+011H,02AH,VHZJP1+000H 
         BYTE     00100000B+010H,02CH,VGCOIN+002H 
         BYTE     00000000B+011H,02CH,VMARU0+000H,002H
         BYTE     00100000B+015H,02CH,VGCOIN+000H 
         BYTE     00000000B+018H,02CH,VAIWA0+000H 
         BYTE     00000000B+019H,02CH,VHILL0+002H 
         BYTE     00000000B+012H,02DH,FASHSR
         BYTE     00100000B+015H,02EH,VGCOIN+000H 
         BYTE     00000000B+018H,02EH,VAIWA0+000H 
;3
         BYTE     00000000B+011H,031H,VMARU0+000H,002H
         BYTE     00000000B+012H,032H,FASHSR
         BYTE     00100000B+014H,035H,VCNQST+003H 
         BYTE     00000000B+019H,034H,VHILL0+005H 
         BYTE     00000000B+018H,035H,VAIWA0+002H 
         BYTE     00100000B+004H,03AH,VCNBLK+000H 
         BYTE     00000000B+007H,03AH,VNKUMO+002H 
         BYTE     00100000B+004H,03BH,FTCBLK
         BYTE     00000000B+00CH,03BH,VNKUMO+003H 
         BYTE     00100000B+00AH,03CH,VGCOIN+002H 
         BYTE     00000000B+016H,03CH,VHILL0+001H 
; 
         BYTE     00000000B+012H,040H,FHIMO0
         BYTE     00000000B+012H,046H,FHIMO1
         BYTE     00000000B+012H,04BH,FHIMO0
         BYTE     00000000B+012H,04EH,FHIMO1
         BYTE     00000000B+013H,040H,VMARU0+000H,006H
         BYTE     00100000B+016H,040H,VCNQST+002H 
         BYTE     00000000B+019H,040H,VHILL0+003H 
         BYTE     00100000B+004H,041H,VGCOIN+002H 
         BYTE     00000000B+007H,041H,VNKUMO+002H 
         BYTE     00100000B+009H,042H,VGCOIN+003H 
         BYTE     00000000B+00BH,042H,VNKUMO+003H 
         BYTE     00100000B+019H,046H,VHZJP1+000H 
         BYTE     00000000B+017H,048H,VMARU1+002H 
         BYTE     00000000B+019H,049H,FASHSR
         BYTE     00000000B+013H,04BH,VMARU0+000H,003H
         BYTE     00100000B+007H,04CH,VGCOIN+004H 
; 
         BYTE     00000000B+015H,050H,VMARU1+003H 
         BYTE     00000000B+014H,051H,VAIWA0+002H 
         BYTE     00000000B+019H,051H,VHILL0+004H 
         BYTE     00000000B+017H,051H,FASHSR
         BYTE     00000000B+00BH,052H,VNKUMO+009H 
         BYTE     00100000B+018H,052H,VGCOIN+002H 
; 
         BYTE     00100000B+016H,068H,VHZJP1+000H 
         BYTE     00000000B+011H,06AH,VMARU1+00AH 
         BYTE     00100000B+016H,06AH,VBBLK0+000H 
         BYTE     00000000B+013H,06BH,FASHSR
         BYTE     00100000B+016H,06CH,VBBLK0+000H 
         BYTE     00100000B+016H,06EH,VBBLK0+000H 
; 
         BYTE     00100000B+016H,070H,VBBLK0+000H 
         BYTE     00000000B+019H,071H,VHILL0+003H 
         BYTE     00100000B+016H,072H,FKNQST+000H 
         BYTE     00000000B+018H,072H,VAIWA0+000H 
         BYTE     00000000B+013H,073H,FASHSR
         BYTE     00100000B+016H,074H,VCNBLK+000H 
         BYTE     00000000B+018H,074H,VAIWA0+000H 
         BYTE     00100000B+016H,076H,VCNBLK+001H 
         BYTE     00100000B+019H,076H,VBBLK0+000H 
         BYTE     00000000B+011H,076H,VMARU1+005H 
         BYTE     00000000B+013H,079H,FASHSR
         BYTE     00000000B+019H,078H,VHILL0+002H 
         BYTE     00100000B+018H,07CH,VHZJP1+000H 
         BYTE     00000000B+011H,07DH,VMARU1+002H 
         BYTE     00000000B+013H,07EH,FASHSR
; 
         BYTE     00000000B+019H,082H,VHILL0+001H 
         BYTE     00100000B+015H,086H,VBBLK0+007H 
         BYTE     00000000B+019H,086H,VHILL0+003H 
         BYTE     00000000B+018H,087H,VAIWA0+001H 
         BYTE     00000000B+019H,08BH,VHILL0+002H 
; 
         BYTE     00000000B+017H,090H,VHILL0+001H 
         BYTE     00000000B+017H,093H,VHILL0+001H 
         BYTE     00000000B+019H,096H,VHILL0+00FH 
         BYTE     00000000B+018H,098H,VAIWA0+005H 
; 
         BYTE     00000000B+019H,0A6H,VHILL0+00FH 
         BYTE     01000000B+000H,0A0H,FBLBET
; 
; 
; 
;;;;;;;;;;        S63/05/23 
;;;;;;;;;;         BYTE     00000000B+019H,000H,VHILL0+008H 
;;;;;;;;;;         BYTE     00000000B+018H,002H,VAIWA0+002H 
;;;;;;;;;;         BYTE     00000000B+019H,00AH,VHILL0+001H 
;;;;;;;;;;         BYTE     00000000B+017H,00DH,VHILL0+001H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+016H,010H,VMARU1+003H 
;;;;;;;;;;         BYTE     00000000B+015H,011H,VAIWA0+001H 
;;;;;;;;;;         BYTE     00000000B+018H,011H,FASHSR
;;;;;;;;;;         BYTE     00100000B+011H,015H,VGCOIN+002H 
;;;;;;;;;;         BYTE     00000000B+019H,016H,VHILL0+001H 
;;;;;;;;;;         BYTE     00000000B+016H,019H,VMARU1+004H 
;;;;;;;;;;         BYTE     00000000B+015H,01AH,VAIWA0+002H 
;;;;;;;;;;         BYTE     00000000B+018H,01AH,FASHSR
;;;;;;;;;;         BYTE     00000000B+018H,01CH,FASHSR
;;;;;;;;;;         BYTE     00100000B+011H,01FH,VGCOIN+002H 
;;;;;;;;;;         BYTE     00100000B+018H,01FH,VHZJP1+001H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+013H,023H,VMARU1+003H 
;;;;;;;;;;         BYTE     00000000B+012H,024H,VAIWA0+001H 
;;;;;;;;;;         BYTE     00000000B+015H,024H,FASHSR
;;;;;;;;;;         BYTE     00100000B+010H,02CH,VGCOIN+002H 
;;;;;;;;;;         BYTE     00000000B+011H,02CH,VMARU0+000H,002H
;;;;;;;;;;         BYTE     00100000B+015H,02CH,VGCOIN+000H 
;;;;;;;;;;         BYTE     00000000B+018H,02CH,VAIWA0+000H 
;;;;;;;;;;         BYTE     00000000B+019H,02CH,VHILL0+002H 
;;;;;;;;;;         BYTE     00000000B+012H,02DH,FASHSR
;;;;;;;;;;         BYTE     00100000B+015H,02EH,VGCOIN+000H 
;;;;;;;;;;         BYTE     00000000B+018H,02EH,VAIWA0+000H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+007H,030H,VNKUMO+002H 
;;;;;;;;;;         BYTE     00000000B+007H,039H,VNKUMO+002H 
;;;;;;;;;;         BYTE     00000000B+00CH,033H,VNKUMO+00BH 
;;;;;;;;;;         BYTE     00100000B+004H,030H,VCNBLK+000H 
;;;;;;;;;;         BYTE     00100000B+004H,031H,FTCBLK
;;;;;;;;;;         BYTE     00000000B+018H,033H,VHILL0+006H 
;;;;;;;;;;         BYTE     00100000B+00AH,034H,VGCOIN+002H 
;;;;;;;;;;         BYTE     00100000B+014H,034H,VCNBLK+001H 
;;;;;;;;;;         BYTE     00000000B+017H,034H,VAIWA0+002H 
;;;;;;;;;;         BYTE     00100000B+014H,036H,FKNQST
;;;;;;;;;;         BYTE     00100000B+014H,037H,VCNBLK+000H 
;;;;;;;;;;         BYTE     00100000B+005H,039H,VGCOIN+002H 
;;;;;;;;;;         BYTE     00100000B+00AH,03CH,VGCOIN+002H 
;;;;;;;;;;         BYTE     00000000B+016H,03CH,VHILL0+001H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+012H,040H,FHIMO0
;;;;;;;;;;         BYTE     00000000B+012H,047H,FHIMO1
;;;;;;;;;;         BYTE     00000000B+011H,04BH,FHIMO0
;;;;;;;;;;         BYTE     00000000B+011H,04EH,FHIMO1
;;;;;;;;;;         BYTE     00000000B+007H,041H,VNKUMO+002H 
;;;;;;;;;;         BYTE     00000000B+007H,04CH,VNKUMO+004H 
;;;;;;;;;;         BYTE     00000000B+00BH,042H,VNKUMO+003H 
;;;;;;;;;;         BYTE     00100000B+005H,041H,VGCOIN+002H 
;;;;;;;;;;         BYTE     00000000B+019H,042H,VHILL0+004H 
;;;;;;;;;;         BYTE     00100000B+010H,043H,VGCOIN+002H 
;;;;;;;;;;         BYTE     00100000B+016H,044H,FKNQST
;;;;;;;;;;         BYTE     00100000B+016H,045H,VCNQST+000H 
;;;;;;;;;;         BYTE     00000000B+013H,040H,VMARU0+000H,007H
;;;;;;;;;;         BYTE     00000000B+017H,04AH,VMARU1+004H 
;;;;;;;;;;         BYTE     00000000B+012H,04BH,VMARU0+000H,003H
;;;;;;;;;;         BYTE     00000000B+019H,04CH,FASHSR
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+013H,052H,FHIMO0
;;;;;;;;;;         BYTE     00000000B+013H,055H,FHIMO1
;;;;;;;;;;         BYTE     00000000B+014H,052H,VMARU0+000H,003H
;;;;;;;;;;         BYTE     00000000B+00BH,052H,VNKUMO+00AH 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+011H,063H,FHIMO0
;;;;;;;;;;         BYTE     00000000B+011H,066H,FHIMO1
;;;;;;;;;;         BYTE     00000000B+012H,063H,VMARU0+000H,003H
;;;;;;;;;;         BYTE     00000000B+012H,06AH,VMARU1+003H 
;;;;;;;;;;         BYTE     00000000B+014H,06BH,FASHSR
;;;;;;;;;;         BYTE     00000000B+019H,06DH,VHILL0+002H 
;;;;;;;;;;         BYTE     00000000B+012H,06FH,VMARU1+003H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+014H,071H,FASHSR
;;;;;;;;;;         BYTE     00000000B+019H,072H,VHILL0+002H 
;;;;;;;;;;         BYTE     00000000B+018H,073H,VAIWA0+000H 
;;;;;;;;;;         BYTE     00000000B+012H,074H,VMARU1+002H 
;;;;;;;;;;         BYTE     00000000B+014H,075H,FASHSR
;;;;;;;;;;         BYTE     00000000B+012H,078H,VMARU1+003H 
;;;;;;;;;;         BYTE     00000000B+014H,079H,FASHSR
;;;;;;;;;;         BYTE     00000000B+019H,07AH,VHILL0+003H 
;;;;;;;;;;         BYTE     00100000B+016H,07BH,FHNQST
;;;;;;;;;;         BYTE     00000000B+012H,07DH,VMARU1+002H 
;;;;;;;;;;         BYTE     00000000B+014H,07EH,FASHSR
;;;;;;;;;;         BYTE     00100000B+016H,07DH,VCNBLK
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+019H,082H,VHILL0+001H 
;;;;;;;;;;         BYTE     00000000B+017H,086H,VHILL0+001H 
;;;;;;;;;;         BYTE     00000000B+018H,08AH,VHILL0+003H 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+019H,090H,VHILL0+004H 
;;;;;;;;;;         BYTE     00000000B+018H,091H,VAIWA0+001H 
;;;;;;;;;;         BYTE     00000000B+019H,096H,VHILL0+00FH 
;;;;;;;;;;; 
;;;;;;;;;;         BYTE     00000000B+019H,0A6H,VHILL0+00FH 
;;;;;;;;;;         BYTE     01000000B+000H,0A0H,FBLBET
; 
         BYTE     0FFH
; 
; 
;=====================================================================
B309     EQU      $ 
; 
         LWORD     0000
         LWORD     0000
; 
;;;;;;;;         LWORD     B303
;;;;;;;;         LWORD     E303
; 
         BYTE     01101001B,00000101B,01000100B,00000100B,00001000B,00101100B
	 BYTE	  012H
;0
         BYTE     00100000B+000H,000H,VBBLK1+00FH 
         BYTE     00100000B+000H,010H,VBBLK1+00FH 
         BYTE     00100000B+000H,020H,VBBLK1+00FH 
         BYTE     00100000B+000H,030H,VBBLK1+00FH 
         BYTE     00100000B+000H,040H,VBBLK1+00FH 
         BYTE     00100000B+000H,050H,VBBLK1+00FH 
         BYTE     00100000B+000H,060H,VBBLK1+00FH 
         BYTE     00100000B+000H,070H,VBBLK1+00FH 
; 
         BYTE     01100000B+019H,000H,VMARU3+00FH 
         BYTE     00100000B+016H,002H,VBBLK1+000H 
         BYTE     00100000B+018H,008H,VBBLK1+000H 
;;K;;         BYTE     00000000B+010H,008H,FASKM1
;;K;;         BYTE     00000000B+012H,00DH,FASKM0
;;K;;         BYTE     00000000B+013H,005H,FASKM0
;1
         BYTE     01100000B+019H,010H,VMARU3+00AH 
         BYTE     01100000B+017H,01BH,VMARU3+00DH 
         BYTE     00100000B+018H,011H,VBBLK1+000H 
         BYTE     01000000B+016H,01AH,FHNJMY
         BYTE     00100000B+017H,01AH,VBBLK1+000H 
         BYTE     00100000B+018H,01AH,VBBLK1+000H 
         BYTE     00100000B+016H,01EH,VBBLK0+001H 
         BYTE     00100000B+017H,01EH,VBLDK3+003H 
;;K;;         BYTE     00000000B+00FH,012H,FASKM0
;;K;;         BYTE     00000000B+012H,019H,FASKM0
;;K;;         BYTE     00000000B+013H,01FH,FASKM0
;;K;;         BYTE     00000000B+010H,01CH,FASKM1
;;K;;         BYTE     00000000B+013H,014H,FASKM1
;2
         BYTE     01100000B+019H,029H,VMARU3+00DH 
         BYTE     00100000B+016H,029H,VBBLK1+000H 
         BYTE     00100000B+017H,029H,VBBLK1+000H 
         BYTE     00100000B+018H,029H,VBBLK1+000H 
         BYTE     00100000B+016H,024H,VBBLK0+001H 
         BYTE     00100000B+017H,024H,VBLDK2+003H 
         BYTE     00100000B+015H,02FH,FHNQST
 ;;K;;        BYTE     00000000B+010H,02AH,FASKM0
 ;;K;;        BYTE     00000000B+011H,024H,FASKM0
 ;;K;;        BYTE     00000000B+013H,02DH,FASKM0
 ;;K;;        BYTE     00000000B+013H,028H,FASKM1
;3
         BYTE     01100000B+019H,039H,VMARU3+007H 
         BYTE     00100000B+015H,030H,VCNQST+002H 
         BYTE     00100000B+017H,037H,VBLDK3+003H 
         BYTE     00100000B+001H,030H,VBLDK4+009H 
         BYTE     00100000B+00AH,030H,VBLDK4+007H 
;;K;;         BYTE     00000000B+010H,03AH,FASKM0
;;K;;         BYTE     00000000B+010H,03FH,FASKM0
;;K;;         BYTE     00000000B+011H,034H,FASKM0
;;K;;         BYTE     00000000B+014H,03DH,FASKM0
;4
         BYTE     00100000B+017H,040H,VBBLK1+008H 
         BYTE     00100000B+018H,040H,VBBLK1+000H 
         BYTE     00100000B+018H,048H,VBBLK1+000H 
         BYTE     01100000B+017H,041H,VMARU3+006H 
         BYTE     01100000B+019H,048H,VMARU3+008H 
         BYTE     00100000B+015H,041H,VGCOIN+006H 
         BYTE     00100000B+019H,041H,VGCOIN+006H 
;;K;;         BYTE     00000000B+010H,045H,FASKM0
;;K;;         BYTE     00000000B+010H,04EH,FASKM0
;;K;;         BYTE     00000000B+013H,041H,FASKM0
;;K;;         BYTE     00000000B+014H,04FH,FASKM0
;;K;;         BYTE     00000000B+012H,04AH,FASKM1
;5
         BYTE     01100000B+019H,059H,VMARU3+006H 
         BYTE     00100000B+018H,050H,VBBLK1+000H 
         BYTE     00100000B+018H,059H,VBBLK1+000H 
         BYTE     00100000B+017H,054H,VBLDK3+003H 
         BYTE     00100000B+001H,05EH,VBLDK4+00FH 
;;K;;         BYTE     00000000B+010H,053H,FASKM0
;;K;;         BYTE     00000000B+014H,052H,FASKM0
;;K;;         BYTE     00000000B+014H,05CH,FASKM0
;;K;;         BYTE     00000000B+012H,056H,FASKM1
;6
         BYTE     01100000B+019H,060H,VMARU3+00FH 
         BYTE     00100000B+012H,062H,VBBLK1+004H 
         BYTE     00100000B+013H,062H,VBBLK1+000H 
         BYTE     00100000B+013H,066H,VBBLK1+000H 
         BYTE     00100000B+014H,062H,VBBLK1+000H 
         BYTE     00100000B+014H,066H,VBBLK1+000H 
         BYTE     00100000B+015H,062H,VBBLK1+004H 
         BYTE     00100000B+016H,063H,VBBLK1+002H 
         BYTE     00100000B+018H,060H,VBBLK1+000H 
         BYTE     01000000B+018H,068H,FHNJMY
         BYTE     00100000B+012H,064H,VBBLK0+000H 
         BYTE     00100000B+015H,064H,VBBLK0+000H 
         BYTE     00100000B+016H,064H,VBBLK0+000H 
         BYTE     00100000B+012H,063H,VCNBLK+000H 
         BYTE     00100000B+012H,065H,FHNBLK+000H 
;;K;;         BYTE     00000000B+010H,062H,FASKM0
;;K;;         BYTE     00000000B+013H,069H,FASKM0
;;K;;         BYTE     00000000B+013H,06DH,FASKM0
         BYTE     00100000B+001H,069H,VBLDK4+00FH 
; 
         BYTE     01100000B+019H,070H,VMARU3+00FH 
         BYTE     00100000B+018H,070H,VBBLK1+000H 
         BYTE     00100000B+018H,078H,VBBLK1+000H 
;;K;;         BYTE     00000000B+010H,079H,FASKM0
;;K;;         BYTE     00000000B+012H,074H,FASKM0
;;K;;         BYTE     00000000B+012H,07FH,FASKM0
;;K;;         BYTE     00000000B+014H,075H,FASKM0
;;K;;         BYTE     00000000B+015H,07BH,FASKM0
;;K;;         BYTE     00000000B+011H,070H,FASKM1
;;K;;         BYTE     00000000B+013H,078H,FASKM1
;;;;;;;  BYTE     00100000B+001H,07CH,VBLDK1+00BH 
;;;;;;;  BYTE     00100000B+00CH,07CH,VBLDK1+009H 
; 
         BYTE     00000000B+01AH,080H,VMARU0+000H,01FH
         BYTE     01000000B+000H,088H,FBLBET
; 
         BYTE     11100000B+002H,002H,017H    ;bonas goto data
         BYTE     11100000B+007H,042H,090H
; 
         BYTE     0FFH
; 
;;;;        LWORD     B513        : BG dtaa address
;;;;        LWORD     E513        : Enmy data address
;;;;
;;;;        BYTE     10100111B,10000000B,10101101B,00000100B,00001000B,00000000B
;;;;
;;;;        BYTE     01100000B+019H,000H,VMARU3+00FH
;;;;        BYTE     01100000B+00BH,000H,VNKUM0+00BH
;;;;        BYTE     01100000B+00CH,000H,VNKUM0+00BH
;;;;        BYTE     01100000B+00DH,000H,VNKUM0+00BH
;;;;        BYTE     01100000B+00EH,000H,VNKUM0+00BH
;;;;        BYTE     00100000B+018H,008H,VBBLK1+000H
;;;;        BYTE     00100000B+009H,00DH,VGCOIN+001H
;;;;
;;;;        BYTE     01100000B+00BH,010H,VNKUM0+00DH
;;;;        BYTE     01100000B+00CH,010H,VNKUM0+00DH
;;;;        BYTE     01100000B+00DH,010H,VNKUM0+00DH
;;;;        BYTE     01100000B+00EH,010H,VNKUM0+00DH
;;;;        BYTE     00100000B+018H,010H,VBBLK1+000H
;;;;        BYTE     01100000B+019H,010H,VMARU3+00FH
;;;;        BYTE     00100000B+018H,018H,VBBLK1+000H
;;;;        BYTE     00100000B+008H,01EH,VGCOIN+003H
;;;;
;;;;        BYTE     00100000B+018H,020H,VBBLK1+000H
;;;;        BYTE     01100000B+00BH,023H,VNKUM0+00BH
;;;;        BYTE     01100000B+00CH,023H,VNKUM0+00BH
;;;;        BYTE     01100000B+00DH,023H,VNKUM0+00BH
;;;;        BYTE     01100000B+00EH,023H,VNKUM0+00BH
;;;;        BYTE     00100000B+018H,028H,VBBLK1+000H
;;;;        BYTE     01100000B+019H,020H,VMARU3+00FH
;;;;
;;;;        BYTE     00100000B+018H,030H,VBBLK1+000H
;;;;        BYTE     01100000B+019H,030H,VMARU3+00FH
;;;;        BYTE     00100000B+004H,031H,VGCOIN+001H
;;;;        BYTE     00100000B+009H,031H,VGCOIN+000H
;;;;        BYTE     00100000B+011H,031H,VBBLK1+000H
;;;;        BYTE     00100000B+012H,031H,VBBLK1+000H
;;;;        BYTE     00100000B+013H,031H,VBBLK1+000H
;;;;        BYTE     00100000B+014H,031H,VBBLK1+000H
;;;;        BYTE     00100000B+008H,032H,VGCOIN+002H
;;;;        BYTE     00100000B+011H,032H,VCNQST+001H
;;;;        BYTE     00100000B+015H,032H,VBBLK1+000H
;;;;        BYTE     00100000B+016H,032H,VBBLK1+000H
;;;;        BYTE     00100000B+014H,033H,VBBLK0+000H
;;;;        BYTE     00100000B+015H,033H,VBBLK0+000H
;;;;        BYTE     00100000B+016H,033H,VBBLK0+000H
;;;;        BYTE     00100000B+004H,034H,VGCOIN+001H
;;;;        BYTE     00100000B+015H,034H,VBBLK1+000H
;;;;        BYTE     00100000B+016H,034H,VBBLK1+000H
;;;;        BYTE     00100000B+009H,035H,VGCOIN+000H
;;;;        BYTE     00100000B+011H,035H,VBBLK1+000H
;;;;        BYTE     00100000B+012H,035H,VBBLK1+000H
;;;;        BYTE     00100000B+013H,035H,VBBLK1+000H
;;;;        BYTE     00100000B+014H,035H,VBBLK1+000H
;;;;        BYTE     00100000B+013H,036H,VBBLK1+000H
;;;;        BYTE     01100000B+00AH,037H,VNKUM0+00BH
;;;;        BYTE     01100000B+00BH,037H,VNKUM0+00BH
;;;;        BYTE     01100000B+00CH,037H,VNKUM0+00BH
;;;;        BYTE     01100000B+00DH,037H,VNKUM0+00BH
;;;;        BYTE     01100000B+00EH,037H,VNKUM0+00BH
;;;;        BYTE     00100000B+018H,038H,VBBLK1+000H
;;;;        BYTE     01100000B+019H,038H,VMARU3+001H
;;;;        BYTE     00100000B+011H,034H,FTCBLK 
;;;;
;;;;        BYTE     01100000B+019H,040H,VMARU3+00FH
;;;;        BYTE     00100000B+018H,041H,VBBLK1+000H
;;;;        BYTE     01100000B+007H,046H,VNKUM0+008H
;;;;        BYTE     01100000B+008H,046H,VNKUM0+008H
;;;;        BYTE     01100000B+009H,046H,VNKUM0+008H
;;;;        BYTE     00100000B+011H,04DH,VBBLK1+000H
;;;;        BYTE     00100000B+012H,04DH,VBBLK1+000H
;;;;        BYTE     00100000B+015H,04DH,VBBLK1+007H
;;;;        BYTE     00100000B+011H,04EH,VBBLK0+002H
;;;;        BYTE     00100000B+013H,04EH,VBBLK1+000H
;;;;        BYTE     00100000B+014H,04DH,VBBLK0+001H
;;;;        BYTE     00100000B+012H,04FH,VBBLK0+003H
;;;;        BYTE     00100000B+013H,04FH,VBBLK0+001H
;;;;
;;;;        BYTE     01100000B+019H,050H,VMARU3+00FH
;;;;        BYTE     00100000B+014H,050H,VBBLK0+002H
;;;;        BYTE     00100000B+018H,051H,VBBLK1+000H
;;;;        BYTE     00100000B+002H,051H,VGCOIN+001H
;;;;        BYTE     00100000B+005H,051H,VGCOIN+000H
;;;;        BYTE     00100000B+013H,052H,VBBLK1+000H
;;;;        BYTE     00100000B+003H,053H,VGCOIN+002H
;;;;        BYTE     00100000B+011H,053H,VBBLK1+000H
;;;;        BYTE     00100000B+012H,053H,VBBLK1+000H
;;;;        BYTE     00100000B+014H,053H,FKNBLK 
;;;;        BYTE     00100000B+002H,056H,VGCOIN+001H
;;;;        BYTE     00100000B+005H,057H,VGCOIN+000H
;;;;        BYTE     01100000B+007H,058H,VNKUM0+004H
;;;;        BYTE     01100000B+008H,058H,VNKUM0+004H
;;;;        BYTE     00100000B+018H,059H,VBBLK1+000H
;;;;        BYTE     00100000B+014H,053H,FHNBLK+000H
;;;;
;;;;        BYTE     01100000B+019H,060H,VMARU3+00FH
;;;;        BYTE     00100000B+008H,060H,VGCOIN+001H
;;;;        BYTE     00100000B+018H,061H,VBBLK1+000H
;;;;        BYTE     01100000B+007H,065H,VNKUM0+002H
;;;;        BYTE     01100000B+008H,065H,VNKUM0+002H
;;;;        BYTE     00100000B+018H,069H,VBBLK1+000H
;;;;        BYTE     00100000B+000H,06EH,VBLDK4+003H
;;;;        BYTE     00100000B+007H,06EH,VBLDK2+004H
;;;;
;;;;        BYTE     00100000B+00CH,06EH,VBLDK4+004H
;;;;        BYTE     00100000B+016H,06EH,VBLDK3+004H
;;;;
;;;;        BYTE     01100000B+00AH,071H,VNKUM0+005H
;;;;        BYTE     01100000B+019H,070H,VMARU3+005H
;;;;        BYTE     00100000B+00DH,073H,VGCOIN+002H
;;;;        BYTE     01100000B+00EH,077H,VNKUM0+002H
;;;;        BYTE     01100000B+015H,077H,VNKUM0+002H
;;;;        BYTE     01100000B+019H,078H,VNKUM0+006H
;;;;        BYTE     01100000B+012H,07AH,VNKUM0+004H
;;;;        BYTE     00100000B+000H,07DH,VBLDK1+00FH
;;;;
;;;;        BYTE     11100000B+006H,002H,017H    ;bonas goto data 
;;;;        BYTE     11100000B+007H,063H,022H 
;;;;
;;;;        BYTE     0FFH 
; 
;=====================================================================
B30A     EQU      $ 
; 
         LWORD     0000H       ; BG dtaa address 
         LWORD     0000H       ; Enmy data address 
; 
         BYTE     10000011B,10000000B,00000100B,00000100B,00001000B,00000000B
	 BYTE	  000H
;0
         BYTE     00000000B+019H,000H,VHILL0+008H 
         BYTE     00000000B+018H,002H,VAIWA0+002H 
         BYTE     00000000B+012H,00EH,VMARU1+005H 
         BYTE     00000000B+013H,006H,VMARU1+004H 
         BYTE     00000000B+017H,00AH,VMARU1+002H 
         BYTE     00000000B+015H,007H,FASHSR
         BYTE     00000000B+019H,00BH,FASHSR
         BYTE     00000000B+019H,00FH,VHILL0+001H 
         BYTE     00000000B+012H,008H,VAIWA0+001H 
         BYTE     00000000B+011H,00FH,VAIWA0+002H 
;1
         BYTE     00000000B+014H,011H,FASHSR
         BYTE     00100000B+016H,015H,VHZJP1+002H 
         BYTE     00000000B+016H,019H,VMARU1+004H 
         BYTE     00000000B+015H,01AH,VAIWA0+002H 
         BYTE     00000000B+018H,01AH,FASHSR
         BYTE     00000000B+018H,01CH,FASHSR
;2
         BYTE     00100000B+016H,020H,VHZJP1+001H 
         BYTE     00000000B+013H,023H,VMARU0+000H,003H
         BYTE     00000000B+019H,023H,VHILL0+003H 
         BYTE     00000000B+012H,024H,VAIWA0+001H 
         BYTE     00000000B+014H,024H,FASHSR
         BYTE     00100000B+016H,025H,VBBLK0+000H 
         BYTE     00100000B+011H,02AH,VHZJP1+000H 
         BYTE     00100000B+010H,02CH,VGCOIN+002H 
         BYTE     00000000B+011H,02CH,VMARU0+000H,002H
         BYTE     00100000B+015H,02CH,VGCOIN+000H 
         BYTE     00000000B+018H,02CH,VAIWA0+000H 
         BYTE     00000000B+019H,02CH,VHILL0+002H 
         BYTE     00000000B+012H,02DH,FASHSR
         BYTE     00100000B+015H,02EH,VGCOIN+000H 
         BYTE     00000000B+018H,02EH,VAIWA0+000H 
;3
         BYTE     00000000B+015H,030H,VMARU0+000H,002H
         BYTE     00000000B+016H,031H,FASHSR
         BYTE     00100000B+014H,035H,VCNQST+003H 
         BYTE     00100000B+014H,037H,FKNQST
         BYTE     00100000B+017H,034H,VBBLK0+000H 
         BYTE     00100000B+018H,034H,VBBLK0+000H 
         BYTE     00100000B+017H,038H,VBBLK0+000H 
         BYTE     00100000B+018H,038H,VBBLK0+000H 
         BYTE     00000000B+019H,034H,VHILL0+005H 
         BYTE     00000000B+016H,03CH,VHILL0+001H 
; 
         BYTE     0FFH
; 
;=====================================================================
B30B     EQU      $ 
; 
         LWORD     0000H       ; BG dtaa address 
         LWORD     0000H       ; Enmy data address 
; 
         BYTE     00000011B,10000000B,00000100B,00000100B,00001000B,00000000B
	 BYTE	  000H
;0
         BYTE     00000000B+01AH,000H,VHILL0+008H 
         BYTE     00000000B+019H,002H,VAIWA0+002H 
         BYTE     00000000B+013H,00EH,VMARU1+005H 
         BYTE     00000000B+014H,006H,VMARU1+004H 
         BYTE     00000000B+018H,00AH,VMARU1+002H 
         BYTE     00000000B+016H,007H,FASHSR
         BYTE     00000000B+01AH,00BH,FASHSR
         BYTE     00000000B+01AH,00FH,VHILL0+001H 
         BYTE     00000000B+013H,008H,VAIWA0+001H 
         BYTE     00000000B+012H,00FH,VAIWA0+002H 
;1
         BYTE     00000000B+015H,011H,FASHSR
         BYTE     00100000B+017H,015H,VHZJP1+002H 
         BYTE     00000000B+017H,019H,VMARU1+004H 
         BYTE     00000000B+016H,01AH,VAIWA0+002H 
         BYTE     00000000B+019H,01AH,FASHSR
         BYTE     00000000B+019H,01CH,FASHSR
;2
         BYTE     00100000B+017H,020H,VHZJP1+001H 
         BYTE     00000000B+014H,023H,VMARU0+000H,003H
         BYTE     00000000B+01AH,023H,VHILL0+003H 
         BYTE     00000000B+013H,024H,VAIWA0+001H 
         BYTE     00000000B+015H,024H,FASHSR
         BYTE     00100000B+017H,025H,VBBLK0+000H 
         BYTE     00100000B+012H,02AH,VHZJP1+000H 
         BYTE     00100000B+011H,02CH,VGCOIN+002H 
         BYTE     00000000B+012H,02CH,VMARU0+000H,002H
         BYTE     00100000B+016H,02CH,VGCOIN+000H 
         BYTE     00000000B+019H,02CH,VAIWA0+000H 
         BYTE     00000000B+01AH,02CH,VHILL0+002H 
         BYTE     00000000B+013H,02DH,FASHSR
         BYTE     00100000B+016H,02EH,VGCOIN+000H 
         BYTE     00000000B+019H,02EH,VAIWA0+000H 
;3
         BYTE     00000000B+016H,030H,VMARU0+000H,002H
         BYTE     00000000B+017H,031H,FASHSR
         BYTE     00100000B+015H,035H,VCNQST+003H 
         BYTE     00100000B+015H,037H,FKNQST
         BYTE     00100000B+018H,034H,VBBLK0+000H 
         BYTE     00100000B+019H,034H,VBBLK0+000H 
         BYTE     00100000B+018H,038H,VBBLK0+000H 
         BYTE     00100000B+019H,038H,VBBLK0+000H 
         BYTE     00000000B+01AH,034H,VHILL0+005H 
         BYTE     00000000B+017H,03CH,VHILL0+001H 
; 
         BYTE     0FFH
; 
;=====================================================================
B30C     EQU      $ 
; 
         LWORD     B310        ; BG dtaa address 
         LWORD     E310        ; Enmy data address 
; 
         BYTE     01101000B,10010000B,10001100B,00000011B,00011000B,00000000B
	 BYTE	  018H
;0
         BYTE     00100000B+016H,000H,VBBLK1+003H 
         BYTE     00100000B+016H,007H,VBBLK1+003H 
;1
         BYTE     01100000B+012H,014H,VICEB0+003H 
         BYTE     01100000B+018H,01FH,VICEB0+003H 
         BYTE     00100000B+011H,015H,VGCOIN+002H 
         BYTE     01000000B+017H,01FH,VKORA0+000H 
;2
         BYTE     00100000B+017H,022H,FHNQST
         BYTE     00100000B+016H,028H,VBBLK1+003H 
         BYTE     01100000B+017H,02DH,VICEB0+003H 
         BYTE     00100000B+010H,029H,VBBLK0+000H 
         BYTE     00100000B+011H,029H,VBBLK0+000H 
         BYTE     00100000B+012H,029H,VBBLK0+000H 
         BYTE     00100000B+013H,029H,VBBLK0+000H 
         BYTE     00100000B+014H,029H,VBBLK0+000H 
         BYTE     00100000B+015H,029H,VBBLK0+000H 
         BYTE     00100000B+013H,02EH,VGCOIN+002H 
;3
         BYTE     01100000B+016H,032H,VICEB0+003H 
         BYTE     00100000B+016H,037H,VBBLK1+003H 
         BYTE     00100000B+016H,03EH,VBBLK1+003H 
         BYTE     00100000B+010H,033H,VGCOIN+002H 
         BYTE     00100000B+013H,03BH,VGCOIN+002H 
         BYTE     00100000B+018H,035H,VGCOIN+002H 
         BYTE     00100000B+013H,034H,VBBLK0+000H 
         BYTE     00100000B+014H,034H,VBBLK0+000H 
         BYTE     00100000B+015H,034H,VBBLK0+000H 
         BYTE     00100000B+013H,039H,VBBLK0+000H 
         BYTE     00100000B+014H,039H,VBBLK0+000H 
         BYTE     00100000B+015H,039H,VBBLK0+000H 
;4
         BYTE     00100000B+018H,042H,VBBLK1+003H 
         BYTE     00100000B+019H,049H,VBBLK1+003H 
         BYTE     00100000B+00BH,04AH,VBBLK1+000H 
         BYTE     00100000B+00CH,04AH,VBBLK1+000H 
         BYTE     00100000B+00DH,04AH,VBBLK1+000H 
         BYTE     00100000B+00EH,04AH,VBBLK1+000H 
         BYTE     00100000B+00FH,04AH,VBBLK1+000H 
         BYTE     00100000B+010H,04AH,VBBLK1+000H 
         BYTE     00100000B+011H,04AH,VBBLK1+000H 
         BYTE     00100000B+012H,04AH,VBBLK1+000H 
         BYTE     00100000B+013H,04AH,VBBLK1+000H 
         BYTE     00100000B+014H,04AH,VBBLK1+000H 
         BYTE     00100000B+015H,04AH,VBBLK1+000H 
         BYTE     00100000B+016H,04AH,VBBLK1+000H 
         BYTE     00100000B+017H,04AH,VBBLK1+000H 
         BYTE     00100000B+018H,04AH,VBBLK1+000H 
;5
         BYTE     01100000B+00BH,051H,VICEB0+003H 
         BYTE     00100000B+008H,056H,VBBLK1+003H 
         BYTE     00100000B+008H,05CH,VBBLK1+003H 
         BYTE     00100000B+005H,058H,FTCBLK
         BYTE     01000000B+006H,058H,VKORA0+000H 
         BYTE     01000000B+007H,058H,VKORA0+000H 
;6
         BYTE     01100000B+00DH,068H,VICEB0+003H 
         BYTE     00100000B+014H,06FH,VBBLK1+003H 
         BYTE     00100000B+010H,06EH,VGCOIN+002H 
;7
         BYTE     00100000B+018H,078H,VBBLK1+003H 
         BYTE     00100000B+00DH,074H,FUPBLK
         BYTE     00100000B+007H,072H,VBBLK1+000H 
         BYTE     00100000B+008H,072H,VBBLK1+000H 
         BYTE     00100000B+009H,072H,VBBLK1+000H 
         BYTE     00100000B+00AH,072H,VBBLK1+000H 
         BYTE     00100000B+00BH,072H,VBBLK1+000H 
         BYTE     00100000B+00CH,072H,VBBLK1+000H 
         BYTE     00100000B+00DH,072H,VBBLK1+000H 
         BYTE     00100000B+00EH,072H,VBBLK1+000H 
         BYTE     00100000B+00FH,072H,VBBLK1+000H 
         BYTE     00100000B+010H,072H,VBBLK1+003H 
;8
         BYTE     00100000B+019H,080H,VBBLK1+003H 
         BYTE     00100000B+017H,08AH,VBLDK0+003H 
         BYTE     11100000B+008H,042H,080H
; 
         BYTE     0FFH
; 
;=====================================================================
B30D     EQU      $ 
; 
         LWORD     0000H       ; BG dtaa address 
         LWORD     0000H       ; Enmy data address 
; 
         BYTE     00001000B,10000000B,00100100B,00000100B,00001000B,00000000B
	 BYTE	  000H
;0
; 
         BYTE     0FFH
; 
;=====================================================================
B30E     EQU      $ 
; 
         LWORD     B31D        ; BG dtaa address 
         LWORD     E002        ; Enmy data address 
; 
         BYTE     11101000B,10010000B,10001100B,00001100B,00000000B,00100010B
	 BYTE	  008H
; 
;;K;;         BYTE     00000000B+012H,002H,VIKUMO+002H 
;;;;;;;  BYTE     00000000B+019H,000H,VAIWA0+007H 
         BYTE     00000000B+01AH,000H,VMARU0+000H,00BH
         BYTE     01100000B+017H,008H,VICEB0+003H 
         BYTE     01100000B+017H,00DH,VICEB0+004H 
         BYTE     00000000B+01AH,00DH,VMARU0+000H,025H
         BYTE     00100000B+014H,00EH,VBBLK0+001H 
; 
         BYTE     00100000B+014H,010H,FKNQST
         BYTE     00100000B+018H,014H,VBLDK3+001H 
;;K;;         BYTE     00000000B+012H,018H,VIKUMO+002H 
         BYTE     00100000B+017H,01AH,VGCOIN+002H 
;;K;;         BYTE     00000000B+005H,01CH,VIKUMO+002H 
; 
;;K;;         BYTE     00000000B+014H,021H,VIKUMO+002H 
;;K;;         BYTE     00000000B+007H,02BH,VIKUMO+002H 
;;K;;         BYTE     00000000B+012H,02DH,VIKUMO+002H 
         BYTE     00100000B+017H,02AH,VBLDK3+002H 
         BYTE     00000000B+005H,025H,FADOR0
         BYTE     00100000B+007H,023H,VBBLK1+003H 
         BYTE     00100000B+016H,02FH,FHCQST
         BYTE     11100000B+002H,068H,020H   ;next goto 
; 
         BYTE     00100000B+016H,032H,VGCOIN+002H 
         BYTE     00100000B+016H,03AH,VBLDK3+003H 
         BYTE     00000000B+01AH,034H,VMARU0+000H,003H
;;;;;;   BYTE     00000000B+019H,036H,VAIWA0+001H 
         BYTE     00000000B+01AH,039H,VMARU0+000H,034H
;;K;;         BYTE     00000000B+003H,03AH,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,03DH,VIKUMO+002H 
;;;;;;   BYTE     00000000B+019H,03CH,VAIWA0+00FH 
; 
;;K;;         BYTE     00000000B+012H,042H,VIKUMO+002H 
;;K;;         BYTE     00000000B+007H,049H,VIKUMO+002H 
;;;;;;   BYTE     00000000B+019H,04CH,VAIWA0+001H 
         BYTE     00100000B+017H,04EH,VBLDK3+002H 
         BYTE     00100000B+016H,04BH,FHCQST
; 
         BYTE     01100000B+016H,053H,VICEB0+003H 
;;K;;         BYTE     00000000B+011H,056H,VIKUMO+002H 
         BYTE     01100000B+016H,058H,VICEB0+002H 
         BYTE     00100000B+013H,058H,VGCOIN+002H 
;;K;;         BYTE     00000000B+007H,059H,VIKUMO+002H 
         BYTE     01100000B+016H,05DH,VICEB0+001H 
         BYTE     00100000B+013H,05EH,VGCOIN+002H 
         BYTE     00100000B+013H,054H,FHNQST
; 
         BYTE     01100000B+016H,062H,VICEB0+002H 
;;K;;         BYTE     00000000B+009H,066H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,068H,VIKUMO+002H 
;;;;;;   BYTE     00000000B+019H,067H,VAIWA0+003H 
         BYTE     00100000B+018H,06CH,VBLDK3+001H 
; 
         BYTE     00000000B+01AH,070H,VMARU0+000H,01FH
;;K;;         BYTE     00000000B+012H,071H,VIKUMO+002H 
         BYTE     01000000B+000H,077H,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
B30F     EQU      $ 
; 
         LWORD     B310        ; BG dtaa address 
         LWORD     E310        ; Enmy data address 
; 
         BYTE     01100111B,10000000B,10001100B,00001100B,00001000B,00000000B
	 BYTE	  000H
; 
         BYTE     01000000B+019H,000H,VREVR1+001H,07FH
         BYTE     01100000B+016H,000H,VICEB1+005H 
;;K;;         BYTE     00000000B+012H,005H,VIKUMO+002H 
         BYTE     01100000B+013H,00CH,VICEB0+002H 
         BYTE     00100000B+010H,00CH,VGCOIN+002H 
; 
;;K;;         BYTE     00000000B+011H,013H,VIKUMO+002H 
         BYTE     00100000B+013H,016H,VGCOIN+002H 
         BYTE     01100000B+016H,012H,VICEB0+00CH 
         BYTE     00100000B+013H,01DH,VGCOIN+002H 
; 
         BYTE     00100000B+015H,025H,VBBLK1+000H 
;;K;;         BYTE     00000000B+012H,026H,VIKUMO+002H 
         BYTE     01100000B+015H,024H,VICEB0+000H 
         BYTE     01100000B+016H,028H,VICEB0+004H 
         BYTE     00100000B+013H,02AH,FKNQST
; 
         BYTE     01100000B+014H,031H,VICEB0+001H 
         BYTE     01100000B+016H,037H,VICEB1+002H 
         BYTE     00100000B+014H,038H,VGCOIN+001H 
         BYTE     00100000B+014H,03BH,VGCOIN+000H 
; 
         BYTE     01100000B+016H,042H,VICEB1+002H 
;;K;;         BYTE     00000000B+010H,042H,VIKUMO+002H 
         BYTE     00100000B+013H,046H,VGCOIN+001H 
         BYTE     00100000B+013H,04BH,VGCOIN+002H 
         BYTE     00100000B+014H,04FH,VCNBLK+000H 
; 
         BYTE     01100000B+012H,050H,VICEB0+003H 
         BYTE     01100000B+013H,054H,VICEB0+000H 
         BYTE     01100000B+014H,055H,VICEB0+000H 
         BYTE     01100000B+015H,056H,VICEB0+000H 
         BYTE     01100000B+016H,057H,VICEB0+001H 
         BYTE     00000000B+017H,05FH,FKBEND
; 
         BYTE     00000000B+011H,05EH,VKEBL1+005H 
         BYTE     00000000B+010H,05FH,VKEBL0+000H 
         BYTE     00000000B+011H,060H,VKEBL2+005H 
         BYTE     00000000B+016H,066H,VKEBL0+003H 
         BYTE     00000000B+015H,06AH,VKEBL5+000H 
         BYTE     00000000B+014H,06BH,VKEBL3+000H 
         BYTE     00000000B+013H,06CH,VKEBL0+002H 
         BYTE     00000000B+014H,06FH,VKEBL4+001H 
         BYTE     00000000B+014H,072H,VKEBL5+001H 
         BYTE     00000000B+013H,073H,VKEBL0+003H 
; 
         BYTE     00100000B+014H,067H,VBBLK1+000H 
;;K;;         BYTE     00000000B+012H,063H,VIKUMO+002H 
         BYTE     00100000B+00FH,070H,VGCOIN+002H 
         BYTE     00100000B+012H,071H,VHZJP1+000H 
;;K;;         BYTE     00000000B+010H,075H,VIKUMO+002H 
         BYTE     00100000B+014H,07CH,VBLDK0+002H 
         BYTE     01100000B+017H,07CH,VICEB1+000H 
         BYTE     01100000B+000H,07EH,VICEB0+001H 
         BYTE     01100000B+001H,07EH,VICEB1+000H 
         BYTE     01100000B+003H,07EH,VICEB1+000H 
         BYTE     01100000B+005H,07EH,VICEB1+000H 
         BYTE     01100000B+007H,07EH,VICEB1+000H 
         BYTE     01100000B+009H,07EH,VICEB1+000H 
         BYTE     01100000B+00BH,07EH,VICEB1+000H 
         BYTE     01100000B+00DH,07EH,VICEB1+000H 
         BYTE     01100000B+00FH,07EH,VICEB1+000H 
         BYTE     01100000B+011H,07EH,VICEB1+000H 
         BYTE     01100000B+013H,07EH,VICEB1+000H 
         BYTE     01100000B+015H,07EH,VICEB1+000H 
         BYTE     01100000B+017H,07EH,VICEB1+000H 
         BYTE     01100000B+016H,07BH,VICEB0+000H 
; 
         BYTE     11100000B+007H,042H,080H
; 
; 
         BYTE     0FFH
; 
;=====================================================================
B310     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00000010B,10010000B,00000000B,00001100B,00001000B,00100010B
	 BYTE	  008H
; 
         BYTE     01000000B+01AH,000H,VREVR1+000H,007H
;;K;;         BYTE     00000000B+014H,003H,VIKUMO+002H 
         BYTE     00100000B+000H,008H,VBLDK4+003H 
         BYTE     00100000B+002H,008H,VBLDK4+00EH 
         BYTE     00000000B+01AH,008H,VMARU0+000H,030H
         BYTE     00000000B+016H,00FH,VHILL1+003H 
         BYTE     00000000B+018H,00CH,VHILL1+003H 
; 
;;K;;         BYTE     00000000B+014H,010H,VIKUMO+002H 
         BYTE     01000000B+000H,019H,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
;;;;;;;;; 7/22
B311     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00001001B,10011000B,10000001B,00000100B,00001000B,00100010B
	 BYTE	  00FH
;0
         BYTE     00000000B+019H,000H,VMARU0+000H,006H
         BYTE     00000000B+01AH,001H,FASHSR
         BYTE     00000000B+018H,002H,VAIWA0+002H 
         BYTE     00000000B+01AH,004H,FASHSR
;;K;;         BYTE     00000000B+012H,006H,FASKM1
;;K;;         BYTE     00000000B+014H,00BH,FASKM1
         BYTE     00000000B+017H,008H,VMARU1+002H 
         BYTE     00000000B+019H,009H,FASHSR
         BYTE     00000000B+015H,00EH,VMARU1+002H 
         BYTE     00000000B+017H,00FH,FASHSR
;1
         BYTE     00100000B+010H,011H,VGCOIN+002H 
         BYTE     00000000B+012H,011H,VAIWA0+002H 
         BYTE     00000000B+013H,011H,VMARU0+000H,002H
         BYTE     00000000B+014H,012H,FASHSR
;;K;;         BYTE     00000000B+013H,017H,FASKM1
         BYTE     00000000B+019H,018H,VMARU0+000H,002H
         BYTE     00100000B+015H,019H,FHNQST
         BYTE     00000000B+01AH,019H,FASHSR
         BYTE     00000000B+013H,01BH,VMARU0+000H,002H
         BYTE     00000000B+012H,01CH,VAIWA0+000H 
         BYTE     00000000B+014H,01CH,FASHSR
; 
         BYTE     00000000B+017H,022H,VKEBL2+001H 
         BYTE     00000000B+016H,022H,VKEBL3+001H 
         BYTE     00000000B+013H,022H,VKEBL2+001H 
         BYTE     00000000B+012H,021H,FKBEND
         BYTE     00000000B+019H,024H,FKBEND
         BYTE     00100000B+014H,027H,VHZJP1+001H 
;;K;;         BYTE     00000000B+009H,02AH,FASKM1
         BYTE     00000000B+016H,02BH,VMARU0+000H,003H
         BYTE     00000000B+013H,02CH,VHILL0+001H 
         BYTE     00000000B+017H,02CH,FASHSR
;;K;;         BYTE     00000000B+010H,02FH,FASKM1
; 
         BYTE     00100000B+017H,032H,VCNBLK+000H 
         BYTE     00100000B+018H,032H,VBBLK0+000H 
         BYTE     00100000B+013H,033H,VBBLK0+003H 
         BYTE     00000000B+019H,032H,VHILL0+006H 
         BYTE     00100000B+013H,035H,FUPBLK
         BYTE     00000000B+018H,033H,VAIWA0+002H 
         BYTE     00100000B+017H,037H,FTCBLK
         BYTE     00100000B+018H,037H,VBBLK0+000H 
;;K;;         BYTE     00000000B+005H,038H,FASKM1
         BYTE     00000000B+019H,03BH,VMARU0+000H,003H
         BYTE     00000000B+016H,03CH,VHILL0+001H 
         BYTE     00000000B+01AH,03CH,FASHSR
; 
         BYTE     00000000B+012H,040H,FHIMO0
         BYTE     00000000B+013H,040H,VMARU0+000H,007H
         BYTE     00000000B+019H,040H,VMARU0+000H,002H
         BYTE     00000000B+018H,041H,VAIWA0+000H 
         BYTE     00000000B+01AH,041H,FASHSR
         BYTE     00000000B+012H,047H,FHIMO1
         BYTE     00000000B+011H,047H,VMARU0+000H,002H
         BYTE     00000000B+012H,048H,FASHSR
         BYTE     00100000B+018H,04AH,VBBLK1+000H 
         BYTE     00000000B+010H,04BH,FHIMO0
         BYTE     00000000B+011H,04BH,VMARU0+000H,006H
         BYTE     00000000B+010H,04DH,VAIWA0+002H 
; 
         BYTE     00000000B+018H,04CH,FKBEND
         BYTE     00000000B+018H,04DH,VKEBL0+007H 
         BYTE     00000000B+019H,055H,VKEBL2+000H 
         BYTE     00000000B+019H,056H,VKEBL0+002H 
         BYTE     00000000B+016H,05AH,VKEBL5+001H 
         BYTE     00000000B+016H,05BH,VKEBL4+000H 
         BYTE     00000000B+017H,05CH,VKEBL3+002H 
         BYTE     00000000B+011H,060H,VKEBL5+001H 
         BYTE     00000000B+010H,061H,VKEBL0+003H 
         BYTE     00000000B+011H,065H,VKEBL2+001H 
; 
         BYTE     00000000B+010H,051H,FHIMO1
         BYTE     00100000B+00AH,055H,VGCOIN+002H 
;;K;;         BYTE     00000000B+007H,056H,FASKM1
;;K;;         BYTE     00000000B+014H,058H,FASKM1
         BYTE     00100000B+008H,05AH,VGCOIN+002H 
         BYTE     00100000B+011H,05EH,VGCOIN+000H 
         BYTE     00100000B+007H,05FH,VGCOIN+002H 
         BYTE     00100000B+013H,05AH,VGCOIN+001H 
; 
;;K;;         BYTE     00000000B+009H,060H,FASKM1
;;K;;         BYTE     00000000B+016H,061H,FASKM1
;;K;;         BYTE     00000000B+003H,066H,FASKM1
;;K;;         BYTE     00000000B+014H,068H,FASKM1
;;K;;         BYTE     00000000B+016H,06EH,FASKM0
         BYTE     00100000B+013H,06AH,VBBLK1+002
         BYTE     00100000B+006H,066H,VGCOIN+002H 
         BYTE     00100000B+006H,06AH,VGCOIN+002H 
         BYTE     00100000B+007H,06FH,VGCOIN+002H 
; 
;;K;;         BYTE     00000000B+008H,071H,FASKM1
         BYTE     00100000B+00AH,074H,VGCOIN+002H 
;;K;;         BYTE     00000000B+00FH,074H,FASKM1
;;K;;         BYTE     00000000B+018H,073H,FASKM0
;;K;;         BYTE     00000000B+010H,07BH,FASKM0
;;K;;         BYTE     00000000B+015H,07CH,FASKM0
; 
         BYTE     00000000B+010H,078H,FKBEND
         BYTE     00000000B+01AH,07CH,FKBEND
         BYTE     00000000B+011H,079H,VKEBL2+000H 
         BYTE     00000000B+012H,079H,VKEBL1+000H 
         BYTE     00000000B+013H,07AH,VKEBL2+000H 
         BYTE     00000000B+014H,07AH,VKEBL3+000H 
         BYTE     00000000B+015H,07AH,VKEBL2+003H 
         BYTE     00000000B+019H,07DH,VKEBL3+000H 
; 
;;K;;         BYTE     00000000B+013H,083H,FASKM1
         BYTE     00000000B+01AH,084H,VMARU0+000H,01FH
;;K;;         BYTE     00000000B+016H,087H,FASKM1
         BYTE     00000000B+019H,087H,VAIWA0+002H 
; 
;;K;;         BYTE     00000000B+009H,008H,FASKM0
;;K;;         BYTE     00000000B+00AH,012H,FASKM0
;;K;;         BYTE     00000000B+005H,01CH,FASKM0
;;K;;         BYTE     00000000B+007H,024H,FASKM0
;;K;;         BYTE     00000000B+00AH,032H,FASKM0
;;K;;         BYTE     00000000B+007H,03CH,FASKM0
; 
         BYTE     01000000B+000H,08BH,FBLBET
; 
         BYTE     0FFH
; 
; 
;=====================================================================
;;;;;;;; 7/22 
B312     EQU      $ 
; 
         LWORD     B131        ; BG dtaa address 
         LWORD     E131        ; Enmy data address 
; 
         BYTE     01100111B,10011000B,10000001B,00000100B,00001000B,00000000B
	 BYTE	  00FH
;0
         BYTE     00000000B+016H,000H,VHILL0+009H 
         BYTE     00000000B+015H,004H,VAIWA0+004H 
         BYTE     00100000B+016H,00EH,VBBLK0+003H 
;;K;;         BYTE     00000000B+010H,00AH,FASKM1
;;K;;         BYTE     00000000B+012H,001H,FASKM1
;;K;;         BYTE     00000000B+013H,006H,FASKM0
;;K;;         BYTE     00000000B+019H,00EH,FASKM1
;1
         BYTE     00100000B+011H,01AH,VGCOIN+002H 
         BYTE     00100000B+013H,015H,VGCOIN+002H 
         BYTE     00100000B+015H,018H,VBBLK0+004H 
;;K;;         BYTE     00000000B+012H,011H,FASKM0
;;K;;         BYTE     00000000B+013H,01AH,FASKM1
;;K;;         BYTE     00000000B+017H,01FH,FASKM0
;;K;;         BYTE     00000000B+018H,018H,FASKM0
;2
         BYTE     00100000B+012H,026H,VBBLK0+003H 
         BYTE     00100000B+017H,028H,VBBLK0+001H 
         BYTE     00100000B+012H,028H,FUPBLK
;;K;;         BYTE     00000000B+011H,022H,FASKM1
;;K;;         BYTE     00000000B+011H,02CH,FASKM1
;;K;;         BYTE     00000000B+015H,02AH,FASKM0
         BYTE     00100000B+014H,02FH,VBBLK0+000H 
         BYTE     00100000B+015H,02FH,VBBLK0+000H 
         BYTE     00100000B+016H,02FH,VBBLK0+000H 
         BYTE     00100000B+017H,02FH,VBBLK0+003H 
;3
         BYTE     00100000B+015H,036H,VBBLK0+000H 
         BYTE     00100000B+016H,036H,VBBLK0+000H 
         BYTE     00100000B+017H,036H,VBBLK0+000H 
         BYTE     00100000B+018H,036H,VBBLK0+002H 
         BYTE     00100000B+015H,03BH,VBBLK0+000H 
         BYTE     00100000B+016H,03BH,VBBLK0+001H 
         BYTE     00100000B+016H,03FH,VBBLK0+004H 
         BYTE     00100000B+019H,03CH,VBBLK0+003H 
         BYTE     00100000B+011H,035H,VGCOIN+002H 
         BYTE     00100000B+013H,030H,VGCOIN+002H 
         BYTE     00100000B+016H,03FH,FTCBLK
;;K;;         BYTE     00000000B+013H,038H,FASKM1
;;K;;         BYTE     00000000B+019H,032H,FASKM1
;;K;;         BYTE     00000000B+014H,032H,FASKM0
;;K;;         BYTE     00000000B+018H,03AH,FASKM0
         BYTE     00100000B+016H,03CH,FHNBLK
;4
         BYTE     00100000B+013H,04AH,VBBLK0+003H 
;;;;;;   BYTE     00100000B+012H,04AH,FTCBLK
         BYTE     00100000B+012H,04DH,FUPBLK
         BYTE     00100000B+018H,048H,VBBLK0+004H 
         BYTE     00100000B+017H,04FH,VBBLK0+001H 
;;K;;         BYTE     00000000B+011H,042H,FASKM1
;;K;;         BYTE     00000000B+015H,048H,FASKM1
;;K;;         BYTE     00000000B+010H,04FH,FASKM0
;;K;;         BYTE     00000000B+019H,049H,FASKM0
;5
         BYTE     00100000B+013H,057H,VBBLK0+002H 
         BYTE     00100000B+012H,053H,VGCOIN+002H 
         BYTE     00100000B+011H,05EH,VGCOIN+000H 
         BYTE     00100000B+012H,05EH,VGCOIN+000H 
         BYTE     00100000B+013H,05EH,VGCOIN+000H 
         BYTE     00100000B+014H,05EH,VGCOIN+000H 
         BYTE     00100000B+015H,05EH,VGCOIN+000H 
         BYTE     00100000B+016H,05EH,VGCOIN+000H 
         BYTE     00100000B+017H,05EH,VGCOIN+000H 
         BYTE     00100000B+018H,05EH,VGCOIN+000H 
;;K;;         BYTE     00000000B+012H,05BH,FASKM1
;;K;;         BYTE     00000000B+018H,053H,FASKM1
;;K;;         BYTE     00000000B+014H,056H,FASKM0
;;K;;         BYTE     00000000B+018H,05AH,FASKM0
;6
         BYTE     00100000B+012H,060H,FTCBLK
         BYTE     00100000B+013H,060H,VBBLK0+000H 
         BYTE     00100000B+017H,060H,VBBLK0+000H 
         BYTE     00100000B+018H,060H,VBBLK0+000H 
         BYTE     00100000B+019H,060H,VBBLK0+003H 
         BYTE     00100000B+012H,06CH,VBBLK0+000H 
         BYTE     00100000B+013H,06CH,VBBLK0+000H 
         BYTE     00100000B+014H,06CH,VBBLK0+000H 
         BYTE     00100000B+017H,06FH,VBBLK0+002H 
;;K;;         BYTE     00000000B+011H,06FH,FASKM0
;;K;;         BYTE     00000000B+013H,068H,FASKM0
;;K;;         BYTE     00000000B+019H,06CH,FASKM0
;;K;;         BYTE     00000000B+012H,062H,FASKM1
;;K;;         BYTE     00000000B+016H,066H,FASKM1
;7
         BYTE     00100000B+013H,076H,VGCOIN+002H 
         BYTE     00000000B+019H,078H,VMARU1+007H 
         BYTE     00100000B+015H,079H,VBLDK0+003H 
         BYTE     00000000B+017H,07BH,VHILL0+002H 
;;K;;         BYTE     00000000B+011H,078H,FASKM1
;;K;;         BYTE     00000000B+016H,074H,FASKM1
;;K;;         BYTE     00000000B+013H,07DH,FASKM0
         BYTE     00100000B+00FH,07FH,VBBLK1+000H 
         BYTE     00100000B+010H,07FH,VBBLK1+000H 
         BYTE     00100000B+011H,07FH,VBBLK1+000H 
         BYTE     00100000B+012H,07FH,VBBLK1+000H 
         BYTE     00100000B+013H,07FH,VBBLK1+000H 
         BYTE     00100000B+014H,07FH,VBBLK1+000H 
         BYTE     00100000B+015H,07FH,VBBLK1+000H 
         BYTE     00100000B+016H,07FH,VBBLK1+000H 
         BYTE     00100000B+017H,07FH,VBBLK1+000H 
         BYTE     00100000B+018H,07FH,VBBLK1+000H 
; 
         BYTE     11100000B+007H,071H,080H
; 
         BYTE     0FFH
; 
;=====================================================================
B313     EQU      $ 
; 
         LWORD     B513        ; BG dtaa address 
         LWORD     E513        ; Enmy data address 
; 
         BYTE     00001010B,00010000B,10001101B,00000011B,00011000B,00100010B
	 BYTE	  018H
;
;0
         BYTE     00000000B+01AH,00BH,VMARU0+000H,003H
         BYTE     00000000B+017H,00CH,VHILL1+001H 
         BYTE     00000000B+019H,000H,VMARU2+005H 
;;K;;         BYTE     00000000B+014H,001H,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,00AH,VIKUMO+002H 
;;K;;         BYTE     00000000B+005H,007H,VIKUMO+002H 
         BYTE     00100000B+011H,004H,VGCOIN+002H 
         BYTE     01100000B+013H,004H,VMARU3+002H 
;1
         BYTE     01100000B+013H,014H,VICEB1+000H 
         BYTE     01100000B+013H,01BH,VICEB0+001H 
         BYTE     01100000B+013H,01EH,VICEB0+000H 
         BYTE     01100000B+017H,01CH,VICEB0+001H 
         BYTE     01100000B+014H,01EH,VICEB1+000H 
         BYTE     01100000B+016H,01FH,VICEB1+000H 
;;K;;         BYTE     00000000B+018H,009H,VIKUMO+002H 
         BYTE     00100000B+014H,018H,VGCOIN+002H 
         BYTE     00100000B+012H,01BH,VBBLK1+000H 
         BYTE     01100000B+015H,016H,VICEB0+000H 
;;K;;         BYTE     00000000B+011H,017H,VIKUMO+002H 
;2
         BYTE     01100000B+013H,021H,VICEB0+003H 
         BYTE     01100000B+019H,026H,VICEB0+000H 
         BYTE     01100000B+017H,021H,VICEB0+000H 
         BYTE     01100000B+018H,022H,VICEB0+000H 
         BYTE     01100000B+019H,023H,VICEB0+001H 
         BYTE     00100000B+015H,026H,FUPBLK
;;K;;         BYTE     00000000B+009H,028H,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,022H,VIKUMO+002H 
; 
         BYTE     01100000B+013H,028H,VICEB1+002H 
         BYTE     01100000B+015H,028H,VICEB1+002H 
         BYTE     01100000B+017H,028H,VICEB1+002H 
         BYTE     01100000B+019H,028H,VICEB1+002H 
;;K;;         BYTE     00000000B+009H,028H,VIKUMO+002H 
         BYTE     00000000B+012H,02FH,VKEBL1+005H 
         BYTE     00000000B+011H,02FH,FKBEND
;3
         BYTE     01100000B+013H,032H,VICEB1+000H 
         BYTE     01100000B+015H,032H,VICEB1+000H 
         BYTE     00100000B+010H,032H,VGCOIN+001H 
;;K;;         BYTE     00000000B+006H,034H,VIKUMO+002H 
         BYTE     00000000B+017H,030H,VKEBL0+003H 
         BYTE     00000000B+017H,034H,VKEBL3+005H 
         BYTE     00000000B+012H,03AH,VKEBL2+003H 
         BYTE     00000000B+019H,03AH,VKEBL3+003H 
         BYTE     00000000B+017H,037H,VKEBL2+002H 
         BYTE     00000000B+016H,037H,VKEBL3+002H 
         BYTE     00000000B+014H,03AH,VKEBL2+001H 
         BYTE     00000000B+017H,03AH,VKEBL3+001H 
         BYTE     00000000B+017H,039H,VKEBL2+000H 
         BYTE     00000000B+016H,039H,VKEBL3+000H 
         BYTE     00000000B+015H,03AH,FKBEND
         BYTE     00100000B+011H,03BH,FHNQST
         BYTE     00100000B+013H,039H,VGCOIN+001H 
         BYTE     00100000B+015H,037H,VGCOIN+000H 
         BYTE     00100000B+015H,03CH,VGCOIN+000H 
         BYTE     00100000B+017H,038H,VGCOIN+000H 
         BYTE     00100000B+017H,03BH,VGCOIN+000H 
         BYTE     00100000B+018H,039H,VGCOIN+001H 
;;K;;         BYTE     00000000B+011H,035H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,03DH,VIKUMO+002H 
         BYTE     01000000B+013H,034H,FSPJP0
         BYTE     11100000B+003H,077H,050H
;4
;;K;;         BYTE     00000000B+005H,044H,VIKUMO+002H 
;;K;;         BYTE     00000000B+00AH,04AH,VIKUMO+002H 
         BYTE     00000000B+016H,04AH,VKEBL5+001H 
         BYTE     00000000B+015H,049H,VKEBL5+001H 
         BYTE     00000000B+015H,04FH,VKEBL5+001H 
         BYTE     00000000B+014H,04EH,VKEBL5+001H 
         BYTE     00000000B+015H,04AH,VKEBL2+000H 
         BYTE     00000000B+019H,048H,VKEBL2+000H 
         BYTE     00000000B+014H,04FH,VKEBL2+000H 
         BYTE     00000000B+018H,04DH,VKEBL2+000H 
         BYTE     00100000B+018H,044H,VBBLK1+001H 
;;K;;         BYTE     00000000B+011H,043H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,04BH,VIKUMO+002H 
;5
         BYTE     01100000B+013H,052H,VICEB1+000H 
         BYTE     01100000B+015H,052H,VICEB1+000H 
         BYTE     01100000B+017H,052H,VICEB1+000H 
         BYTE     01100000B+019H,052H,VICEB1+000H 
         BYTE     01100000B+018H,059H,VICEB1+00AH 
         BYTE     00100000B+005H,055H,VBBLK0+002H 
         BYTE     00100000B+006H,056H,VBBLK0+000H 
         BYTE     00100000B+007H,056H,VBBLK0+000H 
         BYTE     00100000B+013H,056H,VBBLK0+000H 
         BYTE     00100000B+014H,056H,VBBLK0+000H 
         BYTE     00100000B+015H,056H,VBBLK0+000H 
         BYTE     00100000B+016H,056H,VBBLK0+000H 
         BYTE     00100000B+017H,056H,VBBLK0+000H 
         BYTE     00100000B+018H,056H,VBBLK0+000H 
         BYTE     00100000B+004H,056H,FTCBLK
         BYTE     00100000B+019H,056H,VBBLK1+000H 
         BYTE     01000000B+012H,056H,FBOTAN
;;K;;         BYTE     00000000B+001H,05AH,VIKUMO+002H 
;;K;;         BYTE     00000000B+007H,052H,VIKUMO+002H 
;;K;;         BYTE     00000000B+008H,059H,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,05AH,VIKUMO+002H 
;6
;;K;;         BYTE     00000000B+005H,06CH,VIKUMO+002H 
;;K;;         BYTE     00000000B+009H,064H,VIKUMO+002H 
;;K;;         BYTE     00000000B+011H,06BH,VIKUMO+002H 
;;K;;         BYTE     00000000B+012H,063H,VIKUMO+002H 
         BYTE     01100000B+015H,062H,VICEB0+000H 
         BYTE     01100000B+016H,062H,VICEB0+000H 
         BYTE     01100000B+016H,06BH,VICEB0+000H 
         BYTE     01100000B+017H,06BH,VICEB0+000H 
         BYTE     00100000B+017H,060H,VBBLK0+004H 
         BYTE     00100000B+000H,061H,VBLDK4+001H 
         BYTE     00100000B+015H,06FH,VGCOIN+001H 
;7
         BYTE     01100000B+018H,071H,VICEB1+00FH 
         BYTE     01100000B+016H,075H,VICEB0+000H 
         BYTE     01100000B+017H,075H,VICEB0+000H 
         BYTE     01100000B+015H,07EH,VICEB0+000H 
         BYTE     01100000B+016H,07EH,VICEB0+000H 
;;K;;         BYTE     00000000B+003H,07AH,VIKUMO+002H 
;;K;;         BYTE     00000000B+009H,077H,VIKUMO+002H 
;;K;;         BYTE     00000000B+00FH,074H,VIKUMO+002H 
;;K;;         BYTE     00000000B+010H,07DH,VIKUMO+002H 
         BYTE     00100000B+007H,072H,VGCOIN+002H 
         BYTE     00100000B+008H,072H,VGCOIN+002H 
         BYTE     00100000B+009H,072H,VGCOIN+002H 
         BYTE     00100000B+014H,074H,VGCOIN+002H 
         BYTE     00100000B+008H,073H,FUPTOM
;8
         BYTE     01100000B+015H,087H,VICEB0+000H 
         BYTE     01100000B+016H,087H,VICEB0+000H 
         BYTE     01100000B+017H,087H,VICEB0+000H 
         BYTE     01100000B+011H,08FH,VICEB1+000H 
         BYTE     01100000B+016H,08FH,VICEB1+000H 
;;K;;         BYTE     00000000B+005H,083H,VIKUMO+002H 
;;K;;         BYTE     00000000B+008H,08AH,VIKUMO+002H 
;;K;;         BYTE     00000000B+012H,08BH,VIKUMO+002H 
         BYTE     00100000B+016H,08AH,VGCOIN+002H 
;9
         BYTE     00000000B+01AH,093H,VMARU0+000H,01CH
         BYTE     00000000B+015H,094H,VHILL1+002H 
         BYTE     01000000B+000H,098H,FBLBET
; 
         BYTE     0FFH
;;;;; 
;;;;;0
;;;;         BYTE     00000000B+01AH,00BH,VMARU0+000H,003H
;;;;         BYTE     00000000B+017H,00CH,VHILL1+001H 
;;;;         BYTE     00000000B+019H,000H,VMARU2+005H 
;;;;         BYTE     00000000B+013H,001H,VIKUMO+002H 
;;;;         BYTE     00000000B+011H,00AH,VIKUMO+002H 
;;;;         BYTE     00100000B+011H,004H,VGCOIN+002H 
;;;;         BYTE     01100000B+013H,004H,VMARU3+002H 
;;;;;1
;;;;         BYTE     01100000B+013H,014H,VICEB1+000H 
;;;;         BYTE     01100000B+013H,01BH,VICEB0+001H 
;;;;         BYTE     01100000B+013H,01EH,VICEB0+000H 
;;;;         BYTE     01100000B+017H,01DH,VICEB0+000H 
;;;;         BYTE     01100000B+014H,01EH,VICEB1+000H 
;;;;         BYTE     01100000B+016H,01FH,VICEB1+000H 
;;;;         BYTE     00000000B+010H,015H,VIKUMO+002H 
;;;;         BYTE     00000000B+018H,01BH,VIKUMO+002H 
;;;;         BYTE     00100000B+014H,018H,VGCOIN+002H 
;;;;         BYTE     00100000B+012H,01BH,VBBLK1+000H 
;;;;         BYTE     01100000B+015H,016H,VICEB0+000H 
;;;;         BYTE     01100000B+017H,01CH,VICEB0+000H 
;;;;;2
;;;;         BYTE     01100000B+013H,021H,VICEB0+003H 
;;;;         BYTE     01100000B+019H,025H,VICEB0+000H 
;;;;         BYTE     01100000B+019H,027H,VICEB0+000H 
;;;;         BYTE     01100000B+017H,021H,VICEB0+000H 
;;;;         BYTE     01100000B+018H,022H,VICEB0+000H 
;;;;         BYTE     01100000B+019H,023H,VICEB0+000H 
;;;;         BYTE     00100000B+015H,021H,VGCOIN+000H 
;;;;         BYTE     00100000B+016H,022H,VGCOIN+000H 
;;;;         BYTE     00100000B+017H,023H,VGCOIN+001H 
;;;;         BYTE     00100000B+015H,025H,FHNQST
;;;;         BYTE     00100000B+015H,029H,VBBLK0+000H 
;;;;         BYTE     00000000B+010H,02EH,VIKUMO+002H 
;;;;;3
;;;;         BYTE     01100000B+014H,03CH,VMARU3+000H 
;;;;         BYTE     00000000B+011H,037H,VIKUMO+002H 
;;;;         BYTE     01100000B+014H,03EH,VMARU3+000H 
;;;;;4
;;;;         BYTE     00100000B+011H,044H,VGCOIN+001H 
;;;;         BYTE     00100000B+013H,049H,VGCOIN+002H 
;;;;         BYTE     00100000B+015H,046H,VGCOIN+001H 
;;;;         BYTE     01100000B+014H,044H,VMARU3+001H 
;;;;         BYTE     01100000B+016H,042H,VMARU3+001H 
;;;;         BYTE     01100000B+016H,049H,VMARU3+002H 
;;;;         BYTE     01100000B+017H,04EH,VMARU3+001H 
;;;;         BYTE     01100000B+018H,046H,VMARU3+001H 
;;;;         BYTE     00000000B+011H,04CH,VIKUMO+002H 
;;;;;5
;;;;         BYTE     00100000B+011H,050H,VGCOIN+002H 
;;;;         BYTE     00100000B+017H,052H,VGCOIN+002H 
;;;;         BYTE     01100000B+013H,050H,VMARU3+002H 
;;;;         BYTE     01100000B+019H,052H,VMARU3+002H 
;;;;         BYTE     00000000B+015H,058H,VIKUMO+002H 
;;;;         BYTE     00100000B+005H,055H,VBBLK0+002H 
;;;;         BYTE     00100000B+006H,056H,VBBLK0+000H 
;;;;         BYTE     00100000B+007H,056H,VBBLK0+000H 
;;;;         BYTE     00100000B+004H,056H,FUPBLK
;;;;;6
;;;;         BYTE     01000000B+012H,060H,FBOTAN
;;;;         BYTE     00100000B+013H,060H,VBBLK0
;;;;         BYTE     00100000B+014H,060H,VBBLK0
;;;;         BYTE     00100000B+015H,060H,VBBLK0
;;;;         BYTE     00100000B+016H,060H,VBBLK0
;;;;         BYTE     00100000B+017H,060H,VBBLK0
;;;;         BYTE     00100000B+018H,060H,VBBLK0
;;;;         BYTE     00100000B+019H,060H,VBBLK1+000H 
;;;;         BYTE     00000000B+019H,064H,VMARU0+000H,003H
;;;;         BYTE     00000000B+018H,065H,VHILL1+002H 
;;;;         BYTE     00000000B+01AH,065H,FASHSR
;;;;         BYTE     00000000B+012H,064H,VIKUMO+002H 
;;;;         BYTE     00000000B+012H,06CH,VMARU2+003H 
;;;;         BYTE     00000000B+014H,06DH,FASHSR
;;;;         BYTE     01100000B+019H,06CH,VICEB0+006H 
;;;;         BYTE     00100000B+011H,06DH,FUPBLK
;;;;;7
;;;;         BYTE     01100000B+011H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+012H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+013H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+014H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+015H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+016H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+017H,071H,VICEB0+000H 
;;;;         BYTE     01100000B+014H,078H,VICEB0+001H 
;;;;         BYTE     01100000B+014H,07EH,VICEB0+000H 
;;;;         BYTE     00000000B+011H,074H,VIKUMO+002H 
;;;;; 
;;;;         BYTE     00000000B+013H,085H,VMARU2+006H 
;;;;         BYTE     00000000B+015H,087H,FASHSR
;;;;         BYTE     00000000B+015H,08AH,FASHSR
;;;;         BYTE     00000000B+01AH,08EH,VMARU0+000H,021H
;;;;;1
;;;;         BYTE     00000000B+015H,092H,VHILL1+003H 
;;;;         BYTE     00000000B+017H,090H,VHILL1+002H 
;;;;         BYTE     01000000B+000H,098H,FBLBET
;;;;; 
; 
; 
;=====================================================================
B314     EQU      $ 
; 
         LWORD     B315        ; BG dtaa address 
         LWORD     E315        ; Enmy data address 
; 
         BYTE     10000111B,10000000B,10001100B,00001100B,00000010B,00000000B
	 BYTE	  000H
;0
         BYTE     01000000B+00BH,000H,VREVR1+00FH,07FH
         BYTE     01100000B+00EH,005H,VKURAG+000H 
         BYTE     01100000B+00FH,00BH,VKURAG+000H 
         BYTE     00100000B+008H,00BH,FKNQST
         BYTE     01100000B+017H,000H,VICEB1+004H 
         BYTE     01100000B+019H,000H,VICEB1+009H 
         BYTE     01100000B+00BH,00BH,VICEB0+002H 
         BYTE     01100000B+00EH,000H,VICEB0+003H 
         BYTE     01100000B+011H,00AH,VICEB0+004H 
         BYTE     01100000B+012H,00CH,VICEB1+000H 
         BYTE     01100000B+00FH,00EH,VICEB0+000H 
         BYTE     01100000B+010H,00EH,VICEB0+000H 
;1
         BYTE     01100000B+015H,015H,VKURAG+000H 
         BYTE     01100000B+012H,011H,VKURAG+000H 
         BYTE     01100000B+000H,012H,VICEB1+000H 
         BYTE     01100000B+002H,012H,VICEB1+000H 
         BYTE     01100000B+004H,012H,VICEB1+000H 
         BYTE     01100000B+006H,012H,VICEB1+006H 
         BYTE     01100000B+008H,012H,VICEB1+006H 
         BYTE     01100000B+00AH,012H,VICEB1+007H 
         BYTE     01100000B+00CH,013H,VICEB1+005H 
         BYTE     01100000B+00EH,016H,VICEB1+003H 
         BYTE     01100000B+010H,017H,VICEB1+001H 
         BYTE     00100000B+012H,018H,VBLDK4+004H 
         BYTE     01100000B+019H,01FH,VICEB1+005H 
;2
         BYTE     01100000B+014H,021H,VKURAG+000H 
         BYTE     01100000B+00CH,024H,VKURAG+000H 
         BYTE     01100000B+00EH,025H,VICEB0+00EH 
         BYTE     01100000B+013H,026H,VICEB0+006H 
         BYTE     01100000B+013H,030H,VICEB0+003H 
;3
         BYTE     01100000B+00FH,033H,VICEB0+000H 
         BYTE     01100000B+010H,033H,VICEB0+000H 
         BYTE     01100000B+011H,033H,VICEB0+000H 
         BYTE     01100000B+012H,033H,VICEB0+000H 
         BYTE     01100000B+013H,03AH,VKURAG+000H 
         BYTE     01100000B+011H,03EH,VKURAG+000H 
         BYTE     01100000B+00FH,03EH,VKURAG+000H 
         BYTE     01100000B+010H,037H,VKURAG+000H 
         BYTE     01100000B+015H,039H,VKURAG+000H 
         BYTE     01100000B+013H,03DH,VKURAG+000H 
;4
         BYTE     01100000B+00EH,041H,VKURAG+000H 
         BYTE     01100000B+010H,042H,VKURAG+000H 
         BYTE     01100000B+007H,046H,VICEB0+003H 
         BYTE     01100000B+00AH,040H,VICEB0+004H 
         BYTE     01100000B+00BH,040H,VICEB0+004H 
         BYTE     01100000B+00CH,041H,VICEB0+00FH 
         BYTE     01100000B+00DH,042H,VICEB0+00FH 
         BYTE     01100000B+00BH,045H,VPACKN+000H,017H
;;;         BYTE     01100000B+00BH,045H,VIBKPK+00FH
;;;         BYTE     00000000B+008H,04BH,VMARU0+000H,002H 
;;;         BYTE     00000000B+007H,04BH,VHILL1+002H
;;;         BYTE     00000000B+009H,04CH,FASHSR 
;5
         BYTE     00100000B+005H,055H,VCNQST+002H 
         BYTE     00100000B+005H,056H,FKNQST
         BYTE     00000000B+009H,052H,VMARU0+000H,006H
         BYTE     00000000B+008H,052H,VMARU2+006H 
;;;         BYTE     01100000B+00BH,055H,VIBKPK+007H
         BYTE     00000000B+00AH,055H,FASHSR
         BYTE     01100000B+00CH,051H,VICEB0+00FH 
         BYTE     01100000B+00DH,052H,VICEB0+00DH 
         BYTE     01100000B+00AH,05DH,VICEB0+004H 
         BYTE     01100000B+00BH,05DH,VICEB0+004H 
;6
         BYTE     01100000B+00EH,064H,VKURAG+000H 
         BYTE     01100000B+010H,069H,VKURAG+000H 
         BYTE     01100000B+012H,067H,VKURAG+000H 
         BYTE     01100000B+014H,06AH,VKURAG+000H 
         BYTE     01100000B+000H,068H,VICEB1+00BH 
         BYTE     01100000B+002H,068H,VICEB1+00BH 
         BYTE     01100000B+004H,068H,VICEB1+00BH 
         BYTE     01100000B+006H,068H,VICEB1+00BH 
         BYTE     01100000B+008H,068H,VICEB1+00BH 
         BYTE     01100000B+00AH,068H,VICEB1+00BH 
         BYTE     01100000B+00CH,06AH,VICEB0+00FH 
         BYTE     01100000B+00DH,06AH,VICEB0+00FH 
         BYTE     01100000B+00EH,06BH,VICEB0+00AH 
         BYTE     01100000B+00FH,06BH,VICEB0+006H 
         BYTE     01100000B+015H,06EH,VICEB0+002H 
         BYTE     01100000B+016H,06EH,VICEB0+002H 
         BYTE     01100000B+017H,06EH,VICEB0+002H 
         BYTE     01100000B+018H,06EH,VICEB0+002H 
         BYTE     01100000B+019H,06EH,VICEB0+002H 
         BYTE     01100000B+01AH,06EH,VICEB0+002H 
         BYTE     00100000B+010H,06CH,VBLDK4+001H 
;;;         BYTE     00100000B+00FH,06FH,VBLDK4+002H
; 
         BYTE     01100000B+017H,071H,VKURAG+000H 
         BYTE     00100000B+00FH,072H,VBLDK4+002H 
         BYTE     01100000B+00FH,074H,VICEB0+001H 
         BYTE     01100000B+010H,074H,VICEB0+001H 
         BYTE     01100000B+011H,074H,VICEB0+001H 
         BYTE     01100000B+012H,074H,VICEB0+001H 
         BYTE     01100000B+013H,074H,VICEB0+001H 
         BYTE     01100000B+014H,074H,VICEB0+001H 
         BYTE     01100000B+018H,074H,VICEB0+001H 
         BYTE     01100000B+019H,074H,VICEB0+001H 
         BYTE     01100000B+01AH,074H,VICEB0+001H 
         BYTE     01100000B+012H,07BH,VICEB0+004H 
         BYTE     01100000B+013H,07BH,VICEB0+000H 
         BYTE     01100000B+014H,07BH,VICEB0+000H 
         BYTE     01100000B+015H,07BH,VICEB0+000H 
         BYTE     01100000B+016H,07BH,VICEB0+000H 
         BYTE     01100000B+017H,07BH,VICEB0+000H 
         BYTE     01100000B+018H,07BH,VICEB0+000H 
         BYTE     01100000B+019H,07BH,VICEB0+000H 
         BYTE     01100000B+01AH,07BH,VICEB0+000H 
         BYTE     01100000B+00CH,07AH,VICEB0+005H 
         BYTE     01100000B+00DH,07AH,VICEB0+005H 
         BYTE     01100000B+013H,07CH,VICEB1+001H 
         BYTE     01100000B+015H,07CH,VICEB1+001H 
         BYTE     01100000B+017H,07CH,VICEB1+001H 
         BYTE     01100000B+019H,07CH,VICEB1+001H 
         BYTE     01100000B+00EH,07FH,VICEB0+000H 
         BYTE     01100000B+00FH,07FH,VICEB0+000H 
         BYTE     01100000B+010H,07FH,VICEB0+000H 
         BYTE     01100000B+011H,07FH,VICEB0+000H 
         BYTE     00100000B+010H,07DH,VDOKY0+001H 
; 
         BYTE     11100000B+007H,071H,080H
; 
         BYTE     0FFH
; 
;=====================================================================
B315     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00000001B,10000000B,01000000B,00001100B,00000000B,00000000B
	 BYTE	  000H
; 
;;K;;         BYTE     00000000B+014H,002H,VIKUMO+002H 
;;K;;         BYTE     00000000B+015H,008H,VIKUMO+002H 
         BYTE     00000000B+019H,001H,VAIWA0+001H 
         BYTE     00000000B+019H,004H,VAIWA0+002H 
         BYTE     00100000B+018H,008H,VBLDK3+001H 
         BYTE     01000000B+000H,00CH,FBLBET
         BYTE     00000000B+01AH,000H,VMARU0+000H,020H
; 
         BYTE     0FFH
; 
;=====================================================================
B316     EQU      $ 
; 
         LWORD     B20A        ; BG dtaa address 
         LWORD     E20A        ; Enmy data address 
; 
         BYTE     11100011B,00010001B,11001110B,00001100B,00000000B,00000000B
	 BYTE	  008H
;0
         BYTE     00000000B+01AH,000H,VMARU0+000H,03FH
         BYTE     01100000B+000H,000H,VICEB0+00EH 
         BYTE     01100000B+016H,006H,VICEB1+000H 
         BYTE     01100000B+017H,008H,VICEB0+004H 
         BYTE     01100000B+018H,004H,VICEB1+004H 
         BYTE     01100000B+018H,00EH,VICEB0+000H 
         BYTE     01100000B+019H,00EH,VICEB0+000H 
         BYTE     01100000B+000H,00FH,VICEB1+008H 
         BYTE     01100000B+002H,00FH,VICEB1+008H 
         BYTE     01100000B+004H,00FH,VICEB1+008H 
         BYTE     01100000B+006H,00FH,VICEB1+008H 
         BYTE     01100000B+008H,00FH,VICEB1+008H 
         BYTE     01100000B+00AH,00FH,VICEB1+008H 
         BYTE     01100000B+00CH,00FH,VICEB1+008H 
         BYTE     01100000B+00EH,00FH,VICEB1+008H 
         BYTE     01100000B+010H,00FH,VICEB1+008H 
         BYTE     01100000B+012H,00FH,VICEB1+008H 
         BYTE     01100000B+014H,00DH,VICEB1+009H 
         BYTE     01100000B+016H,00DH,VICEB1+009H 
         BYTE     01100000B+018H,00FH,VICEB1+008H 
;;K;;         BYTE     00000000B+011H,007H,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,002H,VIKUMO+002H 
         BYTE     00100000B+015H,00BH,VDOKY0+001H 
         BYTE     11100000B+000H,012H,020H
;2
         BYTE     00100000B+018H,023H,VBLDK3+001H 
;;K;;         BYTE     00000000B+011H,028H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,022H,VIKUMO+002H 
;;K;;         BYTE     00000000B+016H,027H,VIKUMO+002H 
         BYTE     01000000B+000H,02CH,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
B317     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00001010B,10010001B,00100000B,00001100B,00001000B,00100010B
	 BYTE	  008H
;0
;;K;;         BYTE     00000000B+015H,002H,VIKUMO+002H 
         BYTE     01100000B+019H,000H,VICEB1+003H 
;;K;;         BYTE     00000000B+012H,008H,VIKUMO+002H 
         BYTE     01100000B+018H,00AH,VICEB1+002H 
         BYTE     01100000B+01AH,00AH,VICEB0+005H 
         BYTE     01100000B+014H,00BH,VICEB0+001H 
         BYTE     01100000B+015H,00EH,VICEB0+004H 
;1
         BYTE     01100000B+018H,012H,VICEB1+002H 
         BYTE     01100000B+01AH,012H,VICEB0+005H 
;;K;;         BYTE     00000000B+013H,018H,VIKUMO+002H 
         BYTE     01100000B+018H,01CH,VICEB1+001H 
         BYTE     01100000B+01AH,01CH,VICEB0+003H 
         BYTE     00100000B+018H,01AH,VBLDK3+002H 
;2
         BYTE     01100000B+01AH,029H,VICEB0+006H 
         BYTE     00100000B+015H,022H,VBBLK0+006H 
         BYTE     01100000B+019H,022H,VICEB1+000H 
         BYTE     00100000B+015H,023H,FKNQST
;;K;;         BYTE     00000000B+005H,021H,VIKUMO+002H 
         BYTE     00100000B+004H,026H,VBBLK0+001H 
         BYTE     01100000B+007H,025H,VICEB0+004H 
         BYTE     00100000B+003H,02AH,VBBLK1+001H 
         BYTE     00100000B+004H,025H,FENBLK
;;K;;         BYTE     00000000B+012H,027H,VIKUMO+002H 
;;K;;         BYTE     00000000B+00AH,02CH,VIKUMO+002H 
         BYTE     00100000B+002H,02FH,VBBLK0+002H 
         BYTE     00100000B+003H,02FH,VBBLK0+002H 
         BYTE     00100000B+004H,02FH,VBBLK0+002H 
         BYTE     00100000B+005H,02FH,VBBLK0+002H 
         BYTE     00100000B+006H,02FH,VBBLK0+002H 
         BYTE     00100000B+007H,02FH,VBBLK0+002H 
         BYTE     00100000B+008H,02FH,VBBLK0+002H 
         BYTE     00100000B+009H,02FH,VBBLK0+002H 
         BYTE     00100000B+00AH,02FH,VBBLK0+002H 
         BYTE     00100000B+00BH,02FH,VBBLK0+002H 
         BYTE     00100000B+00CH,02FH,VBBLK0+002H 
         BYTE     00100000B+00DH,02FH,VBBLK0+002H 
         BYTE     00100000B+00EH,02FH,VBBLK0+002H 
         BYTE     00100000B+00FH,02FH,VBBLK0+002H 
         BYTE     00100000B+010H,02FH,VBBLK0+002H 
         BYTE     00100000B+011H,02FH,VBBLK0+002H 
         BYTE     00100000B+012H,02FH,VBBLK0+002H 
         BYTE     00100000B+013H,02FH,VBBLK0+002H 
         BYTE     00100000B+014H,02FH,VBBLK0+002H 
         BYTE     00100000B+015H,02FH,VBBLK0+002H 
         BYTE     00100000B+016H,02FH,VBBLK0+002H 
         BYTE     00100000B+017H,02FH,VBBLK0+002H 
         BYTE     01000000B+018H,02FH,VKORA0+002H 
         BYTE     01000000B+019H,02FH,VKORA0+002H 
         BYTE     00100000B+018H,020H,VBLDK3+002H 
         BYTE     00100000B+018H,02AH,FRPBLK
         BYTE     01000000B+019H,02AH,VKORA0+000H 
         BYTE     01000000B+019H,029H,VKORA0+000H 
         BYTE     00100000B+018H,029H,VBBLK0+000H 
;3
         BYTE     01100000B+01AH,030H,VICEB0+00FH 
         BYTE     00100000B+016H,036H,VCNQST+001H 
         BYTE     00100000B+016H,038H,FKNQST
;;K;;         BYTE     00000000B+00CH,035H,VIKUMO+002H 
         BYTE     01100000B+019H,038H,VICEB0+002H 
         BYTE     01100000B+019H,03BH,VIBKPK+002H 
;;K;;         BYTE     00000000B+012H,039H,VIKUMO+002H 
         BYTE     00100000B+017H,03EH,VBLDK3+002H 
         BYTE     01100000B+019H,03BH,VIBKCN+002H 
         BYTE     01100000B+01AH,03BH,VIBKPK+002H 
         BYTE     01000000B+019H,034H,VKORA0+001H 
         BYTE     01000000B+018H,03AH,VKORA0+001H 
;4
         BYTE     01100000B+01AH,040H,VICEB0+00FH 
;;K;;         BYTE     00000000B+013H,041H,VIKUMO+002H 
;;K;;         BYTE     00000000B+014H,047H,VIKUMO+002H 
         BYTE     01100000B+017H,046H,VIBKCN+002H 
         BYTE     01100000B+018H,046H,VIBKCN+002H 
         BYTE     01100000B+019H,046H,VIBKCN+002H 
         BYTE     01100000B+016H,04AH,VICEB0+000H 
         BYTE     01100000B+016H,04FH,VICEB0+000H 
         BYTE     01100000B+017H,04AH,VICEB0+005H 
         BYTE     01100000B+017H,04BH,VIBKPK+003H 
         BYTE     01100000B+018H,04AH,VICEB1+002H 
         BYTE     00100000B+018H,04CH,VBLDK2+001H 
         BYTE     11100000B+004H,012H,0D6H    ;bonasu goto data 
;5
         BYTE     01100000B+01AH,056H,VICEB0+00FH 
;;K;;         BYTE     00000000B+012H,052H,VIKUMO+002H 
;;K;;         BYTE     00000000B+013H,05CH,VIKUMO+002H 
         BYTE     01100000B+018H,056H,VIBKCN+00FH 
         BYTE     01100000B+017H,056H,VIBKCN+000H 
         BYTE     01100000B+019H,056H,VIBKPK+00FH 
         BYTE     01100000B+019H,05AH,VIBKCN+003H 
         BYTE     01000000B+017H,05AH,VKORA0+003H 
;6
         BYTE     01100000B+018H,066H,VIBKCN+00FH 
         BYTE     01100000B+01AH,066H,VICEB0+00FH 
         BYTE     01100000B+019H,066H,VIBKPK+00FH 
;;K;;         BYTE     00000000B+014H,066H,VIKUMO+002H 
         BYTE     01000000B+017H,061H,VKORA0+003H 
         BYTE     01000000B+017H,068H,VKORA0+002H 
         BYTE     01000000B+017H,06EH,VKORA0+003H 
         BYTE     01100000B+019H,061H,VIBKCN+003H 
         BYTE     01100000B+019H,068H,VIBKCN+002H 
         BYTE     01100000B+019H,06EH,VIBKCN+003H 
;7
         BYTE     01100000B+017H,075H,VIBKCN+000H 
;;K;;         BYTE     00000000B+011H,071H,VIKUMO+002H 
;;K;;         BYTE     00000000B+012H,07BH,VIKUMO+002H 
         BYTE     01100000B+017H,07CH,VICEB1+000H 
         BYTE     01100000B+019H,07CH,VICEB1+000H 
; 
;;K;;         BYTE     00000000B+012H,083H,VIKUMO+002H 
         BYTE     01100000B+017H,084H,VICEB1+000H 
         BYTE     01100000B+019H,084H,VICEB1+000H 
         BYTE     01100000B+017H,088H,VICEB1+000H 
         BYTE     01100000B+019H,088H,VICEB1+000H 
;;K;;         BYTE     00000000B+014H,08BH,VIKUMO+002H 
         BYTE     01100000B+01AH,08CH,VICEB0+003H 
; 
         BYTE     01100000B+01AH,090H,VICEB0+00FH 
         BYTE     01000000B+000H,096H,FBLBET
; 
         BYTE     01100000B+01AH,0A0H,VICEB0+00FH 
; 
         BYTE     0FFH
; 
;=====================================================================
B318     EQU      $ 
; 
         LWORD     B319        ; BG dtaa address 
         LWORD     E319        ; Enmy data address 
;
         BYTE     00100111B,10010000B,10001100B,00000011B,00011000B,00100010B
	 BYTE	  018H
;0
         BYTE     00000000B+006H,000H,VMARU2+009H 
         BYTE     00000000B+008H,001H,FASHSR
         BYTE     00000000B+008H,007H,FASHSR
;;K;;         BYTE     00000000B+003H,002H,VIKUMO+002H 
;;K;;         BYTE     00000000B+004H,00BH,VIKUMO+002H 
         BYTE     01100000B+008H,00DH,VMARU3+002H 
;1
         BYTE     01100000B+008H,013H,VMARU3+002H 
         BYTE     00100000B+00AH,015H,VGCOIN+000H 
         BYTE     00100000B+00BH,015H,VGCOIN+000H 
         BYTE     00100000B+00CH,015H,VGCOIN+000H 
;;K;;         BYTE     00000000B+007H,016H,VIKUMO+002H 
         BYTE     00000000B+00AH,017H,VMARU2+004H 
         BYTE     00000000B+00CH,018H,FASHSR
         BYTE     00000000B+00CH,01AH,FASHSR
         BYTE     01100000B+000H,018H,VICEB0+007H 
         BYTE     01100000B+006H,01AH,VICEB0+003H 
         BYTE     00100000B+006H,019H,FHNQST
         BYTE     01100000B+007H,01DH,VICEB0+000H 
         BYTE     01100000B+008H,01DH,VICEB0+000H 
         BYTE     01100000B+009H,01DH,VICEB0+000H 
         BYTE     01100000B+00AH,01DH,VICEB0+000H 
         BYTE     01100000B+006H,01EH,VMARU3+000H 
         BYTE     01100000B+000H,01FH,VICEB0+000H 
         BYTE     01100000B+001H,01FH,VICEB0+000H 
         BYTE     01100000B+002H,01FH,VICEB0+000H 
         BYTE     01100000B+003H,01FH,VICEB0+000H 
         BYTE     01100000B+004H,01FH,VICEB0+000H 
         BYTE     01100000B+005H,01FH,VICEB0+000H 
         BYTE     01100000B+006H,01FH,VICEB0+000H 
;;K;;         BYTE     00000000B+010H,01CH,VIKUMO+002H 
         BYTE     01100000B+00AH,01CH,VMARU3+000H 
         BYTE     01100000B+010H,01FH,VMARU3+000H 
;2
         BYTE     01100000B+00DH,020H,VMARU3+003H 
         BYTE     00100000B+011H,022H,VGCOIN+001H 
         BYTE     00100000B+012H,022H,VGCOIN+001H 
         BYTE     00100000B+013H,022H,VGCOIN+001H 
;;K;;         BYTE     00000000B+017H,024H,VIKUMO+002H 
         BYTE     01100000B+013H,026H,VICEB0+003H 
;;K;;         BYTE     00000000B+00EH,027H,VIKUMO+002H 
         BYTE     00100000B+012H,02CH,VGCOIN+002H 
         BYTE     01100000B+016H,02CH,VICEB0+004H 
;;K;;         BYTE     00000000B+019H,02DH,VIKUMO+002H 
         BYTE     01100000B+015H,02AH,VMARU3+000H 
         BYTE     00100000B+016H,02AH,VGCOIN+000H 
         BYTE     00100000B+017H,02AH,VGCOIN+000H 
         BYTE     00100000B+018H,02AH,VGCOIN+000H 
;3
;;K;;         BYTE     00000000B+011H,031H,VIKUMO+002H 
         BYTE     01100000B+013H,032H,VMARU3+003H 
         BYTE     01100000B+017H,037H,VMARU3+002H 
         BYTE     00100000B+014H,038H,VCNQST
         BYTE     01100000B+013H,03BH,VMARU3+002H 
         BYTE     00100000B+016H,03EH,VGCOIN+002H 
         BYTE     00100000B+018H,039H,VGCOIN+000H 
         BYTE     00100000B+019H,039H,VGCOIN+000H 
         BYTE     00100000B+01AH,039H,VGCOIN+000H 
         BYTE     00100000B+014H,035H,VGCOIN+000H 
         BYTE     00100000B+015H,035H,VGCOIN+000H 
         BYTE     00100000B+016H,035H,VGCOIN+000H 
;4
         BYTE     01100000B+017H,041H,VMARU3+002H 
         BYTE     00100000B+014H,042H,VCNBLK+000H 
         BYTE     01100000B+013H,045H,VMARU3+001H 
         BYTE     00100000B+015H,048H,VBBLK0+002H 
         BYTE     01100000B+019H,048H,VICEB0+003H 
         BYTE     00100000B+015H,049H,FKNQST
;;K;;         BYTE     00000000B+012H,04BH,VIKUMO+002H 
         BYTE     00100000B+015H,04DH,VBBLK0+001H 
         BYTE     01100000B+019H,04DH,VICEB0+002H 
         BYTE     01100000B+015H,04FH,VICEB0+000H 
         BYTE     01100000B+016H,04FH,VICEB0+000H 
         BYTE     01100000B+017H,04FH,VICEB0+000H 
         BYTE     01100000B+018H,04FH,VICEB0+000H 
         BYTE     01100000B+019H,04FH,VICEB0+000H 
         BYTE     00100000B+015H,046H,VGCOIN+000H 
         BYTE     00100000B+016H,046H,VGCOIN+000H 
         BYTE     00100000B+017H,046H,VGCOIN+000H 
         BYTE     00100000B+018H,046H,VGCOIN+000H 
;5
         BYTE     01100000B+013H,051H,VMARU3+001H 
         BYTE     01100000B+00DH,053H,VICEB0+000H 
         BYTE     01100000B+00EH,053H,VICEB0+000H 
         BYTE     01100000B+00FH,053H,VICEB0+000H 
         BYTE     01100000B+010H,053H,VICEB0+000H 
         BYTE     01100000B+011H,053H,VICEB0+000H 
         BYTE     01100000B+012H,053H,VICEB0+000H 
;;K;;         BYTE     00000000B+014H,055H,VIKUMO+002H 
         BYTE     01100000B+019H,055H,VMARU3+002H 
         BYTE     01100000B+019H,058H,VICEB0+001H 
;;K;;         BYTE     00000000B+00CH,059H,VIKUMO+002H 
         BYTE     01100000B+019H,05DH,VMARU3+002H 
         BYTE     01100000B+011H,05DH,VMARU3+002H 
         BYTE     01100000B+015H,05FH,VMARU3+002H 
         BYTE     01100000B+015H,05AH,VMARU3+002H 
         BYTE     01100000B+019H,03CH,VMARU3+002H 
         BYTE     00100000B+00DH,052H,FUPBLK
         BYTE     00100000B+016H,05CH,VGCOIN+000H 
         BYTE     00100000B+017H,05CH,VGCOIN+000H 
         BYTE     00100000B+018H,05CH,VGCOIN+000H 
         BYTE     00100000B+019H,05CH,VGCOIN+000H 
         BYTE     00100000B+012H,05DH,VGCOIN+000H 
         BYTE     00100000B+013H,05DH,VGCOIN+000H 
         BYTE     00100000B+014H,05DH,VGCOIN+000H 
;6
;;K;;         BYTE     00000000B+012H,061H,VIKUMO+002H 
;;K;;         BYTE     00000000B+003H,066H,VIKUMO+002H 
         BYTE     00000000B+008H,069H,VMARU2+005H 
         BYTE     00000000B+00AH,06AH,FASHSR
         BYTE     00000000B+00AH,06DH,FASHSR
         BYTE     01100000B+00DH,061H,VMARU3+002H 
         BYTE     01100000B+00BH,065H,VMARU3+002H 
         BYTE     00100000B+00EH,063H,VGCOIN+000H 
         BYTE     00100000B+00FH,063H,VGCOIN+000H 
         BYTE     00100000B+010H,063H,VGCOIN+000H 
         BYTE     00100000B+004H,06AH,VGCOIN+003H 
;7
         BYTE     01100000B+005H,072H,VMARU3+000H 
;;K;;         BYTE     00000000B+009H,074H,VIKUMO+002H 
         BYTE     01100000B+004H,075H,VICEB0+008H 
         BYTE     01100000B+004H,077H,VMARU3+000H 
;;K;;         BYTE     00000000B+002H,07BH,VIKUMO+002H 
         BYTE     00100000B+010H,07CH,VBLDK0+00AH 
         BYTE     00100000B+009H,07CH,VBLDK0+008H 
         BYTE     01100000B+000H,07EH,VICEB0+001H 
         BYTE     01100000B+001H,07EH,VICEB0+001H 
         BYTE     01100000B+002H,07EH,VICEB0+001H 
         BYTE     01100000B+003H,07EH,VICEB0+001H 
         BYTE     01100000B+004H,07EH,VICEB0+001H 
         BYTE     01100000B+005H,07EH,VICEB0+001H 
         BYTE     01100000B+006H,07EH,VICEB0+001H 
         BYTE     01100000B+007H,07EH,VICEB0+001H 
         BYTE     01100000B+008H,07EH,VICEB0+001H 
         BYTE     01100000B+009H,07EH,VICEB0+001H 
         BYTE     01100000B+00AH,07EH,VICEB0+001H 
         BYTE     01100000B+00BH,07EH,VICEB0+001H 
         BYTE     01100000B+00CH,07EH,VICEB0+001H 
         BYTE     01100000B+00DH,07EH,VICEB0+001H 
         BYTE     01100000B+00EH,07EH,VICEB0+001H 
         BYTE     01100000B+00FH,07EH,VICEB0+001H 
         BYTE     01100000B+010H,07EH,VICEB0+001H 
         BYTE     01100000B+011H,07EH,VICEB0+001H 
         BYTE     01100000B+012H,07EH,VICEB0+001H 
         BYTE     01100000B+013H,07EH,VICEB0+001H 
         BYTE     01100000B+014H,07EH,VICEB0+001H 
         BYTE     01100000B+015H,07EH,VICEB0+001H 
         BYTE     01100000B+016H,07EH,VICEB0+001H 
         BYTE     01100000B+017H,07EH,VICEB0+001H 
         BYTE     01100000B+018H,07EH,VICEB0+001H 
         BYTE     01100000B+019H,07EH,VICEB0+001H 
         BYTE     01100000B+01AH,07EH,VICEB0+001H 
         BYTE     00100000B+00BH,07AH,VHZJP1+001H 
         BYTE     01100000B+007H,070H,VMARU3+000H 
; 
         BYTE     11100000B+007H,00010010B,080H 
; 
         BYTE     0FFH
; 
;=====================================================================
B319     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00000010B,10010000B,00100000B,00001100B,00001000B,00100010B
	 BYTE	  008H
; 
         BYTE     01100000B+014H,003H,VIBKCN+006H 
         BYTE     01100000B+015H,003H,VIBKCN+006H 
         BYTE     01100000B+016H,003H,VIBKCN+001H 
         BYTE     01100000B+017H,003H,VIBKCN+001H 
         BYTE     01100000B+018H,003H,VIBKCN+001H 
         BYTE     01100000B+019H,003H,VIBKCN+006H 
         BYTE     01100000B+016H,008H,VIBKCN+001H 
         BYTE     01100000B+017H,008H,VIBKCN+001H 
         BYTE     01100000B+018H,008H,VIBKCN+001H 
         BYTE     00000000B+01AH,000H,VMARU0+000H,030H
;;K;;         BYTE     00000000B+009H,003H,VIKUMO+002H 
         BYTE     00100000B+000H,008H,VBLDK4+005H 
;;K;;         BYTE     00000000B+00DH,00BH,VIKUMO+002H 
         BYTE     00000000B+015H,00CH,VHILL1+003H 
         BYTE     00000000B+018H,00BH,VHILL1+002H 
         BYTE     00100000B+016H,002H,FCNTOM
         BYTE     01000000B+000H,018H,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
;;;;;;;;; 7/28
B31A     EQU      $ 
; 
         LWORD     B207        ; BG dtaa address 
         LWORD     E207        ; Enmy data address 
; 
         BYTE     11100101B,00010001B,10001110B,00001100B,00000000B,00100010B
	 BYTE	  008H
;
;0
         BYTE     00000000B+01AH,000H,VMARU0+000H,05FH
         BYTE     01100000B+014H,00CH,VICEB1+000H 
         BYTE     01100000B+016H,00AH,VICEB1+003H 
         BYTE     01100000B+018H,008H,VICEB1+005H 
         BYTE     00100000B+016H,00EH,VBLDK0+004H 
         BYTE     11100000B+000H,002H,040H
;1
         BYTE     01100000B+00EH,018H,VICEB1+00CH 
         BYTE     01100000B+010H,018H,VICEB1+00CH 
         BYTE     01100000B+012H,018H,VICEB1+00CH 
         BYTE     01100000B+014H,018H,VICEB1+00CH 
         BYTE     01100000B+016H,018H,VICEB1+00CH 
         BYTE     01100000B+018H,018H,VICEB1+00FH 
;2
         BYTE     00100000B+00BH,025H,FUPBLK
         BYTE     01000000B+00DH,023H,VKORA0+000H 
         BYTE     01000000B+00DH,027H,VKORA0+000H 
;3
         BYTE     01100000B+018H,03EH,VICEB1+000H 
         BYTE     00100000B+017H,034H,VBLDK3+003H 
;4
         BYTE     01000000B+000H,048H,FBLBET
; 
         BYTE     0FFH
; 
;=====================================================================
B31B     EQU      $ 
; 
         LWORD     B108        ; BG dtaa address 
         LWORD     E108        ; Enmy data address 
; 
         BYTE     00001011B,00000100B,11000001B,00000100B,00001000B,00000000B
	 BYTE	  005H
;0
         BYTE     01000000B+000H,000H,VCKREN+000H,0BFH
;;K;;         BYTE     00000000B+00FH,002H,FASKM0
;;K;;         BYTE     00000000B+011H,005H,FASKM1
;;K;;         BYTE     00000000B+00EH,00CH,FASKM1
;;K;;         BYTE     00000000B+011H,00EH,FASKM0
         BYTE     00000000B+019H,006H,VAIWA0+000H 
         BYTE     00000000B+019H,008H,VAIWA0+001H 
         BYTE     00000000B+019H,00DH,VAIWA0+002H 
         BYTE     00000000B+01AH,000H,VMARU0+000H,0BFH
         BYTE     01000000B+018H,000H,VDOKY3+002H 
         BYTE     00100000B+016H,00AH,VBLDK3+003H 
;1
;;K;;         BYTE     00000000B+00FH,012H,FASKM0
;;K;;         BYTE     00000000B+011H,015H,FASKM1
;;K;;         BYTE     00000000B+00EH,01CH,FASKM1
;;K;;         BYTE     00000000B+011H,01EH,FASKM0
         BYTE     00100000B+017H,012H,VBLDK3+002H 
         BYTE     00100000B+018H,01EH,VBLDK3+001H 
         BYTE     00100000B+016H,018H,FHSQST
         BYTE     01100000B+017H,01FH,VPACKN+000H,09AH
         BYTE     00000000B+019H,01AH,VAIWA0+000H 
         BYTE     00000000B+019H,01CH,VAIWA0+000H 
;2
;;K;;         BYTE     00000000B+00FH,022H,FASKM0
;;K;;         BYTE     00000000B+011H,025H,FASKM1
;;K;;         BYTE     00000000B+00EH,02CH,FASKM1
;;K;;         BYTE     00000000B+011H,02EH,FASKM0
         BYTE     00100000B+018H,020H,VBLDK3+001H 
         BYTE     00100000B+018H,022H,VBLDK3+001H 
         BYTE     00100000B+018H,024H,VBLDK3+001H 
         BYTE     00100000B+018H,026H,VBLDK3+001H 
         BYTE     00100000B+018H,028H,VBLDK3+001H 
         BYTE     00100000B+018H,02AH,VBLDK3+001H 
         BYTE     00100000B+018H,02CH,VBLDK3+001H 
         BYTE     00100000B+018H,02EH,VBLDK3+001H 
         BYTE     00100000B+015H,02AH,FHSQST
;3
;;K;;         BYTE     00000000B+00FH,032H,FASKM0
;;K;;         BYTE     00000000B+011H,035H,FASKM1
;;K;;         BYTE     00000000B+00EH,03CH,FASKM1
;;K;;         BYTE     00000000B+011H,03EH,FASKM0
         BYTE     00100000B+018H,030H,VBLDK3+001H 
         BYTE     00100000B+018H,032H,VBLDK3+001H 
         BYTE     00100000B+018H,034H,VBLDK3+001H 
         BYTE     00100000B+018H,036H,VBLDK3+001H 
         BYTE     00100000B+018H,038H,VBLDK3+001H 
         BYTE     00100000B+018H,03AH,VBLDK3+001H 
         BYTE     00100000B+018H,03CH,VBLDK3+001H 
         BYTE     00100000B+018H,03EH,VBLDK3+001H 
;4
;;K;;         BYTE     00000000B+00FH,042H,FASKM0
;;K;;         BYTE     00000000B+011H,045H,FASKM1
;;K;;         BYTE     00000000B+00EH,04CH,FASKM1
;;K;;         BYTE     00000000B+011H,04EH,FASKM0
         BYTE     00100000B+018H,040H,VBLDK3+001H 
         BYTE     00100000B+018H,042H,VBLDK3+001H 
         BYTE     00100000B+018H,044H,VBLDK3+001H 
         BYTE     00100000B+018H,046H,VBLDK3+001H 
         BYTE     00100000B+018H,048H,VBLDK3+001H 
         BYTE     00100000B+018H,04AH,VBLDK3+001H 
         BYTE     00100000B+018H,04CH,VBLDK3+001H 
         BYTE     00100000B+018H,04EH,VBLDK3+001H 
;5
;;K;;         BYTE     00000000B+00FH,052H,FASKM0
;;K;;         BYTE     00000000B+011H,055H,FASKM1
;;K;;         BYTE     00000000B+00EH,05CH,FASKM1
;;K;;         BYTE     00000000B+011H,05EH,FASKM0
         BYTE     00100000B+018H,050H,VBLDK3+001H 
         BYTE     00100000B+018H,052H,VBLDK3+001H 
         BYTE     00100000B+018H,054H,VBLDK3+001H 
         BYTE     00100000B+018H,056H,VBLDK3+001H 
         BYTE     00100000B+018H,058H,VBLDK3+001H 
         BYTE     00100000B+018H,05AH,VBLDK3+001H 
         BYTE     00100000B+018H,05CH,VBLDK3+001H 
         BYTE     00100000B+018H,05EH,VBLDK3+001H 
         BYTE     00100000B+014H,056H,FHSQST
;6
;;K;;         BYTE     00000000B+00FH,062H,FASKM0
;;K;;         BYTE     00000000B+011H,065H,FASKM1
;;K;;         BYTE     00000000B+00EH,06CH,FASKM1
;;K;;         BYTE     00000000B+011H,06EH,FASKM0
         BYTE     00100000B+018H,060H,VBLDK3+001H 
         BYTE     00100000B+018H,062H,VBLDK3+001H 
         BYTE     00100000B+018H,064H,VBLDK3+001H 
         BYTE     00100000B+018H,066H,VBLDK3+001H 
         BYTE     00100000B+018H,068H,VBLDK3+001H 
         BYTE     00100000B+018H,06CH,VBLDK3+001H 
         BYTE     00100000B+018H,06EH,VBLDK3+001H 
         BYTE     00100000B+00CH,06AH,VBLDK4+004H 
         BYTE     00100000B+014H,06AH,VBLDK3+005H 
;7
;;K;;         BYTE     00000000B+00FH,072H,FASKM0
;;K;;         BYTE     00000000B+011H,075H,FASKM1
;;K;;         BYTE     00000000B+00EH,07CH,FASKM1
;;K;;         BYTE     00000000B+011H,07EH,FASKM0
         BYTE     00100000B+018H,070H,VBLDK3+001H 
         BYTE     00100000B+018H,074H,VBLDK3+001H 
         BYTE     00100000B+018H,076H,VBLDK3+001H 
         BYTE     00100000B+018H,078H,VBLDK3+001H 
         BYTE     00100000B+018H,07AH,VBLDK3+001H 
         BYTE     00100000B+018H,07CH,VBLDK3+001H 
         BYTE     00100000B+018H,07EH,VBLDK3+001H 
         BYTE     00100000B+016H,072H,VBLDK3+003H 
         BYTE     00100000B+00CH,072H,VBLDK4+006H 
;8
;;K;;         BYTE     00000000B+00FH,082H,FASKM0
;;K;;         BYTE     00000000B+011H,085H,FASKM1
;;K;;         BYTE     00000000B+00EH,08CH,FASKM1
;;K;;         BYTE     00000000B+011H,08EH,FASKM0
         BYTE     00100000B+018H,080H,VBLDK3+001H 
         BYTE     00100000B+018H,082H,VBLDK3+001H 
         BYTE     00100000B+018H,086H,VBLDK3+001H 
         BYTE     00100000B+018H,088H,VBLDK3+001H 
         BYTE     00100000B+018H,08AH,VBLDK3+001H 
         BYTE     00100000B+018H,08CH,VBLDK3+001H 
         BYTE     00100000B+018H,08EH,VBLDK3+001H 
         BYTE     00100000B+014H,084H,VBLDK3+005H 
         BYTE     00100000B+00CH,084H,VBLDK4+004H 
         BYTE     00100000B+014H,08CH,VBBLK1+000H 
         BYTE     00100000B+015H,08CH,VBBLK1+000H 
         BYTE     00100000B+016H,08CH,VBBLK1+000H 
         BYTE     00100000B+014H,08DH,FHSQST
;9
;;K;;         BYTE     00000000B+00FH,092H,FASKM0
;;K;;         BYTE     00000000B+011H,095H,FASKM1
;;K;;         BYTE     00000000B+00EH,09CH,FASKM1
;;K;;         BYTE     00000000B+011H,09EH,FASKM0
         BYTE     00100000B+018H,090H,VBLDK3+001H 
         BYTE     00100000B+018H,092H,VBLDK3+001H 
         BYTE     00100000B+018H,094H,VBLDK3+001H 
         BYTE     00100000B+018H,096H,VBLDK3+001H 
         BYTE     00100000B+018H,098H,VBLDK3+001H 
         BYTE     00100000B+018H,09AH,VBLDK3+001H 
         BYTE     00100000B+018H,09CH,VBLDK3+001H 
         BYTE     00100000B+018H,09EH,VBLDK3+001H 
;A
;;K;;         BYTE     00000000B+00FH,0A2H,FASKM0
;;K;;         BYTE     00000000B+011H,0A5H,FASKM1
;;K;;         BYTE     00000000B+00EH,0ACH,FASKM1
;;K;;         BYTE     00000000B+011H,0AEH,FASKM0
         BYTE     00100000B+018H,0A0H,VBLDK3+001H 
         BYTE     00100000B+018H,0A2H,VBLDK3+001H 
         BYTE     00100000B+018H,0A4H,VBLDK3+001H 
         BYTE     00100000B+018H,0A6H,VBLDK3+001H 
         BYTE     00100000B+018H,0A8H,VBLDK3+001H 
         BYTE     00100000B+018H,0AAH,VBLDK3+001H 
         BYTE     00100000B+018H,0ACH,VBLDK3+001H 
         BYTE     00100000B+018H,0AEH,VBLDK3+001H 
         BYTE     00100000B+000H,0A3H,VBLDK3+00FH 
         BYTE     00100000B+00CH,0A3H,VBLDK4+009H 
;B
;;K;;         BYTE     00000000B+00FH,0B2H,FASKM0
;;K;;         BYTE     00000000B+011H,0B5H,FASKM1
;;K;;         BYTE     00000000B+00EH,0BCH,FASKM1
;;K;;         BYTE     00000000B+011H,0BEH,FASKM0
         BYTE     00100000B+018H,0B0H,VBLDK3+001H 
         BYTE     00100000B+018H,0B2H,VBLDK3+001H 
         BYTE     00100000B+018H,0B6H,VBLDK3+001H 
         BYTE     00100000B+018H,0B8H,VBLDK3+001H 
         BYTE     00100000B+018H,0BAH,VBLDK3+001H 
         BYTE     00100000B+018H,0BCH,VBLDK3+001H 
         BYTE     00100000B+018H,0BEH,VBLDK3+001H 
         BYTE     00100000B+014H,0B4H,VBLDK3+005H 
         BYTE     00100000B+000H,0B4H,VBLDK4+004H 
         BYTE     00100000B+015H,0BDH,VDOKY0+002H 
         BYTE     00100000B+017H,0BAH,VBBLK1+005H 
; 
         BYTE     11100000B+00BH,073H,081H
; 
         BYTE     0FFH
; 
;=====================================================================
;;;;;;;  8/4
B31C     EQU      $ 
;
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     11100000B,00010000B,01000000B,00001100B,10000110B,00000000B
	 BYTE	  008H
; 
;;K;;         BYTE     00000000B+011H,003H,VIKUMO+002H 
         BYTE     00100000B+012H,007H,VBBLK0+006H 
;;K;;         BYTE     00000000B+014H,001H,VIKUMO+002H 
         BYTE     00100000B+016H,007H,VBBLK0+006H 
         BYTE     01100000B+01AH,000H,VICEB0+00FH 
; 
         BYTE     0FFH
; 
;=====================================================================
B31D     EQU      $ 
; 
         LWORD     B30E        ; BG dtaa address 
         LWORD     E30E        ; Enmy data address 
; 
         BYTE     00000001B,10010000B,11001100B,00001100B,00000001B,00000000B
	 BYTE	  013H
; 
         BYTE     01100000B+00FH,000H,VICEB1+00FH 
         BYTE     01100000B+011H,000H,VICEB1+000H 
         BYTE     01100000B+013H,000H,VICEB1+000H 
         BYTE     01100000B+015H,000H,VICEB1+000H 
         BYTE     01100000B+017H,000H,VICEB1+000H 
         BYTE     01100000B+019H,000H,VICEB1+00FH 
         BYTE     01100000B+017H,004H,VICEB1+000H 
         BYTE     01100000B+011H,00CH,VICEB1+000H 
         BYTE     01100000B+014H,006H,VICEB0+00FH 
         BYTE     00100000B+015H,009H,VBBLK0+00AH 
         BYTE     00100000B+016H,009H,VBBLK0+00AH 
         BYTE     00100000B+017H,009H,VBBLK0+00AH 
         BYTE     00100000B+018H,009H,VBBLK0+00AH 
; 
         BYTE     01100000B+011H,010H,VICEB1+000H 
         BYTE     01100000B+011H,018H,VICEB1+000H 
         BYTE     01100000B+014H,016H,VICEB0+007H 
         BYTE     01100000B+017H,016H,VICEB1+000H 
         BYTE     01100000B+017H,01AH,VICEB1+001H 
         BYTE     01100000B+011H,01EH,VICEB1+000H 
         BYTE     01100000B+013H,01EH,VICEB1+000H 
         BYTE     01100000B+015H,01EH,VICEB1+000H 
         BYTE     01100000B+017H,01EH,VICEB1+000H 
         BYTE     01000000B+013H,01CH,FBOTAN
         BYTE     00000000B+017H,019H,FADOR0
         BYTE     11100000B+001H,018H,0C3H
; 
; 
         BYTE     0FFH
; 
;=====================================================================
; 
B31E     EQU      $ 
;
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     11100000B,00010000B,01000000B,00001100B,10000110B,00000000B
	 BYTE	  008H
; 
;;K;;         BYTE     00000000B+011H,003H,VIKUMO+002H 
         BYTE     00100000B+012H,007H,VBBLK0+006H 
;;K;;         BYTE     00000000B+014H,001H,VIKUMO+002H 
         BYTE     00100000B+016H,007H,VBBLK0+005H 
         BYTE     00100000B+016H,00DH,FHNBLK
         BYTE     01100000B+01AH,000H,VICEB0+00FH 
; 
         BYTE     0FFH
; 
; 
;=====================================================================
B31F     EQU      $ 
B320     EQU      $ 
; 
         LWORD     0000        ; BG dtaa address 
         LWORD     0000        ; Enmy data address 
; 
         BYTE     00000000B,00000000B,00000000B,00000000B,00000000B,00000000B
	 BYTE	  000H
; 
; 
         BYTE     0FFH
; 
;=====================================================================
B321     EQU      $ 
; 
; 
;=====================================================================
B322     EQU      $ 
; 
; 
;=====================================================================
B323     EQU      $ 
; 
; 
;=====================================================================
B324     EQU      $ 
; 
; 
;=====================================================================
B325     EQU      $ 
; 
; 
;=====================================================================
B326     EQU      $ 
; 
; 
;=====================================================================
B327     EQU      $ 
; 
; 
;=====================================================================
B328     EQU      $ 
; 
; 
;=====================================================================
B329     EQU      $ 
; 
; 
;=====================================================================
B32A     EQU      $ 
; 
; 
;=====================================================================
B32B     EQU      $ 
; 
; 
;=====================================================================
B32C     EQU      $ 
; 
; 
;=====================================================================
B32D     EQU      $ 
; 
; 
;=====================================================================
B32E     EQU      $ 
; 
; 
;=====================================================================
B32F     EQU      $ 
; 
; 
;=====================================================================
B330     EQU      $ 
; 
; 
;=====================================================================
B331     EQU      $ 
; 
; 
;=====================================================================
B332     EQU      $ 
; 
; 
;=====================================================================
B333     EQU      $ 
; 
; 
;=====================================================================
B334     EQU      $ 
; 
; 
;=====================================================================
B335     EQU      $ 
; 
; 
;=====================================================================
B336     EQU      $ 
; 
; 
;=====================================================================
B337     EQU      $ 
; 
; 
;=====================================================================
B338     EQU      $ 
; 
; 
;=====================================================================
B339     EQU      $ 
; 
; 
;=====================================================================
B33A     EQU      $ 
; 
; 
;=====================================================================
B33B     EQU      $ 
; 
; 
;=====================================================================
B33C     EQU      $ 
; 
; 
;=====================================================================
B33D     EQU      $ 
; 
; 
;=====================================================================
B33E     EQU      $ 
; 
; 
;=====================================================================
B33F     EQU      $ 
; 
; 
		END
